# HIDE REVISION FIELD DEVELOPMENT/CONTRIBUTING
* All bug or feature requests are welcome.

* Most bugs & features **should** have automatic tests. The test suite only
  runs on Drupal 8.6+. If you have a patch, but don't have tests, don't let that
  hold you back from opening an issue. I'm happy to help folks learn testing or
  writing tests myself. I'll still be grateful for the issue/patch, just will
  likely take a bit longer to get to than a review only issue.

* All code **must** conform to Drupal standards. To ease this, run `composer
  install` in your development copy. This will install some composer commands
  that will help ensure patches match standards such as `composer phpcs` - see
  [Drupal Standards Composer
  Commands](https://github.com/NickWilde1990/drupal-standards-composer-commands)
  as well as a git pre-commit hook - see [PHP Composter PHPCS
  Drupal](https://github.com/NickWilde1990/php-composter-phpcs-drupal).

* All questions & contributions should be done through the module [issue
  queue](https://www.drupal.org/project/issues/hide_revision_field).
  Alternatively, feel free to directly contact the maintainer ([Nick
  Wilde](https://www.drupal.org/u/nickwilde)). For security issues see the
  [Security Team](https://www.drupal.org/node/101494).

* All issue queue interactions and contributions must conform to the [Drupal
  Code of Conduct](https://www.drupal.org/dcoc). If they do not, please report
  it to the the [Drupal Community Working
  Group](https://www.drupal.org/governance/community-working-group).
