%% OPF Using Chu-Beasley's Algorithm
% MATLAB Version: R2013a

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% UNESP - Ilha Solteira - SP - Brazil Team
% Marcos J. Rider
% Rubn Romero
% John F. Franco
% Leonardo H. Macedo
% Edgard Carreo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function cbga(fhd,ii,jj,kk,args)
    %% Inicial Settings
    
	global proc
    global ps
    % Reinitialization of local
    % function evaluation counter.
    proc.i_eval = 0;
    % Function evaluation at which
    % the last update of the global
    % best solution occurred.
    % Refers to the internal evaluation
    % using static penalty constraint 
    % handling method.
	proc.last_improvement = 1;
    % Signalizing your 
    % to stop running.
    proc.finish = 0;   
    % Size of the population.
    n_pop = proc.pop_size;
    % For dynamic weight adaption.
    me = proc.n_eval;
    % Dimensionality of test case.
    D = ps.D;
    % Individuals' lower bounds.
    VRmin = ps.x_min;
    % Individuals' upper bounds.
    VRmax = ps.x_max;
    % Individuals' type.
    VRtype = ps.x_type;
    
    %% Genereting Initial Population
    
    Vmin = VRmin;
    Vmax = VRmax;
    
    if length(VRmin) == 1
        VRmin = repmat(VRmin,1,D);
        VRmax = repmat(VRmax,1,D);
    end

    VRmin = repmat(VRmin,n_pop,1);
    VRmax = repmat(VRmax,n_pop,1);
   
    % random initial population
    
    pop = zeros(n_pop,D);
    
    for k = 1:D
        % continuous variables
        if VRtype(k) == 0
            pop(:,k) = VRmin(:,k) + rand(n_pop,1).*(VRmax(:,k) - VRmin(:,k));
        end
        % integer variables
        if VRtype(k) == 1
            pop(:,k) = VRmin(:,k) + round(rand(n_pop,1).*(VRmax(:,k) - VRmin(:,k)));
        end
        % binary variables
        if VRtype(k) == 2
            pop(:,k) = round(rand(n_pop,1));
        end
    end
   
    %% compute initial population

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	[fit,obj,g_sum,pop,fit_best] = feval(fhd,ii,jj,kk,args,pop);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
% fprintf('\n=================== INITIAL POPULATION =====================\n')    
% fprintf('\n')
% 
% fprintf(' ind     objective                    infact                   fitness\n')
% for k = 1:n_pop
%     fprintf('%4d %13.7f %25.7f %25.7f \n',k,obj(k),g_sum(k),fit(k))
% end
%     
% fprintf('\n============================================================\n')
     %% Local search (10% of total number of trials)
%     
% fprintf('\n============ LOCAL SEARCH ON INITIAL POPULATION ============\n')
% fprintf('\n')
    
    % sensibility 
    sensi = zeros(n_pop,D);
    
	alpha = ones(1,n_pop);
    
    for iterp = 1:me/(10*n_pop)  
        % store 'pop' and 'fit'
        popant = pop;
        fitant = fit;
        
        objant = obj;
        g_sumant = g_sum;
        
        % choose randomly the control that will be changed
        kn = randi(D,n_pop,1);

        for n = 1:n_pop
            
            % update alpha 
            if fitant(n) < 1.5*objant(n)
                alpha(n) = 0.10/0.15;
            end          
            
            k = kn(n);
            % change on choosen control
            if VRtype(k) == 0
                if pop(n,k) == VRmax(n,k)
                    pop(n,k) = pop(n,k) - alpha(n)*randi(150)*(VRmax(n,k) - VRmin(n,k))/1000;
                    sensi(n,k) = -1;
                elseif pop(n,k) == VRmin(n,k)
                    pop(n,k) = pop(n,k) + alpha(n)*randi(150)*(VRmax(n,k) - VRmin(n,k))/1000;
                    sensi(n,k) = 1;
                elseif sensi(n,k) == 0
					pop(n,k) = pop(n,k) + alpha(n)*randi(150)*(VRmax(n,k) - pop(n,k))/1000;
					sensi(n,k) = 1;
                elseif sensi(n,k) == 1
					pop(n,k) = pop(n,k) + alpha(n)*randi(150)*(VRmax(n,k) - pop(n,k))/1000;
                elseif sensi(n,k) == -1
					pop(n,k) = pop(n,k) - alpha(n)*randi(150)*(pop(n,k) - VRmin(n,k))/1000;
                end
            end
            if VRtype(k) == 1
                if pop(n,k) == VRmax(n,k)
                    pop(n,k) = pop(n,k) - 1;
                    sensi(n,k) = -1;
                elseif pop(n,k) == VRmin(n,k)
                    pop(n,k) = pop(n,k) + 1;
                    sensi(n,k) = 1;
                elseif sensi(n,k) == 0
					pop(n,k) = pop(n,k) + 1;
                    sensi(n,k) = 1;
                elseif sensi(n,k) == 1
                    pop(n,k) = pop(n,k) + 1;
                elseif sensi(n,k) == -1
                    pop(n,k) = pop(n,k) - 1;
                end
            end
            if VRtype(k) == 2
                if pop(n,k) == VRmax(n,k)
                    pop(n,k) = 0;
                    sensi(n,k) = -1;
                elseif pop(n,k) == VRmin(n,k)
                    pop(n,k) = 1;
                    sensi(n,k) = 1;
                elseif sensi(n,k) == 0
                    pop(n,k) = 1;
                    sensi(n,k) = 1;
                elseif sensi(n,k) == 1
                    pop(n,k) = 1;
                elseif sensi(n,k) == -1
                    pop(n,k) = 0;
                end
            end
        end
        
        % compute new population
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        [fit,obj,g_sum,pop,fit_best] = feval(fhd,ii,jj,kk,args,pop);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        % updates sensitivity vector
        for n = 1:n_pop
            k =kn(n);
            if fit(n) > fitant(n)
                pop(n,:) = popant(n,:);
                fit(n) = fitant(n);                
                g_sum(n) = g_sumant(n);                
                obj(n) = objant(n);
                if sensi(n,k) == 1
                    sensi(n,k) = -1;
                elseif sensi(n,k) == -1
                    sensi(n,k) = 1;
                end
            end
        end
        if proc.finish
            return;
        end
    end
    
% fprintf('\n============================================================\n')    
% fprintf('\n=================== IMPROVED POPULATION ====================\n')    
% fprintf('\n')
% 
% fprintf(' ind     objective                    infact                   fitness\n')
% for k = 1:n_pop
%     fprintf('%4d %13.7f %25.7f %25.7f \n',k,obj(k),g_sum(k),fit(k))
% end
%     
% fprintf('\n============================================================\n')    

    fitness = obj;
    unfitness = g_sum;
    fittot = fit;

    %% Iterative process
    gen = 1;
    while 1
        %% Tournament Selection
        
        ntorn = 2;

        rflag = zeros(1,n_pop);
        
        kpop1 = zeros(1,ntorn);
        aux1 = randperm(n_pop);        
        for jk = 1:ntorn
            kpop1(jk) = aux1(jk);    
        end
        
        minfk1 = fitness(kpop1(1));
        mink1 = kpop1(1);
        for i = 2:ntorn
            if fitness(kpop1(i)) < minfk1
                minfk1 = fitness(kpop1(i));
                mink1 = kpop1(i);                
            end           
        end

        rflag(mink1) = 1;

        kpop2 = zeros(1,ntorn);
        for i = 1:ntorn
            kpop2(i) = randi(n_pop);
            if rflag(kpop2(i)) == 0
                rflag(kpop2(i)) = 1;
            else        
                while rflag(kpop2(i)) == 1
                    kpop2(i) = randi(n_pop);                
                end
                rflag(kpop2(i)) = 1;        
            end
        end

        minfk2 = fitness(kpop2(1));
        mink2 = kpop2(1);        
        for i = 2:ntorn
            if fitness(kpop2(i)) < minfk2
                minfk2 = fitness(kpop2(i));
                mink2 = kpop2(i);                
            end           
        end

        %% Crossover
        
        npcrs = ceil(D/5);

        kpcrs = zeros(1,npcrs);
        aux2 = randperm(D-1);        
        for jk = 1:npcrs
            kpcrs(jk) = aux2(jk);    
        end
        
        kpcrs = sort(kpcrs);

        kpcrs = [0, kpcrs, D];

        des1 = zeros(1,D);
        des2 = zeros(1,D);

 
        flag = 0;
        for i = 1:npcrs+1
            if flag == 0
                for j = kpcrs(i)+1:kpcrs(i+1)
                    des1(j) = pop(mink1,j);
                    des2(j) = pop(mink2,j);
                end
                    flag = 1;        
            else
                for j = kpcrs(i)+1:kpcrs(i+1)
                    des1(j) = pop(mink2,j);
                    des2(j) = pop(mink1,j);
                end
                    flag = 0;
            end       
        end
        %% Choose best descendant
        
        desc = [des1; des2];
        
        args{3} = 2;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        [fitdesc,objdesc,g_sumdesc,desc,fit_best] = feval(fhd,ii,jj,kk,args,desc);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        
% fprintf('\n======================= DESCENDANTS ========================\n')    
% 
% fprintf('\nSelected: %4d and %4d\n',mink1,mink2)
% 
% fprintf(' ind     objective                    infact                   fitness\n')
% for k = 1:2
%     fprintf('%4d %13.7f %25.7f %25.7f \n',k,objdesc(k),g_sumdesc(k),fitdesc(k))
% end
%     
% fprintf('\n============================================================\n')

        [descobj, kdesc] = min(objdesc);
        
        desm = desc(kdesc,:);
        
        fitdesm = fitdesc(kdesc);
        objdesm = objdesc(kdesc);
        g_sumdesm = g_sumdesc(kdesc);

% fprintf('\n============= LOCAL SEARCH ON BEST DESCENDANT ==============\n')    
% fprintf('\n')
        %% Local Improvement

        % sensibility 
        sens = zeros(1,D);

        cont = 0;
        lmax = 1;
        while(cont < 3*D)
            
            % store current values of fitness and individual       
            desmant = desm;
            ifitant = fitdesm;
            objant = objdesm;
            g_sumant = g_sumdesm;
            
            % choose randomly the controls that will be changed
            ki = zeros(1,lmax);            
            aux3 = randperm(D);        
            for jk = 1:lmax
                ki(jk) = aux3(jk);    
            end

            delta = 1;            
            if g_sumant < 0.1
                delta = 0.5;
            end
            
            for l = 1:lmax                
                % change on choosen controls
                if VRtype(ki(l)) == 0
                    if desm(ki(l)) == Vmax(ki(l))
                        desm(ki(l)) = desm(ki(l)) - delta*randi(200)*(Vmax(ki(l)) - Vmin(ki(l)))/1000;
                        sens(ki(l)) = -1;
                    elseif desm(ki(l)) == Vmin(ki(l))
                        desm(ki(l)) = desm(ki(l)) + delta*randi(200)*(Vmax(ki(l)) - Vmin(ki(l)))/1000;
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 0
                        desm(ki(l)) = desm(ki(l)) + delta*randi(200)*(Vmax(ki(l)) - desm(ki(l)))/1000;
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 1
                        desm(ki(l)) = desm(ki(l)) + delta*randi(200)*(desm(ki(l)) - Vmin(ki(l)))/1000;
                    elseif sens(ki(l)) == -1
                        desm(ki(l)) = desm(ki(l)) - delta*randi(200)*(desm(ki(l)) - Vmin(ki(l)))/1000;
                    end
                end
                if VRtype(ki(l)) == 1
                    if desm(ki(l)) == Vmax(ki(l))
                        desm(ki(l)) = desm(ki(l)) - randi(2);
                        sens(ki(l)) = -1;
                    elseif desm(ki(l)) == Vmin(ki(l))
                        desm(ki(l)) = desm(ki(l)) + randi(2);
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 0
                        desm(ki(l)) = desm(ki(l)) + randi(2);
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 1
                        desm(ki(l)) = desm(ki(l)) + randi(2);
                    elseif sens(ki(l)) == -1
                        desm(ki(l)) = desm(ki(l)) - randi(2);
                    end
                end
                if VRtype(ki(l)) == 2
                    if desm(ki(l)) == Vmax(ki(l))
                        desm(ki(l)) = 0;
                        sens(ki(l)) = -1;
                    elseif desm(ki(l)) == Vmin(ki(l))
                        desm(ki(l)) = 1;
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 0
                        desm(ki(l)) = 1;
                        sens(ki(l)) = 1;
                    elseif sens(ki(l)) == 1
                        desm(ki(l)) = 1;
                    elseif sens(ki(l)) == -1
                        desm(ki(l)) = 0;
                    end               
                end
            end
            
            args{3} = 1;
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            [fitdesm,objdesm,g_sumdesm,desm,fit_best] = feval(fhd,ii,jj,kk,args,desm);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            lfit = fitdesm;
            
            if fitdesm <= ifitant - 0.1
                cont = 0;
            end            
            if (fitdesm <= ifitant - 0.1) && (g_sumdesm < 100)                
                    cont = -3*D; 
            end            
            if (fitdesm <= ifitant - 0.01) && (g_sumdesm < 1e-1)               
                    cont = -7*D;
            end
            
            % update sensibility vector
            if fitdesm > ifitant
                cont = cont + 1;
                desm = desmant;
                fitdesm = ifitant;
                objdesm = objant;
                g_sumdesm = g_sumant;
                for l = 1:lmax
                    if sens(ki(l)) == 1
                        sens(ki(l)) = -1;
                    elseif sens(ki(l)) == -1
                        sens(ki(l)) = 1;
                    end
                end
            end            
            
            if lfit < ifitant
                lmax = 1;
            else
                lmax = lmax + 1;
                if lmax > 4
                    lmax = 1; 
                end
            end
            
            if proc.finish
                return;
            end            
        end
% fprintf('\n============================================================\n')        
% fprintf('\n================== LOCAL SEARCH SOLUTION ===================\n')    
% fprintf('\n')
% 
% fprintf('    objective                    infact                   fitness\n')
% fprintf('%13.7f %25.7f %25.7f \n',objdesm,g_sumdesm,fitdesm)
% 
% fprintf('\n============================================================\n')
       
        %% Update Population
        
        gen = gen + 1;
        
        [winf, kw] = max(unfitness);
        [wof, kof] = max(fitness);
        [wfit,kwfit] = max(fittot);
        
        if fitdesm < wfit
            pop(kwfit,:) = desm;
            unfitness(kwfit) = g_sumdesm;
            fitness(kwfit) = objdesm;
            fittot(kwfit) = fitdesm;
        end

% fprintf('\n====================== NEW POPULATION ======================\n')
% 
% 
% fprintf('\nGeneration number     : %4d',gen)
% fprintf('\nWorst infactibility (previous population) on: %4d',kw)
% fprintf('\nWorst objective (previous population) on    : %4d',kof)
% 
% fprintf('\n')
% fprintf(' ind     objective                    infact                   fitness\n')
% for k = 1:n_pop
%     fprintf('%4d %13.7f %25.7f %25.7f \n',k,fitness(k),unfitness(k),fittot(k))
% end
% 
% fprintf('\n============================================================\n')
        
        %% End of Process
        if proc.finish
            return;
        end
    end
end