clear all
close all
clc

algorithm_name='cbga';

systems=[57 118 300 41];

fid=fopen([algorithm_name '.txt'],'w');
for i_system=1:numel(systems)
    system=systems(i_system);
    system_name=['system_' num2str(system)];
    
    fprintf(fid,'-----------------------------------------------------------\n');
    fprintf(fid,['System ' num2str(system) '\n']);
    
    if system~=41
        n_test_cases=2;
        n_scenarios=1;
    else
        n_test_cases=1;
        n_scenarios=96;
    end
   
    fitness.(system_name)=cell(1,n_test_cases);
    objective.(system_name)=cell(1,n_test_cases);
    constraint_violations.(system_name)=cell(1,n_test_cases);
    variables.(system_name)=cell(1,n_test_cases);
    best_variables.(system_name)=cell(1,n_test_cases);
    
    fitness_mean.(system_name)=cell(1,n_test_cases);
    fitness_best.(system_name)=cell(1,n_test_cases);
    fitness_worst.(system_name)=cell(1,n_test_cases);
    objective_best.(system_name)=cell(1,n_test_cases);
    constraint_violations_sum.(system_name)=cell(1,n_test_cases);
    
    fitness_final.(system_name)=cell(1,n_test_cases);
    objective_final.(system_name)=cell(1,n_test_cases);
   
    fitness_stats.(system_name)=cell(1,n_test_cases);
    objective_stats.(system_name)=cell(1,n_test_cases);
    
    for test_case=1:n_test_cases
        if system~=41
            load([num2str(system) '_' num2str(test_case) '.mat'],'ps');
        else
            load([num2str(system) '.mat'],'ps');
        end
        fprintf(fid,['Test case ' num2str(test_case) '\n']);
        fitness.(system_name){test_case}=cell(1,n_scenarios);
        objective.(system_name){test_case}=cell(1,n_scenarios);
        constraint_violations.(system_name){test_case}=cell(1,n_scenarios);
        variables.(system_name){test_case}=cell(1,n_scenarios);
        best_variables.(system_name){test_case}=cell(1,n_scenarios);
        
        fitness_mean.(system_name){test_case}=cell(1,n_scenarios);
        fitness_best.(system_name){test_case}=cell(1,n_scenarios);
        fitness_worst.(system_name){test_case}=cell(1,n_scenarios);
        objective_best.(system_name){test_case}=cell(1,n_scenarios);
        constraint_violations_sum.(system_name){test_case}=cell(1,n_scenarios);
        
        fitness_stats.(system_name){test_case}=cell(1,n_scenarios);
        objective_stats.(system_name){test_case}=cell(1,n_scenarios);
        
        for scenario=1:n_scenarios
            fprintf(fid,['Scenario ' num2str(scenario) '\n']);
            filename=[algorithm_name '_' num2str(system) '_' num2str(test_case) '_' num2str(scenario) '_' 'fitness.txt'];
            dataArray=importdata(filename,' ');
            a=dataArray;
         	ainf=find(isinf(a));
         	if ~isempty(ainf)
                a(ainf(1):end)=a(ainf(1)-1);
            end
         	fitness.(system_name){test_case}{scenario}=a;
            
            filename=[algorithm_name '_' num2str(system) '_' num2str(test_case) '_' num2str(scenario) '_' 'objective.txt'];
            dataArray=importdata(filename,' ');
            a=dataArray;
        	ainf=find(isinf(a));
         	if ~isempty(ainf)
                a(ainf(1):end)=a(ainf(1)-1);
            end
            objective.(system_name){test_case}{scenario}=a;
            
            filename=[algorithm_name '_' num2str(system) '_' num2str(test_case) '_' num2str(scenario) '_' 'constraint_violations.txt'];
            dataArray=importdata(filename,' ');
            constraint_violations.(system_name){test_case}{scenario}=dataArray;
            
            filename=[algorithm_name '_' num2str(system) '_' num2str(test_case) '_' num2str(scenario) '_' 'variables.txt'];
            dataArray=importdata(filename,' ');
            variables.(system_name){test_case}{scenario}=dataArray;
            
            % Final fitness over trials
            fitness_final.(system_name){test_case}{scenario}=fitness.(system_name){test_case}{scenario}(end,:);
            % Final objective over trials
            objective_final.(system_name){test_case}{scenario}=objective.(system_name){test_case}{scenario}(end,:);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            fitness_stats.(system_name){test_case}{scenario}.mean=mean(fitness_final.(system_name){test_case}{scenario});
            fitness_stats.(system_name){test_case}{scenario}.median=median(fitness_final.(system_name){test_case}{scenario});
            [fitness_stats.(system_name){test_case}{scenario}.best,best_trial]=min(fitness_final.(system_name){test_case}{scenario});
            [fitness_stats.(system_name){test_case}{scenario}.worst,worst_trial]=max(fitness_final.(system_name){test_case}{scenario});
            fitness_stats.(system_name){test_case}{scenario}.std=std(fitness_final.(system_name){test_case}{scenario});
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            objective_stats.(system_name){test_case}{scenario}.mean=mean(objective_final.(system_name){test_case}{scenario});
            objective_stats.(system_name){test_case}{scenario}.median=median(objective_final.(system_name){test_case}{scenario});
            objective_stats.(system_name){test_case}{scenario}.best=objective_final.(system_name){test_case}{scenario}(best_trial);
            objective_stats.(system_name){test_case}{scenario}.worst=objective_final.(system_name){test_case}{scenario}(worst_trial);
            objective_stats.(system_name){test_case}{scenario}.std=std(objective_final.(system_name){test_case}{scenario});
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % Mean intermediate fitness over trials
            fitness_mean.(system_name){test_case}{scenario}=mean(fitness.(system_name){test_case}{scenario}');
            % Fitness over trials corresponding to best trial (minimum final fitness)
            fitness_best.(system_name){test_case}{scenario}=fitness.(system_name){test_case}{scenario}(:,best_trial);
            % Fitness over trials corresponding to worst trial (maximum final fitness)
            fitness_worst.(system_name){test_case}{scenario}=fitness.(system_name){test_case}{scenario}(:,worst_trial);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % Objective over trials corresponding to best trial (minimum final fitness)
            objective_best.(system_name){test_case}{scenario}=objective.(system_name){test_case}{scenario}(:,best_trial);

            % Variables corresponding to best trial
            best_variables.(system_name){test_case}{scenario}=...
                variables.(system_name){test_case}{scenario}(best_trial,:);
            % Whether variables are out of bounds
            act=best_variables.(system_name){test_case}{scenario};
            scaling=abs(ps.x_max-ps.x_min);
            g_var=[(ps.x_min-act)./scaling (act-ps.x_max)./scaling];
            g_var(g_var<0)=0;
            g_var_sum=sum(g_var);
            % Sum of final constraint violations over trials
            a=sum(constraint_violations.(system_name){test_case}{scenario}');
            constraint_violations_sum.(system_name){test_case}{scenario}=a(best_trial);
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            a=num2str(fitness_stats.(system_name){test_case}{scenario}.best);
            b=num2str(fitness_stats.(system_name){test_case}{scenario}.mean);
            c=num2str(fitness_stats.(system_name){test_case}{scenario}.median);
            d=num2str(fitness_stats.(system_name){test_case}{scenario}.worst);
            e=num2str(fitness_stats.(system_name){test_case}{scenario}.std);
            f=num2str(g_var_sum);
            g=num2str(objective_stats.(system_name){test_case}{scenario}.best);
            h=num2str(constraint_violations_sum.(system_name){test_case}{scenario});
            
            fprintf(fid,['fBest: ' a '     oBest: ' g '     g_sum_abs: ' h '     g_var_sum_norm: ' f '     Mean: ' b '     Med: ' c '     Worst: ' d '     Std: ' e '\n']);
            if system~=41
                figure
                semilogy(fitness_best.(system_name){test_case}{scenario},'Color','green','Linewidth',2)
                hold on
                semilogy(objective_best.(system_name){test_case}{scenario},'Color','green','Linewidth',2,'Linestyle','--')
                hold on
                semilogy(fitness_mean.(system_name){test_case}{scenario},'Color','blue','Linewidth',2)
                hold on
                semilogy(fitness_worst.(system_name){test_case}{scenario},'Color','red','Linewidth',2)
                xlabel('Function evaluations','FontName','Times New Roman','FontSize',11)
                ylabel('Fitness / objective','FontName','Times New Roman','FontSize',11)
                set(gca,'FontName','Times New Roman','FontSize',11)
                switch system
                    case 57
                        xlim([1 5e4/100])
                    case 118
                        xlim([1 10e4/100])
                    case 300
                        xlim([1 30e4/100])
                end
                aaa=get(gca,'XTickLabel');
                set(gca,'XTickLabel',num2str((str2num(aaa)*100)));
                legend('Fitness corr. to best trial','Objective corr. to best trial','Mean fitness','Fitness corr. to worst trial','FontName','Times New Roman','FontSize',11)
                text(0.15,0.8,['Algorithm ' algorithm_name],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                text(0.15,0.75,['System ' num2str(system)],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                text(0.15,0.7,['Test case ' num2str(test_case)],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                hgsave([system_name '_' 'testcase' '_' num2str(test_case) '_' 'scenario' '_' num2str(scenario) '_' algorithm_name])
            else
                if scenario==48 || scenario==80
                    figure
                    semilogy(fitness_best.(system_name){test_case}{scenario},'Color','green','Linewidth',2)
                    hold on
                    semilogy(objective_best.(system_name){test_case}{scenario},'Color','green','Linewidth',2,'Linestyle','--')
                    hold on
                    semilogy(fitness_mean.(system_name){test_case}{scenario},'Color','blue','Linewidth',2)
                    hold on
                    semilogy(fitness_worst.(system_name){test_case}{scenario},'Color','red','Linewidth',2)
                    xlabel('Function evaluations','FontName','Times New Roman','FontSize',11)
                    ylabel('Fitness / objective','FontName','Times New Roman','FontSize',11)
                    set(gca,'FontName','Times New Roman','FontSize',11)
                    xlim([1 1e4/100])
                 	aaa=get(gca,'XTickLabel');
                    set(gca,'XTickLabel',num2str((str2num(aaa)*100)));
                    legend('Fitness corr. to best trial','Objective corr. to best trial','Mean fitness','Fitness corr. to worst trial','FontName','Times New Roman','FontSize',11)
                    text(0.15,0.8,['Algorithm ' algorithm_name],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                    text(0.15,0.75,['System ' num2str(system)],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                    text(0.15,0.7,['Scenario ' num2str(scenario)],'FontName','Times New Roman','FontSize',11,'Units','normalized')
                    hgsave([system_name '_' 'testcase' '_' num2str(test_case) '_' 'scenario' '_' num2str(scenario) '_' algorithm_name])
                end
            end
        end
    end
end
fclose('all');
close all;