function mpc = case3012wp
%CASE3012WP  Power flow data for Polish system - winter 2007-08 evening peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   winter 2007-08 evening peak conditions.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case3012wp.m,v 1.1 2011/10/31 14:14:35 cvs Exp $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.10687	-0.31071	220	1	1.11	0.95;
	2	1	0	0	0	0	1	1.10786	1.38118	220	1	1.11	0.95;
	3	1	0	0	0	0	1	1.06622	-30.75479	220	1	1.11	0.95;
	4	1	0	0	0	0	1	1.06616	-30.76377	220	1	1.11	0.95;
	5	1	0	0	0	0	1	1.07733	-32.99749	220	1	1.11	0.95;
	6	1	0	0	0	0	1	1.07571	-6.07319	220	1	1.11	0.95;
	7	1	0	0	0	0	1	1.07568	-6.07443	220	1	1.11	0.95;
	8	1	0	0	0	0	1	1.09064	-18.37688	220	1	1.11	0.95;
	9	1	0	0	0	0	1	1.09088	-18.36046	220	1	1.11	0.95;
	10	1	0	0	0	0	1	1.11	-21.78212	220	1	1.11	0.95;
	11	1	0	0	0	0	1	1.02566	-13.20685	400	1	1.05	0.95;
	12	1	0	0	0	0	1	1.02574	-13.19799	400	1	1.05	0.95;
	13	1	0	0	0	0	1	1.0119	-17.61355	400	1	1.05	0.95;
	14	1	0	0	0	0	1	1.04309	-18.20959	220	1	1.11	0.95;
	15	1	0	0	0	0	1	1.04329	-18.2057	220	1	1.11	0.95;
	16	1	0	0	0	0	1	1.0433	-18.19566	220	1	1.11	0.95;
	17	1	0	0	0	0	1	1.03119	-22.61825	220	1	1.11	0.95;
	18	1	0	0	0	0	1	1.03092	-22.24172	220	1	1.11	0.95;
	19	1	0	0	0	0	1	1.02695	-11.56537	400	1	1.05	0.95;
	20	1	0	0	0	0	1	1.027	-11.55538	400	1	1.05	0.95;
	21	1	0	0	0	0	1	1.022	-21.30132	400	1	1.05	0.95;
	22	1	0	0	0	0	1	1.0159	-17.33382	400	1	1.05	0.95;
	23	1	0	0	0	0	1	1.0159	-17.33382	400	1	1.05	0.95;
	24	2	10.05	20.1	0	0	1	1.08673	-25.1625	220	1	1.11	0.95;
	25	2	10.05	20.1	0	0	1	1.08668	-25.16218	220	1	1.11	0.95;
	26	1	0	0	0	0	1	1.08508	-5.08891	220	1	1.11	0.95;
	27	1	0	0	0	0	1	1.0852	-5.10279	220	1	1.11	0.95;
	28	1	0	0	0	0	1	1.04003	-20.22757	220	1	1.11	0.95;
	29	1	0	0	0	0	1	1.03998	-20.22535	220	1	1.11	0.95;
	30	1	0	0	0	0	1	1.04254	-17.70338	220	1	1.11	0.95;
	31	1	0	0	0	0	1	1.04248	-17.71626	220	1	1.11	0.95;
	32	1	0	0	0	0	1	1.08455	-2.6769	220	1	1.11	0.95;
	33	1	0	0	0	0	1	1.08445	-2.70092	220	1	1.11	0.95;
	34	1	0	0	0	0	1	1.01782	-15.36123	400	1	1.05	0.95;
	35	1	0	0	0	0	1	1.01778	-15.36625	400	1	1.05	0.95;
	36	1	0	0	0	0	1	1.00715	-18.54864	400	1	1.05	0.95;
	37	3	48.68	86.21	0	0	1	1.11	0	220	1	1.11	0.95;
	38	2	54.54	89.93	0	0	1	1.11	1.67906	220	1	1.11	0.95;
	39	2	20.1	40.19	0	0	1	1.11	1.6712	220	1	1.11	0.95;
	40	2	60.29	120.57	0	0	1	1.04749	0.16082	400	1	1.05	0.95;
	41	2	60.29	120.57	0	0	1	1.04746	0.1677	400	1	1.05	0.95;
	42	1	0	0	0	0	1	1.032	-19.50464	220	1	1.11	0.95;
	43	1	0	0	0	0	1	1.0319	-19.50833	220	1	1.11	0.95;
	44	1	0	0	0	0	1	1.05	-1.46667	400	1	1.05	0.95;
	45	1	0	0	0	0	1	1.04999	-1.4702	400	1	1.05	0.95;
	46	1	0	0	0	0	1	1.03961	-18.55938	220	1	1.11	0.95;
	47	1	0	0	0	0	1	1.0603	-8.38392	220	1	1.11	0.95;
	48	1	0	0	0	0	1	1.06031	-8.40113	220	1	1.11	0.95;
	49	1	0	0	0	0	1	1.09293	-12.14531	220	2	1.11	0.95;
	50	1	0	0	0	0	1	1.09117	-11.76281	220	2	1.11	0.95;
	51	1	0	0	0	0	1	1.10366	-10.12826	220	2	1.11	0.95;
	52	1	0	0	0	0	1	1.10363	-10.13266	220	2	1.11	0.95;
	53	1	0	0	0	0	1	1.07232	-14.11371	220	2	1.11	0.95;
	54	1	3.23	1	0	0	1	1.09961	-8.90014	220	2	1.11	0.95;
	55	1	0	0	0	0	1	1.09968	-8.89933	220	2	1.11	0.95;
	56	1	0	0	0	0	1	1.03605	-9.05729	400	2	1.05	0.95;
	57	2	26.12	60.29	0	0	1	1.10173	-10.25582	220	2	1.11	0.95;
	58	2	54.26	120.57	0	0	1	1.10171	-10.25621	220	2	1.11	0.95;
	59	2	13.06	30.14	0	0	1	1.10172	-10.25725	220	2	1.11	0.95;
	60	2	26.12	50.24	0	0	1	1.05	-8.39996	400	2	1.05	0.95;
	61	2	26.12	50.24	0	0	1	1.05	-8.39311	400	2	1.05	0.95;
	62	1	0	0	0	0	1	1.09422	-9.63373	220	2	1.11	0.95;
	63	1	0	0	0	0	1	1.04488	-12.96627	400	2	1.05	0.95;
	64	1	0	0	0	0	1	1.04488	-12.96741	400	2	1.05	0.95;
	65	1	0	0	0	0	1	1.04784	-9.93617	400	2	1.05	0.95;
	66	1	0	0	0	0	1	1.07841	-12.39445	220	2	1.11	0.95;
	67	1	0	0	0	0	1	1.07841	-12.3893	220	2	1.11	0.95;
	68	1	0	0	0	0	1	1.04573	-9.63176	400	2	1.05	0.95;
	69	1	0	0	0	0	1	1.04572	-9.63384	400	2	1.05	0.95;
	70	2	13.06	30.14	0	0	1	1.10839	-8.87769	220	2	1.11	0.95;
	71	2	13.06	30.14	0	0	1	1.10837	-8.87934	220	2	1.11	0.95;
	72	2	13.06	30.14	0	0	1	1.04326	-9.26509	400	2	1.05	0.95;
	73	2	26.12	60.29	0	0	1	1.04328	-9.2666	400	2	1.05	0.95;
	74	2	149.71	60.29	0	0	1	1.09864	-11.20347	220	2	1.11	0.95;
	75	1	29.14	10.05	0	0	1	1.09863	-11.2051	220	2	1.11	0.95;
	76	1	0	0	0	0	1	1.09665	-9.80009	220	2	1.11	0.95;
	77	1	0	0	0	0	1	1.09665	-9.79646	220	2	1.11	0.95;
	78	1	0	0	0	0	1	1.09751	-11.17469	220	2	1.11	0.95;
	79	1	0	0	0	0	1	1.09752	-11.17842	220	2	1.11	0.95;
	80	1	0	0	0	0	1	1.05	-10.59415	400	2	1.05	0.95;
	81	1	0	0	0	0	1	1.04997	-10.60572	400	2	1.05	0.95;
	82	1	0	0	0	0	1	1.10002	-11.23164	220	2	1.11	0.95;
	83	1	0	0	0	0	1	1.10068	-11.10542	220	2	1.11	0.95;
	84	1	0	0	0	0	1	1.07989	-11.21263	220	2	1.11	0.95;
	85	1	0	0	0	0	1	1.09346	-3.5943	220	3	1.11	0.95;
	86	1	9.35	0	0	0	1	1.09458	-8.18638	220	3	1.11	0.95;
	87	1	8.18	0	0	0	1	1.0946	-8.18664	220	3	1.11	0.95;
	88	1	0	0	0	0	1	1.09961	-2.00004	220	3	1.11	0.95;
	89	1	0	0	0	0	1	1.09973	-1.98735	220	3	1.11	0.95;
	90	1	0	0	0	0	1	1.10943	-1.60433	220	3	1.11	0.95;
	91	1	0	0	0	0	1	1.10945	-1.60664	220	3	1.11	0.95;
	92	1	0	0	0	0	1	1.07467	-3.37656	220	3	1.11	0.95;
	93	1	0	0	0	0	1	1.07442	-3.38318	220	3	1.11	0.95;
	94	2	28.13	70.33	0	0	1	1.10879	-1.16446	220	3	1.11	0.95;
	95	2	42.2	103.49	0	0	1	1.11	-0.70406	220	3	1.11	0.95;
	96	1	7.72	-24.99	0	0	1	1.09588	-2.13544	220	3	1.11	0.95;
	97	1	0	0	0	0	1	1.09587	-2.13643	220	3	1.11	0.95;
	98	2	32.15	142.68	0	0	1	1.05	-3.78388	400	3	1.05	0.95;
	99	1	0	0	0	0	1	1.04991	-3.81135	400	3	1.05	0.95;
	100	1	0	0	0	0	1	1.06008	-5.3044	220	3	1.11	0.95;
	101	1	0	0	0	0	1	1.10846	-1.10453	220	3	1.11	0.95;
	102	1	0	0	0	0	1	1.10846	-1.10183	220	3	1.11	0.95;
	103	1	45.11	7.94	0	0	1	1.09635	-3.36048	220	3	1.11	0.95;
	104	1	0	0	0	0	1	1.09629	-3.3649	220	3	1.11	0.95;
	105	1	0	0	0	0	1	1.10423	-0.96982	220	3	1.11	0.95;
	106	1	0	0	0	0	1	1.10416	-0.97182	220	3	1.11	0.95;
	107	1	0	0	0	0	1	1.10052	-2.95149	220	3	1.11	0.95;
	108	1	0	0	0	0	1	1.1005	-2.95733	220	3	1.11	0.95;
	109	1	0	0	0	0	1	1.04342	-1.54584	400	3	1.05	0.95;
	110	1	0	0	0	0	1	1.04342	-1.54731	400	3	1.05	0.95;
	111	1	0	0	0	0	1	1.10685	-0.81041	220	3	1.11	0.95;
	112	1	0	0	0	0	1	1.10687	-0.80889	220	3	1.11	0.95;
	113	1	0	0	0	0	1	1.08112	-2.74238	220	3	1.11	0.95;
	114	1	0	0	0	0	1	1.08102	-2.75523	220	3	1.11	0.95;
	115	2	29.36	18.51	0	0	1	1.10086	-2.24238	220	3	1.11	0.95;
	116	1	0	0	0	0	1	1.10083	-2.25484	220	3	1.11	0.95;
	117	1	0	0	0	0	1	1.09464	-8.16746	220	3	1.11	0.95;
	118	1	0	0	0	0	1	1.09463	-8.16449	220	3	1.11	0.95;
	119	1	0	0	0	0	1	1.06073	-3.70462	220	3	1.11	0.95;
	120	1	0	0	0	0	1	1.0607	-3.70595	220	3	1.11	0.95;
	121	2	0	0	0	0	1	1.10998	-0.81487	220	3	1.11	0.95;
	122	2	10.05	44.21	0	0	1	1.11	-0.81293	220	3	1.11	0.95;
	123	2	7.03	18.09	0	0	1	1.10998	-0.9014	220	3	1.11	0.95;
	124	2	8.04	21.1	0	0	1	1.11	-0.88955	220	3	1.11	0.95;
	125	1	0	0	0	0	1	1.09615	-3.6595	220	3	1.11	0.95;
	126	1	71.54	7.94	0	0	1	1.09618	-3.66739	220	3	1.11	0.95;
	127	1	0	0	0	0	1	1.07909	-3.98005	220	3	1.11	0.95;
	128	1	0	0	0	0	1	1.08915	-1.6916	220	3	1.11	0.95;
	129	1	0	0	0	0	1	1.08919	-1.6937	220	3	1.11	0.95;
	130	1	0	0	0	0	1	1.09446	-2.20106	220	3	1.11	0.95;
	131	1	0	0	0	0	1	1.09456	-2.19291	220	3	1.11	0.95;
	132	1	0	0	0	0	1	1.04145	-4.68941	400	3	1.05	0.95;
	133	1	0	0	0	0	1	1.04145	-4.68941	400	3	1.05	0.95;
	134	2	0	0	0	0	1	1.1076	-1.75405	220	3	1.11	0.95;
	135	2	9.04	20.1	0	0	1	1.10756	-1.75662	220	3	1.11	0.95;
	136	2	6.03	15.07	0	0	1	1.09273	-3.25359	220	3	1.11	0.95;
	137	1	0	0	0	0	1	1.09274	-3.26507	220	3	1.11	0.95;
	138	1	0	0	0	0	1	1.04773	-10.43139	400	3	1.05	0.95;
	139	1	0	0	0	0	1	1.04776	-10.43347	400	3	1.05	0.95;
	140	1	0	0	0	0	1	1.05	-5.23789	400	3	1.05	0.95;
	141	1	0	0	0	0	1	1.05	-5.23626	400	3	1.05	0.95;
	142	1	0	0	0	0	1	1.07651	-4.23696	220	3	1.11	0.95;
	143	1	0	0	0	0	1	1.07657	-4.2345	220	3	1.11	0.95;
	144	2	18.34	15.86	0	0	1	1.10995	-0.42094	220	3	1.11	0.95;
	145	2	41.01	43.07	0	0	1	1.11	-0.39755	220	3	1.11	0.95;
	146	2	28.13	66.31	0	0	1	1.03968	-3.73649	400	3	1.05	0.95;
	147	1	0	0	0	0	1	1.03973	-3.73553	400	3	1.05	0.95;
	148	1	0	0	0	0	1	1.09503	-3.45038	220	3	1.11	0.95;
	149	1	0	0	0	0	1	1.09511	-3.44329	220	3	1.11	0.95;
	150	1	0	0	0	0	1	1.10974	-0.88932	220	3	1.11	0.95;
	151	1	0	0	0	0	1	1.09847	-3.06801	220	3	1.11	0.95;
	152	2	0	0	0	0	1	1.0747	-3.37679	220	3	1.11	0.95;
	153	2	0	0	0	0	1	1.07446	-3.38341	220	3	1.11	0.95;
	154	2	7.84	20.1	0	0	1	1.0886	-12.28014	220	4	1.11	0.95;
	155	2	8.04	20.1	0	0	1	1.0886	-12.29183	220	4	1.11	0.95;
	156	1	0	0	0	0	1	1.06352	-13.64672	220	4	1.11	0.95;
	157	1	0	0	0	0	1	1.06349	-13.64822	220	4	1.11	0.95;
	158	1	0	0	0	0	1	1.05491	-15.40253	220	4	1.11	0.95;
	159	1	0	0	0	0	1	1.0809	-11.9306	220	4	1.11	0.95;
	160	1	0	0	0	0	1	1.08081	-11.94	220	4	1.11	0.95;
	161	1	0	0	0	0	1	1.02237	-11.56354	400	4	1.05	0.95;
	162	1	0	0	0	0	1	1.02234	-11.56615	400	4	1.05	0.95;
	163	1	0	0	0	0	1	1.02624	-27.57951	220	4	1.11	0.95;
	164	1	0	0	0	0	1	1.07708	-34.45732	220	4	1.11	0.95;
	165	1	0	0	0	0	1	1.07708	-34.45732	220	4	1.11	0.95;
	166	1	0	0	0	0	1	1.07169	-29.99065	220	4	1.11	0.95;
	167	1	0	0	0	0	1	1.07169	-29.99065	220	4	1.11	0.95;
	168	1	0	0	0	0	1	1.05429	-15.63955	220	4	1.11	0.95;
	169	2	0	0	0	0	1	1.08102	-17.43907	220	4	1.11	0.95;
	170	2	0	0	0	0	1	1.08099	-17.45362	220	4	1.11	0.95;
	171	1	0	0	0	0	1	1.11	-14.25484	220	4	1.11	0.95;
	172	2	12.06	30.14	0	0	1	1.10415	-32.35768	220	4	1.11	0.95;
	173	2	9.39	2.43	0	0	1	1.1041	-32.35811	220	4	1.11	0.95;
	174	2	12.06	30.14	0	0	1	1.03614	-29.56303	400	4	1.05	0.95;
	175	2	24.11	60.29	0	0	1	1.03615	-29.55912	400	4	1.05	0.95;
	176	1	0	0	0	0	1	0.9948	-26.47025	220	4	1.11	0.95;
	177	1	0	0	0	0	1	0.99492	-26.47877	220	4	1.11	0.95;
	178	1	0	0	0	0	1	1.04834	-21.80385	220	4	1.11	0.95;
	179	1	0	0	0	0	1	1.04835	-21.80804	220	4	1.11	0.95;
	180	2	26.12	64.3	0	0	1	1.11	-8.16009	220	4	1.11	0.95;
	181	2	26.12	64.3	0	0	1	1.11	-8.16811	220	4	1.11	0.95;
	182	2	26.12	64.51	0	0	1	1.11	-8.14562	220	4	1.11	0.95;
	183	2	26.12	64.51	0	0	1	1.0494	-7.52334	400	4	1.05	0.95;
	184	1	0	0	0	0	1	1.04937	-7.52475	400	4	1.05	0.95;
	185	1	0	0	0	0	1	1.08073	-34.49268	220	4	1.11	0.95;
	186	1	0	0	0	0	1	1.08073	-34.49268	220	4	1.11	0.95;
	187	1	0	0	0	0	1	1.00811	-12.6487	400	4	1.05	0.95;
	188	1	0	0	0	0	1	0.97886	-18.43994	400	4	1.05	0.95;
	189	1	0	0	0	0	1	1.02056	-10.67424	400	4	1.05	0.95;
	190	1	0	0	0	0	1	1.02058	-10.66628	400	4	1.05	0.95;
	191	2	12.06	30.14	0	0	1	1.08298	-17.58589	220	4	1.11	0.95;
	192	2	14.66	30.65	0	0	1	1.08268	-17.62769	220	4	1.11	0.95;
	193	2	38.18	64.3	0	0	1	1.03244	-10.99838	400	4	1.05	0.95;
	194	1	0	0	0	0	1	1.01417	-34.12922	220	4	1.11	0.95;
	195	1	0	0	0	0	1	1.01422	-34.13421	220	4	1.11	0.95;
	196	1	0	0	0	0	1	1.0765	-34.5414	220	4	1.11	0.95;
	197	1	0	0	0	0	1	1.07651	-34.54253	220	4	1.11	0.95;
	198	1	0	0	0	0	1	1.02063	-28.73479	220	4	1.11	0.95;
	199	1	0	0	0	0	1	1.02061	-28.7266	220	4	1.11	0.95;
	200	1	0	0	0	0	1	0.98033	-30.38903	400	4	1.05	0.95;
	201	1	0	0	0	0	1	0.98033	-30.38903	400	4	1.05	0.95;
	202	1	0	0	0	0	1	1.01651	-20.42501	220	4	1.11	0.95;
	203	1	0	0	0	0	1	1.01651	-20.41966	220	4	1.11	0.95;
	204	1	0	0	0	0	1	1.01058	-29.47283	220	4	1.11	0.95;
	205	1	0	0	0	0	1	1.06372	-13.17167	220	4	1.11	0.95;
	206	1	0	0	0	0	1	1.06373	-13.18391	220	4	1.11	0.95;
	207	1	0	0	0	0	1	1.05545	-11.52153	220	4	1.11	0.95;
	208	2	3.14	1.51	0	0	1	1.06751	-20.34103	220	4	1.11	0.95;
	209	1	0	0	0	0	1	1.0071	-21.69583	220	4	1.11	0.95;
	210	1	0	0	0	0	1	1.00709	-21.68746	220	4	1.11	0.95;
	211	1	0	0	0	0	1	1.04386	-26.87614	220	5	1.11	0.95;
	212	1	0	0	0	0	1	1.11	-31.12644	220	5	1.11	0.95;
	213	1	0	0	0	0	1	1.03205	-30.05015	400	5	1.05	0.95;
	214	1	0	0	0	0	1	1.03208	-30.05116	400	5	1.05	0.95;
	215	1	0	0	0	0	1	1.02334	-28.07644	400	5	1.05	0.95;
	216	1	0	0	0	0	1	1.02335	-28.08285	400	5	1.05	0.95;
	217	1	0	0	0	0	1	1.02952	-33.32654	400	5	1.05	0.95;
	218	1	0	0	0	0	1	1.02356	-31.92689	220	5	1.11	0.95;
	219	1	0	0	0	0	1	1.02356	-31.93251	220	5	1.11	0.95;
	220	1	0	0	0	0	1	1.05502	-27.06468	220	5	1.11	0.95;
	221	1	0	0	0	0	1	1.05496	-27.0685	220	5	1.11	0.95;
	222	1	0	0	0	0	1	1.00615	-24.40357	400	5	1.05	0.95;
	223	1	0	0	0	0	1	1.00615	-24.40357	400	5	1.05	0.95;
	224	1	0	0	0	0	1	1.0292	-30.07108	400	5	1.05	0.95;
	225	1	0	0	0	0	1	1.0517	-25.99674	220	5	1.11	0.95;
	226	1	0	0	0	0	1	1.05171	-25.99001	220	5	1.11	0.95;
	227	1	0	0	0	0	1	1.07065	-29.65174	220	5	1.11	0.95;
	228	1	0	0	0	0	1	1.06046	-30.31094	220	5	1.11	0.95;
	229	1	0	0	0	0	1	1.02718	-30.08211	400	5	1.05	0.95;
	230	1	0	0	0	0	1	1.02714	-30.08242	400	5	1.05	0.95;
	231	1	0	0	0	0	1	1.05	-33.4206	400	5	1.05	0.95;
	232	1	0	0	0	0	1	1.05293	-30.39317	220	5	1.11	0.95;
	233	1	0	0	0	0	1	1.05301	-30.3895	220	5	1.11	0.95;
	234	1	0	0	0	70	1	1.03626	-29.27812	400	5	1.25	0.75;
	235	1	0	0	0	0	1	1.03625	-29.28116	400	5	1.05	0.95;
	236	1	0	0	0	0	1	1.02938	-28.18775	220	5	1.11	0.95;
	237	1	0	0	0	0	1	1.02933	-28.18704	220	5	1.11	0.95;
	238	1	0	0	0	0	1	1.03234	-26.20743	220	5	1.11	0.95;
	239	1	0	0	0	0	1	1.03226	-26.22273	220	5	1.11	0.95;
	240	2	2.01	40.19	0	0	1	1.02222	-27.35991	400	5	1.05	0.95;
	241	2	5.55	30.14	0	0	1	1.02222	-27.3569	400	5	1.05	0.95;
	242	1	0	0	0	0	1	1.06862	-32.33784	220	5	1.11	0.95;
	243	1	0	0	0	0	1	1.06873	-32.33242	220	5	1.11	0.95;
	244	2	0	0	0	0	0	1.11	-2.26558	220	0	1.11	0.95;
	245	1	9.94	2.01	0	0	1	1.0598	-27.47615	110	1	1.12	0.95;
	246	1	8.89	0	0	0	1	1.06878	-35.16503	110	1	1.12	0.95;
	247	1	8.89	0	0	0	1	1.06867	-35.15648	110	1	1.12	0.95;
	248	1	6.09	1	0	0	1	1.11188	-21.26523	110	1	1.12	0.95;
	249	1	6.09	2.01	0	0	1	1.11193	-21.28907	110	1	1.12	0.95;
	250	1	2.94	2.51	0	0	1	1.0369	-26.11152	110	1	1.12	0.95;
	251	1	6.29	5.83	0	0	1	1.03685	-26.11407	110	1	1.12	0.95;
	252	1	5.18	1.31	0	0	1	1.0894	-2.22548	110	1	1.12	0.95;
	253	1	6.2	1	0	0	1	1.07826	-3.38376	110	1	1.12	0.95;
	254	2	-11.53	119.74	0	0	1	1.10528	-24.32495	110	1	1.12	0.95;
	255	1	23.02	2.01	0	0	1	1.10547	-24.52431	110	1	1.12	0.95;
	256	1	14.65	1.51	0	0	1	1.10662	-24.73563	110	1	1.12	0.95;
	257	1	16.74	0	0	0	1	1.10644	-24.88734	110	1	1.12	0.95;
	258	1	26.16	3.01	0	0	1	1.10496	-25.02851	110	1	1.12	0.95;
	259	1	11.51	2.01	0	0	1	1.10514	-24.50349	110	1	1.12	0.95;
	260	1	5.23	1	0	0	1	1.10468	-24.96311	110	1	1.12	0.95;
	261	1	5.23	1	0	0	1	1.1046	-24.94136	110	1	1.12	0.95;
	262	1	0	0	0	0	1	1.10653	-24.98207	110	1	1.12	0.95;
	263	1	7.72	1.51	0	0	1	1.09924	-24.35413	110	1	1.12	0.95;
	264	1	5.59	1	0	0	1	1.09931	-24.34805	110	1	1.12	0.95;
	265	1	5.05	0.5	0	0	1	1.10768	-23.54858	110	1	1.12	0.95;
	266	1	5.05	0.5	0	0	1	1.1076	-23.57077	110	1	1.12	0.95;
	267	2	0.06	0	0	0	1	1.05826	-18.51816	110	1	1.12	0.95;
	268	2	10.87	2.51	0	0	1	1.07506	-10.60506	110	1	1.12	0.95;
	269	1	20.71	5.63	0	0	1	1.11088	-23.3054	110	1	1.12	0.95;
	270	1	0.91	0.4	0	0	1	1.09075	-4.65123	110	1	1.12	0.95;
	271	1	1.21	-0.9	0	0	1	1.0872	-0.50335	110	1	1.12	0.95;
	272	1	5.66	0.3	0	0	1	1.09854	-24.75344	110	1	1.12	0.95;
	273	1	5.23	0.2	0	0	1	1.10015	-32.20886	110	1	1.12	0.95;
	274	1	24.07	2.01	0	0	1	1.08464	-26.28132	110	1	1.12	0.95;
	275	1	4.17	2.11	0	0	1	1.10917	-9.31584	110	1	1.12	0.95;
	276	1	8.33	1.51	0	0	1	1.05962	-14.4717	110	1	1.12	0.95;
	277	1	3.15	0.5	0	0	1	1.11957	-23.46357	110	1	1.12	0.95;
	278	2	3.86	1.61	0	0	1	1.11543	-8.95777	110	1	1.12	0.95;
	279	2	3.86	1.61	0	0	1	1.11989	-10.32493	110	1	1.12	0.95;
	280	1	24.36	6.53	0	0	1	1.09723	-23.79866	110	1	1.12	0.95;
	281	1	10.36	2.21	0	0	1	1.07942	-3.24686	110	1	1.12	0.95;
	282	1	6.09	0.5	0	0	1	1.07456	-13.12454	110	1	1.12	0.95;
	283	1	3.25	0.2	0	0	1	1.07455	-13.11849	110	1	1.12	0.95;
	284	1	13.51	7.03	0	0	1	1.0745	-2.2326	110	1	1.12	0.95;
	285	1	20.72	11.55	0	0	1	1.0744	-2.25543	110	1	1.12	0.95;
	286	1	10.31	0.4	0	0	1	1.08108	-28.77144	110	1	1.12	0.95;
	287	1	12.6	4.52	0	0	1	1.11103	-8.72336	110	1	1.12	0.95;
	288	1	9.6	0.8	0	0	1	1.08032	-29.03292	110	1	1.12	0.95;
	289	1	0	0	0	0	1	1.08031	-29.03735	110	1	1.12	0.95;
	290	1	6.28	0.3	0	0	1	1.08594	-29.05077	110	1	1.12	0.95;
	291	1	5.23	0	0	0	1	1.0796	-29.28297	110	1	1.12	0.95;
	292	1	4.19	0	0	0	1	1.07955	-29.28738	110	1	1.12	0.95;
	293	1	1.05	0	0	0	1	1.08863	-27.7686	110	1	1.12	0.95;
	294	1	0	0	0	0	1	1.08868	-27.7935	110	1	1.12	0.95;
	295	2	0.23	0.4	0	0	1	1.09445	-25.72919	110	1	1.12	0.95;
	296	1	0	0	0	0	1	1.09449	-25.75	110	1	1.12	0.95;
	297	1	9.42	2.01	0	0	1	1.06854	-32.62676	110	1	1.12	0.95;
	298	1	0.3	0.1	0	0	1	1.10393	-5.20295	110	1	1.12	0.95;
	299	1	0.3	0.1	0	0	1	1.10025	-5.1172	110	1	1.12	0.95;
	300	1	13.51	7.64	0	0	1	1.10173	-5.28144	110	1	1.12	0.95;
	301	1	0.51	0.2	0	0	1	1.10022	-5.11879	110	1	1.12	0.95;
	302	1	7.78	0.1	0	0	1	1.07888	-31.06533	110	1	1.12	0.95;
	303	1	8.99	0.1	0	0	1	1.07891	-31.07775	110	1	1.12	0.95;
	304	1	6.71	2.21	0	0	1	1.11155	-9.6863	110	1	1.12	0.95;
	305	1	6.7	0.6	0	0	1	1.10282	-5.45313	110	1	1.12	0.95;
	306	1	3.66	0.3	0	0	1	1.10283	-5.43433	110	1	1.12	0.95;
	307	1	4.16	1	0	0	1	1.11613	-26.1945	110	1	1.12	0.95;
	308	1	0	0	0	0	1	1.08666	-0.47112	110	1	1.12	0.95;
	309	1	0	0	0	0	1	1.08672	-0.49322	110	1	1.12	0.95;
	310	2	33.84	48.83	0	0	1	1	3.28552	24	1	1.12	0.95;
	311	1	6.28	0.5	0	0	1	1.09647	-33.75971	110	1	1.12	0.95;
	312	1	6.28	0.5	0	0	1	1.09643	-33.77946	110	1	1.12	0.95;
	313	1	4.71	0.5	0	0	1	1.09783	-33.73775	110	1	1.12	0.95;
	314	1	2.62	0.5	0	0	1	1.10834	-32.63587	110	1	1.12	0.95;
	315	1	0	0	0	45	1	1.08698	-32.99455	16	1	1.25	0.75;
	316	2	0	-0.02	0	0	1	1.06162	-25.09631	110	1	1.12	0.95;
	317	1	17.79	2.51	0	0	1	1.1041	-25.07208	110	1	1.12	0.95;
	318	1	3.66	0.5	0	0	1	1.06109	-37.60014	110	1	1.12	0.95;
	319	1	6.37	0.5	0	0	1	1.11528	-22.20018	110	1	1.12	0.95;
	320	1	24.36	6.53	0	0	1	1.07426	-16.64133	110	1	1.12	0.95;
	321	1	26.39	6.23	0	0	1	1.09963	-23.97438	110	1	1.12	0.95;
	322	1	17.27	1	0	0	1	1.07335	-36.88841	110	1	1.12	0.95;
	323	1	43.95	2.51	0	0	1	1.09312	-32.27825	110	1	1.12	0.95;
	324	1	5.76	0.4	0	0	1	1.09638	-32.3692	110	1	1.12	0.95;
	325	1	4.16	1	0	0	1	1.07422	-2.20224	110	1	1.12	0.95;
	326	1	4.88	1.21	0	0	1	1.07414	-2.21909	110	1	1.12	0.95;
	327	1	13.11	4.22	0	0	1	1.10283	-9.97055	110	1	1.12	0.95;
	328	1	8.37	1	0	0	1	1.06234	-37.81147	110	1	1.12	0.95;
	329	1	10.15	1	0	0	1	1.11522	-21.65948	110	1	1.12	0.95;
	330	1	12.18	2.01	0	0	1	1.10972	-21.00921	110	1	1.12	0.95;
	331	1	3.84	1	0	0	1	1.07671	-30.13139	110	1	1.12	0.95;
	332	1	31.28	22.1	0	0	1	1.08513	-0.84811	110	1	1.12	0.95;
	333	1	22.75	13.06	0	0	1	1.07939	-2.85587	110	1	1.12	0.95;
	334	1	38.41	12.06	0	0	1	1.08615	-0.56772	110	1	1.12	0.95;
	335	1	5.08	2.51	0	0	1	1.09961	-23.10749	110	1	1.12	0.95;
	336	1	13.04	0.7	0	0	1	1.10665	-24.44525	110	1	1.12	0.95;
	337	1	2.93	0.4	0	0	1	1.11521	-21.56597	110	1	1.12	0.95;
	338	1	7.78	1	0	0	1	1.11525	-21.57644	110	1	1.12	0.95;
	339	1	16.74	1.51	0	0	1	1.08523	-26.42824	110	1	1.12	0.95;
	340	1	7.32	0.4	0	0	1	1.06047	-37.32696	110	1	1.12	0.95;
	341	1	3.14	0.1	0	0	1	1.06051	-37.32034	110	1	1.12	0.95;
	342	1	9.08	2.11	0	0	1	1.10835	-21.81905	110	1	1.12	0.95;
	343	1	9.08	2.11	0	0	1	1.10828	-21.81294	110	1	1.12	0.95;
	344	1	0.3	0	0	0	1	1.09679	-23.95109	110	1	1.12	0.95;
	345	1	0.81	0.2	0	0	1	1.11647	-21.30193	110	1	1.12	0.95;
	346	1	0	0	0	0	1	1.10865	-22.32118	110	1	1.12	0.95;
	347	1	11.69	5.63	0	0	1	1.10902	-8.54829	110	1	1.12	0.95;
	348	1	7.82	3.72	0	0	1	1.11134	-9.11067	110	1	1.12	0.95;
	349	1	4.88	0.3	0	0	1	1.07954	-10.22441	110	1	1.12	0.95;
	350	1	3.86	0.6	0	0	1	1.07959	-10.23145	110	1	1.12	0.95;
	351	1	3.66	0.5	0	0	1	1.10142	-26.32366	110	1	1.12	0.95;
	352	1	9.42	0.5	0	0	1	1.09764	-28.46343	110	1	1.12	0.95;
	353	1	11.17	2.01	0	0	1	1.10843	-22.11537	110	1	1.12	0.95;
	354	1	13.2	2.01	0	0	1	1.08852	-22.363	110	1	1.12	0.95;
	355	1	23.87	14.07	0	0	1	1.0744	-2.81097	110	1	1.12	0.95;
	356	1	10.36	5.02	0	0	1	1.07434	-2.80025	110	1	1.12	0.95;
	357	1	2.02	0.4	0	0	1	1.08849	-0.66352	110	1	1.12	0.95;
	358	1	0	0	0	0	1	1.08715	-0.85789	110	1	1.12	0.95;
	359	1	13.82	4.92	0	0	1	1.10911	-8.58413	110	1	1.12	0.95;
	360	1	3.05	1	0	0	1	1.09921	-23.25652	110	1	1.12	0.95;
	361	1	14.02	1.81	0	0	1	1.0911	-10.56029	110	1	1.12	0.95;
	362	1	0	0	0	0	1	1.09279	-31.55095	110	1	1.12	0.95;
	363	1	11.51	0.2	0	0	1	1.09287	-31.57322	110	1	1.12	0.95;
	364	1	4.71	0	0	0	1	1.09877	-27.68586	110	1	1.12	0.95;
	365	1	4.97	1.31	0	0	1	1.09281	-24.67367	110	1	1.12	0.95;
	366	1	5.56	0.2	0	0	1	1.09497	-14.72992	110	1	1.12	0.95;
	367	1	24.36	7.03	0	0	1	1.0901	-22.18599	110	1	1.12	0.95;
	368	1	15.23	1.61	0	0	1	1.118	-21.36738	110	1	1.12	0.95;
	369	1	11.89	3.82	0	0	1	1.1111	-8.51705	110	1	1.12	0.95;
	370	1	6.5	1.21	0	0	1	1.06279	-25.76766	110	1	1.12	0.95;
	371	1	8.19	0.1	0	0	1	1.1004	-25.13789	110	1	1.12	0.95;
	372	1	16.27	0.5	0	0	1	1.09525	-14.62633	110	1	1.12	0.95;
	373	1	5.69	0.5	0	0	1	1.09483	-9.22741	110	1	1.12	0.95;
	374	1	9.75	3.52	0	0	1	1.11353	-8.89553	110	1	1.12	0.95;
	375	1	18.09	6.53	0	0	1	1.11832	-10.42885	110	1	1.12	0.95;
	376	2	16.74	0	0	0	1	1.10193	-26.41819	110	1	1.12	0.95;
	377	1	5.69	0.5	0	0	1	1.10876	-9.3716	110	1	1.12	0.95;
	378	1	0	0	0	0	1	1.0857	-5.26957	110	1	1.12	0.95;
	379	2	19.02	6.91	0	0	1	1.11132	-8.50417	110	1	1.12	0.95;
	380	1	18.09	5.93	0	0	1	1.11111	-9.6757	110	1	1.12	0.95;
	381	1	23.78	7.74	0	0	1	1.10927	-8.49297	110	1	1.12	0.95;
	382	1	25.81	8.44	0	0	1	1.11481	-8.84209	110	1	1.12	0.95;
	383	2	49.45	18.99	0	0	1	1.11054	-8.64265	110	1	1.12	0.95;
	384	2	30.41	12.76	0	0	1	1.11743	-8.67343	110	1	1.12	0.95;
	385	2	30.41	12.76	0	0	1	1.11752	-9.66341	110	1	1.12	0.95;
	386	1	0	0	0	0	1	1.11401	-8.87637	110	1	1.12	0.95;
	387	2	32.5	14.27	0	0	1	1.1113	-8.33583	110	1	1.12	0.95;
	388	2	13.89	6.13	0	0	1	1.11386	-8.86727	110	1	1.12	0.95;
	389	1	6.57	1	0	0	1	1.10279	-13.23027	110	1	1.12	0.95;
	390	1	8.49	0.9	0	0	1	1.10276	-13.24654	110	1	1.12	0.95;
	391	1	2.09	0	0	0	1	1.0927	-25.98099	110	1	1.12	0.95;
	392	1	4.67	0	0	0	1	1.0936	-25.56166	110	1	1.12	0.95;
	393	1	12.59	2.41	0	0	1	1.09642	-25.11172	110	1	1.12	0.95;
	394	1	15.53	4.02	0	0	1	1.09378	-25.55532	110	1	1.12	0.95;
	395	1	0	0	0	0	1	1.09381	-25.54147	110	1	1.12	0.95;
	396	1	9.14	2.41	0	0	1	1.10812	-21.44691	110	1	1.12	0.95;
	397	1	7.51	1.91	0	0	1	1.1081	-21.43392	110	1	1.12	0.95;
	398	1	14.23	4.62	0	0	1	1.10944	-8.52349	110	1	1.12	0.95;
	399	2	21.13	6.83	0	0	1	1.10799	-8.61176	110	1	1.12	0.95;
	400	1	17.79	1	0	0	1	1.09632	-28.84116	110	1	1.12	0.95;
	401	1	26.01	9.34	0	0	1	1.11242	-8.90154	110	1	1.12	0.95;
	402	1	17.38	6.23	0	0	1	1.10887	-8.75804	110	1	1.12	0.95;
	403	1	7.42	2.71	0	0	1	1.1102	-8.7993	110	1	1.12	0.95;
	404	1	10.46	0	0	0	1	1.09777	-28.55444	110	1	1.12	0.95;
	405	1	5.23	0	0	0	1	1.09774	-28.57828	110	1	1.12	0.95;
	406	1	10.66	1	0	0	1	1.09909	-24.97745	110	1	1.12	0.95;
	407	1	8.12	1	0	0	1	1.09905	-24.98763	110	1	1.12	0.95;
	408	1	17.88	5.83	0	0	1	1.11042	-8.77712	110	1	1.12	0.95;
	409	1	9.34	1.81	0	0	1	1.10041	-9.57755	110	1	1.12	0.95;
	410	1	5.18	0.4	0	0	1	1.09955	-9.66472	110	1	1.12	0.95;
	411	1	51.92	16.88	0	0	1	1.10502	-8.83637	110	1	1.12	0.95;
	412	1	11.98	2.41	0	0	1	1.07381	-20.21334	110	1	1.12	0.95;
	413	1	8.83	2.31	0	0	1	1.07381	-20.22655	110	1	1.12	0.95;
	414	1	2.34	0.9	0	0	1	1.09716	-25.11683	110	1	1.12	0.95;
	415	1	10.66	2.01	0	0	1	1.09717	-25.11594	110	1	1.12	0.95;
	416	1	0	0	0	0	1	1.10317	-9.97982	110	1	1.12	0.95;
	417	1	9.6	0.8	0	0	1	1.07811	-32.0508	110	1	1.12	0.95;
	418	1	17.58	5.73	0	0	1	1.11021	-9.57527	110	1	1.12	0.95;
	419	1	6.09	2.61	0	0	1	1.07354	-29.47436	110	1	1.12	0.95;
	420	1	6.9	2.01	0	0	1	1.07345	-29.47603	110	1	1.12	0.95;
	421	1	20.69	6.23	0	0	1	1.11646	-21.28062	110	1	1.12	0.95;
	422	1	20.69	6.23	0	0	1	1.10163	-22.33697	110	1	1.12	0.95;
	423	1	5.23	0	0	0	1	1.09642	-25.55662	110	1	1.12	0.95;
	424	1	1.22	0.2	0	0	1	1.0755	-24.20059	110	1	1.12	0.95;
	425	1	0	0	0	0	1	1.11639	-21.45858	110	1	1.12	0.95;
	426	1	0	0	0	0	1	1.10743	-20.67992	110	1	1.12	0.95;
	427	1	0	0	0	45	1	1.11498	-21.77627	16	1	1.25	0.75;
	428	1	0	0	0	0	1	0.99609	-17.61355	32	1	1.25	0.75;
	429	1	20.3	4.02	0	0	1	1.04984	-18.38193	110	1	1.12	0.95;
	430	1	22.33	4.02	0	0	1	1.0867	-22.49569	110	1	1.12	0.95;
	431	1	0	0	0	0	1	1.1166	-21.46282	110	1	1.12	0.95;
	432	1	6.28	0.5	0	0	1	1.06763	-37.49335	110	1	1.12	0.95;
	433	2	12.08	3.62	0	0	1	1.09946	-26.57919	110	1	1.12	0.95;
	434	1	15.16	0.8	0	0	1	1.07233	-31.51482	110	1	1.12	0.95;
	435	1	19.51	6.33	0	0	1	1.11146	-8.48963	110	1	1.12	0.95;
	436	1	15.54	2.61	0	0	1	1.10812	-22.00687	110	1	1.12	0.95;
	437	1	0	0	0	0	1	1.10971	-21.03804	110	1	1.12	0.95;
	438	1	7.85	0.5	0	0	1	1.09264	-28.96429	110	1	1.12	0.95;
	439	1	3.53	1.11	0	0	1	1.11167	-21.84875	110	1	1.12	0.95;
	440	1	0	0	0	0	1	1.11208	-21.47381	110	1	1.12	0.95;
	441	1	0	0	0	0	1	1.11207	-21.46844	110	1	1.12	0.95;
	442	1	0	0	0	15	1	0.99214	-22.58189	16	1	1.25	0.75;
	443	1	0	0	0	15	1	0.99431	-22.23735	16	1	1.25	0.75;
	444	1	10.66	3.01	0	0	1	1.07101	-24.70904	110	1	1.12	0.95;
	445	1	6.4	0.8	0	0	1	1.09648	-24.21165	110	1	1.12	0.95;
	446	1	3.55	0.5	0	0	1	1.09646	-24.20581	110	1	1.12	0.95;
	447	1	5.96	0.9	0	0	1	1.11833	-22.7489	110	1	1.12	0.95;
	448	1	6.17	0.9	0	0	1	1.11835	-22.75299	110	1	1.12	0.95;
	449	1	0	0	0	0	1	1.1135	-20.58702	110	1	1.12	0.95;
	450	1	0	0	0	0	1	1.11352	-20.5146	110	1	1.12	0.95;
	451	1	0	0	0	0	1	1.11345	-20.56195	110	1	1.12	0.95;
	452	1	0	0	0	0	1	0.9815	-21.30132	16	1	1.25	0.75;
	453	1	6.3	1.31	0	0	1	1.07493	-13.55774	110	1	1.12	0.95;
	454	1	8.93	1.51	0	0	1	1.11322	-26.54392	110	1	1.12	0.95;
	455	2	45.13	21.81	0	0	1	1.11245	-21.25549	110	1	1.12	0.95;
	456	2	32.5	15.68	0	0	1	1.11895	-21.84018	110	1	1.12	0.95;
	457	2	94.17	53.55	0	0	1	1.11707	-19.87229	110	1	1.12	0.95;
	458	2	77.9	45.62	0	0	1	1.11493	-20.45074	110	1	1.12	0.95;
	459	1	0	0	0	0	1	1.11324	-23.97698	110	1	1.12	0.95;
	460	1	0	0	0	0	1	1.11307	-24.01111	110	1	1.12	0.95;
	461	1	10.41	0.3	0	0	1	1.08947	-26.80247	110	1	1.12	0.95;
	462	1	14.25	1.21	0	0	1	1.08309	-28.24478	110	1	1.12	0.95;
	463	1	6.17	0.3	0	0	1	1.08308	-28.26109	110	1	1.12	0.95;
	464	1	3.66	0.3	0	0	1	1.07792	-33.59136	110	1	1.12	0.95;
	465	1	0	0	0	0	1	1.09476	-29.29305	110	1	1.12	0.95;
	466	1	11.67	2.01	0	0	1	1.09066	-25.81629	110	1	1.12	0.95;
	467	1	11.17	2.51	0	0	1	1.09066	-25.81704	110	1	1.12	0.95;
	468	1	6.6	1.11	0	0	1	1.0882	-10.89997	110	1	1.12	0.95;
	469	1	4.77	1.11	0	0	1	1.10353	-10.76078	110	1	1.12	0.95;
	470	1	15.7	1	0	0	1	1.07656	-35.66757	110	1	1.12	0.95;
	471	1	9.9	0.5	0	0	1	1.0742	-31.15026	110	1	1.12	0.95;
	472	1	7.21	0.9	0	0	1	1.07482	-13.01214	110	1	1.12	0.95;
	473	1	7.82	1.41	0	0	1	1.07492	-13.03123	110	1	1.12	0.95;
	474	1	7.61	2.51	0	0	1	1.09155	-25.84624	110	1	1.12	0.95;
	475	1	15.63	3.62	0	0	1	1.11452	-26.07161	110	1	1.12	0.95;
	476	1	11.78	2.61	0	0	1	1.11563	-26.15736	110	1	1.12	0.95;
	477	1	25.07	7.44	0	0	1	1.07801	-29.44179	110	1	1.12	0.95;
	478	2	-7.73	18	0	0	1	1.11867	-25.86398	110	1	1.12	0.95;
	479	2	13.61	11.34	0	0	1	1.10485	-27.89938	110	1	1.12	0.95;
	480	1	2.62	0.2	0	0	1	1.09236	-30.23172	110	1	1.12	0.95;
	481	1	18.68	5.63	0	0	1	1.10932	-22.02454	110	1	1.12	0.95;
	482	2	22.56	7.33	0	0	1	1.10618	-12.32236	110	1	1.12	0.95;
	483	1	18.27	5.63	0	0	1	1.10989	-22.20986	110	1	1.12	0.95;
	484	1	12.5	5.22	0	0	1	1.1131	-8.35197	110	1	1.12	0.95;
	485	1	5.39	2.21	0	0	1	1.11176	-8.42251	110	1	1.12	0.95;
	486	1	0	0	0	0	1	1.08384	-2.76103	110	1	1.12	0.95;
	487	1	0	0	0	0	1	1.08711	-0.85675	110	1	1.12	0.95;
	488	1	4.45	0.2	0	0	1	1.11617	-21.61684	110	1	1.12	0.95;
	489	1	2.84	1	0	0	1	1.0956	-28.08122	110	1	1.12	0.95;
	490	1	7.21	1	0	0	1	1.1023	-11.75773	110	1	1.12	0.95;
	491	1	8.59	0.8	0	0	1	1.12	-22.70116	110	1	1.12	0.95;
	492	1	5.36	0.2	0	0	1	1.12	-21.036	110	1	1.12	0.95;
	493	1	0	0	0	0	1	1.11534	-21.41923	110	1	1.12	0.95;
	494	1	0	0	0	0	1	1.11506	-23.35769	110	1	1.12	0.95;
	495	1	5.55	1.21	0	0	1	1.0928	-24.16946	110	1	1.12	0.95;
	496	1	5.55	1.21	0	0	1	1.09285	-24.18824	110	1	1.12	0.95;
	497	1	4.98	0.6	0	0	1	1.07716	-13.69774	110	1	1.12	0.95;
	498	1	16.24	4.02	0	0	1	1.11846	-21.39756	110	1	1.12	0.95;
	499	1	38.78	8.04	0	0	1	1.11421	-20.69035	110	1	1.12	0.95;
	500	2	12.19	1.31	0	0	1	1.09306	-5.44157	110	1	1.12	0.95;
	501	1	10.36	1.11	0	0	1	1.09739	-3.76618	110	1	1.12	0.95;
	502	1	14.13	0	0	0	1	1.08435	-33.00907	110	1	1.12	0.95;
	503	1	12.39	1.51	0	0	1	1.09164	-5.24324	110	1	1.12	0.95;
	504	1	15.26	1	0	0	1	1.11868	-22.78679	110	1	1.12	0.95;
	505	1	12.89	2.21	0	0	1	1.06713	-17.1444	110	1	1.12	0.95;
	506	1	3.03	0.3	0	0	1	1.11501	-23.35699	110	1	1.12	0.95;
	507	1	0	0	0	0	1	1.11496	-23.37102	110	1	1.12	0.95;
	508	1	4.19	0	0	0	1	1.08581	-28.25931	110	1	1.12	0.95;
	509	1	0	0	0	0	1	1.12	-20.58167	110	1	1.12	0.95;
	510	1	0	0	0	0	1	1.11907	-22.45181	110	1	1.12	0.95;
	511	1	0	0	0	0	1	0.99141	-18.54864	32	1	1.25	0.75;
	512	1	25.29	3.22	0	0	1	1.09404	-3.59546	110	1	1.12	0.95;
	513	1	7.21	1.61	0	0	1	1.0907	-25.85667	110	1	1.12	0.95;
	514	1	9.1	1	0	0	1	1.11932	-22.75231	110	1	1.12	0.95;
	515	1	11.22	0.7	0	0	1	1.09611	-24.77094	110	1	1.12	0.95;
	516	1	11.02	1.11	0	0	1	1.09612	-24.75943	110	1	1.12	0.95;
	517	1	7.11	1	0	0	1	1.10287	-11.71836	110	1	1.12	0.95;
	518	1	9.44	5.02	0	0	1	1.11211	-26.16106	110	1	1.12	0.95;
	519	1	21.19	6.93	0	0	1	1.10433	-22.40603	110	1	1.12	0.95;
	520	1	21.19	6.93	0	0	1	1.10425	-22.41791	110	1	1.12	0.95;
	521	1	16.24	2.01	0	0	1	1.09839	-23.378	110	1	1.12	0.95;
	522	2	9.14	2.01	0	0	1	1.10119	-22.82512	110	1	1.12	0.95;
	523	1	18.68	3.62	0	0	1	1.08343	-29.18755	110	1	1.12	0.95;
	524	1	12.03	0.6	0	0	1	1.09557	-26.55654	110	1	1.12	0.95;
	525	1	22.74	4.62	0	0	1	1.07686	-24.06816	110	1	1.12	0.95;
	526	1	15.84	4.02	0	0	1	1.10344	-22.43675	110	1	1.12	0.95;
	527	2	15.75	5.63	0	0	1	1.11076	-8.56916	110	1	1.12	0.95;
	528	1	0	0	0	0	1	1.11077	-8.5692	110	1	1.12	0.95;
	529	1	12.39	1.41	0	0	1	1.05895	-3.84174	110	1	1.12	0.95;
	530	1	7.78	0.1	0	0	1	1.11714	-23.06827	110	1	1.12	0.95;
	531	1	16.45	1.61	0	0	1	1.08468	-12.97277	110	1	1.12	0.95;
	532	2	13.84	4.12	0	0	1	1.10157	-24.88004	110	1	1.12	0.95;
	533	1	11.93	3.62	0	0	1	1.10154	-24.86032	110	1	1.12	0.95;
	534	1	9.45	3.11	0	0	1	1.11329	-8.90206	110	1	1.12	0.95;
	535	1	6.09	3.22	0	0	1	1.05984	-25.24174	110	1	1.12	0.95;
	536	1	7.11	2.31	0	0	1	1.07244	-29.77812	110	1	1.12	0.95;
	537	1	10.87	2.61	0	0	1	1.0598	-3.79577	110	1	1.12	0.95;
	538	1	11.37	2.81	0	0	1	1.05977	-3.80045	110	1	1.12	0.95;
	539	1	0	0	0	0	1	1.09657	-7.7072	110	1	1.12	0.95;
	540	1	13.08	0	0	0	1	1.05986	-37.33915	110	1	1.12	0.95;
	541	1	4.16	1	0	0	1	1.08618	-0.67589	110	1	1.12	0.95;
	542	1	3.66	0.8	0	0	1	1.08611	-0.68928	110	1	1.12	0.95;
	543	2	4.87	1	0	0	1	1.06077	-3.71465	110	1	1.12	0.95;
	544	1	5.18	1	0	0	1	1.08601	-5.2078	110	1	1.12	0.95;
	545	1	9.14	3.32	0	0	1	1.11062	-8.5832	110	1	1.12	0.95;
	546	1	19.51	6.33	0	0	1	1.11042	-9.34274	110	1	1.12	0.95;
	547	1	8.94	1	0	0	1	1.09632	-7.50962	110	1	1.12	0.95;
	548	1	8.94	1	0	0	1	1.08547	-14.14671	110	1	1.12	0.95;
	549	1	0.81	0.3	0	0	1	1.06116	-25.98195	110	1	1.12	0.95;
	550	1	7.21	1	0	0	1	1.0961	-10.67652	110	1	1.12	0.95;
	551	1	8.12	1.31	0	0	1	1.05945	-26.24579	110	1	1.12	0.95;
	552	1	8.73	1.31	0	0	1	1.05941	-26.22045	110	1	1.12	0.95;
	553	1	12.18	1.71	0	0	1	1.05995	-25.71758	110	1	1.12	0.95;
	554	1	11.06	1.31	0	0	1	1.06162	-25.09629	110	1	1.12	0.95;
	555	1	11.67	2.01	0	0	1	1.06161	-25.0676	110	1	1.12	0.95;
	556	1	5.76	0	0	0	1	1.05774	-37.6437	110	1	1.12	0.95;
	557	1	7.71	1.61	0	0	1	1.09418	-26.1329	110	1	1.12	0.95;
	558	1	36.75	8.44	0	0	1	1.11228	-21.89989	110	1	1.12	0.95;
	559	1	2.23	0.5	0	0	1	1.10196	-5.89843	110	1	1.12	0.95;
	560	1	17.06	0.6	0	0	1	1.06413	-13.90507	110	1	1.12	0.95;
	561	1	11.37	0.8	0	0	1	1.06407	-13.91749	110	1	1.12	0.95;
	562	1	9.42	0.5	0	0	1	1.07481	-30.2491	110	1	1.12	0.95;
	563	1	7.32	0.5	0	0	1	1.07489	-30.26861	110	1	1.12	0.95;
	564	1	19.49	4.72	0	0	1	1.10509	-20.99867	110	1	1.12	0.95;
	565	1	10.11	1.41	0	0	1	1.10066	-25.18708	110	1	1.12	0.95;
	566	1	12.13	0.6	0	0	1	1.09407	-14.79478	110	1	1.12	0.95;
	567	1	18.84	2.01	0	0	1	1.05369	-27.6686	110	1	1.12	0.95;
	568	1	0	0	0	0	1	1.0665	-25.29114	110	1	1.12	0.95;
	569	1	13.7	4.52	0	0	1	1.11034	-14.34285	110	1	1.12	0.95;
	570	1	18.69	3.52	0	0	1	1.11988	-23.42521	110	1	1.12	0.95;
	571	1	11.37	1.81	0	0	1	1.12	-23.40645	110	1	1.12	0.95;
	572	2	10.15	2.01	0	0	1	1.05365	-28.23614	110	1	1.12	0.95;
	573	1	10.46	2.51	0	0	1	1.0537	-28.24846	110	1	1.12	0.95;
	574	1	23.36	3.52	0	0	1	1.08106	-10.52407	110	1	1.12	0.95;
	575	1	11.32	0.4	0	0	1	1.10253	-23.92372	110	1	1.12	0.95;
	576	1	13.62	4.42	0	0	1	1.111	-8.71953	110	1	1.12	0.95;
	577	1	0	0	0	0	1	1.08763	-17.86715	110	1	1.12	0.95;
	578	1	8.83	1.31	0	0	1	1.08758	-17.88842	110	1	1.12	0.95;
	579	1	8.64	2.81	0	0	1	1.10499	-9.78761	110	1	1.12	0.95;
	580	1	5.15	0.5	0	0	1	1.10777	-22.89432	110	1	1.12	0.95;
	581	1	3.45	0.5	0	0	1	1.09343	-4.29496	110	1	1.12	0.95;
	582	1	0	0	0	0	1	1.06655	-35.70157	110	1	1.12	0.95;
	583	1	0	0	0	0	1	1.06655	-35.68838	110	1	1.12	0.95;
	584	1	20.93	1.51	0	0	1	1.06032	-37.10518	110	1	1.12	0.95;
	585	1	1.42	0	0	0	1	1.04975	-18.4402	110	1	1.12	0.95;
	586	1	0.81	0.2	0	0	1	1.09574	-21.67892	110	1	1.12	0.95;
	587	1	15.7	1	0	0	1	1.09222	-34.1112	110	1	1.12	0.95;
	588	1	5.96	0.3	0	0	1	1.11634	-22.70434	110	1	1.12	0.95;
	589	1	4.06	1	0	0	1	1.07941	-13.63373	110	1	1.12	0.95;
	590	1	19.79	6.03	0	0	1	1.102	-22.82528	110	1	1.12	0.95;
	591	1	20.63	6.73	0	0	1	1.11793	-10.0605	110	1	1.12	0.95;
	592	1	6.5	1.11	0	0	1	1.11031	-23.89013	110	1	1.12	0.95;
	593	1	6.5	1.11	0	0	1	1.1104	-23.87954	110	1	1.12	0.95;
	594	1	5.15	0.4	0	0	1	1.07808	-31.64824	110	1	1.12	0.95;
	595	1	6.6	1	0	0	1	1.04689	-25.88235	110	1	1.12	0.95;
	596	1	7	1	0	0	1	1.04682	-25.88906	110	1	1.12	0.95;
	597	2	11.78	1	0	0	1	1.08723	-5.12045	110	1	1.12	0.95;
	598	1	7.82	1.21	0	0	1	1.07827	-9.83735	110	1	1.12	0.95;
	599	1	10.36	2.01	0	0	1	1.08535	-5.2639	110	1	1.12	0.95;
	600	1	9.65	1.11	0	0	1	1.07711	-9.94819	110	1	1.12	0.95;
	601	1	0	0	0	0	1	1.10394	-5.2008	110	1	1.12	0.95;
	602	1	0	0	0	0	1	1.10027	-5.11503	110	1	1.12	0.95;
	603	2	2.02	0.6	0	0	1	1.11189	-21.85077	110	1	1.12	0.95;
	604	1	0	0	0	0	1	1.1119	-21.85156	110	1	1.12	0.95;
	605	1	8.58	2.61	0	0	1	1.11067	-21.53484	110	1	1.12	0.95;
	606	1	0	0	0	0	1	1.11079	-21.52664	110	1	1.12	0.95;
	607	1	0	0	0	0	1	1.09929	-26.08096	110	1	1.12	0.95;
	608	1	8.37	0.1	0	0	1	1.10468	-24.42472	110	1	1.12	0.95;
	609	1	29.27	6.43	0	0	1	1.10578	-22.13255	110	1	1.12	0.95;
	610	1	29.27	8.74	0	0	1	1.10583	-22.11542	110	1	1.12	0.95;
	611	1	20.39	5.12	0	0	1	1.1077	-21.66706	110	1	1.12	0.95;
	612	1	20.39	5.12	0	0	1	1.10756	-21.69387	110	1	1.12	0.95;
	613	1	0	0	0	0	1	1.10932	-21.40634	110	1	1.12	0.95;
	614	1	14.13	3.22	0	0	1	1.10932	-21.40634	110	1	1.12	0.95;
	615	1	20.18	5.02	0	0	1	1.10696	-23.12049	110	1	1.12	0.95;
	616	1	20.18	5.02	0	0	1	1.10716	-23.10469	110	1	1.12	0.95;
	617	1	2.03	1	0	0	1	1.09399	-25.52262	110	1	1.12	0.95;
	618	1	10.36	3.01	0	0	1	1.06337	-13.99285	110	1	1.12	0.95;
	619	1	11.78	2.01	0	0	1	1.05625	-29.29575	110	1	1.12	0.95;
	620	1	4.54	1.41	0	0	1	1.11036	-21.89423	110	1	1.12	0.95;
	621	1	4.54	1.41	0	0	1	1.11049	-21.88581	110	1	1.12	0.95;
	622	1	18.17	5.63	0	0	1	1.10561	-22.02831	110	1	1.12	0.95;
	623	1	18.17	5.83	0	0	1	1.10561	-22.03969	110	1	1.12	0.95;
	624	1	16.65	5.12	0	0	1	1.11166	-22.72982	110	1	1.12	0.95;
	625	1	16.65	5.12	0	0	1	1.10546	-22.26791	110	1	1.12	0.95;
	626	1	13.12	3.92	0	0	1	1.10709	-21.80951	110	1	1.12	0.95;
	627	1	13.12	3.92	0	0	1	1.107	-21.83261	110	1	1.12	0.95;
	628	1	7.32	0.1	0	0	1	1.06841	-37.52111	110	1	1.12	0.95;
	629	1	25.23	7.54	0	0	1	1.10865	-21.91491	110	1	1.12	0.95;
	630	1	37.34	11.15	0	0	1	1.10982	-21.00877	110	1	1.12	0.95;
	631	1	0.81	0.2	0	0	1	1.09935	-5.75557	110	1	1.12	0.95;
	632	1	3.15	0.7	0	0	1	1.09938	-5.76729	110	1	1.12	0.95;
	633	1	26.01	9.34	0	0	1	1.11166	-9.05132	110	1	1.12	0.95;
	634	1	1.32	0.2	0	0	1	1.09423	-25.68265	110	1	1.12	0.95;
	635	1	4.04	0.8	0	0	1	1.1119	-21.60699	110	1	1.12	0.95;
	636	1	4.04	0.8	0	0	1	1.11196	-21.59898	110	1	1.12	0.95;
	637	1	4.19	0	0	0	1	1.09902	-27.6085	110	1	1.12	0.95;
	638	1	14.13	3.52	0	0	1	1.10563	-22.39886	110	1	1.12	0.95;
	639	1	14.13	3.52	0	0	1	1.11118	-21.55175	110	1	1.12	0.95;
	640	1	7.06	2.11	0	0	1	1.10055	-23.35128	110	1	1.12	0.95;
	641	1	7.06	2.11	0	0	1	1.09676	-22.40812	110	1	1.12	0.95;
	642	1	17.66	4.42	0	0	1	1.10943	-21.38619	110	1	1.12	0.95;
	643	1	17.66	4.42	0	0	1	1.10944	-21.4206	110	1	1.12	0.95;
	644	1	16.15	4.52	0	0	1	1.10609	-22.34901	110	1	1.12	0.95;
	645	1	16.15	4.52	0	0	1	1.10602	-22.36046	110	1	1.12	0.95;
	646	1	10.15	1.71	0	0	1	1.06239	-25.13287	110	1	1.12	0.95;
	647	1	10.25	1.61	0	0	1	1.06223	-25.15475	110	1	1.12	0.95;
	648	1	15.03	1.81	0	0	1	1.08329	-7.56075	110	1	1.12	0.95;
	649	1	10.36	1.31	0	0	1	1.08334	-7.57869	110	1	1.12	0.95;
	650	1	23.21	6.93	0	0	1	1.11184	-22.75451	110	1	1.12	0.95;
	651	1	23.21	6.93	0	0	1	1.11192	-22.74205	110	1	1.12	0.95;
	652	1	14.63	3.32	0	0	1	1.1118	-22.73084	110	1	1.12	0.95;
	653	1	14.63	3.32	0	0	1	1.1119	-22.72558	110	1	1.12	0.95;
	654	1	14.63	3.82	0	0	1	1.11346	-20.88655	110	1	1.12	0.95;
	655	1	14.63	3.82	0	0	1	1.11343	-20.88751	110	1	1.12	0.95;
	656	1	29.27	9.34	0	0	1	1.10812	-21.93651	110	1	1.12	0.95;
	657	1	29.27	9.34	0	0	1	1.10813	-21.92899	110	1	1.12	0.95;
	658	1	11.1	3.32	0	0	1	1.10035	-23.13994	110	1	1.12	0.95;
	659	1	11.1	3.32	0	0	1	1.10042	-23.11961	110	1	1.12	0.95;
	660	1	2.03	0.5	0	0	1	1.08562	-7.39669	110	1	1.12	0.95;
	661	1	7.11	1.41	0	0	1	1.0589	-25.33909	110	1	1.12	0.95;
	662	1	7.11	1.41	0	0	1	1.0588	-25.35143	110	1	1.12	0.95;
	663	1	10.09	2.51	0	0	1	1.11176	-22.76625	110	1	1.12	0.95;
	664	1	10.09	2.51	0	0	1	1.10415	-22.43518	110	1	1.12	0.95;
	665	1	30.78	9.24	0	0	1	1.10993	-21.75753	110	1	1.12	0.95;
	666	1	30.78	9.24	0	0	1	1.10717	-21.70448	110	1	1.12	0.95;
	667	1	26.24	8.64	0	0	1	1.10733	-21.66598	110	1	1.12	0.95;
	668	1	26.24	8.64	0	0	1	1.10741	-21.65087	110	1	1.12	0.95;
	669	1	5.86	0.6	0	0	1	1.11762	-22.89683	110	1	1.12	0.95;
	670	2	53.29	50.64	0	0	1	1.11956	-20.97845	110	1	1.12	0.95;
	671	2	55.3	52.65	0	0	1	1.12	-20.55445	110	1	1.12	0.95;
	672	1	16.15	5.02	0	0	1	1.11891	-20.62601	110	1	1.12	0.95;
	673	1	18.17	5.63	0	0	1	1.11833	-21.05906	110	1	1.12	0.95;
	674	1	15.14	4.42	0	0	1	1.11039	-22.69626	110	1	1.12	0.95;
	675	1	15.14	4.42	0	0	1	1.11029	-22.6886	110	1	1.12	0.95;
	676	1	25.23	8.84	0	0	1	1.10727	-21.75286	110	1	1.12	0.95;
	677	1	25.23	8.84	0	0	1	1.10728	-21.74318	110	1	1.12	0.95;
	678	1	19.18	5.53	0	0	1	1.1137	-21.43943	110	1	1.12	0.95;
	679	1	19.18	5.53	0	0	1	1.11388	-21.40897	110	1	1.12	0.95;
	680	1	26.74	6.63	0	0	1	1.10196	-22.33808	110	1	1.12	0.95;
	681	1	26.74	6.63	0	0	1	1.10173	-22.35202	110	1	1.12	0.95;
	682	1	25.23	7.54	0	0	1	1.11233	-22.69223	110	1	1.12	0.95;
	683	1	25.23	7.54	0	0	1	1.1076	-21.75499	110	1	1.12	0.95;
	684	1	8.07	2.41	0	0	1	1.10943	-21.87098	110	1	1.12	0.95;
	685	1	8.07	2.41	0	0	1	1.10954	-21.87064	110	1	1.12	0.95;
	686	1	22.2	5.53	0	0	1	1.10923	-21.58489	110	1	1.12	0.95;
	687	1	22.2	5.53	0	0	1	1.10919	-21.58157	110	1	1.12	0.95;
	688	1	22.2	6.63	0	0	1	1.11274	-21.52199	110	1	1.12	0.95;
	689	1	22.2	6.63	0	0	1	1.11262	-21.53978	110	1	1.12	0.95;
	690	1	12.11	3.01	0	0	1	1.1103	-22.18323	110	1	1.12	0.95;
	691	1	12.11	3.01	0	0	1	1.11027	-22.16534	110	1	1.12	0.95;
	692	2	48.44	15.47	0	0	1	1.09872	-23.35898	110	1	1.12	0.95;
	693	1	9.08	2.91	0	0	1	1.10577	-22.06071	110	1	1.12	0.95;
	694	2	15.94	4.02	0	0	1	1.08197	-29.21921	110	1	1.12	0.95;
	695	1	5.76	0.5	0	0	1	1.08171	-35.73711	110	1	1.12	0.95;
	696	1	18.31	1.51	0	0	1	1.08741	-28.75188	110	1	1.12	0.95;
	697	1	5.18	0	0	0	1	1.07972	-29.34716	110	1	1.12	0.95;
	698	1	0	0	0	0	1	1.07968	-29.35127	110	1	1.12	0.95;
	699	1	0	0	0	0	1	1.03708	-26.12134	110	1	1.12	0.95;
	700	2	24.09	12.86	0	0	1	1.11463	-22.69045	110	1	1.12	0.95;
	701	2	45.19	32.65	0	0	1	1.11138	-21.84607	110	1	1.12	0.95;
	702	2	14.07	13.06	0	0	1	1.11468	-22.65396	110	1	1.12	0.95;
	703	1	0	0	0	0	1	1.08109	-28.77104	110	1	1.12	0.95;
	704	1	0	0	0	0	1	1.11162	-9.68159	110	1	1.12	0.95;
	705	1	0	0	0	0	1	1.11455	-26.0701	110	1	1.12	0.95;
	706	1	0	0	0	0	1	1.11564	-26.15654	110	1	1.12	0.95;
	707	1	0	0	0	0	1	1.09639	-32.36815	110	1	1.12	0.95;
	708	1	0	0	0	0	1	1.11648	-21.30155	110	1	1.12	0.95;
	709	1	0	0	0	0	1	1.10865	-22.32118	110	1	1.12	0.95;
	710	1	0	0	0	0	1	1.10202	-25.02695	110	1	1.12	0.95;
	711	1	0	0	0	0	1	1.1104	-8.77322	110	1	1.12	0.95;
	712	1	0	0	0	0	1	1.11654	-21.27512	110	1	1.12	0.95;
	713	1	0	0	0	0	1	1.10172	-22.33132	110	1	1.12	0.95;
	714	1	0	0	0	0	1	1.07555	-24.19726	110	1	1.12	0.95;
	715	1	0	0	0	0	1	1.10877	-21.95119	110	1	1.12	0.95;
	716	1	0	0	0	0	1	1.1097	-21.03794	110	1	1.12	0.95;
	717	1	0	0	0	0	1	1.0613	-3.66032	110	1	1.12	0.95;
	718	1	0	0	0	0	1	1.11067	-8.57952	110	1	1.12	0.95;
	719	1	0	0	0	0	1	1.08629	-0.55494	110	1	1.12	0.95;
	720	1	0	0	0	0	1	1.0612	-25.98041	110	1	1.12	0.95;
	721	1	0	0	0	0	1	1.0665	-25.29114	110	1	1.12	0.95;
	722	1	0	0	0	0	1	1.10788	-22.88028	110	1	1.12	0.95;
	723	1	0	0	0	0	1	1.09376	-4.25393	110	1	1.12	0.95;
	724	1	0	0	0	0	1	1.09929	-26.08096	110	1	1.12	0.95;
	725	1	0	0	0	0	1	1.08526	-23.36466	110	1	1.12	0.95;
	726	1	0	0	0	0	1	1.11347	-8.88814	110	1	1.12	0.95;
	727	1	0	0	0	0	1	1.11692	-8.70785	110	1	1.12	0.95;
	728	1	12.89	2.51	0	0	1	1.11226	-21.90887	110	1	1.12	0.95;
	729	1	10.15	2.01	0	0	1	1.09987	-23.4175	110	1	1.12	0.95;
	730	1	10.86	1.41	0	0	1	1.08487	-23.41286	110	1	1.12	0.95;
	731	1	6.9	0.3	0	0	1	1.10578	-27.12989	110	1	1.12	0.95;
	732	1	9.42	0.6	0	0	1	1.08916	-29.05207	110	1	1.12	0.95;
	733	1	10.46	1	0	0	1	1.08921	-29.05079	110	1	1.12	0.95;
	734	1	5.69	1	0	0	1	1.08043	-9.06083	110	1	1.12	0.95;
	735	2	7.21	1.31	0	0	1	1.0952	-10.05171	110	1	1.12	0.95;
	736	1	7.21	1.31	0	0	1	1.09535	-10.05951	110	1	1.12	0.95;
	737	1	13.41	5.63	0	0	1	1.11554	-8.95113	110	1	1.12	0.95;
	738	1	5.79	2.41	0	0	1	1.12	-10.31834	110	1	1.12	0.95;
	739	1	0.61	0.2	0	0	1	1.08881	-0.67165	110	1	1.12	0.95;
	740	1	8.33	0.6	0	0	1	1.08868	-10.34024	110	1	1.12	0.95;
	741	1	3.15	0.7	0	0	1	1.07624	-3.6009	110	1	1.12	0.95;
	742	1	3.76	0.8	0	0	1	1.07625	-3.59964	110	1	1.12	0.95;
	743	1	0	0	0	0	1	1.1113	-8.57755	110	1	1.12	0.95;
	744	1	4.54	1.41	0	0	1	1.1076	-22.20683	110	1	1.12	0.95;
	745	1	0	0	0	0	1	1.10748	-22.22434	110	1	1.12	0.95;
	746	1	0.4	0.1	0	0	1	1.1087	-21.82404	110	1	1.12	0.95;
	747	1	0	0	0	0	1	1.10876	-21.85166	110	1	1.12	0.95;
	748	1	8.33	2.41	0	0	1	1.08388	-13.5802	110	1	1.12	0.95;
	749	1	13.64	0.5	0	0	1	1.08468	-28.18713	110	1	1.12	0.95;
	750	1	9.14	3.01	0	0	1	1.11684	-8.71406	110	1	1.12	0.95;
	751	1	7.11	2.01	0	0	1	1.05469	-29.16845	110	1	1.12	0.95;
	752	2	14.9	2.31	0	0	1	1.09731	-25.26461	110	1	1.12	0.95;
	753	1	10.36	1.51	0	0	1	1.09664	-24.41029	110	1	1.12	0.95;
	754	1	6.2	0.6	0	0	1	1.0966	-24.40938	110	1	1.12	0.95;
	755	1	0	0	0	0	1	1.11233	-14.23434	110	2	1.12	0.95;
	756	1	10.28	0.22	0	0	1	1.11233	-14.22901	110	2	1.12	0.95;
	757	1	3.77	-0.8	0	0	1	1.09117	-14.3704	110	2	1.12	0.95;
	758	1	8.5	0.9	0	0	1	1.10116	-15.73552	110	2	1.12	0.95;
	759	1	11.94	0.8	0	0	1	1.08908	-14.93788	110	2	1.12	0.95;
	760	1	8.64	1	0	0	1	1.09894	-15.49167	110	2	1.12	0.95;
	761	1	22.91	8.04	0	0	1	1.09617	-13.71927	110	2	1.12	0.95;
	762	1	0	0	0	0	1	1.09616	-13.7245	110	2	1.12	0.95;
	763	1	21.52	4.02	0	0	1	1.09874	-16.03872	110	2	1.12	0.95;
	764	1	10.76	1	0	0	1	1.09628	-14.58675	110	2	1.12	0.95;
	765	1	5.81	1.31	0	0	1	1.06798	-14.27619	110	2	1.12	0.95;
	766	2	20.12	2.81	0	0	1	1.09745	-14.44931	110	2	1.12	0.95;
	767	1	6.78	1.11	0	0	1	1.09655	-14.57814	110	2	1.12	0.95;
	768	1	7.53	0	0	0	1	1.08342	-14.32146	110	2	1.12	0.95;
	769	1	2.77	0	0	0	1	1.08335	-14.32507	110	2	1.12	0.95;
	770	1	10.11	1.11	0	0	1	1.05137	-23.94645	110	2	1.12	0.95;
	771	1	0	0	0	0	1	1.05142	-23.95216	110	2	1.12	0.95;
	772	1	15.92	1.11	0	0	1	1.0505	-23.84319	110	2	1.12	0.95;
	773	1	3.76	0.3	0	0	1	1.08559	-15.95323	110	2	1.12	0.95;
	774	1	3.44	0	0	0	1	1.08434	-16.2975	110	2	1.12	0.95;
	775	2	23.8	1.71	0	0	1	1.09432	-15.83936	110	2	1.12	0.95;
	776	1	0	0	0	0	1	1.09437	-15.83323	110	2	1.12	0.95;
	777	1	12.91	1	0	0	1	1.09733	-11.31239	110	2	1.12	0.95;
	778	1	6.45	0	0	0	1	1.09837	-11.29904	110	2	1.12	0.95;
	779	1	9.97	2.21	0	0	1	1.10217	-15.17302	110	2	1.12	0.95;
	780	1	11.62	0.6	0	0	1	1.08821	-15.00564	110	2	1.12	0.95;
	781	1	0	0	0	0	1	1.09369	-16.54066	110	2	1.12	0.95;
	782	1	11.83	1.51	0	0	1	1.09371	-16.53974	110	2	1.12	0.95;
	783	1	13.99	4.02	0	0	1	1.0934	-16.55532	110	2	1.12	0.95;
	784	1	9.47	0.4	0	0	1	1.09521	-16.52262	110	2	1.12	0.95;
	785	1	0	0	0	0	1	1.10515	-12.01623	110	2	1.12	0.95;
	786	1	0	0	0	0	1	1.1051	-12.017	110	2	1.12	0.95;
	787	1	9.04	0	0	0	1	1.09532	-16.52768	110	2	1.12	0.95;
	788	1	8.61	1.51	0	0	1	1.09157	-13.90702	110	2	1.12	0.95;
	789	1	0	0	0	0	1	1.09641	-16.36203	110	2	1.12	0.95;
	790	1	0	0	0	0	1	1.09636	-16.38251	110	2	1.12	0.95;
	791	1	7.53	0.5	0	0	1	1.09479	-11.90942	110	2	1.12	0.95;
	792	1	9.79	1	0	0	1	1.09478	-16.5767	110	2	1.12	0.95;
	793	1	12.97	0.6	0	0	1	1.08691	-16.28527	110	2	1.12	0.95;
	794	1	4.3	0	0	0	1	1.10246	-14.32193	110	2	1.12	0.95;
	795	1	3.23	0.5	0	0	1	1.07731	-13.42535	110	2	1.12	0.95;
	796	1	8.71	1.71	0	0	1	1.09264	-14.43293	110	2	1.12	0.95;
	797	1	4.3	0.5	0	0	1	1.09884	-10.18895	110	2	1.12	0.95;
	798	2	6.13	17.08	0	0	1	1.11549	-12.02448	110	2	1.12	0.95;
	799	1	6.56	1.21	0	0	1	1.09141	-14.20951	110	2	1.12	0.95;
	800	1	35.5	8.04	0	0	1	1.09851	-19.24562	110	2	1.12	0.95;
	801	2	3.12	0.6	0	0	1	1.06826	-15.14378	110	2	1.12	0.95;
	802	1	0	0	0	0	1	1.06677	-14.81439	110	2	1.12	0.95;
	803	1	4.3	1	0	0	1	1.10692	-10.77173	110	2	1.12	0.95;
	804	1	7.1	1.99	0	0	1	1.10694	-14.90899	110	2	1.12	0.95;
	805	1	10.76	2.51	0	0	1	1.09242	-14.11984	110	2	1.12	0.95;
	806	1	7.32	2.41	0	0	1	1.10996	-10.57757	110	2	1.12	0.95;
	807	1	11.51	-1.91	0	0	1	1.07072	-15.32937	110	2	1.12	0.95;
	808	2	11.4	2.91	0	0	1	1.09831	-15.46461	110	2	1.12	0.95;
	809	2	19.04	2.81	0	0	1	1.09858	-15.44595	110	2	1.12	0.95;
	810	1	9.57	2.71	0	0	1	1.11413	-12.17435	110	2	1.12	0.95;
	811	1	29.15	14.97	0	0	1	1.10019	-14.20825	110	2	1.12	0.95;
	812	1	13.88	5.33	0	0	1	1.09903	-14.28187	110	2	1.12	0.95;
	813	1	17.21	7.64	0	0	1	1.11377	-12.19445	110	2	1.12	0.95;
	814	1	14.74	8.84	0	0	1	1.0927	-13.87025	110	2	1.12	0.95;
	815	1	0.22	0	0	0	1	1.08815	-14.65039	110	2	1.12	0.95;
	816	1	7.61	0.9	0	0	1	1.05237	-24.19531	110	2	1.12	0.95;
	817	1	5.92	1.31	0	0	1	1.08758	-14.87971	110	2	1.12	0.95;
	818	1	6.45	1	0	0	1	1.09246	-14.20015	110	2	1.12	0.95;
	819	1	11.73	0.1	0	0	1	1.10193	-14.71825	110	2	1.12	0.95;
	820	1	12.91	0	0	0	1	1.08071	-16.92293	110	2	1.12	0.95;
	821	1	4.84	0	0	0	1	1.08777	-11.0974	110	2	1.12	0.95;
	822	1	9.68	0.5	0	0	1	1.0885	-11.33603	110	2	1.12	0.95;
	823	1	2.47	0.4	0	0	1	1.07774	-15.397	110	2	1.12	0.95;
	824	1	8.61	1	0	0	1	1.09435	-14.86859	110	2	1.12	0.95;
	825	1	3.44	1.11	0	0	1	1.05306	-23.86861	110	2	1.12	0.95;
	826	1	5.38	0.2	0	0	1	1.08546	-16.19645	110	2	1.12	0.95;
	827	1	5.59	0	0	0	1	1.10134	-14.94335	110	2	1.12	0.95;
	828	1	0.86	0	0	0	1	1.1064	-12.10971	110	2	1.12	0.95;
	829	1	4.02	0.99	0	0	1	1.08285	-16.60165	110	2	1.12	0.95;
	830	1	1.08	0	0	0	1	1.09248	-12.87152	110	2	1.12	0.95;
	831	1	13.77	2.21	0	0	1	1.10146	-12.45877	110	2	1.12	0.95;
	832	1	0	0	0	0	1	1.12	-13.23249	110	2	1.12	0.95;
	833	1	6.71	0.1	0	0	1	1.08532	-18.45881	110	2	1.12	0.95;
	834	1	3.23	1	0	0	1	1.09204	-13.16595	110	2	1.12	0.95;
	835	1	9.04	2.41	0	0	1	1.0941	-15.85684	110	2	1.12	0.95;
	836	1	0.92	0	0	0	1	1.09311	-13.1228	110	2	1.12	0.95;
	837	1	37.65	4.52	0	0	1	1.09042	-13.1076	110	2	1.12	0.95;
	838	1	22.59	1.51	0	0	1	1.09067	-13.2143	110	2	1.12	0.95;
	839	1	16.14	1.51	0	0	1	1.09059	-13.39063	110	2	1.12	0.95;
	840	1	0.92	0	0	0	1	1.09311	-13.12298	110	2	1.12	0.95;
	841	1	1.08	0	0	0	1	1.09906	-10.88377	110	2	1.12	0.95;
	842	1	5.7	-2.31	0	0	1	1.10252	-12.50072	110	2	1.12	0.95;
	843	1	4.82	1.26	0	0	1	1.08498	-16.46804	110	2	1.12	0.95;
	844	1	6.6	2.25	0	0	1	1.10258	-14.81488	110	2	1.12	0.95;
	845	1	3.23	0.5	0	0	1	1.09126	-14.07393	110	2	1.12	0.95;
	846	2	13.06	30.14	0	0	1	1.12	-13.23249	110	2	1.12	0.95;
	847	2	13.06	30.14	0	0	1	1.12	-13.24036	110	2	1.12	0.95;
	848	1	5.92	0.5	0	0	1	1.09058	-13.277	110	2	1.12	0.95;
	849	1	37.65	1	0	0	1	1.09313	-13.11989	110	2	1.12	0.95;
	850	1	6.56	1.41	0	0	1	1.0783	-15.36808	110	2	1.12	0.95;
	851	1	0	0	0	0	1	1.08874	-14.76128	110	2	1.12	0.95;
	852	1	0	0	0	0	1	1.08876	-14.76704	110	2	1.12	0.95;
	853	1	12.26	1.41	0	0	1	1.07853	-15.36127	110	2	1.12	0.95;
	854	2	19.31	2.32	0	0	1	1.07804	-15.36675	110	2	1.12	0.95;
	855	1	0	0	0	0	1	1.07809	-15.35968	110	2	1.12	0.95;
	856	1	6.45	1	0	0	1	1.0785	-15.36477	110	2	1.12	0.95;
	857	1	7.42	0.7	0	0	1	1.08494	-15.00908	110	2	1.12	0.95;
	858	1	10.76	1	0	0	1	1.07052	-14.24705	110	2	1.12	0.95;
	859	1	2.15	1	0	0	1	1.0703	-14.19169	110	2	1.12	0.95;
	860	2	25.82	8.44	0	0	1	1.09667	-15.8532	110	2	1.12	0.95;
	861	1	10.76	1.51	0	0	1	1.07024	-14.16626	110	2	1.12	0.95;
	862	1	7.53	0	0	0	1	1.10071	-9.16268	110	2	1.12	0.95;
	863	1	25.82	1	0	0	1	1.08994	-13.43913	110	2	1.12	0.95;
	864	1	17.21	2.51	0	0	1	1.11206	-13.82815	110	2	1.12	0.95;
	865	1	21.3	3.52	0	0	1	1.08547	-14.93934	110	2	1.12	0.95;
	866	1	11.62	2.01	0	0	1	1.07824	-17.18443	110	2	1.12	0.95;
	867	1	26.81	3.22	0	0	1	1.09513	-16.71111	110	2	1.12	0.95;
	868	1	11.91	0	0	0	1	1.10078	-15.78233	110	2	1.12	0.95;
	869	1	21.99	1.47	0	0	1	1.10965	-14.65888	110	2	1.12	0.95;
	870	2	13.56	31.25	0	0	1	1.11642	-13.79551	110	2	1.12	0.95;
	871	1	0	0	0	0	1	1.11633	-13.81955	110	2	1.12	0.95;
	872	1	14.09	0.9	0	0	1	1.10913	-12.39134	110	2	1.12	0.95;
	873	1	8.18	2.01	0	0	1	1.09591	-14.47744	110	2	1.12	0.95;
	874	1	6.56	1.71	0	0	1	1.10863	-12.41744	110	2	1.12	0.95;
	875	1	2	0.5	0	0	1	1.10892	-14.6004	110	2	1.12	0.95;
	876	2	17.23	9.22	0	0	1	1.10874	-14.5955	110	2	1.12	0.95;
	877	1	4.87	0.65	0	0	1	1.10888	-14.64944	110	2	1.12	0.95;
	878	1	14.2	1.22	0	0	1	1.10704	-14.94006	110	2	1.12	0.95;
	879	1	9.68	1	0	0	1	1.09129	-14.64166	110	2	1.12	0.95;
	880	1	10.89	1.61	0	0	1	1.05376	-24.50762	110	2	1.12	0.95;
	881	1	4.09	1	0	0	1	1.08544	-14.94164	110	2	1.12	0.95;
	882	1	0	0	0	0	1	1.10917	-14.70738	110	2	1.12	0.95;
	883	1	0	0	0	0	1	1.10907	-14.73997	110	2	1.12	0.95;
	884	1	3.98	0.6	0	0	1	1.0733	-19.52094	110	2	1.12	0.95;
	885	1	17.5	1.89	0	0	1	1.10603	-15.07583	110	2	1.12	0.95;
	886	1	19.56	2.22	0	0	1	1.10878	-14.47766	110	2	1.12	0.95;
	887	1	23.82	2.99	0	0	1	1.10588	-15.10271	110	2	1.12	0.95;
	888	1	4.6	0.25	0	0	1	1.10948	-14.60398	110	2	1.12	0.95;
	889	1	0.69	0.06	0	0	1	1.10954	-14.59737	110	2	1.12	0.95;
	890	2	21.89	2.21	0	0	1	1.1085	-14.50521	110	2	1.12	0.95;
	891	1	9.19	0.6	0	0	1	1.11012	-14.38512	110	2	1.12	0.95;
	892	1	12.98	2.4	0	0	1	1.109	-14.60809	110	2	1.12	0.95;
	893	2	3.23	0	0	0	1	1.10501	-12.0116	110	2	1.12	0.95;
	894	1	2.15	1	0	0	1	1.10518	-11.98281	110	2	1.12	0.95;
	895	1	3.55	0	0	0	1	1.08394	-17.86608	110	2	1.12	0.95;
	896	1	0	0	0	0	1	1.08536	-13.14104	110	2	1.12	0.95;
	897	1	15.06	2.01	0	0	1	1.10166	-6.64042	110	2	1.12	0.95;
	898	1	13.87	1	0	0	1	1.05769	-22.39517	110	2	1.12	0.95;
	899	1	2.69	0	0	0	1	1.07374	-17.31346	110	2	1.12	0.95;
	900	1	9.68	1.51	0	0	1	1.09059	-14.58572	110	2	1.12	0.95;
	901	1	0.54	0	0	0	1	1.10546	-17.90102	110	2	1.12	0.95;
	902	1	0	0	0	0	1	1.1105	-14.35972	110	2	1.12	0.95;
	903	1	0	0	0	0	1	1.1106	-14.35154	110	2	1.12	0.95;
	904	1	22.59	16.38	0	0	1	1.10203	-11.30376	110	2	1.12	0.95;
	905	1	23.67	6.03	0	0	1	1.08536	-13.14104	110	2	1.12	0.95;
	906	1	6.92	3.91	0	0	1	1.08538	-13.14233	110	2	1.12	0.95;
	907	1	6.78	0.2	0	0	1	1.10563	-11.00249	110	2	1.12	0.95;
	908	2	12.15	3.01	0	0	1	1.10489	-11.04678	110	2	1.12	0.95;
	909	1	9.68	1	0	0	1	1.0952	-12.0695	110	2	1.12	0.95;
	910	1	18.29	0.1	0	0	1	1.07919	-17.08155	110	2	1.12	0.95;
	911	1	4.52	0.6	0	0	1	1.08707	-16.37536	110	2	1.12	0.95;
	912	1	10.54	1.71	0	0	1	1.1019	-12.318	110	2	1.12	0.95;
	913	2	20.98	1.51	0	0	1	1.06654	-14.97926	110	2	1.12	0.95;
	914	1	11.62	2.81	0	0	1	1.11132	-12.47275	110	2	1.12	0.95;
	915	1	0	0	0	0	1	1.09641	-11.98927	110	2	1.12	0.95;
	916	1	3.23	0	0	0	1	1.09854	-16.08218	110	2	1.12	0.95;
	917	1	6.45	1	0	0	1	1.08834	-14.50978	110	2	1.12	0.95;
	918	2	11.13	0.95	0	0	1	1.09251	-16.17222	110	2	1.12	0.95;
	919	1	0.11	0	0	0	1	1.10862	-12.21013	110	2	1.12	0.95;
	920	1	3.23	0.5	0	0	1	1.08216	-13.47064	110	2	1.12	0.95;
	921	1	8.28	1	0	0	1	1.09795	-13.16433	110	2	1.12	0.95;
	922	1	43.03	10.05	0	0	1	1.09521	-13.59872	110	2	1.12	0.95;
	923	1	0	0	0	0	1	1.09529	-13.56424	110	2	1.12	0.95;
	924	1	5.44	0	0	0	1	1.09496	-13.64783	110	2	1.12	0.95;
	925	1	1.61	0.3	0	0	1	1.10732	-11.51115	110	2	1.12	0.95;
	926	1	0	0	0	0	1	1.09882	-10.97658	110	2	1.12	0.95;
	927	1	43.03	30.14	0	0	1	1.09881	-10.97635	110	2	1.12	0.95;
	928	1	5.44	0	0	0	1	1.095	-13.6391	110	2	1.12	0.95;
	929	2	16.14	2.51	0	0	1	1.09201	-13.97078	110	2	1.12	0.95;
	930	1	20.65	1.41	0	0	1	1.09292	-13.93131	110	2	1.12	0.95;
	931	1	10.22	0.3	0	0	1	1.09119	-14.27046	110	2	1.12	0.95;
	932	1	11.35	0.8	0	0	1	1.08126	-18.7645	110	2	1.12	0.95;
	933	1	4.3	0.5	0	0	1	1.08413	-14.39872	110	2	1.12	0.95;
	934	2	13.06	30.14	0	0	1	1.11698	-10.01944	110	2	1.12	0.95;
	935	1	0	0	0	0	1	1.11696	-10.03314	110	2	1.12	0.95;
	936	2	0.1	1	0	0	1	1.09445	-14.07369	110	2	1.12	0.95;
	937	1	5.38	0.5	0	0	1	1.09907	-10.85671	110	2	1.12	0.95;
	938	1	6.45	1	0	0	1	1.10528	-14.16874	110	2	1.12	0.95;
	939	2	5.38	0.5	0	0	1	1.09949	-14.34084	110	2	1.12	0.95;
	940	1	10.1	0	0	0	1	1.08393	-16.43697	110	2	1.12	0.95;
	941	1	13.76	0.41	0	0	1	1.08391	-16.48641	110	2	1.12	0.95;
	942	1	3.74	0.6	0	0	1	1.09303	-16.10424	110	2	1.12	0.95;
	943	1	6.88	0.7	0	0	1	1.09349	-16.04248	110	2	1.12	0.95;
	944	1	3.12	0	0	0	1	1.10062	-15.32239	110	2	1.12	0.95;
	945	1	6.67	2.01	0	0	1	1.07133	-17.48991	110	2	1.12	0.95;
	946	1	19.58	2.51	0	0	1	1.07828	-16.15375	110	2	1.12	0.95;
	947	1	8.61	1	0	0	1	1.08315	-13.81539	110	2	1.12	0.95;
	948	1	2.69	0.3	0	0	1	1.10581	-11.86176	110	2	1.12	0.95;
	949	1	9.36	1.81	0	0	1	1.07124	-17.50492	110	2	1.12	0.95;
	950	1	17.21	1.81	0	0	1	1.07388	-17.29576	110	2	1.12	0.95;
	951	1	4.94	0	0	0	1	1.07391	-17.29244	110	2	1.12	0.95;
	952	1	12.48	0.6	0	0	1	1.07152	-17.47118	110	2	1.12	0.95;
	953	1	23.67	3.01	0	0	1	1.0894	-14.44396	110	2	1.12	0.95;
	954	1	16.14	3.01	0	0	1	1.09641	-11.98927	110	2	1.12	0.95;
	955	1	0	0	0	0	1	1.09645	-11.97495	110	2	1.12	0.95;
	956	1	16.21	1.41	0	0	1	1.07912	-19.58957	110	2	1.12	0.95;
	957	1	16.14	1	0	0	1	1.08935	-14.53685	110	2	1.12	0.95;
	958	1	2.69	0.5	0	0	1	1.07746	-13.40777	110	2	1.12	0.95;
	959	2	6.03	16.08	0	0	1	1.10735	-11.93221	110	2	1.12	0.95;
	960	1	13.02	2.51	0	0	1	1.09689	-16.19717	110	2	1.12	0.95;
	961	1	0	0	0	0	1	1.09688	-16.19459	110	2	1.12	0.95;
	962	1	18.29	3.01	0	0	1	1.08665	-15.24693	110	2	1.12	0.95;
	963	1	3.77	0.9	0	0	1	1.06653	-14.9804	110	2	1.12	0.95;
	964	1	20.01	2.01	0	0	1	1.09974	-13.25524	110	2	1.12	0.95;
	965	2	10.27	1.53	0	0	1	1.07544	-14.10844	110	2	1.12	0.95;
	966	1	4.3	1.51	0	0	1	1.09566	-13.81725	110	2	1.12	0.95;
	967	1	0	0	0	0	1	1.09573	-13.82147	110	2	1.12	0.95;
	968	1	17.21	2.01	0	0	1	1.09237	-14.35533	110	2	1.12	0.95;
	969	1	16.14	2.01	0	0	1	1.09261	-14.2294	110	2	1.12	0.95;
	970	1	18.29	1.51	0	0	1	1.08637	-15.21161	110	2	1.12	0.95;
	971	1	8.28	2.01	0	0	1	1.10661	-13.30393	110	2	1.12	0.95;
	972	1	14.56	1.04	0	0	1	1.09361	-15.71809	110	2	1.12	0.95;
	973	1	11.08	2.91	0	0	1	1.09511	-13.51025	110	2	1.12	0.95;
	974	1	12.59	2.01	0	0	1	1.09916	-13.40251	110	2	1.12	0.95;
	975	1	7.85	0	0	0	1	1.09521	-13.73527	110	2	1.12	0.95;
	976	1	0	0	0	0	1	1.10318	-12.30546	110	2	1.12	0.95;
	977	1	0	0	0	0	1	1.10315	-12.31275	110	2	1.12	0.95;
	978	1	2.69	1	0	0	1	1.0904	-14.34116	110	2	1.12	0.95;
	979	1	22.38	5.02	0	0	1	1.10641	-12.01716	110	2	1.12	0.95;
	980	2	6.45	0.6	0	0	1	1.09905	-13.60351	110	2	1.12	0.95;
	981	1	7.85	0.3	0	0	1	1.10284	-13.15159	110	2	1.12	0.95;
	982	2	3.44	1	0	0	1	1.11542	-12.03034	110	2	1.12	0.95;
	983	1	1.08	0.5	0	0	1	1.09598	-11.65875	110	2	1.12	0.95;
	984	2	8.61	1.51	0	0	1	1.1072	-14.9414	110	2	1.12	0.95;
	985	1	8.61	1	0	0	1	1.08644	-14.29449	110	2	1.12	0.95;
	986	1	20.65	1.07	0	0	1	1.10698	-14.9705	110	2	1.12	0.95;
	987	1	8.61	1.51	0	0	1	1.08754	-10.14481	110	2	1.12	0.95;
	988	1	11.51	1.41	0	0	1	1.07917	-14.11888	110	2	1.12	0.95;
	989	2	3.66	1.21	0	0	1	1.09313	-14.66589	110	2	1.12	0.95;
	990	1	11.83	1.41	0	0	1	1.09192	-14.77629	110	2	1.12	0.95;
	991	1	5.92	0	0	0	1	1.09721	-14.54299	110	2	1.12	0.95;
	992	1	9.57	3.42	0	0	1	1.10324	-12.53672	110	2	1.12	0.95;
	993	2	0	1	0	0	1	1.10184	-14.04265	110	2	1.12	0.95;
	994	1	0	0	0	0	1	1.10181	-14.04863	110	2	1.12	0.95;
	995	1	4.3	0.5	0	0	1	1.08369	-14.38596	110	2	1.12	0.95;
	996	1	6.45	1	0	0	1	1.07514	-14.37298	110	2	1.12	0.95;
	997	1	5.38	0.5	0	0	1	1.08457	-14.38929	110	2	1.12	0.95;
	998	1	18.72	3.42	0	0	1	1.09446	-13.64929	110	2	1.12	0.95;
	999	1	7.64	-0.4	0	0	1	1.11159	-10.50232	110	2	1.12	0.95;
	1000	1	32.27	6.03	0	0	1	1.09016	-14.292	110	2	1.12	0.95;
	1001	1	0	0	0	0	1	1.09022	-14.28225	110	2	1.12	0.95;
	1002	1	0	0	0	0	1	1.09016	-14.292	110	2	1.12	0.95;
	1003	1	0	0	0	0	1	1.09914	-15.99712	110	2	1.12	0.95;
	1004	1	0	0	0	0	1	1.09016	-14.292	110	2	1.12	0.95;
	1005	1	7.85	1.41	0	0	1	1.09259	-14.71813	110	2	1.12	0.95;
	1006	1	3.23	0.5	0	0	1	1.10243	-11.07884	110	2	1.12	0.95;
	1007	1	16.14	2.01	0	0	1	1.09175	-14.22417	110	2	1.12	0.95;
	1008	2	15.29	28.65	0	0	1	1.11496	-12.10243	110	2	1.12	0.95;
	1009	2	33.03	28.65	0	0	1	1.10191	-14.11067	110	2	1.12	0.95;
	1010	1	13.56	2.51	0	0	1	1.08478	-14.78805	110	2	1.12	0.95;
	1011	1	3.76	0	0	0	1	1.08445	-14.17961	110	2	1.12	0.95;
	1012	1	18.93	2.51	0	0	1	1.11105	-12.32725	110	2	1.12	0.95;
	1013	1	7.53	1.41	0	0	1	1.10754	-12.7392	110	2	1.12	0.95;
	1014	1	9.79	1.71	0	0	1	1.10475	-14.5249	110	2	1.12	0.95;
	1015	1	6.88	1.31	0	0	1	1.09601	-14.67602	110	2	1.12	0.95;
	1016	1	16.14	-0.8	0	0	1	1.09777	-13.16301	110	2	1.12	0.95;
	1017	1	12.8	0.9	0	0	1	1.08619	-16.45818	110	2	1.12	0.95;
	1018	1	6.78	0.8	0	0	1	1.08935	-16.13266	110	2	1.12	0.95;
	1019	1	4.19	0.8	0	0	1	1.09237	-14.00102	110	2	1.12	0.95;
	1020	1	0	0	0	0	1	1.09641	-11.98927	110	2	1.12	0.95;
	1021	2	8.39	1.51	0	0	1	1.10219	-15.13809	110	2	1.12	0.95;
	1022	1	1.94	0.6	0	0	1	1.08565	-16.54155	110	2	1.12	0.95;
	1023	1	6.99	0.7	0	0	1	1.09815	-14.29159	110	2	1.12	0.95;
	1024	1	13.98	4.02	0	0	1	1.10663	-16.64198	110	2	1.12	0.95;
	1025	1	0	0	0	0	1	1.09566	-13.81725	110	2	1.12	0.95;
	1026	1	6.15	0.88	0	0	1	1.06945	-20.56276	110	2	1.12	0.95;
	1027	1	11.73	1.91	0	0	1	1.05543	-23.17812	110	2	1.12	0.95;
	1028	1	7.53	0.5	0	0	1	1.09321	-11.85738	110	2	1.12	0.95;
	1029	1	5.38	0	0	0	1	1.07592	-18.83755	110	2	1.12	0.95;
	1030	1	5.38	1	0	0	1	1.08849	-13.64314	110	2	1.12	0.95;
	1031	1	11.3	0.5	0	0	1	1.08956	-9.05223	110	2	1.12	0.95;
	1032	1	15.76	2.11	0	0	1	1.10946	-14.4362	110	2	1.12	0.95;
	1033	1	0	0	0	0	1	1.08511	-14.33909	110	2	1.12	0.95;
	1034	1	0	0	0	0	1	1.09374	-16.53762	110	2	1.12	0.95;
	1035	1	0	0	0	0	1	1.09369	-16.54067	110	2	1.12	0.95;
	1036	1	0	0	0	0	1	1.09964	-14.24308	110	2	1.12	0.95;
	1037	1	0	0	0	0	1	1.10259	-14.8146	110	2	1.12	0.95;
	1038	1	0	0	0	0	1	1.09966	-10.06922	110	2	1.12	0.95;
	1039	1	0	0	0	0	1	1.10769	-12.72495	110	2	1.12	0.95;
	1040	1	6.6	2.25	0	0	1	1.10512	-12.12916	110	2	1.12	0.95;
	1041	1	13.02	1.11	0	0	1	1.10808	-14.43347	110	2	1.12	0.95;
	1042	1	5.86	0	0	0	1	1.10807	-14.42044	110	2	1.12	0.95;
	1043	1	1.61	0.3	0	0	1	1.09405	-14.62637	110	2	1.12	0.95;
	1044	1	0	0	0	0	1	1.09016	-14.292	110	2	1.12	0.95;
	1045	1	6.02	1.21	0	0	1	1.10535	-14.70361	110	2	1.12	0.95;
	1046	1	4.41	0.6	0	0	1	1.09719	-15.16377	110	2	1.12	0.95;
	1047	1	10.65	0	0	0	1	1.10864	-14.50026	110	2	1.12	0.95;
	1048	1	10.54	0.7	0	0	1	1.10798	-14.48439	110	2	1.12	0.95;
	1049	2	2.15	1	0	0	1	1.08347	-14.34863	110	2	1.12	0.95;
	1050	1	7.82	1.51	0	0	1	1.08832	-15.14905	110	2	1.12	0.95;
	1051	1	0	0	0	0	1	1.12	0.20931	110	3	1.12	0.95;
	1052	1	0.58	-0.6	0	0	1	1.11892	-1.1342	110	3	1.12	0.95;
	1053	1	0	0	0	0	1	1.08878	-10.8065	110	3	1.12	0.95;
	1054	1	2.34	0.6	0	0	1	1.09374	-11.53946	110	3	1.12	0.95;
	1055	1	0	0	0	0	1	1.08878	-10.80648	110	3	1.12	0.95;
	1056	2	65.34	42.45	0	0	1	1.08851	-10.77146	110	3	1.12	0.95;
	1057	1	10.9	4.05	0	0	1	1.09928	-6.64047	110	3	1.12	0.95;
	1058	1	5.15	1.84	0	0	1	1.09919	-6.64012	110	3	1.12	0.95;
	1059	1	3.4	0.16	0	0	1	1.11283	-4.17856	110	3	1.12	0.95;
	1060	1	5.38	1.94	0	0	1	1.09947	-6.06802	110	3	1.12	0.95;
	1061	1	0	0	0	0	1	1.09955	-6.05105	110	3	1.12	0.95;
	1062	1	8.66	2.98	0	0	1	1.09939	-6.23226	110	3	1.12	0.95;
	1063	1	10.53	2.28	0	0	1	1.09941	-6.23071	110	3	1.12	0.95;
	1064	1	0	0	0	0	1	1.09945	-6.22511	110	3	1.12	0.95;
	1065	1	15.01	2.68	0	0	1	1.10067	-7.15547	110	3	1.12	0.95;
	1066	1	9.38	3.02	0	0	1	1.10055	-7.16806	110	3	1.12	0.95;
	1067	1	0	0	0	0	1	1.114	-1.52547	110	3	1.12	0.95;
	1068	1	0	0	0	0	1	1.114	-1.51784	110	3	1.12	0.95;
	1069	1	8.18	0.91	0	0	1	1.0978	-3.45618	110	3	1.12	0.95;
	1070	1	6.08	2.85	0	0	1	1.09777	-3.43614	110	3	1.12	0.95;
	1071	1	8.56	3.87	0	0	1	1.10001	-6.78615	110	3	1.12	0.95;
	1072	1	0	0	0	0	1	1.1001	-6.78574	110	3	1.12	0.95;
	1073	1	24.91	4.82	0	0	1	1.10833	-7.38232	110	3	1.12	0.95;
	1074	1	26.43	4.76	0	0	1	1.10835	-7.38279	110	3	1.12	0.95;
	1075	1	17.6	7.07	0	0	1	1.09673	-3.42562	110	3	1.12	0.95;
	1076	1	0	0	0	0	1	1.10187	-1.94356	110	3	1.12	0.95;
	1077	1	0	0	0	0	1	1.09682	-3.42028	110	3	1.12	0.95;
	1078	1	11.62	4.35	0	0	1	1.09262	-6.6903	110	3	1.12	0.95;
	1079	1	8.21	3.02	0	0	1	1.0925	-6.69025	110	3	1.12	0.95;
	1080	1	11.16	3.04	0	0	1	1.11551	-6.65235	110	3	1.12	0.95;
	1081	1	8.56	2.16	0	0	1	1.11554	-6.65026	110	3	1.12	0.95;
	1082	1	3.63	1.55	0	0	1	1.06574	-11.83237	110	3	1.12	0.95;
	1083	1	2.34	1.32	0	0	1	1.09177	-11.69699	110	3	1.12	0.95;
	1084	1	0	0	0	0	1	1.06577	-11.83141	110	3	1.12	0.95;
	1085	1	0	0	0	0	1	1.10748	-3.34124	110	3	1.12	0.95;
	1086	1	0	0	0	0	1	1.10725	-3.34938	110	3	1.12	0.95;
	1087	2	7.38	4.78	0	0	1	1.11915	-0.90481	110	3	1.12	0.95;
	1088	1	9.83	5.86	0	0	1	1.11901	-0.9211	110	3	1.12	0.95;
	1089	1	11.19	6.33	0	0	1	1.06574	-8.8331	110	3	1.12	0.95;
	1090	1	5.61	1.75	0	0	1	1.06203	-7.65285	110	3	1.12	0.95;
	1091	1	0	0	0	0	1	1.06328	-7.59282	110	3	1.12	0.95;
	1092	1	13.71	1.86	0	0	1	1.0784	-12.63619	110	3	1.12	0.95;
	1093	1	7.49	2.34	0	0	1	1.07829	-12.64651	110	3	1.12	0.95;
	1094	1	12.63	7.07	0	0	1	1.10883	-4.50798	110	3	1.12	0.95;
	1095	1	0	0	0	0	1	1.10486	-5.2548	110	3	1.12	0.95;
	1096	1	4.22	1.61	0	0	1	1.0964	-6.66419	110	3	1.12	0.95;
	1097	1	1.05	0.44	0	0	1	1.09674	-6.5989	110	3	1.12	0.95;
	1098	1	0	0	0	0	1	1.09647	-6.6612	110	3	1.12	0.95;
	1099	1	0	0	0	0	1	1.09676	-6.59817	110	3	1.12	0.95;
	1100	1	0	0	0	0	1	1.11781	-2.06619	110	3	1.12	0.95;
	1101	1	1.52	0.35	0	0	1	1.11785	-2.04698	110	3	1.12	0.95;
	1102	1	4.46	1.29	0	0	1	1.0887	-10.26965	110	3	1.12	0.95;
	1103	1	4.46	0.69	0	0	1	1.08869	-10.27141	110	3	1.12	0.95;
	1104	1	0	0	0	0	1	1.08997	-10.15626	110	3	1.12	0.95;
	1105	1	14.05	4.16	0	0	1	1.0973	-6.34157	110	3	1.12	0.95;
	1106	1	0	0	0	0	1	1.09731	-6.34904	110	3	1.12	0.95;
	1107	1	7.26	1.07	0	0	1	1.08133	-7.80326	110	3	1.12	0.95;
	1108	1	1.52	0.11	0	0	1	1.08134	-7.80036	110	3	1.12	0.95;
	1109	1	0	0	0	0	1	1.09864	-6.34029	110	3	1.12	0.95;
	1110	1	11.69	3.26	0	0	1	1.09601	-4.61512	110	3	1.12	0.95;
	1111	2	12.37	7.52	0	0	1	1.11135	-3.5886	110	3	1.12	0.95;
	1112	2	2.01	4.02	0	0	1	1.11269	-3.14631	110	3	1.12	0.95;
	1113	1	4.92	0.52	0	0	1	1.09945	-7.39923	110	3	1.12	0.95;
	1114	1	5.74	2.26	0	0	1	1.09938	-7.40329	110	3	1.12	0.95;
	1115	1	10.66	3.17	0	0	1	1.07662	-12.73821	110	3	1.12	0.95;
	1116	1	9.59	3.03	0	0	1	1.07657	-12.74136	110	3	1.12	0.95;
	1117	1	0	0	0	0	1	1.05285	-8.91854	110	3	1.12	0.95;
	1118	1	22.52	0.96	0	0	1	1.05286	-8.91524	110	3	1.12	0.95;
	1119	1	12.52	4.28	0	0	1	1.11799	-0.35096	110	3	1.12	0.95;
	1120	1	7.37	2.68	0	0	1	1.11814	-1.03203	110	3	1.12	0.95;
	1121	1	0.35	0.11	0	0	1	1.10883	-4.51347	110	3	1.12	0.95;
	1122	1	0	0	0	0	1	1.10492	-5.2559	110	3	1.12	0.95;
	1123	1	12.28	2.89	0	0	1	1.10939	-4.03379	110	3	1.12	0.95;
	1124	1	0	0	0	0	1	1.11527	-2.5995	110	3	1.12	0.95;
	1125	1	15.2	6.94	0	0	1	1.11508	-2.6055	110	3	1.12	0.95;
	1126	1	15.83	6.94	0	0	1	1.10934	-4.03351	110	3	1.12	0.95;
	1127	1	7.84	1.71	0	0	1	1.10285	-7.60294	110	3	1.12	0.95;
	1128	1	12.18	2.87	0	0	1	1.10277	-7.6188	110	3	1.12	0.95;
	1129	1	5.87	2.75	0	0	1	1.09964	-6.76856	110	3	1.12	0.95;
	1130	1	0	0	0	0	1	1.09969	-6.76842	110	3	1.12	0.95;
	1131	1	21.86	12.43	0	0	1	1.09283	-2.94431	110	3	1.12	0.95;
	1132	1	3.51	2.85	0	0	1	1.09748	-2.20367	110	3	1.12	0.95;
	1133	1	6.09	2.28	0	0	1	1.10465	-4.0296	110	3	1.12	0.95;
	1134	1	0	0	0	0	1	1.10515	-3.95658	110	3	1.12	0.95;
	1135	1	0	0	0	0	1	1.10472	-4.02512	110	3	1.12	0.95;
	1136	1	0	0	0	0	1	1.10514	-3.95657	110	3	1.12	0.95;
	1137	1	0	0	0	0	1	1.08988	-5.26421	110	3	1.12	0.95;
	1138	1	4.57	0.73	0	0	1	1.08981	-5.27956	110	3	1.12	0.95;
	1139	1	13	4.78	0	0	1	1.08684	-7.36283	110	3	1.12	0.95;
	1140	1	0	0.04	0	0	1	1.08684	-7.36283	110	3	1.12	0.95;
	1141	1	0	0	0	0	1	1.08696	-7.35451	110	3	1.12	0.95;
	1142	1	12.89	5.51	0	0	1	1.09775	-2.66789	110	3	1.12	0.95;
	1143	1	3.63	1.74	0	0	1	1.11485	-0.93699	110	3	1.12	0.95;
	1144	1	14.29	3.6	0	0	1	1.06005	-11.65428	110	3	1.12	0.95;
	1145	1	10.89	2.8	0	0	1	1.06019	-11.65806	110	3	1.12	0.95;
	1146	1	6.9	5.47	0	0	1	1.09569	-5.82841	110	3	1.12	0.95;
	1147	1	9.47	2.09	0	0	1	1.09575	-5.83598	110	3	1.12	0.95;
	1148	1	9.01	3.05	0	0	1	1.09846	-6.31394	110	3	1.12	0.95;
	1149	1	11.38	3.99	0	0	1	1.09871	-6.31128	110	3	1.12	0.95;
	1150	1	5.14	1.71	0	0	1	1.10353	-4.0589	110	3	1.12	0.95;
	1151	1	0	0	0	0	1	1.10385	-4.03484	110	3	1.12	0.95;
	1152	1	8.77	2.83	0	0	1	1.11179	-6.78453	110	3	1.12	0.95;
	1153	1	7.27	2.95	0	0	1	1.11169	-6.78181	110	3	1.12	0.95;
	1154	1	10.07	3.3	0	0	1	1.11051	-1.17638	110	3	1.12	0.95;
	1155	1	0	0	0	0	1	1.1106	-1.16151	110	3	1.12	0.95;
	1156	1	14.38	6.85	0	0	1	1.11111	-2.04136	110	3	1.12	0.95;
	1157	1	6.78	1.37	0	0	1	1.11119	-2.03621	110	3	1.12	0.95;
	1158	1	0	0	0	0	1	1.11079	-2.03539	110	3	1.12	0.95;
	1159	1	7.14	2.65	0	0	1	1.10951	-4.02739	110	3	1.12	0.95;
	1160	1	5.74	2.87	0	0	1	1.11527	-2.59949	110	3	1.12	0.95;
	1161	1	1.17	1.13	0	0	1	1.09208	-5.76892	110	3	1.12	0.95;
	1162	1	4.22	4.04	0	0	1	1.0921	-5.76444	110	3	1.12	0.95;
	1163	1	7.85	2.26	0	0	1	1.09613	-7.54723	110	3	1.12	0.95;
	1164	1	0	0	0	0	1	1.0974	-7.44048	110	3	1.12	0.95;
	1165	1	6.1	2.49	0	0	1	1.10535	-3.03321	110	3	1.12	0.95;
	1166	1	2.93	1.35	0	0	1	1.10372	-3.42812	110	3	1.12	0.95;
	1167	1	22.36	8.94	0	0	1	1.10386	-3.42829	110	3	1.12	0.95;
	1168	1	10.41	0.73	0	0	1	1.09989	-7.96224	110	3	1.12	0.95;
	1169	1	5.5	0.49	0	0	1	1.10009	-7.92605	110	3	1.12	0.95;
	1170	1	0	0	0	0	1	1.10068	-7.15575	110	3	1.12	0.95;
	1171	1	0	0	0	0	1	1.10056	-7.16834	110	3	1.12	0.95;
	1172	1	7.64	3.2	0	0	1	1.07676	-13.16776	110	3	1.12	0.95;
	1173	1	0	0	0	0	1	1.07672	-13.17696	110	3	1.12	0.95;
	1174	1	13.01	2.35	0	0	1	1.09141	-4.21765	110	3	1.12	0.95;
	1175	1	0	0	0	0	1	1.09137	-4.22152	110	3	1.12	0.95;
	1176	1	0	0	0	0	1	1.09961	-4.21266	110	3	1.12	0.95;
	1177	1	0.7	0.23	0	0	1	1.09963	-4.20691	110	3	1.12	0.95;
	1178	1	0	0	0	0	1	1.09809	-4.68108	110	3	1.12	0.95;
	1179	1	6.56	0.61	0	0	1	1.09811	-4.67626	110	3	1.12	0.95;
	1180	1	6.08	2.62	0	0	1	1.11078	-2.03577	110	3	1.12	0.95;
	1181	1	1.87	1.25	0	0	1	1.11626	-1.59572	110	3	1.12	0.95;
	1182	1	9.83	2.12	0	0	1	1.10451	-4.94866	110	3	1.12	0.95;
	1183	1	6.43	0.61	0	0	1	1.10455	-4.94186	110	3	1.12	0.95;
	1184	1	6.44	0.89	0	0	1	1.10858	-3.50169	110	3	1.12	0.95;
	1185	1	7.61	0.93	0	0	1	1.1085	-3.51339	110	3	1.12	0.95;
	1186	1	10.3	4.17	0	0	1	1.11544	-1.45158	110	3	1.12	0.95;
	1187	1	6.55	2.78	0	0	1	1.11545	-1.44595	110	3	1.12	0.95;
	1188	2	34.82	23.37	0	0	1	1.11896	-0.38999	110	3	1.12	0.95;
	1189	2	11.05	18.09	0	0	1	1.11854	-0.57081	110	3	1.12	0.95;
	1190	1	7.96	3.26	0	0	1	1.11084	-4.47545	110	3	1.12	0.95;
	1191	1	8.42	3.49	0	0	1	1.11079	-4.49237	110	3	1.12	0.95;
	1192	1	14.07	7.03	0	0	1	1.11286	-1.5417	110	3	1.12	0.95;
	1193	2	0.01	0.01	0	0	1	1.11298	-1.52978	110	3	1.12	0.95;
	1194	1	9.36	3.83	0	0	1	1.11416	-1.90133	110	3	1.12	0.95;
	1195	1	6.32	2.61	0	0	1	1.11422	-1.91576	110	3	1.12	0.95;
	1196	1	1.4	0.82	0	0	1	1.05522	-8.41767	110	3	1.12	0.95;
	1197	1	0	0	0	0	1	1.05522	-8.41761	110	3	1.12	0.95;
	1198	1	7.15	0.51	0	0	1	1.09948	-6.76292	110	3	1.12	0.95;
	1199	1	0	0	0	0	1	1.09943	-6.75382	110	3	1.12	0.95;
	1200	1	6.78	2.17	0	0	1	1.09569	-6.31627	110	3	1.12	0.95;
	1201	1	3.98	1.25	0	0	1	1.09574	-6.32075	110	3	1.12	0.95;
	1202	1	10.66	5.85	0	0	1	1.10796	-4.95105	110	3	1.12	0.95;
	1203	1	5.73	1.77	0	0	1	1.10785	-4.93171	110	3	1.12	0.95;
	1204	1	7.15	3.23	0	0	1	1.11932	0.09307	110	3	1.12	0.95;
	1205	1	0	0	0	0	1	1.11952	0.10497	110	3	1.12	0.95;
	1206	1	13.93	2.34	0	0	1	1.11723	-6.52492	110	3	1.12	0.95;
	1207	1	16.84	3.87	0	0	1	1.11714	-6.53643	110	3	1.12	0.95;
	1208	1	12.06	4.16	0	0	1	1.10053	-2.288	110	3	1.12	0.95;
	1209	1	11.82	4.71	0	0	1	1.11631	-0.57648	110	3	1.12	0.95;
	1210	1	18.94	3.96	0	0	1	1.11912	-6.40992	110	3	1.12	0.95;
	1211	1	17.19	3.12	0	0	1	1.115	-7.04647	110	3	1.12	0.95;
	1212	1	4.68	2.31	0	0	1	1.11944	-0.72501	110	3	1.12	0.95;
	1213	1	3.27	1.27	0	0	1	1.11945	-0.71879	110	3	1.12	0.95;
	1214	2	24.26	66.11	0	0	1	1.12	-1.70418	110	3	1.12	0.95;
	1215	2	25.43	66.11	0	0	1	1.12	-1.12064	110	3	1.12	0.95;
	1216	1	5.04	0.72	0	0	1	1.09089	-5.29672	110	3	1.12	0.95;
	1217	1	4.33	-0.23	0	0	1	1.09093	-5.28526	110	3	1.12	0.95;
	1218	1	9.71	2.21	0	0	1	1.11136	-1.90933	110	3	1.12	0.95;
	1219	2	0.94	0.07	0	0	1	1.11136	-1.91206	110	3	1.12	0.95;
	1220	2	11.05	18.09	0	0	1	1.12	0.07272	110	3	1.12	0.95;
	1221	1	0	0	0	0	1	1.11992	0.05102	110	3	1.12	0.95;
	1222	1	12.05	3.83	0	0	1	1.07984	-9.10336	110	3	1.12	0.95;
	1223	1	8.31	2.69	0	0	1	1.07975	-9.12289	110	3	1.12	0.95;
	1224	1	9.18	4.65	0	0	1	1.07892	-11.81882	110	3	1.12	0.95;
	1225	1	0	0	0	0	1	1.07914	-11.81309	110	3	1.12	0.95;
	1226	2	0	0	0	0	1	1.10881	-5.14538	110	3	1.12	0.95;
	1227	2	34.18	0.22	0	0	1	1.10904	-5.28531	110	3	1.12	0.95;
	1228	2	0	0	0	0	1	1.103	-5.08675	110	3	1.12	0.95;
	1229	1	3.52	1.07	0	0	1	1.09906	-6.16913	110	3	1.12	0.95;
	1230	1	0	0	0	0	1	1.09907	-6.1688	110	3	1.12	0.95;
	1231	1	4.09	1.37	0	0	1	1.09675	-6.51005	110	3	1.12	0.95;
	1232	1	4.91	1.6	0	0	1	1.09677	-6.51597	110	3	1.12	0.95;
	1233	1	5.04	1.94	0	0	1	1.06728	-14.32801	110	3	1.12	0.95;
	1234	1	0	0	0	0	1	1.06733	-14.32474	110	3	1.12	0.95;
	1235	1	0	0.23	0	0	1	1.11854	-0.9542	110	3	1.12	0.95;
	1236	1	0	0	0	0	1	1.11855	-0.95429	110	3	1.12	0.95;
	1237	2	0	1.51	0	0	1	1.10503	-6.48479	110	3	1.12	0.95;
	1238	2	22.1	8.96	0	0	1	1.10501	-6.47756	110	3	1.12	0.95;
	1239	2	7.94	3.01	0	0	1	1.10493	-6.48097	110	3	1.12	0.95;
	1240	1	0	0	0	0	1	1.10181	-6.18241	110	3	1.12	0.95;
	1241	1	3.04	0.8	0	0	1	1.09712	-4.59802	110	3	1.12	0.95;
	1242	1	0	0	0	0	1	1.09715	-4.59597	110	3	1.12	0.95;
	1243	1	0	0	0	0	1	1.11992	0.05102	110	3	1.12	0.95;
	1244	1	0	0	0	0	1	1.12	0.07272	110	3	1.12	0.95;
	1245	1	0	0	0	0	1	1.09666	-6.64854	110	3	1.12	0.95;
	1246	1	0	0	0	0	1	1.09666	-6.64854	110	3	1.12	0.95;
	1247	1	0	0	0	0	1	1.11808	-0.34469	110	3	1.12	0.95;
	1248	1	2.69	0.37	0	0	1	1.11552	-3.97693	110	3	1.12	0.95;
	1249	1	0	0	0	0	1	1.11545	-3.98811	110	3	1.12	0.95;
	1250	1	0.23	0.11	0	0	1	1.11654	-1.43878	110	3	1.12	0.95;
	1251	1	0	0	0	0	1	1.11654	-1.43874	110	3	1.12	0.95;
	1252	1	3.86	1.25	0	0	1	1.11738	-1.09094	110	3	1.12	0.95;
	1253	1	0	0	0	0	1	1.1174	-1.08925	110	3	1.12	0.95;
	1254	1	0	0	0	0	1	1.10894	-1.44382	110	3	1.12	0.95;
	1255	1	3.51	1.71	0	0	1	1.10894	-1.44515	110	3	1.12	0.95;
	1256	1	0	0	0	0	1	1.11654	-1.43874	110	3	1.12	0.95;
	1257	1	0	0	0	0	1	1.11654	-1.43874	110	3	1.12	0.95;
	1258	1	22.96	7.82	0	0	1	1.09624	-2.77744	110	3	1.12	0.95;
	1259	1	0	0	0	0	1	1.11485	-0.9371	110	3	1.12	0.95;
	1260	1	13.33	4.31	0	0	1	1.10129	-6.28516	110	3	1.12	0.95;
	1261	1	12.63	4.19	0	0	1	1.10162	-6.27317	110	3	1.12	0.95;
	1262	1	12.66	5.17	0	0	1	1.10833	-4.4862	110	3	1.12	0.95;
	1263	1	11.13	3.57	0	0	1	1.10837	-4.48044	110	3	1.12	0.95;
	1264	1	0.94	0.35	0	0	1	1.09966	-6.56852	110	3	1.12	0.95;
	1265	1	0	0	0	0	1	1.09964	-6.55848	110	3	1.12	0.95;
	1266	1	6.33	1.46	0	0	1	1.10748	-3.92212	110	3	1.12	0.95;
	1267	1	0	0	0	0	1	1.10761	-4.02425	110	3	1.12	0.95;
	1268	1	6.44	4.17	0	0	1	1.10539	-5.3409	110	3	1.12	0.95;
	1269	1	0	0	0	0	1	1.10562	-5.33715	110	3	1.12	0.95;
	1270	1	8.79	0.02	0	0	1	1.07313	-6.52626	110	3	1.12	0.95;
	1271	1	0	0	0	0	1	1.07306	-6.54357	110	3	1.12	0.95;
	1272	1	7.02	3.88	0	0	1	1.10449	-3.98749	110	3	1.12	0.95;
	1273	1	3.16	0	0	0	1	1.10526	-3.95743	110	3	1.12	0.95;
	1274	1	0	0	0	0	1	1.11491	-1.27237	110	3	1.12	0.95;
	1275	1	13.68	4.02	0	0	1	1.11483	-1.28293	110	3	1.12	0.95;
	1276	1	4.91	1.37	0	0	1	1.07085	-13.83462	110	3	1.12	0.95;
	1277	1	5.38	1.83	0	0	1	1.07068	-13.95289	110	3	1.12	0.95;
	1278	1	0	0	0	0	1	1.07071	-13.96381	110	3	1.12	0.95;
	1279	1	9.86	5.42	0	0	1	1.07427	-5.38141	110	3	1.12	0.95;
	1280	1	0	0	0	0	1	1.07427	-5.37644	110	3	1.12	0.95;
	1281	1	1.29	0.46	0	0	1	1.10925	-4.25036	110	3	1.12	0.95;
	1282	1	5.03	1.85	0	0	1	1.10921	-4.22529	110	3	1.12	0.95;
	1283	1	0.94	0.41	0	0	1	1.10929	-4.24765	110	3	1.12	0.95;
	1284	1	17.77	6.41	0	0	1	1.09957	-4.53455	110	3	1.12	0.95;
	1285	1	6.55	2.1	0	0	1	1.09968	-4.52444	110	3	1.12	0.95;
	1286	1	6.9	2.92	0	0	1	1.11712	-1.32003	110	3	1.12	0.95;
	1287	1	6.9	2.78	0	0	1	1.11711	-1.31629	110	3	1.12	0.95;
	1288	1	9.84	2.1	0	0	1	1.11339	-6.90116	110	3	1.12	0.95;
	1289	1	11.71	3.03	0	0	1	1.11337	-6.9065	110	3	1.12	0.95;
	1290	1	5.62	1.57	0	0	1	1.11172	-2.78936	110	3	1.12	0.95;
	1291	1	9.03	3.59	0	0	1	1.11176	-2.75998	110	3	1.12	0.95;
	1292	1	0	0	0	0	1	1.07639	-12.73257	110	3	1.12	0.95;
	1293	1	0	0	0	0	1	1.0765	-12.72508	110	3	1.12	0.95;
	1294	1	7.61	5.72	0	0	1	1.08226	-5.51196	110	3	1.12	0.95;
	1295	1	2.57	0.13	0	0	1	1.08226	-5.51539	110	3	1.12	0.95;
	1296	1	0	0	0	0	1	1.08234	-5.49927	110	3	1.12	0.95;
	1297	1	9.35	3.08	0	0	1	1.09846	-6.60959	110	3	1.12	0.95;
	1298	1	9.35	2.97	0	0	1	1.09857	-6.61616	110	3	1.12	0.95;
	1299	1	0	0	0	0	1	1.09849	-6.60739	110	3	1.12	0.95;
	1300	1	0	0	0	0	1	1.09872	-6.60576	110	3	1.12	0.95;
	1301	1	7.5	0.99	0	0	1	1.10838	-3.44199	110	3	1.12	0.95;
	1302	1	5.74	2.4	0	0	1	1.10839	-3.46292	110	3	1.12	0.95;
	1303	1	5.39	1.66	0	0	1	1.09119	-11.1373	110	3	1.12	0.95;
	1304	1	4.33	1.13	0	0	1	1.09124	-11.14919	110	3	1.12	0.95;
	1305	1	2.22	0.68	0	0	1	1.10841	-3.03648	110	3	1.12	0.95;
	1306	1	1.64	0.57	0	0	1	1.10844	-3.02024	110	3	1.12	0.95;
	1307	1	7.02	0.23	0	0	1	1.10761	-4.02424	110	3	1.12	0.95;
	1308	1	7.02	0.82	0	0	1	1.10752	-3.91541	110	3	1.12	0.95;
	1309	1	5.74	2.56	0	0	1	1.0943	-10.75816	110	3	1.12	0.95;
	1310	1	0	0	0	0	1	1.09454	-10.75198	110	3	1.12	0.95;
	1311	1	9.72	3.31	0	0	1	1.07017	-13.47481	110	3	1.12	0.95;
	1312	1	2.69	1.05	0	0	1	1.0702	-13.47922	110	3	1.12	0.95;
	1313	1	2.46	0.8	0	0	1	1.10929	-1.79774	110	3	1.12	0.95;
	1314	1	0	0	0	0	1	1.11346	-1.51641	110	3	1.12	0.95;
	1315	1	0	0	0	0	1	1.10938	-1.79341	110	3	1.12	0.95;
	1316	1	0	0	0	0	1	1.11346	-1.51639	110	3	1.12	0.95;
	1317	1	0	0	0	0	1	1.10039	-7.28212	110	3	1.12	0.95;
	1318	1	5.27	1.94	0	0	1	1.10042	-7.2847	110	3	1.12	0.95;
	1319	1	0	0	0	0	1	1.11638	-1.60128	110	3	1.12	0.95;
	1320	1	9.13	3.14	0	0	1	1.10164	-4.17555	110	3	1.12	0.95;
	1321	1	0	0	0	0	1	1.11638	-1.60122	110	3	1.12	0.95;
	1322	1	0	0	0	0	1	1.10201	-4.14972	110	3	1.12	0.95;
	1323	1	1.05	0.66	0	0	1	1.1019	-4.28634	110	3	1.12	0.95;
	1324	1	0.7	0.3	0	0	1	1.10193	-4.28298	110	3	1.12	0.95;
	1325	1	1.64	0.35	0	0	1	1.11678	-1.29254	110	3	1.12	0.95;
	1326	1	0	0	0	0	1	1.11679	-1.29193	110	3	1.12	0.95;
	1327	1	0	0	0	0	1	1.11679	-1.29187	110	3	1.12	0.95;
	1328	1	7.61	0.22	0	0	1	1.05763	-8.23506	110	3	1.12	0.95;
	1329	1	6.79	-0.81	0	0	1	1.08432	-5.41625	110	3	1.12	0.95;
	1330	2	4.25	5.68	0	0	1	1.11507	-1.12076	110	3	1.12	0.95;
	1331	2	5.78	7.92	0	0	1	1.10535	-3.94318	110	3	1.12	0.95;
	1332	1	0	0	0	0	1	1.1166	-1.57999	110	3	1.12	0.95;
	1333	1	0.7	2.75	0	0	1	1.11348	-2.82565	110	3	1.12	0.95;
	1334	1	7.26	3.06	0	0	1	1.11343	-2.8467	110	3	1.12	0.95;
	1335	1	12.99	1.3	0	0	1	1.06846	-6.20792	110	3	1.12	0.95;
	1336	1	5.15	2.24	0	0	1	1.06861	-6.19046	110	3	1.12	0.95;
	1337	1	22.22	12.38	0	0	1	1.06063	-11.19523	110	3	1.12	0.95;
	1338	1	0.7	0	0	0	1	1.06095	-11.16015	110	3	1.12	0.95;
	1339	1	3.16	0.99	0	0	1	1.10033	-7.28156	110	3	1.12	0.95;
	1340	1	0	0	0	0	1	1.10048	-7.28665	110	3	1.12	0.95;
	1341	1	0	0	0	0	1	1.10038	-7.27906	110	3	1.12	0.95;
	1342	1	0	0	0	0	1	1.10048	-7.28665	110	3	1.12	0.95;
	1343	1	16.44	7.84	0	0	1	1.09931	-7.39521	110	3	1.12	0.95;
	1344	1	0	0	0	0	1	1.10085	-7.30227	110	3	1.12	0.95;
	1345	1	0	0	0	0	1	1.09958	-7.38065	110	3	1.12	0.95;
	1346	1	0	0	0	0	1	1.10085	-7.30227	110	3	1.12	0.95;
	1347	1	24.32	6.98	0	0	1	1.09949	-6.48129	110	3	1.12	0.95;
	1348	1	9.36	3.57	0	0	1	1.09923	-7.3957	110	3	1.12	0.95;
	1349	1	17.71	9.91	0	0	1	1.09948	-7.32932	110	3	1.12	0.95;
	1350	1	0	0	0	0	1	1.09956	-7.32745	110	3	1.12	0.95;
	1351	1	3.28	0.4	0	0	1	1.08866	-7.1226	110	3	1.12	0.95;
	1352	1	7.03	3.45	0	0	1	1.08863	-7.13378	110	3	1.12	0.95;
	1353	1	3.5	2.01	0	0	1	1.10357	-3.69647	110	3	1.12	0.95;
	1354	2	109.52	51.24	0	0	1	1.0866	-7.37142	110	3	1.12	0.95;
	1355	1	3.86	1.25	0	0	1	1.11885	-0.39775	110	3	1.12	0.95;
	1356	1	26.12	11.05	0	0	1	1.11698	-0.79494	110	3	1.12	0.95;
	1357	1	63.3	22.61	0	0	1	1.118	-1.68346	110	3	1.12	0.95;
	1358	1	0	0	0	0	1	1.11971	-1.55061	110	3	1.12	0.95;
	1359	1	0	0	0	0	1	1.11721	-0.78125	110	3	1.12	0.95;
	1360	1	0	0	0	0	1	1.11913	-1.60455	110	3	1.12	0.95;
	1361	1	0	0	0	0	1	1.11739	-0.7655	110	3	1.12	0.95;
	1362	1	10.52	4.56	0	0	1	1.09163	-5.8345	110	3	1.12	0.95;
	1363	1	0	0	0	0	1	1.09166	-5.83455	110	3	1.12	0.95;
	1364	1	0	0	0	0	1	1.09164	-5.85356	110	3	1.12	0.95;
	1365	1	1.64	0.57	0	0	1	1.09585	-6.33395	110	3	1.12	0.95;
	1366	1	0.58	0.34	0	0	1	1.09403	-6.87309	110	3	1.12	0.95;
	1367	1	6.31	0.93	0	0	1	1.10098	-4.2708	110	3	1.12	0.95;
	1368	1	6.2	-0.9	0	0	1	1.10096	-4.27401	110	3	1.12	0.95;
	1369	1	3.04	1.14	0	0	1	1.1136	-1.06041	110	3	1.12	0.95;
	1370	1	2.92	0.68	0	0	1	1.11361	-1.05565	110	3	1.12	0.95;
	1371	2	19.4	6.94	0	0	1	1.11621	-6.5134	110	3	1.12	0.95;
	1372	2	18.6	9.76	0	0	1	1.11608	-6.50598	110	3	1.12	0.95;
	1373	2	16.79	3.83	0	0	1	1.11665	-6.51829	110	3	1.12	0.95;
	1374	1	11.21	2.63	0	0	1	1.11642	-6.56524	110	3	1.12	0.95;
	1375	1	22.42	6.52	0	0	1	1.11635	-6.56985	110	3	1.12	0.95;
	1376	1	10.35	4.62	0	0	1	1.11813	-6.52365	110	3	1.12	0.95;
	1377	1	11.96	4.12	0	0	1	1.11839	-6.48454	110	3	1.12	0.95;
	1378	1	10.62	0.46	0	0	1	1.11649	-6.55932	110	3	1.12	0.95;
	1379	1	10.65	0.8	0	0	1	1.11631	-6.55051	110	3	1.12	0.95;
	1380	1	2.69	2.29	0	0	1	1.11653	-6.55166	110	3	1.12	0.95;
	1381	1	44.21	16.08	0	0	1	1.118	-6.51264	110	3	1.12	0.95;
	1382	1	44.21	16.08	0	0	1	1.11772	-6.55672	110	3	1.12	0.95;
	1383	1	0	0	0	0	1	1.11878	-6.45925	110	3	1.12	0.95;
	1384	1	7.82	3.78	0	0	1	1.11834	-6.51279	110	3	1.12	0.95;
	1385	1	11.45	3.01	0	0	1	1.11742	-6.55113	110	3	1.12	0.95;
	1386	1	11.45	2.41	0	0	1	1.11751	-6.54642	110	3	1.12	0.95;
	1387	1	0.93	0	0	0	1	1.11619	-6.58498	110	3	1.12	0.95;
	1388	1	0.82	0	0	0	1	1.11736	-6.53439	110	3	1.12	0.95;
	1389	1	0	0	0	0	1	1.11619	-6.5848	110	3	1.12	0.95;
	1390	1	0	0	0	0	1	1.11736	-6.53418	110	3	1.12	0.95;
	1391	1	3.16	0.57	0	0	1	1.11302	-1.61113	110	3	1.12	0.95;
	1392	1	1.52	0.23	0	0	1	1.11329	-1.58819	110	3	1.12	0.95;
	1393	1	1.52	0.46	0	0	1	1.1003	-3.36711	110	3	1.12	0.95;
	1394	1	0	0	0	0	1	1.1003	-3.36682	110	3	1.12	0.95;
	1395	1	0	0	0	0	1	1.10864	-3.99209	110	3	1.12	0.95;
	1396	1	0	0	0	0	1	1.10864	-3.99208	110	3	1.12	0.95;
	1397	1	0	0	0	0	1	1.10037	-3.3578	110	3	1.12	0.95;
	1398	1	12.41	4.38	0	0	1	1.10999	-4.56716	110	3	1.12	0.95;
	1399	1	7.25	0.12	0	0	1	1.11348	-3.53213	110	3	1.12	0.95;
	1400	2	9.49	9.89	0	0	1	1.11997	-0.83013	110	3	1.12	0.95;
	1401	2	8.55	9.2	0	0	1	1.11405	-3.19034	110	3	1.12	0.95;
	1402	1	4.1	1.89	0	0	1	1.07053	-9.76155	110	3	1.12	0.95;
	1403	1	3.28	1.2	0	0	1	1.07044	-9.75989	110	3	1.12	0.95;
	1404	1	0.35	0.23	0	0	1	1.1157	-1.4764	110	3	1.12	0.95;
	1405	1	0	0	0	0	1	1.1157	-1.47639	110	3	1.12	0.95;
	1406	1	21.75	14.94	0	0	1	1.10379	-1.97872	110	3	1.12	0.95;
	1407	1	9.35	1.14	0	0	1	1.10366	-1.99193	110	3	1.12	0.95;
	1408	2	53.02	29.46	0	0	1	1.10592	-1.04233	110	3	1.12	0.95;
	1409	1	36.9	34.81	0	0	1	1.11776	-1.34244	110	3	1.12	0.95;
	1410	1	9.24	2.81	0	0	1	1.11392	-1.34778	110	3	1.12	0.95;
	1411	1	2.46	1.27	0	0	1	1.11787	-0.35619	110	3	1.12	0.95;
	1412	1	0	0	0	0	1	1.11394	-1.34426	110	3	1.12	0.95;
	1413	1	2.93	1.31	0	0	1	1.10863	-5.28989	110	3	1.12	0.95;
	1414	1	0	0	0	0	1	1.10884	-5.27793	110	3	1.12	0.95;
	1415	1	16.95	5.82	0	0	1	1.09521	-2.38528	110	3	1.12	0.95;
	1416	1	0	0	0	0	1	1.09527	-2.3759	110	3	1.12	0.95;
	1417	1	0	0	0	0	1	1.09173	-2.81927	110	3	1.12	0.95;
	1418	1	7.02	2.68	0	0	1	1.09655	-3.55906	110	3	1.12	0.95;
	1419	1	2.34	0.6	0	0	1	1.09773	-3.64073	110	3	1.12	0.95;
	1420	1	0	0	0	0	1	1.09666	-3.55305	110	3	1.12	0.95;
	1421	1	0	0	0	0	1	1.09776	-3.63861	110	3	1.12	0.95;
	1422	1	0.58	0.09	0	0	1	1.10805	-4.829	110	3	1.12	0.95;
	1423	1	0.58	0.21	0	0	1	1.10808	-4.82148	110	3	1.12	0.95;
	1424	1	1.17	2.97	0	0	1	1.11993	0.07233	110	3	1.12	0.95;
	1425	1	3.75	1.27	0	0	1	1.09452	-8.18306	110	3	1.12	0.95;
	1426	1	1.64	0.56	0	0	1	1.09453	-8.19385	110	3	1.12	0.95;
	1427	1	15.2	4.79	0	0	1	1.09866	-6.08709	110	3	1.12	0.95;
	1428	1	9.59	4.22	0	0	1	1.09864	-6.09794	110	3	1.12	0.95;
	1429	1	1.17	0	0	0	1	1.10639	-4.76116	110	3	1.12	0.95;
	1430	1	0.35	0	0	0	1	1.10644	-4.75145	110	3	1.12	0.95;
	1431	1	8.2	3.65	0	0	1	1.10845	-4.88967	110	3	1.12	0.95;
	1432	1	8.2	3.65	0	0	1	1.10846	-4.90049	110	3	1.12	0.95;
	1433	1	1.76	0.57	0	0	1	1.08882	-7.50393	110	3	1.12	0.95;
	1434	1	3.05	-0.25	0	0	1	1.08879	-7.50632	110	3	1.12	0.95;
	1435	1	9.18	4.85	0	0	1	1.06265	-9.20437	110	3	1.12	0.95;
	1436	1	4.34	2.33	0	0	1	1.06261	-9.19764	110	3	1.12	0.95;
	1437	1	0.82	0.35	0	0	1	1.10525	-5.42351	110	3	1.12	0.95;
	1438	1	0	0	0	0	1	1.10526	-5.4234	110	3	1.12	0.95;
	1439	1	4.91	2.36	0	0	1	1.11849	-1.02444	110	3	1.12	0.95;
	1440	1	5.03	2.36	0	0	1	1.11597	-1.50084	110	3	1.12	0.95;
	1441	1	1.05	-0.2	0	0	1	1.1064	-5.78345	110	3	1.12	0.95;
	1442	1	4.21	0.93	0	0	1	1.10634	-5.7918	110	3	1.12	0.95;
	1443	1	4.21	2.38	0	0	1	1.09939	-6.73049	110	3	1.12	0.95;
	1444	1	11.47	4.9	0	0	1	1.1	-6.66056	110	3	1.12	0.95;
	1445	1	6.69	2.87	0	0	1	1.09536	-7.39412	110	3	1.12	0.95;
	1446	1	5.4	2.96	0	0	1	1.09528	-7.39884	110	3	1.12	0.95;
	1447	1	5.74	1.08	0	0	1	1.08087	-10.29561	110	3	1.12	0.95;
	1448	1	11.38	2.66	0	0	1	1.08008	-10.35951	110	3	1.12	0.95;
	1449	1	0	0	0	0	1	1.08136	-10.27537	110	3	1.12	0.95;
	1450	1	0	0	0	0	1	1.08077	-10.33208	110	3	1.12	0.95;
	1451	1	8.31	3.02	0	0	1	1.11487	-0.86186	110	3	1.12	0.95;
	1452	1	0	0	0	0	1	1.11487	-0.86879	110	3	1.12	0.95;
	1453	1	0	0	0	0	1	1.11808	-0.34467	110	3	1.12	0.95;
	1454	1	0	0	0	0	1	1.1182	-1.02809	110	3	1.12	0.95;
	1455	1	10.53	3.03	0	0	1	1.09733	-7.44219	110	3	1.12	0.95;
	1456	1	6.79	0.77	0	0	1	1.09739	-7.44063	110	3	1.12	0.95;
	1457	1	3.74	1.64	0	0	1	1.11812	-1.14214	110	3	1.12	0.95;
	1458	1	3.27	1.52	0	0	1	1.11809	-1.13027	110	3	1.12	0.95;
	1459	1	5.85	1.94	0	0	1	1.09914	-6.37167	110	3	1.12	0.95;
	1460	1	0	0	0	0	1	1.09915	-6.37127	110	3	1.12	0.95;
	1461	1	5.03	1.3	0	0	1	1.1012	-5.24072	110	3	1.12	0.95;
	1462	1	4.1	1.26	0	0	1	1.10118	-5.25534	110	3	1.12	0.95;
	1463	1	7.62	2.43	0	0	1	1.11566	-6.99522	110	3	1.12	0.95;
	1464	1	5.86	1.71	0	0	1	1.11586	-6.97473	110	3	1.12	0.95;
	1465	1	8.22	1.82	0	0	1	1.09933	-7.18929	110	3	1.12	0.95;
	1466	1	0	0	0	0	1	1.09925	-7.19035	110	3	1.12	0.95;
	1467	1	5.61	-0.01	0	0	1	1.07121	-13.60301	110	3	1.12	0.95;
	1468	1	9.72	2.81	0	0	1	1.07117	-13.61587	110	3	1.12	0.95;
	1469	2	0.01	0.01	0	0	1	1.10917	-3.587	110	3	1.12	0.95;
	1470	2	90.54	33.94	0	0	1	1.10912	-3.6089	110	3	1.12	0.95;
	1471	2	28.45	7.41	0	0	1	1.10014	-6.18499	110	3	1.12	0.95;
	1472	1	19.33	7.43	0	0	1	1.1002	-6.19041	110	3	1.12	0.95;
	1473	1	1.4	0.23	0	0	1	1.10505	-3.99671	110	3	1.12	0.95;
	1474	1	7.25	2.05	0	0	1	1.11473	-1.11628	110	3	1.12	0.95;
	1475	1	0	0	0	0	1	1.10507	-3.9959	110	3	1.12	0.95;
	1476	1	0	0	0	0	1	1.1148	-1.11259	110	3	1.12	0.95;
	1477	1	0	0	0	0	1	1.09262	-10.60211	110	3	1.12	0.95;
	1478	1	0	0	0	0	1	1.09492	-11.44291	110	3	1.12	0.95;
	1479	1	3.39	1.04	0	0	1	1.10886	-3.81777	110	3	1.12	0.95;
	1480	1	3.39	1.04	0	0	1	1.10887	-3.8165	110	3	1.12	0.95;
	1481	1	8.79	3.43	0	0	1	1.11652	-1.43673	110	3	1.12	0.95;
	1482	1	0	0	0	0	1	1.11655	-1.43342	110	3	1.12	0.95;
	1483	1	0.7	0.24	0	0	1	1.11846	-1.02329	110	3	1.12	0.95;
	1484	1	0	0	0	0	1	1.1185	-1.02102	110	3	1.12	0.95;
	1485	1	0	0	0	0	1	1.09418	-7.10821	110	3	1.12	0.95;
	1486	1	0	0	0	0	1	1.09422	-7.09835	110	3	1.12	0.95;
	1487	1	0	0	0	0	1	1.09439	-7.24605	110	3	1.12	0.95;
	1488	1	9.95	2.69	0	0	1	1.09432	-7.24348	110	3	1.12	0.95;
	1489	1	1.87	0.95	0	0	1	1.09632	-6.73525	110	3	1.12	0.95;
	1490	1	0	0	0	0	1	1.09635	-6.73194	110	3	1.12	0.95;
	1491	1	5.15	1.91	0	0	1	1.07668	-6.58725	110	3	1.12	0.95;
	1492	1	6.21	2.1	0	0	1	1.07672	-6.60224	110	3	1.12	0.95;
	1493	1	6.31	2.17	0	0	1	1.10051	-4.27587	110	3	1.12	0.95;
	1494	1	2.1	0.68	0	0	1	1.11636	-1.60224	110	3	1.12	0.95;
	1495	1	10.41	5.25	0	0	1	1.10194	-4.15375	110	3	1.12	0.95;
	1496	1	0	0	0	0	1	1.101	-4.2529	110	3	1.12	0.95;
	1497	1	10.8	4.64	0	0	1	1.0956	-7.74585	110	3	1.12	0.95;
	1498	1	0	0	0	0	1	1.09629	-7.70274	110	3	1.12	0.95;
	1499	1	5.74	0.75	0	0	1	1.11299	-7.03497	110	3	1.12	0.95;
	1500	1	7.27	1.31	0	0	1	1.11295	-7.02861	110	3	1.12	0.95;
	1501	1	11.7	3.94	0	0	1	1.11049	-1.24901	110	3	1.12	0.95;
	1502	1	0	0	0	0	1	1.11074	-1.21403	110	3	1.12	0.95;
	1503	1	7.61	2.25	0	0	1	1.09156	-8.68689	110	3	1.12	0.95;
	1504	1	2.57	0.83	0	0	1	1.09155	-8.68122	110	3	1.12	0.95;
	1505	2	12.51	1.85	0	0	1	1.11395	-1.53043	110	3	1.12	0.95;
	1506	1	0	0	0	0	1	1.114	-1.51785	110	3	1.12	0.95;
	1507	1	14.75	4.62	0	0	1	1.08992	-5.95863	110	3	1.12	0.95;
	1508	1	0	0	0	0	1	1.08995	-5.97269	110	3	1.12	0.95;
	1509	1	2.34	0.93	0	0	1	1.11051	-5.01546	110	3	1.12	0.95;
	1510	1	6.33	2.44	0	0	1	1.10181	-6.18234	110	3	1.12	0.95;
	1511	2	12.57	8.92	0	0	1	1.11226	-5.93781	110	3	1.12	0.95;
	1512	2	10.05	44.21	0	0	1	1.12	-3.52986	110	3	1.12	0.95;
	1513	2	10.05	44.21	0	0	1	1.11825	-0.70054	110	3	1.12	0.95;
	1514	1	11.48	3.49	0	0	1	1.11236	-6.84712	110	3	1.12	0.95;
	1515	1	9.37	3.1	0	0	1	1.11235	-6.848	110	3	1.12	0.95;
	1516	1	0	0	0	0	1	1.06469	-7.56723	110	3	1.12	0.95;
	1517	1	5.87	2.06	0	0	1	1.0647	-7.55682	110	3	1.12	0.95;
	1518	1	1.29	0.34	0	0	1	1.09846	-7.3834	110	3	1.12	0.95;
	1519	1	1.52	0.58	0	0	1	1.09846	-7.39968	110	3	1.12	0.95;
	1520	1	4.79	2.4	0	0	1	1.10919	-1.43983	110	3	1.12	0.95;
	1521	1	7.83	5.02	0	0	1	1.10923	-1.43692	110	3	1.12	0.95;
	1522	1	6.08	0.23	0	0	1	1.09532	-4.85824	110	3	1.12	0.95;
	1523	1	11.81	2.21	0	0	1	1.09535	-4.85617	110	3	1.12	0.95;
	1524	1	1.99	4.38	0	0	1	1.09916	-3.32172	110	3	1.12	0.95;
	1525	1	8.8	3.47	0	0	1	1.09927	-3.32692	110	3	1.12	0.95;
	1526	1	3.28	1.22	0	0	1	1.09282	-7.08034	110	3	1.12	0.95;
	1527	1	1.64	0.67	0	0	1	1.0928	-7.08323	110	3	1.12	0.95;
	1528	1	9.64	3.71	0	0	1	1.09722	-10.64895	110	3	1.12	0.95;
	1529	1	0	0	0	0	1	1.09716	-10.6599	110	3	1.12	0.95;
	1530	1	6.44	2.08	0	0	1	1.07135	-13.38619	110	3	1.12	0.95;
	1531	1	6.56	1.74	0	0	1	1.07136	-13.38272	110	3	1.12	0.95;
	1532	1	7.38	3.08	0	0	1	1.11557	-4.293	110	3	1.12	0.95;
	1533	1	4.93	1.71	0	0	1	1.11565	-4.30993	110	3	1.12	0.95;
	1534	1	0	0	0	0	1	1.09707	-6.536	110	3	1.12	0.95;
	1535	1	0	0	0	0	1	1.09707	-6.53591	110	3	1.12	0.95;
	1536	1	1.99	0.58	0	0	1	1.0823	-7.69335	110	3	1.12	0.95;
	1537	1	1.76	0.44	0	0	1	1.08228	-7.69756	110	3	1.12	0.95;
	1538	1	0	0.09	0	0	1	1.10127	-5.6045	110	3	1.12	0.95;
	1539	1	5.39	1.79	0	0	1	1.10127	-5.62101	110	3	1.12	0.95;
	1540	1	0	0	0	0	1	1.11921	-0.83965	110	3	1.12	0.95;
	1541	1	0	0	0	0	1	1.1192	-0.83514	110	3	1.12	0.95;
	1542	1	9.82	3.88	0	0	1	1.10511	-3.62249	110	3	1.12	0.95;
	1543	1	0	0	0	0	1	1.10514	-3.62092	110	3	1.12	0.95;
	1544	1	0	0	0	0	1	1.11352	-2.06059	110	3	1.12	0.95;
	1545	1	7.97	3.12	0	0	1	1.09674	-2.97133	110	3	1.12	0.95;
	1546	1	0	0	0	0	1	1.11351	-2.06048	110	3	1.12	0.95;
	1547	1	0	0	0	0	1	1.0973	-2.94522	110	3	1.12	0.95;
	1548	1	6.08	1.94	0	0	1	1.11579	-1.0757	110	3	1.12	0.95;
	1549	1	4.33	1.48	0	0	1	1.11578	-1.08614	110	3	1.12	0.95;
	1550	1	8.89	3.11	0	0	1	1.11148	-2.59273	110	3	1.12	0.95;
	1551	1	0	0	0	0	1	1.11176	-2.57307	110	3	1.12	0.95;
	1552	1	0	0	0	0	1	1.10591	-3.87008	110	3	1.12	0.95;
	1553	1	1.87	0.58	0	0	1	1.10769	-3.62287	110	3	1.12	0.95;
	1554	1	0	0	0	0	1	1.10591	-3.87008	110	3	1.12	0.95;
	1555	1	0	0	0	0	1	1.1077	-3.622	110	3	1.12	0.95;
	1556	1	7.62	1.79	0	0	1	1.11575	-6.98705	110	3	1.12	0.95;
	1557	1	8.32	2.2	0	0	1	1.11592	-6.96831	110	3	1.12	0.95;
	1558	1	0	0	0	0	1	1.07934	-4.93811	110	3	1.12	0.95;
	1559	1	8.34	2.27	0	0	1	1.07934	-4.93314	110	3	1.12	0.95;
	1560	1	4.92	1.64	0	0	1	1.07906	-6.33004	110	3	1.12	0.95;
	1561	1	3.51	0.53	0	0	1	1.07911	-6.31773	110	3	1.12	0.95;
	1562	1	3.51	1.32	0	0	1	1.10606	-3.43849	110	3	1.12	0.95;
	1563	1	6.44	2.41	0	0	1	1.1061	-3.44215	110	3	1.12	0.95;
	1564	1	10.66	1.16	0	0	1	1.06161	-10.99187	110	3	1.12	0.95;
	1565	1	8.66	-1.96	0	0	1	1.06162	-11.0042	110	3	1.12	0.95;
	1566	1	5.98	2.84	0	0	1	1.1089	-1.44348	110	3	1.12	0.95;
	1567	1	6.08	2.05	0	0	1	1.09764	-2.67327	110	3	1.12	0.95;
	1568	1	6.66	2.51	0	0	1	1.11472	-0.94254	110	3	1.12	0.95;
	1569	1	0	0	0	0	1	1.09371	-4.68676	110	3	1.12	0.95;
	1570	2	39.71	14.09	0	0	1	1.09368	-4.68841	110	3	1.12	0.95;
	1571	1	9.71	-0.3	0	0	1	1.10625	-4.13172	110	3	1.12	0.95;
	1572	1	6.43	1.4	0	0	1	1.09273	-4.85796	110	3	1.12	0.95;
	1573	1	0	0	0	0	1	1.1063	-4.12716	110	3	1.12	0.95;
	1574	1	10.88	4.72	0	0	1	1.09218	-5.79636	110	3	1.12	0.95;
	1575	1	3.16	1.17	0	0	1	1.09873	-3.94405	110	3	1.12	0.95;
	1576	1	6.21	1.73	0	0	1	1.08194	-12.58107	110	3	1.12	0.95;
	1577	1	0	0	0	0	1	1.0819	-12.60341	110	3	1.12	0.95;
	1578	2	12.65	16.38	0	0	1	1.11095	-4.87512	110	3	1.12	0.95;
	1579	2	12.65	16.22	0	0	1	1.1186	-1.11636	110	3	1.12	0.95;
	1580	2	7.03	14.07	0	0	1	1.11987	0.21118	110	3	1.12	0.95;
	1581	1	5.51	1.38	0	0	1	1.08533	-9.92484	110	3	1.12	0.95;
	1582	1	5.63	1.38	0	0	1	1.08527	-9.92066	110	3	1.12	0.95;
	1583	1	7.96	2.77	0	0	1	1.11801	-3.67277	110	3	1.12	0.95;
	1584	1	9.72	4.14	0	0	1	1.1152	-0.95595	110	3	1.12	0.95;
	1585	1	0	0	0	0	1	1.11838	-3.65667	110	3	1.12	0.95;
	1586	1	0	0	0	0	1	1.11567	-0.93756	110	3	1.12	0.95;
	1587	1	12.34	4.41	0	0	1	1.06926	-13.78748	110	3	1.12	0.95;
	1588	1	18.15	6.57	0	0	1	1.06928	-13.8015	110	3	1.12	0.95;
	1589	1	8.77	6.85	0	0	1	1.11779	-0.73277	110	3	1.12	0.95;
	1590	2	20.31	49.37	0	0	1	1.12	-1.54546	110	3	1.12	0.95;
	1591	1	9.61	0.16	0	0	1	1.08416	-7.49551	110	3	1.12	0.95;
	1592	1	9.14	1.11	0	0	1	1.08415	-7.49065	110	3	1.12	0.95;
	1593	1	1.29	0.54	0	0	1	1.11667	-1.38048	110	3	1.12	0.95;
	1594	1	2.11	0.93	0	0	1	1.1166	-1.4108	110	3	1.12	0.95;
	1595	1	36.46	16.57	0	0	1	1.10785	-1.47472	110	3	1.12	0.95;
	1596	1	11.44	4.79	0	0	1	1.10792	-1.46498	110	3	1.12	0.95;
	1597	1	4.1	1.11	0	0	1	1.10822	-4.52629	110	3	1.12	0.95;
	1598	1	7.02	2.45	0	0	1	1.10157	-5.37099	110	3	1.12	0.95;
	1599	1	0	0	0	0	1	1.1085	-4.51157	110	3	1.12	0.95;
	1600	1	0	0	0	0	1	1.1021	-5.34696	110	3	1.12	0.95;
	1601	2	11.18	16.4	0	0	1	1.12	-6.28409	110	3	1.12	0.95;
	1602	2	12.35	18.11	0	0	1	1.12	-6.26908	110	3	1.12	0.95;
	1603	2	12.06	26.12	0	0	1	1.11894	-6.64618	110	3	1.12	0.95;
	1604	1	5.82	2	0	0	1	1.11044	-1.37988	110	3	1.12	0.95;
	1605	1	5.82	2	0	0	1	1.11054	-1.37199	110	3	1.12	0.95;
	1606	1	6.68	2.66	0	0	1	1.11276	-1.76841	110	3	1.12	0.95;
	1607	1	3.86	1.44	0	0	1	1.11269	-1.77963	110	3	1.12	0.95;
	1608	1	19.06	8.66	0	0	1	1.10043	-2.42127	110	3	1.12	0.95;
	1609	1	0	0	0	0	1	1.10035	-2.43317	110	3	1.12	0.95;
	1610	1	15.69	5.31	0	0	1	1.1164	-0.64897	110	3	1.12	0.95;
	1611	1	0	0	0	0	1	1.11637	-0.65911	110	3	1.12	0.95;
	1612	1	1.29	0.59	0	0	1	1.1039	-5.00333	110	3	1.12	0.95;
	1613	1	0	0.09	0	0	1	1.10392	-5.00026	110	3	1.12	0.95;
	1614	1	17.9	3.08	0	0	1	1.11333	-6.98542	110	3	1.12	0.95;
	1615	1	18.95	3.21	0	0	1	1.1099	-6.94856	110	3	1.12	0.95;
	1616	1	0	0	0	0	1	1.10162	-6.76951	110	3	1.12	0.95;
	1617	1	0	0	0	0	1	1.10177	-6.74585	110	3	1.12	0.95;
	1618	1	8.56	3.84	0	0	1	1.10519	-3.87397	110	3	1.12	0.95;
	1619	1	3.51	1.57	0	0	1	1.1053	-3.87686	110	3	1.12	0.95;
	1620	1	14.53	6.11	0	0	1	1.07014	-11.02461	110	3	1.12	0.95;
	1621	1	11.7	3.59	0	0	1	1.07019	-11.04019	110	3	1.12	0.95;
	1622	1	8.08	1.17	0	0	1	1.11644	-6.54166	110	3	1.12	0.95;
	1623	1	13.35	2.78	0	0	1	1.1166	-6.54948	110	3	1.12	0.95;
	1624	1	4.69	2.14	0	0	1	1.09764	-6.7801	110	3	1.12	0.95;
	1625	1	0	0	0	0	1	1.09784	-6.76984	110	3	1.12	0.95;
	1626	1	18.6	7.54	0	0	1	1.1171	-1.06445	110	3	1.12	0.95;
	1627	1	18.48	7.59	0	0	1	1.11712	-1.0599	110	3	1.12	0.95;
	1628	1	4.91	1.05	0	0	1	1.10036	-4.36357	110	3	1.12	0.95;
	1629	1	3.04	-0.1	0	0	1	1.10358	-3.73426	110	3	1.12	0.95;
	1630	1	0	0	0	0	1	1.10042	-4.35966	110	3	1.12	0.95;
	1631	1	0	0	0	0	1	1.12	-0.7492	110	3	1.12	0.95;
	1632	1	0	0	0	0	1	1.11999	-0.74537	110	3	1.12	0.95;
	1633	1	5.51	1.99	0	0	1	1.09346	-6.53743	110	3	1.12	0.95;
	1634	1	3.39	1.25	0	0	1	1.09083	-6.61877	110	3	1.12	0.95;
	1635	1	0	0	0	0	1	1.09365	-6.52941	110	3	1.12	0.95;
	1636	1	0	0	0	0	1	1.09095	-6.61381	110	3	1.12	0.95;
	1637	1	4.91	1.86	0	0	1	1.10056	-5.75783	110	3	1.12	0.95;
	1638	1	0	0.12	0	0	1	1.10059	-5.77046	110	3	1.12	0.95;
	1639	1	16.64	6.66	0	0	1	1.10537	-6.20002	110	3	1.12	0.95;
	1640	1	8.07	2.94	0	0	1	1.1058	-6.17715	110	3	1.12	0.95;
	1641	1	0	0	0	0	1	1.09591	-6.33195	110	3	1.12	0.95;
	1642	1	0	0	0	0	1	1.09406	-6.87252	110	3	1.12	0.95;
	1643	1	0	0	0	0	1	1.09655	-6.65818	110	3	1.12	0.95;
	1644	2	4.02	4.02	0	0	1	1.0997	-6.38604	110	3	1.12	0.95;
	1645	1	8.07	0.77	0	0	1	1.09781	-6.86343	110	3	1.12	0.95;
	1646	1	3.98	0.18	0	0	1	1.09782	-6.86327	110	3	1.12	0.95;
	1647	1	12.06	6.56	0	0	1	1.09666	-6.66888	110	3	1.12	0.95;
	1648	1	0	0	0	0	1	1.09666	-6.66778	110	3	1.12	0.95;
	1649	1	4.92	2.23	0	0	1	1.11966	0.08819	110	3	1.12	0.95;
	1650	1	2.22	1.02	0	0	1	1.11969	0.08634	110	3	1.12	0.95;
	1651	1	0.23	0.04	0	0	1	1.11775	-1.28002	110	3	1.12	0.95;
	1652	1	0.47	0.15	0	0	1	1.1177	-1.26969	110	3	1.12	0.95;
	1653	1	8.43	2.24	0	0	1	1.1016	-6.60489	110	3	1.12	0.95;
	1654	1	11.37	3.58	0	0	1	1.10174	-6.59793	110	3	1.12	0.95;
	1655	1	5.74	0.29	0	0	1	1.06436	-6.42162	110	3	1.12	0.95;
	1656	1	5.85	2.07	0	0	1	1.06433	-6.41064	110	3	1.12	0.95;
	1657	1	1.64	0.69	0	0	1	1.11989	-0.68621	110	3	1.12	0.95;
	1658	1	0	0	0	0	1	1.11989	-0.68615	110	3	1.12	0.95;
	1659	2	20.6	8.69	0	0	1	1.09764	-4.24432	110	3	1.12	0.95;
	1660	2	7.15	2.3	0	0	1	1.09483	-2.42679	110	3	1.12	0.95;
	1661	2	9.96	8	0	0	1	1.10648	-2.00687	110	3	1.12	0.95;
	1662	2	15.1	8.05	0	0	1	1.1077	-1.84293	110	3	1.12	0.95;
	1663	1	0	0	0	0	1	1.10661	-2.01545	110	3	1.12	0.95;
	1664	1	13.12	4.76	0	0	1	1.08511	-8.74683	110	3	1.12	0.95;
	1665	1	18.07	6.43	0	0	1	1.08505	-8.77498	110	3	1.12	0.95;
	1666	2	29.76	42.87	0	0	1	1.12	-0.62105	110	3	1.12	0.95;
	1667	1	7.96	4.16	0	0	1	1.11994	-0.65027	110	3	1.12	0.95;
	1668	1	0	0	0	0	1	1.11425	-4.09191	110	3	1.12	0.95;
	1669	1	0	0	0	0	1	1.11425	-4.09187	110	3	1.12	0.95;
	1670	1	7.97	2.77	0	0	1	1.11154	-4.20475	110	3	1.12	0.95;
	1671	1	6.91	2.68	0	0	1	1.10865	-4.52752	110	3	1.12	0.95;
	1672	1	0	0	0	0	1	1.11211	-4.1639	110	3	1.12	0.95;
	1673	1	0	0	0	0	1	1.10919	-4.49114	110	3	1.12	0.95;
	1674	1	3.4	0.52	0	0	1	1.07167	-13.41301	110	3	1.12	0.95;
	1675	1	3.28	1.08	0	0	1	1.07165	-13.41343	110	3	1.12	0.95;
	1676	1	0	0.1	0	0	1	1.09903	-6.80066	110	3	1.12	0.95;
	1677	1	0	0	0	0	1	1.09903	-6.79801	110	3	1.12	0.95;
	1678	1	8.19	1.43	0	0	1	1.09122	-6.45458	110	3	1.12	0.95;
	1679	1	4.44	1.54	0	0	1	1.0911	-6.44901	110	3	1.12	0.95;
	1680	1	9.49	2.63	0	0	1	1.08598	-4.80058	110	3	1.12	0.95;
	1681	1	6.21	1.6	0	0	1	1.08599	-4.81504	110	3	1.12	0.95;
	1682	1	8.91	1.85	0	0	1	1.07299	-13.11516	110	3	1.12	0.95;
	1683	1	9.15	1.88	0	0	1	1.07297	-13.12077	110	3	1.12	0.95;
	1684	1	13.92	1.23	0	0	1	1.11946	-0.89312	110	3	1.12	0.95;
	1685	1	8.77	0.89	0	0	1	1.11943	-0.9003	110	3	1.12	0.95;
	1686	1	8.44	2.25	0	0	1	1.09263	-10.71453	110	3	1.12	0.95;
	1687	1	0	0	0	0	1	1.09262	-10.71088	110	3	1.12	0.95;
	1688	2	2.31	4.26	0	0	1	1.1012	-10.28593	110	3	1.12	0.95;
	1689	2	3.16	1.02	0	0	1	1.10111	-10.30168	110	3	1.12	0.95;
	1690	1	8.56	2.37	0	0	1	1.07525	-9.76389	110	3	1.12	0.95;
	1691	1	11.5	4.6	0	0	1	1.07528	-9.74389	110	3	1.12	0.95;
	1692	1	0	0	0	0	1	1.11957	-0.74031	110	3	1.12	0.95;
	1693	1	0	0	0	0	1	1.11957	-0.74031	110	3	1.12	0.95;
	1694	1	3.16	1.07	0	0	1	1.10903	-1.44791	110	3	1.12	0.95;
	1695	1	2.57	1.16	0	0	1	1.11439	-1.00483	110	3	1.12	0.95;
	1696	1	0	0	0	0	1	1.10904	-1.4473	110	3	1.12	0.95;
	1697	1	0	0	0	0	1	1.1144	-1.00438	110	3	1.12	0.95;
	1698	1	7.62	2.65	0	0	1	1.11521	-0.93027	110	3	1.12	0.95;
	1699	1	11.75	5.58	0	0	1	1.11506	-0.96515	110	3	1.12	0.95;
	1700	1	10.3	3.18	0	0	1	1.09206	-11.61641	110	3	1.12	0.95;
	1701	1	7.25	2.13	0	0	1	1.09204	-11.62008	110	3	1.12	0.95;
	1702	1	3.98	1.06	0	0	1	1.10549	-1.72884	110	3	1.12	0.95;
	1703	1	5.03	1.4	0	0	1	1.10561	-1.70359	110	3	1.12	0.95;
	1704	1	0	0	0	0	1	1.11187	-1.84874	110	3	1.12	0.95;
	1705	1	9.35	3.99	0	0	1	1.11181	-1.85854	110	3	1.12	0.95;
	1706	1	1.29	0.62	0	0	1	1.10146	-6.77993	110	3	1.12	0.95;
	1707	1	1.64	0.71	0	0	1	1.10158	-6.75913	110	3	1.12	0.95;
	1708	1	8.66	2.96	0	0	1	1.10949	-4.0114	110	3	1.12	0.95;
	1709	1	0	0.17	0	0	1	1.10956	-4.03563	110	3	1.12	0.95;
	1710	1	5.74	0.65	0	0	1	1.08023	-6.2215	110	3	1.12	0.95;
	1711	1	3.05	0.87	0	0	1	1.08026	-6.21389	110	3	1.12	0.95;
	1712	1	4.91	2.19	0	0	1	1.11055	-5.01261	110	3	1.12	0.95;
	1713	1	3.98	1.54	0	0	1	1.10979	-3.74769	110	3	1.12	0.95;
	1714	1	10.44	3.87	0	0	1	1.09546	-11.58565	110	3	1.12	0.95;
	1715	1	0	0	0	0	1	1.09544	-11.58652	110	3	1.12	0.95;
	1716	1	7.28	3.47	0	0	1	1.11369	-1.89936	110	3	1.12	0.95;
	1717	1	8.56	3.41	0	0	1	1.11357	-1.91018	110	3	1.12	0.95;
	1718	1	5.04	1.07	0	0	1	1.05587	-8.38777	110	3	1.12	0.95;
	1719	1	6.44	0.18	0	0	1	1.05588	-8.38508	110	3	1.12	0.95;
	1720	1	10.65	4.29	0	0	1	1.11873	-0.76233	110	3	1.12	0.95;
	1721	1	13.45	5.3	0	0	1	1.11876	-0.74808	110	3	1.12	0.95;
	1722	1	18.94	6.4	0	0	1	1.0793	-5.98682	110	3	1.12	0.95;
	1723	1	14.97	7.33	0	0	1	1.07931	-5.97546	110	3	1.12	0.95;
	1724	1	2.93	2.35	0	0	1	1.09414	-10.75238	110	3	1.12	0.95;
	1725	1	0	0	0	0	1	1.0942	-10.75169	110	3	1.12	0.95;
	1726	1	5.97	1.92	0	0	1	1.10042	-4.35966	110	3	1.12	0.95;
	1727	1	4.33	0.96	0	0	1	1.10361	-3.7315	110	3	1.12	0.95;
	1728	1	4.69	2.6	0	0	1	1.08876	-4.27886	110	3	1.12	0.95;
	1729	1	2.93	1.06	0	0	1	1.08872	-4.25209	110	3	1.12	0.95;
	1730	1	3.28	2.8	0	0	1	1.10996	-5.01876	110	3	1.12	0.95;
	1731	1	7.84	4.2	0	0	1	1.11166	-3.52651	110	3	1.12	0.95;
	1732	1	0	0	0	0	1	1.11242	-3.49015	110	3	1.12	0.95;
	1733	1	6.66	2.28	0	0	1	1.1139	-1.5322	110	3	1.12	0.95;
	1734	1	3.27	1.03	0	0	1	1.11395	-1.52119	110	3	1.12	0.95;
	1735	1	3.28	0.16	0	0	1	1.0889	-7.24786	110	3	1.12	0.95;
	1736	1	4.92	0.42	0	0	1	1.08898	-7.24636	110	3	1.12	0.95;
	1737	1	1.99	0.8	0	0	1	1.11785	-0.73313	110	3	1.12	0.95;
	1738	1	0.58	0.44	0	0	1	1.1075	-4.72068	110	3	1.12	0.95;
	1739	1	13.25	5.4	0	0	1	1.11434	-1.48662	110	3	1.12	0.95;
	1740	1	7.38	2.73	0	0	1	1.1142	-1.49481	110	3	1.12	0.95;
	1741	1	10.89	0.22	0	0	1	1.10301	-3.98093	110	3	1.12	0.95;
	1742	1	7.96	1.26	0	0	1	1.10301	-3.96914	110	3	1.12	0.95;
	1743	1	3.39	0.35	0	0	1	1.05448	-8.7294	110	3	1.12	0.95;
	1744	1	7.14	0.39	0	0	1	1.05448	-8.72797	110	3	1.12	0.95;
	1745	1	8.81	4.55	0	0	1	1.11783	-0.87368	110	3	1.12	0.95;
	1746	1	7.26	3.12	0	0	1	1.11782	-0.88113	110	3	1.12	0.95;
	1747	1	0	0	0	0	1	1.08061	-5.02619	110	3	1.12	0.95;
	1748	1	0	0	0	0	1	1.08068	-5.02536	110	3	1.12	0.95;
	1749	1	0	0	0	0	1	1.11532	-0.79557	110	3	1.12	0.95;
	1750	1	20.62	12.15	0	0	1	1.11533	-0.78972	110	3	1.12	0.95;
	1751	1	3.05	1.43	0	0	1	1.07123	-13.36358	110	3	1.12	0.95;
	1752	1	1.17	0.29	0	0	1	1.07123	-13.36426	110	3	1.12	0.95;
	1753	1	1.4	0.19	0	0	1	1.11884	-0.98536	110	3	1.12	0.95;
	1754	1	0	0	0	0	1	1.11887	-0.98327	110	3	1.12	0.95;
	1755	1	9.35	2.33	0	0	1	1.09614	-4.8185	110	3	1.12	0.95;
	1756	1	0	0	0	0	1	1.1015	-4.37135	110	3	1.12	0.95;
	1757	1	0	0	0	0	1	1.09654	-4.79717	110	3	1.12	0.95;
	1758	1	0	0	0	0	1	1.1015	-4.3713	110	3	1.12	0.95;
	1759	1	15.73	5.1	0	0	1	1.09954	-7.92485	110	3	1.12	0.95;
	1760	1	10.67	3.1	0	0	1	1.09953	-7.93014	110	3	1.12	0.95;
	1761	1	5.62	1.15	0	0	1	1.08943	-4.27714	110	3	1.12	0.95;
	1762	1	0	0	0	0	1	1.08675	-4.46173	110	3	1.12	0.95;
	1763	1	0	0	0	0	1	1.08944	-4.27613	110	3	1.12	0.95;
	1764	1	5.73	1.14	0	0	1	1.07584	-12.76623	110	3	1.12	0.95;
	1765	1	7.27	1.45	0	0	1	1.11554	-6.88933	110	3	1.12	0.95;
	1766	1	12.19	3.03	0	0	1	1.11527	-6.92009	110	3	1.12	0.95;
	1767	1	16.02	4.91	0	0	1	1.08985	-3.94358	110	3	1.12	0.95;
	1768	1	20.46	6.62	0	0	1	1.08928	-3.39613	110	3	1.12	0.95;
	1769	1	7.02	2.6	0	0	1	1.09111	-2.65485	110	3	1.12	0.95;
	1770	1	6.2	2.05	0	0	1	1.09102	-2.66528	110	3	1.12	0.95;
	1771	1	4.46	2.05	0	0	1	1.11748	-1.34096	110	3	1.12	0.95;
	1772	1	0	0	0	0	1	1.11744	-1.33973	110	3	1.12	0.95;
	1773	1	5.62	2.12	0	0	1	1.09759	-6.28699	110	3	1.12	0.95;
	1774	1	2.11	0.93	0	0	1	1.09834	-6.19747	110	3	1.12	0.95;
	1775	1	0	0	0	0	1	1.09783	-6.27078	110	3	1.12	0.95;
	1776	1	0	0	0	0	1	1.09844	-6.19131	110	3	1.12	0.95;
	1777	1	6.44	1.54	0	0	1	1.09898	-6.82092	110	3	1.12	0.95;
	1778	1	0	0	0	0	1	1.09901	-6.81938	110	3	1.12	0.95;
	1779	1	1.52	0.67	0	0	1	1.10274	-3.31837	110	3	1.12	0.95;
	1780	1	2.69	0.72	0	0	1	1.10271	-3.33729	110	3	1.12	0.95;
	1781	1	10.67	2.88	0	0	1	1.11748	-6.50422	110	3	1.12	0.95;
	1782	1	8.56	2.73	0	0	1	1.11741	-6.51636	110	3	1.12	0.95;
	1783	1	10.52	4.17	0	0	1	1.1012	-5.73093	110	3	1.12	0.95;
	1784	1	0	0	0	0	1	1.1024	-5.65616	110	3	1.12	0.95;
	1785	1	1.17	0.42	0	0	1	1.09203	-11.63184	110	3	1.12	0.95;
	1786	1	1.29	0.31	0	0	1	1.09204	-11.63227	110	3	1.12	0.95;
	1787	1	21.9	7.18	0	0	1	1.08863	-6.48896	110	3	1.12	0.95;
	1788	1	0	0	0	0	1	1.09056	-6.38591	110	3	1.12	0.95;
	1789	1	0	0	0	0	1	1.08903	-6.46599	110	3	1.12	0.95;
	1790	1	0	0	0	0	1	1.09056	-6.3859	110	3	1.12	0.95;
	1791	1	9.15	1.61	0	0	1	1.07869	-7.1606	110	3	1.12	0.95;
	1792	1	3.98	0.24	0	0	1	1.07862	-7.1571	110	3	1.12	0.95;
	1793	1	0	0	0	0	1	1.10992	-5.46584	110	3	1.12	0.95;
	1794	1	0	0	0	0	1	1.10982	-5.46933	110	3	1.12	0.95;
	1795	1	0	0	0	0	1	1.10451	-4.20155	110	3	1.12	0.95;
	1796	1	1.17	-0.2	0	0	1	1.10451	-4.20155	110	3	1.12	0.95;
	1797	1	0	0	0	0	1	1.08843	-5.18407	110	3	1.12	0.95;
	1798	1	0	0	0	0	1	1.10455	-4.19498	110	3	1.12	0.95;
	1799	1	16.61	3.21	0	0	1	1.11344	-6.95984	110	3	1.12	0.95;
	1800	1	19.18	3.44	0	0	1	1.11002	-6.92062	110	3	1.12	0.95;
	1801	1	11.15	1.88	0	0	1	1.09932	-6.6213	110	3	1.12	0.95;
	1802	1	0	0	0	0	1	1.09933	-6.614	110	3	1.12	0.95;
	1803	1	6.79	1.85	0	0	1	1.10979	-7.89721	110	3	1.12	0.95;
	1804	1	7.38	1.54	0	0	1	1.10978	-7.87889	110	3	1.12	0.95;
	1805	1	7.83	1.75	0	0	1	1.05074	-9.1399	110	3	1.12	0.95;
	1806	1	7.72	0.58	0	0	1	1.07761	-5.61159	110	3	1.12	0.95;
	1807	1	3.74	1.48	0	0	1	1.10018	-4.18852	110	3	1.12	0.95;
	1808	1	0.58	0.46	0	0	1	1.10014	-4.20915	110	3	1.12	0.95;
	1809	1	5.86	0.92	0	0	1	1.09182	-10.82568	110	3	1.12	0.95;
	1810	1	2.34	0.43	0	0	1	1.09185	-10.84057	110	3	1.12	0.95;
	1811	1	8.54	3.76	0	0	1	1.10312	-5.32394	110	3	1.12	0.95;
	1812	1	3.04	0.8	0	0	1	1.10323	-5.31765	110	3	1.12	0.95;
	1813	1	6.56	2.56	0	0	1	1.09787	-3.44785	110	3	1.12	0.95;
	1814	1	0	0	0	0	1	1.09786	-3.43107	110	3	1.12	0.95;
	1815	1	9.85	3.09	0	0	1	1.10393	-5.29905	110	3	1.12	0.95;
	1816	1	13.48	5.42	0	0	1	1.10388	-5.32057	110	3	1.12	0.95;
	1817	1	4.56	1.68	0	0	1	1.11327	-1.55143	110	3	1.12	0.95;
	1818	1	9.37	3.55	0	0	1	1.11332	-1.57377	110	3	1.12	0.95;
	1819	1	2.93	0.48	0	0	1	1.07979	-13.06388	110	3	1.12	0.95;
	1820	1	1.87	0.56	0	0	1	1.07978	-13.06462	110	3	1.12	0.95;
	1821	1	10.56	4.22	0	0	1	1.089	-4.31509	110	3	1.12	0.95;
	1822	1	4.92	1.83	0	0	1	1.08908	-4.29822	110	3	1.12	0.95;
	1823	1	0	0	0	0	1	1.11527	-0.82846	110	3	1.12	0.95;
	1824	1	0	0	0	0	1	1.11527	-0.82844	110	3	1.12	0.95;
	1825	1	14.63	5.76	0	0	1	1.09337	-6.87787	110	3	1.12	0.95;
	1826	1	0	0	0	0	1	1.09336	-6.88002	110	3	1.12	0.95;
	1827	1	16.88	6.99	0	0	1	1.09903	-3.92197	110	3	1.12	0.95;
	1828	1	0	0	0	0	1	1.09905	-3.92088	110	3	1.12	0.95;
	1829	1	5.74	1.99	0	0	1	1.09178	-11.43506	110	3	1.12	0.95;
	1830	1	0	0	0	0	1	1.09172	-11.42489	110	3	1.12	0.95;
	1831	1	8.91	2.27	0	0	1	1.08661	-9.57032	110	3	1.12	0.95;
	1832	1	12.65	3.91	0	0	1	1.08662	-9.58167	110	3	1.12	0.95;
	1833	1	11.13	3.29	0	0	1	1.10019	-6.0163	110	3	1.12	0.95;
	1834	1	7.85	1.89	0	0	1	1.10026	-6.0247	110	3	1.12	0.95;
	1835	1	1.99	0.68	0	0	1	1.07211	-8.11107	110	3	1.12	0.95;
	1836	1	2.69	1.3	0	0	1	1.07205	-8.11653	110	3	1.12	0.95;
	1837	1	5.03	1.41	0	0	1	1.09955	-6.47251	110	3	1.12	0.95;
	1838	1	0	0	0	0	1	1.09956	-6.47203	110	3	1.12	0.95;
	1839	1	6.31	0.68	0	0	1	1.09992	-2.39326	110	3	1.12	0.95;
	1840	1	0	0	0	0	1	1.09996	-2.3758	110	3	1.12	0.95;
	1841	1	3.05	1.86	0	0	1	1.11839	-6.65355	110	3	1.12	0.95;
	1842	1	6.56	-0.06	0	0	1	1.11838	-6.65311	110	3	1.12	0.95;
	1843	1	2.34	1.04	0	0	1	1.11123	-2.89006	110	3	1.12	0.95;
	1844	1	0	0	0	0	1	1.11187	-2.84163	110	3	1.12	0.95;
	1845	1	5.61	2	0	0	1	1.09835	-6.28528	110	3	1.12	0.95;
	1846	1	3.04	0.71	0	0	1	1.09839	-6.2896	110	3	1.12	0.95;
	1847	1	9.96	3.75	0	0	1	1.10791	-1.86247	110	3	1.12	0.95;
	1848	1	0	0	0	0	1	1.10811	-1.82375	110	3	1.12	0.95;
	1849	1	1.52	0.34	0	0	1	1.1143	-1.13691	110	3	1.12	0.95;
	1850	1	0	0	0	0	1	1.11435	-1.13319	110	3	1.12	0.95;
	1851	1	5.4	2.91	0	0	1	1.09753	-7.38014	110	3	1.12	0.95;
	1852	1	5.86	1.71	0	0	1	1.09749	-7.386	110	3	1.12	0.95;
	1853	1	12.31	5.9	0	0	1	1.10504	-1.94494	110	3	1.12	0.95;
	1854	1	11.37	4.64	0	0	1	1.10525	-1.92152	110	3	1.12	0.95;
	1855	1	9.38	3.26	0	0	1	1.09602	-4.73649	110	3	1.12	0.95;
	1856	1	6.68	2.43	0	0	1	1.09612	-4.70716	110	3	1.12	0.95;
	1857	1	0	0	0	0	1	1.09922	-6.58956	110	3	1.12	0.95;
	1858	1	0	0	0	0	1	1.09895	-6.59429	110	3	1.12	0.95;
	1859	1	0	0	0	0	1	1.099	-5.32012	110	3	1.12	0.95;
	1860	1	8.31	3.59	0	0	1	1.10324	-5.62603	110	3	1.12	0.95;
	1861	1	0	0	0	0	1	1.10317	-5.64293	110	3	1.12	0.95;
	1862	1	14.89	4.04	0	0	1	1.11329	-7.08153	110	3	1.12	0.95;
	1863	1	13.95	3.45	0	0	1	1.11338	-7.08017	110	3	1.12	0.95;
	1864	1	13.75	7.11	0	0	1	1.09704	-7.42637	110	3	1.12	0.95;
	1865	1	0	0	0	0	1	1.09706	-7.42276	110	3	1.12	0.95;
	1866	1	0	0	0	0	1	1.09706	-7.4224	110	3	1.12	0.95;
	1867	1	0	0	0	0	1	1.09706	-7.4224	110	3	1.12	0.95;
	1868	1	10.54	3.79	0	0	1	1.10746	-2.93425	110	3	1.12	0.95;
	1869	1	18.02	6.09	0	0	1	1.10009	-3.04923	110	3	1.12	0.95;
	1870	1	2.1	0.57	0	0	1	1.10888	-1.72359	110	3	1.12	0.95;
	1871	1	0	0	0	0	1	1.10892	-1.72051	110	3	1.12	0.95;
	1872	2	3.91	4.57	0	0	1	1.10208	-11.23812	110	3	1.12	0.95;
	1873	1	6.67	2.97	0	0	1	1.10199	-11.24543	110	3	1.12	0.95;
	1874	1	5.14	1.71	0	0	1	1.11788	-0.73736	110	3	1.12	0.95;
	1875	1	4.56	1.48	0	0	1	1.11986	-3.53917	110	3	1.12	0.95;
	1876	1	0	0	0	0	1	1.11793	-0.73372	110	3	1.12	0.95;
	1877	1	3.86	3.65	0	0	1	1.09046	-5.96798	110	3	1.12	0.95;
	1878	1	7.6	2.97	0	0	1	1.09051	-5.96366	110	3	1.12	0.95;
	1879	1	2.22	0.91	0	0	1	1.11862	-1.57218	110	3	1.12	0.95;
	1880	1	0	0	0	0	1	1.1187	-1.56689	110	3	1.12	0.95;
	1881	1	3.51	0.88	0	0	1	1.10097	-10.62314	110	3	1.12	0.95;
	1882	1	0	0	0	0	1	1.10105	-10.61893	110	3	1.12	0.95;
	1883	1	8.19	3.25	0	0	1	1.10868	-1.45515	110	3	1.12	0.95;
	1884	1	8.19	2.8	0	0	1	1.11294	-1.17022	110	3	1.12	0.95;
	1885	1	6.22	2.67	0	0	1	1.06373	-7.5397	110	3	1.12	0.95;
	1886	1	0	0	0	0	1	1.06392	-7.5325	110	3	1.12	0.95;
	1887	1	5.96	1.27	0	0	1	1.10926	-3.82802	110	3	1.12	0.95;
	1888	1	11.22	4.05	0	0	1	1.10926	-3.81861	110	3	1.12	0.95;
	1889	1	4.81	2.2	0	0	1	1.09237	-11.62571	110	3	1.12	0.95;
	1890	1	5.03	1.29	0	0	1	1.09081	-7.14173	110	3	1.12	0.95;
	1891	1	4.57	0.67	0	0	1	1.0907	-7.15598	110	3	1.12	0.95;
	1892	1	4.33	1.27	0	0	1	1.10902	-3.91662	110	3	1.12	0.95;
	1893	1	3.62	1.27	0	0	1	1.10905	-3.92216	110	3	1.12	0.95;
	1894	1	0	0	0	0	1	1.06898	-10.29292	110	3	1.12	0.95;
	1895	1	0	0	0	0	1	1.06898	-10.29285	110	3	1.12	0.95;
	1896	1	1.52	0.71	0	0	1	1.09064	-9.00738	110	3	1.12	0.95;
	1897	1	0.23	0.06	0	0	1	1.09066	-9.00575	110	3	1.12	0.95;
	1898	1	0	0	0	0	1	1.10842	-3.03556	110	3	1.12	0.95;
	1899	1	13.58	4.51	0	0	1	1.10845	-3.01964	110	3	1.12	0.95;
	1900	2	21.24	32.23	0	0	1	1.11999	-3.59294	110	3	1.12	0.95;
	1901	2	15.07	19.09	0	0	1	1.12	-3.91456	110	3	1.12	0.95;
	1902	2	19.98	22.1	0	0	1	1.11999	-2.83032	110	3	1.12	0.95;
	1903	1	9.02	0.98	0	0	1	1.09872	-7.32855	110	3	1.12	0.95;
	1904	1	6.91	2.3	0	0	1	1.09877	-7.31772	110	3	1.12	0.95;
	1905	1	4.92	1.9	0	0	1	1.11396	-2.03248	110	3	1.12	0.95;
	1906	1	0	0	0	0	1	1.11394	-2.0472	110	3	1.12	0.95;
	1907	1	8.79	3.91	0	0	1	1.10065	-6.17485	110	3	1.12	0.95;
	1908	1	5.27	2.32	0	0	1	1.10065	-6.18687	110	3	1.12	0.95;
	1909	1	0	0	0	0	1	1.10541	-5.52682	110	3	1.12	0.95;
	1910	2	7.78	7.83	0	0	1	1.11404	-6.7291	110	3	1.12	0.95;
	1911	2	17.9	16.93	0	0	1	1.10311	-7.0517	110	3	1.12	0.95;
	1912	1	5.62	1.32	0	0	1	1.08056	-10.35293	110	3	1.12	0.95;
	1913	1	7.74	1	0	0	1	1.0799	-10.44029	110	3	1.12	0.95;
	1914	1	4.92	0.78	0	0	1	1.09211	-8.92348	110	3	1.12	0.95;
	1915	1	0	0	0	0	1	1.09207	-8.90644	110	3	1.12	0.95;
	1916	1	7.65	2.12	0	0	1	1.10179	-7.11374	110	3	1.12	0.95;
	1917	1	0	0	0	0	1	1.11326	-6.80223	110	3	1.12	0.95;
	1918	1	0.35	0	0	0	1	1.09031	-7.25028	110	3	1.12	0.95;
	1919	1	0.35	0	0	0	1	1.09785	-4.53789	110	3	1.12	0.95;
	1920	1	8.44	3.49	0	0	1	1.07984	-6.01794	110	3	1.12	0.95;
	1921	1	13.97	5.77	0	0	1	1.07972	-6.03654	110	3	1.12	0.95;
	1922	1	6.2	2.31	0	0	1	1.11347	-3.46466	110	3	1.12	0.95;
	1923	1	0	0	0	0	1	1.11345	-3.45061	110	3	1.12	0.95;
	1924	1	2.46	0.75	0	0	1	1.11316	-3.65333	110	3	1.12	0.95;
	1925	1	5.85	0.2	0	0	1	1.11109	-4.45755	110	3	1.12	0.95;
	1926	1	0	0	0	0	1	1.11351	-3.63978	110	3	1.12	0.95;
	1927	1	0	0	0	0	1	1.11176	-4.41717	110	3	1.12	0.95;
	1928	1	7.37	3.76	0	0	1	1.11393	-1.09172	110	3	1.12	0.95;
	1929	1	8.07	1.83	0	0	1	1.10882	-1.45613	110	3	1.12	0.95;
	1930	1	0	0	0	0	1	1.11432	-1.07121	110	3	1.12	0.95;
	1931	1	10.31	2.83	0	0	1	1.10549	-6.75244	110	3	1.12	0.95;
	1932	1	11.27	3.37	0	0	1	1.10537	-6.7561	110	3	1.12	0.95;
	1933	1	1.75	0	0	0	1	1.10926	-1.77944	110	3	1.12	0.95;
	1934	1	1.75	1.48	0	0	1	1.10931	-1.77323	110	3	1.12	0.95;
	1935	1	5.15	2.43	0	0	1	1.11848	-0.22928	110	3	1.12	0.95;
	1936	1	9.01	4.84	0	0	1	1.11748	-0.37527	110	3	1.12	0.95;
	1937	1	0	0	0	0	1	1.11891	-0.21414	110	3	1.12	0.95;
	1938	1	0	0	0	0	1	1.11827	-0.35027	110	3	1.12	0.95;
	1939	1	11.72	6.59	0	0	1	1.11099	-3.52817	110	3	1.12	0.95;
	1940	1	1.4	0.92	0	0	1	1.11097	-3.54252	110	3	1.12	0.95;
	1941	1	7.27	2.07	0	0	1	1.10223	-6.16609	110	3	1.12	0.95;
	1942	1	0.23	0.09	0	0	1	1.1021	-6.16976	110	3	1.12	0.95;
	1943	1	4.33	1.48	0	0	1	1.099	-4.39179	110	3	1.12	0.95;
	1944	1	15.32	5.02	0	0	1	1.10515	-3.61795	110	3	1.12	0.95;
	1945	1	1.87	0.09	0	0	1	1.08385	-5.95992	110	3	1.12	0.95;
	1946	1	0	0	0	0	1	1.08381	-5.9687	110	3	1.12	0.95;
	1947	1	5.86	2.64	0	0	1	1.11653	-1.31398	110	3	1.12	0.95;
	1948	1	3.86	1.73	0	0	1	1.11768	-1.22291	110	3	1.12	0.95;
	1949	1	0	0	0	0	1	1.11655	-1.31308	110	3	1.12	0.95;
	1950	1	0	0	0	0	1	1.11781	-1.21536	110	3	1.12	0.95;
	1951	1	10.09	3.89	0	0	1	1.07128	-8.11581	110	3	1.12	0.95;
	1952	1	9.49	4	0	0	1	1.07122	-8.123	110	3	1.12	0.95;
	1953	1	11.36	4.65	0	0	1	1.11788	-0.91183	110	3	1.12	0.95;
	1954	1	5.85	2.43	0	0	1	1.11783	-0.90913	110	3	1.12	0.95;
	1955	1	1.76	0.8	0	0	1	1.1083	-5.17473	110	3	1.12	0.95;
	1956	1	2.11	0.92	0	0	1	1.10835	-5.15889	110	3	1.12	0.95;
	1957	1	5.61	2.11	0	0	1	1.11355	-1.37117	110	3	1.12	0.95;
	1958	1	7.61	2.91	0	0	1	1.08947	-6.0329	110	3	1.12	0.95;
	1959	1	1.29	0.46	0	0	1	1.09527	-5.97909	110	3	1.12	0.95;
	1960	1	15.9	2.33	0	0	1	1.09594	-4.71725	110	3	1.12	0.95;
	1961	1	0	0	0	0	1	1.09594	-4.71605	110	3	1.12	0.95;
	1962	1	28.14	9.23	0	0	1	1.08942	-6.24058	110	3	1.12	0.95;
	1963	1	12.64	3.12	0	0	1	1.08951	-6.26583	110	3	1.12	0.95;
	1964	1	3.86	1.29	0	0	1	1.0711	-13.82307	110	3	1.12	0.95;
	1965	1	7.03	2.65	0	0	1	1.07107	-13.81574	110	3	1.12	0.95;
	1966	1	5.15	1.7	0	0	1	1.09685	-7.46502	110	3	1.12	0.95;
	1967	1	11.24	3.27	0	0	1	1.09636	-7.49153	110	3	1.12	0.95;
	1968	1	9.94	2.57	0	0	1	1.0689	-13.81173	110	3	1.12	0.95;
	1969	1	10.17	3.39	0	0	1	1.06894	-13.82208	110	3	1.12	0.95;
	1970	1	1.52	0.08	0	0	1	1.09881	-4.30691	110	3	1.12	0.95;
	1971	1	1.87	0.33	0	0	1	1.0988	-4.31208	110	3	1.12	0.95;
	1972	1	4.21	1.66	0	0	1	1.08719	-5.02529	110	3	1.12	0.95;
	1973	1	5.62	0.61	0	0	1	1.08727	-5.04863	110	3	1.12	0.95;
	1974	1	6.44	1.99	0	0	1	1.07604	-13.21151	110	3	1.12	0.95;
	1975	1	3.75	1.03	0	0	1	1.07609	-13.20711	110	3	1.12	0.95;
	1976	1	10.68	3.96	0	0	1	1.0867	-4.46029	110	3	1.12	0.95;
	1977	1	11.15	3.49	0	0	1	1.08671	-4.46078	110	3	1.12	0.95;
	1978	1	9.27	3.74	0	0	1	1.07077	-8.53063	110	3	1.12	0.95;
	1979	1	4.8	1.99	0	0	1	1.07084	-8.51413	110	3	1.12	0.95;
	1980	1	9.02	1.95	0	0	1	1.11217	-2.82479	110	3	1.12	0.95;
	1981	1	4.33	0.39	0	0	1	1.11207	-2.85662	110	3	1.12	0.95;
	1982	1	0	0	0	0	1	1.10321	-2.87729	110	3	1.12	0.95;
	1983	1	9.71	3.42	0	0	1	1.103	-2.90599	110	3	1.12	0.95;
	1984	1	4.92	1.17	0	0	1	1.10818	-3.47714	110	3	1.12	0.95;
	1985	1	9.37	0.48	0	0	1	1.1081	-3.47192	110	3	1.12	0.95;
	1986	1	4.8	1.37	0	0	1	1.09536	-5.97214	110	3	1.12	0.95;
	1987	1	8.8	4.26	0	0	1	1.09534	-5.96268	110	3	1.12	0.95;
	1988	1	5.4	1.84	0	0	1	1.09011	-8.15584	110	3	1.12	0.95;
	1989	1	4.22	1.5	0	0	1	1.08996	-8.18141	110	3	1.12	0.95;
	1990	1	1.75	0.73	0	0	1	1.09378	-11.53793	110	3	1.12	0.95;
	1991	1	0	0	0	0	1	1.08878	-10.80648	110	3	1.12	0.95;
	1992	1	1.99	0.44	0	0	1	1.09767	-3.10933	110	3	1.12	0.95;
	1993	1	3.75	1.59	0	0	1	1.09772	-3.11659	110	3	1.12	0.95;
	1994	1	4.21	1.6	0	0	1	1.10059	-6.23289	110	3	1.12	0.95;
	1995	1	1.87	1.16	0	0	1	1.10053	-6.22481	110	3	1.12	0.95;
	1996	1	5.26	1.48	0	0	1	1.11916	-0.79518	110	3	1.12	0.95;
	1997	1	2.34	0.91	0	0	1	1.11918	-0.78147	110	3	1.12	0.95;
	1998	1	7.84	3.32	0	0	1	1.11833	-1.04094	110	3	1.12	0.95;
	1999	1	4.56	1.96	0	0	1	1.11833	-1.03444	110	3	1.12	0.95;
	2000	1	8.43	1.51	0	0	1	1.08661	-10.0404	110	3	1.12	0.95;
	2001	1	13.72	3.82	0	0	1	1.08681	-10.03451	110	3	1.12	0.95;
	2002	1	12.63	8.33	0	0	1	1.09688	-6.54713	110	3	1.12	0.95;
	2003	1	0	0	0	0	1	1.09698	-6.54127	110	3	1.12	0.95;
	2004	1	10.54	4.22	0	0	1	1.11806	-0.91702	110	3	1.12	0.95;
	2005	1	0	0	0	0	1	1.11806	-0.90665	110	3	1.12	0.95;
	2006	1	11.71	4.02	0	0	1	1.09561	-6.45626	110	3	1.12	0.95;
	2007	1	11.7	3.82	0	0	1	1.09223	-6.95259	110	3	1.12	0.95;
	2008	1	0	0	0	0	1	1.09627	-6.4342	110	3	1.12	0.95;
	2009	1	0	0	0	0	1	1.09284	-6.93325	110	3	1.12	0.95;
	2010	1	3.51	0.75	0	0	1	1.09303	-11.53145	110	3	1.12	0.95;
	2011	1	0	0	0	0	1	1.09299	-11.53909	110	3	1.12	0.95;
	2012	1	1.64	0.69	0	0	1	1.10517	-4.07731	110	3	1.12	0.95;
	2013	1	0	0	0	0	1	1.10521	-4.07307	110	3	1.12	0.95;
	2014	1	0	0	0	0	1	1.09278	-11.62874	110	3	1.12	0.95;
	2015	1	0	0	0	0	1	1.09227	-11.63277	110	3	1.12	0.95;
	2016	1	0	0	0	0	1	1.10389	-3.67411	110	3	1.12	0.95;
	2017	1	0	0	0	0	1	1.09546	-6.91979	110	3	1.12	0.95;
	2018	2	17.03	6.64	0	0	1	1.10393	-5.10434	110	3	1.12	0.95;
	2019	1	7.74	3	0	0	1	1.10375	-5.12072	110	3	1.12	0.95;
	2020	1	0.23	0.26	0	0	1	1.10914	-3.94412	110	3	1.12	0.95;
	2021	1	0	0	0	0	1	1.10914	-3.94412	110	3	1.12	0.95;
	2022	1	20.42	8.66	0	0	1	1.1039	-5.00227	110	3	1.12	0.95;
	2023	1	9.74	4.12	0	0	1	1.10388	-5.01223	110	3	1.12	0.95;
	2024	1	7.74	2.98	0	0	1	1.11736	-0.4615	110	3	1.12	0.95;
	2025	1	8.68	3.42	0	0	1	1.11792	-1.04319	110	3	1.12	0.95;
	2026	1	0	0	0	0	1	1.11743	-0.45723	110	3	1.12	0.95;
	2027	1	10.77	3.71	0	0	1	1.09427	-4.96518	110	3	1.12	0.95;
	2028	1	5.26	2	0	0	1	1.09424	-4.98687	110	3	1.12	0.95;
	2029	1	3.98	4.02	0	0	1	1.11418	-4.09305	110	3	1.12	0.95;
	2030	1	16.62	6.87	0	0	1	1.1142	-4.09518	110	3	1.12	0.95;
	2031	1	8.21	4.77	0	0	1	1.08569	-12.24813	110	3	1.12	0.95;
	2032	1	0	0	0	0	1	1.08578	-12.2339	110	3	1.12	0.95;
	2033	1	0	0	0	0	1	1.08167	-5.62573	110	3	1.12	0.95;
	2034	1	5.86	-0.06	0	0	1	1.08166	-5.6281	110	3	1.12	0.95;
	2035	1	12.06	4.05	0	0	1	1.10078	-5.32128	110	3	1.12	0.95;
	2036	1	18.51	6.22	0	0	1	1.10063	-5.3429	110	3	1.12	0.95;
	2037	1	7.62	2.3	0	0	1	1.07053	-6.42164	110	3	1.12	0.95;
	2038	1	8.89	3.05	0	0	1	1.07031	-6.43501	110	3	1.12	0.95;
	2039	1	9.02	2.57	0	0	1	1.10184	-6.13615	110	3	1.12	0.95;
	2040	1	0	0	0	0	1	1.10256	-6.11066	110	3	1.12	0.95;
	2041	1	2.34	0.8	0	0	1	1.09191	-5.82345	110	3	1.12	0.95;
	2042	1	0	0	0	0	1	1.09191	-5.82329	110	3	1.12	0.95;
	2043	1	0	0	0	0	1	1.11878	-6.45924	110	3	1.12	0.95;
	2044	1	0	0	0	0	1	1.1185	-6.50329	110	3	1.12	0.95;
	2045	1	12.8	5.43	0	0	1	1.09834	-6.58689	110	3	1.12	0.95;
	2046	1	12.79	4.75	0	0	1	1.09836	-6.59404	110	3	1.12	0.95;
	2047	1	8.08	2.73	0	0	1	1.09902	-6.40822	110	3	1.12	0.95;
	2048	1	0	0	0	0	1	1.09896	-6.40983	110	3	1.12	0.95;
	2049	1	9.61	2.28	0	0	1	1.11437	-6.82297	110	3	1.12	0.95;
	2050	1	11.01	2.88	0	0	1	1.11415	-6.83376	110	3	1.12	0.95;
	2051	1	7.74	3.04	0	0	1	1.07648	-6.07153	110	3	1.12	0.95;
	2052	1	5.97	2.29	0	0	1	1.07644	-6.06181	110	3	1.12	0.95;
	2053	1	4.68	1.71	0	0	1	1.11778	-0.36497	110	3	1.12	0.95;
	2054	1	14.87	4.96	0	0	1	1.11274	-0.94282	110	3	1.12	0.95;
	2055	1	0	0	0	0	1	1.11294	-0.92869	110	3	1.12	0.95;
	2056	1	9.84	5.57	0	0	1	1.06773	-8.35783	110	3	1.12	0.95;
	2057	1	9.97	3.97	0	0	1	1.06772	-8.35839	110	3	1.12	0.95;
	2058	1	4.33	2.27	0	0	1	1.10893	-2.57878	110	3	1.12	0.95;
	2059	1	5.03	3.61	0	0	1	1.10889	-2.607	110	3	1.12	0.95;
	2060	1	0	0	0	0	1	1.10395	-4.19831	110	3	1.12	0.95;
	2061	1	3.27	0.8	0	0	1	1.10393	-4.21059	110	3	1.12	0.95;
	2062	2	18.86	35	0	0	1	1.12	-1.57927	110	3	1.12	0.95;
	2063	2	14.07	32.15	0	0	1	1.12	-0.45812	110	3	1.12	0.95;
	2064	2	14.07	32.15	0	0	1	1.11839	-1.30285	110	3	1.12	0.95;
	2065	1	0	0	0	0	1	1.1091	-1.43214	110	3	1.12	0.95;
	2066	1	11.27	4.55	0	0	1	1.11333	-1.14678	110	3	1.12	0.95;
	2067	1	10.56	3.92	0	0	1	1.06729	-6.65628	110	3	1.12	0.95;
	2068	1	0	0	0	0	1	1.09546	-6.91992	110	3	1.12	0.95;
	2069	1	15.72	5.07	0	0	1	1.08647	-8.75143	110	3	1.12	0.95;
	2070	1	9.14	3.03	0	0	1	1.08636	-8.77921	110	3	1.12	0.95;
	2071	1	7.84	2.55	0	0	1	1.11633	-3.91237	110	3	1.12	0.95;
	2072	1	4.91	1.4	0	0	1	1.11626	-3.92332	110	3	1.12	0.95;
	2073	1	0	0	0	0	1	1.11439	-0.97848	110	3	1.12	0.95;
	2074	1	6.67	2.29	0	0	1	1.11439	-0.9854	110	3	1.12	0.95;
	2075	1	12.89	4.78	0	0	1	1.09529	-3.81555	110	3	1.12	0.95;
	2076	1	12.31	5.31	0	0	1	1.09534	-3.82848	110	3	1.12	0.95;
	2077	1	8.56	2.4	0	0	1	1.11256	-5.25896	110	3	1.12	0.95;
	2078	1	5.05	0.3	0	0	1	1.11259	-5.27814	110	3	1.12	0.95;
	2079	1	14.99	4.26	0	0	1	1.10053	-6.19222	110	3	1.12	0.95;
	2080	1	8.55	0.67	0	0	1	1.10053	-6.17774	110	3	1.12	0.95;
	2081	1	5.85	2.2	0	0	1	1.11955	-3.94343	110	3	1.12	0.95;
	2082	1	0	0	0	0	1	1.12	-3.59314	110	3	1.12	0.95;
	2083	1	0	0	0	0	1	1.11992	0.05101	110	3	1.12	0.95;
	2084	1	16.15	0.59	0	0	1	1.10124	-7.31788	110	3	1.12	0.95;
	2085	1	1.87	0.18	0	0	1	1.10214	-6.34351	110	3	1.12	0.95;
	2086	1	6.43	0.57	0	0	1	1.07059	-13.84507	110	3	1.12	0.95;
	2087	1	4.56	2.29	0	0	1	1.07058	-13.84447	110	3	1.12	0.95;
	2088	1	8.66	3.41	0	0	1	1.06091	-11.18159	110	3	1.12	0.95;
	2089	1	7.02	2.27	0	0	1	1.06095	-11.15953	110	3	1.12	0.95;
	2090	1	0.7	0.23	0	0	1	1.10877	-4.5149	110	3	1.12	0.95;
	2091	1	0.47	0.23	0	0	1	1.10481	-5.2594	110	3	1.12	0.95;
	2092	1	0	0	0	0	1	1.10189	-1.9421	110	3	1.12	0.95;
	2093	1	0	0	0	0	1	1.06327	-6.53952	110	3	1.12	0.95;
	2094	2	37.1	20.43	0	0	1	1.10243	-4.52232	110	3	1.12	0.95;
	2095	2	0	0	0	0	1	1.09665	-6.64131	110	3	1.12	0.95;
	2096	1	5.04	1.91	0	0	1	1.10174	-2.13832	110	3	1.12	0.95;
	2097	1	5.39	1.99	0	0	1	1.11584	-0.66754	110	3	1.12	0.95;
	2098	1	0	0	0	0	1	1.10174	-2.13799	110	3	1.12	0.95;
	2099	1	0	0	0	0	1	1.11585	-0.6672	110	3	1.12	0.95;
	2100	1	3.39	0.79	0	0	1	1.09455	-7.1382	110	3	1.12	0.95;
	2101	1	7.85	2.25	0	0	1	1.09446	-7.1379	110	3	1.12	0.95;
	2102	1	14.89	3.57	0	0	1	1.11557	-2.55477	110	3	1.12	0.95;
	2103	1	12.42	2.13	0	0	1	1.11548	-2.58059	110	3	1.12	0.95;
	2104	1	10.76	3.54	0	0	1	1.10291	-4.30119	110	3	1.12	0.95;
	2105	1	10.17	3.31	0	0	1	1.10292	-4.28687	110	3	1.12	0.95;
	2106	1	7.62	2.96	0	0	1	1.0913	-7.52136	110	3	1.12	0.95;
	2107	1	12.44	4.44	0	0	1	1.09136	-7.50312	110	3	1.12	0.95;
	2108	1	13.86	4.1	0	0	1	1.10713	-6.1212	110	3	1.12	0.95;
	2109	1	3.86	0.18	0	0	1	1.10709	-6.11049	110	3	1.12	0.95;
	2110	1	7.5	2.32	0	0	1	1.09032	-7.24968	110	3	1.12	0.95;
	2111	1	0	0	0	0	1	1.09786	-4.53731	110	3	1.12	0.95;
	2112	1	7.02	2.28	0	0	1	1.10587	-1.62929	110	3	1.12	0.95;
	2113	1	7.25	2.4	0	0	1	1.10573	-1.64631	110	3	1.12	0.95;
	2114	1	10.08	2.58	0	0	1	1.10842	-6.38138	110	3	1.12	0.95;
	2115	1	9.51	3.43	0	0	1	1.10848	-6.39487	110	3	1.12	0.95;
	2116	1	3.16	1.51	0	0	1	1.09384	-4.77924	110	3	1.12	0.95;
	2117	1	4.33	0.99	0	0	1	1.09388	-4.79061	110	3	1.12	0.95;
	2118	1	9.94	3.01	0	0	1	1.10099	-6.78864	110	3	1.12	0.95;
	2119	1	4.91	1.5	0	0	1	1.10111	-6.78407	110	3	1.12	0.95;
	2120	1	1.52	0.57	0	0	1	1.11347	-1.096	110	3	1.12	0.95;
	2121	1	0	0	0	0	1	1.11348	-1.09907	110	3	1.12	0.95;
	2122	1	14.97	6.62	0	0	1	1.09412	-5.7562	110	3	1.12	0.95;
	2123	1	5.96	0.11	0	0	1	1.09403	-5.76576	110	3	1.12	0.95;
	2124	1	4.92	2.26	0	0	1	1.09636	-5.64725	110	3	1.12	0.95;
	2125	1	2.93	-0.27	0	0	1	1.09638	-5.63531	110	3	1.12	0.95;
	2126	1	0.23	0.33	0	0	1	1.10045	-6.78685	110	3	1.12	0.95;
	2127	1	0.82	0.1	0	0	1	1.10036	-6.78758	110	3	1.12	0.95;
	2128	1	0	0	0	0	1	1.1192	-1.6057	110	3	1.12	0.95;
	2129	1	0	0	0	0	1	1.1192	-1.6057	110	3	1.12	0.95;
	2130	2	30.27	15.89	0	0	1	1.09061	-2.70252	110	3	1.12	0.95;
	2131	2	29.87	14.84	0	0	1	1.09056	-2.693	110	3	1.12	0.95;
	2132	1	0	0	0	0	1	1.09062	-2.70548	110	3	1.12	0.95;
	2133	1	0	0	0	0	1	1.09062	-2.70548	110	3	1.12	0.95;
	2134	1	9.96	2.43	0	0	1	1.1012	-1.99825	110	3	1.12	0.95;
	2135	1	0	0	0	0	1	1.11655	-1.43893	110	3	1.12	0.95;
	2136	1	0	0	0	0	1	1.10187	-1.94356	110	3	1.12	0.95;
	2137	1	7.72	2.66	0	0	1	1.1011	-6.75304	110	3	1.12	0.95;
	2138	1	11.13	4.41	0	0	1	1.10099	-6.75351	110	3	1.12	0.95;
	2139	1	5.39	2.28	0	0	1	1.10084	-6.77474	110	3	1.12	0.95;
	2140	1	10.21	4.77	0	0	1	1.10074	-6.7787	110	3	1.12	0.95;
	2141	1	3.63	1.61	0	0	1	1.09363	-8.46787	110	3	1.12	0.95;
	2142	1	0	0	0	0	1	1.09363	-8.45213	110	3	1.12	0.95;
	2143	1	4.33	1.54	0	0	1	1.10038	-7.16863	110	3	1.12	0.95;
	2144	1	9.36	0.21	0	0	1	1.10015	-7.20305	110	3	1.12	0.95;
	2145	1	15.72	6.25	0	0	1	1.10988	-4.45696	110	3	1.12	0.95;
	2146	1	0	0	0	0	1	1.11001	-4.43665	110	3	1.12	0.95;
	2147	1	0.47	0.23	0	0	1	1.11612	-0.68997	110	3	1.12	0.95;
	2148	1	0	0	0	0	1	1.11612	-0.68997	110	3	1.12	0.95;
	2149	1	0	0	0	0	1	1.11612	-0.68995	110	3	1.12	0.95;
	2150	2	40.5	9	0	0	1	1.07505	-7.9648	110	3	1.12	0.95;
	2151	1	16.17	4.45	0	0	1	1.08203	-7.51299	110	3	1.12	0.95;
	2152	2	6.03	20.1	0	0	1	1.12	-12.5075	110	4	1.12	0.95;
	2153	2	8.84	20.61	0	0	1	1.11995	-12.49774	110	4	1.12	0.95;
	2154	1	1.75	1.62	0	0	1	1.11938	-12.5193	110	4	1.12	0.95;
	2155	1	28.76	2.36	0	0	1	1.08107	-33.76083	110	4	1.12	0.95;
	2156	1	7.56	1.68	0	0	1	1.08836	-23.05859	110	4	1.12	0.95;
	2157	1	10.95	-0.81	0	0	1	1.02335	-29.23496	110	4	1.12	0.95;
	2158	1	0.49	0	0	0	1	1.09991	-14.29076	110	4	1.12	0.95;
	2159	1	10.93	1.39	0	0	1	1.0753	-16.12618	110	4	1.12	0.95;
	2160	1	0	0	0	0	1	1.0753	-16.12618	110	4	1.12	0.95;
	2161	1	7.37	1.73	0	0	1	1.06121	-36.12791	110	4	1.12	0.95;
	2162	1	26.94	11.49	0	0	1	1.0775	-17.228	110	4	1.12	0.95;
	2163	1	22	8.61	0	0	1	1.06961	-37.41911	110	4	1.12	0.95;
	2164	1	11.48	0.17	0	0	1	1.08067	-34.02058	110	4	1.12	0.95;
	2165	1	0	0	0	0	1	1.08066	-34.03545	110	4	1.12	0.95;
	2166	1	13.19	1.16	0	0	1	1.06508	-34.58302	110	4	1.12	0.95;
	2167	1	6.48	1.2	0	0	1	1.10186	-13.27465	110	4	1.12	0.95;
	2168	2	6.49	1.21	0	0	1	1.10185	-13.2887	110	4	1.12	0.95;
	2169	1	16.78	5.08	0	0	1	1.10074	-13.5468	110	4	1.12	0.95;
	2170	1	7.95	0	0	0	1	1.07726	-16.36084	110	4	1.12	0.95;
	2171	1	6.55	0	0	0	1	1.07725	-16.36351	110	4	1.12	0.95;
	2172	1	39.05	11.16	0	0	1	1.07003	-34.34875	110	4	1.12	0.95;
	2173	1	6.17	-0.45	0	0	1	1.07295	-16.1283	110	4	1.12	0.95;
	2174	1	4.94	0	0	0	1	1.07143	-16.37019	110	4	1.12	0.95;
	2175	1	12.19	4.88	0	0	1	1.03137	-31.79955	110	4	1.12	0.95;
	2176	1	8.91	3.42	0	0	1	1.05148	-24.70035	110	4	1.12	0.95;
	2177	1	2.71	-1.06	0	0	1	0.99624	-30.4906	110	4	1.12	0.95;
	2178	1	19.57	4.28	0	0	1	1.07564	-16.77221	110	4	1.12	0.95;
	2179	1	19.57	4.28	0	0	1	1.0756	-16.78005	110	4	1.12	0.95;
	2180	1	15.16	1.13	0	0	1	1.05225	-24.50542	110	4	1.12	0.95;
	2181	1	0.9	0.43	0	0	1	1.06929	-27.88454	110	4	1.12	0.95;
	2182	1	5.31	1.06	0	0	1	1.11832	-10.90159	110	4	1.12	0.95;
	2183	2	5.19	0.49	0	0	1	1.08195	-14.8369	110	4	1.12	0.95;
	2184	1	0	0	0	0	1	1.11966	-34.0226	110	4	1.12	0.95;
	2185	1	9.59	-1.71	0	0	1	1.05121	-34.20218	110	4	1.12	0.95;
	2186	1	6.7	0.34	0	0	1	1.03897	-25.94158	110	4	1.12	0.95;
	2187	2	4.4	0.13	0	0	1	1.06445	-16.82062	110	4	1.12	0.95;
	2188	1	3.74	2.12	0	0	1	1.06443	-16.82209	110	4	1.12	0.95;
	2189	2	3.01	5.02	0	0	1	1.08615	-16.52569	110	4	1.12	0.95;
	2190	2	3.55	6.08	0	0	1	1.08635	-17.6097	110	4	1.12	0.95;
	2191	1	4.19	0.19	0	0	1	1.08579	-15.55664	110	4	1.12	0.95;
	2192	1	27.67	7.31	0	0	1	1.07741	-36.96574	110	4	1.12	0.95;
	2193	1	7.11	1.76	0	0	1	1.08506	-35.44814	110	4	1.12	0.95;
	2194	1	4.2	0.28	0	0	1	1.07391	-18.46321	110	4	1.12	0.95;
	2195	1	9.36	2	0	0	1	1.07471	-38.01197	110	4	1.12	0.95;
	2196	1	1.59	0.43	0	0	1	1.08531	-26.13147	110	4	1.12	0.95;
	2197	1	11.34	3.55	0	0	1	1.09215	-15.6134	110	4	1.12	0.95;
	2198	1	0.98	-0.4	0	0	1	1.0866	-33.345	110	4	1.12	0.95;
	2199	1	0	0	0	0	1	1.08199	-14.82371	110	4	1.12	0.95;
	2200	1	0	0	0	0	1	1.08199	-14.82371	110	4	1.12	0.95;
	2201	1	0	0	0	0	1	1.0762	-18.25211	110	4	1.12	0.95;
	2202	1	0	0	0	0	1	1.08139	-17.73947	110	4	1.12	0.95;
	2203	1	3.42	0.79	0	0	1	1.10261	-13.36563	110	4	1.12	0.95;
	2204	1	7.74	-0.11	0	0	1	1.05659	-38.63791	110	4	1.12	0.95;
	2205	1	24.93	6.81	0	0	1	1.07854	-33.75382	110	4	1.12	0.95;
	2206	1	3.23	4.7	0	0	1	1.04533	-30.73203	110	4	1.12	0.95;
	2207	1	6.3	2.65	0	0	1	1.08536	-33.1726	110	4	1.12	0.95;
	2208	1	3.71	1.09	0	0	1	1.08533	-33.20193	110	4	1.12	0.95;
	2209	1	17.26	1.89	0	0	1	1.0575	-38.51209	110	4	1.12	0.95;
	2210	1	18.85	4.8	0	0	1	1.07882	-36.74575	110	4	1.12	0.95;
	2211	1	4.89	1.28	0	0	1	1.06929	-28.86475	110	4	1.12	0.95;
	2212	1	10.46	1.7	0	0	1	1.04857	-20.04751	110	4	1.12	0.95;
	2213	1	4	0.24	0	0	1	1.05383	-38.28883	110	4	1.12	0.95;
	2214	1	12.94	0.06	0	0	1	1.04494	-36.55085	110	4	1.12	0.95;
	2215	1	5.41	1.7	0	0	1	1.05943	-38.41997	110	4	1.12	0.95;
	2216	2	19.16	34.66	0	0	1	1.11996	-33.99672	110	4	1.12	0.95;
	2217	1	0	0	0	0	1	1.11996	-33.99672	110	4	1.12	0.95;
	2218	1	12.13	-1.29	0	0	1	1.05878	-36.77483	110	4	1.12	0.95;
	2219	1	0	0	0	0	1	1.05878	-36.77483	110	4	1.12	0.95;
	2220	1	15.07	-0.87	0	0	1	1.0549	-37.64507	110	4	1.12	0.95;
	2221	1	4.32	1.27	0	0	1	1.05627	-17.46109	110	4	1.12	0.95;
	2222	2	0.02	0.43	0	0	1	1.06405	-27.71202	110	4	1.12	0.95;
	2223	1	0	0	0	0	1	1.06405	-27.71202	110	4	1.12	0.95;
	2224	1	8.95	3.15	0	0	1	1.06139	-17.38388	110	4	1.12	0.95;
	2225	1	11.47	3.02	0	0	1	1.07652	-16.37155	110	4	1.12	0.95;
	2226	2	32.98	32.06	0	0	1	1.08735	-33.35249	110	4	1.12	0.95;
	2227	2	8.04	16.08	0	0	1	1.0868	-33.36944	110	4	1.12	0.95;
	2228	1	10.57	4.63	0	0	1	1.06775	-33.33315	110	4	1.12	0.95;
	2229	1	3.16	1.13	0	0	1	1.06312	-37.98599	110	4	1.12	0.95;
	2230	1	10.98	3.98	0	0	1	1.07667	-33.16042	110	4	1.12	0.95;
	2231	1	10.98	4.89	0	0	1	1.07458	-33.64729	110	4	1.12	0.95;
	2232	2	14.49	7.15	0	0	1	1.02115	-39.93314	110	4	1.12	0.95;
	2233	2	0.79	0.32	0	0	1	1.07186	-37.56285	110	4	1.12	0.95;
	2234	1	0.66	0.32	0	0	1	1.0716	-37.58846	110	4	1.12	0.95;
	2235	1	21.65	5.21	0	0	1	1.06554	-32.17403	110	4	1.12	0.95;
	2236	2	13.34	-0.07	0	0	1	1.06422	-33.04585	110	4	1.12	0.95;
	2237	1	10.97	7.1	0	0	1	1.06429	-33.07012	110	4	1.12	0.95;
	2238	2	3.85	-2.63	0	0	1	1.05587	-28.61813	110	4	1.12	0.95;
	2239	2	3.02	5.03	0	0	1	1.07723	-31.77798	110	4	1.12	0.95;
	2240	2	0.02	0.02	0	0	1	1.07722	-32.8745	110	4	1.12	0.95;
	2241	1	23.29	7.6	0	0	1	1.05515	-38.05794	110	4	1.12	0.95;
	2242	1	13.76	1.2	0	0	1	1.07384	-33.12859	110	4	1.12	0.95;
	2243	1	12.87	1.38	0	0	1	1.07386	-33.12299	110	4	1.12	0.95;
	2244	1	9.71	1.78	0	0	1	1.06784	-19.36806	110	4	1.12	0.95;
	2245	1	25.62	5.21	0	0	1	1.02286	-35.09834	110	4	1.12	0.95;
	2246	1	3.31	0.44	0	0	1	1.07346	-18.52947	110	4	1.12	0.95;
	2247	1	13.17	7.33	0	0	1	1.1094	-34.6562	110	4	1.12	0.95;
	2248	1	4.46	0	0	0	1	1.06832	-16.65348	110	4	1.12	0.95;
	2249	1	0	0	0	0	1	1.06832	-16.65348	110	4	1.12	0.95;
	2250	1	17.21	1.2	0	0	1	1.07291	-32.35907	110	4	1.12	0.95;
	2251	1	0	0	0	0	1	1.07291	-32.35907	110	4	1.12	0.95;
	2252	1	12.27	1.22	0	0	1	1.07358	-32.30533	110	4	1.12	0.95;
	2253	2	29.6	11.52	0	0	1	1.02764	-28.47219	110	4	1.12	0.95;
	2254	1	7.99	-0.54	0	0	1	1.04134	-28.63462	110	4	1.12	0.95;
	2255	1	22.16	4.05	0	0	1	1.06541	-37.72275	110	4	1.12	0.95;
	2256	1	5.34	1.26	0	0	1	1.07574	-32.98124	110	4	1.12	0.95;
	2257	1	8.14	0.58	0	0	1	1.0332	-35.65408	110	4	1.12	0.95;
	2258	1	2.29	0.51	0	0	1	1.07219	-21.21652	110	4	1.12	0.95;
	2259	1	3.02	0.38	0	0	1	1.07222	-21.23987	110	4	1.12	0.95;
	2260	1	6.03	-0.65	0	0	1	1.03017	-31.853	110	4	1.12	0.95;
	2261	2	6.44	1.27	0	0	1	1.05417	-24.47789	110	4	1.12	0.95;
	2262	1	6.47	3.11	0	0	1	1.06078	-24.17223	110	4	1.12	0.95;
	2263	1	30.6	9.07	0	0	1	1.05101	-24.79226	110	4	1.12	0.95;
	2264	1	35.97	11.9	0	0	1	1.05799	-24.81681	110	4	1.12	0.95;
	2265	2	10.52	3.18	0	0	1	1.06234	-18.47576	110	4	1.12	0.95;
	2266	1	6.88	3.97	0	0	1	1.06209	-18.49733	110	4	1.12	0.95;
	2267	2	102.49	76.36	0	0	1	1.09109	-19.14875	110	4	1.12	0.95;
	2268	1	0	0	0	0	1	1.09109	-19.14875	110	4	1.12	0.95;
	2269	1	3.35	3.47	0	0	1	1.11037	-16.48388	110	4	1.12	0.95;
	2270	1	7.37	3.93	0	0	1	1.08574	-17.05291	110	4	1.12	0.95;
	2271	1	9.32	5.82	0	0	1	1.05999	-33.31598	110	4	1.12	0.95;
	2272	1	8.92	2.27	0	0	1	1.07112	-16.72519	110	4	1.12	0.95;
	2273	2	5.49	0.01	0	0	1	1.0711	-16.72473	110	4	1.12	0.95;
	2274	1	12.89	1.01	0	0	1	1.00165	-29.78724	110	4	1.12	0.95;
	2275	1	15.74	1.32	0	0	1	1.07693	-31.90168	110	4	1.12	0.95;
	2276	1	12.06	6.26	0	0	1	1.0572	-17.42026	110	4	1.12	0.95;
	2277	1	0	0	0	0	1	1.0572	-17.42026	110	4	1.12	0.95;
	2278	1	7.43	0	0	0	1	1.07218	-33.78437	110	4	1.12	0.95;
	2279	1	13.26	2.98	0	0	1	1.07778	-15.37463	110	4	1.12	0.95;
	2280	1	24.93	9.97	0	0	1	1.07205	-33.82505	110	4	1.12	0.95;
	2281	1	9.27	0.15	0	0	1	1.11887	-22.61825	110	4	1.12	0.95;
	2282	2	21.63	4.16	0	0	1	1.03569	-22.01783	110	4	1.12	0.95;
	2283	1	13.54	2.04	0	0	1	1.03708	-21.95925	110	4	1.12	0.95;
	2284	2	1.79	-1.13	0	0	1	1.07777	-38.19647	110	4	1.12	0.95;
	2285	1	9.43	3.78	0	0	1	1.11376	-12.80985	110	4	1.12	0.95;
	2286	2	17.33	3.4	0	0	1	1.05762	-18.26827	110	4	1.12	0.95;
	2287	1	9.06	1.33	0	0	1	1.07949	-15.17817	110	4	1.12	0.95;
	2288	1	8.7	2.08	0	0	1	1.08106	-14.87839	110	4	1.12	0.95;
	2289	1	17.61	5.03	0	0	1	1.0529	-19.01307	110	4	1.12	0.95;
	2290	2	7.13	-1.98	0	0	1	1.07278	-16.07503	110	4	1.12	0.95;
	2291	2	29.21	13.89	0	0	1	1.05551	-18.57836	110	4	1.12	0.95;
	2292	1	0	0	0	0	1	1.07253	-18.39095	110	4	1.12	0.95;
	2293	2	31.71	1.71	0	0	1	1.04922	-19.986	110	4	1.12	0.95;
	2294	1	22.88	8.02	0	0	1	1.11716	-22.64415	110	4	1.12	0.95;
	2295	2	22.62	5.25	0	0	1	1.05398	-32.80304	110	4	1.12	0.95;
	2296	1	13.37	3.61	0	0	1	1.09494	-25.65382	110	4	1.12	0.95;
	2297	1	0	0	0	0	1	1.11641	-18.49391	110	4	1.12	0.95;
	2298	1	7.9	2.1	0	0	1	1.06042	-17.15955	110	4	1.12	0.95;
	2299	2	9.18	4.21	0	0	1	1.06038	-17.16218	110	4	1.12	0.95;
	2300	1	28.5	13.62	0	0	1	1.06468	-34.83912	110	4	1.12	0.95;
	2301	1	9.67	1.15	0	0	1	1.06496	-19.82987	110	4	1.12	0.95;
	2302	1	20.63	6.17	0	0	1	1.05574	-8.21774	110	4	1.12	0.95;
	2303	1	7.21	-1.72	0	0	1	1.01637	-28.36514	110	4	1.12	0.95;
	2304	1	0	0	0	0	1	1.10561	-16.64967	110	4	1.12	0.95;
	2305	1	0	0	0	0	1	1.08039	-17.1417	110	4	1.12	0.95;
	2306	2	8.32	3.81	0	0	1	1.04949	-22.74748	110	4	1.12	0.95;
	2307	1	19.64	8.95	0	0	1	1.04156	-22.51672	110	4	1.12	0.95;
	2308	1	9.29	3.92	0	0	1	1.05845	-21.19403	110	4	1.12	0.95;
	2309	1	8.53	3.01	0	0	1	1.05895	-20.22243	110	4	1.12	0.95;
	2310	1	7.28	1.15	0	0	1	1.09553	-14.71086	110	4	1.12	0.95;
	2311	1	5.22	1.04	0	0	1	1.05329	-22.31933	110	4	1.12	0.95;
	2312	1	2.84	0.45	0	0	1	1.04986	-22.76692	110	4	1.12	0.95;
	2313	1	5.66	1.33	0	0	1	1.03269	-22.30627	110	4	1.12	0.95;
	2314	1	5.66	1.33	0	0	1	1.03268	-22.30889	110	4	1.12	0.95;
	2315	1	8.7	-0.7	0	0	1	1.04592	-38.68066	110	4	1.12	0.95;
	2316	2	13.39	7.95	0	0	1	1.06434	-27.53473	110	4	1.12	0.95;
	2317	1	11.24	0	0	0	1	1.1164	-18.49462	110	4	1.12	0.95;
	2318	1	14.32	4.15	0	0	1	1.1045	-13.81647	110	4	1.12	0.95;
	2319	2	4	5.15	0	0	1	1.09378	-18.28375	110	4	1.12	0.95;
	2320	2	2.01	3.01	0	0	1	1.12	-22.37408	110	4	1.12	0.95;
	2321	1	0	0	0	0	1	1.09163	-19.05896	110	4	1.12	0.95;
	2322	2	3.01	6.03	0	0	1	1.08999	-14.20887	110	4	1.12	0.95;
	2323	1	4.65	1.54	0	0	1	1.04069	-21.39048	110	4	1.12	0.95;
	2324	1	12.17	2.09	0	0	1	1.0747	-15.54428	110	4	1.12	0.95;
	2325	2	11.66	6.65	0	0	1	1.04659	-22.22469	110	4	1.12	0.95;
	2326	1	0	0	0	0	1	1.04692	-22.22959	110	4	1.12	0.95;
	2327	1	30.92	16.33	0	0	1	1.05251	-22.32593	110	4	1.12	0.95;
	2328	1	11.34	7.52	0	0	1	1.05318	-22.36437	110	4	1.12	0.95;
	2329	1	6.63	1.76	0	0	1	1.09651	-14.61344	110	4	1.12	0.95;
	2330	1	3.05	1.57	0	0	1	1.05211	-22.78671	110	4	1.12	0.95;
	2331	1	3.82	1.07	0	0	1	1.05207	-22.76434	110	4	1.12	0.95;
	2332	1	0	0	0	0	1	1.12	-33.87877	110	4	1.12	0.95;
	2333	1	0.76	0.31	0	0	1	1.05287	-21.06423	110	4	1.12	0.95;
	2334	1	0	0	0	0	1	1.09884	-14.14151	110	4	1.12	0.95;
	2335	1	0	0	0	0	1	1.09883	-14.12799	110	4	1.12	0.95;
	2336	1	48.43	22.17	0	0	1	1.04606	-22.13788	110	4	1.12	0.95;
	2337	1	40.77	23.16	0	0	1	1.05155	-22.38528	110	4	1.12	0.95;
	2338	1	3.43	1.36	0	0	1	1.04524	-22.91223	110	4	1.12	0.95;
	2339	1	3.18	1.37	0	0	1	1.05933	-21.29778	110	4	1.12	0.95;
	2340	1	0	0	0	0	1	1.05941	-21.25217	110	4	1.12	0.95;
	2341	1	9.56	2.26	0	0	1	1.04846	-24.07943	110	4	1.12	0.95;
	2342	1	5.1	3.19	0	0	1	1.04969	-21.52286	110	4	1.12	0.95;
	2343	1	3.82	6.24	0	0	1	1.04652	-22.43432	110	4	1.12	0.95;
	2344	1	3.82	3.17	0	0	1	1.05358	-22.29006	110	4	1.12	0.95;
	2345	1	1.02	0.62	0	0	1	1.05204	-24.09315	110	4	1.12	0.95;
	2346	1	2.03	0.9	0	0	1	1.05212	-24.11091	110	4	1.12	0.95;
	2347	1	6.37	2.18	0	0	1	1.10714	-13.10624	110	4	1.12	0.95;
	2348	1	9.74	0	0	0	1	1.05787	-23.77138	110	4	1.12	0.95;
	2349	1	9.74	0	0	0	1	1.0518	-24.17205	110	4	1.12	0.95;
	2350	2	50.4	17.72	0	0	1	1.03148	-36.34523	110	4	1.12	0.95;
	2351	1	8.92	4.71	0	0	1	1.05439	-23.13566	110	4	1.12	0.95;
	2352	1	3.05	2.22	0	0	1	1.05454	-23.15435	110	4	1.12	0.95;
	2353	1	6.75	1.28	0	0	1	1.0518	-23.37121	110	4	1.12	0.95;
	2354	1	3.95	0.37	0	0	1	1.0465	-22.29422	110	4	1.12	0.95;
	2355	2	7.97	1.19	0	0	1	1.03154	-22.99333	110	4	1.12	0.95;
	2356	1	40.01	11.37	0	0	1	1.03231	-22.31496	110	4	1.12	0.95;
	2357	1	23.56	4.21	0	0	1	1.0702	-34.17545	110	4	1.12	0.95;
	2358	1	14.18	3.07	0	0	1	1.03365	-22.24096	110	4	1.12	0.95;
	2359	1	0	0	0	0	1	1.0549	-17.5703	110	4	1.12	0.95;
	2360	1	4.94	0.7	0	0	1	1.0549	-17.5703	110	4	1.12	0.95;
	2361	1	4.46	2.05	0	0	1	1.07971	-17.85584	110	4	1.12	0.95;
	2362	1	0	0	0	0	1	1.06114	-20.90194	110	4	1.12	0.95;
	2363	1	7.1	3.73	0	0	1	1.0512	-18.95507	110	4	1.12	0.95;
	2364	1	7.24	3.72	0	0	1	1.10227	-16.76342	110	4	1.12	0.95;
	2365	1	7.69	0.61	0	0	1	1.10262	-14.01611	110	4	1.12	0.95;
	2366	1	0	0	0	0	1	1.08097	-15.84931	110	4	1.12	0.95;
	2367	1	5.1	0.35	0	0	1	1.08097	-15.84931	110	4	1.12	0.95;
	2368	1	7.33	0.22	0	0	1	1.05434	-38.64732	110	4	1.12	0.95;
	2369	1	13.68	4.03	0	0	1	1.0478	-20.11226	110	4	1.12	0.95;
	2370	1	9.02	4.44	0	0	1	1.07183	-18.42593	110	4	1.12	0.95;
	2371	1	9.35	3.6	0	0	1	1.0705	-37.5811	110	4	1.12	0.95;
	2372	2	13.74	3.87	0	0	1	1.10552	-12.8085	110	4	1.12	0.95;
	2373	1	1.94	0.1	0	0	1	1.07264	-16.10465	110	4	1.12	0.95;
	2374	1	5.96	0	0	0	1	1.08986	-20.58985	110	4	1.12	0.95;
	2375	1	5.35	3.32	0	0	1	1.06781	-16.42338	110	4	1.12	0.95;
	2376	1	0	0	0	0	1	1.06781	-16.42338	110	4	1.12	0.95;
	2377	1	42.33	7.89	0	0	1	1.05282	-30.35714	110	4	1.12	0.95;
	2378	1	0	0	0	0	1	1.05282	-30.35714	110	4	1.12	0.95;
	2379	1	0	0	0	0	1	1.05282	-30.35714	110	4	1.12	0.95;
	2380	1	15.81	1.1	0	0	1	1.06525	-18.84901	110	4	1.12	0.95;
	2381	1	6.74	0.65	0	0	1	1.06471	-18.46676	110	4	1.12	0.95;
	2382	1	15.15	2.06	0	0	1	1.06442	-18.75554	110	4	1.12	0.95;
	2383	1	12.47	1.86	0	0	1	1.06311	-18.71139	110	4	1.12	0.95;
	2384	1	23.03	2.95	0	0	1	1.04858	-30.69917	110	4	1.12	0.95;
	2385	1	5.93	0.1	0	0	1	1.08304	-36.33623	110	4	1.12	0.95;
	2386	1	0	0	0	0	1	1.07446	-26.62965	110	4	1.12	0.95;
	2387	1	0	0	0	0	1	1.06967	-26.63074	110	4	1.12	0.95;
	2388	1	18.5	9.2	0	0	1	1.07537	-33.55412	110	4	1.12	0.95;
	2389	1	1.99	0.43	0	0	1	1.04674	-21.40805	110	4	1.12	0.95;
	2390	1	10.12	-1.71	0	0	1	1.06387	-34.15154	110	4	1.12	0.95;
	2391	1	5.33	0.49	0	0	1	1.07422	-31.35162	110	4	1.12	0.95;
	2392	1	13.27	-1.22	0	0	1	1.06485	-27.52601	110	4	1.12	0.95;
	2393	1	5.83	0.96	0	0	1	1.10066	-13.67737	110	4	1.12	0.95;
	2394	1	10.36	1.25	0	0	1	1.07268	-16.04684	110	4	1.12	0.95;
	2395	1	5.01	-0.3	0	0	1	1.07158	-37.84597	110	4	1.12	0.95;
	2396	1	7.9	4.02	0	0	1	1.06986	-16.38577	110	4	1.12	0.95;
	2397	1	7.53	1.35	0	0	1	1.0451	-31.77435	110	4	1.12	0.95;
	2398	1	7.64	2.44	0	0	1	1.06976	-37.7713	110	4	1.12	0.95;
	2399	1	1.45	0.77	0	0	1	1.05803	-37.93814	110	4	1.12	0.95;
	2400	1	6.29	0.2	0	0	1	1.05182	-36.26714	110	4	1.12	0.95;
	2401	1	14.54	0.34	0	0	1	1.06142	-35.07647	110	4	1.12	0.95;
	2402	1	3.25	0.48	0	0	1	1.07415	-15.84072	110	4	1.12	0.95;
	2403	1	3.43	0.9	0	0	1	1.11725	-11.63887	110	4	1.12	0.95;
	2404	1	3.43	0.9	0	0	1	1.12	-10.74349	110	4	1.12	0.95;
	2405	1	8.49	1.9	0	0	1	1.05812	-39.87919	110	4	1.12	0.95;
	2406	1	2.74	0.44	0	0	1	1.10955	-31.70865	110	4	1.12	0.95;
	2407	1	15.41	9.58	0	0	1	1.04634	-20.39166	110	4	1.12	0.95;
	2408	1	0	0	0	0	1	1.07621	-34.08536	110	4	1.12	0.95;
	2409	1	11.39	3.27	0	0	1	1.08062	-17.96743	110	4	1.12	0.95;
	2410	2	1.88	1.36	0	0	1	1.05703	-17.41682	110	4	1.12	0.95;
	2411	2	11.75	4.04	0	0	1	1.08405	-36.12063	110	4	1.12	0.95;
	2412	1	13.59	6.02	0	0	1	1.08027	-37.14123	110	4	1.12	0.95;
	2413	1	15.07	0.92	0	0	1	1.0664	-33.51236	110	4	1.12	0.95;
	2414	1	3.73	-0.55	0	0	1	1.0655	-34.83	110	4	1.12	0.95;
	2415	1	7.33	-0.33	0	0	1	1.06619	-34.30976	110	4	1.12	0.95;
	2416	1	4.74	0.1	0	0	1	1.05897	-37.9906	110	4	1.12	0.95;
	2417	1	10	5.12	0	0	1	1.08607	-33.41001	110	4	1.12	0.95;
	2418	1	6.17	1.63	0	0	1	1.07982	-33.70738	110	4	1.12	0.95;
	2419	1	12.06	6.23	0	0	1	1.07378	-33.58231	110	4	1.12	0.95;
	2420	1	16.3	6.79	0	0	1	1.08281	-33.56772	110	4	1.12	0.95;
	2421	1	9.95	3.03	0	0	1	1.08589	-18.88611	110	4	1.12	0.95;
	2422	1	7.12	-0.6	0	0	1	1.0661	-32.17633	110	4	1.12	0.95;
	2423	1	5.67	2.26	0	0	1	1.07169	-26.84638	110	4	1.12	0.95;
	2424	1	4.08	2.24	0	0	1	1.01655	-40.41052	110	4	1.12	0.95;
	2425	1	15.05	5.46	0	0	1	1.06809	-37.67887	110	4	1.12	0.95;
	2426	1	9.02	-1.02	0	0	1	1.02533	-27.28015	110	4	1.12	0.95;
	2427	1	19.92	8.67	0	0	1	1.00376	-34.83909	110	4	1.12	0.95;
	2428	1	19.58	-1.39	0	0	1	1.0217	-27.6915	110	4	1.12	0.95;
	2429	1	17.53	4.99	0	0	1	1.09426	-17.57696	110	4	1.12	0.95;
	2430	1	10.15	1.97	0	0	1	1.0671	-38.01215	110	4	1.12	0.95;
	2431	1	9.43	0.2	0	0	1	1.06933	-16.79765	110	4	1.12	0.95;
	2432	1	9.89	2.1	0	0	1	1.06927	-16.80313	110	4	1.12	0.95;
	2433	1	16.71	0.06	0	0	1	1.0692	-35.28077	110	4	1.12	0.95;
	2434	1	10.05	6.15	0	0	1	1.08592	-16.02529	110	4	1.12	0.95;
	2435	1	10.61	6.82	0	0	1	1.07183	-18.58281	110	4	1.12	0.95;
	2436	2	2.75	-1.22	0	0	1	1.07837	-38.24985	110	4	1.12	0.95;
	2437	2	26.17	16.15	0	0	1	1.06216	-17.18885	110	4	1.12	0.95;
	2438	1	23.43	5.01	0	0	1	1.07756	-18.25162	110	4	1.12	0.95;
	2439	2	1.55	1.62	0	0	1	1.03456	-34.66538	110	4	1.12	0.95;
	2440	2	11.73	9.24	0	0	1	1.07563	-18.21528	110	4	1.12	0.95;
	2441	1	7.7	1.78	0	0	1	1.07038	-18.47021	110	4	1.12	0.95;
	2442	2	29.6	14.3	0	0	1	1.07201	-18.37199	110	4	1.12	0.95;
	2443	1	0	0	0	0	1	1.07696	-18.13815	110	4	1.12	0.95;
	2444	1	0	0	0	0	1	1.07662	-18.19425	110	4	1.12	0.95;
	2445	1	0	0	0	0	1	0.94007	-18.43994	16	4	1.25	0.75;
	2446	1	17.23	2.27	0	0	1	1.06454	-19.84551	110	4	1.12	0.95;
	2447	1	0	0	0	0	1	1.09244	-15.51168	110	4	1.12	0.95;
	2448	1	0	0	0	0	1	1.09215	-16.79492	110	4	1.12	0.95;
	2449	2	17.28	30.71	0	0	1	1.12	-18.14439	110	4	1.12	0.95;
	2450	2	16.57	30.61	0	0	1	1.12	-22.51786	110	4	1.12	0.95;
	2451	1	1.4	0.11	0	0	1	1.06252	-18.48664	110	4	1.12	0.95;
	2452	1	3.18	0.87	0	0	1	1.06265	-18.47953	110	4	1.12	0.95;
	2453	1	2.59	0.29	0	0	1	1.08142	-14.87292	110	4	1.12	0.95;
	2454	1	3.89	0.48	0	0	1	1.08148	-14.86856	110	4	1.12	0.95;
	2455	1	14.85	4.06	0	0	1	1.08371	-18.79558	110	4	1.12	0.95;
	2456	1	5.18	5.44	0	0	1	1.06865	-16.57257	110	4	1.12	0.95;
	2457	1	6.63	4.2	0	0	1	1.06861	-16.57515	110	4	1.12	0.95;
	2458	1	10.69	2.41	0	0	1	1.02637	-25.74432	110	4	1.12	0.95;
	2459	1	17.59	-1.81	0	0	1	1.10979	-16.51164	110	4	1.12	0.95;
	2460	1	6.61	-1.1	0	0	1	1.10971	-16.5214	110	4	1.12	0.95;
	2461	1	13.73	8.06	0	0	1	1.0838	-33.55746	110	4	1.12	0.95;
	2462	2	17.34	-0.38	0	0	1	1.06997	-34.24931	110	4	1.12	0.95;
	2463	2	20.97	-1.16	0	0	1	1.08157	-37.76021	110	4	1.12	0.95;
	2464	1	11.46	0.7	0	0	1	1.06851	-16.68676	110	4	1.12	0.95;
	2465	1	0	0	0	0	1	1.06851	-16.68676	110	4	1.12	0.95;
	2466	1	18.93	-3.62	0	0	1	1.08308	-37.58605	110	4	1.12	0.95;
	2467	1	20.82	6.99	0	0	1	1.07848	-33.76324	110	4	1.12	0.95;
	2468	1	0	0	0	0	1	1.08539	-36.95573	110	4	1.12	0.95;
	2469	1	0	0	0	0	1	1.08761	-36.8491	110	4	1.12	0.95;
	2470	2	25.03	11.64	0	0	1	1.0502	-35.23831	110	4	1.12	0.95;
	2471	1	22.39	7.12	0	0	1	1.05021	-35.24221	110	4	1.12	0.95;
	2472	1	0	0	0	0	1	1.07434	-33.49072	110	4	1.12	0.95;
	2473	1	0	0	0	0	1	1.07788	-33.10544	110	4	1.12	0.95;
	2474	1	3.7	0.23	0	0	1	1.05395	-22.27686	110	4	1.12	0.95;
	2475	1	2.55	0.2	0	0	1	1.04691	-22.22996	110	4	1.12	0.95;
	2476	1	6.57	-2.06	0	0	1	1.06588	-27.29698	110	4	1.12	0.95;
	2477	1	12.71	3.06	0	0	1	1.05375	-22.45759	110	4	1.12	0.95;
	2478	1	3.56	0.32	0	0	1	1.03933	-26.14005	110	4	1.12	0.95;
	2479	1	20.83	6.74	0	0	1	1.05978	-38.11468	110	4	1.12	0.95;
	2480	1	15.12	2.17	0	0	1	1.07274	-37.11328	110	4	1.12	0.95;
	2481	1	17.26	1.8	0	0	1	1.05054	-36.51088	110	4	1.12	0.95;
	2482	1	0	0	0	0	1	1.05054	-36.51088	110	4	1.12	0.95;
	2483	1	6.48	0.96	0	0	1	1.10679	-12.9363	110	4	1.12	0.95;
	2484	1	6.3	0.57	0	0	1	1.07356	-33.36905	110	4	1.12	0.95;
	2485	1	27.4	11.46	0	0	1	1.07999	-33.69508	110	4	1.12	0.95;
	2486	1	0	0	0	0	1	1.04691	-22.22956	110	4	1.12	0.95;
	2487	1	0	0	0	0	1	1.05396	-22.27611	110	4	1.12	0.95;
	2488	2	11.95	14.1	0	0	1	1.07048	-37.3075	110	4	1.12	0.95;
	2489	2	12.74	8.26	0	0	1	1.07041	-37.32124	110	4	1.12	0.95;
	2490	1	12.47	-1.75	0	0	1	1.07621	-34.08536	110	4	1.12	0.95;
	2491	1	19.19	5.6	0	0	1	1.07918	-33.73282	110	4	1.12	0.95;
	2492	1	8.49	-0.72	0	0	1	1.07842	-33.48547	110	4	1.12	0.95;
	2493	1	9.86	-0.84	0	0	1	1.07819	-33.50191	110	4	1.12	0.95;
	2494	1	26.58	4.99	0	0	1	1.08141	-37.75348	110	4	1.12	0.95;
	2495	1	15.48	3.62	0	0	1	1.07226	-33.77072	110	4	1.12	0.95;
	2496	1	16.03	4.89	0	0	1	1.07671	-33.58628	110	4	1.12	0.95;
	2497	2	6.38	0.43	0	0	1	1.06855	-19.48978	110	4	1.12	0.95;
	2498	1	12.74	0.67	0	0	1	1.06847	-19.52772	110	4	1.12	0.95;
	2499	1	4.34	1.31	0	0	1	1.07959	-18.01403	110	4	1.12	0.95;
	2500	2	35.53	12.39	0	0	1	1.08724	-16.05008	110	4	1.12	0.95;
	2501	1	28.63	-0.4	0	0	1	1.07554	-33.89305	110	4	1.12	0.95;
	2502	1	7.64	1.01	0	0	1	1.06993	-17.47215	110	4	1.12	0.95;
	2503	1	17.75	2.35	0	0	1	1.04761	-20.65851	110	4	1.12	0.95;
	2504	1	10.44	4.34	0	0	1	1.08699	-17.57076	110	4	1.12	0.95;
	2505	1	10.98	4.63	0	0	1	1.08213	-17.79336	110	4	1.12	0.95;
	2506	2	3.34	2.05	0	0	1	1.08059	-15.76123	110	4	1.12	0.95;
	2507	1	9.1	4.86	0	0	1	1.06911	-35.59342	110	4	1.12	0.95;
	2508	2	8.54	4.37	0	0	1	1.017	-32.17067	110	4	1.12	0.95;
	2509	1	15.38	5.42	0	0	1	1.01695	-32.17747	110	4	1.12	0.95;
	2510	1	4.96	1.13	0	0	1	1.09915	-14.02447	110	4	1.12	0.95;
	2511	1	4.51	1.94	0	0	1	1.07315	-19.20555	110	4	1.12	0.95;
	2512	2	0	0	0	0	1	1.06009	-37.81842	110	4	1.12	0.95;
	2513	2	7.92	3.76	0	0	1	1.06009	-37.81874	110	4	1.12	0.95;
	2514	1	15.07	-1.45	0	0	1	1.067	-35.82767	110	4	1.12	0.95;
	2515	2	48.16	28.15	0	0	1	1.06182	-17.51734	110	4	1.12	0.95;
	2516	1	0	0	0	0	1	1.062	-17.49885	110	4	1.12	0.95;
	2517	1	3.44	0	0	0	1	1.07093	-16.52914	110	4	1.12	0.95;
	2518	1	4.93	-0.14	0	0	1	1.0412	-32.68195	110	4	1.12	0.95;
	2519	1	12	-0.21	0	0	1	1.03774	-34.70143	110	4	1.12	0.95;
	2520	1	12	-2.08	0	0	1	1.02922	-31.15946	110	4	1.12	0.95;
	2521	1	9.67	-0.59	0	0	1	1.02313	-31.73017	110	4	1.12	0.95;
	2522	1	8.6	1.21	0	0	1	1.06932	-16.95865	110	4	1.12	0.95;
	2523	1	7.37	0.42	0	0	1	1.0813	-18.55166	110	4	1.12	0.95;
	2524	1	2.29	0.33	0	0	1	1.08129	-18.55527	110	4	1.12	0.95;
	2525	1	11.46	1.4	0	0	1	1.06693	-16.99547	110	4	1.12	0.95;
	2526	1	0	0	0	0	1	1.06693	-16.99547	110	4	1.12	0.95;
	2527	1	9.06	-2.41	0	0	1	1.05933	-35.60096	110	4	1.12	0.95;
	2528	1	11.37	9.22	0	0	1	1.06348	-33.3509	110	4	1.12	0.95;
	2529	1	9.22	0.34	0	0	1	1.06902	-37.87043	110	4	1.12	0.95;
	2530	1	11.45	-0.18	0	0	1	1.07122	-37.62374	110	4	1.12	0.95;
	2531	2	3.26	0.24	0	0	1	1.08129	-14.89286	110	4	1.12	0.95;
	2532	2	5.87	0.26	0	0	1	1.06773	-33.6981	110	4	1.12	0.95;
	2533	1	3.44	0	0	0	1	1.06577	-16.98034	110	4	1.12	0.95;
	2534	2	3.19	0.93	0	0	1	1.09155	-19.50314	110	4	1.12	0.95;
	2535	1	24.48	10.78	0	0	1	1.03934	-27.70371	110	4	1.12	0.95;
	2536	1	20.92	1.11	0	0	1	1.07523	-17.031	110	4	1.12	0.95;
	2537	1	7.77	1.75	0	0	1	1.07067	-16.71495	110	4	1.12	0.95;
	2538	1	12.36	3.46	0	0	1	1.03514	-26.41932	110	4	1.12	0.95;
	2539	1	11.1	5.38	0	0	1	1.05114	-31.99505	110	4	1.12	0.95;
	2540	2	25.1	4.74	0	0	1	1.04846	-37.32675	110	4	1.12	0.95;
	2541	1	16.48	4.92	0	0	1	1.07445	-28.04442	110	4	1.12	0.95;
	2542	2	25.2	10.69	0	0	1	1.02877	-31.94617	110	4	1.12	0.95;
	2543	1	14.66	-0.04	0	0	1	1.04923	-36.61918	110	4	1.12	0.95;
	2544	2	20.01	9.09	0	0	1	1.03266	-32.05204	110	4	1.12	0.95;
	2545	1	18.24	-0.98	0	0	1	1.0789	-18.16064	110	4	1.12	0.95;
	2546	1	3.58	0.5	0	0	1	1.0721	-18.69393	110	4	1.12	0.95;
	2547	1	6.24	4.28	0	0	1	1.06125	-20.65328	110	4	1.12	0.95;
	2548	1	4.96	2.21	0	0	1	1.07207	-19.04559	110	4	1.12	0.95;
	2549	1	22.9	1.75	0	0	1	1.06149	-17.48216	110	4	1.12	0.95;
	2550	1	0	0	0	0	1	1.06149	-17.48216	110	4	1.12	0.95;
	2551	1	11.08	0.27	0	0	1	1.06597	-35.11844	110	4	1.12	0.95;
	2552	1	1.68	0.39	0	0	1	1.10142	-13.32168	110	4	1.12	0.95;
	2553	1	10.15	0.76	0	0	1	1.07137	-30.12244	110	4	1.12	0.95;
	2554	1	30.96	11.75	0	0	1	1.0737	-33.44828	110	4	1.12	0.95;
	2555	1	8.68	3.39	0	0	1	0.99738	-33.98496	110	4	1.12	0.95;
	2556	1	12.74	4.37	0	0	1	1.07093	-16.6062	110	4	1.12	0.95;
	2557	2	0.01	0.01	0	0	1	1.08253	-15.93073	110	4	1.12	0.95;
	2558	1	17.91	4.39	0	0	1	1.0492	-38.92586	110	4	1.12	0.95;
	2559	1	0	0	0	0	1	1.05885	-38.0051	110	4	1.12	0.95;
	2560	1	6.69	2.61	0	0	1	1.0864	-17.42843	110	4	1.12	0.95;
	2561	1	1.05	0.49	0	0	1	1.05884	-38.00468	110	4	1.12	0.95;
	2562	2	15.69	6.43	0	0	1	1.06822	-37.78045	110	4	1.12	0.95;
	2563	2	7.58	1.92	0	0	1	1.05916	-19.68085	110	4	1.12	0.95;
	2564	1	10.75	2.85	0	0	1	1.06844	-19.34549	110	4	1.12	0.95;
	2565	2	13.08	8.11	0	0	1	1.07183	-37.17894	110	4	1.12	0.95;
	2566	1	9.41	1.16	0	0	1	1.02605	-27.39511	110	4	1.12	0.95;
	2567	1	8.55	5.01	0	0	1	1.06998	-37.64484	110	4	1.12	0.95;
	2568	2	7.52	-0.22	0	0	1	1.01855	-40.28275	110	4	1.12	0.95;
	2569	1	32.2	8.13	0	0	1	1.05295	-36.42161	110	4	1.12	0.95;
	2570	1	14.77	7.55	0	0	1	1.07874	-18.05369	110	4	1.12	0.95;
	2571	1	15.67	5.12	0	0	1	1.11627	-13.00696	110	4	1.12	0.95;
	2572	1	14.25	-1.07	0	0	1	1.06749	-38.13215	110	4	1.12	0.95;
	2573	1	9.12	2.46	0	0	1	1.11903	-11.29275	110	4	1.12	0.95;
	2574	1	2.59	0.87	0	0	1	1.11748	-11.38796	110	4	1.12	0.95;
	2575	1	2.72	0.96	0	0	1	1.1169	-11.42124	110	4	1.12	0.95;
	2576	1	17.1	7.91	0	0	1	1.11762	-11.37743	110	4	1.12	0.95;
	2577	1	26.16	12.05	0	0	1	1.11709	-11.40854	110	4	1.12	0.95;
	2578	1	8.74	2.06	0	0	1	1.11627	-11.50661	110	4	1.12	0.95;
	2579	1	6.24	1.03	0	0	1	1.11628	-11.50542	110	4	1.12	0.95;
	2580	2	20.43	34	0	0	1	1.11962	-11.26504	110	4	1.12	0.95;
	2581	1	9.12	4.92	0	0	1	1.11956	-11.25954	110	4	1.12	0.95;
	2582	1	39.56	12.82	0	0	1	1.06752	-37.65376	110	4	1.12	0.95;
	2583	1	12.73	1.01	0	0	1	1.07307	-18.73309	110	4	1.12	0.95;
	2584	1	3.29	0.63	0	0	1	1.07624	-16.40653	110	4	1.12	0.95;
	2585	1	19.74	9.62	0	0	1	1.06707	-16.77416	110	4	1.12	0.95;
	2586	1	4.84	1.75	0	0	1	1.06708	-16.77307	110	4	1.12	0.95;
	2587	1	26.58	6.53	0	0	1	1.06517	-35.97286	110	4	1.12	0.95;
	2588	1	10.95	7.24	0	0	1	1.09647	-18.97595	110	4	1.12	0.95;
	2589	1	5.01	1.57	0	0	1	1.09708	-18.95317	110	4	1.12	0.95;
	2590	1	29.73	10.25	0	0	1	1.07772	-33.75235	110	4	1.12	0.95;
	2591	1	3.16	-0.32	0	0	1	1.10694	-34.56768	110	4	1.12	0.95;
	2592	2	34.35	32.95	0	0	1	1.11489	-16.19484	110	4	1.12	0.95;
	2593	2	37.88	31.94	0	0	1	1.09089	-16.9285	110	4	1.12	0.95;
	2594	1	4.78	2.11	0	0	1	1.10613	-14.87411	110	4	1.12	0.95;
	2595	1	3.69	-0.79	0	0	1	1.07492	-38.20962	110	4	1.12	0.95;
	2596	1	0	0	0	0	1	1.07159	-16.40808	110	4	1.12	0.95;
	2597	1	-7.33	-0.63	0	0	1	1.07159	-16.40808	110	4	1.12	0.95;
	2598	2	6.49	0.97	0	0	1	1.08188	-14.81828	110	4	1.12	0.95;
	2599	1	11.29	1.69	0	0	1	1.08176	-14.84957	110	4	1.12	0.95;
	2600	1	6.1	1.87	0	0	1	1.07456	-29.86545	110	4	1.12	0.95;
	2601	1	1.87	0.31	0	0	1	1.10063	-13.55978	110	4	1.12	0.95;
	2602	1	0	0	0	0	1	1.10191	-13.27541	110	4	1.12	0.95;
	2603	1	22.47	-1.25	0	0	1	1.06495	-39.41565	110	4	1.12	0.95;
	2604	2	11.81	1.78	0	0	1	1.0849	-17.94053	110	4	1.12	0.95;
	2605	1	0	0	0	0	1	1.0849	-17.94053	110	4	1.12	0.95;
	2606	1	9.66	5.89	0	0	1	1.09559	-16.0047	110	4	1.12	0.95;
	2607	1	12.71	2.86	0	0	1	1.09066	-16.94624	110	4	1.12	0.95;
	2608	2	5.77	1.07	0	0	1	1.08089	-17.58001	110	4	1.12	0.95;
	2609	1	12.59	3.73	0	0	1	1.08102	-17.57442	110	4	1.12	0.95;
	2610	1	22.61	4.59	0	0	1	1.04927	-37.64731	110	4	1.12	0.95;
	2611	2	17.82	4.63	0	0	1	1.07881	-17.75982	110	4	1.12	0.95;
	2612	1	15.93	5.68	0	0	1	1.11036	-16.51237	110	4	1.12	0.95;
	2613	1	8.71	0.92	0	0	1	1.10644	-16.63523	110	4	1.12	0.95;
	2614	1	8.58	-0.81	0	0	1	1.07929	-17.19739	110	4	1.12	0.95;
	2615	1	27.64	6.57	0	0	1	1.058	-8.42706	110	4	1.12	0.95;
	2616	1	13.52	7.03	0	0	1	1.0876	-17.53084	110	4	1.12	0.95;
	2617	1	10.72	6.46	0	0	1	1.08278	-17.75108	110	4	1.12	0.95;
	2618	2	9.32	0.78	0	0	1	1.053	-28.54113	110	4	1.12	0.95;
	2619	1	3.69	2.45	0	0	1	1.05314	-28.55882	110	4	1.12	0.95;
	2620	1	26.85	2.78	0	0	1	1.06284	-31.20808	110	4	1.12	0.95;
	2621	1	21.16	16.29	0	0	1	1.02446	-27.52644	110	4	1.12	0.95;
	2622	1	6.46	0.16	0	0	1	1.05122	-38.77254	110	4	1.12	0.95;
	2623	1	6.59	0	0	0	1	1.04169	-35.56889	110	4	1.12	0.95;
	2624	1	19.09	5.01	0	0	1	1.09485	-15.96185	110	4	1.12	0.95;
	2625	1	23.51	7.69	0	0	1	1.08477	-17.49062	110	4	1.12	0.95;
	2626	1	14.59	4.46	0	0	1	1.07296	-18.28192	110	4	1.12	0.95;
	2627	1	15.03	8.02	0	0	1	1.07629	-17.32365	110	4	1.12	0.95;
	2628	1	11.66	1.93	0	0	1	1.10093	-13.53046	110	4	1.12	0.95;
	2629	1	11.66	1.93	0	0	1	1.10095	-13.52793	110	4	1.12	0.95;
	2630	1	9.32	-1.74	0	0	1	1.11006	-31.62229	110	4	1.12	0.95;
	2631	1	14.19	2.58	0	0	1	1.07932	-17.37636	110	4	1.12	0.95;
	2632	1	14.99	1.45	0	0	1	1.11047	-16.48137	110	4	1.12	0.95;
	2633	1	21.55	10.03	0	0	1	1.07271	-18.29905	110	4	1.12	0.95;
	2634	1	21.39	7.11	0	0	1	1.10307	-16.1658	110	4	1.12	0.95;
	2635	1	0	0	0	0	1	1.07713	-16.32202	110	4	1.12	0.95;
	2636	1	0	0	0	0	1	1.06586	-18.31287	110	4	1.12	0.95;
	2637	1	0	0	0	0	1	1.09855	-25.45747	110	4	1.12	0.95;
	2638	1	0	0	0	0	1	1.11641	-18.4939	110	4	1.12	0.95;
	2639	1	0	0	0	0	1	1.07252	-18.39079	110	4	1.12	0.95;
	2640	1	0	0	0	0	1	1.05354	-22.34807	110	4	1.12	0.95;
	2641	1	0	0	0	0	1	1.06114	-20.90194	110	4	1.12	0.95;
	2642	1	0	0	0	0	1	1.06636	-18.68669	110	4	1.12	0.95;
	2643	1	0	0	0	0	1	1.064	-34.13222	110	4	1.12	0.95;
	2644	1	0	0	0	0	1	1.07436	-31.3404	110	4	1.12	0.95;
	2645	1	0	0	0	0	1	1.05356	-28.63483	110	4	1.12	0.95;
	2646	1	0	0	0	0	1	1.08245	-17.86726	110	4	1.12	0.95;
	2647	1	0	0	0	0	1	1.06716	-34.03924	110	4	1.12	0.95;
	2648	1	0	0	0	0	1	1.05854	-21.19036	110	4	1.12	0.95;
	2649	1	0	0	0	0	1	1.08282	-37.59552	110	4	1.12	0.95;
	2650	1	0	0	0	0	1	1.06233	-20.62447	110	4	1.12	0.95;
	2651	1	0	0	0	0	1	1.08085	-37.5046	110	4	1.12	0.95;
	2652	1	0	0	0	0	1	1.07401	-34.18629	110	4	1.12	0.95;
	2653	1	0	0	0	0	1	1.0579	-23.76621	110	4	1.12	0.95;
	2654	1	0	0	0	0	1	1.07252	-19.0277	110	4	1.12	0.95;
	2655	1	0	0	0	0	1	1.07671	-36.88362	110	4	1.12	0.95;
	2656	1	0	0	0	0	1	1.07659	-16.36588	110	4	1.12	0.95;
	2657	1	0	0	0	0	1	1.08702	-17.31749	110	4	1.12	0.95;
	2658	1	0	0	0	0	1	1.08762	-17.53699	110	4	1.12	0.95;
	2659	1	0	0	0	0	1	1.03764	-35.79651	110	4	1.12	0.95;
	2660	1	7.48	1.9	0	0	1	1.10394	-16.74176	110	4	1.12	0.95;
	2661	1	7.92	0.31	0	0	1	1.0964	-4.73819	110	4	1.12	0.95;
	2662	1	2.96	3.04	0	0	1	1.05532	-27.12992	110	4	1.12	0.95;
	2663	1	13.03	6.36	0	0	1	1.00862	-29.03608	110	4	1.12	0.95;
	2664	1	10.14	4.74	0	0	1	1.06655	-37.4413	110	4	1.12	0.95;
	2665	1	65.55	42.06	0	0	1	0.9963	-30.3031	110	4	1.12	0.95;
	2666	1	7.78	0.5	0	0	1	1.07998	-16.02379	110	4	1.12	0.95;
	2667	1	0	0	0	0	1	1.07998	-16.02379	110	4	1.12	0.95;
	2668	1	0	0.18	0	0	1	1.08171	-15.71889	110	4	1.12	0.95;
	2669	1	11.46	4.37	0	0	1	1.08163	-15.7376	110	4	1.12	0.95;
	2670	1	11.74	11.7	0	0	1	0.99755	-33.96307	110	4	1.12	0.95;
	2671	1	13.17	12.26	0	0	1	0.99751	-33.98068	110	4	1.12	0.95;
	2672	1	8.43	1.87	0	0	1	1.0763	-36.9079	110	4	1.12	0.95;
	2673	1	36.03	18.76	0	0	1	1.07546	-33.98009	110	4	1.12	0.95;
	2674	1	50.68	17.89	0	0	1	1.05911	-38.16538	110	4	1.12	0.95;
	2675	1	9.92	-1.66	0	0	1	1.06459	-27.51073	110	4	1.12	0.95;
	2676	1	26.33	8.41	0	0	1	1.06192	-27.70818	110	4	1.12	0.95;
	2677	2	18.31	3.21	0	0	1	1.06352	-27.65895	110	4	1.12	0.95;
	2678	1	9.71	-1.97	0	0	1	1.11176	-12.40421	110	4	1.12	0.95;
	2679	1	5.29	0.74	0	0	1	1.06577	-20.24869	110	4	1.12	0.95;
	2680	1	4.66	0.22	0	0	1	1.05569	-35.7606	110	4	1.12	0.95;
	2681	1	9.67	4.07	0	0	1	1.11817	-12.66561	110	4	1.12	0.95;
	2682	1	21.58	3.1	0	0	1	1.07622	-38.15837	110	4	1.12	0.95;
	2683	1	9.78	-0.88	0	0	1	1.08314	-16.37903	110	4	1.12	0.95;
	2684	2	11.93	2.77	0	0	1	1.05509	-38.45897	110	4	1.12	0.95;
	2685	2	4.96	0.62	0	0	1	1.04944	-24.21899	110	4	1.12	0.95;
	2686	1	14.01	1.22	0	0	1	1.07652	-16.2939	110	4	1.12	0.95;
	2687	1	0	0	0	0	1	1.07647	-16.30052	110	4	1.12	0.95;
	2688	1	11.86	2.81	0	0	1	1.05869	-18.80614	110	4	1.12	0.95;
	2689	1	0	0	0	0	1	1.06284	-18.48424	110	4	1.12	0.95;
	2690	1	0	0	0	0	1	1.06117	-24.14872	110	4	1.12	0.95;
	2691	1	0	0	0	0	1	1.05372	-24.58078	110	4	1.12	0.95;
	2692	1	10.33	5.96	0	0	1	1.07414	-17.21752	110	4	1.12	0.95;
	2693	1	0.79	0.32	0	0	1	1.07269	-37.29049	110	4	1.12	0.95;
	2694	2	9.96	0.8	0	0	1	1.09935	-33.29623	110	5	1.12	0.95;
	2695	1	12.57	2.51	0	0	1	1.06985	-36.46691	110	5	1.12	0.95;
	2696	1	20.43	4.02	0	0	1	1.11475	-29.78963	110	5	1.12	0.95;
	2697	2	11.05	9.04	0	0	1	1.11976	-28.90657	110	5	1.12	0.95;
	2698	2	10.1	9.04	0	0	1	1.11975	-28.90639	110	5	1.12	0.95;
	2699	1	9.43	2.01	0	0	1	1.08232	-35.42001	110	5	1.12	0.95;
	2700	2	7.86	0.5	0	0	1	1.08252	-32.53961	110	5	1.12	0.95;
	2701	1	5.76	0	0	0	1	1.08245	-32.53614	110	5	1.12	0.95;
	2702	1	9.43	2.01	0	0	1	1.11775	-29.15077	110	5	1.12	0.95;
	2703	1	14.46	3.92	0	0	1	1.08036	-32.20459	110	5	1.12	0.95;
	2704	1	12.57	8.04	0	0	1	1.07574	-31.23006	110	5	1.12	0.95;
	2705	1	24.1	4.52	0	0	1	1.11602	-29.56988	110	5	1.12	0.95;
	2706	2	10.48	4.02	0	0	1	1.06243	-35.39966	110	5	1.12	0.95;
	2707	1	6.29	2.01	0	0	1	1.09223	-34.15382	110	5	1.12	0.95;
	2708	1	10.9	3.22	0	0	1	1.08352	-32.08468	110	5	1.12	0.95;
	2709	1	7.33	2.01	0	0	1	1.04284	-36.36685	110	5	1.12	0.95;
	2710	1	25.67	6.03	0	0	1	1.11424	-29.63622	110	5	1.12	0.95;
	2711	1	19.91	5.02	0	0	1	1.11714	-29.38083	110	5	1.12	0.95;
	2712	1	0	0	0	0	1	1.12	-29.70492	110	5	1.12	0.95;
	2713	1	0	0	0	0	1	1.11979	-29.71851	110	5	1.12	0.95;
	2714	2	13.62	2.01	0	0	1	1.07691	-33.52728	110	5	1.12	0.95;
	2715	1	5.24	1.21	0	0	1	1.07961	-34.16677	110	5	1.12	0.95;
	2716	1	9.43	3.01	0	0	1	1.04602	-34.93031	110	5	1.12	0.95;
	2717	2	26.01	7.44	0	0	1	1.09065	-32.66108	110	5	1.12	0.95;
	2718	2	12.91	2.01	0	0	1	1.0905	-32.65456	110	5	1.12	0.95;
	2719	2	11.84	3.82	0	0	1	1.10414	-30.86907	110	5	1.12	0.95;
	2720	1	9.43	2.51	0	0	1	1.10021	-30.32847	110	5	1.12	0.95;
	2721	1	9.33	2.41	0	0	1	1.10023	-30.31785	110	5	1.12	0.95;
	2722	1	15.19	4.32	0	0	1	1.04769	-34.82899	110	5	1.12	0.95;
	2723	1	10.9	3.11	0	0	1	1.11193	-30.4989	110	5	1.12	0.95;
	2724	1	10.48	3.01	0	0	1	1.04338	-36.96864	110	5	1.12	0.95;
	2725	1	12.05	0.5	0	0	1	1.04575	-37.09003	110	5	1.12	0.95;
	2726	2	13.62	3.32	0	0	1	1.03674	-35.58092	110	5	1.12	0.95;
	2727	1	17.29	3.22	0	0	1	1.09684	-33.08833	110	5	1.12	0.95;
	2728	1	5.24	0	0	0	1	1.02649	-40.75068	110	5	1.12	0.95;
	2729	2	4.72	0.3	0	0	1	1.03437	-35.97404	110	5	1.12	0.95;
	2730	2	4.19	1.11	0	0	1	1.07595	-32.3049	110	5	1.12	0.95;
	2731	2	0.52	0.1	0	0	1	1.08099	-32.80065	110	5	1.12	0.95;
	2732	1	9.96	2.01	0	0	1	1.08737	-34.2226	110	5	1.12	0.95;
	2733	2	6.29	0.5	0	0	1	1.02453	-40.93202	110	5	1.12	0.95;
	2734	1	0.84	0.4	0	0	1	1.10451	-30.47696	110	5	1.12	0.95;
	2735	1	11.32	4.02	0	0	1	1.10526	-28.78704	110	5	1.12	0.95;
	2736	2	6.81	0	0	0	1	1.0876	-31.24631	110	5	1.12	0.95;
	2737	1	0	0	0	0	1	1.08349	-31.61456	110	5	1.12	0.95;
	2738	1	0	0	0	0	1	1.08347	-31.63396	110	5	1.12	0.95;
	2739	2	21.35	7.03	0	0	1	1.06072	-35.29065	110	5	1.12	0.95;
	2740	2	1.51	1	0	0	1	1.0608	-35.29084	110	5	1.12	0.95;
	2741	1	19.91	4.02	0	0	1	1.05876	-35.61278	110	5	1.12	0.95;
	2742	1	14.67	4.02	0	0	1	1.05867	-35.43671	110	5	1.12	0.95;
	2743	1	8.91	2.01	0	0	1	1.11924	-29.16257	110	5	1.12	0.95;
	2744	1	7.33	1.81	0	0	1	1.11927	-29.15209	110	5	1.12	0.95;
	2745	2	2.2	1	0	0	1	1.07957	-33.11367	110	5	1.12	0.95;
	2746	1	0	0	0	0	1	1.10012	-32.99878	110	5	1.12	0.95;
	2747	1	0	0	0	0	1	1.09802	-33.12926	110	5	1.12	0.95;
	2748	1	0	0	0	48.6	1	1.04789	-33.46492	32	5	1.25	0.75;
	2749	2	11.05	3.01	0	0	1	1.10075	-33.35933	110	5	1.12	0.95;
	2750	2	41.55	21.1	0	0	1	1.10144	-33.06744	110	5	1.12	0.95;
	2751	1	0	0	0	0	1	1.09661	-33.00332	110	5	1.12	0.95;
	2752	1	0	0	0	0	1	1.09644	-33.75895	110	5	1.12	0.95;
	2753	1	29.34	4.02	0	0	1	1.09411	-33.51571	110	5	1.12	0.95;
	2754	1	12.05	2.11	0	0	1	1.08404	-33.33124	110	5	1.12	0.95;
	2755	1	0	0	0	0	1	1.08402	-33.31588	110	5	1.12	0.95;
	2756	1	6.29	1	0	0	1	1.09015	-33.68399	110	5	1.12	0.95;
	2757	2	5.34	0.9	0	0	1	1.10907	-30.12374	110	5	1.12	0.95;
	2758	1	11	4.02	0	0	1	1.07257	-24.58209	110	5	1.12	0.95;
	2759	2	0.01	0.01	0	0	1	1.08531	-30.6331	110	5	1.12	0.95;
	2760	1	8.28	2.61	0	0	1	1.09694	-30.58489	110	5	1.12	0.95;
	2761	1	5.76	2.01	0	0	1	1.07402	-33.11468	110	5	1.12	0.95;
	2762	1	23.05	5.02	0	0	1	1.08256	-33.47975	110	5	1.12	0.95;
	2763	1	18.86	6.03	0	0	1	1.0837	-33.35213	110	5	1.12	0.95;
	2764	2	0.94	0.1	0	0	1	1.11054	-30.41841	110	5	1.12	0.95;
	2765	1	0.31	0	0	0	1	1.11066	-30.40565	110	5	1.12	0.95;
	2766	1	3.14	1	0	0	1	1.0781	-35.69813	110	5	1.12	0.95;
	2767	1	3.14	1	0	0	1	1.09948	-33.1563	110	5	1.12	0.95;
	2768	1	13.83	4.52	0	0	1	1.10864	-30.16453	110	5	1.12	0.95;
	2769	1	0	0	0	0	1	1.11525	-29.57628	110	5	1.12	0.95;
	2770	1	0	0	0	0	1	1.11523	-29.55338	110	5	1.12	0.95;
	2771	1	0	0	0	0	1	1.11533	-29.55359	110	5	1.12	0.95;
	2772	1	0	0	0	60	1	1.04748	-30.06368	16	5	1.25	0.75;
	2773	1	5.13	1.11	0	0	1	1.0352	-35.81844	110	5	1.12	0.95;
	2774	1	7.86	0.5	0	0	1	1.0842	-34.4186	110	5	1.12	0.95;
	2775	1	19.91	3.01	0	0	1	1.08425	-33.02228	110	5	1.12	0.95;
	2776	1	8.28	3.11	0	0	1	1.09497	-31.15995	110	5	1.12	0.95;
	2777	2	11.53	2.81	0	0	1	1.11594	-29.66362	110	5	1.12	0.95;
	2778	1	10.48	2.01	0	0	1	1.11598	-29.66764	110	5	1.12	0.95;
	2779	1	13.62	3.52	0	0	1	1.12	-29.09066	110	5	1.12	0.95;
	2780	1	7.86	1.51	0	0	1	1.11992	-29.09324	110	5	1.12	0.95;
	2781	1	0	0	0	45	1	1.0801	-29.64757	16	5	1.25	0.75;
	2782	2	32.49	24.11	0	0	1	1.08445	-23.17061	110	5	1.12	0.95;
	2783	1	12.57	2.01	0	0	1	1.09514	-33.61182	110	5	1.12	0.95;
	2784	1	4.19	0.5	0	0	1	1.07839	-32.83266	110	5	1.12	0.95;
	2785	1	6.71	3.42	0	0	1	1.10366	-30.18993	110	5	1.12	0.95;
	2786	1	3.67	1.11	0	0	1	1.06321	-24.85339	110	5	1.12	0.95;
	2787	1	0	0	0	0	1	1.06322	-24.8519	110	5	1.12	0.95;
	2788	1	25.15	3.01	0	0	1	1.05352	-36.99957	110	5	1.12	0.95;
	2789	2	0	0	0	0	1	1.11048	-30.31268	110	5	1.12	0.95;
	2790	1	14.15	3.01	0	0	1	1.07394	-35.3641	110	5	1.12	0.95;
	2791	2	0.01	0.01	0	0	1	1.09262	-31.62362	110	5	1.12	0.95;
	2792	1	15.19	2.51	0	0	1	1.0892	-33.90683	110	5	1.12	0.95;
	2793	1	13.1	1	0	0	1	1.07223	-33.28948	110	5	1.12	0.95;
	2794	1	12.57	2.01	0	0	1	1.08487	-33.2451	110	5	1.12	0.95;
	2795	2	9.43	2.01	0	0	1	1.09323	-33.6625	110	5	1.12	0.95;
	2796	1	9.43	1	0	0	1	1.07299	-33.20011	110	5	1.12	0.95;
	2797	1	8.91	1.51	0	0	1	1.10859	-30.55632	110	5	1.12	0.95;
	2798	1	13.1	0	0	0	1	1.07945	-32.1041	110	5	1.12	0.95;
	2799	1	7.33	2.01	0	0	1	1.10798	-30.1657	110	5	1.12	0.95;
	2800	2	12.05	7.03	0	0	1	1.08008	-31.91281	110	5	1.12	0.95;
	2801	2	16.24	3.52	0	0	1	1.07968	-32.06769	110	5	1.12	0.95;
	2802	1	6.08	2.01	0	0	1	1.08194	-24.05007	110	5	1.12	0.95;
	2803	1	45.06	7.54	0	0	1	1.04962	-38.47096	110	5	1.12	0.95;
	2804	1	5.24	1.51	0	0	1	1.06738	-37.23662	110	5	1.12	0.95;
	2805	2	16.35	3.62	0	0	1	1.08054	-24.06753	110	5	1.12	0.95;
	2806	2	8.91	0.5	0	0	1	1.06735	-37.48076	110	5	1.12	0.95;
	2807	1	8.38	0.5	0	0	1	1.06737	-37.47493	110	5	1.12	0.95;
	2808	1	5.24	2.01	0	0	1	1.06459	-35.05221	110	5	1.12	0.95;
	2809	1	12.57	3.01	0	0	1	1.11956	-29.00666	110	5	1.12	0.95;
	2810	2	147.58	40.69	0	0	1	1.08526	-33.29314	110	5	1.12	0.95;
	2811	1	0	0	0	0	1	1.08535	-33.26853	110	5	1.12	0.95;
	2812	1	0	0	0	0	1	1.08535	-33.26852	110	5	1.12	0.95;
	2813	1	6.18	2.51	0	0	1	1.10466	-30.58502	110	5	1.12	0.95;
	2814	1	14.67	4.02	0	0	1	1.08405	-33.35065	110	5	1.12	0.95;
	2815	1	13.62	1	0	0	1	1.079	-32.15713	110	5	1.12	0.95;
	2816	2	4.82	1.91	0	0	1	1.10373	-30.76923	110	5	1.12	0.95;
	2817	1	12.16	4.32	0	0	1	1.09402	-26.65788	110	5	1.12	0.95;
	2818	1	0.1	0	0	0	1	1.1087	-30.47831	110	5	1.12	0.95;
	2819	1	11.95	3.92	0	0	1	1.10645	-26.723	110	5	1.12	0.95;
	2820	1	16.77	3.52	0	0	1	1.08241	-33.2692	110	5	1.12	0.95;
	2821	2	15.72	1.11	0	0	1	1.07451	-31.96007	110	5	1.12	0.95;
	2822	1	10.48	0.5	0	0	1	1.07443	-31.94685	110	5	1.12	0.95;
	2823	1	3.67	0.1	0	0	1	1.08368	-33.71432	110	5	1.12	0.95;
	2824	1	14.15	4.42	0	0	1	1.0947	-30.25305	110	5	1.12	0.95;
	2825	1	4.72	0	0	0	1	1.09931	-33.05608	110	5	1.12	0.95;
	2826	1	4.19	0	0	0	1	1.09922	-33.06331	110	5	1.12	0.95;
	2827	2	11.53	3.01	0	0	1	1.07942	-35.61414	110	5	1.12	0.95;
	2828	1	0.84	0.7	0	0	1	1.10626	-30.26422	110	5	1.12	0.95;
	2829	1	15.72	4.02	0	0	1	1.08551	-33.11362	110	5	1.12	0.95;
	2830	2	10.48	8.04	0	0	1	1.08006	-24.00286	110	5	1.12	0.95;
	2831	2	0	0	0	0	1	1.08005	-24.00218	110	5	1.12	0.95;
	2832	1	16.77	4.02	0	0	1	1.06376	-35.07119	110	5	1.12	0.95;
	2833	2	11.53	1	0	0	1	1.08554	-33.35579	110	5	1.12	0.95;
	2834	2	14.67	3.01	0	0	1	1.09634	-33.54361	110	5	1.12	0.95;
	2835	1	10.48	2.01	0	0	1	1.09625	-33.55783	110	5	1.12	0.95;
	2836	1	12.78	4.02	0	0	1	1.0829	-33.19902	110	5	1.12	0.95;
	2837	1	12.57	3.01	0	0	1	1.0852	-34.26958	110	5	1.12	0.95;
	2838	1	3.67	1.51	0	0	1	1.06673	-35.38635	110	5	1.12	0.95;
	2839	1	2.93	0.7	0	0	1	1.1097	-30.07898	110	5	1.12	0.95;
	2840	1	12.57	3.01	0	0	1	1.08567	-24.41395	110	5	1.12	0.95;
	2841	1	13.62	2.51	0	0	1	1.09914	-33.07225	110	5	1.12	0.95;
	2842	1	17.81	2.51	0	0	1	1.06904	-37.25789	110	5	1.12	0.95;
	2843	1	19.39	4.02	0	0	1	1.07441	-34.92588	110	5	1.12	0.95;
	2844	1	14.67	3.82	0	0	1	1.07636	-24.30495	110	5	1.12	0.95;
	2845	2	15.72	3.52	0	0	1	1.11099	-31.03015	110	5	1.12	0.95;
	2846	1	13.1	2.01	0	0	1	1.07531	-32.04311	110	5	1.12	0.95;
	2847	1	14.04	4.82	0	0	1	1.07885	-32.96149	110	5	1.12	0.95;
	2848	1	10.48	3.01	0	0	1	1.06725	-34.90875	110	5	1.12	0.95;
	2849	1	3.67	1	0	0	1	1.11496	-29.31789	110	5	1.12	0.95;
	2850	1	6.29	1.11	0	0	1	1.07869	-23.88531	110	5	1.12	0.95;
	2851	2	3.04	0.5	0	0	1	1.08731	-32.69005	110	5	1.12	0.95;
	2852	1	9.43	1	0	0	1	1.08625	-33.10514	110	5	1.12	0.95;
	2853	1	23.05	1.51	0	0	1	1.09508	-34.01	110	5	1.12	0.95;
	2854	1	0	0	0	0	1	1.0964	-33.18889	110	5	1.12	0.95;
	2855	1	0	0	0	0	1	1.09636	-33.20747	110	5	1.12	0.95;
	2856	1	0	0	0	60	1	1.05009	-33.56027	16	5	1.25	0.75;
	2857	2	8.38	1.51	0	0	1	1.09946	-33.32614	110	5	1.12	0.95;
	2858	1	8.38	2.01	0	0	1	1.09947	-33.33066	110	5	1.12	0.95;
	2859	1	9.43	2.01	0	0	1	1.08283	-32.78114	110	5	1.12	0.95;
	2860	1	18.34	2.51	0	0	1	1.10096	-33.08631	110	5	1.12	0.95;
	2861	1	23.05	6.03	0	0	1	1.09344	-33.80175	110	5	1.12	0.95;
	2862	2	9.43	2.01	0	0	1	1.08391	-30.19233	110	5	1.12	0.95;
	2863	1	11.53	3.01	0	0	1	1.09842	-33.39617	110	5	1.12	0.95;
	2864	1	26.2	2.01	0	0	1	1.08329	-33.91966	110	5	1.12	0.95;
	2865	1	6.29	2.01	0	0	1	1.0758	-34.91878	110	5	1.12	0.95;
	2866	1	3.98	1.21	0	0	1	1.0792	-33.51647	110	5	1.12	0.95;
	2867	1	20.96	4.52	0	0	1	1.11569	-30.23544	110	5	1.12	0.95;
	2868	1	8.38	2.51	0	0	1	1.09455	-33.71846	110	5	1.12	0.95;
	2869	2	15.72	3.52	0	0	1	1.09447	-33.73459	110	5	1.12	0.95;
	2870	1	0	0	0	0	1	1.09634	-33.54363	110	5	1.12	0.95;
	2871	1	0	0	0	0	1	1.09625	-33.55784	110	5	1.12	0.95;
	2872	1	8.49	2.01	0	0	1	1.08039	-23.72688	110	5	1.12	0.95;
	2873	1	7.33	2.01	0	0	1	1.08039	-23.71821	110	5	1.12	0.95;
	2874	1	16.77	5.02	0	0	1	1.09867	-33.35226	110	5	1.12	0.95;
	2875	1	0.1	0	0	0	1	1.08877	-32.48662	110	5	1.12	0.95;
	2876	1	3.67	0.5	0	0	1	1.08576	-31.51958	110	5	1.12	0.95;
	2877	1	14.67	6.03	0	0	1	1.09362	-23.68286	110	5	1.12	0.95;
	2878	1	14.67	4.02	0	0	1	1.06021	-35.738	110	5	1.12	0.95;
	2879	1	0	0	0	0	1	1.06027	-35.73326	110	5	1.12	0.95;
	2880	1	5.24	1	0	0	1	1.08329	-34.15747	110	5	1.12	0.95;
	2881	1	5.24	1	0	0	1	1.09144	-33.4996	110	5	1.12	0.95;
	2882	1	8.38	2.01	0	0	1	1.09426	-34.09222	110	5	1.12	0.95;
	2883	1	3.14	1	0	0	1	1.06127	-35.36751	110	5	1.12	0.95;
	2884	1	5.76	1	0	0	1	1.07799	-35.46802	110	5	1.12	0.95;
	2885	1	6.81	0.8	0	0	1	1.10002	-33.31844	110	5	1.12	0.95;
	2886	1	16.77	3.01	0	0	1	1.09688	-33.79366	110	5	1.12	0.95;
	2887	1	7.13	2.81	0	0	1	1.10016	-31.02349	110	5	1.12	0.95;
	2888	1	0	0	0	0	1	1.10013	-31.02244	110	5	1.12	0.95;
	2889	1	7.86	1.71	0	0	1	1.07604	-24.61391	110	5	1.12	0.95;
	2890	2	4.19	1	0	0	1	1.06872	-35.26172	110	5	1.12	0.95;
	2891	1	3.98	1	0	0	1	1.10177	-31.28679	110	5	1.12	0.95;
	2892	1	0.1	0.1	0	0	1	1.08425	-31.34275	110	5	1.12	0.95;
	2893	2	21.38	5.02	0	0	1	1.09205	-33.93093	110	5	1.12	0.95;
	2894	1	7.33	2.01	0	0	1	1.1128	-30.82729	110	5	1.12	0.95;
	2895	1	11.53	3.01	0	0	1	1.10413	-30.64062	110	5	1.12	0.95;
	2896	1	18.34	4.32	0	0	1	1.07892	-23.97119	110	5	1.12	0.95;
	2897	2	23.58	16.38	0	0	1	1.09943	-33.03506	110	5	1.12	0.95;
	2898	1	20.96	8.34	0	0	1	1.09747	-33.16534	110	5	1.12	0.95;
	2899	2	22.01	4.52	0	0	1	1.06162	-35.27107	110	5	1.12	0.95;
	2900	1	19.91	8.04	0	0	1	1.08268	-33.50418	110	5	1.12	0.95;
	2901	1	23.05	5.02	0	0	1	1.08324	-32.15107	110	5	1.12	0.95;
	2902	1	5.24	1.51	0	0	1	1.066	-37.60426	110	5	1.12	0.95;
	2903	1	0	0	0	0	1	1.11993	-29.09325	110	5	1.12	0.95;
	2904	1	18.02	5.83	0	0	1	1.1058	-30.62851	110	5	1.12	0.95;
	2905	1	12.57	3.01	0	0	1	1.08757	-32.52341	110	5	1.12	0.95;
	2906	1	4.19	1.11	0	0	1	1.08883	-32.25141	110	5	1.12	0.95;
	2907	1	24.63	6.03	0	0	1	1.11488	-29.52187	110	5	1.12	0.95;
	2908	2	13.41	5.53	0	0	1	1.09627	-33.02376	110	5	1.12	0.95;
	2909	1	13.83	4.42	0	0	1	1.0799	-31.87436	110	5	1.12	0.95;
	2910	1	5.66	1.71	0	0	1	1.11211	-29.8989	110	5	1.12	0.95;
	2911	1	15.72	3.01	0	0	1	1.0786	-24.27537	110	5	1.12	0.95;
	2912	1	10.48	2.01	0	0	1	1.07858	-24.26534	110	5	1.12	0.95;
	2913	1	12.57	4.32	0	0	1	1.11633	-29.1923	110	5	1.12	0.95;
	2914	1	3.14	0.5	0	0	1	1.05001	-38.45373	110	5	1.12	0.95;
	2915	1	0	0	0	0	1	1.05006	-38.44431	110	5	1.12	0.95;
	2916	1	13.62	0.5	0	0	1	1.05238	-38.14046	110	5	1.12	0.95;
	2917	1	12.57	0.5	0	0	1	1.07568	-36.00113	110	5	1.12	0.95;
	2918	1	0	0	0	0	1	1.083	-32.55004	110	5	1.12	0.95;
	2919	1	8.59	2.01	0	0	1	1.08295	-32.60953	110	5	1.12	0.95;
	2920	2	23.58	5.53	0	0	1	1.08325	-32.16873	110	5	1.12	0.95;
	2921	1	4.72	0.5	0	0	1	1.07901	-32.18166	110	5	1.12	0.95;
	2922	1	3.67	0.5	0	0	1	1.04133	-39.2604	110	5	1.12	0.95;
	2923	1	11	2.01	0	0	1	1.04592	-37.54146	110	5	1.12	0.95;
	2924	2	7.86	2.01	0	0	1	1.05437	-36.99783	110	5	1.12	0.95;
	2925	1	9.43	2.01	0	0	1	1.08036	-32.05252	110	5	1.12	0.95;
	2926	1	8.91	1	0	0	1	1.07887	-32.53903	110	5	1.12	0.95;
	2927	1	0	0	0	0	1	1.08691	-31.46303	110	5	1.12	0.95;
	2928	1	0	0	0	0	1	1.08689	-31.49375	110	5	1.12	0.95;
	2929	2	12.57	1	0	0	1	1.08185	-32.49163	110	5	1.12	0.95;
	2930	1	12.57	1	0	0	1	1.0819	-32.49052	110	5	1.12	0.95;
	2931	1	7.23	2.71	0	0	1	1.10856	-30.18464	110	5	1.12	0.95;
	2932	1	24.1	2.41	0	0	1	1.09354	-34.17139	110	5	1.12	0.95;
	2933	1	0.63	0.1	0	0	1	1.09362	-33.87317	110	5	1.12	0.95;
	2934	2	32.49	3.52	0	0	1	1.05752	-36.69531	110	5	1.12	0.95;
	2935	1	0	0	0	0	1	1.05752	-36.69531	110	5	1.12	0.95;
	2936	1	11.53	1	0	0	1	1.08198	-32.40843	110	5	1.12	0.95;
	2937	1	0	0	0	0	1	1.0928	-33.79486	110	5	1.12	0.95;
	2938	2	27.77	5.53	0	0	1	1.07247	-34.37132	110	5	1.12	0.95;
	2939	1	5.24	1.51	0	0	1	1.0838	-33.33881	110	5	1.12	0.95;
	2940	1	6.81	2.31	0	0	1	1.10031	-20.76082	110	5	1.12	0.95;
	2941	1	7.33	2.01	0	0	1	1.08294	-34.01964	110	5	1.12	0.95;
	2942	1	9.43	2.01	0	0	1	1.08728	-32.46034	110	5	1.12	0.95;
	2943	2	105.85	35.27	0	0	1	1.11316	-30.84389	110	5	1.12	0.95;
	2944	1	4.4	1.91	0	0	1	1.11147	-29.89639	110	5	1.12	0.95;
	2945	1	6.29	1.61	0	0	1	1.10954	-30.62732	110	5	1.12	0.95;
	2946	1	28.29	6.03	0	0	1	1.0842	-34.24359	110	5	1.12	0.95;
	2947	2	12.36	3.92	0	0	1	1.11047	-30.42479	110	5	1.12	0.95;
	2948	1	6.81	1.21	0	0	1	1.11067	-30.40447	110	5	1.12	0.95;
	2949	1	7.33	2.01	0	0	1	1.08422	-33.31006	110	5	1.12	0.95;
	2950	1	8.59	2.31	0	0	1	1.10492	-30.58222	110	5	1.12	0.95;
	2951	1	12.68	3.22	0	0	1	1.10731	-30.6347	110	5	1.12	0.95;
	2952	1	20.85	5.53	0	0	1	1.10717	-30.60613	110	5	1.12	0.95;
	2953	1	4.61	1.11	0	0	1	1.10735	-30.59374	110	5	1.12	0.95;
	2954	2	13.52	3.32	0	0	1	1.10075	-31.01908	110	5	1.12	0.95;
	2955	1	15.4	3.22	0	0	1	1.09814	-30.9298	110	5	1.12	0.95;
	2956	1	13.62	3.01	0	0	1	1.08047	-24.72937	110	5	1.12	0.95;
	2957	1	12.99	3.32	0	0	1	1.10671	-30.66736	110	5	1.12	0.95;
	2958	1	12.57	3.82	0	0	1	1.06172	-33.6523	110	5	1.12	0.95;
	2959	2	0.01	0	0	0	1	1.09009	-30.24437	110	5	1.12	0.95;
	2960	2	3.56	1.51	0	0	1	1.10207	-30.98022	110	5	1.12	0.95;
	2961	1	12.57	2.01	0	0	1	1.08478	-31.63505	110	5	1.12	0.95;
	2962	1	4.19	0.5	0	0	1	1.07688	-32.61529	110	5	1.12	0.95;
	2963	1	15.19	4.62	0	0	1	1.10209	-30.53582	110	5	1.12	0.95;
	2964	2	22.01	6.03	0	0	1	1.08448	-30.98533	110	5	1.12	0.95;
	2965	1	26.2	4.02	0	0	1	1.08121	-31.6291	110	5	1.12	0.95;
	2966	2	9.43	0.4	0	0	1	1.07773	-31.56622	110	5	1.12	0.95;
	2967	1	26.2	4.52	0	0	1	1.08506	-33.83914	110	5	1.12	0.95;
	2968	2	6.6	3.82	0	0	1	1.11129	-28.81926	110	5	1.12	0.95;
	2969	1	13.41	7.44	0	0	1	1.11117	-28.82201	110	5	1.12	0.95;
	2970	1	12.57	4.02	0	0	1	1.09763	-31.39722	110	5	1.12	0.95;
	2971	1	23.05	6.33	0	0	1	1.10353	-28.98654	110	5	1.12	0.95;
	2972	2	15.38	3.97	0	0	1	1.10733	-28.61667	110	5	1.12	0.95;
	2973	2	0.5	0.15	0	0	1	1.10722	-28.62496	110	5	1.12	0.95;
	2974	1	16.03	4.02	0	0	1	1.10472	-29.02888	110	5	1.12	0.95;
	2975	1	7.86	0.7	0	0	1	1.09395	-34.11179	110	5	1.12	0.95;
	2976	1	0	0	0	0	1	1.09255	-34.12888	110	5	1.12	0.95;
	2977	1	0	0	0	0	1	1.08577	-31.51847	110	5	1.12	0.95;
	2978	1	0	0	0	0	1	1.09398	-34.1094	110	5	1.12	0.95;
	2979	1	22.01	5.02	0	0	1	1.1193	-28.9646	110	5	1.12	0.95;
	2980	1	22.01	5.02	0	0	1	1.11929	-28.97624	110	5	1.12	0.95;
	2981	1	2.1	0.8	0	0	1	1.11967	-28.9127	110	5	1.12	0.95;
	2982	1	13.62	2.51	0	0	1	1.10054	-33.15754	110	5	1.12	0.95;
	2983	1	15.72	3.01	0	0	1	1.09969	-33.46311	110	5	1.12	0.95;
	2984	2	40.87	11.86	0	0	1	1.10888	-28.92563	110	5	1.12	0.95;
	2985	1	35.21	9.65	0	0	1	1.10878	-28.93883	110	5	1.12	0.95;
	2986	1	7.86	0.5	0	0	1	1.02658	-40.73968	110	5	1.12	0.95;
	2987	1	29.34	18.09	0	0	1	1.05913	-35.38178	110	5	1.12	0.95;
	2988	1	17.29	3.22	0	0	1	1.06531	-24.72224	110	5	1.12	0.95;
	2989	1	0	0	0	0	1	1.08438	-30.13716	110	5	1.12	0.95;
	2990	1	0	0	0	0	1	1.08434	-30.12124	110	5	1.12	0.95;
	2991	2	14.67	4.52	0	0	1	1.09582	-31.54591	110	5	1.12	0.95;
	2992	1	0	0	0	0	1	1.09587	-31.53525	110	5	1.12	0.95;
	2993	1	4.09	1.41	0	0	1	1.10603	-28.77086	110	5	1.12	0.95;
	2994	2	0.3	0.1	0	0	1	1.09505	-32.81804	110	5	1.12	0.95;
	2995	2	0.3	0.1	0	0	1	1.09508	-32.83811	110	5	1.12	0.95;
	2996	1	2.1	0.5	0	0	1	1.09188	-33.35973	110	5	1.12	0.95;
	2997	1	16	6	0	0	0	1.07863	-5.16473	110	0	1.12	0.95;
	2998	1	0	0	0	0	0	1.07871	-5.15829	110	0	1.12	0.95;
	2999	1	33	12	0	0	0	1.07742	-5.25081	110	0	1.12	0.95;
	3000	1	16	6	0	0	0	1.07743	-5.24895	110	0	1.12	0.95;
	3001	1	50	14	0	0	0	1.03081	-18.34894	110	0	1.12	0.95;
	3002	1	50	14	0	0	0	1.02923	-18.59734	110	0	1.12	0.95;
	3003	1	25	10	0	0	0	1.05875	-6.78523	110	0	1.12	0.95;
	3004	1	65	26	0	0	0	1.0496	-7.42809	110	0	1.12	0.95;
	3005	2	0.01	0.01	0	0	1	1.07144	-34.36389	110	5	1.12	0.95;
	3006	2	355.35	0	0	0	0	1.04526	-9.54214	400	0	1.05	0.95;
	3007	2	246.29	0	0	0	0	1.08868	-6.31139	220	0	1.11	0.95;
	3008	2	603.75	0	0	0	0	1.03223	-8.95252	400	0	1.05	0.95;
	3010	2	0	0	0	0	0	1.05	-7.52711	400	0	1.05	0.95;
	3011	2	0	0	0	0	0	1.11	-32.39185	220	0	1.11	0.95;
	3012	2	589.51	0	0	0	0	1.03018	-16.39901	400	0	1.05	0.95;
	3013	1	2.01	1	0	0	1	1.107	-30.66734	110	5	1.12	0.95;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	24	110	85.19	140	-49	1.08673	235.3	1	221	110	0	0	0	0	0	0	0	0	0	0	0;
	25	135	-22	124	-22	1.08668	235.3	1	200	135	0	0	0	0	0	0	0	0	0	0	0;
	37	370	74.67	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	37	370	74.67	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	370	16.41	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	370	16.41	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	39	370	97	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	69.26	190	-19	1.04749	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	69.26	190	-19	1.04749	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	69.26	190	-19	1.04749	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-18.99	190	-19	1.04746	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-18.99	190	-19	1.04746	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-18.99	190	-19	1.04746	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	57	111.38	41.84	152	-33	1.10173	235	1	215	110	0	0	0	0	0	0	0	0	0	0	0;
	57	126.35	41.84	152	-33	1.10173	235	1	220	125	0	0	0	0	0	0	0	0	0	0	0;
	58	164.41	85.9	149	-33	1.10171	235	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	58	0	0	149	-33	1	235	0	225	120	0	0	0	0	0	0	0	0	0	0	0;
	58	153.88	85.9	149	-33	1.10171	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	59	110	29.72	149	-33	1.10172	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	60	535	177.45	363	-47	1.05	588	1	535	255	0	0	0	0	0	0	0	0	0	0	0;
	61	560	36.63	348	-100	1.05	588	1	560	250	0	0	0	0	0	0	0	0	0	0	0;
	70	129	-6	105	-11	1.10839	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	129	55.33	105	-11	1.10837	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	0	0	99	-10	1	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	72	0	0	105	-11	1	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	72	129	-11	105	-11	1.04326	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	73	129	-10	99	-10	1.04328	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	73	129	-11	105	-11	1.04328	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	74	112	60	60	0	1.09864	120	1	112	0	0	0	0	0	0	0	0	0	0	0	0;
	94	220	95.65	131	-6	1.10879	270.6	1	220	125	0	0	0	0	0	0	0	0	0	0	0;
	94	225	95.65	131	-6	1.10879	270.6	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	95	225	72.13	131	-6	1.11	270.6	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	95	225	72.13	131	-6	1.11	270.6	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	95	225	72.13	131	-6	1.11	270.6	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	98	383	36.08	213	-31	1.05	426	1	383	220	0	0	0	0	0	0	0	0	0	0	0;
	98	380	21.68	119	-31	1.05	435.3	1	380	220	0	0	0	0	0	0	0	0	0	0	0;
	115	12	0	0	0	1.10086	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	115	6	0	0	0	1.10086	6	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	121	0	0	120	-10	1	270.6	0	225	120	0	0	0	0	0	0	0	0	0	0	0;
	122	225	61.33	120	-10	1.11	270.6	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	123	120	66.3	73	-1	1.10998	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	124	120	16.34	73	-1	1.11	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	134	0	0	80	0	1	150	0	120	70	0	0	0	0	0	0	0	0	0	0	0;
	135	120	80	80	0	1.10756	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	136	80	31	31	0	1.09273	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	144	215	44.29	135	-35	1.10995	270.6	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	145	215	41.96	135	-35	1.11	270.6	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	145	225	43.99	140	-35	1.11	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	146	225	-36	140	-36	1.03968	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	146	220	-36	137	-36	1.03968	270.6	1	220	135	0	0	0	0	0	0	0	0	0	0	0;
	152	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	152	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	153	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	153	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	154	120	85	85	-15	1.0886	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	155	120	85	85	-15	1.0886	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	155	0	0	85	-15	1	150	0	120	94	0	0	0	0	0	0	0	0	0	0	0;
	169	0	0	25	0	1	51.4	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	90	-15	1	150	0	120	80	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	25	0	1	51.4	0	50	45	0	0	0	0	0	0	0	0	0	0	0;
	172	100	119	119	-31	1.10415	252.4	1	232	100	0	0	0	0	0	0	0	0	0	0	0;
	172	0	0	111	-21	1	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0;
	173	0	0	111	-21	1	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0;
	173	0	0	102	-15	1	252.4	0	222	90	0	0	0	0	0	0	0	0	0	0	0;
	174	90	-15	102	-15	1.03614	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	175	90	62.7	102	-15	1.03615	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	175	100	56.73	93	-10	1.03615	252.4	1	232	100	0	0	0	0	0	0	0	0	0	0	0;
	180	261	99	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	180	261	99	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	181	206	103	103	-17	1.11	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	181	261	127	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	182	235	10.81	145	-38	1.11	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	182	235	10.81	145	-38	1.11	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	183	206	103	103	-17	1.0494	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	183	206	103	103	-17	1.0494	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	191	200	104	104	-23	1.08298	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	192	200	104	104	-23	1.08268	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	192	0	0	104	-23	1	233.2	0	200	145	0	0	0	0	0	0	0	0	0	0	0;
	192	0	0	104	-23	1	233.2	0	200	145	0	0	0	0	0	0	0	0	0	0	0;
	193	464	294	294	-259	1.03244	464	1	464	208	0	0	0	0	0	0	0	0	0	0	0;
	208	188	100	100	0	1.06751	218.3	1	188	76	0	0	0	0	0	0	0	0	0	0	0;
	240	179	-62	105	-62	1.02222	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	240	179	-62	105	-62	1.02222	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	240	0	0	160	-100	1	209	0	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	241	179	-19.63	160	-100	1.02222	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	244	220	10.07	100	0	1.11	177.1	1	220	112.5	0	0	0	0	0	0	0	0	0	0	0;
	254	55	20	20	0	1.10528	78.8	1	55	23	0	0	0	0	0	0	0	0	0	0	0;
	254	50	20	20	0	1.10528	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	254	50	20	20	0	1.10528	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	254	23	20	20	0	1.10528	27.6	1	23	7	0	0	0	0	0	0	0	0	0	0	0;
	267	2.1	1	1	0	1.05826	0.7	1	2.1	0.45	0	0	0	0	0	0	0	0	0	0	0;
	268	2.1	1	1	0	1.07506	0.7	1	2.1	0.45	0	0	0	0	0	0	0	0	0	0	0;
	278	0	0	5	0	1	10.3	0	7.15	5.85	0	0	0	0	0	0	0	0	0	0	0;
	279	0	0	5	0	1	10.3	0	7.15	5.85	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.75	3.75	0	1.09445	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.75	3.75	0	1.09445	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.75	3.75	0	1.09445	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.75	3.75	0	1.09445	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	310	370	190	190	-19	1	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	316	0	0	2	0	1	4	0	5.73	1	0	0	0	0	0	0	0	0	0	0	0;
	316	0	0	2	0	1	4	0	5.73	1	0	0	0	0	0	0	0	0	0	0	0;
	376	6.6	5	5	0	1.10193	8.4	1	6.6	5.4	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11132	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11132	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11132	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	383	27	7	7	0	1.11054	31.3	1	27	11	0	0	0	0	0	0	0	0	0	0	0;
	383	30	7	7	0	1.11054	39	1	30	11	0	0	0	0	0	0	0	0	0	0	0;
	383	30	6	6	0	1.11054	40.6	1	30	9	0	0	0	0	0	0	0	0	0	0	0;
	384	55	15	15	0	1.11743	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	384	55	15	15	0	1.11743	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	385	40	6.11	15	0	1.11752	48.5	1	40	10	0	0	0	0	0	0	0	0	0	0	0;
	385	55	6.11	15	0	1.11752	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	387	50	20	20	0	1.1113	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	387	100	20	20	0	1.1113	147	1	100	55	0	0	0	0	0	0	0	0	0	0	0;
	388	60	40	40	0	1.11386	68.8	1	60	25	0	0	0	0	0	0	0	0	0	0	0;
	399	2.75	3	3	0	1.10799	3.8	1	2.75	2	0	0	0	0	0	0	0	0	0	0	0;
	433	1.65	1	1	0	1.09946	1.9	1	1.65	1.35	0	0	0	0	0	0	0	0	0	0	0;
	455	51.5	8.22	57	-22	1.11245	68.8	1	51.5	15	0	0	0	0	0	0	0	0	0	0	0;
	456	55	8.37	57	-22	1.11895	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	457	55	14.8	57	-22	1.11707	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	457	77	17.33	71	-28	1.11707	87.5	1	77	3	0	0	0	0	0	0	0	0	0	0	0;
	458	55	8.56	57	-22	1.11493	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	458	55	8.56	57	-22	1.11493	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	478	120	73.47	137	-47	1.11867	235.3	1	226	120	0	0	0	0	0	0	0	0	0	0	0;
	478	12	6.16	12	0	1.11867	48.5	1	25	12	0	0	0	0	0	0	0	0	0	0	0;
	479	10	12	12	0	1.10485	48.5	1	17	10	0	0	0	0	0	0	0	0	0	0	0;
	482	4.4	2	2	0	1.10618	5.6	1	4.4	3.6	0	0	0	0	0	0	0	0	0	0	0;
	500	0.34	0.2	0.2	0	1.09306	0.4	1	0.34	0	0	0	0	0	0	0	0	0	0	0	0;
	522	6.6	4	4	0	1.10119	8.4	1	6.6	3	0	0	0	0	0	0	0	0	0	0	0;
	527	3.41	3	3	0	1.11076	4.6	1	3.41	2.79	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.59	4.7	3.8	1.10157	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.59	4.7	3.8	1.10157	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.59	4.7	3.8	1.10157	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	543	2.97	2	2	0	1.06077	4.1	1	2.97	2.43	0	0	0	0	0	0	0	0	0	0	0;
	572	0	0	2	0	1	4.6	0	3.52	2.88	0	0	0	0	0	0	0	0	0	0	0;
	597	1.7	0.7	0.7	0	1.08723	1.9	1	1.7	1	0	0	0	0	0	0	0	0	0	0	0;
	597	0	0	0.7	0	1	1.9	0	1.7	1	0	0	0	0	0	0	0	0	0	0	0;
	603	4.4	3	3	0	1.11189	5.6	1	4.4	3	0	0	0	0	0	0	0	0	0	0	0;
	670	52	16.51	35	2	1.11956	62.5	1	52	37	0	0	0	0	0	0	0	0	0	0	0;
	670	30	11.7	23	2	1.11956	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	670	105	34.77	85	6	1.11956	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	670	105	34.77	85	6	1.11956	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	671	30	11.81	23	2	1.12	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	30	11.81	23	2	1.12	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	30	12.67	25	2	1.12	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	125	35.77	85	6	1.12	150	1	125	68	0	0	0	0	0	0	0	0	0	0	0;
	671	105	35.77	85	6	1.12	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	692	1.54	0.7	0.7	0	1.09872	1.9	1	1.54	1.26	0	0	0	0	0	0	0	0	0	0	0;
	694	1.4	1	1	0	1.08197	3.8	1	1.4	0	0	0	0	0	0	0	0	0	0	0	0;
	700	35	18	18	2	1.11463	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	700	20	30	30	2	1.11463	37.5	1	20	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.11138	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.11138	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.11138	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	97	65	65	6	1.11138	121.3	1	97	30	0	0	0	0	0	0	0	0	0	0	0;
	702	35	18	18	2	1.11468	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	702	30	18	18	2	1.11468	37.5	1	30	9	0	0	0	0	0	0	0	0	0	0	0;
	702	28	14	14	2	1.11468	31.5	1	28	9	0	0	0	0	0	0	0	0	0	0	0;
	735	8	4	4	0	1.0952	5.3	1	8	1	0	0	0	0	0	0	0	0	0	0	0;
	735	2	2	2	0	1.0952	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	752	4.4	0.2	4.5	0.2	1.09731	5.8	1	4.4	3.6	0	0	0	0	0	0	0	0	0	0	0;
	766	2.7	0	0	0	1.09745	5.8	1	2.7	0	0	0	0	0	0	0	0	0	0	0	0;
	775	4.9	0	0	0	1.09432	4	1	4.9	0	0	0	0	0	0	0	0	0	0	0	0;
	798	93	14.74	30	0	1.11549	65	1	93	0	0	0	0	0	0	0	0	0	0	0	0;
	798	35.9	14.74	30	0	1.11549	65	1	35.9	0	0	0	0	0	0	0	0	0	0	0	0;
	801	0	0	0	0	1	12.4	0	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	808	6	0	0	0	1.09831	4.7	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	809	6	0	0	0	1.09858	5.8	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	846	130	37.67	149	-33	1.12	235	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	847	180.38	76.49	149	-33	1.12	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	854	2.5	0	0	0	1.07804	3	1	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	860	12	0	0	0	1.09667	12.4	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	870	170	30	30	0	1.11642	167.6	1	170	66	0	0	0	0	0	0	0	0	0	0	0;
	870	61	30	30	0	1.11642	71.6	1	61	34	0	0	0	0	0	0	0	0	0	0	0;
	876	21	0	0	0	1.10874	8.3	1	21	0	0	0	0	0	0	0	0	0	0	0	0;
	890	7	0	0	0	1.1085	5.6	1	7	0	0	0	0	0	0	0	0	0	0	0	0;
	893	0	0	0	0	1	3	0	10	0	0	0	0	0	0	0	0	0	0	0	0;
	908	30.4	0	0	0	1.10489	3	1	30.4	0	0	0	0	0	0	0	0	0	0	0	0;
	913	2	0	0	0	1.06654	0	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	918	0	0	0	0	1	1	0	1.9	0	0	0	0	0	0	0	0	0	0	0	0;
	929	0	0	0	0	1	2.1	0	2.02	1.34	0	0	0	0	0	0	0	0	0	0	0;
	934	129	28.69	105	-11	1.11698	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	936	36	15.64	30	0	1.09445	36.8	1	36	0	0	0	0	0	0	0	0	0	0	0	0;
	939	0	0	0	0	1	2.8	0	2.68	1.78	0	0	0	0	0	0	0	0	0	0	0;
	959	101	25.6	30	0	1.10735	100.8	1	101	49	0	0	0	0	0	0	0	0	0	0	0;
	965	0	0	0	0	1	1.7	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	980	12	19.57	30	0	1.09905	9.5	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	982	0	0	0	0	1	1.6	0	1.6	0.91	0	0	0	0	0	0	0	0	0	0	0;
	984	6	0	0	0	1.1072	5.9	1	6	1	0	0	0	0	0	0	0	0	0	0	0;
	989	8.3	0	0	0	1.09313	10.9	1	8.3	0	0	0	0	0	0	0	0	0	0	0	0;
	993	68	9.63	23	0	1.10184	52	1	68	5	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	23	0	1	52	0	68	5	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	11	0	1	24.5	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	10	0	1	24.5	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	1008	0	0	10	0	1	69	0	50	0	0	0	0	0	0	0	0	0	0	0	0;
	1008	92	40.93	74	-15	1.11496	57.6	1	125	92	0	0	0	0	0	0	0	0	0	0	0;
	1009	84	54.39	74	-15	1.10191	57.6	1	125	84	0	0	0	0	0	0	0	0	0	0	0;
	1009	0	0	10	0	1	40	0	30	0	0	0	0	0	0	0	0	0	0	0	0;
	1021	2.5	0	0	0	1.10219	3.3	1	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1049	3.35	0	0	0	1.08347	3.8	1	3.35	2.23	0	0	0	0	0	0	0	0	0	0	0;
	1056	0	0	0	0	1	25	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	25	0	0	0	1.08851	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	31	0	0	0	1.08851	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	31	0	0	0	1.08851	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1087	78	30.72	41.2	0	1.11915	92.9	1	78	10.5	0	0	0	0	0	0	0	0	0	0	0;
	1111	0	0	45	-10	1	63	0	48	40	0	0	0	0	0	0	0	0	0	0	0;
	1111	55	14.96	45	-10	1.11135	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1112	55	35.77	45	-10	1.11269	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1188	113	51.03	110	-40	1.11896	149	1	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1189	113	66.16	110	-40	1.11854	149	1	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1193	16.8	0	0	0	1.11298	16.8	1	16.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1214	386	150.73	216	32	1.12	426	1	386	220	0	0	0	0	0	0	0	0	0	0	0;
	1215	383	134.31	187	-31	1.12	426	1	383	220	0	0	0	0	0	0	0	0	0	0	0;
	1219	0	0	0	0	1	6	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	1220	135	30.96	110	-40	1.12	169.4	1	135	34.5	0	0	0	0	0	0	0	0	0	0	0;
	1226	0	0	0	0	1	12.8	0	12.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1226	0	0	0	0	1	12.5	0	12.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1227	20	0	0	0	1.10904	20	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1227	20	0	0	0	1.10904	20	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1228	0	0	0	0	1	19	0	19	0	0	0	0	0	0	0	0	0	0	0	0;
	1237	24	18	18	9	1.10503	32	1	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1238	0	0	18	9	1	32	0	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1239	29	14	14	10.5	1.10493	32.2	1	29	10	0	0	0	0	0	0	0	0	0	0	0;
	1330	50	37.5	37.5	16.8	1.11507	62.5	1	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1330	0	0	37.5	16.8	1	62.5	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1330	0	0	37.5	16.8	1	62.5	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1331	50	37.5	37.5	16.8	1.10535	62.5	1	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1354	0	0	0	0	1	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	0	0	0	0	1	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	25	0	0	0	1.0866	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	25	0	0	0	1.0866	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1371	25	0	0	0	1.11621	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1372	25	0	0	0	1.11608	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1373	25	0	0	0	1.11665	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1373	0	0	0	0	1	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	1400	70	18.43	52.5	0	1.11997	87.5	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1401	0	0	42	16.8	1	62.5	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	1401	70	52.5	52.5	0	1.11405	87.5	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1408	50	0	0	0	1.10592	50	1	50	10	0	0	0	0	0	0	0	0	0	0	0;
	1469	0	0	0	0	1	24	0	24	5	0	0	0	0	0	0	0	0	0	0	0;
	1469	16.5	0	0	0	1.10917	16.5	1	16.5	4	0	0	0	0	0	0	0	0	0	0	0;
	1470	14.6	0	0	0	1.10912	14.6	1	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1470	0	0	0	0	1	14.6	0	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1470	0	0	0	0	1	14.6	0	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1471	5.5	0	0	0	1.10014	5.5	1	5.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1471	0	0	0	0	1	5.5	0	5.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1505	0	0	0	0	1	7.5	0	7.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1505	0	0	0	0	1	8	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	1511	55	25.3	41	-6.5	1.11226	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	1512	230	86.53	113	-5	1.12	270.6	1	230	120	0	0	0	0	0	0	0	0	0	0	0;
	1513	225	120	120	-10	1.11825	270.6	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	1570	0	0	0	0	1	18	0	18	0	0	0	0	0	0	0	0	0	0	0	0;
	1570	32	0	0	0	1.09368	32	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	1570	25	0	0	0	1.09368	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1578	120	73	73	-1	1.11095	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1579	120	32.04	73	-1	1.1186	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1580	120	20.31	73	-1	1.11987	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0;
	1580	0	0	73	-1	1	150	0	110	79	0	0	0	0	0	0	0	0	0	0	0;
	1590	125	57.78	83	-5	1.12	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1590	125	57.78	83	-5	1.12	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1601	119	49.56	80	-25	1.12	150	1	119	80	0	0	0	0	0	0	0	0	0	0	0;
	1602	117	27.29	80	-25	1.12	150	1	117	80	0	0	0	0	0	0	0	0	0	0	0;
	1603	110	54.35	80	-25	1.11894	150	1	110	65	0	0	0	0	0	0	0	0	0	0	0;
	1603	100	54.35	80	-25	1.11894	150	1	100	65	0	0	0	0	0	0	0	0	0	0	0;
	1644	0	0	41.2	-13.7	1	68.8	0	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1644	0	0	33.5	12	1	20	0	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1644	55	30.98	41.2	-13.7	1.0997	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1659	12	0	0	0	1.09764	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1659	12	0	0	0	1.09764	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1660	4	0	0	0	1.09483	6.7	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1660	4	0	0	0	1.09483	6.7	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1661	15	0	0	0	1.10648	15	1	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1662	22	0	0	0	1.1077	22	1	22	0	0	0	0	0	0	0	0	0	0	0	0;
	1666	225	45.23	131	-6	1.12	270.6	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	1688	46	34.49	35	-6	1.1012	53	1	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1689	0	0	35	-6	1	53	0	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	6.78	9.3	1.9	1.10208	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	6.78	9.3	1.9	1.10208	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	6.78	9.3	1.9	1.10208	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	3.8	0	0	0	1.10208	3.8	1	3.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1872	4.2	0	0	0	1.10208	4.2	1	4.2	0	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	6.8	9.3	2	1.10208	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1900	85.71	31.58	80	0	1.11999	150	1	123	70	0	0	0	0	0	0	0	0	0	0	0;
	1900	86.39	31.29	79	0	1.11999	150	1	128	70	0	0	0	0	0	0	0	0	0	0	0;
	1901	161	53.04	114	-27	1.12	190.9	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1902	81.36	54.58	114	-27	1.11999	190.9	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1910	0	0	37	0	1	62.5	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	1910	84.16	15	15	0	1.11404	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1911	0	0	42	16.8	1	62.5	0	45	35	0	0	0	0	0	0	0	0	0	0	0;
	1911	0	0	42	16.8	1	62.5	0	45	35	0	0	0	0	0	0	0	0	0	0	0;
	1911	110	15	15	0	1.10311	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1911	110	31	31	0	1.10311	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	2018	40	26	26	13	1.10393	50	1	40	5	0	0	0	0	0	0	0	0	0	0	0;
	2062	225	59.48	140	-35	1.12	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2063	225	71.27	140	-35	1.12	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2064	225	140	140	-35	1.11839	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2094	0	0	26	13	1	43.8	0	35	18	0	0	0	0	0	0	0	0	0	0	0;
	2094	8	8.3	8.3	1.5	1.10243	13.8	1	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2094	25	12	12	5.8	1.10243	31.3	1	25	18	0	0	0	0	0	0	0	0	0	0	0;
	2095	0	0	26	13	1	43.8	0	30	18	0	0	0	0	0	0	0	0	0	0	0;
	2130	32	0	0	0	1.09061	32	1	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2131	32	0	0	0	1.09056	32	1	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2150	10.5	0	0	0	1.07505	10.5	1	10.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2150	0	0	0	0	1	10.5	0	10.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2152	120	57.25	85	-15	1.12	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	2153	120	34.87	85	-15	1.11995	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	2168	1.78	0	0	0	1.10185	4	1	1.78	0.5	0	0	0	0	0	0	0	0	0	0	0;
	2183	4.9	0	0	0	1.08195	1.5	1	4.9	0.17	0	0	0	0	0	0	0	0	0	0	0;
	2187	0.26	0	0	0	1.06445	1.5	1	0.26	0.09	0	0	0	0	0	0	0	0	0	0	0;
	2189	50	30	30	0	1.08615	50	1	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2190	50	30	30	0	1.08635	50	1	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2216	90	101.02	117	-19	1.11996	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	2222	0	0	8	0	1	27.3	0	28	-5	0	0	0	0	0	0	0	0	0	0	0;
	2222	29	8	8	0	1.06405	28.5	1	29	-5	0	0	0	0	0	0	0	0	0	0	0;
	2222	28	8	8	0	1.06405	27.3	1	28	-5	0	0	0	0	0	0	0	0	0	0	0;
	2226	55	49	49	-7	1.08735	57	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	2226	100	91	91	-17	1.08735	128.1	1	100	50	0	0	0	0	0	0	0	0	0	0	0;
	2227	106	89	89	-16	1.0868	150.4	1	106	70	0	0	0	0	0	0	0	0	0	0	0;
	2232	2.19	0	0	0	1.02115	1.5	1	2.19	0.28	0	0	0	0	0	0	0	0	0	0	0;
	2233	0	0	0	0	1	1.5	0	1.32	0.28	0	0	0	0	0	0	0	0	0	0	0;
	2236	0	0	0	0	1	3.3	0	2.86	2.34	0	0	0	0	0	0	0	0	0	0	0;
	2238	6	0	0	0	1.05587	5.3	1	6	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2239	54.5	15	15	0	1.07723	56.5	1	54.5	10	0	0	0	0	0	0	0	0	0	0	0;
	2239	6	2	2	0	1.07723	6.3	1	6	3	0	0	0	0	0	0	0	0	0	0	0;
	2240	5	2	2	0	1.07722	5.4	1	5	0.7	0	0	0	0	0	0	0	0	0	0	0;
	2240	28.5	10	10	0	1.07722	30.2	1	28.5	20.5	0	0	0	0	0	0	0	0	0	0	0;
	2253	4.4	0	0	0	1.02764	5.3	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2261	30	0	0	0	1.05417	35	1	30	5	0	0	0	0	0	0	0	0	0	0	0;
	2265	11.5	0	0	0	1.06234	15.3	1	11.5	2	0	0	0	0	0	0	0	0	0	0	0;
	2267	0	0	90	-15	1	150	0	120	80	0	0	0	0	0	0	0	0	0	0	0;
	2273	6.5	0	0	0	1.0711	3.8	1	6.5	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2282	0	0	0	0	1	4.5	0	3.96	3.24	0	0	0	0	0	0	0	0	0	0	0;
	2284	2.65	0	0	0	1.07777	3	1	2.65	0.55	0	0	0	0	0	0	0	0	0	0	0;
	2286	2.65	0	0	0	1.05762	3	1	2.65	1.26	0	0	0	0	0	0	0	0	0	0	0;
	2290	0	0	0	0	1	3	0	2.55	0.45	0	0	0	0	0	0	0	0	0	0	0;
	2291	0	0	1	0	1	3.2	0	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2291	4	2	2	0	1.05551	4.5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2293	0	0	0	0	1	0.6	0	0.55	0.45	0	0	0	0	0	0	0	0	0	0	0;
	2295	4.4	0	0	0	1.05398	5.3	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2299	1.32	0	0	0	1.06038	1.5	1	1.32	0.18	0	0	0	0	0	0	0	0	0	0	0;
	2306	9.9	0	0	0	1.04949	11.3	1	9.9	2	0	0	0	0	0	0	0	0	0	0	0;
	2316	0	0	0	0	1	1.5	0	1.32	0.55	0	0	0	0	0	0	0	0	0	0	0;
	2319	50	25	25	0	1.09378	51.4	1	50	40	0	0	0	0	0	0	0	0	0	0	0;
	2320	0	0	25	0	1	51.4	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	2320	28	9.53	12	0	1.12	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0;
	2322	55	23.34	25	0	1.08999	56.3	1	55	35	0	0	0	0	0	0	0	0	0	0	0;
	2325	9.9	0	0	0	1.04659	11.3	1	9.9	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2350	4.4	0	0	0	1.03148	5	1	4.4	2.43	0	0	0	0	0	0	0	0	0	0	0;
	2355	4.4	0	0	0	1.03154	5	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2372	3.5	0	0	0	1.10552	4	1	3.5	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2410	1.65	0	0	0	1.05703	1.9	1	1.65	0.55	0	0	0	0	0	0	0	0	0	0	0;
	2411	0.22	0	0	0	1.08405	0.3	1	0.22	0.18	0	0	0	0	0	0	0	0	0	0	0;
	2411	1.32	0	0	0	1.08405	1.5	1	1.32	0.55	0	0	0	0	0	0	0	0	0	0	0;
	2436	1.32	0	0	0	1.07837	1.5	1	1.32	0.55	0	0	0	0	0	0	0	0	0	0	0;
	2437	0.33	0	0	0	1.06216	0.4	1	0.33	0.17	0	0	0	0	0	0	0	0	0	0	0;
	2439	6.1	0	0	0	1.03456	7.3	1	6.1	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2440	0	0	0	0	1	3.5	0	3.08	2.52	0	0	0	0	0	0	0	0	0	0	0;
	2442	4.4	0	0	0	1.07201	5	1	4.4	2	0	0	0	0	0	0	0	0	0	0	0;
	2449	200	87.63	104	-23	1.12	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	2450	200	82.23	111	-18	1.12	233.2	1	200	145	0	0	0	0	0	0	0	0	0	0	0;
	2462	2.85	0	0	0	1.06997	3.5	1	2.85	1.35	0	0	0	0	0	0	0	0	0	0	0;
	2463	0.33	0	0	0	1.08157	0.4	1	0.33	0.27	0	0	0	0	0	0	0	0	0	0	0;
	2470	20.3	0	0	0	1.0502	25	1	20.3	8	0	0	0	0	0	0	0	0	0	0	0;
	2488	67	15	15	0	1.07048	66.7	1	67	40	0	0	0	0	0	0	0	0	0	0	0;
	2489	65	15	15	0	1.07041	66.7	1	65	40	0	0	0	0	0	0	0	0	0	0	0;
	2497	0.33	0	0	0	1.06855	0.4	1	0.33	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2500	5.5	0	0	0	1.08724	6.3	1	5.5	1	0	0	0	0	0	0	0	0	0	0	0;
	2506	1	0	0	0	1.08059	0.4	1	1	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2508	4.4	0	0	0	1.017	5	1	4.4	2.16	0	0	0	0	0	0	0	0	0	0	0;
	2512	30.6	0	0	0	1.06009	16	1	30.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2513	30.6	0	0	0	1.06009	16	1	30.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2515	6.5	0	0	0	1.06182	7.3	1	6.5	2	0	0	0	0	0	0	0	0	0	0	0;
	2531	1.33	0	0	0	1.08129	1.5	1	1.33	0.17	0	0	0	0	0	0	0	0	0	0	0;
	2532	1.01	0	0	0	1.06773	0.4	1	1.01	0.17	0	0	0	0	0	0	0	0	0	0	0;
	2534	6.1	0	0	0	1.09155	7.3	1	6.1	2	0	0	0	0	0	0	0	0	0	0	0;
	2540	0	0	0	0	1	2.5	0	2.2	1.8	0	0	0	0	0	0	0	0	0	0	0;
	2542	5.55	0	0	0	1.02877	7.3	1	5.55	3.15	0	0	0	0	0	0	0	0	0	0	0;
	2544	4.4	0	0	0	1.03266	5	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2557	10	0	0	0	1.08253	5	1	10	2.16	0	0	0	0	0	0	0	0	0	0	0;
	2562	1.65	0	0	0	1.06822	1.9	1	1.65	1.35	0	0	0	0	0	0	0	0	0	0	0;
	2563	4.4	0	0	0	1.05916	5	1	4.4	2	0	0	0	0	0	0	0	0	0	0	0;
	2565	0	0	15	0	1	58	0	56	10	0	0	0	0	0	0	0	0	0	0	0;
	2565	0	0	6	0	1	19	0	18	3	0	0	0	0	0	0	0	0	0	0	0;
	2565	4	2	2	0	1.07183	4.5	1	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2568	0.45	0	0	0	1.01855	0.3	1	0.45	0.08	0	0	0	0	0	0	0	0	0	0	0;
	2580	94	71.13	145	-38	1.11962	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	2592	50	30	30	0	1.11489	50	1	50	32	0	0	0	0	0	0	0	0	0	0	0;
	2592	108	70	70	0	1.11489	128.1	1	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2593	108	70	70	0	1.09089	128.1	1	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2598	16.41	0	0	0	1.08188	12.4	1	16.41	2.11	0	0	0	0	0	0	0	0	0	0	0;
	2604	9.72	0	0	0	1.0849	5.3	1	9.72	2.16	0	0	0	0	0	0	0	0	0	0	0;
	2608	0.33	0	0	0	1.08089	0.4	1	0.33	0.17	0	0	0	0	0	0	0	0	0	0	0;
	2611	1.14	0	0	0	1.07881	1.5	1	1.14	0.56	0	0	0	0	0	0	0	0	0	0	0;
	2618	0	0	0	0	1	1.3	0	1.1	0.9	0	0	0	0	0	0	0	0	0	0	0;
	2677	0	0	10	0	1	15.6	0	12	3	0	0	0	0	0	0	0	0	0	0	0;
	2677	10.5	10	10	0	1.06352	14.5	1	10.5	3	0	0	0	0	0	0	0	0	0	0	0;
	2684	1.15	0	0	0	1.05509	1.5	1	1.15	0.45	0	0	0	0	0	0	0	0	0	0	0;
	2685	0	0	0	0	1	3.8	0	3.3	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2694	0.88	0	0	0	1.09935	1	1	0.88	0	0	0	0	0	0	0	0	0	0	0	0;
	2694	0	0	0	0	1	0	0	3.1	0	0	0	0	0	0	0	0	0	0	0	0;
	2697	50	5	37.5	5	1.11976	62.5	1	50	0	0	0	0	0	0	0	0	0	0	0	0;
	2697	32	5	24	5	1.11976	40	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	0	0	15	5	1	40.6	0	35	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	55	8.68	41.25	6	1.11975	68.7	1	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	55	8.69	41.7	6	1.11975	68.7	1	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2700	0.5	0	1	0	1.08252	0.5	1	0.5	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2706	3	1	1	0	1.06243	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2714	0.4	0	0	0	1.07691	3	1	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2717	55	35	35	4	1.09065	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2718	55	23.3	35	4	1.0905	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2719	0	0	5	0	1	5.7	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2726	0.7	0	0	0	1.03674	0.3	1	0.7	0.18	0	0	0	0	0	0	0	0	0	0	0;
	2729	0.3	0	0	0	1.03437	1.5	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2730	0.4	0	0	0	1.07595	0.4	1	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2731	0.9	0	0	0	1.08099	0.6	1	0.9	0	0	0	0	0	0	0	0	0	0	0	0;
	2733	0.7	0.09	0.1	0	1.02453	2.7	1	0.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2736	0	0	0	0	1	12.9	0	11	0	0	0	0	0	0	0	0	0	0	0	0;
	2736	20	0	0	0	1.0876	22	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	2739	28	10	10	0	1.06072	30.9	1	28	4	0	0	0	0	0	0	0	0	0	0	0;
	2739	0	0	5	0	1	15.5	0	13.2	2	0	0	0	0	0	0	0	0	0	0	0;
	2740	13.2	5	5	0	1.0608	15.5	1	13.2	2	0	0	0	0	0	0	0	0	0	0	0;
	2745	5.94	0	0	0	1.07957	7	1	5.94	0	0	0	0	0	0	0	0	0	0	0	0;
	2749	0	0	18.7	4	1	31.2	0	25	15	0	0	0	0	0	0	0	0	0	0	0;
	2749	55	17.02	35	6	1.10075	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2749	55	15.56	35	4	1.10075	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2750	55	20.25	39	3	1.10144	65.6	1	55	24	0	0	0	0	0	0	0	0	0	0	0;
	2750	55	18.67	35	3.5	1.10144	68.7	1	55	25	0	0	0	0	0	0	0	0	0	0	0;
	2757	0	0	0	0	1	7.9	0	6.6	5.4	0	0	0	0	0	0	0	0	0	0	0;
	2759	22	0	0	0	1.08531	22	1	22	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2764	2.75	0	0	0	1.11054	3.9	1	2.75	0	0	0	0	0	0	0	0	0	0	0	0;
	2777	4	1.52	3	1	1.11594	5	1	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	16	12	12	0	1.08445	20	1	16	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	20	15	15	0	1.08445	25	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	2789	12.4	8.47	9.3	1	1.11048	15.5	1	12.4	5	0	0	0	0	0	0	0	0	0	0	0;
	2789	0	0	9.3	1	1	15.5	0	12.4	5	0	0	0	0	0	0	0	0	0	0	0;
	2791	40.5	1	1	0	1.09262	40.5	1	40.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2795	7.7	0	0	0	1.09323	8.8	1	7.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2800	0.55	0	0	0	1.08008	4.5	1	0.55	0	0	0	0	0	0	0	0	0	0	0	0;
	2801	1.98	0	0	0	1.07968	3.2	1	1.98	0	0	0	0	0	0	0	0	0	0	0	0;
	2805	5	0	0	0	1.08054	7.4	1	5	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2806	0	0	1.27	0	1	2.5	0	1.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	25	18.78	18.78	0	1.08526	31.3	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	34.6	25.95	25.95	0	1.08526	43.3	1	34.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	0	0	18.78	0	1	31.3	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2816	0	0	0	0	1	1.9	0	1.65	0	0	0	0	0	0	0	0	0	0	0	0;
	2821	0.2	0	0	0	1.07451	2.1	1	0.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2827	0	0	0	0	1	0.4	0	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	13.2	10.5	10.5	0	1.08006	17.5	1	13.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	0	0	3.75	0	1	6.2	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	0	0	3.75	0	1	6.2	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2831	13.2	10.5	10.5	0	1.08005	17.5	1	13.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2833	0.5	0	0	0	1.08554	2.3	1	0.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2834	20	0	18.75	0	1.09634	31.3	1	20	4.5	0	0	0	0	0	0	0	0	0	0	0;
	2845	6.27	0	0	0	1.11099	8.1	1	6.27	5.13	0	0	0	0	0	0	0	0	0	0	0;
	2851	0.6	0	0	0	1.08731	0.6	1	0.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2857	0	0	0	0	1	0.3	0	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2862	1.65	0.5	0.5	0	1.08391	2	1	1.65	1.35	0	0	0	0	0	0	0	0	0	0	0;
	2869	0	0	0	0	1	3.2	0	2.75	0	0	0	0	0	0	0	0	0	0	0	0;
	2890	0.3	0	0	0	1.06872	0.2	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2893	3	0	0	0	1.09205	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2893	0	0	0	0	1	0	0	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2897	14.74	0	0	0	1.09943	16.8	1	14.74	0	0	0	0	0	0	0	0	0	0	0	0;
	2899	0.3	0.1	0.1	0	1.06162	0.2	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2908	1.32	0	0	0	1.09627	1.5	1	1.32	0	0	0	0	0	0	0	0	0	0	0	0;
	2920	1	0	0	0	1.08325	6.1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2924	0.11	0	0	0	1.05437	0.1	1	0.11	0	0	0	0	0	0	0	0	0	0	0	0;
	2929	0.11	0	0	0	1.08185	4.9	1	0.11	0.09	0	0	0	0	0	0	0	0	0	0	0;
	2934	4.07	0	0	0	1.05752	4.6	1	4.07	0	0	0	0	0	0	0	0	0	0	0	0;
	2938	0	0	0.36	0	1	0.6	0	0.49	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	0	0	8	0	1	13.7	0	11.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	0	0	6.8	0	1	11.3	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	32	21.18	24	0	1.11316	40	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	40	23.13	26	0	1.11316	48	1	40	0	0	0	0	0	0	0	0	0	0	0	0;
	2947	0	0	0	0	1	23.2	0	18.26	0	0	0	0	0	0	0	0	0	0	0	0;
	2954	0	0	1	0	1	5.5	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	2959	50	0	1	0	1.09009	50	1	50	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2960	0	0	0	0	1	4.2	0	3.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2964	8.8	0	0	0	1.08448	10.1	1	8.8	0	0	0	0	0	0	0	0	0	0	0	0;
	2966	0.11	0	0	0	1.07773	1.5	1	0.11	0	0	0	0	0	0	0	0	0	0	0	0;
	2968	0	0	15	0	1	32.2	0	28	0	0	0	0	0	0	0	0	0	0	0	0;
	2972	26.7	17	17	-10	1.10733	31.8	1	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2972	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	26.7	17	17	-10	1.10722	31.8	1	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2984	0	0	0	0	1	32.2	0	28	10	0	0	0	0	0	0	0	0	0	0	0;
	2991	4	2.2	2.2	0.5	1.09582	4.4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2991	4	2.2	2.2	0.5	1.09582	4.4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2994	0	0	22	-2.5	1	57	0	54	37	0	0	0	0	0	0	0	0	0	0	0;
	2994	52	8	22	8	1.09505	55.5	1	52	41	0	0	0	0	0	0	0	0	0	0	0;
	2995	51	8	22	8	1.09508	55.5	1	51	41	0	0	0	0	0	0	0	0	0	0	0;
	3005	18	2	2	0	1.07144	20	1	18	0	0	0	0	0	0	0	0	0	0	0	0;
	3006	0	-16.02	9999	-9999	1.04526	482.3	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3007	0	28.11	9999	-9999	1.08868	7776.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3008	0	15.62	9999	-9999	1.03223	22373.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3010	0	29.77	9999	-9999	1.05	33044.7	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3011	0	74.75	9999	-9999	1.11	7212.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3012	0	-133.32	9999	-9999	1.03018	15218.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	9	11	0.00064	0.0305	0	400	400	400	1.10224	0	1	-360	360;
	13	12	0.00069	0.03946	0	250	250	250	0.9999	0	1	-360	360;
	21	19	0.00088	0.05709	0	330	330	330	0.9999	0	1	-360	360;
	36	35	0.0007	0.03652	0	250	250	250	0.9999	0	1	-360	360;
	37	40	0.00036	0.02519	0	500	500	500	1.0686	0	1	-360	360;
	38	41	0.00036	0.02519	0	500	500	500	1.08671	0	1	-360	360;
	55	56	0.00034	0.02097	0	500	500	500	1.0755	0	1	-360	360;
	59	61	0.00034	0.02097	0	500	500	500	1.05955	0	1	-360	360;
	70	72	0.00081	0.03	0	400	400	400	1.0876	0	1	-360	360;
	107	109	0.00075	0.02445	-0.00832	330	330	330	1.06467	0	1	-360	360;
	108	110	0.0004	0.0253	0	500	500	500	1.07013	0	1	-360	360;
	144	147	0.00053	0.02875	-0.016	400	400	400	1.07702	0	1	-360	360;
	173	174	0.00064	0.0305	0	400	400	400	1.06172	0	1	-360	360;
	182	183	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	181	184	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	188	187	0.00032	0.04392	0	330	330	330	0.9999	0	1	-360	360;
	191	193	0.0003	0.02732	0	500	500	500	1.10871	0	1	-360	360;
	198	200	0.00035	0.02375	0	500	500	500	1.07313	0	1	-360	360;
	212	213	0.00051	0.0275	0	400	400	400	1.10394	0	1	-360	360;
	217	215	0.00084	0.06858	0	250	250	250	0.9999	0	1	-360	360;
	220	222	0.00033	0.02711	0	500	500	500	1.08613	0	1	-360	360;
	224	222	0.00032	0.0464	0	330	330	330	0.9999	0	1	-360	360;
	231	229	0.00113	0.05647	0	330	330	330	0.9999	0	1	-360	360;
	228	230	0.00075	0.02469	-0.008	330	330	330	1.04544	0	1	-360	360;
	3010	183	0.00029	0.00317	0.09184	1386	1386	1386	0	0	1	-360	360;
	3010	184	0.0003	0.00326	0.09536	1386	1386	1386	0	0	1	-360	360;
	244	84	0.01475	0.08595	0.13036	415	415	415	0	0	1	-360	360;
	3007	92	0.01244	0.06959	0.1181	412	412	412	0	0	1	-360	360;
	3007	122	0.01207	0.06905	0.11519	412	412	412	0	0	1	-360	360;
	146	3008	0.00168	0.01604	0.51488	1206	1206	1206	0	0	1	-360	360;
	3011	172	0.0018	0.01616	0.0484	457	457	457	0	0	1	-360	360;
	3011	173	0.0018	0.01616	0.0484	457	457	457	0	0	1	-360	360;
	3012	63	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	3012	64	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	99	3006	0.00293	0.03054	0.95472	1206	1206	1206	0	0	1	-360	360;
	58	30	0.01174	0.07014	0.12689	415	415	415	0	0	1	-360	360;
	37	107	0.00919	0.06614	0.10451	461	461	461	0	0	1	-360	360;
	38	108	0.00822	0.05767	0.0982	465	465	465	0	0	1	-360	360;
	169	42	0.01698	0.12459	0.1957	373	373	373	0	0	1	-360	360;
	155	48	0.01298	0.06738	0.10284	335	335	335	0	0	1	-360	360;
	154	27	0.01068	0.0475	0.09495	415	415	415	0	0	1	-360	360;
	191	28	0.01436	0.10729	0.16081	373	373	373	0	0	1	-360	360;
	55	126	0.01488	0.08161	0.1148	347	347	347	0	0	1	-360	360;
	54	108	0.01116	0.07171	0.10367	362	362	362	0	0	1	-360	360;
	207	100	0.00552	0.05948	0.17077	427	427	427	0	0	1	-360	360;
	238	192	0.01118	0.06597	0.10778	362	362	362	0	0	1	-360	360;
	226	191	0.01682	0.08909	0.12993	400	400	400	0	0	1	-360	360;
	225	192	0.01384	0.08702	0.13484	400	400	400	0	0	1	-360	360;
	242	195	0.01517	0.09938	0.14492	274	274	274	0	0	1	-360	360;
	59	16	0.01347	0.07316	0.13418	377	377	377	0	0	1	-360	360;
	233	25	0.01403	0.10413	0.15949	373	373	373	0	0	1	-360	360;
	117	70	0.00374	0.0438	0.10096	476	476	476	0	0	1	-360	360;
	190	99	0.00194	0.02007	0.54307	1316	1316	1316	0	0	1	-360	360;
	60	12	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360;
	214	174	0.00296	0.03484	0.9296	1358	1358	1358	0	0	1	-360	360;
	138	72	0.00169	0.01931	0.53814	866	866	866	0	0	1	-360	360;
	41	110	0.00137	0.01569	0.43744	1386	1386	1386	0	0	1	-360	360;
	40	141	0.00234	0.02677	0.74653	1386	1386	1386	0	0	1	-360	360;
	34	222	0.00217	0.02513	0.67098	1386	1386	1386	0	0	1	-360	360;
	138	80	0.00152	0.01739	0.48083	866	866	866	0	0	1	-360	360;
	140	80	0.00468	0.05347	1.48883	831	831	831	0	0	1	-360	360;
	99	44	0.00355	0.03617	0.95894	1150	1150	1150	0	0	1	-360	360;
	109	40	0.00195	0.02103	0.5679	1316	1316	1316	0	0	1	-360	360;
	63	139	0.00144	0.01446	0.51213	1386	1386	1386	0	0	1	-360	360;
	14	6	0.013	0.09781	0.14013	461	461	461	0	0	1	-360	360;
	43	14	0.00525	0.03847	0.06053	373	373	373	0	0	1	-360	360;
	33	6	0.00457	0.03351	0.05245	427	427	427	0	0	1	-360	360;
	24	9	0.01469	0.10915	0.16676	427	427	427	0	0	1	-360	360;
	29	16	0.01262	0.09326	0.14324	373	373	373	0	0	1	-360	360;
	37	7	0.00924	0.05052	0.07698	366	366	366	0	0	1	-360	360;
	24	3	0.01068	0.07936	0.12155	274	274	274	0	0	1	-360	360;
	37	27	0.00585	0.04027	0.07161	495	495	495	0	0	1	-360	360;
	39	26	0.00585	0.04027	0.07161	495	495	495	0	0	1	-360	360;
	15	8	0.00558	0.04147	0.0629	373	373	373	0	0	1	-360	360;
	46	14	0.00089	0.0063	0.0108	373	373	373	0	0	1	-360	360;
	31	15	0.00442	0.02374	0.04477	415	415	415	0	0	1	-360	360;
	47	7	0.00494	0.0269	0.04225	335	335	335	0	0	1	-360	360;
	26	6	0.00287	0.01671	0.02467	366	366	366	0	0	1	-360	360;
	37	1	0.0012	0.0089	0.01512	747	747	747	0	0	1	-360	360;
	39	2	0.0012	0.0089	0.01513	747	747	747	0	0	1	-360	360;
	38	32	0.00399	0.02901	0.04808	476	476	476	0	0	1	-360	360;
	34	12	0.00298	0.03445	0.94221	831	831	831	0	0	1	-360	360;
	40	34	0.00358	0.04122	1.13382	1386	1386	1386	0	0	1	-360	360;
	20	41	0.00342	0.03928	1.08288	1316	1316	1316	0	0	1	-360	360;
	11	22	0.00286	0.0335	0.89392	1358	1358	1358	0	0	1	-360	360;
	11	20	0.0011	0.01259	0.3496	1358	1358	1358	0	0	1	-360	360;
	44	41	0.00076	0.00868	0.24096	1358	1358	1358	0	0	1	-360	360;
	79	74	0.01054	0.06151	0.09306	316	316	316	0	0	1	-360	360;
	76	71	0.00905	0.06723	0.10296	373	373	373	0	0	1	-360	360;
	83	49	0.0114	0.06587	0.09975	274	274	274	0	0	1	-360	360;
	66	49	0.0107	0.06628	0.10825	377	377	377	0	0	1	-360	360;
	74	57	0.00543	0.03733	0.06668	446	446	446	0	0	1	-360	360;
	75	59	0.00543	0.03733	0.06668	446	446	446	0	0	1	-360	360;
	75	49	0.00657	0.0481	0.0727	419	419	419	0	0	1	-360	360;
	84	67	0.00302	0.0201	0.03069	415	415	415	0	0	1	-360	360;
	67	53	0.007	0.05138	0.08084	373	373	373	0	0	1	-360	360;
	51	70	0.00329	0.02506	0.0439	427	427	427	0	0	1	-360	360;
	52	50	0.00789	0.05868	0.08985	373	373	373	0	0	1	-360	360;
	71	52	0.00558	0.04062	0.06491	446	446	446	0	0	1	-360	360;
	83	51	0.00452	0.03366	0.05156	446	446	446	0	0	1	-360	360;
	83	82	0.00134	0.00996	0.01337	377	377	377	0	0	1	-360	360;
	78	57	0.00618	0.04353	0.07649	446	446	446	0	0	1	-360	360;
	79	58	0.00618	0.04353	0.07649	347	347	347	0	0	1	-360	360;
	78	54	0.01219	0.0637	0.09333	347	347	347	0	0	1	-360	360;
	77	55	0.00246	0.01826	0.02798	373	373	373	0	0	1	-360	360;
	62	54	0.00242	0.01531	0.02249	377	377	377	0	0	1	-360	360;
	65	61	0.0017	0.01977	0.53386	1358	1358	1358	0	0	1	-360	360;
	73	69	0.00116	0.013	0.33856	1358	1358	1358	0	0	1	-360	360;
	56	72	0.00218	0.02536	0.68579	1358	1358	1358	0	0	1	-360	360;
	80	73	0.00105	0.01123	0.28195	1386	1386	1386	0	0	1	-360	360;
	64	81	0.00119	0.01428	0.36666	1386	1386	1386	0	0	1	-360	360;
	68	60	0.00184	0.02139	0.5777	1358	1358	1358	0	0	1	-360	360;
	113	144	0.00488	0.03362	0.05961	446	446	446	0	0	1	-360	360;
	91	124	0.01093	0.05919	0.08439	290	290	290	0	0	1	-360	360;
	124	111	0.00194	0.01415	0.0223	446	446	446	0	0	1	-360	360;
	95	150	0.00192	0.01355	0.023	446	446	446	0	0	1	-360	360;
	150	102	0.00238	0.01667	0.02846	446	446	446	0	0	1	-360	360;
	123	150	0.00279	0.02017	0.03204	446	446	446	0	0	1	-360	360;
	151	149	0.00066	0.00496	0.00758	419	419	419	0	0	1	-360	360;
	123	151	0.00537	0.04039	0.06005	419	419	419	0	0	1	-360	360;
	108	151	0.00083	0.00525	0.00868	305	305	305	0	0	1	-360	360;
	117	137	0.01589	0.0876	0.11682	347	347	347	0	0	1	-360	360;
	97	130	0.00217	0.01459	0.02575	316	316	316	0	0	1	-360	360;
	134	118	0.01773	0.11678	0.16361	335	335	335	0	0	1	-360	360;
	145	90	0.00593	0.04093	0.07215	446	446	446	0	0	1	-360	360;
	125	107	0.0039	0.02847	0.04498	427	427	427	0	0	1	-360	360;
	136	95	0.00816	0.04242	0.0612	385	385	385	0	0	1	-360	360;
	137	94	0.00816	0.04242	0.0612	385	385	385	0	0	1	-360	360;
	95	92	0.00519	0.03839	0.05875	495	495	495	0	0	1	-360	360;
	94	89	0.00213	0.01403	0.0226	335	335	335	0	0	1	-360	360;
	131	94	0.00463	0.02775	0.04612	362	362	362	0	0	1	-360	360;
	120	88	0.01122	0.07074	0.11571	290	290	290	0	0	1	-360	360;
	127	135	0.00601	0.04147	0.07364	427	427	427	0	0	1	-360	360;
	108	85	0.00207	0.01279	0.02055	316	316	316	0	0	1	-360	360;
	103	107	0.00136	0.0099	0.01586	495	495	495	0	0	1	-360	360;
	148	104	0.00058	0.00417	0.00684	446	446	446	0	0	1	-360	360;
	152	92	0.00085	0.00624	0.00954	457	457	457	0	0	1	-360	360;
	153	93	0.00085	0.00626	0.00948	457	457	457	0	0	1	-360	360;
	119	93	0.00159	0.01112	0.01913	492	492	492	0	0	1	-360	360;
	144	121	0.00314	0.02159	0.03839	446	446	446	0	0	1	-360	360;
	145	128	0.00455	0.03157	0.05531	373	373	373	0	0	1	-360	360;
	121	101	0.00145	0.01008	0.01719	373	373	373	0	0	1	-360	360;
	122	112	0.00384	0.02721	0.04517	373	373	373	0	0	1	-360	360;
	129	96	0.00777	0.04128	0.06391	316	316	316	0	0	1	-360	360;
	106	94	0.00446	0.03041	0.04867	290	290	290	0	0	1	-360	360;
	135	125	0.00589	0.03506	0.05235	362	362	362	0	0	1	-360	360;
	126	116	0.00316	0.02378	0.03527	373	373	373	0	0	1	-360	360;
	134	95	0.00184	0.0126	0.0224	373	373	373	0	0	1	-360	360;
	123	105	0.00171	0.00961	0.01424	335	335	335	0	0	1	-360	360;
	115	95	0.00341	0.02442	0.03997	427	427	427	0	0	1	-360	360;
	135	94	0.00184	0.0126	0.02239	373	373	373	0	0	1	-360	360;
	100	114	0.0057	0.04149	0.06617	446	446	446	0	0	1	-360	360;
	143	136	0.00459	0.02463	0.03616	347	347	347	0	0	1	-360	360;
	142	127	0.00215	0.01333	0.02211	335	335	335	0	0	1	-360	360;
	117	87	0.00079	0.00488	0.00726	137	137	137	0	0	1	-360	360;
	118	86	0.00079	0.00488	0.00724	137	137	137	0	0	1	-360	360;
	110	146	0.00241	0.02782	0.77066	1386	1386	1386	0	0	1	-360	360;
	99	147	0.00213	0.02432	0.67744	1386	1386	1386	0	0	1	-360	360;
	140	132	0.00091	0.0104	0.28989	1358	1358	1358	0	0	1	-360	360;
	141	139	0.00312	0.03563	0.99107	831	831	831	0	0	1	-360	360;
	132	147	0.00092	0.01051	0.29293	1358	1358	1358	0	0	1	-360	360;
	202	181	0.01039	0.08983	0.11422	461	461	461	0	0	1	-360	360;
	203	180	0.01039	0.08983	0.11422	461	461	461	0	0	1	-360	360;
	205	180	0.01455	0.0813	0.13279	362	362	362	0	0	1	-360	360;
	206	181	0.01455	0.0813	0.13279	362	362	362	0	0	1	-360	360;
	158	206	0.00519	0.03965	0.05836	427	427	427	0	0	1	-360	360;
	158	168	0.00083	0.00645	0.00951	427	427	427	0	0	1	-360	360;
	192	163	0.01105	0.08107	0.12824	446	446	446	0	0	1	-360	360;
	159	182	0.00597	0.04473	0.06735	427	427	427	0	0	1	-360	360;
	199	202	0.01736	0.10969	0.16268	305	305	305	0	0	1	-360	360;
	176	203	0.00938	0.06093	0.08934	415	415	415	0	0	1	-360	360;
	179	181	0.01246	0.09134	0.14349	476	476	476	0	0	1	-360	360;
	156	160	0.00514	0.03826	0.05933	305	305	305	0	0	1	-360	360;
	172	166	0.01062	0.0789	0.12085	427	427	427	0	0	1	-360	360;
	178	209	0.00769	0.0569	0.08673	373	373	373	0	0	1	-360	360;
	178	208	0.00225	0.01667	0.02541	286	286	286	0	0	1	-360	360;
	199	170	0.01851	0.1088	0.14435	335	335	335	0	0	1	-360	360;
	204	198	0.00236	0.01411	0.02031	229	229	229	0	0	1	-360	360;
	198	163	0.00355	0.02607	0.04096	446	446	446	0	0	1	-360	360;
	199	194	0.013	0.07589	0.11484	362	362	362	0	0	1	-360	360;
	198	177	0.00934	0.0539	0.08683	377	377	377	0	0	1	-360	360;
	170	154	0.00698	0.0374	0.05463	385	385	385	0	0	1	-360	360;
	169	155	0.00436	0.03202	0.0503	476	476	476	0	0	1	-360	360;
	191	170	0.0006	0.00351	0.00555	446	446	446	0	0	1	-360	360;
	192	169	0.0006	0.00351	0.00555	446	446	446	0	0	1	-360	360;
	179	166	0.01058	0.07762	0.12203	373	373	373	0	0	1	-360	360;
	185	172	0.00469	0.03486	0.05338	427	427	427	0	0	1	-360	360;
	173	164	0.00568	0.04012	0.07033	427	427	427	0	0	1	-360	360;
	196	164	0.00105	0.00733	0.01258	373	373	373	0	0	1	-360	360;
	197	185	0.00744	0.05397	0.09307	373	373	373	0	0	1	-360	360;
	206	157	0.00221	0.01618	0.02541	373	373	373	0	0	1	-360	360;
	207	205	0.00525	0.03837	0.06052	373	373	373	0	0	1	-360	360;
	210	202	0.00236	0.01746	0.02676	381	381	381	0	0	1	-360	360;
	183	161	0.00274	0.02778	0.69846	1150	1150	1150	0	0	1	-360	360;
	189	162	0.00171	0.01741	0.45456	1150	1150	1150	0	0	1	-360	360;
	187	190	0.00136	0.01599	0.41965	1621	1621	1621	0	0	1	-360	360;
	200	175	0.00373	0.04344	1.172	831	831	831	0	0	1	-360	360;
	218	225	0.02738	0.14254	0.20047	351	351	351	0	0	1	-360	360;
	232	238	0.02709	0.15992	0.26125	274	274	274	0	0	1	-360	360;
	219	243	0.01909	0.11277	0.16673	274	274	274	0	0	1	-360	360;
	221	226	0.008	0.05936	0.10081	373	373	373	0	0	1	-360	360;
	225	211	0.00186	0.02155	0.05317	747	747	747	0	0	1	-360	360;
	237	239	0.00738	0.05486	0.09318	274	274	274	0	0	1	-360	360;
	220	236	0.00556	0.04198	0.06158	274	274	274	0	0	1	-360	360;
	233	228	0.00205	0.01421	0.02506	446	446	446	0	0	1	-360	360;
	243	212	0.00568	0.04215	0.0716	366	366	366	0	0	1	-360	360;
	235	213	0.00131	0.01547	0.41152	1358	1358	1358	0	0	1	-360	360;
	215	222	0.00224	0.02606	0.70304	831	831	831	0	0	1	-360	360;
	229	216	0.0024	0.02795	0.75408	1358	1358	1358	0	0	1	-360	360;
	240	234	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360;
	215	240	0.00133	0.01553	0.41901	831	831	831	0	0	1	-360	360;
	216	241	0.00133	0.01553	0.41898	831	831	831	0	0	1	-360	360;
	486	1	0.00157	0.06612	0	160	160	160	0.99491	0	1	-360	360;
	487	2	0.00157	0.06612	0	160	160	160	0.9909	0	1	-360	360;
	310	308	0.00101	0.04727	0	300	300	300	0.91667	0	1	-360	360;
	310	41	0.00079	0.03678	0	426	426	426	0.91667	0	1	-360	360;
	313	4	0.00165	0.06736	0	160	160	160	1.04356	0	1	-360	360;
	5	3	0.00068	0.08078	0	160	160	160	0.9999	0	1	-360	360;
	314	5	0.00072	-0.01281	0	160	160	160	1.02537	0	1	-360	360;
	315	5	-0.00012	0.1674	0	9999	50	50	0.94157	0	1	-360	360;
	347	6	0.00165	0.06901	0	160	160	160	1.03315	0	1	-360	360;
	348	7	0.00165	0.06901	0	160	160	160	1.03303	0	1	-360	360;
	10	8	0.00079	0.07524	0	160	160	160	0.9999	0	1	-360	360;
	425	10	0.00081	-0.00714	0	160	160	160	1.00521	0	1	-360	360;
	427	10	-0.00024	0.15701	0	9999	50	50	0.94157	0	1	-360	360;
	426	8	0.00165	0.0686	0	160	160	160	1.02676	0	1	-360	360;
	426	13	0.00066	0.0269	0	250	250	250	1.10119	0	1	-360	360;
	428	13	-0.00044	0.00942	0	50	50	50	0.98438	0	1	-360	360;
	17	14	0.00059	0.07897	0	160	160	160	0.9999	0	1	-360	360;
	439	17	0.0006	-0.01352	0	160	160	160	1.07516	0	1	-360	360;
	442	17	-0.00467	0.16067	0	16	16	16	0.94157	0	1	-360	360;
	18	15	0.00062	0.08296	0	160	160	160	0.9999	0	1	-360	360;
	440	18	0.00062	-0.01547	0	160	160	160	1.07516	0	1	-360	360;
	443	18	-0.00056	0.17867	0	16	16	16	0.94157	0	1	-360	360;
	441	16	0.00165	0.06775	0	160	160	160	1.09622	0	1	-360	360;
	450	21	0.00011	-0.00462	0	330	330	330	1.09089	0	1	-360	360;
	452	21	0.00452	0.07233	0	63	63	63	0.96037	0	1	-360	360;
	459	22	0.00087	0.05244	-0.02144	330	330	330	1.1175	0	1	-360	360;
	479	24	0.00124	0.06839	0	160	160	160	1.02703	0	1	-360	360;
	478	25	0.00124	0.06839	0	160	160	160	1.01196	0	1	-360	360;
	484	26	0.00165	0.06901	0	160	160	160	1.04795	0	1	-360	360;
	485	27	0.00165	0.06901	0	160	160	160	1.02755	0	1	-360	360;
	491	28	0.00155	0.06612	0	160	160	160	1.08759	0	1	-360	360;
	492	29	0.00157	0.06612	0	160	160	160	1.09829	0	1	-360	360;
	498	30	0.00165	0.06901	0	160	160	160	1.09028	0	1	-360	360;
	499	31	0.00165	0.06901	0	160	160	160	1.09028	0	1	-360	360;
	500	32	0.00157	0.06798	0	160	160	160	1.01602	0	1	-360	360;
	501	33	0.00165	0.06901	0	160	160	160	1.02703	0	1	-360	360;
	509	36	0.00067	0.023	0	250	250	250	1.11802	0	1	-360	360;
	511	36	-0.00044	0.01252	0	50	50	50	0.98438	0	1	-360	360;
	571	43	0.00165	0.06818	0	160	160	160	1.13473	0	1	-360	360;
	601	44	0.00137	0.06119	-0.01504	250	250	250	1.05095	0	1	-360	360;
	602	45	0.00137	0.06119	-0.01504	250	250	250	1.05095	0	1	-360	360;
	682	46	0.00165	0.06901	0	160	160	160	1.09851	0	1	-360	360;
	737	47	0.00165	0.06901	0	160	160	160	1.08569	0	1	-360	360;
	738	48	0.00165	0.06901	0	160	160	160	1.08569	0	1	-360	360;
	756	49	0.0014	0.0668	0	160	160	160	1.0225	0	1	-360	360;
	761	50	0.00151	0.06715	0	160	160	160	1.01599	0	1	-360	360;
	785	52	0.00157	0.07808	0	160	160	160	1.00521	0	1	-360	360;
	789	53	0.00149	0.06616	0	160	160	160	1.02676	0	1	-360	360;
	846	57	0.00157	0.06775	0	160	160	160	1.0225	0	1	-360	360;
	849	62	0.00163	0.06946	0	160	160	160	1.01196	0	1	-360	360;
	851	64	0.00135	0.06052	0	250	250	250	1.04876	0	1	-360	360;
	882	65	0.00135	0.06052	0	250	250	250	1.07213	0	1	-360	360;
	903	66	0.00119	0.06558	0	160	160	160	1.04115	0	1	-360	360;
	923	69	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	927	68	0.00139	0.05984	0	250	250	250	1.06772	0	1	-360	360;
	935	71	0.00145	0.06839	0	160	160	160	1.0225	0	1	-360	360;
	955	76	0.00165	0.06775	0	160	160	160	1.01039	0	1	-360	360;
	954	77	0.00157	0.06775	0	160	160	160	1.00433	0	1	-360	360;
	967	78	0.00163	0.06783	0	160	160	160	1.00562	0	1	-360	360;
	966	79	0.00143	0.06831	0	160	160	160	1.00143	0	1	-360	360;
	976	80	0.00139	0.0608	0	250	250	250	1.05095	0	1	-360	360;
	977	81	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	1008	82	0.00163	0.06754	0	160	160	160	1.01633	0	1	-360	360;
	1042	84	0.00161	0.06762	0	160	160	160	1.02703	0	1	-360	360;
	1065	85	0.00119	0.06565	-0.003	160	160	160	1.02994	0	1	-360	360;
	1094	88	0.00141	0.07036	-0.00319	160	160	160	1.01186	0	1	-360	360;
	1111	90	0.00287	0.10711	-0.00242	100	100	100	1.00972	0	1	-360	360;
	1112	91	0.0014	0.06927	-0.00532	160	160	160	0.99664	0	1	-360	360;
	1214	98	0.00155	0.06268	-0.00992	250	250	250	1.03418	0	1	-360	360;
	1215	98	0.00155	0.06288	-0.00992	250	250	250	1.03622	0	1	-360	360;
	1307	100	0.0016	0.06694	-0.0031	160	160	160	1.06291	0	1	-360	360;
	1308	100	0.00153	0.0666	-0.00319	160	160	160	1.05385	0	1	-360	360;
	1331	101	0.00149	0.06756	-0.00252	160	160	160	0.99966	0	1	-360	360;
	1330	102	0.00149	0.06544	-0.00252	160	160	160	1.01119	0	1	-360	360;
	1408	105	0.00141	0.06975	-0.00232	160	160	160	1.01904	0	1	-360	360;
	1409	106	0.00157	0.0677	-0.00281	160	160	160	1.04338	0	1	-360	360;
	1454	111	0.00154	0.06742	-0.00658	160	160	160	1.02832	0	1	-360	360;
	1453	112	0.00143	0.06701	-0.0029	160	160	160	1.01552	0	1	-360	360;
	1470	113	0.0014	0.06831	-0.00319	160	160	160	1.04745	0	1	-360	360;
	1478	117	0.00162	0.06729	-0.00232	160	160	160	1.00901	0	1	-360	360;
	1477	118	0.00155	0.06701	-0.00319	160	160	160	1.00156	0	1	-360	360;
	1511	119	0.00143	0.06968	-0.00223	160	160	160	1.1232	0	1	-360	360;
	1510	120	0.00155	0.06763	-0.00319	160	160	160	1.08347	0	1	-360	360;
	1513	121	0.00148	0.06688	-0.0029	160	160	160	1.00622	0	1	-360	360;
	1590	122	0.00155	0.06851	-0.0029	160	160	160	1.00562	0	1	-360	360;
	1578	123	0.00174	0.09356	-0.00339	160	160	160	0.98025	0	1	-360	360;
	1580	124	0.00167	0.09275	-0.003	160	160	160	0.99243	0	1	-360	360;
	1617	125	0.00144	0.06708	-0.00223	160	160	160	1.03706	0	1	-360	360;
	1623	127	0.00148	0.06578	-0.00523	160	160	160	1.06211	0	1	-360	360;
	1659	128	0.00152	0.06749	-0.00348	160	160	160	1.05917	0	1	-360	360;
	1793	130	0.00143	0.06968	-0.0029	160	160	160	1.04669	0	1	-360	360;
	1857	132	0.00156	0.06252	-0.00864	250	250	250	1.10237	0	1	-360	360;
	1859	132	0.00156	0.06292	-0.00864	250	250	250	1.06627	0	1	-360	360;
	1902	134	0.00142	0.06729	-0.00223	160	160	160	1.00562	0	1	-360	360;
	1910	137	0.00153	0.06667	-0.00658	160	160	160	1.03633	0	1	-360	360;
	2014	138	0.00136	0.05992	-0.01504	250	250	250	1.09851	0	1	-360	360;
	2016	140	0.00139	0.0612	-0.00992	250	250	250	1.04984	0	1	-360	360;
	2017	141	0.00156	0.06244	-0.00992	250	250	250	1.07415	0	1	-360	360;
	2044	142	0.00155	0.06701	-0.003	160	160	160	1.06519	0	1	-360	360;
	2043	143	0.00121	0.06831	-0.003	160	160	160	1.05641	0	1	-360	360;
	2064	144	0.00139	0.06852	-0.00232	160	160	160	1.00622	0	1	-360	360;
	2063	145	0.00154	0.06811	-0.0029	160	160	160	1.00562	0	1	-360	360;
	2084	148	0.00119	0.06571	-0.00378	160	160	160	1.03799	0	1	-360	360;
	2085	149	0.00143	0.06551	-0.0029	160	160	160	1.01739	0	1	-360	360;
	2153	154	0.00165	0.0625	0	160	160	160	1.03303	0	1	-360	360;
	2173	157	0.00145	0.06818	0	160	160	160	1.01601	0	1	-360	360;
	2174	156	0.00165	0.06818	0	160	160	160	1.02036	0	1	-360	360;
	2178	158	0.00145	0.06818	0	160	160	160	1.02586	0	1	-360	360;
	2199	159	0.00151	0.06688	0	160	160	160	1.00666	0	1	-360	360;
	2201	161	0.00153	0.06206	0	250	250	250	1.08449	0	1	-360	360;
	2202	162	0.00152	0.06206	0	250	250	250	1.08449	0	1	-360	360;
	2207	163	0.00118	0.06517	0	160	160	160	1.06463	0	1	-360	360;
	2233	164	0.00151	0.06688	0	160	160	160	1.02678	0	1	-360	360;
	2239	166	0.00161	0.06653	0	160	160	160	1.00125	0	1	-360	360;
	2240	166	0.00161	0.06653	0	160	160	160	1.00381	0	1	-360	360;
	2304	168	0.00145	0.06818	0	160	160	160	1.04795	0	1	-360	360;
	2305	168	0.00145	0.06818	0	160	160	160	1.02678	0	1	-360	360;
	2321	169	0.00165	0.06851	0	160	160	160	1.0162	0	1	-360	360;
	2320	170	0.00165	0.06851	0	160	160	160	1.03303	0	1	-360	360;
	2319	171	0.00498	0.16449	0	70	70	70	1.00832	0	1	-360	360;
	2322	171	0.00191	0.00254	0	70	70	70	0.98083	0	1	-360	360;
	2332	173	0.00163	0.06136	0.00416	160	160	160	1.01226	0	1	-360	360;
	2377	176	0.00165	0.0593	0	160	160	160	1.10087	0	1	-360	360;
	2386	178	0.00118	0.06517	0	160	160	160	1.04356	0	1	-360	360;
	2387	179	0.00123	0.06619	0	160	160	160	1.04583	0	1	-360	360;
	2403	181	0.00165	0.09277	0	160	160	160	1.01196	0	1	-360	360;
	2404	182	0.00165	0.06694	0	160	160	160	1.0096	0	1	-360	360;
	2411	185	0.00029	0.06136	0.00416	160	160	160	1.0162	0	1	-360	360;
	2412	185	0.00165	0.0686	0	160	160	160	1.0162	0	1	-360	360;
	2443	188	0.00032	-0.00215	0	330	330	330	1.09976	0	1	-360	360;
	2445	188	-0.00023	0.09951	0	63	63	63	0.96037	0	1	-360	360;
	2448	190	0.00101	0.06188	0	330	330	330	1.09976	0	1	-360	360;
	2447	189	0.00138	0.05931	0	250	250	250	1.08449	0	1	-360	360;
	2449	191	0.00163	0.07033	0	160	160	160	1.04795	0	1	-360	360;
	2468	194	0.00165	0.0593	0	160	160	160	1.0797	0	1	-360	360;
	2469	195	0.00165	0.0593	0	160	160	160	1.09028	0	1	-360	360;
	2470	196	0.00281	0.10601	0	100	100	100	0.98445	0	1	-360	360;
	2471	197	0.00281	0.10601	0	100	100	100	0.98445	0	1	-360	360;
	2473	199	0.00165	0.0593	0	160	160	160	1.06463	0	1	-360	360;
	2472	200	0.00101	0.06188	-0.01984	330	330	330	1.11518	0	1	-360	360;
	2473	200	0.00153	0.06206	0	250	250	250	1.11803	0	1	-360	360;
	2486	202	0.00165	0.06653	0	160	160	160	1.05108	0	1	-360	360;
	2487	203	0.00165	0.06775	0	160	160	160	1.06912	0	1	-360	360;
	2492	204	0.00162	0.06763	0	160	160	160	1.10675	0	1	-360	360;
	2556	205	0.00165	0.06818	0	160	160	160	1.02196	0	1	-360	360;
	2557	206	0.00165	0.06818	0	160	160	160	1.03016	0	1	-360	360;
	2668	207	0.00165	0.06632	0	160	160	160	1.03871	0	1	-360	360;
	2691	209	0.00165	0.06632	0	160	160	160	1.09028	0	1	-360	360;
	2690	210	0.00165	0.06632	0	160	160	160	1.09028	0	1	-360	360;
	2712	211	0.00155	0.06585	0	160	160	160	1.09491	0	1	-360	360;
	2737	214	0.00137	0.05968	0	250	250	250	1.05095	0	1	-360	360;
	2746	217	0.00044	-0.00422	0	250	250	250	1.06773	0	1	-360	360;
	2748	217	0.00496	0.06982	0	9999	50	50	0.98438	0	1	-360	360;
	2747	216	0.00129	0.06437	0	250	250	250	1.08448	0	1	-360	360;
	2751	218	0.00015	0.06524	0	160	160	160	1.08282	0	1	-360	360;
	2752	219	0.00027	0.06715	0	160	160	160	1.10197	0	1	-360	360;
	2769	220	0.00163	0.06671	0	160	160	160	1.08006	0	1	-360	360;
	2771	221	0.00163	0.06671	0	160	160	160	1.07319	0	1	-360	360;
	2770	224	0.00032	-0.00435	0	330	330	330	1.08434	0	1	-360	360;
	2772	224	-0.00022	0.1019	0	9999	63	63	0.96037	0	1	-360	360;
	227	225	0.00076	0.0789	0	160	160	160	0.9999	0	1	-360	360;
	2779	227	0.00077	-0.01223	0	160	160	160	1.04452	0	1	-360	360;
	2781	227	-0.00017	0.16709	0	9999	50	50	0.94157	0	1	-360	360;
	2780	226	0.00159	0.06736	0	160	160	160	1.06986	0	1	-360	360;
	2854	231	-0.00013	-0.00407	0	330	330	330	1.04345	0	1	-360	360;
	2856	231	0.00423	0.07177	0	9999	63	63	0.96037	0	1	-360	360;
	2857	232	0.00161	0.06756	0	160	160	160	1.06367	0	1	-360	360;
	2858	233	0.00161	0.06756	0	160	160	160	1.06986	0	1	-360	360;
	2927	234	0.00059	0.04206	0	330	330	330	1.04858	0	1	-360	360;
	2948	237	0.00119	0.06565	0	160	160	160	1.09622	0	1	-360	360;
	2947	236	0.00151	0.06633	0	160	160	160	1.1017	0	1	-360	360;
	2968	238	0.00161	0.06736	0	160	160	160	1.09825	0	1	-360	360;
	2968	239	0.00165	0.06671	0	160	160	160	1.09825	0	1	-360	360;
	2989	240	0.00137	0.05969	0	250	250	250	1.05449	0	1	-360	360;
	2990	240	0.00137	0.05969	0	250	250	250	1.05312	0	1	-360	360;
	2994	242	0.00155	0.06798	0	160	160	160	1.02947	0	1	-360	360;
	2995	243	0.00161	0.06775	0	160	160	160	1.03303	0	1	-360	360;
	2846	434	0.07545	0.13256	0.01257	76	76	76	0	0	1	-360	360;
	2310	366	0.02372	0.06124	0.00624	102	102	102	0	0	1	-360	360;
	2347	389	0.02471	0.06281	0.00641	111	111	111	0	0	1	-360	360;
	2153	517	0.04207	0.1086	0.01107	108	108	108	0	0	1	-360	360;
	2291	267	0.06182	0.10504	0.01014	87	87	87	0	0	1	-360	360;
	2615	648	0.05926	0.10397	0.01048	90	90	90	0	0	1	-360	360;
	1486	305	0.03306	0.08099	0.01007	102	102	102	0	0	1	-360	360;
	1498	539	0.02149	0.07107	0.00724	133	133	133	0	0	1	-360	360;
	861	473	0.04727	0.08388	0.00786	90	90	90	0	0	1	-360	360;
	800	499	0.07463	0.13025	0.01244	83	83	83	0	0	1	-360	360;
	972	569	0.05223	0.09008	0.00866	83	83	83	0	0	1	-360	360;
	1031	1504	0.04545	0.07934	0.00852	69	69	69	0	0	1	-360	360;
	862	1803	0.03719	0.06033	0.00656	58	58	58	0	0	1	-360	360;
	935	1882	0.04132	0.13967	0.01241	102	102	102	0	0	1	-360	360;
	965	1588	0.02397	0.05372	0.00881	57	57	57	0	0	1	-360	360;
	1278	765	0.01653	0.02008	0.0042	78	78	78	0	0	1	-360	360;
	2661	1367	0.07025	0.12066	0.0129	67	67	67	0	0	1	-360	360;
	2940	2449	0.03719	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2872	2449	0.08207	0.20008	0.02217	120	120	120	0	0	1	-360	360;
	2877	2450	0.04463	0.11521	0.01205	120	120	120	0	0	1	-360	360;
	2819	2320	0.0681	0.17298	0.01756	120	120	120	0	0	1	-360	360;
	2817	2156	0.05678	0.14413	0.01463	120	120	120	0	0	1	-360	360;
	2840	2450	0.05628	0.18322	0.01876	137	137	137	0	0	1	-360	360;
	1914	987	0.03884	0.06446	0.00695	58	58	58	0	0	1	-360	360;
	846	555	0.04678	0.32397	0.03151	131	131	131	0	0	1	-360	360;
	1516	2302	0.0405	0.05041	0.00719	57	57	57	0	0	1	-360	360;
	649	1434	0.05702	0.11322	0.01232	78	78	78	0	0	1	-360	360;
	846	569	0.01636	0.05314	0.00619	112	112	112	0	0	1	-360	360;
	847	320	0.05661	0.1305	0.013	83	83	83	0	0	1	-360	360;
	632	1230	0.00992	0.02975	0.00356	119	119	119	0	0	1	-360	360;
	958	473	0.01397	0.04504	0.00462	137	137	137	0	0	1	-360	360;
	898	413	0.05992	0.10149	0.01089	83	83	83	0	0	1	-360	360;
	880	555	0.07438	0.13025	0.01236	83	83	83	0	0	1	-360	360;
	2807	322	0.0394	0.12917	0.01307	76	76	76	0	0	1	-360	360;
	2846	303	0.04521	0.0795	0.00754	76	76	76	0	0	1	-360	360;
	920	589	0.01719	0.0557	0.00569	137	137	137	0	0	1	-360	360;
	1031	1896	0.01405	0.04298	0.00513	69	69	69	0	0	1	-360	360;
	1994	897	0.02149	0.0405	0.00799	120	120	120	0	0	1	-360	360;
	1932	897	0.01901	0.03388	0.00697	57	57	57	0	0	1	-360	360;
	1819	904	0.05106	0.09015	0.00845	76	76	76	0	0	1	-360	360;
	956	413	0.04231	0.07529	0.00706	142	142	142	0	0	1	-360	360;
	2938	464	0.03752	0.12182	0.0124	69	69	69	0	0	1	-360	360;
	2703	417	0.07884	0.10231	0.01021	69	69	69	0	0	1	-360	360;
	847	577	0.05653	0.18587	0.01908	112	112	112	0	0	1	-360	360;
	900	548	0.02826	0.09669	0.00936	76	76	76	0	0	1	-360	360;
	802	1234	0.01901	0.05868	0.00682	114	114	114	0	0	1	-360	360;
	2845	2630	0.03074	0.09917	0.01021	69	69	69	0	0	1	-360	360;
	2842	432	0.02314	0.07529	0.00762	19	19	19	0	0	1	-360	360;
	262	260	0.03744	0.18876	0.01765	151	151	151	0	0	1	-360	360;
	526	441	0.01223	0.02868	0.00295	133	133	133	0	0	1	-360	360;
	393	266	0.01959	0.06355	0.00659	133	133	133	0	0	1	-360	360;
	725	641	0.00686	0.02207	0.00232	133	133	133	0	0	1	-360	360;
	525	725	0.00554	0.01802	0.00184	133	133	133	0	0	1	-360	360;
	725	730	0.00273	0.0095	0.001	133	133	133	0	0	1	-360	360;
	431	425	0.02355	0.06107	0.00629	120	120	120	0	0	1	-360	360;
	430	426	0.02339	0.0619	0.00629	120	120	120	0	0	1	-360	360;
	481	425	0.01545	0.04488	0.00434	120	120	120	0	0	1	-360	360;
	586	426	0.01967	0.05959	0.00587	120	120	120	0	0	1	-360	360;
	329	498	0.03182	0.05851	0.00559	90	90	90	0	0	1	-360	360;
	330	499	0.03256	0.06124	0.00549	90	90	90	0	0	1	-360	360;
	564	426	0.00251	0.00811	0.00086	137	137	137	0	0	1	-360	360;
	590	498	0.04058	0.07612	0.00678	90	90	90	0	0	1	-360	360;
	641	564	0.01398	0.04524	0.0048	137	137	137	0	0	1	-360	360;
	524	433	0.04306	0.07157	0.00754	90	90	90	0	0	1	-360	360;
	461	296	0.02736	0.05992	0.00581	90	90	90	0	0	1	-360	360;
	523	288	0.02455	0.07967	0.00818	133	133	133	0	0	1	-360	360;
	590	360	0.02165	0.0386	0.00351	90	90	90	0	0	1	-360	360;
	567	551	0.11182	0.19074	0.01909	90	90	90	0	0	1	-360	360;
	571	321	0.03083	0.10008	0.01034	142	142	142	0	0	1	-360	360;
	361	347	0.01967	0.06455	0.00652	120	120	120	0	0	1	-360	360;
	377	275	0.00653	0.02157	0.00211	120	120	120	0	0	1	-360	360;
	409	485	0.02364	0.07736	0.00789	120	120	120	0	0	1	-360	360;
	410	409	0.00248	0.00802	0.00082	133	133	133	0	0	1	-360	360;
	416	327	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360;
	469	348	0.02281	0.07446	0.00759	120	120	120	0	0	1	-360	360;
	743	528	0.02934	0.09512	0.00992	120	120	120	0	0	1	-360	360;
	482	389	0.01372	0.04455	0.00461	120	120	120	0	0	1	-360	360;
	419	292	0.02975	0.07686	0.00795	120	120	120	0	0	1	-360	360;
	478	404	0.03149	0.10347	0.01045	140	140	140	0	0	1	-360	360;
	479	465	0.04736	0.08314	0.00789	90	90	90	0	0	1	-360	360;
	465	362	0.0243	0.07975	0.00805	140	140	140	0	0	1	-360	360;
	483	439	0.00645	0.02025	0.00223	90	90	90	0	0	1	-360	360;
	515	466	0.03702	0.12132	0.0121	133	133	133	0	0	1	-360	360;
	669	571	0.02256	0.07322	0.0075	133	133	133	0	0	1	-360	360;
	752	407	0.05926	0.10455	0.00969	90	90	90	0	0	1	-360	360;
	571	269	0.02744	0.08264	0.00995	142	142	142	0	0	1	-360	360;
	570	588	0.04893	0.15504	0.01573	120	120	120	0	0	1	-360	360;
	557	524	0.0238	0.0781	0.00789	133	133	133	0	0	1	-360	360;
	365	496	0.00711	0.02281	0.00242	133	133	133	0	0	1	-360	360;
	604	558	0.01381	0.04492	0.00795	111	111	111	0	0	1	-360	360;
	670	368	0.01736	0.04533	0.00922	90	90	90	0	0	1	-360	360;
	343	396	0.00919	0.02977	0.00316	111	111	111	0	0	1	-360	360;
	397	716	0.00631	0.02038	0.00216	111	111	111	0	0	1	-360	360;
	729	640	0.00455	0.01471	0.00154	133	133	133	0	0	1	-360	360;
	249	439	0.00628	0.02036	0.00216	137	137	137	0	0	1	-360	360;
	248	449	0.00643	0.02076	0.0022	137	137	137	0	0	1	-360	360;
	691	439	0.00356	0.01154	0.00122	137	137	137	0	0	1	-360	360;
	702	624	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	701	625	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	625	609	0.00555	0.01796	0.00293	111	111	111	0	0	1	-360	360;
	610	440	0.00607	0.01973	0.00291	137	137	137	0	0	1	-360	360;
	683	441	0.00382	0.02652	0.00281	137	137	137	0	0	1	-360	360;
	666	440	0.01348	0.03592	0.0151	90	90	90	0	0	1	-360	360;
	656	439	0.01121	0.03006	0.01231	90	90	90	0	0	1	-360	360;
	678	665	0.0047	0.01191	0.00126	90	90	90	0	0	1	-360	360;
	671	611	0.01017	0.02827	0.02773	90	90	90	0	0	1	-360	360;
	603	439	0.00161	0.00521	0.00055	111	111	111	0	0	1	-360	360;
	606	441	0.00212	0.00684	0.00073	111	111	111	0	0	1	-360	360;
	671	654	0.01826	0.04974	0.00528	90	90	90	0	0	1	-360	360;
	675	690	0.00916	0.02956	0.00314	111	111	111	0	0	1	-360	360;
	672	671	0.00421	0.01103	0.00117	90	90	90	0	0	1	-360	360;
	673	670	0.00421	0.01103	0.00117	90	90	90	0	0	1	-360	360;
	701	680	0.00596	0.01931	0.00205	137	137	137	0	0	1	-360	360;
	701	621	0.00118	0.0038	0.0004	137	137	137	0	0	1	-360	360;
	674	624	0.00241	0.00778	0.00083	111	111	111	0	0	1	-360	360;
	641	426	0.01404	0.04546	0.00483	137	137	137	0	0	1	-360	360;
	728	709	0.0045	0.0145	0.00154	111	111	111	0	0	1	-360	360;
	659	709	0.01103	0.02812	0.00298	90	90	90	0	0	1	-360	360;
	709	346	0.00037	0.0012	0.00013	111	111	111	0	0	1	-360	360;
	425	708	0.00855	0.02759	0.00293	111	111	111	0	0	1	-360	360;
	712	708	0.0017	0.00427	0.00045	90	90	90	0	0	1	-360	360;
	670	712	0.00843	0.02047	0.00217	90	90	90	0	0	1	-360	360;
	708	345	0.00045	0.00115	0.00012	111	111	111	0	0	1	-360	360;
	712	421	0.00026	0.00066	7e-05	90	90	90	0	0	1	-360	360;
	635	665	0.00616	0.02064	0.00971	111	111	111	0	0	1	-360	360;
	623	693	0.00083	0.00356	0.02543	137	137	137	0	0	1	-360	360;
	677	612	0.00034	0.00216	0.01054	109	109	109	0	0	1	-360	360;
	441	451	0.01254	0.04055	0.00431	137	137	137	0	0	1	-360	360;
	642	449	0.00439	0.01417	0.0015	137	137	137	0	0	1	-360	360;
	702	715	0.01264	0.04099	0.00435	137	137	137	0	0	1	-360	360;
	715	629	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	715	436	0.00329	0.00826	0.00088	90	90	90	0	0	1	-360	360;
	684	342	0.00363	0.01174	0.00125	137	137	137	0	0	1	-360	360;
	625	519	0.00101	0.00587	0.03106	95	95	95	0	0	1	-360	360;
	439	744	0.00493	0.01634	0.00609	111	111	111	0	0	1	-360	360;
	440	639	0.00401	0.01293	0.00137	111	111	111	0	0	1	-360	360;
	651	682	0.00031	0.00199	0.00973	98	98	98	0	0	1	-360	360;
	665	657	0.00279	0.00805	0.00815	90	90	90	0	0	1	-360	360;
	686	605	0.00316	0.01018	0.00108	111	111	111	0	0	1	-360	360;
	629	747	0.00056	0.00182	0.00019	137	137	137	0	0	1	-360	360;
	679	670	0.00404	0.01024	0.00109	90	90	90	0	0	1	-360	360;
	693	620	0.00769	0.0249	0.00264	137	137	137	0	0	1	-360	360;
	689	636	0.00154	0.00541	0.00499	111	111	111	0	0	1	-360	360;
	688	670	0.00575	0.01855	0.00197	111	111	111	0	0	1	-360	360;
	667	666	0.00167	0.00597	0.00617	111	111	111	0	0	1	-360	360;
	671	668	0.0118	0.03881	0.01131	111	111	111	0	0	1	-360	360;
	643	746	0.00358	0.01155	0.00122	137	137	137	0	0	1	-360	360;
	716	630	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	716	437	0.00391	0.00826	0.00088	90	90	90	0	0	1	-360	360;
	644	745	0.00181	0.00621	0.00438	111	111	111	0	0	1	-360	360;
	645	638	0.00169	0.00619	0.0081	111	111	111	0	0	1	-360	360;
	701	685	0.00318	0.01028	0.00109	137	137	137	0	0	1	-360	360;
	700	265	0.00995	0.03021	0.00321	120	120	120	0	0	1	-360	360;
	671	626	0.01377	0.03899	0.00414	90	90	90	0	0	1	-360	360;
	693	713	0.01243	0.03156	0.00335	90	90	90	0	0	1	-360	360;
	713	422	0.00026	0.00066	7e-05	90	90	90	0	0	1	-360	360;
	627	622	0.0028	0.00903	0.00096	111	111	111	0	0	1	-360	360;
	681	641	0.00701	0.0227	0.00241	137	137	137	0	0	1	-360	360;
	692	640	0.00393	0.01271	0.00135	137	137	137	0	0	1	-360	360;
	687	499	0.01963	0.06331	0.00672	111	111	111	0	0	1	-360	360;
	655	499	0.01202	0.03521	0.00986	90	90	90	0	0	1	-360	360;
	640	615	0.00882	0.02843	0.00302	133	133	133	0	0	1	-360	360;
	641	495	0.02083	0.06719	0.00713	133	133	133	0	0	1	-360	360;
	683	676	0.00064	0.0041	0.02001	109	109	109	0	0	1	-360	360;
	425	728	0.00412	0.01331	0.00141	111	111	111	0	0	1	-360	360;
	663	650	0.00041	0.00259	0.01264	98	98	98	0	0	1	-360	360;
	520	664	0.0006	0.00374	0.01827	98	98	98	0	0	1	-360	360;
	692	658	0.0042	0.01131	0.0012	90	90	90	0	0	1	-360	360;
	630	451	0.00396	0.01276	0.00135	137	137	137	0	0	1	-360	360;
	624	652	0.00028	0.00179	0.01597	137	137	137	0	0	1	-360	360;
	682	653	0.00041	0.00264	0.0236	183	183	183	0	0	1	-360	360;
	614	642	0.00049	0.00313	0.02806	137	137	137	0	0	1	-360	360;
	578	412	0.03322	0.10785	0.01114	133	133	133	0	0	1	-360	360;
	721	444	0.01169	0.03841	0.00388	133	133	133	0	0	1	-360	360;
	370	721	0.00954	0.03133	0.00316	133	133	133	0	0	1	-360	360;
	568	721	0.00017	0.00033	3e-05	133	133	133	0	0	1	-360	360;
	505	429	0.0686	0.12	0.01149	90	90	90	0	0	1	-360	360;
	751	573	0.04174	0.07628	0.00695	90	90	90	0	0	1	-360	360;
	646	525	0.01372	0.03719	0.00363	120	120	120	0	0	1	-360	360;
	505	320	0.01777	0.03124	0.00297	90	90	90	0	0	1	-360	360;
	572	551	0.0324	0.09587	0.00967	90	90	90	0	0	1	-360	360;
	474	295	0.01504	0.03075	0.00298	90	90	90	0	0	1	-360	360;
	513	474	0.01182	0.01967	0.00207	90	90	90	0	0	1	-360	360;
	321	280	0.00917	0.02983	0.00307	133	133	133	0	0	1	-360	360;
	521	280	0.00785	0.02545	0.00262	133	133	133	0	0	1	-360	360;
	553	552	0.00636	0.02091	0.00212	133	133	133	0	0	1	-360	360;
	647	535	0.0224	0.03926	0.00372	90	90	90	0	0	1	-360	360;
	698	536	0.07868	0.13934	0.01292	90	90	90	0	0	1	-360	360;
	661	647	0.00595	0.01157	0.0011	90	90	90	0	0	1	-360	360;
	596	250	0.04719	0.08273	0.00785	90	90	90	0	0	1	-360	360;
	526	522	0.00496	0.01421	0.00145	120	120	120	0	0	1	-360	360;
	523	479	0.05926	0.19198	0.01974	133	133	133	0	0	1	-360	360;
	634	295	0.00289	0.00926	0.00096	133	133	133	0	0	1	-360	360;
	392	395	0.00504	0.00901	0.00084	90	90	90	0	0	1	-360	360;
	478	706	0.00397	0.01298	0.00132	133	133	133	0	0	1	-360	360;
	731	706	0.01702	0.05512	0.00542	133	133	133	0	0	1	-360	360;
	706	476	8e-05	0.00017	2e-05	133	133	133	0	0	1	-360	360;
	697	694	0.01107	0.01934	0.00184	90	90	90	0	0	1	-360	360;
	586	367	0.00942	0.03041	0.00315	133	133	133	0	0	1	-360	360;
	518	433	0.06091	0.10124	0.01098	90	90	90	0	0	1	-360	360;
	705	478	0.00678	0.01446	0.00132	90	90	90	0	0	1	-360	360;
	518	705	0.00653	0.01207	0.00129	90	90	90	0	0	1	-360	360;
	705	475	0.00017	0.00025	2e-05	90	90	90	0	0	1	-360	360;
	479	477	0.03967	0.1286	0.01323	133	133	133	0	0	1	-360	360;
	477	419	0.02314	0.05587	0.00629	120	120	120	0	0	1	-360	360;
	698	420	0.05322	0.13512	0.01374	120	120	120	0	0	1	-360	360;
	619	420	0.03942	0.12769	0.01323	133	133	133	0	0	1	-360	360;
	394	467	0.02017	0.06405	0.00675	133	133	133	0	0	1	-360	360;
	483	269	0.03529	0.10818	0.011	90	90	90	0	0	1	-360	360;
	335	522	0.00331	0.01091	0.0011	133	133	133	0	0	1	-360	360;
	335	521	0.00347	0.01132	0.00117	133	133	133	0	0	1	-360	360;
	699	251	0.03909	0.06843	0.00649	90	90	90	0	0	1	-360	360;
	700	616	0.00574	0.01668	0.00177	120	120	120	0	0	1	-360	360;
	662	595	0.03289	0.05744	0.00521	90	90	90	0	0	1	-360	360;
	557	296	0.01165	0.04298	0.0039	90	90	90	0	0	1	-360	360;
	367	354	0.00901	0.02917	0.00302	133	133	133	0	0	1	-360	360;
	714	430	0.01522	0.08255	0.00509	133	133	133	0	0	1	-360	360;
	444	714	0.00791	0.02572	0.00265	133	133	133	0	0	1	-360	360;
	424	714	0.00339	0.00603	0.00054	133	133	133	0	0	1	-360	360;
	720	370	0.00542	0.01753	0.00181	133	133	133	0	0	1	-360	360;
	552	720	0.00631	0.0204	0.00211	133	133	133	0	0	1	-360	360;
	549	720	0.00256	0.00463	0.00041	133	133	133	0	0	1	-360	360;
	634	394	0.00694	0.02256	0.00234	90	90	90	0	0	1	-360	360;
	617	295	0.00355	0.0114	0.00118	133	133	133	0	0	1	-360	360;
	554	553	0.00636	0.02074	0.00214	133	133	133	0	0	1	-360	360;
	395	393	0.00694	0.02281	0.0023	133	133	133	0	0	1	-360	360;
	731	489	0.01975	0.06479	0.00655	133	133	133	0	0	1	-360	360;
	694	489	0.03116	0.08463	0.00843	90	90	90	0	0	1	-360	360;
	751	619	0.00537	0.01752	0.00177	133	133	133	0	0	1	-360	360;
	307	478	0.01678	0.05661	0.00575	133	133	133	0	0	1	-360	360;
	454	307	0.02686	0.0881	0.0089	133	133	133	0	0	1	-360	360;
	429	585	0.02727	0.07157	0.00743	133	133	133	0	0	1	-360	360;
	617	365	0.01372	0.04471	0.0046	133	133	133	0	0	1	-360	360;
	513	466	0.00545	0.01752	0.00183	133	133	133	0	0	1	-360	360;
	368	498	0.00607	0.01757	0.00407	90	90	90	0	0	1	-360	360;
	558	498	0.01061	0.03423	0.00363	111	111	111	0	0	1	-360	360;
	353	481	0.0057	0.01851	0.00193	133	133	133	0	0	1	-360	360;
	316	554	0.00012	0.00052	0.00318	133	133	133	0	0	1	-360	360;
	401	388	0.00223	0.00727	0.00073	120	120	120	0	0	1	-360	360;
	387	347	0.00306	0.00959	0.001	120	120	120	0	0	1	-360	360;
	398	381	0.00579	0.01661	0.00179	120	120	120	0	0	1	-360	360;
	534	347	0.01802	0.04636	0.0047	120	120	120	0	0	1	-360	360;
	633	348	0.00463	0.01488	0.00145	120	120	120	0	0	1	-360	360;
	411	347	0.00711	0.02273	0.00242	140	140	140	0	0	1	-360	360;
	380	704	0.00107	0.00281	0.00033	120	120	120	0	0	1	-360	360;
	385	704	0.00992	0.02636	0.00299	120	120	120	0	0	1	-360	360;
	704	304	0.00066	0.00174	0.00016	120	120	120	0	0	1	-360	360;
	591	385	0.00463	0.01388	0.00167	120	120	120	0	0	1	-360	360;
	382	386	0.00372	0.0119	0.00125	120	120	120	0	0	1	-360	360;
	727	384	0.00058	0.00198	0.00021	140	140	140	0	0	1	-360	360;
	382	727	0.00306	0.00992	0.00104	140	140	140	0	0	1	-360	360;
	727	750	0.0005	0.00165	0.00017	120	120	120	0	0	1	-360	360;
	737	384	0.00529	0.01645	0.00189	120	120	120	0	0	1	-360	360;
	726	408	0.00736	0.02388	0.00248	140	140	140	0	0	1	-360	360;
	374	726	0.00215	0.00645	0.00078	120	120	120	0	0	1	-360	360;
	737	726	0.00562	0.01818	0.0019	140	140	140	0	0	1	-360	360;
	718	383	0.00488	0.0124	0.00121	120	120	120	0	0	1	-360	360;
	718	485	0.00595	0.01793	0.00216	140	140	140	0	0	1	-360	360;
	545	718	0.00033	0.00099	0.0001	140	140	140	0	0	1	-360	360;
	738	591	0.00405	0.01298	0.00134	120	120	120	0	0	1	-360	360;
	737	546	0.00752	0.02264	0.0027	140	140	140	0	0	1	-360	360;
	485	287	0.01388	0.03628	0.00396	120	120	120	0	0	1	-360	360;
	388	287	0.01661	0.04702	0.00505	120	120	120	0	0	1	-360	360;
	402	383	0.00504	0.01612	0.0017	120	120	120	0	0	1	-360	360;
	418	348	0.01058	0.02802	0.00316	120	120	120	0	0	1	-360	360;
	711	383	0.00264	0.0086	0.0009	140	140	140	0	0	1	-360	360;
	408	711	8e-05	0.00033	4e-05	140	140	140	0	0	1	-360	360;
	711	403	0.00024	0.00769	0.00078	140	140	140	0	0	1	-360	360;
	418	380	0.00339	0.01124	0.00111	120	120	120	0	0	1	-360	360;
	386	374	0.00223	0.00678	0.00082	120	120	120	0	0	1	-360	360;
	579	327	0.01066	0.03231	0.00383	120	120	120	0	0	1	-360	360;
	546	579	0.01579	0.04785	0.00568	120	120	120	0	0	1	-360	360;
	387	381	0.0057	0.01372	0.00155	120	120	120	0	0	1	-360	360;
	278	737	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	359	347	0.01876	0.05198	0.00571	120	120	120	0	0	1	-360	360;
	484	359	0.01711	0.04669	0.00509	120	120	120	0	0	1	-360	360;
	484	435	0.00339	0.01017	0.00123	120	120	120	0	0	1	-360	360;
	279	738	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	275	348	0.01446	0.04802	0.00469	140	140	140	0	0	1	-360	360;
	411	399	0.00769	0.02471	0.00261	120	120	120	0	0	1	-360	360;
	387	399	0.00504	0.0162	0.0017	120	120	120	0	0	1	-360	360;
	527	435	0.00479	0.01446	0.00175	120	120	120	0	0	1	-360	360;
	576	485	0.00785	0.02537	0.00267	120	120	120	0	0	1	-360	360;
	576	401	0.00909	0.03058	0.00315	120	120	120	0	0	1	-360	360;
	484	398	0.01281	0.04116	0.00434	120	120	120	0	0	1	-360	360;
	379	484	0.00612	0.01975	0.00208	120	120	120	0	0	1	-360	360;
	369	484	0.01198	0.0386	0.00406	120	120	120	0	0	1	-360	360;
	369	379	0.00562	0.0181	0.00191	120	120	120	0	0	1	-360	360;
	738	482	0.0238	0.07215	0.00855	120	120	120	0	0	1	-360	360;
	633	388	0.00388	0.01256	0.00132	120	120	120	0	0	1	-360	360;
	737	534	0.00496	0.01496	0.00177	120	120	120	0	0	1	-360	360;
	375	738	0.00504	0.01521	0.00181	120	120	120	0	0	1	-360	360;
	598	660	0.01628	0.05397	0.00529	133	133	133	0	0	1	-360	360;
	717	326	0.02521	0.08223	0.00841	133	133	133	0	0	1	-360	360;
	543	717	0.00149	0.00471	0.00049	133	133	133	0	0	1	-360	360;
	717	529	0.01702	0.03058	0.00276	90	90	90	0	0	1	-360	360;
	512	501	0.00843	0.0214	0.00218	120	120	120	0	0	1	-360	360;
	593	571	0.0195	0.03545	0.00353	133	133	133	0	0	1	-360	360;
	753	263	0.01361	0.02471	0.00246	133	133	133	0	0	1	-360	360;
	754	445	0.02264	0.03769	0.00397	90	90	90	0	0	1	-360	360;
	736	410	0.01413	0.04653	0.0047	133	133	133	0	0	1	-360	360;
	356	285	0.0044	0.03039	0.00342	232	232	232	0	0	1	-360	360;
	740	574	0.01653	0.05388	0.0055	133	133	133	0	0	1	-360	360;
	736	550	0.01785	0.03273	0.00346	133	133	133	0	0	1	-360	360;
	550	517	0.03033	0.07331	0.00825	133	133	133	0	0	1	-360	360;
	490	517	0.00719	0.01256	0.0012	90	90	90	0	0	1	-360	360;
	735	373	0.01711	0.04364	0.00444	120	120	120	0	0	1	-360	360;
	547	373	0.03124	0.07942	0.00808	120	120	120	0	0	1	-360	360;
	601	559	0.01	0.02628	0.00267	120	120	120	0	0	1	-360	360;
	559	547	0.02802	0.06182	0.00747	120	120	120	0	0	1	-360	360;
	468	361	0.00413	0.01347	0.00139	133	133	133	0	0	1	-360	360;
	472	598	0.02595	0.08512	0.0086	133	133	133	0	0	1	-360	360;
	560	468	0.04041	0.13264	0.01339	133	133	133	0	0	1	-360	360;
	618	561	0.00256	0.00843	0.00087	133	133	133	0	0	1	-360	360;
	350	574	0.01413	0.03727	0.004	90	90	90	0	0	1	-360	360;
	544	597	0.00711	0.01248	0.00119	90	90	90	0	0	1	-360	360;
	599	544	0.00579	0.01174	0.00114	90	90	90	0	0	1	-360	360;
	600	598	0.0105	0.02447	0.00217	90	90	90	0	0	1	-360	360;
	570	406	0.05455	0.09471	0.00914	90	90	90	0	0	1	-360	360;
	531	469	0.06058	0.10603	0.01006	90	90	90	0	0	1	-360	360;
	543	537	0.00273	0.00785	0.00079	133	133	133	0	0	1	-360	360;
	597	270	0.01198	0.03893	0.00402	133	133	133	0	0	1	-360	360;
	723	501	0.01074	0.03479	0.00359	133	133	133	0	0	1	-360	360;
	723	270	0.00983	0.03198	0.0033	133	133	133	0	0	1	-360	360;
	581	723	0.00785	0.0257	0.00248	133	133	133	0	0	1	-360	360;
	631	602	0.01298	0.04215	0.00436	133	133	133	0	0	1	-360	360;
	298	601	0.00471	0.01529	0.00159	90	90	90	0	0	1	-360	360;
	299	602	0.00744	0.01554	0.00151	90	90	90	0	0	1	-360	360;
	300	601	0.00843	0.01744	0.00169	90	90	90	0	0	1	-360	360;
	301	602	0.00826	0.01719	0.00166	90	90	90	0	0	1	-360	360;
	601	306	0.00314	0.00942	0.00096	120	120	120	0	0	1	-360	360;
	541	487	0.00355	0.02421	0.00271	232	232	232	0	0	1	-360	360;
	486	281	0.01372	0.04446	0.00461	133	133	133	0	0	1	-360	360;
	542	332	0.00164	0.01112	0.00134	232	232	232	0	0	1	-360	360;
	487	252	0.01967	0.0638	0.0066	133	133	133	0	0	1	-360	360;
	283	472	0.00355	0.01157	0.00121	133	133	133	0	0	1	-360	360;
	497	453	0.02868	0.09314	0.00962	133	133	133	0	0	1	-360	360;
	281	253	0.00686	0.02215	0.00229	133	133	133	0	0	1	-360	360;
	512	252	0.02231	0.07248	0.0075	133	133	133	0	0	1	-360	360;
	748	531	0.01471	0.04769	0.00493	133	133	133	0	0	1	-360	360;
	748	548	0.0195	0.06331	0.00654	133	133	133	0	0	1	-360	360;
	742	253	0.02058	0.06694	0.00691	133	133	133	0	0	1	-360	360;
	446	344	0.00851	0.02793	0.00285	133	133	133	0	0	1	-360	360;
	503	500	0.00488	0.01587	0.00164	133	133	133	0	0	1	-360	360;
	570	277	0.00843	0.02769	0.00279	133	133	133	0	0	1	-360	360;
	503	486	0.03529	0.13702	0.01374	133	133	133	0	0	1	-360	360;
	378	599	0.0243	0.07893	0.00815	133	133	133	0	0	1	-360	360;
	487	332	0.00182	0.01273	0.00142	232	232	232	0	0	1	-360	360;
	486	333	0.00174	0.01207	0.00134	232	232	232	0	0	1	-360	360;
	284	308	0.00788	0.05315	0.00589	232	232	232	0	0	1	-360	360;
	541	309	0.00107	0.00719	0.00094	232	232	232	0	0	1	-360	360;
	355	333	0.00256	0.02273	0.00199	232	232	232	0	0	1	-360	360;
	487	325	0.0195	0.06314	0.00654	133	133	133	0	0	1	-360	360;
	276	618	0.0357	0.11719	0.01184	133	133	133	0	0	1	-360	360;
	268	349	0.0443	0.09347	0.00876	90	90	90	0	0	1	-360	360;
	648	602	0.01893	0.06248	0.01932	133	133	133	0	0	1	-360	360;
	415	407	0.01099	0.02322	0.00218	90	90	90	0	0	1	-360	360;
	735	740	0.01215	0.03934	0.00405	133	133	133	0	0	1	-360	360;
	282	453	0.02909	0.09438	0.00976	133	133	133	0	0	1	-360	360;
	264	592	0.03183	0.05769	0.00576	133	133	133	0	0	1	-360	360;
	589	497	0.01983	0.06438	0.00665	133	133	133	0	0	1	-360	360;
	734	649	0.02421	0.07934	0.00803	133	133	133	0	0	1	-360	360;
	734	349	0.02223	0.07281	0.00735	133	133	133	0	0	1	-360	360;
	500	660	0.01289	0.04289	0.0042	133	133	133	0	0	1	-360	360;
	360	344	0.03273	0.0719	0.00681	83	83	83	0	0	1	-360	360;
	494	506	0.00835	0.0262	0.00292	90	90	90	0	0	1	-360	360;
	492	488	0.0076	0.02545	0.00249	133	133	133	0	0	1	-360	360;
	493	455	0.01182	0.03	0.00305	120	120	120	0	0	1	-360	360;
	510	456	0.0162	0.05405	0.00527	133	133	133	0	0	1	-360	360;
	507	336	0.01992	0.06438	0.00667	133	133	133	0	0	1	-360	360;
	710	371	0.01066	0.01868	0.00186	133	133	133	0	0	1	-360	360;
	710	336	0.01587	0.05388	0.00533	133	133	133	0	0	1	-360	360;
	710	565	0.01074	0.03496	0.00361	133	133	133	0	0	1	-360	360;
	390	372	0.02702	0.08744	0.00905	133	133	133	0	0	1	-360	360;
	331	289	0.01909	0.06273	0.00634	133	133	133	0	0	1	-360	360;
	471	331	0.01975	0.06496	0.00656	133	133	133	0	0	1	-360	360;
	575	509	0.02504	0.08223	0.00831	133	133	133	0	0	1	-360	360;
	272	575	0.0076	0.02298	0.00272	133	133	133	0	0	1	-360	360;
	493	319	0.02314	0.07413	0.00785	133	133	133	0	0	1	-360	360;
	532	462	0.03884	0.1276	0.01288	133	133	133	0	0	1	-360	360;
	722	488	0.01835	0.06025	0.00608	133	133	133	0	0	1	-360	360;
	722	516	0.03033	0.09967	0.01006	133	133	133	0	0	1	-360	360;
	580	722	0.00182	0.00603	0.00059	133	133	133	0	0	1	-360	360;
	566	372	0.00975	0.0295	0.00355	133	133	133	0	0	1	-360	360;
	752	371	0.03678	0.0638	0.00623	90	90	90	0	0	1	-360	360;
	594	302	0.0214	0.07157	0.00699	133	133	133	0	0	1	-360	360;
	514	491	0.00198	0.0062	0.00069	133	133	133	0	0	1	-360	360;
	530	491	0.00562	0.01711	0.0018	90	90	90	0	0	1	-360	360;
	337	493	0.00306	0.01	0.00103	133	133	133	0	0	1	-360	360;
	492	458	0.00959	0.03099	0.0032	133	133	133	0	0	1	-360	360;
	509	457	0.01066	0.03463	0.00358	133	133	133	0	0	1	-360	360;
	504	448	0.0043	0.01298	0.00157	133	133	133	0	0	1	-360	360;
	461	288	0.08909	0.17595	0.01535	90	90	90	0	0	1	-360	360;
	749	302	0.03124	0.10421	0.01018	133	133	133	0	0	1	-360	360;
	530	506	0.00479	0.01603	0.00156	133	133	133	0	0	1	-360	360;
	463	703	0.00917	0.03	0.00303	133	133	133	0	0	1	-360	360;
	703	289	0.00678	0.02215	0.00224	133	133	133	0	0	1	-360	360;
	286	703	1e-05	8e-05	0	133	133	133	0	0	1	-360	360;
	372	366	0.01661	0.04298	0.00429	120	120	120	0	0	1	-360	360;
	510	447	0.01132	0.03777	0.00369	133	133	133	0	0	1	-360	360;
	509	493	0.01289	0.04116	0.00443	133	133	133	0	0	1	-360	360;
	533	509	0.04397	0.14529	0.01447	133	133	133	0	0	1	-360	360;
	510	491	0.02455	0.0743	0.00772	120	120	120	0	0	1	-360	360;
	594	417	0.02165	0.0724	0.00706	133	133	133	0	0	1	-360	360;
	669	338	0.04405	0.13372	0.01585	133	133	133	0	0	1	-360	360;
	434	471	0.01826	0.03157	0.00307	90	90	90	0	0	1	-360	360;
	588	319	0.0205	0.06694	0.00684	133	133	133	0	0	1	-360	360;
	749	272	0.03339	0.10124	0.01199	133	133	133	0	0	1	-360	360;
	514	504	0.00273	0.00818	0.00099	133	133	133	0	0	1	-360	360;
	259	254	0.00694	0.02256	0.00231	140	140	140	0	0	1	-360	360;
	274	460	0.05992	0.11628	0.01298	90	90	90	0	0	1	-360	360;
	274	245	0.10041	0.17736	0.01665	90	90	90	0	0	1	-360	360;
	317	260	0.00554	0.01802	0.00167	120	120	120	0	0	1	-360	360;
	339	274	0.05198	0.09	0.00889	69	69	69	0	0	1	-360	360;
	351	261	0.02893	0.08719	0.0105	140	140	140	0	0	1	-360	360;
	637	351	0.03033	0.09124	0.01099	140	140	140	0	0	1	-360	360;
	707	323	0.00635	0.01952	0.00235	140	140	140	0	0	1	-360	360;
	707	314	0.03736	0.06314	0.00687	107	107	107	0	0	1	-360	360;
	707	324	0.00026	0.0004	5e-05	140	140	140	0	0	1	-360	360;
	733	405	0.02694	0.0819	0.0097	140	140	140	0	0	1	-360	360;
	465	400	0.02	0.0338	0.00368	90	90	90	0	0	1	-360	360;
	273	363	0.02702	0.08215	0.00973	140	140	140	0	0	1	-360	360;
	470	312	0.04992	0.08967	0.00898	140	140	140	0	0	1	-360	360;
	587	313	0.00785	0.02388	0.00284	140	140	140	0	0	1	-360	360;
	583	246	0.01102	0.03212	0.00397	140	140	140	0	0	1	-360	360;
	724	260	0.01549	0.03483	0.00343	90	90	90	0	0	1	-360	360;
	293	724	0.02848	0.05104	0.00475	90	90	90	0	0	1	-360	360;
	607	724	0.0002	0.00067	7e-05	140	140	140	0	0	1	-360	360;
	508	294	0.0081	0.01413	0.00135	90	90	90	0	0	1	-360	360;
	297	247	0.07934	0.13074	0.01414	90	90	90	0	0	1	-360	360;
	352	404	0.00397	0.01215	0.00138	140	140	140	0	0	1	-360	360;
	314	311	0.02207	0.04273	0.00416	90	90	90	0	0	1	-360	360;
	562	508	0.03653	0.06372	0.00608	90	90	90	0	0	1	-360	360;
	261	254	0.00264	0.00851	0.00088	140	140	140	0	0	1	-360	360;
	732	696	0.0395	0.06909	0.00656	90	90	90	0	0	1	-360	360;
	696	376	0.03537	0.10331	0.00917	120	120	120	0	0	1	-360	360;
	584	540	0.01975	0.03736	0.00401	90	90	90	0	0	1	-360	360;
	695	313	0.03165	0.09537	0.01148	140	140	140	0	0	1	-360	360;
	502	464	0.04066	0.07066	0.00682	69	69	69	0	0	1	-360	360;
	587	246	0.0414	0.1257	0.01489	140	140	140	0	0	1	-360	360;
	480	438	0.0157	0.04736	0.0057	140	140	140	0	0	1	-360	360;
	364	261	0.02802	0.08446	0.01016	140	140	140	0	0	1	-360	360;
	258	257	0.00347	0.01033	0.00125	140	140	140	0	0	1	-360	360;
	328	318	0.02678	0.0805	0.0097	140	140	140	0	0	1	-360	360;
	567	245	0.0386	0.08364	0.00735	90	90	90	0	0	1	-360	360;
	261	256	0.01157	0.03587	0.00404	140	140	140	0	0	1	-360	360;
	341	318	0.01909	0.06198	0.00644	140	140	140	0	0	1	-360	360;
	470	341	0.06769	0.11901	0.01104	90	90	90	0	0	1	-360	360;
	556	340	0.06107	0.10165	0.01102	90	90	90	0	0	1	-360	360;
	405	400	0.00612	0.0124	0.00117	90	90	90	0	0	1	-360	360;
	628	328	0.05099	0.16893	0.0166	140	140	140	0	0	1	-360	360;
	502	363	0.03124	0.09496	0.01125	140	140	140	0	0	1	-360	360;
	696	291	0.02917	0.07438	0.00774	91	91	91	0	0	1	-360	360;
	317	258	0.00711	0.02256	0.00224	120	120	120	0	0	1	-360	360;
	563	297	0.0576	0.10058	0.0096	90	90	90	0	0	1	-360	360;
	438	364	0.02165	0.04008	0.00386	107	107	107	0	0	1	-360	360;
	322	695	0.01868	0.06198	0.00608	140	140	140	0	0	1	-360	360;
	323	480	0.02678	0.08058	0.0097	140	140	140	0	0	1	-360	360;
	340	540	0.0043	0.01388	0.00144	140	140	140	0	0	1	-360	360;
	423	254	0.03942	0.12033	0.01413	140	140	140	0	0	1	-360	360;
	608	254	0.00818	0.02545	0.00289	140	140	140	0	0	1	-360	360;
	391	339	0.04339	0.07157	0.00774	69	69	69	0	0	1	-360	360;
	391	423	0.01826	0.05537	0.00656	140	140	140	0	0	1	-360	360;
	628	322	0.03446	0.11364	0.01127	140	140	140	0	0	1	-360	360;
	290	696	0.02959	0.09727	0.00971	140	140	140	0	0	1	-360	360;
	459	376	0.02868	0.08818	0.00783	120	120	120	0	0	1	-360	360;
	459	260	0.02545	0.08099	0.00735	120	120	120	0	0	1	-360	360;
	257	459	0.01091	0.04223	0.00465	140	140	140	0	0	1	-360	360;
	255	460	0.01818	0.06595	0.00707	140	140	140	0	0	1	-360	360;
	460	256	0.01926	0.05876	0.00555	140	140	140	0	0	1	-360	360;
	314	273	0.02793	0.08496	0.01006	140	140	140	0	0	1	-360	360;
	637	352	0.02364	0.07149	0.00851	140	140	140	0	0	1	-360	360;
	255	259	0.00223	0.00752	0.00076	140	140	140	0	0	1	-360	360;
	584	582	0.02957	0.08621	0.01064	140	140	140	0	0	1	-360	360;
	719	308	0.00098	0.00423	0.02594	95	95	95	0	0	1	-360	360;
	719	357	0.01639	0.0344	0.02258	77	77	77	0	0	1	-360	360;
	719	334	0.00017	0.00074	0.00757	95	95	95	0	0	1	-360	360;
	358	487	0.01545	0.03008	0.00257	77	77	77	0	0	1	-360	360;
	271	309	0.00165	0.00744	0.10672	95	95	95	0	0	1	-360	360;
	739	357	0.00298	0.0105	0.06292	95	95	95	0	0	1	-360	360;
	774	1050	0.03628	0.09421	0.00974	117	117	117	0	0	1	-360	360;
	991	798	0.03041	0.09893	0.01014	137	137	137	0	0	1	-360	360;
	960	758	0.02678	0.08653	0.00885	120	120	120	0	0	1	-360	360;
	1046	775	0.02256	0.07289	0.00746	120	120	120	0	0	1	-360	360;
	914	766	0.08678	0.14975	0.01423	76	76	76	0	0	1	-360	360;
	981	922	0.07207	0.1381	0.01321	90	90	90	0	0	1	-360	360;
	931	923	0.05	0.10909	0.0107	90	90	90	0	0	1	-360	360;
	806	803	0.01124	0.02777	0.00276	90	90	90	0	0	1	-360	360;
	923	921	0.01636	0.05306	0.00542	137	137	137	0	0	1	-360	360;
	916	789	0.04116	0.13289	0.01359	137	137	137	0	0	1	-360	360;
	930	922	0.02306	0.07157	0.00818	168	168	168	0	0	1	-360	360;
	930	923	0.02306	0.07157	0.00818	168	168	168	0	0	1	-360	360;
	946	865	0.02017	0.06529	0.0067	137	137	137	0	0	1	-360	360;
	993	773	0.04893	0.12777	0.01321	120	120	120	0	0	1	-360	360;
	796	762	0.03198	0.10347	0.01058	69	69	69	0	0	1	-360	360;
	884	1026	0.03917	0.12669	0.01296	120	120	120	0	0	1	-360	360;
	990	796	0.03851	0.12463	0.01275	69	69	69	0	0	1	-360	360;
	1045	819	0.0614	0.1986	0.02032	137	137	137	0	0	1	-360	360;
	941	940	0.00372	0.00884	0.00067	120	120	120	0	0	1	-360	360;
	941	793	0.04843	0.08438	0.00809	91	91	91	0	0	1	-360	360;
	986	755	0.01207	0.03893	0.00402	120	120	120	0	0	1	-360	360;
	972	793	0.0376	0.06554	0.00624	109	109	109	0	0	1	-360	360;
	941	843	0.01075	0.0282	0.00291	109	109	109	0	0	1	-360	360;
	911	843	0.0127	0.03297	0.00341	109	109	109	0	0	1	-360	360;
	943	911	0.03485	0.07019	0.00683	109	109	109	0	0	1	-360	360;
	760	943	0.01421	0.04603	0.00471	137	137	137	0	0	1	-360	360;
	891	756	0.00562	0.00992	0.00092	76	76	76	0	0	1	-360	360;
	891	886	0.00446	0.00793	0.00075	76	76	76	0	0	1	-360	360;
	890	886	0.00256	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	1032	890	0.01306	0.02165	0.00208	109	109	109	0	0	1	-360	360;
	1032	755	0.01174	0.02025	0.00195	120	120	120	0	0	1	-360	360;
	779	755	0.02562	0.08281	0.00847	120	120	120	0	0	1	-360	360;
	779	776	0.02934	0.09479	0.0097	120	120	120	0	0	1	-360	360;
	984	882	0.01372	0.05686	0.00567	137	137	137	0	0	1	-360	360;
	986	984	0.00298	0.00959	0.00099	137	137	137	0	0	1	-360	360;
	986	758	0.01884	0.06099	0.00624	120	120	120	0	0	1	-360	360;
	1003	758	0.02512	0.08107	0.0083	120	120	120	0	0	1	-360	360;
	1003	763	0.00413	0.01322	0.00136	120	120	120	0	0	1	-360	360;
	883	868	0.02314	0.06628	0.00678	120	120	120	0	0	1	-360	360;
	868	763	0.00777	0.02512	0.00257	120	120	120	0	0	1	-360	360;
	916	763	0.00355	0.01157	0.0012	137	137	137	0	0	1	-360	360;
	877	882	0.01083	0.01917	0.0018	120	120	120	0	0	1	-360	360;
	892	877	0.00455	0.00802	0.00075	120	120	120	0	0	1	-360	360;
	876	875	0.00124	0.00397	0.00044	137	137	137	0	0	1	-360	360;
	888	875	0.00314	0.01025	0.00105	120	120	120	0	0	1	-360	360;
	883	871	0.03322	0.10752	0.011	120	120	120	0	0	1	-360	360;
	887	869	0.01364	0.04413	0.00452	120	120	120	0	0	1	-360	360;
	882	878	0.01339	0.02686	0.00257	109	109	109	0	0	1	-360	360;
	885	878	0.00463	0.01579	0.00161	120	120	120	0	0	1	-360	360;
	887	885	0.01264	0.04091	0.00418	120	120	120	0	0	1	-360	360;
	883	867	0.01967	0.06364	0.00651	120	120	120	0	0	1	-360	360;
	867	833	0.02826	0.0914	0.00934	120	120	120	0	0	1	-360	360;
	956	833	0.02182	0.07066	0.00723	120	120	120	0	0	1	-360	360;
	898	772	0.05835	0.09876	0.0106	109	109	109	0	0	1	-360	360;
	772	770	0.0057	0.0186	0.00189	120	120	120	0	0	1	-360	360;
	880	771	0.03322	0.10736	0.01099	120	120	120	0	0	1	-360	360;
	932	882	0.06372	0.20612	0.02108	120	120	120	0	0	1	-360	360;
	892	756	0.01372	0.04438	0.00454	120	120	120	0	0	1	-360	360;
	889	882	0.0038	0.0286	0.00273	183	183	183	0	0	1	-360	360;
	888	883	0.00231	0.02413	0.00373	183	183	183	0	0	1	-360	360;
	889	756	0.00413	0.03066	0.00293	137	137	137	0	0	1	-360	360;
	870	755	0.00397	0.01298	0.00133	120	120	120	0	0	1	-360	360;
	1027	770	0.03231	0.10438	0.01068	120	120	120	0	0	1	-360	360;
	1027	1026	0.04041	0.13058	0.01336	120	120	120	0	0	1	-360	360;
	870	756	0.00397	0.01281	0.00131	120	120	120	0	0	1	-360	360;
	871	869	0.01306	0.04207	0.00431	120	120	120	0	0	1	-360	360;
	918	775	0.03033	0.0981	0.01004	120	120	120	0	0	1	-360	360;
	1026	932	0.03793	0.12298	0.01258	120	120	120	0	0	1	-360	360;
	883	878	0.00959	0.03116	0.00318	137	137	137	0	0	1	-360	360;
	880	816	0.02636	0.08521	0.00871	120	120	120	0	0	1	-360	360;
	825	816	0.01917	0.06231	0.00637	120	120	120	0	0	1	-360	360;
	1027	825	0.03066	0.09909	0.01014	120	120	120	0	0	1	-360	360;
	816	771	0.03107	0.10041	0.01029	120	120	120	0	0	1	-360	360;
	941	829	0.01917	0.06198	0.00634	120	120	120	0	0	1	-360	360;
	760	756	0.02917	0.08074	0.00832	120	120	120	0	0	1	-360	360;
	942	943	0.00521	0.01694	0.00173	120	120	120	0	0	1	-360	360;
	918	942	0.01107	0.03579	0.00366	120	120	120	0	0	1	-360	360;
	804	882	0.02033	0.06562	0.00671	120	120	120	0	0	1	-360	360;
	774	940	0.00496	0.01339	0.00138	120	120	120	0	0	1	-360	360;
	876	892	0.00107	0.00802	0.00018	137	137	137	0	0	1	-360	360;
	835	775	0.00149	0.00446	0	137	137	137	0	0	1	-360	360;
	960	789	0.03116	0.05504	0.00515	90	90	90	0	0	1	-360	360;
	910	820	0.00512	0.0124	0.00123	69	69	69	0	0	1	-360	360;
	961	790	0.03215	0.05504	0.00515	76	76	76	0	0	1	-360	360;
	961	860	0.01901	0.05116	0.00528	120	120	120	0	0	1	-360	360;
	903	860	0.04579	0.12752	0.01314	120	120	120	0	0	1	-360	360;
	1014	902	0.02463	0.04488	0.00423	90	90	90	0	0	1	-360	360;
	1014	766	0.05818	0.10041	0.00954	90	90	90	0	0	1	-360	360;
	1047	902	0.01017	0.03298	0.00336	137	137	137	0	0	1	-360	360;
	1048	1041	0.00347	0.00901	0.00094	120	120	120	0	0	1	-360	360;
	1048	1047	0.00678	0.0219	0.00222	120	120	120	0	0	1	-360	360;
	1041	903	0.01496	0.04661	0.00475	76	76	76	0	0	1	-360	360;
	1042	1018	0.06347	0.1138	0.0107	90	90	90	0	0	1	-360	360;
	910	866	0.04455	0.14413	0.01475	69	69	69	0	0	1	-360	360;
	1045	903	0.06909	0.12273	0.01151	69	69	69	0	0	1	-360	360;
	789	1034	0.01738	0.03069	0.00288	69	69	69	0	0	1	-360	360;
	790	782	0.01669	0.02975	0.00279	90	90	90	0	0	1	-360	360;
	951	910	0.04463	0.07884	0.00738	69	69	69	0	0	1	-360	360;
	951	773	0.03843	0.10074	0.01041	120	120	120	0	0	1	-360	360;
	946	950	0.03769	0.1219	0.01247	137	137	137	0	0	1	-360	360;
	895	790	0.0557	0.0995	0.00934	76	76	76	0	0	1	-360	360;
	1029	895	0.04099	0.07364	0.00692	90	90	90	0	0	1	-360	360;
	790	784	0.00793	0.01893	0.00187	69	69	69	0	0	1	-360	360;
	789	787	0.00851	0.02785	0.00285	69	69	69	0	0	1	-360	360;
	792	787	0.00942	0.0305	0.00312	137	137	137	0	0	1	-360	360;
	792	784	0.00785	0.01835	0.0018	90	90	90	0	0	1	-360	360;
	1022	1017	0.02777	0.08975	0.00918	10	10	10	0	0	1	-360	360;
	820	826	0.01083	0.03789	0.00385	107	107	107	0	0	1	-360	360;
	826	991	0.02378	0.07688	0.00787	137	137	137	0	0	1	-360	360;
	767	766	0.00835	0.02702	0.00277	137	137	137	0	0	1	-360	360;
	1015	767	0.01843	0.0595	0.00608	137	137	137	0	0	1	-360	360;
	1029	884	0.02066	0.06686	0.00684	137	137	137	0	0	1	-360	360;
	809	1041	0.04876	0.15769	0.01613	76	76	76	0	0	1	-360	360;
	808	809	0.0105	0.03306	0.00338	120	120	120	0	0	1	-360	360;
	944	808	0.02661	0.08603	0.0088	120	120	120	0	0	1	-360	360;
	1021	944	0.01752	0.05678	0.00581	137	137	137	0	0	1	-360	360;
	1042	1021	0.03752	0.1214	0.01242	120	120	120	0	0	1	-360	360;
	1037	1042	0.04169	0.07362	0.0069	26	26	26	0	0	1	-360	360;
	827	1037	0.027	0.04768	0.00446	10	10	10	0	0	1	-360	360;
	949	950	0.0238	0.0538	0.0055	90	90	90	0	0	1	-360	360;
	945	949	0.01802	0.03182	0.00298	90	90	90	0	0	1	-360	360;
	952	945	0.00165	0.00537	0.00055	90	90	90	0	0	1	-360	360;
	951	952	0.01083	0.01917	0.0018	76	76	76	0	0	1	-360	360;
	899	950	0.01678	0.02959	0.00277	34	34	34	0	0	1	-360	360;
	899	951	0.01455	0.0257	0.00241	34	34	34	0	0	1	-360	360;
	1017	866	0.08306	0.14868	0.01396	90	90	90	0	0	1	-360	360;
	1018	1017	0.01413	0.02694	0.00257	90	90	90	0	0	1	-360	360;
	991	1015	0.02638	0.08531	0.00873	137	137	137	0	0	1	-360	360;
	782	1034	0.00021	0.00038	4e-05	69	69	69	0	0	1	-360	360;
	781	1034	0.01843	0.03331	0.00326	69	69	69	0	0	1	-360	360;
	1035	781	0.00026	0.00045	4e-05	69	69	69	0	0	1	-360	360;
	1035	782	0.0001	0.00017	2e-05	69	69	69	0	0	1	-360	360;
	1035	783	0.00148	0.00262	0.00024	69	69	69	0	0	1	-360	360;
	844	1037	3e-05	0.0001	1e-05	16	16	16	0	0	1	-360	360;
	815	761	0.03124	0.10107	0.01034	168	168	168	0	0	1	-360	360;
	992	874	0.03488	0.11281	0.01154	168	168	168	0	0	1	-360	360;
	874	872	0.00207	0.00661	0.00068	168	168	168	0	0	1	-360	360;
	982	872	0.01992	0.03711	0.00351	168	168	168	0	0	1	-360	360;
	1009	971	0.01719	0.0557	0.0057	168	168	168	0	0	1	-360	360;
	1008	914	0.01207	0.02074	0.00198	109	109	109	0	0	1	-360	360;
	981	1039	0.02938	0.06012	0.00579	109	109	109	0	0	1	-360	360;
	1008	1039	0.02938	0.06012	0.00579	109	109	109	0	0	1	-360	360;
	1013	1039	0.00133	0.00431	0.00044	109	109	109	0	0	1	-360	360;
	1009	805	0.04521	0.07926	0.0064	109	109	109	0	0	1	-360	360;
	805	799	0.01306	0.02455	0.00198	109	109	109	0	0	1	-360	360;
	931	799	0.04455	0.08926	0.00679	109	109	109	0	0	1	-360	360;
	798	971	0.02207	0.07124	0.00729	168	168	168	0	0	1	-360	360;
	894	893	0.00876	0.01455	0.00152	109	109	109	0	0	1	-360	360;
	1012	1008	0.01248	0.03438	0.00347	109	109	109	0	0	1	-360	360;
	919	828	0.0162	0.05223	0.00535	168	168	168	0	0	1	-360	360;
	828	785	0.01595	0.03174	0.00302	109	109	109	0	0	1	-360	360;
	894	785	0.01083	0.01909	0.00166	109	109	109	0	0	1	-360	360;
	894	786	0.01124	0.01975	0.00173	109	109	109	0	0	1	-360	360;
	976	973	0.02264	0.07314	0.00748	168	168	168	0	0	1	-360	360;
	1009	762	0.1362	0.23512	0.02235	109	109	109	0	0	1	-360	360;
	975	762	0.00612	0.01992	0.00204	168	168	168	0	0	1	-360	360;
	980	762	0.00463	0.01479	0.0016	168	168	168	0	0	1	-360	360;
	980	974	0.00744	0.02405	0.00247	168	168	168	0	0	1	-360	360;
	974	964	0.00322	0.0105	0.00109	168	168	168	0	0	1	-360	360;
	1040	976	0.02108	0.06817	0.00697	168	168	168	0	0	1	-360	360;
	977	831	0.00967	0.03149	0.00322	168	168	168	0	0	1	-360	360;
	912	831	0.04545	0.08091	0.00757	109	109	109	0	0	1	-360	360;
	912	786	0.02628	0.04694	0.0044	109	109	109	0	0	1	-360	360;
	948	894	0.01091	0.01926	0.0018	109	109	109	0	0	1	-360	360;
	934	806	0.03521	0.07645	0.00743	168	168	168	0	0	1	-360	360;
	999	935	0.0224	0.0724	0.00741	168	168	168	0	0	1	-360	360;
	935	904	0.02132	0.06595	0.00671	168	168	168	0	0	1	-360	360;
	904	786	0.07694	0.13256	0.01263	109	109	109	0	0	1	-360	360;
	988	762	0.03182	0.07959	0.00806	144	144	144	0	0	1	-360	360;
	988	965	0.00917	0.02289	0.00232	144	144	144	0	0	1	-360	360;
	1010	761	0.02355	0.07562	0.00782	168	168	168	0	0	1	-360	360;
	1010	855	0.02223	0.0714	0.00738	168	168	168	0	0	1	-360	360;
	852	759	0.02207	0.05917	0.00611	144	144	144	0	0	1	-360	360;
	989	759	0.02537	0.06736	0.00695	144	144	144	0	0	1	-360	360;
	873	989	0.01405	0.03645	0.00377	168	168	168	0	0	1	-360	360;
	854	807	0.02074	0.06702	0.00686	168	168	168	0	0	1	-360	360;
	801	807	0.00967	0.0262	0.00263	109	109	109	0	0	1	-360	360;
	913	801	0.0062	0.02	0.00204	109	109	109	0	0	1	-360	360;
	1016	785	0.01579	0.05107	0.00523	168	168	168	0	0	1	-360	360;
	979	959	0.00174	0.00562	0.00058	168	168	168	0	0	1	-360	360;
	1023	994	0.02058	0.03628	0.00339	168	168	168	0	0	1	-360	360;
	1043	1023	0.02802	0.0905	0.00924	109	109	109	0	0	1	-360	360;
	1043	989	0.00868	0.01537	0.00143	109	109	109	0	0	1	-360	360;
	977	761	0.03306	0.10686	0.01094	168	168	168	0	0	1	-360	360;
	1009	819	0.03298	0.10669	0.01091	168	168	168	0	0	1	-360	360;
	919	1012	0.02066	0.06678	0.00683	109	109	109	0	0	1	-360	360;
	1016	814	0.01479	0.04769	0.00488	168	168	168	0	0	1	-360	360;
	1019	814	0.00744	0.01314	0.00123	109	109	109	0	0	1	-360	360;
	1019	805	0.00826	0.01463	0.00137	109	109	109	0	0	1	-360	360;
	1005	989	0.00256	0.00818	0.00083	168	168	168	0	0	1	-360	360;
	893	786	0.00529	0.01686	0.00173	168	168	168	0	0	1	-360	360;
	977	865	0.03893	0.12595	0.01288	168	168	168	0	0	1	-360	360;
	925	948	0.02157	0.04744	0.00462	109	109	109	0	0	1	-360	360;
	925	934	0.02967	0.06636	0.00649	109	109	109	0	0	1	-360	360;
	865	815	0.00983	0.03182	0.00325	168	168	168	0	0	1	-360	360;
	977	959	0.02438	0.07802	0.00807	168	168	168	0	0	1	-360	360;
	964	959	0.01777	0.05736	0.00587	168	168	168	0	0	1	-360	360;
	999	806	0.00818	0.02645	0.00271	168	168	168	0	0	1	-360	360;
	852	780	0.0124	0.05413	0.00675	168	168	168	0	0	1	-360	360;
	1005	990	0.00636	0.02058	0.0021	168	168	168	0	0	1	-360	360;
	780	759	0.01793	0.05802	0.00593	168	168	168	0	0	1	-360	360;
	850	854	0.00149	0.00264	0.00025	109	109	109	0	0	1	-360	360;
	853	850	0.00058	0.0019	0.00019	168	168	168	0	0	1	-360	360;
	1046	1009	0.02868	0.09281	0.00949	109	109	109	0	0	1	-360	360;
	757	931	0.0157	0.05074	0.00519	168	168	168	0	0	1	-360	360;
	842	925	0.02132	0.06893	0.00705	168	168	168	0	0	1	-360	360;
	998	975	0.00818	0.02653	0.00271	168	168	168	0	0	1	-360	360;
	857	853	0.01149	0.02967	0.00301	109	109	109	0	0	1	-360	360;
	802	913	0.0062	0.02	0.00204	168	168	168	0	0	1	-360	360;
	921	842	0.0181	0.05851	0.00599	168	168	168	0	0	1	-360	360;
	851	857	0.0057	0.01603	0.00165	144	144	144	0	0	1	-360	360;
	993	873	0.01917	0.04983	0.00516	168	168	168	0	0	1	-360	360;
	992	976	0.02306	0.07463	0.00764	168	168	168	0	0	1	-360	360;
	982	798	0.00016	0.0005	5e-05	168	168	168	0	0	1	-360	360;
	765	913	0.03025	0.05931	0.00567	109	109	109	0	0	1	-360	360;
	851	817	0.01359	0.04394	0.0045	168	168	168	0	0	1	-360	360;
	1008	810	0.00107	0.00626	0.00059	120	120	120	0	0	1	-360	360;
	812	1036	0.00223	0.00678	0	120	120	120	0	0	1	-360	360;
	811	1036	0.00207	0.00612	0	120	120	120	0	0	1	-360	360;
	1009	811	0.00174	0.00564	0.00058	120	120	120	0	0	1	-360	360;
	907	934	0.04561	0.13862	0.01402	109	109	109	0	0	1	-360	360;
	904	908	0.01031	0.02002	0.00191	109	109	109	0	0	1	-360	360;
	907	908	0.00349	0.01126	0.00115	168	168	168	0	0	1	-360	360;
	823	854	0.00876	0.02636	0	137	137	137	0	0	1	-360	360;
	998	973	0.00372	0.0119	0.00121	168	168	168	0	0	1	-360	360;
	856	853	0.00033	0.00116	0	137	137	137	0	0	1	-360	360;
	963	913	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	881	865	0.00041	0.00126	0	137	137	137	0	0	1	-360	360;
	813	810	0.00099	0.00298	0	137	137	137	0	0	1	-360	360;
	979	1040	0.0064	0.02069	0.00212	168	168	168	0	0	1	-360	360;
	1050	966	0.0519	0.1314	0.01312	117	117	117	0	0	1	-360	360;
	969	967	0.01521	0.02562	0.00245	90	90	90	0	0	1	-360	360;
	969	968	0.00851	0.01438	0.00155	90	90	90	0	0	1	-360	360;
	968	939	0.02702	0.0876	0.009	137	137	137	0	0	1	-360	360;
	938	864	0.01851	0.06	0.00614	137	137	137	0	0	1	-360	360;
	864	847	0.01372	0.04446	0.00454	137	137	137	0	0	1	-360	360;
	966	957	0.02289	0.0519	0.00506	90	90	90	0	0	1	-360	360;
	970	957	0.02521	0.05744	0.00561	90	90	90	0	0	1	-360	360;
	970	962	0.00579	0.00992	0.00105	137	137	137	0	0	1	-360	360;
	824	794	0.01777	0.05736	0.00587	137	137	137	0	0	1	-360	360;
	847	794	0.02058	0.06612	0.00686	137	137	137	0	0	1	-360	360;
	966	788	0.00901	0.03107	0.00298	137	137	137	0	0	1	-360	360;
	947	788	0.02397	0.08322	0.00799	137	137	137	0	0	1	-360	360;
	958	947	0.02322	0.07521	0.0077	137	137	137	0	0	1	-360	360;
	1033	985	0.00884	0.01488	0.0015	90	90	90	0	0	1	-360	360;
	1000	966	0.05331	0.13339	0.01064	117	117	117	0	0	1	-360	360;
	967	818	0.04066	0.11116	0.01147	117	117	117	0	0	1	-360	360;
	1007	818	0.02777	0.07769	0.00801	117	117	117	0	0	1	-360	360;
	1007	1001	0.00289	0.00777	0.0008	117	117	117	0	0	1	-360	360;
	768	1001	0.04	0.06182	0.00676	90	90	90	0	0	1	-360	360;
	996	769	0.03826	0.06562	0.01263	90	90	90	0	0	1	-360	360;
	996	858	0.02893	0.04975	0.00953	90	90	90	0	0	1	-360	360;
	859	858	0.00413	0.00711	0.00137	90	90	90	0	0	1	-360	360;
	1001	922	0.06909	0.1238	0.01008	90	90	90	0	0	1	-360	360;
	1000	845	0.03992	0.06793	0.00543	90	90	90	0	0	1	-360	360;
	929	845	0.01281	0.02182	0.00175	90	90	90	0	0	1	-360	360;
	929	923	0.01322	0.0343	0.00329	90	90	90	0	0	1	-360	360;
	922	879	0.03132	0.1014	0.01038	137	137	137	0	0	1	-360	360;
	927	926	0.00033	0.00058	0.0242	274	274	274	0	0	1	-360	360;
	794	764	0.01628	0.05273	0.00541	137	137	137	0	0	1	-360	360;
	1024	846	0.03471	0.11256	0.01158	137	137	137	0	0	1	-360	360;
	1024	901	0.01512	0.05132	0.00251	137	137	137	0	0	1	-360	360;
	901	800	0.0295	0.05182	0.00488	137	137	137	0	0	1	-360	360;
	1011	768	0.01025	0.0181	0.0017	90	90	90	0	0	1	-360	360;
	1030	1011	0.03124	0.05512	0.00516	90	90	90	0	0	1	-360	360;
	1030	849	0.02446	0.04322	0.00405	90	90	90	0	0	1	-360	360;
	906	849	0.05736	0.10083	0.00949	90	90	90	0	0	1	-360	360;
	920	905	0.01364	0.07041	0.00728	137	137	137	0	0	1	-360	360;
	834	849	0.00306	0.00983	0.00101	137	137	137	0	0	1	-360	360;
	838	837	0.00446	0.01455	0.00148	137	137	137	0	0	1	-360	360;
	954	837	0.01405	0.04537	0.00465	137	137	137	0	0	1	-360	360;
	839	849	0.0076	0.02455	0.00252	137	137	137	0	0	1	-360	360;
	863	839	0.00446	0.01388	0.00143	137	137	137	0	0	1	-360	360;
	848	863	0.0057	0.01851	0.00189	137	137	137	0	0	1	-360	360;
	954	905	0.02198	0.06843	0.00702	137	137	137	0	0	1	-360	360;
	1028	955	0.0162	0.02843	0.00269	90	90	90	0	0	1	-360	360;
	1028	822	0.03917	0.06603	0.00396	90	90	90	0	0	1	-360	360;
	821	822	0.00959	0.02017	0.00196	90	90	90	0	0	1	-360	360;
	955	909	0.00967	0.03157	0.00322	137	137	137	0	0	1	-360	360;
	909	791	0.04777	0.09058	0.00862	90	90	90	0	0	1	-360	360;
	983	791	0.02273	0.04661	0.0045	90	90	90	0	0	1	-360	360;
	983	777	0.02463	0.05959	0.00496	90	90	90	0	0	1	-360	360;
	778	777	0.0057	0.01851	0.00189	90	90	90	0	0	1	-360	360;
	1050	879	0.04719	0.08521	0.00803	90	90	90	0	0	1	-360	360;
	957	953	0.00777	0.01686	0.00165	90	90	90	0	0	1	-360	360;
	978	967	0.01686	0.02983	0.00281	90	90	90	0	0	1	-360	360;
	978	953	0.00355	0.00628	0.00542	90	90	90	0	0	1	-360	360;
	1049	768	0.00587	0.01033	0.00097	90	90	90	0	0	1	-360	360;
	1049	995	0.0038	0.0124	0.00127	137	137	137	0	0	1	-360	360;
	995	933	0.00405	0.01298	0.00133	137	137	137	0	0	1	-360	360;
	958	795	0.00355	0.01157	0.00119	137	137	137	0	0	1	-360	360;
	1006	778	0.01777	0.0576	0.00589	90	90	90	0	0	1	-360	360;
	803	1006	0.01777	0.0576	0.00589	90	90	90	0	0	1	-360	360;
	937	777	0.02174	0.03835	0.00359	90	90	90	0	0	1	-360	360;
	937	1038	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360;
	1038	862	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360;
	900	764	0.02074	0.06727	0.00688	137	137	137	0	0	1	-360	360;
	861	859	0.00157	0.00306	0.00029	90	90	90	0	0	1	-360	360;
	985	967	0.03826	0.06752	0.00633	90	90	90	0	0	1	-360	360;
	1000	917	0.02488	0.07223	0.00824	137	137	137	0	0	1	-360	360;
	937	841	0.01521	0.04901	0.00502	137	137	137	0	0	1	-360	360;
	1033	997	0.00041	0.0119	0.00122	137	137	137	0	0	1	-360	360;
	933	997	0.00281	0.00901	0.00092	137	137	137	0	0	1	-360	360;
	955	830	0.02289	0.07413	0.00758	137	137	137	0	0	1	-360	360;
	938	939	0.01934	0.06264	0.00641	137	137	137	0	0	1	-360	360;
	838	834	0.00455	0.01471	0.0015	137	137	137	0	0	1	-360	360;
	821	987	0.03488	0.06488	0.00614	90	90	90	0	0	1	-360	360;
	962	824	0.02099	0.06785	0.00694	137	137	137	0	0	1	-360	360;
	830	848	0.01083	0.03512	0.00359	137	137	137	0	0	1	-360	360;
	797	1038	0.01917	0.05959	0.0061	137	137	137	0	0	1	-360	360;
	1007	936	0.004	0.01038	0.00107	117	117	117	0	0	1	-360	360;
	840	849	0.0023	0.00744	0.00076	137	137	137	0	0	1	-360	360;
	836	840	0.00144	0.00464	0.00047	137	137	137	0	0	1	-360	360;
	849	836	0.00184	0.00597	0.00061	137	137	137	0	0	1	-360	360;
	924	922	0.01074	0.03473	0.00355	137	137	137	0	0	1	-360	360;
	928	924	0.00223	0.00722	0.00074	137	137	137	0	0	1	-360	360;
	922	928	0.00328	0.0106	0.00108	137	137	137	0	0	1	-360	360;
	1025	966	0.0124	0.03603	0	137	137	137	0	0	1	-360	360;
	1044	1000	0.01818	0.05463	0	137	137	137	0	0	1	-360	360;
	1004	1000	0.00331	0.00992	0	137	137	137	0	0	1	-360	360;
	1002	1000	0.00058	0.00165	0	137	137	137	0	0	1	-360	360;
	896	905	0.00661	0.0181	0	137	137	137	0	0	1	-360	360;
	896	905	0.00661	0.01835	0	137	137	137	0	0	1	-360	360;
	915	954	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	915	954	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	1020	954	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	1020	954	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	832	846	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	2084	1498	0.02628	0.08298	0.00905	114	114	114	0	0	1	-360	360;
	1497	1498	0.00298	0.00967	0.001	114	114	114	0	0	1	-360	360;
	1197	1718	0.03612	0.05041	0.00829	57	57	57	0	0	1	-360	360;
	1196	1197	0	8e-05	1e-05	29	29	29	0	0	1	-360	360;
	1230	1199	0.0162	0.04917	0.00584	114	114	114	0	0	1	-360	360;
	1229	1230	0.00017	0.00025	4e-05	77	77	77	0	0	1	-360	360;
	1234	1587	0.01653	0.05041	0.00589	114	114	114	0	0	1	-360	360;
	1233	1234	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1363	1111	0.03868	0.10116	0.0108	99	99	99	0	0	1	-360	360;
	1828	1575	0.00537	0.01736	0.00181	114	114	114	0	0	1	-360	360;
	1112	1828	0.03909	0.09719	0.01033	99	99	99	0	0	1	-360	360;
	1827	1828	8e-05	0.00017	2e-05	97	97	97	0	0	1	-360	360;
	1554	1470	0.01595	0.04132	0.00403	99	99	99	0	0	1	-360	360;
	1943	1554	0.03174	0.08347	0.00816	99	99	99	0	0	1	-360	360;
	1552	1554	0.0005	0.00107	0.00014	29	29	29	0	0	1	-360	360;
	1555	1469	0.01595	0.0414	0.00404	99	99	99	0	0	1	-360	360;
	1944	1555	0.03174	0.08347	0.00816	99	99	99	0	0	1	-360	360;
	1553	1555	0.0005	0.00116	0.00014	29	29	29	0	0	1	-360	360;
	2110	1858	0.04826	0.12198	0.0129	99	99	99	0	0	1	-360	360;
	1857	1526	0.04017	0.10537	0.01188	99	99	99	0	0	1	-360	360;
	1227	1095	0.01165	0.03653	0.00401	114	114	114	0	0	1	-360	360;
	1226	1094	0.01165	0.03653	0.00401	114	114	114	0	0	1	-360	360;
	1438	1860	0.00273	0.00876	0.0009	114	114	114	0	0	1	-360	360;
	1578	1438	0.0076	0.02355	0.00263	114	114	114	0	0	1	-360	360;
	1437	1438	0.00033	0.00041	9e-05	77	77	77	0	0	1	-360	360;
	1109	1641	0.01818	0.04521	0.0048	102	102	102	0	0	1	-360	360;
	2085	1109	0.02603	0.06471	0.00687	102	102	102	0	0	1	-360	360;
	1489	1642	0.01736	0.04893	0.00504	102	102	102	0	0	1	-360	360;
	1784	1427	0.00686	0.02215	0.00232	114	114	114	0	0	1	-360	360;
	1269	1784	0.0043	0.01347	0.00147	114	114	114	0	0	1	-360	360;
	1578	1269	0.00579	0.01785	0.00204	114	114	114	0	0	1	-360	360;
	1783	1784	0.00603	0.01744	0.0023	114	114	114	0	0	1	-360	360;
	1269	1268	0.00231	0.00273	0.00058	77	77	77	0	0	1	-360	360;
	1937	1188	0.00504	0.01562	0.00173	114	114	114	0	0	1	-360	360;
	1580	1937	0.01025	0.03198	0.00354	114	114	114	0	0	1	-360	360;
	1937	1935	0.00521	0.00884	0.00089	72	72	72	0	0	1	-360	360;
	1938	1189	0.00504	0.01562	0.00173	114	114	114	0	0	1	-360	360;
	1580	1938	0.01025	0.03198	0.00354	114	114	114	0	0	1	-360	360;
	1938	1936	0.00521	0.00884	0.00089	72	72	72	0	0	1	-360	360;
	2110	1591	0.04017	0.06455	0.0076	77	77	77	0	0	1	-360	360;
	1902	1532	0.02256	0.05818	0.00621	102	102	102	0	0	1	-360	360;
	1901	2077	0.01876	0.04876	0.00519	102	102	102	0	0	1	-360	360;
	1546	1401	0.01463	0.04661	0.00496	114	114	114	0	0	1	-360	360;
	1818	1546	0.00628	0.02	0.00213	114	114	114	0	0	1	-360	360;
	1546	1544	0.00438	0.0086	0.00086	72	72	72	0	0	1	-360	360;
	1547	1142	0.00628	0.01983	0.00216	114	114	114	0	0	1	-360	360;
	1992	1547	0.00504	0.01537	0.00179	114	114	114	0	0	1	-360	360;
	1547	1545	0.00438	0.0086	0.00086	72	72	72	0	0	1	-360	360;
	1580	1051	0.01248	0.04595	0.00524	114	114	114	0	0	1	-360	360;
	1579	1052	0.01289	0.04669	0.00515	114	114	114	0	0	1	-360	360;
	1650	1220	0.00223	0.00826	0.00099	114	114	114	0	0	1	-360	360;
	1205	1221	0.00413	0.01587	0.00183	114	114	114	0	0	1	-360	360;
	1580	1205	0.00488	0.01678	0.00193	114	114	114	0	0	1	-360	360;
	1205	1204	0.00124	0.00421	0.00059	114	114	114	0	0	1	-360	360;
	1626	1454	0.00554	0.01702	0.00195	114	114	114	0	0	1	-360	360;
	1690	1564	0.04157	0.0581	0.01085	57	57	57	0	0	1	-360	360;
	1720	2005	0.00397	0.01124	0.00151	114	114	114	0	0	1	-360	360;
	1895	2089	0.01587	0.04496	0.00605	114	114	114	0	0	1	-360	360;
	1223	1895	0.02157	0.06124	0.00825	114	114	114	0	0	1	-360	360;
	1894	1895	0.0024	0.00686	0.00091	114	114	114	0	0	1	-360	360;
	1667	1997	0.0024	0.00744	0.00084	114	114	114	0	0	1	-360	360;
	1616	1518	0.0105	0.02983	0.00402	114	114	114	0	0	1	-360	360;
	1444	1677	0.02496	0.03802	0.00491	78	78	78	0	0	1	-360	360;
	1283	1203	0.01083	0.02364	0.00345	97	97	97	0	0	1	-360	360;
	1972	1728	0.00835	0.02339	0.0032	97	97	97	0	0	1	-360	360;
	1336	1659	0.02826	0.0924	0.00933	114	114	114	0	0	1	-360	360;
	1723	1659	0.03488	0.0881	0.01298	114	114	114	0	0	1	-360	360;
	1816	1538	0.00818	0.01364	0.00324	97	97	97	0	0	1	-360	360;
	1977	1175	0.02099	0.05934	0.00803	75	75	75	0	0	1	-360	360;
	1976	1559	0.03826	0.04818	0.00455	57	57	57	0	0	1	-360	360;
	1563	1470	0.02926	0.0514	0.00489	77	77	77	0	0	1	-360	360;
	2111	1217	0.01959	0.04818	0.00609	77	77	77	0	0	1	-360	360;
	1710	1492	0.02182	0.06149	0.00827	77	77	77	0	0	1	-360	360;
	1792	1492	0.03628	0.06727	0.00769	57	57	57	0	0	1	-360	360;
	2029	1227	0.01992	0.06157	0.00695	114	114	114	0	0	1	-360	360;
	1432	1226	0.00777	0.02397	0.00275	119	119	119	0	0	1	-360	360;
	1059	2030	0.0476	0.05091	0.00542	52	52	52	0	0	1	-360	360;
	1226	1916	0.05256	0.13264	0.01406	102	102	102	0	0	1	-360	360;
	2108	1153	0.03264	0.08	0.00928	102	102	102	0	0	1	-360	360;
	1089	1436	0.02372	0.03132	0.00624	90	90	90	0	0	1	-360	360;
	1396	1940	0.00835	0.02669	0.0028	119	119	119	0	0	1	-360	360;
	1228	1396	0.01992	0.06488	0.00659	114	114	114	0	0	1	-360	360;
	1395	1396	0.00099	0.00298	0.00039	114	114	114	0	0	1	-360	360;
	1916	1445	0.01355	0.03835	0.00516	114	114	114	0	0	1	-360	360;
	1429	1183	0.00537	0.01686	0.00187	114	114	114	0	0	1	-360	360;
	1714	1873	0.02025	0.06612	0.00668	114	114	114	0	0	1	-360	360;
	1964	2031	0.03727	0.12074	0.01246	114	114	114	0	0	1	-360	360;
	1965	1173	0.01876	0.05926	0.00642	114	114	114	0	0	1	-360	360;
	1778	1617	0.01587	0.05182	0.00527	114	114	114	0	0	1	-360	360;
	1430	1094	0.00678	0.02132	0.00234	114	114	114	0	0	1	-360	360;
	1422	1095	0.01529	0.04917	0.00517	114	114	114	0	0	1	-360	360;
	2090	1094	0.00686	0.02207	0.00229	114	114	114	0	0	1	-360	360;
	2091	1095	0.00686	0.02215	0.0023	114	114	114	0	0	1	-360	360;
	1975	2015	0.05306	0.2314	0.02446	114	114	114	0	0	1	-360	360;
	1293	2014	0.04909	0.21488	0.02272	114	114	114	0	0	1	-360	360;
	1768	1656	0.03438	0.11107	0.01156	114	114	114	0	0	1	-360	360;
	1342	1318	0.0005	0.00091	8e-05	78	78	78	0	0	1	-360	360;
	1346	1342	0.00413	0.00669	0.00073	78	78	78	0	0	1	-360	360;
	2084	1346	0.00413	0.00711	0.0007	78	78	78	0	0	1	-360	360;
	1340	1342	0.00116	0.00207	0.0002	57	57	57	0	0	1	-360	360;
	1344	1346	8e-05	0.00025	3e-05	119	119	119	0	0	1	-360	360;
	1198	1066	0.01736	0.04694	0.00667	102	102	102	0	0	1	-360	360;
	1485	1488	0.00661	0.01504	0.00192	76	76	76	0	0	1	-360	360;
	1592	1352	0.02661	0.03248	0.00676	78	78	78	0	0	1	-360	360;
	2084	1425	0.03165	0.05521	0.01258	102	102	102	0	0	1	-360	360;
	2085	1351	0.04545	0.05331	0.01145	78	78	78	0	0	1	-360	360;
	1465	1065	0.00298	0.00909	0.00104	114	114	114	0	0	1	-360	360;
	1736	1485	0.01347	0.04388	0.00447	114	114	114	0	0	1	-360	360;
	1114	1455	0.00818	0.02537	0.00287	114	114	114	0	0	1	-360	360;
	1504	1426	0.02041	0.03645	0.00807	102	102	102	0	0	1	-360	360;
	1838	1347	8e-05	0.00083	1e-05	78	78	78	0	0	1	-360	360;
	2085	1838	0.00653	0.01116	0.0011	78	78	78	0	0	1	-360	360;
	1838	1837	0.00017	0.00025	3e-05	78	78	78	0	0	1	-360	360;
	1345	1348	0.00256	0.00438	0.00044	78	78	78	0	0	1	-360	360;
	2084	1345	0.00405	0.00694	0.00069	77	77	77	0	0	1	-360	360;
	1343	1345	0.00074	0.00223	0.00029	76	76	76	0	0	1	-360	360;
	1341	1066	0.01091	0.02066	0.00319	78	78	78	0	0	1	-360	360;
	1317	1341	0.00041	0.00074	7e-05	78	78	78	0	0	1	-360	360;
	1339	1341	0.00124	0.00207	0.00021	57	57	57	0	0	1	-360	360;
	2143	1065	0.00455	0.00802	0.00081	78	78	78	0	0	1	-360	360;
	2144	1066	0.00455	0.00802	0.00081	78	78	78	0	0	1	-360	360;
	1904	1065	0.00413	0.01058	0.0018	114	114	114	0	0	1	-360	360;
	1455	1966	0.00678	0.01149	0.00116	29	29	29	0	0	1	-360	360;
	1456	1967	0.00678	0.01149	0.00116	57	57	57	0	0	1	-360	360;
	1801	1645	0.03702	0.0595	0.00702	78	78	78	0	0	1	-360	360;
	1777	1646	0.01488	0.02661	0.00302	78	78	78	0	0	1	-360	360;
	2142	1519	0.01909	0.05413	0.00729	114	114	114	0	0	1	-360	360;
	2084	1350	0.00702	0.01529	0.0018	78	78	78	0	0	1	-360	360;
	1349	1065	0.01083	0.03074	0.00411	114	114	114	0	0	1	-360	360;
	1851	1066	0.0086	0.02438	0.00328	114	114	114	0	0	1	-360	360;
	1915	1503	0.02835	0.05174	0.01048	102	102	102	0	0	1	-360	360;
	2141	1915	0.0086	0.02438	0.00328	114	114	114	0	0	1	-360	360;
	1914	1897	0.0157	0.04471	0.00602	114	114	114	0	0	1	-360	360;
	1946	1711	0.01479	0.02455	0.00298	57	57	57	0	0	1	-360	360;
	2101	1486	0.00388	0.00653	0.00153	102	102	102	0	0	1	-360	360;
	1591	1536	0.0119	0.03397	0.00451	114	114	114	0	0	1	-360	360;
	1537	1108	0.00884	0.02504	0.00337	114	114	114	0	0	1	-360	360;
	1945	1216	0.02678	0.05975	0.00764	57	57	57	0	0	1	-360	360;
	1791	1735	0.03198	0.10364	0.01064	114	114	114	0	0	1	-360	360;
	1486	1433	0.03612	0.1176	0.01195	114	114	114	0	0	1	-360	360;
	2084	1864	0.02388	0.07802	0.00788	114	114	114	0	0	1	-360	360;
	2100	1466	0.02289	0.03901	0.00908	102	102	102	0	0	1	-360	360;
	1164	1456	0	8e-05	1e-05	102	102	102	0	0	1	-360	360;
	2084	1164	0.01083	0.03132	0.00333	102	102	102	0	0	1	-360	360;
	1163	1164	0.0095	0.03116	0.00315	114	114	114	0	0	1	-360	360;
	2084	1113	0.0043	0.01322	0.00152	114	114	114	0	0	1	-360	360;
	1490	2085	0.04058	0.10669	0.01117	102	102	102	0	0	1	-360	360;
	2085	1802	0.01752	0.03033	0.00327	78	78	78	0	0	1	-360	360;
	1867	1852	0.00314	0.00884	0.00119	114	114	114	0	0	1	-360	360;
	1865	1867	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1866	1867	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1456	1903	0.00554	0.01339	0.00257	114	114	114	0	0	1	-360	360;
	1676	1777	0.00215	0.00603	0.00063	78	78	78	0	0	1	-360	360;
	1487	1455	0.0181	0.0419	0.00515	102	102	102	0	0	1	-360	360;
	1170	1065	0.00545	0.01785	0.0018	114	114	114	0	0	1	-360	360;
	1171	1066	0.00545	0.01785	0.0018	114	114	114	0	0	1	-360	360;
	1471	1147	0.01901	0.06017	0.00654	114	114	114	0	0	1	-360	360;
	2124	1146	0.00504	0.01438	0.00192	114	114	114	0	0	1	-360	360;
	1472	1062	0.01421	0.02306	0.00276	90	90	90	0	0	1	-360	360;
	1148	1921	0.02157	0.06926	0.00705	114	114	114	0	0	1	-360	360;
	1510	1442	0.01545	0.05058	0.00511	114	114	114	0	0	1	-360	360;
	2045	1510	0.01223	0.02818	0.00432	114	114	114	0	0	1	-360	360;
	1260	1149	0.00231	0.00653	0.00069	114	114	114	0	0	1	-360	360;
	1890	1237	0.02529	0.04041	0.00662	90	90	90	0	0	1	-360	360;
	2093	1655	0.00149	0.00488	0.0005	114	114	114	0	0	1	-360	360;
	2038	2093	0.01322	0.02975	0.00356	90	90	90	0	0	1	-360	360;
	1921	2037	0.00818	0.02364	0.0031	114	114	114	0	0	1	-360	360;
	2150	1951	0.00901	0.01421	0.0017	90	90	90	0	0	1	-360	360;
	1637	1539	0.00331	0.00744	0.00096	114	114	114	0	0	1	-360	360;
	1653	1057	0.00471	0.01331	0.00179	114	114	114	0	0	1	-360	360;
	1261	1639	0.00298	0.00612	0.00103	114	114	114	0	0	1	-360	360;
	1941	1511	0.01587	0.04314	0.00429	114	114	114	0	0	1	-360	360;
	1973	1920	0.02612	0.03058	0.00657	90	90	90	0	0	1	-360	360;
	2046	1058	0.00413	0.01165	0.00158	114	114	114	0	0	1	-360	360;
	1238	1511	0.00851	0.0257	0.00309	114	114	114	0	0	1	-360	360;
	1722	1921	0.00281	0.00893	0.00097	114	114	114	0	0	1	-360	360;
	1441	1793	0.01033	0.03165	0.00366	114	114	114	0	0	1	-360	360;
	2109	1227	0.02058	0.05215	0.006	114	114	114	0	0	1	-360	360;
	1461	1228	0.00463	0.00777	0.00186	114	114	114	0	0	1	-360	360;
	2040	1794	0.01917	0.0624	0.00638	114	114	114	0	0	1	-360	360;
	1064	2040	0.01802	0.02116	0.00455	90	90	90	0	0	1	-360	360;
	2039	2040	0.00669	0.00785	0.00168	29	29	29	0	0	1	-360	360;
	2106	1446	0.01702	0.04901	0.00645	114	114	114	0	0	1	-360	360;
	1979	2106	0.04091	0.05083	0.01042	90	90	90	0	0	1	-360	360;
	1834	1510	0.00661	0.02	0.0024	114	114	114	0	0	1	-360	360;
	2150	1510	0.02512	0.07182	0.00953	114	114	114	0	0	1	-360	360;
	2067	2038	0.01438	0.04694	0.00475	114	114	114	0	0	1	-360	360;
	1835	2151	0.02876	0.08876	0.01014	114	114	114	0	0	1	-360	360;
	1510	1240	0.00264	0.00744	0.00101	114	114	114	0	0	1	-360	360;
	1891	2151	0.01959	0.02942	0.00541	90	90	90	0	0	1	-360	360;
	1472	1942	0.00372	0.00992	0.00096	114	114	114	0	0	1	-360	360;
	2107	1793	0.02421	0.07669	0.00831	114	114	114	0	0	1	-360	360;
	1226	1793	0.00769	0.02504	0.00253	114	114	114	0	0	1	-360	360;
	1227	1794	0.00769	0.02504	0.00253	114	114	114	0	0	1	-360	360;
	1471	1793	0.01926	0.06298	0.00636	114	114	114	0	0	1	-360	360;
	1655	1335	0.00603	0.01686	0.00167	114	114	114	0	0	1	-360	360;
	1239	1654	0.00405	0.01083	0.00137	114	114	114	0	0	1	-360	360;
	2057	1952	0.02033	0.0624	0.00719	114	114	114	0	0	1	-360	360;
	1638	1833	0.00512	0.01529	0.00187	114	114	114	0	0	1	-360	360;
	2056	1836	0.01562	0.05107	0.00516	114	114	114	0	0	1	-360	360;
	1462	2125	0.01736	0.02322	0.00464	90	90	90	0	0	1	-360	360;
	1640	1511	0.00289	0.00934	0.00099	114	114	114	0	0	1	-360	360;
	1920	1510	0.02207	0.07215	0.00729	114	114	114	0	0	1	-360	360;
	1978	1089	0.01636	0.02025	0.00421	90	90	90	0	0	1	-360	360;
	1228	1612	0.00884	0.02802	0.00301	114	114	114	0	0	1	-360	360;
	1613	1182	0.00479	0.01471	0.00168	114	114	114	0	0	1	-360	360;
	1511	1202	0.01793	0.04463	0.00544	114	114	114	0	0	1	-360	360;
	1158	1219	0.01347	0.04264	0.00462	114	114	114	0	0	1	-360	360;
	1156	1158	0.00463	0.01331	0.00176	114	114	114	0	0	1	-360	360;
	1180	1158	8e-05	0.00017	3e-05	114	114	114	0	0	1	-360	360;
	1868	1562	0.04025	0.07132	0.00662	72	72	72	0	0	1	-360	360;
	1763	1868	0.02702	0.05752	0.00544	72	72	72	0	0	1	-360	360;
	1822	1763	0.00066	0.00107	0.00018	72	72	72	0	0	1	-360	360;
	1761	1763	0.00017	0.00041	5e-05	114	114	114	0	0	1	-360	360;
	1709	1282	0.00215	0.00612	0.00083	114	114	114	0	0	1	-360	360;
	1982	1590	0.01306	0.04157	0.00445	114	114	114	0	0	1	-360	360;
	2092	1132	0.01	0.02306	0.00305	97	97	97	0	0	1	-360	360;
	2113	2092	0.00587	0.01835	0.00202	116	116	116	0	0	1	-360	360;
	2136	2092	8e-05	0.00033	4e-05	116	116	116	0	0	1	-360	360;
	1076	2136	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	2134	2136	0.00446	0.01273	0.00172	114	114	114	0	0	1	-360	360;
	1067	1332	0.01397	0.04405	0.00478	114	114	114	0	0	1	-360	360;
	1815	1512	0.02281	0.06	0.00958	114	114	114	0	0	1	-360	360;
	1660	1769	0.00669	0.0162	0.00254	97	97	97	0	0	1	-360	360;
	1165	1868	0.02256	0.04314	0.004	75	75	75	0	0	1	-360	360;
	1660	1415	0.00446	0.01215	0.00124	111	111	111	0	0	1	-360	360;
	1416	1132	0.0057	0.01636	0.00222	114	114	114	0	0	1	-360	360;
	2076	1659	0.01364	0.03446	0.00363	97	97	97	0	0	1	-360	360;
	1421	1659	0.01769	0.04438	0.00468	97	97	97	0	0	1	-360	360;
	1813	1421	0.00488	0.01306	0.0016	97	97	97	0	0	1	-360	360;
	1421	1419	0.00091	0.00215	0.00023	97	97	97	0	0	1	-360	360;
	1660	1407	0.01669	0.04364	0.00566	97	97	97	0	0	1	-360	360;
	1315	1391	0.00289	0.00802	0.0008	114	114	114	0	0	1	-360	360;
	1406	1315	0.00595	0.00992	0.00237	97	97	97	0	0	1	-360	360;
	1315	1313	0.0024	0.00455	0.00075	72	72	72	0	0	1	-360	360;
	1635	1858	0.00893	0.02926	0.00295	114	114	114	0	0	1	-360	360;
	1678	1635	0.00496	0.01612	0.00164	114	114	114	0	0	1	-360	360;
	1633	1635	0.00231	0.00388	0.00039	72	72	72	0	0	1	-360	360;
	1299	1857	0.00083	0.00256	0.00027	114	114	114	0	0	1	-360	360;
	1078	1299	0.00793	0.02595	0.00262	114	114	114	0	0	1	-360	360;
	1297	1299	0.00025	0.00058	8e-05	114	114	114	0	0	1	-360	360;
	1644	1858	0.00802	0.02471	0.0025	97	97	97	0	0	1	-360	360;
	1643	1857	0.0081	0.0257	0.00258	97	97	97	0	0	1	-360	360;
	1859	1987	0.01446	0.04132	0.0055	114	114	114	0	0	1	-360	360;
	1898	1944	0.01008	0.03182	0.00345	114	114	114	0	0	1	-360	360;
	1411	1453	0.00372	0.01207	0.00122	114	114	114	0	0	1	-360	360;
	1607	1704	0.00223	0.0062	0.00084	114	114	114	0	0	1	-360	360;
	2035	2018	0.00959	0.03107	0.00317	114	114	114	0	0	1	-360	360;
	1663	1847	0.00099	0.00298	0.00036	114	114	114	0	0	1	-360	360;
	1869	1663	0.00579	0.01868	0.0019	114	114	114	0	0	1	-360	360;
	1661	1663	0.00083	0.00231	0.0003	114	114	114	0	0	1	-360	360;
	2062	1868	0.0119	0.03686	0.00418	114	114	114	0	0	1	-360	360;
	1362	1161	0.00421	0.01355	0.0014	114	114	114	0	0	1	-360	360;
	1962	1508	0.00521	0.01496	0.00198	114	114	114	0	0	1	-360	360;
	2098	1702	0.00479	0.01471	0.00176	114	114	114	0	0	1	-360	360;
	1208	2098	0.00174	0.00579	0.00065	114	114	114	0	0	1	-360	360;
	2096	2098	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	1208	1840	0.00124	0.00421	0.00042	114	114	114	0	0	1	-360	360;
	1662	1847	0.00149	0.0043	0.00058	114	114	114	0	0	1	-360	360;
	1154	1596	0.00678	0.02215	0.00225	114	114	114	0	0	1	-360	360;
	1300	1647	0.0081	0.02066	0.00231	97	97	97	0	0	1	-360	360;
	1858	1300	0.0005	0.00157	0.00016	97	97	97	0	0	1	-360	360;
	1300	1298	0.00091	0.00264	0.00036	57	57	57	0	0	1	-360	360;
	1355	1188	0.00174	0.00496	0.00065	57	57	57	0	0	1	-360	360;
	2063	1548	0.01298	0.04074	0.0045	114	114	114	0	0	1	-360	360;
	1789	1963	0.0038	0.01231	0.00124	114	114	114	0	0	1	-360	360;
	1636	1789	0.00669	0.02198	0.00222	116	116	116	0	0	1	-360	360;
	1079	1636	0.00446	0.01463	0.00148	114	114	114	0	0	1	-360	360;
	1789	1787	0.00116	0.00256	0.00025	72	72	72	0	0	1	-360	360;
	1634	1636	0.00231	0.00388	0.00039	72	72	72	0	0	1	-360	360;
	1962	1364	0.00446	0.01455	0.00149	114	114	114	0	0	1	-360	360;
	1453	2053	0.00331	0.01066	0.0011	114	114	114	0	0	1	-360	360;
	1453	1247	0.0014	0.00455	0.00046	114	114	114	0	0	1	-360	360;
	1705	1218	0.0024	0.00678	0.00091	114	114	114	0	0	1	-360	360;
	2063	1698	0.0038	0.01083	0.00145	114	114	114	0	0	1	-360	360;
	1848	2064	0.01835	0.05744	0.00634	114	114	114	0	0	1	-360	360;
	1316	1193	0.00099	0.00273	0.00037	114	114	114	0	0	1	-360	360;
	1740	1316	0.00149	0.0043	0.00057	114	114	114	0	0	1	-360	360;
	1316	1314	0.00132	0.00364	0.00049	114	114	114	0	0	1	-360	360;
	1417	1131	0.00273	0.00785	0.00102	114	114	114	0	0	1	-360	360;
	2133	1417	0.00223	0.00736	0.00075	116	116	116	0	0	1	-360	360;
	2130	2133	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	2132	2133	0	0.00083	1e-05	114	114	114	0	0	1	-360	360;
	1475	1331	0.00107	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	2060	1475	0.00455	0.01355	0.00164	114	114	114	0	0	1	-360	360;
	1475	1473	0.00116	0.0014	0.0003	72	72	72	0	0	1	-360	360;
	1135	1331	0.00107	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	2105	1135	0.00388	0.01207	0.00134	114	114	114	0	0	1	-360	360;
	1133	1135	0.00066	0.00182	0.00024	114	114	114	0	0	1	-360	360;
	1496	1331	0.00934	0.0257	0.00253	97	97	97	0	0	1	-360	360;
	1943	1496	0.0057	0.01479	0.0015	97	97	97	0	0	1	-360	360;
	1496	1493	0.00554	0.00959	0.00095	72	72	72	0	0	1	-360	360;
	1543	1331	0.01504	0.04033	0.00401	97	97	97	0	0	1	-360	360;
	1944	1543	8e-05	0.00025	2e-05	114	114	114	0	0	1	-360	360;
	1542	1543	0.00017	0.00041	6e-05	114	114	114	0	0	1	-360	360;
	1589	1513	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1589	1513	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1359	1330	0.01256	0.03975	0.0044	114	114	114	0	0	1	-360	360;
	1361	1359	0.00025	0.00083	9e-05	116	116	116	0	0	1	-360	360;
	1589	1361	0.00058	0.00174	0.00019	114	114	114	0	0	1	-360	360;
	1356	1359	0.00041	0.00132	0.00013	114	114	114	0	0	1	-360	360;
	1880	1332	0.00876	0.02744	0.00304	114	114	114	0	0	1	-360	360;
	1358	1880	0.00364	0.01149	0.00127	116	116	116	0	0	1	-360	360;
	1590	1358	0.00099	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	1879	1880	0.00207	0.00603	0.00079	114	114	114	0	0	1	-360	360;
	1246	2095	0.00149	0.00496	0.0005	84	84	84	0	0	1	-360	360;
	1648	1246	0.00496	0.01306	0.00151	97	97	97	0	0	1	-360	360;
	1245	1246	0.00066	0.00198	0.00026	114	114	114	0	0	1	-360	360;
	2064	1739	0.0043	0.01364	0.00146	114	114	114	0	0	1	-360	360;
	1370	1749	0.01198	0.03702	0.00418	114	114	114	0	0	1	-360	360;
	1610	1188	0.00455	0.01405	0.0016	114	114	114	0	0	1	-360	360;
	2035	2019	0.00421	0.00917	0.00216	114	114	114	0	0	1	-360	360;
	1839	1142	0.00579	0.01529	0.0016	97	97	97	0	0	1	-360	360;
	1567	1142	0.00132	0.00231	0.00023	57	57	57	0	0	1	-360	360;
	1568	1143	0.00132	0.00231	0.00023	57	57	57	0	0	1	-360	360;
	2065	1883	0.00289	0.00719	0.00076	97	97	97	0	0	1	-360	360;
	2066	1884	0.00289	0.00719	0.00076	97	97	97	0	0	1	-360	360;
	1850	1330	0.00372	0.00917	0.00098	97	97	97	0	0	1	-360	360;
	2066	1850	0.00463	0.01463	0.00159	114	114	114	0	0	1	-360	360;
	1849	1850	0.00264	0.00579	0.00136	114	114	114	0	0	1	-360	360;
	2065	1330	0.00835	0.02388	0.00256	97	97	97	0	0	1	-360	360;
	1476	1330	0.00157	0.00488	0.00055	114	114	114	0	0	1	-360	360;
	1697	1476	0.00744	0.02281	0.00261	116	116	116	0	0	1	-360	360;
	2074	1697	0.00099	0.00331	0.00035	114	114	114	0	0	1	-360	360;
	1476	1474	0.00074	0.00132	0.00031	97	97	97	0	0	1	-360	360;
	1695	1697	0.00025	0.0005	5e-05	72	72	72	0	0	1	-360	360;
	1605	1330	0.00752	0.02339	0.0026	114	114	114	0	0	1	-360	360;
	2008	1641	0.01008	0.02496	0.00265	97	97	97	0	0	1	-360	360;
	2048	2008	0.0119	0.03008	0.0032	97	97	97	0	0	1	-360	360;
	2006	2008	0.00438	0.00545	0.00081	75	75	75	0	0	1	-360	360;
	2009	1642	0.01008	0.02496	0.00265	97	97	97	0	0	1	-360	360;
	1826	2009	0.00826	0.02132	0.00242	97	97	97	0	0	1	-360	360;
	2007	2009	0.00413	0.00479	0.00072	75	75	75	0	0	1	-360	360;
	2065	1929	0.0024	0.00694	0.0009	114	114	114	0	0	1	-360	360;
	1453	1220	0.00314	0.01355	0.00135	114	114	114	0	0	1	-360	360;
	1641	1365	0.00306	0.00355	0.00076	72	72	72	0	0	1	-360	360;
	1521	1604	0.00314	0.00959	0.00112	114	114	114	0	0	1	-360	360;
	1642	1366	0.00314	0.00364	0.00078	72	72	72	0	0	1	-360	360;
	1242	1856	0.00107	0.00298	0.0004	114	114	114	0	0	1	-360	360;
	1943	1242	0.00182	0.00529	0.00071	114	114	114	0	0	1	-360	360;
	1242	1241	0.00058	0.00157	0.00021	114	114	114	0	0	1	-360	360;
	1608	1853	0.00314	0.02124	0.00243	114	114	114	0	0	1	-360	360;
	1189	1502	0.00496	0.01628	0.00164	114	114	114	0	0	1	-360	360;
	2065	1596	0.00405	0.01264	0.0014	114	114	114	0	0	1	-360	360;
	1098	1643	0.00198	0.00612	0.00068	114	114	114	0	0	1	-360	360;
	2095	1098	0.00496	0.01545	0.00171	114	114	114	0	0	1	-360	360;
	1098	1096	0.00107	0.0019	0.00019	72	72	72	0	0	1	-360	360;
	1460	1644	0.00231	0.00752	0.00079	114	114	114	0	0	1	-360	360;
	1846	1460	0.0057	0.01818	0.00196	114	114	114	0	0	1	-360	360;
	1459	1460	8e-05	0.00017	2e-05	97	97	97	0	0	1	-360	360;
	1454	2025	0.0019	0.00455	0.00091	114	114	114	0	0	1	-360	360;
	2026	1453	0.0014	0.00471	0.00048	114	114	114	0	0	1	-360	360;
	1143	2026	0.0081	0.02298	0.00239	97	97	97	0	0	1	-360	360;
	2024	2026	0.0005	0.0014	0.00017	114	114	114	0	0	1	-360	360;
	1321	1332	0.00752	0.02347	0.00235	97	97	97	0	0	1	-360	360;
	1494	1321	0.00033	0.00116	0.00012	114	114	114	0	0	1	-360	360;
	1319	1321	0.0024	0.00727	0.00087	114	114	114	0	0	1	-360	360;
	2036	2122	0.0081	0.02496	0.00284	114	114	114	0	0	1	-360	360;
	1775	1060	0.00364	0.01149	0.00123	114	114	114	0	0	1	-360	360;
	1105	1775	0.00157	0.00463	0.00057	114	114	114	0	0	1	-360	360;
	1775	1773	0.00231	0.00694	0.00072	97	97	97	0	0	1	-360	360;
	2002	1232	0.0019	0.0057	0.00061	97	97	97	0	0	1	-360	360;
	1099	2003	0.0057	0.01744	0.00187	97	97	97	0	0	1	-360	360;
	2095	1099	0.00496	0.01545	0.00171	114	114	114	0	0	1	-360	360;
	1099	1097	0.00107	0.0019	0.00019	72	72	72	0	0	1	-360	360;
	1454	1996	0.00521	0.01603	0.00183	114	114	114	0	0	1	-360	360;
	1673	1512	0.01339	0.04223	0.00461	114	114	114	0	0	1	-360	360;
	2022	1673	0.00785	0.02529	0.00263	114	114	114	0	0	1	-360	360;
	1673	1671	0.00388	0.01281	0.00126	114	114	114	0	0	1	-360	360;
	1672	1263	0.00876	0.0281	0.00298	114	114	114	0	0	1	-360	360;
	1585	1672	0.01116	0.03504	0.00382	116	116	116	0	0	1	-360	360;
	1512	1585	0.00231	0.00719	0.00079	114	114	114	0	0	1	-360	360;
	1672	1670	0.0038	0.0124	0.00126	114	114	114	0	0	1	-360	360;
	1585	1583	0.00322	0.00554	0.00054	72	72	72	0	0	1	-360	360;
	2002	1643	0.00545	0.01702	0.00187	114	114	114	0	0	1	-360	360;
	2121	2066	0.00488	0.01207	0.00144	97	97	97	0	0	1	-360	360;
	1369	2120	0.00273	0.00785	0.00081	97	97	97	0	0	1	-360	360;
	1600	1811	0.00289	0.00868	0.00103	114	114	114	0	0	1	-360	360;
	2036	1600	0.00595	0.01942	0.00199	114	114	114	0	0	1	-360	360;
	1600	1598	0.00529	0.00909	0.0009	72	72	72	0	0	1	-360	360;
	1253	1454	0.0014	0.00455	0.00046	114	114	114	0	0	1	-360	360;
	1274	1253	0.00512	0.01554	0.00186	114	114	114	0	0	1	-360	360;
	1252	1253	0.00033	0.00107	0.00011	114	114	114	0	0	1	-360	360;
	1958	1877	0.00678	0.02025	0.00244	105	105	105	0	0	1	-360	360;
	2123	1878	0.00802	0.02554	0.00272	114	114	114	0	0	1	-360	360;
	1976	1821	0.00727	0.00975	0.00189	72	72	72	0	0	1	-360	360;
	2064	1131	0.01785	0.05826	0.00589	114	114	114	0	0	1	-360	360;
	2065	1254	0.00314	0.00785	0.00086	97	97	97	0	0	1	-360	360;
	1696	1255	0.00579	0.01595	0.00189	97	97	97	0	0	1	-360	360;
	1520	1696	0.00207	0.0062	0.00077	114	114	114	0	0	1	-360	360;
	1694	1696	0.00025	0.0005	5e-05	72	72	72	0	0	1	-360	360;
	2018	1738	0.00744	0.02289	0.00262	114	114	114	0	0	1	-360	360;
	1737	1513	0.01207	0.03926	0.00399	114	114	114	0	0	1	-360	360;
	1876	1513	0.0005	0.0038	0.00038	152	152	152	0	0	1	-360	360;
	1930	1876	0.0081	0.05248	0.00524	116	116	116	0	0	1	-360	360;
	2066	1930	0.00769	0.02413	0.00266	114	114	114	0	0	1	-360	360;
	1874	1876	0.00058	0.00174	0.00023	114	114	114	0	0	1	-360	360;
	1928	1930	0.00223	0.00719	0.00075	114	114	114	0	0	1	-360	360;
	1812	1095	0.00281	0.00851	0.00098	114	114	114	0	0	1	-360	360;
	1599	1094	0.00347	0.0114	0.00115	114	114	114	0	0	1	-360	360;
	1262	1599	0.00529	0.01719	0.00176	114	114	114	0	0	1	-360	360;
	1599	1597	0.00529	0.00909	0.0009	72	72	72	0	0	1	-360	360;
	1551	1807	0.01926	0.06198	0.00647	114	114	114	0	0	1	-360	360;
	2062	1551	0.01041	0.03388	0.00346	114	114	114	0	0	1	-360	360;
	1550	1551	0.00165	0.00537	0.00054	114	114	114	0	0	1	-360	360;
	1933	1847	0.00471	0.0138	0.00176	114	114	114	0	0	1	-360	360;
	1360	1590	0.00074	0.00231	0.00023	114	114	114	0	0	1	-360	360;
	2128	1360	0.01107	0.03612	0.00365	114	114	114	0	0	1	-360	360;
	1357	1360	0.00091	0.00306	0.0003	114	114	114	0	0	1	-360	360;
	1590	1716	0.00752	0.02446	0.00247	114	114	114	0	0	1	-360	360;
	1762	1977	0.0124	0.02793	0.00267	72	72	72	0	0	1	-360	360;
	2017	1443	0.01711	0.05562	0.0056	99	99	99	0	0	1	-360	360;
	1195	1160	0.01512	0.04223	0.00403	99	99	99	0	0	1	-360	360;
	1619	1159	0.01529	0.03198	0.00589	99	99	99	0	0	1	-360	360;
	1658	1400	0.00934	0.02917	0.00321	114	114	114	0	0	1	-360	360;
	1667	1658	0.00215	0.00636	0.0008	114	114	114	0	0	1	-360	360;
	1658	1657	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1631	1400	0.00504	0.01661	0.00167	114	114	114	0	0	1	-360	360;
	1956	1578	0.00579	0.01446	0.00162	99	99	99	0	0	1	-360	360;
	1444	1578	0.03413	0.08545	0.00909	99	99	99	0	0	1	-360	360;
	1444	2138	0.0062	0.01562	0.00277	114	114	114	0	0	1	-360	360;
	1617	2137	0.00124	0.00355	0.00045	114	114	114	0	0	1	-360	360;
	1909	1955	0.00769	0.01934	0.00211	99	99	99	0	0	1	-360	360;
	1907	1909	0.01248	0.03545	0.00474	114	114	114	0	0	1	-360	360;
	1443	1071	0.00488	0.01231	0.00189	99	99	99	0	0	1	-360	360;
	1212	1541	0.0062	0.01934	0.00214	114	114	114	0	0	1	-360	360;
	1443	1264	0.00405	0.01331	0.00135	114	114	114	0	0	1	-360	360;
	1265	1908	0.01025	0.02926	0.0039	114	114	114	0	0	1	-360	360;
	1440	1400	0.00959	0.03107	0.00321	114	114	114	0	0	1	-360	360;
	1684	1400	0.0014	0.0043	0.00047	114	114	114	0	0	1	-360	360;
	1191	1431	0.00777	0.02372	0.00273	114	114	114	0	0	1	-360	360;
	1993	1524	0.00818	0.02496	0.00292	114	114	114	0	0	1	-360	360;
	2126	2118	0.00149	0.00446	0.00057	114	114	114	0	0	1	-360	360;
	1706	1616	0.00628	0.01959	0.00217	114	114	114	0	0	1	-360	360;
	1707	1617	0.0062	0.01942	0.00215	114	114	114	0	0	1	-360	360;
	1616	2119	0.00083	0.00248	0.00027	114	114	114	0	0	1	-360	360;
	1072	2127	0.00074	0.00223	0.0003	114	114	114	0	0	1	-360	360;
	2139	1617	0.00198	0.00529	0.00071	99	99	99	0	0	1	-360	360;
	1892	1887	0.00347	0.00975	0.00132	114	114	114	0	0	1	-360	360;
	2021	1159	0.00512	0.01463	0.00197	114	114	114	0	0	1	-360	360;
	1893	2021	0.00132	0.0038	0.00051	114	114	114	0	0	1	-360	360;
	2020	2021	0.00025	0.00033	4e-05	114	114	114	0	0	1	-360	360;
	1923	1401	0.00479	0.01471	0.00169	114	114	114	0	0	1	-360	360;
	1423	1398	0.00884	0.02769	0.00305	114	114	114	0	0	1	-360	360;
	1939	1401	0.00504	0.01554	0.00179	114	114	114	0	0	1	-360	360;
	1926	1399	0.00355	0.00884	0.00094	99	99	99	0	0	1	-360	360;
	2029	1926	0.01603	0.04124	0.00435	99	99	99	0	0	1	-360	360;
	1926	1924	0.01264	0.01488	0.00319	77	77	77	0	0	1	-360	360;
	1927	1398	0.0043	0.01066	0.00113	99	99	99	0	0	1	-360	360;
	1900	1927	0.01727	0.04893	0.00506	99	99	99	0	0	1	-360	360;
	1927	1925	0.01281	0.01496	0.00322	77	77	77	0	0	1	-360	360;
	2030	1900	0.00893	0.02777	0.0031	114	114	114	0	0	1	-360	360;
	1248	1900	0.00901	0.02769	0.00317	114	114	114	0	0	1	-360	360;
	1901	1159	0.01083	0.02711	0.00287	99	99	99	0	0	1	-360	360;
	1902	1160	0.01083	0.02711	0.00287	99	99	99	0	0	1	-360	360;
	2081	1901	0.0043	0.0124	0.00164	114	114	114	0	0	1	-360	360;
	2082	1900	0.0043	0.0124	0.00164	114	114	114	0	0	1	-360	360;
	1732	1713	0.00504	0.01256	0.00135	99	99	99	0	0	1	-360	360;
	1902	1732	0.01099	0.02835	0.00304	99	99	99	0	0	1	-360	360;
	1731	1732	0.0043	0.01231	0.00162	114	114	114	0	0	1	-360	360;
	1901	1712	0.01603	0.04107	0.0044	99	99	99	0	0	1	-360	360;
	1900	2071	0.0062	0.02025	0.00208	114	114	114	0	0	1	-360	360;
	1443	1129	0.00455	0.01289	0.00174	114	114	114	0	0	1	-360	360;
	1999	1087	0.00421	0.01322	0.00146	114	114	114	0	0	1	-360	360;
	1953	1087	0.00347	0.01116	0.00119	114	114	114	0	0	1	-360	360;
	1950	1287	0.00471	0.01339	0.0018	114	114	114	0	0	1	-360	360;
	1579	1950	0.00355	0.01091	0.00126	114	114	114	0	0	1	-360	360;
	1950	1948	0.00157	0.00496	0.00056	114	114	114	0	0	1	-360	360;
	1754	1088	0.00264	0.00818	0.00091	114	114	114	0	0	1	-360	360;
	1579	1754	0.00612	0.01917	0.00209	114	114	114	0	0	1	-360	360;
	1754	1753	0.00207	0.00347	0.00083	99	99	99	0	0	1	-360	360;
	1593	1579	0.0024	0.00719	0.00085	114	114	114	0	0	1	-360	360;
	1213	1667	0.0024	0.00777	0.00081	114	114	114	0	0	1	-360	360;
	1286	1772	0.00372	0.00843	0.00145	102	102	102	0	0	1	-360	360;
	1745	1666	0.00628	0.02025	0.00211	114	114	114	0	0	1	-360	360;
	1484	1439	8e-05	0.00025	2e-05	114	114	114	0	0	1	-360	360;
	1693	1484	0.0076	0.01983	0.00206	99	99	99	0	0	1	-360	360;
	1666	1693	0.00314	0.00843	0.00085	99	99	99	0	0	1	-360	360;
	1483	1484	0.00455	0.00818	0.00096	77	77	77	0	0	1	-360	360;
	1692	1693	0.0005	0.0014	0.00013	99	99	99	0	0	1	-360	360;
	1458	1439	0.00256	0.00636	0.001	99	99	99	0	0	1	-360	360;
	1651	1409	0.00165	0.00463	0.00063	114	114	114	0	0	1	-360	360;
	1405	1440	0.00322	0.00926	0.00122	114	114	114	0	0	1	-360	360;
	1186	1405	0.00306	0.00893	0.00111	114	114	114	0	0	1	-360	360;
	1404	1405	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1409	1771	0.0014	0.00405	0.00053	114	114	114	0	0	1	-360	360;
	2058	1594	0.01074	0.03273	0.00383	114	114	114	0	0	1	-360	360;
	1439	1685	0.00826	0.02686	0.00276	114	114	114	0	0	1	-360	360;
	1625	2017	0.01471	0.03025	0.00563	99	99	99	0	0	1	-360	360;
	1444	1625	0.00992	0.01661	0.00395	99	99	99	0	0	1	-360	360;
	1625	1624	0.00223	0.00562	0.0006	99	99	99	0	0	1	-360	360;
	1085	1401	0.00603	0.02083	0.00212	114	114	114	0	0	1	-360	360;
	1086	1167	0.00306	0.01074	0.00115	114	114	114	0	0	1	-360	360;
	1397	1166	0.00653	0.02099	0.00221	114	114	114	0	0	1	-360	360;
	1525	1397	0.0024	0.00694	0.00092	114	114	114	0	0	1	-360	360;
	1393	1397	0.00868	0.02669	0.00307	114	114	114	0	0	1	-360	360;
	1394	1397	0.00835	0.0257	0.00294	114	114	114	0	0	1	-360	360;
	1414	1712	0.00471	0.01149	0.00179	99	99	99	0	0	1	-360	360;
	2080	1414	0.02405	0.04025	0.00957	99	99	99	0	0	1	-360	360;
	1413	1414	0.00347	0.01025	0.00125	114	114	114	0	0	1	-360	360;
	1713	1888	0.00149	0.00438	0.00052	114	114	114	0	0	1	-360	360;
	1712	1509	0.00091	0.00298	0.00033	114	114	114	0	0	1	-360	360;
	1730	1712	0.01033	0.0124	0.00255	77	77	77	0	0	1	-360	360;
	1713	1480	0.00843	0.02421	0.00321	114	114	114	0	0	1	-360	360;
	1954	1746	0.00149	0.00446	0.00055	114	114	114	0	0	1	-360	360;
	1721	1666	0.00198	0.0057	0.00077	114	114	114	0	0	1	-360	360;
	1949	1187	0.00438	0.01405	0.00149	114	114	114	0	0	1	-360	360;
	1327	1949	0.00066	0.00182	0.00024	114	114	114	0	0	1	-360	360;
	1579	1327	0.00463	0.01413	0.00163	114	114	114	0	0	1	-360	360;
	1947	1949	0.00017	0.00041	6e-05	114	114	114	0	0	1	-360	360;
	1326	1327	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1540	1088	0.00463	0.01438	0.0016	114	114	114	0	0	1	-360	360;
	1236	1088	0.00083	0.00264	0.00026	114	114	114	0	0	1	-360	360;
	1627	1236	0.00256	0.00835	0.00084	114	114	114	0	0	1	-360	360;
	1235	1236	0.00099	0.00289	0.00038	114	114	114	0	0	1	-360	360;
	2030	1190	0.00529	0.01636	0.00188	114	114	114	0	0	1	-360	360;
	1123	1159	0.00083	0.00132	0.00016	77	77	77	0	0	1	-360	360;
	1124	1160	0.00083	0.00124	0.00015	77	77	77	0	0	1	-360	360;
	1125	1160	0.00083	0.00124	0.00015	77	77	77	0	0	1	-360	360;
	1126	1159	0.00074	0.00116	0.00013	77	77	77	0	0	1	-360	360;
	1579	1998	0.00496	0.01537	0.00175	114	114	114	0	0	1	-360	360;
	1440	1194	0.00719	0.01777	0.00216	99	99	99	0	0	1	-360	360;
	1666	1632	0.00802	0.02521	0.00274	114	114	114	0	0	1	-360	360;
	2140	1130	0.00603	0.01711	0.00231	114	114	114	0	0	1	-360	360;
	1649	1580	0.00769	0.02711	0.00317	114	114	114	0	0	1	-360	360;
	1922	1399	0.0014	0.00446	0.00049	114	114	114	0	0	1	-360	360;
	1652	1457	0.00488	0.00868	0.00192	99	99	99	0	0	1	-360	360;
	2068	2017	0.00372	0.01231	0.00124	114	114	114	0	0	1	-360	360;
	2029	1249	0.00273	0.00826	0.00096	114	114	114	0	0	1	-360	360;
	2079	1995	0.00116	0.00273	0.00046	99	99	99	0	0	1	-360	360;
	1353	2016	0.00215	0.01479	0.00169	114	114	114	0	0	1	-360	360;
	1618	2016	0.00769	0.02347	0.00277	114	114	114	0	0	1	-360	360;
	1141	2017	0.00207	0.01413	0.00162	114	114	114	0	0	1	-360	360;
	1354	1141	8e-05	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	1139	1141	0.0005	0.00149	0.0096	114	114	114	0	0	1	-360	360;
	2059	2016	0.01116	0.03273	0.00319	99	99	99	0	0	1	-360	360;
	1669	2072	0.00587	0.0162	0.0017	99	99	99	0	0	1	-360	360;
	2030	1669	0.00017	0.00033	3e-05	99	99	99	0	0	1	-360	360;
	1669	1668	0.00198	0.00455	0.00078	99	99	99	0	0	1	-360	360;
	1296	1294	8e-05	0.00083	0	77	77	77	0	0	1	-360	360;
	1797	1296	0.01603	0.02347	0.00336	77	77	77	0	0	1	-360	360;
	1308	1797	0.04752	0.09182	0.00916	77	77	77	0	0	1	-360	360;
	1886	1328	0.03041	0.05322	0.00508	77	77	77	0	0	1	-360	360;
	2117	1886	0.09893	0.17769	0.01704	77	77	77	0	0	1	-360	360;
	1885	1886	0.00198	0.00314	0.00037	19	19	19	0	0	1	-360	360;
	1572	2116	0.01355	0.02826	0.00271	77	77	77	0	0	1	-360	360;
	1971	1110	0.02289	0.05793	0.00612	99	99	99	0	0	1	-360	360;
	1961	1110	0.02479	0.06264	0.00663	99	99	99	0	0	1	-360	360;
	2117	1284	0.02273	0.07314	0.00765	114	114	114	0	0	1	-360	360;
	1569	1110	0.01471	0.04587	0.00509	99	99	99	0	0	1	-360	360;
	1798	1367	0.04901	0.08405	0.00831	77	77	77	0	0	1	-360	360;
	1307	1798	0.04752	0.09182	0.00916	77	77	77	0	0	1	-360	360;
	1796	1798	0.0062	0.01066	0.00104	77	77	77	0	0	1	-360	360;
	1573	1111	0.01636	0.04132	0.0045	99	99	99	0	0	1	-360	360;
	1179	1573	0.03727	0.06678	0.00651	77	77	77	0	0	1	-360	360;
	1571	1573	0.00058	0.00099	0.0001	29	29	29	0	0	1	-360	360;
	1091	1271	0.01802	0.05174	0.00682	57	57	57	0	0	1	-360	360;
	1328	1091	0.0124	0.03595	0.00461	57	57	57	0	0	1	-360	360;
	1091	1090	0.01653	0.02579	0.0031	19	19	19	0	0	1	-360	360;
	1328	1719	0.01264	0.02372	0.00377	57	57	57	0	0	1	-360	360;
	1470	1111	0.00719	0.02248	0.00246	114	114	114	0	0	1	-360	360;
	1469	1112	0.00719	0.02256	0.00247	114	114	114	0	0	1	-360	360;
	1308	1302	0.00661	0.02124	0.00222	114	114	114	0	0	1	-360	360;
	1334	1307	0.01636	0.0524	0.00553	114	114	114	0	0	1	-360	360;
	1726	1307	0.02066	0.04909	0.0103	77	77	77	0	0	1	-360	360;
	1266	1308	0.00013	0.00231	0.00024	57	57	57	0	0	1	-360	360;
	1267	1307	0.00074	0.00223	0.00025	57	57	57	0	0	1	-360	360;
	1758	1308	0.02843	0.06868	0.00659	77	77	77	0	0	1	-360	360;
	2116	1758	0.0376	0.06537	0.00643	77	77	77	0	0	1	-360	360;
	1758	1756	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	2117	1522	0.03818	0.0662	0.00648	77	77	77	0	0	1	-360	360;
	1757	1307	0.02843	0.06868	0.00659	77	77	77	0	0	1	-360	360;
	1523	1757	0.00521	0.0086	0.00095	77	77	77	0	0	1	-360	360;
	1757	1755	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	1517	1492	0.0405	0.06314	0.00758	57	57	57	0	0	1	-360	360;
	2110	1527	0.02579	0.06736	0.0079	99	99	99	0	0	1	-360	360;
	2111	1726	0.02446	0.0624	0.00662	99	99	99	0	0	1	-360	360;
	2111	1727	0.02446	0.0624	0.00662	99	99	99	0	0	1	-360	360;
	1138	1561	0.02479	0.06579	0.00654	99	99	99	0	0	1	-360	360;
	2110	1918	0.00165	0.00347	0.00038	77	77	77	0	0	1	-360	360;
	2111	1919	0.00107	0.00347	0.00037	114	114	114	0	0	1	-360	360;
	2051	1491	0.03074	0.04793	0.00575	57	57	57	0	0	1	-360	360;
	1570	2116	0.00248	0.00752	0.00079	99	99	99	0	0	1	-360	360;
	1307	1285	0.01124	0.03645	0.00373	114	114	114	0	0	1	-360	360;
	1560	1491	0.00777	0.02116	0.00242	99	99	99	0	0	1	-360	360;
	2052	1681	0.05	0.0781	0.00933	57	57	57	0	0	1	-360	360;
	1727	1177	0.02603	0.0662	0.00724	99	99	99	0	0	1	-360	360;
	1780	1680	0.0424	0.06628	0.00792	57	57	57	0	0	1	-360	360;
	1101	1214	0.00438	0.01446	0.00146	86	86	86	0	0	1	-360	360;
	1323	1110	0.03256	0.10355	0.01105	114	114	114	0	0	1	-360	360;
	1806	1279	0.05025	0.07843	0.00941	57	57	57	0	0	1	-360	360;
	1960	1726	0.02537	0.06355	0.00677	99	99	99	0	0	1	-360	360;
	2033	1295	0.01331	0.03785	0.0051	57	57	57	0	0	1	-360	360;
	1214	1308	0.01	0.06967	0.00747	271	271	271	0	0	1	-360	360;
	1215	1980	0.00587	0.04058	0.00443	191	191	191	0	0	1	-360	360;
	1290	1301	0.00628	0.01959	0.0022	114	114	114	0	0	1	-360	360;
	1215	1291	0.00942	0.04198	0.00452	114	114	114	0	0	1	-360	360;
	1176	1970	0.00521	0.0138	0.00166	99	99	99	0	0	1	-360	360;
	1985	1301	0.00306	0.00702	0.00073	57	57	57	0	0	1	-360	360;
	1984	1302	0.00306	0.00694	0.00072	57	57	57	0	0	1	-360	360;
	1779	1100	0.03306	0.05388	0.00644	77	77	77	0	0	1	-360	360;
	1805	1117	0.01777	0.05802	0.00587	57	57	57	0	0	1	-360	360;
	1726	1137	0.02248	0.05165	0.00652	99	99	99	0	0	1	-360	360;
	1270	1294	0.01455	0.04165	0.00549	57	57	57	0	0	1	-360	360;
	1744	1328	0.02992	0.09198	0.01059	114	114	114	0	0	1	-360	360;
	1308	2013	0.01116	0.03364	0.00399	114	114	114	0	0	1	-360	360;
	1742	1906	0.03463	0.10727	0.01217	114	114	114	0	0	1	-360	360;
	1844	1214	0.02107	0.06851	0.00701	114	114	114	0	0	1	-360	360;
	1368	1844	0.03041	0.0914	0.01103	114	114	114	0	0	1	-360	360;
	1843	1844	0.01512	0.0495	0.005	114	114	114	0	0	1	-360	360;
	1905	1215	0.01471	0.04612	0.00511	114	114	114	0	0	1	-360	360;
	1741	1367	0.01521	0.03041	0.00377	90	90	90	0	0	1	-360	360;
	1981	1307	0.00463	0.03207	0.00353	232	232	232	0	0	1	-360	360;
	2103	1333	0.00339	0.00975	0.00127	114	114	114	0	0	1	-360	360;
	1214	2102	0.00331	0.02273	0.00246	114	114	114	0	0	1	-360	360;
	1726	1214	0.03438	0.11231	0.01135	114	114	114	0	0	1	-360	360;
	1727	1215	0.03438	0.1124	0.01135	114	114	114	0	0	1	-360	360;
	1558	1280	0.05347	0.06785	0.00635	57	57	57	0	0	1	-360	360;
	1184	1112	0.00752	0.02207	0.00251	99	99	99	0	0	1	-360	360;
	2012	1324	0.01702	0.0519	0.00604	114	114	114	0	0	1	-360	360;
	1329	1178	0.08231	0.14521	0.01396	57	57	57	0	0	1	-360	360;
	1368	1294	0.04719	0.07769	0.00864	57	57	57	0	0	1	-360	360;
	1174	1185	0.05843	0.0805	0.00897	64	64	64	0	0	1	-360	360;
	1118	1328	0.01364	0.04455	0.00453	57	57	57	0	0	1	-360	360;
	1806	1329	0.03124	0.10182	0.01034	57	57	57	0	0	1	-360	360;
	1628	1726	0.00099	0.0019	0	229	229	229	0	0	1	-360	360;
	1629	1727	0.00099	0.0019	0	229	229	229	0	0	1	-360	360;
	1630	1726	0.00124	0.00231	0	229	229	229	0	0	1	-360	360;
	1911	1169	0.02372	0.05926	0.0063	102	102	102	0	0	1	-360	360;
	1389	1623	0.00413	0.01033	0.0011	102	102	102	0	0	1	-360	360;
	1515	1389	0.03595	0.09132	0.0097	102	102	102	0	0	1	-360	360;
	1387	1389	0.00025	0.00041	0.00011	102	102	102	0	0	1	-360	360;
	1910	1127	0.01802	0.04124	0.00623	102	102	102	0	0	1	-360	360;
	1910	1073	0.01818	0.05636	0.00636	114	114	114	0	0	1	-360	360;
	1911	1800	0.02512	0.07851	0.00866	114	114	114	0	0	1	-360	360;
	1910	1500	0.01157	0.02512	0.00389	102	102	102	0	0	1	-360	360;
	1931	1623	0.02438	0.04083	0.00971	102	102	102	0	0	1	-360	360;
	1390	1623	0.00413	0.01033	0.0011	102	102	102	0	0	1	-360	360;
	2044	1390	0.0057	0.01562	0.00163	102	102	102	0	0	1	-360	360;
	1390	1388	0.00033	0.00058	0.00013	102	102	102	0	0	1	-360	360;
	2043	1842	0.01917	0.05124	0.0054	102	102	102	0	0	1	-360	360;
	2043	1383	0.00083	0.00273	0.00028	114	114	114	0	0	1	-360	360;
	2044	1384	0.00083	0.00306	0.00031	114	114	114	0	0	1	-360	360;
	2044	1376	0.00182	0.00512	0.00069	114	114	114	0	0	1	-360	360;
	2043	1377	0.0019	0.00529	0.00071	114	114	114	0	0	1	-360	360;
	2050	1800	0.00463	0.01512	0.00153	114	114	114	0	0	1	-360	360;
	1601	1799	0.00826	0.02702	0.00273	114	114	114	0	0	1	-360	360;
	2043	1374	0.00537	0.01207	0.00267	114	114	114	0	0	1	-360	360;
	1622	1371	0.00347	0.00661	0.00059	77	77	77	0	0	1	-360	360;
	1622	1372	0.00364	0.00653	0.00058	77	77	77	0	0	1	-360	360;
	1623	1373	0.00364	0.00653	0.00058	77	77	77	0	0	1	-360	360;
	1623	1378	0.00107	0.00207	0.00044	114	114	114	0	0	1	-360	360;
	1622	1379	0.00116	0.0019	0.00045	114	114	114	0	0	1	-360	360;
	2044	1386	0.00182	0.00479	0.00076	114	114	114	0	0	1	-360	360;
	1622	1375	0.00248	0.00595	0.00117	114	114	114	0	0	1	-360	360;
	1622	1080	0.01793	0.04512	0.00471	102	102	102	0	0	1	-360	360;
	1207	1081	0.00628	0.01942	0.00195	102	102	102	0	0	1	-360	360;
	1782	1288	0.01322	0.03694	0.0038	102	102	102	0	0	1	-360	360;
	2049	1603	0.00372	0.01223	0.00124	119	119	119	0	0	1	-360	360;
	1765	1603	0.00207	0.00653	0.00074	119	119	119	0	0	1	-360	360;
	1169	1766	0.01198	0.03455	0.00367	102	102	102	0	0	1	-360	360;
	1911	1988	0.01231	0.03545	0.00466	114	114	114	0	0	1	-360	360;
	1917	1152	0.00388	0.00901	0.00133	102	102	102	0	0	1	-360	360;
	1917	1910	0.00066	0.00413	0.00062	152	152	152	0	0	1	-360	360;
	1916	1911	0.00091	0.0062	0.00076	152	152	152	0	0	1	-360	360;
	1449	2000	0.04322	0.04876	0.00543	57	57	57	0	0	1	-360	360;
	1912	1449	0.00926	0.03017	0.00306	57	57	57	0	0	1	-360	360;
	1447	1449	0.00769	0.0086	0.00095	57	57	57	0	0	1	-360	360;
	1450	2001	0.02901	0.0362	0.00756	57	57	57	0	0	1	-360	360;
	1913	1450	0.00909	0.02959	0.00301	57	57	57	0	0	1	-360	360;
	1448	1450	0.00521	0.00612	0.00118	57	57	57	0	0	1	-360	360;
	1917	1831	0.08777	0.15231	0.01599	77	77	77	0	0	1	-360	360;
	1911	1664	0.02	0.04405	0.00993	114	114	114	0	0	1	-360	360;
	1665	1620	0.03934	0.08496	0.02002	114	114	114	0	0	1	-360	360;
	1403	1435	0.04322	0.10372	0.01111	77	77	77	0	0	1	-360	360;
	2000	1581	0.0157	0.02017	0.00426	77	77	77	0	0	1	-360	360;
	1872	1092	0.03678	0.08405	0.01056	102	102	102	0	0	1	-360	360;
	1293	1764	0.00934	0.01628	0.00189	77	77	77	0	0	1	-360	360;
	1293	1531	0.03264	0.09331	0.0124	76	76	76	0	0	1	-360	360;
	1832	1582	0.02653	0.03231	0.00677	77	77	77	0	0	1	-360	360;
	1601	1206	0.00388	0.01264	0.00128	114	114	114	0	0	1	-360	360;
	1312	1965	0.03579	0.06314	0.0077	77	77	77	0	0	1	-360	360;
	1964	1276	0.00397	0.00579	0.00109	57	57	57	0	0	1	-360	360;
	1964	2086	0.00711	0.01107	0.00132	77	77	77	0	0	1	-360	360;
	1965	2087	0.00702	0.01099	0.00131	77	77	77	0	0	1	-360	360;
	1104	1688	0.01909	0.05421	0.0073	114	114	114	0	0	1	-360	360;
	2001	1104	0.00653	0.0186	0.0025	114	114	114	0	0	1	-360	360;
	1102	1104	0.01	0.02843	0.00383	57	57	57	0	0	1	-360	360;
	1292	1621	0.03868	0.11587	0.01404	114	114	114	0	0	1	-360	360;
	1292	1116	0.00264	0.00769	0.00101	114	114	114	0	0	1	-360	360;
	2069	1168	0.01405	0.02124	0.0037	77	77	77	0	0	1	-360	360;
	1799	1074	0.01273	0.03917	0.0045	114	114	114	0	0	1	-360	360;
	1210	1601	0.00215	0.01504	0.00164	152	152	152	0	0	1	-360	360;
	1514	1910	0.00769	0.02074	0.0022	102	102	102	0	0	1	-360	360;
	2043	1602	0.00264	0.01909	0.0019	152	152	152	0	0	1	-360	360;
	2044	1601	0.00264	0.01909	0.0019	152	152	152	0	0	1	-360	360;
	2115	1800	0.01512	0.0376	0.00401	102	102	102	0	0	1	-360	360;
	1128	1759	0.00893	0.02355	0.00319	102	102	102	0	0	1	-360	360;
	1292	1311	0.04124	0.07066	0.00857	77	77	77	0	0	1	-360	360;
	1622	1385	0.00521	0.01157	0.00259	114	114	114	0	0	1	-360	360;
	1289	1799	0.01521	0.04074	0.00426	102	102	102	0	0	1	-360	360;
	1841	1603	0.00471	0.01554	0.00157	119	119	119	0	0	1	-360	360;
	1682	1292	0.01091	0.0357	0.00362	114	114	114	0	0	1	-360	360;
	1751	1683	0.0319	0.10785	0.011	114	114	114	0	0	1	-360	360;
	1557	1603	0.00165	0.01132	0.00121	152	152	152	0	0	1	-360	360;
	1675	1530	0.00653	0.02116	0.00217	114	114	114	0	0	1	-360	360;
	1752	1531	0.02198	0.07174	0.00727	114	114	114	0	0	1	-360	360;
	2001	1916	0.04512	0.23744	0.02383	114	114	114	0	0	1	-360	360;
	2001	1910	0.0457	0.2405	0.0243	114	114	114	0	0	1	-360	360;
	1623	1380	0.00083	0.00248	0.00033	102	102	102	0	0	1	-360	360;
	1863	1211	0.0043	0.00719	0.01602	102	102	102	0	0	1	-360	360;
	2000	1402	0.0581	0.13339	0.01261	77	77	77	0	0	1	-360	360;
	1602	1781	0.00388	0.01273	0.00129	114	114	114	0	0	1	-360	360;
	1614	1799	0.0005	0.00314	0.03081	97	97	97	0	0	1	-360	360;
	1615	1800	0.0005	0.00322	0.03119	97	97	97	0	0	1	-360	360;
	1093	1115	0.00397	0.01174	0.00144	114	114	114	0	0	1	-360	360;
	1804	1623	0.01802	0.0514	0.00687	114	114	114	0	0	1	-360	360;
	2070	1691	0.01785	0.03372	0.005	77	77	77	0	0	1	-360	360;
	1760	1168	0.00678	0.01521	0.00235	102	102	102	0	0	1	-360	360;
	1528	1689	0.00678	0.02083	0.00898	97	97	97	0	0	1	-360	360;
	2078	2114	0.02008	0.05017	0.0053	102	102	102	0	0	1	-360	360;
	1211	1556	0.00058	0.00388	0.00044	152	152	152	0	0	1	-360	360;
	1533	1622	0.04446	0.10959	0.01193	102	102	102	0	0	1	-360	360;
	1674	1974	0.03273	0.10661	0.01082	114	114	114	0	0	1	-360	360;
	1293	1529	0.04942	0.16132	0.01634	114	114	114	0	0	1	-360	360;
	1222	1989	0.01174	0.03339	0.00449	114	114	114	0	0	1	-360	360;
	1499	1862	0.00264	0.00793	0.00093	119	119	119	0	0	1	-360	360;
	1964	1277	0.00273	0.00793	0.00103	57	57	57	0	0	1	-360	360;
	1463	1556	0.00074	0.00248	0.01641	81	81	81	0	0	1	-360	360;
	1464	1557	0.00074	0.00248	0.01641	81	81	81	0	0	1	-360	360;
	1381	2043	0.00091	0.00298	0.0003	114	114	114	0	0	1	-360	360;
	1382	2044	0.00091	0.00298	0.0003	114	114	114	0	0	1	-360	360;
	2014	1990	0.00942	0.02802	0.00346	114	114	114	0	0	1	-360	360;
	1991	1053	0.00157	0.00182	0.00039	77	77	77	0	0	1	-360	360;
	1990	1054	0.00149	0.00174	0.00037	77	77	77	0	0	1	-360	360;
	1991	1055	0.0005	0.00058	0.00012	77	77	77	0	0	1	-360	360;
	1991	1056	0.00107	0.00124	0.00027	77	77	77	0	0	1	-360	360;
	2015	1991	0.01116	0.02983	0.0036	102	102	102	0	0	1	-360	360;
	1144	2088	0.02314	0.02711	0.00583	77	77	77	0	0	1	-360	360;
	1478	1576	0.02215	0.03876	0.00878	102	102	102	0	0	1	-360	360;
	1084	1145	0.02083	0.02479	0.00517	77	77	77	0	0	1	-360	360;
	1224	1084	0.01851	0.05818	0.00631	77	77	77	0	0	1	-360	360;
	1082	1084	0.0005	0.00074	9e-05	77	77	77	0	0	1	-360	360;
	1990	1478	0.00694	0.01901	0.00195	102	102	102	0	0	1	-360	360;
	2010	1478	0.00686	0.0095	0.00185	77	77	77	0	0	1	-360	360;
	1337	2088	0.0005	0.00149	0.0002	57	57	57	0	0	1	-360	360;
	2014	1829	0.0057	0.01777	0.00198	114	114	114	0	0	1	-360	360;
	2014	1083	0.02124	0.06909	0.00708	77	77	77	0	0	1	-360	360;
	1968	1587	0.00256	0.00554	0.00084	57	57	57	0	0	1	-360	360;
	1969	1588	0.00198	0.00471	0.00069	57	57	57	0	0	1	-360	360;
	1338	2089	0.00058	0.00174	0.00023	57	57	57	0	0	1	-360	360;
	2089	1565	0.00512	0.01455	0.00197	114	114	114	0	0	1	-360	360;
	1701	1785	0.00364	0.01033	0.0014	114	114	114	0	0	1	-360	360;
	2015	1786	0.00595	0.01917	0.00201	114	114	114	0	0	1	-360	360;
	1468	1587	0.01	0.01562	0.00187	76	76	76	0	0	1	-360	360;
	1819	1467	0.02339	0.03066	0.00535	108	108	108	0	0	1	-360	360;
	1830	1304	0.00661	0.02058	0.00231	114	114	114	0	0	1	-360	360;
	1477	1809	0.00364	0.01041	0.0014	119	119	119	0	0	1	-360	360;
	1477	1687	0.00802	0.02273	0.00304	119	119	119	0	0	1	-360	360;
	1724	1686	0.01264	0.03446	0.00355	102	102	102	0	0	1	-360	360;
	1810	1303	0.00587	0.01669	0.00225	114	114	114	0	0	1	-360	360;
	1478	1889	0.02736	0.08909	0.00906	38	38	38	0	0	1	-360	360;
	1310	1725	0.00174	0.00479	0.0005	102	102	102	0	0	1	-360	360;
	1881	1310	0.02157	0.05752	0.0053	102	102	102	0	0	1	-360	360;
	1310	1309	0.00314	0.00364	0.00079	57	57	57	0	0	1	-360	360;
	2032	2014	0.0119	0.03752	0.00408	114	114	114	0	0	1	-360	360;
	1991	1477	0.00678	0.02074	0.00193	102	102	102	0	0	1	-360	360;
	1577	1587	0.02529	0.04355	0.01005	102	102	102	0	0	1	-360	360;
	2011	1700	0.00314	0.00893	0.0012	114	114	114	0	0	1	-360	360;
	1172	2015	0.0343	0.11	0.01158	114	114	114	0	0	1	-360	360;
	2015	1225	0.01455	0.04521	0.0051	114	114	114	0	0	1	-360	360;
	2014	1715	0.01959	0.06397	0.00647	119	119	119	0	0	1	-360	360;
	2064	1392	0.00355	0.01132	0.00123	114	114	114	0	0	1	-360	360;
	1501	1595	0.00198	0.00645	0.00065	114	114	114	0	0	1	-360	360;
	1586	1513	0.00091	0.00653	0.00065	152	152	152	0	0	1	-360	360;
	1854	1586	0.0043	0.03033	0.00319	152	152	152	0	0	1	-360	360;
	1584	1586	0.00314	0.00545	0.00053	72	72	72	0	0	1	-360	360;
	1825	1643	0.00959	0.02587	0.00288	97	97	97	0	0	1	-360	360;
	1121	1094	0.01041	0.02975	0.00393	114	114	114	0	0	1	-360	360;
	1855	2027	0.00264	0.00744	0.001	114	114	114	0	0	1	-360	360;
	1122	1095	0.01008	0.02884	0.00381	114	114	114	0	0	1	-360	360;
	1859	2094	0.01231	0.03215	0.00338	97	97	97	0	0	1	-360	360;
	1790	1679	0.0019	0.00612	0.00062	114	114	114	0	0	1	-360	360;
	1963	1790	0.00355	0.01165	0.00118	114	114	114	0	0	1	-360	360;
	1790	1788	0.00132	0.00322	0.00031	72	72	72	0	0	1	-360	360;
	1142	1258	0.00347	0.01124	0.00113	114	114	114	0	0	1	-360	360;
	1143	1259	0.00339	0.01116	0.00113	114	114	114	0	0	1	-360	360;
	2064	1606	0.00942	0.03008	0.00319	114	114	114	0	0	1	-360	360;
	1871	1699	0.00711	0.02074	0.00265	114	114	114	0	0	1	-360	360;
	1848	1871	0.00099	0.00289	0.00037	114	114	114	0	0	1	-360	360;
	1870	1871	0.00124	0.00347	0.00046	114	114	114	0	0	1	-360	360;
	1641	1201	0.00083	0.00231	0.00031	114	114	114	0	0	1	-360	360;
	1281	1283	0.00182	0.00512	0.00069	29	29	29	0	0	1	-360	360;
	1776	1428	0.00322	0.01025	0.00109	114	114	114	0	0	1	-360	360;
	1845	1776	0.00372	0.0114	0.00133	114	114	114	0	0	1	-360	360;
	1774	1776	0.0024	0.00719	0.00074	97	97	97	0	0	1	-360	360;
	1986	1200	0.01281	0.03661	0.00485	114	114	114	0	0	1	-360	360;
	2146	1512	0.01198	0.03917	0.00396	114	114	114	0	0	1	-360	360;
	1331	1272	0.00496	0.0162	0.00164	114	114	114	0	0	1	-360	360;
	1331	1273	0.00339	0.00959	0.00129	114	114	114	0	0	1	-360	360;
	1934	1192	0.00975	0.03083	0.00335	114	114	114	0	0	1	-360	360;
	1535	2003	0.00017	0.00058	6e-05	114	114	114	0	0	1	-360	360;
	1644	1535	0.00529	0.01645	0.00181	114	114	114	0	0	1	-360	360;
	1534	1535	0.00421	0.00711	0.00072	72	72	72	0	0	1	-360	360;
	1077	1767	0.01099	0.02496	0.00416	97	97	97	0	0	1	-360	360;
	1077	1983	0.00579	0.01802	0.00198	114	114	114	0	0	1	-360	360;
	1075	1077	0.00025	0.00074	0.0001	114	114	114	0	0	1	-360	360;
	1136	1331	0.00041	0.00132	0.00013	114	114	114	0	0	1	-360	360;
	1151	1136	0.00273	0.00785	0.00077	97	97	97	0	0	1	-360	360;
	1322	1151	0.00438	0.01438	0.00145	116	116	116	0	0	1	-360	360;
	1495	1322	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	1134	1136	0.00124	0.00364	0.00048	114	114	114	0	0	1	-360	360;
	1151	1150	0.00339	0.01107	0.00112	114	114	114	0	0	1	-360	360;
	1320	1322	0.00223	0.00678	0.00081	114	114	114	0	0	1	-360	360;
	2094	2061	0.0076	0.02306	0.00272	114	114	114	0	0	1	-360	360;
	1256	1481	0.00496	0.01413	0.0019	114	114	114	0	0	1	-360	360;
	1943	1808	0.00231	0.00744	0.00077	114	114	114	0	0	1	-360	360;
	1420	1869	0.00818	0.02017	0.00219	97	97	97	0	0	1	-360	360;
	2075	1420	0.00471	0.01182	0.00132	57	57	57	0	0	1	-360	360;
	1418	1420	0.00091	0.00215	0.00023	97	97	97	0	0	1	-360	360;
	1861	1061	0.00653	0.02058	0.00222	114	114	114	0	0	1	-360	360;
	2028	1507	0.01231	0.04033	0.00408	114	114	114	0	0	1	-360	360;
	1162	1859	0.02587	0.06818	0.00737	97	97	97	0	0	1	-360	360;
	1750	1189	0.00496	0.01496	0.00179	114	114	114	0	0	1	-360	360;
	1770	2131	0.0014	0.00322	0.00053	97	97	97	0	0	1	-360	360;
	2073	1452	0.00413	0.01289	0.00144	114	114	114	0	0	1	-360	360;
	2062	1899	0.0176	0.05686	0.00587	114	114	114	0	0	1	-360	360;
	1817	1143	0.00636	0.0205	0.00213	114	114	114	0	0	1	-360	360;
	1131	1767	0.0086	0.02802	0.00284	114	114	114	0	0	1	-360	360;
	2063	1768	0.0262	0.08496	0.00871	114	114	114	0	0	1	-360	360;
	1859	1574	0.01975	0.05372	0.00566	97	97	97	0	0	1	-360	360;
	2042	1574	0.0019	0.00595	0.00067	114	114	114	0	0	1	-360	360;
	1364	2042	0.00264	0.0086	0.0009	114	114	114	0	0	1	-360	360;
	2041	2042	8e-05	0.00017	2e-05	72	72	72	0	0	1	-360	360;
	1482	2064	0.01174	0.03537	0.00421	114	114	114	0	0	1	-360	360;
	1106	1231	0.00562	0.01736	0.00193	97	97	97	0	0	1	-360	360;
	2099	1209	0.00182	0.00587	0.00065	114	114	114	0	0	1	-360	360;
	1824	2099	0.0038	0.01215	0.00125	116	116	116	0	0	1	-360	360;
	1143	1824	0.00264	0.00818	0.00094	114	114	114	0	0	1	-360	360;
	2097	2099	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	1824	1823	0.00124	0.00364	0.00047	57	57	57	0	0	1	-360	360;
	1595	1703	0.0024	0.00727	0.00087	114	114	114	0	0	1	-360	360;
	2055	1155	0.00413	0.01355	0.00138	114	114	114	0	0	1	-360	360;
	1188	2055	0.00711	0.02322	0.00234	114	114	114	0	0	1	-360	360;
	2054	2055	0.00074	0.00231	0.00026	114	114	114	0	0	1	-360	360;
	2083	1221	0.00091	0.00273	0.00033	114	114	114	0	0	1	-360	360;
	1453	1221	0.00314	0.01355	0.00135	114	114	114	0	0	1	-360	360;
	1119	1453	0.00041	0.00124	0.00013	114	114	114	0	0	1	-360	360;
	1120	1454	0.00041	0.00132	0.00014	114	114	114	0	0	1	-360	360;
	1424	1220	0.00066	0.0024	0.00031	114	114	114	0	0	1	-360	360;
	1589	2112	0.01289	0.04099	0.00439	114	114	114	0	0	1	-360	360;
	1659	1748	0.01942	0.06355	0.00642	69	69	69	0	0	1	-360	360;
	1747	1767	0.02091	0.06826	0.00692	69	69	69	0	0	1	-360	360;
	2047	1644	0.00174	0.00504	0.00052	97	97	97	0	0	1	-360	360;
	1332	1181	0.0076	0.02281	0.00274	114	114	114	0	0	1	-360	360;
	1875	1512	0.00174	0.00504	0.00067	114	114	114	0	0	1	-360	360;
	1257	2135	0.00413	0.01182	0.00159	114	114	114	0	0	1	-360	360;
	1549	1068	0.01248	0.03967	0.00426	114	114	114	0	0	1	-360	360;
	1412	1275	0.00347	0.01008	0.00131	114	114	114	0	0	1	-360	360;
	1957	1412	0.00364	0.01174	0.00124	114	114	114	0	0	1	-360	360;
	1410	1412	0	0.00083	1e-05	114	114	114	0	0	1	-360	360;
	1738	2145	0.00471	0.01554	0.00157	114	114	114	0	0	1	-360	360;
	2004	1454	0.00446	0.01281	0.00175	114	114	114	0	0	1	-360	360;
	1590	1708	0.02769	0.07157	0.00735	97	97	97	0	0	1	-360	360;
	1067	1733	0.00083	0.00248	0.00032	114	114	114	0	0	1	-360	360;
	1068	1734	0.00083	0.00248	0.00033	114	114	114	0	0	1	-360	360;
	2094	2104	0.00554	0.01711	0.00194	114	114	114	0	0	1	-360	360;
	1814	1869	0.00612	0.01636	0.00185	97	97	97	0	0	1	-360	360;
	1729	1767	0.00314	0.00884	0.00119	114	114	114	0	0	1	-360	360;
	1069	1813	0.00074	0.00223	0.00027	114	114	114	0	0	1	-360	360;
	1070	1814	0.00066	0.00207	0.00025	114	114	114	0	0	1	-360	360;
	1305	1898	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	1306	1899	0.00033	0.00091	0.00012	114	114	114	0	0	1	-360	360;
	1505	1067	0.00033	0.00091	0.00012	114	114	114	0	0	1	-360	360;
	1506	1068	0.00041	0.00124	0.00016	114	114	114	0	0	1	-360	360;
	1959	1986	0.0043	0.01256	0.00157	114	114	114	0	0	1	-360	360;
	1250	1256	0.00017	0.0005	7e-05	114	114	114	0	0	1	-360	360;
	1251	1257	0.00017	0.00058	7e-05	114	114	114	0	0	1	-360	360;
	1243	1221	0.00066	0.00215	0.00022	114	114	114	0	0	1	-360	360;
	1244	1220	0.00066	0.00207	0.00021	114	114	114	0	0	1	-360	360;
	1453	1209	0.00355	0.01149	0.00116	114	114	114	0	0	1	-360	360;
	2023	2019	0.00413	0.01355	0.00136	114	114	114	0	0	1	-360	360;
	1717	1157	0.00479	0.01537	0.00163	114	114	114	0	0	1	-360	360;
	1566	2065	0.00149	0.00479	0.00048	114	114	114	0	0	1	-360	360;
	2149	1611	0.00091	0.00256	0.00033	114	114	114	0	0	1	-360	360;
	1451	2149	0.00463	0.01446	0.00163	114	114	114	0	0	1	-360	360;
	2147	2149	0	8e-05	0	114	114	114	0	0	1	-360	360;
	1142	1609	0.00488	0.01719	0.00191	114	114	114	0	0	1	-360	360;
	2216	2332	0.00064	0.00483	0.00047	123	123	123	0	0	1	-360	360;
	2543	2400	0.03347	0.05893	0.00578	90	90	90	0	0	1	-360	360;
	2680	2400	0.02959	0.05471	0.00503	90	90	90	0	0	1	-360	360;
	2680	2401	0.03306	0.0586	0.00557	90	90	90	0	0	1	-360	360;
	2507	2414	0.04802	0.10264	0.01344	63	63	63	0	0	1	-360	360;
	2414	2166	0.0138	0.02421	0.0023	63	63	63	0	0	1	-360	360;
	2220	2213	0.05636	0.10521	0.01021	90	90	90	0	0	1	-360	360;
	2618	2264	0.05893	0.12397	0.01197	90	90	90	0	0	1	-360	360;
	2215	2204	0.02174	0.05	0.00501	76	76	76	0	0	1	-360	360;
	2368	2204	0.03471	0.06744	0.00663	76	76	76	0	0	1	-360	360;
	2214	2161	0.01971	0.06676	0.00661	137	137	137	0	0	1	-360	360;
	2552	2168	0.02486	0.04348	0.00415	120	120	120	0	0	1	-360	360;
	2518	2206	0.02228	0.07545	0.00747	137	137	137	0	0	1	-360	360;
	2553	2211	0.02521	0.08264	0.00847	137	137	137	0	0	1	-360	360;
	2546	2583	0.02066	0.06686	0.00692	126	126	126	0	0	1	-360	360;
	2358	2407	0.05967	0.10455	0.00995	87	87	87	0	0	1	-360	360;
	2186	2691	0.02711	0.04612	0.00445	90	90	90	0	0	1	-360	360;
	2538	2691	0.03366	0.11402	0.01129	137	137	137	0	0	1	-360	360;
	2671	2427	0.02413	0.07851	0.0082	137	137	137	0	0	1	-360	360;
	2220	2218	0.01835	0.06256	0.00605	137	137	137	0	0	1	-360	360;
	2355	2458	0.02497	0.08457	0.00837	137	137	137	0	0	1	-360	360;
	2620	2541	0.02236	0.07573	0.0075	137	137	137	0	0	1	-360	360;
	2637	2450	0.01654	0.05601	0.00554	140	140	140	0	0	1	-360	360;
	2600	2637	0.02679	0.09072	0.00898	140	140	140	0	0	1	-360	360;
	2600	2235	0.01445	0.04894	0.00484	137	137	137	0	0	1	-360	360;
	2296	2637	0.02042	0.03616	0.00345	140	140	140	0	0	1	-360	360;
	2564	2438	0.03204	0.10852	0.01074	137	137	137	0	0	1	-360	360;
	2566	2478	0.01612	0.05281	0.00541	114	114	114	0	0	1	-360	360;
	2272	2522	0.0166	0.05623	0.00557	10	10	10	0	0	1	-360	360;
	2451	2363	0.10413	0.16851	0.01897	90	90	90	0	0	1	-360	360;
	2452	2636	0.03306	0.04959	0.00605	76	76	76	0	0	1	-360	360;
	2636	2305	0.1	0.16529	0.01822	76	76	76	0	0	1	-360	360;
	2381	2636	0.0157	0.04628	0.00501	76	76	76	0	0	1	-360	360;
	2437	2189	0.0338	0.05537	0.00595	67	67	67	0	0	1	-360	360;
	2437	2276	0.0157	0.04628	0.00501	69	69	69	0	0	1	-360	360;
	2364	2304	0.02893	0.04711	0.0053	90	90	90	0	0	1	-360	360;
	2633	2626	0.00055	0.00182	0.02683	118	118	118	0	0	1	-360	360;
	2560	2190	0.01198	0.04056	0.00401	137	137	137	0	0	1	-360	360;
	2504	2616	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	2505	2617	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	2614	2305	0.00331	0.00579	0.00061	90	90	90	0	0	1	-360	360;
	2627	2614	0.00992	0.02231	0.00242	90	90	90	0	0	1	-360	360;
	2616	2304	0.02562	0.0438	0.00455	90	90	90	0	0	1	-360	360;
	2616	2190	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	2626	2617	0.01818	0.03554	0.0039	90	90	90	0	0	1	-360	360;
	2617	2190	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	2657	2448	0.00877	0.02969	0.00294	137	137	137	0	0	1	-360	360;
	2560	2657	0.00445	0.01505	0.00149	137	137	137	0	0	1	-360	360;
	2625	2657	0.00497	0.01683	0.00167	137	137	137	0	0	1	-360	360;
	2500	2189	0.0157	0.04793	0.00515	137	137	137	0	0	1	-360	360;
	2500	2447	0.00744	0.02397	0.00257	137	137	137	0	0	1	-360	360;
	2634	2592	0.0157	0.02727	0.00264	137	137	137	0	0	1	-360	360;
	2624	2447	0.00744	0.02562	0.00278	137	137	137	0	0	1	-360	360;
	2624	2606	0.00165	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2634	2606	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2607	2448	0.00909	0.02975	0.00319	137	137	137	0	0	1	-360	360;
	2607	2593	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2434	2447	0.02314	0.05868	0.00574	120	120	120	0	0	1	-360	360;
	2570	2448	0.01372	0.04446	0.00439	137	137	137	0	0	1	-360	360;
	2438	2448	0.02231	0.07182	0.00702	137	137	137	0	0	1	-360	360;
	2658	2448	0.02489	0.08432	0.00835	120	120	120	0	0	1	-360	360;
	2604	2658	0.01362	0.04612	0.00457	120	120	120	0	0	1	-360	360;
	2516	2447	0.0295	0.0999	0.00989	137	137	137	0	0	1	-360	360;
	2276	2410	0.00752	0.01256	0.0013	57	57	57	0	0	1	-360	360;
	2570	2407	0.06215	0.10504	0.01058	90	90	90	0	0	1	-360	360;
	2683	2434	0.03967	0.06942	0.00666	90	90	90	0	0	1	-360	360;
	2632	2592	0.00496	0.0157	0.0008	90	90	90	0	0	1	-360	360;
	2646	2190	0.01438	0.02405	0.00249	90	90	90	0	0	1	-360	360;
	2438	2646	0.03876	0.06463	0.00668	90	90	90	0	0	1	-360	360;
	2646	2409	0.01165	0.02124	0.00221	90	90	90	0	0	1	-360	360;
	2270	2305	0.01157	0.01983	0.00194	90	90	90	0	0	1	-360	360;
	2270	2593	0.00794	0.01591	0.00153	90	90	90	0	0	1	-360	360;
	2613	2304	0.00331	0.00579	0.00055	90	90	90	0	0	1	-360	360;
	2613	2460	0.00909	0.01736	0.00165	90	90	90	0	0	1	-360	360;
	2631	2305	0.01157	0.01893	0.00201	90	90	90	0	0	1	-360	360;
	2632	2304	0.01157	0.01893	0.00191	90	90	90	0	0	1	-360	360;
	2632	2269	0.00083	0.00248	0.00027	90	90	90	0	0	1	-360	360;
	2612	2592	0.01523	0.0484	0.00476	137	137	137	0	0	1	-360	360;
	2609	2593	0.01157	0.03636	0.00399	120	120	120	0	0	1	-360	360;
	2608	2611	0.00707	0.02395	0.00237	137	137	137	0	0	1	-360	360;
	2609	2545	0.02562	0.08264	0.00854	137	137	137	0	0	1	-360	360;
	2545	2499	0.02149	0.06942	0.00711	120	120	120	0	0	1	-360	360;
	2459	2592	0.00992	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2631	2608	0.01983	0.0338	0.00329	90	90	90	0	0	1	-360	360;
	2305	2189	0.02561	0.04415	0.00429	90	90	90	0	0	1	-360	360;
	2660	2304	0.01774	0.0304	0.00298	90	90	90	0	0	1	-360	360;
	2162	2305	0.005	0.00879	0.00084	90	90	90	0	0	1	-360	360;
	2692	2536	0.0281	0.04876	0.00477	90	90	90	0	0	1	-360	360;
	2162	2692	0.023	0.04027	0.00384	90	90	90	0	0	1	-360	360;
	2583	2438	0.02546	0.08496	0.00635	137	137	137	0	0	1	-360	360;
	2253	2377	0.03771	0.12774	0.01265	137	137	137	0	0	1	-360	360;
	2458	2253	0.02896	0.10088	0.00999	137	137	137	0	0	1	-360	360;
	2481	2473	0.08066	0.14207	0.01348	120	120	120	0	0	1	-360	360;
	2610	2220	0.04116	0.10446	0.01043	120	120	120	0	0	1	-360	360;
	2684	2610	0.05808	0.10375	0.00991	90	90	90	0	0	1	-360	360;
	2620	2422	0.02504	0.04289	0.00428	120	120	120	0	0	1	-360	360;
	2569	2540	0.01661	0.0538	0.00557	91	91	91	0	0	1	-360	360;
	2209	2572	0.0157	0.05157	0.00528	137	137	137	0	0	1	-360	360;
	2572	2468	0.02479	0.08132	0.00834	120	120	120	0	0	1	-360	360;
	2645	2377	0.03891	0.06806	0.00649	90	90	90	0	0	1	-360	360;
	2645	2619	0.00102	0.00347	0.00034	90	90	90	0	0	1	-360	360;
	2645	2238	0.03237	0.05888	0.00583	90	90	90	0	0	1	-360	360;
	2417	2227	0.00292	0.00988	0.00098	120	120	120	0	0	1	-360	360;
	2226	2208	0.00603	0.01785	0.00183	120	120	120	0	0	1	-360	360;
	2587	2237	0.04207	0.14132	0.01394	120	120	120	0	0	1	-360	360;
	2587	2192	0.02992	0.10136	0.01003	120	120	120	0	0	1	-360	360;
	2192	2469	0.01165	0.03957	0.00392	91	91	91	0	0	1	-360	360;
	2172	2462	0.00372	0.01248	0.00116	120	120	120	0	0	1	-360	360;
	2198	2207	0.00537	0.01512	0.00153	120	120	120	0	0	1	-360	360;
	2590	2496	0.00413	0.01405	0.00138	137	137	137	0	0	1	-360	360;
	2198	2227	0.00074	0.00231	0.00024	137	137	137	0	0	1	-360	360;
	2673	2501	0.00711	0.01942	0.00201	120	120	120	0	0	1	-360	360;
	2155	2226	0.00499	0.01691	0.00147	137	137	137	0	0	1	-360	360;
	2649	2468	0.01917	0.06388	0.00598	137	137	137	0	0	1	-360	360;
	2649	2494	0.0038	0.01264	0.00119	137	137	137	0	0	1	-360	360;
	2649	2466	0.00116	0.0038	0.00038	137	137	137	0	0	1	-360	360;
	2682	2284	0.01455	0.05314	0.00523	120	120	120	0	0	1	-360	360;
	2406	2630	0.02008	0.06818	0.00674	10	10	10	0	0	1	-360	360;
	2436	2284	0.01711	0.05769	0.00567	137	137	137	0	0	1	-360	360;
	2539	2377	0.03196	0.05589	0.00533	90	90	90	0	0	1	-360	360;
	2539	2295	0.01848	0.03232	0.00308	90	90	90	0	0	1	-360	360;
	2295	2271	0.02901	0.05165	0.00489	90	90	90	0	0	1	-360	360;
	2413	2271	0.01661	0.0295	0.00288	90	90	90	0	0	1	-360	360;
	2494	2463	0.00793	0.02678	0.00264	137	137	137	0	0	1	-360	360;
	2466	2463	0.00864	0.0173	0.00166	90	90	90	0	0	1	-360	360;
	2433	2165	0.0376	0.0676	0.00651	90	90	90	0	0	1	-360	360;
	2467	2300	0.01413	0.04628	0.00475	137	137	137	0	0	1	-360	360;
	2439	2245	0.01	0.03479	0.00317	120	120	120	0	0	1	-360	360;
	2673	2155	0.0061	0.02065	0.00204	137	137	137	0	0	1	-360	360;
	2384	2175	0.02213	0.07514	0.00742	91	91	91	0	0	1	-360	360;
	2508	2175	0.04678	0.05793	0.00462	91	91	91	0	0	1	-360	360;
	2544	2542	0.05388	0.0943	0.00898	90	90	90	0	0	1	-360	360;
	2427	2245	0.0414	0.08355	0.00786	90	90	90	0	0	1	-360	360;
	2490	2461	0.00968	0.03279	0.00325	137	137	137	0	0	1	-360	360;
	2379	2377	0.00033	0.00041	0	78	78	78	0	0	1	-360	360;
	2164	2208	0.01165	0.03463	0.00356	90	90	90	0	0	1	-360	360;
	2484	2208	0.02204	0.07467	0.00739	91	91	91	0	0	1	-360	360;
	2228	2484	0.01214	0.04112	0.00407	91	91	91	0	0	1	-360	360;
	2554	2422	0.04033	0.06893	0.00692	91	91	91	0	0	1	-360	360;
	2610	2481	0.03364	0.08545	0.00874	91	91	91	0	0	1	-360	360;
	2651	2468	0.01669	0.03529	0.00341	90	90	90	0	0	1	-360	360;
	2651	2603	0.0576	0.12215	0.01179	90	90	90	0	0	1	-360	360;
	2610	2540	0.03529	0.06033	0.00605	90	90	90	0	0	1	-360	360;
	2260	2377	0.06808	0.1244	0.01294	90	90	90	0	0	1	-360	360;
	2542	2260	0.0043	0.01028	0.00143	90	90	90	0	0	1	-360	360;
	2300	2472	0.01612	0.05405	0.00532	120	120	120	0	0	1	-360	360;
	2620	2397	0.03967	0.06934	0.00663	90	90	90	0	0	1	-360	360;
	2528	2472	0.02397	0.04223	0.00414	90	90	90	0	0	1	-360	360;
	2528	2295	0.04645	0.08174	0.00801	69	69	69	0	0	1	-360	360;
	2185	2473	0.02276	0.0771	0.00763	120	120	120	0	0	1	-360	360;
	2554	2419	0.01124	0.03818	0.00378	120	120	120	0	0	1	-360	360;
	2543	2481	0.02347	0.05785	0.00593	91	91	91	0	0	1	-360	360;
	2466	2469	0.00983	0.03322	0.00328	137	137	137	0	0	1	-360	360;
	2228	2237	0.01393	0.04721	0.00467	91	91	91	0	0	1	-360	360;
	2235	2236	0.00688	0.02328	0.0023	120	120	120	0	0	1	-360	360;
	2544	2397	0.0343	0.06	0.00574	90	90	90	0	0	1	-360	360;
	2384	2377	0.00389	0.01322	0.0013	69	69	69	0	0	1	-360	360;
	2682	2469	0.0605	0.11818	0.01159	90	90	90	0	0	1	-360	360;
	2527	2300	0.00615	0.02083	0.00206	91	91	91	0	0	1	-360	360;
	2569	2527	0.00759	0.02569	0.00254	91	91	91	0	0	1	-360	360;
	2485	2226	0.00519	0.01413	0.00143	120	120	120	0	0	1	-360	360;
	2603	2405	0.06744	0.11802	0.01126	10	10	10	0	0	1	-360	360;
	2185	2439	0.01452	0.04917	0.00487	137	137	137	0	0	1	-360	360;
	2485	2418	0.00182	0.00455	0.00046	91	91	91	0	0	1	-360	360;
	2461	2227	0.00259	0.00876	0.00087	137	137	137	0	0	1	-360	360;
	2467	2491	0.0019	0.00603	0.00061	137	137	137	0	0	1	-360	360;
	2462	2357	0.00174	0.00479	0.00048	120	120	120	0	0	1	-360	360;
	2467	2207	0.00686	0.02198	0.00228	137	137	137	0	0	1	-360	360;
	2514	2433	0.01702	0.05512	0.00571	137	137	137	0	0	1	-360	360;
	2501	2492	0.01028	0.02164	0.0021	90	90	90	0	0	1	-360	360;
	2554	2226	0.01126	0.03814	0.00378	91	91	91	0	0	1	-360	360;
	2652	2490	0.00303	0.01029	0.00102	120	120	120	0	0	1	-360	360;
	2172	2652	0.00617	0.01736	0.00174	120	120	120	0	0	1	-360	360;
	2230	2473	0.00731	0.01279	0.00122	90	90	90	0	0	1	-360	360;
	2495	2472	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	2496	2473	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	2388	2472	0.01344	0.02383	0.00227	90	90	90	0	0	1	-360	360;
	2388	2493	0.00698	0.01279	0.00098	90	90	90	0	0	1	-360	360;
	2280	2473	0.00574	0.01944	0.00192	137	137	137	0	0	1	-360	360;
	2491	2420	0.00339	0.01099	0.00114	137	137	137	0	0	1	-360	360;
	2420	2227	0.00281	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	2419	2493	0.01475	0.04998	0.00495	90	90	90	0	0	1	-360	360;
	2590	2491	0.00405	0.01339	0.00138	137	137	137	0	0	1	-360	360;
	2684	2209	0.01031	0.01797	0.00171	90	90	90	0	0	1	-360	360;
	2278	2495	0.00202	0.00325	0.02903	90	90	90	0	0	1	-360	360;
	2587	2514	0.0395	0.07231	0.00728	90	90	90	0	0	1	-360	360;
	2485	2205	0.00165	0.00537	0.00055	137	137	137	0	0	1	-360	360;
	2590	2205	0.00182	0.00595	0.00063	137	137	137	0	0	1	-360	360;
	2408	2490	0.00033	0.00041	0	78	78	78	0	0	1	-360	360;
	2357	2280	0.00405	0.01331	0.00138	137	137	137	0	0	1	-360	360;
	2231	2493	0.02035	0.03558	0.0034	90	90	90	0	0	1	-360	360;
	2413	2492	0.02272	0.03973	0.00379	90	90	90	0	0	1	-360	360;
	2681	2152	0.00129	0.00374	0.00038	114	114	114	0	0	1	-360	360;
	2191	2681	0.02833	0.07349	0.00745	108	108	108	0	0	1	-360	360;
	2191	2291	0.02967	0.07661	0.00777	108	108	108	0	0	1	-360	360;
	2564	2301	0.02826	0.0957	0.00947	137	137	137	0	0	1	-360	360;
	2446	2244	0.01729	0.05855	0.0058	137	137	137	0	0	1	-360	360;
	2639	2292	0.00702	0.01752	0.00078	126	126	126	0	0	1	-360	360;
	2639	2443	0.02388	0.06711	0.00621	126	126	126	0	0	1	-360	360;
	2639	2370	0.00355	0.00959	0.0008	126	126	126	0	0	1	-360	360;
	2244	2444	0.02737	0.09213	0.00912	140	140	140	0	0	1	-360	360;
	2446	2301	0.01792	0.06144	0.00601	137	137	137	0	0	1	-360	360;
	2358	2444	0.03793	0.09752	0.00999	137	137	137	0	0	1	-360	360;
	2429	2319	0.01322	0.03289	0.00347	114	114	114	0	0	1	-360	360;
	2571	2153	0.00504	0.01413	0.00145	108	108	108	0	0	1	-360	360;
	2389	2679	0.03744	0.09653	0.00989	108	108	108	0	0	1	-360	360;
	2389	2283	0.02017	0.04959	0.00508	108	108	108	0	0	1	-360	360;
	2313	2282	0.01529	0.04967	0.00518	91	91	91	0	0	1	-360	360;
	2196	2320	0.03331	0.07982	0.00783	108	108	108	0	0	1	-360	360;
	2638	2449	0.03814	0.06671	0.00636	81	81	81	0	0	1	-360	360;
	2297	2638	0.00069	0.00235	0.00023	81	81	81	0	0	1	-360	360;
	2317	2638	8e-05	0.00014	1e-05	81	81	81	0	0	1	-360	360;
	2281	2450	0.01364	0.0238	0.00227	69	69	69	0	0	1	-360	360;
	2294	2450	0.00868	0.01512	0.00145	69	69	69	0	0	1	-360	360;
	2450	2320	0.00537	0.01545	0.00181	204	204	204	0	0	1	-360	360;
	2323	2282	0.02843	0.05207	0.00498	87	87	87	0	0	1	-360	360;
	2503	2323	0.02843	0.05207	0.00498	87	87	87	0	0	1	-360	360;
	2440	2444	0.00388	0.00669	0.00063	87	87	87	0	0	1	-360	360;
	2442	2443	0.0076	0.01802	0.00179	87	87	87	0	0	1	-360	360;
	2541	2196	0.01169	0.03957	0.00392	137	137	137	0	0	1	-360	360;
	2589	2449	0.00397	0.02917	0.00283	274	274	274	0	0	1	-360	360;
	2588	2267	0.00099	0.00793	0.00077	171	171	171	0	0	1	-360	360;
	2374	2156	0.03397	0.0862	0.00875	120	120	120	0	0	1	-360	360;
	2267	2321	0.0005	0.00397	0.00056	160	160	160	0	0	1	-360	360;
	2154	2152	0.01627	0.02831	0.0027	69	69	69	0	0	1	-360	360;
	2329	2310	0.00909	0.02645	0.00269	111	111	111	0	0	1	-360	360;
	2318	2152	0.03198	0.08107	0.00828	111	111	111	0	0	1	-360	360;
	2365	2318	0.00692	0.01922	0.00194	111	111	111	0	0	1	-360	360;
	2289	2291	0.00504	0.01421	0.0015	114	114	114	0	0	1	-360	360;
	2158	2365	0.01395	0.03998	0.00401	111	111	111	0	0	1	-360	360;
	2329	2158	0.01657	0.0489	0.0049	111	111	111	0	0	1	-360	360;
	2283	2282	0.0038	0.01215	0.00123	119	119	119	0	0	1	-360	360;
	2435	2444	0.01793	0.05818	0.00603	126	126	126	0	0	1	-360	360;
	2503	2443	0.06438	0.1138	0.01096	81	81	81	0	0	1	-360	360;
	2358	2356	0.0024	0.00413	0.00039	90	90	90	0	0	1	-360	360;
	2285	2153	0.01471	0.03736	0.00382	102	102	102	0	0	1	-360	360;
	2347	2285	0.02504	0.06364	0.00724	102	102	102	0	0	1	-360	360;
	2442	2441	0.01661	0.02917	0.00278	77	77	77	0	0	1	-360	360;
	2546	2435	0.01438	0.04653	0.00481	126	126	126	0	0	1	-360	360;
	2594	2429	0.03669	0.0943	0.00985	102	102	102	0	0	1	-360	360;
	2615	2302	0.02983	0.05463	0.00552	87	87	87	0	0	1	-360	360;
	2369	2212	0.00302	0.01	0.00102	126	126	126	0	0	1	-360	360;
	2293	2212	0.00161	0.00529	0.00054	126	126	126	0	0	1	-360	360;
	2293	2289	0.01645	0.04298	0.00443	114	114	114	0	0	1	-360	360;
	2455	2319	0.01033	0.03405	0.00348	114	114	114	0	0	1	-360	360;
	2594	2571	0.02289	0.06215	0.00636	102	102	102	0	0	1	-360	360;
	2356	2314	0.01752	0.05438	0.00564	91	91	91	0	0	1	-360	360;
	2511	2455	0.01463	0.04793	0.00491	126	126	126	0	0	1	-360	360;
	2563	2511	0.02207	0.07149	0.00747	126	126	126	0	0	1	-360	360;
	2563	2293	0.0176	0.05694	0.00575	126	126	126	0	0	1	-360	360;
	2534	2319	0.01603	0.04074	0.00411	120	120	120	0	0	1	-360	360;
	2421	2319	0.00975	0.03207	0.00329	108	108	108	0	0	1	-360	360;
	2679	2421	0.03488	0.09488	0.00972	108	108	108	0	0	1	-360	360;
	2358	2355	0.00653	0.02207	0.00216	91	91	91	0	0	1	-360	360;
	2534	2374	0.01355	0.03446	0.0035	120	120	120	0	0	1	-360	360;
	2368	2213	0.04669	0.09545	0.00939	76	76	76	0	0	1	-360	360;
	2350	2214	0.03397	0.05942	0.00567	90	90	90	0	0	1	-360	360;
	2532	2239	0.02736	0.09182	0.00907	90	90	90	0	0	1	-360	360;
	2551	2240	0.02719	0.08793	0.0091	137	137	137	0	0	1	-360	360;
	2350	2257	0.02967	0.04926	0.00486	90	90	90	0	0	1	-360	360;
	2551	2218	0.02521	0.08182	0.00917	137	137	137	0	0	1	-360	360;
	2647	2275	0.05945	0.10398	0.00992	76	76	76	0	0	1	-360	360;
	2166	2647	0.01877	0.03282	0.00313	76	76	76	0	0	1	-360	360;
	2415	2647	0.02111	0.0715	0.00708	76	76	76	0	0	1	-360	360;
	2644	2239	0.02473	0.054	0.00523	90	90	90	0	0	1	-360	360;
	2553	2644	0.05383	0.11001	0.01061	90	90	90	0	0	1	-360	360;
	2391	2644	0.00257	0.00449	0.00043	90	90	90	0	0	1	-360	360;
	2275	2239	0.0014	0.00463	0.00046	76	76	76	0	0	1	-360	360;
	2519	2518	0.02661	0.08661	0.00899	137	137	137	0	0	1	-360	360;
	2532	2401	0.02198	0.0738	0.00736	90	90	90	0	0	1	-360	360;
	2643	2240	0.03224	0.06998	0.00678	90	90	90	0	0	1	-360	360;
	2643	2623	0.06617	0.11573	0.01104	90	90	90	0	0	1	-360	360;
	2659	2350	0.0165	0.05588	0.00553	90	90	90	0	0	1	-360	360;
	2390	2643	0.00198	0.00345	0.00033	90	90	90	0	0	1	-360	360;
	2623	2659	0.01442	0.02521	0.00241	90	90	90	0	0	1	-360	360;
	2519	2257	0.03149	0.05215	0.00515	76	76	76	0	0	1	-360	360;
	2252	2239	0.0104	0.03704	0.00282	90	90	90	0	0	1	-360	360;
	2250	2252	0.00375	0.00656	0.00063	90	90	90	0	0	1	-360	360;
	2256	2240	0.00415	0.00726	0.00069	90	90	90	0	0	1	-360	360;
	2243	2256	0.00652	0.0114	0.00109	90	90	90	0	0	1	-360	360;
	2210	2411	0.01983	0.05504	0.00595	76	76	76	0	0	1	-360	360;
	2655	2565	0.01093	0.03048	0.00307	120	120	120	0	0	1	-360	360;
	2210	2655	0.00375	0.01025	0.00103	120	120	120	0	0	1	-360	360;
	2672	2655	0.00383	0.00669	0.00064	120	120	120	0	0	1	-360	360;
	2693	2489	0.01173	0.03052	0.00303	90	90	90	0	0	1	-360	360;
	2693	2412	0.04023	0.10277	0.01021	90	90	90	0	0	1	-360	360;
	2562	2412	0.0286	0.05322	0.00515	76	76	76	0	0	1	-360	360;
	2184	2216	9e-05	0.00069	7e-05	137	137	137	0	0	1	-360	360;
	2247	2184	0.00555	0.01818	0.00186	137	137	137	0	0	1	-360	360;
	2488	2233	0.0256	0.0784	0.00806	90	90	90	0	0	1	-360	360;
	2255	2489	0.00661	0.01826	0.00194	120	120	120	0	0	1	-360	360;
	2567	2233	0.0096	0.02474	0.00251	69	69	69	0	0	1	-360	360;
	2530	2233	0.00628	0.01058	0.00108	90	90	90	0	0	1	-360	360;
	2674	2234	0.01777	0.03157	0.00301	90	90	90	0	0	1	-360	360;
	2395	2412	0.02706	0.09164	0.00907	90	90	90	0	0	1	-360	360;
	2430	2395	0.02078	0.03802	0.00364	90	90	90	0	0	1	-360	360;
	2430	2229	0.04152	0.07429	0.0071	76	76	76	0	0	1	-360	360;
	2229	2512	0.05017	0.08774	0.00837	90	90	90	0	0	1	-360	360;
	2562	2215	0.04463	0.09421	0.00963	90	90	90	0	0	1	-360	360;
	2622	2512	0.02479	0.08041	0.00832	76	76	76	0	0	1	-360	360;
	2399	2512	0.03769	0.06554	0.00624	90	90	90	0	0	1	-360	360;
	2399	2241	0.06537	0.11488	0.01096	90	90	90	0	0	1	-360	360;
	2247	2210	0.02058	0.0676	0.00569	137	137	137	0	0	1	-360	360;
	2664	2480	0.01314	0.02554	0.00246	90	90	90	0	0	1	-360	360;
	2424	2568	0.01947	0.06595	0.00653	34	34	34	0	0	1	-360	360;
	2591	2193	0.02182	0.07107	0.00737	120	120	120	0	0	1	-360	360;
	2582	2489	0.00486	0.01645	0.00163	120	120	120	0	0	1	-360	360;
	2163	2488	0.00228	0.00772	0.00076	120	120	120	0	0	1	-360	360;
	2416	2513	0.02306	0.05736	0.00587	76	76	76	0	0	1	-360	360;
	2371	2234	0.00389	0.01319	0.00131	120	120	120	0	0	1	-360	360;
	2163	2371	0.01011	0.03425	0.00339	137	137	137	0	0	1	-360	360;
	2425	2233	0.0078	0.02641	0.00262	120	120	120	0	0	1	-360	360;
	2582	2425	0.00317	0.01073	0.00106	120	120	120	0	0	1	-360	360;
	2565	2488	0.00595	0.02016	0.002	76	76	76	0	0	1	-360	360;
	2479	2255	0.01289	0.03372	0.00333	120	120	120	0	0	1	-360	360;
	2315	2513	0.03397	0.0581	0.00559	82	82	82	0	0	1	-360	360;
	2315	2232	0.06926	0.12157	0.01174	90	90	90	0	0	1	-360	360;
	2664	2241	0.03983	0.06967	0.00666	90	90	90	0	0	1	-360	360;
	2622	2558	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	2561	2559	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	2568	2232	0.01818	0.05884	0.00612	120	120	120	0	0	1	-360	360;
	2480	2210	0.00926	0.0186	0.00181	76	76	76	0	0	1	-360	360;
	2507	2411	0.06942	0.1405	0.01368	63	63	63	0	0	1	-360	360;
	2561	2416	0.01107	0.02744	0.00281	120	120	120	0	0	1	-360	360;
	2591	2216	0.01289	0.04198	0.00436	120	120	120	0	0	1	-360	360;
	2529	2398	0.00802	0.02174	0.0022	90	90	90	0	0	1	-360	360;
	2398	2234	0.00843	0.02298	0.00232	90	90	90	0	0	1	-360	360;
	2385	2411	0.02264	0.07355	0.00762	120	120	120	0	0	1	-360	360;
	2193	2161	0.0318	0.07979	0.00779	120	120	120	0	0	1	-360	360;
	2195	2412	0.05033	0.13388	0.01203	72	72	72	0	0	1	-360	360;
	2595	2195	0.02851	0.09843	0.00896	120	120	120	0	0	1	-360	360;
	2513	2411	0.0343	0.24545	0.02408	120	120	120	0	0	1	-360	360;
	2674	2479	0.00818	0.02149	0.00212	120	120	120	0	0	1	-360	360;
	2375	2668	0.04876	0.06942	0.01254	120	120	120	0	0	1	-360	360;
	2506	2669	0.01979	0.03629	0.00348	90	90	90	0	0	1	-360	360;
	2635	2669	0.02364	0.05992	0.00618	120	120	120	0	0	1	-360	360;
	2656	2225	0.00044	0.00112	0.00011	90	90	90	0	0	1	-360	360;
	2635	2656	0.00246	0.00659	0.00067	90	90	90	0	0	1	-360	360;
	2170	2635	0.00405	0.01306	0.00136	120	120	120	0	0	1	-360	360;
	2666	2669	0.02231	0.07557	0.00748	137	137	137	0	0	1	-360	360;
	2536	2668	0.02835	0.09504	0.00937	137	137	137	0	0	1	-360	360;
	2431	2668	0.03025	0.10165	0.01002	120	120	120	0	0	1	-360	360;
	2686	2557	0.0157	0.02727	0.00286	69	69	69	0	0	1	-360	360;
	2586	2464	0.01201	0.02671	0.00259	120	120	120	0	0	1	-360	360;
	2585	2556	0.01127	0.02548	0.00247	90	90	90	0	0	1	-360	360;
	2537	2556	0.0081	0.02742	0.00272	120	120	120	0	0	1	-360	360;
	2549	2556	0.02975	0.04207	0.00404	69	69	69	0	0	1	-360	360;
	2502	2557	0.04959	0.08678	0.009	69	69	69	0	0	1	-360	360;
	2502	2452	0.04207	0.07025	0.00733	69	69	69	0	0	1	-360	360;
	2170	2557	0.03898	0.10313	0.01043	120	120	120	0	0	1	-360	360;
	2525	2556	0.01467	0.0404	0.00628	120	120	120	0	0	1	-360	360;
	2549	2286	0.05124	0.08182	0.00949	90	90	90	0	0	1	-360	360;
	2159	2173	0.00661	0.01983	0.0023	137	137	137	0	0	1	-360	360;
	2456	2556	0.01405	0.02727	0.00278	90	90	90	0	0	1	-360	360;
	2456	2174	0.02479	0.04298	0.00423	90	90	90	0	0	1	-360	360;
	2394	2173	0.03223	0.05537	0.00307	90	90	90	0	0	1	-360	360;
	2159	2557	0.01762	0.04135	0.00402	90	90	90	0	0	1	-360	360;
	2464	2174	0.01135	0.03509	0.00346	137	137	137	0	0	1	-360	360;
	2597	2174	0.00992	0.02066	0.00218	91	91	91	0	0	1	-360	360;
	2290	2174	0.01753	0.05936	0.00588	137	137	137	0	0	1	-360	360;
	2517	2597	0.00992	0.02314	0.00261	91	91	91	0	0	1	-360	360;
	2517	2432	0.0338	0.08099	0.00927	91	91	91	0	0	1	-360	360;
	2533	2248	0.0281	0.08926	0.00924	114	114	114	0	0	1	-360	360;
	2396	2248	0.01405	0.04463	0.0046	120	120	120	0	0	1	-360	360;
	2533	2432	0.01818	0.04132	0.00465	114	114	114	0	0	1	-360	360;
	2396	2173	0.01157	0.0281	0.00286	120	120	120	0	0	1	-360	360;
	2533	2298	0.02479	0.03471	0.00419	90	90	90	0	0	1	-360	360;
	2187	2299	0.03793	0.06612	0.00641	90	90	90	0	0	1	-360	360;
	2221	2299	0.03853	0.06806	0.0065	90	90	90	0	0	1	-360	360;
	2360	2221	0.02515	0.0455	0.00437	120	120	120	0	0	1	-360	360;
	2375	2187	0.01405	0.04463	0.00484	120	120	120	0	0	1	-360	360;
	2584	2656	0.00775	0.02625	0.0026	90	90	90	0	0	1	-360	360;
	2273	2537	0.00826	0.01653	0.00194	120	120	120	0	0	1	-360	360;
	2224	2525	0.03764	0.09704	0.00984	120	120	120	0	0	1	-360	360;
	2272	2687	0.01676	0.05678	0.00562	120	120	120	0	0	1	-360	360;
	2367	2669	0.01335	0.0452	0.00447	120	120	120	0	0	1	-360	360;
	2678	2403	0.01317	0.0446	0.00442	137	137	137	0	0	1	-360	360;
	2628	2168	0.02744	0.10017	0.00953	90	90	90	0	0	1	-360	360;
	2629	2203	0.0062	0.02008	0.00293	90	90	90	0	0	1	-360	360;
	2169	2403	0.05489	0.14743	0.01489	120	120	120	0	0	1	-360	360;
	2167	2404	0.04902	0.12753	0.01292	120	120	120	0	0	1	-360	360;
	2580	2403	0.00514	0.03512	0.0079	229	229	229	0	0	1	-360	360;
	2581	2404	0.00514	0.03512	0.0079	229	229	229	0	0	1	-360	360;
	2372	2403	0.03223	0.07769	0.0044	137	137	137	0	0	1	-360	360;
	2182	2404	0.02727	0.0686	0.00666	120	120	120	0	0	1	-360	360;
	2576	2574	0.00331	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2573	2581	0.00413	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	2576	2580	0.00413	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2577	2580	0.00413	0.01074	0.00099	137	137	137	0	0	1	-360	360;
	2577	2575	0.00413	0.01157	0.00104	137	137	137	0	0	1	-360	360;
	2335	2169	0.01074	0.03471	0.00356	114	114	114	0	0	1	-360	360;
	2602	2167	0.00945	0.02846	0.0028	90	90	90	0	0	1	-360	360;
	2601	2169	0.00451	0.01529	0.00151	137	137	137	0	0	1	-360	360;
	2169	2168	0.0065	0.02202	0.00218	120	120	120	0	0	1	-360	360;
	2483	2203	0.01319	0.04467	0.00442	137	137	137	0	0	1	-360	360;
	2678	2483	0.0126	0.04265	0.00422	137	137	137	0	0	1	-360	360;
	2393	2372	0.02562	0.07851	0.00842	137	137	137	0	0	1	-360	360;
	2510	2393	0.0124	0.04132	0.00419	120	120	120	0	0	1	-360	360;
	2183	2199	0.03669	0.09165	0.0094	120	120	120	0	0	1	-360	360;
	2598	2288	0.00661	0.0157	0.00165	120	120	120	0	0	1	-360	360;
	2287	2199	0.00592	0.01857	0.00199	90	90	90	0	0	1	-360	360;
	2598	2199	0.00157	0.00512	0.00053	120	120	120	0	0	1	-360	360;
	2599	2199	0.00153	0.00493	0.0005	120	120	120	0	0	1	-360	360;
	2287	2279	0.00579	0.01322	0.00138	90	90	90	0	0	1	-360	360;
	2324	2199	0.02719	0.04917	0.00478	90	90	90	0	0	1	-360	360;
	2453	2199	0.0129	0.02274	0.0022	90	90	90	0	0	1	-360	360;
	2454	2199	0.01204	0.02472	0.00244	90	90	90	0	0	1	-360	360;
	2402	2279	0.02893	0.05124	0.00469	90	90	90	0	0	1	-360	360;
	2402	2394	0.0157	0.02727	0.00252	90	90	90	0	0	1	-360	360;
	2324	2290	0.01893	0.0595	0.00656	120	120	120	0	0	1	-360	360;
	2394	2290	0.01405	0.02314	0.00232	90	90	90	0	0	1	-360	360;
	2373	2290	0.009	0.03048	0.00302	69	69	69	0	0	1	-360	360;
	2576	2579	0.00909	0.0314	0.00327	137	137	137	0	0	1	-360	360;
	2577	2578	0.0124	0.0405	0.00416	137	137	137	0	0	1	-360	360;
	2531	2453	0.00636	0.02155	0.00213	91	91	91	0	0	1	-360	360;
	2311	2487	0.01028	0.01795	0.00171	114	114	114	0	0	1	-360	360;
	2307	2486	0.01334	0.0339	0.00343	114	114	114	0	0	1	-360	360;
	2648	2487	0.01249	0.03219	0.00326	90	90	90	0	0	1	-360	360;
	2308	2648	0.0006	0.00103	0.0001	90	90	90	0	0	1	-360	360;
	2641	2648	0.00435	0.0076	0.00073	90	90	90	0	0	1	-360	360;
	2362	2641	0.0004	0.00069	7e-05	90	90	90	0	0	1	-360	360;
	2650	2641	0.00221	0.00746	0.00074	90	90	90	0	0	1	-360	360;
	2547	2650	0.0085	0.01485	0.00142	90	90	90	0	0	1	-360	360;
	2498	2650	0.0082	0.02777	0.00275	90	90	90	0	0	1	-360	360;
	2325	2486	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2306	2312	0.00455	0.01263	0.00127	114	114	114	0	0	1	-360	360;
	2326	2486	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2338	2343	0.01176	0.02107	0.00202	90	90	90	0	0	1	-360	360;
	2327	2487	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2338	2341	0.01803	0.06109	0.00605	90	90	90	0	0	1	-360	360;
	2477	2487	0.00154	0.00521	0.00052	137	137	137	0	0	1	-360	360;
	2337	2487	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	2336	2486	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	2477	2351	0.00697	0.0236	0.00234	137	137	137	0	0	1	-360	360;
	2344	2487	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2343	2486	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2474	2487	0.00012	0.0004	4e-05	137	137	137	0	0	1	-360	360;
	2475	2486	0.0001	0.00031	3e-05	137	137	137	0	0	1	-360	360;
	2339	2487	0.00579	0.01818	0.00186	120	120	120	0	0	1	-360	360;
	2642	2202	0.0207	0.07012	0.00694	137	137	137	0	0	1	-360	360;
	2382	2642	0.00349	0.0118	0.00117	137	137	137	0	0	1	-360	360;
	2380	2642	0.00615	0.02083	0.00206	137	137	137	0	0	1	-360	360;
	2604	2523	0.02479	0.07686	0.00835	120	120	120	0	0	1	-360	360;
	2258	2524	0.02893	0.08843	0.00973	120	120	120	0	0	1	-360	360;
	2333	2309	0.00676	0.02291	0.00227	120	120	120	0	0	1	-360	360;
	2333	2342	0.00369	0.0125	0.00124	137	137	137	0	0	1	-360	360;
	2336	2342	0.00522	0.0177	0.00175	137	137	137	0	0	1	-360	360;
	2640	2487	0.00061	0.00208	0.00021	120	120	120	0	0	1	-360	360;
	2328	2640	0.00102	0.00347	0.00034	120	120	120	0	0	1	-360	360;
	2331	2640	0.00431	0.01388	0.00116	120	120	120	0	0	1	-360	360;
	2354	2486	0.00942	0.03193	0.00316	120	120	120	0	0	1	-360	360;
	2353	2330	0.00645	0.02187	0.00216	120	120	120	0	0	1	-360	360;
	2197	2334	0.02439	0.06359	0.01204	137	137	137	0	0	1	-360	360;
	2689	2452	0.01902	0.04153	0.00864	90	90	90	0	0	1	-360	360;
	2510	2334	0.00579	0.01893	0.00191	76	76	76	0	0	1	-360	360;
	2383	2452	0.0157	0.02562	0.00227	120	120	120	0	0	1	-360	360;
	2383	2382	0.00826	0.0124	0.00128	120	120	120	0	0	1	-360	360;
	2688	2451	0.02209	0.05774	0.00565	76	76	76	0	0	1	-360	360;
	2265	2451	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2266	2452	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2286	2451	0.04628	0.07686	0.00755	76	76	76	0	0	1	-360	360;
	2261	2691	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2262	2690	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2180	2691	0.00661	0.00909	0.00116	120	120	120	0	0	1	-360	360;
	2685	2180	0.00744	0.02397	0.00244	120	120	120	0	0	1	-360	360;
	2349	2346	0.00359	0.01215	0.0012	120	120	120	0	0	1	-360	360;
	2263	2691	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2264	2690	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2653	2690	0.00615	0.02083	0.0023	120	120	120	0	0	1	-360	360;
	2352	2653	0.00769	0.02603	0.00258	120	120	120	0	0	1	-360	360;
	2348	2653	0.00031	0.00104	0.0001	120	120	120	0	0	1	-360	360;
	2346	2691	0.00909	0.02727	0.0029	120	120	120	0	0	1	-360	360;
	2353	2345	0.00992	0.03058	0.00329	120	120	120	0	0	1	-360	360;
	2478	2690	0.02479	0.08008	0.0083	114	114	114	0	0	1	-360	360;
	2176	2691	0.01499	0.03154	0.0031	90	90	90	0	0	1	-360	360;
	2259	2690	0.04298	0.10248	0.0105	90	90	90	0	0	1	-360	360;
	2685	2341	0.00287	0.00972	0.00096	114	114	114	0	0	1	-360	360;
	2452	2201	0.03719	0.11901	0.0122	114	114	114	0	0	1	-360	360;
	2197	2202	0.06463	0.10992	0.01059	137	137	137	0	0	1	-360	360;
	2194	2201	0.03322	0.05661	0.00545	120	120	120	0	0	1	-360	360;
	2361	2202	0.01783	0.06021	0.00596	120	120	120	0	0	1	-360	360;
	2497	2201	0.00759	0.02569	0.00254	120	120	120	0	0	1	-360	360;
	2654	2340	0.01209	0.04096	0.00406	120	120	120	0	0	1	-360	360;
	2654	2202	0.00687	0.02326	0.0023	120	120	120	0	0	1	-360	360;
	2548	2654	0.00553	0.00967	0.00092	120	120	120	0	0	1	-360	360;
	2309	2201	0.0157	0.04959	0.00511	120	120	120	0	0	1	-360	360;
	2524	2202	0.00413	0.0314	0.003	137	137	137	0	0	1	-360	360;
	2515	2201	0.06583	0.22298	0.02208	137	137	137	0	0	1	-360	360;
	2499	2202	0.02066	0.06612	0.00678	120	120	120	0	0	1	-360	360;
	2312	2331	0.01642	0.05563	0.00551	137	137	137	0	0	1	-360	360;
	2246	2194	0.01214	0.04112	0.00407	137	137	137	0	0	1	-360	360;
	2303	2663	0.03124	0.10231	0.01048	137	137	137	0	0	1	-360	360;
	2206	2222	0.04421	0.11367	0.01112	91	91	91	0	0	1	-360	360;
	2316	2222	0.01033	0.01802	0.00172	90	90	90	0	0	1	-360	360;
	2676	2392	0.01256	0.0219	0.00212	90	90	90	0	0	1	-360	360;
	2677	2675	0.01008	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2476	2387	0.02	0.03744	0.00365	90	90	90	0	0	1	-360	360;
	2675	2476	0.00793	0.01537	0.0015	90	90	90	0	0	1	-360	360;
	2677	2676	0.01083	0.01893	0.00181	90	90	90	0	0	1	-360	360;
	2392	2386	0.02818	0.05818	0.0059	90	90	90	0	0	1	-360	360;
	2254	2222	0.05702	0.11331	0.01091	90	90	90	0	0	1	-360	360;
	2520	2386	0.03934	0.12917	0.0132	137	137	137	0	0	1	-360	360;
	2521	2520	0.00595	0.01917	0.00198	137	137	137	0	0	1	-360	360;
	2316	2386	0.0362	0.06339	0.00612	90	90	90	0	0	1	-360	360;
	2521	2670	0.02743	0.08885	0.00915	137	137	137	0	0	1	-360	360;
	2621	2535	0.04033	0.13661	0.01353	137	137	137	0	0	1	-360	360;
	2665	2274	0.01157	0.03942	0.0039	137	137	137	0	0	1	-360	360;
	2254	2157	0.03507	0.11878	0.01176	137	137	137	0	0	1	-360	360;
	2157	2387	0.04107	0.13909	0.01377	137	137	137	0	0	1	-360	360;
	2426	2186	0.0295	0.05017	0.00484	90	90	90	0	0	1	-360	360;
	2663	2274	0.01132	0.03744	0.0037	137	137	137	0	0	1	-360	360;
	2555	2671	0.00107	0.00121	0.01087	120	120	120	0	0	1	-360	360;
	2662	2387	0.01421	0.04661	0.00477	137	137	137	0	0	1	-360	360;
	2662	2535	0.01777	0.05818	0.00595	137	137	137	0	0	1	-360	360;
	2428	2303	0.02269	0.06221	0.00629	90	90	90	0	0	1	-360	360;
	2181	2387	0.02099	0.06934	0.00699	137	137	137	0	0	1	-360	360;
	2211	2181	0.01711	0.05562	0.0048	137	137	137	0	0	1	-360	360;
	2663	2566	0.02496	0.08446	0.00847	137	137	137	0	0	1	-360	360;
	2621	2538	0.03174	0.1075	0.01064	137	137	137	0	0	1	-360	360;
	2423	2386	0.02595	0.08512	0.00874	10	10	10	0	0	1	-360	360;
	2428	2426	0.00943	0.01889	0.00185	90	90	90	0	0	1	-360	360;
	2665	2157	0.01769	0.05744	0.00596	137	137	137	0	0	1	-360	360;
	2177	2665	0.05234	0.09155	0.00873	20	20	20	0	0	1	-360	360;
	2931	2992	0.03562	0.10942	0.01146	69	69	69	0	0	1	-360	360;
	2829	2970	0.03678	0.09397	0.00951	120	120	120	0	0	1	-360	360;
	2943	2894	0.00207	0.00727	0.0007	126	126	126	0	0	1	-360	360;
	2894	2723	0.01851	0.0595	0.00627	126	126	126	0	0	1	-360	360;
	2821	2704	0.021	0.0679	0.00696	123	123	123	0	0	1	-360	360;
	2921	2925	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2700	2994	0.06645	0.17719	0.01791	70	70	70	0	0	1	-360	360;
	2916	2995	0.03957	0.12859	0.01319	137	137	137	0	0	1	-360	360;
	2838	2879	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2811	2769	0.04	0.12959	0.01329	114	114	114	0	0	1	-360	360;
	2775	2875	0.00992	0.03322	0.00419	107	107	107	0	0	1	-360	360;
	2812	2770	0.04025	0.13025	0.01336	114	114	114	0	0	1	-360	360;
	2877	2802	0.03545	0.08736	0.00882	120	120	120	0	0	1	-360	360;
	2996	2995	0.01264	0.03802	0.00273	69	69	69	0	0	1	-360	360;
	2774	2996	0.03306	0.08264	0.00968	69	69	69	0	0	1	-360	360;
	2847	2775	0.04669	0.08182	0.00774	90	90	90	0	0	1	-360	360;
	2726	2716	0.03413	0.05992	0.00566	48	48	48	0	0	1	-360	360;
	2740	2848	0.03587	0.05868	0.00646	90	90	90	0	0	1	-360	360;
	2739	2746	0.1	0.1595	0.01597	57	57	57	0	0	1	-360	360;
	2966	2862	0.0395	0.1281	0.01314	119	119	119	0	0	1	-360	360;
	2848	2715	0.03124	0.05603	0.00563	90	90	90	0	0	1	-360	360;
	2977	2736	0.0214	0.06887	0.00708	69	69	69	0	0	1	-360	360;
	2961	2977	0.01686	0.05427	0.00558	69	69	69	0	0	1	-360	360;
	2876	2977	0.00026	0.00066	7e-05	69	69	69	0	0	1	-360	360;
	2725	2724	0.01223	0.0386	0.0042	69	69	69	0	0	1	-360	360;
	2865	2732	0.02883	0.09322	0.00956	69	69	69	0	0	1	-360	360;
	2775	2942	0.02455	0.07992	0.00823	137	137	137	0	0	1	-360	360;
	2716	2958	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360;
	2958	2991	0.08653	0.11405	0.01019	69	69	69	0	0	1	-360	360;
	2830	2805	0.00785	0.01983	0.00203	120	120	120	0	0	1	-360	360;
	2873	2896	0.01033	0.02653	0.00269	69	69	69	0	0	1	-360	360;
	2850	2873	0.02231	0.05702	0.00576	120	120	120	0	0	1	-360	360;
	2849	2913	0.03099	0.07901	0.00801	120	120	120	0	0	1	-360	360;
	2697	2809	0.00264	0.00752	0.00075	120	120	120	0	0	1	-360	360;
	2799	2779	0.03025	0.06281	0.00061	120	120	120	0	0	1	-360	360;
	2777	2705	0.00331	0.01083	0.00109	114	114	114	0	0	1	-360	360;
	2789	2780	0.04124	0.07231	0.00687	69	69	69	0	0	1	-360	360;
	2778	2713	0.0186	0.0562	0.00581	111	111	111	0	0	1	-360	360;
	2845	2867	0.02479	0.08	0.00823	137	137	137	0	0	1	-360	360;
	2697	2913	0.01314	0.04182	0.00448	120	120	120	0	0	1	-360	360;
	2912	2872	0.00942	0.03066	0.00315	76	76	76	0	0	1	-360	360;
	2911	2840	0.02901	0.09438	0.00966	137	137	137	0	0	1	-360	360;
	2711	2780	0.00421	0.01058	0.00106	120	120	120	0	0	1	-360	360;
	2980	2779	0.00736	0.0238	0.00244	137	137	137	0	0	1	-360	360;
	2979	2697	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2979	2698	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2705	2711	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2844	2831	0.00826	0.02628	0.00286	120	120	120	0	0	1	-360	360;
	2758	2844	0.0181	0.05702	0.0062	120	120	120	0	0	1	-360	360;
	2809	2780	0.00405	0.01058	0.00109	120	120	120	0	0	1	-360	360;
	2702	2698	0.00231	0.00752	0.00077	137	137	137	0	0	1	-360	360;
	2907	2702	0.00397	0.01298	0.00131	137	137	137	0	0	1	-360	360;
	2797	2789	0.00361	0.01166	0.0012	114	114	114	0	0	1	-360	360;
	2919	2797	0.06898	0.12121	0.01145	90	90	90	0	0	1	-360	360;
	2722	2919	0.06661	0.11306	0.01118	69	69	69	0	0	1	-360	360;
	2895	2799	0.01322	0.03306	0.00327	69	69	69	0	0	1	-360	360;
	2991	2895	0.05686	0.09339	0.00944	76	76	76	0	0	1	-360	360;
	2943	2779	0.0376	0.12165	0.01249	137	137	137	0	0	1	-360	360;
	2956	2840	0.03058	0.05372	0.00508	90	90	90	0	0	1	-360	360;
	2873	2782	0.00851	0.02074	0.00232	120	120	120	0	0	1	-360	360;
	2782	2940	0.0405	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2973	2817	0.04008	0.10174	0.01033	99	99	99	0	0	1	-360	360;
	2710	2907	0.00198	0.00628	0.00065	137	137	137	0	0	1	-360	360;
	2696	2710	0.00653	0.02116	0.0022	137	137	137	0	0	1	-360	360;
	2896	2830	0.00926	0.0238	0.00242	69	69	69	0	0	1	-360	360;
	2988	2872	0.06223	0.10413	0.01072	69	69	69	0	0	1	-360	360;
	2787	2988	0.04702	0.07851	0.00808	69	69	69	0	0	1	-360	360;
	2716	2722	0.00545	0.0076	0.00077	69	69	69	0	0	1	-360	360;
	2872	2831	0.0162	0.0338	0.00351	90	90	90	0	0	1	-360	360;
	2911	2889	0.02781	0.08994	0.01845	137	137	137	0	0	1	-360	360;
	2696	2713	0.01397	0.04463	0.00462	137	137	137	0	0	1	-360	360;
	2867	2712	0.00868	0.0281	0.00295	76	76	76	0	0	1	-360	360;
	2906	2919	0.01607	0.05279	0.01083	69	69	69	0	0	1	-360	360;
	2891	2906	0.034	0.10995	0.02256	69	69	69	0	0	1	-360	360;
	2743	2779	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	2744	2780	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	2981	2697	0.00215	0.00719	0.00072	16	16	16	0	0	1	-360	360;
	2903	2780	0.00091	0.00306	0.00031	10	10	10	0	0	1	-360	360;
	2802	2805	0.00661	0.01372	0.00133	120	120	120	0	0	1	-360	360;
	2945	2713	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2709	2716	0.0374	0.12066	0.01272	137	137	137	0	0	1	-360	360;
	2945	2891	0.01928	0.06236	0.0064	137	137	137	0	0	1	-360	360;
	2724	2709	0.02269	0.07306	0.00777	140	140	140	0	0	1	-360	360;
	2735	2973	0.0057	0.01017	0.00094	137	137	137	0	0	1	-360	360;
	2971	2735	0.00967	0.01702	0.0016	137	137	137	0	0	1	-360	360;
	2785	2972	0.05769	0.14545	0.015	76	76	76	0	0	1	-360	360;
	2993	2973	0.00282	0.00717	0.00079	90	90	90	0	0	1	-360	360;
	2824	2993	0.03198	0.07876	0.00786	90	90	90	0	0	1	-360	360;
	2969	2972	0.01843	0.06	0.00615	137	137	137	0	0	1	-360	360;
	2951	2953	0.00554	0.01793	0.00184	137	137	137	0	0	1	-360	360;
	2847	2703	0.03636	0.12066	0.01181	114	114	114	0	0	1	-360	360;
	2953	2947	0.00306	0.00992	0.00102	114	114	114	0	0	1	-360	360;
	2760	2824	0.0676	0.11901	0.0112	69	69	69	0	0	1	-360	360;
	2963	2760	0.03868	0.0681	0.00639	69	69	69	0	0	1	-360	360;
	2892	2824	0.05042	0.10487	0.0102	69	69	69	0	0	1	-360	360;
	2909	2892	0.01976	0.0514	0.00515	69	69	69	0	0	1	-360	360;
	2828	2771	0.02781	0.07968	0.00807	140	140	140	0	0	1	-360	360;
	2963	2828	0.01467	0.03239	0.00328	69	69	69	0	0	1	-360	360;
	2708	2776	0.02231	0.07231	0.01493	75	75	75	0	0	1	-360	360;
	2703	2708	0.01322	0.01777	0.00191	62	62	62	0	0	1	-360	360;
	2944	2771	0.00883	0.02792	0.00305	137	137	137	0	0	1	-360	360;
	2757	2944	0.00688	0.02158	0.0024	137	137	137	0	0	1	-360	360;
	2888	2955	0.01554	0.05455	0.00557	137	137	137	0	0	1	-360	360;
	2950	2904	0.00438	0.01136	0.00098	120	120	120	0	0	1	-360	360;
	2734	2950	0.00515	0.01374	0.00122	120	120	120	0	0	1	-360	360;
	2904	2952	0.00281	0.00702	0.00059	114	114	114	0	0	1	-360	360;
	2721	2968	0.02769	0.0895	0.00917	95	95	95	0	0	1	-360	360;
	2955	2720	0.02132	0.06942	0.00707	137	137	137	0	0	1	-360	360;
	2968	2974	0.01504	0.04132	0.00426	137	137	137	0	0	1	-360	360;
	2954	2951	0.01777	0.05736	0.00588	137	137	137	0	0	1	-360	360;
	2910	2769	0.00736	0.0238	0.00251	114	114	114	0	0	1	-360	360;
	2931	2839	0.00421	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	2703	2909	0.02331	0.07893	0.00745	69	69	69	0	0	1	-360	360;
	2931	2768	0.00273	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	2768	2757	0.00149	0.00496	0.00048	137	137	137	0	0	1	-360	360;
	2723	2771	0.02868	0.09256	0.00951	140	140	140	0	0	1	-360	360;
	2734	2785	0.01364	0.03554	0.0037	120	120	120	0	0	1	-360	360;
	2951	2947	0.00421	0.01355	0.0014	131	131	131	0	0	1	-360	360;
	2887	2954	0.00529	0.01074	0.00111	90	90	90	0	0	1	-360	360;
	2974	2971	0.00934	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2816	2770	0.02124	0.0686	0.00704	140	140	140	0	0	1	-360	360;
	2776	2769	0.0314	0.09884	0.01074	140	140	140	0	0	1	-360	360;
	2818	2947	0.00851	0.02686	0.0029	95	95	95	0	0	1	-360	360;
	2813	2818	0.0181	0.05702	0.0062	95	95	95	0	0	1	-360	360;
	3013	2719	0.00864	0.02821	0.00288	140	140	140	0	0	1	-360	360;
	2819	2972	0.03678	0.09347	0.00949	120	120	120	0	0	1	-360	360;
	2875	2816	0.03364	0.10744	0.01016	107	107	107	0	0	1	-360	360;
	2910	2839	0.00826	0.01653	0.00194	114	114	114	0	0	1	-360	360;
	2968	2984	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2968	2984	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2764	2947	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2765	2948	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2957	2951	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2960	2887	0.0254	0.08216	0.00843	123	123	123	0	0	1	-360	360;
	2960	2719	0.01636	0.05289	0.00558	140	140	140	0	0	1	-360	360;
	2813	2963	0.02041	0.06843	0.00685	123	123	123	0	0	1	-360	360;
	2957	2951	0.00992	0.03488	0.00407	76	76	76	0	0	1	-360	360;
	2970	2931	0.02017	0.05223	0.00545	120	120	120	0	0	1	-360	360;
	2931	2770	0.0095	0.02455	0.00256	114	114	114	0	0	1	-360	360;
	2936	2920	0.00891	0.01566	0.00148	77	77	77	0	0	1	-360	360;
	2928	2930	0.0328	0.07474	0.00784	66	66	66	0	0	1	-360	360;
	2927	2925	0.04351	0.09356	0.00962	66	66	66	0	0	1	-360	360;
	2929	2994	0.07306	0.1919	0.01832	867	867	867	0	0	1	-360	360;
	2930	2851	0.03091	0.08107	0.00774	87	87	87	0	0	1	-360	360;
	2851	2994	0.04207	0.11074	0.01053	87	87	87	0	0	1	-360	360;
	2926	2929	0.01653	0.03306	0.00242	66	66	66	0	0	1	-360	360;
	2821	2730	0.0405	0.07107	0.00673	77	77	77	0	0	1	-360	360;
	2730	2926	0.04628	0.07107	0.0076	77	77	77	0	0	1	-360	360;
	2929	2936	0.00496	0.00826	0.00085	66	66	66	0	0	1	-360	360;
	2822	2821	0.00413	0.01372	0.00138	119	119	119	0	0	1	-360	360;
	2961	2927	0.02394	0.04718	0.00469	66	66	66	0	0	1	-360	360;
	2920	2928	0.00862	0.02752	0.00296	135	135	135	0	0	1	-360	360;
	2833	2994	0.04438	0.07826	0.00739	77	77	77	0	0	1	-360	360;
	2866	2833	0.05661	0.09983	0.00943	66	66	66	0	0	1	-360	360;
	2714	2866	0.01975	0.06215	0.00675	66	66	66	0	0	1	-360	360;
	2745	2714	0.03669	0.06471	0.00611	77	77	77	0	0	1	-360	360;
	2731	2930	0.03587	0.07132	0.00624	77	77	77	0	0	1	-360	360;
	2966	2822	0.03438	0.06099	0.00569	119	119	119	0	0	1	-360	360;
	2745	2731	0.03587	0.07132	0.00624	77	77	77	0	0	1	-360	360;
	2729	2773	0.0204	0.06595	0.00677	135	135	135	0	0	1	-360	360;
	2726	2773	0.01455	0.04747	0.00483	135	135	135	0	0	1	-360	360;
	2750	2874	0.00661	0.0157	0.00169	103	103	103	0	0	1	-360	360;
	2755	2717	0.00983	0.01736	0.0016	137	137	137	0	0	1	-360	360;
	2717	2751	0.03025	0.09752	0.01002	86	86	86	0	0	1	-360	360;
	2792	2752	0.01149	0.03471	0.00293	120	120	120	0	0	1	-360	360;
	2967	2792	0.00826	0.02893	0.00363	120	120	120	0	0	1	-360	360;
	2825	2746	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2825	2841	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2826	2841	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2754	2967	0.01083	0.03471	0.00358	137	137	137	0	0	1	-360	360;
	2763	2754	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2939	2763	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2755	2939	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2717	2989	0.03669	0.11818	0.01217	137	137	137	0	0	1	-360	360;
	2965	2989	0.01721	0.05623	0.00573	137	137	137	0	0	1	-360	360;
	2946	2747	0.03248	0.1081	0.01445	137	137	137	0	0	1	-360	360;
	2934	2746	0.05455	0.18017	0.0242	99	99	99	0	0	1	-360	360;
	2749	2752	0.01917	0.02595	0.00467	69	69	69	0	0	1	-360	360;
	2874	2752	0.01405	0.03636	0.00399	103	103	103	0	0	1	-360	360;
	2900	2751	0.03587	0.09008	0.00924	114	114	114	0	0	1	-360	360;
	2978	2752	0.015	0.04714	0.00466	114	114	114	0	0	1	-360	360;
	2932	2978	0.00525	0.0165	0.00163	114	114	114	0	0	1	-360	360;
	2975	2978	0.00026	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	2901	2964	0.04174	0.07322	0.00692	90	90	90	0	0	1	-360	360;
	2759	2990	0.01705	0.05552	0.00567	137	137	137	0	0	1	-360	360;
	2754	2949	0.00099	0.00347	0.00036	137	137	137	0	0	1	-360	360;
	2882	2932	0.00364	0.01074	0.00106	114	114	114	0	0	1	-360	360;
	2749	2886	0.00463	0.01488	0.00152	137	137	137	0	0	1	-360	360;
	2762	2900	0.00372	0.00934	0.00094	120	120	120	0	0	1	-360	360;
	2755	2762	0.00496	0.01273	0.00128	95	95	95	0	0	1	-360	360;
	2727	2826	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2751	2727	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2752	2933	0.01496	0.0438	0.00445	114	114	114	0	0	1	-360	360;
	2753	2747	0.0076	0.01983	0.00206	120	120	120	0	0	1	-360	360;
	2837	2752	0.03479	0.1119	0.01176	76	76	76	0	0	1	-360	360;
	2946	2837	0.00702	0.0224	0.00237	123	123	123	0	0	1	-360	360;
	2880	2941	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2946	2880	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2823	2829	0.01992	0.05245	0.00519	120	120	120	0	0	1	-360	360;
	2941	2823	0.01187	0.03176	0.00315	120	120	120	0	0	1	-360	360;
	2885	2749	0.00504	0.01686	0.00174	137	137	137	0	0	1	-360	360;
	2694	2749	0.00331	0.01091	0.00111	137	137	137	0	0	1	-360	360;
	2933	2893	0.00777	0.02479	0.00257	137	137	137	0	0	1	-360	360;
	2852	2718	0.00711	0.02314	0.00234	124	124	124	0	0	1	-360	360;
	2886	2853	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2905	2901	0.00645	0.02066	0.00213	137	137	137	0	0	1	-360	360;
	2897	2746	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2898	2747	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2747	2750	0.02074	0.06727	0.00682	137	137	137	0	0	1	-360	360;
	2897	2767	0.00545	0.01736	0.00177	137	137	137	0	0	1	-360	360;
	2747	2694	0.00612	0.0157	0.00157	120	120	120	0	0	1	-360	360;
	2860	2750	0.00132	0.00421	0.00044	137	137	137	0	0	1	-360	360;
	2746	2860	0.00793	0.02231	0.00215	123	123	123	0	0	1	-360	360;
	2767	2885	0.00909	0.02893	0.0029	137	137	137	0	0	1	-360	360;
	2893	2937	0.00736	0.02372	0.00242	137	137	137	0	0	1	-360	360;
	2718	2905	0.00331	0.01074	0.00109	137	137	137	0	0	1	-360	360;
	2949	2794	0.00207	0.00694	0.0007	137	137	137	0	0	1	-360	360;
	2965	2901	0.01132	0.03636	0.00375	137	137	137	0	0	1	-360	360;
	2794	2852	0.00289	0.00926	0.00094	137	137	137	0	0	1	-360	360;
	2853	2882	0.00248	0.00744	0.00073	120	120	120	0	0	1	-360	360;
	2795	2753	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	2937	2795	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	2862	2990	0.00165	0.00496	0.00053	137	137	137	0	0	1	-360	360;
	2725	2934	0.0395	0.12455	0.01176	38	38	38	0	0	1	-360	360;
	2790	2752	0.0395	0.06959	0.00657	72	72	72	0	0	1	-360	360;
	2788	2790	0.05306	0.09355	0.00884	72	72	72	0	0	1	-360	360;
	2924	2788	0.03293	0.1065	0.01093	137	137	137	0	0	1	-360	360;
	2923	2788	0.05807	0.10306	0.00937	76	76	76	0	0	1	-360	360;
	2934	2924	0.02444	0.07902	0.00811	137	137	137	0	0	1	-360	360;
	2704	2989	0.02139	0.06954	0.00729	120	120	120	0	0	1	-360	360;
	2908	2751	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2749	2983	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2750	2982	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2881	2747	0.01281	0.02149	0.00212	78	78	78	0	0	1	-360	360;
	2715	2881	0.0262	0.04397	0.00434	78	78	78	0	0	1	-360	360;
	2842	2699	0.03905	0.12628	0.01297	95	95	95	0	0	1	-360	360;
	2976	2858	0.01165	0.03769	0.00387	137	137	137	0	0	1	-360	360;
	2699	2976	0.0214	0.06917	0.0071	137	137	137	0	0	1	-360	360;
	2707	2976	0.00281	0.00917	0.00094	123	123	123	0	0	1	-360	360;
	2938	2857	0.15802	0.18273	0.01643	46	46	46	0	0	1	-360	360;
	2834	2858	0.00498	0.01612	0.00165	137	137	137	0	0	1	-360	360;
	2756	2854	0.01039	0.05083	0.00494	133	133	133	0	0	1	-360	360;
	2827	2854	0.03603	0.12893	0.01251	69	69	69	0	0	1	-360	360;
	2732	2857	0.02234	0.07496	0.00748	69	69	69	0	0	1	-360	360;
	2695	2827	0.0414	0.06942	0.00711	69	69	69	0	0	1	-360	360;
	2766	2827	0.03314	0.06116	0.00639	69	69	69	0	0	1	-360	360;
	2804	2695	0.03769	0.12149	0.01249	69	69	69	0	0	1	-360	360;
	2807	2804	0.01942	0.06281	0.00649	69	69	69	0	0	1	-360	360;
	2859	2854	0.03587	0.1157	0.0122	140	140	140	0	0	1	-360	360;
	2783	2855	0.03025	0.09752	0.01028	140	140	140	0	0	1	-360	360;
	2820	2775	0.00983	0.01727	0.00163	69	69	69	0	0	1	-360	360;
	2864	2820	0.05322	0.09347	0.00882	69	69	69	0	0	1	-360	360;
	2868	2861	0.00661	0.01372	0.00133	69	69	69	0	0	1	-360	360;
	2861	2869	0.00537	0.01736	0.00179	69	69	69	0	0	1	-360	360;
	2842	2807	0.02339	0.07587	0.00784	57	57	57	0	0	1	-360	360;
	2869	2857	0.01157	0.03769	0.00387	69	69	69	0	0	1	-360	360;
	2843	2855	0.0331	0.11107	0.01106	114	114	114	0	0	1	-360	360;
	2846	2859	0.02818	0.09116	0.00934	69	69	69	0	0	1	-360	360;
	2864	2756	0.02446	0.04347	0.00404	69	69	69	0	0	1	-360	360;
	2863	2858	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2835	2868	0.00507	0.01627	0.00168	137	137	137	0	0	1	-360	360;
	2843	2838	0.0205	0.06876	0.00688	69	69	69	0	0	1	-360	360;
	2902	2806	0.01568	0.0507	0.0052	84	84	84	0	0	1	-360	360;
	2854	2857	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2855	2858	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2835	2783	0.01012	0.03265	0.00336	137	137	137	0	0	1	-360	360;
	2870	2834	0.00118	0.00382	0.00039	57	57	57	0	0	1	-360	360;
	2871	2835	0.0011	0.00355	0.00037	57	57	57	0	0	1	-360	360;
	2701	2738	0.02355	0.06215	0.00639	82	82	82	0	0	1	-360	360;
	2784	2701	0.0276	0.0495	0.00448	69	69	69	0	0	1	-360	360;
	2761	2784	0.03967	0.07157	0.00641	69	69	69	0	0	1	-360	360;
	2796	2761	0.02983	0.05793	0.00547	69	69	69	0	0	1	-360	360;
	2801	2737	0.00926	0.03008	0.00307	123	123	123	0	0	1	-360	360;
	2922	2916	0.05314	0.09339	0.0089	69	69	69	0	0	1	-360	360;
	2798	2801	0.00132	0.00421	0.00044	119	119	119	0	0	1	-360	360;
	2800	2738	0.00909	0.02975	0.00302	119	119	119	0	0	1	-360	360;
	2736	2737	0.05504	0.1643	0.01682	69	69	69	0	0	1	-360	360;
	2986	2733	0.03653	0.06413	0.00605	69	69	69	0	0	1	-360	360;
	2815	2800	0.01595	0.05124	0.0053	140	140	140	0	0	1	-360	360;
	2815	2798	0.00744	0.02397	0.00246	123	123	123	0	0	1	-360	360;
	2884	2774	0.03669	0.11669	0.01251	69	69	69	0	0	1	-360	360;
	2986	2922	0.08314	0.14628	0.01392	69	69	69	0	0	1	-360	360;
	2962	2737	0.02688	0.08734	0.00915	140	140	140	0	0	1	-360	360;
	2815	2921	0.03347	0.06529	0.00593	140	140	140	0	0	1	-360	360;
	2793	2796	0.00521	0.01413	0.0014	90	90	90	0	0	1	-360	360;
	2796	2962	0.01843	0.0619	0.0062	140	140	140	0	0	1	-360	360;
	2728	2986	0.00182	0.00388	0.00027	76	76	76	0	0	1	-360	360;
	2915	2916	0.00347	0.01264	0.00119	69	69	69	0	0	1	-360	360;
	2700	2918	0.0376	0.09174	0.00968	69	69	69	0	0	1	-360	360;
	2884	2917	0.01967	0.08612	0.00924	57	57	57	0	0	1	-360	360;
	2803	2914	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	2803	2915	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	2959	2737	0.01463	0.05661	0.00653	140	140	140	0	0	1	-360	360;
	2742	2987	0.00331	0.01058	0.00109	137	137	137	0	0	1	-360	360;
	2899	2742	0.02975	0.09587	0.01007	137	137	137	0	0	1	-360	360;
	2832	2899	0.00512	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2808	2848	0.03347	0.06529	0.00593	21	21	21	0	0	1	-360	360;
	2706	2883	0.01653	0.0314	0.0029	48	48	48	0	0	1	-360	360;
	2890	2706	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2883	2740	0.01653	0.0314	0.00315	48	48	48	0	0	1	-360	360;
	2865	2890	0.02288	0.074	0.00759	69	69	69	0	0	1	-360	360;
	2987	2739	0.00165	0.00529	0.00053	137	137	137	0	0	1	-360	360;
	2741	2740	0.00909	0.0281	0.00288	133	133	133	0	0	1	-360	360;
	2814	2810	0.00405	0.01331	0.00138	95	95	95	0	0	1	-360	360;
	2836	2814	0.02074	0.06628	0.00699	126	126	126	0	0	1	-360	360;
	2942	2836	0.02835	0.09223	0.00951	137	137	137	0	0	1	-360	360;
	3005	2810	0.03017	0.09764	0.01004	140	140	140	0	0	1	-360	360;
	2878	2741	0.02041	0.06612	0.00678	95	95	95	0	0	1	-360	360;
	2791	2942	0.01338	0.04326	0.00444	140	140	140	0	0	1	-360	360;
	3001	2173	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	3002	2174	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	3003	1656	0.01041	0.03355	0.00354	114	114	114	0	0	1	-360	360;
	3004	2093	0.00975	0.0305	0.00315	140	140	140	0	0	1	-360	360;
	2998	1747	0.00256	0.00826	0.00087	114	114	114	0	0	1	-360	360;
	3000	2998	0.00306	0.01	0.00105	114	114	114	0	0	1	-360	360;
	2997	2998	0.00025	0.00091	8e-05	114	114	114	0	0	1	-360	360;
	2999	1748	0.0057	0.01826	0.00192	114	114	114	0	0	1	-360	360;
	2832	3005	0.01103	0.03572	0.00367	140	140	140	0	0	1	-360	360;
	2947	3013	0.00934	0.0305	0.00311	140	140	140	0	0	1	-360	360;
	2964	2759	0.00543	0.01774	0.00181	140	140	140	0	0	1	-360	360;
	4	3	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	7	6	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	9	8	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	12	11	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	15	14	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	16	15	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	20	19	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	23	22	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	25	24	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	27	26	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	29	28	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	31	30	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	33	32	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	35	34	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	39	38	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	41	40	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	43	42	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	45	44	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	48	47	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	52	51	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	55	54	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	59	57	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	58	57	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	61	60	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	64	63	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	67	66	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	69	68	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	71	70	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	73	72	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	75	74	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	77	76	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	79	78	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	81	80	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	89	88	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	91	90	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	93	92	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	97	96	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	99	98	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	102	101	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	104	103	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	106	105	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	108	107	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	110	109	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	112	111	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	114	113	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	116	115	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	118	117	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	120	119	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	122	121	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	124	123	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	126	125	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	129	128	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	131	130	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	133	132	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	135	134	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	137	136	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	139	138	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	141	140	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	143	142	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	145	144	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	147	146	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	149	148	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	155	154	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	157	156	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	160	159	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	162	161	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	165	164	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	167	166	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	170	169	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	172	173	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	175	174	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	177	176	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	179	178	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	181	180	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	182	181	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	184	183	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	186	185	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	190	189	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	192	191	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	195	194	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	197	196	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	199	198	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	201	200	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	203	202	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	206	205	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	210	209	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	214	213	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	216	215	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	219	218	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	221	220	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	226	225	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	230	229	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	233	232	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	235	234	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	237	236	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	239	238	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	241	240	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	243	242	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	247	246	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	249	248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	251	250	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	261	260	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	264	263	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	266	265	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	283	282	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	285	284	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	289	288	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	292	291	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	294	293	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	296	295	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	303	302	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	306	305	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	309	308	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	312	311	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	326	325	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	338	337	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	341	340	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	343	342	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	350	349	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	356	355	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	363	362	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	390	389	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	395	394	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	397	396	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	405	404	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	407	406	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	413	412	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	415	414	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	420	419	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	441	440	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	446	445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	448	447	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	450	449	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	451	450	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	460	459	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	463	462	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	467	466	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	473	472	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	496	495	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	507	506	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	516	515	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	520	519	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	528	527	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	533	532	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	538	537	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	542	541	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	552	551	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	555	554	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	561	560	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	563	562	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	571	570	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	573	572	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	578	577	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	583	582	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	593	592	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	596	595	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	604	603	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	606	605	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	610	609	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	612	611	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	614	613	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	616	615	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	621	620	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	623	622	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	627	626	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	632	631	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	636	635	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	643	642	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	645	644	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	647	646	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	649	648	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	651	650	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	653	652	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	655	654	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	657	656	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	659	658	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	662	661	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	668	667	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	675	674	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	677	676	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	679	678	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	681	680	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	685	684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	687	686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	689	688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	691	690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	698	697	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	702	700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	733	732	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	736	735	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	742	741	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	745	744	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	747	746	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	754	753	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	756	755	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	762	761	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	769	768	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	771	770	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	776	775	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	786	785	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	790	789	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	847	846	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	852	851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	855	854	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	871	870	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	883	882	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	889	888	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	903	902	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	906	905	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	923	922	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	935	934	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	951	950	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	955	954	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	961	960	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	967	966	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	977	976	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	994	993	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1001	1000	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1042	1041	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1058	1057	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1061	1060	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1063	1062	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1064	1063	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1066	1065	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1068	1067	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1072	1071	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1074	1073	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1079	1078	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1081	1080	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1086	1085	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1088	1087	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1093	1092	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1101	1100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1103	1102	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1106	1105	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1108	1107	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1114	1113	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1116	1115	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1118	1117	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1128	1127	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1130	1129	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1138	1137	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1140	1139	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1145	1144	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1147	1146	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1149	1148	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1153	1152	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1155	1154	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1157	1156	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1162	1161	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1167	1166	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1169	1168	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1173	1172	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1175	1174	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1177	1176	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1179	1178	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1183	1182	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1185	1184	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1187	1186	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1191	1190	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1193	1192	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1195	1194	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1199	1198	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1201	1200	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1203	1202	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1207	1206	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1213	1212	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1217	1216	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1219	1218	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1221	1220	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1223	1222	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1225	1224	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1232	1231	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1238	1237	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1239	1238	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1249	1248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1255	1254	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1257	1256	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1261	1260	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1263	1262	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1265	1264	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1271	1270	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1275	1274	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1278	1277	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1280	1279	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1283	1282	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1285	1284	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1287	1286	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1289	1288	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1291	1290	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1293	1292	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1295	1294	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1302	1301	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1304	1303	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1312	1311	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1318	1317	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1324	1323	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1326	1325	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1334	1333	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1336	1335	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1350	1349	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1352	1351	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1363	1362	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1364	1363	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1368	1367	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1370	1369	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1375	1374	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1386	1385	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1392	1391	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1394	1393	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1403	1402	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1407	1406	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1416	1415	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1423	1422	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1426	1425	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1428	1427	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1430	1429	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1432	1431	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1434	1433	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1436	1435	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1442	1441	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1446	1445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1452	1451	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1456	1455	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1458	1457	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1462	1461	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1466	1465	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1468	1467	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1470	1469	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1472	1471	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1480	1479	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1482	1481	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1486	1485	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1488	1487	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1490	1489	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1492	1491	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1500	1499	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1502	1501	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1504	1503	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1508	1507	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1515	1514	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1517	1516	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1519	1518	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1521	1520	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1523	1522	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1525	1524	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1527	1526	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1529	1528	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1531	1530	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1533	1532	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1537	1536	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1539	1538	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1541	1540	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1549	1548	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1557	1556	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1559	1558	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1561	1560	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1563	1562	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1565	1564	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1570	1569	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1577	1576	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1582	1581	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1588	1587	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1592	1591	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1594	1593	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1596	1595	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1602	1601	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1605	1604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1607	1606	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1609	1608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1611	1610	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1613	1612	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1617	1616	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1619	1618	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1621	1620	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1623	1622	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1627	1626	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1632	1631	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1638	1637	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1640	1639	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1646	1645	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1648	1647	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1650	1649	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1652	1651	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1654	1653	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1656	1655	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1665	1664	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1667	1666	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1675	1674	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1677	1676	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1679	1678	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1681	1680	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1683	1682	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1685	1684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1687	1686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1689	1688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1691	1690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1699	1698	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1701	1700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1703	1702	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1705	1704	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1709	1708	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1711	1710	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1715	1714	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1717	1716	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1719	1718	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1721	1720	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1723	1722	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1725	1724	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1729	1728	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1736	1735	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1740	1739	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1742	1741	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1744	1743	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1746	1745	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1748	1747	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1750	1749	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1752	1751	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1760	1759	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1766	1765	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1770	1769	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1772	1771	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1778	1777	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1780	1779	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1782	1781	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1786	1785	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1792	1791	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1794	1793	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1796	1795	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1802	1801	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1804	1803	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1808	1807	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1810	1809	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1812	1811	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1814	1813	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1816	1815	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1818	1817	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1820	1819	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1822	1821	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1826	1825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1830	1829	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1832	1831	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1834	1833	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1836	1835	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1840	1839	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1842	1841	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1846	1845	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1848	1847	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1852	1851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1854	1853	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1856	1855	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1858	1857	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1861	1860	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1863	1862	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1865	1864	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1873	1872	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1878	1877	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1882	1881	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1888	1887	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1891	1890	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1893	1892	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1897	1896	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1899	1898	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1904	1903	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1906	1905	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1908	1907	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1915	1914	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1921	1920	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1923	1922	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1932	1931	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1934	1933	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1940	1939	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1942	1941	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1946	1945	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1952	1951	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1954	1953	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1956	1955	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1961	1960	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1963	1962	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1965	1964	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1971	1970	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1973	1972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1975	1974	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1977	1976	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1979	1978	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1981	1980	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1983	1982	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1987	1986	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1989	1988	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1993	1992	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1995	1994	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1997	1996	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1999	1998	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2001	2000	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2003	2002	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2005	2004	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2011	2010	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2013	2012	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2015	2014	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2019	2018	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2023	2022	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2028	2027	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2030	2029	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2032	2031	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2034	2033	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2036	2035	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2038	2037	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2046	2045	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2048	2047	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2050	2049	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2052	2051	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2057	2056	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2059	2058	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2061	2060	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2070	2069	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2072	2071	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2074	2073	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2076	2075	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2078	2077	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2080	2079	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2087	2086	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2089	2088	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2101	2100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2103	2102	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2105	2104	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2107	2106	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2109	2108	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2113	2112	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2115	2114	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2117	2116	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2119	2118	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2121	2120	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2123	2122	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2125	2124	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2127	2126	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2129	2128	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2131	2130	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2138	2137	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2140	2139	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2142	2141	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2146	2145	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2148	2147	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2153	2152	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2160	2159	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2165	2164	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2168	2167	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2171	2170	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2188	2187	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2200	2199	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2208	2207	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2217	2216	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2219	2218	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2223	2222	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2234	2233	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2237	2236	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2243	2242	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2249	2248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2251	2250	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2259	2258	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2268	2267	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2273	2272	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2277	2276	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2299	2298	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2314	2313	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2331	2330	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2335	2334	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2340	2339	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2346	2345	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2352	2351	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2360	2359	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2367	2366	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2376	2375	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2378	2377	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2432	2431	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2444	2443	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2452	2451	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2457	2456	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2460	2459	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2465	2464	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2471	2470	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2482	2481	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2489	2488	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2493	2492	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2498	2497	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2509	2508	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2513	2512	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2516	2515	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2524	2523	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2526	2525	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2550	2549	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2579	2578	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2581	2580	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2586	2585	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2589	2588	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2597	2596	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2605	2604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2609	2608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2619	2618	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2629	2628	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2667	2666	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2669	2668	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2671	2670	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2687	2686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2701	2700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2713	2712	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2718	2717	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2738	2737	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2740	2739	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2755	2754	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2770	2769	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2771	2770	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2780	2779	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2787	2786	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2807	2806	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2812	2810	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2810	2811	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2831	2830	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2855	2854	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2858	2857	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2873	2872	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2879	2878	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3000	2999	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2928	2927	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2930	2929	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2948	2947	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2969	2968	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2973	2972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2985	2984	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2990	2989	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2995	2994	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2698	2697	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2915	2914	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2912	2911	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2778	2777	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2980	2979	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2953	2952	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2992	2991	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2935	2934	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2826	2825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2721	2720	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2888	2887	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2835	2834	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	223	222	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	2179	2178	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	1;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
