function mpc = case3375wp
%CASE3375WP  Power flow data for Polish system - winter 2007-08 evening peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   winter 2007-08 evening peak conditions and includes some equivalents
%   of the German, Czech and Slovak networks.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case3375wp.m,v 1.1 2011/10/31 14:14:35 cvs Exp $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	10000	1	0	0	0	0	0	1.04687	-10.70488	400	0	1.05	0.95;
	10001	1	0	0	0	0	0	1.04837	-15.04781	400	0	1.05	0.95;
	10002	1	0	0	0	0	0	1.07251	-16.96552	220	0	1.11	0.95;
	10003	1	0	0	0	0	0	1.04525	-17.93119	400	0	1.05	0.95;
	10004	1	0	0	0	0	0	1.04396	-13.97333	400	0	1.05	0.95;
	10005	1	0	0	0	0	0	1.04437	-16.49872	400	0	1.05	0.95;
	10006	1	0	0	0	0	0	1.04078	-9.90352	400	0	1.05	0.95;
	10007	1	0	0	0	0	0	1.07323	-15.91864	220	0	1.11	0.95;
	10008	1	0	0	0	0	0	1.07074	-18.07504	220	0	1.11	0.95;
	10009	1	0	0	0	0	0	1.04438	-17.28051	400	0	1.05	0.95;
	10010	1	0	0	0	0	0	1.04912	-12.07385	400	0	1.05	0.95;
	10011	1	0	0	0	0	0	1.04471	-18.59454	400	0	1.05	0.95;
	10012	1	0	0	0	0	0	1.04471	-18.59454	400	0	1.05	0.95;
	10013	1	0	0	0	0	0	1.04559	-12.19767	400	0	1.05	0.95;
	10014	1	0	0	0	0	0	1.0458	-12.22917	400	0	1.05	0.95;
	10015	1	0	0	0	0	0	1.0447	-18.15425	400	0	1.05	0.95;
	10016	1	0	0	0	0	0	1.04578	-12.11669	400	0	1.05	0.95;
	10017	1	0	0	0	0	0	1.04572	-12.12076	400	0	1.05	0.95;
	10018	1	0	0	0	0	0	1.0457	-12.11351	400	0	1.05	0.95;
	10019	1	0	0	0	0	0	1.0458	-12.2292	400	0	1.05	0.95;
	10020	1	0	0	0	0	0	1.05	-14.07745	400	0	1.05	0.95;
	10021	1	0	0	0	0	0	1.07631	-16.60737	220	0	1.11	0.95;
	10022	1	0	0	0	0	0	1.07483	-17.01984	220	0	1.11	0.95;
	10023	1	0	0	0	0	0	1.04582	-11.75662	400	0	1.05	0.95;
	10024	1	0	0	0	0	0	1.04557	-11.85608	400	0	1.05	0.95;
	10025	1	0	0	0	0	0	1.04573	-11.8032	400	0	1.05	0.95;
	10026	1	0	0	0	0	0	1.04137	-8.03514	400	0	1.05	0.95;
	10027	1	0	0	0	0	0	1.04176	-7.76212	400	0	1.05	0.95;
	10028	1	0	0	0	0	0	1.04187	-7.56465	400	0	1.05	0.95;
	10029	1	0	0	0	0	0	1.04913	-11.5362	400	0	1.05	0.95;
	10030	1	0	0	0	0	0	1.04912	-11.53101	400	0	1.05	0.95;
	10031	1	0	0	0	0	0	1.08683	-11.59324	220	0	1.11	0.95;
	10032	1	0	0	0	0	0	1.04142	-8.05065	400	0	1.05	0.95;
	10033	1	0	0	0	0	0	1.04141	-8.05055	400	0	1.05	0.95;
	10034	1	0	0	0	0	0	1.0426	-14.14929	400	0	1.05	0.95;
	10035	1	0	0	0	0	0	1.07253	-12.37237	220	0	1.11	0.95;
	10036	1	0	0	0	0	0	1.07259	-12.38001	220	0	1.11	0.95;
	10037	1	0	0	0	0	0	1.04141	-8.14861	400	0	1.05	0.95;
	10038	1	0	0	0	0	0	1.04145	-8.15657	400	0	1.05	0.95;
	10039	1	0	0	0	0	0	1.04189	-8.20445	400	0	1.05	0.95;
	10040	1	0	0	0	0	0	1.04506	-12.91957	400	0	1.05	0.95;
	10041	1	0	0	0	0	0	1.04919	-11.66977	400	0	1.05	0.95;
	10042	1	0	0	0	0	0	1.04486	-18.81658	400	0	1.05	0.95;
	10043	1	0	0	0	0	0	1.06595	-14.1772	220	0	1.11	0.95;
	10044	1	0	0	0	0	0	1.07305	-13.3306	220	0	1.11	0.95;
	10045	1	0	0	0	0	0	1.06741	-18.93627	220	0	1.11	0.95;
	10046	1	0	0	0	0	0	1.07479	-17.01935	220	0	1.11	0.95;
	10047	1	0	0	0	0	0	1.04347	-19.72898	400	0	1.05	0.95;
	10048	1	0	0	0	0	0	1.04593	-11.20792	400	0	1.05	0.95;
	10049	1	0	0	0	0	0	1.04881	-11.71874	400	0	1.05	0.95;
	10050	1	0	0	0	0	0	1.04919	-11.66977	400	0	1.05	0.95;
	10051	1	0	0	0	0	0	1.06435	-18.64806	220	0	1.11	0.95;
	10052	1	0	0	0	0	0	1.04276	-16.39521	400	0	1.05	0.95;
	10053	1	0	0	0	0	0	1.08851	-11.03458	220	0	1.11	0.95;
	10054	1	0	0	0	0	0	1.08851	-11.03458	220	0	1.11	0.95;
	10055	1	0	0	0	0	0	1.08025	-14.93844	220	0	1.11	0.95;
	10056	1	0	0	0	0	0	1.04177	-10.15342	400	0	1.05	0.95;
	10057	1	0	0	0	0	0	1.0397	-9.14536	400	0	1.05	0.95;
	10058	1	0	0	0	0	0	1.05983	-16.70686	220	0	1.11	0.95;
	10059	1	0	0	0	0	0	1.05	-15.8165	400	0	1.05	0.95;
	10060	1	0	0	0	0	0	1.04143	-8.15259	400	0	1.05	0.95;
	10061	1	0	0	0	0	0	1.04177	-10.15342	400	0	1.05	0.95;
	10062	1	0	0	0	0	0	1.04302	-15.75403	400	0	1.05	0.95;
	10063	1	0	0	0	0	0	1.04579	-12.22916	400	0	1.05	0.95;
	10064	1	0	0	0	0	0	1.06571	-16.28209	220	0	1.11	0.95;
	10065	1	0	0	0	0	0	1.04673	-13.53303	400	0	1.05	0.95;
	10066	1	0	0	0	0	0	1.04876	-12.21379	400	0	1.05	0.95;
	10067	1	0	0	0	0	0	1.06752	-15.36971	220	0	1.11	0.95;
	10068	1	0	0	0	0	0	1.04901	-13.12103	400	0	1.05	0.95;
	10069	1	0	0	0	0	0	1.06642	-19.22427	220	0	1.11	0.95;
	10070	1	0	0	0	0	0	1.04467	-18.59429	400	0	1.05	0.95;
	10071	2	16	8	0	0	0	1.07617	-15.28959	220	0	1.11	0.95;
	10072	1	0	0	0	0	0	1.08597	-11.76891	220	0	1.11	0.95;
	10073	1	0	0	0	0	1	1.0747	-13.36695	220	0	1.11	0.95;
	10074	1	0	0	0	0	0	1.07385	-13.34281	220	0	1.11	0.95;
	10075	1	0	0	0	0	0	1.07257	-14.1716	220	0	1.11	0.95;
	10076	1	0	0	0	0	0	1.04556	-11.85601	400	0	1.05	0.95;
	10077	1	0	0	0	0	0	1.04556	-11.85601	400	0	1.05	0.95;
	10078	1	305.5	-14	0	0	0	1.03456	-8.21584	400	0	1.05	0.95;
	10079	2	-1529.6	4542.9	0	0	0	1.01319	-0.05172	400	0	1.05	0.95;
	10080	2	-159.1	-181	0	0	0	1.02855	-4.88451	400	0	1.05	0.95;
	10081	1	-1078.3	-374.1	0	0	0	1.03447	-0.91888	400	0	1.05	0.95;
	10082	1	943.2	310.2	0	0	0	1.00371	-4.43737	400	0	1.05	0.95;
	10083	1	97	26	0	0	0	1.04136	-5.54383	400	0	1.05	0.95;
	10084	1	0.6	160	0	0	0	1.04213	-5.41022	400	0	1.05	0.95;
	10085	1	161.6	183.6	0	0	0	1.04114	-5.52506	400	0	1.05	0.95;
	10086	1	288.6	221.6	0	0	0	1.04113	-5.52774	400	0	1.05	0.95;
	10087	1	0	0	0	0	0	1.0431	-5.31775	400	0	1.05	0.95;
	10088	1	0	0	0	0	0	1.08895	-5.62324	220	0	1.11	0.95;
	10089	1	0	0	0	0	0	1.08671	-5.74853	220	0	1.11	0.95;
	10090	2	274.4	279.6	0	0	0	1.04139	-5.51893	400	0	1.05	0.95;
	10091	1	94.2	111.8	0	0	0	1.04083	-5.53521	400	0	1.05	0.95;
	10092	1	0	0	0	0	0	1.0851	-5.81601	220	0	1.11	0.95;
	10093	1	0	0	0	0	0	1.08774	-5.67067	220	0	1.11	0.95;
	10094	2	0	0	0	0	0	1.03526	-4.64081	400	0	1.05	0.95;
	10095	2	4.4	-2590.1	0	0	0	1.02969	-6.03574	400	0	1.05	0.95;
	10096	1	488	79.1	0	0	0	1.02127	-6.23895	400	0	1.05	0.95;
	10097	1	601	147.9	0	0	0	1.02468	-6.14923	400	0	1.05	0.95;
	10098	1	527	265.1	0	0	0	1.02591	-5.42562	400	0	1.05	0.95;
	10099	1	0	0	0	0	0	1.00482	-2.42812	400	0	1.05	0.95;
	10100	2	0	0	0	0	0	1.04073	-0.86289	400	0	1.05	0.95;
	10101	1	0	0	0	0	0	1.03993	-13.17887	220	0	1.11	0.95;
	10102	1	120	25	0	0	0	1.0587	-7.39157	220	0	1.11	0.95;
	10103	1	0	0	0	0	0	1.03974	-3.47171	400	0	1.05	0.95;
	10104	2	200.2	48.7	0	0	0	1.04409	-2.35603	400	0	1.05	0.95;
	10105	1	0	0	0	0	0	1.06465	-7.80747	220	0	1.11	0.95;
	10106	1	0	0	0	0	0	1.03444	-4.47152	400	0	1.05	0.95;
	10107	1	0	0	0	0	0	1.04224	-3.12182	400	0	1.05	0.95;
	10108	1	0	0	0	0	0	1.04282	-2.80538	400	0	1.05	0.95;
	10109	1	0	0	0	0	0	1.0422	-3.04523	400	0	1.05	0.95;
	10110	1	0	0	0	0	0	1.0428	-2.72415	400	0	1.05	0.95;
	10111	1	0	0	0	0	0	1.02625	-1.81906	400	0	1.05	0.95;
	10112	1	0	0	0	0	0	1.10809	-5.03261	220	0	1.11	0.95;
	10113	1	0	0	0	0	0	1.01806	-2.51227	400	0	1.05	0.95;
	10114	1	0	0	0	0	0	1.09061	-6.95533	220	0	1.11	0.95;
	10115	2	0	0	0	0	0	1.00234	-2.20727	400	0	1.05	0.95;
	10116	2	0	0	0	0	0	1.00234	-2.20727	400	0	1.05	0.95;
	10117	1	0	0	0	0	0	1.03218	-5.38558	400	0	1.05	0.95;
	10118	2	0	0	0	0	0	1.04097	-0.52486	400	0	1.05	0.95;
	10119	1	0	0	0	0	0	1.01219	-3.2983	400	0	1.05	0.95;
	10120	1	0	0	0	0	0	1.03983	-3.96258	400	0	1.05	0.95;
	10121	1	80	20	0	0	0	1.05717	-6.34415	220	0	1.11	0.95;
	10122	1	0	0	0	0	0	1.05022	-9.78444	220	0	1.11	0.95;
	10123	1	0	0	0	0	0	1.04891	-3.71076	400	0	1.05	0.95;
	10124	1	0	0	0	0	0	1.05	-0.9584	400	0	1.05	0.95;
	10125	1	0	0	0	0	0	1.01317	-4.39221	400	0	1.05	0.95;
	10126	2	0	0	0	0	0	1.00802	-3.54138	400	0	1.05	0.95;
	10127	1	0	0	0	0	0	1.09612	-7.22408	220	0	1.11	0.95;
	10128	1	0	0	0	0	0	1.09612	-7.22408	220	0	1.11	0.95;
	10129	2	0.2	100	0	0	0	1.04538	0.02453	400	0	1.05	0.95;
	10130	1	0	0	0	0	0	1.04546	-0.00196	400	0	1.05	0.95;
	10131	1	0	0	0	0	0	1.00966	-4.04069	400	0	1.05	0.95;
	10132	2	0	0	0	0	0	1.02908	-4.54928	400	0	1.05	0.95;
	10133	1	0	0	0	0	0	1.05	-4.33366	400	0	1.05	0.95;
	10134	1	0	0	0	0	0	1.04707	-4.96621	400	0	1.05	0.95;
	10135	1	0	0	0	0	0	1.05137	-5.13694	220	0	1.11	0.95;
	10136	1	0	0	0	0	0	1.07164	-7.48745	220	0	1.11	0.95;
	10137	1	0	0	0	0	0	1.03873	-15.98919	220	0	1.11	0.95;
	10138	1	0	0	0	0	0	1.03401	-5.16183	400	0	1.05	0.95;
	10139	2	0	0	0	0	0	1.03742	-1.81786	400	0	1.05	0.95;
	10140	2	0	0	0	0	0	1.03856	-1.33469	400	0	1.05	0.95;
	10141	2	0	0	0	0	0	1.01264	-1.61676	400	0	1.05	0.95;
	10142	1	0	0	0	0	0	1.03744	-4.88394	400	0	1.05	0.95;
	10143	1	0	0	0	0	0	1.03597	-3.0404	400	0	1.05	0.95;
	10144	1	0	0	0	0	0	1.03599	-3.03915	400	0	1.05	0.95;
	10145	1	0	0	0	0	0	1.01027	-3.74196	400	0	1.05	0.95;
	10146	2	0	0	0	0	0	1.04296	-3.5178	220	0	1.11	0.95;
	10147	1	0	0	0	0	0	1.03128	-5.37046	400	0	1.05	0.95;
	10148	1	0	0	0	0	0	1.07357	-7.15426	220	0	1.11	0.95;
	10149	1	0	0	0	0	0	1.07355	-7.15711	220	0	1.11	0.95;
	10150	2	0	0	0	0	0	1.04015	-3.34555	400	0	1.05	0.95;
	10151	1	0	0	0	0	0	1.04146	-3.0972	400	0	1.05	0.95;
	10152	1	0	0	0	0	0	1.04668	-1.42588	400	0	1.05	0.95;
	10153	1	0	0	0	0	0	1.03101	-2.84339	400	0	1.05	0.95;
	10154	1	80	20	0	0	0	1.03599	-4.25547	220	0	1.11	0.95;
	10155	1	0	0	0	0	0	1.08192	-7.36524	220	0	1.11	0.95;
	10156	1	0	0	0	0	0	1.03079	-5.15792	400	0	1.05	0.95;
	10157	1	0	0	0	0	0	1.08715	-5.5406	220	0	1.11	0.95;
	10158	1	0	0	0	0	0	1.01375	-2.96684	400	0	1.05	0.95;
	10159	1	0	0	0	0	0	1.11	-4.89462	220	0	1.11	0.95;
	10160	1	0	0	0	0	0	1.0642	-17.66826	220	0	1.11	0.95;
	10161	1	0	0	0	0	0	1.02091	-4.68112	400	0	1.05	0.95;
	10162	1	0	0	0	0	0	1.05927	-8.90546	220	0	1.11	0.95;
	10163	1	0	0	0	0	0	1.09451	-7.44737	220	0	1.11	0.95;
	10164	1	0	0	0	0	0	1.02895	-4.92842	400	0	1.05	0.95;
	10165	1	0	0	0	0	0	1.03338	-5.57007	400	0	1.05	0.95;
	10166	1	0	0	0	0	0	1.06606	-6.42146	220	0	1.11	0.95;
	10167	1	0	0	0	0	0	1.02906	-5.04152	400	0	1.05	0.95;
	10168	1	0	0	0	0	0	1.02906	-5.04152	400	0	1.05	0.95;
	10169	1	0	0	0	0	0	1.02941	-4.99501	400	0	1.05	0.95;
	10170	1	0	0	0	0	0	1.02941	-4.99501	400	0	1.05	0.95;
	10171	2	-104.8	-159	0	0	0	1.02955	-4.63616	400	0	1.05	0.95;
	10172	1	247.4	-57.5	0	0	0	1.02972	-6.04019	400	0	1.05	0.95;
	10173	1	247.4	-57.5	0	0	0	1.02972	-6.04019	400	0	1.05	0.95;
	10174	1	371.5	403.5	0	0	0	1.02061	-6.26044	400	0	1.05	0.95;
	10176	2	-249.9	162.6	0	0	0	1.02979	-4.79163	400	0	1.05	0.95;
	10177	2	-249.9	162.6	0	0	0	1.02979	-4.79163	400	0	1.05	0.95;
	10178	1	52.5	207.2	0	0	0	1.02727	-10.4183	400	0	1.05	0.95;
	10179	1	379.5	54.6	0	0	0	1.03892	-13.22007	400	0	1.05	0.95;
	10180	1	73.6	-95.6	0	0	0	1.08759	-16.75353	220	0	1.11	0.95;
	10181	1	73.6	-95.6	0	0	0	1.08759	-16.75353	220	0	1.11	0.95;
	10182	1	107.2	-44.4	0	0	0	1.05	-12.71113	400	0	1.05	0.95;
	10183	1	86	8	0	0	0	1.04861	-10.45398	400	0	1.05	0.95;
	10184	1	70	49	0	0	0	1.05073	-14.33097	220	0	1.11	0.95;
	10185	1	0	0	0	0	0	1.04939	-12.67172	400	0	1.05	0.95;
	10186	2	0	0	0	0	0	1.08932	-7.60913	220	0	1.11	0.95;
	10187	2	0	0	0	0	0	1.0894	-7.57617	220	0	1.11	0.95;
	10188	2	0	0	0	0	0	1.04594	-9.12003	400	0	1.05	0.95;
	10189	2	10.2	0	0	0	0	1.04556	-10.36714	400	0	1.05	0.95;
	10190	2	0	0	0	0	0	1.04288	-9.96023	400	0	1.05	0.95;
	10191	2	0	0	0	0	0	1.04288	-9.95495	400	0	1.05	0.95;
	10192	2	0	0	0	0	0	1.04073	-11.04322	220	0	1.11	0.95;
	10193	1	0	0	0	0	0	1.04073	-11.04554	220	0	1.11	0.95;
	10194	2	0	0	0	0	0	1.03584	-9.39911	400	0	1.05	0.95;
	10195	1	0	0	0	0	0	1.03662	-9.43812	400	0	1.05	0.95;
	10196	2	0	0	0	0	0	1.04091	-12.69816	400	0	1.05	0.95;
	10197	1	295	51.9	0	0	0	1.04399	-12.22816	400	0	1.05	0.95;
	10198	1	0	0	0	0	0	1.04664	-10.86919	400	0	1.05	0.95;
	10199	1	308	40	0	0	0	1.08152	-10.10172	220	0	1.11	0.95;
	10200	1	0	0	0	0	0	1.08153	-10.08501	220	0	1.11	0.95;
	10201	1	0	0	0	0	0	1.02697	-10.79239	400	0	1.05	0.95;
	10202	1	103	28	0	0	0	1.03005	-12.57582	220	0	1.11	0.95;
	10203	1	0	0	0	0	0	1.03005	-12.57582	220	0	1.11	0.95;
	10204	1	170	33	0	0	0	1.0408	-10.43423	400	0	1.05	0.95;
	10205	1	154	6	0	0	0	1.04863	-12.66758	400	0	1.05	0.95;
	10206	1	150	15	0	0	0	1.02862	-17.76737	220	0	1.11	0.95;
	10207	1	113	15	0	0	0	1.0439	-11.25141	400	0	1.05	0.95;
	10208	1	65	11	0	0	0	1.04565	-12.22395	400	0	1.05	0.95;
	10209	1	60	10	0	0	0	1.05635	-15.00801	220	0	1.11	0.95;
	10210	1	204	16.9	0	0	0	1.04548	-11.97728	400	0	1.05	0.95;
	10211	1	142	10.9	0	0	0	1.06702	-14.43722	220	0	1.11	0.95;
	10212	1	83	19	0	0	0	1.04142	-15.74593	220	0	1.11	0.95;
	10213	1	189	35	0	0	0	1.03546	-12.28418	400	0	1.05	0.95;
	10214	1	17	6	0	0	0	1.04833	-12.69685	400	0	1.05	0.95;
	10215	1	0	0	0	0	0	1.04908	-12.48244	400	0	1.05	0.95;
	10216	1	2	-6	0	0	0	1.04552	-15.08244	220	0	1.11	0.95;
	10217	1	88	-4	0	0	0	1.05	-12.21481	400	0	1.05	0.95;
	10218	1	0	0	0	0	0	1.04267	-10.20161	400	0	1.05	0.95;
	10219	1	0	0	0	0	0	1.04267	-10.1978	400	0	1.05	0.95;
	10220	1	0	0	0	0	0	1.0366	-9.43804	400	0	1.05	0.95;
	10221	1	0	0	0	0	0	1.03886	-8.62781	400	0	1.05	0.95;
	10222	1	50	20	0	0	0	1.03211	-12.19988	220	0	1.11	0.95;
	10223	2	-338.1	155.6	0	0	0	1.04073	-7.81766	400	0	1.05	0.95;
	10225	2	195.7	126.6	0	0	0	1.06248	-13.81633	110	0	1.12	0.95;
	10226	2	141.9	93.1	0	0	0	1.06441	-10.69182	110	0	1.12	0.95;
	10227	2	234.5	57.5	0	0	0	1.10423	-17.44457	110	0	1.12	0.95;
	10228	2	388.2	98.2	0	0	0	1.06247	-26.93097	110	0	1.12	0.95;
	10229	2	84.7	29.1	0	0	0	1.06902	-18.42187	110	0	1.12	0.95;
	10230	2	0	0	0	0	0	1.07323	-12.3377	110	0	1.12	0.95;
	10231	1	194.4	43.4	0	0	0	1.0183	-23.93631	110	0	1.12	0.95;
	10232	2	195.7	43.3	0	0	0	1.01987	-23.76967	110	0	1.12	0.95;
	10233	2	513.7	92.5	0	0	0	1.04665	-19.09981	110	0	1.12	0.95;
	10234	2	455.4	108.8	0	0	0	1.09129	-28.95277	110	0	1.12	0.95;
	10235	2	61.8	19.6	0	0	0	1.08091	-18.72336	110	0	1.12	0.95;
	10236	2	260.8	80.8	0	0	0	1.07896	-11.33262	110	0	1.12	0.95;
	10237	2	199.4	65.6	0	0	0	1.08023	-18.74809	110	0	1.12	0.95;
	10238	2	395	96.4	0	0	0	1.00809	-24.04735	110	0	1.12	0.95;
	10239	2	344.4	71	0	0	0	1.06246	-15.10374	110	0	1.12	0.95;
	10240	2	0	0	0	0	0	1.0666	-10.01367	110	0	1.12	0.95;
	10241	1	0	0	0	0	0	1.07019	-10.92594	110	0	1.12	0.95;
	10242	1	0	0	0	0	0	1.07381	-17.48996	110	0	1.12	0.95;
	10243	1	0	0	0	0	0	1.06266	-13.81703	110	0	1.12	0.95;
	10244	1	0	0	0	0	0	1.06623	-9.05663	110	0	1.12	0.95;
	10245	1	185.4	59.7	0	0	0	1.07935	-18.76304	110	0	1.12	0.95;
	10246	2	4	2	0	0	0	1.03917	-8.50193	14	0	1.12	0.95;
	10247	2	14	10	0	0	0	1.12	-8.38281	14	0	1.12	0.95;
	10248	2	14	10	0	0	0	1.12	-5.92631	14	0	1.12	0.95;
	10249	2	5	3	0	0	0	1.00179	-15.67326	23	0	1.12	0.95;
	10250	2	28	17	0	0	0	1.0404	-7.15858	16	0	1.12	0.95;
	10251	2	28	17	0	0	0	1.03995	-7.15971	16	0	1.12	0.95;
	10252	2	28	17	0	0	0	1.03994	-7.15236	16	0	1.12	0.95;
	10253	2	26.7	5.9	0	0	0	1.01534	-16.29544	15	0	1.12	0.95;
	10254	2	23	10	0	0	0	1.04999	-9.99449	20	0	1.12	0.95;
	10255	2	4	2	0	0	0	1.03994	-13.14222	16	0	1.12	0.95;
	10256	2	30	10	0	0	0	1.11998	-8.70427	16	0	1.12	0.95;
	10257	2	15	5	0	0	0	1.11817	-10.27505	16	0	1.12	0.95;
	10258	2	20	8	0	0	0	1.10518	-5.2305	16	0	1.12	0.95;
	10259	2	30	14	0	0	0	0.98182	-4.11356	17	0	1.12	0.95;
	10260	2	45	21	0	0	0	1.10941	-4.70641	17	0	1.12	0.95;
	10261	2	80	40	0	0	0	0.99592	-8.44878	25	0	1.12	0.95;
	10262	2	80	40	0	0	0	0.99592	-8.44355	25	0	1.12	0.95;
	10263	2	10	4	0	0	0	1.09219	-8.80241	14	0	1.12	0.95;
	10264	2	30	10	0	0	0	1.00552	-4.42061	17	0	1.12	0.95;
	10265	2	30	10	0	0	0	1.10573	-4.66225	16	0	1.12	0.95;
	10266	2	298.7	37.9	0	0	0	1.04403	-17.38244	110	0	1.12	0.95;
	10267	2	198.4	53.4	0	0	0	1.08131	-15.61818	110	0	1.12	0.95;
	10268	2	114.8	20.4	0	0	0	1.06395	-13.81804	110	0	1.12	0.95;
	10269	2	275.2	110.6	0	0	0	1.07428	-17.2699	110	0	1.12	0.95;
	10270	2	61.8	23.7	0	0	0	1.05973	-13.22787	110	0	1.12	0.95;
	10271	2	385.3	67	0	0	0	1.06494	-21.87399	110	0	1.12	0.95;
	10272	2	104.1	17.5	0	0	0	1.072	-19.12522	110	0	1.12	0.95;
	10273	2	541	91.4	0	0	0	1.02431	-23.78277	110	0	1.12	0.95;
	10274	2	256.3	100.7	0	0	0	1.06504	-14.1841	110	0	1.12	0.95;
	10275	2	0	0	0	0	0	1.06182	-12.32377	110	0	1.12	0.95;
	10276	2	164.4	34	0	0	0	1.06034	-19.38658	110	0	1.12	0.95;
	10277	2	616.8	133.2	0	0	0	1.06264	-20.31444	110	0	1.12	0.95;
	10278	2	15	10	0	0	0	1.11356	-7.71481	12	0	1.12	0.95;
	10279	2	15	10	0	0	0	1.11356	-7.71481	12	0	1.12	0.95;
	10280	1	149.8	37	0	0	0	1.05742	-13.40637	110	0	1.12	0.95;
	10281	2	106	22.4	0	0	0	1.07868	-17.51779	110	0	1.12	0.95;
	10282	2	363.9	100.1	0	0	0	1.06767	-21.77961	110	0	1.12	0.95;
	10283	1	0	0	0	0	0	1.01468	-23.76967	13	0	1.12	0.95;
	10284	2	1122.7	280.7	0	0	0	1.12	-20.1553	110	0	1.12	0.95;
	10285	2	155.7	32.1	0	0	0	1.0574	-14.40001	110	0	1.12	0.95;
	10287	1	0	0	0	0	0	1	0	110	0	1.12	0.95;
	10288	2	197.5	44.6	0	0	0	1.03369	-17.16989	110	0	1.12	0.95;
	10289	2	124.6	23.4	0	0	0	1.05256	-17.86813	110	0	1.12	0.95;
	10290	2	148.9	31.1	0	0	0	1.06119	-22.81444	110	0	1.12	0.95;
	10291	2	264.7	53.5	0	0	0	1.08362	-23.82921	110	0	1.12	0.95;
	10292	2	364.8	158.7	0	0	0	1.08678	-12.45458	110	0	1.12	0.95;
	10293	2	54.6	21.6	0	0	0	1.07356	-17.48899	110	0	1.12	0.95;
	10294	2	17.5	3.9	0	0	1	1.08819	-13.63431	110	0	1.12	0.95;
	10295	2	344.4	104	0	0	0	0.99474	-17.18159	110	0	1.12	0.95;
	10296	2	275.3	104.1	0	0	0	1.08634	-17.92203	110	0	1.12	0.95;
	10297	1	163.6	2.3	0	0	0	1.11082	-7.22832	110	0	1.12	0.95;
	10298	1	90.7	61	0	0	0	1.07174	-6.78749	110	0	1.12	0.95;
	10299	1	314	87	0	0	0	1.04695	-7.84988	110	0	1.12	0.95;
	10300	1	34	13	0	0	0	1.04421	-10.88209	110	0	1.12	0.95;
	10301	1	107	-22	0	0	0	1.07855	-7.22395	110	0	1.12	0.95;
	10302	1	161	58	0	0	0	1.09222	-10.5003	110	0	1.12	0.95;
	10303	1	161.5	37	0	0	0	1.05534	-10.03917	110	0	1.12	0.95;
	10304	1	161.5	37	0	0	0	1.05534	-10.03917	110	0	1.12	0.95;
	10305	1	232	-45.9	0	0	0	1.10778	-8.12369	110	0	1.12	0.95;
	10306	1	143	58.1	0	0	0	1.09145	-6.39794	110	0	1.12	0.95;
	10307	1	111.5	32.5	0	0	0	1.07241	-10.07733	110	0	1.12	0.95;
	10308	1	111.5	32.5	0	0	0	1.09137	-7.5084	110	0	1.12	0.95;
	10309	1	124	8.1	0	0	0	1.06294	-5.43913	110	0	1.12	0.95;
	10310	1	28.5	6	0	0	0	1.04084	-11.86881	110	0	1.12	0.95;
	10311	1	28.5	6	0	0	0	1.04084	-11.86881	110	0	1.12	0.95;
	10312	1	135	74	0	0	0	1.0479	-8.54622	110	0	1.12	0.95;
	10313	1	0	0	0	0	0	1.04454	-5.10084	110	0	1.12	0.95;
	10314	1	0	0	0	0	0	1.04454	-5.09922	110	0	1.12	0.95;
	10315	1	110	34	0	0	0	1.09352	-4.05964	110	0	1.12	0.95;
	10316	1	110	34	0	0	0	1.09338	-4.06012	110	0	1.12	0.95;
	10317	1	100	32	0	0	0	1.09382	-4.05869	110	0	1.12	0.95;
	10318	1	37	35	0	0	0	1.05289	-4.68355	110	0	1.12	0.95;
	10319	1	93	80	0	0	0	1.06177	-7.11307	110	0	1.12	0.95;
	10320	1	30	18	0	0	0	1.07986	-4.96142	110	0	1.12	0.95;
	10321	1	189	38	0	0	0	1.0353	-12.90356	110	0	1.12	0.95;
	10322	1	78.5	21	0	0	0	1.07974	-7.23949	110	0	1.12	0.95;
	10323	1	78.5	21	0	0	0	1.07974	-7.23949	110	0	1.12	0.95;
	10324	1	190	22	0	0	0	1.09021	-7.80898	110	0	1.12	0.95;
	10325	1	42.6	31.4	0	0	0	1.03672	-5.06258	110	0	1.12	0.95;
	10326	1	170.4	125.6	0	0	0	1.05028	-6.56373	110	0	1.12	0.95;
	10327	1	106	50	0	0	0	1.02247	-11.25013	110	0	1.12	0.95;
	10328	1	94	60.6	0	0	0	1.01616	-7.46571	110	0	1.12	0.95;
	10329	1	94	60.6	0	0	0	1.01616	-7.46571	110	0	1.12	0.95;
	10330	1	133.5	25.5	0	0	0	1.02385	-13.52995	110	0	1.12	0.95;
	10331	1	133.5	25.5	0	0	0	1.02385	-13.52995	110	0	1.12	0.95;
	10332	1	121	31.9	0	0	0	1.03381	-6.83166	110	0	1.12	0.95;
	10333	1	125	3	0	0	0	1.11843	-9.53252	110	0	1.12	0.95;
	10334	1	210	0	0	0	0	1.0128	-21.49132	110	0	1.12	0.95;
	10335	1	62	33.5	0	0	0	1.05347	-8.04462	110	0	1.12	0.95;
	10336	1	62	33.5	0	0	0	1.05347	-8.04462	110	0	1.12	0.95;
	10337	1	85	5	0	0	0	1.02004	-5.32478	110	0	1.12	0.95;
	10338	1	85	5	0	0	0	1.02118	-4.83383	110	0	1.12	0.95;
	10339	1	147	36	0	0	0	1.04451	-5.10546	110	0	1.12	0.95;
	10340	1	147	36	0	0	0	1.04456	-5.09664	110	0	1.12	0.95;
	10341	1	44	0	0	0	0	1.08635	-5.03949	110	0	1.12	0.95;
	10342	1	33	-19	0	0	0	1.02361	-4.10959	110	0	1.12	0.95;
	10343	1	107	22	0	0	0	1.04896	-6.31433	110	0	1.12	0.95;
	10344	1	157	46	0	0	0	1.08553	-8.88587	110	0	1.12	0.95;
	10345	1	95	21	0	0	0	1.10631	-10.27971	110	0	1.12	0.95;
	10346	1	67.5	7	0	0	0	1.04395	-11.77881	110	0	1.12	0.95;
	10347	1	67.5	7	0	0	0	1.04395	-11.77881	110	0	1.12	0.95;
	10348	1	102	17	0	0	0	1.07055	-6.88126	110	0	1.12	0.95;
	10349	1	102	17	0	0	0	1.05869	-6.96516	110	0	1.12	0.95;
	10350	1	109	25	0	0	0	1.09006	-3.22107	110	0	1.12	0.95;
	10351	1	181	45.1	0	0	0	1.06554	-5.93954	110	0	1.12	0.95;
	10352	1	45	25	0	0	0	1.06555	-4.37582	110	0	1.12	0.95;
	10353	1	62	38.5	0	0	0	1.11857	-9.31326	110	0	1.12	0.95;
	10354	1	62	38.5	0	0	0	1.11857	-9.31326	110	0	1.12	0.95;
	10355	1	300	57	0	0	0	1.05618	-10.4405	110	0	1.12	0.95;
	10356	1	15	3	0	0	0	1.04325	-18.03777	110	0	1.12	0.95;
	10357	1	79	6	0	0	0	1.08647	-8.12785	110	0	1.12	0.95;
	10358	1	296	58	0	0	0	1.12	-10.52462	110	0	1.12	0.95;
	10359	1	0	0	0	0	0	1.05447	-10.30796	110	0	1.12	0.95;
	10360	1	240	71	0	0	0	1.0541	-10.20427	110	0	1.12	0.95;
	10361	1	265	46.1	0	0	0	1.05135	-11.29547	110	0	1.12	0.95;
	10366	1	0	0	0	0	0	1.02163	-8.17421	22	0	1.12	0.95;
	10367	1	0	0	0	0	0	1.02164	-8.17421	110	0	1.12	0.95;
	10368	1	0	0	0	0	0	1.0553	-8.75319	110	0	1.12	0.95;
	10369	1	0	0	0	0	0	1.05529	-8.75319	22	0	1.12	0.95;
	1	1	0	0	0	0	1	1.10683	-0.3147	220	1	1.11	0.95;
	2	1	0	0	0	0	1	1.10783	1.34368	220	1	1.11	0.95;
	3	1	0	0	0	0	1	1.05771	-30.03567	220	1	1.11	0.95;
	4	1	0	0	0	0	1	1.05765	-30.04457	220	1	1.11	0.95;
	5	1	0	0	0	0	1	1.06886	-32.42333	220	1	1.11	0.95;
	6	1	0	0	0	0	1	1.07562	-5.79827	220	1	1.11	0.95;
	7	1	0	0	0	0	1	1.0756	-5.79861	220	1	1.11	0.95;
	8	1	0	0	0	0	1	1.0814	-18.53453	220	1	1.11	0.95;
	9	1	0	0	0	0	1	1.08169	-18.51761	220	1	1.11	0.95;
	10	1	0	0	0	0	1	1.08481	-22.24216	220	1	1.11	0.95;
	11	1	0	0	0	0	1	1.02329	-13.60481	400	1	1.05	0.95;
	12	1	0	0	0	0	1	1.02339	-13.59722	400	1	1.05	0.95;
	13	1	0	0	0	0	1	1.00602	-17.95869	400	1	1.05	0.95;
	14	1	0	0	0	0	1	1.03516	-18.26116	220	1	1.11	0.95;
	15	1	0	0	0	0	1	1.03539	-18.2591	220	1	1.11	0.95;
	16	1	0	0	0	0	1	1.03545	-18.24859	220	1	1.11	0.95;
	17	1	0	0	0	0	1	1.01167	-23.047	220	1	1.11	0.95;
	18	1	0	0	0	0	1	1.01817	-22.57535	220	1	1.11	0.95;
	19	1	0	0	0	0	1	1.02339	-11.87636	400	1	1.05	0.95;
	20	1	0	0	0	0	1	1.02345	-11.86651	400	1	1.05	0.95;
	21	1	0	0	0	0	1	1.00891	-21.65053	400	1	1.05	0.95;
	22	1	0	0	0	0	1	1.01162	-17.61066	400	1	1.05	0.95;
	23	1	0	0	0	0	1	1.01162	-17.61066	400	1	1.05	0.95;
	24	2	10	20.1	0	0	1	1.07767	-24.32403	220	1	1.11	0.95;
	25	2	10	20.1	0	0	1	1.0776	-24.32136	220	1	1.11	0.95;
	26	1	0	0	0	0	1	1.08577	-4.75886	220	1	1.11	0.95;
	27	1	0	0	0	0	1	1.0859	-4.77005	220	1	1.11	0.95;
	28	1	0	0	0	0	1	1.03847	-19.52171	220	1	1.11	0.95;
	29	1	0	0	0	0	1	1.03841	-19.52178	220	1	1.11	0.95;
	30	1	0	0	0	0	1	1.03437	-17.88953	220	1	1.11	0.95;
	31	1	0	0	0	0	1	1.0343	-17.90171	220	1	1.11	0.95;
	32	1	0	0	0	0	1	1.08456	-2.60422	220	1	1.11	0.95;
	33	1	0	0	0	0	1	1.08446	-2.62715	220	1	1.11	0.95;
	34	1	0	0	0	0	1	1.02081	-14.73024	400	1	1.05	0.95;
	35	1	0	0	0	0	1	1.02077	-14.73529	400	1	1.05	0.95;
	36	1	0	0	0	0	1	1.00827	-17.96045	400	1	1.05	0.95;
	37	3	48.7	86.2	0	0	1	1.11	0	220	1	1.11	0.95;
	38	2	54.5	89.9	0	0	1	1.11	1.64313	220	1	1.11	0.95;
	39	2	20.1	40.2	0	0	1	1.11	1.63704	220	1	1.11	0.95;
	40	2	60.3	120.6	0	0	1	1.04756	0.02164	400	1	1.05	0.95;
	41	2	60.3	120.6	0	0	1	1.04755	0.02748	400	1	1.05	0.95;
	42	1	0	0	0	0	1	1.02593	-19.15636	220	1	1.11	0.95;
	43	1	0	0	0	0	1	1.02582	-19.16305	220	1	1.11	0.95;
	44	1	0	0	0	0	1	1.05	-1.58839	400	1	1.05	0.95;
	45	1	0	0	0	0	1	1.04998	-1.59196	400	1	1.05	0.95;
	46	1	0	0	0	0	1	1.03111	-18.62695	220	1	1.11	0.95;
	47	1	0	0	0	0	1	1.06103	-7.84552	220	1	1.11	0.95;
	48	1	0	0	0	0	1	1.06104	-7.86017	220	1	1.11	0.95;
	49	1	0	0	0	0	1	1.09337	-12.42931	220	2	1.11	0.95;
	50	1	0	0	0	0	1	1.09039	-11.16452	220	2	1.11	0.95;
	51	1	0	0	0	0	1	1.10263	-9.84324	220	2	1.11	0.95;
	52	1	0	0	0	0	1	1.10261	-9.84649	220	2	1.11	0.95;
	53	1	0	0	0	0	1	1.07037	-14.43296	220	2	1.11	0.95;
	54	1	3.2	1	0	0	1	1.09978	-9.00933	220	2	1.11	0.95;
	55	1	0	0	0	0	1	1.09984	-9.00618	220	2	1.11	0.95;
	56	1	0	0	0	0	1	1.03565	-8.72229	400	2	1.05	0.95;
	57	2	26.1	60.3	0	0	1	1.10991	-10.73043	220	2	1.11	0.95;
	58	2	54.3	120.6	0	0	1	1.1097	-10.73757	220	2	1.11	0.95;
	59	2	13.1	30.1	0	0	1	1.11	-10.72656	220	2	1.11	0.95;
	60	2	26.1	50.2	0	0	1	1.05	-9.56951	400	2	1.05	0.95;
	61	2	26.1	50.2	0	0	1	1.04992	-9.56854	400	2	1.05	0.95;
	62	1	0	0	0	0	1	1.09416	-9.75714	220	2	1.11	0.95;
	63	1	0	0	0	0	1	1.04454	-9.88832	400	2	1.05	0.95;
	64	1	0	0	0	0	1	1.04453	-9.89003	400	2	1.05	0.95;
	65	1	0	0	0	0	1	1.04746	-10.98572	400	2	1.05	0.95;
	66	1	0	0	0	0	1	1.07714	-12.62676	220	2	1.11	0.95;
	67	1	0	0	0	0	1	1.07713	-12.62172	220	2	1.11	0.95;
	68	1	0	0	0	0	1	1.04521	-9.56117	400	2	1.05	0.95;
	69	1	0	0	0	0	1	1.0452	-9.55972	400	2	1.05	0.95;
	70	2	13.1	30.1	0	0	1	1.10739	-8.60021	220	2	1.11	0.95;
	71	2	13.1	30.1	0	0	1	1.10739	-8.60343	220	2	1.11	0.95;
	72	2	13.1	30.1	0	0	1	1.04287	-8.4031	400	2	1.05	0.95;
	73	2	26.1	60.3	0	0	1	1.0429	-8.40447	400	2	1.05	0.95;
	74	2	149.7	60.3	0	0	1	1.1043	-11.61975	220	2	1.11	0.95;
	75	1	29.1	10	0	0	1	1.10428	-11.62108	220	2	1.11	0.95;
	76	1	0	0	0	0	1	1.09619	-9.86894	220	2	1.11	0.95;
	77	1	0	0	0	0	1	1.0962	-9.86604	220	2	1.11	0.95;
	78	1	0	0	0	0	1	1.10133	-11.58367	220	2	1.11	0.95;
	79	1	0	0	0	0	1	1.10135	-11.58785	220	2	1.11	0.95;
	80	1	0	0	0	0	1	1.05	-9.02748	400	2	1.05	0.95;
	81	1	0	0	0	0	1	1.04998	-9.03312	400	2	1.05	0.95;
	82	1	0	0	0	0	1	1.09853	-11.11488	220	2	1.11	0.95;
	83	1	0	0	0	0	1	1.09948	-10.99534	220	2	1.11	0.95;
	84	1	0	0	0	0	1	1.07865	-11.42219	220	2	1.11	0.95;
	85	1	0	0	0	0	1	1.09226	-4.09446	220	3	1.11	0.95;
	86	1	9.4	0	0	0	1	1.09034	-8.35201	220	3	1.11	0.95;
	87	1	8.2	0	0	0	1	1.09035	-8.35113	220	3	1.11	0.95;
	88	1	0	0	0	0	1	1.09294	-3.5166	220	3	1.11	0.95;
	89	1	0	0	0	0	1	1.09307	-3.50133	220	3	1.11	0.95;
	90	1	0	0	0	0	1	1.10865	-2.97501	220	3	1.11	0.95;
	91	1	0	0	0	0	1	1.10867	-2.97695	220	3	1.11	0.95;
	92	1	0	0	0	0	1	1.06576	-6.13735	220	3	1.11	0.95;
	93	1	0	0	0	0	1	1.06553	-6.13858	220	3	1.11	0.95;
	94	2	28.1	70.3	0	0	1	1.10247	-2.50735	220	3	1.11	0.95;
	95	2	42.2	103.5	0	0	1	1.10442	-2.16364	220	3	1.11	0.95;
	96	1	7.7	-25	0	0	1	1.09045	-3.5891	220	3	1.11	0.95;
	97	1	0	0	0	0	1	1.09043	-3.58958	220	3	1.11	0.95;
	98	2	32.2	142.7	0	0	1	1.05	-3.80394	400	3	1.05	0.95;
	99	1	0	0	0	0	1	1.04993	-3.83168	400	3	1.05	0.95;
	100	1	0	0	0	0	1	1.06235	-5.1257	220	3	1.11	0.95;
	101	1	0	0	0	0	1	1.1067	-2.92815	220	3	1.11	0.95;
	102	1	0	0	0	0	1	1.10667	-2.92209	220	3	1.11	0.95;
	103	1	45.1	7.9	0	0	1	1.09504	-3.92095	220	3	1.11	0.95;
	104	1	0	0	0	0	1	1.09498	-3.92621	220	3	1.11	0.95;
	105	1	0	0	0	0	1	1.09907	-2.33167	220	3	1.11	0.95;
	106	1	0	0	0	0	1	1.09897	-2.33346	220	3	1.11	0.95;
	107	1	0	0	0	0	1	1.09932	-3.47111	220	3	1.11	0.95;
	108	1	0	0	0	0	1	1.09932	-3.4761	220	3	1.11	0.95;
	109	1	0	0	0	0	1	1.04336	-1.94993	400	3	1.05	0.95;
	110	1	0	0	0	0	1	1.04336	-1.95191	400	3	1.05	0.95;
	111	1	0	0	0	0	1	1.10343	-2.4016	220	3	1.11	0.95;
	112	1	0	0	0	0	1	1.10348	-2.40387	220	3	1.11	0.95;
	113	1	0	0	0	0	1	1.08227	-3.60332	220	3	1.11	0.95;
	114	1	0	0	0	0	1	1.08218	-3.61107	220	3	1.11	0.95;
	115	2	29.4	18.5	0	0	1	1.09646	-3.40562	220	3	1.11	0.95;
	116	1	0	0	0	0	1	1.09644	-3.41548	220	3	1.11	0.95;
	117	1	0	0	0	0	1	1.09039	-8.33168	220	3	1.11	0.95;
	118	1	0	0	0	0	1	1.09039	-8.32974	220	3	1.11	0.95;
	119	1	0	0	0	0	1	1.05297	-6.17162	220	3	1.11	0.95;
	120	1	0	0	0	0	1	1.05294	-6.16856	220	3	1.11	0.95;
	121	2	0	0	0	0	1	1.10918	-2.88774	220	3	1.11	0.95;
	122	2	10	44.2	0	0	1	1.10922	-2.89696	220	3	1.11	0.95;
	123	2	7	18.1	0	0	1	1.10624	-2.27844	220	3	1.11	0.95;
	124	2	8	21.1	0	0	1	1.10639	-2.27068	220	3	1.11	0.95;
	125	1	0	0	0	0	1	1.09264	-4.52218	220	3	1.11	0.95;
	126	1	71.5	7.9	0	0	1	1.09268	-4.53086	220	3	1.11	0.95;
	127	1	0	0	0	0	1	1.05869	-5.03006	220	3	1.11	0.95;
	128	1	0	0	0	0	1	1.0856	-3.25526	220	3	1.11	0.95;
	129	1	0	0	0	0	1	1.08564	-3.25685	220	3	1.11	0.95;
	130	1	0	0	0	0	1	1.0883	-3.61644	220	3	1.11	0.95;
	131	1	0	0	0	0	1	1.0884	-3.60774	220	3	1.11	0.95;
	132	1	0	0	0	0	1	1.04276	-5.24535	400	3	1.05	0.95;
	133	1	0	0	0	0	1	1.04276	-5.24535	400	3	1.05	0.95;
	134	2	0	0	0	0	1	1.09925	-2.98757	220	3	1.11	0.95;
	135	2	9	20.1	0	0	1	1.09923	-2.98863	220	3	1.11	0.95;
	136	2	6	15.1	0	0	1	1.07793	-4.29705	220	3	1.11	0.95;
	137	1	0	0	0	0	1	1.07795	-4.30702	220	3	1.11	0.95;
	138	1	0	0	0	0	1	1.04756	-8.85339	400	3	1.05	0.95;
	139	1	0	0	0	0	1	1.0476	-8.85201	400	3	1.05	0.95;
	140	1	0	0	0	0	1	1.05	-5.27699	400	3	1.05	0.95;
	141	1	0	0	0	0	1	1.05	-5.2733	400	3	1.05	0.95;
	142	1	0	0	0	0	1	1.05475	-5.25144	220	3	1.11	0.95;
	143	1	0	0	0	0	1	1.05482	-5.24859	220	3	1.11	0.95;
	144	2	18.3	15.9	0	0	1	1.10999	-1.94392	220	3	1.11	0.95;
	145	2	41	43.1	0	0	1	1.11	-1.92154	220	3	1.11	0.95;
	146	2	28.1	66.3	0	0	1	1.04293	-4.71535	400	3	1.05	0.95;
	147	1	0	0	0	0	1	1.04296	-4.71061	400	3	1.05	0.95;
	148	1	0	0	0	0	1	1.09367	-4.0284	220	3	1.11	0.95;
	149	1	0	0	0	0	1	1.09374	-4.02261	220	3	1.11	0.95;
	150	1	0	0	0	0	1	1.10588	-2.44486	220	3	1.11	0.95;
	151	1	0	0	0	0	1	1.09705	-3.66763	220	3	1.11	0.95;
	152	2	0	0	0	0	1	1.06579	-6.13758	220	3	1.11	0.95;
	153	2	0	0	0	0	1	1.06556	-6.13881	220	3	1.11	0.95;
	154	2	7.8	20.1	0	0	1	1.0916	-10.91902	220	4	1.11	0.95;
	155	2	8	20.1	0	0	1	1.0916	-10.92908	220	4	1.11	0.95;
	156	1	0	0	0	0	1	1.06325	-10.74057	220	4	1.11	0.95;
	157	1	0	0	0	0	1	1.06322	-10.74363	220	4	1.11	0.95;
	158	1	0	0	0	0	1	1.05493	-12.84056	220	4	1.11	0.95;
	159	1	0	0	0	0	1	1.08041	-8.69944	220	4	1.11	0.95;
	160	1	0	0	0	0	1	1.08032	-8.71058	220	4	1.11	0.95;
	161	1	0	0	0	0	1	1.02359	-8.98666	400	4	1.05	0.95;
	162	1	0	0	0	0	1	1.02356	-8.99236	400	4	1.05	0.95;
	163	1	0	0	0	0	1	1.03135	-23.38638	220	4	1.11	0.95;
	164	1	0	0	0	0	1	1.04195	-21.79824	220	4	1.11	0.95;
	165	1	0	0	0	0	1	1.04195	-21.79824	220	4	1.11	0.95;
	166	1	0	0	0	0	1	1.05789	-20.86338	220	4	1.11	0.95;
	167	1	0	0	0	0	1	1.05789	-20.86338	220	4	1.11	0.95;
	168	1	0	0	0	0	1	1.05438	-13.11633	220	4	1.11	0.95;
	169	2	0	0	0	0	1	1.08388	-15.43233	220	4	1.11	0.95;
	170	2	0	0	0	0	1	1.08387	-15.44225	220	4	1.11	0.95;
	171	1	0	0	0	0	1	1.11	-12.76059	220	4	1.11	0.95;
	172	2	12.1	30.1	0	0	1	1.06808	-19.35046	220	4	1.11	0.95;
	173	2	9.4	2.4	0	0	1	1.06807	-19.3607	220	4	1.11	0.95;
	174	2	12.1	30.1	0	0	1	1.03111	-20.95	400	4	1.05	0.95;
	175	2	24.1	60.3	0	0	1	1.03109	-20.94948	400	4	1.05	0.95;
	176	1	0	0	0	0	1	0.99815	-22.08104	220	4	1.11	0.95;
	177	1	0	0	0	0	1	0.99827	-22.08834	220	4	1.11	0.95;
	178	1	0	0	0	0	1	1.0485	-15.95015	220	4	1.11	0.95;
	179	1	0	0	0	0	1	1.04851	-15.94999	220	4	1.11	0.95;
	180	2	26.1	64.3	0	0	1	1.11	-4.44833	220	4	1.11	0.95;
	181	2	26.1	64.3	0	0	1	1.11	-4.45514	220	4	1.11	0.95;
	182	2	26.1	64.5	0	0	1	1.11	-4.43484	220	4	1.11	0.95;
	183	2	26.1	64.5	0	0	1	1.04854	-3.78074	400	4	1.05	0.95;
	184	1	0	0	0	0	1	1.04851	-3.78094	400	4	1.05	0.95;
	185	1	0	0	0	0	1	1.04664	-21.95019	220	4	1.11	0.95;
	186	1	0	0	0	0	1	1.04664	-21.95019	220	4	1.11	0.95;
	187	1	0	0	0	0	1	1.01055	-11.00913	400	4	1.05	0.95;
	188	1	0	0	0	0	1	0.98085	-16.56062	400	4	1.05	0.95;
	189	1	0	0	0	0	1	1.02286	-9.11442	400	4	1.05	0.95;
	190	1	0	0	0	0	1	1.02287	-9.1105	400	4	1.05	0.95;
	191	2	12.1	30.1	0	0	1	1.08579	-15.54865	220	4	1.11	0.95;
	192	2	14.7	30.6	0	0	1	1.08551	-15.58683	220	4	1.11	0.95;
	193	2	38.2	64.3	0	0	1	1.03481	-8.99641	400	4	1.05	0.95;
	194	1	0	0	0	0	1	1.01593	-29.2687	220	4	1.11	0.95;
	195	1	0	0	0	0	1	1.01598	-29.27385	220	4	1.11	0.95;
	196	1	0	0	0	0	1	1.04143	-21.90223	220	4	1.11	0.95;
	197	1	0	0	0	0	1	1.04144	-21.90382	220	4	1.11	0.95;
	198	1	0	0	0	0	1	1.02472	-24.03635	220	4	1.11	0.95;
	199	1	0	0	0	0	1	1.02471	-24.03231	220	4	1.11	0.95;
	200	1	0	0	0	0	1	0.9801	-24.58195	400	4	1.05	0.95;
	201	1	0	0	0	0	1	0.9801	-24.58195	400	4	1.05	0.95;
	202	1	0	0	0	0	1	1.01912	-16.22044	220	4	1.11	0.95;
	203	1	0	0	0	0	1	1.01912	-16.21707	220	4	1.11	0.95;
	204	1	0	0	0	0	1	1.01447	-24.74539	220	4	1.11	0.95;
	205	1	0	0	0	0	1	1.06356	-10.37047	220	4	1.11	0.95;
	206	1	0	0	0	0	1	1.06356	-10.38039	220	4	1.11	0.95;
	207	1	0	0	0	0	1	1.05699	-9.60484	220	4	1.11	0.95;
	208	2	3.1	1.5	0	0	1	1.06766	-14.48751	220	4	1.11	0.95;
	209	1	0	0	0	0	1	1.00929	-17.20737	220	4	1.11	0.95;
	210	1	0	0	0	0	1	1.00928	-17.20358	220	4	1.11	0.95;
	211	1	0	0	0	0	1	1.04499	-24.62717	220	5	1.11	0.95;
	212	1	0	0	0	0	1	1.11	-25.78057	220	5	1.11	0.95;
	213	1	0	0	0	0	1	1.03098	-24.33679	400	5	1.05	0.95;
	214	1	0	0	0	0	1	1.03101	-24.33313	400	5	1.05	0.95;
	215	1	0	0	0	0	1	1.02565	-24.99548	400	5	1.05	0.95;
	216	1	0	0	0	0	1	1.02566	-25.00121	400	5	1.05	0.95;
	217	1	0	0	0	0	1	1.03197	-30.24909	400	5	1.05	0.95;
	218	1	0	0	0	0	1	1.0257	-28.56715	220	5	1.11	0.95;
	219	1	0	0	0	0	1	1.0257	-28.5707	220	5	1.11	0.95;
	220	1	0	0	0	0	1	1.05774	-25.00995	220	5	1.11	0.95;
	221	1	0	0	0	0	1	1.05766	-25.01303	220	5	1.11	0.95;
	222	1	0	0	0	0	1	1.01011	-22.46181	400	5	1.05	0.95;
	223	1	0	0	0	0	1	1.01011	-22.46181	400	5	1.05	0.95;
	224	1	0	0	0	0	1	1.03124	-27.98356	400	5	1.05	0.95;
	225	1	0	0	0	0	1	1.0532	-23.74794	220	5	1.11	0.95;
	226	1	0	0	0	0	1	1.05322	-23.74233	220	5	1.11	0.95;
	227	1	0	0	0	0	1	1.06997	-27.41835	220	5	1.11	0.95;
	228	1	0	0	0	0	1	1.06026	-28.11231	220	5	1.11	0.95;
	229	1	0	0	0	0	1	1.02747	-27.56992	400	5	1.05	0.95;
	230	1	0	0	0	0	1	1.02744	-27.57098	400	5	1.05	0.95;
	231	1	0	0	0	0	1	1.05	-31.35487	400	5	1.05	0.95;
	232	1	0	0	0	0	1	1.05214	-28.36179	220	5	1.11	0.95;
	233	1	0	0	0	0	1	1.05222	-28.35818	220	5	1.11	0.95;
	234	1	0	0	0	70	1	1.03704	-24.54632	400	5	1.25	0.75;
	235	1	0	0	0	0	1	1.03703	-24.54553	400	5	1.05	0.95;
	236	1	0	0	0	0	1	1.0316	-26.13555	220	5	1.11	0.95;
	237	1	0	0	0	0	1	1.03155	-26.13486	220	5	1.11	0.95;
	238	1	0	0	0	0	1	1.03418	-24.15788	220	5	1.11	0.95;
	239	1	0	0	0	0	1	1.0341	-24.17316	220	5	1.11	0.95;
	240	2	2	40.2	0	0	1	1.02448	-23.7809	400	5	1.05	0.95;
	241	2	5.5	30.1	0	0	1	1.02448	-23.77988	400	5	1.05	0.95;
	242	1	0	0	0	0	1	1.06948	-27.49284	220	5	1.11	0.95;
	243	1	0	0	0	0	1	1.06959	-27.48746	220	5	1.11	0.95;
	244	2	0	0	0	0	0	1.11	-2.47606	220	0	1.11	0.95;
	245	1	9.9	2	0	0	1	1.04873	-27.86221	110	1	1.12	0.95;
	246	1	8.9	0	0	0	1	1.06109	-34.62851	110	1	1.12	0.95;
	247	1	8.9	0	0	0	1	1.06099	-34.62119	110	1	1.12	0.95;
	248	1	6.1	1	0	0	1	1.09558	-21.60979	110	1	1.12	0.95;
	249	1	6.1	2	0	0	1	1.09554	-21.63491	110	1	1.12	0.95;
	250	1	2.9	2.5	0	0	1	1.02506	-26.51723	110	1	1.12	0.95;
	251	1	6.3	5.8	0	0	1	1.02501	-26.51986	110	1	1.12	0.95;
	252	1	5.2	1.3	0	0	1	1.08936	-2.25594	110	1	1.12	0.95;
	253	1	6.2	1	0	0	1	1.07805	-3.4235	110	1	1.12	0.95;
	254	2	-11.5	119.7	0	0	1	1.09551	-24.41896	110	1	1.12	0.95;
	255	1	23	2	0	0	1	1.09592	-24.63705	110	1	1.12	0.95;
	256	1	14.7	1.5	0	0	1	1.09722	-24.83457	110	1	1.12	0.95;
	257	1	16.7	0	0	0	1	1.09714	-25.00352	110	1	1.12	0.95;
	258	1	26.2	3	0	0	1	1.09558	-25.13876	110	1	1.12	0.95;
	259	1	11.5	2	0	0	1	1.09554	-24.6122	110	1	1.12	0.95;
	260	1	5.2	1	0	0	1	1.09506	-25.03595	110	1	1.12	0.95;
	261	1	5.2	1	0	0	1	1.09496	-25.01388	110	1	1.12	0.95;
	262	1	0	0	0	0	1	1.09688	-25.05491	110	1	1.12	0.95;
	263	1	7.7	1.5	0	0	1	1.08778	-24.43921	110	1	1.12	0.95;
	264	1	5.6	1	0	0	1	1.08788	-24.43134	110	1	1.12	0.95;
	265	1	5	0.5	0	0	1	1.09279	-23.79765	110	1	1.12	0.95;
	266	1	5	0.5	0	0	1	1.09274	-23.8178	110	1	1.12	0.95;
	267	2	0.1	0	0	0	1	1.05867	-17.27801	110	1	1.12	0.95;
	268	2	10.9	2.5	0	0	1	1.07476	-10.5064	110	1	1.12	0.95;
	269	1	20.7	5.6	0	0	1	1.09905	-23.4131	110	1	1.12	0.95;
	270	1	0.9	0.4	0	0	1	1.09081	-4.63657	110	1	1.12	0.95;
	271	1	1.2	-0.9	0	0	1	1.08704	-0.57959	110	1	1.12	0.95;
	272	1	5.7	0.3	0	0	1	1.09915	-23.93962	110	1	1.12	0.95;
	273	1	5.2	0.2	0	0	1	1.09073	-31.54209	110	1	1.12	0.95;
	274	1	24.1	2	0	0	1	1.07467	-26.51005	110	1	1.12	0.95;
	275	1	4.2	2.1	0	0	1	1.10822	-9.03632	110	1	1.12	0.95;
	276	1	8.3	1.5	0	0	1	1.05946	-14.18987	110	1	1.12	0.95;
	277	1	3.1	0.5	0	0	1	1.11254	-23.38916	110	1	1.12	0.95;
	278	2	3.9	1.6	0	0	1	1.11594	-8.58082	110	1	1.12	0.95;
	279	2	3.9	1.6	0	0	1	1.11989	-9.80668	110	1	1.12	0.95;
	280	1	24.4	6.5	0	0	1	1.08663	-23.97191	110	1	1.12	0.95;
	281	1	10.4	2.2	0	0	1	1.07921	-3.2859	110	1	1.12	0.95;
	282	1	6.1	0.5	0	0	1	1.07309	-13.38399	110	1	1.12	0.95;
	283	1	3.3	0.2	0	0	1	1.07308	-13.37802	110	1	1.12	0.95;
	284	1	13.5	7	0	0	1	1.07428	-2.29509	110	1	1.12	0.95;
	285	1	20.7	11.6	0	0	1	1.07418	-2.31767	110	1	1.12	0.95;
	286	1	10.3	0.4	0	0	1	1.0752	-28.1569	110	1	1.12	0.95;
	287	1	12.6	4.5	0	0	1	1.11079	-8.41423	110	1	1.12	0.95;
	288	1	9.6	0.8	0	0	1	1.07416	-28.41506	110	1	1.12	0.95;
	289	1	0	0	0	0	1	1.07418	-28.41748	110	1	1.12	0.95;
	290	1	6.3	0.3	0	0	1	1.07383	-28.85261	110	1	1.12	0.95;
	291	1	5.2	0	0	0	1	1.06721	-29.0494	110	1	1.12	0.95;
	292	1	4.2	0	0	0	1	1.06716	-29.05356	110	1	1.12	0.95;
	293	1	1	0	0	0	1	1.07957	-27.73087	110	1	1.12	0.95;
	294	1	0	0	0	0	1	1.07962	-27.75482	110	1	1.12	0.95;
	295	2	0.2	0.4	0	0	1	1.08251	-25.6987	110	1	1.12	0.95;
	296	1	0	0	0	0	1	1.08253	-25.71649	110	1	1.12	0.95;
	297	1	9.4	2	0	0	1	1.06039	-32.31708	110	1	1.12	0.95;
	298	1	0.3	0.1	0	0	1	1.10353	-5.32571	110	1	1.12	0.95;
	299	1	0.3	0.1	0	0	1	1.09987	-5.28569	110	1	1.12	0.95;
	300	1	13.5	7.6	0	0	1	1.10133	-5.40475	110	1	1.12	0.95;
	301	1	0.5	0.2	0	0	1	1.09983	-5.2872	110	1	1.12	0.95;
	302	1	7.8	0.1	0	0	1	1.07895	-29.71522	110	1	1.12	0.95;
	303	1	9	0.1	0	0	1	1.07897	-29.72727	110	1	1.12	0.95;
	304	1	6.7	2.2	0	0	1	1.11097	-9.30157	110	1	1.12	0.95;
	305	1	6.7	0.6	0	0	1	1.10236	-5.5956	110	1	1.12	0.95;
	306	1	3.7	0.3	0	0	1	1.10236	-5.57526	110	1	1.12	0.95;
	307	1	4.2	1	0	0	1	1.09654	-25.46557	110	1	1.12	0.95;
	308	1	0	0	0	0	1	1.0865	-0.54788	110	1	1.12	0.95;
	309	1	0	0	0	0	1	1.08656	-0.56949	110	1	1.12	0.95;
	310	2	33.8	48.8	0	0	1	0.99995	3.1727	24	1	1.12	0.95;
	311	1	6.3	0.5	0	0	1	1.08778	-33.1704	110	1	1.12	0.95;
	312	1	6.3	0.5	0	0	1	1.08774	-33.19021	110	1	1.12	0.95;
	313	1	4.7	0.5	0	0	1	1.0898	-32.99041	110	1	1.12	0.95;
	314	1	2.6	0.5	0	0	1	1.09956	-32.03921	110	1	1.12	0.95;
	315	1	0	0	0	45	1	1.07843	-32.42039	16	1	1.25	0.75;
	316	2	0	0	0	0	1	1.04939	-25.80147	110	1	1.12	0.95;
	317	1	17.8	2.5	0	0	1	1.09458	-25.16336	110	1	1.12	0.95;
	318	1	3.7	0.5	0	0	1	1.05348	-36.94031	110	1	1.12	0.95;
	319	1	6.4	0.5	0	0	1	1.11562	-21.91138	110	1	1.12	0.95;
	320	1	24.4	6.5	0	0	1	1.05496	-18.15716	110	1	1.12	0.95;
	321	1	26.4	6.2	0	0	1	1.08979	-24.09605	110	1	1.12	0.95;
	322	1	17.3	1	0	0	1	1.06726	-35.84224	110	1	1.12	0.95;
	323	1	44	2.5	0	0	1	1.0838	-31.88976	110	1	1.12	0.95;
	324	1	5.8	0.4	0	0	1	1.08702	-31.9351	110	1	1.12	0.95;
	325	1	4.2	1	0	0	1	1.074	-2.27745	110	1	1.12	0.95;
	326	1	4.9	1.2	0	0	1	1.07391	-2.29444	110	1	1.12	0.95;
	327	1	13.1	4.2	0	0	1	1.10332	-9.59582	110	1	1.12	0.95;
	328	1	8.4	1	0	0	1	1.05504	-37.0719	110	1	1.12	0.95;
	329	1	10.2	1	0	0	1	1.09263	-22.06371	110	1	1.12	0.95;
	330	1	12.2	2	0	0	1	1.09677	-21.3903	110	1	1.12	0.95;
	331	1	3.8	1	0	0	1	1.07143	-29.352	110	1	1.12	0.95;
	332	1	31.3	22.1	0	0	1	1.08497	-0.91657	110	1	1.12	0.95;
	333	1	22.7	13.1	0	0	1	1.07918	-2.89721	110	1	1.12	0.95;
	334	1	38.4	12.1	0	0	1	1.08599	-0.64486	110	1	1.12	0.95;
	335	1	5.1	2.5	0	0	1	1.08813	-23.33151	110	1	1.12	0.95;
	336	1	13	0.7	0	0	1	1.10707	-24.03341	110	1	1.12	0.95;
	337	1	2.9	0.4	0	0	1	1.11763	-21.21926	110	1	1.12	0.95;
	338	1	7.8	1	0	0	1	1.11764	-21.23111	110	1	1.12	0.95;
	339	1	16.7	1.5	0	0	1	1.07527	-26.63258	110	1	1.12	0.95;
	340	1	7.3	0.4	0	0	1	1.05266	-36.7258	110	1	1.12	0.95;
	341	1	3.1	0.1	0	0	1	1.05269	-36.71858	110	1	1.12	0.95;
	342	1	9.1	2.1	0	0	1	1.09511	-22.14732	110	1	1.12	0.95;
	343	1	9.1	2.1	0	0	1	1.09505	-22.1416	110	1	1.12	0.95;
	344	1	0.3	0	0	0	1	1.08161	-24.16483	110	1	1.12	0.95;
	345	1	0.8	0.2	0	0	1	1.08516	-21.72965	110	1	1.12	0.95;
	346	1	0	0	0	0	1	1.08618	-22.74179	110	1	1.12	0.95;
	347	1	11.7	5.6	0	0	1	1.10913	-8.23148	110	1	1.12	0.95;
	348	1	7.8	3.7	0	0	1	1.11041	-8.8288	110	1	1.12	0.95;
	349	1	4.9	0.3	0	0	1	1.07928	-10.12186	110	1	1.12	0.95;
	350	1	3.9	0.6	0	0	1	1.07933	-10.12768	110	1	1.12	0.95;
	351	1	3.7	0.5	0	0	1	1.09061	-26.20407	110	1	1.12	0.95;
	352	1	9.4	0.5	0	0	1	1.08434	-27.97616	110	1	1.12	0.95;
	353	1	11.2	2	0	0	1	1.08424	-22.56771	110	1	1.12	0.95;
	354	1	13.2	2	0	0	1	1.07905	-22.72707	110	1	1.12	0.95;
	355	1	23.9	14.1	0	0	1	1.07417	-2.86263	110	1	1.12	0.95;
	356	1	10.4	5	0	0	1	1.07411	-2.85223	110	1	1.12	0.95;
	357	1	2	0.4	0	0	1	1.08832	-0.74045	110	1	1.12	0.95;
	358	1	0	0	0	0	1	1.08701	-0.92149	110	1	1.12	0.95;
	359	1	13.8	4.9	0	0	1	1.10933	-8.26862	110	1	1.12	0.95;
	360	1	3	1	0	0	1	1.08128	-23.55789	110	1	1.12	0.95;
	361	1	14	1.8	0	0	1	1.09111	-10.25489	110	1	1.12	0.95;
	362	1	0	0	0	0	1	1.08279	-30.81277	110	1	1.12	0.95;
	363	1	11.5	0.2	0	0	1	1.08286	-30.83386	110	1	1.12	0.95;
	364	1	4.7	0	0	0	1	1.08937	-27.61264	110	1	1.12	0.95;
	365	1	5	1.3	0	0	1	1.08132	-24.77895	110	1	1.12	0.95;
	366	1	5.6	0.2	0	0	1	1.09477	-13.82668	110	1	1.12	0.95;
	367	1	24.4	7	0	0	1	1.08065	-22.54595	110	1	1.12	0.95;
	368	1	15.2	1.6	0	0	1	1.0912	-21.7691	110	1	1.12	0.95;
	369	1	11.9	3.8	0	0	1	1.11142	-8.20259	110	1	1.12	0.95;
	370	1	6.5	1.2	0	0	1	1.05106	-26.3103	110	1	1.12	0.95;
	371	1	8.2	0.1	0	0	1	1.10113	-24.84721	110	1	1.12	0.95;
	372	1	16.3	0.5	0	0	1	1.09504	-13.75645	110	1	1.12	0.95;
	373	1	5.7	0.5	0	0	1	1.09483	-9.00116	110	1	1.12	0.95;
	374	1	9.8	3.5	0	0	1	1.11394	-8.52953	110	1	1.12	0.95;
	375	1	18.1	6.5	0	0	1	1.11831	-9.91118	110	1	1.12	0.95;
	376	2	16.7	0	0	0	1	1.09167	-26.39978	110	1	1.12	0.95;
	377	1	5.7	0.5	0	0	1	1.10781	-9.09257	110	1	1.12	0.95;
	378	1	0	0	0	0	1	1.08572	-5.25993	110	1	1.12	0.95;
	379	2	19	6.9	0	0	1	1.11164	-8.18956	110	1	1.12	0.95;
	380	1	18.1	5.9	0	0	1	1.1105	-9.29809	110	1	1.12	0.95;
	381	1	23.8	7.7	0	0	1	1.10942	-8.17851	110	1	1.12	0.95;
	382	1	25.8	8.4	0	0	1	1.11525	-8.47262	110	1	1.12	0.95;
	383	2	49.4	19	0	0	1	1.11072	-8.30378	110	1	1.12	0.95;
	384	2	30.4	12.8	0	0	1	1.11789	-8.30126	110	1	1.12	0.95;
	385	2	30.4	12.8	0	0	1	1.11718	-9.21162	110	1	1.12	0.95;
	386	1	0	0	0	0	1	1.11443	-8.50911	110	1	1.12	0.95;
	387	2	32.5	14.3	0	0	1	1.11142	-8.02036	110	1	1.12	0.95;
	388	2	13.9	6.1	0	0	1	1.11332	-8.57081	110	1	1.12	0.95;
	389	1	6.6	1	0	0	1	1.10266	-12.42043	110	1	1.12	0.95;
	390	1	8.5	0.9	0	0	1	1.10263	-12.43619	110	1	1.12	0.95;
	391	1	2.1	0	0	0	1	1.08285	-26.15438	110	1	1.12	0.95;
	392	1	4.7	0	0	0	1	1.08129	-25.59421	110	1	1.12	0.95;
	393	1	12.6	2.4	0	0	1	1.08346	-25.20457	110	1	1.12	0.95;
	394	1	15.5	4	0	0	1	1.08149	-25.5848	110	1	1.12	0.95;
	395	1	0	0	0	0	1	1.08151	-25.57335	110	1	1.12	0.95;
	396	1	9.1	2.4	0	0	1	1.09474	-21.78479	110	1	1.12	0.95;
	397	1	7.5	1.9	0	0	1	1.09472	-21.77198	110	1	1.12	0.95;
	398	1	14.2	4.6	0	0	1	1.10964	-8.20905	110	1	1.12	0.95;
	399	2	21.1	6.8	0	0	1	1.10809	-8.29653	110	1	1.12	0.95;
	400	1	17.8	1	0	0	1	1.08339	-28.29482	110	1	1.12	0.95;
	401	1	26	9.3	0	0	1	1.11193	-8.60286	110	1	1.12	0.95;
	402	1	17.4	6.2	0	0	1	1.10904	-8.41995	110	1	1.12	0.95;
	403	1	7.4	2.7	0	0	1	1.11044	-8.45395	110	1	1.12	0.95;
	404	1	10.5	0	0	0	1	1.08427	-28.03815	110	1	1.12	0.95;
	405	1	5.2	0	0	0	1	1.08427	-28.06129	110	1	1.12	0.95;
	406	1	10.7	1	0	0	1	1.09567	-24.86756	110	1	1.12	0.95;
	407	1	8.1	1	0	0	1	1.09565	-24.87681	110	1	1.12	0.95;
	408	1	17.9	5.8	0	0	1	1.11065	-8.43145	110	1	1.12	0.95;
	409	1	9.3	1.8	0	0	1	1.10037	-9.25766	110	1	1.12	0.95;
	410	1	5.2	0.4	0	0	1	1.0995	-9.34481	110	1	1.12	0.95;
	411	1	51.9	16.9	0	0	1	1.10511	-8.52131	110	1	1.12	0.95;
	412	1	12	2.4	0	0	1	1.06307	-21.22722	110	1	1.12	0.95;
	413	1	8.8	2.3	0	0	1	1.06308	-21.23896	110	1	1.12	0.95;
	414	1	2.3	0.9	0	0	1	1.09375	-25.00746	110	1	1.12	0.95;
	415	1	10.7	2	0	0	1	1.09376	-25.00658	110	1	1.12	0.95;
	416	1	0	0	0	0	1	1.10366	-9.6051	110	1	1.12	0.95;
	417	1	9.6	0.8	0	0	1	1.07811	-30.39937	110	1	1.12	0.95;
	418	1	17.6	5.7	0	0	1	1.10954	-9.22529	110	1	1.12	0.95;
	419	1	6.1	2.6	0	0	1	1.06083	-29.2042	110	1	1.12	0.95;
	420	1	6.9	2	0	0	1	1.06073	-29.20755	110	1	1.12	0.95;
	421	1	20.7	6.2	0	0	1	1.08398	-21.70512	110	1	1.12	0.95;
	422	1	20.7	6.2	0	0	1	1.08695	-22.66227	110	1	1.12	0.95;
	423	1	5.2	0	0	0	1	1.08657	-25.70625	110	1	1.12	0.95;
	424	1	1.2	0.2	0	0	1	1.06465	-24.66418	110	1	1.12	0.95;
	425	1	0	0	0	0	1	1.09242	-21.87656	110	1	1.12	0.95;
	426	1	0	0	0	0	1	1.09822	-21.00492	110	1	1.12	0.95;
	427	1	0	0	0	45	1	1.08968	-22.23631	16	1	1.25	0.75;
	428	1	0	0	0	0	1	0.99031	-17.95869	32	1	1.25	0.75;
	429	1	20.3	4	0	0	1	1.02989	-19.96869	110	1	1.12	0.95;
	430	1	22.3	4	0	0	1	1.0766	-22.88256	110	1	1.12	0.95;
	431	1	0	0	0	0	1	1.09263	-21.88081	110	1	1.12	0.95;
	432	1	6.3	0.5	0	0	1	1.06419	-35.89137	110	1	1.12	0.95;
	433	2	12.1	3.6	0	0	1	1.08239	-26.16695	110	1	1.12	0.95;
	434	1	15.2	0.8	0	0	1	1.06862	-30.48155	110	1	1.12	0.95;
	435	1	19.5	6.3	0	0	1	1.11178	-8.1748	110	1	1.12	0.95;
	436	1	15.5	2.6	0	0	1	1.09348	-22.35167	110	1	1.12	0.95;
	437	1	0	0	0	0	1	1.09627	-21.3785	110	1	1.12	0.95;
	438	1	7.8	0.5	0	0	1	1.08356	-28.81488	110	1	1.12	0.95;
	439	1	3.5	1.1	0	0	1	1.09264	-22.19897	110	1	1.12	0.95;
	440	1	0	0	0	0	1	1.09922	-21.74931	110	1	1.12	0.95;
	441	1	0	0	0	0	1	1.0992	-21.74419	110	1	1.12	0.95;
	442	1	0	0	0	15	1	0.97336	-23.01064	16	1	1.25	0.75;
	443	1	0	0	0	15	1	0.98201	-22.57098	16	1	1.25	0.75;
	444	1	10.7	3	0	0	1	1.0599	-25.19615	110	1	1.12	0.95;
	445	1	6.4	0.8	0	0	1	1.08224	-24.38396	110	1	1.12	0.95;
	446	1	3.6	0.5	0	0	1	1.08219	-24.37958	110	1	1.12	0.95;
	447	1	6	0.9	0	0	1	1.11849	-22.18384	110	1	1.12	0.95;
	448	1	6.2	0.9	0	0	1	1.11851	-22.18786	110	1	1.12	0.95;
	449	1	0	0	0	0	1	1.09993	-20.92647	110	1	1.12	0.95;
	450	1	0	0	0	0	1	1.10007	-20.85216	110	1	1.12	0.95;
	451	1	0	0	0	0	1	1.10001	-20.8985	110	1	1.12	0.95;
	452	1	0	0	0	0	1	0.96893	-21.65053	16	1	1.25	0.75;
	453	1	6.3	1.3	0	0	1	1.07356	-13.80611	110	1	1.12	0.95;
	454	1	8.9	1.5	0	0	1	1.09355	-25.8278	110	1	1.12	0.95;
	455	2	45.1	21.8	0	0	1	1.1199	-20.99234	110	1	1.12	0.95;
	456	2	32.5	15.7	0	0	1	1.11997	-21.29439	110	1	1.12	0.95;
	457	2	94.2	53.6	0	0	1	1.11356	-19.26797	110	1	1.12	0.95;
	458	2	77.9	45.6	0	0	1	1.11649	-19.94432	110	1	1.12	0.95;
	459	1	0	0	0	0	1	1.10432	-24.10932	110	1	1.12	0.95;
	460	1	0	0	0	0	1	1.10412	-24.14361	110	1	1.12	0.95;
	461	1	10.4	0.3	0	0	1	1.07895	-26.62965	110	1	1.12	0.95;
	462	1	14.3	1.2	0	0	1	1.07758	-27.63542	110	1	1.12	0.95;
	463	1	6.2	0.3	0	0	1	1.07756	-27.65175	110	1	1.12	0.95;
	464	1	3.7	0.3	0	0	1	1.07003	-32.4365	110	1	1.12	0.95;
	465	1	0	0	0	0	1	1.08349	-28.66001	110	1	1.12	0.95;
	466	1	11.7	2	0	0	1	1.07962	-25.77685	110	1	1.12	0.95;
	467	1	11.2	2.5	0	0	1	1.07961	-25.77872	110	1	1.12	0.95;
	468	1	6.6	1.1	0	0	1	1.08819	-10.59671	110	1	1.12	0.95;
	469	1	4.8	1.1	0	0	1	1.10042	-10.67966	110	1	1.12	0.95;
	470	1	15.7	1	0	0	1	1.06819	-35.08145	110	1	1.12	0.95;
	471	1	9.9	0.5	0	0	1	1.06971	-30.20288	110	1	1.12	0.95;
	472	1	7.2	0.9	0	0	1	1.07334	-13.2723	110	1	1.12	0.95;
	473	1	7.8	1.4	0	0	1	1.07344	-13.2925	110	1	1.12	0.95;
	474	1	7.6	2.5	0	0	1	1.08	-25.81386	110	1	1.12	0.95;
	475	1	15.6	3.6	0	0	1	1.09527	-25.36796	110	1	1.12	0.95;
	476	1	11.8	2.6	0	0	1	1.0963	-25.43706	110	1	1.12	0.95;
	477	1	25.1	7.4	0	0	1	1.06636	-29.03502	110	1	1.12	0.95;
	478	2	-7.7	18	0	0	1	1.09916	-25.12169	110	1	1.12	0.95;
	479	2	13.6	11.3	0	0	1	1.09548	-27.15081	110	1	1.12	0.95;
	480	1	2.6	0.2	0	0	1	1.08325	-29.99428	110	1	1.12	0.95;
	481	1	18.7	5.6	0	0	1	1.08515	-22.47199	110	1	1.12	0.95;
	482	2	22.6	7.3	0	0	1	1.10618	-11.6262	110	1	1.12	0.95;
	483	1	18.3	5.6	0	0	1	1.09197	-22.52784	110	1	1.12	0.95;
	484	1	12.5	5.2	0	0	1	1.11343	-8.03669	110	1	1.12	0.95;
	485	1	5.4	2.2	0	0	1	1.11176	-8.10282	110	1	1.12	0.95;
	486	1	0	0	0	0	1	1.08365	-2.79663	110	1	1.12	0.95;
	487	1	0	0	0	0	1	1.08697	-0.92035	110	1	1.12	0.95;
	488	1	4.4	0.2	0	0	1	1.11517	-21.11709	110	1	1.12	0.95;
	489	1	2.8	1	0	0	1	1.07824	-27.52997	110	1	1.12	0.95;
	490	1	7.2	1	0	0	1	1.10262	-11.02657	110	1	1.12	0.95;
	491	1	8.6	0.8	0	0	1	1.12	-22.12997	110	1	1.12	0.95;
	492	1	5.4	0.2	0	0	1	1.12	-20.49855	110	1	1.12	0.95;
	493	1	0	0	0	0	1	1.11822	-21.05991	110	1	1.12	0.95;
	494	1	0	0	0	0	1	1.11517	-22.84008	110	1	1.12	0.95;
	495	1	5.6	1.2	0	0	1	1.08149	-24.33037	110	1	1.12	0.95;
	496	1	5.6	1.2	0	0	1	1.08153	-24.34743	110	1	1.12	0.95;
	497	1	5	0.6	0	0	1	1.0759	-13.93308	110	1	1.12	0.95;
	498	1	16.2	4	0	0	1	1.09597	-21.7883	110	1	1.12	0.95;
	499	1	38.8	8	0	0	1	1.10134	-21.06169	110	1	1.12	0.95;
	500	2	12.2	1.3	0	0	1	1.0928	-5.46596	110	1	1.12	0.95;
	501	1	10.4	1.1	0	0	1	1.0975	-3.74458	110	1	1.12	0.95;
	502	1	14.1	0	0	0	1	1.07513	-32.04311	110	1	1.12	0.95;
	503	1	12.4	1.5	0	0	1	1.09138	-5.26931	110	1	1.12	0.95;
	504	1	15.3	1	0	0	1	1.11876	-22.21918	110	1	1.12	0.95;
	505	1	12.9	2.2	0	0	1	1.04764	-18.68061	110	1	1.12	0.95;
	506	1	3	0.3	0	0	1	1.11513	-22.83938	110	1	1.12	0.95;
	507	1	0	0	0	0	1	1.11509	-22.85464	110	1	1.12	0.95;
	508	1	4.2	0	0	0	1	1.07684	-28.20177	110	1	1.12	0.95;
	509	1	0	0	0	0	1	1.12	-20.02624	110	1	1.12	0.95;
	510	1	0	0	0	0	1	1.11947	-21.89143	110	1	1.12	0.95;
	511	1	0	0	0	0	1	0.99252	-17.96045	32	1	1.25	0.75;
	512	1	25.3	3.2	0	0	1	1.0941	-3.58684	110	1	1.12	0.95;
	513	1	7.2	1.6	0	0	1	1.07944	-25.82267	110	1	1.12	0.95;
	514	1	9.1	1	0	0	1	1.11935	-22.18273	110	1	1.12	0.95;
	515	1	11.2	0.7	0	0	1	1.08917	-24.53356	110	1	1.12	0.95;
	516	1	11	1.1	0	0	1	1.08921	-24.52045	110	1	1.12	0.95;
	517	1	7.1	1	0	0	1	1.1032	-10.98711	110	1	1.12	0.95;
	518	1	9.4	5	0	0	1	1.09309	-25.48817	110	1	1.12	0.95;
	519	1	21.2	6.9	0	0	1	1.09118	-22.72712	110	1	1.12	0.95;
	520	1	21.2	6.9	0	0	1	1.0911	-22.73935	110	1	1.12	0.95;
	521	1	16.2	2	0	0	1	1.08717	-23.58786	110	1	1.12	0.95;
	522	2	9.1	2	0	0	1	1.08945	-23.06192	110	1	1.12	0.95;
	523	1	18.7	3.6	0	0	1	1.07626	-28.54091	110	1	1.12	0.95;
	524	1	12	0.6	0	0	1	1.08003	-26.31976	110	1	1.12	0.95;
	525	1	22.7	4.6	0	0	1	1.06564	-24.42028	110	1	1.12	0.95;
	526	1	15.8	4	0	0	1	1.09135	-22.68895	110	1	1.12	0.95;
	527	2	15.7	5.6	0	0	1	1.11109	-8.25448	110	1	1.12	0.95;
	528	1	0	0	0	0	1	1.11109	-8.25452	110	1	1.12	0.95;
	529	1	12.4	1.4	0	0	1	1.05865	-3.92932	110	1	1.12	0.95;
	530	1	7.8	0.1	0	0	1	1.11719	-22.52505	110	1	1.12	0.95;
	531	1	16.5	1.6	0	0	1	1.07734	-13.18027	110	1	1.12	0.95;
	532	2	13.8	4.1	0	0	1	1.09769	-24.27473	110	1	1.12	0.95;
	533	1	11.9	3.6	0	0	1	1.09767	-24.25502	110	1	1.12	0.95;
	534	1	9.4	3.1	0	0	1	1.11371	-8.53959	110	1	1.12	0.95;
	535	1	6.1	3.2	0	0	1	1.04834	-25.62672	110	1	1.12	0.95;
	536	1	7.1	2.3	0	0	1	1.05675	-29.38735	110	1	1.12	0.95;
	537	1	10.9	2.6	0	0	1	1.0595	-3.88331	110	1	1.12	0.95;
	538	1	11.4	2.8	0	0	1	1.05947	-3.88802	110	1	1.12	0.95;
	539	1	0	0	0	0	1	1.09476	-8.14274	110	1	1.12	0.95;
	540	1	13.1	0	0	0	1	1.05205	-36.74671	110	1	1.12	0.95;
	541	1	4.2	1	0	0	1	1.08602	-0.74792	110	1	1.12	0.95;
	542	1	3.7	0.8	0	0	1	1.08595	-0.76108	110	1	1.12	0.95;
	543	2	4.9	1	0	0	1	1.06047	-3.8015	110	1	1.12	0.95;
	544	1	5.2	1	0	0	1	1.08603	-5.19764	110	1	1.12	0.95;
	545	1	9.1	3.3	0	0	1	1.11072	-8.25215	110	1	1.12	0.95;
	546	1	19.5	6.3	0	0	1	1.11092	-8.96669	110	1	1.12	0.95;
	547	1	8.9	1	0	0	1	1.0963	-7.44894	110	1	1.12	0.95;
	548	1	8.9	1	0	0	1	1.0758	-14.66282	110	1	1.12	0.95;
	549	1	0.8	0.3	0	0	1	1.04929	-26.53739	110	1	1.12	0.95;
	550	1	7.2	1	0	0	1	1.09638	-10.22487	110	1	1.12	0.95;
	551	1	8.1	1.3	0	0	1	1.04739	-26.81409	110	1	1.12	0.95;
	552	1	8.7	1.3	0	0	1	1.04737	-26.79083	110	1	1.12	0.95;
	553	1	12.2	1.7	0	0	1	1.04782	-26.35759	110	1	1.12	0.95;
	554	1	11.1	1.3	0	0	1	1.04939	-25.80146	110	1	1.12	0.95;
	555	1	11.7	2	0	0	1	1.04939	-25.77511	110	1	1.12	0.95;
	556	1	5.8	0	0	0	1	1.04985	-37.05069	110	1	1.12	0.95;
	557	1	7.7	1.6	0	0	1	1.08092	-26.03114	110	1	1.12	0.95;
	558	1	36.7	8.4	0	0	1	1.0911	-22.28866	110	1	1.12	0.95;
	559	1	2.2	0.5	0	0	1	1.10166	-5.96746	110	1	1.12	0.95;
	560	1	17.1	0.6	0	0	1	1.06398	-13.62198	110	1	1.12	0.95;
	561	1	11.4	0.8	0	0	1	1.06392	-13.63448	110	1	1.12	0.95;
	562	1	9.4	0.5	0	0	1	1.06621	-30.10158	110	1	1.12	0.95;
	563	1	7.3	0.5	0	0	1	1.06628	-30.12002	110	1	1.12	0.95;
	564	1	19.5	4.7	0	0	1	1.09562	-21.32214	110	1	1.12	0.95;
	565	1	10.1	1.4	0	0	1	1.1014	-24.86289	110	1	1.12	0.95;
	566	1	12.1	0.6	0	0	1	1.09385	-13.92538	110	1	1.12	0.95;
	567	1	18.8	2	0	0	1	1.04232	-28.12253	110	1	1.12	0.95;
	568	1	0	0	0	0	1	1.05504	-25.80854	110	1	1.12	0.95;
	569	1	13.7	4.5	0	0	1	1.09377	-15.59633	110	1	1.12	0.95;
	570	1	18.7	3.5	0	0	1	1.11285	-23.35071	110	1	1.12	0.95;
	571	1	11.4	1.8	0	0	1	1.11293	-23.33364	110	1	1.12	0.95;
	572	2	10.2	2	0	0	1	1.04123	-28.58639	110	1	1.12	0.95;
	573	1	10.5	2.5	0	0	1	1.04126	-28.59686	110	1	1.12	0.95;
	574	1	23.4	3.5	0	0	1	1.08089	-10.35979	110	1	1.12	0.95;
	575	1	11.3	0.4	0	0	1	1.10304	-23.16791	110	1	1.12	0.95;
	576	1	13.6	4.4	0	0	1	1.11078	-8.40962	110	1	1.12	0.95;
	577	1	0	0	0	0	1	1.07438	-19.0364	110	1	1.12	0.95;
	578	1	8.8	1.3	0	0	1	1.07434	-19.0565	110	1	1.12	0.95;
	579	1	8.6	2.8	0	0	1	1.10548	-9.41229	110	1	1.12	0.95;
	580	1	5.2	0.5	0	0	1	1.10447	-22.48938	110	1	1.12	0.95;
	581	1	3.5	0.5	0	0	1	1.09351	-4.27816	110	1	1.12	0.95;
	582	1	0	0	0	0	1	1.05882	-35.15505	110	1	1.12	0.95;
	583	1	0	0	0	0	1	1.05882	-35.14208	110	1	1.12	0.95;
	584	1	20.9	1.5	0	0	1	1.05248	-36.53247	110	1	1.12	0.95;
	585	1	1.4	0	0	0	1	1.02979	-20.02863	110	1	1.12	0.95;
	586	1	0.8	0.2	0	0	1	1.08637	-22.02682	110	1	1.12	0.95;
	587	1	15.7	1	0	0	1	1.08421	-33.39974	110	1	1.12	0.95;
	588	1	6	0.3	0	0	1	1.11444	-22.48084	110	1	1.12	0.95;
	589	1	4.1	1	0	0	1	1.07823	-13.85814	110	1	1.12	0.95;
	590	1	19.8	6	0	0	1	1.08244	-23.1662	110	1	1.12	0.95;
	591	1	20.6	6.7	0	0	1	1.11778	-9.57453	110	1	1.12	0.95;
	592	1	6.5	1.1	0	0	1	1.10153	-23.8787	110	1	1.12	0.95;
	593	1	6.5	1.1	0	0	1	1.10164	-23.86626	110	1	1.12	0.95;
	594	1	5.2	0.4	0	0	1	1.07813	-30.14962	110	1	1.12	0.95;
	595	1	6.6	1	0	0	1	1.03519	-26.28298	110	1	1.12	0.95;
	596	1	7	1	0	0	1	1.03512	-26.28986	110	1	1.12	0.95;
	597	2	11.8	1	0	0	1	1.08727	-5.10951	110	1	1.12	0.95;
	598	1	7.8	1.2	0	0	1	1.07721	-9.98506	110	1	1.12	0.95;
	599	1	10.4	2	0	0	1	1.08537	-5.25426	110	1	1.12	0.95;
	600	1	9.6	1.1	0	0	1	1.07605	-10.09612	110	1	1.12	0.95;
	601	1	0	0	0	0	1	1.10355	-5.32355	110	1	1.12	0.95;
	602	1	0	0	0	0	1	1.09989	-5.28352	110	1	1.12	0.95;
	603	2	2	0.6	0	0	1	1.09264	-22.20472	110	1	1.12	0.95;
	604	1	0	0	0	0	1	1.09262	-22.20645	110	1	1.12	0.95;
	605	1	8.6	2.6	0	0	1	1.09778	-21.82351	110	1	1.12	0.95;
	606	1	0	0	0	0	1	1.0979	-21.81394	110	1	1.12	0.95;
	607	1	0	0	0	0	1	1.08986	-26.11031	110	1	1.12	0.95;
	608	1	8.4	0.1	0	0	1	1.0949	-24.52136	110	1	1.12	0.95;
	609	1	29.3	6.4	0	0	1	1.09273	-22.43727	110	1	1.12	0.95;
	610	1	29.3	8.7	0	0	1	1.09279	-22.41924	110	1	1.12	0.95;
	611	1	20.4	5.1	0	0	1	1.09251	-21.96494	110	1	1.12	0.95;
	612	1	20.4	5.1	0	0	1	1.09242	-21.99207	110	1	1.12	0.95;
	613	1	0	0	0	0	1	1.09522	-21.75279	110	1	1.12	0.95;
	614	1	14.1	3.2	0	0	1	1.09522	-21.75279	110	1	1.12	0.95;
	615	1	20.2	5	0	0	1	1.08974	-23.47383	110	1	1.12	0.95;
	616	1	20.2	5	0	0	1	1.08999	-23.45583	110	1	1.12	0.95;
	617	1	2	1	0	0	1	1.08215	-25.51974	110	1	1.12	0.95;
	618	1	10.4	3	0	0	1	1.06322	-13.71029	110	1	1.12	0.95;
	619	1	11.8	2	0	0	1	1.04412	-29.3833	110	1	1.12	0.95;
	620	1	4.5	1.4	0	0	1	1.09703	-22.20843	110	1	1.12	0.95;
	621	1	4.5	1.4	0	0	1	1.0972	-22.19946	110	1	1.12	0.95;
	622	1	18.2	5.6	0	0	1	1.09079	-22.34383	110	1	1.12	0.95;
	623	1	18.2	5.8	0	0	1	1.09083	-22.35529	110	1	1.12	0.95;
	624	1	16.7	5.1	0	0	1	1.0959	-23.05392	110	1	1.12	0.95;
	625	1	16.7	5.1	0	0	1	1.09233	-22.58495	110	1	1.12	0.95;
	626	1	13.1	3.9	0	0	1	1.09183	-22.11659	110	1	1.12	0.95;
	627	1	13.1	3.9	0	0	1	1.09177	-22.14018	110	1	1.12	0.95;
	628	1	7.3	0.1	0	0	1	1.06179	-36.60057	110	1	1.12	0.95;
	629	1	25.2	7.5	0	0	1	1.09407	-22.25885	110	1	1.12	0.95;
	630	1	37.3	11.2	0	0	1	1.09638	-21.34941	110	1	1.12	0.95;
	631	1	0.8	0.2	0	0	1	1.09863	-5.98186	110	1	1.12	0.95;
	632	1	3.1	0.7	0	0	1	1.09866	-5.99472	110	1	1.12	0.95;
	633	1	26	9.3	0	0	1	1.11093	-8.76196	110	1	1.12	0.95;
	634	1	1.3	0.2	0	0	1	1.08219	-25.66967	110	1	1.12	0.95;
	635	1	4	0.8	0	0	1	1.07663	-22.02574	110	1	1.12	0.95;
	636	1	4	0.8	0	0	1	1.0766	-22.01864	110	1	1.12	0.95;
	637	1	4.2	0	0	0	1	1.08687	-27.28431	110	1	1.12	0.95;
	638	1	14.1	3.5	0	0	1	1.08647	-22.76944	110	1	1.12	0.95;
	639	1	14.1	3.5	0	0	1	1.0983	-21.82933	110	1	1.12	0.95;
	640	1	7.1	2.1	0	0	1	1.08127	-23.75166	110	1	1.12	0.95;
	641	1	7.1	2.1	0	0	1	1.08588	-22.71656	110	1	1.12	0.95;
	642	1	17.7	4.4	0	0	1	1.09533	-21.73207	110	1	1.12	0.95;
	643	1	17.7	4.4	0	0	1	1.09531	-21.76683	110	1	1.12	0.95;
	644	1	16.1	4.5	0	0	1	1.08694	-22.71768	110	1	1.12	0.95;
	645	1	16.1	4.5	0	0	1	1.08687	-22.72957	110	1	1.12	0.95;
	646	1	10.2	1.7	0	0	1	1.05093	-25.51457	110	1	1.12	0.95;
	647	1	10.3	1.6	0	0	1	1.05077	-25.53705	110	1	1.12	0.95;
	648	1	15	1.8	0	0	1	1.08284	-7.68397	110	1	1.12	0.95;
	649	1	10.4	1.3	0	0	1	1.08288	-7.70141	110	1	1.12	0.95;
	650	1	23.2	6.9	0	0	1	1.09643	-23.07245	110	1	1.12	0.95;
	651	1	23.2	6.9	0	0	1	1.09651	-23.05958	110	1	1.12	0.95;
	652	1	14.6	3.3	0	0	1	1.09617	-23.05262	110	1	1.12	0.95;
	653	1	14.6	3.3	0	0	1	1.09632	-23.04595	110	1	1.12	0.95;
	654	1	14.6	3.8	0	0	1	1.09884	-21.21762	110	1	1.12	0.95;
	655	1	14.6	3.8	0	0	1	1.09884	-21.21914	110	1	1.12	0.95;
	656	1	29.3	9.3	0	0	1	1.07825	-22.34205	110	1	1.12	0.95;
	657	1	29.3	9.3	0	0	1	1.078	-22.33917	110	1	1.12	0.95;
	658	1	11.1	3.3	0	0	1	1.07951	-23.56217	110	1	1.12	0.95;
	659	1	11.1	3.3	0	0	1	1.07954	-23.54256	110	1	1.12	0.95;
	660	1	2	0.5	0	0	1	1.08497	-7.47422	110	1	1.12	0.95;
	661	1	7.1	1.4	0	0	1	1.04739	-25.72609	110	1	1.12	0.95;
	662	1	7.1	1.4	0	0	1	1.04728	-25.73874	110	1	1.12	0.95;
	663	1	10.1	2.5	0	0	1	1.09635	-23.08458	110	1	1.12	0.95;
	664	1	10.1	2.5	0	0	1	1.091	-22.75712	110	1	1.12	0.95;
	665	1	30.8	9.2	0	0	1	1.07702	-22.17364	110	1	1.12	0.95;
	666	1	30.8	9.2	0	0	1	1.09235	-21.98756	110	1	1.12	0.95;
	667	1	26.2	8.6	0	0	1	1.09221	-21.94923	110	1	1.12	0.95;
	668	1	26.2	8.6	0	0	1	1.09226	-21.93419	110	1	1.12	0.95;
	669	1	5.9	0.6	0	0	1	1.1138	-22.72443	110	1	1.12	0.95;
	670	2	53.3	50.6	0	0	1	1.08156	-21.36878	110	1	1.12	0.95;
	671	2	55.3	52.6	0	0	1	1.1031	-20.80839	110	1	1.12	0.95;
	672	1	16.1	5	0	0	1	1.10199	-20.88231	110	1	1.12	0.95;
	673	1	18.2	5.6	0	0	1	1.08028	-21.4558	110	1	1.12	0.95;
	674	1	15.1	4.4	0	0	1	1.09411	-23.02791	110	1	1.12	0.95;
	675	1	15.1	4.4	0	0	1	1.09396	-23.02142	110	1	1.12	0.95;
	676	1	25.2	8.8	0	0	1	1.09232	-22.05143	110	1	1.12	0.95;
	677	1	25.2	8.8	0	0	1	1.09227	-22.04198	110	1	1.12	0.95;
	678	1	19.2	5.5	0	0	1	1.07809	-21.84812	110	1	1.12	0.95;
	679	1	19.2	5.5	0	0	1	1.07811	-21.81908	110	1	1.12	0.95;
	680	1	26.7	6.6	0	0	1	1.08983	-22.65573	110	1	1.12	0.95;
	681	1	26.7	6.6	0	0	1	1.08964	-22.66919	110	1	1.12	0.95;
	682	1	25.2	7.5	0	0	1	1.09693	-23.00812	110	1	1.12	0.95;
	683	1	25.2	7.5	0	0	1	1.09292	-22.0518	110	1	1.12	0.95;
	684	1	8.1	2.4	0	0	1	1.09626	-22.1927	110	1	1.12	0.95;
	685	1	8.1	2.4	0	0	1	1.09638	-22.19177	110	1	1.12	0.95;
	686	1	22.2	5.5	0	0	1	1.09632	-21.88966	110	1	1.12	0.95;
	687	1	22.2	5.5	0	0	1	1.09628	-21.88738	110	1	1.12	0.95;
	688	1	22.2	6.6	0	0	1	1.07668	-21.94167	110	1	1.12	0.95;
	689	1	22.2	6.6	0	0	1	1.07664	-21.95925	110	1	1.12	0.95;
	690	1	12.1	3	0	0	1	1.09204	-22.53168	110	1	1.12	0.95;
	691	1	12.1	3	0	0	1	1.09197	-22.51456	110	1	1.12	0.95;
	692	2	48.4	15.5	0	0	1	1.07855	-23.77635	110	1	1.12	0.95;
	693	1	9.1	2.9	0	0	1	1.09116	-22.37684	110	1	1.12	0.95;
	694	2	15.9	4	0	0	1	1.06609	-28.78617	110	1	1.12	0.95;
	695	1	5.8	0.5	0	0	1	1.07496	-34.81394	110	1	1.12	0.95;
	696	1	18.3	1.5	0	0	1	1.07535	-28.54474	110	1	1.12	0.95;
	697	1	5.2	0	0	0	1	1.06417	-28.94185	110	1	1.12	0.95;
	698	1	0	0	0	0	1	1.06415	-28.94657	110	1	1.12	0.95;
	699	1	0	0	0	0	1	1.02524	-26.52712	110	1	1.12	0.95;
	700	2	24.1	12.9	0	0	1	1.09876	-23.00627	110	1	1.12	0.95;
	701	2	45.2	32.7	0	0	1	1.09829	-22.1592	110	1	1.12	0.95;
	702	2	14.1	13.1	0	0	1	1.09885	-22.96959	110	1	1.12	0.95;
	703	1	0	0	0	0	1	1.07521	-28.15649	110	1	1.12	0.95;
	704	1	0	0	0	0	1	1.11104	-9.29683	110	1	1.12	0.95;
	705	1	0	0	0	0	1	1.09531	-25.36639	110	1	1.12	0.95;
	706	1	0	0	0	0	1	1.09631	-25.4362	110	1	1.12	0.95;
	707	1	0	0	0	0	1	1.08703	-31.93403	110	1	1.12	0.95;
	708	1	0	0	0	0	1	1.08517	-21.72924	110	1	1.12	0.95;
	709	1	0	0	0	0	1	1.08618	-22.74179	110	1	1.12	0.95;
	710	1	0	0	0	0	1	1.10277	-24.70231	110	1	1.12	0.95;
	711	1	0	0	0	0	1	1.11064	-8.4278	110	1	1.12	0.95;
	712	1	0	0	0	0	1	1.08406	-21.69924	110	1	1.12	0.95;
	713	1	0	0	0	0	1	1.08704	-22.65643	110	1	1.12	0.95;
	714	1	0	0	0	0	1	1.0647	-24.66081	110	1	1.12	0.95;
	715	1	0	0	0	0	1	1.09414	-22.29437	110	1	1.12	0.95;
	716	1	0	0	0	0	1	1.09626	-21.3784	110	1	1.12	0.95;
	717	1	0	0	0	0	1	1.061	-3.7467	110	1	1.12	0.95;
	718	1	0	0	0	0	1	1.11077	-8.24847	110	1	1.12	0.95;
	719	1	0	0	0	0	1	1.08612	-0.63202	110	1	1.12	0.95;
	720	1	0	0	0	0	1	1.04932	-26.53583	110	1	1.12	0.95;
	721	1	0	0	0	0	1	1.05504	-25.80854	110	1	1.12	0.95;
	722	1	0	0	0	0	1	1.10458	-22.47506	110	1	1.12	0.95;
	723	1	0	0	0	0	1	1.09384	-4.2364	110	1	1.12	0.95;
	724	1	0	0	0	0	1	1.08986	-26.11031	110	1	1.12	0.95;
	725	1	0	0	0	0	1	1.07418	-23.6982	110	1	1.12	0.95;
	726	1	0	0	0	0	1	1.11387	-8.52309	110	1	1.12	0.95;
	727	1	0	0	0	0	1	1.11738	-8.33612	110	1	1.12	0.95;
	728	1	12.9	2.5	0	0	1	1.089	-22.33026	110	1	1.12	0.95;
	729	1	10.2	2	0	0	1	1.08058	-23.82097	110	1	1.12	0.95;
	730	1	10.9	1.4	0	0	1	1.07379	-23.74782	110	1	1.12	0.95;
	731	1	6.9	0.3	0	0	1	1.08731	-26.49109	110	1	1.12	0.95;
	732	1	9.4	0.6	0	0	1	1.07665	-28.70327	110	1	1.12	0.95;
	733	1	10.5	1	0	0	1	1.07669	-28.70063	110	1	1.12	0.95;
	734	1	5.7	1	0	0	1	1.08011	-9.06718	110	1	1.12	0.95;
	735	2	7.2	1.3	0	0	1	1.09514	-9.73365	110	1	1.12	0.95;
	736	1	7.2	1.3	0	0	1	1.09528	-9.73861	110	1	1.12	0.95;
	737	1	13.4	5.6	0	0	1	1.11605	-8.57406	110	1	1.12	0.95;
	738	1	5.8	2.4	0	0	1	1.12	-9.79997	110	1	1.12	0.95;
	739	1	0.6	0.2	0	0	1	1.08864	-0.74858	110	1	1.12	0.95;
	740	1	8.3	0.6	0	0	1	1.08856	-10.08673	110	1	1.12	0.95;
	741	1	3.1	0.7	0	0	1	1.07603	-3.6417	110	1	1.12	0.95;
	742	1	3.8	0.8	0	0	1	1.07604	-3.64046	110	1	1.12	0.95;
	743	1	0	0	0	0	1	1.11162	-8.26287	110	1	1.12	0.95;
	744	1	4.5	1.4	0	0	1	1.08848	-22.57016	110	1	1.12	0.95;
	745	1	0	0	0	0	1	1.08836	-22.58833	110	1	1.12	0.95;
	746	1	0.4	0.1	0	0	1	1.0942	-22.16814	110	1	1.12	0.95;
	747	1	0	0	0	0	1	1.09423	-22.19591	110	1	1.12	0.95;
	748	1	8.3	2.4	0	0	1	1.0755	-13.92125	110	1	1.12	0.95;
	749	1	13.6	0.5	0	0	1	1.08535	-27.10953	110	1	1.12	0.95;
	750	1	9.1	3	0	0	1	1.11729	-8.34233	110	1	1.12	0.95;
	751	1	7.1	2	0	0	1	1.04265	-29.3026	110	1	1.12	0.95;
	752	2	14.9	2.3	0	0	1	1.09801	-25.08951	110	1	1.12	0.95;
	753	1	10.4	1.5	0	0	1	1.08409	-24.53353	110	1	1.12	0.95;
	754	1	6.2	0.6	0	0	1	1.08402	-24.53423	110	1	1.12	0.95;
	755	1	0	0	0	0	1	1.11008	-14.80675	110	2	1.12	0.95;
	756	1	10.3	0.2	0	0	1	1.11009	-14.80158	110	2	1.12	0.95;
	757	1	3.8	-0.8	0	0	1	1.0887	-14.30768	110	2	1.12	0.95;
	758	1	8.5	0.9	0	0	1	1.09865	-16.27481	110	2	1.12	0.95;
	759	1	11.9	0.8	0	0	1	1.09045	-13.0487	110	2	1.12	0.95;
	760	1	8.6	1	0	0	1	1.09568	-16.0329	110	2	1.12	0.95;
	761	1	22.9	8	0	0	1	1.0945	-12.76136	110	2	1.12	0.95;
	762	1	0	0	0	0	1	1.09449	-12.76691	110	2	1.12	0.95;
	763	1	21.5	4	0	0	1	1.09618	-16.60893	110	2	1.12	0.95;
	764	1	10.8	1	0	0	1	1.0837	-15.53559	110	2	1.12	0.95;
	765	1	5.8	1.3	0	0	1	1.06434	-13.79975	110	2	1.12	0.95;
	766	2	20.1	2.8	0	0	1	1.09463	-14.31303	110	2	1.12	0.95;
	767	1	6.8	1.1	0	0	1	1.0936	-14.39127	110	2	1.12	0.95;
	768	1	7.5	0	0	0	1	1.08112	-14.61938	110	2	1.12	0.95;
	769	1	2.8	0	0	0	1	1.08104	-14.62293	110	2	1.12	0.95;
	770	1	10.1	1.1	0	0	1	1.04153	-24.79015	110	2	1.12	0.95;
	771	1	0	0	0	0	1	1.04157	-24.7955	110	2	1.12	0.95;
	772	1	15.9	1.1	0	0	1	1.04065	-24.70515	110	2	1.12	0.95;
	773	1	3.8	0.3	0	0	1	1.08456	-14.84842	110	2	1.12	0.95;
	774	1	3.4	0	0	0	1	1.0788	-16.93113	110	2	1.12	0.95;
	775	2	23.8	1.7	0	0	1	1.09067	-16.12355	110	2	1.12	0.95;
	776	1	0	0	0	0	1	1.09073	-16.11863	110	2	1.12	0.95;
	777	1	12.9	1	0	0	1	1.08788	-11.71625	110	2	1.12	0.95;
	778	1	6.5	0	0	0	1	1.08993	-11.65481	110	2	1.12	0.95;
	779	1	10	2.2	0	0	1	1.09929	-15.61482	110	2	1.12	0.95;
	780	1	11.6	0.6	0	0	1	1.08986	-13.01582	110	2	1.12	0.95;
	781	1	0	0	0	0	1	1.0912	-16.98032	110	2	1.12	0.95;
	782	1	11.8	1.5	0	0	1	1.09121	-16.97938	110	2	1.12	0.95;
	783	1	14	4	0	0	1	1.09091	-16.99515	110	2	1.12	0.95;
	784	1	9.5	0.4	0	0	1	1.09272	-16.96258	110	2	1.12	0.95;
	785	1	0	0	0	0	1	1.10384	-11.69472	110	2	1.12	0.95;
	786	1	0	0	0	0	1	1.10378	-11.69308	110	2	1.12	0.95;
	787	1	9	0	0	0	1	1.09283	-16.96704	110	2	1.12	0.95;
	788	1	8.6	1.5	0	0	1	1.09015	-14.37594	110	2	1.12	0.95;
	789	1	0	0	0	0	1	1.09393	-16.79987	110	2	1.12	0.95;
	790	1	0	0	0	0	1	1.09388	-16.821	110	2	1.12	0.95;
	791	1	7.5	0.5	0	0	1	1.08923	-12.21266	110	2	1.12	0.95;
	792	1	9.8	1	0	0	1	1.09229	-17.01701	110	2	1.12	0.95;
	793	1	13	0.6	0	0	1	1.07715	-17.18424	110	2	1.12	0.95;
	794	1	4.3	0	0	0	1	1.08899	-15.39588	110	2	1.12	0.95;
	795	1	3.2	0.5	0	0	1	1.07581	-13.73415	110	2	1.12	0.95;
	796	1	8.7	1.7	0	0	1	1.09183	-13.23844	110	2	1.12	0.95;
	797	1	4.3	0.5	0	0	1	1.08036	-10.88734	110	2	1.12	0.95;
	798	2	6.1	17.1	0	0	1	1.1109	-11.45929	110	2	1.12	0.95;
	799	1	6.6	1.2	0	0	1	1.08858	-14.02584	110	2	1.12	0.95;
	800	1	35.5	8	0	0	1	1.08282	-20.05383	110	2	1.12	0.95;
	801	2	3.1	0.6	0	0	1	1.06674	-14.2473	110	2	1.12	0.95;
	802	1	0	0	0	0	1	1.06503	-14.0983	110	2	1.12	0.95;
	803	1	4.3	1	0	0	1	1.10481	-10.82544	110	2	1.12	0.95;
	804	1	7.1	2	0	0	1	1.10424	-15.58436	110	2	1.12	0.95;
	805	1	10.8	2.5	0	0	1	1.08951	-13.90161	110	2	1.12	0.95;
	806	1	7.3	2.4	0	0	1	1.10956	-10.56539	110	2	1.12	0.95;
	807	1	11.5	-1.9	0	0	1	1.06969	-14.25099	110	2	1.12	0.95;
	808	2	11.4	2.9	0	0	1	1.0959	-15.62584	110	2	1.12	0.95;
	809	2	19	2.8	0	0	1	1.09617	-15.6068	110	2	1.12	0.95;
	810	1	9.6	2.7	0	0	1	1.11051	-12.02683	110	2	1.12	0.95;
	811	1	29.2	15	0	0	1	1.09596	-13.92942	110	2	1.12	0.95;
	812	1	13.9	5.3	0	0	1	1.09479	-14.00416	110	2	1.12	0.95;
	813	1	17.2	7.6	0	0	1	1.11015	-12.04716	110	2	1.12	0.95;
	814	1	14.7	8.8	0	0	1	1.09021	-13.63196	110	2	1.12	0.95;
	815	1	0.2	0	0	0	1	1.08651	-13.65984	110	2	1.12	0.95;
	816	1	7.6	0.9	0	0	1	1.0424	-25.01515	110	2	1.12	0.95;
	817	1	5.9	1.3	0	0	1	1.08937	-12.79287	110	2	1.12	0.95;
	818	1	6.5	1	0	0	1	1.08964	-14.5539	110	2	1.12	0.95;
	819	1	11.7	0.1	0	0	1	1.09823	-14.54825	110	2	1.12	0.95;
	820	1	12.9	0	0	0	1	1.07784	-16.33322	110	2	1.12	0.95;
	821	1	4.8	0	0	0	1	1.08632	-11.42946	110	2	1.12	0.95;
	822	1	9.7	0.5	0	0	1	1.08709	-11.64296	110	2	1.12	0.95;
	823	1	2.5	0.4	0	0	1	1.07754	-13.86166	110	2	1.12	0.95;
	824	1	8.6	1	0	0	1	1.08375	-15.79928	110	2	1.12	0.95;
	825	1	3.4	1.1	0	0	1	1.04351	-24.67641	110	2	1.12	0.95;
	826	1	5.4	0.2	0	0	1	1.08238	-15.64842	110	2	1.12	0.95;
	827	1	5.6	0	0	0	1	1.09891	-15.09825	110	2	1.12	0.95;
	828	1	0.9	0	0	0	1	1.10458	-11.81748	110	2	1.12	0.95;
	829	1	4	1	0	0	1	1.07683	-17.27695	110	2	1.12	0.95;
	830	1	1.1	0	0	0	1	1.09156	-13.06292	110	2	1.12	0.95;
	831	1	13.8	2.2	0	0	1	1.10067	-11.4575	110	2	1.12	0.95;
	832	1	0	0	0	0	1	1.10183	-14.59337	110	2	1.12	0.95;
	833	1	6.7	0.1	0	0	1	1.07851	-19.31608	110	2	1.12	0.95;
	834	1	3.2	1	0	0	1	1.0912	-13.36329	110	2	1.12	0.95;
	835	1	9	2.4	0	0	1	1.09045	-16.14116	110	2	1.12	0.95;
	836	1	0.9	0	0	0	1	1.0923	-13.32086	110	2	1.12	0.95;
	837	1	37.7	4.5	0	0	1	1.08951	-13.30162	110	2	1.12	0.95;
	838	1	22.6	1.5	0	0	1	1.08979	-13.41051	110	2	1.12	0.95;
	839	1	16.1	1.5	0	0	1	1.08973	-13.58856	110	2	1.12	0.95;
	840	1	0.9	0	0	0	1	1.0923	-13.32103	110	2	1.12	0.95;
	841	1	1.1	0	0	0	1	1.08543	-11.3932	110	2	1.12	0.95;
	842	1	5.7	-2.3	0	0	1	1.10177	-12.42463	110	2	1.12	0.95;
	843	1	4.8	1.3	0	0	1	1.07938	-17.10972	110	2	1.12	0.95;
	844	1	6.6	2.3	0	0	1	1.10017	-14.96854	110	2	1.12	0.95;
	845	1	3.2	0.5	0	0	1	1.08877	-14.22432	110	2	1.12	0.95;
	846	2	13.1	30.1	0	0	1	1.10183	-14.59337	110	2	1.12	0.95;
	847	2	13.1	30.1	0	0	1	1.102	-14.62089	110	2	1.12	0.95;
	848	1	5.9	0.5	0	0	1	1.08969	-13.47244	110	2	1.12	0.95;
	849	1	37.7	1	0	0	1	1.09231	-13.318	110	2	1.12	0.95;
	850	1	6.6	1.4	0	0	1	1.07828	-13.80224	110	2	1.12	0.95;
	851	1	0	0	0	0	1	1.09052	-12.67461	110	2	1.12	0.95;
	852	1	0	0	0	0	1	1.09055	-12.68431	110	2	1.12	0.95;
	853	1	12.3	1.4	0	0	1	1.07855	-13.77479	110	2	1.12	0.95;
	854	2	19.3	2.3	0	0	1	1.07784	-13.83088	110	2	1.12	0.95;
	855	1	0	0	0	0	1	1.0779	-13.82702	110	2	1.12	0.95;
	856	1	6.5	1	0	0	1	1.07852	-13.77834	110	2	1.12	0.95;
	857	1	7.4	0.7	0	0	1	1.08614	-13.09577	110	2	1.12	0.95;
	858	1	10.8	1	0	0	1	1.06858	-14.53381	110	2	1.12	0.95;
	859	1	2.2	1	0	0	1	1.06839	-14.4771	110	2	1.12	0.95;
	860	2	25.8	8.4	0	0	1	1.09411	-16.20772	110	2	1.12	0.95;
	861	1	10.8	1.5	0	0	1	1.06834	-14.45097	110	2	1.12	0.95;
	862	1	7.5	0	0	0	1	1.07735	-10.03165	110	2	1.12	0.95;
	863	1	25.8	1	0	0	1	1.08907	-13.63652	110	2	1.12	0.95;
	864	1	17.2	2.5	0	0	1	1.09639	-15.09144	110	2	1.12	0.95;
	865	1	21.3	3.5	0	0	1	1.08383	-13.93855	110	2	1.12	0.95;
	866	1	11.6	2	0	0	1	1.07628	-16.82412	110	2	1.12	0.95;
	867	1	26.8	3.2	0	0	1	1.09067	-17.46048	110	2	1.12	0.95;
	868	1	11.9	0	0	0	1	1.09821	-16.38145	110	2	1.12	0.95;
	869	1	22	1.5	0	0	1	1.1072	-15.26975	110	2	1.12	0.95;
	870	2	13.6	31.3	0	0	1	1.11412	-14.37548	110	2	1.12	0.95;
	871	1	0	0	0	0	1	1.11404	-14.40079	110	2	1.12	0.95;
	872	1	14.1	0.9	0	0	1	1.10538	-11.73512	110	2	1.12	0.95;
	873	1	8.2	2	0	0	1	1.09623	-12.98538	110	2	1.12	0.95;
	874	1	6.6	1.7	0	0	1	1.10496	-11.74478	110	2	1.12	0.95;
	875	1	2	0.5	0	0	1	1.1064	-15.24064	110	2	1.12	0.95;
	876	2	17.2	9.2	0	0	1	1.10623	-15.23509	110	2	1.12	0.95;
	877	1	4.9	0.7	0	0	1	1.10633	-15.29812	110	2	1.12	0.95;
	878	1	14.2	1.2	0	0	1	1.10439	-15.60716	110	2	1.12	0.95;
	879	1	9.7	1	0	0	1	1.08885	-14.92301	110	2	1.12	0.95;
	880	1	10.9	1.6	0	0	1	1.04315	-25.31687	110	2	1.12	0.95;
	881	1	4.1	1	0	0	1	1.0838	-13.94087	110	2	1.12	0.95;
	882	1	0	0	0	0	1	1.1065	-15.38105	110	2	1.12	0.95;
	883	1	0	0	0	0	1	1.10638	-15.41206	110	2	1.12	0.95;
	884	1	4	0.6	0	0	1	1.06788	-20.12009	110	2	1.12	0.95;
	885	1	17.5	1.9	0	0	1	1.1034	-15.73574	110	2	1.12	0.95;
	886	1	19.6	2.2	0	0	1	1.10651	-15.05305	110	2	1.12	0.95;
	887	1	23.8	3	0	0	1	1.10332	-15.74096	110	2	1.12	0.95;
	888	1	4.6	0.3	0	0	1	1.10693	-15.24581	110	2	1.12	0.95;
	889	1	0.7	0.1	0	0	1	1.10699	-15.23829	110	2	1.12	0.95;
	890	2	21.9	2.2	0	0	1	1.10622	-15.08093	110	2	1.12	0.95;
	891	1	9.2	0.6	0	0	1	1.10787	-14.95944	110	2	1.12	0.95;
	892	1	13	2.4	0	0	1	1.10651	-15.24616	110	2	1.12	0.95;
	893	2	3.2	0	0	0	1	1.10378	-11.69615	110	2	1.12	0.95;
	894	1	2.2	1	0	0	1	1.104	-11.6763	110	2	1.12	0.95;
	895	1	3.5	0	0	0	1	1.08009	-18.36724	110	2	1.12	0.95;
	896	1	0	0	0	0	1	1.08434	-13.34005	110	2	1.12	0.95;
	897	1	15.1	2	0	0	1	1.0657	-7.94429	110	2	1.12	0.95;
	898	1	13.9	1	0	0	1	1.04738	-23.34194	110	2	1.12	0.95;
	899	1	2.7	0	0	0	1	1.07205	-16.45812	110	2	1.12	0.95;
	900	1	9.7	1.5	0	0	1	1.07919	-15.36246	110	2	1.12	0.95;
	901	1	0.5	0	0	0	1	1.08877	-18.85597	110	2	1.12	0.95;
	902	1	0	0	0	0	1	1.10803	-14.51558	110	2	1.12	0.95;
	903	1	0	0	0	0	1	1.10813	-14.50869	110	2	1.12	0.95;
	904	1	22.6	16.4	0	0	1	1.10255	-11.09043	110	2	1.12	0.95;
	905	1	23.7	6	0	0	1	1.08434	-13.34005	110	2	1.12	0.95;
	906	1	6.9	3.9	0	0	1	1.08436	-13.34133	110	2	1.12	0.95;
	907	1	6.8	0.2	0	0	1	1.10646	-10.81045	110	2	1.12	0.95;
	908	2	12.1	3	0	0	1	1.1056	-10.8482	110	2	1.12	0.95;
	909	1	9.7	1	0	0	1	1.09319	-12.28994	110	2	1.12	0.95;
	910	1	18.3	0.1	0	0	1	1.07642	-16.47725	110	2	1.12	0.95;
	911	1	4.5	0.6	0	0	1	1.08195	-16.97891	110	2	1.12	0.95;
	912	1	10.5	1.7	0	0	1	1.10078	-11.74641	110	2	1.12	0.95;
	913	2	21	1.5	0	0	1	1.06476	-14.2206	110	2	1.12	0.95;
	914	1	11.6	2.8	0	0	1	1.10779	-12.32686	110	2	1.12	0.95;
	915	1	0	0	0	0	1	1.09544	-12.17007	110	2	1.12	0.95;
	916	1	3.2	0	0	0	1	1.09599	-16.64183	110	2	1.12	0.95;
	917	1	6.5	1	0	0	1	1.08491	-14.76066	110	2	1.12	0.95;
	918	2	11.1	1	0	0	1	1.0887	-16.61409	110	2	1.12	0.95;
	919	1	0.1	0	0	0	1	1.1062	-11.96786	110	2	1.12	0.95;
	920	1	3.2	0.5	0	0	1	1.08106	-13.68379	110	2	1.12	0.95;
	921	1	8.3	1	0	0	1	1.09658	-13.16556	110	2	1.12	0.95;
	922	1	43	10	0	0	1	1.09331	-13.67158	110	2	1.12	0.95;
	923	1	0	0	0	0	1	1.0934	-13.63465	110	2	1.12	0.95;
	924	1	5.4	0	0	0	1	1.09306	-13.72077	110	2	1.12	0.95;
	925	1	1.6	0.3	0	0	1	1.10736	-11.34473	110	2	1.12	0.95;
	926	1	0	0	0	0	1	1.09819	-10.91278	110	2	1.12	0.95;
	927	1	43	30.1	0	0	1	1.09818	-10.91255	110	2	1.12	0.95;
	928	1	5.4	0	0	0	1	1.0931	-13.71203	110	2	1.12	0.95;
	929	2	16.1	2.5	0	0	1	1.08981	-14.09036	110	2	1.12	0.95;
	930	1	20.7	1.4	0	0	1	1.09101	-14.00656	110	2	1.12	0.95;
	931	1	10.2	0.3	0	0	1	1.08873	-14.20607	110	2	1.12	0.95;
	932	1	11.3	0.8	0	0	1	1.07618	-19.44565	110	2	1.12	0.95;
	933	1	4.3	0.5	0	0	1	1.08209	-14.74869	110	2	1.12	0.95;
	934	2	13.1	30.1	0	0	1	1.11929	-9.90687	110	2	1.12	0.95;
	935	1	0	0	0	0	1	1.11918	-9.91876	110	2	1.12	0.95;
	936	2	0.1	1	0	0	1	1.09004	-14.30742	110	2	1.12	0.95;
	937	1	5.4	0.5	0	0	1	1.08545	-11.36479	110	2	1.12	0.95;
	938	1	6.5	1	0	0	1	1.0928	-15.25475	110	2	1.12	0.95;
	939	2	5.4	0.5	0	0	1	1.09035	-15.23271	110	2	1.12	0.95;
	940	1	10.1	0	0	0	1	1.07811	-17.09548	110	2	1.12	0.95;
	941	1	13.8	0.4	0	0	1	1.07791	-17.16056	110	2	1.12	0.95;
	942	1	3.7	0.6	0	0	1	1.08918	-16.60236	110	2	1.12	0.95;
	943	1	6.9	0.7	0	0	1	1.08964	-16.56724	110	2	1.12	0.95;
	944	1	3.1	0	0	0	1	1.09822	-15.48177	110	2	1.12	0.95;
	945	1	6.7	2	0	0	1	1.06962	-16.63682	110	2	1.12	0.95;
	946	1	19.6	2.5	0	0	1	1.07657	-15.20667	110	2	1.12	0.95;
	947	1	8.6	1	0	0	1	1.08167	-14.20201	110	2	1.12	0.95;
	948	1	2.7	0.3	0	0	1	1.10494	-11.59828	110	2	1.12	0.95;
	949	1	9.4	1.8	0	0	1	1.06953	-16.652	110	2	1.12	0.95;
	950	1	17.2	1.8	0	0	1	1.07219	-16.43997	110	2	1.12	0.95;
	951	1	4.9	0	0	0	1	1.07223	-16.43714	110	2	1.12	0.95;
	952	1	12.5	0.6	0	0	1	1.06982	-16.61785	110	2	1.12	0.95;
	953	1	23.7	3	0	0	1	1.08677	-14.99196	110	2	1.12	0.95;
	954	1	16.1	3	0	0	1	1.09544	-12.17007	110	2	1.12	0.95;
	955	1	0	0	0	0	1	1.09547	-12.15664	110	2	1.12	0.95;
	956	1	16.2	1.4	0	0	1	1.07059	-20.53308	110	2	1.12	0.95;
	957	1	16.1	1	0	0	1	1.08623	-15.10688	110	2	1.12	0.95;
	958	1	2.7	0.5	0	0	1	1.07596	-13.71658	110	2	1.12	0.95;
	959	2	6	16.1	0	0	1	1.10245	-10.77594	110	2	1.12	0.95;
	960	1	13	2.5	0	0	1	1.09437	-16.62962	110	2	1.12	0.95;
	961	1	0	0	0	0	1	1.09435	-16.62598	110	2	1.12	0.95;
	962	1	18.3	3	0	0	1	1.07941	-15.9975	110	2	1.12	0.95;
	963	1	3.8	0.9	0	0	1	1.06475	-14.22175	110	2	1.12	0.95;
	964	1	20	2	0	0	1	1.09666	-12.21321	110	2	1.12	0.95;
	965	2	10.3	1.5	0	0	1	1.07379	-13.45928	110	2	1.12	0.95;
	966	1	4.3	1.5	0	0	1	1.09427	-14.3158	110	2	1.12	0.95;
	967	1	0	0	0	0	1	1.09432	-14.32161	110	2	1.12	0.95;
	968	1	17.2	2	0	0	1	1.08793	-14.96789	110	2	1.12	0.95;
	969	1	16.1	2	0	0	1	1.08925	-14.8016	110	2	1.12	0.95;
	970	1	18.3	1.5	0	0	1	1.0798	-15.93839	110	2	1.12	0.95;
	971	1	8.3	2	0	0	1	1.10216	-12.89979	110	2	1.12	0.95;
	972	1	14.6	1	0	0	1	1.08099	-16.77906	110	2	1.12	0.95;
	973	1	11.1	2.9	0	0	1	1.09357	-12.46827	110	2	1.12	0.95;
	974	1	12.6	2	0	0	1	1.09642	-12.38	110	2	1.12	0.95;
	975	1	7.9	0	0	0	1	1.09358	-12.74979	110	2	1.12	0.95;
	976	1	0	0	0	0	1	1.1019	-11.15085	110	2	1.12	0.95;
	977	1	0	0	0	0	1	1.10189	-11.15952	110	2	1.12	0.95;
	978	1	2.7	1	0	0	1	1.08798	-14.88076	110	2	1.12	0.95;
	979	1	22.4	5	0	0	1	1.10171	-10.86194	110	2	1.12	0.95;
	980	2	6.5	0.6	0	0	1	1.09713	-12.62408	110	2	1.12	0.95;
	981	1	7.9	0.3	0	0	1	1.09998	-13.10878	110	2	1.12	0.95;
	982	2	3.4	1	0	0	1	1.11083	-11.46397	110	2	1.12	0.95;
	983	1	1.1	0.5	0	0	1	1.08866	-12.00475	110	2	1.12	0.95;
	984	2	8.6	1.5	0	0	1	1.10468	-15.54538	110	2	1.12	0.95;
	985	1	8.6	1	0	0	1	1.08473	-14.6931	110	2	1.12	0.95;
	986	1	20.7	1.1	0	0	1	1.1045	-15.56237	110	2	1.12	0.95;
	987	1	8.6	1.5	0	0	1	1.08583	-10.55934	110	2	1.12	0.95;
	988	1	11.5	1.4	0	0	1	1.07751	-13.40043	110	2	1.12	0.95;
	989	2	3.7	1.2	0	0	1	1.09354	-13.11466	110	2	1.12	0.95;
	990	1	11.8	1.4	0	0	1	1.0921	-13.29235	110	2	1.12	0.95;
	991	1	5.9	0	0	0	1	1.09363	-14.07446	110	2	1.12	0.95;
	992	1	9.6	3.4	0	0	1	1.10098	-11.57647	110	2	1.12	0.95;
	993	2	0	1	0	0	1	1.10203	-12.62944	110	2	1.12	0.95;
	994	1	0	0	0	0	1	1.102	-12.6347	110	2	1.12	0.95;
	995	1	4.3	0.5	0	0	1	1.08154	-14.71797	110	2	1.12	0.95;
	996	1	6.5	1	0	0	1	1.07302	-14.66599	110	2	1.12	0.95;
	997	1	5.4	0.5	0	0	1	1.08262	-14.75155	110	2	1.12	0.95;
	998	1	18.7	3.4	0	0	1	1.09289	-12.62528	110	2	1.12	0.95;
	999	1	7.6	-0.4	0	0	1	1.11189	-10.46233	110	2	1.12	0.95;
	1000	1	32.3	6	0	0	1	1.08676	-14.53874	110	2	1.12	0.95;
	1001	1	0	0	0	0	1	1.0868	-14.5287	110	2	1.12	0.95;
	1002	1	0	0	0	0	1	1.08676	-14.53874	110	2	1.12	0.95;
	1003	1	0	0	0	0	1	1.09659	-16.56298	110	2	1.12	0.95;
	1004	1	0	0	0	0	1	1.08676	-14.53874	110	2	1.12	0.95;
	1005	1	7.9	1.4	0	0	1	1.09293	-13.18624	110	2	1.12	0.95;
	1006	1	3.2	0.5	0	0	1	1.09714	-11.28206	110	2	1.12	0.95;
	1007	1	16.1	2	0	0	1	1.08796	-14.47186	110	2	1.12	0.95;
	1008	2	15.3	28.6	0	0	1	1.11134	-11.95404	110	2	1.12	0.95;
	1009	2	33	28.6	0	0	1	1.09769	-13.83044	110	2	1.12	0.95;
	1010	1	13.6	2.5	0	0	1	1.08392	-13.53958	110	2	1.12	0.95;
	1011	1	3.8	0	0	0	1	1.08236	-14.46236	110	2	1.12	0.95;
	1012	1	18.9	2.5	0	0	1	1.10785	-12.14913	110	2	1.12	0.95;
	1013	1	7.5	1.4	0	0	1	1.10429	-12.64414	110	2	1.12	0.95;
	1014	1	9.8	1.7	0	0	1	1.10212	-14.59366	110	2	1.12	0.95;
	1015	1	6.9	1.3	0	0	1	1.09279	-14.37488	110	2	1.12	0.95;
	1016	1	16.1	-0.8	0	0	1	1.09583	-12.88493	110	2	1.12	0.95;
	1017	1	12.8	0.9	0	0	1	1.08408	-16.36984	110	2	1.12	0.95;
	1018	1	6.8	0.8	0	0	1	1.08723	-16.09131	110	2	1.12	0.95;
	1019	1	4.2	0.8	0	0	1	1.08968	-13.77235	110	2	1.12	0.95;
	1020	1	0	0	0	0	1	1.09544	-12.17007	110	2	1.12	0.95;
	1021	2	8.4	1.5	0	0	1	1.0998	-15.29616	110	2	1.12	0.95;
	1022	1	1.9	0.6	0	0	1	1.08354	-16.45219	110	2	1.12	0.95;
	1023	1	7	0.7	0	0	1	1.09849	-12.84174	110	2	1.12	0.95;
	1024	1	14	4	0	0	1	1.08959	-17.7339	110	2	1.12	0.95;
	1025	1	0	0	0	0	1	1.09427	-14.3158	110	2	1.12	0.95;
	1026	1	6.2	0.9	0	0	1	1.06298	-21.25044	110	2	1.12	0.95;
	1027	1	11.7	1.9	0	0	1	1.0466	-23.96625	110	2	1.12	0.95;
	1028	1	7.5	0.5	0	0	1	1.09212	-12.07656	110	2	1.12	0.95;
	1029	1	5.4	0	0	0	1	1.0711	-19.38866	110	2	1.12	0.95;
	1030	1	5.4	1	0	0	1	1.0871	-13.87869	110	2	1.12	0.95;
	1031	1	11.3	0.5	0	0	1	1.08745	-9.54005	110	2	1.12	0.95;
	1032	1	15.8	2.1	0	0	1	1.10719	-15.01103	110	2	1.12	0.95;
	1033	1	0	0	0	0	1	1.08334	-14.71438	110	2	1.12	0.95;
	1034	1	0	0	0	0	1	1.09125	-16.97725	110	2	1.12	0.95;
	1035	1	0	0	0	0	1	1.0912	-16.98033	110	2	1.12	0.95;
	1036	1	0	0	0	0	1	1.0954	-13.96478	110	2	1.12	0.95;
	1037	1	0	0	0	0	1	1.10018	-14.96826	110	2	1.12	0.95;
	1038	1	0	0	0	0	1	1.08121	-10.76301	110	2	1.12	0.95;
	1039	1	0	0	0	0	1	1.10443	-12.62981	110	2	1.12	0.95;
	1040	1	6.6	2.3	0	0	1	1.1012	-10.97464	110	2	1.12	0.95;
	1041	1	13	1.1	0	0	1	1.10574	-14.58494	110	2	1.12	0.95;
	1042	1	5.9	0	0	0	1	1.10573	-14.57159	110	2	1.12	0.95;
	1043	1	1.6	0.3	0	0	1	1.09439	-13.09076	110	2	1.12	0.95;
	1044	1	0	0	0	0	1	1.08676	-14.53874	110	2	1.12	0.95;
	1045	1	6	1.2	0	0	1	1.1027	-14.72717	110	2	1.12	0.95;
	1046	1	4.4	0.6	0	0	1	1.09319	-15.19978	110	2	1.12	0.95;
	1047	1	10.7	0	0	0	1	1.10623	-14.65504	110	2	1.12	0.95;
	1048	1	10.5	0.7	0	0	1	1.10562	-14.63695	110	2	1.12	0.95;
	1049	2	2.2	1	0	0	1	1.0812	-14.6633	110	2	1.12	0.95;
	1050	1	7.8	1.5	0	0	1	1.0848	-15.6113	110	2	1.12	0.95;
	1051	1	0	0	0	0	1	1.12	-1.42909	110	3	1.12	0.95;
	1052	1	0.6	-0.6	0	0	1	1.10315	-2.4018	110	3	1.12	0.95;
	1053	1	0	0	0	0	1	1.08426	-10.61383	110	3	1.12	0.95;
	1054	1	2.3	0.6	0	0	1	1.08925	-11.30014	110	3	1.12	0.95;
	1055	1	0	0	0	0	1	1.08426	-10.61382	110	3	1.12	0.95;
	1056	2	65.3	42.4	0	0	1	1.08399	-10.57859	110	3	1.12	0.95;
	1057	1	10.9	4.1	0	0	1	1.09275	-8.64783	110	3	1.12	0.95;
	1058	1	5.2	1.8	0	0	1	1.09265	-8.64702	110	3	1.12	0.95;
	1059	1	3.4	0.2	0	0	1	1.10914	-5.26288	110	3	1.12	0.95;
	1060	1	5.4	1.9	0	0	1	1.09733	-6.9317	110	3	1.12	0.95;
	1061	1	0	0	0	0	1	1.09739	-6.91516	110	3	1.12	0.95;
	1062	1	8.7	3	0	0	1	1.09151	-7.86438	110	3	1.12	0.95;
	1063	1	10.5	2.3	0	0	1	1.0915	-7.86156	110	3	1.12	0.95;
	1064	1	0	0	0	0	1	1.09151	-7.85464	110	3	1.12	0.95;
	1065	1	15	2.7	0	0	1	1.09899	-7.56162	110	3	1.12	0.95;
	1066	1	9.4	3	0	0	1	1.09887	-7.57394	110	3	1.12	0.95;
	1067	1	0	0	0	0	1	1.10609	-3.59474	110	3	1.12	0.95;
	1068	1	0	0	0	0	1	1.10601	-3.58742	110	3	1.12	0.95;
	1069	1	8.2	0.9	0	0	1	1.08861	-5.3608	110	3	1.12	0.95;
	1070	1	6.1	2.9	0	0	1	1.08855	-5.34116	110	3	1.12	0.95;
	1071	1	8.6	3.9	0	0	1	1.0979	-7.44986	110	3	1.12	0.95;
	1072	1	0	0	0	0	1	1.09798	-7.44986	110	3	1.12	0.95;
	1073	1	24.9	4.8	0	0	1	1.07003	-8.43908	110	3	1.12	0.95;
	1074	1	26.4	4.8	0	0	1	1.07002	-8.44023	110	3	1.12	0.95;
	1075	1	17.6	7.1	0	0	1	1.0925	-5.43531	110	3	1.12	0.95;
	1076	1	0	0	0	0	1	1.09683	-3.81775	110	3	1.12	0.95;
	1077	1	0	0	0	0	1	1.09259	-5.42991	110	3	1.12	0.95;
	1078	1	11.6	4.4	0	0	1	1.09179	-7.57836	110	3	1.12	0.95;
	1079	1	8.2	3	0	0	1	1.09168	-7.57959	110	3	1.12	0.95;
	1080	1	11.2	3	0	0	1	1.07726	-7.69832	110	3	1.12	0.95;
	1081	1	8.6	2.2	0	0	1	1.07723	-7.69606	110	3	1.12	0.95;
	1082	1	3.6	1.6	0	0	1	1.04915	-12.21999	110	3	1.12	0.95;
	1083	1	2.3	1.3	0	0	1	1.08735	-11.41451	110	3	1.12	0.95;
	1084	1	0	0	0	0	1	1.04918	-12.21902	110	3	1.12	0.95;
	1085	1	0	0	0	0	1	1.10419	-4.82864	110	3	1.12	0.95;
	1086	1	0	0	0	0	1	1.10397	-4.83868	110	3	1.12	0.95;
	1087	2	7.4	4.8	0	0	1	1.10464	-2.22851	110	3	1.12	0.95;
	1088	1	9.8	5.9	0	0	1	1.10453	-2.24594	110	3	1.12	0.95;
	1089	1	11.2	6.3	0	0	1	1.0443	-9.98458	110	3	1.12	0.95;
	1090	1	5.6	1.7	0	0	1	1.06257	-7.62077	110	3	1.12	0.95;
	1091	1	0	0	0	0	1	1.06382	-7.56035	110	3	1.12	0.95;
	1092	1	13.7	1.9	0	0	1	1.06978	-12.75641	110	3	1.12	0.95;
	1093	1	7.5	2.3	0	0	1	1.06962	-12.76831	110	3	1.12	0.95;
	1094	1	12.6	7.1	0	0	1	1.10213	-5.98756	110	3	1.12	0.95;
	1095	1	0	0	0	0	1	1.09893	-6.61777	110	3	1.12	0.95;
	1096	1	4.2	1.6	0	0	1	1.09502	-7.50345	110	3	1.12	0.95;
	1097	1	1.1	0.4	0	0	1	1.09524	-7.44153	110	3	1.12	0.95;
	1098	1	0	0	0	0	1	1.09509	-7.50045	110	3	1.12	0.95;
	1099	1	0	0	0	0	1	1.09526	-7.44073	110	3	1.12	0.95;
	1100	1	0	0	0	0	1	1.11781	-2.0519	110	3	1.12	0.95;
	1101	1	1.5	0.3	0	0	1	1.11785	-2.03243	110	3	1.12	0.95;
	1102	1	4.5	1.3	0	0	1	1.06334	-11.16039	110	3	1.12	0.95;
	1103	1	4.5	0.7	0	0	1	1.06334	-11.16225	110	3	1.12	0.95;
	1104	1	0	0	0	0	1	1.06467	-11.03992	110	3	1.12	0.95;
	1105	1	14	4.2	0	0	1	1.09535	-7.19791	110	3	1.12	0.95;
	1106	1	0	0	0	0	1	1.09536	-7.2049	110	3	1.12	0.95;
	1107	1	7.3	1.1	0	0	1	1.07991	-8.58397	110	3	1.12	0.95;
	1108	1	1.5	0.1	0	0	1	1.07992	-8.58104	110	3	1.12	0.95;
	1109	1	0	0	0	0	1	1.09751	-7.13619	110	3	1.12	0.95;
	1110	1	11.7	3.3	0	0	1	1.09648	-4.58662	110	3	1.12	0.95;
	1111	2	12.4	7.5	0	0	1	1.11109	-4.7545	110	3	1.12	0.95;
	1112	2	2	4	0	0	1	1.11258	-4.36141	110	3	1.12	0.95;
	1113	1	4.9	0.5	0	0	1	1.09768	-7.82206	110	3	1.12	0.95;
	1114	1	5.7	2.3	0	0	1	1.0976	-7.82556	110	3	1.12	0.95;
	1115	1	10.7	3.2	0	0	1	1.06711	-12.87252	110	3	1.12	0.95;
	1116	1	9.6	3	0	0	1	1.067	-12.8771	110	3	1.12	0.95;
	1117	1	0	0	0	0	1	1.05337	-8.88738	110	3	1.12	0.95;
	1118	1	22.5	1	0	0	1	1.05338	-8.88408	110	3	1.12	0.95;
	1119	1	12.5	4.3	0	0	1	1.11748	-1.95613	110	3	1.12	0.95;
	1120	1	7.4	2.7	0	0	1	1.1055	-2.43468	110	3	1.12	0.95;
	1121	1	0.4	0.1	0	0	1	1.10213	-5.99385	110	3	1.12	0.95;
	1122	1	0	0	0	0	1	1.09899	-6.61887	110	3	1.12	0.95;
	1123	1	12.3	2.9	0	0	1	1.08106	-5.36575	110	3	1.12	0.95;
	1124	1	0	0	0	0	1	1.09038	-3.88611	110	3	1.12	0.95;
	1125	1	15.2	6.9	0	0	1	1.09019	-3.89244	110	3	1.12	0.95;
	1126	1	15.8	6.9	0	0	1	1.08101	-5.36545	110	3	1.12	0.95;
	1127	1	7.8	1.7	0	0	1	1.06502	-8.50457	110	3	1.12	0.95;
	1128	1	12.2	2.9	0	0	1	1.06489	-8.51947	110	3	1.12	0.95;
	1129	1	5.9	2.8	0	0	1	1.09757	-7.43139	110	3	1.12	0.95;
	1130	1	0	0	0	0	1	1.09762	-7.43156	110	3	1.12	0.95;
	1131	1	21.9	12.4	0	0	1	1.08583	-4.85393	110	3	1.12	0.95;
	1132	1	3.5	2.9	0	0	1	1.09157	-4.0818	110	3	1.12	0.95;
	1133	1	6.1	2.3	0	0	1	1.10345	-5.27547	110	3	1.12	0.95;
	1134	1	0	0	0	0	1	1.10391	-5.21292	110	3	1.12	0.95;
	1135	1	0	0	0	0	1	1.10353	-5.27096	110	3	1.12	0.95;
	1136	1	0	0	0	0	1	1.1039	-5.21291	110	3	1.12	0.95;
	1137	1	0	0	0	0	1	1.0899	-5.28435	110	3	1.12	0.95;
	1138	1	4.6	0.7	0	0	1	1.08983	-5.30022	110	3	1.12	0.95;
	1139	1	13	4.8	0	0	1	1.08612	-7.86593	110	3	1.12	0.95;
	1140	1	0	0	0	0	1	1.08612	-7.86593	110	3	1.12	0.95;
	1141	1	0	0	0	0	1	1.08624	-7.85755	110	3	1.12	0.95;
	1142	1	12.9	5.5	0	0	1	1.09495	-4.39426	110	3	1.12	0.95;
	1143	1	3.6	1.7	0	0	1	1.11391	-2.51637	110	3	1.12	0.95;
	1144	1	14.3	3.6	0	0	1	1.03873	-12.15786	110	3	1.12	0.95;
	1145	1	10.9	2.8	0	0	1	1.03894	-12.15567	110	3	1.12	0.95;
	1146	1	6.9	5.5	0	0	1	1.08878	-7.42805	110	3	1.12	0.95;
	1147	1	9.5	2.1	0	0	1	1.08883	-7.43682	110	3	1.12	0.95;
	1148	1	9	3.1	0	0	1	1.09274	-8.34256	110	3	1.12	0.95;
	1149	1	11.4	4	0	0	1	1.09301	-8.34022	110	3	1.12	0.95;
	1150	1	5.1	1.7	0	0	1	1.10229	-5.31556	110	3	1.12	0.95;
	1151	1	0	0	0	0	1	1.10261	-5.29156	110	3	1.12	0.95;
	1152	1	8.8	2.8	0	0	1	1.07848	-7.80167	110	3	1.12	0.95;
	1153	1	7.3	3	0	0	1	1.07853	-7.7988	110	3	1.12	0.95;
	1154	1	10.1	3.3	0	0	1	1.10857	-2.90473	110	3	1.12	0.95;
	1155	1	0	0	0	0	1	1.10866	-2.88937	110	3	1.12	0.95;
	1156	1	14.4	6.8	0	0	1	1.10842	-4.07569	110	3	1.12	0.95;
	1157	1	6.8	1.4	0	0	1	1.10856	-4.07138	110	3	1.12	0.95;
	1158	1	0	0	0	0	1	1.10727	-4.04344	110	3	1.12	0.95;
	1159	1	7.1	2.7	0	0	1	1.08119	-5.35897	110	3	1.12	0.95;
	1160	1	5.7	2.9	0	0	1	1.09038	-3.88611	110	3	1.12	0.95;
	1161	1	1.2	1.1	0	0	1	1.09187	-6.75267	110	3	1.12	0.95;
	1162	1	4.2	4	0	0	1	1.09189	-6.74786	110	3	1.12	0.95;
	1163	1	7.9	2.3	0	0	1	1.09439	-7.95366	110	3	1.12	0.95;
	1164	1	0	0	0	0	1	1.09568	-7.84563	110	3	1.12	0.95;
	1165	1	6.1	2.5	0	0	1	1.10526	-4.23312	110	3	1.12	0.95;
	1166	1	2.9	1.3	0	0	1	1.10049	-4.94546	110	3	1.12	0.95;
	1167	1	22.4	8.9	0	0	1	1.10063	-4.94383	110	3	1.12	0.95;
	1168	1	10.4	0.7	0	0	1	1.06021	-8.74598	110	3	1.12	0.95;
	1169	1	5.5	0.5	0	0	1	1.06031	-8.70852	110	3	1.12	0.95;
	1170	1	0	0	0	0	1	1.09901	-7.5619	110	3	1.12	0.95;
	1171	1	0	0	0	0	1	1.09889	-7.57422	110	3	1.12	0.95;
	1172	1	7.6	3.2	0	0	1	1.07196	-12.85534	110	3	1.12	0.95;
	1173	1	0	0	0	0	1	1.07192	-12.86426	110	3	1.12	0.95;
	1174	1	13	2.4	0	0	1	1.0912	-5.42766	110	3	1.12	0.95;
	1175	1	0	0	0	0	1	1.09116	-5.43149	110	3	1.12	0.95;
	1176	1	0	0	0	0	1	1.09994	-4.19194	110	3	1.12	0.95;
	1177	1	0.7	0.2	0	0	1	1.09995	-4.18627	110	3	1.12	0.95;
	1178	1	0	0	0	0	1	1.09776	-5.86064	110	3	1.12	0.95;
	1179	1	6.6	0.6	0	0	1	1.09779	-5.85576	110	3	1.12	0.95;
	1180	1	6.1	2.6	0	0	1	1.10726	-4.04383	110	3	1.12	0.95;
	1181	1	1.9	1.3	0	0	1	1.11235	-3.6835	110	3	1.12	0.95;
	1182	1	9.8	2.1	0	0	1	1.09814	-6.45633	110	3	1.12	0.95;
	1183	1	6.4	0.6	0	0	1	1.09818	-6.44909	110	3	1.12	0.95;
	1184	1	6.4	0.9	0	0	1	1.10845	-4.71623	110	3	1.12	0.95;
	1185	1	7.6	0.9	0	0	1	1.10837	-4.72793	110	3	1.12	0.95;
	1186	1	10.3	4.2	0	0	1	1.09863	-2.75286	110	3	1.12	0.95;
	1187	1	6.6	2.8	0	0	1	1.09866	-2.74619	110	3	1.12	0.95;
	1188	2	34.8	23.4	0	0	1	1.1174	-2.09733	110	3	1.12	0.95;
	1189	2	11.1	18.1	0	0	1	1.11671	-2.28486	110	3	1.12	0.95;
	1190	1	8	3.3	0	0	1	1.10575	-5.62622	110	3	1.12	0.95;
	1191	1	8.4	3.5	0	0	1	1.10564	-5.64706	110	3	1.12	0.95;
	1192	1	14.1	7	0	0	1	1.10322	-3.40116	110	3	1.12	0.95;
	1193	2	0	0	0	0	1	1.10337	-3.38789	110	3	1.12	0.95;
	1194	1	9.4	3.8	0	0	1	1.09454	-3.20623	110	3	1.12	0.95;
	1195	1	6.3	2.6	0	0	1	1.0945	-3.22158	110	3	1.12	0.95;
	1196	1	1.4	0.8	0	0	1	1.05575	-8.38493	110	3	1.12	0.95;
	1197	1	0	0	0	0	1	1.05575	-8.38487	110	3	1.12	0.95;
	1198	1	7.1	0.5	0	0	1	1.09817	-7.10241	110	3	1.12	0.95;
	1199	1	0	0	0	0	1	1.09813	-7.09216	110	3	1.12	0.95;
	1200	1	6.8	2.2	0	0	1	1.09463	-7.17166	110	3	1.12	0.95;
	1201	1	4	1.3	0	0	1	1.09467	-7.17526	110	3	1.12	0.95;
	1202	1	10.7	5.8	0	0	1	1.10434	-7.0102	110	3	1.12	0.95;
	1203	1	5.7	1.8	0	0	1	1.10426	-6.99076	110	3	1.12	0.95;
	1204	1	7.2	3.2	0	0	1	1.11931	-1.53567	110	3	1.12	0.95;
	1205	1	0	0	0	0	1	1.1195	-1.5236	110	3	1.12	0.95;
	1206	1	13.9	2.3	0	0	1	1.07769	-7.5456	110	3	1.12	0.95;
	1207	1	16.8	3.9	0	0	1	1.07765	-7.55803	110	3	1.12	0.95;
	1208	1	12.1	4.2	0	0	1	1.09799	-4.02044	110	3	1.12	0.95;
	1209	1	11.8	4.7	0	0	1	1.11568	-2.17406	110	3	1.12	0.95;
	1210	1	18.9	4	0	0	1	1.07883	-7.41231	110	3	1.12	0.95;
	1211	1	17.2	3.1	0	0	1	1.0676	-7.76006	110	3	1.12	0.95;
	1212	1	4.7	2.3	0	0	1	1.10596	-2.0811	110	3	1.12	0.95;
	1213	1	3.3	1.3	0	0	1	1.10599	-2.07529	110	3	1.12	0.95;
	1214	2	24.3	66.1	0	0	1	1.12	-1.68476	110	3	1.12	0.95;
	1215	2	25.4	66.1	0	0	1	1.12	-1.09516	110	3	1.12	0.95;
	1216	1	5	0.7	0	0	1	1.09091	-5.31364	110	3	1.12	0.95;
	1217	1	4.3	-0.2	0	0	1	1.09095	-5.30186	110	3	1.12	0.95;
	1218	1	9.7	2.2	0	0	1	1.10509	-3.83476	110	3	1.12	0.95;
	1219	2	0.9	0.1	0	0	1	1.10515	-3.83844	110	3	1.12	0.95;
	1220	2	11.1	18.1	0	0	1	1.12	-1.54618	110	3	1.12	0.95;
	1221	1	0	0	0	0	1	1.11989	-1.56774	110	3	1.12	0.95;
	1222	1	12.1	3.8	0	0	1	1.05133	-9.87583	110	3	1.12	0.95;
	1223	1	8.3	2.7	0	0	1	1.05124	-9.89427	110	3	1.12	0.95;
	1224	1	9.2	4.6	0	0	1	1.06905	-11.83426	110	3	1.12	0.95;
	1225	1	0	0	0	0	1	1.06933	-11.8225	110	3	1.12	0.95;
	1226	2	0	0	0	0	1	1.09958	-6.49639	110	3	1.12	0.95;
	1227	2	34.2	0.2	0	0	1	1.0997	-6.61351	110	3	1.12	0.95;
	1228	2	0	0	0	0	1	1.09704	-6.61952	110	3	1.12	0.95;
	1229	1	3.5	1.1	0	0	1	1.0981	-6.43817	110	3	1.12	0.95;
	1230	1	0	0	0	0	1	1.09811	-6.43784	110	3	1.12	0.95;
	1231	1	4.1	1.4	0	0	1	1.09502	-7.35742	110	3	1.12	0.95;
	1232	1	4.9	1.6	0	0	1	1.09505	-7.36282	110	3	1.12	0.95;
	1233	1	5	1.9	0	0	1	1.06559	-13.73734	110	3	1.12	0.95;
	1234	1	0	0	0	0	1	1.06564	-13.73405	110	3	1.12	0.95;
	1235	1	0	0.2	0	0	1	1.10423	-2.28695	110	3	1.12	0.95;
	1236	1	0	0	0	0	1	1.10423	-2.28703	110	3	1.12	0.95;
	1237	2	0	1.5	0	0	1	1.0991	-8.51149	110	3	1.12	0.95;
	1238	2	22.1	9	0	0	1	1.09909	-8.50416	110	3	1.12	0.95;
	1239	2	7.9	3	0	0	1	1.09898	-8.50722	110	3	1.12	0.95;
	1240	1	0	0	0	0	1	1.09446	-8.14213	110	3	1.12	0.95;
	1241	1	3	0.8	0	0	1	1.09652	-5.75169	110	3	1.12	0.95;
	1242	1	0	0	0	0	1	1.09654	-5.74967	110	3	1.12	0.95;
	1243	1	0	0	0	0	1	1.11989	-1.56774	110	3	1.12	0.95;
	1244	1	0	0	0	0	1	1.12	-1.54618	110	3	1.12	0.95;
	1245	1	0	0	0	0	1	1.09533	-7.48945	110	3	1.12	0.95;
	1246	1	0	0	0	0	1	1.09533	-7.48945	110	3	1.12	0.95;
	1247	1	0	0	0	0	1	1.11758	-1.94984	110	3	1.12	0.95;
	1248	1	2.7	0.4	0	0	1	1.11233	-5.02916	110	3	1.12	0.95;
	1249	1	0	0	0	0	1	1.11222	-5.04385	110	3	1.12	0.95;
	1250	1	0.2	0.1	0	0	1	1.10756	-3.27068	110	3	1.12	0.95;
	1251	1	0	0	0	0	1	1.10757	-3.27065	110	3	1.12	0.95;
	1252	1	3.9	1.3	0	0	1	1.10473	-2.49522	110	3	1.12	0.95;
	1253	1	0	0	0	0	1	1.10475	-2.49346	110	3	1.12	0.95;
	1254	1	0	0	0	0	1	1.10672	-3.20558	110	3	1.12	0.95;
	1255	1	3.5	1.7	0	0	1	1.10671	-3.20725	110	3	1.12	0.95;
	1256	1	0	0	0	0	1	1.10756	-3.27064	110	3	1.12	0.95;
	1257	1	0	0	0	0	1	1.10757	-3.27065	110	3	1.12	0.95;
	1258	1	23	7.8	0	0	1	1.09343	-4.50514	110	3	1.12	0.95;
	1259	1	0	0	0	0	1	1.11392	-2.51648	110	3	1.12	0.95;
	1260	1	13.3	4.3	0	0	1	1.09575	-8.31842	110	3	1.12	0.95;
	1261	1	12.6	4.2	0	0	1	1.0961	-8.30661	110	3	1.12	0.95;
	1262	1	12.7	5.2	0	0	1	1.10351	-6.02669	110	3	1.12	0.95;
	1263	1	11.1	3.6	0	0	1	1.10361	-6.02196	110	3	1.12	0.95;
	1264	1	0.9	0.4	0	0	1	1.09762	-7.25384	110	3	1.12	0.95;
	1265	1	0	0	0	0	1	1.0976	-7.24544	110	3	1.12	0.95;
	1266	1	6.3	1.5	0	0	1	1.10833	-3.86565	110	3	1.12	0.95;
	1267	1	0	0	0	0	1	1.10836	-3.98013	110	3	1.12	0.95;
	1268	1	6.4	4.2	0	0	1	1.10275	-6.21996	110	3	1.12	0.95;
	1269	1	0	0	0	0	1	1.10299	-6.21626	110	3	1.12	0.95;
	1270	1	8.8	0	0	0	1	1.07367	-6.49297	110	3	1.12	0.95;
	1271	1	0	0	0	0	1	1.0736	-6.51028	110	3	1.12	0.95;
	1272	1	7	3.9	0	0	1	1.10324	-5.24393	110	3	1.12	0.95;
	1273	1	3.2	0	0	0	1	1.10402	-5.21401	110	3	1.12	0.95;
	1274	1	0	0	0	0	1	1.10222	-2.68143	110	3	1.12	0.95;
	1275	1	13.7	4	0	0	1	1.10213	-2.69226	110	3	1.12	0.95;
	1276	1	4.9	1.4	0	0	1	1.06589	-13.4956	110	3	1.12	0.95;
	1277	1	5.4	1.8	0	0	1	1.06587	-13.57775	110	3	1.12	0.95;
	1278	1	0	0	0	0	1	1.0659	-13.58496	110	3	1.12	0.95;
	1279	1	9.9	5.4	0	0	1	1.07394	-6.58487	110	3	1.12	0.95;
	1280	1	0	0	0	0	1	1.07394	-6.5799	110	3	1.12	0.95;
	1281	1	1.3	0.5	0	0	1	1.10646	-6.32066	110	3	1.12	0.95;
	1282	1	5	1.9	0	0	1	1.10644	-6.29549	110	3	1.12	0.95;
	1283	1	0.9	0.4	0	0	1	1.1065	-6.31794	110	3	1.12	0.95;
	1284	1	17.8	6.4	0	0	1	1.10025	-4.49369	110	3	1.12	0.95;
	1285	1	6.5	2.1	0	0	1	1.10036	-4.48349	110	3	1.12	0.95;
	1286	1	6.9	2.9	0	0	1	1.10315	-2.64612	110	3	1.12	0.95;
	1287	1	6.9	2.8	0	0	1	1.10308	-2.64131	110	3	1.12	0.95;
	1288	1	9.8	2.1	0	0	1	1.07324	-7.93763	110	3	1.12	0.95;
	1289	1	11.7	3	0	0	1	1.07323	-7.94324	110	3	1.12	0.95;
	1290	1	5.6	1.6	0	0	1	1.11212	-2.74825	110	3	1.12	0.95;
	1291	1	9	3.6	0	0	1	1.11215	-2.71922	110	3	1.12	0.95;
	1292	1	0	0	0	0	1	1.06629	-12.87472	110	3	1.12	0.95;
	1293	1	0	0	0	0	1	1.06637	-12.86806	110	3	1.12	0.95;
	1294	1	7.6	5.7	0	0	1	1.0828	-5.47702	110	3	1.12	0.95;
	1295	1	2.6	0.1	0	0	1	1.08279	-5.48049	110	3	1.12	0.95;
	1296	1	0	0	0	0	1	1.08287	-5.46416	110	3	1.12	0.95;
	1297	1	9.4	3.1	0	0	1	1.09749	-7.4531	110	3	1.12	0.95;
	1298	1	9.4	3	0	0	1	1.09755	-7.45721	110	3	1.12	0.95;
	1299	1	0	0	0	0	1	1.09753	-7.45088	110	3	1.12	0.95;
	1300	1	0	0	0	0	1	1.0977	-7.4467	110	3	1.12	0.95;
	1301	1	7.5	1	0	0	1	1.10899	-3.39414	110	3	1.12	0.95;
	1302	1	5.7	2.4	0	0	1	1.10899	-3.41467	110	3	1.12	0.95;
	1303	1	5.4	1.7	0	0	1	1.08679	-10.94136	110	3	1.12	0.95;
	1304	1	4.3	1.1	0	0	1	1.08683	-10.95157	110	3	1.12	0.95;
	1305	1	2.2	0.7	0	0	1	1.10793	-4.25634	110	3	1.12	0.95;
	1306	1	1.6	0.6	0	0	1	1.10797	-4.23985	110	3	1.12	0.95;
	1307	1	7	0.2	0	0	1	1.10836	-3.98013	110	3	1.12	0.95;
	1308	1	7	0.8	0	0	1	1.10837	-3.85895	110	3	1.12	0.95;
	1309	1	5.7	2.6	0	0	1	1.09141	-10.62799	110	3	1.12	0.95;
	1310	1	0	0	0	0	1	1.09166	-10.62187	110	3	1.12	0.95;
	1311	1	9.7	3.3	0	0	1	1.06282	-13.3709	110	3	1.12	0.95;
	1312	1	2.7	1	0	0	1	1.06286	-13.37232	110	3	1.12	0.95;
	1313	1	2.5	0.8	0	0	1	1.10085	-3.64501	110	3	1.12	0.95;
	1314	1	0	0	0	0	1	1.10393	-3.3713	110	3	1.12	0.95;
	1315	1	0	0	0	0	1	1.10093	-3.64049	110	3	1.12	0.95;
	1316	1	0	0	0	0	1	1.10393	-3.37128	110	3	1.12	0.95;
	1317	1	0	0	0	0	1	1.09864	-7.70372	110	3	1.12	0.95;
	1318	1	5.3	1.9	0	0	1	1.09868	-7.70682	110	3	1.12	0.95;
	1319	1	0	0	0	0	1	1.11248	-3.68879	110	3	1.12	0.95;
	1320	1	9.1	3.1	0	0	1	1.1004	-5.43315	110	3	1.12	0.95;
	1321	1	0	0	0	0	1	1.11248	-3.68873	110	3	1.12	0.95;
	1322	1	0	0	0	0	1	1.10077	-5.40719	110	3	1.12	0.95;
	1323	1	1.1	0.7	0	0	1	1.10254	-4.24285	110	3	1.12	0.95;
	1324	1	0.7	0.3	0	0	1	1.10257	-4.23935	110	3	1.12	0.95;
	1325	1	1.6	0.3	0	0	1	1.10053	-2.57564	110	3	1.12	0.95;
	1326	1	0	0	0	0	1	1.10053	-2.57503	110	3	1.12	0.95;
	1327	1	0	0	0	0	1	1.10053	-2.57497	110	3	1.12	0.95;
	1328	1	7.6	0.2	0	0	1	1.05815	-8.20281	110	3	1.12	0.95;
	1329	1	6.8	-0.8	0	0	1	1.08395	-6.60852	110	3	1.12	0.95;
	1330	2	4.3	5.7	0	0	1	1.11278	-2.90319	110	3	1.12	0.95;
	1331	2	5.8	7.9	0	0	1	1.10411	-5.19946	110	3	1.12	0.95;
	1332	1	0	0	0	0	1	1.11271	-3.66742	110	3	1.12	0.95;
	1333	1	0.7	2.8	0	0	1	1.11373	-2.79755	110	3	1.12	0.95;
	1334	1	7.3	3.1	0	0	1	1.11369	-2.81832	110	3	1.12	0.95;
	1335	1	13	1.3	0	0	1	1.05977	-8.18445	110	3	1.12	0.95;
	1336	1	5.2	2.2	0	0	1	1.05994	-8.16608	110	3	1.12	0.95;
	1337	1	22.2	12.4	0	0	1	1.03434	-11.80415	110	3	1.12	0.95;
	1338	1	0.7	0	0	0	1	1.0346	-11.7733	110	3	1.12	0.95;
	1339	1	3.2	1	0	0	1	1.09858	-7.7027	110	3	1.12	0.95;
	1340	1	0	0	0	0	1	1.09873	-7.70939	110	3	1.12	0.95;
	1341	1	0	0	0	0	1	1.09864	-7.70013	110	3	1.12	0.95;
	1342	1	0	0	0	0	1	1.09873	-7.70938	110	3	1.12	0.95;
	1343	1	16.4	7.8	0	0	1	1.0975	-7.82797	110	3	1.12	0.95;
	1344	1	0	0	0	0	1	1.09907	-7.72957	110	3	1.12	0.95;
	1345	1	0	0	0	0	1	1.09777	-7.81331	110	3	1.12	0.95;
	1346	1	0	0	0	0	1	1.09907	-7.72957	110	3	1.12	0.95;
	1347	1	24.3	7	0	0	1	1.09832	-7.19891	110	3	1.12	0.95;
	1348	1	9.4	3.6	0	0	1	1.09741	-7.82854	110	3	1.12	0.95;
	1349	1	17.7	9.9	0	0	1	1.09772	-7.75293	110	3	1.12	0.95;
	1350	1	0	0	0	0	1	1.0978	-7.75147	110	3	1.12	0.95;
	1351	1	3.3	0.4	0	0	1	1.08733	-7.87624	110	3	1.12	0.95;
	1352	1	7	3.5	0	0	1	1.0873	-7.88783	110	3	1.12	0.95;
	1353	1	3.5	2	0	0	1	1.09029	-4.68533	110	3	1.12	0.95;
	1354	2	109.5	51.2	0	0	1	1.08588	-7.87464	110	3	1.12	0.95;
	1355	1	3.9	1.3	0	0	1	1.11728	-2.1052	110	3	1.12	0.95;
	1356	1	26.1	11.1	0	0	1	1.11416	-2.63966	110	3	1.12	0.95;
	1357	1	63.3	22.6	0	0	1	1.11799	-3.78777	110	3	1.12	0.95;
	1358	1	0	0	0	0	1	1.1194	-3.65332	110	3	1.12	0.95;
	1359	1	0	0	0	0	1	1.11439	-2.62586	110	3	1.12	0.95;
	1360	1	0	0	0	0	1	1.11912	-3.70848	110	3	1.12	0.95;
	1361	1	0	0	0	0	1	1.11456	-2.61133	110	3	1.12	0.95;
	1362	1	10.5	4.6	0	0	1	1.09135	-6.82308	110	3	1.12	0.95;
	1363	1	0	0	0	0	1	1.09138	-6.82344	110	3	1.12	0.95;
	1364	1	0	0	0	0	1	1.09134	-6.84145	110	3	1.12	0.95;
	1365	1	1.6	0.6	0	0	1	1.09474	-7.18523	110	3	1.12	0.95;
	1366	1	0.6	0.3	0	0	1	1.09272	-7.67613	110	3	1.12	0.95;
	1367	1	6.3	0.9	0	0	1	1.10131	-4.24115	110	3	1.12	0.95;
	1368	1	6.2	-0.9	0	0	1	1.10129	-4.24437	110	3	1.12	0.95;
	1369	1	3	1.1	0	0	1	1.11141	-2.82405	110	3	1.12	0.95;
	1370	1	2.9	0.7	0	0	1	1.11142	-2.81853	110	3	1.12	0.95;
	1371	2	19.4	6.9	0	0	1	1.08095	-7.59462	110	3	1.12	0.95;
	1372	2	18.6	9.8	0	0	1	1.08082	-7.58653	110	3	1.12	0.95;
	1373	2	16.8	3.8	0	0	1	1.08158	-7.59916	110	3	1.12	0.95;
	1374	1	11.2	2.6	0	0	1	1.08015	-7.63047	110	3	1.12	0.95;
	1375	1	22.4	6.5	0	0	1	1.0802	-7.63592	110	3	1.12	0.95;
	1376	1	10.3	4.6	0	0	1	1.0822	-7.58694	110	3	1.12	0.95;
	1377	1	12	4.1	0	0	1	1.08036	-7.50315	110	3	1.12	0.95;
	1378	1	10.6	0.5	0	0	1	1.08142	-7.6426	110	3	1.12	0.95;
	1379	1	10.7	0.8	0	0	1	1.08106	-7.63397	110	3	1.12	0.95;
	1380	1	2.7	2.3	0	0	1	1.08146	-7.63445	110	3	1.12	0.95;
	1381	1	44.2	16.1	0	0	1	1.07996	-7.53326	110	3	1.12	0.95;
	1382	1	44.2	16.1	0	0	1	1.08177	-7.62249	110	3	1.12	0.95;
	1383	1	0	0	0	0	1	1.08078	-7.47579	110	3	1.12	0.95;
	1384	1	7.8	3.8	0	0	1	1.08242	-7.57534	110	3	1.12	0.95;
	1385	1	11.5	3	0	0	1	1.08171	-7.62159	110	3	1.12	0.95;
	1386	1	11.5	2.4	0	0	1	1.08177	-7.61628	110	3	1.12	0.95;
	1387	1	0.9	0	0	0	1	1.08106	-7.66098	110	3	1.12	0.95;
	1388	1	0.8	0	0	0	1	1.08196	-7.60855	110	3	1.12	0.95;
	1389	1	0	0	0	0	1	1.08106	-7.6608	110	3	1.12	0.95;
	1390	1	0	0	0	0	1	1.08196	-7.60832	110	3	1.12	0.95;
	1391	1	3.2	0.6	0	0	1	1.10437	-3.4511	110	3	1.12	0.95;
	1392	1	1.5	0.2	0	0	1	1.10461	-3.42766	110	3	1.12	0.95;
	1393	1	1.5	0.5	0	0	1	1.09716	-4.93364	110	3	1.12	0.95;
	1394	1	0	0	0	0	1	1.09716	-4.93335	110	3	1.12	0.95;
	1395	1	0	0	0	0	1	1.1042	-5.46618	110	3	1.12	0.95;
	1396	1	0	0	0	0	1	1.1042	-5.46616	110	3	1.12	0.95;
	1397	1	0	0	0	0	1	1.09723	-4.92443	110	3	1.12	0.95;
	1398	1	12.4	4.4	0	0	1	1.10626	-5.69133	110	3	1.12	0.95;
	1399	1	7.3	0.1	0	0	1	1.10993	-4.87312	110	3	1.12	0.95;
	1400	2	9.5	9.9	0	0	1	1.1055	-2.17233	110	3	1.12	0.95;
	1401	2	8.6	9.2	0	0	1	1.11067	-4.62721	110	3	1.12	0.95;
	1402	1	4.1	1.9	0	0	1	1.04627	-10.81491	110	3	1.12	0.95;
	1403	1	3.3	1.2	0	0	1	1.04621	-10.81359	110	3	1.12	0.95;
	1404	1	0.4	0.2	0	0	1	1.09861	-2.78474	110	3	1.12	0.95;
	1405	1	0	0	0	0	1	1.09861	-2.78473	110	3	1.12	0.95;
	1406	1	21.7	14.9	0	0	1	1.0956	-3.83732	110	3	1.12	0.95;
	1407	1	9.4	1.1	0	0	1	1.09549	-3.8508	110	3	1.12	0.95;
	1408	2	53	29.5	0	0	1	1.10045	-2.41251	110	3	1.12	0.95;
	1409	1	36.9	34.8	0	0	1	1.10477	-2.70015	110	3	1.12	0.95;
	1410	1	9.2	2.8	0	0	1	1.10122	-2.75864	110	3	1.12	0.95;
	1411	1	2.5	1.3	0	0	1	1.11736	-1.96158	110	3	1.12	0.95;
	1412	1	0	0	0	0	1	1.10124	-2.75504	110	3	1.12	0.95;
	1413	1	2.9	1.3	0	0	1	1.07279	-6.73753	110	3	1.12	0.95;
	1414	1	0	0	0	0	1	1.073	-6.72485	110	3	1.12	0.95;
	1415	1	17	5.8	0	0	1	1.0887	-4.26923	110	3	1.12	0.95;
	1416	1	0	0	0	0	1	1.0888	-4.25926	110	3	1.12	0.95;
	1417	1	0	0	0	0	1	1.08472	-4.72424	110	3	1.12	0.95;
	1418	1	7	2.7	0	0	1	1.08753	-5.46274	110	3	1.12	0.95;
	1419	1	2.3	0.6	0	0	1	1.08894	-5.53992	110	3	1.12	0.95;
	1420	1	0	0	0	0	1	1.08764	-5.45663	110	3	1.12	0.95;
	1421	1	0	0	0	0	1	1.08897	-5.53779	110	3	1.12	0.95;
	1422	1	0.6	0.1	0	0	1	1.1035	-6.04053	110	3	1.12	0.95;
	1423	1	0.6	0.2	0	0	1	1.10354	-6.03038	110	3	1.12	0.95;
	1424	1	1.2	3	0	0	1	1.11993	-1.5466	110	3	1.12	0.95;
	1425	1	3.7	1.3	0	0	1	1.09254	-8.64131	110	3	1.12	0.95;
	1426	1	1.6	0.6	0	0	1	1.09256	-8.65248	110	3	1.12	0.95;
	1427	1	15.2	4.8	0	0	1	1.09635	-6.95293	110	3	1.12	0.95;
	1428	1	9.6	4.2	0	0	1	1.09633	-6.96335	110	3	1.12	0.95;
	1429	1	1.2	0	0	0	1	1.09987	-6.25688	110	3	1.12	0.95;
	1430	1	0.4	0	0	0	1	1.09991	-6.24668	110	3	1.12	0.95;
	1431	1	8.2	3.6	0	0	1	1.10128	-6.14065	110	3	1.12	0.95;
	1432	1	8.2	3.6	0	0	1	1.10124	-6.15537	110	3	1.12	0.95;
	1433	1	1.8	0.6	0	0	1	1.0878	-7.71483	110	3	1.12	0.95;
	1434	1	3	-0.2	0	0	1	1.08778	-7.71659	110	3	1.12	0.95;
	1435	1	9.2	4.8	0	0	1	1.04051	-10.32874	110	3	1.12	0.95;
	1436	1	4.3	2.3	0	0	1	1.04049	-10.32209	110	3	1.12	0.95;
	1437	1	0.8	0.4	0	0	1	1.10274	-6.29983	110	3	1.12	0.95;
	1438	1	0	0	0	0	1	1.10274	-6.29973	110	3	1.12	0.95;
	1439	1	4.9	2.4	0	0	1	1.10501	-2.37909	110	3	1.12	0.95;
	1440	1	5	2.4	0	0	1	1.09859	-2.81615	110	3	1.12	0.95;
	1441	1	1.1	-0.2	0	0	1	1.09765	-7.42883	110	3	1.12	0.95;
	1442	1	4.2	0.9	0	0	1	1.09764	-7.44179	110	3	1.12	0.95;
	1443	1	4.2	2.4	0	0	1	1.09742	-7.38885	110	3	1.12	0.95;
	1444	1	11.5	4.9	0	0	1	1.09802	-7.32192	110	3	1.12	0.95;
	1445	1	6.7	2.9	0	0	1	1.07092	-8.40356	110	3	1.12	0.95;
	1446	1	5.4	3	0	0	1	1.07093	-8.4103	110	3	1.12	0.95;
	1447	1	5.7	1.1	0	0	1	1.05401	-11.24844	110	3	1.12	0.95;
	1448	1	11.4	2.7	0	0	1	1.05317	-11.31498	110	3	1.12	0.95;
	1449	1	0	0	0	0	1	1.05452	-11.22732	110	3	1.12	0.95;
	1450	1	0	0	0	0	1	1.05388	-11.28605	110	3	1.12	0.95;
	1451	1	8.3	3	0	0	1	1.11298	-2.60171	110	3	1.12	0.95;
	1452	1	0	0	0	0	1	1.11298	-2.60947	110	3	1.12	0.95;
	1453	1	0	0	0	0	1	1.11758	-1.94982	110	3	1.12	0.95;
	1454	1	0	0	0	0	1	1.10556	-2.43062	110	3	1.12	0.95;
	1455	1	10.5	3	0	0	1	1.09562	-7.84646	110	3	1.12	0.95;
	1456	1	6.8	0.8	0	0	1	1.09567	-7.8457	110	3	1.12	0.95;
	1457	1	3.7	1.6	0	0	1	1.1048	-2.49774	110	3	1.12	0.95;
	1458	1	3.3	1.5	0	0	1	1.10475	-2.48603	110	3	1.12	0.95;
	1459	1	5.8	1.9	0	0	1	1.09724	-7.21664	110	3	1.12	0.95;
	1460	1	0	0	0	0	1	1.09725	-7.21624	110	3	1.12	0.95;
	1461	1	5	1.3	0	0	1	1.09507	-6.78459	110	3	1.12	0.95;
	1462	1	4.1	1.3	0	0	1	1.09504	-6.80049	110	3	1.12	0.95;
	1463	1	7.6	2.4	0	0	1	1.06721	-7.69315	110	3	1.12	0.95;
	1464	1	5.9	1.7	0	0	1	1.06718	-7.66912	110	3	1.12	0.95;
	1465	1	8.2	1.8	0	0	1	1.09767	-7.57924	110	3	1.12	0.95;
	1466	1	0	0	0	0	1	1.09758	-7.57888	110	3	1.12	0.95;
	1467	1	5.6	0	0	0	1	1.06978	-13.15291	110	3	1.12	0.95;
	1468	1	9.7	2.8	0	0	1	1.06972	-13.16478	110	3	1.12	0.95;
	1469	2	0	0	0	0	1	1.10925	-4.74751	110	3	1.12	0.95;
	1470	2	90.5	33.9	0	0	1	1.10921	-4.76698	110	3	1.12	0.95;
	1471	2	28.5	7.4	0	0	1	1.09262	-7.86649	110	3	1.12	0.95;
	1472	1	19.3	7.4	0	0	1	1.09271	-7.87549	110	3	1.12	0.95;
	1473	1	1.4	0.2	0	0	1	1.10385	-5.24433	110	3	1.12	0.95;
	1474	1	7.2	2.1	0	0	1	1.11248	-2.89421	110	3	1.12	0.95;
	1475	1	0	0	0	0	1	1.10387	-5.24351	110	3	1.12	0.95;
	1476	1	0	0	0	0	1	1.11255	-2.89053	110	3	1.12	0.95;
	1477	1	0	0	0	0	1	1.08819	-10.46503	110	3	1.12	0.95;
	1478	1	0	0	0	0	1	1.09036	-11.23221	110	3	1.12	0.95;
	1479	1	3.4	1	0	0	1	1.08046	-5.13618	110	3	1.12	0.95;
	1480	1	3.4	1	0	0	1	1.08047	-5.13483	110	3	1.12	0.95;
	1481	1	8.8	3.4	0	0	1	1.10754	-3.26879	110	3	1.12	0.95;
	1482	1	0	0	0	0	1	1.10757	-3.26542	110	3	1.12	0.95;
	1483	1	0.7	0.2	0	0	1	1.10498	-2.37811	110	3	1.12	0.95;
	1484	1	0	0	0	0	1	1.10502	-2.37572	110	3	1.12	0.95;
	1485	1	0	0	0	0	1	1.09299	-7.40792	110	3	1.12	0.95;
	1486	1	0	0	0	0	1	1.09303	-7.39739	110	3	1.12	0.95;
	1487	1	0	0	0	0	1	1.09306	-7.57453	110	3	1.12	0.95;
	1488	1	9.9	2.7	0	0	1	1.09298	-7.57053	110	3	1.12	0.95;
	1489	1	1.9	0.9	0	0	1	1.09505	-7.51218	110	3	1.12	0.95;
	1490	1	0	0	0	0	1	1.09508	-7.50844	110	3	1.12	0.95;
	1491	1	5.2	1.9	0	0	1	1.07632	-6.66239	110	3	1.12	0.95;
	1492	1	6.2	2.1	0	0	1	1.07637	-6.67807	110	3	1.12	0.95;
	1493	1	6.3	2.2	0	0	1	1.09964	-5.47575	110	3	1.12	0.95;
	1494	1	2.1	0.7	0	0	1	1.11246	-3.68975	110	3	1.12	0.95;
	1495	1	10.4	5.2	0	0	1	1.1007	-5.41124	110	3	1.12	0.95;
	1496	1	0	0	0	0	1	1.10015	-5.45276	110	3	1.12	0.95;
	1497	1	10.8	4.6	0	0	1	1.09378	-8.18179	110	3	1.12	0.95;
	1498	1	0	0	0	0	1	1.09448	-8.13828	110	3	1.12	0.95;
	1499	1	5.7	0.8	0	0	1	1.06997	-7.86171	110	3	1.12	0.95;
	1500	1	7.3	1.3	0	0	1	1.07016	-7.85639	110	3	1.12	0.95;
	1501	1	11.7	3.9	0	0	1	1.10843	-2.9808	110	3	1.12	0.95;
	1502	1	0	0	0	0	1	1.10869	-2.94488	110	3	1.12	0.95;
	1503	1	7.6	2.3	0	0	1	1.08951	-9.16477	110	3	1.12	0.95;
	1504	1	2.6	0.8	0	0	1	1.08949	-9.15883	110	3	1.12	0.95;
	1505	2	12.5	1.9	0	0	1	1.10604	-3.59977	110	3	1.12	0.95;
	1506	1	0	0	0	0	1	1.10601	-3.58742	110	3	1.12	0.95;
	1507	1	14.7	4.6	0	0	1	1.08939	-6.9752	110	3	1.12	0.95;
	1508	1	0	0	0	0	1	1.08942	-6.98717	110	3	1.12	0.95;
	1509	1	2.3	0.9	0	0	1	1.07479	-6.47419	110	3	1.12	0.95;
	1510	1	6.3	2.4	0	0	1	1.09445	-8.14205	110	3	1.12	0.95;
	1511	2	12.6	8.9	0	0	1	1.10715	-7.97881	110	3	1.12	0.95;
	1512	2	10	44.2	0	0	1	1.12	-5.21392	110	3	1.12	0.95;
	1513	2	10	44.2	0	0	1	1.11542	-2.54973	110	3	1.12	0.95;
	1514	1	11.5	3.5	0	0	1	1.07668	-7.86292	110	3	1.12	0.95;
	1515	1	9.4	3.1	0	0	1	1.07668	-7.86446	110	3	1.12	0.95;
	1516	1	0	0	0	0	1	1.0642	-7.65651	110	3	1.12	0.95;
	1517	1	5.9	2.1	0	0	1	1.06421	-7.64596	110	3	1.12	0.95;
	1518	1	1.3	0.3	0	0	1	1.09631	-8.00596	110	3	1.12	0.95;
	1519	1	1.5	0.6	0	0	1	1.0963	-8.02103	110	3	1.12	0.95;
	1520	1	4.8	2.4	0	0	1	1.10692	-3.21078	110	3	1.12	0.95;
	1521	1	7.8	5	0	0	1	1.10696	-3.20816	110	3	1.12	0.95;
	1522	1	6.1	0.2	0	0	1	1.09598	-4.82143	110	3	1.12	0.95;
	1523	1	11.8	2.2	0	0	1	1.096	-4.81931	110	3	1.12	0.95;
	1524	1	2	4.4	0	0	1	1.09606	-4.90673	110	3	1.12	0.95;
	1525	1	8.8	3.5	0	0	1	1.09615	-4.91016	110	3	1.12	0.95;
	1526	1	3.3	1.2	0	0	1	1.09166	-7.90266	110	3	1.12	0.95;
	1527	1	1.6	0.7	0	0	1	1.09164	-7.90543	110	3	1.12	0.95;
	1528	1	9.6	3.7	0	0	1	1.07738	-11.29996	110	3	1.12	0.95;
	1529	1	0	0	0	0	1	1.07736	-11.30807	110	3	1.12	0.95;
	1530	1	6.4	2.1	0	0	1	1.06205	-13.48067	110	3	1.12	0.95;
	1531	1	6.6	1.7	0	0	1	1.06204	-13.47801	110	3	1.12	0.95;
	1532	1	7.4	3.1	0	0	1	1.08492	-5.49918	110	3	1.12	0.95;
	1533	1	4.9	1.7	0	0	1	1.08495	-5.5158	110	3	1.12	0.95;
	1534	1	0	0	0	0	1	1.09542	-7.3797	110	3	1.12	0.95;
	1535	1	0	0	0	0	1	1.09541	-7.37962	110	3	1.12	0.95;
	1536	1	2	0.6	0	0	1	1.08089	-8.47296	110	3	1.12	0.95;
	1537	1	1.8	0.4	0	0	1	1.08088	-8.47723	110	3	1.12	0.95;
	1538	1	0	0.1	0	0	1	1.09643	-7.45571	110	3	1.12	0.95;
	1539	1	5.4	1.8	0	0	1	1.09639	-7.47466	110	3	1.12	0.95;
	1540	1	0	0	0	0	1	1.10515	-2.17761	110	3	1.12	0.95;
	1541	1	0	0	0	0	1	1.10517	-2.17355	110	3	1.12	0.95;
	1542	1	9.8	3.9	0	0	1	1.1044	-4.84995	110	3	1.12	0.95;
	1543	1	0	0	0	0	1	1.10443	-4.84837	110	3	1.12	0.95;
	1544	1	0	0	0	0	1	1.11144	-3.57281	110	3	1.12	0.95;
	1545	1	8	3.1	0	0	1	1.09384	-4.65297	110	3	1.12	0.95;
	1546	1	0	0	0	0	1	1.11144	-3.5727	110	3	1.12	0.95;
	1547	1	0	0	0	0	1	1.0944	-4.62644	110	3	1.12	0.95;
	1548	1	6.1	1.9	0	0	1	1.1042	-3.11979	110	3	1.12	0.95;
	1549	1	4.3	1.5	0	0	1	1.10425	-3.13004	110	3	1.12	0.95;
	1550	1	8.9	3.1	0	0	1	1.11128	-3.78677	110	3	1.12	0.95;
	1551	1	0	0	0	0	1	1.11156	-3.76695	110	3	1.12	0.95;
	1552	1	0	0	0	0	1	1.10577	-5.03096	110	3	1.12	0.95;
	1553	1	1.9	0.6	0	0	1	1.1075	-4.80588	110	3	1.12	0.95;
	1554	1	0	0	0	0	1	1.10577	-5.03095	110	3	1.12	0.95;
	1555	1	0	0	0	0	1	1.10751	-4.80498	110	3	1.12	0.95;
	1556	1	7.6	1.8	0	0	1	1.0673	-7.68422	110	3	1.12	0.95;
	1557	1	8.3	2.2	0	0	1	1.06724	-7.66205	110	3	1.12	0.95;
	1558	1	0	0	0	0	1	1.07907	-6.14317	110	3	1.12	0.95;
	1559	1	8.3	2.3	0	0	1	1.07906	-6.1382	110	3	1.12	0.95;
	1560	1	4.9	1.6	0	0	1	1.0788	-6.39215	110	3	1.12	0.95;
	1561	1	3.5	0.5	0	0	1	1.07885	-6.37933	110	3	1.12	0.95;
	1562	1	3.5	1.3	0	0	1	1.10609	-4.6141	110	3	1.12	0.95;
	1563	1	6.4	2.4	0	0	1	1.10612	-4.61752	110	3	1.12	0.95;
	1564	1	10.7	1.2	0	0	1	1.03393	-11.65648	110	3	1.12	0.95;
	1565	1	8.7	-2	0	0	1	1.03399	-11.66562	110	3	1.12	0.95;
	1566	1	6	2.8	0	0	1	1.10669	-3.20214	110	3	1.12	0.95;
	1567	1	6.1	2.1	0	0	1	1.09483	-4.39968	110	3	1.12	0.95;
	1568	1	6.7	2.5	0	0	1	1.11378	-2.52201	110	3	1.12	0.95;
	1569	1	0	0	0	0	1	1.09427	-4.65233	110	3	1.12	0.95;
	1570	2	39.7	14.1	0	0	1	1.09424	-4.65386	110	3	1.12	0.95;
	1571	1	9.7	-0.3	0	0	1	1.10597	-5.30324	110	3	1.12	0.95;
	1572	1	6.4	1.4	0	0	1	1.09331	-4.82165	110	3	1.12	0.95;
	1573	1	0	0	0	0	1	1.10602	-5.29866	110	3	1.12	0.95;
	1574	1	10.9	4.7	0	0	1	1.09197	-6.77809	110	3	1.12	0.95;
	1575	1	3.2	1.2	0	0	1	1.09849	-5.16582	110	3	1.12	0.95;
	1576	1	6.2	1.7	0	0	1	1.07876	-12.24692	110	3	1.12	0.95;
	1577	1	0	0	0	0	1	1.07873	-12.26656	110	3	1.12	0.95;
	1578	2	12.6	16.4	0	0	1	1.10817	-5.7603	110	3	1.12	0.95;
	1579	2	12.6	16.2	0	0	1	1.10283	-2.38307	110	3	1.12	0.95;
	1580	2	7	14.1	0	0	1	1.11987	-1.42721	110	3	1.12	0.95;
	1581	1	5.5	1.4	0	0	1	1.0576	-10.88064	110	3	1.12	0.95;
	1582	1	5.6	1.4	0	0	1	1.05752	-10.87776	110	3	1.12	0.95;
	1583	1	8	2.8	0	0	1	1.11752	-5.34237	110	3	1.12	0.95;
	1584	1	9.7	4.1	0	0	1	1.11237	-2.79587	110	3	1.12	0.95;
	1585	1	0	0	0	0	1	1.11789	-5.32613	110	3	1.12	0.95;
	1586	1	0	0	0	0	1	1.11284	-2.77731	110	3	1.12	0.95;
	1587	1	12.3	4.4	0	0	1	1.06756	-13.30433	110	3	1.12	0.95;
	1588	1	18.1	6.6	0	0	1	1.06756	-13.31619	110	3	1.12	0.95;
	1589	1	8.8	6.8	0	0	1	1.11494	-2.58116	110	3	1.12	0.95;
	1590	2	20.3	49.4	0	0	1	1.12	-3.64911	110	3	1.12	0.95;
	1591	1	9.6	0.2	0	0	1	1.08278	-8.27242	110	3	1.12	0.95;
	1592	1	9.1	1.1	0	0	1	1.08276	-8.26715	110	3	1.12	0.95;
	1593	1	1.3	0.5	0	0	1	1.10116	-2.62164	110	3	1.12	0.95;
	1594	1	2.1	0.9	0	0	1	1.1011	-2.64889	110	3	1.12	0.95;
	1595	1	36.5	16.6	0	0	1	1.10571	-3.21302	110	3	1.12	0.95;
	1596	1	11.4	4.8	0	0	1	1.10579	-3.20408	110	3	1.12	0.95;
	1597	1	4.1	1.1	0	0	1	1.10227	-6.03052	110	3	1.12	0.95;
	1598	1	7	2.5	0	0	1	1.09682	-6.80666	110	3	1.12	0.95;
	1599	1	0	0	0	0	1	1.10255	-6.01555	110	3	1.12	0.95;
	1600	1	0	0	0	0	1	1.09736	-6.78253	110	3	1.12	0.95;
	1601	2	11.2	16.4	0	0	1	1.07976	-7.27662	110	3	1.12	0.95;
	1602	2	12.4	18.1	0	0	1	1.07966	-7.2597	110	3	1.12	0.95;
	1603	2	12.1	26.1	0	0	1	1.06726	-7.27713	110	3	1.12	0.95;
	1604	1	5.8	2	0	0	1	1.10816	-3.15448	110	3	1.12	0.95;
	1605	1	5.8	2	0	0	1	1.10826	-3.14686	110	3	1.12	0.95;
	1606	1	6.7	2.7	0	0	1	1.1056	-3.66351	110	3	1.12	0.95;
	1607	1	3.9	1.4	0	0	1	1.10558	-3.67586	110	3	1.12	0.95;
	1608	1	19.1	8.7	0	0	1	1.09756	-4.1797	110	3	1.12	0.95;
	1609	1	0	0	0	0	1	1.09748	-4.19016	110	3	1.12	0.95;
	1610	1	15.7	5.3	0	0	1	1.11469	-2.37112	110	3	1.12	0.95;
	1611	1	0	0	0	0	1	1.11465	-2.38212	110	3	1.12	0.95;
	1612	1	1.3	0.6	0	0	1	1.09767	-6.52007	110	3	1.12	0.95;
	1613	1	0	0.1	0	0	1	1.09768	-6.51662	110	3	1.12	0.95;
	1614	1	17.9	3.1	0	0	1	1.07357	-8.02537	110	3	1.12	0.95;
	1615	1	18.9	3.2	0	0	1	1.06528	-7.77157	110	3	1.12	0.95;
	1616	1	0	0	0	0	1	1.0994	-7.43823	110	3	1.12	0.95;
	1617	1	0	0	0	0	1	1.09954	-7.41616	110	3	1.12	0.95;
	1618	1	8.6	3.8	0	0	1	1.08597	-5.02524	110	3	1.12	0.95;
	1619	1	3.5	1.6	0	0	1	1.0859	-5.03572	110	3	1.12	0.95;
	1620	1	14.5	6.1	0	0	1	1.05125	-11.5749	110	3	1.12	0.95;
	1621	1	11.7	3.6	0	0	1	1.05136	-11.58728	110	3	1.12	0.95;
	1622	1	8.1	1.2	0	0	1	1.08119	-7.62445	110	3	1.12	0.95;
	1623	1	13.4	2.8	0	0	1	1.08153	-7.6321	110	3	1.12	0.95;
	1624	1	4.7	2.1	0	0	1	1.0962	-7.3841	110	3	1.12	0.95;
	1625	1	0	0	0	0	1	1.0964	-7.3737	110	3	1.12	0.95;
	1626	1	18.6	7.5	0	0	1	1.10335	-2.42344	110	3	1.12	0.95;
	1627	1	18.5	7.6	0	0	1	1.10332	-2.41728	110	3	1.12	0.95;
	1628	1	4.9	1	0	0	1	1.10066	-4.35116	110	3	1.12	0.95;
	1629	1	3	-0.1	0	0	1	1.10376	-3.71935	110	3	1.12	0.95;
	1630	1	0	0	0	0	1	1.10072	-4.34722	110	3	1.12	0.95;
	1631	1	0	0	0	0	1	1.10603	-2.09889	110	3	1.12	0.95;
	1632	1	0	0	0	0	1	1.10604	-2.09517	110	3	1.12	0.95;
	1633	1	5.5	2	0	0	1	1.09268	-7.43812	110	3	1.12	0.95;
	1634	1	3.4	1.2	0	0	1	1.0901	-7.53302	110	3	1.12	0.95;
	1635	1	0	0	0	0	1	1.09286	-7.43007	110	3	1.12	0.95;
	1636	1	0	0	0	0	1	1.09022	-7.52797	110	3	1.12	0.95;
	1637	1	4.9	1.9	0	0	1	1.09522	-7.62797	110	3	1.12	0.95;
	1638	1	0	0.1	0	0	1	1.09522	-7.64299	110	3	1.12	0.95;
	1639	1	16.6	6.7	0	0	1	1.09999	-8.23788	110	3	1.12	0.95;
	1640	1	8.1	2.9	0	0	1	1.10045	-8.21506	110	3	1.12	0.95;
	1641	1	0	0	0	0	1	1.0948	-7.18332	110	3	1.12	0.95;
	1642	1	0	0	0	0	1	1.09275	-7.67547	110	3	1.12	0.95;
	1643	1	0	0	0	0	1	1.09517	-7.49674	110	3	1.12	0.95;
	1644	2	4	4	0	0	1	1.09788	-7.22715	110	3	1.12	0.95;
	1645	1	8.1	0.8	0	0	1	1.09602	-7.54789	110	3	1.12	0.95;
	1646	1	4	0.2	0	0	1	1.09603	-7.54758	110	3	1.12	0.95;
	1647	1	12.1	6.6	0	0	1	1.09544	-7.51008	110	3	1.12	0.95;
	1648	1	0	0	0	0	1	1.09543	-7.50904	110	3	1.12	0.95;
	1649	1	4.9	2.2	0	0	1	1.11967	-1.53561	110	3	1.12	0.95;
	1650	1	2.2	1	0	0	1	1.11969	-1.53704	110	3	1.12	0.95;
	1651	1	0.2	0	0	0	1	1.10465	-2.63759	110	3	1.12	0.95;
	1652	1	0.5	0.2	0	0	1	1.10458	-2.62747	110	3	1.12	0.95;
	1653	1	8.4	2.2	0	0	1	1.09538	-8.62316	110	3	1.12	0.95;
	1654	1	11.4	3.6	0	0	1	1.09554	-8.61654	110	3	1.12	0.95;
	1655	1	5.7	0.3	0	0	1	1.05546	-8.41237	110	3	1.12	0.95;
	1656	1	5.9	2.1	0	0	1	1.05541	-8.40219	110	3	1.12	0.95;
	1657	1	1.6	0.7	0	0	1	1.10644	-2.04498	110	3	1.12	0.95;
	1658	1	0	0	0	0	1	1.10644	-2.04492	110	3	1.12	0.95;
	1659	2	20.6	8.7	0	0	1	1.09025	-6.12606	110	3	1.12	0.95;
	1660	2	7.2	2.3	0	0	1	1.08791	-4.3126	110	3	1.12	0.95;
	1661	2	10	8	0	0	1	1.09573	-3.92091	110	3	1.12	0.95;
	1662	2	15.1	8	0	0	1	1.09678	-3.75762	110	3	1.12	0.95;
	1663	1	0	0	0	0	1	1.09586	-3.92958	110	3	1.12	0.95;
	1664	1	13.1	4.8	0	0	1	1.05895	-9.5063	110	3	1.12	0.95;
	1665	1	18.1	6.4	0	0	1	1.05893	-9.53213	110	3	1.12	0.95;
	1666	2	29.8	42.9	0	0	1	1.10681	-1.98294	110	3	1.12	0.95;
	1667	1	8	4.2	0	0	1	1.10672	-2.01289	110	3	1.12	0.95;
	1668	1	0	0	0	0	1	1.11062	-5.17499	110	3	1.12	0.95;
	1669	1	0	0	0	0	1	1.11061	-5.17495	110	3	1.12	0.95;
	1670	1	8	2.8	0	0	1	1.10867	-5.80366	110	3	1.12	0.95;
	1671	1	6.9	2.7	0	0	1	1.10716	-6.13879	110	3	1.12	0.95;
	1672	1	0	0	0	0	1	1.10925	-5.76227	110	3	1.12	0.95;
	1673	1	0	0	0	0	1	1.10771	-6.10225	110	3	1.12	0.95;
	1674	1	3.4	0.5	0	0	1	1.06265	-13.48698	110	3	1.12	0.95;
	1675	1	3.3	1.1	0	0	1	1.06262	-13.48829	110	3	1.12	0.95;
	1676	1	0	0.1	0	0	1	1.09707	-7.47304	110	3	1.12	0.95;
	1677	1	0	0	0	0	1	1.09706	-7.47022	110	3	1.12	0.95;
	1678	1	8.2	1.4	0	0	1	1.09056	-7.38833	110	3	1.12	0.95;
	1679	1	4.4	1.5	0	0	1	1.09046	-7.38428	110	3	1.12	0.95;
	1680	1	9.5	2.6	0	0	1	1.08574	-4.83174	110	3	1.12	0.95;
	1681	1	6.2	1.6	0	0	1	1.08574	-4.84645	110	3	1.12	0.95;
	1682	1	8.9	1.9	0	0	1	1.06296	-13.25492	110	3	1.12	0.95;
	1683	1	9.1	1.9	0	0	1	1.06294	-13.26038	110	3	1.12	0.95;
	1684	1	13.9	1.2	0	0	1	1.10511	-2.23831	110	3	1.12	0.95;
	1685	1	8.8	0.9	0	0	1	1.10511	-2.24562	110	3	1.12	0.95;
	1686	1	8.4	2.3	0	0	1	1.08876	-10.58001	110	3	1.12	0.95;
	1687	1	0	0	0	0	1	1.08873	-10.57651	110	3	1.12	0.95;
	1688	2	2.3	4.3	0	0	1	1.08003	-10.99721	110	3	1.12	0.95;
	1689	2	3.2	1	0	0	1	1.07997	-11.01038	110	3	1.12	0.95;
	1690	1	8.6	2.4	0	0	1	1.04089	-10.50708	110	3	1.12	0.95;
	1691	1	11.5	4.6	0	0	1	1.04087	-10.48954	110	3	1.12	0.95;
	1692	1	0	0	0	0	1	1.1063	-2.10007	110	3	1.12	0.95;
	1693	1	0	0	0	0	1	1.1063	-2.10007	110	3	1.12	0.95;
	1694	1	3.2	1.1	0	0	1	1.10677	-3.21649	110	3	1.12	0.95;
	1695	1	2.6	1.2	0	0	1	1.11234	-2.76189	110	3	1.12	0.95;
	1696	1	0	0	0	0	1	1.10678	-3.21587	110	3	1.12	0.95;
	1697	1	0	0	0	0	1	1.11235	-2.76143	110	3	1.12	0.95;
	1698	1	7.6	2.7	0	0	1	1.10131	-2.91442	110	3	1.12	0.95;
	1699	1	11.8	5.6	0	0	1	1.10125	-2.94632	110	3	1.12	0.95;
	1700	1	10.3	3.2	0	0	1	1.08756	-11.38285	110	3	1.12	0.95;
	1701	1	7.3	2.1	0	0	1	1.08754	-11.38562	110	3	1.12	0.95;
	1702	1	4	1.1	0	0	1	1.10323	-3.4656	110	3	1.12	0.95;
	1703	1	5	1.4	0	0	1	1.10336	-3.44038	110	3	1.12	0.95;
	1704	1	0	0	0	0	1	1.10513	-3.75874	110	3	1.12	0.95;
	1705	1	9.4	4	0	0	1	1.10513	-3.76963	110	3	1.12	0.95;
	1706	1	1.3	0.6	0	0	1	1.09924	-7.44891	110	3	1.12	0.95;
	1707	1	1.6	0.7	0	0	1	1.09935	-7.42921	110	3	1.12	0.95;
	1708	1	8.7	3	0	0	1	1.10697	-6.08358	110	3	1.12	0.95;
	1709	1	0	0.2	0	0	1	1.10701	-6.10789	110	3	1.12	0.95;
	1710	1	5.7	0.6	0	0	1	1.08	-6.27239	110	3	1.12	0.95;
	1711	1	3	0.9	0	0	1	1.08003	-6.26445	110	3	1.12	0.95;
	1712	1	4.9	2.2	0	0	1	1.07483	-6.47119	110	3	1.12	0.95;
	1713	1	4	1.5	0	0	1	1.08141	-5.0616	110	3	1.12	0.95;
	1714	1	10.4	3.9	0	0	1	1.09218	-11.46915	110	3	1.12	0.95;
	1715	1	0	0	0	0	1	1.09214	-11.46818	110	3	1.12	0.95;
	1716	1	7.3	3.5	0	0	1	1.1121	-3.96213	110	3	1.12	0.95;
	1717	1	8.6	3.4	0	0	1	1.11192	-3.97216	110	3	1.12	0.95;
	1718	1	5	1.1	0	0	1	1.05639	-8.35487	110	3	1.12	0.95;
	1719	1	6.4	0.2	0	0	1	1.0564	-8.35218	110	3	1.12	0.95;
	1720	1	10.7	4.3	0	0	1	1.10564	-2.13432	110	3	1.12	0.95;
	1721	1	13.5	5.3	0	0	1	1.10566	-2.11911	110	3	1.12	0.95;
	1722	1	18.9	6.4	0	0	1	1.07202	-7.9573	110	3	1.12	0.95;
	1723	1	15	7.3	0	0	1	1.07202	-7.9453	110	3	1.12	0.95;
	1724	1	2.9	2.4	0	0	1	1.09112	-10.62187	110	3	1.12	0.95;
	1725	1	0	0	0	0	1	1.0912	-10.621	110	3	1.12	0.95;
	1726	1	6	1.9	0	0	1	1.10072	-4.34722	110	3	1.12	0.95;
	1727	1	4.3	1	0	0	1	1.10379	-3.71662	110	3	1.12	0.95;
	1728	1	4.7	2.6	0	0	1	1.08264	-6.24161	110	3	1.12	0.95;
	1729	1	2.9	1.1	0	0	1	1.08261	-6.21429	110	3	1.12	0.95;
	1730	1	3.3	2.8	0	0	1	1.07421	-6.47789	110	3	1.12	0.95;
	1731	1	7.8	4.2	0	0	1	1.08331	-4.82686	110	3	1.12	0.95;
	1732	1	0	0	0	0	1	1.08409	-4.78863	110	3	1.12	0.95;
	1733	1	6.7	2.3	0	0	1	1.10599	-3.60163	110	3	1.12	0.95;
	1734	1	3.3	1	0	0	1	1.10596	-3.59087	110	3	1.12	0.95;
	1735	1	3.3	0.2	0	0	1	1.0878	-7.50388	110	3	1.12	0.95;
	1736	1	4.9	0.4	0	0	1	1.08788	-7.50316	110	3	1.12	0.95;
	1737	1	2	0.8	0	0	1	1.11501	-2.58283	110	3	1.12	0.95;
	1738	1	0.6	0.4	0	0	1	1.10546	-6.30627	110	3	1.12	0.95;
	1739	1	13.2	5.4	0	0	1	1.10495	-3.33508	110	3	1.12	0.95;
	1740	1	7.4	2.7	0	0	1	1.10479	-3.34456	110	3	1.12	0.95;
	1741	1	10.9	0.2	0	0	1	1.10326	-3.95321	110	3	1.12	0.95;
	1742	1	8	1.3	0	0	1	1.10326	-3.94147	110	3	1.12	0.95;
	1743	1	3.4	0.3	0	0	1	1.05504	-8.69822	110	3	1.12	0.95;
	1744	1	7.1	0.4	0	0	1	1.05504	-8.69678	110	3	1.12	0.95;
	1745	1	8.8	4.6	0	0	1	1.1039	-2.21781	110	3	1.12	0.95;
	1746	1	7.3	3.1	0	0	1	1.10386	-2.22482	110	3	1.12	0.95;
	1747	1	0	0	0	0	1	1.07384	-6.95623	110	3	1.12	0.95;
	1748	1	0	0	0	0	1	1.0739	-6.95503	110	3	1.12	0.95;
	1749	1	0	0	0	0	1	1.11338	-2.52479	110	3	1.12	0.95;
	1750	1	20.6	12.1	0	0	1	1.11339	-2.51818	110	3	1.12	0.95;
	1751	1	3	1.4	0	0	1	1.06162	-13.47821	110	3	1.12	0.95;
	1752	1	1.2	0.3	0	0	1	1.06162	-13.47866	110	3	1.12	0.95;
	1753	1	1.4	0.2	0	0	1	1.10397	-2.29286	110	3	1.12	0.95;
	1754	1	0	0	0	0	1	1.104	-2.29073	110	3	1.12	0.95;
	1755	1	9.4	2.3	0	0	1	1.0968	-4.78142	110	3	1.12	0.95;
	1756	1	0	0	0	0	1	1.10223	-4.32528	110	3	1.12	0.95;
	1757	1	0	0	0	0	1	1.0972	-4.75984	110	3	1.12	0.95;
	1758	1	0	0	0	0	1	1.10223	-4.32523	110	3	1.12	0.95;
	1759	1	15.7	5.1	0	0	1	1.0605	-8.76556	110	3	1.12	0.95;
	1760	1	10.7	3.1	0	0	1	1.06045	-8.76908	110	3	1.12	0.95;
	1761	1	5.6	1.1	0	0	1	1.08924	-5.48345	110	3	1.12	0.95;
	1762	1	0	0	0	0	1	1.08653	-5.66867	110	3	1.12	0.95;
	1763	1	0	0	0	0	1	1.08925	-5.48243	110	3	1.12	0.95;
	1764	1	5.7	1.1	0	0	1	1.06572	-12.91017	110	3	1.12	0.95;
	1765	1	7.3	1.4	0	0	1	1.06568	-7.54837	110	3	1.12	0.95;
	1766	1	12.2	3	0	0	1	1.06564	-7.57985	110	3	1.12	0.95;
	1767	1	16	4.9	0	0	1	1.08391	-5.90173	110	3	1.12	0.95;
	1768	1	20.5	6.6	0	0	1	1.07673	-5.41842	110	3	1.12	0.95;
	1769	1	7	2.6	0	0	1	1.0841	-4.55228	110	3	1.12	0.95;
	1770	1	6.2	2.1	0	0	1	1.08402	-4.56328	110	3	1.12	0.95;
	1771	1	4.5	2	0	0	1	1.10418	-2.69003	110	3	1.12	0.95;
	1772	1	0	0	0	0	1	1.10408	-2.68782	110	3	1.12	0.95;
	1773	1	5.6	2.1	0	0	1	1.09558	-7.14553	110	3	1.12	0.95;
	1774	1	2.1	0.9	0	0	1	1.09614	-7.0579	110	3	1.12	0.95;
	1775	1	0	0	0	0	1	1.09582	-7.12925	110	3	1.12	0.95;
	1776	1	0	0	0	0	1	1.09625	-7.05168	110	3	1.12	0.95;
	1777	1	6.4	1.5	0	0	1	1.09702	-7.49476	110	3	1.12	0.95;
	1778	1	0	0	0	0	1	1.09706	-7.49321	110	3	1.12	0.95;
	1779	1	1.5	0.7	0	0	1	1.10261	-3.32368	110	3	1.12	0.95;
	1780	1	2.7	0.7	0	0	1	1.10258	-3.34287	110	3	1.12	0.95;
	1781	1	10.7	2.9	0	0	1	1.07715	-7.51267	110	3	1.12	0.95;
	1782	1	8.6	2.7	0	0	1	1.07708	-7.52563	110	3	1.12	0.95;
	1783	1	10.5	4.2	0	0	1	1.09867	-6.60578	110	3	1.12	0.95;
	1784	1	0	0	0	0	1	1.09989	-6.53057	110	3	1.12	0.95;
	1785	1	1.2	0.4	0	0	1	1.08754	-11.3845	110	3	1.12	0.95;
	1786	1	1.3	0.3	0	0	1	1.08755	-11.38394	110	3	1.12	0.95;
	1787	1	21.9	7.2	0	0	1	1.08802	-7.44026	110	3	1.12	0.95;
	1788	1	0	0	0	0	1	1.08996	-7.33363	110	3	1.12	0.95;
	1789	1	0	0	0	0	1	1.08843	-7.41717	110	3	1.12	0.95;
	1790	1	0	0	0	0	1	1.08996	-7.33362	110	3	1.12	0.95;
	1791	1	9.1	1.6	0	0	1	1.07787	-7.3113	110	3	1.12	0.95;
	1792	1	4	0.2	0	0	1	1.0778	-7.30697	110	3	1.12	0.95;
	1793	1	0	0	0	0	1	1.10046	-6.91384	110	3	1.12	0.95;
	1794	1	0	0	0	0	1	1.10037	-6.91503	110	3	1.12	0.95;
	1795	1	0	0	0	0	1	1.10504	-4.16611	110	3	1.12	0.95;
	1796	1	1.2	-0.2	0	0	1	1.10504	-4.16611	110	3	1.12	0.95;
	1797	1	0	0	0	0	1	1.08904	-5.14453	110	3	1.12	0.95;
	1798	1	0	0	0	0	1	1.10508	-4.15934	110	3	1.12	0.95;
	1799	1	16.6	3.2	0	0	1	1.0737	-7.99776	110	3	1.12	0.95;
	1800	1	19.2	3.4	0	0	1	1.06542	-7.7412	110	3	1.12	0.95;
	1801	1	11.1	1.9	0	0	1	1.09793	-7.32771	110	3	1.12	0.95;
	1802	1	0	0	0	0	1	1.09795	-7.32052	110	3	1.12	0.95;
	1803	1	6.8	1.9	0	0	1	1.07952	-8.87135	110	3	1.12	0.95;
	1804	1	7.4	1.5	0	0	1	1.07945	-8.85575	110	3	1.12	0.95;
	1805	1	7.8	1.7	0	0	1	1.05128	-9.10889	110	3	1.12	0.95;
	1806	1	7.7	0.6	0	0	1	1.07727	-6.81002	110	3	1.12	0.95;
	1807	1	3.7	1.5	0	0	1	1.09961	-5.35854	110	3	1.12	0.95;
	1808	1	0.6	0.5	0	0	1	1.09956	-5.37894	110	3	1.12	0.95;
	1809	1	5.9	0.9	0	0	1	1.0874	-10.66702	110	3	1.12	0.95;
	1810	1	2.3	0.4	0	0	1	1.08743	-10.68026	110	3	1.12	0.95;
	1811	1	8.5	3.8	0	0	1	1.0978	-6.72422	110	3	1.12	0.95;
	1812	1	3	0.8	0	0	1	1.09785	-6.71536	110	3	1.12	0.95;
	1813	1	6.6	2.6	0	0	1	1.08868	-5.35227	110	3	1.12	0.95;
	1814	1	0	0	0	0	1	1.08864	-5.33598	110	3	1.12	0.95;
	1815	1	9.9	3.1	0	0	1	1.10012	-7.12182	110	3	1.12	0.95;
	1816	1	13.5	5.4	0	0	1	1.10004	-7.1458	110	3	1.12	0.95;
	1817	1	4.6	1.7	0	0	1	1.11176	-3.09779	110	3	1.12	0.95;
	1818	1	9.4	3.6	0	0	1	1.11178	-3.11909	110	3	1.12	0.95;
	1819	1	2.9	0.5	0	0	1	1.07878	-12.68127	110	3	1.12	0.95;
	1820	1	1.9	0.6	0	0	1	1.07877	-12.68202	110	3	1.12	0.95;
	1821	1	10.6	4.2	0	0	1	1.08881	-5.52161	110	3	1.12	0.95;
	1822	1	4.9	1.8	0	0	1	1.08889	-5.50463	110	3	1.12	0.95;
	1823	1	0	0	0	0	1	1.11442	-2.41359	110	3	1.12	0.95;
	1824	1	0	0	0	0	1	1.11442	-2.41357	110	3	1.12	0.95;
	1825	1	14.6	5.8	0	0	1	1.09199	-7.70455	110	3	1.12	0.95;
	1826	1	0	0	0	0	1	1.09198	-7.70632	110	3	1.12	0.95;
	1827	1	16.9	7	0	0	1	1.09879	-5.14333	110	3	1.12	0.95;
	1828	1	0	0	0	0	1	1.09882	-5.14223	110	3	1.12	0.95;
	1829	1	5.7	2	0	0	1	1.08736	-11.19142	110	3	1.12	0.95;
	1830	1	0	0	0	0	1	1.0873	-11.18292	110	3	1.12	0.95;
	1831	1	8.9	2.3	0	0	1	1.05723	-10.54227	110	3	1.12	0.95;
	1832	1	12.7	3.9	0	0	1	1.05726	-10.55277	110	3	1.12	0.95;
	1833	1	11.1	3.3	0	0	1	1.09396	-7.92611	110	3	1.12	0.95;
	1834	1	7.8	1.9	0	0	1	1.09399	-7.93686	110	3	1.12	0.95;
	1835	1	2	0.7	0	0	1	1.06506	-10.13643	110	3	1.12	0.95;
	1836	1	2.7	1.3	0	0	1	1.06499	-10.14192	110	3	1.12	0.95;
	1837	1	5	1.4	0	0	1	1.09838	-7.19008	110	3	1.12	0.95;
	1838	1	0	0	0	0	1	1.09839	-7.18959	110	3	1.12	0.95;
	1839	1	6.3	0.7	0	0	1	1.09731	-4.12457	110	3	1.12	0.95;
	1840	1	0	0	0	0	1	1.09737	-4.1072	110	3	1.12	0.95;
	1841	1	3.1	1.9	0	0	1	1.06985	-7.36974	110	3	1.12	0.95;
	1842	1	6.6	-0.1	0	0	1	1.07002	-7.37177	110	3	1.12	0.95;
	1843	1	2.3	1	0	0	1	1.1114	-2.86553	110	3	1.12	0.95;
	1844	1	0	0	0	0	1	1.11202	-2.8176	110	3	1.12	0.95;
	1845	1	5.6	2	0	0	1	1.09627	-7.13997	110	3	1.12	0.95;
	1846	1	3	0.7	0	0	1	1.09632	-7.1438	110	3	1.12	0.95;
	1847	1	10	3.7	0	0	1	1.097	-3.7774	110	3	1.12	0.95;
	1848	1	0	0	0	0	1	1.09714	-3.74045	110	3	1.12	0.95;
	1849	1	1.5	0.3	0	0	1	1.11199	-2.91947	110	3	1.12	0.95;
	1850	1	0	0	0	0	1	1.11204	-2.91571	110	3	1.12	0.95;
	1851	1	5.4	2.9	0	0	1	1.09581	-7.79316	110	3	1.12	0.95;
	1852	1	5.9	1.7	0	0	1	1.09577	-7.79925	110	3	1.12	0.95;
	1853	1	12.3	5.9	0	0	1	1.10218	-3.73809	110	3	1.12	0.95;
	1854	1	11.4	4.6	0	0	1	1.1024	-3.71596	110	3	1.12	0.95;
	1855	1	9.4	3.3	0	0	1	1.09542	-5.88068	110	3	1.12	0.95;
	1856	1	6.7	2.4	0	0	1	1.09553	-5.85333	110	3	1.12	0.95;
	1857	1	0	0	0	0	1	1.09824	-7.42852	110	3	1.12	0.95;
	1858	1	0	0	0	0	1	1.09795	-7.43509	110	3	1.12	0.95;
	1859	1	0	0	0	0	1	1.09915	-6.27853	110	3	1.12	0.95;
	1860	1	8.3	3.6	0	0	1	1.10083	-6.49903	110	3	1.12	0.95;
	1861	1	0	0	0	0	1	1.10077	-6.51551	110	3	1.12	0.95;
	1862	1	14.9	4	0	0	1	1.06805	-7.86887	110	3	1.12	0.95;
	1863	1	14	3.4	0	0	1	1.06791	-7.8658	110	3	1.12	0.95;
	1864	1	13.7	7.1	0	0	1	1.09531	-7.84193	110	3	1.12	0.95;
	1865	1	0	0	0	0	1	1.09533	-7.83812	110	3	1.12	0.95;
	1866	1	0	0	0	0	1	1.09533	-7.83774	110	3	1.12	0.95;
	1867	1	0	0	0	0	1	1.09533	-7.83774	110	3	1.12	0.95;
	1868	1	10.5	3.8	0	0	1	1.10739	-4.13375	110	3	1.12	0.95;
	1869	1	18	6.1	0	0	1	1.09041	-4.95696	110	3	1.12	0.95;
	1870	1	2.1	0.6	0	0	1	1.09756	-3.64852	110	3	1.12	0.95;
	1871	1	0	0	0	0	1	1.0976	-3.64539	110	3	1.12	0.95;
	1872	2	3.9	4.6	0	0	1	1.10001	-11.29004	110	3	1.12	0.95;
	1873	1	6.7	3	0	0	1	1.0999	-11.29558	110	3	1.12	0.95;
	1874	1	5.1	1.7	0	0	1	1.11506	-2.58345	110	3	1.12	0.95;
	1875	1	4.6	1.5	0	0	1	1.11986	-5.22335	110	3	1.12	0.95;
	1876	1	0	0	0	0	1	1.11512	-2.57981	110	3	1.12	0.95;
	1877	1	3.9	3.7	0	0	1	1.0869	-7.48824	110	3	1.12	0.95;
	1878	1	7.6	3	0	0	1	1.08696	-7.48385	110	3	1.12	0.95;
	1879	1	2.2	0.9	0	0	1	1.11725	-3.67045	110	3	1.12	0.95;
	1880	1	0	0	0	0	1	1.11734	-3.66517	110	3	1.12	0.95;
	1881	1	3.5	0.9	0	0	1	1.09958	-10.50103	110	3	1.12	0.95;
	1882	1	0	0	0	0	1	1.09968	-10.49665	110	3	1.12	0.95;
	1883	1	8.2	3.3	0	0	1	1.10647	-3.21381	110	3	1.12	0.95;
	1884	1	8.2	2.8	0	0	1	1.11059	-2.95322	110	3	1.12	0.95;
	1885	1	6.2	2.7	0	0	1	1.06425	-7.50609	110	3	1.12	0.95;
	1886	1	0	0	0	0	1	1.06445	-7.49893	110	3	1.12	0.95;
	1887	1	6	1.3	0	0	1	1.08087	-5.14664	110	3	1.12	0.95;
	1888	1	11.2	4.1	0	0	1	1.08087	-5.13667	110	3	1.12	0.95;
	1889	1	4.8	2.2	0	0	1	1.08779	-11.41679	110	3	1.12	0.95;
	1890	1	5	1.3	0	0	1	1.08451	-9.16975	110	3	1.12	0.95;
	1891	1	4.6	0.7	0	0	1	1.08439	-9.1842	110	3	1.12	0.95;
	1892	1	4.3	1.3	0	0	1	1.08064	-5.24051	110	3	1.12	0.95;
	1893	1	3.6	1.3	0	0	1	1.08067	-5.24638	110	3	1.12	0.95;
	1894	1	0	0	0	0	1	1.04174	-10.97445	110	3	1.12	0.95;
	1895	1	0	0	0	0	1	1.04173	-10.97438	110	3	1.12	0.95;
	1896	1	1.5	0.7	0	0	1	1.08853	-9.49832	110	3	1.12	0.95;
	1897	1	0.2	0.1	0	0	1	1.08855	-9.49675	110	3	1.12	0.95;
	1898	1	0	0	0	0	1	1.10795	-4.25543	110	3	1.12	0.95;
	1899	1	13.6	4.5	0	0	1	1.10798	-4.23927	110	3	1.12	0.95;
	1900	2	21.2	32.2	0	0	1	1.11831	-4.53733	110	3	1.12	0.95;
	1901	2	15.1	19.1	0	0	1	1.08482	-5.40375	110	3	1.12	0.95;
	1902	2	20	22.1	0	0	1	1.09186	-4.09042	110	3	1.12	0.95;
	1903	1	9	1	0	0	1	1.09702	-7.73444	110	3	1.12	0.95;
	1904	1	6.9	2.3	0	0	1	1.09707	-7.72362	110	3	1.12	0.95;
	1905	1	4.9	1.9	0	0	1	1.11404	-2.00643	110	3	1.12	0.95;
	1906	1	0	0	0	0	1	1.11402	-2.02112	110	3	1.12	0.95;
	1907	1	8.8	3.9	0	0	1	1.09842	-6.92358	110	3	1.12	0.95;
	1908	1	5.3	2.3	0	0	1	1.09842	-6.934	110	3	1.12	0.95;
	1909	1	0	0	0	0	1	1.10294	-6.34509	110	3	1.12	0.95;
	1910	2	7.8	7.8	0	0	1	1.07834	-7.71849	110	3	1.12	0.95;
	1911	2	17.9	16.9	0	0	1	1.07341	-7.87433	110	3	1.12	0.95;
	1912	1	5.6	1.3	0	0	1	1.0537	-11.30904	110	3	1.12	0.95;
	1913	1	7.7	1	0	0	1	1.05298	-11.39977	110	3	1.12	0.95;
	1914	1	4.9	0.8	0	0	1	1.09002	-9.41879	110	3	1.12	0.95;
	1915	1	0	0	0	0	1	1.08998	-9.40272	110	3	1.12	0.95;
	1916	1	7.6	2.1	0	0	1	1.07367	-7.96767	110	3	1.12	0.95;
	1917	1	0	0	0	0	1	1.07838	-7.79216	110	3	1.12	0.95;
	1918	1	0.4	0	0	0	1	1.08905	-8.06153	110	3	1.12	0.95;
	1919	1	0.4	0	0	0	1	1.098	-4.53653	110	3	1.12	0.95;
	1920	1	8.4	3.5	0	0	1	1.07262	-7.9942	110	3	1.12	0.95;
	1921	1	14	5.8	0	0	1	1.07249	-8.01345	110	3	1.12	0.95;
	1922	1	6.2	2.3	0	0	1	1.10997	-4.82715	110	3	1.12	0.95;
	1923	1	0	0	0	0	1	1.10996	-4.81675	110	3	1.12	0.95;
	1924	1	2.5	0.7	0	0	1	1.10961	-4.95062	110	3	1.12	0.95;
	1925	1	5.8	0.2	0	0	1	1.10775	-5.54942	110	3	1.12	0.95;
	1926	1	0	0	0	0	1	1.10996	-4.93627	110	3	1.12	0.95;
	1927	1	0	0	0	0	1	1.10843	-5.50894	110	3	1.12	0.95;
	1928	1	7.4	3.8	0	0	1	1.11137	-2.8951	110	3	1.12	0.95;
	1929	1	8.1	1.8	0	0	1	1.10661	-3.21497	110	3	1.12	0.95;
	1930	1	0	0	0	0	1	1.11176	-2.87431	110	3	1.12	0.95;
	1931	1	10.3	2.8	0	0	1	1.06977	-7.96569	110	3	1.12	0.95;
	1932	1	11.3	3.4	0	0	1	1.06965	-7.97156	110	3	1.12	0.95;
	1933	1	1.8	0	0	0	1	1.09873	-3.67836	110	3	1.12	0.95;
	1934	1	1.8	1.5	0	0	1	1.0988	-3.67095	110	3	1.12	0.95;
	1935	1	5.2	2.4	0	0	1	1.11743	-1.91453	110	3	1.12	0.95;
	1936	1	9	4.8	0	0	1	1.11625	-2.06463	110	3	1.12	0.95;
	1937	1	0	0	0	0	1	1.11786	-1.89905	110	3	1.12	0.95;
	1938	1	0	0	0	0	1	1.11704	-2.03943	110	3	1.12	0.95;
	1939	1	11.7	6.6	0	0	1	1.10722	-4.9785	110	3	1.12	0.95;
	1940	1	1.4	0.9	0	0	1	1.10718	-4.99372	110	3	1.12	0.95;
	1941	1	7.3	2.1	0	0	1	1.09522	-7.92271	110	3	1.12	0.95;
	1942	1	0.2	0.1	0	0	1	1.09503	-7.92176	110	3	1.12	0.95;
	1943	1	4.3	1.5	0	0	1	1.09838	-5.55882	110	3	1.12	0.95;
	1944	1	15.3	5	0	0	1	1.10444	-4.84522	110	3	1.12	0.95;
	1945	1	1.9	0.1	0	0	1	1.0837	-6.00047	110	3	1.12	0.95;
	1946	1	0	0	0	0	1	1.08366	-6.00957	110	3	1.12	0.95;
	1947	1	5.9	2.6	0	0	1	1.10021	-2.59913	110	3	1.12	0.95;
	1948	1	3.9	1.7	0	0	1	1.10269	-2.51598	110	3	1.12	0.95;
	1949	1	0	0	0	0	1	1.10023	-2.59819	110	3	1.12	0.95;
	1950	1	0	0	0	0	1	1.10282	-2.5081	110	3	1.12	0.95;
	1951	1	10.1	3.9	0	0	1	1.06379	-10.12576	110	3	1.12	0.95;
	1952	1	9.5	4	0	0	1	1.06373	-10.13317	110	3	1.12	0.95;
	1953	1	11.4	4.6	0	0	1	1.10373	-2.24993	110	3	1.12	0.95;
	1954	1	5.8	2.4	0	0	1	1.10372	-2.24783	110	3	1.12	0.95;
	1955	1	1.8	0.8	0	0	1	1.10566	-6.03081	110	3	1.12	0.95;
	1956	1	2.1	0.9	0	0	1	1.1057	-6.01649	110	3	1.12	0.95;
	1957	1	5.6	2.1	0	0	1	1.10084	-2.78263	110	3	1.12	0.95;
	1958	1	7.6	2.9	0	0	1	1.08591	-7.55387	110	3	1.12	0.95;
	1959	1	1.3	0.5	0	0	1	1.09474	-6.88272	110	3	1.12	0.95;
	1960	1	15.9	2.3	0	0	1	1.09633	-4.69782	110	3	1.12	0.95;
	1961	1	0	0	0	0	1	1.09632	-4.6965	110	3	1.12	0.95;
	1962	1	28.1	9.2	0	0	1	1.08892	-7.21472	110	3	1.12	0.95;
	1963	1	12.6	3.1	0	0	1	1.08898	-7.23723	110	3	1.12	0.95;
	1964	1	3.9	1.3	0	0	1	1.06614	-13.48397	110	3	1.12	0.95;
	1965	1	7	2.7	0	0	1	1.06611	-13.47987	110	3	1.12	0.95;
	1966	1	5.2	1.7	0	0	1	1.09512	-7.86971	110	3	1.12	0.95;
	1967	1	11.2	3.3	0	0	1	1.09464	-7.89671	110	3	1.12	0.95;
	1968	1	9.9	2.6	0	0	1	1.06719	-13.32863	110	3	1.12	0.95;
	1969	1	10.2	3.4	0	0	1	1.06722	-13.337	110	3	1.12	0.95;
	1970	1	1.5	0.1	0	0	1	1.09917	-4.28488	110	3	1.12	0.95;
	1971	1	1.9	0.3	0	0	1	1.09916	-4.28995	110	3	1.12	0.95;
	1972	1	4.2	1.7	0	0	1	1.08065	-6.99844	110	3	1.12	0.95;
	1973	1	5.6	0.6	0	0	1	1.08072	-7.0223	110	3	1.12	0.95;
	1974	1	6.4	2	0	0	1	1.06849	-13.17876	110	3	1.12	0.95;
	1975	1	3.7	1	0	0	1	1.06854	-13.17344	110	3	1.12	0.95;
	1976	1	10.7	4	0	0	1	1.08648	-5.6672	110	3	1.12	0.95;
	1977	1	11.1	3.5	0	0	1	1.08649	-5.66773	110	3	1.12	0.95;
	1978	1	9.3	3.7	0	0	1	1.04984	-9.69784	110	3	1.12	0.95;
	1979	1	4.8	2	0	0	1	1.04993	-9.681	110	3	1.12	0.95;
	1980	1	9	2	0	0	1	1.11258	-2.7895	110	3	1.12	0.95;
	1981	1	4.3	0.4	0	0	1	1.11249	-2.82109	110	3	1.12	0.95;
	1982	1	0	0	0	0	1	1.10031	-4.91557	110	3	1.12	0.95;
	1983	1	9.7	3.4	0	0	1	1.10005	-4.9437	110	3	1.12	0.95;
	1984	1	4.9	1.2	0	0	1	1.10879	-3.42886	110	3	1.12	0.95;
	1985	1	9.4	0.5	0	0	1	1.1087	-3.42424	110	3	1.12	0.95;
	1986	1	4.8	1.4	0	0	1	1.09484	-6.87575	110	3	1.12	0.95;
	1987	1	8.8	4.3	0	0	1	1.09483	-6.86715	110	3	1.12	0.95;
	1988	1	5.4	1.8	0	0	1	1.061	-8.95771	110	3	1.12	0.95;
	1989	1	4.2	1.5	0	0	1	1.06086	-8.98263	110	3	1.12	0.95;
	1990	1	1.8	0.7	0	0	1	1.08929	-11.29862	110	3	1.12	0.95;
	1991	1	0	0	0	0	1	1.08426	-10.61381	110	3	1.12	0.95;
	1992	1	2	0.4	0	0	1	1.0947	-4.75463	110	3	1.12	0.95;
	1993	1	3.7	1.6	0	0	1	1.09474	-4.76011	110	3	1.12	0.95;
	1994	1	4.2	1.6	0	0	1	1.06452	-7.62148	110	3	1.12	0.95;
	1995	1	1.9	1.2	0	0	1	1.06447	-7.61477	110	3	1.12	0.95;
	1996	1	5.3	1.5	0	0	1	1.10614	-2.17168	110	3	1.12	0.95;
	1997	1	2.3	0.9	0	0	1	1.10613	-2.15684	110	3	1.12	0.95;
	1998	1	7.8	3.3	0	0	1	1.1032	-2.33884	110	3	1.12	0.95;
	1999	1	4.6	2	0	0	1	1.10324	-2.33347	110	3	1.12	0.95;
	2000	1	8.4	1.5	0	0	1	1.05993	-10.98161	110	3	1.12	0.95;
	2001	1	13.7	3.8	0	0	1	1.06014	-10.97349	110	3	1.12	0.95;
	2002	1	12.6	8.3	0	0	1	1.09523	-7.39108	110	3	1.12	0.95;
	2003	1	0	0	0	0	1	1.09533	-7.38506	110	3	1.12	0.95;
	2004	1	10.5	4.2	0	0	1	1.10519	-2.30439	110	3	1.12	0.95;
	2005	1	0	0	0	0	1	1.10517	-2.2932	110	3	1.12	0.95;
	2006	1	11.7	4	0	0	1	1.0942	-7.30393	110	3	1.12	0.95;
	2007	1	11.7	3.8	0	0	1	1.09088	-7.76873	110	3	1.12	0.95;
	2008	1	0	0	0	0	1	1.09486	-7.28171	110	3	1.12	0.95;
	2009	1	0	0	0	0	1	1.09149	-7.74923	110	3	1.12	0.95;
	2010	1	3.5	0.8	0	0	1	1.08854	-11.30878	110	3	1.12	0.95;
	2011	1	0	0	0	0	1	1.08849	-11.31556	110	3	1.12	0.95;
	2012	1	1.6	0.7	0	0	1	1.10594	-4.0256	110	3	1.12	0.95;
	2013	1	0	0	0	0	1	1.10598	-4.02123	110	3	1.12	0.95;
	2014	1	0	0	0	0	1	1.08836	-11.34664	110	3	1.12	0.95;
	2015	1	0	0	0	0	1	1.08778	-11.36011	110	3	1.12	0.95;
	2016	1	0	0	0	0	1	1.09062	-4.66235	110	3	1.12	0.95;
	2017	1	0	0	0	0	1	1.09478	-7.4186	110	3	1.12	0.95;
	2018	2	17	6.6	0	0	1	1.10106	-6.64776	110	3	1.12	0.95;
	2019	1	7.7	3	0	0	1	1.10087	-6.66367	110	3	1.12	0.95;
	2020	1	0.2	0.3	0	0	1	1.08077	-5.2698	110	3	1.12	0.95;
	2021	1	0	0	0	0	1	1.08077	-5.2698	110	3	1.12	0.95;
	2022	1	20.4	8.7	0	0	1	1.10151	-6.57022	110	3	1.12	0.95;
	2023	1	9.7	4.1	0	0	1	1.10146	-6.5791	110	3	1.12	0.95;
	2024	1	7.7	3	0	0	1	1.11678	-2.06245	110	3	1.12	0.95;
	2025	1	8.7	3.4	0	0	1	1.10528	-2.4462	110	3	1.12	0.95;
	2026	1	0	0	0	0	1	1.11685	-2.05819	110	3	1.12	0.95;
	2027	1	10.8	3.7	0	0	1	1.0937	-6.09017	110	3	1.12	0.95;
	2028	1	5.3	2	0	0	1	1.09366	-6.10982	110	3	1.12	0.95;
	2029	1	4	4	0	0	1	1.11052	-5.18126	110	3	1.12	0.95;
	2030	1	16.6	6.9	0	0	1	1.11054	-5.17941	110	3	1.12	0.95;
	2031	1	8.2	4.8	0	0	1	1.08112	-11.95324	110	3	1.12	0.95;
	2032	1	0	0	0	0	1	1.08122	-11.93923	110	3	1.12	0.95;
	2033	1	0	0	0	0	1	1.08221	-5.59227	110	3	1.12	0.95;
	2034	1	5.9	-0.1	0	0	1	1.0822	-5.59467	110	3	1.12	0.95;
	2035	1	12.1	4.1	0	0	1	1.09742	-6.83542	110	3	1.12	0.95;
	2036	1	18.5	6.2	0	0	1	1.09721	-6.85482	110	3	1.12	0.95;
	2037	1	7.6	2.3	0	0	1	1.0626	-8.40949	110	3	1.12	0.95;
	2038	1	8.9	3.1	0	0	1	1.06236	-8.42349	110	3	1.12	0.95;
	2039	1	9	2.6	0	0	1	1.09372	-7.70655	110	3	1.12	0.95;
	2040	1	0	0	0	0	1	1.09445	-7.68074	110	3	1.12	0.95;
	2041	1	2.3	0.8	0	0	1	1.09166	-6.80763	110	3	1.12	0.95;
	2042	1	0	0	0	0	1	1.09166	-6.80747	110	3	1.12	0.95;
	2043	1	0	0	0	0	1	1.08077	-7.47578	110	3	1.12	0.95;
	2044	1	0	0	0	0	1	1.08259	-7.56521	110	3	1.12	0.95;
	2045	1	12.8	5.4	0	0	1	1.09152	-8.58207	110	3	1.12	0.95;
	2046	1	12.8	4.7	0	0	1	1.09157	-8.58983	110	3	1.12	0.95;
	2047	1	8.1	2.7	0	0	1	1.09726	-7.2503	110	3	1.12	0.95;
	2048	1	0	0	0	0	1	1.09721	-7.25192	110	3	1.12	0.95;
	2049	1	9.6	2.3	0	0	1	1.06572	-7.54307	110	3	1.12	0.95;
	2050	1	11	2.9	0	0	1	1.06571	-7.55723	110	3	1.12	0.95;
	2051	1	7.7	3	0	0	1	1.07615	-6.1308	110	3	1.12	0.95;
	2052	1	6	2.3	0	0	1	1.07611	-6.12086	110	3	1.12	0.95;
	2053	1	4.7	1.7	0	0	1	1.11728	-1.97034	110	3	1.12	0.95;
	2054	1	14.9	5	0	0	1	1.11093	-2.66364	110	3	1.12	0.95;
	2055	1	0	0	0	0	1	1.11114	-2.64937	110	3	1.12	0.95;
	2056	1	9.8	5.6	0	0	1	1.06041	-10.38041	110	3	1.12	0.95;
	2057	1	10	4	0	0	1	1.0604	-10.38091	110	3	1.12	0.95;
	2058	1	4.3	2.3	0	0	1	1.09454	-3.69632	110	3	1.12	0.95;
	2059	1	5	3.6	0	0	1	1.09452	-3.72135	110	3	1.12	0.95;
	2060	1	0	0	0	0	1	1.10289	-5.41106	110	3	1.12	0.95;
	2061	1	3.3	0.8	0	0	1	1.10288	-5.42124	110	3	1.12	0.95;
	2062	2	18.9	35	0	0	1	1.12	-2.78541	110	3	1.12	0.95;
	2063	2	14.1	32.2	0	0	1	1.10481	-2.46715	110	3	1.12	0.95;
	2064	2	14.1	32.2	0	0	1	1.10942	-3.13229	110	3	1.12	0.95;
	2065	1	0	0	0	0	1	1.10689	-3.19063	110	3	1.12	0.95;
	2066	1	11.3	4.5	0	0	1	1.11098	-2.92953	110	3	1.12	0.95;
	2067	1	10.6	3.9	0	0	1	1.0593	-8.65022	110	3	1.12	0.95;
	2068	1	0	0	0	0	1	1.09479	-7.41873	110	3	1.12	0.95;
	2069	1	15.7	5.1	0	0	1	1.04881	-9.53765	110	3	1.12	0.95;
	2070	1	9.1	3	0	0	1	1.04876	-9.56368	110	3	1.12	0.95;
	2071	1	7.8	2.6	0	0	1	1.1136	-4.93238	110	3	1.12	0.95;
	2072	1	4.9	1.4	0	0	1	1.11351	-4.94668	110	3	1.12	0.95;
	2073	1	0	0	0	0	1	1.11237	-2.7316	110	3	1.12	0.95;
	2074	1	6.7	2.3	0	0	1	1.11237	-2.73935	110	3	1.12	0.95;
	2075	1	12.9	4.8	0	0	1	1.08666	-5.71577	110	3	1.12	0.95;
	2076	1	12.3	5.3	0	0	1	1.08673	-5.72801	110	3	1.12	0.95;
	2077	1	8.6	2.4	0	0	1	1.07401	-6.53352	110	3	1.12	0.95;
	2078	1	5	0.3	0	0	1	1.07396	-6.55002	110	3	1.12	0.95;
	2079	1	15	4.3	0	0	1	1.06448	-7.58722	110	3	1.12	0.95;
	2080	1	8.6	0.7	0	0	1	1.06449	-7.57364	110	3	1.12	0.95;
	2081	1	5.8	2.2	0	0	1	1.08435	-5.43438	110	3	1.12	0.95;
	2082	1	0	0	0	0	1	1.11832	-4.53753	110	3	1.12	0.95;
	2083	1	0	0	0	0	1	1.1199	-1.56774	110	3	1.12	0.95;
	2084	1	16.2	0.6	0	0	1	1.09944	-7.74999	110	3	1.12	0.95;
	2085	1	1.9	0.2	0	0	1	1.10098	-7.06045	110	3	1.12	0.95;
	2086	1	6.4	0.6	0	0	1	1.06562	-13.50786	110	3	1.12	0.95;
	2087	1	4.6	2.3	0	0	1	1.06561	-13.50735	110	3	1.12	0.95;
	2088	1	8.7	3.4	0	0	1	1.03462	-11.78976	110	3	1.12	0.95;
	2089	1	7	2.3	0	0	1	1.0346	-11.77264	110	3	1.12	0.95;
	2090	1	0.7	0.2	0	0	1	1.10207	-5.99465	110	3	1.12	0.95;
	2091	1	0.5	0.2	0	0	1	1.09888	-6.62282	110	3	1.12	0.95;
	2092	1	0	0	0	0	1	1.09684	-3.81626	110	3	1.12	0.95;
	2093	1	0	0	0	0	1	1.05448	-8.5312	110	3	1.12	0.95;
	2094	2	37.1	20.4	0	0	1	1.10162	-5.67295	110	3	1.12	0.95;
	2095	2	0	0	0	0	1	1.09527	-7.48224	110	3	1.12	0.95;
	2096	1	5	1.9	0	0	1	1.09927	-3.87188	110	3	1.12	0.95;
	2097	1	5.4	2	0	0	1	1.11513	-2.26114	110	3	1.12	0.95;
	2098	1	0	0	0	0	1	1.09928	-3.87155	110	3	1.12	0.95;
	2099	1	0	0	0	0	1	1.11514	-2.2608	110	3	1.12	0.95;
	2100	1	3.4	0.8	0	0	1	1.09328	-7.45159	110	3	1.12	0.95;
	2101	1	7.9	2.3	0	0	1	1.0932	-7.44986	110	3	1.12	0.95;
	2102	1	14.9	3.6	0	0	1	1.11573	-2.52941	110	3	1.12	0.95;
	2103	1	12.4	2.1	0	0	1	1.11564	-2.55497	110	3	1.12	0.95;
	2104	1	10.8	3.5	0	0	1	1.10187	-5.50692	110	3	1.12	0.95;
	2105	1	10.2	3.3	0	0	1	1.10188	-5.49517	110	3	1.12	0.95;
	2106	1	7.6	3	0	0	1	1.07185	-8.7167	110	3	1.12	0.95;
	2107	1	12.4	4.4	0	0	1	1.07202	-8.69986	110	3	1.12	0.95;
	2108	1	13.9	4.1	0	0	1	1.08825	-7.33465	110	3	1.12	0.95;
	2109	1	3.9	0.2	0	0	1	1.08835	-7.32353	110	3	1.12	0.95;
	2110	1	7.5	2.3	0	0	1	1.08906	-8.06084	110	3	1.12	0.95;
	2111	1	0	0	0	0	1	1.09801	-4.53586	110	3	1.12	0.95;
	2112	1	7	2.3	0	0	1	1.10151	-3.49509	110	3	1.12	0.95;
	2113	1	7.2	2.4	0	0	1	1.10135	-3.51277	110	3	1.12	0.95;
	2114	1	10.1	2.6	0	0	1	1.06634	-7.41062	110	3	1.12	0.95;
	2115	1	9.5	3.4	0	0	1	1.06633	-7.42107	110	3	1.12	0.95;
	2116	1	3.2	1.5	0	0	1	1.09443	-4.74308	110	3	1.12	0.95;
	2117	1	4.3	1	0	0	1	1.09447	-4.75438	110	3	1.12	0.95;
	2118	1	9.9	3	0	0	1	1.09879	-7.456	110	3	1.12	0.95;
	2119	1	4.9	1.5	0	0	1	1.09891	-7.45183	110	3	1.12	0.95;
	2120	1	1.5	0.6	0	0	1	1.11122	-2.86684	110	3	1.12	0.95;
	2121	1	0	0	0	0	1	1.11122	-2.87068	110	3	1.12	0.95;
	2122	1	15	6.6	0	0	1	1.09062	-7.27384	110	3	1.12	0.95;
	2123	1	6	0.1	0	0	1	1.09053	-7.28354	110	3	1.12	0.95;
	2124	1	4.9	2.3	0	0	1	1.08964	-7.22596	110	3	1.12	0.95;
	2125	1	2.9	-0.3	0	0	1	1.08966	-7.21276	110	3	1.12	0.95;
	2126	1	0.2	0.3	0	0	1	1.0983	-7.45231	110	3	1.12	0.95;
	2127	1	0.8	0.1	0	0	1	1.09822	-7.45262	110	3	1.12	0.95;
	2128	1	0	0	0	0	1	1.1192	-3.70964	110	3	1.12	0.95;
	2129	1	0	0	0	0	1	1.1192	-3.70964	110	3	1.12	0.95;
	2130	2	30.3	15.9	0	0	1	1.08359	-4.6031	110	3	1.12	0.95;
	2131	2	29.9	14.8	0	0	1	1.08354	-4.5931	110	3	1.12	0.95;
	2132	1	0	0	0	0	1	1.08361	-4.60616	110	3	1.12	0.95;
	2133	1	0	0	0	0	1	1.08361	-4.60616	110	3	1.12	0.95;
	2134	1	10	2.4	0	0	1	1.09615	-3.87353	110	3	1.12	0.95;
	2135	1	0	0	0	0	1	1.10758	-3.27084	110	3	1.12	0.95;
	2136	1	0	0	0	0	1	1.09683	-3.81775	110	3	1.12	0.95;
	2137	1	7.7	2.7	0	0	1	1.09891	-7.42183	110	3	1.12	0.95;
	2138	1	11.1	4.4	0	0	1	1.09881	-7.42185	110	3	1.12	0.95;
	2139	1	5.4	2.3	0	0	1	1.09864	-7.44362	110	3	1.12	0.95;
	2140	1	10.2	4.8	0	0	1	1.09855	-7.4473	110	3	1.12	0.95;
	2141	1	3.6	1.6	0	0	1	1.09153	-9.00279	110	3	1.12	0.95;
	2142	1	0	0	0	0	1	1.09153	-8.98826	110	3	1.12	0.95;
	2143	1	4.3	1.5	0	0	1	1.09871	-7.57485	110	3	1.12	0.95;
	2144	1	9.4	0.2	0	0	1	1.09847	-7.6094	110	3	1.12	0.95;
	2145	1	15.7	6.3	0	0	1	1.10841	-6.07033	110	3	1.12	0.95;
	2146	1	0	0	0	0	1	1.10857	-6.0511	110	3	1.12	0.95;
	2147	1	0.5	0.2	0	0	1	1.11438	-2.41554	110	3	1.12	0.95;
	2148	1	0	0	0	0	1	1.11438	-2.41554	110	3	1.12	0.95;
	2149	1	0	0	0	0	1	1.11438	-2.41552	110	3	1.12	0.95;
	2150	2	40.5	9	0	0	1	1.06756	-9.96912	110	3	1.12	0.95;
	2151	1	16.2	4.5	0	0	1	1.07548	-9.54039	110	3	1.12	0.95;
	2152	2	6	20.1	0	0	1	1.12	-11.37321	110	4	1.12	0.95;
	2153	2	8.8	20.6	0	0	1	1.11998	-11.36343	110	4	1.12	0.95;
	2154	1	1.8	1.6	0	0	1	1.11938	-11.38586	110	4	1.12	0.95;
	2155	1	28.8	2.4	0	0	1	1.08338	-28.97514	110	4	1.12	0.95;
	2156	1	7.6	1.7	0	0	1	1.09005	-21.3465	110	4	1.12	0.95;
	2157	1	10.9	-0.8	0	0	1	1.02257	-23.61402	110	4	1.12	0.95;
	2158	1	0.5	0	0	0	1	1.09972	-13.27592	110	4	1.12	0.95;
	2159	1	10.9	1.4	0	0	1	1.07537	-13.31912	110	4	1.12	0.95;
	2160	1	0	0	0	0	1	1.07537	-13.31912	110	4	1.12	0.95;
	2161	1	7.4	1.7	0	0	1	1.04271	-25.6092	110	4	1.12	0.95;
	2162	1	26.9	11.5	0	0	1	1.07821	-14.84764	110	4	1.12	0.95;
	2163	1	22	8.6	0	0	1	1.0366	-25.19936	110	4	1.12	0.95;
	2164	1	11.5	0.2	0	0	1	1.08292	-29.32057	110	4	1.12	0.95;
	2165	1	0	0	0	0	1	1.08291	-29.33606	110	4	1.12	0.95;
	2166	1	13.2	1.2	0	0	1	1.0479	-24.67518	110	4	1.12	0.95;
	2167	1	6.5	1.2	0	0	1	1.10201	-9.73921	110	4	1.12	0.95;
	2168	2	6.5	1.2	0	0	1	1.102	-9.75381	110	4	1.12	0.95;
	2169	1	16.8	5.1	0	0	1	1.10098	-10.03242	110	4	1.12	0.95;
	2170	1	7.9	0	0	0	1	1.07728	-13.85558	110	4	1.12	0.95;
	2171	1	6.5	0	0	0	1	1.07728	-13.85824	110	4	1.12	0.95;
	2172	1	39	11.2	0	0	1	1.07163	-29.34666	110	4	1.12	0.95;
	2173	1	6.2	-0.5	0	0	1	1.07296	-13.30308	110	4	1.12	0.95;
	2174	1	4.9	0	0	0	1	1.07155	-13.53977	110	4	1.12	0.95;
	2175	1	12.2	4.9	0	0	1	1.03505	-27.56865	110	4	1.12	0.95;
	2176	1	8.9	3.4	0	0	1	1.05483	-20.40564	110	4	1.12	0.95;
	2177	1	2.7	-1.1	0	0	1	0.99663	-25.20029	110	4	1.12	0.95;
	2178	1	19.6	4.3	0	0	1	1.0756	-14.2187	110	4	1.12	0.95;
	2179	1	19.6	4.3	0	0	1	1.07555	-14.22658	110	4	1.12	0.95;
	2180	1	15.2	1.1	0	0	1	1.05546	-20.24075	110	4	1.12	0.95;
	2181	1	0.9	0.4	0	0	1	1.06575	-21.43665	110	4	1.12	0.95;
	2182	1	5.3	1.1	0	0	1	1.11828	-7.26688	110	4	1.12	0.95;
	2183	2	5.2	0.5	0	0	1	1.08218	-11.78358	110	4	1.12	0.95;
	2184	1	0	0	0	0	1	1.09448	-21.69699	110	4	1.12	0.95;
	2185	1	9.6	-1.7	0	0	1	1.05182	-28.96828	110	4	1.12	0.95;
	2186	1	6.7	0.3	0	0	1	1.04245	-21.55003	110	4	1.12	0.95;
	2187	2	4.4	0.1	0	0	1	1.06445	-14.3663	110	4	1.12	0.95;
	2188	1	3.7	2.1	0	0	1	1.06443	-14.36777	110	4	1.12	0.95;
	2189	2	3	5	0	0	1	1.08651	-14.27741	110	4	1.12	0.95;
	2190	2	3.5	6.1	0	0	1	1.08732	-15.43173	110	4	1.12	0.95;
	2191	1	4.2	0.2	0	0	1	1.08605	-14.37083	110	4	1.12	0.95;
	2192	1	27.7	7.3	0	0	1	1.07914	-32.22328	110	4	1.12	0.95;
	2193	1	7.1	1.8	0	0	1	1.06391	-24.15132	110	4	1.12	0.95;
	2194	1	4.2	0.3	0	0	1	1.07596	-15.34185	110	4	1.12	0.95;
	2195	1	9.4	2	0	0	1	1.04311	-26.07038	110	4	1.12	0.95;
	2196	1	1.6	0.4	0	0	1	1.08758	-23.01341	110	4	1.12	0.95;
	2197	1	11.3	3.6	0	0	1	1.09322	-12.29236	110	4	1.12	0.95;
	2198	1	1	-0.4	0	0	1	1.08868	-28.54206	110	4	1.12	0.95;
	2199	1	0	0	0	0	1	1.08224	-11.76922	110	4	1.12	0.95;
	2200	1	0	0	0	0	1	1.08224	-11.76922	110	4	1.12	0.95;
	2201	1	0	0	0	0	1	1.07824	-15.13078	110	4	1.12	0.95;
	2202	1	0	0	0	0	1	1.08309	-14.69156	110	4	1.12	0.95;
	2203	1	3.4	0.8	0	0	1	1.10269	-9.80262	110	4	1.12	0.95;
	2204	1	7.7	-0.1	0	0	1	1.03267	-28.51325	110	4	1.12	0.95;
	2205	1	24.9	6.8	0	0	1	1.08054	-28.89785	110	4	1.12	0.95;
	2206	1	3.2	4.7	0	0	1	1.04113	-23.5229	110	4	1.12	0.95;
	2207	1	6.3	2.6	0	0	1	1.08758	-28.4419	110	4	1.12	0.95;
	2208	1	3.7	1.1	0	0	1	1.08756	-28.47313	110	4	1.12	0.95;
	2209	1	17.3	1.9	0	0	1	1.05407	-32.90577	110	4	1.12	0.95;
	2210	1	18.9	4.8	0	0	1	1.0486	-24.582	110	4	1.12	0.95;
	2211	1	4.9	1.3	0	0	1	1.0639	-22.0152	110	4	1.12	0.95;
	2212	1	10.5	1.7	0	0	1	1.04914	-18.7565	110	4	1.12	0.95;
	2213	1	4	0.2	0	0	1	1.03749	-29.65762	110	4	1.12	0.95;
	2214	1	12.9	0.1	0	0	1	1.03005	-26.65693	110	4	1.12	0.95;
	2215	1	5.4	1.7	0	0	1	1.03302	-27.83983	110	4	1.12	0.95;
	2216	2	19.2	34.7	0	0	1	1.09482	-21.66947	110	4	1.12	0.95;
	2217	1	0	0	0	0	1	1.09482	-21.66947	110	4	1.12	0.95;
	2218	1	12.1	-1.3	0	0	1	1.04607	-28.79709	110	4	1.12	0.95;
	2219	1	0	0	0	0	1	1.04607	-28.79709	110	4	1.12	0.95;
	2220	1	15.1	-0.9	0	0	1	1.04311	-29.97867	110	4	1.12	0.95;
	2221	1	4.3	1.3	0	0	1	1.05623	-14.92585	110	4	1.12	0.95;
	2222	2	0	0.4	0	0	1	1.06232	-21.34861	110	4	1.12	0.95;
	2223	1	0	0	0	0	1	1.06232	-21.34861	110	4	1.12	0.95;
	2224	1	9	3.1	0	0	1	1.06145	-14.57768	110	4	1.12	0.95;
	2225	1	11.5	3	0	0	1	1.07657	-13.89966	110	4	1.12	0.95;
	2226	2	33	32.1	0	0	1	1.08961	-28.58611	110	4	1.12	0.95;
	2227	2	8	16.1	0	0	1	1.08886	-28.55561	110	4	1.12	0.95;
	2228	1	10.6	4.6	0	0	1	1.07048	-29.04483	110	4	1.12	0.95;
	2229	1	3.2	1.1	0	0	1	1.03099	-25.99972	110	4	1.12	0.95;
	2230	1	11	4	0	0	1	1.07801	-28.02005	110	4	1.12	0.95;
	2231	1	11	4.9	0	0	1	1.07726	-28.7865	110	4	1.12	0.95;
	2232	2	14.5	7.2	0	0	1	0.98707	-28.05104	110	4	1.12	0.95;
	2233	2	0.8	0.3	0	0	1	1.03826	-25.30124	110	4	1.12	0.95;
	2234	1	0.7	0.3	0	0	1	1.03801	-25.32972	110	4	1.12	0.95;
	2235	1	21.6	5.2	0	0	1	1.06862	-28.23282	110	4	1.12	0.95;
	2236	2	13.3	-0.1	0	0	1	1.06718	-28.94507	110	4	1.12	0.95;
	2237	1	11	7.1	0	0	1	1.06723	-28.96403	110	4	1.12	0.95;
	2238	2	3.8	-2.6	0	0	1	1.05968	-24.43332	110	4	1.12	0.95;
	2239	2	3	5	0	0	1	1.06525	-23.04301	110	4	1.12	0.95;
	2240	2	0	0	0	0	1	1.06381	-24.01306	110	4	1.12	0.95;
	2241	1	23.3	7.6	0	0	1	1.02351	-26.00616	110	4	1.12	0.95;
	2242	1	13.8	1.2	0	0	1	1.06035	-24.27517	110	4	1.12	0.95;
	2243	1	12.9	1.4	0	0	1	1.06037	-24.26938	110	4	1.12	0.95;
	2244	1	9.7	1.8	0	0	1	1.06978	-17.44807	110	4	1.12	0.95;
	2245	1	25.6	5.2	0	0	1	1.02261	-29.75573	110	4	1.12	0.95;
	2246	1	3.3	0.4	0	0	1	1.07552	-15.40805	110	4	1.12	0.95;
	2247	1	13.2	7.3	0	0	1	1.08308	-22.36535	110	4	1.12	0.95;
	2248	1	4.5	0	0	0	1	1.06829	-13.9401	110	4	1.12	0.95;
	2249	1	0	0	0	0	1	1.06829	-13.9401	110	4	1.12	0.95;
	2250	1	17.2	1.2	0	0	1	1.06087	-23.6405	110	4	1.12	0.95;
	2251	1	0	0	0	0	1	1.06087	-23.6405	110	4	1.12	0.95;
	2252	1	12.3	1.2	0	0	1	1.06155	-23.58531	110	4	1.12	0.95;
	2253	2	29.6	11.5	0	0	1	1.03233	-25.00522	110	4	1.12	0.95;
	2254	1	8	-0.5	0	0	1	1.03934	-22.64436	110	4	1.12	0.95;
	2255	1	22.2	4	0	0	1	1.0322	-25.52368	110	4	1.12	0.95;
	2256	1	5.3	1.3	0	0	1	1.06229	-24.12298	110	4	1.12	0.95;
	2257	1	8.1	0.6	0	0	1	1.02062	-26.8376	110	4	1.12	0.95;
	2258	1	2.3	0.5	0	0	1	1.07512	-17.68848	110	4	1.12	0.95;
	2259	1	3	0.4	0	0	1	1.07514	-17.70768	110	4	1.12	0.95;
	2260	1	6	-0.7	0	0	1	1.0332	-27.73649	110	4	1.12	0.95;
	2261	2	6.4	1.3	0	0	1	1.0575	-20.18392	110	4	1.12	0.95;
	2262	1	6.5	3.1	0	0	1	1.06476	-20.07875	110	4	1.12	0.95;
	2263	1	30.6	9.1	0	0	1	1.05434	-20.49737	110	4	1.12	0.95;
	2264	1	36	11.9	0	0	1	1.06194	-20.71399	110	4	1.12	0.95;
	2265	2	10.5	3.2	0	0	1	1.06385	-15.58991	110	4	1.12	0.95;
	2266	1	6.9	4	0	0	1	1.0636	-15.61104	110	4	1.12	0.95;
	2267	2	102.5	76.4	0	0	1	1.09194	-17.08334	110	4	1.12	0.95;
	2268	1	0	0	0	0	1	1.09194	-17.08334	110	4	1.12	0.95;
	2269	1	3.3	3.5	0	0	1	1.11141	-14.24103	110	4	1.12	0.95;
	2270	1	7.4	3.9	0	0	1	1.08652	-14.70094	110	4	1.12	0.95;
	2271	1	9.3	5.8	0	0	1	1.06312	-28.55679	110	4	1.12	0.95;
	2272	1	8.9	2.3	0	0	1	1.07122	-13.92881	110	4	1.12	0.95;
	2273	2	5.5	0	0	0	1	1.0712	-13.92807	110	4	1.12	0.95;
	2274	1	12.9	1	0	0	1	1.00298	-24.71796	110	4	1.12	0.95;
	2275	1	15.7	1.3	0	0	1	1.06468	-23.13533	110	4	1.12	0.95;
	2276	1	12.1	6.3	0	0	1	1.0573	-15.17538	110	4	1.12	0.95;
	2277	1	0	0	0	0	1	1.0573	-15.17538	110	4	1.12	0.95;
	2278	1	7.4	0	0	0	1	1.07524	-28.65093	110	4	1.12	0.95;
	2279	1	13.3	3	0	0	1	1.07804	-12.36288	110	4	1.12	0.95;
	2280	1	24.9	10	0	0	1	1.07348	-28.73811	110	4	1.12	0.95;
	2281	1	9.3	0.2	0	0	1	1.11885	-19.95357	110	4	1.12	0.95;
	2282	2	21.6	4.2	0	0	1	1.03877	-20.05892	110	4	1.12	0.95;
	2283	1	13.5	2	0	0	1	1.04012	-20.021	110	4	1.12	0.95;
	2284	2	1.8	-1.1	0	0	1	1.07915	-33.37633	110	4	1.12	0.95;
	2285	1	9.4	3.8	0	0	1	1.11372	-11.74901	110	4	1.12	0.95;
	2286	2	17.3	3.4	0	0	1	1.05861	-15.41062	110	4	1.12	0.95;
	2287	1	9.1	1.3	0	0	1	1.07976	-12.14855	110	4	1.12	0.95;
	2288	1	8.7	2.1	0	0	1	1.0813	-11.82441	110	4	1.12	0.95;
	2289	1	17.6	5	0	0	1	1.05337	-17.75896	110	4	1.12	0.95;
	2290	2	7.1	-2	0	0	1	1.07283	-13.16965	110	4	1.12	0.95;
	2291	2	29.2	13.9	0	0	1	1.05595	-17.336	110	4	1.12	0.95;
	2292	1	0	0	0	0	1	1.07481	-16.52338	110	4	1.12	0.95;
	2293	2	31.7	1.7	0	0	1	1.0498	-18.69456	110	4	1.12	0.95;
	2294	1	22.9	8	0	0	1	1.11715	-19.97984	110	4	1.12	0.95;
	2295	2	22.6	5.2	0	0	1	1.05738	-28.11879	110	4	1.12	0.95;
	2296	1	13.4	3.6	0	0	1	1.09657	-22.64447	110	4	1.12	0.95;
	2297	1	0	0	0	0	1	1.11641	-16.38944	110	4	1.12	0.95;
	2298	1	7.9	2.1	0	0	1	1.06038	-14.62476	110	4	1.12	0.95;
	2299	2	9.2	4.2	0	0	1	1.06035	-14.6282	110	4	1.12	0.95;
	2300	1	28.5	13.6	0	0	1	1.06619	-29.69537	110	4	1.12	0.95;
	2301	1	9.7	1.2	0	0	1	1.06648	-17.84711	110	4	1.12	0.95;
	2302	1	20.6	6.2	0	0	1	1.05516	-8.31752	110	4	1.12	0.95;
	2303	1	7.2	-1.7	0	0	1	1.01947	-23.70189	110	4	1.12	0.95;
	2304	1	0	0	0	0	1	1.10683	-14.38403	110	4	1.12	0.95;
	2305	1	0	0	0	0	1	1.08116	-14.75828	110	4	1.12	0.95;
	2306	2	8.3	3.8	0	0	1	1.05321	-18.88673	110	4	1.12	0.95;
	2307	1	19.6	8.9	0	0	1	1.04508	-18.61101	110	4	1.12	0.95;
	2308	1	9.3	3.9	0	0	1	1.06163	-17.63086	110	4	1.12	0.95;
	2309	1	8.5	3	0	0	1	1.06193	-16.7522	110	4	1.12	0.95;
	2310	1	7.3	1.1	0	0	1	1.09535	-13.75798	110	4	1.12	0.95;
	2311	1	5.2	1	0	0	1	1.05701	-18.54316	110	4	1.12	0.95;
	2312	1	2.8	0.4	0	0	1	1.05359	-18.90593	110	4	1.12	0.95;
	2313	1	5.7	1.3	0	0	1	1.03598	-20.24047	110	4	1.12	0.95;
	2314	1	5.7	1.3	0	0	1	1.03596	-20.24135	110	4	1.12	0.95;
	2315	1	8.7	-0.7	0	0	1	1.01301	-26.71627	110	4	1.12	0.95;
	2316	2	13.4	8	0	0	1	1.06261	-21.25643	110	4	1.12	0.95;
	2317	1	11.2	0	0	0	1	1.1164	-16.39015	110	4	1.12	0.95;
	2318	1	14.3	4.1	0	0	1	1.10435	-12.75257	110	4	1.12	0.95;
	2319	2	4	5.2	0	0	1	1.09487	-16.78725	110	4	1.12	0.95;
	2320	2	2	3	0	0	1	1.12	-19.77198	110	4	1.12	0.95;
	2321	1	0	0	0	0	1	1.09259	-16.9971	110	4	1.12	0.95;
	2322	2	3	6	0	0	1	1.08997	-12.71398	110	4	1.12	0.95;
	2323	1	4.7	1.5	0	0	1	1.0436	-19.45689	110	4	1.12	0.95;
	2324	1	12.2	2.1	0	0	1	1.07469	-12.56044	110	4	1.12	0.95;
	2325	2	11.7	6.7	0	0	1	1.05009	-18.32017	110	4	1.12	0.95;
	2326	1	0	0	0	0	1	1.05042	-18.32491	110	4	1.12	0.95;
	2327	1	30.9	16.3	0	0	1	1.05623	-18.5498	110	4	1.12	0.95;
	2328	1	11.3	7.5	0	0	1	1.05689	-18.57717	110	4	1.12	0.95;
	2329	1	6.6	1.8	0	0	1	1.09632	-13.63861	110	4	1.12	0.95;
	2330	1	3.1	1.6	0	0	1	1.05579	-18.92152	110	4	1.12	0.95;
	2331	1	3.8	1.1	0	0	1	1.05576	-18.90328	110	4	1.12	0.95;
	2332	1	0	0	0	0	1	1.0941	-21.50094	110	4	1.12	0.95;
	2333	1	0.8	0.3	0	0	1	1.05609	-17.42939	110	4	1.12	0.95;
	2334	1	0	0	0	0	1	1.09933	-10.68003	110	4	1.12	0.95;
	2335	1	0	0	0	0	1	1.09931	-10.6654	110	4	1.12	0.95;
	2336	1	48.4	22.2	0	0	1	1.04947	-18.28234	110	4	1.12	0.95;
	2337	1	40.8	23.2	0	0	1	1.05526	-18.60905	110	4	1.12	0.95;
	2338	1	3.4	1.4	0	0	1	1.0489	-18.91507	110	4	1.12	0.95;
	2339	1	3.2	1.4	0	0	1	1.06271	-17.68579	110	4	1.12	0.95;
	2340	1	0	0	0	0	1	1.0628	-17.64732	110	4	1.12	0.95;
	2341	1	9.6	2.3	0	0	1	1.05183	-19.90992	110	4	1.12	0.95;
	2342	1	5.1	3.2	0	0	1	1.05301	-17.79704	110	4	1.12	0.95;
	2343	1	3.8	6.2	0	0	1	1.05001	-18.50279	110	4	1.12	0.95;
	2344	1	3.8	3.2	0	0	1	1.05729	-18.51387	110	4	1.12	0.95;
	2345	1	1	0.6	0	0	1	1.05552	-19.9477	110	4	1.12	0.95;
	2346	1	2	0.9	0	0	1	1.05559	-19.96135	110	4	1.12	0.95;
	2347	1	6.4	2.2	0	0	1	1.10703	-12.17181	110	4	1.12	0.95;
	2348	1	9.7	0	0	0	1	1.06181	-19.76331	110	4	1.12	0.95;
	2349	1	9.7	0	0	0	1	1.05526	-20.0221	110	4	1.12	0.95;
	2350	2	50.4	17.7	0	0	1	1.01775	-27.09576	110	4	1.12	0.95;
	2351	1	8.9	4.7	0	0	1	1.05825	-19.23937	110	4	1.12	0.95;
	2352	1	3.1	2.2	0	0	1	1.05839	-19.25476	110	4	1.12	0.95;
	2353	1	6.8	1.3	0	0	1	1.05539	-19.38994	110	4	1.12	0.95;
	2354	1	3.9	0.4	0	0	1	1.05	-18.38847	110	4	1.12	0.95;
	2355	2	8	1.2	0	0	1	1.03548	-20.66326	110	4	1.12	0.95;
	2356	1	40	11.4	0	0	1	1.03585	-20.12717	110	4	1.12	0.95;
	2357	1	23.6	4.2	0	0	1	1.0717	-29.12552	110	4	1.12	0.95;
	2358	1	14.2	3.1	0	0	1	1.03725	-20.04383	110	4	1.12	0.95;
	2359	1	0	0	0	0	1	1.05487	-15.03459	110	4	1.12	0.95;
	2360	1	4.9	0.7	0	0	1	1.05487	-15.03459	110	4	1.12	0.95;
	2361	1	4.5	2	0	0	1	1.08143	-14.80969	110	4	1.12	0.95;
	2362	1	0	0	0	0	1	1.06403	-17.39032	110	4	1.12	0.95;
	2363	1	7.1	3.7	0	0	1	1.05274	-16.07161	110	4	1.12	0.95;
	2364	1	7.2	3.7	0	0	1	1.1035	-14.49731	110	4	1.12	0.95;
	2365	1	7.7	0.6	0	0	1	1.10246	-12.96845	110	4	1.12	0.95;
	2366	1	0	0	0	0	1	1.08093	-13.52915	110	4	1.12	0.95;
	2367	1	5.1	0.3	0	0	1	1.08093	-13.52915	110	4	1.12	0.95;
	2368	1	7.3	0.2	0	0	1	1.03336	-29.15411	110	4	1.12	0.95;
	2369	1	13.7	4	0	0	1	1.04837	-18.82166	110	4	1.12	0.95;
	2370	1	9	4.4	0	0	1	1.07412	-16.55839	110	4	1.12	0.95;
	2371	1	9.4	3.6	0	0	1	1.03705	-25.33617	110	4	1.12	0.95;
	2372	2	13.7	3.9	0	0	1	1.10563	-9.25555	110	4	1.12	0.95;
	2373	1	1.9	0.1	0	0	1	1.0727	-13.19881	110	4	1.12	0.95;
	2374	1	6	0	0	0	1	1.0913	-18.99535	110	4	1.12	0.95;
	2375	1	5.3	3.3	0	0	1	1.06798	-14.01703	110	4	1.12	0.95;
	2376	1	0	0	0	0	1	1.06798	-14.01703	110	4	1.12	0.95;
	2377	1	42.3	7.9	0	0	1	1.05654	-26.13025	110	4	1.12	0.95;
	2378	1	0	0	0	0	1	1.05654	-26.13025	110	4	1.12	0.95;
	2379	1	0	0	0	0	1	1.05654	-26.13025	110	4	1.12	0.95;
	2380	1	15.8	1.1	0	0	1	1.06697	-15.89176	110	4	1.12	0.95;
	2381	1	6.7	0.7	0	0	1	1.06597	-15.69819	110	4	1.12	0.95;
	2382	1	15.1	2.1	0	0	1	1.06615	-15.8136	110	4	1.12	0.95;
	2383	1	12.5	1.9	0	0	1	1.06475	-15.78787	110	4	1.12	0.95;
	2384	1	23	3	0	0	1	1.05229	-26.47109	110	4	1.12	0.95;
	2385	1	5.9	0.1	0	0	1	1.05306	-24.21542	110	4	1.12	0.95;
	2386	1	0	0	0	0	1	1.07276	-20.64608	110	4	1.12	0.95;
	2387	1	0	0	0	0	1	1.06816	-20.68441	110	4	1.12	0.95;
	2388	1	18.5	9.2	0	0	1	1.07818	-28.59874	110	4	1.12	0.95;
	2389	1	2	0.4	0	0	1	1.04947	-19.55565	110	4	1.12	0.95;
	2390	1	10.1	-1.7	0	0	1	1.05037	-25.20298	110	4	1.12	0.95;
	2391	1	5.3	0.5	0	0	1	1.0636	-23.03731	110	4	1.12	0.95;
	2392	1	13.3	-1.2	0	0	1	1.06316	-21.56215	110	4	1.12	0.95;
	2393	1	5.8	1	0	0	1	1.10096	-10.17649	110	4	1.12	0.95;
	2394	1	10.4	1.3	0	0	1	1.07275	-13.14314	110	4	1.12	0.95;
	2395	1	5	-0.3	0	0	1	1.03983	-25.87507	110	4	1.12	0.95;
	2396	1	7.9	4	0	0	1	1.06981	-13.60475	110	4	1.12	0.95;
	2397	1	7.5	1.4	0	0	1	1.04725	-27.81254	110	4	1.12	0.95;
	2398	1	7.6	2.4	0	0	1	1.03611	-25.52488	110	4	1.12	0.95;
	2399	1	1.4	0.8	0	0	1	1.026	-25.90735	110	4	1.12	0.95;
	2400	1	6.3	0.2	0	0	1	1.04579	-29.31472	110	4	1.12	0.95;
	2401	1	14.5	0.3	0	0	1	1.05374	-27.35604	110	4	1.12	0.95;
	2402	1	3.3	0.5	0	0	1	1.07427	-12.89967	110	4	1.12	0.95;
	2403	1	3.4	0.9	0	0	1	1.11734	-8.0327	110	4	1.12	0.95;
	2404	1	3.4	0.9	0	0	1	1.12	-7.10908	110	4	1.12	0.95;
	2405	1	8.5	1.9	0	0	1	1.05831	-34.89046	110	4	1.12	0.95;
	2406	1	2.7	0.4	0	0	1	1.10958	-29.4701	110	4	1.12	0.95;
	2407	1	15.4	9.6	0	0	1	1.04887	-18.22631	110	4	1.12	0.95;
	2408	1	0	0	0	0	1	1.07796	-29.16	110	4	1.12	0.95;
	2409	1	11.4	3.3	0	0	1	1.08158	-15.81364	110	4	1.12	0.95;
	2410	2	1.9	1.4	0	0	1	1.05713	-15.17155	110	4	1.12	0.95;
	2411	2	11.8	4	0	0	1	1.05411	-23.98767	110	4	1.12	0.95;
	2412	1	13.6	6	0	0	1	1.04904	-25.1408	110	4	1.12	0.95;
	2413	1	15.1	0.9	0	0	1	1.06935	-28.71109	110	4	1.12	0.95;
	2414	1	3.7	-0.6	0	0	1	1.04736	-24.71208	110	4	1.12	0.95;
	2415	1	7.3	-0.3	0	0	1	1.05027	-24.68727	110	4	1.12	0.95;
	2416	1	4.7	0.1	0	0	1	1.02669	-25.98308	110	4	1.12	0.95;
	2417	1	10	5.1	0	0	1	1.08813	-28.59626	110	4	1.12	0.95;
	2418	1	6.2	1.6	0	0	1	1.08191	-28.87595	110	4	1.12	0.95;
	2419	1	12.1	6.2	0	0	1	1.07661	-28.84657	110	4	1.12	0.95;
	2420	1	16.3	6.8	0	0	1	1.08483	-28.73435	110	4	1.12	0.95;
	2421	1	10	3	0	0	1	1.0872	-17.34249	110	4	1.12	0.95;
	2422	1	7.1	-0.6	0	0	1	1.06844	-27.99253	110	4	1.12	0.95;
	2423	1	5.7	2.3	0	0	1	1.06994	-20.86496	110	4	1.12	0.95;
	2424	1	4.1	2.2	0	0	1	0.98227	-28.56317	110	4	1.12	0.95;
	2425	1	15.1	5.5	0	0	1	1.03472	-25.45559	110	4	1.12	0.95;
	2426	1	9	-1	0	0	1	1.02888	-22.77962	110	4	1.12	0.95;
	2427	1	19.9	8.7	0	0	1	1.00303	-29.36176	110	4	1.12	0.95;
	2428	1	19.6	-1.4	0	0	1	1.0252	-23.15131	110	4	1.12	0.95;
	2429	1	17.5	5	0	0	1	1.09524	-16.14151	110	4	1.12	0.95;
	2430	1	10.2	2	0	0	1	1.03514	-26.04433	110	4	1.12	0.95;
	2431	1	9.4	0.2	0	0	1	1.06925	-14.23565	110	4	1.12	0.95;
	2432	1	9.9	2.1	0	0	1	1.06919	-14.23925	110	4	1.12	0.95;
	2433	1	16.7	0.1	0	0	1	1.07133	-30.64273	110	4	1.12	0.95;
	2434	1	10	6.2	0	0	1	1.08661	-13.97102	110	4	1.12	0.95;
	2435	1	10.6	6.8	0	0	1	1.07382	-16.66252	110	4	1.12	0.95;
	2436	2	2.8	-1.2	0	0	1	1.07973	-33.43176	110	4	1.12	0.95;
	2437	2	26.2	16.2	0	0	1	1.06232	-14.94326	110	4	1.12	0.95;
	2438	1	23.4	5	0	0	1	1.07864	-16.16235	110	4	1.12	0.95;
	2439	2	1.6	1.6	0	0	1	1.03467	-29.36883	110	4	1.12	0.95;
	2440	2	11.7	9.2	0	0	1	1.07789	-16.34396	110	4	1.12	0.95;
	2441	1	7.7	1.8	0	0	1	1.07262	-16.60267	110	4	1.12	0.95;
	2442	2	29.6	14.3	0	0	1	1.07426	-16.50453	110	4	1.12	0.95;
	2443	1	0	0	0	0	1	1.07923	-16.2704	110	4	1.12	0.95;
	2444	1	0	0	0	0	1	1.07888	-16.32291	110	4	1.12	0.95;
	2445	1	0	0	0	0	1	0.94198	-16.56062	16	4	1.25	0.75;
	2446	1	17.2	2.3	0	0	1	1.06627	-17.89462	110	4	1.12	0.95;
	2447	1	0	0	0	0	1	1.09316	-13.45691	110	4	1.12	0.95;
	2448	1	0	0	0	0	1	1.09324	-14.66839	110	4	1.12	0.95;
	2449	2	17.3	30.7	0	0	1	1.12	-16.03961	110	4	1.12	0.95;
	2450	2	16.6	30.6	0	0	1	1.12	-19.85273	110	4	1.12	0.95;
	2451	1	1.4	0.1	0	0	1	1.06403	-15.60071	110	4	1.12	0.95;
	2452	1	3.2	0.9	0	0	1	1.06416	-15.59322	110	4	1.12	0.95;
	2453	1	2.6	0.3	0	0	1	1.08167	-11.81965	110	4	1.12	0.95;
	2454	1	3.9	0.5	0	0	1	1.08173	-11.8143	110	4	1.12	0.95;
	2455	1	14.8	4.1	0	0	1	1.08469	-17.33098	110	4	1.12	0.95;
	2456	1	5.2	5.4	0	0	1	1.06874	-13.75209	110	4	1.12	0.95;
	2457	1	6.6	4.2	0	0	1	1.0687	-13.75467	110	4	1.12	0.95;
	2458	1	10.7	2.4	0	0	1	1.03112	-22.89643	110	4	1.12	0.95;
	2459	1	17.6	-1.8	0	0	1	1.1109	-14.27001	110	4	1.12	0.95;
	2460	1	6.6	-1.1	0	0	1	1.11081	-14.27901	110	4	1.12	0.95;
	2461	1	13.7	8.1	0	0	1	1.08579	-28.72019	110	4	1.12	0.95;
	2462	2	17.3	-0.4	0	0	1	1.07148	-29.21282	110	4	1.12	0.95;
	2463	2	21	-1.2	0	0	1	1.08265	-32.87579	110	4	1.12	0.95;
	2464	1	11.5	0.7	0	0	1	1.06862	-13.86349	110	4	1.12	0.95;
	2465	1	0	0	0	0	1	1.06862	-13.86349	110	4	1.12	0.95;
	2466	1	18.9	-3.6	0	0	1	1.08418	-32.70278	110	4	1.12	0.95;
	2467	1	20.8	7	0	0	1	1.08048	-28.90455	110	4	1.12	0.95;
	2468	1	0	0	0	0	1	1.08568	-31.94864	110	4	1.12	0.95;
	2469	1	0	0	0	0	1	1.08913	-32.02269	110	4	1.12	0.95;
	2470	2	25	11.6	0	0	1	1.01532	-22.65319	110	4	1.12	0.95;
	2471	1	22.4	7.1	0	0	1	1.01533	-22.65736	110	4	1.12	0.95;
	2472	1	0	0	0	0	1	1.0774	-28.35761	110	4	1.12	0.95;
	2473	1	0	0	0	0	1	1.07923	-27.96491	110	4	1.12	0.95;
	2474	1	3.7	0.2	0	0	1	1.05767	-18.50084	110	4	1.12	0.95;
	2475	1	2.5	0.2	0	0	1	1.05042	-18.32527	110	4	1.12	0.95;
	2476	1	6.6	-2.1	0	0	1	1.0643	-21.34831	110	4	1.12	0.95;
	2477	1	12.7	3.1	0	0	1	1.05749	-18.65971	110	4	1.12	0.95;
	2478	1	3.6	0.3	0	0	1	1.04292	-21.77149	110	4	1.12	0.95;
	2479	1	20.8	6.7	0	0	1	1.0261	-25.92507	110	4	1.12	0.95;
	2480	1	15.1	2.2	0	0	1	1.04221	-24.97674	110	4	1.12	0.95;
	2481	1	17.3	1.8	0	0	1	1.0476	-30.30688	110	4	1.12	0.95;
	2482	1	0	0	0	0	1	1.0476	-30.30688	110	4	1.12	0.95;
	2483	1	6.5	1	0	0	1	1.10686	-9.35934	110	4	1.12	0.95;
	2484	1	6.3	0.6	0	0	1	1.07609	-28.92261	110	4	1.12	0.95;
	2485	1	27.4	11.5	0	0	1	1.08208	-28.86354	110	4	1.12	0.95;
	2486	1	0	0	0	0	1	1.05042	-18.32488	110	4	1.12	0.95;
	2487	1	0	0	0	0	1	1.05767	-18.50009	110	4	1.12	0.95;
	2488	2	12	14.1	0	0	1	1.0376	-25.08824	110	4	1.12	0.95;
	2489	2	12.7	8.3	0	0	1	1.03753	-25.1032	110	4	1.12	0.95;
	2490	1	12.5	-1.7	0	0	1	1.07796	-29.16	110	4	1.12	0.95;
	2491	1	19.2	5.6	0	0	1	1.08117	-28.87565	110	4	1.12	0.95;
	2492	1	8.5	-0.7	0	0	1	1.08116	-28.6277	110	4	1.12	0.95;
	2493	1	9.9	-0.8	0	0	1	1.0809	-28.64101	110	4	1.12	0.95;
	2494	1	26.6	5	0	0	1	1.08246	-32.8659	110	4	1.12	0.95;
	2495	1	15.5	3.6	0	0	1	1.07532	-28.63733	110	4	1.12	0.95;
	2496	1	16	4.9	0	0	1	1.0783	-28.61237	110	4	1.12	0.95;
	2497	2	6.4	0.4	0	0	1	1.07102	-16.20789	110	4	1.12	0.95;
	2498	1	12.7	0.7	0	0	1	1.07094	-16.24073	110	4	1.12	0.95;
	2499	1	4.3	1.3	0	0	1	1.08104	-15.15823	110	4	1.12	0.95;
	2500	2	35.5	12.4	0	0	1	1.08783	-13.93196	110	4	1.12	0.95;
	2501	1	28.6	-0.4	0	0	1	1.07807	-29.06027	110	4	1.12	0.95;
	2502	1	7.6	1	0	0	1	1.07085	-14.63977	110	4	1.12	0.95;
	2503	1	17.8	2.3	0	0	1	1.05034	-18.74778	110	4	1.12	0.95;
	2504	1	10.4	4.3	0	0	1	1.088	-15.38104	110	4	1.12	0.95;
	2505	1	11	4.6	0	0	1	1.08309	-15.61617	110	4	1.12	0.95;
	2506	2	3.3	2	0	0	1	1.08055	-13.43991	110	4	1.12	0.95;
	2507	1	9.1	4.9	0	0	1	1.04569	-24.63607	110	4	1.12	0.95;
	2508	2	8.5	4.4	0	0	1	1.02067	-27.93873	110	4	1.12	0.95;
	2509	1	15.4	5.4	0	0	1	1.02061	-27.94552	110	4	1.12	0.95;
	2510	1	5	1.1	0	0	1	1.09958	-10.55097	110	4	1.12	0.95;
	2511	1	4.5	1.9	0	0	1	1.07402	-17.78738	110	4	1.12	0.95;
	2512	2	0	0	0	0	1	1.02788	-25.79943	110	4	1.12	0.95;
	2513	2	7.9	3.8	0	0	1	1.02788	-25.7998	110	4	1.12	0.95;
	2514	1	15.1	-1.5	0	0	1	1.06929	-31.23603	110	4	1.12	0.95;
	2515	2	48.2	28.1	0	0	1	1.06303	-15.14004	110	4	1.12	0.95;
	2516	1	0	0	0	0	1	1.06322	-15.12417	110	4	1.12	0.95;
	2517	1	3.4	0	0	0	1	1.07093	-13.79243	110	4	1.12	0.95;
	2518	1	4.9	-0.1	0	0	1	1.03385	-24.93511	110	4	1.12	0.95;
	2519	1	12	-0.2	0	0	1	1.02626	-26.33685	110	4	1.12	0.95;
	2520	1	12	-2.1	0	0	1	1.02747	-25.38518	110	4	1.12	0.95;
	2521	1	9.7	-0.6	0	0	1	1.02142	-25.98736	110	4	1.12	0.95;
	2522	1	8.6	1.2	0	0	1	1.06941	-14.16335	110	4	1.12	0.95;
	2523	1	7.4	0.4	0	0	1	1.08329	-15.48899	110	4	1.12	0.95;
	2524	1	2.3	0.3	0	0	1	1.08327	-15.48898	110	4	1.12	0.95;
	2525	1	11.5	1.4	0	0	1	1.06699	-14.18432	110	4	1.12	0.95;
	2526	1	0	0	0	0	1	1.06699	-14.18432	110	4	1.12	0.95;
	2527	1	9.1	-2.4	0	0	1	1.05993	-30.32384	110	4	1.12	0.95;
	2528	1	11.4	9.2	0	0	1	1.06667	-28.36916	110	4	1.12	0.95;
	2529	1	9.2	0.3	0	0	1	1.03536	-25.63093	110	4	1.12	0.95;
	2530	1	11.4	-0.2	0	0	1	1.0376	-25.36624	110	4	1.12	0.95;
	2531	2	3.3	0.2	0	0	1	1.08153	-11.84052	110	4	1.12	0.95;
	2532	2	5.9	0.3	0	0	1	1.0578	-25.5292	110	4	1.12	0.95;
	2533	1	3.4	0	0	0	1	1.06584	-14.40001	110	4	1.12	0.95;
	2534	2	3.2	0.9	0	0	1	1.09285	-17.95422	110	4	1.12	0.95;
	2535	1	24.5	10.8	0	0	1	1.03871	-22.13249	110	4	1.12	0.95;
	2536	1	20.9	1.1	0	0	1	1.07547	-14.68114	110	4	1.12	0.95;
	2537	1	7.8	1.7	0	0	1	1.07078	-13.91151	110	4	1.12	0.95;
	2538	1	12.4	3.5	0	0	1	1.03738	-21.72684	110	4	1.12	0.95;
	2539	1	11.1	5.4	0	0	1	1.05474	-27.47774	110	4	1.12	0.95;
	2540	2	25.1	4.7	0	0	1	1.04534	-31.52746	110	4	1.12	0.95;
	2541	1	16.5	4.9	0	0	1	1.07682	-24.66293	110	4	1.12	0.95;
	2542	2	25.2	10.7	0	0	1	1.03175	-27.83891	110	4	1.12	0.95;
	2543	1	14.7	0	0	0	1	1.04428	-30.06591	110	4	1.12	0.95;
	2544	2	20	9.1	0	0	1	1.03511	-28.03415	110	4	1.12	0.95;
	2545	1	18.2	-1	0	0	1	1.08014	-15.50811	110	4	1.12	0.95;
	2546	1	3.6	0.5	0	0	1	1.07388	-16.73434	110	4	1.12	0.95;
	2547	1	6.2	4.3	0	0	1	1.06406	-17.18902	110	4	1.12	0.95;
	2548	1	5	2.2	0	0	1	1.07452	-15.80025	110	4	1.12	0.95;
	2549	1	22.9	1.7	0	0	1	1.06189	-14.65516	110	4	1.12	0.95;
	2550	1	0	0	0	0	1	1.06189	-14.65516	110	4	1.12	0.95;
	2551	1	11.1	0.3	0	0	1	1.05257	-26.7191	110	4	1.12	0.95;
	2552	1	1.7	0.4	0	0	1	1.10156	-9.78696	110	4	1.12	0.95;
	2553	1	10.1	0.8	0	0	1	1.06293	-22.67865	110	4	1.12	0.95;
	2554	1	31	11.8	0	0	1	1.07663	-28.80758	110	4	1.12	0.95;
	2555	1	8.7	3.4	0	0	1	0.99601	-28.38739	110	4	1.12	0.95;
	2556	1	12.7	4.4	0	0	1	1.07102	-13.79131	110	4	1.12	0.95;
	2557	2	0	0	0	0	1	1.08268	-13.1626	110	4	1.12	0.95;
	2558	1	17.9	4.4	0	0	1	1.01649	-26.98352	110	4	1.12	0.95;
	2559	1	0	0	0	0	1	1.02655	-25.99904	110	4	1.12	0.95;
	2560	1	6.7	2.6	0	0	1	1.08742	-15.27556	110	4	1.12	0.95;
	2561	1	1.1	0.5	0	0	1	1.02653	-25.99862	110	4	1.12	0.95;
	2562	2	15.7	6.4	0	0	1	1.03812	-26.31107	110	4	1.12	0.95;
	2563	2	7.6	1.9	0	0	1	1.05986	-18.33326	110	4	1.12	0.95;
	2564	1	10.7	2.9	0	0	1	1.06972	-17.31163	110	4	1.12	0.95;
	2565	2	13.1	8.1	0	0	1	1.0398	-24.97981	110	4	1.12	0.95;
	2566	1	9.4	1.2	0	0	1	1.02919	-22.83917	110	4	1.12	0.95;
	2567	1	8.5	5	0	0	1	1.03631	-25.38834	110	4	1.12	0.95;
	2568	2	7.5	-0.2	0	0	1	0.98435	-28.42469	110	4	1.12	0.95;
	2569	1	32.2	8.1	0	0	1	1.05236	-30.97864	110	4	1.12	0.95;
	2570	1	14.8	7.5	0	0	1	1.0802	-15.91517	110	4	1.12	0.95;
	2571	1	15.7	5.1	0	0	1	1.1164	-11.84944	110	4	1.12	0.95;
	2572	1	14.2	-1.1	0	0	1	1.06557	-32.76254	110	4	1.12	0.95;
	2573	1	9.1	2.5	0	0	1	1.11886	-7.6738	110	4	1.12	0.95;
	2574	1	2.6	0.9	0	0	1	1.11729	-7.76969	110	4	1.12	0.95;
	2575	1	2.7	1	0	0	1	1.11671	-7.80294	110	4	1.12	0.95;
	2576	1	17.1	7.9	0	0	1	1.11744	-7.75912	110	4	1.12	0.95;
	2577	1	26.2	12.1	0	0	1	1.11691	-7.79036	110	4	1.12	0.95;
	2578	1	8.7	2.1	0	0	1	1.11608	-7.88825	110	4	1.12	0.95;
	2579	1	6.2	1	0	0	1	1.1161	-7.88705	110	4	1.12	0.95;
	2580	2	20.4	34	0	0	1	1.11945	-7.64642	110	4	1.12	0.95;
	2581	1	9.1	4.9	0	0	1	1.11939	-7.64057	110	4	1.12	0.95;
	2582	1	39.6	12.8	0	0	1	1.03429	-25.44079	110	4	1.12	0.95;
	2583	1	12.7	1	0	0	1	1.07455	-16.71614	110	4	1.12	0.95;
	2584	1	3.3	0.6	0	0	1	1.0763	-13.93505	110	4	1.12	0.95;
	2585	1	19.7	9.6	0	0	1	1.06716	-13.95545	110	4	1.12	0.95;
	2586	1	4.8	1.7	0	0	1	1.06717	-13.95423	110	4	1.12	0.95;
	2587	1	26.6	6.5	0	0	1	1.06743	-31.44666	110	4	1.12	0.95;
	2588	1	10.9	7.2	0	0	1	1.09714	-16.90233	110	4	1.12	0.95;
	2589	1	5	1.6	0	0	1	1.09773	-16.87872	110	4	1.12	0.95;
	2590	1	29.7	10.3	0	0	1	1.07962	-28.86929	110	4	1.12	0.95;
	2591	1	3.2	-0.3	0	0	1	1.08311	-22.61966	110	4	1.12	0.95;
	2592	2	34.3	33	0	0	1	1.11589	-13.97005	110	4	1.12	0.95;
	2593	2	37.9	31.9	0	0	1	1.0917	-14.60013	110	4	1.12	0.95;
	2594	1	4.8	2.1	0	0	1	1.10666	-13.60921	110	4	1.12	0.95;
	2595	1	3.7	-0.8	0	0	1	1.04331	-26.28145	110	4	1.12	0.95;
	2596	1	0	0	0	0	1	1.07163	-13.62215	110	4	1.12	0.95;
	2597	1	-7.3	-0.6	0	0	1	1.07163	-13.62215	110	4	1.12	0.95;
	2598	2	6.5	1	0	0	1	1.08212	-11.76401	110	4	1.12	0.95;
	2599	1	11.3	1.7	0	0	1	1.08201	-11.79523	110	4	1.12	0.95;
	2600	1	6.1	1.9	0	0	1	1.07756	-26.2581	110	4	1.12	0.95;
	2601	1	1.9	0.3	0	0	1	1.10087	-10.04571	110	4	1.12	0.95;
	2602	1	0	0	0	0	1	1.10205	-9.73997	110	4	1.12	0.95;
	2603	1	22.5	-1.3	0	0	1	1.06518	-34.42409	110	4	1.12	0.95;
	2604	2	11.8	1.8	0	0	1	1.08652	-15.22982	110	4	1.12	0.95;
	2605	1	0	0	0	0	1	1.08652	-15.22982	110	4	1.12	0.95;
	2606	1	9.7	5.9	0	0	1	1.0963	-13.89286	110	4	1.12	0.95;
	2607	1	12.7	2.9	0	0	1	1.09158	-14.71639	110	4	1.12	0.95;
	2608	2	5.8	1.1	0	0	1	1.08183	-15.16891	110	4	1.12	0.95;
	2609	1	12.6	3.7	0	0	1	1.08195	-15.16286	110	4	1.12	0.95;
	2610	1	22.6	4.6	0	0	1	1.04488	-31.36831	110	4	1.12	0.95;
	2611	2	17.8	4.6	0	0	1	1.07974	-15.34962	110	4	1.12	0.95;
	2612	1	15.9	5.7	0	0	1	1.11134	-14.28755	110	4	1.12	0.95;
	2613	1	8.7	0.9	0	0	1	1.10764	-14.37551	110	4	1.12	0.95;
	2614	1	8.6	-0.8	0	0	1	1.08006	-14.81413	110	4	1.12	0.95;
	2615	1	27.6	6.6	0	0	1	1.05742	-8.53644	110	4	1.12	0.95;
	2616	1	13.5	7	0	0	1	1.08861	-15.34112	110	4	1.12	0.95;
	2617	1	10.7	6.5	0	0	1	1.08374	-15.57364	110	4	1.12	0.95;
	2618	2	9.3	0.8	0	0	1	1.05683	-24.35976	110	4	1.12	0.95;
	2619	1	3.7	2.4	0	0	1	1.05696	-24.37704	110	4	1.12	0.95;
	2620	1	26.9	2.8	0	0	1	1.06465	-27.3112	110	4	1.12	0.95;
	2621	1	21.2	16.3	0	0	1	1.02543	-22.44848	110	4	1.12	0.95;
	2622	1	6.5	0.2	0	0	1	1.0186	-26.81964	110	4	1.12	0.95;
	2623	1	6.6	0	0	0	1	1.02829	-26.44356	110	4	1.12	0.95;
	2624	1	19.1	5	0	0	1	1.09555	-13.85826	110	4	1.12	0.95;
	2625	1	23.5	7.7	0	0	1	1.08579	-15.34721	110	4	1.12	0.95;
	2626	1	14.6	4.5	0	0	1	1.07386	-16.10694	110	4	1.12	0.95;
	2627	1	15	8	0	0	1	1.07705	-14.94056	110	4	1.12	0.95;
	2628	1	11.7	1.9	0	0	1	1.10102	-9.974	110	4	1.12	0.95;
	2629	1	11.7	1.9	0	0	1	1.10103	-9.97128	110	4	1.12	0.95;
	2630	1	9.3	-1.7	0	0	1	1.11006	-29.38433	110	4	1.12	0.95;
	2631	1	14.2	2.6	0	0	1	1.08014	-14.98324	110	4	1.12	0.95;
	2632	1	15	1.5	0	0	1	1.11151	-14.23858	110	4	1.12	0.95;
	2633	1	21.6	10	0	0	1	1.0736	-16.12417	110	4	1.12	0.95;
	2634	1	21.4	7.1	0	0	1	1.10381	-13.99856	110	4	1.12	0.95;
	2635	1	0	0	0	0	1	1.07718	-13.84971	110	4	1.12	0.95;
	2636	1	0	0	0	0	1	1.06714	-15.54529	110	4	1.12	0.95;
	2637	1	0	0	0	0	1	1.10019	-22.44725	110	4	1.12	0.95;
	2638	1	0	0	0	0	1	1.11641	-16.38943	110	4	1.12	0.95;
	2639	1	0	0	0	0	1	1.07481	-16.52322	110	4	1.12	0.95;
	2640	1	0	0	0	0	1	1.05725	-18.56097	110	4	1.12	0.95;
	2641	1	0	0	0	0	1	1.06403	-17.39032	110	4	1.12	0.95;
	2642	1	0	0	0	0	1	1.06808	-15.72933	110	4	1.12	0.95;
	2643	1	0	0	0	0	1	1.0505	-25.18312	110	4	1.12	0.95;
	2644	1	0	0	0	0	1	1.06375	-23.02588	110	4	1.12	0.95;
	2645	1	0	0	0	0	1	1.05738	-24.4511	110	4	1.12	0.95;
	2646	1	0	0	0	0	1	1.08344	-15.71331	110	4	1.12	0.95;
	2647	1	0	0	0	0	1	1.05128	-24.40885	110	4	1.12	0.95;
	2648	1	0	0	0	0	1	1.06172	-17.62717	110	4	1.12	0.95;
	2649	1	0	0	0	0	1	1.08387	-32.70588	110	4	1.12	0.95;
	2650	1	0	0	0	0	1	1.06514	-17.16061	110	4	1.12	0.95;
	2651	1	0	0	0	0	1	1.08113	-32.50092	110	4	1.12	0.95;
	2652	1	0	0	0	0	1	1.07568	-29.23291	110	4	1.12	0.95;
	2653	1	0	0	0	0	1	1.06184	-19.75818	110	4	1.12	0.95;
	2654	1	0	0	0	0	1	1.07497	-15.78216	110	4	1.12	0.95;
	2655	1	0	0	0	0	1	1.04603	-24.71246	110	4	1.12	0.95;
	2656	1	0	0	0	0	1	1.07664	-13.89394	110	4	1.12	0.95;
	2657	1	0	0	0	0	1	1.08805	-15.17372	110	4	1.12	0.95;
	2658	1	0	0	0	0	1	1.0891	-15.03379	110	4	1.12	0.95;
	2659	1	0	0	0	0	1	1.02426	-26.62903	110	4	1.12	0.95;
	2660	1	7.5	1.9	0	0	1	1.10516	-14.47655	110	4	1.12	0.95;
	2661	1	7.9	0.3	0	0	1	1.09674	-4.70919	110	4	1.12	0.95;
	2662	1	3	3	0	0	1	1.05417	-21.34889	110	4	1.12	0.95;
	2663	1	13	6.4	0	0	1	1.0108	-24.17628	110	4	1.12	0.95;
	2664	1	10.1	4.7	0	0	1	1.03568	-25.33174	110	4	1.12	0.95;
	2665	1	65.6	42.1	0	0	1	0.99664	-25.01141	110	4	1.12	0.95;
	2666	1	7.8	0.5	0	0	1	1.07991	-13.70488	110	4	1.12	0.95;
	2667	1	0	0	0	0	1	1.07991	-13.70488	110	4	1.12	0.95;
	2668	1	0	0.2	0	0	1	1.08166	-13.39956	110	4	1.12	0.95;
	2669	1	11.5	4.4	0	0	1	1.08158	-13.41643	110	4	1.12	0.95;
	2670	1	11.7	11.7	0	0	1	0.99617	-28.36423	110	4	1.12	0.95;
	2671	1	13.2	12.3	0	0	1	0.99614	-28.38308	110	4	1.12	0.95;
	2672	1	8.4	1.9	0	0	1	1.0456	-24.73815	110	4	1.12	0.95;
	2673	1	36	18.8	0	0	1	1.07786	-29.17007	110	4	1.12	0.95;
	2674	1	50.7	17.9	0	0	1	1.02524	-25.9679	110	4	1.12	0.95;
	2675	1	9.9	-1.7	0	0	1	1.06299	-21.56031	110	4	1.12	0.95;
	2676	1	26.3	8.4	0	0	1	1.06024	-21.75073	110	4	1.12	0.95;
	2677	2	18.3	3.2	0	0	1	1.06188	-21.70569	110	4	1.12	0.95;
	2678	1	9.7	-2	0	0	1	1.11184	-8.8133	110	4	1.12	0.95;
	2679	1	5.3	0.7	0	0	1	1.06783	-18.5564	110	4	1.12	0.95;
	2680	1	4.7	0.2	0	0	1	1.0487	-28.44056	110	4	1.12	0.95;
	2681	1	9.7	4.1	0	0	1	1.11818	-11.52903	110	4	1.12	0.95;
	2682	1	21.6	3.1	0	0	1	1.07762	-33.33721	110	4	1.12	0.95;
	2683	1	9.8	-0.9	0	0	1	1.08383	-14.32692	110	4	1.12	0.95;
	2684	2	11.9	2.8	0	0	1	1.05149	-32.75372	110	4	1.12	0.95;
	2685	2	5	0.6	0	0	1	1.05277	-20.02219	110	4	1.12	0.95;
	2686	1	14	1.2	0	0	1	1.07669	-13.51662	110	4	1.12	0.95;
	2687	1	0	0	0	0	1	1.07663	-13.52299	110	4	1.12	0.95;
	2688	1	11.9	2.8	0	0	1	1.06019	-15.92185	110	4	1.12	0.95;
	2689	1	0	0	0	0	1	1.06435	-15.59793	110	4	1.12	0.95;
	2690	1	0	0	0	0	1	1.06514	-20.05518	110	4	1.12	0.95;
	2691	1	0	0	0	0	1	1.05706	-20.28625	110	4	1.12	0.95;
	2692	1	10.3	6	0	0	1	1.07463	-14.85067	110	4	1.12	0.95;
	2693	1	0.8	0.3	0	0	1	1.04018	-25.12315	110	4	1.12	0.95;
	2694	2	10	0.8	0	0	1	1.10225	-30.24114	110	5	1.12	0.95;
	2695	1	12.6	2.5	0	0	1	1.06721	-34.69432	110	5	1.12	0.95;
	2696	1	20.4	4	0	0	1	1.11432	-27.54946	110	5	1.12	0.95;
	2697	2	11.1	9	0	0	1	1.11894	-26.66293	110	5	1.12	0.95;
	2698	2	10.1	9	0	0	1	1.11891	-26.66262	110	5	1.12	0.95;
	2699	1	9.4	2	0	0	1	1.08027	-33.57909	110	5	1.12	0.95;
	2700	2	7.9	0.5	0	0	1	1.08335	-27.31093	110	5	1.12	0.95;
	2701	1	5.8	0	0	0	1	1.08328	-27.30578	110	5	1.12	0.95;
	2702	1	9.4	2	0	0	1	1.11696	-26.90818	110	5	1.12	0.95;
	2703	1	14.5	3.9	0	0	1	1.08204	-30.30588	110	5	1.12	0.95;
	2704	1	12.6	8	0	0	1	1.07739	-27.49744	110	5	1.12	0.95;
	2705	1	24.1	4.5	0	0	1	1.11564	-27.33167	110	5	1.12	0.95;
	2706	2	10.5	4	0	0	1	1.06238	-32.90544	110	5	1.12	0.95;
	2707	1	6.3	2	0	0	1	1.09108	-32.18813	110	5	1.12	0.95;
	2708	1	10.9	3.2	0	0	1	1.08538	-30.1679	110	5	1.12	0.95;
	2709	1	7.3	2	0	0	1	1.04449	-33.79788	110	5	1.12	0.95;
	2710	1	25.7	6	0	0	1	1.11362	-27.39601	110	5	1.12	0.95;
	2711	1	19.9	5	0	0	1	1.11676	-27.14277	110	5	1.12	0.95;
	2712	1	0	0	0	0	1	1.12	-27.46333	110	5	1.12	0.95;
	2713	1	0	0	0	0	1	1.11978	-27.47692	110	5	1.12	0.95;
	2714	2	13.6	2	0	0	1	1.07782	-28.75846	110	5	1.12	0.95;
	2715	1	5.2	1.2	0	0	1	1.08145	-31.28647	110	5	1.12	0.95;
	2716	1	9.4	3	0	0	1	1.04732	-32.53724	110	5	1.12	0.95;
	2717	2	26	7.4	0	0	1	1.09327	-29.31549	110	5	1.12	0.95;
	2718	2	12.9	2	0	0	1	1.09312	-29.30799	110	5	1.12	0.95;
	2719	2	11.8	3.8	0	0	1	1.10639	-28.81798	110	5	1.12	0.95;
	2720	1	9.4	2.5	0	0	1	1.10219	-28.27799	110	5	1.12	0.95;
	2721	1	9.3	2.4	0	0	1	1.10221	-28.26739	110	5	1.12	0.95;
	2722	1	15.2	4.3	0	0	1	1.04887	-32.44043	110	5	1.12	0.95;
	2723	1	10.9	3.1	0	0	1	1.11277	-28.36761	110	5	1.12	0.95;
	2724	1	10.5	3	0	0	1	1.04517	-34.29338	110	5	1.12	0.95;
	2725	1	12.1	0.5	0	0	1	1.04761	-34.3579	110	5	1.12	0.95;
	2726	2	13.6	3.3	0	0	1	1.03804	-33.18757	110	5	1.12	0.95;
	2727	1	17.3	3.2	0	0	1	1.09964	-29.92616	110	5	1.12	0.95;
	2728	1	5.2	0	0	0	1	1.02704	-35.93789	110	5	1.12	0.95;
	2729	2	4.7	0.3	0	0	1	1.03567	-33.58008	110	5	1.12	0.95;
	2730	2	4.2	1.1	0	0	1	1.0769	-28.07998	110	5	1.12	0.95;
	2731	2	0.5	0.1	0	0	1	1.08197	-28.07205	110	5	1.12	0.95;
	2732	1	10	2	0	0	1	1.08684	-32.08557	110	5	1.12	0.95;
	2733	2	6.3	0.5	0	0	1	1.02508	-36.12072	110	5	1.12	0.95;
	2734	1	0.8	0.4	0	0	1	1.10667	-28.42542	110	5	1.12	0.95;
	2735	1	11.3	4	0	0	1	1.1069	-26.73359	110	5	1.12	0.95;
	2736	2	6.8	0	0	0	1	1.0885	-26.1742	110	5	1.12	0.95;
	2737	1	0	0	0	0	1	1.08441	-26.26324	110	5	1.12	0.95;
	2738	1	0	0	0	0	1	1.08441	-26.28475	110	5	1.12	0.95;
	2739	2	21.4	7	0	0	1	1.06107	-32.68969	110	5	1.12	0.95;
	2740	2	1.5	1	0	0	1	1.06115	-32.69056	110	5	1.12	0.95;
	2741	1	19.9	4	0	0	1	1.05906	-33.0575	110	5	1.12	0.95;
	2742	1	14.7	4	0	0	1	1.0591	-32.8654	110	5	1.12	0.95;
	2743	1	8.9	2	0	0	1	1.11886	-26.92487	110	5	1.12	0.95;
	2744	1	7.3	1.8	0	0	1	1.11889	-26.91375	110	5	1.12	0.95;
	2745	2	2.2	1	0	0	1	1.0805	-28.36528	110	5	1.12	0.95;
	2746	1	0	0	0	0	1	1.10273	-29.9212	110	5	1.12	0.95;
	2747	1	0	0	0	0	1	1.10087	-30.09751	110	5	1.12	0.95;
	2748	1	0	0	0	48.6	1	1.05039	-30.38747	32	5	1.25	0.75;
	2749	2	11.1	3	0	0	1	1.10366	-30.28827	110	5	1.12	0.95;
	2750	2	41.5	21.1	0	0	1	1.10434	-29.99526	110	5	1.12	0.95;
	2751	1	0	0	0	0	1	1.09967	-29.77428	110	5	1.12	0.95;
	2752	1	0	0	0	0	1	1.09952	-30.64432	110	5	1.12	0.95;
	2753	1	29.3	4	0	0	1	1.09701	-30.47322	110	5	1.12	0.95;
	2754	1	12.1	2.1	0	0	1	1.08666	-30.02235	110	5	1.12	0.95;
	2755	1	0	0	0	0	1	1.08663	-30.00618	110	5	1.12	0.95;
	2756	1	6.3	1	0	0	1	1.09053	-31.59657	110	5	1.12	0.95;
	2757	2	5.3	0.9	0	0	1	1.11148	-28.01074	110	5	1.12	0.95;
	2758	1	11	4	0	0	1	1.07257	-22.24404	110	5	1.12	0.95;
	2759	2	0	0	0	0	1	1.08766	-27.12233	110	5	1.12	0.95;
	2760	1	8.3	2.6	0	0	1	1.09898	-28.54249	110	5	1.12	0.95;
	2761	1	5.8	2	0	0	1	1.07494	-27.84152	110	5	1.12	0.95;
	2762	1	23.1	5	0	0	1	1.08522	-30.17954	110	5	1.12	0.95;
	2763	1	18.9	6	0	0	1	1.08632	-30.04301	110	5	1.12	0.95;
	2764	2	0.9	0.1	0	0	1	1.11283	-28.36723	110	5	1.12	0.95;
	2765	1	0.3	0	0	0	1	1.11294	-28.35469	110	5	1.12	0.95;
	2766	1	3.1	1	0	0	1	1.07675	-33.80862	110	5	1.12	0.95;
	2767	1	3.1	1	0	0	1	1.10219	-30.08066	110	5	1.12	0.95;
	2768	1	13.8	4.5	0	0	1	1.11105	-28.04796	110	5	1.12	0.95;
	2769	1	0	0	0	0	1	1.11769	-27.50019	110	5	1.12	0.95;
	2770	1	0	0	0	0	1	1.11768	-27.47736	110	5	1.12	0.95;
	2771	1	0	0	0	0	1	1.11776	-27.47707	110	5	1.12	0.95;
	2772	1	0	0	0	60	1	1.04955	-27.97617	16	5	1.25	0.75;
	2773	1	5.1	1.1	0	0	1	1.0365	-33.42451	110	5	1.12	0.95;
	2774	1	7.9	0.5	0	0	1	1.08495	-29.58217	110	5	1.12	0.95;
	2775	1	19.9	3	0	0	1	1.08576	-30.97964	110	5	1.12	0.95;
	2776	1	8.3	3.1	0	0	1	1.09703	-29.17513	110	5	1.12	0.95;
	2777	2	11.5	2.8	0	0	1	1.11558	-27.42462	110	5	1.12	0.95;
	2778	1	10.5	2	0	0	1	1.11562	-27.42857	110	5	1.12	0.95;
	2779	1	13.6	3.5	0	0	1	1.11963	-26.85265	110	5	1.12	0.95;
	2780	1	7.9	1.5	0	0	1	1.11954	-26.85487	110	5	1.12	0.95;
	2781	1	0	0	0	45	1	1.07941	-27.41418	16	5	1.25	0.75;
	2782	2	32.5	24.1	0	0	1	1.0845	-20.87699	110	5	1.12	0.95;
	2783	1	12.6	2	0	0	1	1.09471	-31.56133	110	5	1.12	0.95;
	2784	1	4.2	0.5	0	0	1	1.07925	-27.58522	110	5	1.12	0.95;
	2785	1	6.7	3.4	0	0	1	1.10571	-28.13775	110	5	1.12	0.95;
	2786	1	3.7	1.1	0	0	1	1.06315	-22.54619	110	5	1.12	0.95;
	2787	1	0	0	0	0	1	1.06316	-22.54468	110	5	1.12	0.95;
	2788	1	25.1	3	0	0	1	1.05588	-33.97609	110	5	1.12	0.95;
	2789	2	0	0	0	0	1	1.10869	-28.00091	110	5	1.12	0.95;
	2790	1	14.1	3	0	0	1	1.0767	-32.28615	110	5	1.12	0.95;
	2791	2	0	0	0	0	1	1.09425	-29.55462	110	5	1.12	0.95;
	2792	1	15.2	2.5	0	0	1	1.09213	-30.72377	110	5	1.12	0.95;
	2793	1	13.1	1	0	0	1	1.07319	-27.99444	110	5	1.12	0.95;
	2794	1	12.6	2	0	0	1	1.08748	-29.927	110	5	1.12	0.95;
	2795	2	9.4	2	0	0	1	1.09614	-30.60821	110	5	1.12	0.95;
	2796	1	9.4	1	0	0	1	1.07395	-27.9048	110	5	1.12	0.95;
	2797	1	8.9	1.5	0	0	1	1.10691	-28.24265	110	5	1.12	0.95;
	2798	1	13.1	0	0	0	1	1.08047	-26.79486	110	5	1.12	0.95;
	2799	1	7.3	2	0	0	1	1.10811	-27.93856	110	5	1.12	0.95;
	2800	2	12.1	7	0	0	1	1.08107	-26.58931	110	5	1.12	0.95;
	2801	2	16.2	3.5	0	0	1	1.08069	-26.75326	110	5	1.12	0.95;
	2802	1	6.1	2	0	0	1	1.08195	-21.66212	110	5	1.12	0.95;
	2803	1	45.1	7.5	0	0	1	1.05029	-33.64493	110	5	1.12	0.95;
	2804	1	5.2	1.5	0	0	1	1.06375	-35.66319	110	5	1.12	0.95;
	2805	2	16.3	3.6	0	0	1	1.08054	-21.69884	110	5	1.12	0.95;
	2806	2	8.9	0.5	0	0	1	1.06325	-36.01049	110	5	1.12	0.95;
	2807	1	8.4	0.5	0	0	1	1.06327	-36.00461	110	5	1.12	0.95;
	2808	1	5.2	2	0	0	1	1.06573	-32.30597	110	5	1.12	0.95;
	2809	1	12.6	3	0	0	1	1.11892	-26.76524	110	5	1.12	0.95;
	2810	2	147.6	40.7	0	0	1	1.08715	-31.14962	110	5	1.12	0.95;
	2811	1	0	0	0	0	1	1.08724	-31.12538	110	5	1.12	0.95;
	2812	1	0	0	0	0	1	1.08724	-31.12536	110	5	1.12	0.95;
	2813	1	6.2	2.5	0	0	1	1.10691	-28.5329	110	5	1.12	0.95;
	2814	1	14.7	4	0	0	1	1.08592	-31.21319	110	5	1.12	0.95;
	2815	1	13.6	1	0	0	1	1.08008	-26.87705	110	5	1.12	0.95;
	2816	2	4.8	1.9	0	0	1	1.10587	-28.70298	110	5	1.12	0.95;
	2817	1	12.2	4.3	0	0	1	1.0958	-24.74533	110	5	1.12	0.95;
	2818	1	0.1	0	0	0	1	1.11096	-28.42702	110	5	1.12	0.95;
	2819	1	11.9	3.9	0	0	1	1.10722	-24.47651	110	5	1.12	0.95;
	2820	1	16.8	3.5	0	0	1	1.08378	-31.2222	110	5	1.12	0.95;
	2821	2	15.7	1.1	0	0	1	1.07554	-28.06013	110	5	1.12	0.95;
	2822	1	10.5	0.5	0	0	1	1.07557	-28.06848	110	5	1.12	0.95;
	2823	1	3.7	0.1	0	0	1	1.08679	-31.02715	110	5	1.12	0.95;
	2824	1	14.1	4.4	0	0	1	1.09643	-28.22898	110	5	1.12	0.95;
	2825	1	4.7	0	0	0	1	1.10187	-29.96317	110	5	1.12	0.95;
	2826	1	4.2	0	0	0	1	1.10177	-29.9678	110	5	1.12	0.95;
	2827	2	11.5	3	0	0	1	1.07806	-33.72533	110	5	1.12	0.95;
	2828	1	0.8	0.7	0	0	1	1.10856	-28.20329	110	5	1.12	0.95;
	2829	1	15.7	4	0	0	1	1.08857	-30.5776	110	5	1.12	0.95;
	2830	2	10.5	8	0	0	1	1.08008	-21.66089	110	5	1.12	0.95;
	2831	2	0	0	0	0	1	1.08007	-21.66078	110	5	1.12	0.95;
	2832	1	16.8	4	0	0	1	1.06492	-32.70262	110	5	1.12	0.95;
	2833	2	11.5	1	0	0	1	1.08637	-28.53511	110	5	1.12	0.95;
	2834	2	14.7	3	0	0	1	1.09579	-31.50744	110	5	1.12	0.95;
	2835	1	10.5	2	0	0	1	1.09569	-31.52144	110	5	1.12	0.95;
	2836	1	12.8	4	0	0	1	1.08466	-31.0901	110	5	1.12	0.95;
	2837	1	12.6	3	0	0	1	1.08831	-31.33081	110	5	1.12	0.95;
	2838	1	3.7	1.5	0	0	1	1.06692	-33.03854	110	5	1.12	0.95;
	2839	1	2.9	0.7	0	0	1	1.11211	-27.9663	110	5	1.12	0.95;
	2840	1	12.6	3	0	0	1	1.08561	-21.95853	110	5	1.12	0.95;
	2841	1	13.6	2.5	0	0	1	1.1017	-29.97802	110	5	1.12	0.95;
	2842	1	17.8	2.5	0	0	1	1.06562	-35.65252	110	5	1.12	0.95;
	2843	1	19.4	4	0	0	1	1.07455	-32.67805	110	5	1.12	0.95;
	2844	1	14.7	3.8	0	0	1	1.07638	-21.96548	110	5	1.12	0.95;
	2845	2	15.7	3.5	0	0	1	1.11098	-28.79204	110	5	1.12	0.95;
	2846	1	13.1	2	0	0	1	1.07488	-30.63446	110	5	1.12	0.95;
	2847	1	14	4.8	0	0	1	1.08029	-30.98065	110	5	1.12	0.95;
	2848	1	10.5	3	0	0	1	1.06839	-32.16314	110	5	1.12	0.95;
	2849	1	3.7	1	0	0	1	1.1141	-27.07917	110	5	1.12	0.95;
	2850	1	6.3	1.1	0	0	1	1.07872	-21.5704	110	5	1.12	0.95;
	2851	2	3	0.5	0	0	1	1.08826	-27.92206	110	5	1.12	0.95;
	2852	1	9.4	1	0	0	1	1.08887	-29.77876	110	5	1.12	0.95;
	2853	1	23.1	1.5	0	0	1	1.09802	-30.92959	110	5	1.12	0.95;
	2854	1	0	0	0	0	1	1.09639	-31.09167	110	5	1.12	0.95;
	2855	1	0	0	0	0	1	1.09635	-31.11086	110	5	1.12	0.95;
	2856	1	0	0	0	60	1	1.05009	-31.49453	16	5	1.25	0.75;
	2857	2	8.4	1.5	0	0	1	1.09886	-31.29323	110	5	1.12	0.95;
	2858	1	8.4	2	0	0	1	1.09888	-31.29785	110	5	1.12	0.95;
	2859	1	9.4	2	0	0	1	1.08263	-31.06616	110	5	1.12	0.95;
	2860	1	18.3	2.5	0	0	1	1.10382	-30.01329	110	5	1.12	0.95;
	2861	1	23.1	6	0	0	1	1.09285	-31.76909	110	5	1.12	0.95;
	2862	2	9.4	2	0	0	1	1.08609	-26.61996	110	5	1.12	0.95;
	2863	1	11.5	3	0	0	1	1.09782	-31.36362	110	5	1.12	0.95;
	2864	1	26.2	2	0	0	1	1.08396	-31.84628	110	5	1.12	0.95;
	2865	1	6.3	2	0	0	1	1.07534	-32.64444	110	5	1.12	0.95;
	2866	1	4	1.2	0	0	1	1.08003	-28.72972	110	5	1.12	0.95;
	2867	1	21	4.5	0	0	1	1.11568	-27.99609	110	5	1.12	0.95;
	2868	1	8.4	2.5	0	0	1	1.09397	-31.68434	110	5	1.12	0.95;
	2869	2	15.7	3.5	0	0	1	1.09387	-31.70227	110	5	1.12	0.95;
	2870	1	0	0	0	0	1	1.09579	-31.50746	110	5	1.12	0.95;
	2871	1	0	0	0	0	1	1.09569	-31.52145	110	5	1.12	0.95;
	2872	1	8.5	2	0	0	1	1.08043	-21.41042	110	5	1.12	0.95;
	2873	1	7.3	2	0	0	1	1.08044	-21.40219	110	5	1.12	0.95;
	2874	1	16.8	5	0	0	1	1.10163	-30.26745	110	5	1.12	0.95;
	2875	1	0.1	0	0	0	1	1.09042	-30.43805	110	5	1.12	0.95;
	2876	1	3.7	0.5	0	0	1	1.0867	-26.56205	110	5	1.12	0.95;
	2877	1	14.7	6	0	0	1	1.09359	-21.17497	110	5	1.12	0.95;
	2878	1	14.7	4	0	0	1	1.06043	-33.28598	110	5	1.12	0.95;
	2879	1	0	0	0	0	1	1.0605	-33.28243	110	5	1.12	0.95;
	2880	1	5.2	1	0	0	1	1.08642	-31.31599	110	5	1.12	0.95;
	2881	1	5.2	1	0	0	1	1.09395	-30.51656	110	5	1.12	0.95;
	2882	1	8.4	2	0	0	1	1.09722	-31.00879	110	5	1.12	0.95;
	2883	1	3.1	1	0	0	1	1.06142	-32.82004	110	5	1.12	0.95;
	2884	1	5.8	1	0	0	1	1.0787	-30.6382	110	5	1.12	0.95;
	2885	1	6.8	0.8	0	0	1	1.10286	-30.24567	110	5	1.12	0.95;
	2886	1	16.8	3	0	0	1	1.09982	-30.71708	110	5	1.12	0.95;
	2887	1	7.1	2.8	0	0	1	1.10234	-28.97286	110	5	1.12	0.95;
	2888	1	0	0	0	0	1	1.10231	-28.97183	110	5	1.12	0.95;
	2889	1	7.9	1.7	0	0	1	1.07602	-22.26855	110	5	1.12	0.95;
	2890	2	4.2	1	0	0	1	1.06829	-32.87479	110	5	1.12	0.95;
	2891	1	4	1	0	0	1	1.10166	-29.01042	110	5	1.12	0.95;
	2892	1	0.1	0.1	0	0	1	1.08587	-29.37552	110	5	1.12	0.95;
	2893	2	21.4	5	0	0	1	1.09501	-30.8524	110	5	1.12	0.95;
	2894	1	7.3	2	0	0	1	1.1126	-28.66078	110	5	1.12	0.95;
	2895	1	11.5	3	0	0	1	1.10452	-28.41785	110	5	1.12	0.95;
	2896	1	18.3	4.3	0	0	1	1.07895	-21.64179	110	5	1.12	0.95;
	2897	2	23.6	16.4	0	0	1	1.10205	-29.95804	110	5	1.12	0.95;
	2898	1	21	8.3	0	0	1	1.10032	-30.13368	110	5	1.12	0.95;
	2899	2	22	4.5	0	0	1	1.06267	-32.87323	110	5	1.12	0.95;
	2900	1	19.9	8	0	0	1	1.08538	-30.21071	110	5	1.12	0.95;
	2901	1	23.1	5	0	0	1	1.08562	-28.73013	110	5	1.12	0.95;
	2902	1	5.2	1.5	0	0	1	1.0619	-36.13467	110	5	1.12	0.95;
	2903	1	0	0	0	0	1	1.11954	-26.85488	110	5	1.12	0.95;
	2904	1	18	5.8	0	0	1	1.10803	-28.57766	110	5	1.12	0.95;
	2905	1	12.6	3	0	0	1	1.0901	-29.15166	110	5	1.12	0.95;
	2906	1	4.2	1.1	0	0	1	1.08864	-29.94191	110	5	1.12	0.95;
	2907	1	24.6	6	0	0	1	1.1142	-27.28111	110	5	1.12	0.95;
	2908	2	13.4	5.5	0	0	1	1.09933	-29.79474	110	5	1.12	0.95;
	2909	1	13.8	4.4	0	0	1	1.08151	-29.93452	110	5	1.12	0.95;
	2910	1	5.7	1.7	0	0	1	1.1145	-27.80209	110	5	1.12	0.95;
	2911	1	15.7	3	0	0	1	1.07861	-21.92645	110	5	1.12	0.95;
	2912	1	10.5	2	0	0	1	1.07859	-21.91724	110	5	1.12	0.95;
	2913	1	12.6	4.3	0	0	1	1.11549	-26.95157	110	5	1.12	0.95;
	2914	1	3.1	0.5	0	0	1	1.05069	-33.62759	110	5	1.12	0.95;
	2915	1	0	0	0	0	1	1.05074	-33.61815	110	5	1.12	0.95;
	2916	1	13.6	0.5	0	0	1	1.05306	-33.31325	110	5	1.12	0.95;
	2917	1	12.6	0.5	0	0	1	1.07638	-31.17401	110	5	1.12	0.95;
	2918	1	0	0	0	0	1	1.08384	-27.32136	110	5	1.12	0.95;
	2919	1	8.6	2	0	0	1	1.08272	-30.28313	110	5	1.12	0.95;
	2920	2	23.6	5.5	0	0	1	1.08424	-27.42343	110	5	1.12	0.95;
	2921	1	4.7	0.5	0	0	1	1.07997	-27.04677	110	5	1.12	0.95;
	2922	1	3.7	0.5	0	0	1	1.04194	-34.44005	110	5	1.12	0.95;
	2923	1	11	2	0	0	1	1.04828	-34.51828	110	5	1.12	0.95;
	2924	2	7.9	2	0	0	1	1.05662	-34.03673	110	5	1.12	0.95;
	2925	1	9.4	2	0	0	1	1.08121	-27.0626	110	5	1.12	0.95;
	2926	1	8.9	1	0	0	1	1.08009	-27.97796	110	5	1.12	0.95;
	2927	1	0	0	0	0	1	1.08771	-26.67583	110	5	1.12	0.95;
	2928	1	0	0	0	0	1	1.08771	-26.70835	110	5	1.12	0.95;
	2929	2	12.6	1	0	0	1	1.08288	-27.7849	110	5	1.12	0.95;
	2930	1	12.6	1	0	0	1	1.08292	-27.78236	110	5	1.12	0.95;
	2931	1	7.2	2.7	0	0	1	1.11096	-28.06216	110	5	1.12	0.95;
	2932	1	24.1	2.4	0	0	1	1.09651	-31.08349	110	5	1.12	0.95;
	2933	1	0.6	0.1	0	0	1	1.09662	-30.78134	110	5	1.12	0.95;
	2934	2	32.5	3.5	0	0	1	1.05968	-33.77788	110	5	1.12	0.95;
	2935	1	0	0	0	0	1	1.05968	-33.77788	110	5	1.12	0.95;
	2936	1	11.5	1	0	0	1	1.083	-27.68827	110	5	1.12	0.95;
	2937	1	0	0	0	0	1	1.09572	-30.72873	110	5	1.12	0.95;
	2938	2	27.8	5.5	0	0	1	1.06528	-32.89465	110	5	1.12	0.95;
	2939	1	5.2	1.5	0	0	1	1.08642	-30.02937	110	5	1.12	0.95;
	2940	1	6.8	2.3	0	0	1	1.10038	-18.56417	110	5	1.12	0.95;
	2941	1	7.3	2	0	0	1	1.08606	-31.24044	110	5	1.12	0.95;
	2942	1	9.4	2	0	0	1	1.08891	-30.38898	110	5	1.12	0.95;
	2943	2	105.8	35.3	0	0	1	1.11284	-28.67329	110	5	1.12	0.95;
	2944	1	4.4	1.9	0	0	1	1.11389	-27.79936	110	5	1.12	0.95;
	2945	1	6.3	1.6	0	0	1	1.10947	-28.36825	110	5	1.12	0.95;
	2946	1	28.3	6	0	0	1	1.08734	-31.3403	110	5	1.12	0.95;
	2947	2	12.4	3.9	0	0	1	1.11275	-28.37389	110	5	1.12	0.95;
	2948	1	6.8	1.2	0	0	1	1.11295	-28.35355	110	5	1.12	0.95;
	2949	1	7.3	2	0	0	1	1.08684	-29.99807	110	5	1.12	0.95;
	2950	1	8.6	2.3	0	0	1	1.10712	-28.5311	110	5	1.12	0.95;
	2951	1	12.7	3.2	0	0	1	1.10957	-28.58408	110	5	1.12	0.95;
	2952	1	20.9	5.5	0	0	1	1.10941	-28.55546	110	5	1.12	0.95;
	2953	1	4.6	1.1	0	0	1	1.1096	-28.54303	110	5	1.12	0.95;
	2954	2	13.5	3.3	0	0	1	1.10294	-28.96853	110	5	1.12	0.95;
	2955	1	15.4	3.2	0	0	1	1.10023	-28.87955	110	5	1.12	0.95;
	2956	1	13.6	3	0	0	1	1.0804	-22.27504	110	5	1.12	0.95;
	2957	1	13	3.3	0	0	1	1.10897	-28.61682	110	5	1.12	0.95;
	2958	1	12.6	3.8	0	0	1	1.06299	-31.34678	110	5	1.12	0.95;
	2959	2	0	0	0	0	1	1.09101	-24.8951	110	5	1.12	0.95;
	2960	2	3.6	1.5	0	0	1	1.10429	-28.92988	110	5	1.12	0.95;
	2961	1	12.6	2	0	0	1	1.08578	-26.76683	110	5	1.12	0.95;
	2962	1	4.2	0.5	0	0	1	1.07781	-27.29709	110	5	1.12	0.95;
	2963	1	15.2	4.6	0	0	1	1.10432	-28.48184	110	5	1.12	0.95;
	2964	2	22	6	0	0	1	1.08689	-27.4909	110	5	1.12	0.95;
	2965	1	26.2	4	0	0	1	1.0835	-28.15231	110	5	1.12	0.95;
	2966	2	9.4	0.4	0	0	1	1.07898	-27.79536	110	5	1.12	0.95;
	2967	1	26.2	4.5	0	0	1	1.08783	-30.59942	110	5	1.12	0.95;
	2968	2	6.6	3.8	0	0	1	1.11311	-26.7695	110	5	1.12	0.95;
	2969	1	13.4	7.4	0	0	1	1.11299	-26.7722	110	5	1.12	0.95;
	2970	1	12.6	4	0	0	1	1.10034	-29.12993	110	5	1.12	0.95;
	2971	1	23.1	6.3	0	0	1	1.1052	-26.93476	110	5	1.12	0.95;
	2972	2	15.4	4	0	0	1	1.10894	-26.56085	110	5	1.12	0.95;
	2973	2	0.5	0.2	0	0	1	1.10884	-26.57045	110	5	1.12	0.95;
	2974	1	16	4	0	0	1	1.10644	-26.97793	110	5	1.12	0.95;
	2975	1	7.9	0.7	0	0	1	1.09695	-31.01717	110	5	1.12	0.95;
	2976	1	0	0	0	0	1	1.09141	-32.16296	110	5	1.12	0.95;
	2977	1	0	0	0	0	1	1.08671	-26.56093	110	5	1.12	0.95;
	2978	1	0	0	0	0	1	1.09697	-31.01477	110	5	1.12	0.95;
	2979	1	22	5	0	0	1	1.11851	-26.72171	110	5	1.12	0.95;
	2980	1	22	5	0	0	1	1.11851	-26.73342	110	5	1.12	0.95;
	2981	1	2.1	0.8	0	0	1	1.11885	-26.6691	110	5	1.12	0.95;
	2982	1	13.6	2.5	0	0	1	1.10344	-30.08517	110	5	1.12	0.95;
	2983	1	15.7	3	0	0	1	1.10261	-30.39192	110	5	1.12	0.95;
	2984	2	40.9	11.9	0	0	1	1.11069	-26.87608	110	5	1.12	0.95;
	2985	1	35.2	9.6	0	0	1	1.1106	-26.8893	110	5	1.12	0.95;
	2986	1	7.9	0.5	0	0	1	1.02713	-35.92692	110	5	1.12	0.95;
	2987	1	29.3	18.1	0	0	1	1.05951	-32.79078	110	5	1.12	0.95;
	2988	1	17.3	3.2	0	0	1	1.06527	-22.41302	110	5	1.12	0.95;
	2989	1	0	0	0	0	1	1.08659	-26.57335	110	5	1.12	0.95;
	2990	1	0	0	0	0	1	1.08654	-26.55681	110	5	1.12	0.95;
	2991	2	14.7	4.5	0	0	1	1.09698	-29.34153	110	5	1.12	0.95;
	2992	1	0	0	0	0	1	1.09705	-29.33134	110	5	1.12	0.95;
	2993	1	4.1	1.4	0	0	1	1.10765	-26.71893	110	5	1.12	0.95;
	2994	2	0.3	0.1	0	0	1	1.0959	-27.97063	110	5	1.12	0.95;
	2995	2	0.3	0.1	0	0	1	1.09593	-27.99095	110	5	1.12	0.95;
	2996	1	2.1	0.5	0	0	1	1.0927	-28.516	110	5	1.12	0.95;
	2997	1	16	6	0	0	0	1.07184	-7.09645	110	0	1.12	0.95;
	2998	1	0	0	0	0	0	1.07193	-7.08993	110	0	1.12	0.95;
	2999	1	33	12	0	0	0	1.07062	-7.18352	110	0	1.12	0.95;
	3000	1	16	6	0	0	0	1.07063	-7.18165	110	0	1.12	0.95;
	3001	1	50	14	0	0	0	1.03083	-15.52365	110	0	1.12	0.95;
	3002	1	50	14	0	0	0	1.02936	-15.76641	110	0	1.12	0.95;
	3003	1	25	10	0	0	0	1.04977	-8.78316	110	0	1.12	0.95;
	3004	1	65	26	0	0	0	1.04069	-9.43484	110	0	1.12	0.95;
	3005	2	0	0	0	0	1	1.07282	-32.05677	110	5	1.12	0.95;
	3006	2	0	0	0	0	0	1.0469	-10.68269	400	0	1.05	0.95;
	3007	2	0	0	0	0	0	1.07307	-13.31811	220	0	1.11	0.95;
	3008	2	0	0	0	0	0	1.0458	-11.16756	400	0	1.05	0.95;
	3010	2	0	0	0	0	0	1.049	-3.71345	400	0	1.05	0.95;
	3011	2	0	0	0	0	0	1.06429	-17.67904	220	0	1.11	0.95;
	3012	2	0	0	0	0	0	1.02688	-10.78735	400	0	1.05	0.95;
	3013	1	2	1	0	0	1	1.10927	-28.61629	110	5	1.12	0.95;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	10071	133.9	0.7	99999	-99999	1.07617	285	1	204.6	133.9	0	0	0	0	0	0	0	0	0	0	0;
	10079	359.9	4404.9	99999	-99999	1.01319	2031	1	549.9	359.9	0	0	0	0	0	0	0	0	0	0	0;
	10080	7.6	-358.3	99999	-99999	1.02855	119	1	11.6	7.6	0	0	0	0	0	0	0	0	0	0	0;
	10090	410.4	188.1	99999	-99999	1.04139	806	1	627	410.4	0	0	0	0	0	0	0	0	0	0	0;
	10094	554.4	10091.5	99999	-99999	1.03526	970	1	847	554.4	0	0	0	0	0	0	0	0	0	0	0;
	10095	121.8	-2580.1	99999	-99999	1.02969	1439	1	1241.5	121.8	0	0	0	0	0	0	0	0	0	0	0;
	10100	1267.2	-118.4	99999	-99999	1.04073	2202	1	1936	1267.2	0	0	0	0	0	0	0	0	0	0	0;
	10104	540	56.7	99999	-99999	1.04409	939	1	825	540	0	0	0	0	0	0	0	0	0	0	0;
	10115	280.8	-228.6	99999	-99999	1.00234	492	1	429	280.8	0	0	0	0	0	0	0	0	0	0	0;
	10116	280.8	-228.6	99999	-99999	1.00234	492	1	429	280.8	0	0	0	0	0	0	0	0	0	0	0;
	10118	1080	63.4	99999	-99999	1.04097	1876	1	1650	1080	0	0	0	0	0	0	0	0	0	0	0;
	10126	424.8	-432.6	99999	-99999	1.00802	786	1	649	424.8	0	0	0	0	0	0	0	0	0	0	0;
	10129	1656	-432.6	99999	-99999	1.04538	2974	1	2530	1656	0	0	0	0	0	0	0	0	0	0	0;
	10132	583.2	-91	99999	-99999	1.02908	1014	1	891	583.2	0	0	0	0	0	0	0	0	0	0	0;
	10139	648	-206.7	99999	-99999	1.03742	1143	1	990	648	0	0	0	0	0	0	0	0	0	0	0;
	10140	972	-194.4	99999	-99999	1.03856	1705	1	1485	972	0	0	0	0	0	0	0	0	0	0	0;
	10141	1224	-437.3	99999	-99999	1.01264	2125	1	1870	1224	0	0	0	0	0	0	0	0	0	0	0;
	10146	115.2	-176.7	99999	-99999	1.04296	224	1	176	115.2	0	0	0	0	0	0	0	0	0	0	0;
	10150	201.6	10.8	99999	-99999	1.04015	427	1	308	201.6	0	0	0	0	0	0	0	0	0	0	0;
	10171	84.6	-9949	99999	-99999	1.02955	715	1	129.3	84.6	0	0	0	0	0	0	0	0	0	0	0;
	10176	191	283.3	99999	-99999	1.02979	346	1	291.8	191	0	0	0	0	0	0	0	0	0	0	0;
	10177	191	283.3	99999	-99999	1.02979	346	1	291.8	191	0	0	0	0	0	0	0	0	0	0	0;
	10186	342.7	27.1	99999	-99999	1.08932	618	1	534.6	342.7	0	0	0	0	0	0	0	0	0	0	0;
	10187	342.7	27.2	99999	-99999	1.0894	618	1	534.6	342.7	0	0	0	0	0	0	0	0	0	0	0;
	10188	347.8	-76.3	99999	-99999	1.04594	618	1	531.3	347.8	0	0	0	0	0	0	0	0	0	0	0;
	10189	283	-60.7	99999	-99999	1.04556	620	1	542.3	283	0	0	0	0	0	0	0	0	0	0	0;
	10190	371.5	-14.2	99999	-99999	1.04288	683	1	600.6	371.5	0	0	0	0	0	0	0	0	0	0	0;
	10191	370.8	-13.7	99999	-99999	1.04288	682	1	599.5	370.8	0	0	0	0	0	0	0	0	0	0	0;
	10192	111.6	19.1	99999	-99999	1.04073	281	1	247.5	111.6	0	0	0	0	0	0	0	0	0	0	0;
	10194	64.8	-85.2	99999	-99999	1.03584	184	1	143	64.8	0	0	0	0	0	0	0	0	0	0	0;
	10196	108	-46.1	99999	-99999	1.04091	215	1	165	108	0	0	0	0	0	0	0	0	0	0	0;
	10223	125.5	190.8	99999	-99999	1.04073	189	1	125.5	0	0	0	0	0	0	0	0	0	0	0	0;
	10225	77.8	131.8	99999	-99999	1.06248	333	1	272.8	77.8	0	0	0	0	0	0	0	0	0	0	0;
	10226	34.6	97.3	99999	-99999	1.06441	198	1	140.8	34.6	0	0	0	0	0	0	0	0	0	0	0;
	10227	11.5	71.5	99999	-99999	1.10423	191	1	17.6	11.5	0	0	0	0	0	0	0	0	0	0	0;
	10228	18.7	146.1	99999	-99999	1.06247	135	1	28.6	18.7	0	0	0	0	0	0	0	0	0	0	0;
	10229	39.6	24.8	99999	-99999	1.06902	85	1	60.5	39.6	0	0	0	0	0	0	0	0	0	0	0;
	10230	0	18.2	99999	-99999	1.07323	132	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	10232	11.2	36.3	99999	-99999	1.01987	64	1	17.2	11.2	0	0	0	0	0	0	0	0	0	0	0;
	10233	45.4	68.4	99999	-99999	1.04665	79	1	69.3	45.4	0	0	0	0	0	0	0	0	0	0	0;
	10234	3.6	205.6	99999	-99999	1.09129	115	1	5.5	3.6	0	0	0	0	0	0	0	0	0	0	0;
	10235	28.8	18.1	99999	-99999	1.08091	83	1	44	28.8	0	0	0	0	0	0	0	0	0	0	0;
	10236	119.5	37.8	99999	-99999	1.07896	219	1	182.6	119.5	0	0	0	0	0	0	0	0	0	0	0;
	10237	50.4	132	99999	-99999	1.08023	121	1	77	50.4	0	0	0	0	0	0	0	0	0	0	0;
	10238	61.9	122.2	99999	-99999	1.00809	179	1	94.6	61.9	0	0	0	0	0	0	0	0	0	0	0;
	10239	62.6	39.5	99999	-99999	1.06246	109	1	95.7	62.6	0	0	0	0	0	0	0	0	0	0	0;
	10240	0	11.5	99999	-99999	1.0666	128	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	10246	146.2	-49.3	99999	-99999	1.03917	262	1	223.3	146.2	0	0	0	0	0	0	0	0	0	0	0;
	10247	102.2	-1.7	99999	-99999	1.12	215	1	156.2	102.2	0	0	0	0	0	0	0	0	0	0	0;
	10248	122.4	6.2	99999	-99999	1.12	241	1	187	122.4	0	0	0	0	0	0	0	0	0	0	0;
	10249	128	-23.9	99999	-99999	1.00179	225	1	195.6	128	0	0	0	0	0	0	0	0	0	0	0;
	10250	374.4	-1.1	99999	-99999	1.0404	650	1	572	374.4	0	0	0	0	0	0	0	0	0	0	0;
	10251	374.4	-2.6	99999	-99999	1.03995	650	1	572	374.4	0	0	0	0	0	0	0	0	0	0	0;
	10252	374.4	-2.5	99999	-99999	1.03994	650	1	572	374.4	0	0	0	0	0	0	0	0	0	0	0;
	10253	187.9	33.5	99999	-99999	1.01534	341	1	287.1	187.9	0	0	0	0	0	0	0	0	0	0	0;
	10254	342.7	30.5	99999	-99999	1.04999	598	1	523.6	342.7	0	0	0	0	0	0	0	0	0	0	0;
	10255	121	5.4	99999	-99999	1.03994	210	1	184.8	121	0	0	0	0	0	0	0	0	0	0	0;
	10256	280.8	31.7	99999	-99999	1.11998	489	1	429	280.8	0	0	0	0	0	0	0	0	0	0	0;
	10257	140.4	16.3	99999	-99999	1.11817	250	1	214.5	140.4	0	0	0	0	0	0	0	0	0	0	0;
	10258	129.6	-3	99999	-99999	1.10518	230	1	198	129.6	0	0	0	0	0	0	0	0	0	0	0;
	10259	283.7	8	99999	-99999	0.98182	519	1	433.4	283.7	0	0	0	0	0	0	0	0	0	0	0;
	10260	425.5	9.2	99999	-99999	1.10941	741	1	650.1	425.5	0	0	0	0	0	0	0	0	0	0	0;
	10261	579.6	15.8	99999	-99999	0.99592	1100	1	951.5	579.6	0	0	0	0	0	0	0	0	0	0	0;
	10262	579.6	15.9	99999	-99999	0.99592	1100	1	951.5	579.6	0	0	0	0	0	0	0	0	0	0	0;
	10263	67.7	7.8	99999	-99999	1.09219	121	1	103.4	67.7	0	0	0	0	0	0	0	0	0	0	0;
	10264	280.8	-4.2	99999	-99999	1.00552	489	1	429	280.8	0	0	0	0	0	0	0	0	0	0	0;
	10265	280.8	-7.2	99999	-99999	1.10573	496	1	429	280.8	0	0	0	0	0	0	0	0	0	0	0;
	10266	3.6	-8.1	99999	-99999	1.04403	72	1	5.5	3.6	0	0	0	0	0	0	0	0	0	0	0;
	10267	4.3	43.3	99999	-99999	1.08131	120	1	6.6	4.3	0	0	0	0	0	0	0	0	0	0	0;
	10268	20.9	15.8	99999	-99999	1.06395	37	1	31.9	20.9	0	0	0	0	0	0	0	0	0	0	0;
	10269	68.4	127.9	99999	-99999	1.07428	338	1	291.5	68.4	0	0	0	0	0	0	0	0	0	0	0;
	10270	0	24.4	99999	-99999	1.05973	40	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	10271	156.2	71.4	99999	-99999	1.06494	286	1	238.7	156.2	0	0	0	0	0	0	0	0	0	0	0;
	10272	24.5	16.2	99999	-99999	1.072	116	1	37.4	24.5	0	0	0	0	0	0	0	0	0	0	0;
	10273	165.6	83.2	99999	-99999	1.02431	321	1	253	165.6	0	0	0	0	0	0	0	0	0	0	0;
	10274	61.2	118.3	99999	-99999	1.06504	317	1	225.5	61.2	0	0	0	0	0	0	0	0	0	0	0;
	10275	21.6	5.4	99999	-99999	1.06182	125	1	110	21.6	0	0	0	0	0	0	0	0	0	0	0;
	10276	107.3	19.9	99999	-99999	1.06034	189	1	163.9	107.3	0	0	0	0	0	0	0	0	0	0	0;
	10277	80.6	60	99999	-99999	1.06264	225	1	123.2	80.6	0	0	0	0	0	0	0	0	0	0	0;
	10278	129.6	18.8	99999	-99999	1.11356	233	1	198	129.6	0	0	0	0	0	0	0	0	0	0	0;
	10279	129.6	18.8	99999	-99999	1.11356	233	1	198	129.6	0	0	0	0	0	0	0	0	0	0	0;
	10281	2.9	25.3	99999	-99999	1.07868	20	1	4.4	2.9	0	0	0	0	0	0	0	0	0	0	0;
	10282	58.3	143.8	99999	-99999	1.06767	357	1	287.1	58.3	0	0	0	0	0	0	0	0	0	0	0;
	10284	418.3	179	99999	-99999	1.12	919	1	771.1	418.3	0	0	0	0	0	0	0	0	0	0	0;
	10285	0	-21.9	99999	-99999	1.0574	132	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	10288	20.9	-26.5	99999	-99999	1.03369	63	1	31.9	20.9	0	0	0	0	0	0	0	0	0	0	0;
	10289	0.7	-25	99999	-99999	1.05256	41	1	34.1	0.7	0	0	0	0	0	0	0	0	0	0	0;
	10290	28.1	27.1	99999	-99999	1.06119	49	1	42.9	28.1	0	0	0	0	0	0	0	0	0	0	0;
	10291	5.8	48.9	99999	-99999	1.08362	71	1	8.8	5.8	0	0	0	0	0	0	0	0	0	0	0;
	10292	312.5	164.1	99999	-99999	1.08678	638	1	477.4	312.5	0	0	0	0	0	0	0	0	0	0	0;
	10293	19.4	20.3	99999	-99999	1.07356	46	1	29.7	19.4	0	0	0	0	0	0	0	0	0	0	0;
	10294	7.9	33.2	99999	-99999	1.08819	74	1	12.1	7.9	0	0	0	0	0	0	0	0	0	0	0;
	10295	151.9	124.2	99999	-99999	0.99474	299	1	232.1	151.9	0	0	0	0	0	0	0	0	0	0	0;
	10296	197.3	132.4	99999	-99999	1.08634	461	1	301.4	197.3	0	0	0	0	0	0	0	0	0	0	0;
	24	110	89.2	140	-49	1.07767	235.3	1	221	110	0	0	0	0	0	0	0	0	0	0	0;
	25	135	-22	124	-22	1.0776	235.3	1	200	135	0	0	0	0	0	0	0	0	0	0	0;
	37	370	169.3	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	37	370	-19	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	370	34.1	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	370	2.3	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	39	370	94.4	190	-19	1.11	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	190	190	-19	1.04756	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	-19	190	-19	1.04756	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	40	370	-19	190	-19	1.04756	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-0.1	190	-19	1.04755	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-0.6	190	-19	1.04755	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	41	370	-0.6	190	-19	1.04755	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	57	110	37.2	152	-33	1.10991	235	1	215	110	0	0	0	0	0	0	0	0	0	0	0;
	57	171.6	152	152	-33	1.10991	235	1	220	125	0	0	0	0	0	0	0	0	0	0	0;
	58	125	149	149	-33	1.1097	235	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	58	0	0	149	-33	1	235	0	225	120	0	0	0	0	0	0	0	0	0	0	0;
	58	110	-33	149	-33	1.1097	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	59	225	149	149	-33	1.11	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	60	535	305.9	363	-47	1.05	588	1	535	255	0	0	0	0	0	0	0	0	0	0	0;
	61	278.8	-100	348	-100	1.04992	588	1	560	250	0	0	0	0	0	0	0	0	0	0	0;
	70	129	-11	105	-11	1.10739	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	129	59	105	-11	1.10739	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	0	0	99	-10	1	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	72	0	0	105	-11	1	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	72	129	-11	105	-11	1.04287	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	73	129	-10	99	-10	1.0429	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	73	129	-11	105	-11	1.0429	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	74	112	60	60	0	1.1043	120	1	112	0	0	0	0	0	0	0	0	0	0	0	0;
	94	220	131	131	-6	1.10247	270.6	1	220	125	0	0	0	0	0	0	0	0	0	0	0;
	94	225	97.3	131	-6	1.10247	270.6	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	95	225	131	131	-6	1.10442	270.6	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	95	225	131	131	-6	1.10442	270.6	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	95	225	-4.4	131	-6	1.10442	270.6	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	98	383	35.2	213	-31	1.05	426	1	383	220	0	0	0	0	0	0	0	0	0	0	0;
	98	380	-14.8	119	-31	1.05	435.3	1	380	220	0	0	0	0	0	0	0	0	0	0	0;
	115	12	0	0	0	1.09646	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	115	6	0	0	0	1.09646	6	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	121	0	0	120	-10	1	270.6	0	225	120	0	0	0	0	0	0	0	0	0	0	0;
	122	225	120	120	-10	1.10922	270.6	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	123	120	5.3	73	-1	1.10624	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	124	120	73	73	-1	1.10639	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	134	0	0	80	0	1	150	0	120	70	0	0	0	0	0	0	0	0	0	0	0;
	135	120	80	80	0	1.09923	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	136	80	31	31	0	1.07793	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	144	215	64.7	135	-35	1.10999	270.6	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	145	215	-35	135	-35	1.11	270.6	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	145	225	140	140	-35	1.11	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	146	225	-34.1	140	-36	1.04293	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	146	220	-34.1	137	-36	1.04293	270.6	1	220	135	0	0	0	0	0	0	0	0	0	0	0;
	152	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	152	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	153	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	153	0	0	72	-29	1	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	154	120	85	85	-15	1.0916	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	155	120	85	85	-15	1.0916	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	155	0	0	85	-15	1	150	0	120	94	0	0	0	0	0	0	0	0	0	0	0;
	169	0	0	25	0	1	51.4	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	90	-15	1	150	0	120	80	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	25	0	1	51.4	0	50	45	0	0	0	0	0	0	0	0	0	0	0;
	172	100	119	119	-31	1.06808	252.4	1	232	100	0	0	0	0	0	0	0	0	0	0	0;
	172	0	0	111	-21	1	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0;
	173	0	0	111	-21	1	237.5	0	205	135	0	0	0	0	0	0	0	0	0	0	0;
	173	0	0	102	-15	1	252.4	0	222	90	0	0	0	0	0	0	0	0	0	0	0;
	174	90	102	102	-15	1.03111	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	175	90	46.7	102	-15	1.03109	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	175	100	20.7	93	-10	1.03109	252.4	1	232	100	0	0	0	0	0	0	0	0	0	0	0;
	180	261	66.1	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	180	261	127	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	181	206	99	103	-17	1.11	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	181	261	123	127	-35	1.11	287.3	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	182	235	-38	145	-38	1.11	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	182	235	65.3	145	-38	1.11	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	183	206	103	103	-17	1.04854	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	183	206	103	103	-17	1.04854	238.4	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	191	200	104	104	-23	1.08579	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	192	200	104	104	-23	1.08551	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	192	0	0	104	-23	1	233.2	0	200	145	0	0	0	0	0	0	0	0	0	0	0;
	192	0	0	104	-23	1	233.2	0	200	145	0	0	0	0	0	0	0	0	0	0	0;
	193	464	294	294	-259	1.03481	464	1	464	208	0	0	0	0	0	0	0	0	0	0	0;
	208	188	100	100	0	1.06766	218.3	1	188	76	0	0	0	0	0	0	0	0	0	0	0;
	240	179	-62	105	-62	1.02448	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	240	179	-62	105	-62	1.02448	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	240	0	0	160	-100	1	209	0	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	241	179	-12.1	160	-100	1.02448	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	244	220	11.6	100	0	1.11	177.1	1	220	112.5	0	0	0	0	0	0	0	0	0	0	0;
	254	55	20	20	0	1.09551	78.8	1	55	23	0	0	0	0	0	0	0	0	0	0	0;
	254	43.5	20	20	0	1.09551	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	254	50	20	20	0	1.09551	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	254	23	20	20	0	1.09551	27.6	1	23	7	0	0	0	0	0	0	0	0	0	0	0;
	267	2.1	1	1	0	1.05867	0.7	1	2.1	0.5	0	0	0	0	0	0	0	0	0	0	0;
	268	2.1	1	1	0	1.07476	0.7	1	2.1	0.5	0	0	0	0	0	0	0	0	0	0	0;
	278	0	0	5	0	1	10.3	0	7.2	5.9	0	0	0	0	0	0	0	0	0	0	0;
	279	0	0	5	0	1	10.3	0	7.2	5.9	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.8	3.75	0	1.08251	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.8	3.75	0	1.08251	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.8	3.75	0	1.08251	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	295	5	3.8	3.75	0	1.08251	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	310	370	190	190	-19	0.99995	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	316	0	0	2	0	1	4	0	5.7	1	0	0	0	0	0	0	0	0	0	0	0;
	316	0	0	2	0	1	4	0	5.7	1	0	0	0	0	0	0	0	0	0	0	0;
	376	6.6	5	5	0	1.09167	8.4	1	6.6	5.4	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11164	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11164	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	379	0.9	1	1	0	1.11164	0.9	1	0.9	0.3	0	0	0	0	0	0	0	0	0	0	0;
	383	27	7	7	0	1.11072	31.3	1	27	11	0	0	0	0	0	0	0	0	0	0	0;
	383	30	7	7	0	1.11072	39	1	30	11	0	0	0	0	0	0	0	0	0	0	0;
	383	30	6	6	0	1.11072	40.6	1	30	9	0	0	0	0	0	0	0	0	0	0	0;
	384	55	15	15	0	1.11789	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	384	55	15	15	0	1.11789	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	385	40	11.7	15	0	1.11718	48.5	1	40	10	0	0	0	0	0	0	0	0	0	0	0;
	385	55	0	15	0	1.11718	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	387	50	20	20	0	1.11142	68.8	1	50	25	0	0	0	0	0	0	0	0	0	0	0;
	387	100	20	20	0	1.11142	147	1	100	55	0	0	0	0	0	0	0	0	0	0	0;
	388	60	40	40	0	1.11332	68.8	1	60	25	0	0	0	0	0	0	0	0	0	0	0;
	399	2.8	3	3	0	1.10809	3.8	1	2.8	2	0	0	0	0	0	0	0	0	0	0	0;
	433	1.7	1	1	0	1.08239	1.9	1	1.7	1.4	0	0	0	0	0	0	0	0	0	0	0;
	455	51.5	25.4	57	-22	1.1199	68.8	1	51.5	15	0	0	0	0	0	0	0	0	0	0	0;
	456	55	9.8	57	-22	1.11997	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	457	55	14.1	57	-22	1.11356	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	457	77	7.3	71	-28	1.11356	87.5	1	77	3	0	0	0	0	0	0	0	0	0	0	0;
	458	55	45	57	-22	1.11649	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	458	55	-22	57	-22	1.11649	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	478	121	38.2	137	-47	1.09916	235.3	1	226	120	0	0	0	0	0	0	0	0	0	0	0;
	478	13	12	12	0	1.09916	48.5	1	25	12	0	0	0	0	0	0	0	0	0	0	0;
	479	17	12	12	0	1.09548	48.5	1	17	10	0	0	0	0	0	0	0	0	0	0	0;
	482	4.4	2	2	0	1.10618	5.6	1	4.4	3.6	0	0	0	0	0	0	0	0	0	0	0;
	500	0.3	0.2	0.2	0	1.0928	0.4	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	522	6.6	4	4	0	1.08945	8.4	1	6.6	3	0	0	0	0	0	0	0	0	0	0	0;
	527	3.4	3	3	0	1.11109	4.6	1	3.4	2.8	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.1	4.7	3.8	1.09769	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.1	4.7	3.8	1.09769	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	532	6.5	4.1	4.7	3.8	1.09769	6.5	1	6.5	1	0	0	0	0	0	0	0	0	0	0	0;
	543	3	2	2	0	1.06047	4.1	1	3	2.4	0	0	0	0	0	0	0	0	0	0	0;
	572	0	0	2	0	1	4.6	0	3.5	2.9	0	0	0	0	0	0	0	0	0	0	0;
	597	1.7	0.7	0.7	0	1.08727	1.9	1	1.7	1	0	0	0	0	0	0	0	0	0	0	0;
	597	0	0	0.7	0	1	1.9	0	1.7	1	0	0	0	0	0	0	0	0	0	0	0;
	603	4.4	3	3	0	1.09264	5.6	1	4.4	3	0	0	0	0	0	0	0	0	0	0	0;
	670	52	2	35	2	1.08156	62.5	1	52	37	0	0	0	0	0	0	0	0	0	0	0;
	670	30	2	23	2	1.08156	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	670	105	6	85	6	1.08156	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	670	71.7	6	85	6	1.08156	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	671	30	2	23	2	1.1031	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	30	2	23	2	1.1031	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	27	2	25	2	1.1031	37.5	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	671	125	6	85	6	1.1031	150	1	125	68	0	0	0	0	0	0	0	0	0	0	0;
	671	105	73.9	85	6	1.1031	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	692	1.5	0	0.7	0	1.07855	1.9	1	1.5	1.3	0	0	0	0	0	0	0	0	0	0	0;
	694	1.4	1	1	0	1.06609	3.8	1	1.4	0	0	0	0	0	0	0	0	0	0	0	0;
	700	35	18	18	2	1.09876	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	700	20	30	30	2	1.09876	37.5	1	20	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.09829	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.09829	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	35	18	18	2	1.09829	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	701	97	65	65	6	1.09829	121.3	1	97	30	0	0	0	0	0	0	0	0	0	0	0;
	702	35	18	18	2	1.09885	37.5	1	35	9	0	0	0	0	0	0	0	0	0	0	0;
	702	30	18	18	2	1.09885	37.5	1	30	9	0	0	0	0	0	0	0	0	0	0	0;
	702	28	14	14	2	1.09885	31.5	1	28	9	0	0	0	0	0	0	0	0	0	0	0;
	735	8	4	4	0	1.09514	5.3	1	8	1	0	0	0	0	0	0	0	0	0	0	0;
	735	2	2	2	0	1.09514	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	752	4.4	4.5	4.5	0.2	1.09801	5.8	1	4.4	3.6	0	0	0	0	0	0	0	0	0	0	0;
	766	2.7	0	0	0	1.09463	5.8	1	2.7	0	0	0	0	0	0	0	0	0	0	0	0;
	775	4.9	0	0	0	1.09067	4	1	4.9	0	0	0	0	0	0	0	0	0	0	0	0;
	798	93	0	30	0	1.1109	65	1	93	0	0	0	0	0	0	0	0	0	0	0	0;
	798	35.9	26.8	30	0	1.1109	65	1	35.9	0	0	0	0	0	0	0	0	0	0	0	0;
	801	0	0	0	0	1	12.4	0	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	808	6	0	0	0	1.0959	4.7	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	809	6	0	0	0	1.09617	5.8	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	846	130	-33	149	-33	1.10183	235	1	225	130	0	0	0	0	0	0	0	0	0	0	0;
	847	110	95	149	-33	1.102	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	854	2.5	0	0	0	1.07784	3	1	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	860	12	0	0	0	1.09411	12.4	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	870	170	30	30	0	1.11412	167.6	1	170	66	0	0	0	0	0	0	0	0	0	0	0;
	870	61	30	30	0	1.11412	71.6	1	61	34	0	0	0	0	0	0	0	0	0	0	0;
	876	21	0	0	0	1.10623	8.3	1	21	0	0	0	0	0	0	0	0	0	0	0	0;
	890	7	0	0	0	1.10622	5.6	1	7	0	0	0	0	0	0	0	0	0	0	0	0;
	893	0	0	0	0	1	3	0	10	0	0	0	0	0	0	0	0	0	0	0	0;
	908	30.4	0	0	0	1.1056	3	1	30.4	0	0	0	0	0	0	0	0	0	0	0	0;
	913	2	0	0	0	1.06476	0	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	918	0	0	0	0	1	1	0	1.9	0	0	0	0	0	0	0	0	0	0	0	0;
	929	0	0	0	0	1	2.1	0	2	1.3	0	0	0	0	0	0	0	0	0	0	0;
	934	129	49.8	105	-11	1.11929	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	936	36	9	30	0	1.09004	36.8	1	36	0	0	0	0	0	0	0	0	0	0	0	0;
	939	0	0	0	0	1	2.8	0	2.7	1.8	0	0	0	0	0	0	0	0	0	0	0;
	959	101	12.9	30	0	1.10245	100.8	1	101	49	0	0	0	0	0	0	0	0	0	0	0;
	965	0	0	0	0	1	1.7	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	980	12	21.4	30	0	1.09713	9.5	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	982	0	0	0	0	1	1.6	0	1.6	0.9	0	0	0	0	0	0	0	0	0	0	0;
	984	6	0	0	0	1.10468	5.9	1	6	1	0	0	0	0	0	0	0	0	0	0	0;
	989	8.3	0	0	0	1.09354	10.9	1	8.3	0	0	0	0	0	0	0	0	0	0	0	0;
	993	68	10.4	23	0	1.10203	52	1	68	5	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	23	0	1	52	0	68	5	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	11	0	1	24.5	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	993	0	0	10	0	1	24.5	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	1008	0	0	10	0	1	69	0	50	0	0	0	0	0	0	0	0	0	0	0	0;
	1008	92	35.4	74	-15	1.11134	57.6	1	125	92	0	0	0	0	0	0	0	0	0	0	0;
	1009	84	52.9	74	-15	1.09769	57.6	1	125	84	0	0	0	0	0	0	0	0	0	0	0;
	1009	0	0	10	0	1	40	0	30	0	0	0	0	0	0	0	0	0	0	0	0;
	1021	2.5	0	0	0	1.0998	3.3	1	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1049	3.4	0	0	0	1.0812	3.8	1	3.4	2.2	0	0	0	0	0	0	0	0	0	0	0;
	1056	0	0	0	0	1	25	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	25	0	0	0	1.08399	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	31	0	0	0	1.08399	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1056	31	0	0	0	1.08399	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1087	78	26.8	41.2	0	1.10464	92.9	1	78	10.5	0	0	0	0	0	0	0	0	0	0	0;
	1111	0	0	45	-10	1	63	0	48	40	0	0	0	0	0	0	0	0	0	0	0;
	1111	55	15	45	-10	1.11109	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1112	55	37.4	45	-10	1.11258	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1188	113	50	110	-40	1.1174	149	1	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1189	113	64.3	110	-40	1.11671	149	1	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1193	16.8	0	0	0	1.10337	16.8	1	16.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1214	386	148.4	216	32	1.12	426	1	386	220	0	0	0	0	0	0	0	0	0	0	0;
	1215	383	132.4	187	-31	1.12	426	1	383	220	0	0	0	0	0	0	0	0	0	0	0;
	1219	0	0	0	0	1	6	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	1220	135	39	110	-40	1.12	169.4	1	135	34.5	0	0	0	0	0	0	0	0	0	0	0;
	1226	0	0	0	0	1	12.8	0	12.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1226	0	0	0	0	1	12.5	0	12.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1227	20	0	0	0	1.0997	20	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1227	20	0	0	0	1.0997	20	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1228	0	0	0	0	1	19	0	19	0	0	0	0	0	0	0	0	0	0	0	0;
	1237	24	18	18	9	1.0991	32	1	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1238	0	0	18	9	1	32	0	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1239	29	14	14	10.5	1.09898	32.2	1	29	10	0	0	0	0	0	0	0	0	0	0	0;
	1330	50	37.5	37.5	16.8	1.11278	62.5	1	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1330	0	0	37.5	16.8	1	62.5	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1330	0	0	37.5	16.8	1	62.5	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1331	50	37.5	37.5	16.8	1.10411	62.5	1	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1354	0	0	0	0	1	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	0	0	0	0	1	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	25	0	0	0	1.08588	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1354	25	0	0	0	1.08588	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1371	25	0	0	0	1.08095	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1372	25	0	0	0	1.08082	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1373	25	0	0	0	1.08158	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1373	0	0	0	0	1	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	1400	70	17.9	52.5	0	1.1055	87.5	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1401	0	0	42	16.8	1	62.5	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	1401	70	52.5	52.5	0	1.11067	87.5	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1408	50	0	0	0	1.10045	50	1	50	10	0	0	0	0	0	0	0	0	0	0	0;
	1469	0	0	0	0	1	24	0	24	5	0	0	0	0	0	0	0	0	0	0	0;
	1469	16.5	0	0	0	1.10925	16.5	1	16.5	4	0	0	0	0	0	0	0	0	0	0	0;
	1470	14.6	0	0	0	1.10921	14.6	1	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1470	0	0	0	0	1	14.6	0	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1470	0	0	0	0	1	14.6	0	14.6	3	0	0	0	0	0	0	0	0	0	0	0;
	1471	5.5	0	0	0	1.09262	5.5	1	5.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1471	0	0	0	0	1	5.5	0	5.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1505	0	0	0	0	1	7.5	0	7.5	0	0	0	0	0	0	0	0	0	0	0	0;
	1505	0	0	0	0	1	8	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	1511	55	41	41	-6.5	1.10715	68.8	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	1512	230	109.1	113	-5	1.12	270.6	1	230	120	0	0	0	0	0	0	0	0	0	0	0;
	1513	225	120	120	-10	1.11542	270.6	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	1570	0	0	0	0	1	18	0	18	0	0	0	0	0	0	0	0	0	0	0	0;
	1570	32	0	0	0	1.09424	32	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	1570	25	0	0	0	1.09424	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1578	120	73	73	-1	1.10817	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1579	120	13.5	73	-1	1.10283	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1580	120	30.9	73	-1	1.11987	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0;
	1580	0	0	73	-1	1	150	0	110	79	0	0	0	0	0	0	0	0	0	0	0;
	1590	125	83	83	-5	1.12	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1590	125	63.3	83	-5	1.12	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1601	119	27.4	80	-25	1.07976	150	1	119	80	0	0	0	0	0	0	0	0	0	0	0;
	1602	117	1.2	80	-25	1.07966	150	1	117	80	0	0	0	0	0	0	0	0	0	0	0;
	1603	110	22.3	80	-25	1.06726	150	1	110	65	0	0	0	0	0	0	0	0	0	0	0;
	1603	100	-25	80	-25	1.06726	150	1	100	65	0	0	0	0	0	0	0	0	0	0	0;
	1644	0	0	41.2	-13.7	1	68.8	0	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1644	0	0	33.5	12	1	20	0	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1644	55	25.9	41.2	-13.7	1.09788	68.8	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1659	12	0	0	0	1.09025	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1659	12	0	0	0	1.09025	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1660	4	0	0	0	1.08791	6.7	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1660	4	0	0	0	1.08791	6.7	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1661	15	0	0	0	1.09573	15	1	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1662	22	0	0	0	1.09678	22	1	22	0	0	0	0	0	0	0	0	0	0	0	0;
	1666	225	56.5	131	-6	1.10681	270.6	1	225	125	0	0	0	0	0	0	0	0	0	0	0;
	1688	46	35	35	-6	1.08003	53	1	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1689	0	0	35	-6	1	53	0	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	9.3	9.3	1.9	1.10001	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	9.3	9.3	1.9	1.10001	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	9.3	9.3	1.9	1.10001	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1872	3.8	0	0	0	1.10001	3.8	1	3.8	0	0	0	0	0	0	0	0	0	0	0	0;
	1872	4.2	0	0	0	1.10001	4.2	1	4.2	0	0	0	0	0	0	0	0	0	0	0	0;
	1872	14	9.3	9.3	2	1.10001	15.6	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1900	123	74.8	80	0	1.11831	150	1	123	70	0	0	0	0	0	0	0	0	0	0	0;
	1900	86.4	0	79	0	1.11831	150	1	128	70	0	0	0	0	0	0	0	0	0	0	0;
	1901	127.2	45.1	114	-27	1.08482	190.9	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1902	76.5	15.5	114	-27	1.09186	190.9	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1910	0	0	37	0	1	62.5	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	1910	80	0	15	0	1.07834	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1911	0	0	42	16.8	1	62.5	0	45	35	0	0	0	0	0	0	0	0	0	0	0;
	1911	0	0	42	16.8	1	62.5	0	45	35	0	0	0	0	0	0	0	0	0	0	0;
	1911	110	15	15	0	1.07341	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1911	110	31	31	0	1.07341	117.5	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	2018	40	26	26	13	1.10106	50	1	40	5	0	0	0	0	0	0	0	0	0	0	0;
	2062	225	61.5	140	-35	1.12	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2063	194.1	24.9	140	-35	1.10481	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2064	225	116	140	-35	1.10942	270.6	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2094	0	0	26	13	1	43.8	0	35	18	0	0	0	0	0	0	0	0	0	0	0;
	2094	8	8.3	8.3	1.5	1.10162	13.8	1	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2094	25	12	12	5.8	1.10162	31.3	1	25	18	0	0	0	0	0	0	0	0	0	0	0;
	2095	0	0	26	13	1	43.8	0	30	18	0	0	0	0	0	0	0	0	0	0	0;
	2130	32	0	0	0	1.08359	32	1	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2131	32	0	0	0	1.08354	32	1	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2150	10.5	0	0	0	1.06756	10.5	1	10.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2150	0	0	0	0	1	10.5	0	10.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2152	120	53	85	-15	1.12	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	2153	120	30.2	85	-15	1.11998	150	1	120	94	0	0	0	0	0	0	0	0	0	0	0;
	2168	1.8	0	0	0	1.102	4	1	1.8	0.5	0	0	0	0	0	0	0	0	0	0	0;
	2183	4.9	0	0	0	1.08218	1.5	1	4.9	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2187	0.3	0	0	0	1.06445	1.5	1	0.3	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2189	50	30	30	0	1.08651	50	1	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2190	50	30	30	0	1.08732	50	1	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2216	90	117	117	-19	1.09482	252.4	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	2222	0	0	8	0	1	27.3	0	28	-5	0	0	0	0	0	0	0	0	0	0	0;
	2222	29	8	8	0	1.06232	28.5	1	29	-5	0	0	0	0	0	0	0	0	0	0	0;
	2222	28	8	8	0	1.06232	27.3	1	28	-5	0	0	0	0	0	0	0	0	0	0	0;
	2226	55	49	49	-7	1.08961	57	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	2226	100	91	91	-17	1.08961	128.1	1	100	50	0	0	0	0	0	0	0	0	0	0	0;
	2227	106	89	89	-16	1.08886	150.4	1	106	70	0	0	0	0	0	0	0	0	0	0	0;
	2232	2.2	0	0	0	0.98707	1.5	1	2.2	0.3	0	0	0	0	0	0	0	0	0	0	0;
	2233	0	0	0	0	1	1.5	0	1.3	0.3	0	0	0	0	0	0	0	0	0	0	0;
	2236	0	0	0	0	1	3.3	0	2.9	2.3	0	0	0	0	0	0	0	0	0	0	0;
	2238	6	0	0	0	1.05968	5.3	1	6	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2239	54.5	15	15	0	1.06525	56.5	1	54.5	10	0	0	0	0	0	0	0	0	0	0	0;
	2239	6	2	2	0	1.06525	6.3	1	6	3	0	0	0	0	0	0	0	0	0	0	0;
	2240	5	2	2	0	1.06381	5.4	1	5	0.7	0	0	0	0	0	0	0	0	0	0	0;
	2240	28.5	10	10	0	1.06381	30.2	1	28.5	20.5	0	0	0	0	0	0	0	0	0	0	0;
	2253	4.4	0	0	0	1.03233	5.3	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2261	30	0	0	0	1.0575	35	1	30	5	0	0	0	0	0	0	0	0	0	0	0;
	2265	11.5	0	0	0	1.06385	15.3	1	11.5	2	0	0	0	0	0	0	0	0	0	0	0;
	2267	0	0	90	-15	1	150	0	120	80	0	0	0	0	0	0	0	0	0	0	0;
	2273	6.5	0	0	0	1.0712	3.8	1	6.5	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2282	0	0	0	0	1	4.5	0	4	3.2	0	0	0	0	0	0	0	0	0	0	0;
	2284	2.7	0	0	0	1.07915	3	1	2.7	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2286	2.7	0	0	0	1.05861	3	1	2.7	1.3	0	0	0	0	0	0	0	0	0	0	0;
	2290	0	0	0	0	1	3	0	2.6	0.5	0	0	0	0	0	0	0	0	0	0	0;
	2291	0	0	1	0	1	3.2	0	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2291	4	2	2	0	1.05595	4.5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2293	0	0	0	0	1	0.6	0	0.6	0.5	0	0	0	0	0	0	0	0	0	0	0;
	2295	4.4	0	0	0	1.05738	5.3	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2299	1.3	0	0	0	1.06035	1.5	1	1.3	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2306	9.9	0	0	0	1.05321	11.3	1	9.9	2	0	0	0	0	0	0	0	0	0	0	0;
	2316	0	0	0	0	1	1.5	0	1.3	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2319	50	25	25	0	1.09487	51.4	1	50	40	0	0	0	0	0	0	0	0	0	0	0;
	2320	0	0	25	0	1	51.4	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	2320	28	5.6	12	0	1.12	29.7	1	28	20	0	0	0	0	0	0	0	0	0	0	0;
	2322	55	22.6	25	0	1.08997	56.3	1	55	35	0	0	0	0	0	0	0	0	0	0	0;
	2325	9.9	0	0	0	1.05009	11.3	1	9.9	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2350	4.4	0	0	0	1.01775	5	1	4.4	2.4	0	0	0	0	0	0	0	0	0	0	0;
	2355	4.4	0	0	0	1.03548	5	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2372	3.5	0	0	0	1.10563	4	1	3.5	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2410	1.7	0	0	0	1.05713	1.9	1	1.7	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2411	0.2	0	0	0	1.05411	0.3	1	0.2	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2411	1.3	0	0	0	1.05411	1.5	1	1.3	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2436	1.3	0	0	0	1.07973	1.5	1	1.3	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2437	0.3	0	0	0	1.06232	0.4	1	0.3	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2439	6.1	0	0	0	1.03467	7.3	1	6.1	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2440	0	0	0	0	1	3.5	0	3.1	2.5	0	0	0	0	0	0	0	0	0	0	0;
	2442	4.4	0	0	0	1.07426	5	1	4.4	2	0	0	0	0	0	0	0	0	0	0	0;
	2449	200	81.8	104	-23	1.12	233.2	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	2450	200	78.1	111	-18	1.12	233.2	1	200	145	0	0	0	0	0	0	0	0	0	0	0;
	2462	2.9	0	0	0	1.07148	3.5	1	2.9	1.4	0	0	0	0	0	0	0	0	0	0	0;
	2463	0.3	0	0	0	1.08265	0.4	1	0.3	0.3	0	0	0	0	0	0	0	0	0	0	0;
	2470	20.3	0	0	0	1.01532	25	1	20.3	8	0	0	0	0	0	0	0	0	0	0	0;
	2488	67	15	15	0	1.0376	66.7	1	67	40	0	0	0	0	0	0	0	0	0	0	0;
	2489	65	15	15	0	1.03753	66.7	1	65	40	0	0	0	0	0	0	0	0	0	0	0;
	2497	0.3	0	0	0	1.07102	0.4	1	0.3	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2500	5.5	0	0	0	1.08783	6.3	1	5.5	1	0	0	0	0	0	0	0	0	0	0	0;
	2506	1	0	0	0	1.08055	0.4	1	1	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2508	4.4	0	0	0	1.02067	5	1	4.4	2.2	0	0	0	0	0	0	0	0	0	0	0;
	2512	30.6	0	0	0	1.02788	16	1	30.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2513	30.6	0	0	0	1.02788	16	1	30.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2515	6.5	0	0	0	1.06303	7.3	1	6.5	2	0	0	0	0	0	0	0	0	0	0	0;
	2531	1.3	0	0	0	1.08153	1.5	1	1.3	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2532	1	0	0	0	1.0578	0.4	1	1	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2534	6.1	0	0	0	1.09285	7.3	1	6.1	2	0	0	0	0	0	0	0	0	0	0	0;
	2540	0	0	0	0	1	2.5	0	2.2	1.8	0	0	0	0	0	0	0	0	0	0	0;
	2542	5.6	0	0	0	1.03175	7.3	1	5.6	3.2	0	0	0	0	0	0	0	0	0	0	0;
	2544	4.4	0	0	0	1.03511	5	1	4.4	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2557	10	0	0	0	1.08268	5	1	10	2.2	0	0	0	0	0	0	0	0	0	0	0;
	2562	1.7	0	0	0	1.03812	1.9	1	1.7	1.4	0	0	0	0	0	0	0	0	0	0	0;
	2563	4.4	0	0	0	1.05986	5	1	4.4	2	0	0	0	0	0	0	0	0	0	0	0;
	2565	0	0	15	0	1	58	0	56	10	0	0	0	0	0	0	0	0	0	0	0;
	2565	0	0	6	0	1	19	0	18	3	0	0	0	0	0	0	0	0	0	0	0;
	2565	4	2	2	0	1.0398	4.5	1	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2568	0.5	0	0	0	0.98435	0.3	1	0.5	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2580	94	70.3	145	-38	1.11945	263.9	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	2592	50	30	30	0	1.11589	50	1	50	32	0	0	0	0	0	0	0	0	0	0	0;
	2592	108	70	70	0	1.11589	128.1	1	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2593	108	70	70	0	1.0917	128.1	1	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2598	16.4	0	0	0	1.08212	12.4	1	16.4	2.1	0	0	0	0	0	0	0	0	0	0	0;
	2604	9.7	0	0	0	1.08652	5.3	1	9.7	2.2	0	0	0	0	0	0	0	0	0	0	0;
	2608	0.3	0	0	0	1.08183	0.4	1	0.3	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2611	1.1	0	0	0	1.07974	1.5	1	1.1	0.6	0	0	0	0	0	0	0	0	0	0	0;
	2618	0	0	0	0	1	1.3	0	1.1	0.9	0	0	0	0	0	0	0	0	0	0	0;
	2677	0	0	10	0	1	15.6	0	12	3	0	0	0	0	0	0	0	0	0	0	0;
	2677	10.5	10	10	0	1.06188	14.5	1	10.5	3	0	0	0	0	0	0	0	0	0	0	0;
	2684	1.2	0	0	0	1.05149	1.5	1	1.2	0.5	0	0	0	0	0	0	0	0	0	0	0;
	2685	0	0	0	0	1	3.8	0	3.3	2.7	0	0	0	0	0	0	0	0	0	0	0;
	2694	0.9	0	0	0	1.10225	1	1	0.9	0	0	0	0	0	0	0	0	0	0	0	0;
	2694	0	0	0	0	1	0	0	3.1	0	0	0	0	0	0	0	0	0	0	0	0;
	2697	50	5	37.5	5	1.11894	62.5	1	50	0	0	0	0	0	0	0	0	0	0	0	0;
	2697	32	5	24	5	1.11894	40	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	0	0	15	5	1	40.6	0	35	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	55	6	41.25	6	1.11891	68.7	1	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	55	6	41.7	6	1.11891	68.7	1	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2700	0.5	0	1	0	1.08335	0.5	1	0.5	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2706	3	1	1	0	1.06238	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2714	0.4	0	0	0	1.07782	3	1	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2717	55	35	35	4	1.09327	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2718	55	23.7	35	4	1.09312	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2719	0	0	5	0	1	5.7	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2726	0.7	0	0	0	1.03804	0.3	1	0.7	0.2	0	0	0	0	0	0	0	0	0	0	0;
	2729	0.3	0	0	0	1.03567	1.5	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2730	0.4	0	0	0	1.0769	0.4	1	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2731	0.9	0	0	0	1.08197	0.6	1	0.9	0	0	0	0	0	0	0	0	0	0	0	0;
	2733	0.7	0.1	0.1	0	1.02508	2.7	1	0.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2736	0	0	0	0	1	12.9	0	11	0	0	0	0	0	0	0	0	0	0	0	0;
	2736	20	0	0	0	1.0885	22	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	2739	28	10	10	0	1.06107	30.9	1	28	4	0	0	0	0	0	0	0	0	0	0	0;
	2739	0	0	5	0	1	15.5	0	13.2	2	0	0	0	0	0	0	0	0	0	0	0;
	2740	13.2	5	5	0	1.06115	15.5	1	13.2	2	0	0	0	0	0	0	0	0	0	0	0;
	2745	5.9	0	0	0	1.0805	7	1	5.9	0	0	0	0	0	0	0	0	0	0	0	0;
	2749	0	0	18.7	4	1	31.2	0	25	15	0	0	0	0	0	0	0	0	0	0	0;
	2749	55	19.7	35	6	1.10366	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2749	55	14.1	35	4	1.10366	68.7	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2750	55	5.2	39	3	1.10434	65.6	1	55	24	0	0	0	0	0	0	0	0	0	0	0;
	2750	55	35	35	3.5	1.10434	68.7	1	55	25	0	0	0	0	0	0	0	0	0	0	0;
	2757	0	0	0	0	1	7.9	0	6.6	5.4	0	0	0	0	0	0	0	0	0	0	0;
	2759	22	0	0	0	1.08766	22	1	22	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2764	2.8	0	0	0	1.11283	3.9	1	2.8	0	0	0	0	0	0	0	0	0	0	0	0;
	2777	4	1	3	1	1.11558	5	1	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	3	0	1	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	16	12	12	0	1.0845	20	1	16	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	20	15	15	0	1.0845	25	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	2789	12.4	4.9	9.3	1	1.10869	15.5	1	12.4	5	0	0	0	0	0	0	0	0	0	0	0;
	2789	0	0	9.3	1	1	15.5	0	12.4	5	0	0	0	0	0	0	0	0	0	0	0;
	2791	40.5	1	1	0	1.09425	40.5	1	40.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2795	7.7	0	0	0	1.09614	8.8	1	7.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2800	0.6	0	0	0	1.08107	4.5	1	0.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2801	2	0	0	0	1.08069	3.2	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	2805	5	0	0	0	1.08054	7.4	1	5	3.6	0	0	0	0	0	0	0	0	0	0	0;
	2806	0	0	1.27	0	1	2.5	0	1.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	25	18.8	18.78	0	1.08715	31.3	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	34.6	26	25.95	0	1.08715	43.3	1	34.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2810	0	0	18.78	0	1	31.3	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2816	0	0	0	0	1	1.9	0	1.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2821	0.2	0	0	0	1.07554	2.1	1	0.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2827	0	0	0	0	1	0.4	0	0.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	13.2	10.5	10.5	0	1.08008	17.5	1	13.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	0	0	3.75	0	1	6.2	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	0	0	3.75	0	1	6.2	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2831	13.2	10.5	10.5	0	1.08007	17.5	1	13.2	0	0	0	0	0	0	0	0	0	0	0	0;
	2833	0.5	0	0	0	1.08637	2.3	1	0.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2834	20	0	18.75	0	1.09579	31.3	1	20	4.5	0	0	0	0	0	0	0	0	0	0	0;
	2845	6.3	0	0	0	1.11098	8.1	1	6.3	5.1	0	0	0	0	0	0	0	0	0	0	0;
	2851	0.6	0	0	0	1.08826	0.6	1	0.6	0	0	0	0	0	0	0	0	0	0	0	0;
	2857	0	0	0	0	1	0.3	0	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2862	1.7	0.5	0.5	0	1.08609	2	1	1.7	1.4	0	0	0	0	0	0	0	0	0	0	0;
	2869	0	0	0	0	1	3.2	0	2.8	0	0	0	0	0	0	0	0	0	0	0	0;
	2890	0.3	0	0	0	1.06829	0.2	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2893	3	0	0	0	1.09501	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2893	0	0	0	0	1	0	0	2.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2897	14.7	0	0	0	1.10205	16.8	1	14.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2899	0.3	0.1	0.1	0	1.06267	0.2	1	0.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2908	1.3	0	0	0	1.09933	1.5	1	1.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2920	1	0	0	0	1.08424	6.1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2924	0.1	0	0	0	1.05662	0.1	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	2929	0.1	0	0	0	1.08288	4.9	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2934	4.1	0	0	0	1.05968	4.6	1	4.1	0	0	0	0	0	0	0	0	0	0	0	0;
	2938	0	0	0.36	0	1	0.6	0	0.5	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	0	0	8	0	1	13.7	0	11.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	0	0	6.8	0	1	11.3	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	32	20.4	24	0	1.11284	40	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	2943	40	22.4	26	0	1.11284	48	1	40	0	0	0	0	0	0	0	0	0	0	0	0;
	2947	0	0	0	0	1	23.2	0	18.3	0	0	0	0	0	0	0	0	0	0	0	0;
	2954	0	0	1	0	1	5.5	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	2959	50	0	1	0	1.09101	50	1	50	0.1	0	0	0	0	0	0	0	0	0	0	0;
	2960	0	0	0	0	1	4.2	0	3.4	0	0	0	0	0	0	0	0	0	0	0	0;
	2964	8.8	0	0	0	1.08689	10.1	1	8.8	0	0	0	0	0	0	0	0	0	0	0	0;
	2966	0.1	0	0	0	1.07898	1.5	1	0.1	0	0	0	0	0	0	0	0	0	0	0	0;
	2968	0	0	15	0	1	32.2	0	28	0	0	0	0	0	0	0	0	0	0	0	0;
	2972	26.7	17	17	-10	1.10894	31.8	1	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2972	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	0	0	17	-10	1	31.8	0	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2973	26.7	17	17	-10	1.10884	31.8	1	26.7	0	0	0	0	0	0	0	0	0	0	0	0;
	2984	0	0	0	0	1	32.2	0	28	10	0	0	0	0	0	0	0	0	0	0	0;
	2991	4	2.2	2.2	0.5	1.09698	4.4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2991	4	2.2	2.2	0.5	1.09698	4.4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2994	0	0	22	-2.5	1	57	0	54	37	0	0	0	0	0	0	0	0	0	0	0;
	2994	52	8	22	8	1.0959	55.5	1	52	41	0	0	0	0	0	0	0	0	0	0	0;
	2995	51	8	22	8	1.09593	55.5	1	51	41	0	0	0	0	0	0	0	0	0	0	0;
	3005	18	2	2	0	1.07282	20	1	18	0	0	0	0	0	0	0	0	0	0	0	0;
	3006	0	-1.5	9999	-9999	1.0469	482.3	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3007	0	73	9999	-9999	1.07307	7776.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3008	0	-98.6	9999	-9999	1.0458	22373.8	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3010	0	220.2	9999	-9999	1.049	33044.7	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3011	0	148.8	9999	-9999	1.06429	7212.2	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3012	0	-405.9	9999	-9999	1.02688	15218.9	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	10330	10331	1e-05	8e-05	0	99999	19052	19052	0	0	1	-360	360;
	10300	10355	0.05932	0.20245	0	99999	19052	19052	0	0	1	-360	360;
	10300	10360	0.02058	0.05185	0	99999	19052	19052	0	0	1	-360	360;
	10367	10201	2e-05	-0.04958	0	99999	200	200	0.999	0	1	-360	360;
	10367	10202	6e-05	0.08346	0	99999	200	200	0.99999	0	1	-360	360;
	10366	10367	0.0026	0.25917	0	99999	200	200	0.99999	0	1	-360	360;
	10368	10215	2e-05	-0.04961	0	99999	200	200	0.999	0	1	-360	360;
	10368	10216	6e-05	0.08373	0	99999	200	200	0.99999	0	1	-360	360;
	10369	10368	0.0026	0.26125	0	99999	200	200	0.99999	0	1	-360	360;
	10090	10083	8e-05	0.00079	0.41456	99999	1247	1247	0	0	1	-360	360;
	10138	10164	0.00168	0.01733	0.75504	99999	1746	1746	0	0	1	-360	360;
	10139	10109	0.00071	0.00594	0.27872	99999	1386	1386	0	0	1	-360	360;
	10139	10144	0.00075	0.00681	0.312	99999	1386	1386	0	0	1	-360	360;
	10139	10153	0.00194	0.02	0.8336	99999	1386	1386	0	0	1	-360	360;
	10140	10110	0.00071	0.00594	0.27872	99999	1386	1386	0	0	1	-360	360;
	10140	10143	0.00075	0.00681	0.312	99999	1386	1386	0	0	1	-360	360;
	10140	10153	0.00194	0.02	0.8336	99999	1386	1386	0	0	1	-360	360;
	10141	10153	0.00233	0.01696	0.70784	99999	1746	1746	0	0	1	-360	360;
	10090	10085	0.00017	0.00148	1.23008	99999	1247	1247	0	0	1	-360	360;
	10141	10158	0.00204	0.01707	0.71344	99999	1746	1746	0	0	1	-360	360;
	10141	10158	0.00204	0.01707	0.71344	99999	1746	1746	0	0	1	-360	360;
	10143	10144	1e-05	6e-05	0	99999	1732	1732	0	0	1	-360	360;
	10143	10153	0.00169	0.01381	0.6496	99999	1386	1386	0	0	1	-360	360;
	10143	10156	0.00119	0.00969	0.4544	99999	1386	1386	0	0	1	-360	360;
	10144	10126	0.00306	0.02537	1.19168	99999	1386	1386	0	0	1	-360	360;
	10144	10153	0.00169	0.01381	0.6496	99999	1386	1386	0	0	1	-360	360;
	10144	10165	0.00244	0.02044	0.9584	99999	831	831	0	0	1	-360	360;
	10091	10090	9e-05	0.00106	1.10432	99999	1247	1247	0	0	1	-360	360;
	10145	10147	0.00194	0.01606	0.75456	99999	1787	1787	0	0	1	-360	360;
	10145	10158	0.00189	0.01232	0.61088	99999	1746	1746	0	0	1	-360	360;
	10171	10094	0	6e-05	0	99999	1593	1593	0	0	1	-360	360;
	10145	10082	0.00091	0.00923	0.39197	99999	1642	1642	0	0	1	-360	360;
	10145	10082	0.00091	0.00923	0.39197	99999	1642	1642	0	0	1	-360	360;
	10146	10154	0.00503	0.01845	0.05812	99999	408	408	0	0	1	-360	360;
	10172	10095	0	6e-05	0	99999	1386	1386	0	0	1	-360	360;
	10147	10153	0.00156	0.01288	0.6032	99999	1386	1386	0	0	1	-360	360;
	10173	10095	0	6e-05	0	99999	1386	1386	0	0	1	-360	360;
	10147	10153	0.00156	0.01288	0.6032	99999	1386	1386	0	0	1	-360	360;
	10174	10096	2e-05	0.00016	0.0008	99999	1386	1386	0	0	1	-360	360;
	10147	10161	0.00113	0.00962	0.4528	99999	1787	1787	0	0	1	-360	360;
	10176	10098	0.00029	0.00219	0.11056	99999	1386	1386	0	0	1	-360	360;
	10177	10098	0.00029	0.00219	0.11056	99999	1386	1386	0	0	1	-360	360;
	10147	10169	0.00041	0.00423	0.18496	99999	1386	1386	0	0	1	-360	360;
	10147	10170	0.00041	0.00423	0.18496	99999	1386	1386	0	0	1	-360	360;
	10091	10090	9e-05	0.00106	1.10432	99999	1247	1247	0	0	1	-360	360;
	10147	10037	0.00105	0.00925	0.37437	99999	1386	1386	0	0	1	-360	360;
	10147	10037	0.00105	0.00925	0.37437	99999	1386	1386	0	0	1	-360	360;
	10148	10136	0.00293	0.01074	0.03436	99999	408	408	0	0	1	-360	360;
	10148	10149	2e-05	0.0001	0	99999	762	762	0	0	1	-360	360;
	10149	10136	0.00293	0.01074	0.03436	99999	408	408	0	0	1	-360	360;
	10149	10162	0.01595	0.06457	0.17037	99999	301	301	0	0	1	-360	360;
	10151	10147	0.00188	0.01925	0.8432	99999	1386	1386	0	0	1	-360	360;
	10152	10164	0.00364	0.03742	1.6384	99999	1746	1746	0	0	1	-360	360;
	10156	10165	0.00131	0.011	0.5168	99999	831	831	0	0	1	-360	360;
	10158	10081	0.00127	0.0132	0.5505	99999	1746	1746	0	0	1	-360	360;
	10091	10164	0.0023	0.02084	0.8752	99999	1746	1746	0	0	1	-360	360;
	10159	10163	0.00517	0.03967	0.12439	99999	457	457	0	0	1	-360	360;
	10159	10163	0.00517	0.03967	0.12439	99999	457	457	0	0	1	-360	360;
	10160	10137	0.0099	0.03659	0.11674	99999	343	343	0	0	1	-360	360;
	10161	10145	0.00088	0.007	0.3296	99999	1787	1787	0	0	1	-360	360;
	10162	10122	0.00527	0.0193	0.06156	99999	408	408	0	0	1	-360	360;
	10162	10122	0.00527	0.0193	0.06156	99999	408	408	0	0	1	-360	360;
	10164	10165	0.00323	0.03369	1.40518	99999	1746	1746	0	0	1	-360	360;
	10164	10080	6e-05	0.00059	0.02467	99999	1746	1746	0	0	1	-360	360;
	10092	10089	0.00046	0.00474	0.01943	99999	960	960	0	0	1	-360	360;
	10164	10080	6e-05	0.00059	0.02467	99999	1746	1746	0	0	1	-360	360;
	10165	10091	0.00067	0.00696	0.2904	99999	1746	1746	0	0	1	-360	360;
	10167	10169	8e-05	0.00067	0.02976	99999	1884	1884	0	0	1	-360	360;
	10168	10170	8e-05	0.00067	0.02976	99999	1884	1884	0	0	1	-360	360;
	10310	10311	8e-05	0.00041	0	99999	111	111	0	0	1	-360	360;
	10330	10359	0.01322	0.04793	0.0092	99999	204	204	0	0	1	-360	360;
	10331	10359	0.01322	0.04793	0.0092	99999	204	204	0	0	1	-360	360;
	10092	10157	0.00627	0.02339	0.07357	99999	343	343	0	0	1	-360	360;
	10346	10347	8e-05	0.00041	0	99999	150	150	0	0	1	-360	360;
	10359	10310	0.02975	0.10992	0.0219	99999	204	204	0	0	1	-360	360;
	10359	10311	0.02975	0.10992	0.0219	99999	204	204	0	0	1	-360	360;
	10359	10346	0.01157	0.04298	0.00859	99999	183	183	0	0	1	-360	360;
	10359	10347	0.01157	0.04298	0.00859	99999	183	183	0	0	1	-360	360;
	10301	10319	0.01298	0.09959	0.01949	99999	229	229	0	0	1	-360	360;
	10301	10319	0.01298	0.09959	0.01949	99999	229	229	0	0	1	-360	360;
	10301	10327	0.03223	0.16033	0.03037	99999	229	229	0	0	1	-360	360;
	10093	10088	0.00046	0.00474	0.01943	99999	960	960	0	0	1	-360	360;
	10301	10327	0.03223	0.16033	0.03037	99999	229	229	0	0	1	-360	360;
	10313	10314	1e-05	0.00041	0	99999	381	381	0	0	1	-360	360;
	10315	10316	1e-05	0.00041	0	99999	191	191	0	0	1	-360	360;
	10315	10317	1e-05	0.00041	0	99999	191	191	0	0	1	-360	360;
	10339	10313	0.00012	0.00118	0.00028	99999	389	389	0	0	1	-360	360;
	10339	10340	1e-05	0.00041	0	99999	381	381	0	0	1	-360	360;
	10340	10314	7e-05	0.00066	0.00016	99999	389	389	0	0	1	-360	360;
	10354	10353	1e-05	0.00041	0	99999	381	381	0	0	1	-360	360;
	10303	10304	8e-05	0.00041	0	99999	229	229	0	0	1	-360	360;
	10093	10157	0.0064	0.02314	0.07299	99999	343	343	0	0	1	-360	360;
	10322	10323	8e-05	0.00041	0	99999	114	114	0	0	1	-360	360;
	10099	10115	0.00014	0.00127	0.0568	99999	1746	1746	0	0	1	-360	360;
	10084	10087	7e-05	0.00077	0.4808	99999	1351	1351	0	0	1	-360	360;
	10099	10116	0.00014	0.00127	0.0568	99999	1746	1746	0	0	1	-360	360;
	10099	10145	0.00091	0.00842	0.37584	99999	1386	1386	0	0	1	-360	360;
	10099	10145	0.00091	0.00842	0.37584	99999	1386	1386	0	0	1	-360	360;
	10099	10158	0.00115	0.01064	0.47546	99999	1884	1884	0	0	1	-360	360;
	10099	10158	0.00115	0.01064	0.47546	99999	1884	1884	0	0	1	-360	360;
	10099	10079	0.00206	0.01905	0.85158	99999	1884	1884	0	0	1	-360	360;
	10099	10079	0.00206	0.01905	0.85158	99999	1884	1884	0	0	1	-360	360;
	10100	10118	0.00034	0.00354	0.1544	99999	1732	1732	0	0	1	-360	360;
	10100	10118	0.00034	0.00354	0.1544	99999	1732	1732	0	0	1	-360	360;
	10100	10151	0.00075	0.00744	0.3264	99999	1386	1386	0	0	1	-360	360;
	10084	10087	7e-05	0.00076	0.51264	99999	1351	1351	0	0	1	-360	360;
	10100	10151	0.00075	0.00744	0.3264	99999	1386	1386	0	0	1	-360	360;
	10100	10153	0.00144	0.01506	0.6592	99999	1386	1386	0	0	1	-360	360;
	10100	10153	0.00144	0.01506	0.6592	99999	1386	1386	0	0	1	-360	360;
	10101	10135	0.01399	0.05116	0.16408	99999	343	343	0	0	1	-360	360;
	10101	10137	0.0049	0.01791	0.0574	99999	343	343	0	0	1	-360	360;
	10102	10166	0.00909	0.03285	0.10503	99999	343	343	0	0	1	-360	360;
	10102	10166	0.00909	0.03285	0.10503	99999	343	343	0	0	1	-360	360;
	10103	10104	0.00125	0.00625	0	99999	1386	1386	0	0	1	-360	360;
	10103	10120	0.00061	0.00564	0.252	99999	1884	1884	0	0	1	-360	360;
	10103	10120	0.00061	0.00564	0.252	99999	1884	1884	0	0	1	-360	360;
	10085	10084	8e-05	0.00095	0.58816	99999	1351	1351	0	0	1	-360	360;
	10103	10150	0.00013	0.00119	0.05328	99999	1884	1884	0	0	1	-360	360;
	10105	10148	0.00492	0.01798	0.05731	99999	408	408	0	0	1	-360	360;
	10105	10149	0.00492	0.01798	0.05731	99999	408	408	0	0	1	-360	360;
	10106	10147	0.00131	0.01339	0.58672	99999	1386	1386	0	0	1	-360	360;
	10106	10151	0.00056	0.00584	0.25616	99999	1386	1386	0	0	1	-360	360;
	10107	10109	0.00014	0.00127	0.0568	99999	1386	1386	0	0	1	-360	360;
	10108	10110	0.00014	0.00127	0.0568	99999	1386	1386	0	0	1	-360	360;
	10111	10158	0.00118	0.01186	0.50192	99999	1746	1746	0	0	1	-360	360;
	10111	10081	0.00051	0.00528	0.22019	99999	1746	1746	0	0	1	-360	360;
	10112	10159	0.00153	0.00561	0.01801	99999	408	408	0	0	1	-360	360;
	10085	10086	0	6e-05	0	99999	2079	2079	0	0	1	-360	360;
	10112	10159	0.00109	0.004	0.01284	99999	408	408	0	0	1	-360	360;
	10112	10159	0.00109	0.004	0.01284	99999	408	408	0	0	1	-360	360;
	10113	10141	0.00031	0.00286	0.12781	99999	1884	1884	0	0	1	-360	360;
	10113	10153	0.00037	0.00343	0.15334	99999	1884	1884	0	0	1	-360	360;
	10114	10127	0.01116	0.04091	0.13068	99999	366	366	0	0	1	-360	360;
	10183	10198	0.00084	0.01065	0.39616	99999	831	831	0	0	1	-360	360;
	10183	10217	0.00146	0.01809	0.63888	99999	831	831	0	0	1	-360	360;
	10184	10199	0.01019	0.06849	0.1012	99999	326	326	0	0	1	-360	360;
	10184	10209	0.01204	0.06105	0.08659	99999	274	274	0	0	1	-360	360;
	10184	10216	0.01029	0.0401	0.10522	99999	274	274	0	0	1	-360	360;
	10185	10205	0.00065	0.00657	0.2224	99999	831	831	0	0	1	-360	360;
	10186	10199	0.00155	0.01508	0.02396	99999	535	535	0	0	1	-360	360;
	10187	10200	0.00156	0.01518	0.02415	99999	535	535	0	0	1	-360	360;
	10188	10183	0.00057	0.00724	0.26592	99999	831	831	0	0	1	-360	360;
	10189	10198	0.00028	0.00346	0.1312	99999	831	831	0	0	1	-360	360;
	10192	10193	0	0.0001	0	99999	762	762	0	0	1	-360	360;
	10192	10222	0.00488	0.0332	0.05542	99999	346	346	0	0	1	-360	360;
	10196	10208	0.00059	0.00752	0.26672	99999	1386	1386	0	0	1	-360	360;
	10197	10215	0.00092	0.01193	0.47104	99999	1109	1109	0	0	1	-360	360;
	10198	10208	0.00081	0.00867	0.27808	99999	831	831	0	0	1	-360	360;
	10199	10200	0	0.0001	0	99999	762	762	0	0	1	-360	360;
	10199	10211	0.00752	0.04678	0.06534	99999	323	323	0	0	1	-360	360;
	10201	10213	0.00112	0.01179	0.35472	99999	738	738	0	0	1	-360	360;
	10201	10220	0.00156	0.01658	0.4112	99999	738	738	0	0	1	-360	360;
	10202	10193	0.01	0.06793	0.1134	99999	274	274	0	0	1	-360	360;
	10202	10203	0	0.0001	0	99999	762	762	0	0	1	-360	360;
	10202	10206	0.03436	0.16971	0.24563	99999	271	271	0	0	1	-360	360;
	10202	10222	0.00595	0.04035	0.06732	99999	274	274	0	0	1	-360	360;
	10204	10210	0.00214	0.02232	0.71616	99999	831	831	0	0	1	-360	360;
	10205	10213	0.00154	0.01628	0.52272	99999	831	831	0	0	1	-360	360;
	10205	10215	0.00078	0.00855	0.2736	99999	1109	1109	0	0	1	-360	360;
	10205	10217	0.00108	0.01152	0.352	99999	1109	1109	0	0	1	-360	360;
	10206	10216	0.01105	0.05364	0.07957	99999	271	271	0	0	1	-360	360;
	10207	10210	0.00185	0.01772	0.57632	99999	831	831	0	0	1	-360	360;
	10207	10220	0.00156	0.01757	0.552	99999	831	831	0	0	1	-360	360;
	10208	10214	0.00058	0.0082	0.28864	99999	831	831	0	0	1	-360	360;
	10212	10216	0.00504	0.0312	0.05087	99999	137	137	0	0	1	-360	360;
	10212	10216	0.00504	0.0312	0.05087	99999	137	137	0	0	1	-360	360;
	10215	10217	0.00033	0.00346	0.1112	99999	1386	1386	0	0	1	-360	360;
	10218	10190	0.0001	0.00123	0.04912	99999	831	831	0	0	1	-360	360;
	10218	10197	0.00086	0.01148	0.4	99999	1386	1386	0	0	1	-360	360;
	10218	10204	0.00026	0.00286	0.08848	99999	866	866	0	0	1	-360	360;
	10218	10219	0	6e-05	0	99999	1386	1386	0	0	1	-360	360;
	10219	10191	0.0001	0.00124	0.04976	99999	831	831	0	0	1	-360	360;
	10219	10198	0.00104	0.01237	0.37936	99999	1109	1109	0	0	1	-360	360;
	10219	10204	0.00026	0.00307	0.1088	99999	866	866	0	0	1	-360	360;
	10220	10194	9e-05	0.00101	0.03168	99999	499	499	0	0	1	-360	360;
	10220	10195	9e-05	0.00097	0.03072	99999	499	499	0	0	1	-360	360;
	10114	10128	0.01116	0.04091	0.13068	99999	366	366	0	0	1	-360	360;
	10180	10064	0.01085	0.05289	0.08301	99999	269	269	0	0	1	-360	360;
	10181	10064	0.01085	0.05289	0.08301	99999	269	269	0	0	1	-360	360;
	10182	10063	0.00065	0.00924	0.276	99999	1386	1386	0	0	1	-360	360;
	10178	10204	0.00078	0.00875	0.13616	99999	1330	1330	0	0	1	-360	360;
	10114	10148	0.00864	0.03777	0.0848	99999	301	301	0	0	1	-360	360;
	10179	10196	0.00036	0.00429	0.1168	99999	1330	1330	0	0	1	-360	360;
	10039	10078	0.00101	0.01281	0.6424	99999	1386	1386	0	0	1	-360	360;
	10039	10038	0.00106	0.01368	0.5168	99999	1386	1386	0	0	1	-360	360;
	10043	10209	0.00839	0.04277	0.06002	99999	274	274	0	0	1	-360	360;
	10043	10044	0.00839	0.04277	0.06026	99999	269	269	0	0	1	-360	360;
	10049	10217	0.00075	0.0072	0.21824	99999	1386	1386	0	0	1	-360	360;
	10049	10048	0.00068	0.00728	0.2176	99999	1386	1386	0	0	1	-360	360;
	10057	10078	0.00067	0.00819	0.47648	99999	1663	1663	0	0	1	-360	360;
	10057	10056	0.00075	0.0091	0.356	99999	1732	1732	0	0	1	-360	360;
	10114	10155	0.0045	0.01649	0.05256	99999	301	301	0	0	1	-360	360;
	10066	10198	0.00118	0.01209	0.3728	99999	1323	1323	0	0	1	-360	360;
	10066	10065	0.00118	0.01209	0.3728	99999	1386	1386	0	0	1	-360	360;
	10067	10211	0.00627	0.04117	0.06002	99999	326	326	0	0	1	-360	360;
	10067	10064	0.00627	0.04117	0.05808	99999	318	318	0	0	1	-360	360;
	10068	10214	0.00069	0.0089	0.32384	99999	831	831	0	0	1	-360	360;
	10068	10065	0.00069	0.0089	0.324	99999	866	866	0	0	1	-360	360;
	10221	10220	0.00053	0.00544	0.06784	99999	831	831	0	0	1	-360	360;
	10221	10223	0.00052	0.00544	0.136	99999	1247	1247	0	0	1	-360	360;
	10114	10155	0.0045	0.01649	0.05256	99999	301	301	0	0	1	-360	360;
	10000	10048	0.0003	0.00314	0.0928	99999	1386	1386	0	0	1	-360	360;
	10225	10243	0.00297	0.03992	0.00819	99999	500	500	0	0	1	-360	360;
	10226	10240	0.00165	0.02256	0.00462	99999	500	500	0	0	1	-360	360;
	10226	10240	0.00826	0.02695	0	99999	500	500	0	0	1	-360	360;
	10244	10240	0.00132	0.01743	0.00358	99999	500	500	0	0	1	-360	360;
	10001	10003	0.00103	0.01009	0.336	99999	1386	1386	0	0	1	-360	360;
	10001	10020	0.00045	0.00585	0.176	99999	831	831	0	0	1	-360	360;
	10001	10076	0.00104	0.01341	0.4592	99999	1386	1386	0	0	1	-360	360;
	10003	10009	0.0013	0.01282	0.42675	99999	1386	1386	0	0	1	-360	360;
	10003	10047	0.00098	0.01281	0.3872	99999	1109	1109	0	0	1	-360	360;
	10004	10034	0.00151	0.01679	0.5504	99999	831	831	0	0	1	-360	360;
	10004	10063	0.00076	0.00894	0.2928	99999	1386	1386	0	0	1	-360	360;
	10004	10065	0.0006	0.00719	0.24	99999	1109	1109	0	0	1	-360	360;
	10005	10009	0.00049	0.00657	0.208	99999	831	831	0	0	1	-360	360;
	10005	10062	0.00042	0.00513	0.184	99999	831	831	0	0	1	-360	360;
	10005	10041	0.00174	0.02253	0.808	99999	831	831	0	0	1	-360	360;
	10006	10038	0.00113	0.01481	0.5088	99999	1386	1386	0	0	1	-360	360;
	10006	10056	0.00047	0.00573	0.1952	99999	1109	1109	0	0	1	-360	360;
	10009	10070	0.00087	0.00881	0.2768	99999	831	831	0	0	1	-360	360;
	10009	10076	0.0017	0.01784	0.5552	99999	1386	1386	0	0	1	-360	360;
	10010	10063	0.00196	0.02597	0.9152	99999	1386	1386	0	0	1	-360	360;
	10010	10041	0.00052	0.00625	0.2256	99999	1109	1109	0	0	1	-360	360;
	10010	10041	0.00056	0.00716	0.2928	99999	1247	1247	0	0	1	-360	360;
	10239	10268	0.01074	0.07934	0	99999	183	183	0	0	1	-360	360;
	10239	10268	0.01074	0.07934	0	99999	183	183	0	0	1	-360	360;
	10015	10042	0.00084	0.01019	0.392	99999	831	831	0	0	1	-360	360;
	10037	10032	9e-05	0.00073	0.0256	99999	831	831	0	0	1	-360	360;
	10037	10060	0.0001	0.00198	0	99999	831	831	0	0	1	-360	360;
	10037	10038	0	6e-05	0	99999	1386	1386	0	0	1	-360	360;
	10037	10033	9e-05	0.00073	0.0256	99999	831	831	0	0	1	-360	360;
	10037	10026	0.00019	0.00194	0.072	99999	416	416	0	0	1	-360	360;
	10037	10034	0.00369	0.04071	1.2784	99999	1386	1386	0	0	1	-360	360;
	10037	10076	0.00078	0.00818	0.2688	99999	1386	1386	0	0	1	-360	360;
	10027	10038	0.00031	0.00293	0.136	99999	1109	1109	0	0	1	-360	360;
	10038	10060	0.0001	0.00198	0	99999	831	831	0	0	1	-360	360;
	10038	10028	0.00031	0.00293	0.136	99999	1109	1109	0	0	1	-360	360;
	10038	10062	0.00198	0.02194	0.8208	99999	1386	1386	0	0	1	-360	360;
	10040	10048	0.00138	0.01671	0.6016	99999	416	416	0	0	1	-360	360;
	10042	10047	0.0015	0.01581	0.4752	99999	1109	1109	0	0	1	-360	360;
	10042	10059	0.00161	0.01656	0.5664	99999	1386	1386	0	0	1	-360	360;
	10042	10070	0.00195	0.0198	0.6	99999	1386	1386	0	0	1	-360	360;
	10048	10059	0.00145	0.01498	0.4416	99999	1386	1386	0	0	1	-360	360;
	10274	10230	0.01021	0.04199	0	99999	300	300	0	0	1	-360	360;
	10275	10270	0.0038	0.02867	0.00469	99999	400	400	0	0	1	-360	360;
	10230	10241	0.00223	0.03173	0.00598	99999	235	235	0	0	1	-360	360;
	10052	10059	0.00069	0.007	0.2144	99999	1109	1109	0	0	1	-360	360;
	10052	10065	0.00131	0.01469	0.4208	99999	1109	1109	0	0	1	-360	360;
	10056	10061	0.0001	0.00143	0	99999	831	831	0	0	1	-360	360;
	10056	10041	0.00165	0.02063	0.6816	99999	1247	1247	0	0	1	-360	360;
	10059	10062	0.00512	0.05602	2.0128	99999	831	831	0	0	1	-360	360;
	10062	10041	0.00182	0.0233	0.9584	99999	1247	1247	0	0	1	-360	360;
	10063	10013	3e-05	0.00041	0.0144	99999	416	416	0	0	1	-360	360;
	10063	10014	3e-05	0.00041	0.0144	99999	416	416	0	0	1	-360	360;
	10063	10016	8e-05	0.00061	0.0208	99999	831	831	0	0	1	-360	360;
	10063	10017	6e-05	0.00059	0.0224	99999	831	831	0	0	1	-360	360;
	10063	10018	6e-05	0.00063	0.0224	99999	831	831	0	0	1	-360	360;
	10063	10019	6e-05	0.00063	0.0256	99999	831	831	0	0	1	-360	360;
	10063	10065	0.00078	0.00866	0.3664	99999	1663	1663	0	0	1	-360	360;
	10063	10065	0.00079	0.00869	0.3664	99999	1386	1386	0	0	1	-360	360;
	10041	10029	4e-05	0.00051	0.0192	99999	1247	1247	0	0	1	-360	360;
	10041	10030	4e-05	0.00053	0.0192	99999	1247	1247	0	0	1	-360	360;
	10041	10050	0.0001	0.00198	0	99999	831	831	0	0	1	-360	360;
	10070	10011	0.00016	0.00161	0.0544	99999	831	831	0	0	1	-360	360;
	10070	10012	0.00016	0.00161	0.0544	99999	831	831	0	0	1	-360	360;
	10076	10023	8e-05	0.00076	0.0256	99999	1109	1109	0	0	1	-360	360;
	10076	10024	8e-05	0.00079	0.0272	99999	1109	1109	0	0	1	-360	360;
	10076	10025	8e-05	0.00081	0.0272	99999	1109	1109	0	0	1	-360	360;
	10076	10077	0.0001	0.00198	0	99999	831	831	0	0	1	-360	360;
	10002	10008	0.00938	0.05535	0.08325	99999	269	269	0	0	1	-360	360;
	10002	10071	0.00667	0.03936	0.0588	99999	269	269	0	0	1	-360	360;
	10007	10075	0.00413	0.02438	0.0363	99999	276	276	0	0	1	-360	360;
	10007	10071	0.00667	0.03936	0.0588	99999	269	269	0	0	1	-360	360;
	10237	10245	0.00052	0.00208	0	99999	413	413	0	0	1	-360	360;
	10237	10235	0.02181	0.07091	0.00716	99999	108	108	0	0	1	-360	360;
	10237	10235	0.02231	0.07264	0.00733	99999	108	108	0	0	1	-360	360;
	10235	10296	0.03041	0.09504	0.00994	99999	95	95	0	0	1	-360	360;
	10235	10296	0.03041	0.09504	0.00994	99999	95	95	0	0	1	-360	360;
	10114	10162	0.01091	0.03994	0.12749	99999	408	408	0	0	1	-360	360;
	10008	10045	0.00269	0.01502	0.02468	99999	325	325	0	0	1	-360	360;
	10008	10045	0.00269	0.01502	0.02468	99999	325	325	0	0	1	-360	360;
	10008	10046	0.01521	0.07448	0.10503	99999	269	269	0	0	1	-360	360;
	10008	10051	0.01198	0.05847	0.08276	99999	269	269	0	0	1	-360	360;
	10008	10075	0.01585	0.07764	0.10406	99999	269	269	0	0	1	-360	360;
	10035	10036	0	0.0001	0	99999	457	457	0	0	1	-360	360;
	10035	10072	0.01233	0.05537	0.08518	99999	269	269	0	0	1	-360	360;
	10035	10074	0.00231	0.00998	0.02614	99999	343	343	0	0	1	-360	360;
	10036	10072	0.01233	0.05537	0.08518	99999	269	269	0	0	1	-360	360;
	10036	10075	0.0044	0.01901	0.04985	99999	343	343	0	0	1	-360	360;
	10044	10058	0.01281	0.06178	0.09728	99999	269	269	0	0	1	-360	360;
	10044	10058	0.01281	0.06178	0.09728	99999	269	269	0	0	1	-360	360;
	10269	10293	0.00446	0.02504	0.00294	99999	269	269	0	0	1	-360	360;
	10269	10293	0.00446	0.02504	0.00294	99999	269	269	0	0	1	-360	360;
	10293	10242	0.00355	0.05041	0.00952	99999	269	269	0	0	1	-360	360;
	10046	10021	0.00161	0.00707	0.01065	99999	269	269	0	0	1	-360	360;
	10046	10022	0.00161	0.00707	0.01065	99999	269	269	0	0	1	-360	360;
	10046	10055	0.00857	0.05599	0.08276	99999	325	325	0	0	1	-360	360;
	10046	10069	0.00787	0.05341	0.0726	99999	276	276	0	0	1	-360	360;
	10051	10064	0.02545	0.12459	0.17569	99999	269	269	0	0	1	-360	360;
	10055	10072	0.01099	0.07169	0.10696	99999	276	276	0	0	1	-360	360;
	10055	10072	0.01099	0.07169	0.10696	99999	276	276	0	0	1	-360	360;
	10058	10064	0.01508	0.07252	0.10648	99999	269	269	0	0	1	-360	360;
	10058	10064	0.01508	0.07252	0.10648	99999	269	269	0	0	1	-360	360;
	10064	10069	0.02217	0.14969	0.20618	99999	325	325	0	0	1	-360	360;
	10072	10031	0.00145	0.00632	0.01016	99999	137	137	0	0	1	-360	360;
	10072	10053	0.00211	0.01329	0.02081	99999	276	276	0	0	1	-360	360;
	10072	10054	0.00211	0.01329	0.02081	99999	286	286	0	0	1	-360	360;
	10073	10074	0.00058	0.00324	0.0213	99999	276	276	0	0	1	-360	360;
	10074	10075	0.00217	0.00936	0.01965	99999	343	343	0	0	1	-360	360;
	10086	10083	8e-05	0.00073	0.79808	99999	1247	1247	0	0	1	-360	360;
	10117	10120	0.00123	0.01136	0.50736	99999	1884	1884	0	0	1	-360	360;
	10117	10095	0.00127	0.01175	0.52515	99999	1884	1884	0	0	1	-360	360;
	10118	10139	0.00116	0.00996	0.45904	99999	1386	1386	0	0	1	-360	360;
	10118	10140	0.00116	0.00996	0.45904	99999	1386	1386	0	0	1	-360	360;
	10119	10145	0.00097	0.00893	0.39888	99999	1732	1732	0	0	1	-360	360;
	10119	10158	0.00051	0.00475	0.212	99999	1732	1732	0	0	1	-360	360;
	10120	10129	0.00233	0.02406	1.03856	99999	1746	1746	0	0	1	-360	360;
	10120	10142	0.00166	0.01701	0.74512	99999	1746	1746	0	0	1	-360	360;
	10120	10095	0.00249	0.02302	1.02899	99999	1884	1884	0	0	1	-360	360;
	10121	10166	0.00446	0.01636	0.05242	99999	381	381	0	0	1	-360	360;
	10086	10084	8e-05	0.00095	0.6032	99999	1351	1351	0	0	1	-360	360;
	10123	10151	0.00088	0.00903	0.39568	99999	1386	1386	0	0	1	-360	360;
	10096	10094	0.00067	0.00872	0.432	99999	2494	2494	0	0	1	-360	360;
	10096	10094	0.00067	0.00872	0.432	99999	2494	2494	0	0	1	-360	360;
	10096	10097	0.00066	0.00494	0.22048	99999	1330	1330	0	0	1	-360	360;
	10096	10097	0.00066	0.00494	0.22048	99999	1330	1330	0	0	1	-360	360;
	10123	10151	0.00088	0.00903	0.39568	99999	1386	1386	0	0	1	-360	360;
	10097	10095	0.00033	0.00423	0.21552	99999	2494	2494	0	0	1	-360	360;
	10097	10095	0.00033	0.00423	0.21552	99999	2494	2494	0	0	1	-360	360;
	10098	10097	0.00062	0.00465	0.22464	99999	1386	1386	0	0	1	-360	360;
	10098	10097	0.00062	0.00465	0.22464	99999	1386	1386	0	0	1	-360	360;
	10124	10130	0.00068	0.00697	0.30541	99999	1746	1746	0	0	1	-360	360;
	10124	10133	0.00247	0.02543	1.11398	99999	1746	1746	0	0	1	-360	360;
	10125	10126	0.00061	0.00623	0.2728	99999	1732	1732	0	0	1	-360	360;
	10125	10164	0.00188	0.019	0.8336	99999	1746	1746	0	0	1	-360	360;
	10126	10158	0.00135	0.0125	0.5585	99999	1884	1884	0	0	1	-360	360;
	10126	10158	0.00135	0.0125	0.5585	99999	1884	1884	0	0	1	-360	360;
	10087	10134	0.00048	0.0027	0.11808	99999	1386	1386	0	0	1	-360	360;
	10126	10164	0.00246	0.02524	1.1048	99999	1746	1746	0	0	1	-360	360;
	10127	10163	0.01467	0.05331	0.17037	99999	381	381	0	0	1	-360	360;
	10128	10163	0.01467	0.05331	0.17037	99999	381	381	0	0	1	-360	360;
	10129	10130	1e-05	6e-05	0	99999	2079	2079	0	0	1	-360	360;
	10129	10134	0.00338	0.03471	1.52074	99999	1746	1746	0	0	1	-360	360;
	10129	10134	0.00338	0.03471	1.52074	99999	1746	1746	0	0	1	-360	360;
	10130	10133	0.00315	0.0324	1.41939	99999	1746	1746	0	0	1	-360	360;
	10130	10152	0.00091	0.00928	0.4064	99999	1746	1746	0	0	1	-360	360;
	10131	10126	0.0009	0.00792	0.36176	99999	1732	1732	0	0	1	-360	360;
	10131	10143	0.00312	0.02634	1.22736	99999	1386	1386	0	0	1	-360	360;
	10087	10134	0.00047	0.00269	0.11808	99999	1386	1386	0	0	1	-360	360;
	10132	10169	0.00027	0.00279	0.1224	99999	1386	1386	0	0	1	-360	360;
	10132	10170	0.00027	0.00279	0.1224	99999	1386	1386	0	0	1	-360	360;
	10133	10134	0.00035	0.00363	0.15888	99999	1399	1399	0	0	1	-360	360;
	10134	10109	0.00164	0.01359	0.63792	99999	1386	1386	0	0	1	-360	360;
	10134	10110	0.00164	0.01359	0.63792	99999	1386	1386	0	0	1	-360	360;
	10135	10121	0.00744	0.02723	0.08722	99999	381	381	0	0	1	-360	360;
	10135	10160	0.01667	0.06105	0.19515	99999	343	343	0	0	1	-360	360;
	10135	10166	0.01116	0.04085	0.13102	99999	343	343	0	0	1	-360	360;
	10138	10142	0.00054	0.00538	0.22912	99999	1746	1746	0	0	1	-360	360;
	10087	10088	0.00035	0.02784	-0.00155	99999	400	400	0.95238	0	1	-360	360;
	10105	10302	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10167	10361	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10042	10232	0.0013	0.04918	0	99999	250	250	1.015	0	1	-360	360;
	10042	10231	0.0013	0.04918	0	99999	250	250	0.999	0	1	-360	360;
	10283	10232	0.0006	0.05	0	99999	200	200	0.99491	0	1	-360	360;
	10020	10254	0.0005	0.0245	0	99999	570	570	1.0035	0	1	-360	360;
	10266	10034	0.00042	0.0206	0	99999	500	500	1.0131	0	1	-360	360;
	10273	10047	0.00043	0.0204	0	99999	500	500	0.9871	0	1	-360	360;
	10274	10048	0.00106	0.05279	0	99999	250	250	1.013	0	1	-360	360;
	10275	10048	0.00106	0.05279	0	99999	250	250	1.013	0	1	-360	360;
	10168	10361	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10241	10247	0.00153	0.06327	0	99999	235	235	0.95	0	1	-360	360;
	10277	10052	0.00017	0.01371	0	99999	750	750	1.032	0	1	-360	360;
	10280	10056	0.00055	0.04057	0	99999	350	350	1.032	0	1	-360	360;
	10284	10062	0.00022	0.0117	0	99999	1200	1200	1.09072	0	1	-360	360;
	10013	10246	0.00051	0.05	0	99999	254	254	0.98143	0	1	-360	360;
	10285	10063	0.00053	0.0264	0	99999	250	250	1.0262	0	1	-360	360;
	10016	10250	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10016	10250	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10017	10251	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10017	10251	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10018	10252	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10018	10252	0.00117	0.0543	0	99999	300	300	0.99875	0	1	-360	360;
	10065	10064	0.00077	0.02674	0	99999	400	400	0.999	0	1	-360	360;
	10288	10065	0.00049	0.03843	0	99999	250	250	1.0165	0	1	-360	360;
	10029	10261	0.00016	0.01072	0	99999	1200	1200	1.05	0	1	-360	360;
	10030	10262	0.00016	0.01072	0	99999	1200	1200	1.05	0	1	-360	360;
	10268	10041	0.00053	0.02619	0	99999	500	500	1.01574	0	1	-360	360;
	10291	10070	0.0009	0.03817	0	99999	330	330	1.0456	0	1	-360	360;
	10023	10256	0.00039	0.02656	0	99999	450	450	0.9375	0	1	-360	360;
	10025	10257	0.00039	0.02656	0	99999	450	450	0.9375	0	1	-360	360;
	10295	10076	0.00103	0.05279	0	99999	330	330	0.948	0	1	-360	360;
	10002	10229	0.00136	0.06474	0	99999	200	200	0.99999	0	1	-360	360;
	10007	10237	0.00049	0.03327	0	99999	400	400	0.99999	0	1	-360	360;
	10245	10253	0.00267	0.08044	0	99999	125	125	1.07143	0	1	-360	360;
	10245	10253	0.00267	0.08044	0	99999	125	125	1.07143	0	1	-360	360;
	10245	10253	0.00267	0.08667	0	99999	125	125	1.07143	0	1	-360	360;
	10008	10009	0.00042	0.01746	0	99999	630	630	1.02827	0	1	-360	360;
	10035	10037	0.00042	0.0264	0	99999	500	500	0.999	0	1	-360	360;
	10044	10269	0.00071	0.03267	0	99999	400	400	0.99999	0	1	-360	360;
	10045	10271	0.00099	0.02541	0	99999	400	400	0.99999	0	1	-360	360;
	10046	10272	0.00192	0.05322	0	99999	200	200	0.99999	0	1	-360	360;
	10021	10255	0.00039	0.05586	0	99999	200	200	1.03533	0	1	-360	360;
	10051	10276	0.00095	0.02571	0	99999	400	400	0.99999	0	1	-360	360;
	10055	10281	0.00192	0.05081	0	99999	200	200	0.99999	0	1	-360	360;
	10058	10059	0.00042	0.0264	0	99999	500	500	0.999	0	1	-360	360;
	10058	10282	0.00049	0.03267	0	99999	400	400	0.99999	0	1	-360	360;
	10064	10289	0.0009	0.02541	0	99999	400	400	0.99999	0	1	-360	360;
	10069	10290	0.00081	0.05869	0	99999	200	200	0.99999	0	1	-360	360;
	10072	10292	0.00093	0.02691	0	99999	400	400	0.99999	0	1	-360	360;
	10031	10263	0.00306	0.10051	0	99999	125	125	0.99857	0	1	-360	360;
	10073	10294	0.00198	0.05081	0	99999	200	200	0.99999	0	1	-360	360;
	10053	10278	0.00069	0.0625	0	99999	250	250	0.98083	0	1	-360	360;
	10054	10279	0.00069	0.0625	0	99999	250	250	0.98083	0	1	-360	360;
	10075	10296	0.00119	0.06714	0	99999	200	200	0.99999	0	1	-360	360;
	10105	10302	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10106	10303	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10106	10304	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10107	10305	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10108	10305	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10111	10306	0.00097	0.06945	-0.00063	99999	300	300	0.90552	0	1	-360	360;
	10112	10307	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10112	10308	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10112	10308	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10087	10089	0.00035	0.02781	-0.00156	99999	400	400	0.95238	0	1	-360	360;
	10113	10114	0.00047	0.03467	-0.02498	99999	600	600	0.89962	0	1	-360	360;
	10113	10309	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10113	10309	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10117	10312	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10117	10312	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10118	10315	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10118	10316	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10118	10317	0.00129	0.07549	-0.01267	99999	250	250	0.88636	0	1	-360	360;
	10119	10318	0.00129	0.07549	-0.01267	99999	250	250	0.93786	0	1	-360	360;
	10120	10319	0.00095	0.06908	-0.00047	99999	300	300	0.95255	0	1	-360	360;
	10092	10298	0.00163	0.06966	-0.01078	99999	250	250	0.99999	0	1	-360	360;
	10120	10320	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10122	10321	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10122	10321	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10122	10321	0.0022	0.09437	-0.01007	99999	160	160	0.99999	0	1	-360	360;
	10123	10322	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10123	10323	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10125	10324	0.00128	0.07549	-0.01267	99999	250	250	0.91987	0	1	-360	360;
	10125	10324	0.00128	0.07549	-0.01267	99999	250	250	0.91987	0	1	-360	360;
	10126	10325	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10126	10326	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10092	10298	0.00163	0.06966	-0.01078	99999	250	250	0.99999	0	1	-360	360;
	10126	10326	0.00129	0.07549	-0.01267	99999	250	250	0.88636	0	1	-360	360;
	10131	10328	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10131	10329	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10133	10297	0.00127	0.07646	-0.01267	99999	250	250	0.94212	0	1	-360	360;
	10133	10297	0.00127	0.07646	-0.01267	99999	250	250	0.94212	0	1	-360	360;
	10135	10134	0.00025	0.01342	-0.01747	99999	800	800	0.99474	-3	1	-360	360;
	10135	10134	0.00025	0.01342	-0.01747	99999	800	800	0.99474	-3	1	-360	360;
	10135	10332	0.00179	0.07291	-0.00139	99999	200	200	0.99131	0	1	-360	360;
	10135	10332	0.00179	0.07291	-0.00139	99999	200	200	0.99131	0	1	-360	360;
	10135	10332	0.0022	0.09782	-0.01007	99999	160	160	1.0543	0	1	-360	360;
	10093	10298	0.00163	0.06966	-0.01078	99999	250	250	0.99999	0	1	-360	360;
	10136	10333	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10136	10333	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10137	10334	0.0022	0.09437	-0.01007	99999	160	160	1.0181	0	1	-360	360;
	10137	10334	0.0022	0.09437	-0.01007	99999	160	160	1.0181	0	1	-360	360;
	10138	10335	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10138	10336	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10139	10337	0.00129	0.07549	-0.01267	99999	250	250	1.00992	0	1	-360	360;
	10140	10338	0.00129	0.07549	-0.01267	99999	250	250	1.00992	0	1	-360	360;
	10141	10339	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10141	10340	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10099	10299	0.00096	0.06842	-0.00047	99999	300	300	0.92895	0	1	-360	360;
	10141	10340	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10143	10341	0.00168	0.09369	-0.00162	99999	200	200	0.95238	0	1	-360	360;
	10144	10342	0.00113	0.05809	-0.00539	99999	340	340	1.02217	0	1	-360	360;
	10145	10343	0.00166	0.09369	-0.00161	99999	200	200	0.95238	0	1	-360	360;
	10145	10343	0.00166	0.09369	-0.00161	99999	200	200	0.95238	0	1	-360	360;
	10146	10145	0.00042	0.02014	-0.00432	99999	400	400	1.05263	0	1	-360	360;
	10146	10145	0.00042	0.02014	-0.00432	99999	400	400	1.05263	0	1	-360	360;
	10147	10344	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10148	10147	0.00024	0.01402	-0.01747	99999	800	800	1.04878	0	1	-360	360;
	10148	10344	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10099	10299	0.00096	0.06842	-0.00047	99999	300	300	0.92895	0	1	-360	360;
	10149	10147	0.00024	0.01402	-0.01747	99999	800	800	1.04878	0	1	-360	360;
	10149	10345	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10151	10348	0.00128	0.07549	-0.01267	99999	250	250	0.95843	0	1	-360	360;
	10151	10349	0.00128	0.07549	-0.01267	99999	250	250	0.9688	0	1	-360	360;
	10152	10350	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10152	10350	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10153	10351	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10153	10351	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10153	10352	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10155	10353	0.00168	0.07129	-0.01078	99999	250	250	0.9448	0	1	-360	360;
	10103	10301	0.00098	0.0739	-0.00053	99999	300	300	0.94178	0	1	-360	360;
	10155	10354	0.00168	0.07129	-0.01078	99999	250	250	0.9448	0	1	-360	360;
	10156	10355	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10156	10355	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10157	10156	0.00042	0.02014	-0.00432	99999	400	400	1.05263	0	1	-360	360;
	10159	10158	0.00021	0.01365	-0.01747	99999	800	800	1.10526	0	1	-360	360;
	10159	10158	0.00021	0.01365	-0.01747	99999	800	800	1.10526	0	1	-360	360;
	10160	10356	0.0022	0.09437	-0.01007	99999	160	160	1.0181	0	1	-360	360;
	10160	10356	0.0022	0.09437	-0.01007	99999	160	160	1.0181	0	1	-360	360;
	10161	10357	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10162	10357	0.00177	0.07164	-0.00139	99999	200	200	0.95584	0	1	-360	360;
	10103	10301	0.00096	0.07147	-0.00047	99999	300	300	0.94178	0	1	-360	360;
	10163	10358	0.00221	0.09272	-0.01007	99999	160	160	0.9638	0	1	-360	360;
	10163	10358	0.00221	0.09272	-0.01007	99999	160	160	0.9638	0	1	-360	360;
	10163	10358	0.00221	0.09272	-0.01007	99999	160	160	0.9638	0	1	-360	360;
	10163	10358	0.00221	0.09272	-0.01007	99999	160	160	0.9638	0	1	-360	360;
	10164	10359	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10199	10198	0.0003	0.0245	-0.01984	99999	400	400	1.04412	0	1	-360	360;
	10164	10359	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10164	10359	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10165	10360	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10225	10000	0.00134	0.05038	0	99999	250	250	1.015	0	1	-360	360;
	10226	10000	0.00134	0.05038	0	99999	250	250	1.015	0	1	-360	360;
	10244	10248	0.00153	0.06327	0	99999	235	235	0.95	0	1	-360	360;
	10227	10001	0.00045	0.0206	0	99999	500	500	1.0524	0	1	-360	360;
	10228	10003	0.00081	0.04639	0	99999	500	500	1.0112	0	1	-360	360;
	10165	10360	0.00095	0.06908	-0.00047	99999	300	300	0.95238	0	1	-360	360;
	10233	10004	0.00041	0.0206	0	99999	500	500	1.0131	0	1	-360	360;
	10234	10005	0.00104	0.05279	0	99999	660	660	1.0262	0	1	-360	360;
	10236	10006	0.00044	0.01909	0	99999	660	660	1.0456	0	1	-360	360;
	10238	10009	0.00049	0.03857	0	99999	500	500	0.96463	0	1	-360	360;
	10239	10010	0.00051	0.0264	0	99999	500	500	1.02433	0	1	-360	360;
	10015	10249	0.00057	0.03554	0	99999	360	360	1.03273	0	1	-360	360;
	10032	10264	0.00104	0.05121	0	99999	250	250	1.03125	0	1	-360	360;
	10166	10165	0.00042	0.02014	-0.00432	99999	400	400	1.05263	0	1	-360	360;
	10032	10264	0.00104	0.05121	0	99999	250	250	1.03125	0	1	-360	360;
	10027	10259	0.00104	0.04844	0	99999	250	250	1.05875	0	1	-360	360;
	10027	10259	0.00104	0.04844	0	99999	250	250	1.05875	0	1	-360	360;
	10033	10265	0.00117	0.05781	0	99999	330	330	0.9375	0	1	-360	360;
	10033	10265	0.00117	0.05781	0	99999	330	330	0.9375	0	1	-360	360;
	10028	10260	0.00104	0.04844	0	99999	330	330	0.9375	0	1	-360	360;
	10028	10260	0.00104	0.04844	0	99999	330	330	0.9375	0	1	-360	360;
	10028	10260	0.00104	0.04844	0	99999	330	330	0.9375	0	1	-360	360;
	10026	10258	0.00117	0.05469	0	99999	330	330	0.9375	0	1	-360	360;
	10267	10040	0.00049	0.0264	0	99999	500	500	1.0393	0	1	-360	360;
	10038	10078	0.00205	0.02639	0	99999	831	831	0	0	1	-360	360;
	10082	10078	0.00198	0.0223	0	99999	831	831	0	0	1	-360	360;
	10079	10078	0.00533	0.07056	0	99999	831	831	0	0	1	-360	360;
	10081	10078	0.01637	0.57223	0	99999	831	831	0	0	1	-360	360;
	10182	10078	0.01793	0.39251	0	99999	831	831	0	0	1	-360	360;
	10082	10079	0.00071	0.00822	0	99999	831	831	0	0	1	-360	360;
	10081	10079	0.00074	0.01939	0	99999	831	831	0	0	1	-360	360;
	10179	10079	0.08688	0.54903	0	99999	831	831	0	0	1	-360	360;
	10182	10079	0.01411	0.25727	0	99999	831	831	0	0	1	-360	360;
	10080	10079	0	0.35542	0	99999	831	831	0	0	1	-360	360;
	10176	10079	0	0.38108	0	99999	831	831	0	0	1	-360	360;
	10177	10079	0	0.38108	0	99999	831	831	0	0	1	-360	360;
	10171	10080	0.02505	0.31078	0	99999	831	831	0	0	1	-360	360;
	10172	10080	0.0043	0.03951	0	99999	831	831	0	0	1	-360	360;
	10173	10080	0.0043	0.03951	0	99999	831	831	0	0	1	-360	360;
	10176	10080	0.01189	0.1311	0	99999	831	831	0	0	1	-360	360;
	10177	10080	0.01189	0.1311	0	99999	831	831	0	0	1	-360	360;
	10081	10080	0.00379	0.04353	0	99999	831	831	0	0	1	-360	360;
	10082	10081	0.04059	0.52094	0	99999	831	831	0	0	1	-360	360;
	10171	10081	0.00311	0.18416	0	99999	831	831	0	0	1	-360	360;
	10172	10081	0.01807	0.20197	0	99999	831	831	0	0	1	-360	360;
	10173	10081	0.01807	0.20197	0	99999	831	831	0	0	1	-360	360;
	10176	10081	0.00286	0.07511	0	99999	831	831	0	0	1	-360	360;
	10177	10081	0.00286	0.07511	0	99999	831	831	0	0	1	-360	360;
	10174	10171	0.0023	0.06693	0	99999	831	831	0	0	1	-360	360;
	10176	10171	0.00147	0.01552	0	99999	831	831	0	0	1	-360	360;
	10177	10171	0.00147	0.01552	0	99999	831	831	0	0	1	-360	360;
	10173	10172	0	6e-05	0	99999	831	831	0	0	1	-360	360;
	10176	10172	0.04808	0.44623	0	99999	831	831	0	0	1	-360	360;
	10177	10172	0.04808	0.44623	0	99999	831	831	0	0	1	-360	360;
	10176	10173	0.04808	0.44623	0	99999	831	831	0	0	1	-360	360;
	10177	10173	0.04808	0.44623	0	99999	831	831	0	0	1	-360	360;
	10176	10174	0.01094	0.15974	0	99999	831	831	0	0	1	-360	360;
	10177	10174	0.01094	0.15974	0	99999	831	831	0	0	1	-360	360;
	10177	10176	0.00076	0.00569	0	99999	831	831	0	0	1	-360	360;
	10178	10223	0.0023	0.04426	0	99999	831	831	0	0	1	-360	360;
	10179	10223	0.0024	0.14454	0	99999	831	831	0	0	1	-360	360;
	10181	10180	0.07557	0.28529	0	99999	457	457	0	0	1	-360	360;
	10179	10180	0.04117	0.28881	0	99999	1200	1200	0	0	1	-360	360;
	10182	10180	0.02077	0.16725	0	99999	1200	1200	0	0	1	-360	360;
	10179	10181	0.04117	0.28881	0	99999	1200	1200	0	0	1	-360	360;
	10182	10181	0.02077	0.16725	0	99999	1200	1200	0	0	1	-360	360;
	10179	10182	0.00221	0.05859	0	99999	831	831	0	0	1	-360	360;
	10178	10182	0.00529	0.57896	0	99999	831	831	0	0	1	-360	360;
	10179	10178	0.00345	0.0839	0	99999	831	831	0	0	1	-360	360;
	10000	3006	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10048	3008	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10044	3007	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10044	3007	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10201	3012	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10201	3012	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10123	3010	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10123	3010	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10160	3011	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	10160	3011	1e-05	0.0001	0	9999	9999	9999	0	0	1	-360	360;
	9	11	0.00064	0.0305	0	400	400	400	1.10224	0	1	-360	360;
	13	12	0.00069	0.03946	0	250	250	250	0.9999	0	1	-360	360;
	21	19	0.00088	0.05709	0	330	330	330	0.9999	0	1	-360	360;
	36	35	0.0007	0.03652	0	250	250	250	0.9999	0	1	-360	360;
	37	40	0.00036	0.02519	0	500	500	500	1.0686	0	1	-360	360;
	38	41	0.00036	0.02519	0	500	500	500	1.08671	0	1	-360	360;
	55	56	0.00034	0.02097	0	500	500	500	1.0755	0	1	-360	360;
	59	61	0.00034	0.02097	0	500	500	500	1.05955	0	1	-360	360;
	70	72	0.00081	0.03	0	400	400	400	1.0876	0	1	-360	360;
	107	109	0.00075	0.02445	-0.00832	330	330	330	1.06467	0	1	-360	360;
	108	110	0.0004	0.0253	0	500	500	500	1.07013	0	1	-360	360;
	144	147	0.00053	0.02875	-0.016	400	400	400	1.07702	0	1	-360	360;
	173	174	0.00064	0.0305	0	400	400	400	1.06172	0	1	-360	360;
	182	183	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	181	184	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	188	187	0.00032	0.04392	0	330	330	330	0.9999	0	1	-360	360;
	191	193	0.0003	0.02732	0	500	500	500	1.10871	0	1	-360	360;
	198	200	0.00035	0.02375	0	500	500	500	1.07313	0	1	-360	360;
	212	213	0.00051	0.0275	0	400	400	400	1.10394	0	1	-360	360;
	217	215	0.00084	0.06858	0	250	250	250	0.9999	0	1	-360	360;
	220	222	0.00033	0.02711	0	500	500	500	1.08613	0	1	-360	360;
	224	222	0.00032	0.0464	0	330	330	330	0.9999	0	1	-360	360;
	231	229	0.00113	0.05647	0	330	330	330	0.9999	0	1	-360	360;
	228	230	0.00075	0.02469	-0.008	330	330	330	1.04544	0	1	-360	360;
	3010	183	0.00029	0.00317	0.09184	1386	1386	1386	0	0	1	-360	360;
	3010	184	0.0003	0.00326	0.09536	1386	1386	1386	0	0	1	-360	360;
	244	84	0.01475	0.08595	0.13036	415	415	415	0	0	1	-360	360;
	3007	92	0.01244	0.06959	0.1181	412	412	412	0	0	1	-360	360;
	3007	122	0.01207	0.06905	0.11519	412	412	412	0	0	1	-360	360;
	146	3008	0.00168	0.01604	0.51488	1206	1206	1206	0	0	1	-360	360;
	3011	172	0.0018	0.01616	0.0484	457	457	457	0	0	1	-360	360;
	3011	173	0.0018	0.01616	0.0484	457	457	457	0	0	1	-360	360;
	3012	63	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	3012	64	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	99	3006	0.00293	0.03054	0.95472	1206	1206	1206	0	0	1	-360	360;
	58	30	0.01174	0.07014	0.12689	415	415	415	0	0	1	-360	360;
	37	107	0.00919	0.06614	0.10451	461	461	461	0	0	1	-360	360;
	38	108	0.00822	0.05767	0.0982	465	465	465	0	0	1	-360	360;
	169	42	0.01698	0.12459	0.1957	373	373	373	0	0	1	-360	360;
	155	48	0.01298	0.06738	0.10284	335	335	335	0	0	1	-360	360;
	154	27	0.01068	0.0475	0.09495	415	415	415	0	0	1	-360	360;
	191	28	0.01436	0.10729	0.16081	373	373	373	0	0	1	-360	360;
	55	126	0.01488	0.08161	0.1148	347	347	347	0	0	1	-360	360;
	54	108	0.01116	0.07171	0.10367	362	362	362	0	0	1	-360	360;
	207	100	0.00552	0.05948	0.17077	427	427	427	0	0	1	-360	360;
	238	192	0.01118	0.06597	0.10778	362	362	362	0	0	1	-360	360;
	226	191	0.01682	0.08909	0.12993	400	400	400	0	0	1	-360	360;
	225	192	0.01384	0.08702	0.13484	400	400	400	0	0	1	-360	360;
	242	195	0.01517	0.09938	0.14492	274	274	274	0	0	1	-360	360;
	59	16	0.01347	0.07316	0.13418	377	377	377	0	0	1	-360	360;
	233	25	0.01403	0.10413	0.15949	373	373	373	0	0	1	-360	360;
	117	70	0.00374	0.0438	0.10096	476	476	476	0	0	1	-360	360;
	190	99	0.00194	0.02007	0.54307	1316	1316	1316	0	0	1	-360	360;
	60	12	0.0015	0.01506	0.4032	1386	1386	1386	0	0	1	-360	360;
	214	174	0.00296	0.03484	0.9296	1358	1358	1358	0	0	1	-360	360;
	138	72	0.00169	0.01931	0.53814	866	866	866	0	0	1	-360	360;
	41	110	0.00137	0.01569	0.43744	1386	1386	1386	0	0	1	-360	360;
	40	141	0.00234	0.02677	0.74653	1386	1386	1386	0	0	1	-360	360;
	34	222	0.00217	0.02513	0.67098	1386	1386	1386	0	0	1	-360	360;
	138	80	0.00152	0.01739	0.48083	866	866	866	0	0	1	-360	360;
	140	80	0.00468	0.05347	1.48883	831	831	831	0	0	1	-360	360;
	99	44	0.00355	0.03617	0.95894	1150	1150	1150	0	0	1	-360	360;
	109	40	0.00195	0.02103	0.5679	1316	1316	1316	0	0	1	-360	360;
	63	139	0.00144	0.01446	0.51213	1386	1386	1386	0	0	1	-360	360;
	14	6	0.013	0.09781	0.14013	461	461	461	0	0	1	-360	360;
	43	14	0.00525	0.03847	0.06053	373	373	373	0	0	1	-360	360;
	33	6	0.00457	0.03351	0.05245	427	427	427	0	0	1	-360	360;
	24	9	0.01469	0.10915	0.16676	427	427	427	0	0	1	-360	360;
	29	16	0.01262	0.09326	0.14324	373	373	373	0	0	1	-360	360;
	37	7	0.00924	0.05052	0.07698	366	366	366	0	0	1	-360	360;
	24	3	0.01068	0.07936	0.12155	274	274	274	0	0	1	-360	360;
	37	27	0.00585	0.04027	0.07161	495	495	495	0	0	1	-360	360;
	39	26	0.00585	0.04027	0.07161	495	495	495	0	0	1	-360	360;
	15	8	0.00558	0.04147	0.0629	373	373	373	0	0	1	-360	360;
	46	14	0.00089	0.0063	0.0108	373	373	373	0	0	1	-360	360;
	31	15	0.00442	0.02374	0.04477	415	415	415	0	0	1	-360	360;
	47	7	0.00494	0.0269	0.04225	335	335	335	0	0	1	-360	360;
	26	6	0.00287	0.01671	0.02467	366	366	366	0	0	1	-360	360;
	37	1	0.0012	0.0089	0.01512	747	747	747	0	0	1	-360	360;
	39	2	0.0012	0.0089	0.01513	747	747	747	0	0	1	-360	360;
	38	32	0.00399	0.02901	0.04808	476	476	476	0	0	1	-360	360;
	34	12	0.00298	0.03445	0.94221	831	831	831	0	0	1	-360	360;
	40	34	0.00358	0.04122	1.13382	1386	1386	1386	0	0	1	-360	360;
	20	41	0.00342	0.03928	1.08288	1316	1316	1316	0	0	1	-360	360;
	11	22	0.00286	0.0335	0.89392	1358	1358	1358	0	0	1	-360	360;
	11	20	0.0011	0.01259	0.3496	1358	1358	1358	0	0	1	-360	360;
	44	41	0.00076	0.00868	0.24096	1358	1358	1358	0	0	1	-360	360;
	79	74	0.01054	0.06151	0.09306	316	316	316	0	0	1	-360	360;
	76	71	0.00905	0.06723	0.10296	373	373	373	0	0	1	-360	360;
	83	49	0.0114	0.06587	0.09975	274	274	274	0	0	1	-360	360;
	66	49	0.0107	0.06628	0.10825	377	377	377	0	0	1	-360	360;
	74	57	0.00543	0.03733	0.06668	446	446	446	0	0	1	-360	360;
	75	59	0.00543	0.03733	0.06668	446	446	446	0	0	1	-360	360;
	75	49	0.00657	0.0481	0.0727	419	419	419	0	0	1	-360	360;
	84	67	0.00302	0.0201	0.03069	415	415	415	0	0	1	-360	360;
	67	53	0.007	0.05138	0.08084	373	373	373	0	0	1	-360	360;
	51	70	0.00329	0.02506	0.0439	427	427	427	0	0	1	-360	360;
	52	50	0.00789	0.05868	0.08985	373	373	373	0	0	1	-360	360;
	71	52	0.00558	0.04062	0.06491	446	446	446	0	0	1	-360	360;
	83	51	0.00452	0.03366	0.05156	446	446	446	0	0	1	-360	360;
	83	82	0.00134	0.00996	0.01337	377	377	377	0	0	1	-360	360;
	78	57	0.00618	0.04353	0.07649	446	446	446	0	0	1	-360	360;
	79	58	0.00618	0.04353	0.07649	347	347	347	0	0	1	-360	360;
	78	54	0.01219	0.0637	0.09333	347	347	347	0	0	1	-360	360;
	77	55	0.00246	0.01826	0.02798	373	373	373	0	0	1	-360	360;
	62	54	0.00242	0.01531	0.02249	377	377	377	0	0	1	-360	360;
	65	61	0.0017	0.01977	0.53386	1358	1358	1358	0	0	1	-360	360;
	73	69	0.00116	0.013	0.33856	1358	1358	1358	0	0	1	-360	360;
	56	72	0.00218	0.02536	0.68579	1358	1358	1358	0	0	1	-360	360;
	80	73	0.00105	0.01123	0.28195	1386	1386	1386	0	0	1	-360	360;
	64	81	0.00119	0.01428	0.36666	1386	1386	1386	0	0	1	-360	360;
	68	60	0.00184	0.02139	0.5777	1358	1358	1358	0	0	1	-360	360;
	113	144	0.00488	0.03362	0.05961	446	446	446	0	0	1	-360	360;
	91	124	0.01093	0.05919	0.08439	290	290	290	0	0	1	-360	360;
	124	111	0.00194	0.01415	0.0223	446	446	446	0	0	1	-360	360;
	95	150	0.00192	0.01355	0.023	446	446	446	0	0	1	-360	360;
	150	102	0.00238	0.01667	0.02846	446	446	446	0	0	1	-360	360;
	123	150	0.00279	0.02017	0.03204	446	446	446	0	0	1	-360	360;
	151	149	0.00066	0.00496	0.00758	419	419	419	0	0	1	-360	360;
	123	151	0.00537	0.04039	0.06005	419	419	419	0	0	1	-360	360;
	108	151	0.00083	0.00525	0.00868	305	305	305	0	0	1	-360	360;
	117	137	0.01589	0.0876	0.11682	347	347	347	0	0	1	-360	360;
	97	130	0.00217	0.01459	0.02575	316	316	316	0	0	1	-360	360;
	134	118	0.01773	0.11678	0.16361	335	335	335	0	0	1	-360	360;
	145	90	0.00593	0.04093	0.07215	446	446	446	0	0	1	-360	360;
	125	107	0.0039	0.02847	0.04498	427	427	427	0	0	1	-360	360;
	136	95	0.00816	0.04242	0.0612	385	385	385	0	0	1	-360	360;
	137	94	0.00816	0.04242	0.0612	385	385	385	0	0	1	-360	360;
	95	92	0.00519	0.03839	0.05875	495	495	495	0	0	1	-360	360;
	94	89	0.00213	0.01403	0.0226	335	335	335	0	0	1	-360	360;
	131	94	0.00463	0.02775	0.04612	362	362	362	0	0	1	-360	360;
	120	88	0.01122	0.07074	0.11571	290	290	290	0	0	1	-360	360;
	127	135	0.00601	0.04147	0.07364	427	427	427	0	0	1	-360	360;
	108	85	0.00207	0.01279	0.02055	316	316	316	0	0	1	-360	360;
	103	107	0.00136	0.0099	0.01586	495	495	495	0	0	1	-360	360;
	148	104	0.00058	0.00417	0.00684	446	446	446	0	0	1	-360	360;
	152	92	0.00085	0.00624	0.00954	457	457	457	0	0	1	-360	360;
	153	93	0.00085	0.00626	0.00948	457	457	457	0	0	1	-360	360;
	119	93	0.00159	0.01112	0.01913	492	492	492	0	0	1	-360	360;
	144	121	0.00314	0.02159	0.03839	446	446	446	0	0	1	-360	360;
	145	128	0.00455	0.03157	0.05531	373	373	373	0	0	1	-360	360;
	121	101	0.00145	0.01008	0.01719	373	373	373	0	0	1	-360	360;
	122	112	0.00384	0.02721	0.04517	373	373	373	0	0	1	-360	360;
	129	96	0.00777	0.04128	0.06391	316	316	316	0	0	1	-360	360;
	106	94	0.00446	0.03041	0.04867	290	290	290	0	0	1	-360	360;
	135	125	0.00589	0.03506	0.05235	362	362	362	0	0	1	-360	360;
	126	116	0.00316	0.02378	0.03527	373	373	373	0	0	1	-360	360;
	134	95	0.00184	0.0126	0.0224	373	373	373	0	0	1	-360	360;
	123	105	0.00171	0.00961	0.01424	335	335	335	0	0	1	-360	360;
	115	95	0.00341	0.02442	0.03997	427	427	427	0	0	1	-360	360;
	135	94	0.00184	0.0126	0.02239	373	373	373	0	0	1	-360	360;
	100	114	0.0057	0.04149	0.06617	446	446	446	0	0	1	-360	360;
	143	136	0.00459	0.02463	0.03616	347	347	347	0	0	1	-360	360;
	142	127	0.00215	0.01333	0.02211	335	335	335	0	0	1	-360	360;
	117	87	0.00079	0.00488	0.00726	137	137	137	0	0	1	-360	360;
	118	86	0.00079	0.00488	0.00724	137	137	137	0	0	1	-360	360;
	110	146	0.00241	0.02782	0.77066	1386	1386	1386	0	0	1	-360	360;
	99	147	0.00213	0.02432	0.67744	1386	1386	1386	0	0	1	-360	360;
	140	132	0.00091	0.0104	0.28989	1358	1358	1358	0	0	1	-360	360;
	141	139	0.00312	0.03563	0.99107	831	831	831	0	0	1	-360	360;
	132	147	0.00092	0.01051	0.29293	1358	1358	1358	0	0	1	-360	360;
	202	181	0.01039	0.08983	0.11422	461	461	461	0	0	1	-360	360;
	203	180	0.01039	0.08983	0.11422	461	461	461	0	0	1	-360	360;
	205	180	0.01455	0.0813	0.13279	362	362	362	0	0	1	-360	360;
	206	181	0.01455	0.0813	0.13279	362	362	362	0	0	1	-360	360;
	158	206	0.00519	0.03965	0.05836	427	427	427	0	0	1	-360	360;
	158	168	0.00083	0.00645	0.00951	427	427	427	0	0	1	-360	360;
	192	163	0.01105	0.08107	0.12824	446	446	446	0	0	1	-360	360;
	159	182	0.00597	0.04473	0.06735	427	427	427	0	0	1	-360	360;
	199	202	0.01736	0.10969	0.16268	305	305	305	0	0	1	-360	360;
	176	203	0.00938	0.06093	0.08934	415	415	415	0	0	1	-360	360;
	179	181	0.01246	0.09134	0.14349	476	476	476	0	0	1	-360	360;
	156	160	0.00514	0.03826	0.05933	305	305	305	0	0	1	-360	360;
	172	166	0.01062	0.0789	0.12085	427	427	427	0	0	1	-360	360;
	178	209	0.00769	0.0569	0.08673	373	373	373	0	0	1	-360	360;
	178	208	0.00225	0.01667	0.02541	286	286	286	0	0	1	-360	360;
	199	170	0.01851	0.1088	0.14435	335	335	335	0	0	1	-360	360;
	204	198	0.00236	0.01411	0.02031	229	229	229	0	0	1	-360	360;
	198	163	0.00355	0.02607	0.04096	446	446	446	0	0	1	-360	360;
	199	194	0.013	0.07589	0.11484	362	362	362	0	0	1	-360	360;
	198	177	0.00934	0.0539	0.08683	377	377	377	0	0	1	-360	360;
	170	154	0.00698	0.0374	0.05463	385	385	385	0	0	1	-360	360;
	169	155	0.00436	0.03202	0.0503	476	476	476	0	0	1	-360	360;
	191	170	0.0006	0.00351	0.00555	446	446	446	0	0	1	-360	360;
	192	169	0.0006	0.00351	0.00555	446	446	446	0	0	1	-360	360;
	179	166	0.01058	0.07762	0.12203	373	373	373	0	0	1	-360	360;
	185	172	0.00469	0.03486	0.05338	427	427	427	0	0	1	-360	360;
	173	164	0.00568	0.04012	0.07033	427	427	427	0	0	1	-360	360;
	196	164	0.00105	0.00733	0.01258	373	373	373	0	0	1	-360	360;
	197	185	0.00744	0.05397	0.09307	373	373	373	0	0	1	-360	360;
	206	157	0.00221	0.01618	0.02541	373	373	373	0	0	1	-360	360;
	207	205	0.00525	0.03837	0.06052	373	373	373	0	0	1	-360	360;
	210	202	0.00236	0.01746	0.02676	381	381	381	0	0	1	-360	360;
	183	161	0.00274	0.02778	0.69846	1150	1150	1150	0	0	1	-360	360;
	189	162	0.00171	0.01741	0.45456	1150	1150	1150	0	0	1	-360	360;
	187	190	0.00136	0.01599	0.41965	1621	1621	1621	0	0	1	-360	360;
	200	175	0.00373	0.04344	1.172	831	831	831	0	0	1	-360	360;
	218	225	0.02738	0.14254	0.20047	351	351	351	0	0	1	-360	360;
	232	238	0.02709	0.15992	0.26125	274	274	274	0	0	1	-360	360;
	219	243	0.01909	0.11277	0.16673	274	274	274	0	0	1	-360	360;
	221	226	0.008	0.05936	0.10081	373	373	373	0	0	1	-360	360;
	225	211	0.00186	0.02155	0.05317	747	747	747	0	0	1	-360	360;
	237	239	0.00738	0.05486	0.09318	274	274	274	0	0	1	-360	360;
	220	236	0.00556	0.04198	0.06158	274	274	274	0	0	1	-360	360;
	233	228	0.00205	0.01421	0.02506	446	446	446	0	0	1	-360	360;
	243	212	0.00568	0.04215	0.0716	366	366	366	0	0	1	-360	360;
	235	213	0.00131	0.01547	0.41152	1358	1358	1358	0	0	1	-360	360;
	215	222	0.00224	0.02606	0.70304	831	831	831	0	0	1	-360	360;
	229	216	0.0024	0.02795	0.75408	1358	1358	1358	0	0	1	-360	360;
	240	234	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360;
	215	240	0.00133	0.01553	0.41901	831	831	831	0	0	1	-360	360;
	216	241	0.00133	0.01553	0.41898	831	831	831	0	0	1	-360	360;
	486	1	0.00157	0.06612	0	160	160	160	0.99491	0	1	-360	360;
	487	2	0.00157	0.06612	0	160	160	160	0.9909	0	1	-360	360;
	310	308	0.00101	0.04727	0	300	300	300	0.91667	0	1	-360	360;
	310	41	0.00079	0.03678	0	426	426	426	0.91667	0	1	-360	360;
	313	4	0.00165	0.06736	0	160	160	160	1.04356	0	1	-360	360;
	5	3	0.00068	0.08078	0	160	160	160	0.9999	0	1	-360	360;
	314	5	0.00072	-0.01281	0	160	160	160	1.02537	0	1	-360	360;
	315	5	-0.00012	0.1674	0	9999	50	50	0.94157	0	1	-360	360;
	347	6	0.00165	0.06901	0	160	160	160	1.03315	0	1	-360	360;
	348	7	0.00165	0.06901	0	160	160	160	1.03303	0	1	-360	360;
	10	8	0.00079	0.07524	0	160	160	160	0.9999	0	1	-360	360;
	425	10	0.00081	-0.00714	0	160	160	160	1.00521	0	1	-360	360;
	427	10	-0.00024	0.15701	0	9999	50	50	0.94157	0	1	-360	360;
	426	8	0.00165	0.0686	0	160	160	160	1.02676	0	1	-360	360;
	426	13	0.00066	0.0269	0	250	250	250	1.10119	0	1	-360	360;
	428	13	-0.00044	0.00942	0	50	50	50	0.98438	0	1	-360	360;
	17	14	0.00059	0.07897	0	160	160	160	0.9999	0	1	-360	360;
	439	17	0.0006	-0.01352	0	160	160	160	1.07516	0	1	-360	360;
	442	17	-0.00467	0.16067	0	16	16	16	0.94157	0	1	-360	360;
	18	15	0.00062	0.08296	0	160	160	160	0.9999	0	1	-360	360;
	440	18	0.00062	-0.01547	0	160	160	160	1.07516	0	1	-360	360;
	443	18	-0.00056	0.17867	0	16	16	16	0.94157	0	1	-360	360;
	441	16	0.00165	0.06775	0	160	160	160	1.09622	0	1	-360	360;
	450	21	0.00011	-0.00462	0	330	330	330	1.09089	0	1	-360	360;
	452	21	0.00452	0.07233	0	63	63	63	0.96037	0	1	-360	360;
	459	22	0.00087	0.05244	-0.02144	330	330	330	1.1175	0	1	-360	360;
	479	24	0.00124	0.06839	0	160	160	160	1.02703	0	1	-360	360;
	478	25	0.00124	0.06839	0	160	160	160	1.01196	0	1	-360	360;
	484	26	0.00165	0.06901	0	160	160	160	1.04795	0	1	-360	360;
	485	27	0.00165	0.06901	0	160	160	160	1.02755	0	1	-360	360;
	491	28	0.00155	0.06612	0	160	160	160	1.08759	0	1	-360	360;
	492	29	0.00157	0.06612	0	160	160	160	1.09829	0	1	-360	360;
	498	30	0.00165	0.06901	0	160	160	160	1.09028	0	1	-360	360;
	499	31	0.00165	0.06901	0	160	160	160	1.09028	0	1	-360	360;
	500	32	0.00157	0.06798	0	160	160	160	1.01602	0	1	-360	360;
	501	33	0.00165	0.06901	0	160	160	160	1.02703	0	1	-360	360;
	509	36	0.00067	0.023	0	250	250	250	1.11802	0	1	-360	360;
	511	36	-0.00044	0.01252	0	50	50	50	0.98438	0	1	-360	360;
	571	43	0.00165	0.06818	0	160	160	160	1.13473	0	1	-360	360;
	601	44	0.00137	0.06119	-0.01504	250	250	250	1.05095	0	1	-360	360;
	602	45	0.00137	0.06119	-0.01504	250	250	250	1.05095	0	1	-360	360;
	682	46	0.00165	0.06901	0	160	160	160	1.09851	0	1	-360	360;
	737	47	0.00165	0.06901	0	160	160	160	1.08569	0	1	-360	360;
	738	48	0.00165	0.06901	0	160	160	160	1.08569	0	1	-360	360;
	756	49	0.0014	0.0668	0	160	160	160	1.0225	0	1	-360	360;
	761	50	0.00151	0.06715	0	160	160	160	1.01599	0	1	-360	360;
	785	52	0.00157	0.07808	0	160	160	160	1.00521	0	1	-360	360;
	789	53	0.00149	0.06616	0	160	160	160	1.02676	0	1	-360	360;
	846	57	0.00157	0.06775	0	160	160	160	1.0225	0	1	-360	360;
	849	62	0.00163	0.06946	0	160	160	160	1.01196	0	1	-360	360;
	851	64	0.00135	0.06052	0	250	250	250	1.04876	0	1	-360	360;
	882	65	0.00135	0.06052	0	250	250	250	1.07213	0	1	-360	360;
	903	66	0.00119	0.06558	0	160	160	160	1.04115	0	1	-360	360;
	923	69	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	927	68	0.00139	0.05984	0	250	250	250	1.06772	0	1	-360	360;
	935	71	0.00145	0.06839	0	160	160	160	1.0225	0	1	-360	360;
	955	76	0.00165	0.06775	0	160	160	160	1.01039	0	1	-360	360;
	954	77	0.00157	0.06775	0	160	160	160	1.00433	0	1	-360	360;
	967	78	0.00163	0.06783	0	160	160	160	1.00562	0	1	-360	360;
	966	79	0.00143	0.06831	0	160	160	160	1.00143	0	1	-360	360;
	976	80	0.00139	0.0608	0	250	250	250	1.05095	0	1	-360	360;
	977	81	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	1008	82	0.00163	0.06754	0	160	160	160	1.01633	0	1	-360	360;
	1042	84	0.00161	0.06762	0	160	160	160	1.02703	0	1	-360	360;
	1065	85	0.00119	0.06565	-0.003	160	160	160	1.02994	0	1	-360	360;
	1094	88	0.00141	0.07036	-0.00319	160	160	160	1.01186	0	1	-360	360;
	1111	90	0.00287	0.10711	-0.00242	100	100	100	1.00972	0	1	-360	360;
	1112	91	0.0014	0.06927	-0.00532	160	160	160	0.99664	0	1	-360	360;
	1214	98	0.00155	0.06268	-0.00992	250	250	250	1.03418	0	1	-360	360;
	1215	98	0.00155	0.06288	-0.00992	250	250	250	1.03622	0	1	-360	360;
	1307	100	0.0016	0.06694	-0.0031	160	160	160	1.06291	0	1	-360	360;
	1308	100	0.00153	0.0666	-0.00319	160	160	160	1.05385	0	1	-360	360;
	1331	101	0.00149	0.06756	-0.00252	160	160	160	0.99966	0	1	-360	360;
	1330	102	0.00149	0.06544	-0.00252	160	160	160	1.01119	0	1	-360	360;
	1408	105	0.00141	0.06975	-0.00232	160	160	160	1.01904	0	1	-360	360;
	1409	106	0.00157	0.0677	-0.00281	160	160	160	1.04338	0	1	-360	360;
	1454	111	0.00154	0.06742	-0.00658	160	160	160	1.02832	0	1	-360	360;
	1453	112	0.00143	0.06701	-0.0029	160	160	160	1.01552	0	1	-360	360;
	1470	113	0.0014	0.06831	-0.00319	160	160	160	1.04745	0	1	-360	360;
	1478	117	0.00162	0.06729	-0.00232	160	160	160	1.00901	0	1	-360	360;
	1477	118	0.00155	0.06701	-0.00319	160	160	160	1.00156	0	1	-360	360;
	1511	119	0.00143	0.06968	-0.00223	160	160	160	1.1232	0	1	-360	360;
	1510	120	0.00155	0.06763	-0.00319	160	160	160	1.08347	0	1	-360	360;
	1513	121	0.00148	0.06688	-0.0029	160	160	160	1.00622	0	1	-360	360;
	1590	122	0.00155	0.06851	-0.0029	160	160	160	1.00562	0	1	-360	360;
	1578	123	0.00174	0.09356	-0.00339	160	160	160	0.98025	0	1	-360	360;
	1580	124	0.00167	0.09275	-0.003	160	160	160	0.99243	0	1	-360	360;
	1617	125	0.00144	0.06708	-0.00223	160	160	160	1.03706	0	1	-360	360;
	1623	127	0.00148	0.06578	-0.00523	160	160	160	1.06211	0	1	-360	360;
	1659	128	0.00152	0.06749	-0.00348	160	160	160	1.05917	0	1	-360	360;
	1793	130	0.00143	0.06968	-0.0029	160	160	160	1.04669	0	1	-360	360;
	1857	132	0.00156	0.06252	-0.00864	250	250	250	1.10237	0	1	-360	360;
	1859	132	0.00156	0.06292	-0.00864	250	250	250	1.06627	0	1	-360	360;
	1902	134	0.00142	0.06729	-0.00223	160	160	160	1.00562	0	1	-360	360;
	1910	137	0.00153	0.06667	-0.00658	160	160	160	1.03633	0	1	-360	360;
	2014	138	0.00136	0.05992	-0.01504	250	250	250	1.09851	0	1	-360	360;
	2016	140	0.00139	0.0612	-0.00992	250	250	250	1.04984	0	1	-360	360;
	2017	141	0.00156	0.06244	-0.00992	250	250	250	1.07415	0	1	-360	360;
	2044	142	0.00155	0.06701	-0.003	160	160	160	1.06519	0	1	-360	360;
	2043	143	0.00121	0.06831	-0.003	160	160	160	1.05641	0	1	-360	360;
	2064	144	0.00139	0.06852	-0.00232	160	160	160	1.00622	0	1	-360	360;
	2063	145	0.00154	0.06811	-0.0029	160	160	160	1.00562	0	1	-360	360;
	2084	148	0.00119	0.06571	-0.00378	160	160	160	1.03799	0	1	-360	360;
	2085	149	0.00143	0.06551	-0.0029	160	160	160	1.01739	0	1	-360	360;
	2153	154	0.00165	0.0625	0	160	160	160	1.03303	0	1	-360	360;
	2173	157	0.00145	0.06818	0	160	160	160	1.01601	0	1	-360	360;
	2174	156	0.00165	0.06818	0	160	160	160	1.02036	0	1	-360	360;
	2178	158	0.00145	0.06818	0	160	160	160	1.02586	0	1	-360	360;
	2199	159	0.00151	0.06688	0	160	160	160	1.00666	0	1	-360	360;
	2201	161	0.00153	0.06206	0	250	250	250	1.08449	0	1	-360	360;
	2202	162	0.00152	0.06206	0	250	250	250	1.08449	0	1	-360	360;
	2207	163	0.00118	0.06517	0	160	160	160	1.06463	0	1	-360	360;
	2233	164	0.00151	0.06688	0	160	160	160	1.02678	0	1	-360	360;
	2239	166	0.00161	0.06653	0	160	160	160	1.00125	0	1	-360	360;
	2240	166	0.00161	0.06653	0	160	160	160	1.00381	0	1	-360	360;
	2304	168	0.00145	0.06818	0	160	160	160	1.04795	0	1	-360	360;
	2305	168	0.00145	0.06818	0	160	160	160	1.02678	0	1	-360	360;
	2321	169	0.00165	0.06851	0	160	160	160	1.0162	0	1	-360	360;
	2320	170	0.00165	0.06851	0	160	160	160	1.03303	0	1	-360	360;
	2319	171	0.00498	0.16449	0	70	70	70	1.00832	0	1	-360	360;
	2322	171	0.00191	0.00254	0	70	70	70	0.98083	0	1	-360	360;
	2332	173	0.00163	0.06136	0.00416	160	160	160	1.01226	0	1	-360	360;
	2377	176	0.00165	0.0593	0	160	160	160	1.10087	0	1	-360	360;
	2386	178	0.00118	0.06517	0	160	160	160	1.04356	0	1	-360	360;
	2387	179	0.00123	0.06619	0	160	160	160	1.04583	0	1	-360	360;
	2403	181	0.00165	0.09277	0	160	160	160	1.01196	0	1	-360	360;
	2404	182	0.00165	0.06694	0	160	160	160	1.0096	0	1	-360	360;
	2411	185	0.00029	0.06136	0.00416	160	160	160	1.0162	0	1	-360	360;
	2412	185	0.00165	0.0686	0	160	160	160	1.0162	0	1	-360	360;
	2443	188	0.00032	-0.00215	0	330	330	330	1.09976	0	1	-360	360;
	2445	188	-0.00023	0.09951	0	63	63	63	0.96037	0	1	-360	360;
	2448	190	0.00101	0.06188	0	330	330	330	1.09976	0	1	-360	360;
	2447	189	0.00138	0.05931	0	250	250	250	1.08449	0	1	-360	360;
	2449	191	0.00163	0.07033	0	160	160	160	1.04795	0	1	-360	360;
	2468	194	0.00165	0.0593	0	160	160	160	1.0797	0	1	-360	360;
	2469	195	0.00165	0.0593	0	160	160	160	1.09028	0	1	-360	360;
	2470	196	0.00281	0.10601	0	100	100	100	0.98445	0	1	-360	360;
	2471	197	0.00281	0.10601	0	100	100	100	0.98445	0	1	-360	360;
	2473	199	0.00165	0.0593	0	160	160	160	1.06463	0	1	-360	360;
	2472	200	0.00101	0.06188	-0.01984	330	330	330	1.11518	0	1	-360	360;
	2473	200	0.00153	0.06206	0	250	250	250	1.11803	0	1	-360	360;
	2486	202	0.00165	0.06653	0	160	160	160	1.05108	0	1	-360	360;
	2487	203	0.00165	0.06775	0	160	160	160	1.06912	0	1	-360	360;
	2492	204	0.00162	0.06763	0	160	160	160	1.10675	0	1	-360	360;
	2556	205	0.00165	0.06818	0	160	160	160	1.02196	0	1	-360	360;
	2557	206	0.00165	0.06818	0	160	160	160	1.03016	0	1	-360	360;
	2668	207	0.00165	0.06632	0	160	160	160	1.03871	0	1	-360	360;
	2691	209	0.00165	0.06632	0	160	160	160	1.09028	0	1	-360	360;
	2690	210	0.00165	0.06632	0	160	160	160	1.09028	0	1	-360	360;
	2712	211	0.00155	0.06585	0	160	160	160	1.09491	0	1	-360	360;
	2737	214	0.00137	0.05968	0	250	250	250	1.05095	0	1	-360	360;
	2746	217	0.00044	-0.00422	0	250	250	250	1.06773	0	1	-360	360;
	2748	217	0.00496	0.06982	0	9999	50	50	0.98438	0	1	-360	360;
	2747	216	0.00129	0.06437	0	250	250	250	1.08448	0	1	-360	360;
	2751	218	0.00015	0.06524	0	160	160	160	1.08282	0	1	-360	360;
	2752	219	0.00027	0.06715	0	160	160	160	1.10197	0	1	-360	360;
	2769	220	0.00163	0.06671	0	160	160	160	1.08006	0	1	-360	360;
	2771	221	0.00163	0.06671	0	160	160	160	1.07319	0	1	-360	360;
	2770	224	0.00032	-0.00435	0	330	330	330	1.08434	0	1	-360	360;
	2772	224	-0.00022	0.1019	0	9999	63	63	0.96037	0	1	-360	360;
	227	225	0.00076	0.0789	0	160	160	160	0.9999	0	1	-360	360;
	2779	227	0.00077	-0.01223	0	160	160	160	1.04452	0	1	-360	360;
	2781	227	-0.00017	0.16709	0	9999	50	50	0.94157	0	1	-360	360;
	2780	226	0.00159	0.06736	0	160	160	160	1.06986	0	1	-360	360;
	2854	231	-0.00013	-0.00407	0	330	330	330	1.04345	0	1	-360	360;
	2856	231	0.00423	0.07177	0	9999	63	63	0.96037	0	1	-360	360;
	2857	232	0.00161	0.06756	0	160	160	160	1.06367	0	1	-360	360;
	2858	233	0.00161	0.06756	0	160	160	160	1.06986	0	1	-360	360;
	2927	234	0.00059	0.04206	0	330	330	330	1.04858	0	1	-360	360;
	2948	237	0.00119	0.06565	0	160	160	160	1.09622	0	1	-360	360;
	2947	236	0.00151	0.06633	0	160	160	160	1.1017	0	1	-360	360;
	2968	238	0.00161	0.06736	0	160	160	160	1.09825	0	1	-360	360;
	2968	239	0.00165	0.06671	0	160	160	160	1.09825	0	1	-360	360;
	2989	240	0.00137	0.05969	0	250	250	250	1.05449	0	1	-360	360;
	2990	240	0.00137	0.05969	0	250	250	250	1.05312	0	1	-360	360;
	2994	242	0.00155	0.06798	0	160	160	160	1.02947	0	1	-360	360;
	2995	243	0.00161	0.06775	0	160	160	160	1.03303	0	1	-360	360;
	2846	434	0.07545	0.13256	0.01257	76	76	76	0	0	1	-360	360;
	2310	366	0.02372	0.06124	0.00624	102	102	102	0	0	1	-360	360;
	2347	389	0.02471	0.06281	0.00641	111	111	111	0	0	1	-360	360;
	2153	517	0.04207	0.1086	0.01107	108	108	108	0	0	1	-360	360;
	2291	267	0.06182	0.10504	0.01014	87	87	87	0	0	1	-360	360;
	2615	648	0.05926	0.10397	0.01048	90	90	90	0	0	1	-360	360;
	1486	305	0.03306	0.08099	0.01007	102	102	102	0	0	1	-360	360;
	1498	539	0.02149	0.07107	0.00724	133	133	133	0	0	1	-360	360;
	861	473	0.04727	0.08388	0.00786	90	90	90	0	0	1	-360	360;
	800	499	0.07463	0.13025	0.01244	83	83	83	0	0	1	-360	360;
	972	569	0.05223	0.09008	0.00866	83	83	83	0	0	1	-360	360;
	1031	1504	0.04545	0.07934	0.00852	69	69	69	0	0	1	-360	360;
	862	1803	0.03719	0.06033	0.00656	58	58	58	0	0	1	-360	360;
	935	1882	0.04132	0.13967	0.01241	102	102	102	0	0	1	-360	360;
	965	1588	0.02397	0.05372	0.00881	57	57	57	0	0	1	-360	360;
	1278	765	0.01653	0.02008	0.0042	78	78	78	0	0	1	-360	360;
	2661	1367	0.07025	0.12066	0.0129	67	67	67	0	0	1	-360	360;
	2940	2449	0.03719	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2872	2449	0.08207	0.20008	0.02217	120	120	120	0	0	1	-360	360;
	2877	2450	0.04463	0.11521	0.01205	120	120	120	0	0	1	-360	360;
	2819	2320	0.0681	0.17298	0.01756	120	120	120	0	0	1	-360	360;
	2817	2156	0.05678	0.14413	0.01463	120	120	120	0	0	1	-360	360;
	2840	2450	0.05628	0.18322	0.01876	137	137	137	0	0	1	-360	360;
	1914	987	0.03884	0.06446	0.00695	58	58	58	0	0	1	-360	360;
	846	555	0.04678	0.32397	0.03151	131	131	131	0	0	1	-360	360;
	1516	2302	0.0405	0.05041	0.00719	57	57	57	0	0	1	-360	360;
	649	1434	0.05702	0.11322	0.01232	78	78	78	0	0	1	-360	360;
	846	569	0.01636	0.05314	0.00619	112	112	112	0	0	1	-360	360;
	847	320	0.05661	0.1305	0.013	83	83	83	0	0	1	-360	360;
	632	1230	0.00992	0.02975	0.00356	119	119	119	0	0	1	-360	360;
	958	473	0.01397	0.04504	0.00462	137	137	137	0	0	1	-360	360;
	898	413	0.05992	0.10149	0.01089	83	83	83	0	0	1	-360	360;
	880	555	0.07438	0.13025	0.01236	83	83	83	0	0	1	-360	360;
	2807	322	0.0394	0.12917	0.01307	76	76	76	0	0	1	-360	360;
	2846	303	0.04521	0.0795	0.00754	76	76	76	0	0	1	-360	360;
	920	589	0.01719	0.0557	0.00569	137	137	137	0	0	1	-360	360;
	1031	1896	0.01405	0.04298	0.00513	69	69	69	0	0	1	-360	360;
	1994	897	0.02149	0.0405	0.00799	120	120	120	0	0	1	-360	360;
	1932	897	0.01901	0.03388	0.00697	57	57	57	0	0	1	-360	360;
	1819	904	0.05106	0.09015	0.00845	76	76	76	0	0	1	-360	360;
	956	413	0.04231	0.07529	0.00706	142	142	142	0	0	1	-360	360;
	2938	464	0.03752	0.12182	0.0124	69	69	69	0	0	1	-360	360;
	2703	417	0.07884	0.10231	0.01021	69	69	69	0	0	1	-360	360;
	847	577	0.05653	0.18587	0.01908	112	112	112	0	0	1	-360	360;
	900	548	0.02826	0.09669	0.00936	76	76	76	0	0	1	-360	360;
	802	1234	0.01901	0.05868	0.00682	114	114	114	0	0	1	-360	360;
	2845	2630	0.03074	0.09917	0.01021	69	69	69	0	0	1	-360	360;
	2842	432	0.02314	0.07529	0.00762	19	19	19	0	0	1	-360	360;
	262	260	0.03744	0.18876	0.01765	151	151	151	0	0	1	-360	360;
	526	441	0.01223	0.02868	0.00295	133	133	133	0	0	1	-360	360;
	393	266	0.01959	0.06355	0.00659	133	133	133	0	0	1	-360	360;
	725	641	0.00686	0.02207	0.00232	133	133	133	0	0	1	-360	360;
	525	725	0.00554	0.01802	0.00184	133	133	133	0	0	1	-360	360;
	725	730	0.00273	0.0095	0.001	133	133	133	0	0	1	-360	360;
	431	425	0.02355	0.06107	0.00629	120	120	120	0	0	1	-360	360;
	430	426	0.02339	0.0619	0.00629	120	120	120	0	0	1	-360	360;
	481	425	0.01545	0.04488	0.00434	120	120	120	0	0	1	-360	360;
	586	426	0.01967	0.05959	0.00587	120	120	120	0	0	1	-360	360;
	329	498	0.03182	0.05851	0.00559	90	90	90	0	0	1	-360	360;
	330	499	0.03256	0.06124	0.00549	90	90	90	0	0	1	-360	360;
	564	426	0.00251	0.00811	0.00086	137	137	137	0	0	1	-360	360;
	590	498	0.04058	0.07612	0.00678	90	90	90	0	0	1	-360	360;
	641	564	0.01398	0.04524	0.0048	137	137	137	0	0	1	-360	360;
	524	433	0.04306	0.07157	0.00754	90	90	90	0	0	1	-360	360;
	461	296	0.02736	0.05992	0.00581	90	90	90	0	0	1	-360	360;
	523	288	0.02455	0.07967	0.00818	133	133	133	0	0	1	-360	360;
	590	360	0.02165	0.0386	0.00351	90	90	90	0	0	1	-360	360;
	567	551	0.11182	0.19074	0.01909	90	90	90	0	0	1	-360	360;
	571	321	0.03083	0.10008	0.01034	142	142	142	0	0	1	-360	360;
	361	347	0.01967	0.06455	0.00652	120	120	120	0	0	1	-360	360;
	377	275	0.00653	0.02157	0.00211	120	120	120	0	0	1	-360	360;
	409	485	0.02364	0.07736	0.00789	120	120	120	0	0	1	-360	360;
	410	409	0.00248	0.00802	0.00082	133	133	133	0	0	1	-360	360;
	416	327	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360;
	469	348	0.02281	0.07446	0.00759	120	120	120	0	0	1	-360	360;
	743	528	0.02934	0.09512	0.00992	120	120	120	0	0	1	-360	360;
	482	389	0.01372	0.04455	0.00461	120	120	120	0	0	1	-360	360;
	419	292	0.02975	0.07686	0.00795	120	120	120	0	0	1	-360	360;
	478	404	0.03149	0.10347	0.01045	140	140	140	0	0	1	-360	360;
	479	465	0.04736	0.08314	0.00789	90	90	90	0	0	1	-360	360;
	465	362	0.0243	0.07975	0.00805	140	140	140	0	0	1	-360	360;
	483	439	0.00645	0.02025	0.00223	90	90	90	0	0	1	-360	360;
	515	466	0.03702	0.12132	0.0121	133	133	133	0	0	1	-360	360;
	669	571	0.02256	0.07322	0.0075	133	133	133	0	0	1	-360	360;
	752	407	0.05926	0.10455	0.00969	90	90	90	0	0	1	-360	360;
	571	269	0.02744	0.08264	0.00995	142	142	142	0	0	1	-360	360;
	570	588	0.04893	0.15504	0.01573	120	120	120	0	0	1	-360	360;
	557	524	0.0238	0.0781	0.00789	133	133	133	0	0	1	-360	360;
	365	496	0.00711	0.02281	0.00242	133	133	133	0	0	1	-360	360;
	604	558	0.01381	0.04492	0.00795	111	111	111	0	0	1	-360	360;
	670	368	0.01736	0.04533	0.00922	90	90	90	0	0	1	-360	360;
	343	396	0.00919	0.02977	0.00316	111	111	111	0	0	1	-360	360;
	397	716	0.00631	0.02038	0.00216	111	111	111	0	0	1	-360	360;
	729	640	0.00455	0.01471	0.00154	133	133	133	0	0	1	-360	360;
	249	439	0.00628	0.02036	0.00216	137	137	137	0	0	1	-360	360;
	248	449	0.00643	0.02076	0.0022	137	137	137	0	0	1	-360	360;
	691	439	0.00356	0.01154	0.00122	137	137	137	0	0	1	-360	360;
	702	624	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	701	625	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	625	609	0.00555	0.01796	0.00293	111	111	111	0	0	1	-360	360;
	610	440	0.00607	0.01973	0.00291	137	137	137	0	0	1	-360	360;
	683	441	0.00382	0.02652	0.00281	137	137	137	0	0	1	-360	360;
	666	440	0.01348	0.03592	0.0151	90	90	90	0	0	1	-360	360;
	656	439	0.01121	0.03006	0.01231	90	90	90	0	0	1	-360	360;
	678	665	0.0047	0.01191	0.00126	90	90	90	0	0	1	-360	360;
	671	611	0.01017	0.02827	0.02773	90	90	90	0	0	1	-360	360;
	603	439	0.00161	0.00521	0.00055	111	111	111	0	0	1	-360	360;
	606	441	0.00212	0.00684	0.00073	111	111	111	0	0	1	-360	360;
	671	654	0.01826	0.04974	0.00528	90	90	90	0	0	1	-360	360;
	675	690	0.00916	0.02956	0.00314	111	111	111	0	0	1	-360	360;
	672	671	0.00421	0.01103	0.00117	90	90	90	0	0	1	-360	360;
	673	670	0.00421	0.01103	0.00117	90	90	90	0	0	1	-360	360;
	701	680	0.00596	0.01931	0.00205	137	137	137	0	0	1	-360	360;
	701	621	0.00118	0.0038	0.0004	137	137	137	0	0	1	-360	360;
	674	624	0.00241	0.00778	0.00083	111	111	111	0	0	1	-360	360;
	641	426	0.01404	0.04546	0.00483	137	137	137	0	0	1	-360	360;
	728	709	0.0045	0.0145	0.00154	111	111	111	0	0	1	-360	360;
	659	709	0.01103	0.02812	0.00298	90	90	90	0	0	1	-360	360;
	709	346	0.00037	0.0012	0.00013	111	111	111	0	0	1	-360	360;
	425	708	0.00855	0.02759	0.00293	111	111	111	0	0	1	-360	360;
	712	708	0.0017	0.00427	0.00045	90	90	90	0	0	1	-360	360;
	670	712	0.00843	0.02047	0.00217	90	90	90	0	0	1	-360	360;
	708	345	0.00045	0.00115	0.00012	111	111	111	0	0	1	-360	360;
	712	421	0.00026	0.00066	7e-05	90	90	90	0	0	1	-360	360;
	635	665	0.00616	0.02064	0.00971	111	111	111	0	0	1	-360	360;
	623	693	0.00083	0.00356	0.02543	137	137	137	0	0	1	-360	360;
	677	612	0.00034	0.00216	0.01054	109	109	109	0	0	1	-360	360;
	441	451	0.01254	0.04055	0.00431	137	137	137	0	0	1	-360	360;
	642	449	0.00439	0.01417	0.0015	137	137	137	0	0	1	-360	360;
	702	715	0.01264	0.04099	0.00435	137	137	137	0	0	1	-360	360;
	715	629	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	715	436	0.00329	0.00826	0.00088	90	90	90	0	0	1	-360	360;
	684	342	0.00363	0.01174	0.00125	137	137	137	0	0	1	-360	360;
	625	519	0.00101	0.00587	0.03106	95	95	95	0	0	1	-360	360;
	439	744	0.00493	0.01634	0.00609	111	111	111	0	0	1	-360	360;
	440	639	0.00401	0.01293	0.00137	111	111	111	0	0	1	-360	360;
	651	682	0.00031	0.00199	0.00973	98	98	98	0	0	1	-360	360;
	665	657	0.00279	0.00805	0.00815	90	90	90	0	0	1	-360	360;
	686	605	0.00316	0.01018	0.00108	111	111	111	0	0	1	-360	360;
	629	747	0.00056	0.00182	0.00019	137	137	137	0	0	1	-360	360;
	679	670	0.00404	0.01024	0.00109	90	90	90	0	0	1	-360	360;
	693	620	0.00769	0.0249	0.00264	137	137	137	0	0	1	-360	360;
	689	636	0.00154	0.00541	0.00499	111	111	111	0	0	1	-360	360;
	688	670	0.00575	0.01855	0.00197	111	111	111	0	0	1	-360	360;
	667	666	0.00167	0.00597	0.00617	111	111	111	0	0	1	-360	360;
	671	668	0.0118	0.03881	0.01131	111	111	111	0	0	1	-360	360;
	643	746	0.00358	0.01155	0.00122	137	137	137	0	0	1	-360	360;
	716	630	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	716	437	0.00391	0.00826	0.00088	90	90	90	0	0	1	-360	360;
	644	745	0.00181	0.00621	0.00438	111	111	111	0	0	1	-360	360;
	645	638	0.00169	0.00619	0.0081	111	111	111	0	0	1	-360	360;
	701	685	0.00318	0.01028	0.00109	137	137	137	0	0	1	-360	360;
	700	265	0.00995	0.03021	0.00321	120	120	120	0	0	1	-360	360;
	671	626	0.01377	0.03899	0.00414	90	90	90	0	0	1	-360	360;
	693	713	0.01243	0.03156	0.00335	90	90	90	0	0	1	-360	360;
	713	422	0.00026	0.00066	7e-05	90	90	90	0	0	1	-360	360;
	627	622	0.0028	0.00903	0.00096	111	111	111	0	0	1	-360	360;
	681	641	0.00701	0.0227	0.00241	137	137	137	0	0	1	-360	360;
	692	640	0.00393	0.01271	0.00135	137	137	137	0	0	1	-360	360;
	687	499	0.01963	0.06331	0.00672	111	111	111	0	0	1	-360	360;
	655	499	0.01202	0.03521	0.00986	90	90	90	0	0	1	-360	360;
	640	615	0.00882	0.02843	0.00302	133	133	133	0	0	1	-360	360;
	641	495	0.02083	0.06719	0.00713	133	133	133	0	0	1	-360	360;
	683	676	0.00064	0.0041	0.02001	109	109	109	0	0	1	-360	360;
	425	728	0.00412	0.01331	0.00141	111	111	111	0	0	1	-360	360;
	663	650	0.00041	0.00259	0.01264	98	98	98	0	0	1	-360	360;
	520	664	0.0006	0.00374	0.01827	98	98	98	0	0	1	-360	360;
	692	658	0.0042	0.01131	0.0012	90	90	90	0	0	1	-360	360;
	630	451	0.00396	0.01276	0.00135	137	137	137	0	0	1	-360	360;
	624	652	0.00028	0.00179	0.01597	137	137	137	0	0	1	-360	360;
	682	653	0.00041	0.00264	0.0236	183	183	183	0	0	1	-360	360;
	614	642	0.00049	0.00313	0.02806	137	137	137	0	0	1	-360	360;
	578	412	0.03322	0.10785	0.01114	133	133	133	0	0	1	-360	360;
	721	444	0.01169	0.03841	0.00388	133	133	133	0	0	1	-360	360;
	370	721	0.00954	0.03133	0.00316	133	133	133	0	0	1	-360	360;
	568	721	0.00017	0.00033	3e-05	133	133	133	0	0	1	-360	360;
	505	429	0.0686	0.12	0.01149	90	90	90	0	0	1	-360	360;
	751	573	0.04174	0.07628	0.00695	90	90	90	0	0	1	-360	360;
	646	525	0.01372	0.03719	0.00363	120	120	120	0	0	1	-360	360;
	505	320	0.01777	0.03124	0.00297	90	90	90	0	0	1	-360	360;
	572	551	0.0324	0.09587	0.00967	90	90	90	0	0	1	-360	360;
	474	295	0.01504	0.03075	0.00298	90	90	90	0	0	1	-360	360;
	513	474	0.01182	0.01967	0.00207	90	90	90	0	0	1	-360	360;
	321	280	0.00917	0.02983	0.00307	133	133	133	0	0	1	-360	360;
	521	280	0.00785	0.02545	0.00262	133	133	133	0	0	1	-360	360;
	553	552	0.00636	0.02091	0.00212	133	133	133	0	0	1	-360	360;
	647	535	0.0224	0.03926	0.00372	90	90	90	0	0	1	-360	360;
	698	536	0.07868	0.13934	0.01292	90	90	90	0	0	1	-360	360;
	661	647	0.00595	0.01157	0.0011	90	90	90	0	0	1	-360	360;
	596	250	0.04719	0.08273	0.00785	90	90	90	0	0	1	-360	360;
	526	522	0.00496	0.01421	0.00145	120	120	120	0	0	1	-360	360;
	523	479	0.05926	0.19198	0.01974	133	133	133	0	0	1	-360	360;
	634	295	0.00289	0.00926	0.00096	133	133	133	0	0	1	-360	360;
	392	395	0.00504	0.00901	0.00084	90	90	90	0	0	1	-360	360;
	478	706	0.00397	0.01298	0.00132	133	133	133	0	0	1	-360	360;
	731	706	0.01702	0.05512	0.00542	133	133	133	0	0	1	-360	360;
	706	476	8e-05	0.00017	2e-05	133	133	133	0	0	1	-360	360;
	697	694	0.01107	0.01934	0.00184	90	90	90	0	0	1	-360	360;
	586	367	0.00942	0.03041	0.00315	133	133	133	0	0	1	-360	360;
	518	433	0.06091	0.10124	0.01098	90	90	90	0	0	1	-360	360;
	705	478	0.00678	0.01446	0.00132	90	90	90	0	0	1	-360	360;
	518	705	0.00653	0.01207	0.00129	90	90	90	0	0	1	-360	360;
	705	475	0.00017	0.00025	2e-05	90	90	90	0	0	1	-360	360;
	479	477	0.03967	0.1286	0.01323	133	133	133	0	0	1	-360	360;
	477	419	0.02314	0.05587	0.00629	120	120	120	0	0	1	-360	360;
	698	420	0.05322	0.13512	0.01374	120	120	120	0	0	1	-360	360;
	619	420	0.03942	0.12769	0.01323	133	133	133	0	0	1	-360	360;
	394	467	0.02017	0.06405	0.00675	133	133	133	0	0	1	-360	360;
	483	269	0.03529	0.10818	0.011	90	90	90	0	0	1	-360	360;
	335	522	0.00331	0.01091	0.0011	133	133	133	0	0	1	-360	360;
	335	521	0.00347	0.01132	0.00117	133	133	133	0	0	1	-360	360;
	699	251	0.03909	0.06843	0.00649	90	90	90	0	0	1	-360	360;
	700	616	0.00574	0.01668	0.00177	120	120	120	0	0	1	-360	360;
	662	595	0.03289	0.05744	0.00521	90	90	90	0	0	1	-360	360;
	557	296	0.01165	0.04298	0.0039	90	90	90	0	0	1	-360	360;
	367	354	0.00901	0.02917	0.00302	133	133	133	0	0	1	-360	360;
	714	430	0.01522	0.08255	0.00509	133	133	133	0	0	1	-360	360;
	444	714	0.00791	0.02572	0.00265	133	133	133	0	0	1	-360	360;
	424	714	0.00339	0.00603	0.00054	133	133	133	0	0	1	-360	360;
	720	370	0.00542	0.01753	0.00181	133	133	133	0	0	1	-360	360;
	552	720	0.00631	0.0204	0.00211	133	133	133	0	0	1	-360	360;
	549	720	0.00256	0.00463	0.00041	133	133	133	0	0	1	-360	360;
	634	394	0.00694	0.02256	0.00234	90	90	90	0	0	1	-360	360;
	617	295	0.00355	0.0114	0.00118	133	133	133	0	0	1	-360	360;
	554	553	0.00636	0.02074	0.00214	133	133	133	0	0	1	-360	360;
	395	393	0.00694	0.02281	0.0023	133	133	133	0	0	1	-360	360;
	731	489	0.01975	0.06479	0.00655	133	133	133	0	0	1	-360	360;
	694	489	0.03116	0.08463	0.00843	90	90	90	0	0	1	-360	360;
	751	619	0.00537	0.01752	0.00177	133	133	133	0	0	1	-360	360;
	307	478	0.01678	0.05661	0.00575	133	133	133	0	0	1	-360	360;
	454	307	0.02686	0.0881	0.0089	133	133	133	0	0	1	-360	360;
	429	585	0.02727	0.07157	0.00743	133	133	133	0	0	1	-360	360;
	617	365	0.01372	0.04471	0.0046	133	133	133	0	0	1	-360	360;
	513	466	0.00545	0.01752	0.00183	133	133	133	0	0	1	-360	360;
	368	498	0.00607	0.01757	0.00407	90	90	90	0	0	1	-360	360;
	558	498	0.01061	0.03423	0.00363	111	111	111	0	0	1	-360	360;
	353	481	0.0057	0.01851	0.00193	133	133	133	0	0	1	-360	360;
	316	554	0.00012	0.00052	0.00318	133	133	133	0	0	1	-360	360;
	401	388	0.00223	0.00727	0.00073	120	120	120	0	0	1	-360	360;
	387	347	0.00306	0.00959	0.001	120	120	120	0	0	1	-360	360;
	398	381	0.00579	0.01661	0.00179	120	120	120	0	0	1	-360	360;
	534	347	0.01802	0.04636	0.0047	120	120	120	0	0	1	-360	360;
	633	348	0.00463	0.01488	0.00145	120	120	120	0	0	1	-360	360;
	411	347	0.00711	0.02273	0.00242	140	140	140	0	0	1	-360	360;
	380	704	0.00107	0.00281	0.00033	120	120	120	0	0	1	-360	360;
	385	704	0.00992	0.02636	0.00299	120	120	120	0	0	1	-360	360;
	704	304	0.00066	0.00174	0.00016	120	120	120	0	0	1	-360	360;
	591	385	0.00463	0.01388	0.00167	120	120	120	0	0	1	-360	360;
	382	386	0.00372	0.0119	0.00125	120	120	120	0	0	1	-360	360;
	727	384	0.00058	0.00198	0.00021	140	140	140	0	0	1	-360	360;
	382	727	0.00306	0.00992	0.00104	140	140	140	0	0	1	-360	360;
	727	750	0.0005	0.00165	0.00017	120	120	120	0	0	1	-360	360;
	737	384	0.00529	0.01645	0.00189	120	120	120	0	0	1	-360	360;
	726	408	0.00736	0.02388	0.00248	140	140	140	0	0	1	-360	360;
	374	726	0.00215	0.00645	0.00078	120	120	120	0	0	1	-360	360;
	737	726	0.00562	0.01818	0.0019	140	140	140	0	0	1	-360	360;
	718	383	0.00488	0.0124	0.00121	120	120	120	0	0	1	-360	360;
	718	485	0.00595	0.01793	0.00216	140	140	140	0	0	1	-360	360;
	545	718	0.00033	0.00099	0.0001	140	140	140	0	0	1	-360	360;
	738	591	0.00405	0.01298	0.00134	120	120	120	0	0	1	-360	360;
	737	546	0.00752	0.02264	0.0027	140	140	140	0	0	1	-360	360;
	485	287	0.01388	0.03628	0.00396	120	120	120	0	0	1	-360	360;
	388	287	0.01661	0.04702	0.00505	120	120	120	0	0	1	-360	360;
	402	383	0.00504	0.01612	0.0017	120	120	120	0	0	1	-360	360;
	418	348	0.01058	0.02802	0.00316	120	120	120	0	0	1	-360	360;
	711	383	0.00264	0.0086	0.0009	140	140	140	0	0	1	-360	360;
	408	711	8e-05	0.00033	4e-05	140	140	140	0	0	1	-360	360;
	711	403	0.00024	0.00769	0.00078	140	140	140	0	0	1	-360	360;
	418	380	0.00339	0.01124	0.00111	120	120	120	0	0	1	-360	360;
	386	374	0.00223	0.00678	0.00082	120	120	120	0	0	1	-360	360;
	579	327	0.01066	0.03231	0.00383	120	120	120	0	0	1	-360	360;
	546	579	0.01579	0.04785	0.00568	120	120	120	0	0	1	-360	360;
	387	381	0.0057	0.01372	0.00155	120	120	120	0	0	1	-360	360;
	278	737	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	359	347	0.01876	0.05198	0.00571	120	120	120	0	0	1	-360	360;
	484	359	0.01711	0.04669	0.00509	120	120	120	0	0	1	-360	360;
	484	435	0.00339	0.01017	0.00123	120	120	120	0	0	1	-360	360;
	279	738	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	275	348	0.01446	0.04802	0.00469	140	140	140	0	0	1	-360	360;
	411	399	0.00769	0.02471	0.00261	120	120	120	0	0	1	-360	360;
	387	399	0.00504	0.0162	0.0017	120	120	120	0	0	1	-360	360;
	527	435	0.00479	0.01446	0.00175	120	120	120	0	0	1	-360	360;
	576	485	0.00785	0.02537	0.00267	120	120	120	0	0	1	-360	360;
	576	401	0.00909	0.03058	0.00315	120	120	120	0	0	1	-360	360;
	484	398	0.01281	0.04116	0.00434	120	120	120	0	0	1	-360	360;
	379	484	0.00612	0.01975	0.00208	120	120	120	0	0	1	-360	360;
	369	484	0.01198	0.0386	0.00406	120	120	120	0	0	1	-360	360;
	369	379	0.00562	0.0181	0.00191	120	120	120	0	0	1	-360	360;
	738	482	0.0238	0.07215	0.00855	120	120	120	0	0	1	-360	360;
	633	388	0.00388	0.01256	0.00132	120	120	120	0	0	1	-360	360;
	737	534	0.00496	0.01496	0.00177	120	120	120	0	0	1	-360	360;
	375	738	0.00504	0.01521	0.00181	120	120	120	0	0	1	-360	360;
	598	660	0.01628	0.05397	0.00529	133	133	133	0	0	1	-360	360;
	717	326	0.02521	0.08223	0.00841	133	133	133	0	0	1	-360	360;
	543	717	0.00149	0.00471	0.00049	133	133	133	0	0	1	-360	360;
	717	529	0.01702	0.03058	0.00276	90	90	90	0	0	1	-360	360;
	512	501	0.00843	0.0214	0.00218	120	120	120	0	0	1	-360	360;
	593	571	0.0195	0.03545	0.00353	133	133	133	0	0	1	-360	360;
	753	263	0.01361	0.02471	0.00246	133	133	133	0	0	1	-360	360;
	754	445	0.02264	0.03769	0.00397	90	90	90	0	0	1	-360	360;
	736	410	0.01413	0.04653	0.0047	133	133	133	0	0	1	-360	360;
	356	285	0.0044	0.03039	0.00342	232	232	232	0	0	1	-360	360;
	740	574	0.01653	0.05388	0.0055	133	133	133	0	0	1	-360	360;
	736	550	0.01785	0.03273	0.00346	133	133	133	0	0	1	-360	360;
	550	517	0.03033	0.07331	0.00825	133	133	133	0	0	1	-360	360;
	490	517	0.00719	0.01256	0.0012	90	90	90	0	0	1	-360	360;
	735	373	0.01711	0.04364	0.00444	120	120	120	0	0	1	-360	360;
	547	373	0.03124	0.07942	0.00808	120	120	120	0	0	1	-360	360;
	601	559	0.01	0.02628	0.00267	120	120	120	0	0	1	-360	360;
	559	547	0.02802	0.06182	0.00747	120	120	120	0	0	1	-360	360;
	468	361	0.00413	0.01347	0.00139	133	133	133	0	0	1	-360	360;
	472	598	0.02595	0.08512	0.0086	133	133	133	0	0	1	-360	360;
	560	468	0.04041	0.13264	0.01339	133	133	133	0	0	1	-360	360;
	618	561	0.00256	0.00843	0.00087	133	133	133	0	0	1	-360	360;
	350	574	0.01413	0.03727	0.004	90	90	90	0	0	1	-360	360;
	544	597	0.00711	0.01248	0.00119	90	90	90	0	0	1	-360	360;
	599	544	0.00579	0.01174	0.00114	90	90	90	0	0	1	-360	360;
	600	598	0.0105	0.02447	0.00217	90	90	90	0	0	1	-360	360;
	570	406	0.05455	0.09471	0.00914	90	90	90	0	0	1	-360	360;
	531	469	0.06058	0.10603	0.01006	90	90	90	0	0	1	-360	360;
	543	537	0.00273	0.00785	0.00079	133	133	133	0	0	1	-360	360;
	597	270	0.01198	0.03893	0.00402	133	133	133	0	0	1	-360	360;
	723	501	0.01074	0.03479	0.00359	133	133	133	0	0	1	-360	360;
	723	270	0.00983	0.03198	0.0033	133	133	133	0	0	1	-360	360;
	581	723	0.00785	0.0257	0.00248	133	133	133	0	0	1	-360	360;
	631	602	0.01298	0.04215	0.00436	133	133	133	0	0	1	-360	360;
	298	601	0.00471	0.01529	0.00159	90	90	90	0	0	1	-360	360;
	299	602	0.00744	0.01554	0.00151	90	90	90	0	0	1	-360	360;
	300	601	0.00843	0.01744	0.00169	90	90	90	0	0	1	-360	360;
	301	602	0.00826	0.01719	0.00166	90	90	90	0	0	1	-360	360;
	601	306	0.00314	0.00942	0.00096	120	120	120	0	0	1	-360	360;
	541	487	0.00355	0.02421	0.00271	232	232	232	0	0	1	-360	360;
	486	281	0.01372	0.04446	0.00461	133	133	133	0	0	1	-360	360;
	542	332	0.00164	0.01112	0.00134	232	232	232	0	0	1	-360	360;
	487	252	0.01967	0.0638	0.0066	133	133	133	0	0	1	-360	360;
	283	472	0.00355	0.01157	0.00121	133	133	133	0	0	1	-360	360;
	497	453	0.02868	0.09314	0.00962	133	133	133	0	0	1	-360	360;
	281	253	0.00686	0.02215	0.00229	133	133	133	0	0	1	-360	360;
	512	252	0.02231	0.07248	0.0075	133	133	133	0	0	1	-360	360;
	748	531	0.01471	0.04769	0.00493	133	133	133	0	0	1	-360	360;
	748	548	0.0195	0.06331	0.00654	133	133	133	0	0	1	-360	360;
	742	253	0.02058	0.06694	0.00691	133	133	133	0	0	1	-360	360;
	446	344	0.00851	0.02793	0.00285	133	133	133	0	0	1	-360	360;
	503	500	0.00488	0.01587	0.00164	133	133	133	0	0	1	-360	360;
	570	277	0.00843	0.02769	0.00279	133	133	133	0	0	1	-360	360;
	503	486	0.03529	0.13702	0.01374	133	133	133	0	0	1	-360	360;
	378	599	0.0243	0.07893	0.00815	133	133	133	0	0	1	-360	360;
	487	332	0.00182	0.01273	0.00142	232	232	232	0	0	1	-360	360;
	486	333	0.00174	0.01207	0.00134	232	232	232	0	0	1	-360	360;
	284	308	0.00788	0.05315	0.00589	232	232	232	0	0	1	-360	360;
	541	309	0.00107	0.00719	0.00094	232	232	232	0	0	1	-360	360;
	355	333	0.00256	0.02273	0.00199	232	232	232	0	0	1	-360	360;
	487	325	0.0195	0.06314	0.00654	133	133	133	0	0	1	-360	360;
	276	618	0.0357	0.11719	0.01184	133	133	133	0	0	1	-360	360;
	268	349	0.0443	0.09347	0.00876	90	90	90	0	0	1	-360	360;
	648	602	0.01893	0.06248	0.01932	133	133	133	0	0	1	-360	360;
	415	407	0.01099	0.02322	0.00218	90	90	90	0	0	1	-360	360;
	735	740	0.01215	0.03934	0.00405	133	133	133	0	0	1	-360	360;
	282	453	0.02909	0.09438	0.00976	133	133	133	0	0	1	-360	360;
	264	592	0.03183	0.05769	0.00576	133	133	133	0	0	1	-360	360;
	589	497	0.01983	0.06438	0.00665	133	133	133	0	0	1	-360	360;
	734	649	0.02421	0.07934	0.00803	133	133	133	0	0	1	-360	360;
	734	349	0.02223	0.07281	0.00735	133	133	133	0	0	1	-360	360;
	500	660	0.01289	0.04289	0.0042	133	133	133	0	0	1	-360	360;
	360	344	0.03273	0.0719	0.00681	83	83	83	0	0	1	-360	360;
	494	506	0.00835	0.0262	0.00292	90	90	90	0	0	1	-360	360;
	492	488	0.0076	0.02545	0.00249	133	133	133	0	0	1	-360	360;
	493	455	0.01182	0.03	0.00305	120	120	120	0	0	1	-360	360;
	510	456	0.0162	0.05405	0.00527	133	133	133	0	0	1	-360	360;
	507	336	0.01992	0.06438	0.00667	133	133	133	0	0	1	-360	360;
	710	371	0.01066	0.01868	0.00186	133	133	133	0	0	1	-360	360;
	710	336	0.01587	0.05388	0.00533	133	133	133	0	0	1	-360	360;
	710	565	0.01074	0.03496	0.00361	133	133	133	0	0	1	-360	360;
	390	372	0.02702	0.08744	0.00905	133	133	133	0	0	1	-360	360;
	331	289	0.01909	0.06273	0.00634	133	133	133	0	0	1	-360	360;
	471	331	0.01975	0.06496	0.00656	133	133	133	0	0	1	-360	360;
	575	509	0.02504	0.08223	0.00831	133	133	133	0	0	1	-360	360;
	272	575	0.0076	0.02298	0.00272	133	133	133	0	0	1	-360	360;
	493	319	0.02314	0.07413	0.00785	133	133	133	0	0	1	-360	360;
	532	462	0.03884	0.1276	0.01288	133	133	133	0	0	1	-360	360;
	722	488	0.01835	0.06025	0.00608	133	133	133	0	0	1	-360	360;
	722	516	0.03033	0.09967	0.01006	133	133	133	0	0	1	-360	360;
	580	722	0.00182	0.00603	0.00059	133	133	133	0	0	1	-360	360;
	566	372	0.00975	0.0295	0.00355	133	133	133	0	0	1	-360	360;
	752	371	0.03678	0.0638	0.00623	90	90	90	0	0	1	-360	360;
	594	302	0.0214	0.07157	0.00699	133	133	133	0	0	1	-360	360;
	514	491	0.00198	0.0062	0.00069	133	133	133	0	0	1	-360	360;
	530	491	0.00562	0.01711	0.0018	90	90	90	0	0	1	-360	360;
	337	493	0.00306	0.01	0.00103	133	133	133	0	0	1	-360	360;
	492	458	0.00959	0.03099	0.0032	133	133	133	0	0	1	-360	360;
	509	457	0.01066	0.03463	0.00358	133	133	133	0	0	1	-360	360;
	504	448	0.0043	0.01298	0.00157	133	133	133	0	0	1	-360	360;
	461	288	0.08909	0.17595	0.01535	90	90	90	0	0	1	-360	360;
	749	302	0.03124	0.10421	0.01018	133	133	133	0	0	1	-360	360;
	530	506	0.00479	0.01603	0.00156	133	133	133	0	0	1	-360	360;
	463	703	0.00917	0.03	0.00303	133	133	133	0	0	1	-360	360;
	703	289	0.00678	0.02215	0.00224	133	133	133	0	0	1	-360	360;
	286	703	1e-05	8e-05	0	133	133	133	0	0	1	-360	360;
	372	366	0.01661	0.04298	0.00429	120	120	120	0	0	1	-360	360;
	510	447	0.01132	0.03777	0.00369	133	133	133	0	0	1	-360	360;
	509	493	0.01289	0.04116	0.00443	133	133	133	0	0	1	-360	360;
	533	509	0.04397	0.14529	0.01447	133	133	133	0	0	1	-360	360;
	510	491	0.02455	0.0743	0.00772	120	120	120	0	0	1	-360	360;
	594	417	0.02165	0.0724	0.00706	133	133	133	0	0	1	-360	360;
	669	338	0.04405	0.13372	0.01585	133	133	133	0	0	1	-360	360;
	434	471	0.01826	0.03157	0.00307	90	90	90	0	0	1	-360	360;
	588	319	0.0205	0.06694	0.00684	133	133	133	0	0	1	-360	360;
	749	272	0.03339	0.10124	0.01199	133	133	133	0	0	1	-360	360;
	514	504	0.00273	0.00818	0.00099	133	133	133	0	0	1	-360	360;
	259	254	0.00694	0.02256	0.00231	140	140	140	0	0	1	-360	360;
	274	460	0.05992	0.11628	0.01298	90	90	90	0	0	1	-360	360;
	274	245	0.10041	0.17736	0.01665	90	90	90	0	0	1	-360	360;
	317	260	0.00554	0.01802	0.00167	120	120	120	0	0	1	-360	360;
	339	274	0.05198	0.09	0.00889	69	69	69	0	0	1	-360	360;
	351	261	0.02893	0.08719	0.0105	140	140	140	0	0	1	-360	360;
	637	351	0.03033	0.09124	0.01099	140	140	140	0	0	1	-360	360;
	707	323	0.00635	0.01952	0.00235	140	140	140	0	0	1	-360	360;
	707	314	0.03736	0.06314	0.00687	107	107	107	0	0	1	-360	360;
	707	324	0.00026	0.0004	5e-05	140	140	140	0	0	1	-360	360;
	733	405	0.02694	0.0819	0.0097	140	140	140	0	0	1	-360	360;
	465	400	0.02	0.0338	0.00368	90	90	90	0	0	1	-360	360;
	273	363	0.02702	0.08215	0.00973	140	140	140	0	0	1	-360	360;
	470	312	0.04992	0.08967	0.00898	140	140	140	0	0	1	-360	360;
	587	313	0.00785	0.02388	0.00284	140	140	140	0	0	1	-360	360;
	583	246	0.01102	0.03212	0.00397	140	140	140	0	0	1	-360	360;
	724	260	0.01549	0.03483	0.00343	90	90	90	0	0	1	-360	360;
	293	724	0.02848	0.05104	0.00475	90	90	90	0	0	1	-360	360;
	607	724	0.0002	0.00067	7e-05	140	140	140	0	0	1	-360	360;
	508	294	0.0081	0.01413	0.00135	90	90	90	0	0	1	-360	360;
	297	247	0.07934	0.13074	0.01414	90	90	90	0	0	1	-360	360;
	352	404	0.00397	0.01215	0.00138	140	140	140	0	0	1	-360	360;
	314	311	0.02207	0.04273	0.00416	90	90	90	0	0	1	-360	360;
	562	508	0.03653	0.06372	0.00608	90	90	90	0	0	1	-360	360;
	261	254	0.00264	0.00851	0.00088	140	140	140	0	0	1	-360	360;
	732	696	0.0395	0.06909	0.00656	90	90	90	0	0	1	-360	360;
	696	376	0.03537	0.10331	0.00917	120	120	120	0	0	1	-360	360;
	584	540	0.01975	0.03736	0.00401	90	90	90	0	0	1	-360	360;
	695	313	0.03165	0.09537	0.01148	140	140	140	0	0	1	-360	360;
	502	464	0.04066	0.07066	0.00682	69	69	69	0	0	1	-360	360;
	587	246	0.0414	0.1257	0.01489	140	140	140	0	0	1	-360	360;
	480	438	0.0157	0.04736	0.0057	140	140	140	0	0	1	-360	360;
	364	261	0.02802	0.08446	0.01016	140	140	140	0	0	1	-360	360;
	258	257	0.00347	0.01033	0.00125	140	140	140	0	0	1	-360	360;
	328	318	0.02678	0.0805	0.0097	140	140	140	0	0	1	-360	360;
	567	245	0.0386	0.08364	0.00735	90	90	90	0	0	1	-360	360;
	261	256	0.01157	0.03587	0.00404	140	140	140	0	0	1	-360	360;
	341	318	0.01909	0.06198	0.00644	140	140	140	0	0	1	-360	360;
	470	341	0.06769	0.11901	0.01104	90	90	90	0	0	1	-360	360;
	556	340	0.06107	0.10165	0.01102	90	90	90	0	0	1	-360	360;
	405	400	0.00612	0.0124	0.00117	90	90	90	0	0	1	-360	360;
	628	328	0.05099	0.16893	0.0166	140	140	140	0	0	1	-360	360;
	502	363	0.03124	0.09496	0.01125	140	140	140	0	0	1	-360	360;
	696	291	0.02917	0.07438	0.00774	91	91	91	0	0	1	-360	360;
	317	258	0.00711	0.02256	0.00224	120	120	120	0	0	1	-360	360;
	563	297	0.0576	0.10058	0.0096	90	90	90	0	0	1	-360	360;
	438	364	0.02165	0.04008	0.00386	107	107	107	0	0	1	-360	360;
	322	695	0.01868	0.06198	0.00608	140	140	140	0	0	1	-360	360;
	323	480	0.02678	0.08058	0.0097	140	140	140	0	0	1	-360	360;
	340	540	0.0043	0.01388	0.00144	140	140	140	0	0	1	-360	360;
	423	254	0.03942	0.12033	0.01413	140	140	140	0	0	1	-360	360;
	608	254	0.00818	0.02545	0.00289	140	140	140	0	0	1	-360	360;
	391	339	0.04339	0.07157	0.00774	69	69	69	0	0	1	-360	360;
	391	423	0.01826	0.05537	0.00656	140	140	140	0	0	1	-360	360;
	628	322	0.03446	0.11364	0.01127	140	140	140	0	0	1	-360	360;
	290	696	0.02959	0.09727	0.00971	140	140	140	0	0	1	-360	360;
	459	376	0.02868	0.08818	0.00783	120	120	120	0	0	1	-360	360;
	459	260	0.02545	0.08099	0.00735	120	120	120	0	0	1	-360	360;
	257	459	0.01091	0.04223	0.00465	140	140	140	0	0	1	-360	360;
	255	460	0.01818	0.06595	0.00707	140	140	140	0	0	1	-360	360;
	460	256	0.01926	0.05876	0.00555	140	140	140	0	0	1	-360	360;
	314	273	0.02793	0.08496	0.01006	140	140	140	0	0	1	-360	360;
	637	352	0.02364	0.07149	0.00851	140	140	140	0	0	1	-360	360;
	255	259	0.00223	0.00752	0.00076	140	140	140	0	0	1	-360	360;
	584	582	0.02957	0.08621	0.01064	140	140	140	0	0	1	-360	360;
	719	308	0.00098	0.00423	0.02594	95	95	95	0	0	1	-360	360;
	719	357	0.01639	0.0344	0.02258	77	77	77	0	0	1	-360	360;
	719	334	0.00017	0.00074	0.00757	95	95	95	0	0	1	-360	360;
	358	487	0.01545	0.03008	0.00257	77	77	77	0	0	1	-360	360;
	271	309	0.00165	0.00744	0.10672	95	95	95	0	0	1	-360	360;
	739	357	0.00298	0.0105	0.06292	95	95	95	0	0	1	-360	360;
	774	1050	0.03628	0.09421	0.00974	117	117	117	0	0	1	-360	360;
	991	798	0.03041	0.09893	0.01014	137	137	137	0	0	1	-360	360;
	960	758	0.02678	0.08653	0.00885	120	120	120	0	0	1	-360	360;
	1046	775	0.02256	0.07289	0.00746	120	120	120	0	0	1	-360	360;
	914	766	0.08678	0.14975	0.01423	76	76	76	0	0	1	-360	360;
	981	922	0.07207	0.1381	0.01321	90	90	90	0	0	1	-360	360;
	931	923	0.05	0.10909	0.0107	90	90	90	0	0	1	-360	360;
	806	803	0.01124	0.02777	0.00276	90	90	90	0	0	1	-360	360;
	923	921	0.01636	0.05306	0.00542	137	137	137	0	0	1	-360	360;
	916	789	0.04116	0.13289	0.01359	137	137	137	0	0	1	-360	360;
	930	922	0.02306	0.07157	0.00818	168	168	168	0	0	1	-360	360;
	930	923	0.02306	0.07157	0.00818	168	168	168	0	0	1	-360	360;
	946	865	0.02017	0.06529	0.0067	137	137	137	0	0	1	-360	360;
	993	773	0.04893	0.12777	0.01321	120	120	120	0	0	1	-360	360;
	796	762	0.03198	0.10347	0.01058	69	69	69	0	0	1	-360	360;
	884	1026	0.03917	0.12669	0.01296	120	120	120	0	0	1	-360	360;
	990	796	0.03851	0.12463	0.01275	69	69	69	0	0	1	-360	360;
	1045	819	0.0614	0.1986	0.02032	137	137	137	0	0	1	-360	360;
	941	940	0.00372	0.00884	0.00067	120	120	120	0	0	1	-360	360;
	941	793	0.04843	0.08438	0.00809	91	91	91	0	0	1	-360	360;
	986	755	0.01207	0.03893	0.00402	120	120	120	0	0	1	-360	360;
	972	793	0.0376	0.06554	0.00624	109	109	109	0	0	1	-360	360;
	941	843	0.01075	0.0282	0.00291	109	109	109	0	0	1	-360	360;
	911	843	0.0127	0.03297	0.00341	109	109	109	0	0	1	-360	360;
	943	911	0.03485	0.07019	0.00683	109	109	109	0	0	1	-360	360;
	760	943	0.01421	0.04603	0.00471	137	137	137	0	0	1	-360	360;
	891	756	0.00562	0.00992	0.00092	76	76	76	0	0	1	-360	360;
	891	886	0.00446	0.00793	0.00075	76	76	76	0	0	1	-360	360;
	890	886	0.00256	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	1032	890	0.01306	0.02165	0.00208	109	109	109	0	0	1	-360	360;
	1032	755	0.01174	0.02025	0.00195	120	120	120	0	0	1	-360	360;
	779	755	0.02562	0.08281	0.00847	120	120	120	0	0	1	-360	360;
	779	776	0.02934	0.09479	0.0097	120	120	120	0	0	1	-360	360;
	984	882	0.01372	0.05686	0.00567	137	137	137	0	0	1	-360	360;
	986	984	0.00298	0.00959	0.00099	137	137	137	0	0	1	-360	360;
	986	758	0.01884	0.06099	0.00624	120	120	120	0	0	1	-360	360;
	1003	758	0.02512	0.08107	0.0083	120	120	120	0	0	1	-360	360;
	1003	763	0.00413	0.01322	0.00136	120	120	120	0	0	1	-360	360;
	883	868	0.02314	0.06628	0.00678	120	120	120	0	0	1	-360	360;
	868	763	0.00777	0.02512	0.00257	120	120	120	0	0	1	-360	360;
	916	763	0.00355	0.01157	0.0012	137	137	137	0	0	1	-360	360;
	877	882	0.01083	0.01917	0.0018	120	120	120	0	0	1	-360	360;
	892	877	0.00455	0.00802	0.00075	120	120	120	0	0	1	-360	360;
	876	875	0.00124	0.00397	0.00044	137	137	137	0	0	1	-360	360;
	888	875	0.00314	0.01025	0.00105	120	120	120	0	0	1	-360	360;
	883	871	0.03322	0.10752	0.011	120	120	120	0	0	1	-360	360;
	887	869	0.01364	0.04413	0.00452	120	120	120	0	0	1	-360	360;
	882	878	0.01339	0.02686	0.00257	109	109	109	0	0	1	-360	360;
	885	878	0.00463	0.01579	0.00161	120	120	120	0	0	1	-360	360;
	887	885	0.01264	0.04091	0.00418	120	120	120	0	0	1	-360	360;
	883	867	0.01967	0.06364	0.00651	120	120	120	0	0	1	-360	360;
	867	833	0.02826	0.0914	0.00934	120	120	120	0	0	1	-360	360;
	956	833	0.02182	0.07066	0.00723	120	120	120	0	0	1	-360	360;
	898	772	0.05835	0.09876	0.0106	109	109	109	0	0	1	-360	360;
	772	770	0.0057	0.0186	0.00189	120	120	120	0	0	1	-360	360;
	880	771	0.03322	0.10736	0.01099	120	120	120	0	0	1	-360	360;
	932	882	0.06372	0.20612	0.02108	120	120	120	0	0	1	-360	360;
	892	756	0.01372	0.04438	0.00454	120	120	120	0	0	1	-360	360;
	889	882	0.0038	0.0286	0.00273	183	183	183	0	0	1	-360	360;
	888	883	0.00231	0.02413	0.00373	183	183	183	0	0	1	-360	360;
	889	756	0.00413	0.03066	0.00293	137	137	137	0	0	1	-360	360;
	870	755	0.00397	0.01298	0.00133	120	120	120	0	0	1	-360	360;
	1027	770	0.03231	0.10438	0.01068	120	120	120	0	0	1	-360	360;
	1027	1026	0.04041	0.13058	0.01336	120	120	120	0	0	1	-360	360;
	870	756	0.00397	0.01281	0.00131	120	120	120	0	0	1	-360	360;
	871	869	0.01306	0.04207	0.00431	120	120	120	0	0	1	-360	360;
	918	775	0.03033	0.0981	0.01004	120	120	120	0	0	1	-360	360;
	1026	932	0.03793	0.12298	0.01258	120	120	120	0	0	1	-360	360;
	883	878	0.00959	0.03116	0.00318	137	137	137	0	0	1	-360	360;
	880	816	0.02636	0.08521	0.00871	120	120	120	0	0	1	-360	360;
	825	816	0.01917	0.06231	0.00637	120	120	120	0	0	1	-360	360;
	1027	825	0.03066	0.09909	0.01014	120	120	120	0	0	1	-360	360;
	816	771	0.03107	0.10041	0.01029	120	120	120	0	0	1	-360	360;
	941	829	0.01917	0.06198	0.00634	120	120	120	0	0	1	-360	360;
	760	756	0.02917	0.08074	0.00832	120	120	120	0	0	1	-360	360;
	942	943	0.00521	0.01694	0.00173	120	120	120	0	0	1	-360	360;
	918	942	0.01107	0.03579	0.00366	120	120	120	0	0	1	-360	360;
	804	882	0.02033	0.06562	0.00671	120	120	120	0	0	1	-360	360;
	774	940	0.00496	0.01339	0.00138	120	120	120	0	0	1	-360	360;
	876	892	0.00107	0.00802	0.00018	137	137	137	0	0	1	-360	360;
	835	775	0.00149	0.00446	0	137	137	137	0	0	1	-360	360;
	960	789	0.03116	0.05504	0.00515	90	90	90	0	0	1	-360	360;
	910	820	0.00512	0.0124	0.00123	69	69	69	0	0	1	-360	360;
	961	790	0.03215	0.05504	0.00515	76	76	76	0	0	1	-360	360;
	961	860	0.01901	0.05116	0.00528	120	120	120	0	0	1	-360	360;
	903	860	0.04579	0.12752	0.01314	120	120	120	0	0	1	-360	360;
	1014	902	0.02463	0.04488	0.00423	90	90	90	0	0	1	-360	360;
	1014	766	0.05818	0.10041	0.00954	90	90	90	0	0	1	-360	360;
	1047	902	0.01017	0.03298	0.00336	137	137	137	0	0	1	-360	360;
	1048	1041	0.00347	0.00901	0.00094	120	120	120	0	0	1	-360	360;
	1048	1047	0.00678	0.0219	0.00222	120	120	120	0	0	1	-360	360;
	1041	903	0.01496	0.04661	0.00475	76	76	76	0	0	1	-360	360;
	1042	1018	0.06347	0.1138	0.0107	90	90	90	0	0	1	-360	360;
	910	866	0.04455	0.14413	0.01475	69	69	69	0	0	1	-360	360;
	1045	903	0.06909	0.12273	0.01151	69	69	69	0	0	1	-360	360;
	789	1034	0.01738	0.03069	0.00288	69	69	69	0	0	1	-360	360;
	790	782	0.01669	0.02975	0.00279	90	90	90	0	0	1	-360	360;
	951	910	0.04463	0.07884	0.00738	69	69	69	0	0	1	-360	360;
	951	773	0.03843	0.10074	0.01041	120	120	120	0	0	1	-360	360;
	946	950	0.03769	0.1219	0.01247	137	137	137	0	0	1	-360	360;
	895	790	0.0557	0.0995	0.00934	76	76	76	0	0	1	-360	360;
	1029	895	0.04099	0.07364	0.00692	90	90	90	0	0	1	-360	360;
	790	784	0.00793	0.01893	0.00187	69	69	69	0	0	1	-360	360;
	789	787	0.00851	0.02785	0.00285	69	69	69	0	0	1	-360	360;
	792	787	0.00942	0.0305	0.00312	137	137	137	0	0	1	-360	360;
	792	784	0.00785	0.01835	0.0018	90	90	90	0	0	1	-360	360;
	1022	1017	0.02777	0.08975	0.00918	10	10	10	0	0	1	-360	360;
	820	826	0.01083	0.03789	0.00385	107	107	107	0	0	1	-360	360;
	826	991	0.02378	0.07688	0.00787	137	137	137	0	0	1	-360	360;
	767	766	0.00835	0.02702	0.00277	137	137	137	0	0	1	-360	360;
	1015	767	0.01843	0.0595	0.00608	137	137	137	0	0	1	-360	360;
	1029	884	0.02066	0.06686	0.00684	137	137	137	0	0	1	-360	360;
	809	1041	0.04876	0.15769	0.01613	76	76	76	0	0	1	-360	360;
	808	809	0.0105	0.03306	0.00338	120	120	120	0	0	1	-360	360;
	944	808	0.02661	0.08603	0.0088	120	120	120	0	0	1	-360	360;
	1021	944	0.01752	0.05678	0.00581	137	137	137	0	0	1	-360	360;
	1042	1021	0.03752	0.1214	0.01242	120	120	120	0	0	1	-360	360;
	1037	1042	0.04169	0.07362	0.0069	26	26	26	0	0	1	-360	360;
	827	1037	0.027	0.04768	0.00446	10	10	10	0	0	1	-360	360;
	949	950	0.0238	0.0538	0.0055	90	90	90	0	0	1	-360	360;
	945	949	0.01802	0.03182	0.00298	90	90	90	0	0	1	-360	360;
	952	945	0.00165	0.00537	0.00055	90	90	90	0	0	1	-360	360;
	951	952	0.01083	0.01917	0.0018	76	76	76	0	0	1	-360	360;
	899	950	0.01678	0.02959	0.00277	34	34	34	0	0	1	-360	360;
	899	951	0.01455	0.0257	0.00241	34	34	34	0	0	1	-360	360;
	1017	866	0.08306	0.14868	0.01396	90	90	90	0	0	1	-360	360;
	1018	1017	0.01413	0.02694	0.00257	90	90	90	0	0	1	-360	360;
	991	1015	0.02638	0.08531	0.00873	137	137	137	0	0	1	-360	360;
	782	1034	0.00021	0.00038	4e-05	69	69	69	0	0	1	-360	360;
	781	1034	0.01843	0.03331	0.00326	69	69	69	0	0	1	-360	360;
	1035	781	0.00026	0.00045	4e-05	69	69	69	0	0	1	-360	360;
	1035	782	0.0001	0.00017	2e-05	69	69	69	0	0	1	-360	360;
	1035	783	0.00148	0.00262	0.00024	69	69	69	0	0	1	-360	360;
	844	1037	3e-05	0.0001	1e-05	16	16	16	0	0	1	-360	360;
	815	761	0.03124	0.10107	0.01034	168	168	168	0	0	1	-360	360;
	992	874	0.03488	0.11281	0.01154	168	168	168	0	0	1	-360	360;
	874	872	0.00207	0.00661	0.00068	168	168	168	0	0	1	-360	360;
	982	872	0.01992	0.03711	0.00351	168	168	168	0	0	1	-360	360;
	1009	971	0.01719	0.0557	0.0057	168	168	168	0	0	1	-360	360;
	1008	914	0.01207	0.02074	0.00198	109	109	109	0	0	1	-360	360;
	981	1039	0.02938	0.06012	0.00579	109	109	109	0	0	1	-360	360;
	1008	1039	0.02938	0.06012	0.00579	109	109	109	0	0	1	-360	360;
	1013	1039	0.00133	0.00431	0.00044	109	109	109	0	0	1	-360	360;
	1009	805	0.04521	0.07926	0.0064	109	109	109	0	0	1	-360	360;
	805	799	0.01306	0.02455	0.00198	109	109	109	0	0	1	-360	360;
	931	799	0.04455	0.08926	0.00679	109	109	109	0	0	1	-360	360;
	798	971	0.02207	0.07124	0.00729	168	168	168	0	0	1	-360	360;
	894	893	0.00876	0.01455	0.00152	109	109	109	0	0	1	-360	360;
	1012	1008	0.01248	0.03438	0.00347	109	109	109	0	0	1	-360	360;
	919	828	0.0162	0.05223	0.00535	168	168	168	0	0	1	-360	360;
	828	785	0.01595	0.03174	0.00302	109	109	109	0	0	1	-360	360;
	894	785	0.01083	0.01909	0.00166	109	109	109	0	0	1	-360	360;
	894	786	0.01124	0.01975	0.00173	109	109	109	0	0	1	-360	360;
	976	973	0.02264	0.07314	0.00748	168	168	168	0	0	1	-360	360;
	1009	762	0.1362	0.23512	0.02235	109	109	109	0	0	1	-360	360;
	975	762	0.00612	0.01992	0.00204	168	168	168	0	0	1	-360	360;
	980	762	0.00463	0.01479	0.0016	168	168	168	0	0	1	-360	360;
	980	974	0.00744	0.02405	0.00247	168	168	168	0	0	1	-360	360;
	974	964	0.00322	0.0105	0.00109	168	168	168	0	0	1	-360	360;
	1040	976	0.02108	0.06817	0.00697	168	168	168	0	0	1	-360	360;
	977	831	0.00967	0.03149	0.00322	168	168	168	0	0	1	-360	360;
	912	831	0.04545	0.08091	0.00757	109	109	109	0	0	1	-360	360;
	912	786	0.02628	0.04694	0.0044	109	109	109	0	0	1	-360	360;
	948	894	0.01091	0.01926	0.0018	109	109	109	0	0	1	-360	360;
	934	806	0.03521	0.07645	0.00743	168	168	168	0	0	1	-360	360;
	999	935	0.0224	0.0724	0.00741	168	168	168	0	0	1	-360	360;
	935	904	0.02132	0.06595	0.00671	168	168	168	0	0	1	-360	360;
	904	786	0.07694	0.13256	0.01263	109	109	109	0	0	1	-360	360;
	988	762	0.03182	0.07959	0.00806	144	144	144	0	0	1	-360	360;
	988	965	0.00917	0.02289	0.00232	144	144	144	0	0	1	-360	360;
	1010	761	0.02355	0.07562	0.00782	168	168	168	0	0	1	-360	360;
	1010	855	0.02223	0.0714	0.00738	168	168	168	0	0	1	-360	360;
	852	759	0.02207	0.05917	0.00611	144	144	144	0	0	1	-360	360;
	989	759	0.02537	0.06736	0.00695	144	144	144	0	0	1	-360	360;
	873	989	0.01405	0.03645	0.00377	168	168	168	0	0	1	-360	360;
	854	807	0.02074	0.06702	0.00686	168	168	168	0	0	1	-360	360;
	801	807	0.00967	0.0262	0.00263	109	109	109	0	0	1	-360	360;
	913	801	0.0062	0.02	0.00204	109	109	109	0	0	1	-360	360;
	1016	785	0.01579	0.05107	0.00523	168	168	168	0	0	1	-360	360;
	979	959	0.00174	0.00562	0.00058	168	168	168	0	0	1	-360	360;
	1023	994	0.02058	0.03628	0.00339	168	168	168	0	0	1	-360	360;
	1043	1023	0.02802	0.0905	0.00924	109	109	109	0	0	1	-360	360;
	1043	989	0.00868	0.01537	0.00143	109	109	109	0	0	1	-360	360;
	977	761	0.03306	0.10686	0.01094	168	168	168	0	0	1	-360	360;
	1009	819	0.03298	0.10669	0.01091	168	168	168	0	0	1	-360	360;
	919	1012	0.02066	0.06678	0.00683	109	109	109	0	0	1	-360	360;
	1016	814	0.01479	0.04769	0.00488	168	168	168	0	0	1	-360	360;
	1019	814	0.00744	0.01314	0.00123	109	109	109	0	0	1	-360	360;
	1019	805	0.00826	0.01463	0.00137	109	109	109	0	0	1	-360	360;
	1005	989	0.00256	0.00818	0.00083	168	168	168	0	0	1	-360	360;
	893	786	0.00529	0.01686	0.00173	168	168	168	0	0	1	-360	360;
	977	865	0.03893	0.12595	0.01288	168	168	168	0	0	1	-360	360;
	925	948	0.02157	0.04744	0.00462	109	109	109	0	0	1	-360	360;
	925	934	0.02967	0.06636	0.00649	109	109	109	0	0	1	-360	360;
	865	815	0.00983	0.03182	0.00325	168	168	168	0	0	1	-360	360;
	977	959	0.02438	0.07802	0.00807	168	168	168	0	0	1	-360	360;
	964	959	0.01777	0.05736	0.00587	168	168	168	0	0	1	-360	360;
	999	806	0.00818	0.02645	0.00271	168	168	168	0	0	1	-360	360;
	852	780	0.0124	0.05413	0.00675	168	168	168	0	0	1	-360	360;
	1005	990	0.00636	0.02058	0.0021	168	168	168	0	0	1	-360	360;
	780	759	0.01793	0.05802	0.00593	168	168	168	0	0	1	-360	360;
	850	854	0.00149	0.00264	0.00025	109	109	109	0	0	1	-360	360;
	853	850	0.00058	0.0019	0.00019	168	168	168	0	0	1	-360	360;
	1046	1009	0.02868	0.09281	0.00949	109	109	109	0	0	1	-360	360;
	757	931	0.0157	0.05074	0.00519	168	168	168	0	0	1	-360	360;
	842	925	0.02132	0.06893	0.00705	168	168	168	0	0	1	-360	360;
	998	975	0.00818	0.02653	0.00271	168	168	168	0	0	1	-360	360;
	857	853	0.01149	0.02967	0.00301	109	109	109	0	0	1	-360	360;
	802	913	0.0062	0.02	0.00204	168	168	168	0	0	1	-360	360;
	921	842	0.0181	0.05851	0.00599	168	168	168	0	0	1	-360	360;
	851	857	0.0057	0.01603	0.00165	144	144	144	0	0	1	-360	360;
	993	873	0.01917	0.04983	0.00516	168	168	168	0	0	1	-360	360;
	992	976	0.02306	0.07463	0.00764	168	168	168	0	0	1	-360	360;
	982	798	0.00016	0.0005	5e-05	168	168	168	0	0	1	-360	360;
	765	913	0.03025	0.05931	0.00567	109	109	109	0	0	1	-360	360;
	851	817	0.01359	0.04394	0.0045	168	168	168	0	0	1	-360	360;
	1008	810	0.00107	0.00626	0.00059	120	120	120	0	0	1	-360	360;
	812	1036	0.00223	0.00678	0	120	120	120	0	0	1	-360	360;
	811	1036	0.00207	0.00612	0	120	120	120	0	0	1	-360	360;
	1009	811	0.00174	0.00564	0.00058	120	120	120	0	0	1	-360	360;
	907	934	0.04561	0.13862	0.01402	109	109	109	0	0	1	-360	360;
	904	908	0.01031	0.02002	0.00191	109	109	109	0	0	1	-360	360;
	907	908	0.00349	0.01126	0.00115	168	168	168	0	0	1	-360	360;
	823	854	0.00876	0.02636	0	137	137	137	0	0	1	-360	360;
	998	973	0.00372	0.0119	0.00121	168	168	168	0	0	1	-360	360;
	856	853	0.00033	0.00116	0	137	137	137	0	0	1	-360	360;
	963	913	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	881	865	0.00041	0.00126	0	137	137	137	0	0	1	-360	360;
	813	810	0.00099	0.00298	0	137	137	137	0	0	1	-360	360;
	979	1040	0.0064	0.02069	0.00212	168	168	168	0	0	1	-360	360;
	1050	966	0.0519	0.1314	0.01312	117	117	117	0	0	1	-360	360;
	969	967	0.01521	0.02562	0.00245	90	90	90	0	0	1	-360	360;
	969	968	0.00851	0.01438	0.00155	90	90	90	0	0	1	-360	360;
	968	939	0.02702	0.0876	0.009	137	137	137	0	0	1	-360	360;
	938	864	0.01851	0.06	0.00614	137	137	137	0	0	1	-360	360;
	864	847	0.01372	0.04446	0.00454	137	137	137	0	0	1	-360	360;
	966	957	0.02289	0.0519	0.00506	90	90	90	0	0	1	-360	360;
	970	957	0.02521	0.05744	0.00561	90	90	90	0	0	1	-360	360;
	970	962	0.00579	0.00992	0.00105	137	137	137	0	0	1	-360	360;
	824	794	0.01777	0.05736	0.00587	137	137	137	0	0	1	-360	360;
	847	794	0.02058	0.06612	0.00686	137	137	137	0	0	1	-360	360;
	966	788	0.00901	0.03107	0.00298	137	137	137	0	0	1	-360	360;
	947	788	0.02397	0.08322	0.00799	137	137	137	0	0	1	-360	360;
	958	947	0.02322	0.07521	0.0077	137	137	137	0	0	1	-360	360;
	1033	985	0.00884	0.01488	0.0015	90	90	90	0	0	1	-360	360;
	1000	966	0.05331	0.13339	0.01064	117	117	117	0	0	1	-360	360;
	967	818	0.04066	0.11116	0.01147	117	117	117	0	0	1	-360	360;
	1007	818	0.02777	0.07769	0.00801	117	117	117	0	0	1	-360	360;
	1007	1001	0.00289	0.00777	0.0008	117	117	117	0	0	1	-360	360;
	768	1001	0.04	0.06182	0.00676	90	90	90	0	0	1	-360	360;
	996	769	0.03826	0.06562	0.01263	90	90	90	0	0	1	-360	360;
	996	858	0.02893	0.04975	0.00953	90	90	90	0	0	1	-360	360;
	859	858	0.00413	0.00711	0.00137	90	90	90	0	0	1	-360	360;
	1001	922	0.06909	0.1238	0.01008	90	90	90	0	0	1	-360	360;
	1000	845	0.03992	0.06793	0.00543	90	90	90	0	0	1	-360	360;
	929	845	0.01281	0.02182	0.00175	90	90	90	0	0	1	-360	360;
	929	923	0.01322	0.0343	0.00329	90	90	90	0	0	1	-360	360;
	922	879	0.03132	0.1014	0.01038	137	137	137	0	0	1	-360	360;
	927	926	0.00033	0.00058	0.0242	274	274	274	0	0	1	-360	360;
	794	764	0.01628	0.05273	0.00541	137	137	137	0	0	1	-360	360;
	1024	846	0.03471	0.11256	0.01158	137	137	137	0	0	1	-360	360;
	1024	901	0.01512	0.05132	0.00251	137	137	137	0	0	1	-360	360;
	901	800	0.0295	0.05182	0.00488	137	137	137	0	0	1	-360	360;
	1011	768	0.01025	0.0181	0.0017	90	90	90	0	0	1	-360	360;
	1030	1011	0.03124	0.05512	0.00516	90	90	90	0	0	1	-360	360;
	1030	849	0.02446	0.04322	0.00405	90	90	90	0	0	1	-360	360;
	906	849	0.05736	0.10083	0.00949	90	90	90	0	0	1	-360	360;
	920	905	0.01364	0.07041	0.00728	137	137	137	0	0	1	-360	360;
	834	849	0.00306	0.00983	0.00101	137	137	137	0	0	1	-360	360;
	838	837	0.00446	0.01455	0.00148	137	137	137	0	0	1	-360	360;
	954	837	0.01405	0.04537	0.00465	137	137	137	0	0	1	-360	360;
	839	849	0.0076	0.02455	0.00252	137	137	137	0	0	1	-360	360;
	863	839	0.00446	0.01388	0.00143	137	137	137	0	0	1	-360	360;
	848	863	0.0057	0.01851	0.00189	137	137	137	0	0	1	-360	360;
	954	905	0.02198	0.06843	0.00702	137	137	137	0	0	1	-360	360;
	1028	955	0.0162	0.02843	0.00269	90	90	90	0	0	1	-360	360;
	1028	822	0.03917	0.06603	0.00396	90	90	90	0	0	1	-360	360;
	821	822	0.00959	0.02017	0.00196	90	90	90	0	0	1	-360	360;
	955	909	0.00967	0.03157	0.00322	137	137	137	0	0	1	-360	360;
	909	791	0.04777	0.09058	0.00862	90	90	90	0	0	1	-360	360;
	983	791	0.02273	0.04661	0.0045	90	90	90	0	0	1	-360	360;
	983	777	0.02463	0.05959	0.00496	90	90	90	0	0	1	-360	360;
	778	777	0.0057	0.01851	0.00189	90	90	90	0	0	1	-360	360;
	1050	879	0.04719	0.08521	0.00803	90	90	90	0	0	1	-360	360;
	957	953	0.00777	0.01686	0.00165	90	90	90	0	0	1	-360	360;
	978	967	0.01686	0.02983	0.00281	90	90	90	0	0	1	-360	360;
	978	953	0.00355	0.00628	0.00542	90	90	90	0	0	1	-360	360;
	1049	768	0.00587	0.01033	0.00097	90	90	90	0	0	1	-360	360;
	1049	995	0.0038	0.0124	0.00127	137	137	137	0	0	1	-360	360;
	995	933	0.00405	0.01298	0.00133	137	137	137	0	0	1	-360	360;
	958	795	0.00355	0.01157	0.00119	137	137	137	0	0	1	-360	360;
	1006	778	0.01777	0.0576	0.00589	90	90	90	0	0	1	-360	360;
	803	1006	0.01777	0.0576	0.00589	90	90	90	0	0	1	-360	360;
	937	777	0.02174	0.03835	0.00359	90	90	90	0	0	1	-360	360;
	937	1038	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360;
	1038	862	0.01719	0.05562	0.00568	137	137	137	0	0	1	-360	360;
	900	764	0.02074	0.06727	0.00688	137	137	137	0	0	1	-360	360;
	861	859	0.00157	0.00306	0.00029	90	90	90	0	0	1	-360	360;
	985	967	0.03826	0.06752	0.00633	90	90	90	0	0	1	-360	360;
	1000	917	0.02488	0.07223	0.00824	137	137	137	0	0	1	-360	360;
	937	841	0.01521	0.04901	0.00502	137	137	137	0	0	1	-360	360;
	1033	997	0.00041	0.0119	0.00122	137	137	137	0	0	1	-360	360;
	933	997	0.00281	0.00901	0.00092	137	137	137	0	0	1	-360	360;
	955	830	0.02289	0.07413	0.00758	137	137	137	0	0	1	-360	360;
	938	939	0.01934	0.06264	0.00641	137	137	137	0	0	1	-360	360;
	838	834	0.00455	0.01471	0.0015	137	137	137	0	0	1	-360	360;
	821	987	0.03488	0.06488	0.00614	90	90	90	0	0	1	-360	360;
	962	824	0.02099	0.06785	0.00694	137	137	137	0	0	1	-360	360;
	830	848	0.01083	0.03512	0.00359	137	137	137	0	0	1	-360	360;
	797	1038	0.01917	0.05959	0.0061	137	137	137	0	0	1	-360	360;
	1007	936	0.004	0.01038	0.00107	117	117	117	0	0	1	-360	360;
	840	849	0.0023	0.00744	0.00076	137	137	137	0	0	1	-360	360;
	836	840	0.00144	0.00464	0.00047	137	137	137	0	0	1	-360	360;
	849	836	0.00184	0.00597	0.00061	137	137	137	0	0	1	-360	360;
	924	922	0.01074	0.03473	0.00355	137	137	137	0	0	1	-360	360;
	928	924	0.00223	0.00722	0.00074	137	137	137	0	0	1	-360	360;
	922	928	0.00328	0.0106	0.00108	137	137	137	0	0	1	-360	360;
	1025	966	0.0124	0.03603	0	137	137	137	0	0	1	-360	360;
	1044	1000	0.01818	0.05463	0	137	137	137	0	0	1	-360	360;
	1004	1000	0.00331	0.00992	0	137	137	137	0	0	1	-360	360;
	1002	1000	0.00058	0.00165	0	137	137	137	0	0	1	-360	360;
	896	905	0.00661	0.0181	0	137	137	137	0	0	1	-360	360;
	896	905	0.00661	0.01835	0	137	137	137	0	0	1	-360	360;
	915	954	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	915	954	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	1020	954	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	1020	954	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	832	846	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	2084	1498	0.02628	0.08298	0.00905	114	114	114	0	0	1	-360	360;
	1497	1498	0.00298	0.00967	0.001	114	114	114	0	0	1	-360	360;
	1197	1718	0.03612	0.05041	0.00829	57	57	57	0	0	1	-360	360;
	1196	1197	0	8e-05	1e-05	29	29	29	0	0	1	-360	360;
	1230	1199	0.0162	0.04917	0.00584	114	114	114	0	0	1	-360	360;
	1229	1230	0.00017	0.00025	4e-05	77	77	77	0	0	1	-360	360;
	1234	1587	0.01653	0.05041	0.00589	114	114	114	0	0	1	-360	360;
	1233	1234	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1363	1111	0.03868	0.10116	0.0108	99	99	99	0	0	1	-360	360;
	1828	1575	0.00537	0.01736	0.00181	114	114	114	0	0	1	-360	360;
	1112	1828	0.03909	0.09719	0.01033	99	99	99	0	0	1	-360	360;
	1827	1828	8e-05	0.00017	2e-05	97	97	97	0	0	1	-360	360;
	1554	1470	0.01595	0.04132	0.00403	99	99	99	0	0	1	-360	360;
	1943	1554	0.03174	0.08347	0.00816	99	99	99	0	0	1	-360	360;
	1552	1554	0.0005	0.00107	0.00014	29	29	29	0	0	1	-360	360;
	1555	1469	0.01595	0.0414	0.00404	99	99	99	0	0	1	-360	360;
	1944	1555	0.03174	0.08347	0.00816	99	99	99	0	0	1	-360	360;
	1553	1555	0.0005	0.00116	0.00014	29	29	29	0	0	1	-360	360;
	2110	1858	0.04826	0.12198	0.0129	99	99	99	0	0	1	-360	360;
	1857	1526	0.04017	0.10537	0.01188	99	99	99	0	0	1	-360	360;
	1227	1095	0.01165	0.03653	0.00401	114	114	114	0	0	1	-360	360;
	1226	1094	0.01165	0.03653	0.00401	114	114	114	0	0	1	-360	360;
	1438	1860	0.00273	0.00876	0.0009	114	114	114	0	0	1	-360	360;
	1578	1438	0.0076	0.02355	0.00263	114	114	114	0	0	1	-360	360;
	1437	1438	0.00033	0.00041	9e-05	77	77	77	0	0	1	-360	360;
	1109	1641	0.01818	0.04521	0.0048	102	102	102	0	0	1	-360	360;
	2085	1109	0.02603	0.06471	0.00687	102	102	102	0	0	1	-360	360;
	1489	1642	0.01736	0.04893	0.00504	102	102	102	0	0	1	-360	360;
	1784	1427	0.00686	0.02215	0.00232	114	114	114	0	0	1	-360	360;
	1269	1784	0.0043	0.01347	0.00147	114	114	114	0	0	1	-360	360;
	1578	1269	0.00579	0.01785	0.00204	114	114	114	0	0	1	-360	360;
	1783	1784	0.00603	0.01744	0.0023	114	114	114	0	0	1	-360	360;
	1269	1268	0.00231	0.00273	0.00058	77	77	77	0	0	1	-360	360;
	1937	1188	0.00504	0.01562	0.00173	114	114	114	0	0	1	-360	360;
	1580	1937	0.01025	0.03198	0.00354	114	114	114	0	0	1	-360	360;
	1937	1935	0.00521	0.00884	0.00089	72	72	72	0	0	1	-360	360;
	1938	1189	0.00504	0.01562	0.00173	114	114	114	0	0	1	-360	360;
	1580	1938	0.01025	0.03198	0.00354	114	114	114	0	0	1	-360	360;
	1938	1936	0.00521	0.00884	0.00089	72	72	72	0	0	1	-360	360;
	2110	1591	0.04017	0.06455	0.0076	77	77	77	0	0	1	-360	360;
	1902	1532	0.02256	0.05818	0.00621	102	102	102	0	0	1	-360	360;
	1901	2077	0.01876	0.04876	0.00519	102	102	102	0	0	1	-360	360;
	1546	1401	0.01463	0.04661	0.00496	114	114	114	0	0	1	-360	360;
	1818	1546	0.00628	0.02	0.00213	114	114	114	0	0	1	-360	360;
	1546	1544	0.00438	0.0086	0.00086	72	72	72	0	0	1	-360	360;
	1547	1142	0.00628	0.01983	0.00216	114	114	114	0	0	1	-360	360;
	1992	1547	0.00504	0.01537	0.00179	114	114	114	0	0	1	-360	360;
	1547	1545	0.00438	0.0086	0.00086	72	72	72	0	0	1	-360	360;
	1580	1051	0.01248	0.04595	0.00524	114	114	114	0	0	1	-360	360;
	1579	1052	0.01289	0.04669	0.00515	114	114	114	0	0	1	-360	360;
	1650	1220	0.00223	0.00826	0.00099	114	114	114	0	0	1	-360	360;
	1205	1221	0.00413	0.01587	0.00183	114	114	114	0	0	1	-360	360;
	1580	1205	0.00488	0.01678	0.00193	114	114	114	0	0	1	-360	360;
	1205	1204	0.00124	0.00421	0.00059	114	114	114	0	0	1	-360	360;
	1626	1454	0.00554	0.01702	0.00195	114	114	114	0	0	1	-360	360;
	1690	1564	0.04157	0.0581	0.01085	57	57	57	0	0	1	-360	360;
	1720	2005	0.00397	0.01124	0.00151	114	114	114	0	0	1	-360	360;
	1895	2089	0.01587	0.04496	0.00605	114	114	114	0	0	1	-360	360;
	1223	1895	0.02157	0.06124	0.00825	114	114	114	0	0	1	-360	360;
	1894	1895	0.0024	0.00686	0.00091	114	114	114	0	0	1	-360	360;
	1667	1997	0.0024	0.00744	0.00084	114	114	114	0	0	1	-360	360;
	1616	1518	0.0105	0.02983	0.00402	114	114	114	0	0	1	-360	360;
	1444	1677	0.02496	0.03802	0.00491	78	78	78	0	0	1	-360	360;
	1283	1203	0.01083	0.02364	0.00345	97	97	97	0	0	1	-360	360;
	1972	1728	0.00835	0.02339	0.0032	97	97	97	0	0	1	-360	360;
	1336	1659	0.02826	0.0924	0.00933	114	114	114	0	0	1	-360	360;
	1723	1659	0.03488	0.0881	0.01298	114	114	114	0	0	1	-360	360;
	1816	1538	0.00818	0.01364	0.00324	97	97	97	0	0	1	-360	360;
	1977	1175	0.02099	0.05934	0.00803	75	75	75	0	0	1	-360	360;
	1976	1559	0.03826	0.04818	0.00455	57	57	57	0	0	1	-360	360;
	1563	1470	0.02926	0.0514	0.00489	77	77	77	0	0	1	-360	360;
	2111	1217	0.01959	0.04818	0.00609	77	77	77	0	0	1	-360	360;
	1710	1492	0.02182	0.06149	0.00827	77	77	77	0	0	1	-360	360;
	1792	1492	0.03628	0.06727	0.00769	57	57	57	0	0	1	-360	360;
	2029	1227	0.01992	0.06157	0.00695	114	114	114	0	0	1	-360	360;
	1432	1226	0.00777	0.02397	0.00275	119	119	119	0	0	1	-360	360;
	1059	2030	0.0476	0.05091	0.00542	52	52	52	0	0	1	-360	360;
	1226	1916	0.05256	0.13264	0.01406	102	102	102	0	0	1	-360	360;
	2108	1153	0.03264	0.08	0.00928	102	102	102	0	0	1	-360	360;
	1089	1436	0.02372	0.03132	0.00624	90	90	90	0	0	1	-360	360;
	1396	1940	0.00835	0.02669	0.0028	119	119	119	0	0	1	-360	360;
	1228	1396	0.01992	0.06488	0.00659	114	114	114	0	0	1	-360	360;
	1395	1396	0.00099	0.00298	0.00039	114	114	114	0	0	1	-360	360;
	1916	1445	0.01355	0.03835	0.00516	114	114	114	0	0	1	-360	360;
	1429	1183	0.00537	0.01686	0.00187	114	114	114	0	0	1	-360	360;
	1714	1873	0.02025	0.06612	0.00668	114	114	114	0	0	1	-360	360;
	1964	2031	0.03727	0.12074	0.01246	114	114	114	0	0	1	-360	360;
	1965	1173	0.01876	0.05926	0.00642	114	114	114	0	0	1	-360	360;
	1778	1617	0.01587	0.05182	0.00527	114	114	114	0	0	1	-360	360;
	1430	1094	0.00678	0.02132	0.00234	114	114	114	0	0	1	-360	360;
	1422	1095	0.01529	0.04917	0.00517	114	114	114	0	0	1	-360	360;
	2090	1094	0.00686	0.02207	0.00229	114	114	114	0	0	1	-360	360;
	2091	1095	0.00686	0.02215	0.0023	114	114	114	0	0	1	-360	360;
	1975	2015	0.05306	0.2314	0.02446	114	114	114	0	0	1	-360	360;
	1293	2014	0.04909	0.21488	0.02272	114	114	114	0	0	1	-360	360;
	1768	1656	0.03438	0.11107	0.01156	114	114	114	0	0	1	-360	360;
	1342	1318	0.0005	0.00091	8e-05	78	78	78	0	0	1	-360	360;
	1346	1342	0.00413	0.00669	0.00073	78	78	78	0	0	1	-360	360;
	2084	1346	0.00413	0.00711	0.0007	78	78	78	0	0	1	-360	360;
	1340	1342	0.00116	0.00207	0.0002	57	57	57	0	0	1	-360	360;
	1344	1346	8e-05	0.00025	3e-05	119	119	119	0	0	1	-360	360;
	1198	1066	0.01736	0.04694	0.00667	102	102	102	0	0	1	-360	360;
	1485	1488	0.00661	0.01504	0.00192	76	76	76	0	0	1	-360	360;
	1592	1352	0.02661	0.03248	0.00676	78	78	78	0	0	1	-360	360;
	2084	1425	0.03165	0.05521	0.01258	102	102	102	0	0	1	-360	360;
	2085	1351	0.04545	0.05331	0.01145	78	78	78	0	0	1	-360	360;
	1465	1065	0.00298	0.00909	0.00104	114	114	114	0	0	1	-360	360;
	1736	1485	0.01347	0.04388	0.00447	114	114	114	0	0	1	-360	360;
	1114	1455	0.00818	0.02537	0.00287	114	114	114	0	0	1	-360	360;
	1504	1426	0.02041	0.03645	0.00807	102	102	102	0	0	1	-360	360;
	1838	1347	8e-05	0.00083	1e-05	78	78	78	0	0	1	-360	360;
	2085	1838	0.00653	0.01116	0.0011	78	78	78	0	0	1	-360	360;
	1838	1837	0.00017	0.00025	3e-05	78	78	78	0	0	1	-360	360;
	1345	1348	0.00256	0.00438	0.00044	78	78	78	0	0	1	-360	360;
	2084	1345	0.00405	0.00694	0.00069	77	77	77	0	0	1	-360	360;
	1343	1345	0.00074	0.00223	0.00029	76	76	76	0	0	1	-360	360;
	1341	1066	0.01091	0.02066	0.00319	78	78	78	0	0	1	-360	360;
	1317	1341	0.00041	0.00074	7e-05	78	78	78	0	0	1	-360	360;
	1339	1341	0.00124	0.00207	0.00021	57	57	57	0	0	1	-360	360;
	2143	1065	0.00455	0.00802	0.00081	78	78	78	0	0	1	-360	360;
	2144	1066	0.00455	0.00802	0.00081	78	78	78	0	0	1	-360	360;
	1904	1065	0.00413	0.01058	0.0018	114	114	114	0	0	1	-360	360;
	1455	1966	0.00678	0.01149	0.00116	29	29	29	0	0	1	-360	360;
	1456	1967	0.00678	0.01149	0.00116	57	57	57	0	0	1	-360	360;
	1801	1645	0.03702	0.0595	0.00702	78	78	78	0	0	1	-360	360;
	1777	1646	0.01488	0.02661	0.00302	78	78	78	0	0	1	-360	360;
	2142	1519	0.01909	0.05413	0.00729	114	114	114	0	0	1	-360	360;
	2084	1350	0.00702	0.01529	0.0018	78	78	78	0	0	1	-360	360;
	1349	1065	0.01083	0.03074	0.00411	114	114	114	0	0	1	-360	360;
	1851	1066	0.0086	0.02438	0.00328	114	114	114	0	0	1	-360	360;
	1915	1503	0.02835	0.05174	0.01048	102	102	102	0	0	1	-360	360;
	2141	1915	0.0086	0.02438	0.00328	114	114	114	0	0	1	-360	360;
	1914	1897	0.0157	0.04471	0.00602	114	114	114	0	0	1	-360	360;
	1946	1711	0.01479	0.02455	0.00298	57	57	57	0	0	1	-360	360;
	2101	1486	0.00388	0.00653	0.00153	102	102	102	0	0	1	-360	360;
	1591	1536	0.0119	0.03397	0.00451	114	114	114	0	0	1	-360	360;
	1537	1108	0.00884	0.02504	0.00337	114	114	114	0	0	1	-360	360;
	1945	1216	0.02678	0.05975	0.00764	57	57	57	0	0	1	-360	360;
	1791	1735	0.03198	0.10364	0.01064	114	114	114	0	0	1	-360	360;
	1486	1433	0.03612	0.1176	0.01195	114	114	114	0	0	1	-360	360;
	2084	1864	0.02388	0.07802	0.00788	114	114	114	0	0	1	-360	360;
	2100	1466	0.02289	0.03901	0.00908	102	102	102	0	0	1	-360	360;
	1164	1456	0	8e-05	1e-05	102	102	102	0	0	1	-360	360;
	2084	1164	0.01083	0.03132	0.00333	102	102	102	0	0	1	-360	360;
	1163	1164	0.0095	0.03116	0.00315	114	114	114	0	0	1	-360	360;
	2084	1113	0.0043	0.01322	0.00152	114	114	114	0	0	1	-360	360;
	1490	2085	0.04058	0.10669	0.01117	102	102	102	0	0	1	-360	360;
	2085	1802	0.01752	0.03033	0.00327	78	78	78	0	0	1	-360	360;
	1867	1852	0.00314	0.00884	0.00119	114	114	114	0	0	1	-360	360;
	1865	1867	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1866	1867	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1456	1903	0.00554	0.01339	0.00257	114	114	114	0	0	1	-360	360;
	1676	1777	0.00215	0.00603	0.00063	78	78	78	0	0	1	-360	360;
	1487	1455	0.0181	0.0419	0.00515	102	102	102	0	0	1	-360	360;
	1170	1065	0.00545	0.01785	0.0018	114	114	114	0	0	1	-360	360;
	1171	1066	0.00545	0.01785	0.0018	114	114	114	0	0	1	-360	360;
	1471	1147	0.01901	0.06017	0.00654	114	114	114	0	0	1	-360	360;
	2124	1146	0.00504	0.01438	0.00192	114	114	114	0	0	1	-360	360;
	1472	1062	0.01421	0.02306	0.00276	90	90	90	0	0	1	-360	360;
	1148	1921	0.02157	0.06926	0.00705	114	114	114	0	0	1	-360	360;
	1510	1442	0.01545	0.05058	0.00511	114	114	114	0	0	1	-360	360;
	2045	1510	0.01223	0.02818	0.00432	114	114	114	0	0	1	-360	360;
	1260	1149	0.00231	0.00653	0.00069	114	114	114	0	0	1	-360	360;
	1890	1237	0.02529	0.04041	0.00662	90	90	90	0	0	1	-360	360;
	2093	1655	0.00149	0.00488	0.0005	114	114	114	0	0	1	-360	360;
	2038	2093	0.01322	0.02975	0.00356	90	90	90	0	0	1	-360	360;
	1921	2037	0.00818	0.02364	0.0031	114	114	114	0	0	1	-360	360;
	2150	1951	0.00901	0.01421	0.0017	90	90	90	0	0	1	-360	360;
	1637	1539	0.00331	0.00744	0.00096	114	114	114	0	0	1	-360	360;
	1653	1057	0.00471	0.01331	0.00179	114	114	114	0	0	1	-360	360;
	1261	1639	0.00298	0.00612	0.00103	114	114	114	0	0	1	-360	360;
	1941	1511	0.01587	0.04314	0.00429	114	114	114	0	0	1	-360	360;
	1973	1920	0.02612	0.03058	0.00657	90	90	90	0	0	1	-360	360;
	2046	1058	0.00413	0.01165	0.00158	114	114	114	0	0	1	-360	360;
	1238	1511	0.00851	0.0257	0.00309	114	114	114	0	0	1	-360	360;
	1722	1921	0.00281	0.00893	0.00097	114	114	114	0	0	1	-360	360;
	1441	1793	0.01033	0.03165	0.00366	114	114	114	0	0	1	-360	360;
	2109	1227	0.02058	0.05215	0.006	114	114	114	0	0	1	-360	360;
	1461	1228	0.00463	0.00777	0.00186	114	114	114	0	0	1	-360	360;
	2040	1794	0.01917	0.0624	0.00638	114	114	114	0	0	1	-360	360;
	1064	2040	0.01802	0.02116	0.00455	90	90	90	0	0	1	-360	360;
	2039	2040	0.00669	0.00785	0.00168	29	29	29	0	0	1	-360	360;
	2106	1446	0.01702	0.04901	0.00645	114	114	114	0	0	1	-360	360;
	1979	2106	0.04091	0.05083	0.01042	90	90	90	0	0	1	-360	360;
	1834	1510	0.00661	0.02	0.0024	114	114	114	0	0	1	-360	360;
	2150	1510	0.02512	0.07182	0.00953	114	114	114	0	0	1	-360	360;
	2067	2038	0.01438	0.04694	0.00475	114	114	114	0	0	1	-360	360;
	1835	2151	0.02876	0.08876	0.01014	114	114	114	0	0	1	-360	360;
	1510	1240	0.00264	0.00744	0.00101	114	114	114	0	0	1	-360	360;
	1891	2151	0.01959	0.02942	0.00541	90	90	90	0	0	1	-360	360;
	1472	1942	0.00372	0.00992	0.00096	114	114	114	0	0	1	-360	360;
	2107	1793	0.02421	0.07669	0.00831	114	114	114	0	0	1	-360	360;
	1226	1793	0.00769	0.02504	0.00253	114	114	114	0	0	1	-360	360;
	1227	1794	0.00769	0.02504	0.00253	114	114	114	0	0	1	-360	360;
	1471	1793	0.01926	0.06298	0.00636	114	114	114	0	0	1	-360	360;
	1655	1335	0.00603	0.01686	0.00167	114	114	114	0	0	1	-360	360;
	1239	1654	0.00405	0.01083	0.00137	114	114	114	0	0	1	-360	360;
	2057	1952	0.02033	0.0624	0.00719	114	114	114	0	0	1	-360	360;
	1638	1833	0.00512	0.01529	0.00187	114	114	114	0	0	1	-360	360;
	2056	1836	0.01562	0.05107	0.00516	114	114	114	0	0	1	-360	360;
	1462	2125	0.01736	0.02322	0.00464	90	90	90	0	0	1	-360	360;
	1640	1511	0.00289	0.00934	0.00099	114	114	114	0	0	1	-360	360;
	1920	1510	0.02207	0.07215	0.00729	114	114	114	0	0	1	-360	360;
	1978	1089	0.01636	0.02025	0.00421	90	90	90	0	0	1	-360	360;
	1228	1612	0.00884	0.02802	0.00301	114	114	114	0	0	1	-360	360;
	1613	1182	0.00479	0.01471	0.00168	114	114	114	0	0	1	-360	360;
	1511	1202	0.01793	0.04463	0.00544	114	114	114	0	0	1	-360	360;
	1158	1219	0.01347	0.04264	0.00462	114	114	114	0	0	1	-360	360;
	1156	1158	0.00463	0.01331	0.00176	114	114	114	0	0	1	-360	360;
	1180	1158	8e-05	0.00017	3e-05	114	114	114	0	0	1	-360	360;
	1868	1562	0.04025	0.07132	0.00662	72	72	72	0	0	1	-360	360;
	1763	1868	0.02702	0.05752	0.00544	72	72	72	0	0	1	-360	360;
	1822	1763	0.00066	0.00107	0.00018	72	72	72	0	0	1	-360	360;
	1761	1763	0.00017	0.00041	5e-05	114	114	114	0	0	1	-360	360;
	1709	1282	0.00215	0.00612	0.00083	114	114	114	0	0	1	-360	360;
	1982	1590	0.01306	0.04157	0.00445	114	114	114	0	0	1	-360	360;
	2092	1132	0.01	0.02306	0.00305	97	97	97	0	0	1	-360	360;
	2113	2092	0.00587	0.01835	0.00202	116	116	116	0	0	1	-360	360;
	2136	2092	8e-05	0.00033	4e-05	116	116	116	0	0	1	-360	360;
	1076	2136	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	2134	2136	0.00446	0.01273	0.00172	114	114	114	0	0	1	-360	360;
	1067	1332	0.01397	0.04405	0.00478	114	114	114	0	0	1	-360	360;
	1815	1512	0.02281	0.06	0.00958	114	114	114	0	0	1	-360	360;
	1660	1769	0.00669	0.0162	0.00254	97	97	97	0	0	1	-360	360;
	1165	1868	0.02256	0.04314	0.004	75	75	75	0	0	1	-360	360;
	1660	1415	0.00446	0.01215	0.00124	111	111	111	0	0	1	-360	360;
	1416	1132	0.0057	0.01636	0.00222	114	114	114	0	0	1	-360	360;
	2076	1659	0.01364	0.03446	0.00363	97	97	97	0	0	1	-360	360;
	1421	1659	0.01769	0.04438	0.00468	97	97	97	0	0	1	-360	360;
	1813	1421	0.00488	0.01306	0.0016	97	97	97	0	0	1	-360	360;
	1421	1419	0.00091	0.00215	0.00023	97	97	97	0	0	1	-360	360;
	1660	1407	0.01669	0.04364	0.00566	97	97	97	0	0	1	-360	360;
	1315	1391	0.00289	0.00802	0.0008	114	114	114	0	0	1	-360	360;
	1406	1315	0.00595	0.00992	0.00237	97	97	97	0	0	1	-360	360;
	1315	1313	0.0024	0.00455	0.00075	72	72	72	0	0	1	-360	360;
	1635	1858	0.00893	0.02926	0.00295	114	114	114	0	0	1	-360	360;
	1678	1635	0.00496	0.01612	0.00164	114	114	114	0	0	1	-360	360;
	1633	1635	0.00231	0.00388	0.00039	72	72	72	0	0	1	-360	360;
	1299	1857	0.00083	0.00256	0.00027	114	114	114	0	0	1	-360	360;
	1078	1299	0.00793	0.02595	0.00262	114	114	114	0	0	1	-360	360;
	1297	1299	0.00025	0.00058	8e-05	114	114	114	0	0	1	-360	360;
	1644	1858	0.00802	0.02471	0.0025	97	97	97	0	0	1	-360	360;
	1643	1857	0.0081	0.0257	0.00258	97	97	97	0	0	1	-360	360;
	1859	1987	0.01446	0.04132	0.0055	114	114	114	0	0	1	-360	360;
	1898	1944	0.01008	0.03182	0.00345	114	114	114	0	0	1	-360	360;
	1411	1453	0.00372	0.01207	0.00122	114	114	114	0	0	1	-360	360;
	1607	1704	0.00223	0.0062	0.00084	114	114	114	0	0	1	-360	360;
	2035	2018	0.00959	0.03107	0.00317	114	114	114	0	0	1	-360	360;
	1663	1847	0.00099	0.00298	0.00036	114	114	114	0	0	1	-360	360;
	1869	1663	0.00579	0.01868	0.0019	114	114	114	0	0	1	-360	360;
	1661	1663	0.00083	0.00231	0.0003	114	114	114	0	0	1	-360	360;
	2062	1868	0.0119	0.03686	0.00418	114	114	114	0	0	1	-360	360;
	1362	1161	0.00421	0.01355	0.0014	114	114	114	0	0	1	-360	360;
	1962	1508	0.00521	0.01496	0.00198	114	114	114	0	0	1	-360	360;
	2098	1702	0.00479	0.01471	0.00176	114	114	114	0	0	1	-360	360;
	1208	2098	0.00174	0.00579	0.00065	114	114	114	0	0	1	-360	360;
	2096	2098	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	1208	1840	0.00124	0.00421	0.00042	114	114	114	0	0	1	-360	360;
	1662	1847	0.00149	0.0043	0.00058	114	114	114	0	0	1	-360	360;
	1154	1596	0.00678	0.02215	0.00225	114	114	114	0	0	1	-360	360;
	1300	1647	0.0081	0.02066	0.00231	97	97	97	0	0	1	-360	360;
	1858	1300	0.0005	0.00157	0.00016	97	97	97	0	0	1	-360	360;
	1300	1298	0.00091	0.00264	0.00036	57	57	57	0	0	1	-360	360;
	1355	1188	0.00174	0.00496	0.00065	57	57	57	0	0	1	-360	360;
	2063	1548	0.01298	0.04074	0.0045	114	114	114	0	0	1	-360	360;
	1789	1963	0.0038	0.01231	0.00124	114	114	114	0	0	1	-360	360;
	1636	1789	0.00669	0.02198	0.00222	116	116	116	0	0	1	-360	360;
	1079	1636	0.00446	0.01463	0.00148	114	114	114	0	0	1	-360	360;
	1789	1787	0.00116	0.00256	0.00025	72	72	72	0	0	1	-360	360;
	1634	1636	0.00231	0.00388	0.00039	72	72	72	0	0	1	-360	360;
	1962	1364	0.00446	0.01455	0.00149	114	114	114	0	0	1	-360	360;
	1453	2053	0.00331	0.01066	0.0011	114	114	114	0	0	1	-360	360;
	1453	1247	0.0014	0.00455	0.00046	114	114	114	0	0	1	-360	360;
	1705	1218	0.0024	0.00678	0.00091	114	114	114	0	0	1	-360	360;
	2063	1698	0.0038	0.01083	0.00145	114	114	114	0	0	1	-360	360;
	1848	2064	0.01835	0.05744	0.00634	114	114	114	0	0	1	-360	360;
	1316	1193	0.00099	0.00273	0.00037	114	114	114	0	0	1	-360	360;
	1740	1316	0.00149	0.0043	0.00057	114	114	114	0	0	1	-360	360;
	1316	1314	0.00132	0.00364	0.00049	114	114	114	0	0	1	-360	360;
	1417	1131	0.00273	0.00785	0.00102	114	114	114	0	0	1	-360	360;
	2133	1417	0.00223	0.00736	0.00075	116	116	116	0	0	1	-360	360;
	2130	2133	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	2132	2133	0	0.00083	1e-05	114	114	114	0	0	1	-360	360;
	1475	1331	0.00107	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	2060	1475	0.00455	0.01355	0.00164	114	114	114	0	0	1	-360	360;
	1475	1473	0.00116	0.0014	0.0003	72	72	72	0	0	1	-360	360;
	1135	1331	0.00107	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	2105	1135	0.00388	0.01207	0.00134	114	114	114	0	0	1	-360	360;
	1133	1135	0.00066	0.00182	0.00024	114	114	114	0	0	1	-360	360;
	1496	1331	0.00934	0.0257	0.00253	97	97	97	0	0	1	-360	360;
	1943	1496	0.0057	0.01479	0.0015	97	97	97	0	0	1	-360	360;
	1496	1493	0.00554	0.00959	0.00095	72	72	72	0	0	1	-360	360;
	1543	1331	0.01504	0.04033	0.00401	97	97	97	0	0	1	-360	360;
	1944	1543	8e-05	0.00025	2e-05	114	114	114	0	0	1	-360	360;
	1542	1543	0.00017	0.00041	6e-05	114	114	114	0	0	1	-360	360;
	1589	1513	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1589	1513	0.0005	0.00149	0.00017	114	114	114	0	0	1	-360	360;
	1359	1330	0.01256	0.03975	0.0044	114	114	114	0	0	1	-360	360;
	1361	1359	0.00025	0.00083	9e-05	116	116	116	0	0	1	-360	360;
	1589	1361	0.00058	0.00174	0.00019	114	114	114	0	0	1	-360	360;
	1356	1359	0.00041	0.00132	0.00013	114	114	114	0	0	1	-360	360;
	1880	1332	0.00876	0.02744	0.00304	114	114	114	0	0	1	-360	360;
	1358	1880	0.00364	0.01149	0.00127	116	116	116	0	0	1	-360	360;
	1590	1358	0.00099	0.00339	0.00038	114	114	114	0	0	1	-360	360;
	1879	1880	0.00207	0.00603	0.00079	114	114	114	0	0	1	-360	360;
	1246	2095	0.00149	0.00496	0.0005	84	84	84	0	0	1	-360	360;
	1648	1246	0.00496	0.01306	0.00151	97	97	97	0	0	1	-360	360;
	1245	1246	0.00066	0.00198	0.00026	114	114	114	0	0	1	-360	360;
	2064	1739	0.0043	0.01364	0.00146	114	114	114	0	0	1	-360	360;
	1370	1749	0.01198	0.03702	0.00418	114	114	114	0	0	1	-360	360;
	1610	1188	0.00455	0.01405	0.0016	114	114	114	0	0	1	-360	360;
	2035	2019	0.00421	0.00917	0.00216	114	114	114	0	0	1	-360	360;
	1839	1142	0.00579	0.01529	0.0016	97	97	97	0	0	1	-360	360;
	1567	1142	0.00132	0.00231	0.00023	57	57	57	0	0	1	-360	360;
	1568	1143	0.00132	0.00231	0.00023	57	57	57	0	0	1	-360	360;
	2065	1883	0.00289	0.00719	0.00076	97	97	97	0	0	1	-360	360;
	2066	1884	0.00289	0.00719	0.00076	97	97	97	0	0	1	-360	360;
	1850	1330	0.00372	0.00917	0.00098	97	97	97	0	0	1	-360	360;
	2066	1850	0.00463	0.01463	0.00159	114	114	114	0	0	1	-360	360;
	1849	1850	0.00264	0.00579	0.00136	114	114	114	0	0	1	-360	360;
	2065	1330	0.00835	0.02388	0.00256	97	97	97	0	0	1	-360	360;
	1476	1330	0.00157	0.00488	0.00055	114	114	114	0	0	1	-360	360;
	1697	1476	0.00744	0.02281	0.00261	116	116	116	0	0	1	-360	360;
	2074	1697	0.00099	0.00331	0.00035	114	114	114	0	0	1	-360	360;
	1476	1474	0.00074	0.00132	0.00031	97	97	97	0	0	1	-360	360;
	1695	1697	0.00025	0.0005	5e-05	72	72	72	0	0	1	-360	360;
	1605	1330	0.00752	0.02339	0.0026	114	114	114	0	0	1	-360	360;
	2008	1641	0.01008	0.02496	0.00265	97	97	97	0	0	1	-360	360;
	2048	2008	0.0119	0.03008	0.0032	97	97	97	0	0	1	-360	360;
	2006	2008	0.00438	0.00545	0.00081	75	75	75	0	0	1	-360	360;
	2009	1642	0.01008	0.02496	0.00265	97	97	97	0	0	1	-360	360;
	1826	2009	0.00826	0.02132	0.00242	97	97	97	0	0	1	-360	360;
	2007	2009	0.00413	0.00479	0.00072	75	75	75	0	0	1	-360	360;
	2065	1929	0.0024	0.00694	0.0009	114	114	114	0	0	1	-360	360;
	1453	1220	0.00314	0.01355	0.00135	114	114	114	0	0	1	-360	360;
	1641	1365	0.00306	0.00355	0.00076	72	72	72	0	0	1	-360	360;
	1521	1604	0.00314	0.00959	0.00112	114	114	114	0	0	1	-360	360;
	1642	1366	0.00314	0.00364	0.00078	72	72	72	0	0	1	-360	360;
	1242	1856	0.00107	0.00298	0.0004	114	114	114	0	0	1	-360	360;
	1943	1242	0.00182	0.00529	0.00071	114	114	114	0	0	1	-360	360;
	1242	1241	0.00058	0.00157	0.00021	114	114	114	0	0	1	-360	360;
	1608	1853	0.00314	0.02124	0.00243	114	114	114	0	0	1	-360	360;
	1189	1502	0.00496	0.01628	0.00164	114	114	114	0	0	1	-360	360;
	2065	1596	0.00405	0.01264	0.0014	114	114	114	0	0	1	-360	360;
	1098	1643	0.00198	0.00612	0.00068	114	114	114	0	0	1	-360	360;
	2095	1098	0.00496	0.01545	0.00171	114	114	114	0	0	1	-360	360;
	1098	1096	0.00107	0.0019	0.00019	72	72	72	0	0	1	-360	360;
	1460	1644	0.00231	0.00752	0.00079	114	114	114	0	0	1	-360	360;
	1846	1460	0.0057	0.01818	0.00196	114	114	114	0	0	1	-360	360;
	1459	1460	8e-05	0.00017	2e-05	97	97	97	0	0	1	-360	360;
	1454	2025	0.0019	0.00455	0.00091	114	114	114	0	0	1	-360	360;
	2026	1453	0.0014	0.00471	0.00048	114	114	114	0	0	1	-360	360;
	1143	2026	0.0081	0.02298	0.00239	97	97	97	0	0	1	-360	360;
	2024	2026	0.0005	0.0014	0.00017	114	114	114	0	0	1	-360	360;
	1321	1332	0.00752	0.02347	0.00235	97	97	97	0	0	1	-360	360;
	1494	1321	0.00033	0.00116	0.00012	114	114	114	0	0	1	-360	360;
	1319	1321	0.0024	0.00727	0.00087	114	114	114	0	0	1	-360	360;
	2036	2122	0.0081	0.02496	0.00284	114	114	114	0	0	1	-360	360;
	1775	1060	0.00364	0.01149	0.00123	114	114	114	0	0	1	-360	360;
	1105	1775	0.00157	0.00463	0.00057	114	114	114	0	0	1	-360	360;
	1775	1773	0.00231	0.00694	0.00072	97	97	97	0	0	1	-360	360;
	2002	1232	0.0019	0.0057	0.00061	97	97	97	0	0	1	-360	360;
	1099	2003	0.0057	0.01744	0.00187	97	97	97	0	0	1	-360	360;
	2095	1099	0.00496	0.01545	0.00171	114	114	114	0	0	1	-360	360;
	1099	1097	0.00107	0.0019	0.00019	72	72	72	0	0	1	-360	360;
	1454	1996	0.00521	0.01603	0.00183	114	114	114	0	0	1	-360	360;
	1673	1512	0.01339	0.04223	0.00461	114	114	114	0	0	1	-360	360;
	2022	1673	0.00785	0.02529	0.00263	114	114	114	0	0	1	-360	360;
	1673	1671	0.00388	0.01281	0.00126	114	114	114	0	0	1	-360	360;
	1672	1263	0.00876	0.0281	0.00298	114	114	114	0	0	1	-360	360;
	1585	1672	0.01116	0.03504	0.00382	116	116	116	0	0	1	-360	360;
	1512	1585	0.00231	0.00719	0.00079	114	114	114	0	0	1	-360	360;
	1672	1670	0.0038	0.0124	0.00126	114	114	114	0	0	1	-360	360;
	1585	1583	0.00322	0.00554	0.00054	72	72	72	0	0	1	-360	360;
	2002	1643	0.00545	0.01702	0.00187	114	114	114	0	0	1	-360	360;
	2121	2066	0.00488	0.01207	0.00144	97	97	97	0	0	1	-360	360;
	1369	2120	0.00273	0.00785	0.00081	97	97	97	0	0	1	-360	360;
	1600	1811	0.00289	0.00868	0.00103	114	114	114	0	0	1	-360	360;
	2036	1600	0.00595	0.01942	0.00199	114	114	114	0	0	1	-360	360;
	1600	1598	0.00529	0.00909	0.0009	72	72	72	0	0	1	-360	360;
	1253	1454	0.0014	0.00455	0.00046	114	114	114	0	0	1	-360	360;
	1274	1253	0.00512	0.01554	0.00186	114	114	114	0	0	1	-360	360;
	1252	1253	0.00033	0.00107	0.00011	114	114	114	0	0	1	-360	360;
	1958	1877	0.00678	0.02025	0.00244	105	105	105	0	0	1	-360	360;
	2123	1878	0.00802	0.02554	0.00272	114	114	114	0	0	1	-360	360;
	1976	1821	0.00727	0.00975	0.00189	72	72	72	0	0	1	-360	360;
	2064	1131	0.01785	0.05826	0.00589	114	114	114	0	0	1	-360	360;
	2065	1254	0.00314	0.00785	0.00086	97	97	97	0	0	1	-360	360;
	1696	1255	0.00579	0.01595	0.00189	97	97	97	0	0	1	-360	360;
	1520	1696	0.00207	0.0062	0.00077	114	114	114	0	0	1	-360	360;
	1694	1696	0.00025	0.0005	5e-05	72	72	72	0	0	1	-360	360;
	2018	1738	0.00744	0.02289	0.00262	114	114	114	0	0	1	-360	360;
	1737	1513	0.01207	0.03926	0.00399	114	114	114	0	0	1	-360	360;
	1876	1513	0.0005	0.0038	0.00038	152	152	152	0	0	1	-360	360;
	1930	1876	0.0081	0.05248	0.00524	116	116	116	0	0	1	-360	360;
	2066	1930	0.00769	0.02413	0.00266	114	114	114	0	0	1	-360	360;
	1874	1876	0.00058	0.00174	0.00023	114	114	114	0	0	1	-360	360;
	1928	1930	0.00223	0.00719	0.00075	114	114	114	0	0	1	-360	360;
	1812	1095	0.00281	0.00851	0.00098	114	114	114	0	0	1	-360	360;
	1599	1094	0.00347	0.0114	0.00115	114	114	114	0	0	1	-360	360;
	1262	1599	0.00529	0.01719	0.00176	114	114	114	0	0	1	-360	360;
	1599	1597	0.00529	0.00909	0.0009	72	72	72	0	0	1	-360	360;
	1551	1807	0.01926	0.06198	0.00647	114	114	114	0	0	1	-360	360;
	2062	1551	0.01041	0.03388	0.00346	114	114	114	0	0	1	-360	360;
	1550	1551	0.00165	0.00537	0.00054	114	114	114	0	0	1	-360	360;
	1933	1847	0.00471	0.0138	0.00176	114	114	114	0	0	1	-360	360;
	1360	1590	0.00074	0.00231	0.00023	114	114	114	0	0	1	-360	360;
	2128	1360	0.01107	0.03612	0.00365	114	114	114	0	0	1	-360	360;
	1357	1360	0.00091	0.00306	0.0003	114	114	114	0	0	1	-360	360;
	1590	1716	0.00752	0.02446	0.00247	114	114	114	0	0	1	-360	360;
	1762	1977	0.0124	0.02793	0.00267	72	72	72	0	0	1	-360	360;
	2017	1443	0.01711	0.05562	0.0056	99	99	99	0	0	1	-360	360;
	1195	1160	0.01512	0.04223	0.00403	99	99	99	0	0	1	-360	360;
	1619	1159	0.01529	0.03198	0.00589	99	99	99	0	0	1	-360	360;
	1658	1400	0.00934	0.02917	0.00321	114	114	114	0	0	1	-360	360;
	1667	1658	0.00215	0.00636	0.0008	114	114	114	0	0	1	-360	360;
	1658	1657	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1631	1400	0.00504	0.01661	0.00167	114	114	114	0	0	1	-360	360;
	1956	1578	0.00579	0.01446	0.00162	99	99	99	0	0	1	-360	360;
	1444	1578	0.03413	0.08545	0.00909	99	99	99	0	0	1	-360	360;
	1444	2138	0.0062	0.01562	0.00277	114	114	114	0	0	1	-360	360;
	1617	2137	0.00124	0.00355	0.00045	114	114	114	0	0	1	-360	360;
	1909	1955	0.00769	0.01934	0.00211	99	99	99	0	0	1	-360	360;
	1907	1909	0.01248	0.03545	0.00474	114	114	114	0	0	1	-360	360;
	1443	1071	0.00488	0.01231	0.00189	99	99	99	0	0	1	-360	360;
	1212	1541	0.0062	0.01934	0.00214	114	114	114	0	0	1	-360	360;
	1443	1264	0.00405	0.01331	0.00135	114	114	114	0	0	1	-360	360;
	1265	1908	0.01025	0.02926	0.0039	114	114	114	0	0	1	-360	360;
	1440	1400	0.00959	0.03107	0.00321	114	114	114	0	0	1	-360	360;
	1684	1400	0.0014	0.0043	0.00047	114	114	114	0	0	1	-360	360;
	1191	1431	0.00777	0.02372	0.00273	114	114	114	0	0	1	-360	360;
	1993	1524	0.00818	0.02496	0.00292	114	114	114	0	0	1	-360	360;
	2126	2118	0.00149	0.00446	0.00057	114	114	114	0	0	1	-360	360;
	1706	1616	0.00628	0.01959	0.00217	114	114	114	0	0	1	-360	360;
	1707	1617	0.0062	0.01942	0.00215	114	114	114	0	0	1	-360	360;
	1616	2119	0.00083	0.00248	0.00027	114	114	114	0	0	1	-360	360;
	1072	2127	0.00074	0.00223	0.0003	114	114	114	0	0	1	-360	360;
	2139	1617	0.00198	0.00529	0.00071	99	99	99	0	0	1	-360	360;
	1892	1887	0.00347	0.00975	0.00132	114	114	114	0	0	1	-360	360;
	2021	1159	0.00512	0.01463	0.00197	114	114	114	0	0	1	-360	360;
	1893	2021	0.00132	0.0038	0.00051	114	114	114	0	0	1	-360	360;
	2020	2021	0.00025	0.00033	4e-05	114	114	114	0	0	1	-360	360;
	1923	1401	0.00479	0.01471	0.00169	114	114	114	0	0	1	-360	360;
	1423	1398	0.00884	0.02769	0.00305	114	114	114	0	0	1	-360	360;
	1939	1401	0.00504	0.01554	0.00179	114	114	114	0	0	1	-360	360;
	1926	1399	0.00355	0.00884	0.00094	99	99	99	0	0	1	-360	360;
	2029	1926	0.01603	0.04124	0.00435	99	99	99	0	0	1	-360	360;
	1926	1924	0.01264	0.01488	0.00319	77	77	77	0	0	1	-360	360;
	1927	1398	0.0043	0.01066	0.00113	99	99	99	0	0	1	-360	360;
	1900	1927	0.01727	0.04893	0.00506	99	99	99	0	0	1	-360	360;
	1927	1925	0.01281	0.01496	0.00322	77	77	77	0	0	1	-360	360;
	2030	1900	0.00893	0.02777	0.0031	114	114	114	0	0	1	-360	360;
	1248	1900	0.00901	0.02769	0.00317	114	114	114	0	0	1	-360	360;
	1901	1159	0.01083	0.02711	0.00287	99	99	99	0	0	1	-360	360;
	1902	1160	0.01083	0.02711	0.00287	99	99	99	0	0	1	-360	360;
	2081	1901	0.0043	0.0124	0.00164	114	114	114	0	0	1	-360	360;
	2082	1900	0.0043	0.0124	0.00164	114	114	114	0	0	1	-360	360;
	1732	1713	0.00504	0.01256	0.00135	99	99	99	0	0	1	-360	360;
	1902	1732	0.01099	0.02835	0.00304	99	99	99	0	0	1	-360	360;
	1731	1732	0.0043	0.01231	0.00162	114	114	114	0	0	1	-360	360;
	1901	1712	0.01603	0.04107	0.0044	99	99	99	0	0	1	-360	360;
	1900	2071	0.0062	0.02025	0.00208	114	114	114	0	0	1	-360	360;
	1443	1129	0.00455	0.01289	0.00174	114	114	114	0	0	1	-360	360;
	1999	1087	0.00421	0.01322	0.00146	114	114	114	0	0	1	-360	360;
	1953	1087	0.00347	0.01116	0.00119	114	114	114	0	0	1	-360	360;
	1950	1287	0.00471	0.01339	0.0018	114	114	114	0	0	1	-360	360;
	1579	1950	0.00355	0.01091	0.00126	114	114	114	0	0	1	-360	360;
	1950	1948	0.00157	0.00496	0.00056	114	114	114	0	0	1	-360	360;
	1754	1088	0.00264	0.00818	0.00091	114	114	114	0	0	1	-360	360;
	1579	1754	0.00612	0.01917	0.00209	114	114	114	0	0	1	-360	360;
	1754	1753	0.00207	0.00347	0.00083	99	99	99	0	0	1	-360	360;
	1593	1579	0.0024	0.00719	0.00085	114	114	114	0	0	1	-360	360;
	1213	1667	0.0024	0.00777	0.00081	114	114	114	0	0	1	-360	360;
	1286	1772	0.00372	0.00843	0.00145	102	102	102	0	0	1	-360	360;
	1745	1666	0.00628	0.02025	0.00211	114	114	114	0	0	1	-360	360;
	1484	1439	8e-05	0.00025	2e-05	114	114	114	0	0	1	-360	360;
	1693	1484	0.0076	0.01983	0.00206	99	99	99	0	0	1	-360	360;
	1666	1693	0.00314	0.00843	0.00085	99	99	99	0	0	1	-360	360;
	1483	1484	0.00455	0.00818	0.00096	77	77	77	0	0	1	-360	360;
	1692	1693	0.0005	0.0014	0.00013	99	99	99	0	0	1	-360	360;
	1458	1439	0.00256	0.00636	0.001	99	99	99	0	0	1	-360	360;
	1651	1409	0.00165	0.00463	0.00063	114	114	114	0	0	1	-360	360;
	1405	1440	0.00322	0.00926	0.00122	114	114	114	0	0	1	-360	360;
	1186	1405	0.00306	0.00893	0.00111	114	114	114	0	0	1	-360	360;
	1404	1405	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1409	1771	0.0014	0.00405	0.00053	114	114	114	0	0	1	-360	360;
	2058	1594	0.01074	0.03273	0.00383	114	114	114	0	0	1	-360	360;
	1439	1685	0.00826	0.02686	0.00276	114	114	114	0	0	1	-360	360;
	1625	2017	0.01471	0.03025	0.00563	99	99	99	0	0	1	-360	360;
	1444	1625	0.00992	0.01661	0.00395	99	99	99	0	0	1	-360	360;
	1625	1624	0.00223	0.00562	0.0006	99	99	99	0	0	1	-360	360;
	1085	1401	0.00603	0.02083	0.00212	114	114	114	0	0	1	-360	360;
	1086	1167	0.00306	0.01074	0.00115	114	114	114	0	0	1	-360	360;
	1397	1166	0.00653	0.02099	0.00221	114	114	114	0	0	1	-360	360;
	1525	1397	0.0024	0.00694	0.00092	114	114	114	0	0	1	-360	360;
	1393	1397	0.00868	0.02669	0.00307	114	114	114	0	0	1	-360	360;
	1394	1397	0.00835	0.0257	0.00294	114	114	114	0	0	1	-360	360;
	1414	1712	0.00471	0.01149	0.00179	99	99	99	0	0	1	-360	360;
	2080	1414	0.02405	0.04025	0.00957	99	99	99	0	0	1	-360	360;
	1413	1414	0.00347	0.01025	0.00125	114	114	114	0	0	1	-360	360;
	1713	1888	0.00149	0.00438	0.00052	114	114	114	0	0	1	-360	360;
	1712	1509	0.00091	0.00298	0.00033	114	114	114	0	0	1	-360	360;
	1730	1712	0.01033	0.0124	0.00255	77	77	77	0	0	1	-360	360;
	1713	1480	0.00843	0.02421	0.00321	114	114	114	0	0	1	-360	360;
	1954	1746	0.00149	0.00446	0.00055	114	114	114	0	0	1	-360	360;
	1721	1666	0.00198	0.0057	0.00077	114	114	114	0	0	1	-360	360;
	1949	1187	0.00438	0.01405	0.00149	114	114	114	0	0	1	-360	360;
	1327	1949	0.00066	0.00182	0.00024	114	114	114	0	0	1	-360	360;
	1579	1327	0.00463	0.01413	0.00163	114	114	114	0	0	1	-360	360;
	1947	1949	0.00017	0.00041	6e-05	114	114	114	0	0	1	-360	360;
	1326	1327	0	8e-05	1e-05	114	114	114	0	0	1	-360	360;
	1540	1088	0.00463	0.01438	0.0016	114	114	114	0	0	1	-360	360;
	1236	1088	0.00083	0.00264	0.00026	114	114	114	0	0	1	-360	360;
	1627	1236	0.00256	0.00835	0.00084	114	114	114	0	0	1	-360	360;
	1235	1236	0.00099	0.00289	0.00038	114	114	114	0	0	1	-360	360;
	2030	1190	0.00529	0.01636	0.00188	114	114	114	0	0	1	-360	360;
	1123	1159	0.00083	0.00132	0.00016	77	77	77	0	0	1	-360	360;
	1124	1160	0.00083	0.00124	0.00015	77	77	77	0	0	1	-360	360;
	1125	1160	0.00083	0.00124	0.00015	77	77	77	0	0	1	-360	360;
	1126	1159	0.00074	0.00116	0.00013	77	77	77	0	0	1	-360	360;
	1579	1998	0.00496	0.01537	0.00175	114	114	114	0	0	1	-360	360;
	1440	1194	0.00719	0.01777	0.00216	99	99	99	0	0	1	-360	360;
	1666	1632	0.00802	0.02521	0.00274	114	114	114	0	0	1	-360	360;
	2140	1130	0.00603	0.01711	0.00231	114	114	114	0	0	1	-360	360;
	1649	1580	0.00769	0.02711	0.00317	114	114	114	0	0	1	-360	360;
	1922	1399	0.0014	0.00446	0.00049	114	114	114	0	0	1	-360	360;
	1652	1457	0.00488	0.00868	0.00192	99	99	99	0	0	1	-360	360;
	2068	2017	0.00372	0.01231	0.00124	114	114	114	0	0	1	-360	360;
	2029	1249	0.00273	0.00826	0.00096	114	114	114	0	0	1	-360	360;
	2079	1995	0.00116	0.00273	0.00046	99	99	99	0	0	1	-360	360;
	1353	2016	0.00215	0.01479	0.00169	114	114	114	0	0	1	-360	360;
	1618	2016	0.00769	0.02347	0.00277	114	114	114	0	0	1	-360	360;
	1141	2017	0.00207	0.01413	0.00162	114	114	114	0	0	1	-360	360;
	1354	1141	8e-05	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	1139	1141	0.0005	0.00149	0.0096	114	114	114	0	0	1	-360	360;
	2059	2016	0.01116	0.03273	0.00319	99	99	99	0	0	1	-360	360;
	1669	2072	0.00587	0.0162	0.0017	99	99	99	0	0	1	-360	360;
	2030	1669	0.00017	0.00033	3e-05	99	99	99	0	0	1	-360	360;
	1669	1668	0.00198	0.00455	0.00078	99	99	99	0	0	1	-360	360;
	1296	1294	8e-05	0.00083	0	77	77	77	0	0	1	-360	360;
	1797	1296	0.01603	0.02347	0.00336	77	77	77	0	0	1	-360	360;
	1308	1797	0.04752	0.09182	0.00916	77	77	77	0	0	1	-360	360;
	1886	1328	0.03041	0.05322	0.00508	77	77	77	0	0	1	-360	360;
	2117	1886	0.09893	0.17769	0.01704	77	77	77	0	0	1	-360	360;
	1885	1886	0.00198	0.00314	0.00037	19	19	19	0	0	1	-360	360;
	1572	2116	0.01355	0.02826	0.00271	77	77	77	0	0	1	-360	360;
	1971	1110	0.02289	0.05793	0.00612	99	99	99	0	0	1	-360	360;
	1961	1110	0.02479	0.06264	0.00663	99	99	99	0	0	1	-360	360;
	2117	1284	0.02273	0.07314	0.00765	114	114	114	0	0	1	-360	360;
	1569	1110	0.01471	0.04587	0.00509	99	99	99	0	0	1	-360	360;
	1798	1367	0.04901	0.08405	0.00831	77	77	77	0	0	1	-360	360;
	1307	1798	0.04752	0.09182	0.00916	77	77	77	0	0	1	-360	360;
	1796	1798	0.0062	0.01066	0.00104	77	77	77	0	0	1	-360	360;
	1573	1111	0.01636	0.04132	0.0045	99	99	99	0	0	1	-360	360;
	1179	1573	0.03727	0.06678	0.00651	77	77	77	0	0	1	-360	360;
	1571	1573	0.00058	0.00099	0.0001	29	29	29	0	0	1	-360	360;
	1091	1271	0.01802	0.05174	0.00682	57	57	57	0	0	1	-360	360;
	1328	1091	0.0124	0.03595	0.00461	57	57	57	0	0	1	-360	360;
	1091	1090	0.01653	0.02579	0.0031	19	19	19	0	0	1	-360	360;
	1328	1719	0.01264	0.02372	0.00377	57	57	57	0	0	1	-360	360;
	1470	1111	0.00719	0.02248	0.00246	114	114	114	0	0	1	-360	360;
	1469	1112	0.00719	0.02256	0.00247	114	114	114	0	0	1	-360	360;
	1308	1302	0.00661	0.02124	0.00222	114	114	114	0	0	1	-360	360;
	1334	1307	0.01636	0.0524	0.00553	114	114	114	0	0	1	-360	360;
	1726	1307	0.02066	0.04909	0.0103	77	77	77	0	0	1	-360	360;
	1266	1308	0.00013	0.00231	0.00024	57	57	57	0	0	1	-360	360;
	1267	1307	0.00074	0.00223	0.00025	57	57	57	0	0	1	-360	360;
	1758	1308	0.02843	0.06868	0.00659	77	77	77	0	0	1	-360	360;
	2116	1758	0.0376	0.06537	0.00643	77	77	77	0	0	1	-360	360;
	1758	1756	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	2117	1522	0.03818	0.0662	0.00648	77	77	77	0	0	1	-360	360;
	1757	1307	0.02843	0.06868	0.00659	77	77	77	0	0	1	-360	360;
	1523	1757	0.00521	0.0086	0.00095	77	77	77	0	0	1	-360	360;
	1757	1755	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	1517	1492	0.0405	0.06314	0.00758	57	57	57	0	0	1	-360	360;
	2110	1527	0.02579	0.06736	0.0079	99	99	99	0	0	1	-360	360;
	2111	1726	0.02446	0.0624	0.00662	99	99	99	0	0	1	-360	360;
	2111	1727	0.02446	0.0624	0.00662	99	99	99	0	0	1	-360	360;
	1138	1561	0.02479	0.06579	0.00654	99	99	99	0	0	1	-360	360;
	2110	1918	0.00165	0.00347	0.00038	77	77	77	0	0	1	-360	360;
	2111	1919	0.00107	0.00347	0.00037	114	114	114	0	0	1	-360	360;
	2051	1491	0.03074	0.04793	0.00575	57	57	57	0	0	1	-360	360;
	1570	2116	0.00248	0.00752	0.00079	99	99	99	0	0	1	-360	360;
	1307	1285	0.01124	0.03645	0.00373	114	114	114	0	0	1	-360	360;
	1560	1491	0.00777	0.02116	0.00242	99	99	99	0	0	1	-360	360;
	2052	1681	0.05	0.0781	0.00933	57	57	57	0	0	1	-360	360;
	1727	1177	0.02603	0.0662	0.00724	99	99	99	0	0	1	-360	360;
	1780	1680	0.0424	0.06628	0.00792	57	57	57	0	0	1	-360	360;
	1101	1214	0.00438	0.01446	0.00146	86	86	86	0	0	1	-360	360;
	1323	1110	0.03256	0.10355	0.01105	114	114	114	0	0	1	-360	360;
	1806	1279	0.05025	0.07843	0.00941	57	57	57	0	0	1	-360	360;
	1960	1726	0.02537	0.06355	0.00677	99	99	99	0	0	1	-360	360;
	2033	1295	0.01331	0.03785	0.0051	57	57	57	0	0	1	-360	360;
	1214	1308	0.01	0.06967	0.00747	271	271	271	0	0	1	-360	360;
	1215	1980	0.00587	0.04058	0.00443	191	191	191	0	0	1	-360	360;
	1290	1301	0.00628	0.01959	0.0022	114	114	114	0	0	1	-360	360;
	1215	1291	0.00942	0.04198	0.00452	114	114	114	0	0	1	-360	360;
	1176	1970	0.00521	0.0138	0.00166	99	99	99	0	0	1	-360	360;
	1985	1301	0.00306	0.00702	0.00073	57	57	57	0	0	1	-360	360;
	1984	1302	0.00306	0.00694	0.00072	57	57	57	0	0	1	-360	360;
	1779	1100	0.03306	0.05388	0.00644	77	77	77	0	0	1	-360	360;
	1805	1117	0.01777	0.05802	0.00587	57	57	57	0	0	1	-360	360;
	1726	1137	0.02248	0.05165	0.00652	99	99	99	0	0	1	-360	360;
	1270	1294	0.01455	0.04165	0.00549	57	57	57	0	0	1	-360	360;
	1744	1328	0.02992	0.09198	0.01059	114	114	114	0	0	1	-360	360;
	1308	2013	0.01116	0.03364	0.00399	114	114	114	0	0	1	-360	360;
	1742	1906	0.03463	0.10727	0.01217	114	114	114	0	0	1	-360	360;
	1844	1214	0.02107	0.06851	0.00701	114	114	114	0	0	1	-360	360;
	1368	1844	0.03041	0.0914	0.01103	114	114	114	0	0	1	-360	360;
	1843	1844	0.01512	0.0495	0.005	114	114	114	0	0	1	-360	360;
	1905	1215	0.01471	0.04612	0.00511	114	114	114	0	0	1	-360	360;
	1741	1367	0.01521	0.03041	0.00377	90	90	90	0	0	1	-360	360;
	1981	1307	0.00463	0.03207	0.00353	232	232	232	0	0	1	-360	360;
	2103	1333	0.00339	0.00975	0.00127	114	114	114	0	0	1	-360	360;
	1214	2102	0.00331	0.02273	0.00246	114	114	114	0	0	1	-360	360;
	1726	1214	0.03438	0.11231	0.01135	114	114	114	0	0	1	-360	360;
	1727	1215	0.03438	0.1124	0.01135	114	114	114	0	0	1	-360	360;
	1558	1280	0.05347	0.06785	0.00635	57	57	57	0	0	1	-360	360;
	1184	1112	0.00752	0.02207	0.00251	99	99	99	0	0	1	-360	360;
	2012	1324	0.01702	0.0519	0.00604	114	114	114	0	0	1	-360	360;
	1329	1178	0.08231	0.14521	0.01396	57	57	57	0	0	1	-360	360;
	1368	1294	0.04719	0.07769	0.00864	57	57	57	0	0	1	-360	360;
	1174	1185	0.05843	0.0805	0.00897	64	64	64	0	0	1	-360	360;
	1118	1328	0.01364	0.04455	0.00453	57	57	57	0	0	1	-360	360;
	1806	1329	0.03124	0.10182	0.01034	57	57	57	0	0	1	-360	360;
	1628	1726	0.00099	0.0019	0	229	229	229	0	0	1	-360	360;
	1629	1727	0.00099	0.0019	0	229	229	229	0	0	1	-360	360;
	1630	1726	0.00124	0.00231	0	229	229	229	0	0	1	-360	360;
	1911	1169	0.02372	0.05926	0.0063	102	102	102	0	0	1	-360	360;
	1389	1623	0.00413	0.01033	0.0011	102	102	102	0	0	1	-360	360;
	1515	1389	0.03595	0.09132	0.0097	102	102	102	0	0	1	-360	360;
	1387	1389	0.00025	0.00041	0.00011	102	102	102	0	0	1	-360	360;
	1910	1127	0.01802	0.04124	0.00623	102	102	102	0	0	1	-360	360;
	1910	1073	0.01818	0.05636	0.00636	114	114	114	0	0	1	-360	360;
	1911	1800	0.02512	0.07851	0.00866	114	114	114	0	0	1	-360	360;
	1910	1500	0.01157	0.02512	0.00389	102	102	102	0	0	1	-360	360;
	1931	1623	0.02438	0.04083	0.00971	102	102	102	0	0	1	-360	360;
	1390	1623	0.00413	0.01033	0.0011	102	102	102	0	0	1	-360	360;
	2044	1390	0.0057	0.01562	0.00163	102	102	102	0	0	1	-360	360;
	1390	1388	0.00033	0.00058	0.00013	102	102	102	0	0	1	-360	360;
	2043	1842	0.01917	0.05124	0.0054	102	102	102	0	0	1	-360	360;
	2043	1383	0.00083	0.00273	0.00028	114	114	114	0	0	1	-360	360;
	2044	1384	0.00083	0.00306	0.00031	114	114	114	0	0	1	-360	360;
	2044	1376	0.00182	0.00512	0.00069	114	114	114	0	0	1	-360	360;
	2043	1377	0.0019	0.00529	0.00071	114	114	114	0	0	1	-360	360;
	2050	1800	0.00463	0.01512	0.00153	114	114	114	0	0	1	-360	360;
	1601	1799	0.00826	0.02702	0.00273	114	114	114	0	0	1	-360	360;
	2043	1374	0.00537	0.01207	0.00267	114	114	114	0	0	1	-360	360;
	1622	1371	0.00347	0.00661	0.00059	77	77	77	0	0	1	-360	360;
	1622	1372	0.00364	0.00653	0.00058	77	77	77	0	0	1	-360	360;
	1623	1373	0.00364	0.00653	0.00058	77	77	77	0	0	1	-360	360;
	1623	1378	0.00107	0.00207	0.00044	114	114	114	0	0	1	-360	360;
	1622	1379	0.00116	0.0019	0.00045	114	114	114	0	0	1	-360	360;
	2044	1386	0.00182	0.00479	0.00076	114	114	114	0	0	1	-360	360;
	1622	1375	0.00248	0.00595	0.00117	114	114	114	0	0	1	-360	360;
	1622	1080	0.01793	0.04512	0.00471	102	102	102	0	0	1	-360	360;
	1207	1081	0.00628	0.01942	0.00195	102	102	102	0	0	1	-360	360;
	1782	1288	0.01322	0.03694	0.0038	102	102	102	0	0	1	-360	360;
	2049	1603	0.00372	0.01223	0.00124	119	119	119	0	0	1	-360	360;
	1765	1603	0.00207	0.00653	0.00074	119	119	119	0	0	1	-360	360;
	1169	1766	0.01198	0.03455	0.00367	102	102	102	0	0	1	-360	360;
	1911	1988	0.01231	0.03545	0.00466	114	114	114	0	0	1	-360	360;
	1917	1152	0.00388	0.00901	0.00133	102	102	102	0	0	1	-360	360;
	1917	1910	0.00066	0.00413	0.00062	152	152	152	0	0	1	-360	360;
	1916	1911	0.00091	0.0062	0.00076	152	152	152	0	0	1	-360	360;
	1449	2000	0.04322	0.04876	0.00543	57	57	57	0	0	1	-360	360;
	1912	1449	0.00926	0.03017	0.00306	57	57	57	0	0	1	-360	360;
	1447	1449	0.00769	0.0086	0.00095	57	57	57	0	0	1	-360	360;
	1450	2001	0.02901	0.0362	0.00756	57	57	57	0	0	1	-360	360;
	1913	1450	0.00909	0.02959	0.00301	57	57	57	0	0	1	-360	360;
	1448	1450	0.00521	0.00612	0.00118	57	57	57	0	0	1	-360	360;
	1917	1831	0.08777	0.15231	0.01599	77	77	77	0	0	1	-360	360;
	1911	1664	0.02	0.04405	0.00993	114	114	114	0	0	1	-360	360;
	1665	1620	0.03934	0.08496	0.02002	114	114	114	0	0	1	-360	360;
	1403	1435	0.04322	0.10372	0.01111	77	77	77	0	0	1	-360	360;
	2000	1581	0.0157	0.02017	0.00426	77	77	77	0	0	1	-360	360;
	1872	1092	0.03678	0.08405	0.01056	102	102	102	0	0	1	-360	360;
	1293	1764	0.00934	0.01628	0.00189	77	77	77	0	0	1	-360	360;
	1293	1531	0.03264	0.09331	0.0124	76	76	76	0	0	1	-360	360;
	1832	1582	0.02653	0.03231	0.00677	77	77	77	0	0	1	-360	360;
	1601	1206	0.00388	0.01264	0.00128	114	114	114	0	0	1	-360	360;
	1312	1965	0.03579	0.06314	0.0077	77	77	77	0	0	1	-360	360;
	1964	1276	0.00397	0.00579	0.00109	57	57	57	0	0	1	-360	360;
	1964	2086	0.00711	0.01107	0.00132	77	77	77	0	0	1	-360	360;
	1965	2087	0.00702	0.01099	0.00131	77	77	77	0	0	1	-360	360;
	1104	1688	0.01909	0.05421	0.0073	114	114	114	0	0	1	-360	360;
	2001	1104	0.00653	0.0186	0.0025	114	114	114	0	0	1	-360	360;
	1102	1104	0.01	0.02843	0.00383	57	57	57	0	0	1	-360	360;
	1292	1621	0.03868	0.11587	0.01404	114	114	114	0	0	1	-360	360;
	1292	1116	0.00264	0.00769	0.00101	114	114	114	0	0	1	-360	360;
	2069	1168	0.01405	0.02124	0.0037	77	77	77	0	0	1	-360	360;
	1799	1074	0.01273	0.03917	0.0045	114	114	114	0	0	1	-360	360;
	1210	1601	0.00215	0.01504	0.00164	152	152	152	0	0	1	-360	360;
	1514	1910	0.00769	0.02074	0.0022	102	102	102	0	0	1	-360	360;
	2043	1602	0.00264	0.01909	0.0019	152	152	152	0	0	1	-360	360;
	2044	1601	0.00264	0.01909	0.0019	152	152	152	0	0	1	-360	360;
	2115	1800	0.01512	0.0376	0.00401	102	102	102	0	0	1	-360	360;
	1128	1759	0.00893	0.02355	0.00319	102	102	102	0	0	1	-360	360;
	1292	1311	0.04124	0.07066	0.00857	77	77	77	0	0	1	-360	360;
	1622	1385	0.00521	0.01157	0.00259	114	114	114	0	0	1	-360	360;
	1289	1799	0.01521	0.04074	0.00426	102	102	102	0	0	1	-360	360;
	1841	1603	0.00471	0.01554	0.00157	119	119	119	0	0	1	-360	360;
	1682	1292	0.01091	0.0357	0.00362	114	114	114	0	0	1	-360	360;
	1751	1683	0.0319	0.10785	0.011	114	114	114	0	0	1	-360	360;
	1557	1603	0.00165	0.01132	0.00121	152	152	152	0	0	1	-360	360;
	1675	1530	0.00653	0.02116	0.00217	114	114	114	0	0	1	-360	360;
	1752	1531	0.02198	0.07174	0.00727	114	114	114	0	0	1	-360	360;
	2001	1916	0.04512	0.23744	0.02383	114	114	114	0	0	1	-360	360;
	2001	1910	0.0457	0.2405	0.0243	114	114	114	0	0	1	-360	360;
	1623	1380	0.00083	0.00248	0.00033	102	102	102	0	0	1	-360	360;
	1863	1211	0.0043	0.00719	0.01602	102	102	102	0	0	1	-360	360;
	2000	1402	0.0581	0.13339	0.01261	77	77	77	0	0	1	-360	360;
	1602	1781	0.00388	0.01273	0.00129	114	114	114	0	0	1	-360	360;
	1614	1799	0.0005	0.00314	0.03081	97	97	97	0	0	1	-360	360;
	1615	1800	0.0005	0.00322	0.03119	97	97	97	0	0	1	-360	360;
	1093	1115	0.00397	0.01174	0.00144	114	114	114	0	0	1	-360	360;
	1804	1623	0.01802	0.0514	0.00687	114	114	114	0	0	1	-360	360;
	2070	1691	0.01785	0.03372	0.005	77	77	77	0	0	1	-360	360;
	1760	1168	0.00678	0.01521	0.00235	102	102	102	0	0	1	-360	360;
	1528	1689	0.00678	0.02083	0.00898	97	97	97	0	0	1	-360	360;
	2078	2114	0.02008	0.05017	0.0053	102	102	102	0	0	1	-360	360;
	1211	1556	0.00058	0.00388	0.00044	152	152	152	0	0	1	-360	360;
	1533	1622	0.04446	0.10959	0.01193	102	102	102	0	0	1	-360	360;
	1674	1974	0.03273	0.10661	0.01082	114	114	114	0	0	1	-360	360;
	1293	1529	0.04942	0.16132	0.01634	114	114	114	0	0	1	-360	360;
	1222	1989	0.01174	0.03339	0.00449	114	114	114	0	0	1	-360	360;
	1499	1862	0.00264	0.00793	0.00093	119	119	119	0	0	1	-360	360;
	1964	1277	0.00273	0.00793	0.00103	57	57	57	0	0	1	-360	360;
	1463	1556	0.00074	0.00248	0.01641	81	81	81	0	0	1	-360	360;
	1464	1557	0.00074	0.00248	0.01641	81	81	81	0	0	1	-360	360;
	1381	2043	0.00091	0.00298	0.0003	114	114	114	0	0	1	-360	360;
	1382	2044	0.00091	0.00298	0.0003	114	114	114	0	0	1	-360	360;
	2014	1990	0.00942	0.02802	0.00346	114	114	114	0	0	1	-360	360;
	1991	1053	0.00157	0.00182	0.00039	77	77	77	0	0	1	-360	360;
	1990	1054	0.00149	0.00174	0.00037	77	77	77	0	0	1	-360	360;
	1991	1055	0.0005	0.00058	0.00012	77	77	77	0	0	1	-360	360;
	1991	1056	0.00107	0.00124	0.00027	77	77	77	0	0	1	-360	360;
	2015	1991	0.01116	0.02983	0.0036	102	102	102	0	0	1	-360	360;
	1144	2088	0.02314	0.02711	0.00583	77	77	77	0	0	1	-360	360;
	1478	1576	0.02215	0.03876	0.00878	102	102	102	0	0	1	-360	360;
	1084	1145	0.02083	0.02479	0.00517	77	77	77	0	0	1	-360	360;
	1224	1084	0.01851	0.05818	0.00631	77	77	77	0	0	1	-360	360;
	1082	1084	0.0005	0.00074	9e-05	77	77	77	0	0	1	-360	360;
	1990	1478	0.00694	0.01901	0.00195	102	102	102	0	0	1	-360	360;
	2010	1478	0.00686	0.0095	0.00185	77	77	77	0	0	1	-360	360;
	1337	2088	0.0005	0.00149	0.0002	57	57	57	0	0	1	-360	360;
	2014	1829	0.0057	0.01777	0.00198	114	114	114	0	0	1	-360	360;
	2014	1083	0.02124	0.06909	0.00708	77	77	77	0	0	1	-360	360;
	1968	1587	0.00256	0.00554	0.00084	57	57	57	0	0	1	-360	360;
	1969	1588	0.00198	0.00471	0.00069	57	57	57	0	0	1	-360	360;
	1338	2089	0.00058	0.00174	0.00023	57	57	57	0	0	1	-360	360;
	2089	1565	0.00512	0.01455	0.00197	114	114	114	0	0	1	-360	360;
	1701	1785	0.00364	0.01033	0.0014	114	114	114	0	0	1	-360	360;
	2015	1786	0.00595	0.01917	0.00201	114	114	114	0	0	1	-360	360;
	1468	1587	0.01	0.01562	0.00187	76	76	76	0	0	1	-360	360;
	1819	1467	0.02339	0.03066	0.00535	108	108	108	0	0	1	-360	360;
	1830	1304	0.00661	0.02058	0.00231	114	114	114	0	0	1	-360	360;
	1477	1809	0.00364	0.01041	0.0014	119	119	119	0	0	1	-360	360;
	1477	1687	0.00802	0.02273	0.00304	119	119	119	0	0	1	-360	360;
	1724	1686	0.01264	0.03446	0.00355	102	102	102	0	0	1	-360	360;
	1810	1303	0.00587	0.01669	0.00225	114	114	114	0	0	1	-360	360;
	1478	1889	0.02736	0.08909	0.00906	38	38	38	0	0	1	-360	360;
	1310	1725	0.00174	0.00479	0.0005	102	102	102	0	0	1	-360	360;
	1881	1310	0.02157	0.05752	0.0053	102	102	102	0	0	1	-360	360;
	1310	1309	0.00314	0.00364	0.00079	57	57	57	0	0	1	-360	360;
	2032	2014	0.0119	0.03752	0.00408	114	114	114	0	0	1	-360	360;
	1991	1477	0.00678	0.02074	0.00193	102	102	102	0	0	1	-360	360;
	1577	1587	0.02529	0.04355	0.01005	102	102	102	0	0	1	-360	360;
	2011	1700	0.00314	0.00893	0.0012	114	114	114	0	0	1	-360	360;
	1172	2015	0.0343	0.11	0.01158	114	114	114	0	0	1	-360	360;
	2015	1225	0.01455	0.04521	0.0051	114	114	114	0	0	1	-360	360;
	2014	1715	0.01959	0.06397	0.00647	119	119	119	0	0	1	-360	360;
	2064	1392	0.00355	0.01132	0.00123	114	114	114	0	0	1	-360	360;
	1501	1595	0.00198	0.00645	0.00065	114	114	114	0	0	1	-360	360;
	1586	1513	0.00091	0.00653	0.00065	152	152	152	0	0	1	-360	360;
	1854	1586	0.0043	0.03033	0.00319	152	152	152	0	0	1	-360	360;
	1584	1586	0.00314	0.00545	0.00053	72	72	72	0	0	1	-360	360;
	1825	1643	0.00959	0.02587	0.00288	97	97	97	0	0	1	-360	360;
	1121	1094	0.01041	0.02975	0.00393	114	114	114	0	0	1	-360	360;
	1855	2027	0.00264	0.00744	0.001	114	114	114	0	0	1	-360	360;
	1122	1095	0.01008	0.02884	0.00381	114	114	114	0	0	1	-360	360;
	1859	2094	0.01231	0.03215	0.00338	97	97	97	0	0	1	-360	360;
	1790	1679	0.0019	0.00612	0.00062	114	114	114	0	0	1	-360	360;
	1963	1790	0.00355	0.01165	0.00118	114	114	114	0	0	1	-360	360;
	1790	1788	0.00132	0.00322	0.00031	72	72	72	0	0	1	-360	360;
	1142	1258	0.00347	0.01124	0.00113	114	114	114	0	0	1	-360	360;
	1143	1259	0.00339	0.01116	0.00113	114	114	114	0	0	1	-360	360;
	2064	1606	0.00942	0.03008	0.00319	114	114	114	0	0	1	-360	360;
	1871	1699	0.00711	0.02074	0.00265	114	114	114	0	0	1	-360	360;
	1848	1871	0.00099	0.00289	0.00037	114	114	114	0	0	1	-360	360;
	1870	1871	0.00124	0.00347	0.00046	114	114	114	0	0	1	-360	360;
	1641	1201	0.00083	0.00231	0.00031	114	114	114	0	0	1	-360	360;
	1281	1283	0.00182	0.00512	0.00069	29	29	29	0	0	1	-360	360;
	1776	1428	0.00322	0.01025	0.00109	114	114	114	0	0	1	-360	360;
	1845	1776	0.00372	0.0114	0.00133	114	114	114	0	0	1	-360	360;
	1774	1776	0.0024	0.00719	0.00074	97	97	97	0	0	1	-360	360;
	1986	1200	0.01281	0.03661	0.00485	114	114	114	0	0	1	-360	360;
	2146	1512	0.01198	0.03917	0.00396	114	114	114	0	0	1	-360	360;
	1331	1272	0.00496	0.0162	0.00164	114	114	114	0	0	1	-360	360;
	1331	1273	0.00339	0.00959	0.00129	114	114	114	0	0	1	-360	360;
	1934	1192	0.00975	0.03083	0.00335	114	114	114	0	0	1	-360	360;
	1535	2003	0.00017	0.00058	6e-05	114	114	114	0	0	1	-360	360;
	1644	1535	0.00529	0.01645	0.00181	114	114	114	0	0	1	-360	360;
	1534	1535	0.00421	0.00711	0.00072	72	72	72	0	0	1	-360	360;
	1077	1767	0.01099	0.02496	0.00416	97	97	97	0	0	1	-360	360;
	1077	1983	0.00579	0.01802	0.00198	114	114	114	0	0	1	-360	360;
	1075	1077	0.00025	0.00074	0.0001	114	114	114	0	0	1	-360	360;
	1136	1331	0.00041	0.00132	0.00013	114	114	114	0	0	1	-360	360;
	1151	1136	0.00273	0.00785	0.00077	97	97	97	0	0	1	-360	360;
	1322	1151	0.00438	0.01438	0.00145	116	116	116	0	0	1	-360	360;
	1495	1322	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	1134	1136	0.00124	0.00364	0.00048	114	114	114	0	0	1	-360	360;
	1151	1150	0.00339	0.01107	0.00112	114	114	114	0	0	1	-360	360;
	1320	1322	0.00223	0.00678	0.00081	114	114	114	0	0	1	-360	360;
	2094	2061	0.0076	0.02306	0.00272	114	114	114	0	0	1	-360	360;
	1256	1481	0.00496	0.01413	0.0019	114	114	114	0	0	1	-360	360;
	1943	1808	0.00231	0.00744	0.00077	114	114	114	0	0	1	-360	360;
	1420	1869	0.00818	0.02017	0.00219	97	97	97	0	0	1	-360	360;
	2075	1420	0.00471	0.01182	0.00132	57	57	57	0	0	1	-360	360;
	1418	1420	0.00091	0.00215	0.00023	97	97	97	0	0	1	-360	360;
	1861	1061	0.00653	0.02058	0.00222	114	114	114	0	0	1	-360	360;
	2028	1507	0.01231	0.04033	0.00408	114	114	114	0	0	1	-360	360;
	1162	1859	0.02587	0.06818	0.00737	97	97	97	0	0	1	-360	360;
	1750	1189	0.00496	0.01496	0.00179	114	114	114	0	0	1	-360	360;
	1770	2131	0.0014	0.00322	0.00053	97	97	97	0	0	1	-360	360;
	2073	1452	0.00413	0.01289	0.00144	114	114	114	0	0	1	-360	360;
	2062	1899	0.0176	0.05686	0.00587	114	114	114	0	0	1	-360	360;
	1817	1143	0.00636	0.0205	0.00213	114	114	114	0	0	1	-360	360;
	1131	1767	0.0086	0.02802	0.00284	114	114	114	0	0	1	-360	360;
	2063	1768	0.0262	0.08496	0.00871	114	114	114	0	0	1	-360	360;
	1859	1574	0.01975	0.05372	0.00566	97	97	97	0	0	1	-360	360;
	2042	1574	0.0019	0.00595	0.00067	114	114	114	0	0	1	-360	360;
	1364	2042	0.00264	0.0086	0.0009	114	114	114	0	0	1	-360	360;
	2041	2042	8e-05	0.00017	2e-05	72	72	72	0	0	1	-360	360;
	1482	2064	0.01174	0.03537	0.00421	114	114	114	0	0	1	-360	360;
	1106	1231	0.00562	0.01736	0.00193	97	97	97	0	0	1	-360	360;
	2099	1209	0.00182	0.00587	0.00065	114	114	114	0	0	1	-360	360;
	1824	2099	0.0038	0.01215	0.00125	116	116	116	0	0	1	-360	360;
	1143	1824	0.00264	0.00818	0.00094	114	114	114	0	0	1	-360	360;
	2097	2099	8e-05	0.00017	2e-05	114	114	114	0	0	1	-360	360;
	1824	1823	0.00124	0.00364	0.00047	57	57	57	0	0	1	-360	360;
	1595	1703	0.0024	0.00727	0.00087	114	114	114	0	0	1	-360	360;
	2055	1155	0.00413	0.01355	0.00138	114	114	114	0	0	1	-360	360;
	1188	2055	0.00711	0.02322	0.00234	114	114	114	0	0	1	-360	360;
	2054	2055	0.00074	0.00231	0.00026	114	114	114	0	0	1	-360	360;
	2083	1221	0.00091	0.00273	0.00033	114	114	114	0	0	1	-360	360;
	1453	1221	0.00314	0.01355	0.00135	114	114	114	0	0	1	-360	360;
	1119	1453	0.00041	0.00124	0.00013	114	114	114	0	0	1	-360	360;
	1120	1454	0.00041	0.00132	0.00014	114	114	114	0	0	1	-360	360;
	1424	1220	0.00066	0.0024	0.00031	114	114	114	0	0	1	-360	360;
	1589	2112	0.01289	0.04099	0.00439	114	114	114	0	0	1	-360	360;
	1659	1748	0.01942	0.06355	0.00642	69	69	69	0	0	1	-360	360;
	1747	1767	0.02091	0.06826	0.00692	69	69	69	0	0	1	-360	360;
	2047	1644	0.00174	0.00504	0.00052	97	97	97	0	0	1	-360	360;
	1332	1181	0.0076	0.02281	0.00274	114	114	114	0	0	1	-360	360;
	1875	1512	0.00174	0.00504	0.00067	114	114	114	0	0	1	-360	360;
	1257	2135	0.00413	0.01182	0.00159	114	114	114	0	0	1	-360	360;
	1549	1068	0.01248	0.03967	0.00426	114	114	114	0	0	1	-360	360;
	1412	1275	0.00347	0.01008	0.00131	114	114	114	0	0	1	-360	360;
	1957	1412	0.00364	0.01174	0.00124	114	114	114	0	0	1	-360	360;
	1410	1412	0	0.00083	1e-05	114	114	114	0	0	1	-360	360;
	1738	2145	0.00471	0.01554	0.00157	114	114	114	0	0	1	-360	360;
	2004	1454	0.00446	0.01281	0.00175	114	114	114	0	0	1	-360	360;
	1590	1708	0.02769	0.07157	0.00735	97	97	97	0	0	1	-360	360;
	1067	1733	0.00083	0.00248	0.00032	114	114	114	0	0	1	-360	360;
	1068	1734	0.00083	0.00248	0.00033	114	114	114	0	0	1	-360	360;
	2094	2104	0.00554	0.01711	0.00194	114	114	114	0	0	1	-360	360;
	1814	1869	0.00612	0.01636	0.00185	97	97	97	0	0	1	-360	360;
	1729	1767	0.00314	0.00884	0.00119	114	114	114	0	0	1	-360	360;
	1069	1813	0.00074	0.00223	0.00027	114	114	114	0	0	1	-360	360;
	1070	1814	0.00066	0.00207	0.00025	114	114	114	0	0	1	-360	360;
	1305	1898	0.00033	0.00099	0.00013	114	114	114	0	0	1	-360	360;
	1306	1899	0.00033	0.00091	0.00012	114	114	114	0	0	1	-360	360;
	1505	1067	0.00033	0.00091	0.00012	114	114	114	0	0	1	-360	360;
	1506	1068	0.00041	0.00124	0.00016	114	114	114	0	0	1	-360	360;
	1959	1986	0.0043	0.01256	0.00157	114	114	114	0	0	1	-360	360;
	1250	1256	0.00017	0.0005	7e-05	114	114	114	0	0	1	-360	360;
	1251	1257	0.00017	0.00058	7e-05	114	114	114	0	0	1	-360	360;
	1243	1221	0.00066	0.00215	0.00022	114	114	114	0	0	1	-360	360;
	1244	1220	0.00066	0.00207	0.00021	114	114	114	0	0	1	-360	360;
	1453	1209	0.00355	0.01149	0.00116	114	114	114	0	0	1	-360	360;
	2023	2019	0.00413	0.01355	0.00136	114	114	114	0	0	1	-360	360;
	1717	1157	0.00479	0.01537	0.00163	114	114	114	0	0	1	-360	360;
	1566	2065	0.00149	0.00479	0.00048	114	114	114	0	0	1	-360	360;
	2149	1611	0.00091	0.00256	0.00033	114	114	114	0	0	1	-360	360;
	1451	2149	0.00463	0.01446	0.00163	114	114	114	0	0	1	-360	360;
	2147	2149	0	8e-05	0	114	114	114	0	0	1	-360	360;
	1142	1609	0.00488	0.01719	0.00191	114	114	114	0	0	1	-360	360;
	2216	2332	0.00064	0.00483	0.00047	123	123	123	0	0	1	-360	360;
	2543	2400	0.03347	0.05893	0.00578	90	90	90	0	0	1	-360	360;
	2680	2400	0.02959	0.05471	0.00503	90	90	90	0	0	1	-360	360;
	2680	2401	0.03306	0.0586	0.00557	90	90	90	0	0	1	-360	360;
	2507	2414	0.04802	0.10264	0.01344	63	63	63	0	0	1	-360	360;
	2414	2166	0.0138	0.02421	0.0023	63	63	63	0	0	1	-360	360;
	2220	2213	0.05636	0.10521	0.01021	90	90	90	0	0	1	-360	360;
	2618	2264	0.05893	0.12397	0.01197	90	90	90	0	0	1	-360	360;
	2215	2204	0.02174	0.05	0.00501	76	76	76	0	0	1	-360	360;
	2368	2204	0.03471	0.06744	0.00663	76	76	76	0	0	1	-360	360;
	2214	2161	0.01971	0.06676	0.00661	137	137	137	0	0	1	-360	360;
	2552	2168	0.02486	0.04348	0.00415	120	120	120	0	0	1	-360	360;
	2518	2206	0.02228	0.07545	0.00747	137	137	137	0	0	1	-360	360;
	2553	2211	0.02521	0.08264	0.00847	137	137	137	0	0	1	-360	360;
	2546	2583	0.02066	0.06686	0.00692	126	126	126	0	0	1	-360	360;
	2358	2407	0.05967	0.10455	0.00995	87	87	87	0	0	1	-360	360;
	2186	2691	0.02711	0.04612	0.00445	90	90	90	0	0	1	-360	360;
	2538	2691	0.03366	0.11402	0.01129	137	137	137	0	0	1	-360	360;
	2671	2427	0.02413	0.07851	0.0082	137	137	137	0	0	1	-360	360;
	2220	2218	0.01835	0.06256	0.00605	137	137	137	0	0	1	-360	360;
	2355	2458	0.02497	0.08457	0.00837	137	137	137	0	0	1	-360	360;
	2620	2541	0.02236	0.07573	0.0075	137	137	137	0	0	1	-360	360;
	2637	2450	0.01654	0.05601	0.00554	140	140	140	0	0	1	-360	360;
	2600	2637	0.02679	0.09072	0.00898	140	140	140	0	0	1	-360	360;
	2600	2235	0.01445	0.04894	0.00484	137	137	137	0	0	1	-360	360;
	2296	2637	0.02042	0.03616	0.00345	140	140	140	0	0	1	-360	360;
	2564	2438	0.03204	0.10852	0.01074	137	137	137	0	0	1	-360	360;
	2566	2478	0.01612	0.05281	0.00541	114	114	114	0	0	1	-360	360;
	2272	2522	0.0166	0.05623	0.00557	10	10	10	0	0	1	-360	360;
	2451	2363	0.10413	0.16851	0.01897	90	90	90	0	0	1	-360	360;
	2452	2636	0.03306	0.04959	0.00605	76	76	76	0	0	1	-360	360;
	2636	2305	0.1	0.16529	0.01822	76	76	76	0	0	1	-360	360;
	2381	2636	0.0157	0.04628	0.00501	76	76	76	0	0	1	-360	360;
	2437	2189	0.0338	0.05537	0.00595	67	67	67	0	0	1	-360	360;
	2437	2276	0.0157	0.04628	0.00501	69	69	69	0	0	1	-360	360;
	2364	2304	0.02893	0.04711	0.0053	90	90	90	0	0	1	-360	360;
	2633	2626	0.00055	0.00182	0.02683	118	118	118	0	0	1	-360	360;
	2560	2190	0.01198	0.04056	0.00401	137	137	137	0	0	1	-360	360;
	2504	2616	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	2505	2617	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	2614	2305	0.00331	0.00579	0.00061	90	90	90	0	0	1	-360	360;
	2627	2614	0.00992	0.02231	0.00242	90	90	90	0	0	1	-360	360;
	2616	2304	0.02562	0.0438	0.00455	90	90	90	0	0	1	-360	360;
	2616	2190	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	2626	2617	0.01818	0.03554	0.0039	90	90	90	0	0	1	-360	360;
	2617	2190	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	2657	2448	0.00877	0.02969	0.00294	137	137	137	0	0	1	-360	360;
	2560	2657	0.00445	0.01505	0.00149	137	137	137	0	0	1	-360	360;
	2625	2657	0.00497	0.01683	0.00167	137	137	137	0	0	1	-360	360;
	2500	2189	0.0157	0.04793	0.00515	137	137	137	0	0	1	-360	360;
	2500	2447	0.00744	0.02397	0.00257	137	137	137	0	0	1	-360	360;
	2634	2592	0.0157	0.02727	0.00264	137	137	137	0	0	1	-360	360;
	2624	2447	0.00744	0.02562	0.00278	137	137	137	0	0	1	-360	360;
	2624	2606	0.00165	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2634	2606	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2607	2448	0.00909	0.02975	0.00319	137	137	137	0	0	1	-360	360;
	2607	2593	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2434	2447	0.02314	0.05868	0.00574	120	120	120	0	0	1	-360	360;
	2570	2448	0.01372	0.04446	0.00439	137	137	137	0	0	1	-360	360;
	2438	2448	0.02231	0.07182	0.00702	137	137	137	0	0	1	-360	360;
	2658	2448	0.02489	0.08432	0.00835	120	120	120	0	0	1	-360	360;
	2604	2658	0.01362	0.04612	0.00457	120	120	120	0	0	1	-360	360;
	2516	2447	0.0295	0.0999	0.00989	137	137	137	0	0	1	-360	360;
	2276	2410	0.00752	0.01256	0.0013	57	57	57	0	0	1	-360	360;
	2570	2407	0.06215	0.10504	0.01058	90	90	90	0	0	1	-360	360;
	2683	2434	0.03967	0.06942	0.00666	90	90	90	0	0	1	-360	360;
	2632	2592	0.00496	0.0157	0.0008	90	90	90	0	0	1	-360	360;
	2646	2190	0.01438	0.02405	0.00249	90	90	90	0	0	1	-360	360;
	2438	2646	0.03876	0.06463	0.00668	90	90	90	0	0	1	-360	360;
	2646	2409	0.01165	0.02124	0.00221	90	90	90	0	0	1	-360	360;
	2270	2305	0.01157	0.01983	0.00194	90	90	90	0	0	1	-360	360;
	2270	2593	0.00794	0.01591	0.00153	90	90	90	0	0	1	-360	360;
	2613	2304	0.00331	0.00579	0.00055	90	90	90	0	0	1	-360	360;
	2613	2460	0.00909	0.01736	0.00165	90	90	90	0	0	1	-360	360;
	2631	2305	0.01157	0.01893	0.00201	90	90	90	0	0	1	-360	360;
	2632	2304	0.01157	0.01893	0.00191	90	90	90	0	0	1	-360	360;
	2632	2269	0.00083	0.00248	0.00027	90	90	90	0	0	1	-360	360;
	2612	2592	0.01523	0.0484	0.00476	137	137	137	0	0	1	-360	360;
	2609	2593	0.01157	0.03636	0.00399	120	120	120	0	0	1	-360	360;
	2608	2611	0.00707	0.02395	0.00237	137	137	137	0	0	1	-360	360;
	2609	2545	0.02562	0.08264	0.00854	137	137	137	0	0	1	-360	360;
	2545	2499	0.02149	0.06942	0.00711	120	120	120	0	0	1	-360	360;
	2459	2592	0.00992	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2631	2608	0.01983	0.0338	0.00329	90	90	90	0	0	1	-360	360;
	2305	2189	0.02561	0.04415	0.00429	90	90	90	0	0	1	-360	360;
	2660	2304	0.01774	0.0304	0.00298	90	90	90	0	0	1	-360	360;
	2162	2305	0.005	0.00879	0.00084	90	90	90	0	0	1	-360	360;
	2692	2536	0.0281	0.04876	0.00477	90	90	90	0	0	1	-360	360;
	2162	2692	0.023	0.04027	0.00384	90	90	90	0	0	1	-360	360;
	2583	2438	0.02546	0.08496	0.00635	137	137	137	0	0	1	-360	360;
	2253	2377	0.03771	0.12774	0.01265	137	137	137	0	0	1	-360	360;
	2458	2253	0.02896	0.10088	0.00999	137	137	137	0	0	1	-360	360;
	2481	2473	0.08066	0.14207	0.01348	120	120	120	0	0	1	-360	360;
	2610	2220	0.04116	0.10446	0.01043	120	120	120	0	0	1	-360	360;
	2684	2610	0.05808	0.10375	0.00991	90	90	90	0	0	1	-360	360;
	2620	2422	0.02504	0.04289	0.00428	120	120	120	0	0	1	-360	360;
	2569	2540	0.01661	0.0538	0.00557	91	91	91	0	0	1	-360	360;
	2209	2572	0.0157	0.05157	0.00528	137	137	137	0	0	1	-360	360;
	2572	2468	0.02479	0.08132	0.00834	120	120	120	0	0	1	-360	360;
	2645	2377	0.03891	0.06806	0.00649	90	90	90	0	0	1	-360	360;
	2645	2619	0.00102	0.00347	0.00034	90	90	90	0	0	1	-360	360;
	2645	2238	0.03237	0.05888	0.00583	90	90	90	0	0	1	-360	360;
	2417	2227	0.00292	0.00988	0.00098	120	120	120	0	0	1	-360	360;
	2226	2208	0.00603	0.01785	0.00183	120	120	120	0	0	1	-360	360;
	2587	2237	0.04207	0.14132	0.01394	120	120	120	0	0	1	-360	360;
	2587	2192	0.02992	0.10136	0.01003	120	120	120	0	0	1	-360	360;
	2192	2469	0.01165	0.03957	0.00392	91	91	91	0	0	1	-360	360;
	2172	2462	0.00372	0.01248	0.00116	120	120	120	0	0	1	-360	360;
	2198	2207	0.00537	0.01512	0.00153	120	120	120	0	0	1	-360	360;
	2590	2496	0.00413	0.01405	0.00138	137	137	137	0	0	1	-360	360;
	2198	2227	0.00074	0.00231	0.00024	137	137	137	0	0	1	-360	360;
	2673	2501	0.00711	0.01942	0.00201	120	120	120	0	0	1	-360	360;
	2155	2226	0.00499	0.01691	0.00147	137	137	137	0	0	1	-360	360;
	2649	2468	0.01917	0.06388	0.00598	137	137	137	0	0	1	-360	360;
	2649	2494	0.0038	0.01264	0.00119	137	137	137	0	0	1	-360	360;
	2649	2466	0.00116	0.0038	0.00038	137	137	137	0	0	1	-360	360;
	2682	2284	0.01455	0.05314	0.00523	120	120	120	0	0	1	-360	360;
	2406	2630	0.02008	0.06818	0.00674	10	10	10	0	0	1	-360	360;
	2436	2284	0.01711	0.05769	0.00567	137	137	137	0	0	1	-360	360;
	2539	2377	0.03196	0.05589	0.00533	90	90	90	0	0	1	-360	360;
	2539	2295	0.01848	0.03232	0.00308	90	90	90	0	0	1	-360	360;
	2295	2271	0.02901	0.05165	0.00489	90	90	90	0	0	1	-360	360;
	2413	2271	0.01661	0.0295	0.00288	90	90	90	0	0	1	-360	360;
	2494	2463	0.00793	0.02678	0.00264	137	137	137	0	0	1	-360	360;
	2466	2463	0.00864	0.0173	0.00166	90	90	90	0	0	1	-360	360;
	2433	2165	0.0376	0.0676	0.00651	90	90	90	0	0	1	-360	360;
	2467	2300	0.01413	0.04628	0.00475	137	137	137	0	0	1	-360	360;
	2439	2245	0.01	0.03479	0.00317	120	120	120	0	0	1	-360	360;
	2673	2155	0.0061	0.02065	0.00204	137	137	137	0	0	1	-360	360;
	2384	2175	0.02213	0.07514	0.00742	91	91	91	0	0	1	-360	360;
	2508	2175	0.04678	0.05793	0.00462	91	91	91	0	0	1	-360	360;
	2544	2542	0.05388	0.0943	0.00898	90	90	90	0	0	1	-360	360;
	2427	2245	0.0414	0.08355	0.00786	90	90	90	0	0	1	-360	360;
	2490	2461	0.00968	0.03279	0.00325	137	137	137	0	0	1	-360	360;
	2379	2377	0.00033	0.00041	0	78	78	78	0	0	1	-360	360;
	2164	2208	0.01165	0.03463	0.00356	90	90	90	0	0	1	-360	360;
	2484	2208	0.02204	0.07467	0.00739	91	91	91	0	0	1	-360	360;
	2228	2484	0.01214	0.04112	0.00407	91	91	91	0	0	1	-360	360;
	2554	2422	0.04033	0.06893	0.00692	91	91	91	0	0	1	-360	360;
	2610	2481	0.03364	0.08545	0.00874	91	91	91	0	0	1	-360	360;
	2651	2468	0.01669	0.03529	0.00341	90	90	90	0	0	1	-360	360;
	2651	2603	0.0576	0.12215	0.01179	90	90	90	0	0	1	-360	360;
	2610	2540	0.03529	0.06033	0.00605	90	90	90	0	0	1	-360	360;
	2260	2377	0.06808	0.1244	0.01294	90	90	90	0	0	1	-360	360;
	2542	2260	0.0043	0.01028	0.00143	90	90	90	0	0	1	-360	360;
	2300	2472	0.01612	0.05405	0.00532	120	120	120	0	0	1	-360	360;
	2620	2397	0.03967	0.06934	0.00663	90	90	90	0	0	1	-360	360;
	2528	2472	0.02397	0.04223	0.00414	90	90	90	0	0	1	-360	360;
	2528	2295	0.04645	0.08174	0.00801	69	69	69	0	0	1	-360	360;
	2185	2473	0.02276	0.0771	0.00763	120	120	120	0	0	1	-360	360;
	2554	2419	0.01124	0.03818	0.00378	120	120	120	0	0	1	-360	360;
	2543	2481	0.02347	0.05785	0.00593	91	91	91	0	0	1	-360	360;
	2466	2469	0.00983	0.03322	0.00328	137	137	137	0	0	1	-360	360;
	2228	2237	0.01393	0.04721	0.00467	91	91	91	0	0	1	-360	360;
	2235	2236	0.00688	0.02328	0.0023	120	120	120	0	0	1	-360	360;
	2544	2397	0.0343	0.06	0.00574	90	90	90	0	0	1	-360	360;
	2384	2377	0.00389	0.01322	0.0013	69	69	69	0	0	1	-360	360;
	2682	2469	0.0605	0.11818	0.01159	90	90	90	0	0	1	-360	360;
	2527	2300	0.00615	0.02083	0.00206	91	91	91	0	0	1	-360	360;
	2569	2527	0.00759	0.02569	0.00254	91	91	91	0	0	1	-360	360;
	2485	2226	0.00519	0.01413	0.00143	120	120	120	0	0	1	-360	360;
	2603	2405	0.06744	0.11802	0.01126	10	10	10	0	0	1	-360	360;
	2185	2439	0.01452	0.04917	0.00487	137	137	137	0	0	1	-360	360;
	2485	2418	0.00182	0.00455	0.00046	91	91	91	0	0	1	-360	360;
	2461	2227	0.00259	0.00876	0.00087	137	137	137	0	0	1	-360	360;
	2467	2491	0.0019	0.00603	0.00061	137	137	137	0	0	1	-360	360;
	2462	2357	0.00174	0.00479	0.00048	120	120	120	0	0	1	-360	360;
	2467	2207	0.00686	0.02198	0.00228	137	137	137	0	0	1	-360	360;
	2514	2433	0.01702	0.05512	0.00571	137	137	137	0	0	1	-360	360;
	2501	2492	0.01028	0.02164	0.0021	90	90	90	0	0	1	-360	360;
	2554	2226	0.01126	0.03814	0.00378	91	91	91	0	0	1	-360	360;
	2652	2490	0.00303	0.01029	0.00102	120	120	120	0	0	1	-360	360;
	2172	2652	0.00617	0.01736	0.00174	120	120	120	0	0	1	-360	360;
	2230	2473	0.00731	0.01279	0.00122	90	90	90	0	0	1	-360	360;
	2495	2472	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	2496	2473	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	2388	2472	0.01344	0.02383	0.00227	90	90	90	0	0	1	-360	360;
	2388	2493	0.00698	0.01279	0.00098	90	90	90	0	0	1	-360	360;
	2280	2473	0.00574	0.01944	0.00192	137	137	137	0	0	1	-360	360;
	2491	2420	0.00339	0.01099	0.00114	137	137	137	0	0	1	-360	360;
	2420	2227	0.00281	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	2419	2493	0.01475	0.04998	0.00495	90	90	90	0	0	1	-360	360;
	2590	2491	0.00405	0.01339	0.00138	137	137	137	0	0	1	-360	360;
	2684	2209	0.01031	0.01797	0.00171	90	90	90	0	0	1	-360	360;
	2278	2495	0.00202	0.00325	0.02903	90	90	90	0	0	1	-360	360;
	2587	2514	0.0395	0.07231	0.00728	90	90	90	0	0	1	-360	360;
	2485	2205	0.00165	0.00537	0.00055	137	137	137	0	0	1	-360	360;
	2590	2205	0.00182	0.00595	0.00063	137	137	137	0	0	1	-360	360;
	2408	2490	0.00033	0.00041	0	78	78	78	0	0	1	-360	360;
	2357	2280	0.00405	0.01331	0.00138	137	137	137	0	0	1	-360	360;
	2231	2493	0.02035	0.03558	0.0034	90	90	90	0	0	1	-360	360;
	2413	2492	0.02272	0.03973	0.00379	90	90	90	0	0	1	-360	360;
	2681	2152	0.00129	0.00374	0.00038	114	114	114	0	0	1	-360	360;
	2191	2681	0.02833	0.07349	0.00745	108	108	108	0	0	1	-360	360;
	2191	2291	0.02967	0.07661	0.00777	108	108	108	0	0	1	-360	360;
	2564	2301	0.02826	0.0957	0.00947	137	137	137	0	0	1	-360	360;
	2446	2244	0.01729	0.05855	0.0058	137	137	137	0	0	1	-360	360;
	2639	2292	0.00702	0.01752	0.00078	126	126	126	0	0	1	-360	360;
	2639	2443	0.02388	0.06711	0.00621	126	126	126	0	0	1	-360	360;
	2639	2370	0.00355	0.00959	0.0008	126	126	126	0	0	1	-360	360;
	2244	2444	0.02737	0.09213	0.00912	140	140	140	0	0	1	-360	360;
	2446	2301	0.01792	0.06144	0.00601	137	137	137	0	0	1	-360	360;
	2358	2444	0.03793	0.09752	0.00999	137	137	137	0	0	1	-360	360;
	2429	2319	0.01322	0.03289	0.00347	114	114	114	0	0	1	-360	360;
	2571	2153	0.00504	0.01413	0.00145	108	108	108	0	0	1	-360	360;
	2389	2679	0.03744	0.09653	0.00989	108	108	108	0	0	1	-360	360;
	2389	2283	0.02017	0.04959	0.00508	108	108	108	0	0	1	-360	360;
	2313	2282	0.01529	0.04967	0.00518	91	91	91	0	0	1	-360	360;
	2196	2320	0.03331	0.07982	0.00783	108	108	108	0	0	1	-360	360;
	2638	2449	0.03814	0.06671	0.00636	81	81	81	0	0	1	-360	360;
	2297	2638	0.00069	0.00235	0.00023	81	81	81	0	0	1	-360	360;
	2317	2638	8e-05	0.00014	1e-05	81	81	81	0	0	1	-360	360;
	2281	2450	0.01364	0.0238	0.00227	69	69	69	0	0	1	-360	360;
	2294	2450	0.00868	0.01512	0.00145	69	69	69	0	0	1	-360	360;
	2450	2320	0.00537	0.01545	0.00181	204	204	204	0	0	1	-360	360;
	2323	2282	0.02843	0.05207	0.00498	87	87	87	0	0	1	-360	360;
	2503	2323	0.02843	0.05207	0.00498	87	87	87	0	0	1	-360	360;
	2440	2444	0.00388	0.00669	0.00063	87	87	87	0	0	1	-360	360;
	2442	2443	0.0076	0.01802	0.00179	87	87	87	0	0	1	-360	360;
	2541	2196	0.01169	0.03957	0.00392	137	137	137	0	0	1	-360	360;
	2589	2449	0.00397	0.02917	0.00283	274	274	274	0	0	1	-360	360;
	2588	2267	0.00099	0.00793	0.00077	171	171	171	0	0	1	-360	360;
	2374	2156	0.03397	0.0862	0.00875	120	120	120	0	0	1	-360	360;
	2267	2321	0.0005	0.00397	0.00056	160	160	160	0	0	1	-360	360;
	2154	2152	0.01627	0.02831	0.0027	69	69	69	0	0	1	-360	360;
	2329	2310	0.00909	0.02645	0.00269	111	111	111	0	0	1	-360	360;
	2318	2152	0.03198	0.08107	0.00828	111	111	111	0	0	1	-360	360;
	2365	2318	0.00692	0.01922	0.00194	111	111	111	0	0	1	-360	360;
	2289	2291	0.00504	0.01421	0.0015	114	114	114	0	0	1	-360	360;
	2158	2365	0.01395	0.03998	0.00401	111	111	111	0	0	1	-360	360;
	2329	2158	0.01657	0.0489	0.0049	111	111	111	0	0	1	-360	360;
	2283	2282	0.0038	0.01215	0.00123	119	119	119	0	0	1	-360	360;
	2435	2444	0.01793	0.05818	0.00603	126	126	126	0	0	1	-360	360;
	2503	2443	0.06438	0.1138	0.01096	81	81	81	0	0	1	-360	360;
	2358	2356	0.0024	0.00413	0.00039	90	90	90	0	0	1	-360	360;
	2285	2153	0.01471	0.03736	0.00382	102	102	102	0	0	1	-360	360;
	2347	2285	0.02504	0.06364	0.00724	102	102	102	0	0	1	-360	360;
	2442	2441	0.01661	0.02917	0.00278	77	77	77	0	0	1	-360	360;
	2546	2435	0.01438	0.04653	0.00481	126	126	126	0	0	1	-360	360;
	2594	2429	0.03669	0.0943	0.00985	102	102	102	0	0	1	-360	360;
	2615	2302	0.02983	0.05463	0.00552	87	87	87	0	0	1	-360	360;
	2369	2212	0.00302	0.01	0.00102	126	126	126	0	0	1	-360	360;
	2293	2212	0.00161	0.00529	0.00054	126	126	126	0	0	1	-360	360;
	2293	2289	0.01645	0.04298	0.00443	114	114	114	0	0	1	-360	360;
	2455	2319	0.01033	0.03405	0.00348	114	114	114	0	0	1	-360	360;
	2594	2571	0.02289	0.06215	0.00636	102	102	102	0	0	1	-360	360;
	2356	2314	0.01752	0.05438	0.00564	91	91	91	0	0	1	-360	360;
	2511	2455	0.01463	0.04793	0.00491	126	126	126	0	0	1	-360	360;
	2563	2511	0.02207	0.07149	0.00747	126	126	126	0	0	1	-360	360;
	2563	2293	0.0176	0.05694	0.00575	126	126	126	0	0	1	-360	360;
	2534	2319	0.01603	0.04074	0.00411	120	120	120	0	0	1	-360	360;
	2421	2319	0.00975	0.03207	0.00329	108	108	108	0	0	1	-360	360;
	2679	2421	0.03488	0.09488	0.00972	108	108	108	0	0	1	-360	360;
	2358	2355	0.00653	0.02207	0.00216	91	91	91	0	0	1	-360	360;
	2534	2374	0.01355	0.03446	0.0035	120	120	120	0	0	1	-360	360;
	2368	2213	0.04669	0.09545	0.00939	76	76	76	0	0	1	-360	360;
	2350	2214	0.03397	0.05942	0.00567	90	90	90	0	0	1	-360	360;
	2532	2239	0.02736	0.09182	0.00907	90	90	90	0	0	1	-360	360;
	2551	2240	0.02719	0.08793	0.0091	137	137	137	0	0	1	-360	360;
	2350	2257	0.02967	0.04926	0.00486	90	90	90	0	0	1	-360	360;
	2551	2218	0.02521	0.08182	0.00917	137	137	137	0	0	1	-360	360;
	2647	2275	0.05945	0.10398	0.00992	76	76	76	0	0	1	-360	360;
	2166	2647	0.01877	0.03282	0.00313	76	76	76	0	0	1	-360	360;
	2415	2647	0.02111	0.0715	0.00708	76	76	76	0	0	1	-360	360;
	2644	2239	0.02473	0.054	0.00523	90	90	90	0	0	1	-360	360;
	2553	2644	0.05383	0.11001	0.01061	90	90	90	0	0	1	-360	360;
	2391	2644	0.00257	0.00449	0.00043	90	90	90	0	0	1	-360	360;
	2275	2239	0.0014	0.00463	0.00046	76	76	76	0	0	1	-360	360;
	2519	2518	0.02661	0.08661	0.00899	137	137	137	0	0	1	-360	360;
	2532	2401	0.02198	0.0738	0.00736	90	90	90	0	0	1	-360	360;
	2643	2240	0.03224	0.06998	0.00678	90	90	90	0	0	1	-360	360;
	2643	2623	0.06617	0.11573	0.01104	90	90	90	0	0	1	-360	360;
	2659	2350	0.0165	0.05588	0.00553	90	90	90	0	0	1	-360	360;
	2390	2643	0.00198	0.00345	0.00033	90	90	90	0	0	1	-360	360;
	2623	2659	0.01442	0.02521	0.00241	90	90	90	0	0	1	-360	360;
	2519	2257	0.03149	0.05215	0.00515	76	76	76	0	0	1	-360	360;
	2252	2239	0.0104	0.03704	0.00282	90	90	90	0	0	1	-360	360;
	2250	2252	0.00375	0.00656	0.00063	90	90	90	0	0	1	-360	360;
	2256	2240	0.00415	0.00726	0.00069	90	90	90	0	0	1	-360	360;
	2243	2256	0.00652	0.0114	0.00109	90	90	90	0	0	1	-360	360;
	2210	2411	0.01983	0.05504	0.00595	76	76	76	0	0	1	-360	360;
	2655	2565	0.01093	0.03048	0.00307	120	120	120	0	0	1	-360	360;
	2210	2655	0.00375	0.01025	0.00103	120	120	120	0	0	1	-360	360;
	2672	2655	0.00383	0.00669	0.00064	120	120	120	0	0	1	-360	360;
	2693	2489	0.01173	0.03052	0.00303	90	90	90	0	0	1	-360	360;
	2693	2412	0.04023	0.10277	0.01021	90	90	90	0	0	1	-360	360;
	2562	2412	0.0286	0.05322	0.00515	76	76	76	0	0	1	-360	360;
	2184	2216	9e-05	0.00069	7e-05	137	137	137	0	0	1	-360	360;
	2247	2184	0.00555	0.01818	0.00186	137	137	137	0	0	1	-360	360;
	2488	2233	0.0256	0.0784	0.00806	90	90	90	0	0	1	-360	360;
	2255	2489	0.00661	0.01826	0.00194	120	120	120	0	0	1	-360	360;
	2567	2233	0.0096	0.02474	0.00251	69	69	69	0	0	1	-360	360;
	2530	2233	0.00628	0.01058	0.00108	90	90	90	0	0	1	-360	360;
	2674	2234	0.01777	0.03157	0.00301	90	90	90	0	0	1	-360	360;
	2395	2412	0.02706	0.09164	0.00907	90	90	90	0	0	1	-360	360;
	2430	2395	0.02078	0.03802	0.00364	90	90	90	0	0	1	-360	360;
	2430	2229	0.04152	0.07429	0.0071	76	76	76	0	0	1	-360	360;
	2229	2512	0.05017	0.08774	0.00837	90	90	90	0	0	1	-360	360;
	2562	2215	0.04463	0.09421	0.00963	90	90	90	0	0	1	-360	360;
	2622	2512	0.02479	0.08041	0.00832	76	76	76	0	0	1	-360	360;
	2399	2512	0.03769	0.06554	0.00624	90	90	90	0	0	1	-360	360;
	2399	2241	0.06537	0.11488	0.01096	90	90	90	0	0	1	-360	360;
	2247	2210	0.02058	0.0676	0.00569	137	137	137	0	0	1	-360	360;
	2664	2480	0.01314	0.02554	0.00246	90	90	90	0	0	1	-360	360;
	2424	2568	0.01947	0.06595	0.00653	34	34	34	0	0	1	-360	360;
	2591	2193	0.02182	0.07107	0.00737	120	120	120	0	0	1	-360	360;
	2582	2489	0.00486	0.01645	0.00163	120	120	120	0	0	1	-360	360;
	2163	2488	0.00228	0.00772	0.00076	120	120	120	0	0	1	-360	360;
	2416	2513	0.02306	0.05736	0.00587	76	76	76	0	0	1	-360	360;
	2371	2234	0.00389	0.01319	0.00131	120	120	120	0	0	1	-360	360;
	2163	2371	0.01011	0.03425	0.00339	137	137	137	0	0	1	-360	360;
	2425	2233	0.0078	0.02641	0.00262	120	120	120	0	0	1	-360	360;
	2582	2425	0.00317	0.01073	0.00106	120	120	120	0	0	1	-360	360;
	2565	2488	0.00595	0.02016	0.002	76	76	76	0	0	1	-360	360;
	2479	2255	0.01289	0.03372	0.00333	120	120	120	0	0	1	-360	360;
	2315	2513	0.03397	0.0581	0.00559	82	82	82	0	0	1	-360	360;
	2315	2232	0.06926	0.12157	0.01174	90	90	90	0	0	1	-360	360;
	2664	2241	0.03983	0.06967	0.00666	90	90	90	0	0	1	-360	360;
	2622	2558	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	2561	2559	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	2568	2232	0.01818	0.05884	0.00612	120	120	120	0	0	1	-360	360;
	2480	2210	0.00926	0.0186	0.00181	76	76	76	0	0	1	-360	360;
	2507	2411	0.06942	0.1405	0.01368	63	63	63	0	0	1	-360	360;
	2561	2416	0.01107	0.02744	0.00281	120	120	120	0	0	1	-360	360;
	2591	2216	0.01289	0.04198	0.00436	120	120	120	0	0	1	-360	360;
	2529	2398	0.00802	0.02174	0.0022	90	90	90	0	0	1	-360	360;
	2398	2234	0.00843	0.02298	0.00232	90	90	90	0	0	1	-360	360;
	2385	2411	0.02264	0.07355	0.00762	120	120	120	0	0	1	-360	360;
	2193	2161	0.0318	0.07979	0.00779	120	120	120	0	0	1	-360	360;
	2195	2412	0.05033	0.13388	0.01203	72	72	72	0	0	1	-360	360;
	2595	2195	0.02851	0.09843	0.00896	120	120	120	0	0	1	-360	360;
	2513	2411	0.0343	0.24545	0.02408	120	120	120	0	0	1	-360	360;
	2674	2479	0.00818	0.02149	0.00212	120	120	120	0	0	1	-360	360;
	2375	2668	0.04876	0.06942	0.01254	120	120	120	0	0	1	-360	360;
	2506	2669	0.01979	0.03629	0.00348	90	90	90	0	0	1	-360	360;
	2635	2669	0.02364	0.05992	0.00618	120	120	120	0	0	1	-360	360;
	2656	2225	0.00044	0.00112	0.00011	90	90	90	0	0	1	-360	360;
	2635	2656	0.00246	0.00659	0.00067	90	90	90	0	0	1	-360	360;
	2170	2635	0.00405	0.01306	0.00136	120	120	120	0	0	1	-360	360;
	2666	2669	0.02231	0.07557	0.00748	137	137	137	0	0	1	-360	360;
	2536	2668	0.02835	0.09504	0.00937	137	137	137	0	0	1	-360	360;
	2431	2668	0.03025	0.10165	0.01002	120	120	120	0	0	1	-360	360;
	2686	2557	0.0157	0.02727	0.00286	69	69	69	0	0	1	-360	360;
	2586	2464	0.01201	0.02671	0.00259	120	120	120	0	0	1	-360	360;
	2585	2556	0.01127	0.02548	0.00247	90	90	90	0	0	1	-360	360;
	2537	2556	0.0081	0.02742	0.00272	120	120	120	0	0	1	-360	360;
	2549	2556	0.02975	0.04207	0.00404	69	69	69	0	0	1	-360	360;
	2502	2557	0.04959	0.08678	0.009	69	69	69	0	0	1	-360	360;
	2502	2452	0.04207	0.07025	0.00733	69	69	69	0	0	1	-360	360;
	2170	2557	0.03898	0.10313	0.01043	120	120	120	0	0	1	-360	360;
	2525	2556	0.01467	0.0404	0.00628	120	120	120	0	0	1	-360	360;
	2549	2286	0.05124	0.08182	0.00949	90	90	90	0	0	1	-360	360;
	2159	2173	0.00661	0.01983	0.0023	137	137	137	0	0	1	-360	360;
	2456	2556	0.01405	0.02727	0.00278	90	90	90	0	0	1	-360	360;
	2456	2174	0.02479	0.04298	0.00423	90	90	90	0	0	1	-360	360;
	2394	2173	0.03223	0.05537	0.00307	90	90	90	0	0	1	-360	360;
	2159	2557	0.01762	0.04135	0.00402	90	90	90	0	0	1	-360	360;
	2464	2174	0.01135	0.03509	0.00346	137	137	137	0	0	1	-360	360;
	2597	2174	0.00992	0.02066	0.00218	91	91	91	0	0	1	-360	360;
	2290	2174	0.01753	0.05936	0.00588	137	137	137	0	0	1	-360	360;
	2517	2597	0.00992	0.02314	0.00261	91	91	91	0	0	1	-360	360;
	2517	2432	0.0338	0.08099	0.00927	91	91	91	0	0	1	-360	360;
	2533	2248	0.0281	0.08926	0.00924	114	114	114	0	0	1	-360	360;
	2396	2248	0.01405	0.04463	0.0046	120	120	120	0	0	1	-360	360;
	2533	2432	0.01818	0.04132	0.00465	114	114	114	0	0	1	-360	360;
	2396	2173	0.01157	0.0281	0.00286	120	120	120	0	0	1	-360	360;
	2533	2298	0.02479	0.03471	0.00419	90	90	90	0	0	1	-360	360;
	2187	2299	0.03793	0.06612	0.00641	90	90	90	0	0	1	-360	360;
	2221	2299	0.03853	0.06806	0.0065	90	90	90	0	0	1	-360	360;
	2360	2221	0.02515	0.0455	0.00437	120	120	120	0	0	1	-360	360;
	2375	2187	0.01405	0.04463	0.00484	120	120	120	0	0	1	-360	360;
	2584	2656	0.00775	0.02625	0.0026	90	90	90	0	0	1	-360	360;
	2273	2537	0.00826	0.01653	0.00194	120	120	120	0	0	1	-360	360;
	2224	2525	0.03764	0.09704	0.00984	120	120	120	0	0	1	-360	360;
	2272	2687	0.01676	0.05678	0.00562	120	120	120	0	0	1	-360	360;
	2367	2669	0.01335	0.0452	0.00447	120	120	120	0	0	1	-360	360;
	2678	2403	0.01317	0.0446	0.00442	137	137	137	0	0	1	-360	360;
	2628	2168	0.02744	0.10017	0.00953	90	90	90	0	0	1	-360	360;
	2629	2203	0.0062	0.02008	0.00293	90	90	90	0	0	1	-360	360;
	2169	2403	0.05489	0.14743	0.01489	120	120	120	0	0	1	-360	360;
	2167	2404	0.04902	0.12753	0.01292	120	120	120	0	0	1	-360	360;
	2580	2403	0.00514	0.03512	0.0079	229	229	229	0	0	1	-360	360;
	2581	2404	0.00514	0.03512	0.0079	229	229	229	0	0	1	-360	360;
	2372	2403	0.03223	0.07769	0.0044	137	137	137	0	0	1	-360	360;
	2182	2404	0.02727	0.0686	0.00666	120	120	120	0	0	1	-360	360;
	2576	2574	0.00331	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2573	2581	0.00413	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	2576	2580	0.00413	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2577	2580	0.00413	0.01074	0.00099	137	137	137	0	0	1	-360	360;
	2577	2575	0.00413	0.01157	0.00104	137	137	137	0	0	1	-360	360;
	2335	2169	0.01074	0.03471	0.00356	114	114	114	0	0	1	-360	360;
	2602	2167	0.00945	0.02846	0.0028	90	90	90	0	0	1	-360	360;
	2601	2169	0.00451	0.01529	0.00151	137	137	137	0	0	1	-360	360;
	2169	2168	0.0065	0.02202	0.00218	120	120	120	0	0	1	-360	360;
	2483	2203	0.01319	0.04467	0.00442	137	137	137	0	0	1	-360	360;
	2678	2483	0.0126	0.04265	0.00422	137	137	137	0	0	1	-360	360;
	2393	2372	0.02562	0.07851	0.00842	137	137	137	0	0	1	-360	360;
	2510	2393	0.0124	0.04132	0.00419	120	120	120	0	0	1	-360	360;
	2183	2199	0.03669	0.09165	0.0094	120	120	120	0	0	1	-360	360;
	2598	2288	0.00661	0.0157	0.00165	120	120	120	0	0	1	-360	360;
	2287	2199	0.00592	0.01857	0.00199	90	90	90	0	0	1	-360	360;
	2598	2199	0.00157	0.00512	0.00053	120	120	120	0	0	1	-360	360;
	2599	2199	0.00153	0.00493	0.0005	120	120	120	0	0	1	-360	360;
	2287	2279	0.00579	0.01322	0.00138	90	90	90	0	0	1	-360	360;
	2324	2199	0.02719	0.04917	0.00478	90	90	90	0	0	1	-360	360;
	2453	2199	0.0129	0.02274	0.0022	90	90	90	0	0	1	-360	360;
	2454	2199	0.01204	0.02472	0.00244	90	90	90	0	0	1	-360	360;
	2402	2279	0.02893	0.05124	0.00469	90	90	90	0	0	1	-360	360;
	2402	2394	0.0157	0.02727	0.00252	90	90	90	0	0	1	-360	360;
	2324	2290	0.01893	0.0595	0.00656	120	120	120	0	0	1	-360	360;
	2394	2290	0.01405	0.02314	0.00232	90	90	90	0	0	1	-360	360;
	2373	2290	0.009	0.03048	0.00302	69	69	69	0	0	1	-360	360;
	2576	2579	0.00909	0.0314	0.00327	137	137	137	0	0	1	-360	360;
	2577	2578	0.0124	0.0405	0.00416	137	137	137	0	0	1	-360	360;
	2531	2453	0.00636	0.02155	0.00213	91	91	91	0	0	1	-360	360;
	2311	2487	0.01028	0.01795	0.00171	114	114	114	0	0	1	-360	360;
	2307	2486	0.01334	0.0339	0.00343	114	114	114	0	0	1	-360	360;
	2648	2487	0.01249	0.03219	0.00326	90	90	90	0	0	1	-360	360;
	2308	2648	0.0006	0.00103	0.0001	90	90	90	0	0	1	-360	360;
	2641	2648	0.00435	0.0076	0.00073	90	90	90	0	0	1	-360	360;
	2362	2641	0.0004	0.00069	7e-05	90	90	90	0	0	1	-360	360;
	2650	2641	0.00221	0.00746	0.00074	90	90	90	0	0	1	-360	360;
	2547	2650	0.0085	0.01485	0.00142	90	90	90	0	0	1	-360	360;
	2498	2650	0.0082	0.02777	0.00275	90	90	90	0	0	1	-360	360;
	2325	2486	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2306	2312	0.00455	0.01263	0.00127	114	114	114	0	0	1	-360	360;
	2326	2486	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2338	2343	0.01176	0.02107	0.00202	90	90	90	0	0	1	-360	360;
	2327	2487	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	2338	2341	0.01803	0.06109	0.00605	90	90	90	0	0	1	-360	360;
	2477	2487	0.00154	0.00521	0.00052	137	137	137	0	0	1	-360	360;
	2337	2487	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	2336	2486	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	2477	2351	0.00697	0.0236	0.00234	137	137	137	0	0	1	-360	360;
	2344	2487	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2343	2486	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2474	2487	0.00012	0.0004	4e-05	137	137	137	0	0	1	-360	360;
	2475	2486	0.0001	0.00031	3e-05	137	137	137	0	0	1	-360	360;
	2339	2487	0.00579	0.01818	0.00186	120	120	120	0	0	1	-360	360;
	2642	2202	0.0207	0.07012	0.00694	137	137	137	0	0	1	-360	360;
	2382	2642	0.00349	0.0118	0.00117	137	137	137	0	0	1	-360	360;
	2380	2642	0.00615	0.02083	0.00206	137	137	137	0	0	1	-360	360;
	2604	2523	0.02479	0.07686	0.00835	120	120	120	0	0	1	-360	360;
	2258	2524	0.02893	0.08843	0.00973	120	120	120	0	0	1	-360	360;
	2333	2309	0.00676	0.02291	0.00227	120	120	120	0	0	1	-360	360;
	2333	2342	0.00369	0.0125	0.00124	137	137	137	0	0	1	-360	360;
	2336	2342	0.00522	0.0177	0.00175	137	137	137	0	0	1	-360	360;
	2640	2487	0.00061	0.00208	0.00021	120	120	120	0	0	1	-360	360;
	2328	2640	0.00102	0.00347	0.00034	120	120	120	0	0	1	-360	360;
	2331	2640	0.00431	0.01388	0.00116	120	120	120	0	0	1	-360	360;
	2354	2486	0.00942	0.03193	0.00316	120	120	120	0	0	1	-360	360;
	2353	2330	0.00645	0.02187	0.00216	120	120	120	0	0	1	-360	360;
	2197	2334	0.02439	0.06359	0.01204	137	137	137	0	0	1	-360	360;
	2689	2452	0.01902	0.04153	0.00864	90	90	90	0	0	1	-360	360;
	2510	2334	0.00579	0.01893	0.00191	76	76	76	0	0	1	-360	360;
	2383	2452	0.0157	0.02562	0.00227	120	120	120	0	0	1	-360	360;
	2383	2382	0.00826	0.0124	0.00128	120	120	120	0	0	1	-360	360;
	2688	2451	0.02209	0.05774	0.00565	76	76	76	0	0	1	-360	360;
	2265	2451	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2266	2452	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2286	2451	0.04628	0.07686	0.00755	76	76	76	0	0	1	-360	360;
	2261	2691	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2262	2690	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2180	2691	0.00661	0.00909	0.00116	120	120	120	0	0	1	-360	360;
	2685	2180	0.00744	0.02397	0.00244	120	120	120	0	0	1	-360	360;
	2349	2346	0.00359	0.01215	0.0012	120	120	120	0	0	1	-360	360;
	2263	2691	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2264	2690	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2653	2690	0.00615	0.02083	0.0023	120	120	120	0	0	1	-360	360;
	2352	2653	0.00769	0.02603	0.00258	120	120	120	0	0	1	-360	360;
	2348	2653	0.00031	0.00104	0.0001	120	120	120	0	0	1	-360	360;
	2346	2691	0.00909	0.02727	0.0029	120	120	120	0	0	1	-360	360;
	2353	2345	0.00992	0.03058	0.00329	120	120	120	0	0	1	-360	360;
	2478	2690	0.02479	0.08008	0.0083	114	114	114	0	0	1	-360	360;
	2176	2691	0.01499	0.03154	0.0031	90	90	90	0	0	1	-360	360;
	2259	2690	0.04298	0.10248	0.0105	90	90	90	0	0	1	-360	360;
	2685	2341	0.00287	0.00972	0.00096	114	114	114	0	0	1	-360	360;
	2452	2201	0.03719	0.11901	0.0122	114	114	114	0	0	1	-360	360;
	2197	2202	0.06463	0.10992	0.01059	137	137	137	0	0	1	-360	360;
	2194	2201	0.03322	0.05661	0.00545	120	120	120	0	0	1	-360	360;
	2361	2202	0.01783	0.06021	0.00596	120	120	120	0	0	1	-360	360;
	2497	2201	0.00759	0.02569	0.00254	120	120	120	0	0	1	-360	360;
	2654	2340	0.01209	0.04096	0.00406	120	120	120	0	0	1	-360	360;
	2654	2202	0.00687	0.02326	0.0023	120	120	120	0	0	1	-360	360;
	2548	2654	0.00553	0.00967	0.00092	120	120	120	0	0	1	-360	360;
	2309	2201	0.0157	0.04959	0.00511	120	120	120	0	0	1	-360	360;
	2524	2202	0.00413	0.0314	0.003	137	137	137	0	0	1	-360	360;
	2515	2201	0.06583	0.22298	0.02208	137	137	137	0	0	1	-360	360;
	2499	2202	0.02066	0.06612	0.00678	120	120	120	0	0	1	-360	360;
	2312	2331	0.01642	0.05563	0.00551	137	137	137	0	0	1	-360	360;
	2246	2194	0.01214	0.04112	0.00407	137	137	137	0	0	1	-360	360;
	2303	2663	0.03124	0.10231	0.01048	137	137	137	0	0	1	-360	360;
	2206	2222	0.04421	0.11367	0.01112	91	91	91	0	0	1	-360	360;
	2316	2222	0.01033	0.01802	0.00172	90	90	90	0	0	1	-360	360;
	2676	2392	0.01256	0.0219	0.00212	90	90	90	0	0	1	-360	360;
	2677	2675	0.01008	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2476	2387	0.02	0.03744	0.00365	90	90	90	0	0	1	-360	360;
	2675	2476	0.00793	0.01537	0.0015	90	90	90	0	0	1	-360	360;
	2677	2676	0.01083	0.01893	0.00181	90	90	90	0	0	1	-360	360;
	2392	2386	0.02818	0.05818	0.0059	90	90	90	0	0	1	-360	360;
	2254	2222	0.05702	0.11331	0.01091	90	90	90	0	0	1	-360	360;
	2520	2386	0.03934	0.12917	0.0132	137	137	137	0	0	1	-360	360;
	2521	2520	0.00595	0.01917	0.00198	137	137	137	0	0	1	-360	360;
	2316	2386	0.0362	0.06339	0.00612	90	90	90	0	0	1	-360	360;
	2521	2670	0.02743	0.08885	0.00915	137	137	137	0	0	1	-360	360;
	2621	2535	0.04033	0.13661	0.01353	137	137	137	0	0	1	-360	360;
	2665	2274	0.01157	0.03942	0.0039	137	137	137	0	0	1	-360	360;
	2254	2157	0.03507	0.11878	0.01176	137	137	137	0	0	1	-360	360;
	2157	2387	0.04107	0.13909	0.01377	137	137	137	0	0	1	-360	360;
	2426	2186	0.0295	0.05017	0.00484	90	90	90	0	0	1	-360	360;
	2663	2274	0.01132	0.03744	0.0037	137	137	137	0	0	1	-360	360;
	2555	2671	0.00107	0.00121	0.01087	120	120	120	0	0	1	-360	360;
	2662	2387	0.01421	0.04661	0.00477	137	137	137	0	0	1	-360	360;
	2662	2535	0.01777	0.05818	0.00595	137	137	137	0	0	1	-360	360;
	2428	2303	0.02269	0.06221	0.00629	90	90	90	0	0	1	-360	360;
	2181	2387	0.02099	0.06934	0.00699	137	137	137	0	0	1	-360	360;
	2211	2181	0.01711	0.05562	0.0048	137	137	137	0	0	1	-360	360;
	2663	2566	0.02496	0.08446	0.00847	137	137	137	0	0	1	-360	360;
	2621	2538	0.03174	0.1075	0.01064	137	137	137	0	0	1	-360	360;
	2423	2386	0.02595	0.08512	0.00874	10	10	10	0	0	1	-360	360;
	2428	2426	0.00943	0.01889	0.00185	90	90	90	0	0	1	-360	360;
	2665	2157	0.01769	0.05744	0.00596	137	137	137	0	0	1	-360	360;
	2177	2665	0.05234	0.09155	0.00873	20	20	20	0	0	1	-360	360;
	2931	2992	0.03562	0.10942	0.01146	69	69	69	0	0	1	-360	360;
	2829	2970	0.03678	0.09397	0.00951	120	120	120	0	0	1	-360	360;
	2943	2894	0.00207	0.00727	0.0007	126	126	126	0	0	1	-360	360;
	2894	2723	0.01851	0.0595	0.00627	126	126	126	0	0	1	-360	360;
	2821	2704	0.021	0.0679	0.00696	123	123	123	0	0	1	-360	360;
	2921	2925	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2700	2994	0.06645	0.17719	0.01791	70	70	70	0	0	1	-360	360;
	2916	2995	0.03957	0.12859	0.01319	137	137	137	0	0	1	-360	360;
	2838	2879	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2811	2769	0.04	0.12959	0.01329	114	114	114	0	0	1	-360	360;
	2775	2875	0.00992	0.03322	0.00419	107	107	107	0	0	1	-360	360;
	2812	2770	0.04025	0.13025	0.01336	114	114	114	0	0	1	-360	360;
	2877	2802	0.03545	0.08736	0.00882	120	120	120	0	0	1	-360	360;
	2996	2995	0.01264	0.03802	0.00273	69	69	69	0	0	1	-360	360;
	2774	2996	0.03306	0.08264	0.00968	69	69	69	0	0	1	-360	360;
	2847	2775	0.04669	0.08182	0.00774	90	90	90	0	0	1	-360	360;
	2726	2716	0.03413	0.05992	0.00566	48	48	48	0	0	1	-360	360;
	2740	2848	0.03587	0.05868	0.00646	90	90	90	0	0	1	-360	360;
	2739	2746	0.1	0.1595	0.01597	57	57	57	0	0	1	-360	360;
	2966	2862	0.0395	0.1281	0.01314	119	119	119	0	0	1	-360	360;
	2848	2715	0.03124	0.05603	0.00563	90	90	90	0	0	1	-360	360;
	2977	2736	0.0214	0.06887	0.00708	69	69	69	0	0	1	-360	360;
	2961	2977	0.01686	0.05427	0.00558	69	69	69	0	0	1	-360	360;
	2876	2977	0.00026	0.00066	7e-05	69	69	69	0	0	1	-360	360;
	2725	2724	0.01223	0.0386	0.0042	69	69	69	0	0	1	-360	360;
	2865	2732	0.02883	0.09322	0.00956	69	69	69	0	0	1	-360	360;
	2775	2942	0.02455	0.07992	0.00823	137	137	137	0	0	1	-360	360;
	2716	2958	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360;
	2958	2991	0.08653	0.11405	0.01019	69	69	69	0	0	1	-360	360;
	2830	2805	0.00785	0.01983	0.00203	120	120	120	0	0	1	-360	360;
	2873	2896	0.01033	0.02653	0.00269	69	69	69	0	0	1	-360	360;
	2850	2873	0.02231	0.05702	0.00576	120	120	120	0	0	1	-360	360;
	2849	2913	0.03099	0.07901	0.00801	120	120	120	0	0	1	-360	360;
	2697	2809	0.00264	0.00752	0.00075	120	120	120	0	0	1	-360	360;
	2799	2779	0.03025	0.06281	0.00061	120	120	120	0	0	1	-360	360;
	2777	2705	0.00331	0.01083	0.00109	114	114	114	0	0	1	-360	360;
	2789	2780	0.04124	0.07231	0.00687	69	69	69	0	0	1	-360	360;
	2778	2713	0.0186	0.0562	0.00581	111	111	111	0	0	1	-360	360;
	2845	2867	0.02479	0.08	0.00823	137	137	137	0	0	1	-360	360;
	2697	2913	0.01314	0.04182	0.00448	120	120	120	0	0	1	-360	360;
	2912	2872	0.00942	0.03066	0.00315	76	76	76	0	0	1	-360	360;
	2911	2840	0.02901	0.09438	0.00966	137	137	137	0	0	1	-360	360;
	2711	2780	0.00421	0.01058	0.00106	120	120	120	0	0	1	-360	360;
	2980	2779	0.00736	0.0238	0.00244	137	137	137	0	0	1	-360	360;
	2979	2697	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2979	2698	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2705	2711	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2844	2831	0.00826	0.02628	0.00286	120	120	120	0	0	1	-360	360;
	2758	2844	0.0181	0.05702	0.0062	120	120	120	0	0	1	-360	360;
	2809	2780	0.00405	0.01058	0.00109	120	120	120	0	0	1	-360	360;
	2702	2698	0.00231	0.00752	0.00077	137	137	137	0	0	1	-360	360;
	2907	2702	0.00397	0.01298	0.00131	137	137	137	0	0	1	-360	360;
	2797	2789	0.00361	0.01166	0.0012	114	114	114	0	0	1	-360	360;
	2919	2797	0.06898	0.12121	0.01145	90	90	90	0	0	1	-360	360;
	2722	2919	0.06661	0.11306	0.01118	69	69	69	0	0	1	-360	360;
	2895	2799	0.01322	0.03306	0.00327	69	69	69	0	0	1	-360	360;
	2991	2895	0.05686	0.09339	0.00944	76	76	76	0	0	1	-360	360;
	2943	2779	0.0376	0.12165	0.01249	137	137	137	0	0	1	-360	360;
	2956	2840	0.03058	0.05372	0.00508	90	90	90	0	0	1	-360	360;
	2873	2782	0.00851	0.02074	0.00232	120	120	120	0	0	1	-360	360;
	2782	2940	0.0405	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2973	2817	0.04008	0.10174	0.01033	99	99	99	0	0	1	-360	360;
	2710	2907	0.00198	0.00628	0.00065	137	137	137	0	0	1	-360	360;
	2696	2710	0.00653	0.02116	0.0022	137	137	137	0	0	1	-360	360;
	2896	2830	0.00926	0.0238	0.00242	69	69	69	0	0	1	-360	360;
	2988	2872	0.06223	0.10413	0.01072	69	69	69	0	0	1	-360	360;
	2787	2988	0.04702	0.07851	0.00808	69	69	69	0	0	1	-360	360;
	2716	2722	0.00545	0.0076	0.00077	69	69	69	0	0	1	-360	360;
	2872	2831	0.0162	0.0338	0.00351	90	90	90	0	0	1	-360	360;
	2911	2889	0.02781	0.08994	0.01845	137	137	137	0	0	1	-360	360;
	2696	2713	0.01397	0.04463	0.00462	137	137	137	0	0	1	-360	360;
	2867	2712	0.00868	0.0281	0.00295	76	76	76	0	0	1	-360	360;
	2906	2919	0.01607	0.05279	0.01083	69	69	69	0	0	1	-360	360;
	2891	2906	0.034	0.10995	0.02256	69	69	69	0	0	1	-360	360;
	2743	2779	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	2744	2780	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	2981	2697	0.00215	0.00719	0.00072	16	16	16	0	0	1	-360	360;
	2903	2780	0.00091	0.00306	0.00031	10	10	10	0	0	1	-360	360;
	2802	2805	0.00661	0.01372	0.00133	120	120	120	0	0	1	-360	360;
	2945	2713	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2709	2716	0.0374	0.12066	0.01272	137	137	137	0	0	1	-360	360;
	2945	2891	0.01928	0.06236	0.0064	137	137	137	0	0	1	-360	360;
	2724	2709	0.02269	0.07306	0.00777	140	140	140	0	0	1	-360	360;
	2735	2973	0.0057	0.01017	0.00094	137	137	137	0	0	1	-360	360;
	2971	2735	0.00967	0.01702	0.0016	137	137	137	0	0	1	-360	360;
	2785	2972	0.05769	0.14545	0.015	76	76	76	0	0	1	-360	360;
	2993	2973	0.00282	0.00717	0.00079	90	90	90	0	0	1	-360	360;
	2824	2993	0.03198	0.07876	0.00786	90	90	90	0	0	1	-360	360;
	2969	2972	0.01843	0.06	0.00615	137	137	137	0	0	1	-360	360;
	2951	2953	0.00554	0.01793	0.00184	137	137	137	0	0	1	-360	360;
	2847	2703	0.03636	0.12066	0.01181	114	114	114	0	0	1	-360	360;
	2953	2947	0.00306	0.00992	0.00102	114	114	114	0	0	1	-360	360;
	2760	2824	0.0676	0.11901	0.0112	69	69	69	0	0	1	-360	360;
	2963	2760	0.03868	0.0681	0.00639	69	69	69	0	0	1	-360	360;
	2892	2824	0.05042	0.10487	0.0102	69	69	69	0	0	1	-360	360;
	2909	2892	0.01976	0.0514	0.00515	69	69	69	0	0	1	-360	360;
	2828	2771	0.02781	0.07968	0.00807	140	140	140	0	0	1	-360	360;
	2963	2828	0.01467	0.03239	0.00328	69	69	69	0	0	1	-360	360;
	2708	2776	0.02231	0.07231	0.01493	75	75	75	0	0	1	-360	360;
	2703	2708	0.01322	0.01777	0.00191	62	62	62	0	0	1	-360	360;
	2944	2771	0.00883	0.02792	0.00305	137	137	137	0	0	1	-360	360;
	2757	2944	0.00688	0.02158	0.0024	137	137	137	0	0	1	-360	360;
	2888	2955	0.01554	0.05455	0.00557	137	137	137	0	0	1	-360	360;
	2950	2904	0.00438	0.01136	0.00098	120	120	120	0	0	1	-360	360;
	2734	2950	0.00515	0.01374	0.00122	120	120	120	0	0	1	-360	360;
	2904	2952	0.00281	0.00702	0.00059	114	114	114	0	0	1	-360	360;
	2721	2968	0.02769	0.0895	0.00917	95	95	95	0	0	1	-360	360;
	2955	2720	0.02132	0.06942	0.00707	137	137	137	0	0	1	-360	360;
	2968	2974	0.01504	0.04132	0.00426	137	137	137	0	0	1	-360	360;
	2954	2951	0.01777	0.05736	0.00588	137	137	137	0	0	1	-360	360;
	2910	2769	0.00736	0.0238	0.00251	114	114	114	0	0	1	-360	360;
	2931	2839	0.00421	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	2703	2909	0.02331	0.07893	0.00745	69	69	69	0	0	1	-360	360;
	2931	2768	0.00273	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	2768	2757	0.00149	0.00496	0.00048	137	137	137	0	0	1	-360	360;
	2723	2771	0.02868	0.09256	0.00951	140	140	140	0	0	1	-360	360;
	2734	2785	0.01364	0.03554	0.0037	120	120	120	0	0	1	-360	360;
	2951	2947	0.00421	0.01355	0.0014	131	131	131	0	0	1	-360	360;
	2887	2954	0.00529	0.01074	0.00111	90	90	90	0	0	1	-360	360;
	2974	2971	0.00934	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2816	2770	0.02124	0.0686	0.00704	140	140	140	0	0	1	-360	360;
	2776	2769	0.0314	0.09884	0.01074	140	140	140	0	0	1	-360	360;
	2818	2947	0.00851	0.02686	0.0029	95	95	95	0	0	1	-360	360;
	2813	2818	0.0181	0.05702	0.0062	95	95	95	0	0	1	-360	360;
	3013	2719	0.00864	0.02821	0.00288	140	140	140	0	0	1	-360	360;
	2819	2972	0.03678	0.09347	0.00949	120	120	120	0	0	1	-360	360;
	2875	2816	0.03364	0.10744	0.01016	107	107	107	0	0	1	-360	360;
	2910	2839	0.00826	0.01653	0.00194	114	114	114	0	0	1	-360	360;
	2968	2984	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2968	2984	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2764	2947	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2765	2948	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2957	2951	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2960	2887	0.0254	0.08216	0.00843	123	123	123	0	0	1	-360	360;
	2960	2719	0.01636	0.05289	0.00558	140	140	140	0	0	1	-360	360;
	2813	2963	0.02041	0.06843	0.00685	123	123	123	0	0	1	-360	360;
	2957	2951	0.00992	0.03488	0.00407	76	76	76	0	0	1	-360	360;
	2970	2931	0.02017	0.05223	0.00545	120	120	120	0	0	1	-360	360;
	2931	2770	0.0095	0.02455	0.00256	114	114	114	0	0	1	-360	360;
	2936	2920	0.00891	0.01566	0.00148	77	77	77	0	0	1	-360	360;
	2928	2930	0.0328	0.07474	0.00784	66	66	66	0	0	1	-360	360;
	2927	2925	0.04351	0.09356	0.00962	66	66	66	0	0	1	-360	360;
	2929	2994	0.07306	0.1919	0.01832	867	867	867	0	0	1	-360	360;
	2930	2851	0.03091	0.08107	0.00774	87	87	87	0	0	1	-360	360;
	2851	2994	0.04207	0.11074	0.01053	87	87	87	0	0	1	-360	360;
	2926	2929	0.01653	0.03306	0.00242	66	66	66	0	0	1	-360	360;
	2821	2730	0.0405	0.07107	0.00673	77	77	77	0	0	1	-360	360;
	2730	2926	0.04628	0.07107	0.0076	77	77	77	0	0	1	-360	360;
	2929	2936	0.00496	0.00826	0.00085	66	66	66	0	0	1	-360	360;
	2822	2821	0.00413	0.01372	0.00138	119	119	119	0	0	1	-360	360;
	2961	2927	0.02394	0.04718	0.00469	66	66	66	0	0	1	-360	360;
	2920	2928	0.00862	0.02752	0.00296	135	135	135	0	0	1	-360	360;
	2833	2994	0.04438	0.07826	0.00739	77	77	77	0	0	1	-360	360;
	2866	2833	0.05661	0.09983	0.00943	66	66	66	0	0	1	-360	360;
	2714	2866	0.01975	0.06215	0.00675	66	66	66	0	0	1	-360	360;
	2745	2714	0.03669	0.06471	0.00611	77	77	77	0	0	1	-360	360;
	2731	2930	0.03587	0.07132	0.00624	77	77	77	0	0	1	-360	360;
	2966	2822	0.03438	0.06099	0.00569	119	119	119	0	0	1	-360	360;
	2745	2731	0.03587	0.07132	0.00624	77	77	77	0	0	1	-360	360;
	2729	2773	0.0204	0.06595	0.00677	135	135	135	0	0	1	-360	360;
	2726	2773	0.01455	0.04747	0.00483	135	135	135	0	0	1	-360	360;
	2750	2874	0.00661	0.0157	0.00169	103	103	103	0	0	1	-360	360;
	2755	2717	0.00983	0.01736	0.0016	137	137	137	0	0	1	-360	360;
	2717	2751	0.03025	0.09752	0.01002	86	86	86	0	0	1	-360	360;
	2792	2752	0.01149	0.03471	0.00293	120	120	120	0	0	1	-360	360;
	2967	2792	0.00826	0.02893	0.00363	120	120	120	0	0	1	-360	360;
	2825	2746	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2825	2841	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2826	2841	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2754	2967	0.01083	0.03471	0.00358	137	137	137	0	0	1	-360	360;
	2763	2754	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2939	2763	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2755	2939	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2717	2989	0.03669	0.11818	0.01217	137	137	137	0	0	1	-360	360;
	2965	2989	0.01721	0.05623	0.00573	137	137	137	0	0	1	-360	360;
	2946	2747	0.03248	0.1081	0.01445	137	137	137	0	0	1	-360	360;
	2934	2746	0.05455	0.18017	0.0242	99	99	99	0	0	1	-360	360;
	2749	2752	0.01917	0.02595	0.00467	69	69	69	0	0	1	-360	360;
	2874	2752	0.01405	0.03636	0.00399	103	103	103	0	0	1	-360	360;
	2900	2751	0.03587	0.09008	0.00924	114	114	114	0	0	1	-360	360;
	2978	2752	0.015	0.04714	0.00466	114	114	114	0	0	1	-360	360;
	2932	2978	0.00525	0.0165	0.00163	114	114	114	0	0	1	-360	360;
	2975	2978	0.00026	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	2901	2964	0.04174	0.07322	0.00692	90	90	90	0	0	1	-360	360;
	2759	2990	0.01705	0.05552	0.00567	137	137	137	0	0	1	-360	360;
	2754	2949	0.00099	0.00347	0.00036	137	137	137	0	0	1	-360	360;
	2882	2932	0.00364	0.01074	0.00106	114	114	114	0	0	1	-360	360;
	2749	2886	0.00463	0.01488	0.00152	137	137	137	0	0	1	-360	360;
	2762	2900	0.00372	0.00934	0.00094	120	120	120	0	0	1	-360	360;
	2755	2762	0.00496	0.01273	0.00128	95	95	95	0	0	1	-360	360;
	2727	2826	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2751	2727	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2752	2933	0.01496	0.0438	0.00445	114	114	114	0	0	1	-360	360;
	2753	2747	0.0076	0.01983	0.00206	120	120	120	0	0	1	-360	360;
	2837	2752	0.03479	0.1119	0.01176	76	76	76	0	0	1	-360	360;
	2946	2837	0.00702	0.0224	0.00237	123	123	123	0	0	1	-360	360;
	2880	2941	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2946	2880	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2823	2829	0.01992	0.05245	0.00519	120	120	120	0	0	1	-360	360;
	2941	2823	0.01187	0.03176	0.00315	120	120	120	0	0	1	-360	360;
	2885	2749	0.00504	0.01686	0.00174	137	137	137	0	0	1	-360	360;
	2694	2749	0.00331	0.01091	0.00111	137	137	137	0	0	1	-360	360;
	2933	2893	0.00777	0.02479	0.00257	137	137	137	0	0	1	-360	360;
	2852	2718	0.00711	0.02314	0.00234	124	124	124	0	0	1	-360	360;
	2886	2853	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2905	2901	0.00645	0.02066	0.00213	137	137	137	0	0	1	-360	360;
	2897	2746	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2898	2747	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2747	2750	0.02074	0.06727	0.00682	137	137	137	0	0	1	-360	360;
	2897	2767	0.00545	0.01736	0.00177	137	137	137	0	0	1	-360	360;
	2747	2694	0.00612	0.0157	0.00157	120	120	120	0	0	1	-360	360;
	2860	2750	0.00132	0.00421	0.00044	137	137	137	0	0	1	-360	360;
	2746	2860	0.00793	0.02231	0.00215	123	123	123	0	0	1	-360	360;
	2767	2885	0.00909	0.02893	0.0029	137	137	137	0	0	1	-360	360;
	2893	2937	0.00736	0.02372	0.00242	137	137	137	0	0	1	-360	360;
	2718	2905	0.00331	0.01074	0.00109	137	137	137	0	0	1	-360	360;
	2949	2794	0.00207	0.00694	0.0007	137	137	137	0	0	1	-360	360;
	2965	2901	0.01132	0.03636	0.00375	137	137	137	0	0	1	-360	360;
	2794	2852	0.00289	0.00926	0.00094	137	137	137	0	0	1	-360	360;
	2853	2882	0.00248	0.00744	0.00073	120	120	120	0	0	1	-360	360;
	2795	2753	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	2937	2795	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	2862	2990	0.00165	0.00496	0.00053	137	137	137	0	0	1	-360	360;
	2725	2934	0.0395	0.12455	0.01176	38	38	38	0	0	1	-360	360;
	2790	2752	0.0395	0.06959	0.00657	72	72	72	0	0	1	-360	360;
	2788	2790	0.05306	0.09355	0.00884	72	72	72	0	0	1	-360	360;
	2924	2788	0.03293	0.1065	0.01093	137	137	137	0	0	1	-360	360;
	2923	2788	0.05807	0.10306	0.00937	76	76	76	0	0	1	-360	360;
	2934	2924	0.02444	0.07902	0.00811	137	137	137	0	0	1	-360	360;
	2704	2989	0.02139	0.06954	0.00729	120	120	120	0	0	1	-360	360;
	2908	2751	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2749	2983	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2750	2982	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2881	2747	0.01281	0.02149	0.00212	78	78	78	0	0	1	-360	360;
	2715	2881	0.0262	0.04397	0.00434	78	78	78	0	0	1	-360	360;
	2842	2699	0.03905	0.12628	0.01297	95	95	95	0	0	1	-360	360;
	2976	2858	0.01165	0.03769	0.00387	137	137	137	0	0	1	-360	360;
	2699	2976	0.0214	0.06917	0.0071	137	137	137	0	0	1	-360	360;
	2707	2976	0.00281	0.00917	0.00094	123	123	123	0	0	1	-360	360;
	2938	2857	0.15802	0.18273	0.01643	46	46	46	0	0	1	-360	360;
	2834	2858	0.00498	0.01612	0.00165	137	137	137	0	0	1	-360	360;
	2756	2854	0.01039	0.05083	0.00494	133	133	133	0	0	1	-360	360;
	2827	2854	0.03603	0.12893	0.01251	69	69	69	0	0	1	-360	360;
	2732	2857	0.02234	0.07496	0.00748	69	69	69	0	0	1	-360	360;
	2695	2827	0.0414	0.06942	0.00711	69	69	69	0	0	1	-360	360;
	2766	2827	0.03314	0.06116	0.00639	69	69	69	0	0	1	-360	360;
	2804	2695	0.03769	0.12149	0.01249	69	69	69	0	0	1	-360	360;
	2807	2804	0.01942	0.06281	0.00649	69	69	69	0	0	1	-360	360;
	2859	2854	0.03587	0.1157	0.0122	140	140	140	0	0	1	-360	360;
	2783	2855	0.03025	0.09752	0.01028	140	140	140	0	0	1	-360	360;
	2820	2775	0.00983	0.01727	0.00163	69	69	69	0	0	1	-360	360;
	2864	2820	0.05322	0.09347	0.00882	69	69	69	0	0	1	-360	360;
	2868	2861	0.00661	0.01372	0.00133	69	69	69	0	0	1	-360	360;
	2861	2869	0.00537	0.01736	0.00179	69	69	69	0	0	1	-360	360;
	2842	2807	0.02339	0.07587	0.00784	57	57	57	0	0	1	-360	360;
	2869	2857	0.01157	0.03769	0.00387	69	69	69	0	0	1	-360	360;
	2843	2855	0.0331	0.11107	0.01106	114	114	114	0	0	1	-360	360;
	2846	2859	0.02818	0.09116	0.00934	69	69	69	0	0	1	-360	360;
	2864	2756	0.02446	0.04347	0.00404	69	69	69	0	0	1	-360	360;
	2863	2858	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2835	2868	0.00507	0.01627	0.00168	137	137	137	0	0	1	-360	360;
	2843	2838	0.0205	0.06876	0.00688	69	69	69	0	0	1	-360	360;
	2902	2806	0.01568	0.0507	0.0052	84	84	84	0	0	1	-360	360;
	2854	2857	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2855	2858	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2835	2783	0.01012	0.03265	0.00336	137	137	137	0	0	1	-360	360;
	2870	2834	0.00118	0.00382	0.00039	57	57	57	0	0	1	-360	360;
	2871	2835	0.0011	0.00355	0.00037	57	57	57	0	0	1	-360	360;
	2701	2738	0.02355	0.06215	0.00639	82	82	82	0	0	1	-360	360;
	2784	2701	0.0276	0.0495	0.00448	69	69	69	0	0	1	-360	360;
	2761	2784	0.03967	0.07157	0.00641	69	69	69	0	0	1	-360	360;
	2796	2761	0.02983	0.05793	0.00547	69	69	69	0	0	1	-360	360;
	2801	2737	0.00926	0.03008	0.00307	123	123	123	0	0	1	-360	360;
	2922	2916	0.05314	0.09339	0.0089	69	69	69	0	0	1	-360	360;
	2798	2801	0.00132	0.00421	0.00044	119	119	119	0	0	1	-360	360;
	2800	2738	0.00909	0.02975	0.00302	119	119	119	0	0	1	-360	360;
	2736	2737	0.05504	0.1643	0.01682	69	69	69	0	0	1	-360	360;
	2986	2733	0.03653	0.06413	0.00605	69	69	69	0	0	1	-360	360;
	2815	2800	0.01595	0.05124	0.0053	140	140	140	0	0	1	-360	360;
	2815	2798	0.00744	0.02397	0.00246	123	123	123	0	0	1	-360	360;
	2884	2774	0.03669	0.11669	0.01251	69	69	69	0	0	1	-360	360;
	2986	2922	0.08314	0.14628	0.01392	69	69	69	0	0	1	-360	360;
	2962	2737	0.02688	0.08734	0.00915	140	140	140	0	0	1	-360	360;
	2815	2921	0.03347	0.06529	0.00593	140	140	140	0	0	1	-360	360;
	2793	2796	0.00521	0.01413	0.0014	90	90	90	0	0	1	-360	360;
	2796	2962	0.01843	0.0619	0.0062	140	140	140	0	0	1	-360	360;
	2728	2986	0.00182	0.00388	0.00027	76	76	76	0	0	1	-360	360;
	2915	2916	0.00347	0.01264	0.00119	69	69	69	0	0	1	-360	360;
	2700	2918	0.0376	0.09174	0.00968	69	69	69	0	0	1	-360	360;
	2884	2917	0.01967	0.08612	0.00924	57	57	57	0	0	1	-360	360;
	2803	2914	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	2803	2915	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	2959	2737	0.01463	0.05661	0.00653	140	140	140	0	0	1	-360	360;
	2742	2987	0.00331	0.01058	0.00109	137	137	137	0	0	1	-360	360;
	2899	2742	0.02975	0.09587	0.01007	137	137	137	0	0	1	-360	360;
	2832	2899	0.00512	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2808	2848	0.03347	0.06529	0.00593	21	21	21	0	0	1	-360	360;
	2706	2883	0.01653	0.0314	0.0029	48	48	48	0	0	1	-360	360;
	2890	2706	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2883	2740	0.01653	0.0314	0.00315	48	48	48	0	0	1	-360	360;
	2865	2890	0.02288	0.074	0.00759	69	69	69	0	0	1	-360	360;
	2987	2739	0.00165	0.00529	0.00053	137	137	137	0	0	1	-360	360;
	2741	2740	0.00909	0.0281	0.00288	133	133	133	0	0	1	-360	360;
	2814	2810	0.00405	0.01331	0.00138	95	95	95	0	0	1	-360	360;
	2836	2814	0.02074	0.06628	0.00699	126	126	126	0	0	1	-360	360;
	2942	2836	0.02835	0.09223	0.00951	137	137	137	0	0	1	-360	360;
	3005	2810	0.03017	0.09764	0.01004	140	140	140	0	0	1	-360	360;
	2878	2741	0.02041	0.06612	0.00678	95	95	95	0	0	1	-360	360;
	2791	2942	0.01338	0.04326	0.00444	140	140	140	0	0	1	-360	360;
	3001	2173	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	3002	2174	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	3003	1656	0.01041	0.03355	0.00354	114	114	114	0	0	1	-360	360;
	3004	2093	0.00975	0.0305	0.00315	140	140	140	0	0	1	-360	360;
	2998	1747	0.00256	0.00826	0.00087	114	114	114	0	0	1	-360	360;
	3000	2998	0.00306	0.01	0.00105	114	114	114	0	0	1	-360	360;
	2997	2998	0.00025	0.00091	8e-05	114	114	114	0	0	1	-360	360;
	2999	1748	0.0057	0.01826	0.00192	114	114	114	0	0	1	-360	360;
	2832	3005	0.01103	0.03572	0.00367	140	140	140	0	0	1	-360	360;
	2947	3013	0.00934	0.0305	0.00311	140	140	140	0	0	1	-360	360;
	2964	2759	0.00543	0.01774	0.00181	140	140	140	0	0	1	-360	360;
	4	3	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	7	6	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	9	8	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	12	11	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	15	14	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	16	15	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	20	19	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	23	22	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	25	24	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	27	26	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	29	28	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	31	30	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	33	32	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	35	34	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	39	38	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	41	40	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	43	42	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	45	44	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	48	47	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	52	51	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	55	54	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	59	57	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	58	57	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	61	60	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	64	63	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	67	66	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	69	68	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	71	70	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	73	72	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	75	74	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	77	76	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	79	78	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	81	80	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	89	88	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	91	90	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	93	92	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	97	96	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	99	98	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	102	101	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	104	103	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	106	105	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	108	107	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	110	109	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	112	111	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	114	113	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	116	115	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	118	117	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	120	119	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	122	121	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	124	123	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	126	125	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	129	128	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	131	130	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	133	132	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	135	134	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	137	136	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	139	138	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	141	140	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	143	142	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	145	144	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	147	146	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	149	148	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	155	154	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	157	156	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	160	159	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	162	161	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	165	164	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	167	166	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	170	169	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	172	173	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	175	174	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	177	176	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	179	178	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	181	180	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	182	181	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	184	183	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	186	185	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	190	189	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	192	191	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	195	194	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	197	196	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	199	198	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	201	200	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	203	202	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	206	205	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	210	209	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	214	213	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	216	215	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	219	218	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	221	220	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	226	225	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	230	229	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	233	232	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	235	234	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	237	236	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	239	238	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	241	240	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	243	242	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	247	246	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	249	248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	251	250	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	261	260	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	264	263	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	266	265	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	283	282	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	285	284	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	289	288	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	292	291	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	294	293	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	296	295	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	303	302	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	306	305	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	309	308	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	312	311	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	326	325	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	338	337	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	341	340	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	343	342	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	350	349	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	356	355	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	363	362	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	390	389	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	395	394	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	397	396	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	405	404	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	407	406	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	413	412	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	415	414	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	420	419	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	441	440	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	446	445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	448	447	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	450	449	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	451	450	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	460	459	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	463	462	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	467	466	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	473	472	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	496	495	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	507	506	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	516	515	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	520	519	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	528	527	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	533	532	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	538	537	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	542	541	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	552	551	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	555	554	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	561	560	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	563	562	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	571	570	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	573	572	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	578	577	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	583	582	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	593	592	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	596	595	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	604	603	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	606	605	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	610	609	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	612	611	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	614	613	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	616	615	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	621	620	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	623	622	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	627	626	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	632	631	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	636	635	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	643	642	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	645	644	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	647	646	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	649	648	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	651	650	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	653	652	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	655	654	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	657	656	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	659	658	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	662	661	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	668	667	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	675	674	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	677	676	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	679	678	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	681	680	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	685	684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	687	686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	689	688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	691	690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	698	697	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	702	700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	733	732	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	736	735	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	742	741	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	745	744	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	747	746	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	754	753	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	756	755	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	762	761	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	769	768	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	771	770	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	776	775	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	786	785	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	790	789	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	847	846	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	852	851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	855	854	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	871	870	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	883	882	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	889	888	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	903	902	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	906	905	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	923	922	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	935	934	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	951	950	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	955	954	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	961	960	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	967	966	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	977	976	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	994	993	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1001	1000	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1042	1041	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1058	1057	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1061	1060	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1063	1062	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1064	1063	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1066	1065	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1068	1067	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1072	1071	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1074	1073	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1079	1078	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1081	1080	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1086	1085	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1088	1087	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1093	1092	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1101	1100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1103	1102	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1106	1105	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1108	1107	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1114	1113	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1116	1115	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1118	1117	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1128	1127	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1130	1129	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1138	1137	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1140	1139	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1145	1144	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1147	1146	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1149	1148	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1153	1152	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1155	1154	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1157	1156	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1162	1161	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1167	1166	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1169	1168	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1173	1172	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1175	1174	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1177	1176	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1179	1178	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1183	1182	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1185	1184	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1187	1186	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1191	1190	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1193	1192	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1195	1194	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1199	1198	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1201	1200	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1203	1202	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1207	1206	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1213	1212	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1217	1216	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1219	1218	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1221	1220	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1223	1222	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1225	1224	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1232	1231	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1238	1237	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1239	1238	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1249	1248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1255	1254	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1257	1256	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1261	1260	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1263	1262	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1265	1264	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1271	1270	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1275	1274	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1278	1277	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1280	1279	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1283	1282	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1285	1284	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1287	1286	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1289	1288	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1291	1290	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1293	1292	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1295	1294	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1302	1301	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1304	1303	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1312	1311	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1318	1317	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1324	1323	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1326	1325	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1334	1333	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1336	1335	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1350	1349	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1352	1351	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1363	1362	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1364	1363	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1368	1367	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1370	1369	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1375	1374	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1386	1385	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1392	1391	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1394	1393	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1403	1402	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1407	1406	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1416	1415	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1423	1422	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1426	1425	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1428	1427	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1430	1429	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1432	1431	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1434	1433	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1436	1435	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1442	1441	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1446	1445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1452	1451	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1456	1455	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1458	1457	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1462	1461	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1466	1465	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1468	1467	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1470	1469	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1472	1471	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1480	1479	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1482	1481	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1486	1485	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1488	1487	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1490	1489	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1492	1491	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1500	1499	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1502	1501	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1504	1503	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1508	1507	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1515	1514	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1517	1516	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1519	1518	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1521	1520	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1523	1522	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1525	1524	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1527	1526	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1529	1528	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1531	1530	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1533	1532	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1537	1536	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1539	1538	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1541	1540	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1549	1548	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1557	1556	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1559	1558	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1561	1560	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1563	1562	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1565	1564	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1570	1569	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1577	1576	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1582	1581	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1588	1587	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1592	1591	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1594	1593	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1596	1595	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1602	1601	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1605	1604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1607	1606	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1609	1608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1611	1610	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1613	1612	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1617	1616	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1619	1618	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1621	1620	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1623	1622	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1627	1626	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1632	1631	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1638	1637	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1640	1639	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1646	1645	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1648	1647	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1650	1649	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1652	1651	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1654	1653	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1656	1655	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1665	1664	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1667	1666	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1675	1674	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1677	1676	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1679	1678	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1681	1680	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1683	1682	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1685	1684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1687	1686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1689	1688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1691	1690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1699	1698	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1701	1700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1703	1702	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1705	1704	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1709	1708	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1711	1710	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1715	1714	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1717	1716	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1719	1718	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1721	1720	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1723	1722	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1725	1724	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1729	1728	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1736	1735	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1740	1739	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1742	1741	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1744	1743	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1746	1745	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1748	1747	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1750	1749	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1752	1751	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1760	1759	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1766	1765	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1770	1769	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1772	1771	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1778	1777	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1780	1779	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1782	1781	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1786	1785	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1792	1791	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1794	1793	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1796	1795	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1802	1801	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1804	1803	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1808	1807	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1810	1809	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1812	1811	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1814	1813	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1816	1815	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1818	1817	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1820	1819	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1822	1821	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1826	1825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1830	1829	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1832	1831	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1834	1833	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1836	1835	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1840	1839	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1842	1841	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1846	1845	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1848	1847	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1852	1851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1854	1853	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1856	1855	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1858	1857	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1861	1860	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1863	1862	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1865	1864	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1873	1872	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1878	1877	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1882	1881	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1888	1887	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1891	1890	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1893	1892	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1897	1896	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1899	1898	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1904	1903	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1906	1905	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1908	1907	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1915	1914	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1921	1920	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1923	1922	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1932	1931	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1934	1933	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1940	1939	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1942	1941	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1946	1945	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1952	1951	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1954	1953	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1956	1955	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1961	1960	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1963	1962	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1965	1964	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1971	1970	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1973	1972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1975	1974	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1977	1976	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1979	1978	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1981	1980	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1983	1982	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1987	1986	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1989	1988	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1993	1992	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1995	1994	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1997	1996	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1999	1998	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2001	2000	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2003	2002	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2005	2004	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2011	2010	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2013	2012	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2015	2014	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2019	2018	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2023	2022	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2028	2027	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2030	2029	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2032	2031	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2034	2033	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2036	2035	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2038	2037	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2046	2045	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2048	2047	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2050	2049	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2052	2051	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2057	2056	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2059	2058	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2061	2060	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2070	2069	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2072	2071	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2074	2073	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2076	2075	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2078	2077	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2080	2079	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2087	2086	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2089	2088	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2101	2100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2103	2102	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2105	2104	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2107	2106	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2109	2108	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2113	2112	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2115	2114	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2117	2116	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2119	2118	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2121	2120	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2123	2122	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2125	2124	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2127	2126	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2129	2128	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2131	2130	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2138	2137	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2140	2139	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2142	2141	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2146	2145	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2148	2147	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2153	2152	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2160	2159	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2165	2164	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2168	2167	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2171	2170	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2188	2187	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2200	2199	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2208	2207	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2217	2216	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2219	2218	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2223	2222	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2234	2233	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2237	2236	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2243	2242	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2249	2248	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2251	2250	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2259	2258	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2268	2267	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2273	2272	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2277	2276	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2299	2298	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2314	2313	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2331	2330	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2335	2334	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2340	2339	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2346	2345	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2352	2351	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2360	2359	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2367	2366	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2376	2375	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2378	2377	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2432	2431	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2444	2443	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2452	2451	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2457	2456	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2460	2459	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2465	2464	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2471	2470	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2482	2481	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2489	2488	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2493	2492	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2498	2497	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2509	2508	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2513	2512	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2516	2515	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2524	2523	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2526	2525	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2550	2549	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2579	2578	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2581	2580	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2586	2585	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2589	2588	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2597	2596	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2605	2604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2609	2608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2619	2618	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2629	2628	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2667	2666	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2669	2668	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2671	2670	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2687	2686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2701	2700	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2713	2712	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2718	2717	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2738	2737	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2740	2739	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2755	2754	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2770	2769	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2771	2770	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2780	2779	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2787	2786	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2807	2806	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2812	2810	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2810	2811	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2831	2830	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2855	2854	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2858	2857	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2873	2872	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2879	2878	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3000	2999	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2928	2927	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2930	2929	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2948	2947	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2969	2968	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2973	2972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2985	2984	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2990	2989	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2995	2994	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2698	2697	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2915	2914	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2912	2911	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2778	2777	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2980	2979	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2953	2952	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2992	2991	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2935	2934	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2826	2825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2721	2720	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2888	2887	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2835	2834	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	223	222	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	2179	2178	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	1;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	240.26	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	236.7	0;
	2	0	0	3	0	100	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	198.86	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
