%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Task Force on Modern Heuristic Optimization Test Beds
% Working Group on Modern Heuristic Optimization
% Intelligent Systems Subcommittee
% Power System Analysis, Computing, and Economic Committee
%
% Sebastian Wildenhues (E-Mail: sebastian.wildenhues@uni-due.de)
% 18th September 2013
%
% Application of Modern Heuristic Optimization Algorithms
% for Solving Optimal Power Flow Problems
%
% Incorporating static penalty constraint handling method.
%
% This routine is called subsequent to every function evaluation,
% i.e. power flow calculation. It does not affect the calculations
% done in test_bed_OPF.p, which calculates internally the fitness by
% using static penalty constraint handling method.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [f,g]=constraint_handling(o,g)
global proc;
global ps;
global ff_par;
dimG = length( g );
a = 2 * ps.n_load;
b = dimG - 2 * ps.n_gen_VS;
ff_par.numFFEval = ff_par.numFFEval + 1;
switch proc.system
    case 41
        tmpA = sum( g( 1 : a )  );
        tmpB = sum( g( 1 + b : dimG ) );
        tmpC = sum( g( 1 + a : b ) );
        tmpABC = [ tmpA, tmpB, 1e5 * tmpC ];
        UPDATE_COEFS_FF( tmpABC );
        g = ff_par.factor * ff_par.coefFF * tmpABC';
    case 57
        if proc.test_case == 1
            tmpA = sum( g( 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );
            tmpABC = [ tmpA, tmpB, tmpC ];
            UPDATE_COEFS_FF( tmpABC );
            g = ff_par.factor * ff_par.coefFF * tmpABC';
        else
            a = a + 1;
            tmpAA = g( 1 );
            tmpA = sum( g( 1 + 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );
            tmpAABC = [ tmpAA, tmpA, tmpB, tmpC  ];
            UPDATE_COEFS_FF( tmpAABC );
            g = ff_par.factor * ff_par.coefFF * tmpAABC';
        end
    case 118
        if proc.test_case == 1
            tmpA = sum( g( 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );  
            tmpABC = [ tmpA, tmpB, tmpC ];
            UPDATE_COEFS_FF( tmpABC );
            g = ff_par.factor * ff_par.coefFF * tmpABC';
        else
            a = a + 1;
            tmpAA = g( 1 );
            tmpA = sum( g( 1 + 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );
            tmpAABC = [ tmpAA, tmpA, tmpB, tmpC ];
            UPDATE_COEFS_FF( tmpAABC );
            g = ff_par.factor * ff_par.coefFF * tmpAABC'; 
        end
    case 300
        if proc.test_case == 1
            tmpA = sum( g( 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );
            tmpABC = [ tmpA, tmpB, tmpC ];
            UPDATE_COEFS_FF( tmpABC );
            g = ff_par.factor * ff_par.coefFF * tmpABC';
        else
            a = a + 1;
            tmpAA = g( 1 );
            tmpA = sum( g( 1 + 1 : a ) );
            tmpB = sum( g( 1 + b : dimG ) );
            tmpC = sum( g( 1 + a : b ) );
            tmpAABC = [ tmpAA, tmpA, tmpB, tmpC ];
            UPDATE_COEFS_FF( tmpAABC );
            g = ff_par.factor * ff_par.coefFF * tmpAABC';
        end
    otherwise
     % This must never happen!
end
% Fitness function.
f = o + g;
end