function mpc = case3120sp
%CASE3120SP  Power flow data for Polish system - summer 2008 morning peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   summer 2008 morning peak conditions.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case3120sp.m,v 1.1 2011/10/31 14:14:35 cvs Exp $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	2	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	3	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	4	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	5	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	6	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	7	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	8	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	9	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	10	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	11	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	12	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	13	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	14	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	15	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	16	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	17	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	18	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	19	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	20	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	21	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	22	2	10	20	0	0	1	1	0	220	1	1.11	0.95;
	23	2	10	20	0	0	1	1	0	220	1	1.11	0.95;
	24	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	25	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	26	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	27	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	28	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	29	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	30	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	31	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	32	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	33	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	34	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	35	2	32.16	52.07	0	0	1	1	0	220	1	1.11	0.95;
	36	2	46.36	92.07	0	0	1	1	0	220	1	1.11	0.95;
	37	3	60	120	0	0	1	1	0	400	1	1.05	0.95;
	38	2	60	120	0	0	1	1	0	400	1	1.05	0.95;
	39	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	40	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	41	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	42	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	43	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	44	1	0	0	0	0	1	1	0	400	1	1.05	0.95;
	45	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	46	1	0	0	0	0	1	1	0	220	1	1.11	0.95;
	47	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	48	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	49	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	50	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	51	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	52	1	3.97	1	0	0	1	1	0	220	2	1.11	0.95;
	53	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	54	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	55	2	13	30	0	0	1	1	0	220	2	1.11	0.95;
	56	2	39.35	90.07	0	0	1	1	0	220	2	1.11	0.95;
	57	2	26	60	0	0	1	1	0	220	2	1.11	0.95;
	58	2	26	50	0	0	1	1	0	400	2	1.05	0.95;
	59	2	26	50	0	0	1	1	0	400	2	1.05	0.95;
	60	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	61	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	62	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	63	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	64	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	65	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	66	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	67	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	68	2	13	30	0	0	1	1	0	220	2	1.11	0.95;
	69	2	26	60	0	0	1	1	0	220	2	1.11	0.95;
	70	2	0	2.25	0	0	1	1	0	400	2	1.05	0.95;
	71	2	26	60	0	0	1	1	0	400	2	1.05	0.95;
	72	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	73	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	74	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	75	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	76	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	77	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	78	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	79	1	0	0	0	0	1	1	0	400	2	1.05	0.95;
	80	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	81	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	82	1	0	0	0	0	1	1	0	220	2	1.11	0.95;
	83	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	84	1	6.41	2.01	0	0	1	1	0	220	3	1.11	0.95;
	85	1	13.89	5.02	0	0	1	1	0	220	3	1.11	0.95;
	86	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	87	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	88	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	89	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	90	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	91	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	92	2	28	70	0	0	1	1	0	220	3	1.11	0.95;
	93	2	28	68	0	0	1	1	0	220	3	1.11	0.95;
	94	1	2.78	1.91	0	0	1	1	0	220	3	1.11	0.95;
	95	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	96	2	32	142	0	0	1	1	0	400	3	1.05	0.95;
	97	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	98	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	99	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	100	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	101	1	38.8	-2.7	0	0	1	1	0	220	3	1.11	0.95;
	102	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	103	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	104	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	105	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	106	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	107	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	108	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	109	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	110	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	111	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	112	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	113	2	38.41	12.71	0	0	1	1	0	220	3	1.11	0.95;
	114	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	115	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	116	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	117	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	118	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	119	2	10	44	0	0	1	1	0	220	3	1.11	0.95;
	120	2	10	44	0	0	1	1	0	220	3	1.11	0.95;
	121	2	7	18	0	0	1	1	0	220	3	1.11	0.95;
	122	2	8	21	0	0	1	1	0	220	3	1.11	0.95;
	123	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	124	1	59.4	11.61	0	0	1	1	0	220	3	1.11	0.95;
	125	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	126	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	127	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	128	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	129	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	130	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	131	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	132	2	0	1.78	0	0	1	1	0	220	3	1.11	0.95;
	133	2	9	20	0	0	1	1	0	220	3	1.11	0.95;
	134	2	6	15	0	0	1	1	0	220	3	1.11	0.95;
	135	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	136	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	137	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	138	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	139	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	140	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	141	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	142	2	18.2	37.21	0	0	1	1	0	220	3	1.11	0.95;
	143	2	41.52	73.01	0	0	1	1	0	220	3	1.11	0.95;
	144	2	28	66	0	0	1	1	0	400	3	1.05	0.95;
	145	1	0	0	0	0	1	1	0	400	3	1.05	0.95;
	146	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	147	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	148	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	149	1	0	0	0	0	1	1	0	220	3	1.11	0.95;
	150	2	0	-0.79	0	0	1	1	0	220	3	1.11	0.95;
	151	2	0	-0.79	0	0	1	1	0	220	3	1.11	0.95;
	152	2	7.7	20	0	0	1	1	0	220	4	1.11	0.95;
	153	2	7.8	20	0	0	1	1	0	220	4	1.11	0.95;
	154	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	155	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	156	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	157	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	158	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	159	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	160	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	161	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	162	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	163	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	164	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	165	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	166	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	167	2	0	-13.01	0	0	1	1	0	220	4	1.11	0.95;
	168	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	169	2	12	30	0	0	1	1	0	220	4	1.11	0.95;
	170	2	19.91	36.57	0	0	1	1	0	220	4	1.11	0.95;
	171	2	12	30	0	0	1	1	0	400	4	1.05	0.95;
	172	2	12	30	0	0	1	1	0	400	4	1.05	0.95;
	173	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	174	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	175	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	176	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	177	2	30.5	64.2	0	0	1	1	0	220	4	1.11	0.95;
	178	2	58.9	96	0	0	1	1	0	220	4	1.11	0.95;
	179	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	180	2	26.5	64.2	0	0	1	1	0	400	4	1.05	0.95;
	181	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	182	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	183	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	184	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	185	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	186	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	187	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	188	2	12	30	0	0	1	1	0	220	4	1.11	0.95;
	189	2	23.8	60	0	0	1	1	0	220	4	1.11	0.95;
	190	2	38	64	0	0	1	1	0	400	4	1.05	0.95;
	191	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	192	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	193	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	194	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	195	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	196	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	197	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	198	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	199	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	200	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	201	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	202	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	203	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	204	2	0	-7.17	0	0	1	1	0	220	4	1.11	0.95;
	205	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	206	1	0	0	0	0	1	1	0	220	4	1.11	0.95;
	207	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	208	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	209	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	210	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	211	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	212	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	213	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	214	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	215	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	216	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	217	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	218	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	219	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	220	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	221	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	222	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	223	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	224	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	225	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	226	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	227	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	228	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	229	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	230	1	0	0	0	70	1	1	0	400	5	1.05	0.95;
	231	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
	232	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	233	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	234	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	235	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	236	2	11	40	0	0	1	1	0	400	5	1.05	0.95;
	237	2	5	10	0	0	1	1	0	400	5	1.05	0.95;
	238	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	239	1	0	0	0	0	1	1	0	220	5	1.11	0.95;
	240	2	8	20	0	0	0	1	0	220	0	1.11	0.95;
	241	1	9.86	2	0	0	1	1	0	110	1	1.12	0.95;
	242	1	6.41	0	0	0	1	1	0	110	1	1.12	0.95;
	243	1	9.37	0.6	0	0	1	1	0	110	1	1.12	0.95;
	244	1	7.25	4	0	0	1	1	0	110	1	1.12	0.95;
	245	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	246	1	2.18	2.4	0	0	1	1	0	110	1	1.12	0.95;
	247	1	5.12	4.91	0	0	1	1	0	110	1	1.12	0.95;
	248	1	3.65	0.9	0	0	1	1	0	110	1	1.12	0.95;
	249	1	3.85	1	0	0	1	1	0	110	1	1.12	0.95;
	250	2	4.44	-1.76	0	0	1	1	0	110	1	1.12	0.95;
	251	2	2.5	0	0	0	1	1	0	110	1	1.12	0.95;
	252	1	17.76	1.2	0	0	1	1	0	110	1	1.12	0.95;
	253	1	12.33	2.1	0	0	1	1	0	110	1	1.12	0.95;
	254	1	7.41	0.99	0	0	1	1	0	110	1	1.12	0.95;
	255	1	4.93	0	0	0	1	1	0	110	1	1.12	0.95;
	256	1	4.93	0	0	0	1	1	0	110	1	1.12	0.95;
	257	1	14.8	2.5	0	0	1	1	0	110	1	1.12	0.95;
	258	1	5.42	1.1	0	0	1	1	0	110	1	1.12	0.95;
	259	1	4.44	1	0	0	1	1	0	110	1	1.12	0.95;
	260	1	2.96	0.5	0	0	1	1	0	110	1	1.12	0.95;
	261	1	5.42	0.6	0	0	1	1	0	110	1	1.12	0.95;
	262	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	263	1	2.96	0.9	0	0	1	1	0	110	1	1.12	0.95;
	264	1	5.33	1.5	0	0	1	1	0	110	1	1.12	0.95;
	265	1	3.45	0.7	0	0	1	1	0	110	1	1.12	0.95;
	266	1	3.45	0.7	0	0	1	1	0	110	1	1.12	0.95;
	267	2	4.34	1.8	0	0	1	1	0	110	1	1.12	0.95;
	268	2	4.34	1.8	0	0	1	1	0	110	1	1.12	0.95;
	269	1	6.25	2	0	0	1	1	0	110	1	1.12	0.95;
	270	1	6.69	3	0	0	1	1	0	110	1	1.12	0.95;
	271	1	0.49	0.2	0	0	1	1	0	110	1	1.12	0.95;
	272	1	0.79	0.2	0	0	1	1	0	110	1	1.12	0.95;
	273	1	1.18	-0.9	0	0	1	1	0	110	1	1.12	0.95;
	274	1	4.74	0.5	0	0	1	1	0	110	1	1.12	0.95;
	275	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	276	1	3.16	0.1	0	0	1	1	0	110	1	1.12	0.95;
	277	1	7.4	1.3	0	0	1	1	0	110	1	1.12	0.95;
	278	1	10.36	1.3	0	0	1	1	0	110	1	1.12	0.95;
	279	1	2.27	1.11	0	0	1	1	0	110	1	1.12	0.95;
	280	1	5.33	1.6	0	0	1	1	0	110	1	1.12	0.95;
	281	1	2.07	0.1	0	0	1	1	0	110	1	1.12	0.95;
	282	2	1.87	0.09	0	0	1	1	0	110	1	1.12	0.95;
	283	2	1.87	0.31	0	0	1	1	0	110	1	1.12	0.95;
	284	1	8.58	3	0	0	1	1	0	110	1	1.12	0.95;
	285	1	1.58	0.4	0	0	1	1	0	110	1	1.12	0.95;
	286	1	4.44	1.1	0	0	1	1	0	110	1	1.12	0.95;
	287	1	5.33	0.5	0	0	1	1	0	110	1	1.12	0.95;
	288	1	4.64	0.4	0	0	1	1	0	110	1	1.12	0.95;
	289	1	13.89	7.76	0	0	1	1	0	110	1	1.12	0.95;
	290	1	19.52	11.23	0	0	1	1	0	110	1	1.12	0.95;
	291	1	6.81	0.5	0	0	1	1	0	110	1	1.12	0.95;
	292	1	9.57	3.84	0	0	1	1	0	110	1	1.12	0.95;
	293	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	294	1	8.38	0.8	0	0	1	1	0	110	1	1.12	0.95;
	295	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	296	1	3.95	0.4	0	0	1	1	0	110	1	1.12	0.95;
	297	1	5.42	0.6	0	0	1	1	0	110	1	1.12	0.95;
	298	1	2.47	0.3	0	0	1	1	0	110	1	1.12	0.95;
	299	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	300	1	0.49	0.2	0	0	1	1	0	110	1	1.12	0.95;
	301	2	0.17	0.3	0	0	1	1	0	110	1	1.12	0.95;
	302	2	0.06	0.1	0	0	1	1	0	110	1	1.12	0.95;
	303	1	5.92	0.7	0	0	1	1	0	110	1	1.12	0.95;
	304	1	0.3	0.1	0	0	1	1	0	110	1	1.12	0.95;
	305	1	0.4	0.1	0	0	1	1	0	110	1	1.12	0.95;
	306	1	10.06	7.01	0	0	1	1	0	110	1	1.12	0.95;
	307	1	0.49	0.2	0	0	1	1	0	110	1	1.12	0.95;
	308	1	8.09	1.3	0	0	1	1	0	110	1	1.12	0.95;
	309	1	4.74	0.4	0	0	1	1	0	110	1	1.12	0.95;
	310	1	4.74	1.74	0	0	1	1	0	110	1	1.12	0.95;
	311	1	2.86	-1.4	0	0	1	1	0	110	1	1.12	0.95;
	312	1	2.86	-1.4	0	0	1	1	0	110	1	1.12	0.95;
	313	1	3.08	2	0	0	1	1	0	110	1	1.12	0.95;
	314	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	315	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	316	2	20	40	0	0	1	1	0	24	1	1.12	0.95;
	317	1	4.93	1	0	0	1	1	0	110	1	1.12	0.95;
	318	1	2.96	0.7	0	0	1	1	0	110	1	1.12	0.95;
	319	1	3.95	1	0	0	1	1	0	110	1	1.12	0.95;
	320	1	1.48	0.2	0	0	1	1	0	110	1	1.12	0.95;
	321	1	0	0	0	45	1	1	0	16	1	1.12	0.95;
	322	2	0	-3.42	0	0	1	1	0	110	1	1.12	0.95;
	323	1	5.42	1	0	0	1	1	0	110	1	1.12	0.95;
	324	1	6.41	1	0	0	1	1	0	110	1	1.12	0.95;
	325	1	1.97	0	0	0	1	1	0	110	1	1.12	0.95;
	326	1	4.74	0.7	0	0	1	1	0	110	1	1.12	0.95;
	327	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	328	1	9.99	5.11	0	0	1	1	0	110	1	1.12	0.95;
	329	1	7.68	4.5	0	0	1	1	0	110	1	1.12	0.95;
	330	1	18.57	4	0	0	1	1	0	110	1	1.12	0.95;
	331	1	17.67	7.31	0	0	1	1	0	110	1	1.12	0.95;
	332	1	5.92	1	0	0	1	1	0	110	1	1.12	0.95;
	333	1	6.91	1	0	0	1	1	0	110	1	1.12	0.95;
	334	1	36.5	2	0	0	1	1	0	110	1	1.12	0.95;
	335	1	3.95	0.5	0	0	1	1	0	110	1	1.12	0.95;
	336	1	3.75	0.7	0	0	1	1	0	110	1	1.12	0.95;
	337	1	2.07	0.4	0	0	1	1	0	110	1	1.12	0.95;
	338	1	9.67	3.56	0	0	1	1	0	110	1	1.12	0.95;
	339	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	340	1	6.41	0.6	0	0	1	1	0	110	1	1.12	0.95;
	341	1	4.99	1.2	0	0	1	1	0	110	1	1.12	0.95;
	342	1	6.79	2.5	0	0	1	1	0	110	1	1.12	0.95;
	343	1	1.97	1.3	0	0	1	1	0	110	1	1.12	0.95;
	344	1	27.67	20.42	0	0	1	1	0	110	1	1.12	0.95;
	345	1	20.43	20.62	0	0	1	1	0	110	1	1.12	0.95;
	346	1	36.5	12.01	0	0	1	1	0	110	1	1.12	0.95;
	347	1	4.56	3	0	0	1	1	0	110	1	1.12	0.95;
	348	1	9.96	0.9	0	0	1	1	0	110	1	1.12	0.95;
	349	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	350	1	7	2	0	0	1	1	0	110	1	1.12	0.95;
	351	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	352	1	13.32	1.4	0	0	1	1	0	110	1	1.12	0.95;
	353	1	2.47	0	0	0	1	1	0	110	1	1.12	0.95;
	354	1	1.97	0	0	0	1	1	0	110	1	1.12	0.95;
	355	1	5.92	1.56	0	0	1	1	0	110	1	1.12	0.95;
	356	1	5.92	1.56	0	0	1	1	0	110	1	1.12	0.95;
	357	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	358	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	359	1	0.18	0.05	0	0	1	1	0	110	1	1.12	0.95;
	360	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	361	1	15.19	7.91	0	0	1	1	0	110	1	1.12	0.95;
	362	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	363	1	3.65	0.8	0	0	1	1	0	110	1	1.12	0.95;
	364	1	3.65	0.8	0	0	1	1	0	110	1	1.12	0.95;
	365	1	1.97	0.4	0	0	1	1	0	110	1	1.12	0.95;
	366	1	6.41	1	0	0	1	1	0	110	1	1.12	0.95;
	367	1	6.69	2.2	0	0	1	1	0	110	1	1.12	0.95;
	368	1	5.53	1.8	0	0	1	1	0	110	1	1.12	0.95;
	369	2	0.15	0.67	0	0	1	1	0	110	1	1.12	0.95;
	370	1	18.52	12.25	0	0	1	1	0	110	1	1.12	0.95;
	371	1	14.09	6.13	0	0	1	1	0	110	1	1.12	0.95;
	372	1	1.97	0.4	0	0	1	1	0	110	1	1.12	0.95;
	373	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	374	1	12.04	4.84	0	0	1	1	0	110	1	1.12	0.95;
	375	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	376	1	2.47	0.8	0	0	1	1	0	110	1	1.12	0.95;
	377	1	5.13	2.2	0	0	1	1	0	110	1	1.12	0.95;
	378	1	5.62	2.4	0	0	1	1	0	110	1	1.12	0.95;
	379	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	380	1	7.89	1.3	0	0	1	1	0	110	1	1.12	0.95;
	381	1	2.96	0	0	0	1	1	0	110	1	1.12	0.95;
	382	1	3.28	2	0	0	1	1	0	110	1	1.12	0.95;
	383	1	3.13	2	0	0	1	1	0	110	1	1.12	0.95;
	384	1	2.86	0.2	0	0	1	1	0	110	1	1.12	0.95;
	385	1	8.53	3.3	0	0	1	1	0	110	1	1.12	0.95;
	386	1	9.79	4.71	0	0	1	1	0	110	1	1.12	0.95;
	387	1	8.2	1.8	0	0	1	1	0	110	1	1.12	0.95;
	388	1	5.62	2.07	0	0	1	1	0	110	1	1.12	0.95;
	389	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	390	1	3.74	0.85	0	0	1	1	0	110	1	1.12	0.95;
	391	1	5.33	0.7	0	0	1	1	0	110	1	1.12	0.95;
	392	1	11.44	0.7	0	0	1	1	0	110	1	1.12	0.95;
	393	1	2.07	0.7	0	0	1	1	0	110	1	1.12	0.95;
	394	1	2.07	0.7	0	0	1	1	0	110	1	1.12	0.95;
	395	1	9.67	3.88	0	0	1	1	0	110	1	1.12	0.95;
	396	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	397	1	9.57	3.52	0	0	1	1	0	110	1	1.12	0.95;
	398	2	4.93	-0.66	0	0	1	1	0	110	1	1.12	0.95;
	399	1	5.42	0.5	0	0	1	1	0	110	1	1.12	0.95;
	400	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	401	1	4.54	1.9	0	0	1	1	0	110	1	1.12	0.95;
	402	2	14.99	6.03	0	0	1	1	0	110	1	1.12	0.95;
	403	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	404	1	10.95	4.03	0	0	1	1	0	110	1	1.12	0.95;
	405	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	406	1	14.21	5.24	0	0	1	1	0	110	1	1.12	0.95;
	407	1	17.76	6.54	0	0	1	1	0	110	1	1.12	0.95;
	408	1	5.66	1.52	0	0	1	1	0	110	1	1.12	0.95;
	409	2	22.7	9.13	0	0	1	1	0	110	1	1.12	0.95;
	410	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	411	2	14.44	10.73	0	0	1	1	0	110	1	1.12	0.95;
	412	2	14.2	0.68	0	0	1	1	0	110	1	1.12	0.95;
	413	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	414	2	1.1	-4.85	0	0	1	1	0	110	1	1.12	0.95;
	415	2	12.46	9.56	0	0	1	1	0	110	1	1.12	0.95;
	416	1	11.34	0.7	0	0	1	1	0	110	1	1.12	0.95;
	417	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	418	1	1.97	0.2	0	0	1	1	0	110	1	1.12	0.95;
	419	1	2.82	0	0	0	1	1	0	110	1	1.12	0.95;
	420	1	4.03	1	0	0	1	1	0	110	1	1.12	0.95;
	421	1	2.28	0.4	0	0	1	1	0	110	1	1.12	0.95;
	422	1	10.41	2	0	0	1	1	0	110	1	1.12	0.95;
	423	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	424	1	7.79	2.5	0	0	1	1	0	110	1	1.12	0.95;
	425	1	5.97	1.7	0	0	1	1	0	110	1	1.12	0.95;
	426	1	9.67	3.56	0	0	1	1	0	110	1	1.12	0.95;
	427	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	428	2	17.07	6.29	0	0	1	1	0	110	1	1.12	0.95;
	429	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	430	1	5.42	1	0	0	1	1	0	110	1	1.12	0.95;
	431	1	4.93	1	0	0	1	1	0	110	1	1.12	0.95;
	432	1	23.18	9.32	0	0	1	1	0	110	1	1.12	0.95;
	433	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	434	1	7.45	2.74	0	0	1	1	0	110	1	1.12	0.95;
	435	1	7.45	2.74	0	0	1	1	0	110	1	1.12	0.95;
	436	1	5.92	0.7	0	0	1	1	0	110	1	1.12	0.95;
	437	1	2.96	0.2	0	0	1	1	0	110	1	1.12	0.95;
	438	1	8.09	2	0	0	1	1	0	110	1	1.12	0.95;
	439	1	7.4	1.9	0	0	1	1	0	110	1	1.12	0.95;
	440	1	10.46	3.85	0	0	1	1	0	110	1	1.12	0.95;
	441	1	9.07	2.4	0	0	1	1	0	110	1	1.12	0.95;
	442	1	5.42	1	0	0	1	1	0	110	1	1.12	0.95;
	443	1	25.35	9.34	0	0	1	1	0	110	1	1.12	0.95;
	444	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	445	1	10.97	0	0	0	1	1	0	110	1	1.12	0.95;
	446	1	9.61	0	0	0	1	1	0	110	1	1.12	0.95;
	447	1	2.96	0.7	0	0	1	1	0	110	1	1.12	0.95;
	448	1	7.89	1.2	0	0	1	1	0	110	1	1.12	0.95;
	449	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	450	1	8.38	1.2	0	0	1	1	0	110	1	1.12	0.95;
	451	1	12.43	4.57	0	0	1	1	0	110	1	1.12	0.95;
	452	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	453	1	8.5	4	0	0	1	1	0	110	1	1.12	0.95;
	454	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	455	1	9.86	2.6	0	0	1	1	0	110	1	1.12	0.95;
	456	1	9.86	2.6	0	0	1	1	0	110	1	1.12	0.95;
	457	1	4.93	0.8	0	0	1	1	0	110	1	1.12	0.95;
	458	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	459	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	460	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	461	1	0	0	0	45	1	1	0	16	1	1.12	0.95;
	462	1	0	0	0	0	1	1	0	32	1	1.12	0.95;
	463	1	18.17	7.41	0	0	1	1	0	110	1	1.12	0.95;
	464	1	14.04	5.41	0	0	1	1	0	110	1	1.12	0.95;
	465	1	5.72	0.9	0	0	1	1	0	110	1	1.12	0.95;
	466	2	7.68	0.38	0	0	1	1	0	110	1	1.12	0.95;
	467	1	14.8	1.4	0	0	1	1	0	110	1	1.12	0.95;
	468	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	469	1	11.94	4.4	0	0	1	1	0	110	1	1.12	0.95;
	470	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	471	1	9.37	2.38	0	0	1	1	0	110	1	1.12	0.95;
	472	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	473	1	5.92	1	0	0	1	1	0	110	1	1.12	0.95;
	474	1	0.99	0.3	0	0	1	1	0	110	1	1.12	0.95;
	475	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	476	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	477	1	0	0	0	15	1	1	0	16	1	1.12	0.95;
	478	1	0	0	0	15	1	1	0	16	1	1.12	0.95;
	479	1	2.46	0.3	0	0	1	1	0	110	1	1.12	0.95;
	480	1	4.94	2	0	0	1	1	0	110	1	1.12	0.95;
	481	1	5.92	2.1	0	0	1	1	0	110	1	1.12	0.95;
	482	1	5.92	2.1	0	0	1	1	0	110	1	1.12	0.95;
	483	1	5.72	1.6	0	0	1	1	0	110	1	1.12	0.95;
	484	1	3.85	1.4	0	0	1	1	0	110	1	1.12	0.95;
	485	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	486	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	487	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	488	1	0	0	0	0	1	1	0	16	1	1.12	0.95;
	489	1	2.56	0.6	0	0	1	1	0	110	1	1.12	0.95;
	490	1	2.86	1.5	0	0	1	1	0	110	1	1.12	0.95;
	491	1	7.57	2.2	0	0	1	1	0	110	1	1.12	0.95;
	492	2	44.88	17.02	0	0	1	1	0	110	1	1.12	0.95;
	493	2	53.77	21.02	0	0	1	1	0	110	1	1.12	0.95;
	494	2	69.15	28.02	0	0	1	1	0	110	1	1.12	0.95;
	495	2	77.06	34.03	0	0	1	1	0	110	1	1.12	0.95;
	496	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	497	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	498	1	9.37	0.2	0	0	1	1	0	110	1	1.12	0.95;
	499	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	500	1	12.92	1.2	0	0	1	1	0	110	1	1.12	0.95;
	501	1	3.35	0.2	0	0	1	1	0	110	1	1.12	0.95;
	502	1	3.45	1	0	0	1	1	0	110	1	1.12	0.95;
	503	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	504	1	6.27	3	0	0	1	1	0	110	1	1.12	0.95;
	505	1	9.22	3	0	0	1	1	0	110	1	1.12	0.95;
	506	1	6.02	1.2	0	0	1	1	0	110	1	1.12	0.95;
	507	1	3.95	1.1	0	0	1	1	0	110	1	1.12	0.95;
	508	1	11.84	1.5	0	0	1	1	0	110	1	1.12	0.95;
	509	1	7.2	0.2	0	0	1	1	0	110	1	1.12	0.95;
	510	1	8.68	1	0	0	1	1	0	110	1	1.12	0.95;
	511	1	6.31	1.2	0	0	1	1	0	110	1	1.12	0.95;
	512	1	6.91	1	0	0	1	1	0	110	1	1.12	0.95;
	513	1	13.5	4.61	0	0	1	1	0	110	1	1.12	0.95;
	514	1	11.48	3.8	0	0	1	1	0	110	1	1.12	0.95;
	515	1	8.4	3	0	0	1	1	0	110	1	1.12	0.95;
	516	1	11.02	4	0	0	1	1	0	110	1	1.12	0.95;
	517	2	24.19	15.32	0	0	1	1	0	110	1	1.12	0.95;
	518	2	14.55	0	0	0	1	1	0	110	1	1.12	0.95;
	519	1	1.48	0.2	0	0	1	1	0	110	1	1.12	0.95;
	520	1	4.2	1.5	0	0	1	1	0	110	1	1.12	0.95;
	521	1	8.5	3.5	0	0	1	1	0	110	1	1.12	0.95;
	522	2	16.87	6.06	0	0	1	1	0	110	1	1.12	0.95;
	523	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	524	1	14.66	7.01	0	0	1	1	0	110	1	1.12	0.95;
	525	1	12.63	5.85	0	0	1	1	0	110	1	1.12	0.95;
	526	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	527	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	528	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	529	1	3.75	0.5	0	0	1	1	0	110	1	1.12	0.95;
	530	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	531	1	1.8	0	0	0	1	1	0	110	1	1.12	0.95;
	532	1	6.61	1.3	0	0	1	1	0	110	1	1.12	0.95;
	533	1	5.52	0.6	0	0	1	1	0	110	1	1.12	0.95;
	534	1	4.14	0.6	0	0	1	1	0	110	1	1.12	0.95;
	535	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	536	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	537	1	2.96	0.84	0	0	1	1	0	110	1	1.12	0.95;
	538	1	2.96	0.84	0	0	1	1	0	110	1	1.12	0.95;
	539	1	3.16	0.3	0	0	1	1	0	110	1	1.12	0.95;
	540	1	12.33	4	0	0	1	1	0	110	1	1.12	0.95;
	541	1	22	6.01	0	0	1	1	0	110	1	1.12	0.95;
	542	2	5.62	1.2	0	0	1	1	0	110	1	1.12	0.95;
	543	1	5.62	1.3	0	0	1	1	0	110	1	1.12	0.95;
	544	1	10.16	1	0	0	1	1	0	110	1	1.12	0.95;
	545	1	3.55	0.3	0	0	1	1	0	110	1	1.12	0.95;
	546	1	2.37	0.6	0	0	1	1	0	110	1	1.12	0.95;
	547	1	6.21	1.2	0	0	1	1	0	110	1	1.12	0.95;
	548	1	8.68	1.6	0	0	1	1	0	110	1	1.12	0.95;
	549	1	6.66	2	0	0	1	1	0	110	1	1.12	0.95;
	550	1	6.4	1	0	0	1	1	0	110	1	1.12	0.95;
	551	1	3.95	0.2	0	0	1	1	0	110	1	1.12	0.95;
	552	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	553	1	2.47	0.2	0	0	1	1	0	110	1	1.12	0.95;
	554	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	555	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	556	1	0	0	0	0	1	1	0	32	1	1.12	0.95;
	557	1	6.91	2.1	0	0	1	1	0	110	1	1.12	0.95;
	558	1	6.61	1.1	0	0	1	1	0	110	1	1.12	0.95;
	559	1	0.69	0.5	0	0	1	1	0	110	1	1.12	0.95;
	560	1	4.59	1.9	0	0	1	1	0	110	1	1.12	0.95;
	561	1	8.19	1.8	0	0	1	1	0	110	1	1.12	0.95;
	562	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	563	1	12.23	0.9	0	0	1	1	0	110	1	1.12	0.95;
	564	1	8.48	1.6	0	0	1	1	0	110	1	1.12	0.95;
	565	1	6.02	2.7	0	0	1	1	0	110	1	1.12	0.95;
	566	1	8.71	1	0	0	1	1	0	110	1	1.12	0.95;
	567	1	17.76	5.41	0	0	1	1	0	110	1	1.12	0.95;
	568	1	17.76	5.41	0	0	1	1	0	110	1	1.12	0.95;
	569	1	8.48	4.7	0	0	1	1	0	110	1	1.12	0.95;
	570	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	571	2	12.3	-2.23	0	0	1	1	0	110	1	1.12	0.95;
	572	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	573	1	5.38	1.8	0	0	1	1	0	110	1	1.12	0.95;
	574	1	5.38	1.7	0	0	1	1	0	110	1	1.12	0.95;
	575	1	9.27	2	0	0	1	1	0	110	1	1.12	0.95;
	576	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	577	1	7.33	2.53	0	0	1	1	0	110	1	1.12	0.95;
	578	1	7.33	2.62	0	0	1	1	0	110	1	1.12	0.95;
	579	1	9.64	4	0	0	1	1	0	110	1	1.12	0.95;
	580	2	8.98	3.4	0	0	1	1	0	110	1	1.12	0.95;
	581	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	582	1	10.95	2.9	0	0	1	1	0	110	1	1.12	0.95;
	583	1	7.89	0.2	0	0	1	1	0	110	1	1.12	0.95;
	584	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	585	1	5.42	1.8	0	0	1	1	0	110	1	1.12	0.95;
	586	1	5.23	2.1	0	0	1	1	0	110	1	1.12	0.95;
	587	2	8.99	2.2	0	0	1	1	0	110	1	1.12	0.95;
	588	1	7	2.1	0	0	1	1	0	110	1	1.12	0.95;
	589	1	5.13	1.89	0	0	1	1	0	110	1	1.12	0.95;
	590	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	591	1	6.4	3	0	0	1	1	0	110	1	1.12	0.95;
	592	1	4.75	1.8	0	0	1	1	0	110	1	1.12	0.95;
	593	1	9.67	3.4	0	0	1	1	0	110	1	1.12	0.95;
	594	1	8.09	3.1	0	0	1	1	0	110	1	1.12	0.95;
	595	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	596	1	7.89	0	0	0	1	1	0	110	1	1.12	0.95;
	597	1	3.16	0.8	0	0	1	1	0	110	1	1.12	0.95;
	598	1	4.54	1.2	0	0	1	1	0	110	1	1.12	0.95;
	599	2	17.76	6.51	0	0	1	1	0	110	1	1.12	0.95;
	600	1	5.62	1.2	0	0	1	1	0	110	1	1.12	0.95;
	601	1	6.41	2.57	0	0	1	1	0	110	1	1.12	0.95;
	602	1	14.5	5.35	0	0	1	1	0	110	1	1.12	0.95;
	603	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	604	1	1.09	-0.9	0	0	1	1	0	110	1	1.12	0.95;
	605	1	1.09	-0.9	0	0	1	1	0	110	1	1.12	0.95;
	606	1	1.78	0.6	0	0	1	1	0	110	1	1.12	0.95;
	607	1	1.18	0.8	0	0	1	1	0	110	1	1.12	0.95;
	608	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	609	1	9.27	1.5	0	0	1	1	0	110	1	1.12	0.95;
	610	1	13.25	5.37	0	0	1	1	0	110	1	1.12	0.95;
	611	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	612	1	3.21	0.84	0	0	1	1	0	110	1	1.12	0.95;
	613	1	4.49	3.8	0	0	1	1	0	110	1	1.12	0.95;
	614	1	9.84	3.6	0	0	1	1	0	110	1	1.12	0.95;
	615	1	7.84	3.2	0	0	1	1	0	110	1	1.12	0.95;
	616	1	3.95	0	0	0	1	1	0	110	1	1.12	0.95;
	617	1	4.3	1.4	0	0	1	1	0	110	1	1.12	0.95;
	618	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	619	1	32.03	8.01	0	0	1	1	0	110	1	1.12	0.95;
	620	1	1.48	-1	0	0	1	1	0	110	1	1.12	0.95;
	621	1	12.53	0.4	0	0	1	1	0	110	1	1.12	0.95;
	622	1	7.79	0.1	0	0	1	1	0	110	1	1.12	0.95;
	623	1	6.41	0.5	0	0	1	1	0	110	1	1.12	0.95;
	624	1	6.12	0.1	0	0	1	1	0	110	1	1.12	0.95;
	625	1	13.83	4.7	0	0	1	1	0	110	1	1.12	0.95;
	626	1	13.32	2	0	0	1	1	0	110	1	1.12	0.95;
	627	1	8.38	0.6	0	0	1	1	0	110	1	1.12	0.95;
	628	1	15.29	1.4	0	0	1	1	0	110	1	1.12	0.95;
	629	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	630	1	11.28	6.51	0	0	1	1	0	110	1	1.12	0.95;
	631	1	14.6	3.9	0	0	1	1	0	110	1	1.12	0.95;
	632	1	7.3	3.3	0	0	1	1	0	110	1	1.12	0.95;
	633	2	10.25	2.82	0	0	1	1	0	110	1	1.12	0.95;
	634	1	7.68	2.8	0	0	1	1	0	110	1	1.12	0.95;
	635	1	9.37	2.5	0	0	1	1	0	110	1	1.12	0.95;
	636	1	8.98	2.3	0	0	1	1	0	110	1	1.12	0.95;
	637	1	9.86	1.3	0	0	1	1	0	110	1	1.12	0.95;
	638	1	5.13	1.89	0	0	1	1	0	110	1	1.12	0.95;
	639	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	640	1	4.89	1.5	0	0	1	1	0	110	1	1.12	0.95;
	641	1	7.2	2.65	0	0	1	1	0	110	1	1.12	0.95;
	642	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	643	1	3.65	1.2	0	0	1	1	0	110	1	1.12	0.95;
	644	1	2.17	0.2	0	0	1	1	0	110	1	1.12	0.95;
	645	1	5.42	0	0	0	1	1	0	110	1	1.12	0.95;
	646	1	4.93	0	0	0	1	1	0	110	1	1.12	0.95;
	647	1	12.33	0	0	0	1	1	0	110	1	1.12	0.95;
	648	1	0.59	0.2	0	0	1	1	0	110	1	1.12	0.95;
	649	1	0.89	0.2	0	0	1	1	0	110	1	1.12	0.95;
	650	1	14.3	1.9	0	0	1	1	0	110	1	1.12	0.95;
	651	1	3.35	0.4	0	0	1	1	0	110	1	1.12	0.95;
	652	1	2.47	0.6	0	0	1	1	0	110	1	1.12	0.95;
	653	1	1.09	0.3	0	0	1	1	0	110	1	1.12	0.95;
	654	1	16.4	7.51	0	0	1	1	0	110	1	1.12	0.95;
	655	1	18.05	6.65	0	0	1	1	0	110	1	1.12	0.95;
	656	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	657	1	5.92	0.2	0	0	1	1	0	110	1	1.12	0.95;
	658	1	5.92	0.2	0	0	1	1	0	110	1	1.12	0.95;
	659	1	4.83	1.1	0	0	1	1	0	110	1	1.12	0.95;
	660	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	661	1	7.68	3.5	0	0	1	1	0	110	1	1.12	0.95;
	662	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	663	2	9.86	1.6	0	0	1	1	0	110	1	1.12	0.95;
	664	1	3.55	0.6	0	0	1	1	0	110	1	1.12	0.95;
	665	1	10.56	1.5	0	0	1	1	0	110	1	1.12	0.95;
	666	1	10.85	1.2	0	0	1	1	0	110	1	1.12	0.95;
	667	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	668	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	669	2	0.99	-14.55	0	0	1	1	0	110	1	1.12	0.95;
	670	1	0.99	0.3	0	0	1	1	0	110	1	1.12	0.95;
	671	1	3.45	1.05	0	0	1	1	0	110	1	1.12	0.95;
	672	1	3.45	1.05	0	0	1	1	0	110	1	1.12	0.95;
	673	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	674	1	5.92	0.5	0	0	1	1	0	110	1	1.12	0.95;
	675	1	17.76	5.41	0	0	1	1	0	110	1	1.12	0.95;
	676	1	17.76	5.41	0	0	1	1	0	110	1	1.12	0.95;
	677	1	15.29	3.88	0	0	1	1	0	110	1	1.12	0.95;
	678	1	15.29	3.88	0	0	1	1	0	110	1	1.12	0.95;
	679	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	680	1	4.93	1.4	0	0	1	1	0	110	1	1.12	0.95;
	681	1	13.32	4.19	0	0	1	1	0	110	1	1.12	0.95;
	682	1	13.32	4.19	0	0	1	1	0	110	1	1.12	0.95;
	683	1	4.93	4	0	0	1	1	0	110	1	1.12	0.95;
	684	1	5.13	2	0	0	1	1	0	110	1	1.12	0.95;
	685	1	5.13	2	0	0	1	1	0	110	1	1.12	0.95;
	686	1	3.33	1.2	0	0	1	1	0	110	1	1.12	0.95;
	687	1	4.62	2	0	0	1	1	0	110	1	1.12	0.95;
	688	1	6.12	1.86	0	0	1	1	0	110	1	1.12	0.95;
	689	1	6.12	1.86	0	0	1	1	0	110	1	1.12	0.95;
	690	1	12.33	4.63	0	0	1	1	0	110	1	1.12	0.95;
	691	1	12.33	4.63	0	0	1	1	0	110	1	1.12	0.95;
	692	1	11.84	3.84	0	0	1	1	0	110	1	1.12	0.95;
	693	1	11.84	3.84	0	0	1	1	0	110	1	1.12	0.95;
	694	1	9.37	3.61	0	0	1	1	0	110	1	1.12	0.95;
	695	1	9.37	3.61	0	0	1	1	0	110	1	1.12	0.95;
	696	1	4.93	0.8	0	0	1	1	0	110	1	1.12	0.95;
	697	1	22.98	7	0	0	1	1	0	110	1	1.12	0.95;
	698	1	40.34	12.28	0	0	1	1	0	110	1	1.12	0.95;
	699	1	3.65	1	0	0	1	1	0	110	1	1.12	0.95;
	700	1	2.76	0.6	0	0	1	1	0	110	1	1.12	0.95;
	701	1	18.35	7.38	0	0	1	1	0	110	1	1.12	0.95;
	702	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	703	1	5.92	4	0	0	1	1	0	110	1	1.12	0.95;
	704	1	1.48	0.35	0	0	1	1	0	110	1	1.12	0.95;
	705	1	1.48	0.35	0	0	1	1	0	110	1	1.12	0.95;
	706	1	2.47	0	0	0	1	1	0	110	1	1.12	0.95;
	707	1	6.41	1.69	0	0	1	1	0	110	1	1.12	0.95;
	708	1	6.41	1.69	0	0	1	1	0	110	1	1.12	0.95;
	709	1	0.79	0.24	0	0	1	1	0	110	1	1.12	0.95;
	710	1	0.79	0.24	0	0	1	1	0	110	1	1.12	0.95;
	711	1	10.36	4.1	0	0	1	1	0	110	1	1.12	0.95;
	712	1	10.36	4.1	0	0	1	1	0	110	1	1.12	0.95;
	713	1	9.86	2.8	0	0	1	1	0	110	1	1.12	0.95;
	714	1	9.86	2.8	0	0	1	1	0	110	1	1.12	0.95;
	715	1	5.12	1	0	0	1	1	0	110	1	1.12	0.95;
	716	1	10.51	4.6	0	0	1	1	0	110	1	1.12	0.95;
	717	1	10.65	-2.5	0	0	1	1	0	110	1	1.12	0.95;
	718	1	10.56	-2.6	0	0	1	1	0	110	1	1.12	0.95;
	719	1	18.74	6.66	0	0	1	1	0	110	1	1.12	0.95;
	720	1	18.74	6.66	0	0	1	1	0	110	1	1.12	0.95;
	721	1	7.89	2.4	0	0	1	1	0	110	1	1.12	0.95;
	722	1	7.89	2.4	0	0	1	1	0	110	1	1.12	0.95;
	723	1	8.88	2.34	0	0	1	1	0	110	1	1.12	0.95;
	724	1	8.88	2.34	0	0	1	1	0	110	1	1.12	0.95;
	725	1	20.72	7.15	0	0	1	1	0	110	1	1.12	0.95;
	726	1	20.72	7.15	0	0	1	1	0	110	1	1.12	0.95;
	727	1	5.42	1.65	0	0	1	1	0	110	1	1.12	0.95;
	728	1	5.42	1.65	0	0	1	1	0	110	1	1.12	0.95;
	729	1	2.07	0.4	0	0	1	1	0	110	1	1.12	0.95;
	730	1	3.23	1.14	0	0	1	1	0	110	1	1.12	0.95;
	731	1	5.23	1.43	0	0	1	1	0	110	1	1.12	0.95;
	732	1	9.37	2.85	0	0	1	1	0	110	1	1.12	0.95;
	733	1	9.37	2.85	0	0	1	1	0	110	1	1.12	0.95;
	734	1	20.72	6.52	0	0	1	1	0	110	1	1.12	0.95;
	735	1	20.72	6.52	0	0	1	1	0	110	1	1.12	0.95;
	736	1	19.73	7.81	0	0	1	1	0	110	1	1.12	0.95;
	737	1	19.73	7.81	0	0	1	1	0	110	1	1.12	0.95;
	738	1	4.14	0.4	0	0	1	1	0	110	1	1.12	0.95;
	739	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	740	2	27.7	27.23	0	0	1	1	0	110	1	1.12	0.95;
	741	2	24.7	24.23	0	0	1	1	0	110	1	1.12	0.95;
	742	1	13.81	4.91	0	0	1	1	0	110	1	1.12	0.95;
	743	1	13.81	4.91	0	0	1	1	0	110	1	1.12	0.95;
	744	1	7.89	2.48	0	0	1	1	0	110	1	1.12	0.95;
	745	1	7.89	2.48	0	0	1	1	0	110	1	1.12	0.95;
	746	1	19.24	9.47	0	0	1	1	0	110	1	1.12	0.95;
	747	1	19.24	9.47	0	0	1	1	0	110	1	1.12	0.95;
	748	1	11.34	3.45	0	0	1	1	0	110	1	1.12	0.95;
	749	1	11.34	3.45	0	0	1	1	0	110	1	1.12	0.95;
	750	1	11.84	4.44	0	0	1	1	0	110	1	1.12	0.95;
	751	1	11.84	4.45	0	0	1	1	0	110	1	1.12	0.95;
	752	1	20.72	10.72	0	0	1	1	0	110	1	1.12	0.95;
	753	1	20.72	10.72	0	0	1	1	0	110	1	1.12	0.95;
	754	1	7.69	2.34	0	0	1	1	0	110	1	1.12	0.95;
	755	1	7.69	2.34	0	0	1	1	0	110	1	1.12	0.95;
	756	1	12.33	3.38	0	0	1	1	0	110	1	1.12	0.95;
	757	1	12.33	3.38	0	0	1	1	0	110	1	1.12	0.95;
	758	1	14.3	4.65	0	0	1	1	0	110	1	1.12	0.95;
	759	1	14.3	4.64	0	0	1	1	0	110	1	1.12	0.95;
	760	1	5.92	1.62	0	0	1	1	0	110	1	1.12	0.95;
	761	1	5.92	1.62	0	0	1	1	0	110	1	1.12	0.95;
	762	2	19.73	8.01	0	0	1	1	0	110	1	1.12	0.95;
	763	1	19.73	8.01	0	0	1	1	0	110	1	1.12	0.95;
	764	2	4.62	1.5	0	0	1	1	0	110	1	1.12	0.95;
	765	1	8.2	3	0	0	1	1	0	110	1	1.12	0.95;
	766	1	4.44	0.2	0	0	1	1	0	110	1	1.12	0.95;
	767	1	8.38	1.6	0	0	1	1	0	110	1	1.12	0.95;
	768	1	6.41	0.7	0	0	1	1	0	110	1	1.12	0.95;
	769	1	4.1	2	0	0	1	1	0	110	1	1.12	0.95;
	770	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	771	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	772	2	12.91	6.31	0	0	1	1	0	110	1	1.12	0.95;
	773	2	24.91	16.31	0	0	1	1	0	110	1	1.12	0.95;
	774	2	0	-12.17	0	0	1	1	0	110	1	1.12	0.95;
	775	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	776	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	777	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	778	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	779	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	780	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	781	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	782	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	783	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	784	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	785	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	786	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	787	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	788	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	789	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	790	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	791	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	792	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	793	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	794	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	795	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	796	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	797	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	798	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	799	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	800	1	8.02	2	0	0	1	1	0	110	1	1.12	0.95;
	801	1	5.82	2.21	0	0	1	1	0	110	1	1.12	0.95;
	802	1	6.02	2.43	0	0	1	1	0	110	1	1.12	0.95;
	803	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	804	1	3.56	0.4	0	0	1	1	0	110	1	1.12	0.95;
	805	1	5.42	1	0	0	1	1	0	110	1	1.12	0.95;
	806	1	6.41	1	0	0	1	1	0	110	1	1.12	0.95;
	807	1	2.07	0.6	0	0	1	1	0	110	1	1.12	0.95;
	808	1	2.07	0.6	0	0	1	1	0	110	1	1.12	0.95;
	809	2	7.79	1	0	0	1	1	0	110	1	1.12	0.95;
	810	1	7.79	1	0	0	1	1	0	110	1	1.12	0.95;
	811	1	7.3	3.37	0	0	1	1	0	110	1	1.12	0.95;
	812	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	813	1	0.59	0.2	0	0	1	1	0	110	1	1.12	0.95;
	814	1	2.47	0.1	0	0	1	1	0	110	1	1.12	0.95;
	815	1	2.47	0.1	0	0	1	1	0	110	1	1.12	0.95;
	816	1	1.18	0.3	0	0	1	1	0	110	1	1.12	0.95;
	817	1	0.4	0.1	0	0	1	1	0	110	1	1.12	0.95;
	818	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	819	1	1.97	0.6	0	0	1	1	0	110	1	1.12	0.95;
	820	1	1.97	0.6	0	0	1	1	0	110	1	1.12	0.95;
	821	1	0.1	0.04	0	0	1	1	0	110	1	1.12	0.95;
	822	1	0.1	0.04	0	0	1	1	0	110	1	1.12	0.95;
	823	1	2.17	1	0	0	1	1	0	110	1	1.12	0.95;
	824	1	2.07	1	0	0	1	1	0	110	1	1.12	0.95;
	825	1	12.82	1.3	0	0	1	1	0	110	1	1.12	0.95;
	826	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	827	1	4.44	1.63	0	0	1	1	0	110	1	1.12	0.95;
	828	1	6.91	1	0	0	1	1	0	110	1	1.12	0.95;
	829	2	7.79	-0.38	0	0	1	1	0	110	1	1.12	0.95;
	830	1	0	0	0	0	1	1	0	110	1	1.12	0.95;
	831	1	6.51	3.1	0	0	1	1	0	110	1	1.12	0.95;
	832	1	7.89	2	0	0	1	1	0	110	1	1.12	0.95;
	833	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	834	1	6.66	0.3	0	0	1	1	0	110	2	1.12	0.95;
	835	1	2.18	0.4	0	0	1	1	0	110	2	1.12	0.95;
	836	1	6.26	1.2	0	0	1	1	0	110	2	1.12	0.95;
	837	1	8.14	1.2	0	0	1	1	0	110	2	1.12	0.95;
	838	1	6.16	0.8	0	0	1	1	0	110	2	1.12	0.95;
	839	1	13.9	2.5	0	0	1	1	0	110	2	1.12	0.95;
	840	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	841	1	18.87	5.01	0	0	1	1	0	110	2	1.12	0.95;
	842	1	8.94	2.5	0	0	1	1	0	110	2	1.12	0.95;
	843	1	4.57	1.1	0	0	1	1	0	110	2	1.12	0.95;
	844	2	16.39	4.21	0	0	1	1	0	110	2	1.12	0.95;
	845	1	4.07	0	0	0	1	1	0	110	2	1.12	0.95;
	846	1	5.96	0.5	0	0	1	1	0	110	2	1.12	0.95;
	847	1	2.61	0	0	0	1	1	0	110	2	1.12	0.95;
	848	1	7.05	1.3	0	0	1	1	0	110	2	1.12	0.95;
	849	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	850	1	14.3	1.6	0	0	1	1	0	110	2	1.12	0.95;
	851	1	2.48	0.7	0	0	1	1	0	110	2	1.12	0.95;
	852	1	3.38	0.4	0	0	1	1	0	110	2	1.12	0.95;
	853	2	11.12	0.98	0	0	1	1	0	110	2	1.12	0.95;
	854	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	855	1	10.92	0.5	0	0	1	1	0	110	2	1.12	0.95;
	856	1	4.97	0.5	0	0	1	1	0	110	2	1.12	0.95;
	857	1	7.3	3.6	0	0	1	1	0	110	2	1.12	0.95;
	858	1	6.95	1.7	0	0	1	1	0	110	2	1.12	0.95;
	859	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	860	1	14.9	4	0	0	1	1	0	110	2	1.12	0.95;
	861	1	11.92	2	0	0	1	1	0	110	2	1.12	0.95;
	862	1	6.65	0.1	0	0	1	1	0	110	2	1.12	0.95;
	863	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	864	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	865	1	6.85	0.9	0	0	1	1	0	110	2	1.12	0.95;
	866	1	5.96	1	0	0	1	1	0	110	2	1.12	0.95;
	867	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	868	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	869	1	6.46	0.5	0	0	1	1	0	110	2	1.12	0.95;
	870	1	7.65	1.1	0	0	1	1	0	110	2	1.12	0.95;
	871	1	7.85	0.6	0	0	1	1	0	110	2	1.12	0.95;
	872	1	3.48	0.3	0	0	1	1	0	110	2	1.12	0.95;
	873	1	2.98	0.5	0	0	1	1	0	110	2	1.12	0.95;
	874	1	5.46	0.8	0	0	1	1	0	110	2	1.12	0.95;
	875	1	2.98	0.5	0	0	1	1	0	110	2	1.12	0.95;
	876	2	6.1	17	0	0	1	1	0	110	2	1.12	0.95;
	877	1	5.16	1.8	0	0	1	1	0	110	2	1.12	0.95;
	878	1	24.83	9.51	0	0	1	1	0	110	2	1.12	0.95;
	879	2	4.57	0.67	0	0	1	1	0	110	2	1.12	0.95;
	880	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	881	1	3.48	1	0	0	1	1	0	110	2	1.12	0.95;
	882	1	5.56	2.6	0	0	1	1	0	110	2	1.12	0.95;
	883	1	10.92	1.6	0	0	1	1	0	110	2	1.12	0.95;
	884	1	4.57	0.9	0	0	1	1	0	110	2	1.12	0.95;
	885	1	11.22	0	0	0	1	1	0	110	2	1.12	0.95;
	886	2	4.07	0.7	0	0	1	1	0	110	2	1.12	0.95;
	887	2	9.34	0.85	0	0	1	1	0	110	2	1.12	0.95;
	888	1	6.95	1	0	0	1	1	0	110	2	1.12	0.95;
	889	1	25.82	9.01	0	0	1	1	0	110	2	1.12	0.95;
	890	1	8.94	3	0	0	1	1	0	110	2	1.12	0.95;
	891	1	12.91	6.01	0	0	1	1	0	110	2	1.12	0.95;
	892	1	13.9	4	0	0	1	1	0	110	2	1.12	0.95;
	893	1	7.55	1.1	0	0	1	1	0	110	2	1.12	0.95;
	894	1	6.79	1.58	0	0	1	1	0	110	2	1.12	0.95;
	895	1	3.77	1.8	0	0	1	1	0	110	2	1.12	0.95;
	896	1	4.97	1	0	0	1	1	0	110	2	1.12	0.95;
	897	1	7.45	1	0	0	1	1	0	110	2	1.12	0.95;
	898	1	10.73	0	0	0	1	1	0	110	2	1.12	0.95;
	899	1	2.98	0	0	0	1	1	0	110	2	1.12	0.95;
	900	1	7.45	20.02	0	0	1	1	0	110	2	1.12	0.95;
	901	1	2.88	0.6	0	0	1	1	0	110	2	1.12	0.95;
	902	1	5.96	1.5	0	0	1	1	0	110	2	1.12	0.95;
	903	1	2.29	0.7	0	0	1	1	0	110	2	1.12	0.95;
	904	1	3.77	0.8	0	0	1	1	0	110	2	1.12	0.95;
	905	1	2.98	1	0	0	1	1	0	110	2	1.12	0.95;
	906	1	3.11	1	0	0	1	1	0	110	2	1.12	0.95;
	907	1	1.49	0.5	0	0	1	1	0	110	2	1.12	0.95;
	908	1	11.62	2.4	0	0	1	1	0	110	2	1.12	0.95;
	909	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	910	1	3.68	0.91	0	0	1	1	0	110	2	1.12	0.95;
	911	1	3.04	1	0	0	1	1	0	110	2	1.12	0.95;
	912	1	12.89	2.74	0	0	1	1	0	110	2	1.12	0.95;
	913	1	0.87	0	0	0	1	1	0	110	2	1.12	0.95;
	914	1	32.28	6.01	0	0	1	1	0	110	2	1.12	0.95;
	915	1	14.9	2	0	0	1	1	0	110	2	1.12	0.95;
	916	1	10.43	1	0	0	1	1	0	110	2	1.12	0.95;
	917	1	0.87	0	0	0	1	1	0	110	2	1.12	0.95;
	918	1	0.99	0	0	0	1	1	0	110	2	1.12	0.95;
	919	1	4.37	2.2	0	0	1	1	0	110	2	1.12	0.95;
	920	1	6.06	0.9	0	0	1	1	0	110	2	1.12	0.95;
	921	1	3.97	1	0	0	1	1	0	110	2	1.12	0.95;
	922	2	13	30	0	0	1	1	0	110	2	1.12	0.95;
	923	2	0	-0.46	0	0	1	1	0	110	2	1.12	0.95;
	924	1	4.97	0.5	0	0	1	1	0	110	2	1.12	0.95;
	925	1	22.84	5.51	0	0	1	1	0	110	2	1.12	0.95;
	926	1	0.99	0	0	0	1	1	0	110	2	1.12	0.95;
	927	1	6.36	1.5	0	0	1	1	0	110	2	1.12	0.95;
	928	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	929	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	930	1	10.03	2.3	0	0	1	1	0	110	2	1.12	0.95;
	931	2	11.67	5.15	0	0	1	1	0	110	2	1.12	0.95;
	932	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	933	1	5.76	1.8	0	0	1	1	0	110	2	1.12	0.95;
	934	1	5.16	1.2	0	0	1	1	0	110	2	1.12	0.95;
	935	1	9.93	1.5	0	0	1	1	0	110	2	1.12	0.95;
	936	1	2.98	1	0	0	1	1	0	110	2	1.12	0.95;
	937	2	13.61	2.27	0	0	1	1	0	110	2	1.12	0.95;
	938	1	6.95	1.5	0	0	1	1	0	110	2	1.12	0.95;
	939	1	6.46	0.5	0	0	1	1	0	110	2	1.12	0.95;
	940	1	17.88	2.5	0	0	1	1	0	110	2	1.12	0.95;
	941	1	12.41	3.5	0	0	1	1	0	110	2	1.12	0.95;
	942	1	16.59	4.91	0	0	1	1	0	110	2	1.12	0.95;
	943	1	8.94	3.2	0	0	1	1	0	110	2	1.12	0.95;
	944	1	18.57	4.83	0	0	1	1	0	110	2	1.12	0.95;
	945	1	8.29	0.2	0	0	1	1	0	110	2	1.12	0.95;
	946	1	14.76	1.61	0	0	1	1	0	110	2	1.12	0.95;
	947	2	0.47	-0.19	0	0	1	1	0	110	2	1.12	0.95;
	948	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	949	1	11.92	1.2	0	0	1	1	0	110	2	1.12	0.95;
	950	1	5.96	0.6	0	0	1	1	0	110	2	1.12	0.95;
	951	1	4.67	2.3	0	0	1	1	0	110	2	1.12	0.95;
	952	1	10.11	2.78	0	0	1	1	0	110	2	1.12	0.95;
	953	2	0	-0.12	0	0	1	1	0	110	2	1.12	0.95;
	954	1	4.75	0.8	0	0	1	1	0	110	2	1.12	0.95;
	955	1	10.58	1.39	0	0	1	1	0	110	2	1.12	0.95;
	956	1	6.95	1.5	0	0	1	1	0	110	2	1.12	0.95;
	957	1	8.04	3.08	0	0	1	1	0	110	2	1.12	0.95;
	958	1	3.67	0.9	0	0	1	1	0	110	2	1.12	0.95;
	959	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	960	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	961	1	2.68	0	0	0	1	1	0	110	2	1.12	0.95;
	962	1	12.22	1.82	0	0	1	1	0	110	2	1.12	0.95;
	963	1	13.59	1.38	0	0	1	1	0	110	2	1.12	0.95;
	964	1	16.27	2.31	0	0	1	1	0	110	2	1.12	0.95;
	965	1	2.16	0.12	0	0	1	1	0	110	2	1.12	0.95;
	966	1	0.65	0.06	0	0	1	1	0	110	2	1.12	0.95;
	967	2	10.62	0.73	0	0	1	1	0	110	2	1.12	0.95;
	968	1	4.27	0.6	0	0	1	1	0	110	2	1.12	0.95;
	969	1	11	1.63	0	0	1	1	0	110	2	1.12	0.95;
	970	2	1.99	-0.29	0	0	1	1	0	110	2	1.12	0.95;
	971	1	0.99	1	0	0	1	1	0	110	2	1.12	0.95;
	972	1	2.48	0	0	0	1	1	0	110	2	1.12	0.95;
	973	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	974	1	10.92	3	0	0	1	1	0	110	2	1.12	0.95;
	975	1	9.83	2.5	0	0	1	1	0	110	2	1.12	0.95;
	976	1	2.38	0	0	0	1	1	0	110	2	1.12	0.95;
	977	1	6.95	3	0	0	1	1	0	110	2	1.12	0.95;
	978	1	0.99	0	0	0	1	1	0	110	2	1.12	0.95;
	979	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	980	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	981	1	15.29	2.8	0	0	1	1	0	110	2	1.12	0.95;
	982	1	24.83	5.01	0	0	1	1	0	110	2	1.12	0.95;
	983	1	6.52	3.9	0	0	1	1	0	110	2	1.12	0.95;
	984	1	5.96	1	0	0	1	1	0	110	2	1.12	0.95;
	985	2	24.73	8.21	0	0	1	1	0	110	2	1.12	0.95;
	986	1	6.46	1	0	0	1	1	0	110	2	1.12	0.95;
	987	1	16.49	0.8	0	0	1	1	0	110	2	1.12	0.95;
	988	1	4.07	0.7	0	0	1	1	0	110	2	1.12	0.95;
	989	1	5.46	1.4	0	0	1	1	0	110	2	1.12	0.95;
	990	2	15.79	2	0	0	1	1	0	110	2	1.12	0.95;
	991	1	7.75	2.9	0	0	1	1	0	110	2	1.12	0.95;
	992	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	993	1	2.98	0	0	0	1	1	0	110	2	1.12	0.95;
	994	1	3.97	1	0	0	1	1	0	110	2	1.12	0.95;
	995	2	8.63	1.7	0	0	1	1	0	110	2	1.12	0.95;
	996	1	0.1	0	0	0	1	1	0	110	2	1.12	0.95;
	997	1	2.48	1	0	0	1	1	0	110	2	1.12	0.95;
	998	1	5.66	0.2	0	0	1	1	0	110	2	1.12	0.95;
	999	1	39.72	9.51	0	0	1	1	0	110	2	1.12	0.95;
	1000	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1001	1	5.12	0	0	0	1	1	0	110	2	1.12	0.95;
	1002	1	1.49	0.4	0	0	1	1	0	110	2	1.12	0.95;
	1003	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1004	1	69.52	30.03	0	0	1	1	0	110	2	1.12	0.95;
	1005	1	5.12	0	0	0	1	1	0	110	2	1.12	0.95;
	1006	2	14.4	3.71	0	0	1	1	0	110	2	1.12	0.95;
	1007	1	36.15	3.5	0	0	1	1	0	110	2	1.12	0.95;
	1008	1	6.26	1.1	0	0	1	1	0	110	2	1.12	0.95;
	1009	1	7.15	0.4	0	0	1	1	0	110	2	1.12	0.95;
	1010	1	3.97	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1011	2	13	30	0	0	1	1	0	110	2	1.12	0.95;
	1012	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1013	2	0	-0.57	0	0	1	1	0	110	2	1.12	0.95;
	1014	1	4.47	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1015	1	4.97	1	0	0	1	1	0	110	2	1.12	0.95;
	1016	2	0.99	-0.12	0	0	1	1	0	110	2	1.12	0.95;
	1017	1	6.36	0.3	0	0	1	1	0	110	2	1.12	0.95;
	1018	1	9.44	0.2	0	0	1	1	0	110	2	1.12	0.95;
	1019	1	2.23	-0.83	0	0	1	1	0	110	2	1.12	0.95;
	1020	1	4.37	0.3	0	0	1	1	0	110	2	1.12	0.95;
	1021	1	2.18	0.7	0	0	1	1	0	110	2	1.12	0.95;
	1022	1	5.46	2	0	0	1	1	0	110	2	1.12	0.95;
	1023	1	17.58	4.6	0	0	1	1	0	110	2	1.12	0.95;
	1024	1	6.95	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1025	1	1.99	1.1	0	0	1	1	0	110	2	1.12	0.95;
	1026	1	8.14	0	0	0	1	1	0	110	2	1.12	0.95;
	1027	1	12.81	1	0	0	1	1	0	110	2	1.12	0.95;
	1028	1	4.65	0	0	0	1	1	0	110	2	1.12	0.95;
	1029	1	5.56	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1030	1	16.88	5.01	0	0	1	1	0	110	2	1.12	0.95;
	1031	1	29.79	9.01	0	0	1	1	0	110	2	1.12	0.95;
	1032	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1033	1	12.61	1.6	0	0	1	1	0	110	2	1.12	0.95;
	1034	1	8.94	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1035	1	1.49	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1036	2	0	1.9	0	0	1	1	0	110	2	1.12	0.95;
	1037	1	13.01	4.1	0	0	1	1	0	110	2	1.12	0.95;
	1038	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1039	1	14.4	2.5	0	0	1	1	0	110	2	1.12	0.95;
	1040	1	2.78	0.6	0	0	1	1	0	110	2	1.12	0.95;
	1041	1	16.59	4	0	0	1	1	0	110	2	1.12	0.95;
	1042	2	6.95	1.83	0	0	1	1	0	110	2	1.12	0.95;
	1043	1	4.97	1	0	0	1	1	0	110	2	1.12	0.95;
	1044	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1045	1	9.93	2	0	0	1	1	0	110	2	1.12	0.95;
	1046	1	14.9	3	0	0	1	1	0	110	2	1.12	0.95;
	1047	1	11.92	2	0	0	1	1	0	110	2	1.12	0.95;
	1048	1	4.67	2.1	0	0	1	1	0	110	2	1.12	0.95;
	1049	1	11.02	2.2	0	0	1	1	0	110	2	1.12	0.95;
	1050	1	5.66	1.6	0	0	1	1	0	110	2	1.12	0.95;
	1051	1	10.33	2.6	0	0	1	1	0	110	2	1.12	0.95;
	1052	1	6.95	0	0	0	1	1	0	110	2	1.12	0.95;
	1053	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1054	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1055	1	0.99	0	0	0	1	1	0	110	2	1.12	0.95;
	1056	1	18.37	6.01	0	0	1	1	0	110	2	1.12	0.95;
	1057	2	13.41	2.3	0	0	1	1	0	110	2	1.12	0.95;
	1058	1	5.54	2.25	0	0	1	1	0	110	2	1.12	0.95;
	1059	1	4.17	1.2	0	0	1	1	0	110	2	1.12	0.95;
	1060	2	2.68	1.03	0	0	1	1	0	110	2	1.12	0.95;
	1061	1	2.98	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1062	2	5.82	3.04	0	0	1	1	0	110	2	1.12	0.95;
	1063	1	5.96	1	0	0	1	1	0	110	2	1.12	0.95;
	1064	1	13.06	3.5	0	0	1	1	0	110	2	1.12	0.95;
	1065	1	5.96	1.5	0	0	1	1	0	110	2	1.12	0.95;
	1066	1	11.92	1	0	0	1	1	0	110	2	1.12	0.95;
	1067	2	4.87	1.2	0	0	1	1	0	110	2	1.12	0.95;
	1068	1	8.34	0.9	0	0	1	1	0	110	2	1.12	0.95;
	1069	1	4.07	0.8	0	0	1	1	0	110	2	1.12	0.95;
	1070	1	6.46	3.7	0	0	1	1	0	110	2	1.12	0.95;
	1071	2	0	1	0	0	1	1	0	110	2	1.12	0.95;
	1072	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1073	1	2.98	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1074	1	3.97	1	0	0	1	1	0	110	2	1.12	0.95;
	1075	1	3.97	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1076	1	14.1	2.9	0	0	1	1	0	110	2	1.12	0.95;
	1077	1	4.97	0.3	0	0	1	1	0	110	2	1.12	0.95;
	1078	1	19.86	6.01	0	0	1	1	0	110	2	1.12	0.95;
	1079	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1080	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1081	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1082	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1083	1	6.85	1.7	0	0	1	1	0	110	2	1.12	0.95;
	1084	1	2.98	0.5	0	0	1	1	0	110	2	1.12	0.95;
	1085	1	11.92	2	0	0	1	1	0	110	2	1.12	0.95;
	1086	2	14.84	28.52	0	0	1	1	0	110	2	1.12	0.95;
	1087	2	31.55	28.52	0	0	1	1	0	110	2	1.12	0.95;
	1088	1	8.64	3.4	0	0	1	1	0	110	2	1.12	0.95;
	1089	1	0.99	0	0	0	1	1	0	110	2	1.12	0.95;
	1090	1	11.02	3.3	0	0	1	1	0	110	2	1.12	0.95;
	1091	1	6.16	2	0	0	1	1	0	110	2	1.12	0.95;
	1092	1	7.65	0.8	0	0	1	1	0	110	2	1.12	0.95;
	1093	1	6.26	1.7	0	0	1	1	0	110	2	1.12	0.95;
	1094	1	9.44	2.1	0	0	1	1	0	110	2	1.12	0.95;
	1095	1	12.02	2.9	0	0	1	1	0	110	2	1.12	0.95;
	1096	1	5.46	1.7	0	0	1	1	0	110	2	1.12	0.95;
	1097	1	2.48	0.1	0	0	1	1	0	110	2	1.12	0.95;
	1098	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1099	2	4.67	-0.12	0	0	1	1	0	110	2	1.12	0.95;
	1100	1	1.49	1	0	0	1	1	0	110	2	1.12	0.95;
	1101	1	4.77	0.8	0	0	1	1	0	110	2	1.12	0.95;
	1102	1	10.92	4	0	0	1	1	0	110	2	1.12	0.95;
	1103	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1104	1	3.93	1.8	0	0	1	1	0	110	2	1.12	0.95;
	1105	1	8.08	2.15	0	0	1	1	0	110	2	1.12	0.95;
	1106	1	7.95	1	0	0	1	1	0	110	2	1.12	0.95;
	1107	1	5.96	0.6	0	0	1	1	0	110	2	1.12	0.95;
	1108	1	4.97	2	0	0	1	1	0	110	2	1.12	0.95;
	1109	1	10.92	1	0	0	1	1	0	110	2	1.12	0.95;
	1110	1	10.2	1.13	0	0	1	1	0	110	2	1.12	0.95;
	1111	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1112	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1113	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1114	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1115	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1116	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1117	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1118	1	11.32	1.3	0	0	1	1	0	110	2	1.12	0.95;
	1119	1	5.52	0	0	0	1	1	0	110	2	1.12	0.95;
	1120	1	2.58	1.4	0	0	1	1	0	110	2	1.12	0.95;
	1121	1	0	0	0	0	1	1	0	110	2	1.12	0.95;
	1122	1	3.48	1	0	0	1	1	0	110	2	1.12	0.95;
	1123	1	3.08	1.7	0	0	1	1	0	110	2	1.12	0.95;
	1124	1	7.45	0	0	0	1	1	0	110	2	1.12	0.95;
	1125	1	7.75	2.2	0	0	1	1	0	110	2	1.12	0.95;
	1126	2	2.98	0.79	0	0	1	1	0	110	2	1.12	0.95;
	1127	1	6.95	1.5	0	0	1	1	0	110	2	1.12	0.95;
	1128	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1129	1	0.53	-0.4	0	0	1	1	0	110	3	1.12	0.95;
	1130	1	3.3	0.15	0	0	1	1	0	110	3	1.12	0.95;
	1131	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1132	2	53.02	34.91	0	0	1	1	0	110	3	1.12	0.95;
	1133	2	0	0.57	0	0	1	1	0	110	3	1.12	0.95;
	1134	1	1.85	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1135	1	8.55	4.17	0	0	1	1	0	110	3	1.12	0.95;
	1136	1	1.5	0.07	0	0	1	1	0	110	3	1.12	0.95;
	1137	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1138	1	4.28	1.58	0	0	1	1	0	110	3	1.12	0.95;
	1139	1	7.77	3.02	0	0	1	1	0	110	3	1.12	0.95;
	1140	1	9.14	4.42	0	0	1	1	0	110	3	1.12	0.95;
	1141	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1142	1	10.81	1.95	0	0	1	1	0	110	3	1.12	0.95;
	1143	1	7.5	2.45	0	0	1	1	0	110	3	1.12	0.95;
	1144	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1145	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1146	1	11.22	4.72	0	0	1	1	0	110	3	1.12	0.95;
	1147	1	3.21	2.41	0	0	1	1	0	110	3	1.12	0.95;
	1148	1	5.48	2.3	0	0	1	1	0	110	3	1.12	0.95;
	1149	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1150	1	18.76	5.17	0	0	1	1	0	110	3	1.12	0.95;
	1151	1	17.34	4.51	0	0	1	1	0	110	3	1.12	0.95;
	1152	1	12.85	4.82	0	0	1	1	0	110	3	1.12	0.95;
	1153	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1154	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1155	1	6.53	2.47	0	0	1	1	0	110	3	1.12	0.95;
	1156	1	2.89	1.04	0	0	1	1	0	110	3	1.12	0.95;
	1157	1	7.28	2.86	0	0	1	1	0	110	3	1.12	0.95;
	1158	1	4.23	1.79	0	0	1	1	0	110	3	1.12	0.95;
	1159	1	2.94	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1160	1	2.14	1.13	0	0	1	1	0	110	3	1.12	0.95;
	1161	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1162	1	7.48	6.32	0	0	1	1	0	110	3	1.12	0.95;
	1163	1	6.62	3.71	0	0	1	1	0	110	3	1.12	0.95;
	1164	2	4.18	3.46	0	0	1	1	0	110	3	1.12	0.95;
	1165	1	7.49	4.58	0	0	1	1	0	110	3	1.12	0.95;
	1166	1	8.7	5.52	0	0	1	1	0	110	3	1.12	0.95;
	1167	1	3.74	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1168	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1169	1	10	2.58	0	0	1	1	0	110	3	1.12	0.95;
	1170	1	4.7	2.7	0	0	1	1	0	110	3	1.12	0.95;
	1171	1	8.01	2.51	0	0	1	1	0	110	3	1.12	0.95;
	1172	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1173	1	0.75	0.39	0	0	1	1	0	110	3	1.12	0.95;
	1174	1	2.78	1.04	0	0	1	1	0	110	3	1.12	0.95;
	1175	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1176	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1177	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1178	1	0.85	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1179	1	2.18	1.15	0	0	1	1	0	110	3	1.12	0.95;
	1180	1	2.31	0.45	0	0	1	1	0	110	3	1.12	0.95;
	1181	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1182	1	7.7	2.56	0	0	1	1	0	110	3	1.12	0.95;
	1183	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1184	1	6.52	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1185	1	0.85	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1186	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1187	1	8.65	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1188	2	12.51	7.51	0	0	1	1	0	110	3	1.12	0.95;
	1189	2	2	4	0	0	1	1	0	110	3	1.12	0.95;
	1190	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1191	1	5.03	1.89	0	0	1	1	0	110	3	1.12	0.95;
	1192	1	7.46	3.04	0	0	1	1	0	110	3	1.12	0.95;
	1193	1	7.28	3.16	0	0	1	1	0	110	3	1.12	0.95;
	1194	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1195	1	16.93	-0.04	0	0	1	1	0	110	3	1.12	0.95;
	1196	1	8.23	2.16	0	0	1	1	0	110	3	1.12	0.95;
	1197	1	8.77	2.66	0	0	1	1	0	110	3	1.12	0.95;
	1198	1	0.32	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1199	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1200	1	10.15	4.01	0	0	1	1	0	110	3	1.12	0.95;
	1201	1	16.56	7.02	0	0	1	1	0	110	3	1.12	0.95;
	1202	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1203	1	16.61	6.22	0	0	1	1	0	110	3	1.12	0.95;
	1204	1	15.01	4.66	0	0	1	1	0	110	3	1.12	0.95;
	1205	1	0	0.12	0	0	1	1	0	110	3	1.12	0.95;
	1206	1	1.87	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1207	1	3.34	1.42	0	0	1	1	0	110	3	1.12	0.95;
	1208	1	6.84	2.21	0	0	1	1	0	110	3	1.12	0.95;
	1209	1	13.14	4.11	0	0	1	1	0	110	3	1.12	0.95;
	1210	1	3.63	1.3	0	0	1	1	0	110	3	1.12	0.95;
	1211	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1212	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1213	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1214	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1215	1	3.21	0.76	0	0	1	1	0	110	3	1.12	0.95;
	1216	1	13.52	5.03	0	0	1	1	0	110	3	1.12	0.95;
	1217	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1218	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1219	1	7.17	2.43	0	0	1	1	0	110	3	1.12	0.95;
	1220	1	4.81	1.73	0	0	1	1	0	110	3	1.12	0.95;
	1221	1	9.2	2.65	0	0	1	1	0	110	3	1.12	0.95;
	1222	1	8.88	2.63	0	0	1	1	0	110	3	1.12	0.95;
	1223	1	6.38	-0.16	0	0	1	1	0	110	3	1.12	0.95;
	1224	1	5.22	0.76	0	0	1	1	0	110	3	1.12	0.95;
	1225	1	7.38	3.26	0	0	1	1	0	110	3	1.12	0.95;
	1226	1	9.71	3.89	0	0	1	1	0	110	3	1.12	0.95;
	1227	1	2.88	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1228	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1229	1	5.29	3.04	0	0	1	1	0	110	3	1.12	0.95;
	1230	1	4.62	3.14	0	0	1	1	0	110	3	1.12	0.95;
	1231	1	6.31	2.2	0	0	1	1	0	110	3	1.12	0.95;
	1232	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1233	1	10.68	2.91	0	0	1	1	0	110	3	1.12	0.95;
	1234	1	4.27	1	0	0	1	1	0	110	3	1.12	0.95;
	1235	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1236	1	5.03	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1237	1	3.96	2.39	0	0	1	1	0	110	3	1.12	0.95;
	1238	1	1.92	0.71	0	0	1	1	0	110	3	1.12	0.95;
	1239	1	4.92	1.44	0	0	1	1	0	110	3	1.12	0.95;
	1240	1	5.35	2.18	0	0	1	1	0	110	3	1.12	0.95;
	1241	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1242	1	6.33	2.49	0	0	1	1	0	110	3	1.12	0.95;
	1243	1	5.88	2.49	0	0	1	1	0	110	3	1.12	0.95;
	1244	1	11.22	4.34	0	0	1	1	0	110	3	1.12	0.95;
	1245	1	5.91	0.86	0	0	1	1	0	110	3	1.12	0.95;
	1246	1	4.03	0.97	0	0	1	1	0	110	3	1.12	0.95;
	1247	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1248	1	1.07	0	0	0	1	1	0	110	3	1.12	0.95;
	1249	1	4.29	2.79	0	0	1	1	0	110	3	1.12	0.95;
	1250	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1251	1	5.25	1.02	0	0	1	1	0	110	3	1.12	0.95;
	1252	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1253	1	6.53	1.48	0	0	1	1	0	110	3	1.12	0.95;
	1254	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1255	1	4.27	3.01	0	0	1	1	0	110	3	1.12	0.95;
	1256	1	2.24	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1257	1	6.69	1.87	0	0	1	1	0	110	3	1.12	0.95;
	1258	1	3.72	0.44	0	0	1	1	0	110	3	1.12	0.95;
	1259	1	4.38	0.98	0	0	1	1	0	110	3	1.12	0.95;
	1260	1	4.06	0.4	0	0	1	1	0	110	3	1.12	0.95;
	1261	1	4.7	1.87	0	0	1	1	0	110	3	1.12	0.95;
	1262	1	4.45	1.77	0	0	1	1	0	110	3	1.12	0.95;
	1263	2	23.61	21.1	0	0	1	1	0	110	3	1.12	0.95;
	1264	2	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1265	1	4.97	1.98	0	0	1	1	0	110	3	1.12	0.95;
	1266	1	2.4	1.02	0	0	1	1	0	110	3	1.12	0.95;
	1267	1	6.62	5.42	0	0	1	1	0	110	3	1.12	0.95;
	1268	2	0.01	0.01	0	0	1	1	0	110	3	1.12	0.95;
	1269	1	9.41	3.64	0	0	1	1	0	110	3	1.12	0.95;
	1270	1	4.09	1.69	0	0	1	1	0	110	3	1.12	0.95;
	1271	1	0.85	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1272	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1273	1	6.31	1.12	0	0	1	1	0	110	3	1.12	0.95;
	1274	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1275	1	2.99	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1276	1	3.63	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1277	1	6.8	3.54	0	0	1	1	0	110	3	1.12	0.95;
	1278	1	4.18	1.44	0	0	1	1	0	110	3	1.12	0.95;
	1279	1	5.46	2.31	0	0	1	1	0	110	3	1.12	0.95;
	1280	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1281	1	10.09	2.45	0	0	1	1	0	110	3	1.12	0.95;
	1282	1	12.34	3.22	0	0	1	1	0	110	3	1.12	0.95;
	1283	1	11.33	3.96	0	0	1	1	0	110	3	1.12	0.95;
	1284	1	9.62	3.14	0	0	1	1	0	110	3	1.12	0.95;
	1285	1	16.85	4.57	0	0	1	1	0	110	3	1.12	0.95;
	1286	1	13.26	4.22	0	0	1	1	0	110	3	1.12	0.95;
	1287	1	5.85	2.2	0	0	1	1	0	110	3	1.12	0.95;
	1288	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1289	2	19.2	62.01	0	0	1	1	0	110	3	1.12	0.95;
	1290	2	24.55	64.01	0	0	1	1	0	110	3	1.12	0.95;
	1291	1	4.06	0.68	0	0	1	1	0	110	3	1.12	0.95;
	1292	1	3.42	0.35	0	0	1	1	0	110	3	1.12	0.95;
	1293	1	7.37	2.75	0	0	1	1	0	110	3	1.12	0.95;
	1294	2	0	-0.01	0	0	1	1	0	110	3	1.12	0.95;
	1295	2	0	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1296	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1297	1	9.42	4.5	0	0	1	1	0	110	3	1.12	0.95;
	1298	1	7.26	3.63	0	0	1	1	0	110	3	1.12	0.95;
	1299	1	8.07	5.39	0	0	1	1	0	110	3	1.12	0.95;
	1300	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1301	2	6.44	1.53	0	0	1	1	0	110	3	1.12	0.95;
	1302	2	17.01	0.01	0	0	1	1	0	110	3	1.12	0.95;
	1303	2	0	0.01	0	0	1	1	0	110	3	1.12	0.95;
	1304	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1305	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1306	1	3.1	1	0	0	1	1	0	110	3	1.12	0.95;
	1307	1	6.73	3.01	0	0	1	1	0	110	3	1.12	0.95;
	1308	1	3.96	1.41	0	0	1	1	0	110	3	1.12	0.95;
	1309	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1310	1	3.92	2.62	0	0	1	1	0	110	3	1.12	0.95;
	1311	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1312	2	0	-0.01	0	0	1	1	0	110	3	1.12	0.95;
	1313	2	18.48	8.74	0	0	1	1	0	110	3	1.12	0.95;
	1314	2	0	-0.47	0	0	1	1	0	110	3	1.12	0.95;
	1315	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1316	1	0.43	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1317	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1318	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1319	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1320	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1321	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1322	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1323	1	2.67	1.32	0	0	1	1	0	110	3	1.12	0.95;
	1324	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1325	1	1.71	0.68	0	0	1	1	0	110	3	1.12	0.95;
	1326	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1327	1	3.31	1.1	0	0	1	1	0	110	3	1.12	0.95;
	1328	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1329	1	5.34	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1330	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1331	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1332	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1333	1	17.76	5.87	0	0	1	1	0	110	3	1.12	0.95;
	1334	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1335	1	13.26	3.94	0	0	1	1	0	110	3	1.12	0.95;
	1336	1	11.79	3.73	0	0	1	1	0	110	3	1.12	0.95;
	1337	1	11.78	4.44	0	0	1	1	0	110	3	1.12	0.95;
	1338	1	11.67	4.74	0	0	1	1	0	110	3	1.12	0.95;
	1339	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1340	1	1	0.38	0	0	1	1	0	110	3	1.12	0.95;
	1341	1	2.36	-2.35	0	0	1	1	0	110	3	1.12	0.95;
	1342	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1343	1	4.49	3.11	0	0	1	1	0	110	3	1.12	0.95;
	1344	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1345	1	7.39	0.86	0	0	1	1	0	110	3	1.12	0.95;
	1346	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1347	1	10.68	4.62	0	0	1	1	0	110	3	1.12	0.95;
	1348	1	5.45	4.11	0	0	1	1	0	110	3	1.12	0.95;
	1349	1	13.99	5.02	0	0	1	1	0	110	3	1.12	0.95;
	1350	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1351	1	3.74	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1352	1	4.06	2.11	0	0	1	1	0	110	3	1.12	0.95;
	1353	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1354	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1355	1	9.98	5.84	0	0	1	1	0	110	3	1.12	0.95;
	1356	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1357	1	3.1	1.13	0	0	1	1	0	110	3	1.12	0.95;
	1358	1	1.28	0.47	0	0	1	1	0	110	3	1.12	0.95;
	1359	1	26.49	9.33	0	0	1	1	0	110	3	1.12	0.95;
	1360	1	9.83	2.01	0	0	1	1	0	110	3	1.12	0.95;
	1361	1	3.98	1.62	0	0	1	1	0	110	3	1.12	0.95;
	1362	1	4.7	1.86	0	0	1	1	0	110	3	1.12	0.95;
	1363	1	7.06	2.65	0	0	1	1	0	110	3	1.12	0.95;
	1364	1	8.56	2.69	0	0	1	1	0	110	3	1.12	0.95;
	1365	1	3.64	1.27	0	0	1	1	0	110	3	1.12	0.95;
	1366	1	6.21	2.69	0	0	1	1	0	110	3	1.12	0.95;
	1367	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1368	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1369	1	3	3.2	0	0	1	1	0	110	3	1.12	0.95;
	1370	1	1.92	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1371	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1372	1	7.8	2.51	0	0	1	1	0	110	3	1.12	0.95;
	1373	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1374	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1375	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1376	1	5.67	0.97	0	0	1	1	0	110	3	1.12	0.95;
	1377	1	2.35	0.92	0	0	1	1	0	110	3	1.12	0.95;
	1378	1	3.32	1.04	0	0	1	1	0	110	3	1.12	0.95;
	1379	1	5.88	1.75	0	0	1	1	0	110	3	1.12	0.95;
	1380	1	2.46	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1381	1	1.5	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1382	1	4.06	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1383	1	7.26	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1384	1	4.38	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1385	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1386	1	6.94	4.29	0	0	1	1	0	110	3	1.12	0.95;
	1387	1	2.14	1.41	0	0	1	1	0	110	3	1.12	0.95;
	1388	1	0.85	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1389	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1390	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1391	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1392	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1393	1	0	0.08	0	0	1	1	0	110	3	1.12	0.95;
	1394	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1395	1	5.56	1.96	0	0	1	1	0	110	3	1.12	0.95;
	1396	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1397	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1398	1	0.21	0.25	0	0	1	1	0	110	3	1.12	0.95;
	1399	1	0.53	0.25	0	0	1	1	0	110	3	1.12	0.95;
	1400	1	0.85	0.38	0	0	1	1	0	110	3	1.12	0.95;
	1401	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1402	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1403	1	5.88	-0.06	0	0	1	1	0	110	3	1.12	0.95;
	1404	1	4.49	-0.29	0	0	1	1	0	110	3	1.12	0.95;
	1405	2	0.21	0.23	0	0	1	1	0	110	3	1.12	0.95;
	1406	2	1.6	-0.54	0	0	1	1	0	110	3	1.12	0.95;
	1407	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1408	1	4.71	2.3	0	0	1	1	0	110	3	1.12	0.95;
	1409	1	4.7	2.26	0	0	1	1	0	110	3	1.12	0.95;
	1410	1	14.57	3.1	0	0	1	1	0	110	3	1.12	0.95;
	1411	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1412	1	19.38	10.68	0	0	1	1	0	110	3	1.12	0.95;
	1413	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1414	1	7.11	2.34	0	0	1	1	0	110	3	1.12	0.95;
	1415	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1416	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1417	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1418	1	5.01	1.06	0	0	1	1	0	110	3	1.12	0.95;
	1419	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1420	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1421	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1422	1	13.23	4.51	0	0	1	1	0	110	3	1.12	0.95;
	1423	1	2.2	0.17	0	0	1	1	0	110	3	1.12	0.95;
	1424	1	27.25	9.86	0	0	1	1	0	110	3	1.12	0.95;
	1425	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1426	1	3.32	0.66	0	0	1	1	0	110	3	1.12	0.95;
	1427	1	3.85	2.63	0	0	1	1	0	110	3	1.12	0.95;
	1428	1	9	5	0	0	1	1	0	110	3	1.12	0.95;
	1429	2	80	39	0	0	1	1	0	110	3	1.12	0.95;
	1430	1	5.23	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1431	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1432	1	22.7	7.9	0	0	1	1	0	110	3	1.12	0.95;
	1433	1	57	19.3	0	0	1	1	0	110	3	1.12	0.95;
	1434	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1435	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1436	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1437	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1438	1	8	3	0	0	1	1	0	110	3	1.12	0.95;
	1439	1	40	0	0	0	1	1	0	110	3	1.12	0.95;
	1440	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1441	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1442	1	1.92	1	0	0	1	1	0	110	3	1.12	0.95;
	1443	1	4.59	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1444	1	4.17	-1.1	0	0	1	1	0	110	3	1.12	0.95;
	1445	1	1.6	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1446	1	1.92	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1447	2	16.61	4.31	0	0	1	1	0	110	3	1.12	0.95;
	1448	2	18.45	5.06	0	0	1	1	0	110	3	1.12	0.95;
	1449	2	23.14	15.6	0	0	1	1	0	110	3	1.12	0.95;
	1450	1	10	3.2	0	0	1	1	0	110	3	1.12	0.95;
	1451	1	20	6.3	0	0	1	1	0	110	3	1.12	0.95;
	1452	1	6.88	3.29	0	0	1	1	0	110	3	1.12	0.95;
	1453	1	8.98	4.52	0	0	1	1	0	110	3	1.12	0.95;
	1454	1	3	-9.4	0	0	1	1	0	110	3	1.12	0.95;
	1455	1	1.44	-9.4	0	0	1	1	0	110	3	1.12	0.95;
	1456	1	3	2.4	0	0	1	1	0	110	3	1.12	0.95;
	1457	1	44	16	0	0	1	1	0	110	3	1.12	0.95;
	1458	1	44	16	0	0	1	1	0	110	3	1.12	0.95;
	1459	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1460	1	13.31	5.11	0	0	1	1	0	110	3	1.12	0.95;
	1461	1	13.4	3.2	0	0	1	1	0	110	3	1.12	0.95;
	1462	1	13.4	3.5	0	0	1	1	0	110	3	1.12	0.95;
	1463	1	0.7	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1464	1	2.21	1.1	0	0	1	1	0	110	3	1.12	0.95;
	1465	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1466	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1467	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1468	1	4.38	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1469	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1470	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1471	1	1.28	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1472	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1473	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1474	1	5.88	0.99	0	0	1	1	0	110	3	1.12	0.95;
	1475	1	7.05	3.51	0	0	1	1	0	110	3	1.12	0.95;
	1476	2	9.14	8.9	0	0	1	1	0	110	3	1.12	0.95;
	1477	2	8.39	8.6	0	0	1	1	0	110	3	1.12	0.95;
	1478	1	3.24	1.84	0	0	1	1	0	110	3	1.12	0.95;
	1479	1	2.37	1.45	0	0	1	1	0	110	3	1.12	0.95;
	1480	1	0.2	0.18	0	0	1	1	0	110	3	1.12	0.95;
	1481	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1482	1	13.89	10.03	0	0	1	1	0	110	3	1.12	0.95;
	1483	1	8.54	5.02	0	0	1	1	0	110	3	1.12	0.95;
	1484	2	53	25.02	0	0	1	1	0	110	3	1.12	0.95;
	1485	1	56.4	36.4	0	0	1	1	0	110	3	1.12	0.95;
	1486	1	2.25	0.82	0	0	1	1	0	110	3	1.12	0.95;
	1487	1	6	2.13	0	0	1	1	0	110	3	1.12	0.95;
	1488	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1489	1	2.14	0.91	0	0	1	1	0	110	3	1.12	0.95;
	1490	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1491	1	16.13	5.12	0	0	1	1	0	110	3	1.12	0.95;
	1492	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1493	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1494	1	3.95	1.36	0	0	1	1	0	110	3	1.12	0.95;
	1495	1	1.92	0.63	0	0	1	1	0	110	3	1.12	0.95;
	1496	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1497	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1498	1	1.07	0.19	0	0	1	1	0	110	3	1.12	0.95;
	1499	1	0.21	0.28	0	0	1	1	0	110	3	1.12	0.95;
	1500	1	2.78	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1501	1	2.46	0.71	0	0	1	1	0	110	3	1.12	0.95;
	1502	1	1.39	0.37	0	0	1	1	0	110	3	1.12	0.95;
	1503	1	10.57	3.51	0	0	1	1	0	110	3	1.12	0.95;
	1504	1	8.22	2.71	0	0	1	1	0	110	3	1.12	0.95;
	1505	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1506	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1507	1	8.03	3.4	0	0	1	1	0	110	3	1.12	0.95;
	1508	1	5.35	2.24	0	0	1	1	0	110	3	1.12	0.95;
	1509	1	1.07	0.46	0	0	1	1	0	110	3	1.12	0.95;
	1510	1	1.93	0.7	0	0	1	1	0	110	3	1.12	0.95;
	1511	1	5.29	3.85	0	0	1	1	0	110	3	1.12	0.95;
	1512	1	4.04	2.51	0	0	1	1	0	110	3	1.12	0.95;
	1513	1	0.43	0.1	0	0	1	1	0	110	3	1.12	0.95;
	1514	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1515	1	2.29	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1516	1	2.97	1.46	0	0	1	1	0	110	3	1.12	0.95;
	1517	1	0.7	-0.15	0	0	1	1	0	110	3	1.12	0.95;
	1518	1	0.8	0.62	0	0	1	1	0	110	3	1.12	0.95;
	1519	1	2.78	1.66	0	0	1	1	0	110	3	1.12	0.95;
	1520	1	5.83	0.67	0	0	1	1	0	110	3	1.12	0.95;
	1521	1	6.39	3.4	0	0	1	1	0	110	3	1.12	0.95;
	1522	1	3.31	2.36	0	0	1	1	0	110	3	1.12	0.95;
	1523	1	3.56	1.11	0	0	1	1	0	110	3	1.12	0.95;
	1524	1	7.94	2.36	0	0	1	1	0	110	3	1.12	0.95;
	1525	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1526	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1527	1	8.12	2.76	0	0	1	1	0	110	3	1.12	0.95;
	1528	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1529	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1530	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1531	1	6.31	2.56	0	0	1	1	0	110	3	1.12	0.95;
	1532	1	6.63	1.66	0	0	1	1	0	110	3	1.12	0.95;
	1533	1	2.74	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1534	1	1.68	0.74	0	0	1	1	0	110	3	1.12	0.95;
	1535	1	4.59	1.51	0	0	1	1	0	110	3	1.12	0.95;
	1536	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1537	1	3.12	1.15	0	0	1	1	0	110	3	1.12	0.95;
	1538	1	3.65	1.64	0	0	1	1	0	110	3	1.12	0.95;
	1539	1	8.16	2.84	0	0	1	1	0	110	3	1.12	0.95;
	1540	1	5.02	1.48	0	0	1	1	0	110	3	1.12	0.95;
	1541	1	5.36	1.15	0	0	1	1	0	110	3	1.12	0.95;
	1542	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1543	1	6.2	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1544	1	7.06	2.31	0	0	1	1	0	110	3	1.12	0.95;
	1545	2	0	-0.4	0	0	1	1	0	110	3	1.12	0.95;
	1546	2	35.41	12.61	0	0	1	1	0	110	3	1.12	0.95;
	1547	2	14.85	7.58	0	0	1	1	0	110	3	1.12	0.95;
	1548	1	12.19	5.48	0	0	1	1	0	110	3	1.12	0.95;
	1549	1	1.18	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1550	1	2.99	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1551	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1552	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1553	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1554	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1555	1	3.07	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1556	1	0.93	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1557	1	6.96	2.61	0	0	1	1	0	110	3	1.12	0.95;
	1558	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1559	1	0.3	0.11	0	0	1	1	0	110	3	1.12	0.95;
	1560	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1561	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1562	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1563	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1564	1	8.44	2.87	0	0	1	1	0	110	3	1.12	0.95;
	1565	1	1.71	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1566	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1567	1	4.07	2.23	0	0	1	1	0	110	3	1.12	0.95;
	1568	1	3.74	1.9	0	0	1	1	0	110	3	1.12	0.95;
	1569	1	4.49	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1570	1	1.71	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1571	1	6.73	2.11	0	0	1	1	0	110	3	1.12	0.95;
	1572	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1573	1	6.75	4.04	0	0	1	1	0	110	3	1.12	0.95;
	1574	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1575	1	4.41	1.06	0	0	1	1	0	110	3	1.12	0.95;
	1576	1	4.41	1.53	0	0	1	1	0	110	3	1.12	0.95;
	1577	1	7.8	2.56	0	0	1	1	0	110	3	1.12	0.95;
	1578	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1579	1	5.34	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1580	1	5.13	1.4	0	0	1	1	0	110	3	1.12	0.95;
	1581	2	1.71	0.81	0	0	1	1	0	110	3	1.12	0.95;
	1582	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1583	1	0	0.15	0	0	1	1	0	110	3	1.12	0.95;
	1584	1	6.75	2.49	0	0	1	1	0	110	3	1.12	0.95;
	1585	1	2.14	1	0	0	1	1	0	110	3	1.12	0.95;
	1586	1	5.47	2.25	0	0	1	1	0	110	3	1.12	0.95;
	1587	2	15.37	11.02	0	0	1	1	0	110	3	1.12	0.95;
	1588	2	10	44	0	0	1	1	0	110	3	1.12	0.95;
	1589	2	10	44	0	0	1	1	0	110	3	1.12	0.95;
	1590	1	8.94	3.72	0	0	1	1	0	110	3	1.12	0.95;
	1591	1	8.77	4	0	0	1	1	0	110	3	1.12	0.95;
	1592	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1593	1	3.32	2.01	0	0	1	1	0	110	3	1.12	0.95;
	1594	1	1.6	0.4	0	0	1	1	0	110	3	1.12	0.95;
	1595	1	1.07	0.49	0	0	1	1	0	110	3	1.12	0.95;
	1596	1	3.95	1.31	0	0	1	1	0	110	3	1.12	0.95;
	1597	1	3.95	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1598	1	2.78	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1599	1	8.22	1.91	0	0	1	1	0	110	3	1.12	0.95;
	1600	1	0.64	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1601	1	7.18	2.73	0	0	1	1	0	110	3	1.12	0.95;
	1602	1	2.67	0.83	0	0	1	1	0	110	3	1.12	0.95;
	1603	1	0.75	0.34	0	0	1	1	0	110	3	1.12	0.95;
	1604	1	6.5	3.91	0	0	1	1	0	110	3	1.12	0.95;
	1605	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1606	1	4.59	2.29	0	0	1	1	0	110	3	1.12	0.95;
	1607	1	5.04	1.83	0	0	1	1	0	110	3	1.12	0.95;
	1608	1	5.15	1.73	0	0	1	1	0	110	3	1.12	0.95;
	1609	1	3.18	2.03	0	0	1	1	0	110	3	1.12	0.95;
	1610	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1611	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1612	1	1.39	0.47	0	0	1	1	0	110	3	1.12	0.95;
	1613	1	0.96	0.45	0	0	1	1	0	110	3	1.12	0.95;
	1614	1	2.57	0.64	0	0	1	1	0	110	3	1.12	0.95;
	1615	1	2.68	0.21	0	0	1	1	0	110	3	1.12	0.95;
	1616	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1617	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1618	1	9.51	3.71	0	0	1	1	0	110	3	1.12	0.95;
	1619	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1620	1	6.53	2.79	0	0	1	1	0	110	3	1.12	0.95;
	1621	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1622	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1623	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1624	1	4.91	1.71	0	0	1	1	0	110	3	1.12	0.95;
	1625	1	7.05	3.51	0	0	1	1	0	110	3	1.12	0.95;
	1626	1	7.05	4.62	0	0	1	1	0	110	3	1.12	0.95;
	1627	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1628	1	1.6	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1629	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1630	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1631	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1632	1	7.71	2.66	0	0	1	1	0	110	3	1.12	0.95;
	1633	1	7.93	2.47	0	0	1	1	0	110	3	1.12	0.95;
	1634	1	0.53	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1635	1	0.53	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1636	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1637	1	4.71	0.48	0	0	1	1	0	110	3	1.12	0.95;
	1638	1	2.78	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1639	1	2.35	0.41	0	0	1	1	0	110	3	1.12	0.95;
	1640	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1641	1	1.71	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1642	1	7.06	2.81	0	0	1	1	0	110	3	1.12	0.95;
	1643	1	4.92	-1.95	0	0	1	1	0	110	3	1.12	0.95;
	1644	1	4.92	2.05	0	0	1	1	0	110	3	1.12	0.95;
	1645	1	4.27	1.41	0	0	1	1	0	110	3	1.12	0.95;
	1646	1	4.81	1.51	0	0	1	1	0	110	3	1.12	0.95;
	1647	1	23	9.5	0	0	1	1	0	110	3	1.12	0.95;
	1648	2	23.02	9.52	0	0	1	1	0	110	3	1.12	0.95;
	1649	1	6.09	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1650	1	4.81	1.71	0	0	1	1	0	110	3	1.12	0.95;
	1651	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1652	1	0.64	0.54	0	0	1	1	0	110	3	1.12	0.95;
	1653	1	8.24	3.64	0	0	1	1	0	110	3	1.12	0.95;
	1654	1	4.49	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1655	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1656	2	18.91	30.21	0	0	1	1	0	110	3	1.12	0.95;
	1657	1	2.03	0.86	0	0	1	1	0	110	3	1.12	0.95;
	1658	2	7	14	0	0	1	1	0	110	3	1.12	0.95;
	1659	1	3.37	1.31	0	0	1	1	0	110	3	1.12	0.95;
	1660	1	4.12	1.76	0	0	1	1	0	110	3	1.12	0.95;
	1661	1	3.96	1.33	0	0	1	1	0	110	3	1.12	0.95;
	1662	1	5.99	2.04	0	0	1	1	0	110	3	1.12	0.95;
	1663	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1664	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1665	1	8.04	3.49	0	0	1	1	0	110	3	1.12	0.95;
	1666	1	13.18	5.37	0	0	1	1	0	110	3	1.12	0.95;
	1667	1	7.48	4.01	0	0	1	1	0	110	3	1.12	0.95;
	1668	2	19.5	48	0	0	1	1	0	110	3	1.12	0.95;
	1669	1	7.92	1.18	0	0	1	1	0	110	3	1.12	0.95;
	1670	1	7.28	0.93	0	0	1	1	0	110	3	1.12	0.95;
	1671	1	2.35	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1672	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1673	1	25.76	6.99	0	0	1	1	0	110	3	1.12	0.95;
	1674	1	5.8	1.9	0	0	1	1	0	110	3	1.12	0.95;
	1675	1	4.71	1.73	0	0	1	1	0	110	3	1.12	0.95;
	1676	1	4.17	1.46	0	0	1	1	0	110	3	1.12	0.95;
	1677	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1678	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1679	1	2.67	1.85	0	0	1	1	0	110	3	1.12	0.95;
	1680	2	3.1	2.09	0	0	1	1	0	110	3	1.12	0.95;
	1681	2	6	13	0	0	1	1	0	110	3	1.12	0.95;
	1682	1	6.52	2.01	0	0	1	1	0	110	3	1.12	0.95;
	1683	1	2.88	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1684	1	4.28	1.61	0	0	1	1	0	110	3	1.12	0.95;
	1685	1	2.99	1.04	0	0	1	1	0	110	3	1.12	0.95;
	1686	1	11.05	4.3	0	0	1	1	0	110	3	1.12	0.95;
	1687	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1688	1	9.09	3.06	0	0	1	1	0	110	3	1.12	0.95;
	1689	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1690	1	0.91	0.35	0	0	1	1	0	110	3	1.12	0.95;
	1691	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1692	1	8.25	2.34	0	0	1	1	0	110	3	1.12	0.95;
	1693	1	12.53	3.47	0	0	1	1	0	110	3	1.12	0.95;
	1694	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1695	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1696	1	7.96	3.41	0	0	1	1	0	110	3	1.12	0.95;
	1697	1	2	0.86	0	0	1	1	0	110	3	1.12	0.95;
	1698	1	7.44	2.92	0	0	1	1	0	110	3	1.12	0.95;
	1699	1	15.02	5.97	0	0	1	1	0	110	3	1.12	0.95;
	1700	1	1.07	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1701	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1702	1	5.97	1.32	0	0	1	1	0	110	3	1.12	0.95;
	1703	1	8.64	3.63	0	0	1	1	0	110	3	1.12	0.95;
	1704	1	2.94	1.25	0	0	1	1	0	110	3	1.12	0.95;
	1705	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1706	1	8.32	3.24	0	0	1	1	0	110	3	1.12	0.95;
	1707	1	11.09	4.43	0	0	1	1	0	110	3	1.12	0.95;
	1708	1	8.76	3.61	0	0	1	1	0	110	3	1.12	0.95;
	1709	1	5.13	1.1	0	0	1	1	0	110	3	1.12	0.95;
	1710	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1711	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1712	1	5.77	5.42	0	0	1	1	0	110	3	1.12	0.95;
	1713	1	5.03	1.96	0	0	1	1	0	110	3	1.12	0.95;
	1714	1	1.82	0.7	0	0	1	1	0	110	3	1.12	0.95;
	1715	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1716	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1717	1	5.17	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1718	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1719	1	13.79	6.27	0	0	1	1	0	110	3	1.12	0.95;
	1720	1	8.41	3.88	0	0	1	1	0	110	3	1.12	0.95;
	1721	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1722	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1723	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1724	2	0	1.58	0	0	1	1	0	110	3	1.12	0.95;
	1725	1	14.55	0.55	0	0	1	1	0	110	3	1.12	0.95;
	1726	1	11.23	2.66	0	0	1	1	0	110	3	1.12	0.95;
	1727	1	8.66	2.96	0	0	1	1	0	110	3	1.12	0.95;
	1728	1	0.43	0.35	0	0	1	1	0	110	3	1.12	0.95;
	1729	1	6.38	2.77	0	0	1	1	0	110	3	1.12	0.95;
	1730	1	8.31	3.68	0	0	1	1	0	110	3	1.12	0.95;
	1731	1	0.2	0.49	0	0	1	1	0	110	3	1.12	0.95;
	1732	1	0	0.38	0	0	1	1	0	110	3	1.12	0.95;
	1733	1	8.86	3.13	0	0	1	1	0	110	3	1.12	0.95;
	1734	1	3.82	2.03	0	0	1	1	0	110	3	1.12	0.95;
	1735	1	4.45	0.78	0	0	1	1	0	110	3	1.12	0.95;
	1736	1	4.95	2.28	0	0	1	1	0	110	3	1.12	0.95;
	1737	1	1.35	0.63	0	0	1	1	0	110	3	1.12	0.95;
	1738	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1739	2	9.3	3.12	0	0	1	1	0	110	3	1.12	0.95;
	1740	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1741	2	0	0.08	0	0	1	1	0	110	3	1.12	0.95;
	1742	2	14.75	10.95	0	0	1	1	0	110	3	1.12	0.95;
	1743	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1744	1	8.56	4.3	0	0	1	1	0	110	3	1.12	0.95;
	1745	1	13.5	7.19	0	0	1	1	0	110	3	1.12	0.95;
	1746	2	23.51	39.5	0	0	1	1	0	110	3	1.12	0.95;
	1747	1	6.42	3.31	0	0	1	1	0	110	3	1.12	0.95;
	1748	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1749	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1750	1	9.54	3.7	0	0	1	1	0	110	3	1.12	0.95;
	1751	1	4.92	1.95	0	0	1	1	0	110	3	1.12	0.95;
	1752	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1753	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1754	1	1.85	0.34	0	0	1	1	0	110	3	1.12	0.95;
	1755	1	3.02	1.25	0	0	1	1	0	110	3	1.12	0.95;
	1756	1	0.85	0.08	0	0	1	1	0	110	3	1.12	0.95;
	1757	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1758	1	5.88	1.96	0	0	1	1	0	110	3	1.12	0.95;
	1759	1	3.53	1.25	0	0	1	1	0	110	3	1.12	0.95;
	1760	1	12.75	5.84	0	0	1	1	0	110	3	1.12	0.95;
	1761	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1762	1	7.53	2.85	0	0	1	1	0	110	3	1.12	0.95;
	1763	1	7.14	2.22	0	0	1	1	0	110	3	1.12	0.95;
	1764	1	3.74	0.56	0	0	1	1	0	110	3	1.12	0.95;
	1765	1	5.98	0.87	0	0	1	1	0	110	3	1.12	0.95;
	1766	1	6.42	2.86	0	0	1	1	0	110	3	1.12	0.95;
	1767	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1768	2	0.69	1.45	0	0	1	1	0	110	3	1.12	0.95;
	1769	2	3.17	4.84	0	0	1	1	0	110	3	1.12	0.95;
	1770	1	2.46	1.02	0	0	1	1	0	110	3	1.12	0.95;
	1771	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1772	1	6.78	3.39	0	0	1	1	0	110	3	1.12	0.95;
	1773	1	8.45	4	0	0	1	1	0	110	3	1.12	0.95;
	1774	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1775	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1776	1	1.07	0.39	0	0	1	1	0	110	3	1.12	0.95;
	1777	1	1.92	0.71	0	0	1	1	0	110	3	1.12	0.95;
	1778	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1779	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1780	1	11.71	4.19	0	0	1	1	0	110	3	1.12	0.95;
	1781	1	0	0.15	0	0	1	1	0	110	3	1.12	0.95;
	1782	1	8.34	3.13	0	0	1	1	0	110	3	1.12	0.95;
	1783	1	7.16	1.53	0	0	1	1	0	110	3	1.12	0.95;
	1784	1	3.21	1.23	0	0	1	1	0	110	3	1.12	0.95;
	1785	1	4.92	1.63	0	0	1	1	0	110	3	1.12	0.95;
	1786	1	2.88	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1787	1	4.81	1.5	0	0	1	1	0	110	3	1.12	0.95;
	1788	1	0.66	0.39	0	0	1	1	0	110	3	1.12	0.95;
	1789	1	0.53	0.31	0	0	1	1	0	110	3	1.12	0.95;
	1790	1	8.13	2.7	0	0	1	1	0	110	3	1.12	0.95;
	1791	1	1.6	0.65	0	0	1	1	0	110	3	1.12	0.95;
	1792	1	5.03	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1793	1	2.78	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1794	1	3.1	1.3	0	0	1	1	0	110	3	1.12	0.95;
	1795	1	2.35	1.16	0	0	1	1	0	110	3	1.12	0.95;
	1796	1	6.32	3.51	0	0	1	1	0	110	3	1.12	0.95;
	1797	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1798	1	6.33	2.49	0	0	1	1	0	110	3	1.12	0.95;
	1799	1	4.71	1.73	0	0	1	1	0	110	3	1.12	0.95;
	1800	1	3.64	1.28	0	0	1	1	0	110	3	1.12	0.95;
	1801	1	4.38	0.64	0	0	1	1	0	110	3	1.12	0.95;
	1802	1	6.72	2.64	0	0	1	1	0	110	3	1.12	0.95;
	1803	1	11.78	4.5	0	0	1	1	0	110	3	1.12	0.95;
	1804	1	4.42	0.4	0	0	1	1	0	110	3	1.12	0.95;
	1805	1	17.92	4.21	0	0	1	1	0	110	3	1.12	0.95;
	1806	1	2.57	2.02	0	0	1	1	0	110	3	1.12	0.95;
	1807	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1808	1	5.03	1.23	0	0	1	1	0	110	3	1.12	0.95;
	1809	1	2.03	0.35	0	0	1	1	0	110	3	1.12	0.95;
	1810	1	3.1	1.16	0	0	1	1	0	110	3	1.12	0.95;
	1811	1	2.46	0.92	0	0	1	1	0	110	3	1.12	0.95;
	1812	1	1.28	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1813	1	6.23	2.47	0	0	1	1	0	110	3	1.12	0.95;
	1814	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1815	1	3.63	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1816	1	0.64	0.2	0	0	1	1	0	110	3	1.12	0.95;
	1817	1	2.14	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1818	1	3.75	1.83	0	0	1	1	0	110	3	1.12	0.95;
	1819	1	2.46	0.92	0	0	1	1	0	110	3	1.12	0.95;
	1820	1	1.92	0.71	0	0	1	1	0	110	3	1.12	0.95;
	1821	1	12.32	4.77	0	0	1	1	0	110	3	1.12	0.95;
	1822	1	4.92	1.71	0	0	1	1	0	110	3	1.12	0.95;
	1823	1	7.17	0.11	0	0	1	1	0	110	3	1.12	0.95;
	1824	1	5.35	0.74	0	0	1	1	0	110	3	1.12	0.95;
	1825	1	2.03	1.31	0	0	1	1	0	110	3	1.12	0.95;
	1826	1	2.35	-0.28	0	0	1	1	0	110	3	1.12	0.95;
	1827	1	3.59	1.78	0	0	1	1	0	110	3	1.12	0.95;
	1828	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1829	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1830	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1831	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1832	1	10.37	3.46	0	0	1	1	0	110	3	1.12	0.95;
	1833	1	3.03	2.04	0	0	1	1	0	110	3	1.12	0.95;
	1834	1	0.78	0.36	0	0	1	1	0	110	3	1.12	0.95;
	1835	1	1.18	0.27	0	0	1	1	0	110	3	1.12	0.95;
	1836	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1837	1	8.87	1.81	0	0	1	1	0	110	3	1.12	0.95;
	1838	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1839	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1840	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1841	1	10.44	2.47	0	0	1	1	0	110	3	1.12	0.95;
	1842	1	8.59	2.67	0	0	1	1	0	110	3	1.12	0.95;
	1843	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1844	1	3.42	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1845	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1846	1	4.01	0	0	0	1	1	0	110	3	1.12	0.95;
	1847	1	7.19	2.4	0	0	1	1	0	110	3	1.12	0.95;
	1848	1	9.42	3.37	0	0	1	1	0	110	3	1.12	0.95;
	1849	1	15.17	4.52	0	0	1	1	0	110	3	1.12	0.95;
	1850	1	18.59	5.92	0	0	1	1	0	110	3	1.12	0.95;
	1851	1	7.92	3.22	0	0	1	1	0	110	3	1.12	0.95;
	1852	1	4.59	1.4	0	0	1	1	0	110	3	1.12	0.95;
	1853	1	5.54	2.47	0	0	1	1	0	110	3	1.12	0.95;
	1854	1	0	0.04	0	0	1	1	0	110	3	1.12	0.95;
	1855	1	2.57	0.93	0	0	1	1	0	110	3	1.12	0.95;
	1856	1	0.43	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1857	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1858	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1859	1	5.35	0.76	0	0	1	1	0	110	3	1.12	0.95;
	1860	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1861	1	1.28	0.47	0	0	1	1	0	110	3	1.12	0.95;
	1862	1	2.14	-0.2	0	0	1	1	0	110	3	1.12	0.95;
	1863	1	6.42	2.54	0	0	1	1	0	110	3	1.12	0.95;
	1864	1	8.27	3.21	0	0	1	1	0	110	3	1.12	0.95;
	1865	1	7.26	2.71	0	0	1	1	0	110	3	1.12	0.95;
	1866	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1867	1	1.18	0.57	0	0	1	1	0	110	3	1.12	0.95;
	1868	1	1.71	0.58	0	0	1	1	0	110	3	1.12	0.95;
	1869	1	18.5	6.44	0	0	1	1	0	110	3	1.12	0.95;
	1870	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1871	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1872	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1873	1	7.5	1.88	0	0	1	1	0	110	3	1.12	0.95;
	1874	1	3.21	0.4	0	0	1	1	0	110	3	1.12	0.95;
	1875	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1876	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1877	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1878	1	1.6	-0.2	0	0	1	1	0	110	3	1.12	0.95;
	1879	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1880	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1881	1	11.44	3.59	0	0	1	1	0	110	3	1.12	0.95;
	1882	1	12.18	3.5	0	0	1	1	0	110	3	1.12	0.95;
	1883	1	7.18	3.72	0	0	1	1	0	110	3	1.12	0.95;
	1884	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1885	1	3.48	1.55	0	0	1	1	0	110	3	1.12	0.95;
	1886	1	4.3	1.56	0	0	1	1	0	110	3	1.12	0.95;
	1887	1	5.23	1.61	0	0	1	1	0	110	3	1.12	0.95;
	1888	1	5.34	0.6	0	0	1	1	0	110	3	1.12	0.95;
	1889	1	3.85	2.11	0	0	1	1	0	110	3	1.12	0.95;
	1890	1	0.32	0	0	0	1	1	0	110	3	1.12	0.95;
	1891	1	4.81	1.16	0	0	1	1	0	110	3	1.12	0.95;
	1892	1	1.5	0.37	0	0	1	1	0	110	3	1.12	0.95;
	1893	1	10.26	3.21	0	0	1	1	0	110	3	1.12	0.95;
	1894	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1895	1	5.25	1.99	0	0	1	1	0	110	3	1.12	0.95;
	1896	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1897	1	7.18	2.74	0	0	1	1	0	110	3	1.12	0.95;
	1898	1	10.81	4.22	0	0	1	1	0	110	3	1.12	0.95;
	1899	1	2.99	1.14	0	0	1	1	0	110	3	1.12	0.95;
	1900	1	6.42	2.28	0	0	1	1	0	110	3	1.12	0.95;
	1901	1	1.93	0.48	0	0	1	1	0	110	3	1.12	0.95;
	1902	1	1.6	0.58	0	0	1	1	0	110	3	1.12	0.95;
	1903	1	7.07	2.62	0	0	1	1	0	110	3	1.12	0.95;
	1904	1	4.17	1.49	0	0	1	1	0	110	3	1.12	0.95;
	1905	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1906	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1907	1	9.62	3.16	0	0	1	1	0	110	3	1.12	0.95;
	1908	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1909	1	10.59	3.91	0	0	1	1	0	110	3	1.12	0.95;
	1910	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1911	1	11.23	4.12	0	0	1	1	0	110	3	1.12	0.95;
	1912	1	0.75	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1913	1	6.05	2.45	0	0	1	1	0	110	3	1.12	0.95;
	1914	1	9.27	4.31	0	0	1	1	0	110	3	1.12	0.95;
	1915	1	8.5	3.32	0	0	1	1	0	110	3	1.12	0.95;
	1916	1	4.04	0.89	0	0	1	1	0	110	3	1.12	0.95;
	1917	1	4.02	2.5	0	0	1	1	0	110	3	1.12	0.95;
	1918	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1919	1	3.1	1.3	0	0	1	1	0	110	3	1.12	0.95;
	1920	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1921	1	8.12	3.31	0	0	1	1	0	110	3	1.12	0.95;
	1922	1	2.78	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1923	1	2.39	0.28	0	0	1	1	0	110	3	1.12	0.95;
	1924	1	5.9	2.08	0	0	1	1	0	110	3	1.12	0.95;
	1925	1	3.21	0.67	0	0	1	1	0	110	3	1.12	0.95;
	1926	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1927	1	3.85	1.45	0	0	1	1	0	110	3	1.12	0.95;
	1928	1	1.71	0.63	0	0	1	1	0	110	3	1.12	0.95;
	1929	1	6.74	2.42	0	0	1	1	0	110	3	1.12	0.95;
	1930	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1931	1	1.28	0.3	0	0	1	1	0	110	3	1.12	0.95;
	1932	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1933	1	3	1.05	0	0	1	1	0	110	3	1.12	0.95;
	1934	1	3.64	2.02	0	0	1	1	0	110	3	1.12	0.95;
	1935	1	6.42	2.28	0	0	1	1	0	110	3	1.12	0.95;
	1936	1	12.32	4.77	0	0	1	1	0	110	3	1.12	0.95;
	1937	1	5.46	1.99	0	0	1	1	0	110	3	1.12	0.95;
	1938	1	3.96	1.39	0	0	1	1	0	110	3	1.12	0.95;
	1939	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1940	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1941	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1942	1	5.99	2.06	0	0	1	1	0	110	3	1.12	0.95;
	1943	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1944	1	11.2	3.95	0	0	1	1	0	110	3	1.12	0.95;
	1945	1	9.36	3.32	0	0	1	1	0	110	3	1.12	0.95;
	1946	1	16.32	1.67	0	0	1	1	0	110	3	1.12	0.95;
	1947	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1948	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1949	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1950	1	6.63	2.23	0	0	1	1	0	110	3	1.12	0.95;
	1951	1	13.57	4.56	0	0	1	1	0	110	3	1.12	0.95;
	1952	1	1.5	0.4	0	0	1	1	0	110	3	1.12	0.95;
	1953	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1954	2	4.85	4.98	0	0	1	1	0	110	3	1.12	0.95;
	1955	1	3.42	1.69	0	0	1	1	0	110	3	1.12	0.95;
	1956	1	3.52	1.1	0	0	1	1	0	110	3	1.12	0.95;
	1957	1	3.85	1.2	0	0	1	1	0	110	3	1.12	0.95;
	1958	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1959	1	2.56	0.5	0	0	1	1	0	110	3	1.12	0.95;
	1960	1	5.45	1	0	0	1	1	0	110	3	1.12	0.95;
	1961	1	2.24	0.7	0	0	1	1	0	110	3	1.12	0.95;
	1962	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1963	1	2.46	1.05	0	0	1	1	0	110	3	1.12	0.95;
	1964	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1965	1	3.95	1.35	0	0	1	1	0	110	3	1.12	0.95;
	1966	1	5.02	1.76	0	0	1	1	0	110	3	1.12	0.95;
	1967	1	4.61	2.82	0	0	1	1	0	110	3	1.12	0.95;
	1968	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1969	1	4.17	0.9	0	0	1	1	0	110	3	1.12	0.95;
	1970	1	11.32	4.82	0	0	1	1	0	110	3	1.12	0.95;
	1971	1	3.32	2.01	0	0	1	1	0	110	3	1.12	0.95;
	1972	1	3	1.26	0	0	1	1	0	110	3	1.12	0.95;
	1973	1	2.31	0.44	0	0	1	1	0	110	3	1.12	0.95;
	1974	1	3.85	1.4	0	0	1	1	0	110	3	1.12	0.95;
	1975	1	3.31	0.8	0	0	1	1	0	110	3	1.12	0.95;
	1976	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1977	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1978	1	1.18	0.59	0	0	1	1	0	110	3	1.12	0.95;
	1979	1	0.21	0.05	0	0	1	1	0	110	3	1.12	0.95;
	1980	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1981	1	4.7	1.55	0	0	1	1	0	110	3	1.12	0.95;
	1982	2	19.39	31.2	0	0	1	1	0	110	3	1.12	0.95;
	1983	2	15	19	0	0	1	1	0	110	3	1.12	0.95;
	1984	2	20.23	22.11	0	0	1	1	0	110	3	1.12	0.95;
	1985	1	6.21	0.75	0	0	1	1	0	110	3	1.12	0.95;
	1986	1	3.42	1.26	0	0	1	1	0	110	3	1.12	0.95;
	1987	1	2.57	1.31	0	0	1	1	0	110	3	1.12	0.95;
	1988	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1989	1	4.54	1.89	0	0	1	1	0	110	3	1.12	0.95;
	1990	1	4.28	1.79	0	0	1	1	0	110	3	1.12	0.95;
	1991	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1992	2	1.6	0.41	0	0	1	1	0	110	3	1.12	0.95;
	1993	2	6	7	0	0	1	1	0	110	3	1.12	0.95;
	1994	1	3.12	1.33	0	0	1	1	0	110	3	1.12	0.95;
	1995	1	4.69	0.82	0	0	1	1	0	110	3	1.12	0.95;
	1996	1	4.61	0.67	0	0	1	1	0	110	3	1.12	0.95;
	1997	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	1998	1	7.69	2.34	0	0	1	1	0	110	3	1.12	0.95;
	1999	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2000	1	0.53	0.1	0	0	1	1	0	110	3	1.12	0.95;
	2001	1	1.71	0.6	0	0	1	1	0	110	3	1.12	0.95;
	2002	1	6.02	2.2	0	0	1	1	0	110	3	1.12	0.95;
	2003	1	10.73	4.81	0	0	1	1	0	110	3	1.12	0.95;
	2004	1	4.7	0.8	0	0	1	1	0	110	3	1.12	0.95;
	2005	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2006	1	1.28	0.15	0	0	1	1	0	110	3	1.12	0.95;
	2007	1	7.05	2.29	0	0	1	1	0	110	3	1.12	0.95;
	2008	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2009	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2010	1	5.55	1.91	0	0	1	1	0	110	3	1.12	0.95;
	2011	1	2.99	0.8	0	0	1	1	0	110	3	1.12	0.95;
	2012	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2013	1	6.62	2.88	0	0	1	1	0	110	3	1.12	0.95;
	2014	1	6.07	2.27	0	0	1	1	0	110	3	1.12	0.95;
	2015	1	1.07	1.1	0	0	1	1	0	110	3	1.12	0.95;
	2016	1	0.53	1.1	0	0	1	1	0	110	3	1.12	0.95;
	2017	1	3.64	1.23	0	0	1	1	0	110	3	1.12	0.95;
	2018	1	4.27	1.55	0	0	1	1	0	110	3	1.12	0.95;
	2019	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2020	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2021	1	10.71	5.71	0	0	1	1	0	110	3	1.12	0.95;
	2022	1	0.85	0.29	0	0	1	1	0	110	3	1.12	0.95;
	2023	1	4.28	1.76	0	0	1	1	0	110	3	1.12	0.95;
	2024	1	1.13	0.38	0	0	1	1	0	110	3	1.12	0.95;
	2025	1	2.35	0.8	0	0	1	1	0	110	3	1.12	0.95;
	2026	1	2.14	0.7	0	0	1	1	0	110	3	1.12	0.95;
	2027	1	0.43	0.03	0	0	1	1	0	110	3	1.12	0.95;
	2028	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2029	1	4.04	1.71	0	0	1	1	0	110	3	1.12	0.95;
	2030	1	3.98	1.71	0	0	1	1	0	110	3	1.12	0.95;
	2031	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2032	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2033	1	7.77	3.75	0	0	1	1	0	110	3	1.12	0.95;
	2034	1	6.78	3.65	0	0	1	1	0	110	3	1.12	0.95;
	2035	1	9.71	3.76	0	0	1	1	0	110	3	1.12	0.95;
	2036	1	4.73	1.87	0	0	1	1	0	110	3	1.12	0.95;
	2037	1	0.75	0.37	0	0	1	1	0	110	3	1.12	0.95;
	2038	1	1.28	0.58	0	0	1	1	0	110	3	1.12	0.95;
	2039	1	3.31	1.25	0	0	1	1	0	110	3	1.12	0.95;
	2040	1	5.99	2.06	0	0	1	1	0	110	3	1.12	0.95;
	2041	1	1.92	0.6	0	0	1	1	0	110	3	1.12	0.95;
	2042	1	6.73	0.7	0	0	1	1	0	110	3	1.12	0.95;
	2043	1	5.66	1.71	0	0	1	1	0	110	3	1.12	0.95;
	2044	1	19.7	7.46	0	0	1	1	0	110	3	1.12	0.95;
	2045	1	18.63	7.16	0	0	1	1	0	110	3	1.12	0.95;
	2046	1	2.47	1.59	0	0	1	1	0	110	3	1.12	0.95;
	2047	1	4.41	2.94	0	0	1	1	0	110	3	1.12	0.95;
	2048	1	4.92	1.55	0	0	1	1	0	110	3	1.12	0.95;
	2049	1	7.16	1.96	0	0	1	1	0	110	3	1.12	0.95;
	2050	1	7.69	1.61	0	0	1	1	0	110	3	1.12	0.95;
	2051	1	11.86	3.71	0	0	1	1	0	110	3	1.12	0.95;
	2052	1	1.28	0.37	0	0	1	1	0	110	3	1.12	0.95;
	2053	1	1.07	0.06	0	0	1	1	0	110	3	1.12	0.95;
	2054	1	4.25	1.88	0	0	1	1	0	110	3	1.12	0.95;
	2055	1	3.65	0.56	0	0	1	1	0	110	3	1.12	0.95;
	2056	1	3.41	1.59	0	0	1	1	0	110	3	1.12	0.95;
	2057	1	1.44	0.65	0	0	1	1	0	110	3	1.12	0.95;
	2058	1	7.39	2.73	0	0	1	1	0	110	3	1.12	0.95;
	2059	1	9.65	3.73	0	0	1	1	0	110	3	1.12	0.95;
	2060	1	7.35	3.92	0	0	1	1	0	110	3	1.12	0.95;
	2061	1	2.83	1.4	0	0	1	1	0	110	3	1.12	0.95;
	2062	1	5.99	2	0	0	1	1	0	110	3	1.12	0.95;
	2063	1	3.1	0.8	0	0	1	1	0	110	3	1.12	0.95;
	2064	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2065	1	13.24	4.41	0	0	1	1	0	110	3	1.12	0.95;
	2066	1	5.56	0.65	0	0	1	1	0	110	3	1.12	0.95;
	2067	1	10.5	2.26	0	0	1	1	0	110	3	1.12	0.95;
	2068	1	6	2.33	0	0	1	1	0	110	3	1.12	0.95;
	2069	1	7.39	2.75	0	0	1	1	0	110	3	1.12	0.95;
	2070	1	2.92	1.83	0	0	1	1	0	110	3	1.12	0.95;
	2071	1	2.71	1.92	0	0	1	1	0	110	3	1.12	0.95;
	2072	1	1.07	0.63	0	0	1	1	0	110	3	1.12	0.95;
	2073	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2074	1	1.93	0.49	0	0	1	1	0	110	3	1.12	0.95;
	2075	1	3.11	1.67	0	0	1	1	0	110	3	1.12	0.95;
	2076	1	3.64	1.37	0	0	1	1	0	110	3	1.12	0.95;
	2077	1	1.93	1.11	0	0	1	1	0	110	3	1.12	0.95;
	2078	1	5.02	1.71	0	0	1	1	0	110	3	1.12	0.95;
	2079	1	5.13	1.61	0	0	1	1	0	110	3	1.12	0.95;
	2080	1	5.77	2.38	0	0	1	1	0	110	3	1.12	0.95;
	2081	1	4.17	1.7	0	0	1	1	0	110	3	1.12	0.95;
	2082	1	4.68	0.9	0	0	1	1	0	110	3	1.12	0.95;
	2083	1	11.2	4.89	0	0	1	1	0	110	3	1.12	0.95;
	2084	1	0.85	0.7	0	0	1	1	0	110	3	1.12	0.95;
	2085	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2086	1	7.59	2.5	0	0	1	1	0	110	3	1.12	0.95;
	2087	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2088	1	15.31	5.14	0	0	1	1	0	110	3	1.12	0.95;
	2089	1	0	0.15	0	0	1	1	0	110	3	1.12	0.95;
	2090	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2091	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2092	1	4.71	1.53	0	0	1	1	0	110	3	1.12	0.95;
	2093	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2094	1	1.82	0.7	0	0	1	1	0	110	3	1.12	0.95;
	2095	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2096	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2097	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2098	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2099	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2100	2	17.03	6.7	0	0	1	1	0	110	3	1.12	0.95;
	2101	1	7.28	2.76	0	0	1	1	0	110	3	1.12	0.95;
	2102	1	0.64	0.41	0	0	1	1	0	110	3	1.12	0.95;
	2103	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2104	1	17.58	6.94	0	0	1	1	0	110	3	1.12	0.95;
	2105	1	7.39	2.75	0	0	1	1	0	110	3	1.12	0.95;
	2106	1	4.6	1.73	0	0	1	1	0	110	3	1.12	0.95;
	2107	1	5.78	2.11	0	0	1	1	0	110	3	1.12	0.95;
	2108	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2109	1	12.62	4.47	0	0	1	1	0	110	3	1.12	0.95;
	2110	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2111	1	2.99	3.79	0	0	1	1	0	110	3	1.12	0.95;
	2112	1	11.12	5.66	0	0	1	1	0	110	3	1.12	0.95;
	2113	1	5.89	2.27	0	0	1	1	0	110	3	1.12	0.95;
	2114	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2115	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2116	1	3.64	-0.64	0	0	1	1	0	110	3	1.12	0.95;
	2117	1	11.34	3.96	0	0	1	1	0	110	3	1.12	0.95;
	2118	1	12.3	3.96	0	0	1	1	0	110	3	1.12	0.95;
	2119	1	6.33	2.63	0	0	1	1	0	110	3	1.12	0.95;
	2120	1	8.24	3.8	0	0	1	1	0	110	3	1.12	0.95;
	2121	1	7.71	2.92	0	0	1	1	0	110	3	1.12	0.95;
	2122	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2123	1	2.89	1.04	0	0	1	1	0	110	3	1.12	0.95;
	2124	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2125	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2126	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2127	1	13.01	6.19	0	0	1	1	0	110	3	1.12	0.95;
	2128	1	10.36	4.89	0	0	1	1	0	110	3	1.12	0.95;
	2129	1	5.77	2	0	0	1	1	0	110	3	1.12	0.95;
	2130	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2131	1	16.24	5.48	0	0	1	1	0	110	3	1.12	0.95;
	2132	1	0	0.03	0	0	1	1	0	110	3	1.12	0.95;
	2133	1	4.39	2.02	0	0	1	1	0	110	3	1.12	0.95;
	2134	1	4.17	2.73	0	0	1	1	0	110	3	1.12	0.95;
	2135	1	4.6	1.63	0	0	1	1	0	110	3	1.12	0.95;
	2136	1	12.19	3.96	0	0	1	1	0	110	3	1.12	0.95;
	2137	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2138	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2139	1	14.77	7.56	0	0	1	1	0	110	3	1.12	0.95;
	2140	1	8.68	3.73	0	0	1	1	0	110	3	1.12	0.95;
	2141	1	5.78	3.59	0	0	1	1	0	110	3	1.12	0.95;
	2142	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2143	1	2.46	0.7	0	0	1	1	0	110	3	1.12	0.95;
	2144	2	17.2	33.81	0	0	1	1	0	110	3	1.12	0.95;
	2145	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2146	2	14	32	0	0	1	1	0	110	3	1.12	0.95;
	2147	1	2.89	1.04	0	0	1	1	0	110	3	1.12	0.95;
	2148	1	0	0.08	0	0	1	1	0	110	3	1.12	0.95;
	2149	1	7.67	4.14	0	0	1	1	0	110	3	1.12	0.95;
	2150	1	0	0.1	0	0	1	1	0	110	3	1.12	0.95;
	2151	1	10.6	5.2	0	0	1	1	0	110	3	1.12	0.95;
	2152	1	5.37	3.18	0	0	1	1	0	110	3	1.12	0.95;
	2153	1	0.7	0.38	0	0	1	1	0	110	3	1.12	0.95;
	2154	1	3.38	1.19	0	0	1	1	0	110	3	1.12	0.95;
	2155	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2156	1	4.28	2.23	0	0	1	1	0	110	3	1.12	0.95;
	2157	1	6.95	2.52	0	0	1	1	0	110	3	1.12	0.95;
	2158	1	9.63	3.51	0	0	1	1	0	110	3	1.12	0.95;
	2159	1	4.58	1.81	0	0	1	1	0	110	3	1.12	0.95;
	2160	1	3.43	0.62	0	0	1	1	0	110	3	1.12	0.95;
	2161	1	9.3	4.89	0	0	1	1	0	110	3	1.12	0.95;
	2162	1	4.92	0.58	0	0	1	1	0	110	3	1.12	0.95;
	2163	1	2.14	3.61	0	0	1	1	0	110	3	1.12	0.95;
	2164	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2165	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2166	1	10.58	2.71	0	0	1	1	0	110	3	1.12	0.95;
	2167	1	0	0.15	0	0	1	1	0	110	3	1.12	0.95;
	2168	1	4.05	0	0	0	1	1	0	110	3	1.12	0.95;
	2169	1	4.59	2.71	0	0	1	1	0	110	3	1.12	0.95;
	2170	1	6.85	3.64	0	0	1	1	0	110	3	1.12	0.95;
	2171	1	5.88	2.76	0	0	1	1	0	110	3	1.12	0.95;
	2172	1	0.64	0.2	0	0	1	1	0	110	3	1.12	0.95;
	2173	1	0.32	0.1	0	0	1	1	0	110	3	1.12	0.95;
	2174	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2175	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2176	2	7.48	7.22	0	0	1	1	0	110	3	1.12	0.95;
	2177	2	0	1.11	0	0	1	1	0	110	3	1.12	0.95;
	2178	1	3.32	1.27	0	0	1	1	0	110	3	1.12	0.95;
	2179	1	3.85	1.38	0	0	1	1	0	110	3	1.12	0.95;
	2180	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2181	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2182	1	1.71	0.52	0	0	1	1	0	110	3	1.12	0.95;
	2183	1	4.28	1.29	0	0	1	1	0	110	3	1.12	0.95;
	2184	1	10.81	3.12	0	0	1	1	0	110	3	1.12	0.95;
	2185	1	8.77	1.83	0	0	1	1	0	110	3	1.12	0.95;
	2186	1	8.22	2.61	0	0	1	1	0	110	3	1.12	0.95;
	2187	1	7.37	2.31	0	0	1	1	0	110	3	1.12	0.95;
	2188	1	5.25	2.76	0	0	1	1	0	110	3	1.12	0.95;
	2189	1	8.39	3.23	0	0	1	1	0	110	3	1.12	0.95;
	2190	1	6.97	2.43	0	0	1	1	0	110	3	1.12	0.95;
	2191	1	3.68	0.99	0	0	1	1	0	110	3	1.12	0.95;
	2192	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2193	1	4.49	1.83	0	0	1	1	0	110	3	1.12	0.95;
	2194	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2195	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2196	1	4.06	1.3	0	0	1	1	0	110	3	1.12	0.95;
	2197	1	2.99	0.9	0	0	1	1	0	110	3	1.12	0.95;
	2198	1	5.66	1.86	0	0	1	1	0	110	3	1.12	0.95;
	2199	1	7.38	2.74	0	0	1	1	0	110	3	1.12	0.95;
	2200	1	2.88	0.85	0	0	1	1	0	110	3	1.12	0.95;
	2201	1	3.32	1.45	0	0	1	1	0	110	3	1.12	0.95;
	2202	1	5.31	1.48	0	0	1	1	0	110	3	1.12	0.95;
	2203	1	7.42	2.01	0	0	1	1	0	110	3	1.12	0.95;
	2204	1	0.75	0.3	0	0	1	1	0	110	3	1.12	0.95;
	2205	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2206	1	13.57	5.12	0	0	1	1	0	110	3	1.12	0.95;
	2207	1	3.42	0.5	0	0	1	1	0	110	3	1.12	0.95;
	2208	1	5.68	2.3	0	0	1	1	0	110	3	1.12	0.95;
	2209	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2210	1	2.15	0.56	0	0	1	1	0	110	3	1.12	0.95;
	2211	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2212	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2213	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2214	2	4.01	1.01	0	0	1	1	0	110	3	1.12	0.95;
	2215	2	28	18.76	0	0	1	1	0	110	3	1.12	0.95;
	2216	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2217	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2218	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2219	1	10.28	3.76	0	0	1	1	0	110	3	1.12	0.95;
	2220	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2221	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2222	1	11.82	4.66	0	0	1	1	0	110	3	1.12	0.95;
	2223	1	11.21	4.84	0	0	1	1	0	110	3	1.12	0.95;
	2224	1	4.13	1.7	0	0	1	1	0	110	3	1.12	0.95;
	2225	1	2.57	1.04	0	0	1	1	0	110	3	1.12	0.95;
	2226	1	2.14	1.32	0	0	1	1	0	110	3	1.12	0.95;
	2227	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2228	1	2.78	1.4	0	0	1	1	0	110	3	1.12	0.95;
	2229	1	6.63	1.08	0	0	1	1	0	110	3	1.12	0.95;
	2230	1	10.6	3.89	0	0	1	1	0	110	3	1.12	0.95;
	2231	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2232	1	0.53	0.3	0	0	1	1	0	110	3	1.12	0.95;
	2233	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2234	1	0	0	0	0	1	1	0	110	3	1.12	0.95;
	2235	2	26.51	6.92	0	0	1	1	0	110	3	1.12	0.95;
	2236	1	15.26	4.76	0	0	1	1	0	110	3	1.12	0.95;
	2237	2	6	20	0	0	1	1	0	110	4	1.12	0.95;
	2238	1	2.22	0.71	0	0	1	1	0	110	4	1.12	0.95;
	2239	1	1.14	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2240	1	23.13	6.91	0	0	1	1	0	110	4	1.12	0.95;
	2241	1	5.28	2.31	0	0	1	1	0	110	4	1.12	0.95;
	2242	1	8.53	1.26	0	0	1	1	0	110	4	1.12	0.95;
	2243	1	3.12	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2244	1	8.33	2.46	0	0	1	1	0	110	4	1.12	0.95;
	2245	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2246	1	5.1	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2247	1	52.06	21.23	0	0	1	1	0	110	4	1.12	0.95;
	2248	1	11.45	2.64	0	0	1	1	0	110	4	1.12	0.95;
	2249	1	9.69	0.76	0	0	1	1	0	110	4	1.12	0.95;
	2250	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2251	1	25.91	6.42	0	0	1	1	0	110	4	1.12	0.95;
	2252	1	4.78	1.27	0	0	1	1	0	110	4	1.12	0.95;
	2253	2	4.79	1.28	0	0	1	1	0	110	4	1.12	0.95;
	2254	1	8.83	2.53	0	0	1	1	0	110	4	1.12	0.95;
	2255	1	6.14	0.12	0	0	1	1	0	110	4	1.12	0.95;
	2256	2	3.65	0.13	0	0	1	1	0	110	4	1.12	0.95;
	2257	1	24.38	4.55	0	0	1	1	0	110	4	1.12	0.95;
	2258	1	4.48	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2259	1	3.33	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2260	1	10.73	2.93	0	0	1	1	0	110	4	1.12	0.95;
	2261	1	6.77	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2262	1	3.43	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2263	1	12.49	1.06	0	0	1	1	0	110	4	1.12	0.95;
	2264	1	13.13	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2265	1	1.46	0.52	0	0	1	1	0	110	4	1.12	0.95;
	2266	1	5.4	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2267	2	4.69	0.54	0	0	1	1	0	110	4	1.12	0.95;
	2268	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2269	1	10.84	2.51	0	0	1	1	0	110	4	1.12	0.95;
	2270	1	4.16	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2271	2	7.51	1.19	0	0	1	1	0	110	4	1.12	0.95;
	2272	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2273	2	2.08	-0.61	0	0	1	1	0	110	4	1.12	0.95;
	2274	2	6.72	6.52	0	0	1	1	0	110	4	1.12	0.95;
	2275	1	2.81	0	0	0	1	1	0	110	4	1.12	0.95;
	2276	1	23.13	3.56	0	0	1	1	0	110	4	1.12	0.95;
	2277	1	6.04	2.42	0	0	1	1	0	110	4	1.12	0.95;
	2278	1	2.5	0.11	0	0	1	1	0	110	4	1.12	0.95;
	2279	1	3.02	1.27	0	0	1	1	0	110	4	1.12	0.95;
	2280	1	2.29	0.33	0	0	1	1	0	110	4	1.12	0.95;
	2281	1	10.33	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2282	1	2.08	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2283	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2284	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2285	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2286	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2287	1	2.6	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2288	1	6.63	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2289	1	19.17	4.29	0	0	1	1	0	110	4	1.12	0.95;
	2290	1	2.5	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2291	1	5.52	1.36	0	0	1	1	0	110	4	1.12	0.95;
	2292	1	2.81	0.73	0	0	1	1	0	110	4	1.12	0.95;
	2293	1	18.03	3.77	0	0	1	1	0	110	4	1.12	0.95;
	2294	1	12.49	4.85	0	0	1	1	0	110	4	1.12	0.95;
	2295	1	4.68	0.1	0	0	1	1	0	110	4	1.12	0.95;
	2296	1	8.84	2.21	0	0	1	1	0	110	4	1.12	0.95;
	2297	1	3.63	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2298	1	8.39	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2299	1	3.54	1.16	0	0	1	1	0	110	4	1.12	0.95;
	2300	2	19.22	32.9	0	0	1	1	0	110	4	1.12	0.95;
	2301	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2302	1	7.88	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2303	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2304	1	11.98	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2305	1	3.75	0.94	0	0	1	1	0	110	4	1.12	0.95;
	2306	2	0.01	0.01	0	0	1	1	0	110	4	1.12	0.95;
	2307	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2308	1	7.08	1.72	0	0	1	1	0	110	4	1.12	0.95;
	2309	1	10.41	1.85	0	0	1	1	0	110	4	1.12	0.95;
	2310	2	30.2	18.18	0	0	1	1	0	110	4	1.12	0.95;
	2311	2	0	-1.8	0	0	1	1	0	110	4	1.12	0.95;
	2312	1	7.61	3.45	0	0	1	1	0	110	4	1.12	0.95;
	2313	1	2.29	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2314	1	6.56	2.09	0	0	1	1	0	110	4	1.12	0.95;
	2315	1	9.38	2.09	0	0	1	1	0	110	4	1.12	0.95;
	2316	2	4.69	1.91	0	0	1	1	0	110	4	1.12	0.95;
	2317	2	0.1	-0.79	0	0	1	1	0	110	4	1.12	0.95;
	2318	1	0.1	0.05	0	0	1	1	0	110	4	1.12	0.95;
	2319	1	13.54	0.01	0	0	1	1	0	110	4	1.12	0.95;
	2320	2	9.48	-2.42	0	0	1	1	0	110	4	1.12	0.95;
	2321	1	8.75	-0.5	0	0	1	1	0	110	4	1.12	0.95;
	2322	2	7.62	2.1	0	0	1	1	0	110	4	1.12	0.95;
	2323	2	3.01	5.01	0	0	1	1	0	110	4	1.12	0.95;
	2324	2	0.01	0.01	0	0	1	1	0	110	4	1.12	0.95;
	2325	1	12.91	4.74	0	0	1	1	0	110	4	1.12	0.95;
	2326	1	4.56	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2327	1	4.56	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2328	1	8.01	4.41	0	0	1	1	0	110	4	1.12	0.95;
	2329	1	20.42	4.6	0	0	1	1	0	110	4	1.12	0.95;
	2330	1	3.23	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2331	1	9.37	3.79	0	0	1	1	0	110	4	1.12	0.95;
	2332	1	3.75	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2333	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2334	1	9.64	2.35	0	0	1	1	0	110	4	1.12	0.95;
	2335	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2336	1	15.55	3.21	0	0	1	1	0	110	4	1.12	0.95;
	2337	2	37.73	6.71	0	0	1	1	0	110	4	1.12	0.95;
	2338	1	5.3	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2339	1	14.16	5.69	0	0	1	1	0	110	4	1.12	0.95;
	2340	1	3.73	0.86	0	0	1	1	0	110	4	1.12	0.95;
	2341	1	5.29	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2342	1	1.56	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2343	1	1.56	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2344	1	6.88	2.2	0	0	1	1	0	110	4	1.12	0.95;
	2345	2	24.96	8.44	0	0	1	1	0	110	4	1.12	0.95;
	2346	1	24.95	8.43	0	0	1	1	0	110	4	1.12	0.95;
	2347	1	19.51	7.58	0	0	1	1	0	110	4	1.12	0.95;
	2348	1	39.03	15.16	0	0	1	1	0	110	4	1.12	0.95;
	2349	2	11.47	6.86	0	0	1	1	0	110	4	1.12	0.95;
	2350	1	11.46	6.85	0	0	1	1	0	110	4	1.12	0.95;
	2351	1	110.89	66.23	0	0	1	1	0	110	4	1.12	0.95;
	2352	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2353	1	3.72	1.2	0	0	1	1	0	110	4	1.12	0.95;
	2354	1	3.72	1.2	0	0	1	1	0	110	4	1.12	0.95;
	2355	1	6.46	2.62	0	0	1	1	0	110	4	1.12	0.95;
	2356	1	10.41	2.95	0	0	1	1	0	110	4	1.12	0.95;
	2357	2	5.74	0.38	0	0	1	1	0	110	4	1.12	0.95;
	2358	1	12.69	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2359	1	11.4	3.74	0	0	1	1	0	110	4	1.12	0.95;
	2360	1	9.41	1	0	0	1	1	0	110	4	1.12	0.95;
	2361	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2362	1	12.5	2.2	0	0	1	1	0	110	4	1.12	0.95;
	2363	1	9.87	2.64	0	0	1	1	0	110	4	1.12	0.95;
	2364	1	15.73	5.75	0	0	1	1	0	110	4	1.12	0.95;
	2365	1	7.91	1.37	0	0	1	1	0	110	4	1.12	0.95;
	2366	2	16.39	0.03	0	0	1	1	0	110	4	1.12	0.95;
	2367	1	8.84	2.1	0	0	1	1	0	110	4	1.12	0.95;
	2368	2	3.97	0.22	0	0	1	1	0	110	4	1.12	0.95;
	2369	1	6.55	2.52	0	0	1	1	0	110	4	1.12	0.95;
	2370	2	16.26	5.8	0	0	1	1	0	110	4	1.12	0.95;
	2371	1	3.64	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2372	1	3.33	1.27	0	0	1	1	0	110	4	1.12	0.95;
	2373	1	12.41	3.31	0	0	1	1	0	110	4	1.12	0.95;
	2374	2	5.71	1.87	0	0	1	1	0	110	4	1.12	0.95;
	2375	2	19.99	8.43	0	0	1	1	0	110	4	1.12	0.95;
	2376	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2377	2	22.88	1.08	0	0	1	1	0	110	4	1.12	0.95;
	2378	1	16.95	4.84	0	0	1	1	0	110	4	1.12	0.95;
	2379	2	18.77	6.81	0	0	1	1	0	110	4	1.12	0.95;
	2380	1	7.28	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2381	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2382	1	5.83	2	0	0	1	1	0	110	4	1.12	0.95;
	2383	2	7.19	2.59	0	0	1	1	0	110	4	1.12	0.95;
	2384	1	17.19	7.74	0	0	1	1	0	110	4	1.12	0.95;
	2385	1	12.38	4.36	0	0	1	1	0	110	4	1.12	0.95;
	2386	1	12.38	4.36	0	0	1	1	0	110	4	1.12	0.95;
	2387	1	6.03	2.31	0	0	1	1	0	110	4	1.12	0.95;
	2388	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2389	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2390	2	12.12	3.64	0	0	1	1	0	110	4	1.12	0.95;
	2391	1	12.11	3.63	0	0	1	1	0	110	4	1.12	0.95;
	2392	1	12.11	3.63	0	0	1	1	0	110	4	1.12	0.95;
	2393	1	7.81	2.42	0	0	1	1	0	110	4	1.12	0.95;
	2394	1	4.72	0.34	0	0	1	1	0	110	4	1.12	0.95;
	2395	1	3.33	0.79	0	0	1	1	0	110	4	1.12	0.95;
	2396	1	3.33	0.79	0	0	1	1	0	110	4	1.12	0.95;
	2397	1	3.17	1.54	0	0	1	1	0	110	4	1.12	0.95;
	2398	1	3.17	1.54	0	0	1	1	0	110	4	1.12	0.95;
	2399	1	10.41	3.8	0	0	1	1	0	110	4	1.12	0.95;
	2400	2	13.52	6.68	0	0	1	1	0	110	4	1.12	0.95;
	2401	1	16.38	4.42	0	0	1	1	0	110	4	1.12	0.95;
	2402	1	30.08	7.86	0	0	1	1	0	110	4	1.12	0.95;
	2403	2	6.78	12.18	0	0	1	1	0	110	4	1.12	0.95;
	2404	2	1	3	0	0	1	1	0	110	4	1.12	0.95;
	2405	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2406	1	5.3	2.21	0	0	1	1	0	110	4	1.12	0.95;
	2407	1	9.87	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2408	2	15.74	7.73	0	0	1	1	0	110	4	1.12	0.95;
	2409	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2410	1	15.73	7.72	0	0	1	1	0	110	4	1.12	0.95;
	2411	1	15.73	7.72	0	0	1	1	0	110	4	1.12	0.95;
	2412	1	3.43	1.37	0	0	1	1	0	110	4	1.12	0.95;
	2413	1	3.85	4.11	0	0	1	1	0	110	4	1.12	0.95;
	2414	1	3.85	4.11	0	0	1	1	0	110	4	1.12	0.95;
	2415	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2416	1	3.96	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2417	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2418	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2419	1	28.65	10.53	0	0	1	1	0	110	4	1.12	0.95;
	2420	1	28.65	10.53	0	0	1	1	0	110	4	1.12	0.95;
	2421	1	7.6	3.05	0	0	1	1	0	110	4	1.12	0.95;
	2422	1	5.73	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2423	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2424	1	3.13	1.32	0	0	1	1	0	110	4	1.12	0.95;
	2425	1	3.13	1.32	0	0	1	1	0	110	4	1.12	0.95;
	2426	1	14.48	7.79	0	0	1	1	0	110	4	1.12	0.95;
	2427	1	3.48	3.48	0	0	1	1	0	110	4	1.12	0.95;
	2428	1	1.56	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2429	1	1.56	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2430	1	4.91	2	0	0	1	1	0	110	4	1.12	0.95;
	2431	1	2.6	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2432	1	2.6	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2433	2	24.89	5.37	0	0	1	1	0	110	4	1.12	0.95;
	2434	1	3.7	3.27	0	0	1	1	0	110	4	1.12	0.95;
	2435	1	3.7	3.26	0	0	1	1	0	110	4	1.12	0.95;
	2436	1	2.87	2.58	0	0	1	1	0	110	4	1.12	0.95;
	2437	1	2.87	2.58	0	0	1	1	0	110	4	1.12	0.95;
	2438	2	7.71	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2439	1	29.54	6.62	0	0	1	1	0	110	4	1.12	0.95;
	2440	1	11.98	4.39	0	0	1	1	0	110	4	1.12	0.95;
	2441	1	8.53	2.73	0	0	1	1	0	110	4	1.12	0.95;
	2442	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2443	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2444	1	3.75	1.53	0	0	1	1	0	110	4	1.12	0.95;
	2445	1	5.73	2.42	0	0	1	1	0	110	4	1.12	0.95;
	2446	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2447	2	5.59	1.62	0	0	1	1	0	110	4	1.12	0.95;
	2448	1	5.58	1.61	0	0	1	1	0	110	4	1.12	0.95;
	2449	1	5.62	1.89	0	0	1	1	0	110	4	1.12	0.95;
	2450	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2451	1	4.27	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2452	1	5.49	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2453	1	7.64	3.05	0	0	1	1	0	110	4	1.12	0.95;
	2454	1	7.64	3.05	0	0	1	1	0	110	4	1.12	0.95;
	2455	1	6.87	2	0	0	1	1	0	110	4	1.12	0.95;
	2456	2	11.96	4.23	0	0	1	1	0	110	4	1.12	0.95;
	2457	1	1.87	0.42	0	0	1	1	0	110	4	1.12	0.95;
	2458	1	10.09	3.32	0	0	1	1	0	110	4	1.12	0.95;
	2459	1	4.27	0.12	0	0	1	1	0	110	4	1.12	0.95;
	2460	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2461	1	22.92	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2462	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2463	1	11.46	3.24	0	0	1	1	0	110	4	1.12	0.95;
	2464	1	10.94	3.42	0	0	1	1	0	110	4	1.12	0.95;
	2465	1	10.94	3.42	0	0	1	1	0	110	4	1.12	0.95;
	2466	1	8.85	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2467	1	7.81	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2468	1	7.81	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2469	1	9.38	2	0	0	1	1	0	110	4	1.12	0.95;
	2470	1	17.71	5.34	0	0	1	1	0	110	4	1.12	0.95;
	2471	1	5.62	2.32	0	0	1	1	0	110	4	1.12	0.95;
	2472	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2473	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2474	1	14.59	5.34	0	0	1	1	0	110	4	1.12	0.95;
	2475	1	3.02	1.89	0	0	1	1	0	110	4	1.12	0.95;
	2476	1	1.66	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2477	1	1.66	0.64	0	0	1	1	0	110	4	1.12	0.95;
	2478	1	9.88	1.26	0	0	1	1	0	110	4	1.12	0.95;
	2479	1	4.68	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2480	1	8.42	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2481	1	4.16	1.69	0	0	1	1	0	110	4	1.12	0.95;
	2482	1	5.21	1.48	0	0	1	1	0	110	4	1.12	0.95;
	2483	1	7.19	3.35	0	0	1	1	0	110	4	1.12	0.95;
	2484	1	4.27	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2485	1	1.46	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2486	1	4.46	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2487	1	9.33	2.14	0	0	1	1	0	110	4	1.12	0.95;
	2488	1	2.6	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2489	1	2.67	0.89	0	0	1	1	0	110	4	1.12	0.95;
	2490	1	2.67	0.89	0	0	1	1	0	110	4	1.12	0.95;
	2491	1	6.56	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2492	1	2.29	0.42	0	0	1	1	0	110	4	1.12	0.95;
	2493	1	10.93	4.12	0	0	1	1	0	110	4	1.12	0.95;
	2494	1	7.87	1.56	0	0	1	1	0	110	4	1.12	0.95;
	2495	2	7.88	1.57	0	0	1	1	0	110	4	1.12	0.95;
	2496	2	1.79	0.76	0	0	1	1	0	110	4	1.12	0.95;
	2497	1	1.67	0.74	0	0	1	1	0	110	4	1.12	0.95;
	2498	1	13.75	2.09	0	0	1	1	0	110	4	1.12	0.95;
	2499	1	3.11	0.86	0	0	1	1	0	110	4	1.12	0.95;
	2500	1	4.77	0.54	0	0	1	1	0	110	4	1.12	0.95;
	2501	1	7.08	1.79	0	0	1	1	0	110	4	1.12	0.95;
	2502	1	7.61	1.67	0	0	1	1	0	110	4	1.12	0.95;
	2503	1	5.21	1.36	0	0	1	1	0	110	4	1.12	0.95;
	2504	1	13.86	0.73	0	0	1	1	0	110	4	1.12	0.95;
	2505	1	11.88	5.44	0	0	1	1	0	110	4	1.12	0.95;
	2506	1	6.87	3.68	0	0	1	1	0	110	4	1.12	0.95;
	2507	1	7.29	0.73	0	0	1	1	0	110	4	1.12	0.95;
	2508	1	4.06	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2509	1	11.45	4.64	0	0	1	1	0	110	4	1.12	0.95;
	2510	1	8.43	3.37	0	0	1	1	0	110	4	1.12	0.95;
	2511	1	7.07	1.68	0	0	1	1	0	110	4	1.12	0.95;
	2512	1	19.17	3.14	0	0	1	1	0	110	4	1.12	0.95;
	2513	1	14.04	2.1	0	0	1	1	0	110	4	1.12	0.95;
	2514	1	12.59	3.76	0	0	1	1	0	110	4	1.12	0.95;
	2515	1	6.77	-1.7	0	0	1	1	0	110	4	1.12	0.95;
	2516	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2517	1	7.29	2.46	0	0	1	1	0	110	4	1.12	0.95;
	2518	1	12.3	3.14	0	0	1	1	0	110	4	1.12	0.95;
	2519	1	7.5	2.4	0	0	1	1	0	110	4	1.12	0.95;
	2520	1	5.83	2.44	0	0	1	1	0	110	4	1.12	0.95;
	2521	2	3.76	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2522	2	18.61	6.7	0	0	1	1	0	110	4	1.12	0.95;
	2523	1	21.86	7.81	0	0	1	1	0	110	4	1.12	0.95;
	2524	2	10.64	1.37	0	0	1	1	0	110	4	1.12	0.95;
	2525	2	14.46	-18.8	0	0	1	1	0	110	4	1.12	0.95;
	2526	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2527	2	21.08	8.63	0	0	1	1	0	110	4	1.12	0.95;
	2528	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2529	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2530	1	0	0	0	0	1	1	0	16	4	1.12	0.95;
	2531	1	11.75	5.05	0	0	1	1	0	110	4	1.12	0.95;
	2532	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2533	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2534	2	3.33	0.71	0	0	1	1	0	110	4	1.12	0.95;
	2535	2	15.78	30.64	0	0	1	1	0	110	4	1.12	0.95;
	2536	1	4.17	1.21	0	0	1	1	0	110	4	1.12	0.95;
	2537	1	4.17	1.21	0	0	1	1	0	110	4	1.12	0.95;
	2538	1	3.33	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2539	1	3.22	0.74	0	0	1	1	0	110	4	1.12	0.95;
	2540	1	11.05	3.09	0	0	1	1	0	110	4	1.12	0.95;
	2541	1	4.48	1.23	0	0	1	1	0	110	4	1.12	0.95;
	2542	1	6.04	1.97	0	0	1	1	0	110	4	1.12	0.95;
	2543	1	9.79	2.82	0	0	1	1	0	110	4	1.12	0.95;
	2544	1	8.7	-2.98	0	0	1	1	0	110	4	1.12	0.95;
	2545	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2546	1	10.73	-0.54	0	0	1	1	0	110	4	1.12	0.95;
	2547	2	15.64	-0.88	0	0	1	1	0	110	4	1.12	0.95;
	2548	2	14.81	-0.99	0	0	1	1	0	110	4	1.12	0.95;
	2549	1	4.16	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2550	1	3.96	1.6	0	0	1	1	0	110	4	1.12	0.95;
	2551	1	15.53	-1.1	0	0	1	1	0	110	4	1.12	0.95;
	2552	1	18.75	5.96	0	0	1	1	0	110	4	1.12	0.95;
	2553	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2554	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2555	2	21.87	12.66	0	0	1	1	0	110	4	1.12	0.95;
	2556	1	24.98	23.19	0	0	1	1	0	110	4	1.12	0.95;
	2557	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2558	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2559	1	3.59	0.58	0	0	1	1	0	110	4	1.12	0.95;
	2560	1	3.59	0.58	0	0	1	1	0	110	4	1.12	0.95;
	2561	1	5.72	-0.5	0	0	1	1	0	110	4	1.12	0.95;
	2562	1	13.54	1.26	0	0	1	1	0	110	4	1.12	0.95;
	2563	1	2.29	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2564	1	14.57	4.22	0	0	1	1	0	110	4	1.12	0.95;
	2565	1	16.13	4.74	0	0	1	1	0	110	4	1.12	0.95;
	2566	1	14.59	7.32	0	0	1	1	0	110	4	1.12	0.95;
	2567	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2568	1	5.4	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2569	1	5.21	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2570	1	16.05	6.28	0	0	1	1	0	110	4	1.12	0.95;
	2571	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2572	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2573	2	5.34	1.77	0	0	1	1	0	110	4	1.12	0.95;
	2574	2	5.67	5.84	0	0	1	1	0	110	4	1.12	0.95;
	2575	1	10.84	2.41	0	0	1	1	0	110	4	1.12	0.95;
	2576	1	17.19	4.39	0	0	1	1	0	110	4	1.12	0.95;
	2577	1	5.31	-0.5	0	0	1	1	0	110	4	1.12	0.95;
	2578	1	6.88	-0.7	0	0	1	1	0	110	4	1.12	0.95;
	2579	1	22.51	1.81	0	0	1	1	0	110	4	1.12	0.95;
	2580	1	11.46	3.77	0	0	1	1	0	110	4	1.12	0.95;
	2581	1	11.46	4.08	0	0	1	1	0	110	4	1.12	0.95;
	2582	2	9.23	10.65	0	0	1	1	0	110	4	1.12	0.95;
	2583	1	9.22	10.64	0	0	1	1	0	110	4	1.12	0.95;
	2584	1	3.13	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2585	2	31.99	-1.93	0	0	1	1	0	110	4	1.12	0.95;
	2586	1	19.28	2.2	0	0	1	1	0	110	4	1.12	0.95;
	2587	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2588	1	13.86	3.66	0	0	1	1	0	110	4	1.12	0.95;
	2589	1	6.37	0.52	0	0	1	1	0	110	4	1.12	0.95;
	2590	1	6.37	0.52	0	0	1	1	0	110	4	1.12	0.95;
	2591	2	4.28	1.61	0	0	1	1	0	110	4	1.12	0.95;
	2592	1	7.7	3.16	0	0	1	1	0	110	4	1.12	0.95;
	2593	2	10.85	2.63	0	0	1	1	0	110	4	1.12	0.95;
	2594	1	11.05	3.66	0	0	1	1	0	110	4	1.12	0.95;
	2595	1	2.92	1.26	0	0	1	1	0	110	4	1.12	0.95;
	2596	1	4.06	2.94	0	0	1	1	0	110	4	1.12	0.95;
	2597	2	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2598	2	7.4	2.54	0	0	1	1	0	110	4	1.12	0.95;
	2599	1	12.4	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2600	2	55.19	24.54	0	0	1	1	0	110	4	1.12	0.95;
	2601	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2602	1	2.5	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2603	1	2.9	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2604	1	7.05	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2605	1	8.95	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2606	1	8.11	1.58	0	0	1	1	0	110	4	1.12	0.95;
	2607	1	5.36	0	0	0	1	1	0	110	4	1.12	0.95;
	2608	1	0.83	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2609	1	0.83	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2610	1	8.33	1.48	0	0	1	1	0	110	4	1.12	0.95;
	2611	1	6.77	0.25	0	0	1	1	0	110	4	1.12	0.95;
	2612	1	16.78	-0.57	0	0	1	1	0	110	4	1.12	0.95;
	2613	1	8.13	4.5	0	0	1	1	0	110	4	1.12	0.95;
	2614	1	1.2	0.47	0	0	1	1	0	110	4	1.12	0.95;
	2615	1	1.2	0.47	0	0	1	1	0	110	4	1.12	0.95;
	2616	2	1.88	0.43	0	0	1	1	0	110	4	1.12	0.95;
	2617	2	4.57	0.55	0	0	1	1	0	110	4	1.12	0.95;
	2618	1	5.21	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2619	2	3.84	2.22	0	0	1	1	0	110	4	1.12	0.95;
	2620	1	21.84	8.2	0	0	1	1	0	110	4	1.12	0.95;
	2621	2	13.67	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2622	1	7.29	1.85	0	0	1	1	0	110	4	1.12	0.95;
	2623	1	14.15	5.88	0	0	1	1	0	110	4	1.12	0.95;
	2624	1	11.25	2.93	0	0	1	1	0	110	4	1.12	0.95;
	2625	2	20.01	2.97	0	0	1	1	0	110	4	1.12	0.95;
	2626	1	12.6	5.64	0	0	1	1	0	110	4	1.12	0.95;
	2627	2	29.18	7.34	0	0	1	1	0	110	4	1.12	0.95;
	2628	1	9.79	0.54	0	0	1	1	0	110	4	1.12	0.95;
	2629	2	20.22	4.05	0	0	1	1	0	110	4	1.12	0.95;
	2630	2	15.32	-2.09	0	0	1	1	0	110	4	1.12	0.95;
	2631	1	1.16	0.28	0	0	1	1	0	110	4	1.12	0.95;
	2632	1	5.72	2.32	0	0	1	1	0	110	4	1.12	0.95;
	2633	1	5.83	2.32	0	0	1	1	0	110	4	1.12	0.95;
	2634	1	2.81	0.95	0	0	1	1	0	110	4	1.12	0.95;
	2635	1	2.81	0.95	0	0	1	1	0	110	4	1.12	0.95;
	2636	1	10.62	7.14	0	0	1	1	0	110	4	1.12	0.95;
	2637	1	10.2	-2.4	0	0	1	1	0	110	4	1.12	0.95;
	2638	1	7.98	0.75	0	0	1	1	0	110	4	1.12	0.95;
	2639	1	1.35	0.42	0	0	1	1	0	110	4	1.12	0.95;
	2640	1	6.32	1.71	0	0	1	1	0	110	4	1.12	0.95;
	2641	1	23.97	6.28	0	0	1	1	0	110	4	1.12	0.95;
	2642	1	7.68	2.45	0	0	1	1	0	110	4	1.12	0.95;
	2643	1	12.49	4.92	0	0	1	1	0	110	4	1.12	0.95;
	2644	2	0.1	0.1	0	0	1	1	0	110	4	1.12	0.95;
	2645	1	6.25	1.74	0	0	1	1	0	110	4	1.12	0.95;
	2646	1	6.25	1.74	0	0	1	1	0	110	4	1.12	0.95;
	2647	1	1.97	0	0	0	1	1	0	110	4	1.12	0.95;
	2648	1	0.63	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2649	2	13.13	5.28	0	0	1	1	0	110	4	1.12	0.95;
	2650	2	6.04	2.22	0	0	1	1	0	110	4	1.12	0.95;
	2651	1	8.22	3.47	0	0	1	1	0	110	4	1.12	0.95;
	2652	2	9.37	3.61	0	0	1	1	0	110	4	1.12	0.95;
	2653	1	7.28	1.26	0	0	1	1	0	110	4	1.12	0.95;
	2654	1	4.68	1.9	0	0	1	1	0	110	4	1.12	0.95;
	2655	2	6.46	2.54	0	0	1	1	0	110	4	1.12	0.95;
	2656	1	22.72	-1.7	0	0	1	1	0	110	4	1.12	0.95;
	2657	1	10.22	-2.16	0	0	1	1	0	110	4	1.12	0.95;
	2658	1	12.23	2.99	0	0	1	1	0	110	4	1.12	0.95;
	2659	1	7.29	-0.75	0	0	1	1	0	110	4	1.12	0.95;
	2660	1	4.83	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2661	1	4.83	2.11	0	0	1	1	0	110	4	1.12	0.95;
	2662	1	2.18	1.06	0	0	1	1	0	110	4	1.12	0.95;
	2663	1	13.72	5.81	0	0	1	1	0	110	4	1.12	0.95;
	2664	1	12.47	5.8	0	0	1	1	0	110	4	1.12	0.95;
	2665	1	9.87	3.69	0	0	1	1	0	110	4	1.12	0.95;
	2666	1	9.87	3.69	0	0	1	1	0	110	4	1.12	0.95;
	2667	2	22.35	30.86	0	0	1	1	0	110	4	1.12	0.95;
	2668	1	9.35	6.86	0	0	1	1	0	110	4	1.12	0.95;
	2669	1	21.76	6.1	0	0	1	1	0	110	4	1.12	0.95;
	2670	1	21.86	7.81	0	0	1	1	0	110	4	1.12	0.95;
	2671	1	3.33	1.18	0	0	1	1	0	110	4	1.12	0.95;
	2672	1	6.25	1.97	0	0	1	1	0	110	4	1.12	0.95;
	2673	1	22.38	7.63	0	0	1	1	0	110	4	1.12	0.95;
	2674	1	19.48	3.35	0	0	1	1	0	110	4	1.12	0.95;
	2675	1	10.09	5.57	0	0	1	1	0	110	4	1.12	0.95;
	2676	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2677	1	20.32	5.44	0	0	1	1	0	110	4	1.12	0.95;
	2678	1	2.08	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2679	2	28.67	24.71	0	0	1	1	0	110	4	1.12	0.95;
	2680	2	16.91	5.94	0	0	1	1	0	110	4	1.12	0.95;
	2681	1	1.35	0.95	0	0	1	1	0	110	4	1.12	0.95;
	2682	1	2.71	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2683	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2684	2	0.63	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2685	2	6.76	1.59	0	0	1	1	0	110	4	1.12	0.95;
	2686	1	0.83	0	0	0	1	1	0	110	4	1.12	0.95;
	2687	1	5.2	1.47	0	0	1	1	0	110	4	1.12	0.95;
	2688	1	2.7	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2689	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2690	1	16.46	-2.5	0	0	1	1	0	110	4	1.12	0.95;
	2691	2	10.67	3.6	0	0	1	1	0	110	4	1.12	0.95;
	2692	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2693	1	7.66	2.25	0	0	1	1	0	110	4	1.12	0.95;
	2694	1	7.66	2.25	0	0	1	1	0	110	4	1.12	0.95;
	2695	2	6.63	-0.74	0	0	1	1	0	110	4	1.12	0.95;
	2696	1	6.62	-0.75	0	0	1	1	0	110	4	1.12	0.95;
	2697	1	18.03	-1.3	0	0	1	1	0	110	4	1.12	0.95;
	2698	2	10.85	2.61	0	0	1	1	0	110	4	1.12	0.95;
	2699	1	10.84	2.6	0	0	1	1	0	110	4	1.12	0.95;
	2700	1	4.4	-0.61	0	0	1	1	0	110	4	1.12	0.95;
	2701	1	4.4	-0.61	0	0	1	1	0	110	4	1.12	0.95;
	2702	1	22.28	7.3	0	0	1	1	0	110	4	1.12	0.95;
	2703	1	6.83	2.62	0	0	1	1	0	110	4	1.12	0.95;
	2704	1	6.83	2.62	0	0	1	1	0	110	4	1.12	0.95;
	2705	2	8.34	-1.23	0	0	1	1	0	110	4	1.12	0.95;
	2706	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2707	1	20.84	2.93	0	0	1	1	0	110	4	1.12	0.95;
	2708	1	21.64	3.15	0	0	1	1	0	110	4	1.12	0.95;
	2709	1	4.06	0.53	0	0	1	1	0	110	4	1.12	0.95;
	2710	1	6.22	1.07	0	0	1	1	0	110	4	1.12	0.95;
	2711	1	12.64	2.98	0	0	1	1	0	110	4	1.12	0.95;
	2712	1	12.64	2.98	0	0	1	1	0	110	4	1.12	0.95;
	2713	1	8.51	1.61	0	0	1	1	0	110	4	1.12	0.95;
	2714	1	8.51	1.61	0	0	1	1	0	110	4	1.12	0.95;
	2715	1	4.68	1.85	0	0	1	1	0	110	4	1.12	0.95;
	2716	1	4.68	1.85	0	0	1	1	0	110	4	1.12	0.95;
	2717	1	6.36	0.03	0	0	1	1	0	110	4	1.12	0.95;
	2718	1	9.13	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2719	1	9.13	0.37	0	0	1	1	0	110	4	1.12	0.95;
	2720	1	16.95	6.41	0	0	1	1	0	110	4	1.12	0.95;
	2721	1	15.97	5.52	0	0	1	1	0	110	4	1.12	0.95;
	2722	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2723	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2724	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2725	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2726	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2727	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2728	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2729	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2730	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2731	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2732	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2733	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2734	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2735	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2736	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2737	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2738	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2739	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2740	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2741	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2742	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2743	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2744	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2745	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2746	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2747	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2748	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2749	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2750	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2751	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2752	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2753	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2754	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2755	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2756	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2757	1	4.09	0.2	0	0	1	1	0	110	4	1.12	0.95;
	2758	1	4.09	0.2	0	0	1	1	0	110	4	1.12	0.95;
	2759	1	2.6	1.05	0	0	1	1	0	110	4	1.12	0.95;
	2760	1	9.36	2.1	0	0	1	1	0	110	4	1.12	0.95;
	2761	1	8.43	3.06	0	0	1	1	0	110	4	1.12	0.95;
	2762	1	57.21	18.91	0	0	1	1	0	110	4	1.12	0.95;
	2763	1	7.29	0.49	0	0	1	1	0	110	4	1.12	0.95;
	2764	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2765	1	5.41	2.46	0	0	1	1	0	110	4	1.12	0.95;
	2766	1	5.52	2.46	0	0	1	1	0	110	4	1.12	0.95;
	2767	1	11.7	3.47	0	0	1	1	0	110	4	1.12	0.95;
	2768	1	11.7	3.47	0	0	1	1	0	110	4	1.12	0.95;
	2769	1	3.75	0.84	0	0	1	1	0	110	4	1.12	0.95;
	2770	1	38.55	11.82	0	0	1	1	0	110	4	1.12	0.95;
	2771	1	28.21	10.33	0	0	1	1	0	110	4	1.12	0.95;
	2772	1	7.28	0	0	0	1	1	0	110	4	1.12	0.95;
	2773	1	14.56	6.31	0	0	1	1	0	110	4	1.12	0.95;
	2774	2	17.17	6.53	0	0	1	1	0	110	4	1.12	0.95;
	2775	1	9.87	2.64	0	0	1	1	0	110	4	1.12	0.95;
	2776	1	3.54	0.21	0	0	1	1	0	110	4	1.12	0.95;
	2777	1	5.6	0.86	0	0	1	1	0	110	4	1.12	0.95;
	2778	1	8.22	4.1	0	0	1	1	0	110	4	1.12	0.95;
	2779	1	15.42	-2.2	0	0	1	1	0	110	4	1.12	0.95;
	2780	1	8.14	2.04	0	0	1	1	0	110	4	1.12	0.95;
	2781	2	13.24	2.73	0	0	1	1	0	110	4	1.12	0.95;
	2782	2	3.33	-1.18	0	0	1	1	0	110	4	1.12	0.95;
	2783	1	11.66	2.83	0	0	1	1	0	110	4	1.12	0.95;
	2784	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2785	1	7.92	2.53	0	0	1	1	0	110	4	1.12	0.95;
	2786	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2787	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2788	1	0	0	0	0	1	1	0	110	4	1.12	0.95;
	2789	1	1.75	0.67	0	0	1	1	0	110	4	1.12	0.95;
	2790	1	1.56	0.63	0	0	1	1	0	110	4	1.12	0.95;
	2791	2	12.26	1	0	0	1	1	0	110	5	1.12	0.95;
	2792	1	8.94	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2793	1	16.58	5.72	0	0	1	1	0	110	5	1.12	0.95;
	2794	2	4.4	5.71	0	0	1	1	0	110	5	1.12	0.95;
	2795	2	6.33	5.23	0	0	1	1	0	110	5	1.12	0.95;
	2796	1	7.84	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2797	2	5.22	1	0	0	1	1	0	110	5	1.12	0.95;
	2798	1	5.22	0	0	0	1	1	0	110	5	1.12	0.95;
	2799	1	6.63	1.81	0	0	1	1	0	110	5	1.12	0.95;
	2800	1	11.55	5.82	0	0	1	1	0	110	5	1.12	0.95;
	2801	1	6.93	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2802	1	15.17	4.72	0	0	1	1	0	110	5	1.12	0.95;
	2803	2	6.33	1.91	0	0	1	1	0	110	5	1.12	0.95;
	2804	1	5.22	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2805	1	13.16	4.92	0	0	1	1	0	110	5	1.12	0.95;
	2806	1	6.53	2.91	0	0	1	1	0	110	5	1.12	0.95;
	2807	1	21	7.33	0	0	1	1	0	110	5	1.12	0.95;
	2808	1	13.06	4.72	0	0	1	1	0	110	5	1.12	0.95;
	2809	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2810	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2811	2	11.55	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2812	1	2.91	1.41	0	0	1	1	0	110	5	1.12	0.95;
	2813	1	7.94	2.81	0	0	1	1	0	110	5	1.12	0.95;
	2814	2	14.65	1	0	0	1	1	0	110	5	1.12	0.95;
	2815	2	8.14	1.32	0	0	1	1	0	110	5	1.12	0.95;
	2816	2	11.55	5.93	0	0	1	1	0	110	5	1.12	0.95;
	2817	1	9.45	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2818	1	8.94	4.02	0	0	1	1	0	110	5	1.12	0.95;
	2819	1	11.55	3.82	0	0	1	1	0	110	5	1.12	0.95;
	2820	1	9.75	5.12	0	0	1	1	0	110	5	1.12	0.95;
	2821	1	7.33	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2822	1	10.45	1	0	0	1	1	0	110	5	1.12	0.95;
	2823	2	11.55	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2824	1	14.17	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2825	1	5.22	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2826	2	3.12	0.4	0	0	1	1	0	110	5	1.12	0.95;
	2827	2	4.22	1	0	0	1	1	0	110	5	1.12	0.95;
	2828	2	0.8	0.2	0	0	1	1	0	110	5	1.12	0.95;
	2829	1	6.83	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2830	2	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2831	1	10.55	4.52	0	0	1	1	0	110	5	1.12	0.95;
	2832	1	0.8	0.2	0	0	1	1	0	110	5	1.12	0.95;
	2833	2	11.56	0.01	0	0	1	1	0	110	5	1.12	0.95;
	2834	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2835	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2836	2	14.76	6.32	0	0	1	1	0	110	5	1.12	0.95;
	2837	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2838	1	12.56	2.31	0	0	1	1	0	110	5	1.12	0.95;
	2839	1	12.56	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2840	1	5.53	2.01	0	0	1	1	0	110	5	1.12	0.95;
	2841	1	5.22	1.91	0	0	1	1	0	110	5	1.12	0.95;
	2842	2	1	1	0	0	1	1	0	110	5	1.12	0.95;
	2843	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2844	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2845	1	0	0	0	48.6	1	1	0	32	5	1.12	0.95;
	2846	2	19.05	8.51	0	0	1	1	0	110	5	1.12	0.95;
	2847	2	10.85	2.93	0	0	1	1	0	110	5	1.12	0.95;
	2848	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2849	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2850	1	16.78	3.82	0	0	1	1	0	110	5	1.12	0.95;
	2851	1	5.22	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2852	1	2.61	1	0	0	1	1	0	110	5	1.12	0.95;
	2853	1	4.72	0.7	0	0	1	1	0	110	5	1.12	0.95;
	2854	2	9.45	-3.27	0	0	1	1	0	110	5	1.12	0.95;
	2855	1	9.95	2.41	0	0	1	1	0	110	5	1.12	0.95;
	2856	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	2857	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	2858	1	6.83	4.12	0	0	1	1	0	110	5	1.12	0.95;
	2859	1	5.22	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2860	1	15.67	5.22	0	0	1	1	0	110	5	1.12	0.95;
	2861	1	16.78	4.72	0	0	1	1	0	110	5	1.12	0.95;
	2862	2	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2863	1	0.9	0.3	0	0	1	1	0	110	5	1.12	0.95;
	2864	1	2.61	0.8	0	0	1	1	0	110	5	1.12	0.95;
	2865	1	1.11	1	0	0	1	1	0	110	5	1.12	0.95;
	2866	1	10.15	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2867	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2868	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2869	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2870	1	0	0	0	60	1	1	0	16	5	1.12	0.95;
	2871	1	4.22	1	0	0	1	1	0	110	5	1.12	0.95;
	2872	1	6.33	0	0	0	1	1	0	110	5	1.12	0.95;
	2873	1	17.78	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2874	1	8.04	4.12	0	0	1	1	0	110	5	1.12	0.95;
	2875	2	7.23	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2876	1	7.13	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2877	1	8.94	2.71	0	0	1	1	0	110	5	1.12	0.95;
	2878	1	5.93	1.41	0	0	1	1	0	110	5	1.12	0.95;
	2879	1	0	0	0	45	1	1	0	16	5	1.12	0.95;
	2880	2	26.22	20.39	0	0	1	1	0	110	5	1.12	0.95;
	2881	1	8.94	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2882	1	4.22	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2883	1	6.13	2.51	0	0	1	1	0	110	5	1.12	0.95;
	2884	1	3.12	1.41	0	0	1	1	0	110	5	1.12	0.95;
	2885	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2886	1	24.11	5.22	0	0	1	1	0	110	5	1.12	0.95;
	2887	2	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2888	1	13.66	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2889	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	2890	1	4.22	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2891	1	9.95	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2892	1	13.06	0	0	0	1	1	0	110	5	1.12	0.95;
	2893	1	10.85	1	0	0	1	1	0	110	5	1.12	0.95;
	2894	2	7.33	1.09	0	0	1	1	0	110	5	1.12	0.95;
	2895	1	12.06	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2896	1	8.84	2.91	0	0	1	1	0	110	5	1.12	0.95;
	2897	1	12.06	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2898	1	5.42	2.31	0	0	1	1	0	110	5	1.12	0.95;
	2899	2	12.06	-0.14	0	0	1	1	0	110	5	1.12	0.95;
	2900	2	13.06	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2901	1	4.72	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2902	1	49.23	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2903	1	3.12	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2904	2	9.45	3.71	0	0	1	1	0	110	5	1.12	0.95;
	2905	2	6.33	-0.57	0	0	1	1	0	110	5	1.12	0.95;
	2906	1	6.33	0	0	0	1	1	0	110	5	1.12	0.95;
	2907	1	7.43	1.51	0	0	1	1	0	110	5	1.12	0.95;
	2908	1	13.06	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2909	2	73.33	31.39	0	0	1	1	0	110	5	1.12	0.95;
	2910	1	62.9	26.21	0	0	1	1	0	110	5	1.12	0.95;
	2911	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2912	1	5.83	3.01	0	0	1	1	0	110	5	1.12	0.95;
	2913	1	8.34	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2914	1	13.66	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2915	2	5.12	0.68	0	0	1	1	0	110	5	1.12	0.95;
	2916	1	9.34	5.12	0	0	1	1	0	110	5	1.12	0.95;
	2917	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2918	1	9.04	5.52	0	0	1	1	0	110	5	1.12	0.95;
	2919	1	15.17	4.72	0	0	1	1	0	110	5	1.12	0.95;
	2920	2	14.67	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2921	1	7.54	1	0	0	1	1	0	110	5	1.12	0.95;
	2922	1	0.1	0	0	0	1	1	0	110	5	1.12	0.95;
	2923	1	13.66	6.33	0	0	1	1	0	110	5	1.12	0.95;
	2924	1	2.11	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2925	1	2.11	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2926	2	8.94	2.32	0	0	1	1	0	110	5	1.12	0.95;
	2927	1	0.9	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2928	1	2.11	0.6	0	0	1	1	0	110	5	1.12	0.95;
	2929	1	13.66	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2930	2	12.06	9.44	0	0	1	1	0	110	5	1.12	0.95;
	2931	2	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2932	1	9.45	2.21	0	0	1	1	0	110	5	1.12	0.95;
	2933	2	9.95	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2934	2	14.67	3.71	0	0	1	1	0	110	5	1.12	0.95;
	2935	1	14.67	3.71	0	0	1	1	0	110	5	1.12	0.95;
	2936	1	11.55	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2937	1	9.45	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2938	1	3.12	1	0	0	1	1	0	110	5	1.12	0.95;
	2939	1	3.92	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2940	1	8.94	3.82	0	0	1	1	0	110	5	1.12	0.95;
	2941	1	8.74	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2942	1	15.17	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2943	1	16.28	5.22	0	0	1	1	0	110	5	1.12	0.95;
	2944	1	11.05	3.72	0	0	1	1	0	110	5	1.12	0.95;
	2945	2	11.05	3.86	0	0	1	1	0	110	5	1.12	0.95;
	2946	1	11.05	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2947	1	12.46	5.82	0	0	1	1	0	110	5	1.12	0.95;
	2948	1	6.33	1.31	0	0	1	1	0	110	5	1.12	0.95;
	2949	1	2.61	1	0	0	1	1	0	110	5	1.12	0.95;
	2950	1	3.82	1	0	0	1	1	0	110	5	1.12	0.95;
	2951	2	2.11	0.4	0	0	1	1	0	110	5	1.12	0.95;
	2952	1	5.73	1	0	0	1	1	0	110	5	1.12	0.95;
	2953	1	17.78	5.72	0	0	1	1	0	110	5	1.12	0.95;
	2954	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2955	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2956	1	0	0	0	60	1	1	0	16	5	1.12	0.95;
	2957	2	4.22	2.41	0	0	1	1	0	110	5	1.12	0.95;
	2958	1	3.12	2.31	0	0	1	1	0	110	5	1.12	0.95;
	2959	1	12.56	4.22	0	0	1	1	0	110	5	1.12	0.95;
	2960	1	17.78	3.71	0	0	1	1	0	110	5	1.12	0.95;
	2961	1	17.28	5.72	0	0	1	1	0	110	5	1.12	0.95;
	2962	2	9.45	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2963	1	11.05	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2964	1	23.61	4.72	0	0	1	1	0	110	5	1.12	0.95;
	2965	1	3.12	1.1	0	0	1	1	0	110	5	1.12	0.95;
	2966	1	3.72	1	0	0	1	1	0	110	5	1.12	0.95;
	2967	1	20.4	6.83	0	0	1	1	0	110	5	1.12	0.95;
	2968	1	6.33	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2969	2	11.55	4.21	0	0	1	1	0	110	5	1.12	0.95;
	2970	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2971	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2972	1	9.45	3.11	0	0	1	1	0	110	5	1.12	0.95;
	2973	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	2974	1	11.55	1	0	0	1	1	0	110	5	1.12	0.95;
	2975	1	0.1	0.1	0	0	1	1	0	110	5	1.12	0.95;
	2976	1	4.22	1	0	0	1	1	0	110	5	1.12	0.95;
	2977	1	10.45	5.22	0	0	1	1	0	110	5	1.12	0.95;
	2978	1	5.22	1.31	0	0	1	1	0	110	5	1.12	0.95;
	2979	1	4.22	1.1	0	0	1	1	0	110	5	1.12	0.95;
	2980	1	4.72	0.5	0	0	1	1	0	110	5	1.12	0.95;
	2981	1	4.72	1	0	0	1	1	0	110	5	1.12	0.95;
	2982	1	6.23	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2983	1	2.11	0.6	0	0	1	1	0	110	5	1.12	0.95;
	2984	1	5.73	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2985	1	3.12	1	0	0	1	1	0	110	5	1.12	0.95;
	2986	1	12.56	2.61	0	0	1	1	0	110	5	1.12	0.95;
	2987	1	3.72	1.71	0	0	1	1	0	110	5	1.12	0.95;
	2988	1	3.52	1.61	0	0	1	1	0	110	5	1.12	0.95;
	2989	1	4.72	2.11	0	0	1	1	0	110	5	1.12	0.95;
	2990	2	2.11	0.6	0	0	1	1	0	110	5	1.12	0.95;
	2991	1	2.51	0.7	0	0	1	1	0	110	5	1.12	0.95;
	2992	1	0.1	0.1	0	0	1	1	0	110	5	1.12	0.95;
	2993	2	16.78	6.33	0	0	1	1	0	110	5	1.12	0.95;
	2994	1	6.83	2.31	0	0	1	1	0	110	5	1.12	0.95;
	2995	1	6.23	2.81	0	0	1	1	0	110	5	1.12	0.95;
	2996	1	12.76	4.32	0	0	1	1	0	110	5	1.12	0.95;
	2997	2	24.11	8.44	0	0	1	1	0	110	5	1.12	0.95;
	2998	1	23.11	8.34	0	0	1	1	0	110	5	1.12	0.95;
	2999	2	9.45	2.31	0	0	1	1	0	110	5	1.12	0.95;
	3000	1	15.67	2.61	0	0	1	1	0	110	5	1.12	0.95;
	3001	1	19.89	6.83	0	0	1	1	0	110	5	1.12	0.95;
	3002	1	4.22	0.5	0	0	1	1	0	110	5	1.12	0.95;
	3003	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3004	1	14.67	7.23	0	0	1	1	0	110	5	1.12	0.95;
	3005	1	8.34	2.71	0	0	1	1	0	110	5	1.12	0.95;
	3006	1	3.01	0.5	0	0	1	1	0	110	5	1.12	0.95;
	3007	1	18.39	6.63	0	0	1	1	0	110	5	1.12	0.95;
	3008	2	16.78	6.33	0	0	1	1	0	110	5	1.12	0.95;
	3009	1	13.56	6.23	0	0	1	1	0	110	5	1.12	0.95;
	3010	1	6.83	2.61	0	0	1	1	0	110	5	1.12	0.95;
	3011	1	15.67	4.72	0	0	1	1	0	110	5	1.12	0.95;
	3012	1	15.67	4.22	0	0	1	1	0	110	5	1.12	0.95;
	3013	1	8.34	3.01	0	0	1	1	0	110	5	1.12	0.95;
	3014	1	2.11	0	0	0	1	1	0	110	5	1.12	0.95;
	3015	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3016	1	11.55	1	0	0	1	1	0	110	5	1.12	0.95;
	3017	1	12.56	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3018	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3019	1	6.73	2.61	0	0	1	1	0	110	5	1.12	0.95;
	3020	2	14.67	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3021	1	5.22	0	0	0	1	1	0	110	5	1.12	0.95;
	3022	1	3.12	0	0	0	1	1	0	110	5	1.12	0.95;
	3023	1	8.94	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3024	2	6.33	3.64	0	0	1	1	0	110	5	1.12	0.95;
	3025	1	7.33	2.11	0	0	1	1	0	110	5	1.12	0.95;
	3026	1	5.22	0.5	0	0	1	1	0	110	5	1.12	0.95;
	3027	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3028	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3029	2	9.45	1	0	0	1	1	0	110	5	1.12	0.95;
	3030	1	8.34	1	0	0	1	1	0	110	5	1.12	0.95;
	3031	1	4.72	2.61	0	0	1	1	0	110	5	1.12	0.95;
	3032	1	16.78	3.71	0	0	1	1	0	110	5	1.12	0.95;
	3033	1	0.6	0.2	0	0	1	1	0	110	5	1.12	0.95;
	3034	2	13.06	4.72	0	0	1	1	0	110	5	1.12	0.95;
	3035	1	13.06	4.72	0	0	1	1	0	110	5	1.12	0.95;
	3036	1	10.45	1	0	0	1	1	0	110	5	1.12	0.95;
	3037	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3038	2	25.12	6.33	0	0	1	1	0	110	5	1.12	0.95;
	3039	1	8.34	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3040	1	6.43	2.81	0	0	1	1	0	110	5	1.12	0.95;
	3041	1	5.73	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3042	1	6.33	0.9	0	0	1	1	0	110	5	1.12	0.95;
	3043	2	83.9	27.21	0	0	1	1	0	110	5	1.12	0.95;
	3044	1	4.12	2.51	0	0	1	1	0	110	5	1.12	0.95;
	3045	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	3046	1	5.12	2.11	0	0	1	1	0	110	5	1.12	0.95;
	3047	1	23.11	6.33	0	0	1	1	0	110	5	1.12	0.95;
	3048	2	21.3	8.64	0	0	1	1	0	110	5	1.12	0.95;
	3049	1	10.25	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3050	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3051	1	7.23	2.21	0	0	1	1	0	110	5	1.12	0.95;
	3052	1	11.25	5.12	0	0	1	1	0	110	5	1.12	0.95;
	3053	1	9.45	3.71	0	0	1	1	0	110	5	1.12	0.95;
	3054	1	8.74	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3055	2	9.75	4.21	0	0	1	1	0	110	5	1.12	0.95;
	3056	1	11.86	3.71	0	0	1	1	0	110	5	1.12	0.95;
	3057	1	25.12	8.34	0	0	1	1	0	110	5	1.12	0.95;
	3058	1	11.45	4.12	0	0	1	1	0	110	5	1.12	0.95;
	3059	1	10.05	4.22	0	0	1	1	0	110	5	1.12	0.95;
	3060	2	0.01	0	0	0	1	1	0	110	5	1.12	0.95;
	3061	2	2.91	1.71	0	0	1	1	0	110	5	1.12	0.95;
	3062	1	14.67	3.11	0	0	1	1	0	110	5	1.12	0.95;
	3063	1	7.33	0	0	0	1	1	0	110	5	1.12	0.95;
	3064	1	12.06	5.52	0	0	1	1	0	110	5	1.12	0.95;
	3065	2	30.44	4.22	0	0	1	1	0	110	5	1.12	0.95;
	3066	1	18.89	4.72	0	0	1	1	0	110	5	1.12	0.95;
	3067	2	11.55	1	0	0	1	1	0	110	5	1.12	0.95;
	3068	1	17.78	4.22	0	0	1	1	0	110	5	1.12	0.95;
	3069	2	19.19	12.25	0	0	1	1	0	110	5	1.12	0.95;
	3070	1	13.16	7.63	0	0	1	1	0	110	5	1.12	0.95;
	3071	1	9.04	3.71	0	0	1	1	0	110	5	1.12	0.95;
	3072	1	18.79	6.73	0	0	1	1	0	110	5	1.12	0.95;
	3073	2	16.57	5.57	0	0	1	1	0	110	5	1.12	0.95;
	3074	2	0.5	0.15	0	0	1	1	0	110	5	1.12	0.95;
	3075	1	12.46	5.42	0	0	1	1	0	110	5	1.12	0.95;
	3076	1	7.33	1.71	0	0	1	1	0	110	5	1.12	0.95;
	3077	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3078	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3079	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3080	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3081	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3082	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3083	1	41.9	16.77	0	0	1	1	0	110	5	1.12	0.95;
	3084	1	21	8.33	0	0	1	1	0	110	5	1.12	0.95;
	3085	1	2.11	0.8	0	0	1	1	0	110	5	1.12	0.95;
	3086	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	3087	2	0.01	0.01	0	0	1	1	0	110	5	1.12	0.95;
	3088	1	8.94	2.11	0	0	1	1	0	110	5	1.12	0.95;
	3089	1	13.06	3.71	0	0	1	1	0	110	5	1.12	0.95;
	3090	1	44.41	14.96	0	0	1	1	0	110	5	1.12	0.95;
	3091	1	50.74	16.87	0	0	1	1	0	110	5	1.12	0.95;
	3092	1	5.73	0	0	0	1	1	0	110	5	1.12	0.95;
	3093	1	21	12.55	0	0	1	1	0	110	5	1.12	0.95;
	3094	1	14.17	5.22	0	0	1	1	0	110	5	1.12	0.95;
	3095	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3096	1	0	0	0	0	1	1	0	110	5	1.12	0.95;
	3097	2	7.33	2.91	0	0	1	1	0	110	5	1.12	0.95;
	3098	2	6.33	1.57	0	0	1	1	0	110	5	1.12	0.95;
	3099	1	4.02	2.11	0	0	1	1	0	110	5	1.12	0.95;
	3100	2	0	0.7	0	0	1	1	0	110	5	1.12	0.95;
	3101	2	0	-0.49	0	0	1	1	0	110	5	1.12	0.95;
	3102	1	1.61	0.5	0	0	1	1	0	110	5	1.12	0.95;
	3103	2	8	20	0	0	0	1	0	110	0	1.12	0.95;
	3104	1	17	6	0	0	0	1	0	110	0	1.12	0.95;
	3105	1	0	0	0	0	0	1	0	110	0	1.12	0.95;
	3106	1	32	9	0	0	0	1	0	110	0	1.12	0.95;
	3107	1	16	5	0	0	0	1	0	110	0	1.12	0.95;
	3108	1	31.5	9.5	0	0	0	1	0	110	0	1.12	0.95;
	3109	1	31.5	9.5	0	0	0	1	0	110	0	1.12	0.95;
	3110	1	25	7	0	0	0	1	0	110	0	1.12	0.95;
	3111	1	65	20	0	0	0	1	0	110	0	1.12	0.95;
	3112	1	0	0	0	0	1	1	0	400	4	1.05	0.95;
	3113	2	40	0	0	0	0	1	0	400	0	1.05	0.95;
	3114	2	406	0	0	0	0	1	0	220	0	1.11	0.95;
	3115	2	77	0	0	0	0	1	0	400	0	1.05	0.95;
	3116	2	0	0	0	0	0	1	0	400	0	1.05	0.95;
	3117	2	634	0	0	0	0	1	0	220	0	1.11	0.95;
	3118	2	0	0	0	0	0	1	0	400	0	1.05	0.95;
	3119	2	172.45	65.03	0	0	1	1	0	32	2	1.12	0.95;
	3120	1	0	0	0	0	1	1	0	400	5	1.05	0.95;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	22	180	22.85	162	-61	1.06818	235	1	221	110	0	0	0	0	0	0	0	0	0	0	0;
	23	180	35.93	140	-25	1.06818	235	1	200	140	0	0	0	0	0	0	0	0	0	0	0;
	35	0	0	190	-19	1.09545	426	0	370	240	0	0	0	0	0	0	0	0	0	0	0;
	35	0	0	190	-19	1.09545	426	0	370	240	0	0	0	0	0	0	0	0	0	0	0;
	35	345	147.04	190	-19	1.09545	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	36	370	85.3	190	-19	1.09545	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	36	320	85.3	190	-19	1.09545	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	37	370	34.92	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	37	340	34.92	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	37	340	34.92	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	370	29.84	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	340	29.84	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	38	340	29.84	190	-19	1.04	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	55	205	86.71	152	-33	1.09091	235	1	215	110	0	0	0	0	0	0	0	0	0	0	0;
	55	0	0	152	-33	1.09091	235	0	220	125	0	0	0	0	0	0	0	0	0	0	0;
	56	0	0	149	-33	1.09091	235	0	225	125	0	0	0	0	0	0	0	0	0	0	0;
	56	205	87.71	149	-33	1.09091	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	57	225	85.6	149	-33	1.09091	235	1	225	110	0	0	0	0	0	0	0	0	0	0	0;
	57	185	85.6	149	-33	1.09091	235	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	58	330	195.71	363	-47	1.035	588	1	535	255	0	0	0	0	0	0	0	0	0	0	0;
	59	330	122.87	348	-100	1.035	588	1	560	250	0	0	0	0	0	0	0	0	0	0	0;
	68	210	-10.62	120	-14	1.08636	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	69	225	-5.94	120	-14	1.08636	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	69	195	-5.94	99	-10	1.08636	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	70	0	0	120	-14	1.0325	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	70	0	0	120	-14	1.0325	235	0	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	225	-7.81	99	-10	1.0325	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	71	215	-7.81	120	-14	1.0325	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	92	220	134.35	134	-7	1.08182	271	1	220	140	0	0	0	0	0	0	0	0	0	0	0;
	92	210	131	131	-6	1.08182	271	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	93	0	0	131	-6	1.08182	271	0	225	140	0	0	0	0	0	0	0	0	0	0	0;
	93	225	131.47	131	-6	1.08182	271	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	93	205	131.47	131	-6	1.08182	271	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	96	383	36.35	213	-30	1.0375	426	1	383	180	0	0	0	0	0	0	0	0	0	0	0;
	96	357	36.35	212	-31	1.0375	435	1	380	180	0	0	0	0	0	0	0	0	0	0	0;
	113	0	0	0	0	1.07727	12	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	113	0	0	0	0	1.07727	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	113	19	1.09	0	0	1.07727	26	1	21	0	0	0	0	0	0	0	0	0	0	0	0;
	119	215	89.14	120	-10	1.08182	271	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	120	215	92.04	120	-10	1.08182	271	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	121	115	52.14	73	-1	1.08182	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	122	115	52.7	73	-1	1.08182	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	132	0	0	79	0	1.07727	150	0	120	70	0	0	0	0	0	0	0	0	0	0	0;
	133	115	68.61	79	0	1.07727	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	134	105	28.62	31	0	1.07273	118	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	142	205	68.73	135	-35	1.08182	271	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	143	215	74.94	135	-35	1.08182	271	1	215	135	0	0	0	0	0	0	0	0	0	0	0;
	143	205	74.94	140	-35	1.08182	271	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	144	225	-2.8	140	-36	1.0375	271	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	144	205	-2.8	137	-36	1.0375	271	1	220	135	0	0	0	0	0	0	0	0	0	0	0;
	150	0	0	72	-29	1.04091	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	150	0	0	72	-29	1.04091	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	151	0	0	72	-29	1.04091	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	151	0	0	72	-29	1.04091	150	0	135	-135	0	0	0	0	0	0	0	0	0	0	0;
	152	110	95.35	85	-15	1.06818	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0;
	152	0	0	85	-15	1.06818	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0;
	153	110	90.77	85	-15	1.06818	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0;
	167	0	0	12	0	1.05	51	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	169	180	81.36	111	-21	1.08182	238	1	205	135	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	102	-15	1.08182	252	0	222	90	0	0	0	0	0	0	0	0	0	0	0;
	170	0	0	111	-21	1.08182	238	0	205	135	0	0	0	0	0	0	0	0	0	0	0;
	170	180	62.03	119	-31	1.08182	252	1	232	100	0	0	0	0	0	0	0	0	0	0	0;
	171	200	94.05	102	-15	1.0325	252	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	172	0	0	93	-10	1.0325	252	0	232	100	0	0	0	0	0	0	0	0	0	0	0;
	172	200	91.8	102	-15	1.0325	252	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	177	261	115.11	127	-35	1.09091	287	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	177	189	115.11	145	-38	1.09091	264	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	178	0	0	103	-17	1.09091	238	0	206	120	0	0	0	0	0	0	0	0	0	0	0;
	178	235	116	145	-38	1.09091	264	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	178	220	116	127	-35	1.09091	287	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	178	220	116	127	-35	1.09091	287	1	261	104	0	0	0	0	0	0	0	0	0	0	0;
	180	206	100.5	103	-17	1.03	238	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	180	194	100.5	103	-17	1.03	238	1	206	120	0	0	0	0	0	0	0	0	0	0	0;
	188	180	111.49	112	-32	1.05455	233	1	225	150	0	0	0	0	0	0	0	0	0	0	0;
	189	200	112.18	112	-32	1.05455	233	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	189	0	0	112	-32	1.05455	233	0	200	150	0	0	0	0	0	0	0	0	0	0	0;
	189	160	112.18	112	-32	1.05455	233	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	190	400	255.32	294	-259	1.005	464	1	464	186	0	0	0	0	0	0	0	0	0	0	0;
	204	0	0	100	0	1	218	0	188	76	0	0	0	0	0	0	0	0	0	0	0;
	236	179	33.19	105	-62	1.0375	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	236	89.5	33.19	105	-62	1.0375	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	236	89.5	33.19	130	-75	1.0375	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	237	0	41.49	160	-100	1.0375	209	1	179	-200	0	0	0	0	0	0	0	0	0	0	0;
	240	224	34.78	150	0	1.09091	156	1	250	113	0	0	0	0	0	0	0	0	0	0	0;
	250	0	0	20	0	1.08182	79	0	55	23	0	0	0	0	0	0	0	0	0	0	0;
	250	0	0	20	0	1.08182	69	0	50	25	0	0	0	0	0	0	0	0	0	0	0;
	251	15	9.77	20	0	1.08182	28	1	23	7	0	0	0	0	0	0	0	0	0	0	0;
	251	0	0	20	0	1.08182	69	0	50	25	0	0	0	0	0	0	0	0	0	0	0;
	267	1.5	1	1	0	1.07273	1	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	268	1.6	1.15	1	0	1.06364	1	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	282	0	0	5	0	1.07273	10	0	7	6	0	0	0	0	0	0	0	0	0	0	0;
	283	0	0	5	0	1.07273	10	0	7	6	0	0	0	0	0	0	0	0	0	0	0;
	301	5	2.99	3.75	0	1.04545	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	301	1.68	2.99	3.75	0	1.04545	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	301	1.68	2.99	3.75	0	1.04545	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	302	2.79	0.14	3.75	0	1.04545	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	316	350	190.13	190	-19	1	426	1	370	240	0	0	0	0	0	0	0	0	0	0	0;
	322	0	0	2	0	1.03636	4	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	322	0	0	2	0	1.03636	4	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	369	9.16	0.44	4	0	1.07273	30	1	30	0	0	0	0	0	0	0	0	0	0	0	0;
	398	0	0	5	0	1.08182	8	0	7	5	0	0	0	0	0	0	0	0	0	0	0;
	402	0.9	1.11	1	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	402	0.55	1.11	1	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	402	0.55	1.11	1	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	409	0	0	7	0	1.07545	31	0	27	11	0	0	0	0	0	0	0	0	0	0	0;
	409	20	7.51	7	0	1.07545	39	1	30	11	0	0	0	0	0	0	0	0	0	0	0;
	409	0	0	6	0	1.07545	41	0	30	9	0	0	0	0	0	0	0	0	0	0	0;
	411	0	0	15	0	1.07273	69	0	55	20	0	0	0	0	0	0	0	0	0	0	0;
	411	20	15.24	15	0	1.07273	69	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	412	0	0	15	0	1.07273	49	0	40	10	0	0	0	0	0	0	0	0	0	0	0;
	412	0	0	15	0	1.07273	69	0	55	20	0	0	0	0	0	0	0	0	0	0	0;
	414	0	0	20	0	1.07273	69	0	50	25	0	0	0	0	0	0	0	0	0	0	0;
	414	0	0	20	0	1.07273	147	0	100	55	0	0	0	0	0	0	0	0	0	0	0;
	415	30	1.18	40	0	1.07273	69	1	60	25	0	0	0	0	0	0	0	0	0	0	0;
	428	2	3.06	3	0	1.07273	4	1	3	2	0	0	0	0	0	0	0	0	0	0	0;
	466	0	0	1	0	1.06364	2	0	2	1	0	0	0	0	0	0	0	0	0	0	0;
	492	38	24.55	57	-22	1.07273	69	1	52	15	0	0	0	0	0	0	0	0	0	0	0;
	493	47	20.36	57	-22	1.07273	69	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	494	47	23.02	57	-22	1.08182	69	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	494	15	23.02	57	-22	1.08182	69	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	495	55	16.82	57	-22	1.07273	69	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	495	15	16.82	71	-28	1.07273	88	1	77	3	0	0	0	0	0	0	0	0	0	0	0;
	517	180	28.36	162	-61	1.09091	235	1	226	120	0	0	0	0	0	0	0	0	0	0	0;
	517	0	0	12	0	1.09091	49	0	25	12	0	0	0	0	0	0	0	0	0	0	0;
	518	15	13.57	12	0	1.1	49	1	17	10	0	0	0	0	0	0	0	0	0	0	0;
	522	0	0	2	0	1.06364	6	0	4	4	0	0	0	0	0	0	0	0	0	0	0;
	542	0.3	1.36	0.2	0	1.08182	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	571	0	0	4	0	1.04545	8	0	7	3	0	0	0	0	0	0	0	0	0	0	0;
	580	0	0	3	0	1.08182	5	0	3	3	0	0	0	0	0	0	0	0	0	0	0;
	587	4	6.34	4.7	3.8	1.06364	7	1	7	1	0	0	0	0	0	0	0	0	0	0	0;
	587	1	6.34	4.7	3.8	1.06364	7	1	7	1	0	0	0	0	0	0	0	0	0	0	0;
	587	0	0	4.7	3.8	1.06364	7	0	7	1	0	0	0	0	0	0	0	0	0	0	0;
	599	2.5	2.02	2	0	1.07273	4	1	3	2	0	0	0	0	0	0	0	0	0	0	0;
	633	0	0	2	0	1.02727	5	0	4	3	0	0	0	0	0	0	0	0	0	0	0;
	663	1	0.32	0.7	0	1.05455	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	663	0	0	0.7	0	1.05455	2	0	2	1	0	0	0	0	0	0	0	0	0	0	0;
	669	0	0	3	0	1.06364	6	0	4	3	0	0	0	0	0	0	0	0	0	0	0;
	740	52	17.63	35	2	1.05455	63	1	52	37	0	0	0	0	0	0	0	0	0	0	0;
	740	0	0	23	2	1.05455	38	0	30	10	0	0	0	0	0	0	0	0	0	0	0;
	740	0	0	85	6	1.05455	150	0	105	50	0	0	0	0	0	0	0	0	0	0	0;
	740	58	17.63	85	6	1.05455	150	1	105	50	0	0	0	0	0	0	0	0	0	0	0;
	741	0	0	23	2	1.05455	38	0	30	10	0	0	0	0	0	0	0	0	0	0	0;
	741	0	0	23	2	1.05455	38	0	30	10	0	0	0	0	0	0	0	0	0	0	0;
	741	30	25	25	2	1.05455	38	1	30	10	0	0	0	0	0	0	0	0	0	0	0;
	741	70	27.57	85	6	1.05455	150	1	125	68	0	0	0	0	0	0	0	0	0	0	0;
	741	0	0	85	6	1.05455	150	0	105	50	0	0	0	0	0	0	0	0	0	0	0;
	762	1.4	2.56	0.7	0	1.04545	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	764	1	1.05	1	0	1.06364	4	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	772	0	0	18	2	1.05455	38	0	35	9	0	0	0	0	0	0	0	0	0	0	0;
	772	20	18.87	30	2	1.05455	38	1	20	9	0	0	0	0	0	0	0	0	0	0	0;
	773	0	0	18	2	1.05455	38	0	35	9	0	0	0	0	0	0	0	0	0	0	0;
	773	0	0	18	2	1.05455	38	0	35	9	0	0	0	0	0	0	0	0	0	0	0;
	773	0	0	18	2	1.05455	38	0	35	9	0	0	0	0	0	0	0	0	0	0	0;
	773	80	90.04	65	6	1.05455	121	1	97	30	0	0	0	0	0	0	0	0	0	0	0;
	774	0	0	18	2	1.05455	38	0	35	9	0	0	0	0	0	0	0	0	0	0	0;
	774	0	0	18	2	1.05455	38	0	30	9	0	0	0	0	0	0	0	0	0	0	0;
	774	0	0	14	2	1.05455	32	0	28	9	0	0	0	0	0	0	0	0	0	0	0;
	809	1	1.23	4	0	1.07273	5	1	8	1	0	0	0	0	0	0	0	0	0	0	0;
	809	0	0	2	0	1.07273	2	0	2	1	0	0	0	0	0	0	0	0	0	0	0;
	829	0	0	4.5	0.2	1.04545	6	0	4	4	0	0	0	0	0	0	0	0	0	0	0;
	844	2.5	1.03	0	0	1.07273	6	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	853	0	0	0	0	1.06364	4	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	876	93	4.21	30	0	1.08182	65	1	93	0	0	0	0	0	0	0	0	0	0	0	0;
	876	12	4.21	30	0	1.08182	65	1	36	0	0	0	0	0	0	0	0	0	0	0	0;
	879	0	0	0	0	1.06364	12	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	886	0	0	0	0	1.08182	5	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	887	0	0	0	0	1.08182	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	922	205	61.56	149	-33	1.09091	235	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	923	0	0	149	-33	1.09091	235	0	225	110	0	0	0	0	0	0	0	0	0	0	0;
	931	0	0	0	0	1.07273	3	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	937	0	0	0	0	1.07273	12	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	947	0	0	30	0	1.07273	168	0	170	66	0	0	0	0	0	0	0	0	0	0	0;
	947	0	0	30	0	1.07273	72	0	61	34	0	0	0	0	0	0	0	0	0	0	0;
	953	0	0	0	0	1.07273	8	0	21	0	0	0	0	0	0	0	0	0	0	0	0;
	967	0	0	0	0	1.07273	6	0	7	0	0	0	0	0	0	0	0	0	0	0	0;
	970	0	0	0	0	1.08182	3	0	10	0	0	0	0	0	0	0	0	0	0	0	0;
	985	8.5	4.45	0	0	1.08182	3	1	30	0	0	0	0	0	0	0	0	0	0	0	0;
	990	0.3	-1.29	0	0	1.06364	1	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	995	0	0	0	0	1.06364	1	0	2	0	0	0	0	0	0	0	0	0	0	0	0;
	1006	0	0	0	0	1.06364	2	0	2	1	0	0	0	0	0	0	0	0	0	0	0;
	1011	190	0.58	120	-14	1.09091	235	1	225	129	0	0	0	0	0	0	0	0	0	0	0;
	1013	0	0	30	0	1.06364	37	0	36	0	0	0	0	0	0	0	0	0	0	0	0;
	1016	0	0	0	0	1.07273	3	0	3	2	0	0	0	0	0	0	0	0	0	0	0;
	1036	0	0	30	0	1.08182	101	0	101	49	0	0	0	0	0	0	0	0	0	0	0;
	1042	0	0	0	0	1.06364	2	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1057	6.1	5.14	30	0	1.07273	10	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1060	0	0	0	0	1.08182	2	0	2	1	0	0	0	0	0	0	0	0	0	0	0;
	1062	0	0	0	0	1.07273	6	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	1067	5	-0.33	0	0	1.08182	11	1	8	0	0	0	0	0	0	0	0	0	0	0	0;
	1071	0	0	23	0	1.09091	52	0	68	5	0	0	0	0	0	0	0	0	0	0	0;
	1071	60	10.56	23	0	1.09091	52	1	68	5	0	0	0	0	0	0	0	0	0	0	0;
	1071	0	0	11	0	1.09091	25	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	1071	0	0	10	0	1.09091	25	0	31	-32	0	0	0	0	0	0	0	0	0	0	0;
	1086	0	0	24	-1	1.08182	69	0	50	8	0	0	0	0	0	0	0	0	0	0	0;
	1086	110	7.63	74	-15	1.08182	58	1	125	92	0	0	0	0	0	0	0	0	0	0	0;
	1087	110	50.94	74	-15	1.08182	58	1	125	85	0	0	0	0	0	0	0	0	0	0	0;
	1087	0	0	28	-2	1.08182	40	0	41	12	0	0	0	0	0	0	0	0	0	0	0;
	1099	0	0	0	0	1.08182	3	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	1126	0	0	0	0	1.06364	4	0	3	2	0	0	0	0	0	0	0	0	0	0	0;
	1132	31	14.23	0	0	1.08182	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1132	13	14.23	0	0	1.08182	31	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	1133	0	0	0	0	1.08182	25	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1133	0	0	0	0	1.08182	25	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1164	35	39	41.2	0	1.08182	93	1	78	11	0	0	0	0	0	0	0	0	0	0	0;
	1188	0	0	45	-10	1.08182	63	0	48	40	0	0	0	0	0	0	0	0	0	0	0;
	1188	43	-6.78	45	-10	1.08182	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1189	43	11.4	45	-10	1.08182	69	1	55	42	0	0	0	0	0	0	0	0	0	0	0;
	1263	110	54	110	-40	1.08182	149	1	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1264	0	0	110	-40	1.08182	149	0	113	32	0	0	0	0	0	0	0	0	0	0	0;
	1268	6	-0.01	0	0	1.08182	17	1	17	0	0	0	0	0	0	0	0	0	0	0	0;
	1289	370	96.92	216	-32	1.09091	426	1	386	180	0	0	0	0	0	0	0	0	0	0	0;
	1290	370	90.19	187	-30	1.09091	426	1	383	180	0	0	0	0	0	0	0	0	0	0	0;
	1294	0	0	0	0	1.08182	6	0	6	1	0	0	0	0	0	0	0	0	0	0	0;
	1295	0	0	110	-40	1.08182	169	0	135	35	0	0	0	0	0	0	0	0	0	0	0;
	1301	0	0	0	0	1.08182	13	0	13	0	0	0	0	0	0	0	0	0	0	0	0;
	1301	0	0	0	0	1.08182	13	0	13	0	0	0	0	0	0	0	0	0	0	0	0;
	1302	0	0	0	0	1.08182	20	0	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1302	15	0	0	0	1.08182	20	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	1303	0	0	0	0	1.07273	19	0	19	0	0	0	0	0	0	0	0	0	0	0	0;
	1312	0	0	18	9	1.07273	32	0	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1313	0	0	18	9	1.07273	32	0	24	12	0	0	0	0	0	0	0	0	0	0	0;
	1314	0	0	14	10.5	1.07273	32	0	29	10	0	0	0	0	0	0	0	0	0	0	0;
	1405	0	0	37.5	16.8	1.08182	63	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1405	0	0	37.5	16.8	1.08182	63	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1405	0	0	37.5	16.8	1.08182	63	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1406	0	0	37.5	16.8	1.08182	63	0	50	38	0	0	0	0	0	0	0	0	0	0	0;
	1429	0	0	0	0	1.07273	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1429	0	0	0	0	1.07273	25	0	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1429	25	2.85	0	0	1.07273	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1429	15	2.85	0	0	1.07273	25	1	25	10	0	0	0	0	0	0	0	0	0	0	0;
	1447	17	4.05	0	0	1.08182	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1448	17	4.06	0	0	1.08182	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1449	17	4.12	0	0	1.08182	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1449	0	0	0	0	1.08182	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	1476	69	11.17	52.5	0	1.08182	88	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1477	0	0	42	16.8	1.08182	63	0	50	40	0	0	0	0	0	0	0	0	0	0	0;
	1477	69	52.42	52.5	0	1.08182	88	1	70	21	0	0	0	0	0	0	0	0	0	0	0;
	1484	0	0	0	0	1.08182	50	0	50	10	0	0	0	0	0	0	0	0	0	0	0;
	1545	0	0	0	0	1.08182	24	0	24	5	0	0	0	0	0	0	0	0	0	0	0;
	1545	0	0	0	0	1.08182	17	0	17	4	0	0	0	0	0	0	0	0	0	0	0;
	1546	7	4.6	0	0	1.08182	15	1	15	3	0	0	0	0	0	0	0	0	0	0	0;
	1546	0	0	0	0	1.08182	15	0	15	3	0	0	0	0	0	0	0	0	0	0	0;
	1546	0	0	0	0	1.08182	15	0	15	3	0	0	0	0	0	0	0	0	0	0	0;
	1547	5.5	0.64	0	0	1.07273	6	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	1547	2.5	0.64	0	0	1.07273	6	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	1581	0	0	0	0	1.09091	8	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	1581	0	0	0	0	1.09091	8	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	1587	48	41.71	41	-6.5	1.08182	69	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	1588	215	60.49	113	-5	1.09091	271	1	230	120	0	0	0	0	0	0	0	0	0	0	0;
	1589	215	74.92	120	-10	1.09091	271	1	225	120	0	0	0	0	0	0	0	0	0	0	0;
	1648	0	0	0	0	1.07273	18	0	18	0	0	0	0	0	0	0	0	0	0	0	0;
	1648	32	6.19	0	0	1.07273	32	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	1648	8	6.19	0	0	1.07273	25	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	1656	90	15.83	73	-1	1.08182	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1656	70	15.83	73	-1	1.08182	150	1	120	70	0	0	0	0	0	0	0	0	0	0	0;
	1658	120	-1.52	73	-1	1.08182	150	1	120	79	0	0	0	0	0	0	0	0	0	0	0;
	1658	0	0	73	-1	1.08182	150	0	110	79	0	0	0	0	0	0	0	0	0	0	0;
	1668	125	46.22	83	-5	1.09091	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1668	110	46.22	83	-5	1.09091	150	1	125	70	0	0	0	0	0	0	0	0	0	0	0;
	1680	0	0	80	-25	1.08182	150	0	117	80	0	0	0	0	0	0	0	0	0	0	0;
	1681	0	0	80	-25	1.08182	150	0	110	65	0	0	0	0	0	0	0	0	0	0	0;
	1681	0	0	80	-25	1.08182	150	0	100	65	0	0	0	0	0	0	0	0	0	0	0;
	1681	100	80.11	80	-25	1.08182	150	1	119	80	0	0	0	0	0	0	0	0	0	0	0;
	1724	0	0	41.2	-13.7	1.08182	69	0	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1724	0	0	33.5	12	1.08182	20	0	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1724	0	0	41.2	-13.7	1.08182	69	0	55	15	0	0	0	0	0	0	0	0	0	0	0;
	1739	0	0	0	0	1.07273	12	0	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1739	10	1.77	0	0	1.07273	12	1	12	0	0	0	0	0	0	0	0	0	0	0	0;
	1741	0	0	0	0	1.08182	15	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1742	12	-0.09	0	0	1.08182	22	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1746	215	14.61	131	-6	1.08182	271	1	15	0	0	0	0	0	0	0	0	0	0	0	0;
	1768	0	0	35	-6	1.08182	53	0	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1769	43	35.28	35	-6	1.08182	53	1	46	3	0	0	0	0	0	0	0	0	0	0	0;
	1954	14	4.27	9.3	1.9	1.08182	16	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1954	13.5	4.27	9.3	1.9	1.08182	16	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1954	13.5	4.27	9.3	1.9	1.08182	16	1	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1954	3.8	0	0	0	1.08182	4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1954	4.2	0	0	0	1.08182	4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	1954	0	0	9.3	2	1.08182	16	0	14	2	0	0	0	0	0	0	0	0	0	0	0;
	1982	123	3.31	79	0	1.08182	150	1	123	70	0	0	0	0	0	0	0	0	0	0	0;
	1982	77	3.31	79	0	1.08182	150	1	128	70	0	0	0	0	0	0	0	0	0	0	0;
	1983	100	42.21	114	-27	1.08182	191	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1984	100	18.94	114	-27	1.08182	191	1	161	55	0	0	0	0	0	0	0	0	0	0	0;
	1992	0	0	37	0	1.08182	63	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	1992	0	0	15	0	1.08182	118	0	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1993	0	0	31	0	1.08182	118	0	110	80	0	0	0	0	0	0	0	0	0	0	0;
	1993	110	14.48	15	0	1.08182	118	1	110	80	0	0	0	0	0	0	0	0	0	0	0;
	2100	38	25.98	26	13	1.08182	50	1	40	5	0	0	0	0	0	0	0	0	0	0	0;
	2144	205	34.08	140	-35	1.09091	271	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2146	0	0	140	-35	1.09091	271	0	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2146	205	63.73	140	-35	1.09091	271	1	225	135	0	0	0	0	0	0	0	0	0	0	0;
	2176	0	0	26	13	1.08182	44	0	35	18	0	0	0	0	0	0	0	0	0	0	0;
	2176	0	0	8.3	1.5	1.08182	14	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2176	0	0	12	5.8	1.08182	31	0	25	18	0	0	0	0	0	0	0	0	0	0	0;
	2177	0	0	26	13	1.08182	44	0	30	18	0	0	0	0	0	0	0	0	0	0	0;
	2214	30	-0.23	0	0	1.07273	32	1	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2215	0	0	0	0	1.07273	32	0	32	27	0	0	0	0	0	0	0	0	0	0	0;
	2235	10	2.79	0	0	1.06364	11	1	11	0	0	0	0	0	0	0	0	0	0	0	0;
	2235	0	0	0	0	1.06364	11	0	11	0	0	0	0	0	0	0	0	0	0	0	0;
	2237	0	0	85	-15	1.09091	150	0	120	100	0	0	0	0	0	0	0	0	0	0	0;
	2237	110	77.34	85	-15	1.09091	150	1	120	100	0	0	0	0	0	0	0	0	0	0	0;
	2253	2.5	0.7	0	0	1.08182	4	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2256	1.8	3.53	0	0	1.08182	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2267	1.5	0.03	0	0	1.1	2	1	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2271	1.3	11.8	0	0	1.09091	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2273	0	0	30	0	1.06364	50	0	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2274	25	4.38	30	0	1.06364	50	1	50	15	0	0	0	0	0	0	0	0	0	0	0;
	2300	150	43.01	117	-19	1.1	252	1	222	90	0	0	0	0	0	0	0	0	0	0	0;
	2306	0	0	8	0	1.04545	27	0	28	-10	0	0	0	0	0	0	0	0	0	0	0;
	2306	20	8.39	8	0	1.04545	29	1	29	10	0	0	0	0	0	0	0	0	0	0	0;
	2306	0	0	8	0	1.04545	27	0	28	-10	0	0	0	0	0	0	0	0	0	0	0;
	2310	50	52.91	49	-7	1.07273	57	1	55	15	0	0	0	0	0	0	0	0	0	0	0;
	2310	0	0	91	-17	1.07273	128	0	100	55	0	0	0	0	0	0	0	0	0	0	0;
	2311	0	0	89	-16	1.04545	150	0	106	70	0	0	0	0	0	0	0	0	0	0	0;
	2316	1.7	0	0	0	1.00909	2	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	2317	0	0	0	0	1.08182	2	0	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2320	0	0	0	0	1.04545	3	0	3	2	0	0	0	0	0	0	0	0	0	0	0;
	2322	2.44	0.03	0	0	1.03636	5	1	6	2	0	0	0	0	0	0	0	0	0	0	0;
	2323	52.7	16.19	15	0	1.08182	57	1	55	10	0	0	0	0	0	0	0	0	0	0	0;
	2323	2.3	2	2	0	1.08182	6	1	6	2	0	0	0	0	0	0	0	0	0	0	0;
	2324	5	1.41	2	0	1.08182	5	1	5	1	0	0	0	0	0	0	0	0	0	0	0;
	2324	0	0	10	0	1.08182	30	0	29	21	0	0	0	0	0	0	0	0	0	0	0;
	2337	2.7	1.35	0	0	1.02727	5	1	4	3	0	0	0	0	0	0	0	0	0	0	0;
	2345	4	3.65	0	0	1.03636	35	1	30	4	0	0	0	0	0	0	0	0	0	0	0;
	2349	2.5	0.59	0	0	1.05455	15	1	12	2	0	0	0	0	0	0	0	0	0	0	0;
	2357	0.5	18.78	0	0	1.08182	4	1	7	0	0	0	0	0	0	0	0	0	0	0	0;
	2366	0	0	0	0	1.02727	5	0	4	3	0	0	0	0	0	0	0	0	0	0	0;
	2368	1.1	0.76	0	0	1.04545	3	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2370	1.46	0.02	0	0	1.05455	3	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2374	0	0	0	0	1.09091	3	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2375	3	2.7	1.25	0	1.05455	3	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2375	2	2.7	2	0	1.05455	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2377	0	0	0	0	1.04545	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2379	2.5	1.87	0	0	1.03636	5	1	4	3	0	0	0	0	0	0	0	0	0	0	0;
	2383	0.3	1.23	0	0	1.08182	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2390	2.25	1.7	0	0	1.03636	11	1	10	2	0	0	0	0	0	0	0	0	0	0	0;
	2400	0	0	0	0	1.04545	2	0	1	1	0	0	0	0	0	0	0	0	0	0	0;
	2403	50	12.06	12	0	1.1	51	1	50	40	0	0	0	0	0	0	0	0	0	0	0;
	2403	40	12.06	12	0	1.1	56	1	55	35	0	0	0	0	0	0	0	0	0	0	0;
	2404	0	0	12	0	1.08182	51	0	50	35	0	0	0	0	0	0	0	0	0	0	0;
	2404	20	6.37	10	0	1.08182	30	1	28	20	0	0	0	0	0	0	0	0	0	0	0;
	2408	3.9	5.18	0	0	1.04545	11	1	10	4	0	0	0	0	0	0	0	0	0	0	0;
	2433	2.4	-0.39	0	0	1.04545	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2438	2.5	3.76	0	0	1.02727	5	1	4	3	0	0	0	0	0	0	0	0	0	0	0;
	2447	2	0.03	0	0	1.04545	4	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2456	1.9	0.06	0	0	1.08182	4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2495	1.6	0	0	0	1.03636	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	2496	0.22	1.47	0	0	1.08182	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2496	1.13	1.47	0	0	1.08182	2	1	1	1	0	0	0	0	0	0	0	0	0	0	0;
	2521	0.7	1.08	0	0	1.03636	2	1	1	1	0	0	0	0	0	0	0	0	0	0	0;
	2522	0.3	0.1	0	0	1.04545	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2524	3	-0.28	0	0	1.02727	7	1	6	3	0	0	0	0	0	0	0	0	0	0	0;
	2525	0	0	0	0	1.06364	4	0	3	3	0	0	0	0	0	0	0	0	0	0	0;
	2527	2	10.9	0	0	1.06364	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2534	0	0	112	-32	1.08182	233	0	200	150	0	0	0	0	0	0	0	0	0	0	0;
	2535	180	110.72	111	-18	1.09091	233	1	200	150	0	0	0	0	0	0	0	0	0	0	0;
	2547	1.63	-0.48	0	0	1.04545	4	1	3	1	0	0	0	0	0	0	0	0	0	0	0;
	2548	0.3	0.64	0	0	1.05455	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2555	6	-0.39	0	0	1.03636	25	1	20	6	0	0	0	0	0	0	0	0	0	0	0;
	2573	0	0	15	0	1.08182	67	0	67	40	0	0	0	0	0	0	0	0	0	0	0;
	2574	50	15.87	15	0	1.1	67	1	65	40	0	0	0	0	0	0	0	0	0	0	0;
	2582	0.23	0.56	0	0	1.05455	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2585	2	0.14	0	0	1.07273	6	1	6	1	0	0	0	0	0	0	0	0	0	0	0;
	2591	0.2	-0.2	0	0	1.09091	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2593	2.7	0.17	0	0	1.01818	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2597	9	0.26	0	0	1.04545	16	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	2598	9	0	0	0	1.04545	16	1	31	0	0	0	0	0	0	0	0	0	0	0	0;
	2600	2.5	0.19	0	0	1.04545	7	1	7	2	0	0	0	0	0	0	0	0	0	0	0;
	2616	0.7	0.16	0	0	1.1	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2617	1	0.11	0	0	1.06364	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2619	2.22	0.63	0	0	1.06364	7	1	6	2	0	0	0	0	0	0	0	0	0	0	0;
	2621	2	0.09	0	0	1.07273	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2625	0	0	0	0	1.03636	3	0	2	2	0	0	0	0	0	0	0	0	0	0	0;
	2627	2.5	0.14	0	0	1.00909	7	1	6	2	0	0	0	0	0	0	0	0	0	0	0;
	2629	2.5	0.04	0	0	1.00909	5	1	4	3	0	0	0	0	0	0	0	0	0	0	0;
	2630	2	0.2	0	0	1.06364	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2644	2.5	-0.36	1.03	0	1.09091	5	1	10	2	0	0	0	0	0	0	0	0	0	0	0;
	2649	1.69	-0.86	0	0	1.07273	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	2650	2.52	0	0	0	1.05455	5	1	4	2	0	0	0	0	0	0	0	0	0	0	0;
	2652	0	0	2	0	1.08182	5	0	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2652	0	0	6	0	1.08182	19	0	18	3	0	0	0	0	0	0	0	0	0	0	0;
	2652	0	0	15	0	1.08182	58	0	56	10	0	0	0	0	0	0	0	0	0	0	0;
	2655	0.2	0	0	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2667	225	52.08	145	-38	1.09091	264	1	235	94	0	0	0	0	0	0	0	0	0	0	0;
	2679	0	0	30	0	1.07273	50	0	50	32	0	0	0	0	0	0	0	0	0	0	0;
	2679	95	13.31	70	0	1.07273	128	1	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2680	0	0	70	0	1.06364	128	0	108	70	0	0	0	0	0	0	0	0	0	0	0;
	2684	5.5	1.1	2	0	1.09091	8	1	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2685	2.5	2.04	0	0	1.1	12	1	16	2	0	0	0	0	0	0	0	0	0	0	0;
	2691	1.7	0.85	0	0	1.07273	5	1	10	2	0	0	0	0	0	0	0	0	0	0	0;
	2695	0.3	0.41	0	0	1.06364	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2698	0.9	0	0	0	1.06364	2	1	1	1	0	0	0	0	0	0	0	0	0	0	0;
	2705	0	0	0	0	1.03636	1	0	1	1	0	0	0	0	0	0	0	0	0	0	0;
	2774	0	0	10	0	1.04545	16	0	12	3	0	0	0	0	0	0	0	0	0	0	0;
	2774	5	4.01	10	0	1.04545	15	1	11	3	0	0	0	0	0	0	0	0	0	0	0;
	2781	1	-1.63	0	0	1.03636	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2782	0	0	0	0	1.04545	4	0	3	3	0	0	0	0	0	0	0	0	0	0	0;
	2791	0.7	1.74	0	0	1.07273	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2791	0	0	0	0	1.07273	1	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2794	0	0	37.5	5	1.05455	63	0	50	0	0	0	0	0	0	0	0	0	0	0	0;
	2794	45	11.34	41.7	6	1.05455	69	1	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2794	0	0	41.25	6	1.05455	69	0	55	0	0	0	0	0	0	0	0	0	0	0	0;
	2795	0	0	15	5	1.05455	41	0	35	0	0	0	0	0	0	0	0	0	0	0	0;
	2795	0	0	24	5	1.05455	40	0	32	0	0	0	0	0	0	0	0	0	0	0	0;
	2797	0.4	0.19	1	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2803	1.8	0.31	1	0	1.04545	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2811	0.3	0.12	0	0	1.07273	3	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2814	49	5.54	35	4	1.06364	69	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2815	0	0	35	4	1.06364	69	0	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2816	0	0	5	0	1.05455	6	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2823	0.2	2.37	0	0	1.01818	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2826	0.2	-0.04	0	0	1.02727	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2827	0.3	-0.1	0	0	1.07273	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2828	1	0.1	0	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2830	0.4	0.07	0.1	0	1.02727	3	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2833	8	4.29	0	0	1.09091	13	1	26	0	0	0	0	0	0	0	0	0	0	0	0;
	2836	0	0	10	0	1.03636	31	0	28	4	0	0	0	0	0	0	0	0	0	0	0;
	2836	10	-1.03	5	0	1.03636	16	1	13	2	0	0	0	0	0	0	0	0	0	0	0;
	2836	0	0	5	0	1.03636	16	0	13	2	0	0	0	0	0	0	0	0	0	0	0;
	2842	4.5	0.09	0	0	1.07273	7	1	6	0	0	0	0	0	0	0	0	0	0	0	0;
	2846	0	0	18.7	4	1.07273	31	0	25	15	0	0	0	0	0	0	0	0	0	0	0;
	2846	53	11.6	35	6	1.07273	69	1	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2846	0	0	35	4	1.07273	69	0	55	26	0	0	0	0	0	0	0	0	0	0	0;
	2847	0	0	39	3	1.07273	66	0	55	24	0	0	0	0	0	0	0	0	0	0	0;
	2847	0	0	35	3.5	1.07273	69	0	55	25	0	0	0	0	0	0	0	0	0	0	0;
	2854	0	0	0	0	1.06364	8	0	7	5	0	0	0	0	0	0	0	0	0	0	0;
	2856	4.8	0.29	0	0	1.07273	18	1	18	0	0	0	0	0	0	0	0	0	0	0	0;
	2857	4.8	1.16	0	0	1.08182	22	1	22	0	0	0	0	0	0	0	0	0	0	0	0;
	2862	0	0	0	0	1.06364	4	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2875	3.2	2.35	3	1	1.05455	5	1	4	1	0	0	0	0	0	0	0	0	0	0	0;
	2880	0	0	3	0	1.03636	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2880	0	0	3	0	1.03636	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2880	0	0	3	0	1.03636	5	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	2880	16	9.5	12	0	1.03636	20	1	16	0	0	0	0	0	0	0	0	0	0	0	0;
	2880	10	9.5	15	0	1.03636	25	1	20	0	0	0	0	0	0	0	0	0	0	0	0;
	2887	10	0.47	9.3	1	1.05455	16	1	12	5	0	0	0	0	0	0	0	0	0	0	0;
	2887	0	0	9.3	1	1.05455	16	0	12	5	0	0	0	0	0	0	0	0	0	0	0;
	2889	12	5.33	1	0	1.04545	41	1	41	0	0	0	0	0	0	0	0	0	0	0	0;
	2894	0	0	0	0	1.07273	9	0	8	0	0	0	0	0	0	0	0	0	0	0	0;
	2899	0	0	0	0	1.08182	5	0	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2900	0.85	0.91	0	0	1.08182	3	1	2	0	0	0	0	0	0	0	0	0	0	0	0;
	2904	0	0	0	0	1.02727	7	0	5	4	0	0	0	0	0	0	0	0	0	0	0;
	2905	0	0	1.27	0	1.05455	3	0	2	0	0	0	0	0	0	0	0	0	0	0	0;
	2909	25	16.67	18.78	0	1.03636	31	1	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2909	12	16.67	25.95	0	1.03636	43	1	35	0	0	0	0	0	0	0	0	0	0	0	0;
	2909	0	0	18.78	0	1.03636	31	0	25	0	0	0	0	0	0	0	0	0	0	0	0;
	2915	0	0	0	0	1.05455	2	0	2	0	0	0	0	0	0	0	0	0	0	0	0;
	2920	0.2	-0.72	0	0	1.07273	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2926	0	0	0	0	1.06364	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2930	13.2	2.02	10.5	0	1.02727	18	1	13	0	0	0	0	0	0	0	0	0	0	0	0;
	2930	3.8	2.02	3.75	0	1.02727	6	1	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2930	0	0	3.75	0	1.02727	6	0	5	0	0	0	0	0	0	0	0	0	0	0	0;
	2931	0	0	10.5	0	1.02727	18	0	13	0	0	0	0	0	0	0	0	0	0	0	0;
	2933	0.3	0.08	0	0	1.07273	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2934	5	4.79	18.75	0	1.07273	31	1	20	5	0	0	0	0	0	0	0	0	0	0	0;
	2945	0	0	0	0	1.04545	8	0	6	5	0	0	0	0	0	0	0	0	0	0	0;
	2951	0.5	0.11	0	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2957	0.8	7.81	0	0	1.08182	1	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	2962	1.1	-0.14	0.5	0	1.08182	2	1	2	1	0	0	0	0	0	0	0	0	0	0	0;
	2969	0	0	0	0	1.07273	3	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2990	0.1	-0.18	0	0	1.05455	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	2993	0.2	0.3	0	0	1.06364	3	1	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2993	0	0	0	0	1.06364	1	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	2997	11.1	11.23	0	0	1.07273	17	1	15	0	0	0	0	0	0	0	0	0	0	0	0;
	2999	0.3	0.32	0.1	0	1.02727	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3008	0.3	1.99	0	0	1.07273	2	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	3020	0.9	2.22	0	0	1.08182	6	1	1	0	0	0	0	0	0	0	0	0	0	0	0;
	3024	0	0	0	0	1.01818	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3029	0.1	0.99	0	0	1.08182	5	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3034	1.4	0.45	0	0	1.02727	5	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	3038	0.49	-0.9	0	0	1.05455	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3043	0	0	8	0	1.05455	14	0	11	0	0	0	0	0	0	0	0	0	0	0	0;
	3043	0	0	6.8	0	1.05455	11	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	3043	32	12.01	24	0	1.05455	40	1	32	0	0	0	0	0	0	0	0	0	0	0	0;
	3043	23	12.01	26	0	1.05455	48	1	40	0	0	0	0	0	0	0	0	0	0	0	0;
	3045	4.8	2.06	2	0	1.03636	20	1	18	0	0	0	0	0	0	0	0	0	0	0	0;
	3048	3.4	6.53	0	0	1.06364	23	1	18	0	0	0	0	0	0	0	0	0	0	0	0;
	3055	0	0	1	0	1.05455	6	0	6	0	0	0	0	0	0	0	0	0	0	0	0;
	3060	17.6	0.22	1	0	1.09091	50	1	50	0	0	0	0	0	0	0	0	0	0	0	0;
	3061	0	0	0	0	1.05455	4	0	3	0	0	0	0	0	0	0	0	0	0	0	0;
	3065	4	0.24	0	0	1.07273	10	1	9	0	0	0	0	0	0	0	0	0	0	0	0;
	3067	0.2	-0.34	0	0	1.07273	2	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3069	9.6	7.1	0	0	1.06364	43	1	35	0	0	0	0	0	0	0	0	0	0	0	0;
	3069	0	0	0	0	1.06364	43	0	35	0	0	0	0	0	0	0	0	0	0	0	0;
	3073	26.7	9.33	17	-10	1.06364	32	1	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3073	16.5	9.33	17	-10	1.06364	32	1	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3074	21.6	11.18	17	-10	1.06364	32	1	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3074	0	0	17	-10	1.06364	32	0	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3074	0	0	17	-10	1.06364	32	0	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3074	0	0	17	-10	1.06364	32	0	27	0	0	0	0	0	0	0	0	0	0	0	0;
	3086	4	1.01	0	0	1.08182	24	1	24	0	0	0	0	0	0	0	0	0	0	0	0;
	3087	4	1	0	0	1.08182	24	1	24	0	0	0	0	0	0	0	0	0	0	0	0;
	3097	2.7	0.77	2.2	0.5	1.04545	4	1	4	0	0	0	0	0	0	0	0	0	0	0	0;
	3098	0	0	2.2	0.5	1.04545	4	0	4	0	0	0	0	0	0	0	0	0	0	0	0;
	3100	0	0	33	-29	1.07273	56	0	52	-69	0	0	0	0	0	0	0	0	0	0	0;
	3100	0	0	33	-26	1.07273	57	0	54	37	0	0	0	0	0	0	0	0	0	0	0;
	3101	0	0	33	-29	1.07273	56	0	51	-69	0	0	0	0	0	0	0	0	0	0	0;
	3103	129	22.1	50	0	1.1	150	1	150	108	0	0	0	0	0	0	0	0	0	0	0;
	3113	0	0	9999	-9999	1.043	110	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3114	0	0	9999	-9999	1.04309	8626	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3115	0	0	9999	-9999	1.03798	26478	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3116	0	0	9999	-9999	1.02647	42342	1	502	502	0	0	0	0	0	0	0	0	0	0	0;
	3117	0	0	9999	-9999	1.08259	11822	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	3118	0	0	9999	-9999	1.0424	17397	1	109	109	0	0	0	0	0	0	0	0	0	0	0;
	3119	57.6	29.96	0	0	0.98438	120	1	112	0	0	0	0	0	0	0	0	0	0	0	0;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	9	11	0.00064	0.0305	0	400	400	400	1.09271	0	1	-360	360;
	13	12	0.00069	0.03946	0	250	250	250	0.9999	0	1	-360	360;
	20	18	0.00088	0.05709	0	330	330	330	0.9999	0	1	-360	360;
	34	33	0.0007	0.03652	0	250	250	250	0.9999	0	1	-360	360;
	35	37	0.00036	0.02519	0	500	500	500	1.07313	0	1	-360	360;
	36	38	0.00036	0.02519	0	500	500	500	1.07313	0	1	-360	360;
	53	54	0.00034	0.02097	0	500	500	500	1.0755	0	1	-360	360;
	57	59	0.00034	0.02097	0	500	500	500	1.07313	0	1	-360	360;
	68	70	0.00081	0.03	0	400	400	400	1.10102	0	1	-360	360;
	105	107	0.00075	0.02445	-0.00832	330	330	330	1.039	0	1	-360	360;
	106	108	0.0004	0.0253	0	500	500	500	1.0457	0	1	-360	360;
	142	145	0.00053	0.02875	-0.016	400	400	400	1.06299	0	1	-360	360;
	170	171	0.00064	0.0305	0	400	400	400	1.07408	0	1	-360	360;
	177	180	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	178	181	0.00023	0.023	0	500	500	500	1.07426	0	1	-360	360;
	185	184	0.00032	0.04392	0	330	330	330	0.9999	0	1	-360	360;
	188	190	0.0003	0.02732	0	500	500	500	1.10037	0	1	-360	360;
	195	197	0.00035	0.02375	0	500	500	500	1.08671	0	1	-360	360;
	208	209	0.00051	0.0275	0	400	400	400	1.07702	0	1	-360	360;
	213	211	0.00084	0.06858	0	250	250	250	0.9999	0	1	-360	360;
	216	218	0.00033	0.02711	0	500	500	500	1.08613	0	1	-360	360;
	220	218	0.00032	0.0464	0	330	330	330	0.9999	0	1	-360	360;
	227	225	0.00113	0.05647	0	330	330	330	0.9999	0	1	-360	360;
	224	226	0.00075	0.02469	-0.008	330	330	330	1.04544	0	1	-360	360;
	3116	180	0.00029	0.00317	0.09184	1386	1386	1386	0	0	1	-360	360;
	3116	181	0.0003	0.00326	0.09536	1386	1386	1386	0	0	1	-360	360;
	240	82	0.01475	0.08595	0.13036	339	339	339	0	0	1	-360	360;
	3114	90	0.01244	0.06959	0.10842	412	412	412	0	0	1	-360	360;
	3114	120	0.01207	0.06905	0.11519	412	412	412	0	0	1	-360	360;
	144	3115	0.00168	0.01603	0.51488	1206	1206	1206	0	0	1	-360	360;
	3117	169	0.0018	0.01616	0.0484	436	436	436	0	0	1	-360	360;
	3117	170	0.0018	0.01616	0.0484	436	436	436	0	0	1	-360	360;
	3118	61	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	3118	62	0.00223	0.02209	0.69011	831	831	831	0	0	1	-360	360;
	97	3113	0.00293	0.03054	0.95472	1206	1206	1206	0	0	1	-360	360;
	56	28	0.01174	0.07014	0.12689	339	339	339	0	0	1	-360	360;
	35	105	0.00919	0.06614	0.10451	375	375	375	0	0	1	-360	360;
	36	106	0.00822	0.05767	0.0982	400	400	400	0	0	1	-360	360;
	167	39	0.01698	0.12459	0.1957	231	231	231	0	0	1	-360	360;
	153	46	0.01298	0.06738	0.10284	250	250	250	0	0	1	-360	360;
	152	25	0.01068	0.0475	0.09495	339	339	339	0	0	1	-360	360;
	188	26	0.01436	0.10729	0.16081	231	231	231	0	0	1	-360	360;
	53	124	0.01488	0.08161	0.1148	266	266	266	0	0	1	-360	360;
	52	106	0.01116	0.07171	0.10367	267	267	267	0	0	1	-360	360;
	203	98	0.00552	0.05948	0.17077	317	317	317	0	0	1	-360	360;
	234	189	0.01118	0.06597	0.10778	267	267	267	0	0	1	-360	360;
	221	188	0.01682	0.08909	0.12993	295	295	295	0	0	1	-360	360;
	222	189	0.01384	0.08702	0.13484	295	295	295	0	0	1	-360	360;
	238	192	0.01517	0.09938	0.14492	197	197	197	0	0	1	-360	360;
	57	14	0.01457	0.07362	0.13344	356	356	356	0	0	1	-360	360;
	229	23	0.01403	0.10413	0.15949	231	231	231	0	0	1	-360	360;
	115	68	0.00374	0.0438	0.10096	476	476	476	0	0	1	-360	360;
	187	97	0.00194	0.02007	0.54307	970	970	970	0	0	1	-360	360;
	58	12	0.0015	0.01506	0.4032	1154	1154	1154	0	0	1	-360	360;
	210	171	0.00296	0.03484	0.9296	838	838	838	0	0	1	-360	360;
	136	70	0.00169	0.01931	0.53814	866	866	866	0	0	1	-360	360;
	38	108	0.00137	0.01569	0.43744	1154	1154	1154	0	0	1	-360	360;
	37	139	0.00234	0.02677	0.74653	1154	1154	1154	0	0	1	-360	360;
	32	218	0.00217	0.02513	0.67098	1154	1154	1154	0	0	1	-360	360;
	136	78	0.00152	0.01739	0.48083	866	866	866	0	0	1	-360	360;
	138	78	0.00468	0.05347	1.48883	831	831	831	0	0	1	-360	360;
	97	41	0.00355	0.03617	0.95894	717	717	717	0	0	1	-360	360;
	107	41	0.00097	0.01052	0.28395	970	970	970	0	0	1	-360	360;
	61	137	0.00144	0.01446	0.51213	1386	1386	1386	0	0	1	-360	360;
	15	6	0.013	0.09781	0.14013	375	375	375	0	0	1	-360	360;
	40	15	0.00525	0.03847	0.06053	231	231	231	0	0	1	-360	360;
	31	6	0.00457	0.03351	0.05245	317	317	317	0	0	1	-360	360;
	22	9	0.01469	0.10915	0.16676	317	317	317	0	0	1	-360	360;
	27	14	0.01262	0.09326	0.14324	231	231	231	0	0	1	-360	360;
	35	7	0.00924	0.05052	0.07698	295	295	295	0	0	1	-360	360;
	22	3	0.01068	0.07936	0.12155	231	231	231	0	0	1	-360	360;
	35	25	0.00585	0.04027	0.07161	400	400	400	0	0	1	-360	360;
	36	24	0.00585	0.04027	0.07161	400	400	400	0	0	1	-360	360;
	14	8	0.00558	0.04147	0.0629	231	231	231	0	0	1	-360	360;
	43	15	0.00089	0.0063	0.0108	231	231	231	0	0	1	-360	360;
	29	15	0.00442	0.02374	0.04477	339	339	339	0	0	1	-360	360;
	45	7	0.00494	0.0269	0.04225	250	250	250	0	0	1	-360	360;
	24	6	0.00287	0.01671	0.02467	295	295	295	0	0	1	-360	360;
	35	1	0.0012	0.0089	0.01512	461	461	461	0	0	1	-360	360;
	36	2	0.0012	0.0089	0.01513	461	461	461	0	0	1	-360	360;
	36	30	0.00399	0.02901	0.04808	380	380	380	0	0	1	-360	360;
	32	12	0.00298	0.03445	0.94221	831	831	831	0	0	1	-360	360;
	37	32	0.00358	0.04122	1.13382	1154	1154	1154	0	0	1	-360	360;
	19	38	0.00342	0.03928	1.08288	1154	1154	1154	0	0	1	-360	360;
	11	21	0.00286	0.03355	0.90157	838	838	838	0	0	1	-360	360;
	44	21	0.00023	0.00264	0.07296	838	838	838	0	0	1	-360	360;
	11	19	0.0011	0.01271	0.35206	838	838	838	0	0	1	-360	360;
	184	38	0.00139	0.0159	0.44176	838	838	838	0	0	1	-360	360;
	77	72	0.01054	0.06151	0.09306	197	197	197	0	0	1	-360	360;
	74	69	0.00905	0.06723	0.10296	231	231	231	0	0	1	-360	360;
	81	47	0.0114	0.06587	0.09975	274	274	274	0	0	1	-360	360;
	64	47	0.0107	0.06628	0.10825	287	287	287	0	0	1	-360	360;
	72	55	0.00543	0.03733	0.06668	341	341	341	0	0	1	-360	360;
	73	57	0.00543	0.03733	0.06668	341	341	341	0	0	1	-360	360;
	73	47	0.00657	0.0481	0.0727	319	319	319	0	0	1	-360	360;
	82	65	0.00302	0.0201	0.03069	339	339	339	0	0	1	-360	360;
	65	51	0.007	0.05138	0.08084	231	231	231	0	0	1	-360	360;
	49	68	0.00329	0.02506	0.0439	317	317	317	0	0	1	-360	360;
	50	48	0.00789	0.05868	0.08985	231	231	231	0	0	1	-360	360;
	69	50	0.00558	0.04062	0.06491	341	341	341	0	0	1	-360	360;
	81	49	0.00452	0.03366	0.05156	341	341	341	0	0	1	-360	360;
	81	80	0.00134	0.00996	0.01337	287	287	287	0	0	1	-360	360;
	76	55	0.00618	0.04353	0.07649	341	341	341	0	0	1	-360	360;
	77	56	0.00618	0.04353	0.07649	266	266	266	0	0	1	-360	360;
	76	52	0.01219	0.0637	0.09333	266	266	266	0	0	1	-360	360;
	75	53	0.00246	0.01826	0.02798	231	231	231	0	0	1	-360	360;
	60	52	0.00242	0.01531	0.02249	287	287	287	0	0	1	-360	360;
	63	59	0.0017	0.01977	0.53386	838	838	838	0	0	1	-360	360;
	71	67	0.00116	0.013	0.33856	838	838	838	0	0	1	-360	360;
	54	70	0.00218	0.02536	0.68579	838	838	838	0	0	1	-360	360;
	78	71	0.00105	0.01123	0.28195	1119	1119	1119	0	0	1	-360	360;
	62	79	0.00119	0.01428	0.36666	1154	1154	1154	0	0	1	-360	360;
	66	58	0.00184	0.02139	0.5777	838	838	838	0	0	1	-360	360;
	111	142	0.00488	0.03362	0.05961	341	341	341	0	0	1	-360	360;
	89	122	0.01093	0.05919	0.08439	180	180	180	0	0	1	-360	360;
	122	109	0.00194	0.01415	0.0223	341	341	341	0	0	1	-360	360;
	93	148	0.00192	0.01355	0.023	341	341	341	0	0	1	-360	360;
	148	100	0.00238	0.01667	0.02846	341	341	341	0	0	1	-360	360;
	149	147	0.00066	0.00496	0.00758	319	319	319	0	0	1	-360	360;
	121	149	0.00537	0.04039	0.06005	319	319	319	0	0	1	-360	360;
	106	149	0.00083	0.00525	0.00868	250	250	250	0	0	1	-360	360;
	115	135	0.01589	0.0832	0.11439	266	266	266	0	0	1	-360	360;
	95	128	0.00217	0.01459	0.02575	197	197	197	0	0	1	-360	360;
	132	116	0.01773	0.11678	0.16361	250	250	250	0	0	1	-360	360;
	143	88	0.00593	0.04093	0.07215	341	341	341	0	0	1	-360	360;
	123	105	0.0039	0.02847	0.04498	317	317	317	0	0	1	-360	360;
	134	93	0.00816	0.04242	0.0612	314	314	314	0	0	1	-360	360;
	135	92	0.00816	0.04242	0.0612	314	314	314	0	0	1	-360	360;
	93	90	0.00519	0.03839	0.05875	400	400	400	0	0	1	-360	360;
	92	87	0.00213	0.01403	0.0226	250	250	250	0	0	1	-360	360;
	129	92	0.00463	0.02775	0.04612	267	267	267	0	0	1	-360	360;
	118	86	0.01122	0.07074	0.11571	180	180	180	0	0	1	-360	360;
	125	133	0.00601	0.04147	0.07364	308	308	308	0	0	1	-360	360;
	106	83	0.00207	0.01279	0.02055	197	197	197	0	0	1	-360	360;
	101	105	0.00136	0.0099	0.01586	400	400	400	0	0	1	-360	360;
	146	102	0.00058	0.00417	0.00684	341	341	341	0	0	1	-360	360;
	150	90	0.00085	0.00632	0.00931	457	457	457	0	0	1	-360	360;
	151	91	0.00085	0.00612	0.00964	457	457	457	0	0	1	-360	360;
	117	91	0.00159	0.01112	0.01913	396	396	396	0	0	1	-360	360;
	142	119	0.00314	0.02159	0.03839	341	341	341	0	0	1	-360	360;
	143	126	0.00455	0.03157	0.05531	231	231	231	0	0	1	-360	360;
	119	99	0.00145	0.01008	0.01719	231	231	231	0	0	1	-360	360;
	120	110	0.00384	0.02721	0.04517	231	231	231	0	0	1	-360	360;
	127	94	0.00777	0.04128	0.06391	197	197	197	0	0	1	-360	360;
	104	92	0.00446	0.03041	0.04867	180	180	180	0	0	1	-360	360;
	133	123	0.00589	0.03506	0.05235	267	267	267	0	0	1	-360	360;
	124	114	0.00316	0.02378	0.03527	231	231	231	0	0	1	-360	360;
	132	93	0.00184	0.0126	0.0224	231	231	231	0	0	1	-360	360;
	121	103	0.00171	0.00961	0.01424	250	250	250	0	0	1	-360	360;
	113	93	0.00341	0.02442	0.03997	317	317	317	0	0	1	-360	360;
	133	92	0.00184	0.0126	0.02239	231	231	231	0	0	1	-360	360;
	98	112	0.0057	0.04149	0.06617	341	341	341	0	0	1	-360	360;
	141	134	0.00461	0.02492	0.0356	266	266	266	0	0	1	-360	360;
	140	125	0.00215	0.01333	0.02211	250	250	250	0	0	1	-360	360;
	115	85	0.00079	0.00488	0.00726	137	137	137	0	0	1	-360	360;
	116	84	0.00079	0.00488	0.00724	137	137	137	0	0	1	-360	360;
	108	144	0.00241	0.02782	0.77066	1154	1154	1154	0	0	1	-360	360;
	97	145	0.00213	0.02432	0.67744	1240	1240	1240	0	0	1	-360	360;
	138	130	0.00091	0.0104	0.28989	838	838	838	0	0	1	-360	360;
	139	137	0.00312	0.03563	0.99107	831	831	831	0	0	1	-360	360;
	130	145	0.00092	0.01051	0.29293	838	838	838	0	0	1	-360	360;
	198	177	0.01039	0.08983	0.11422	375	375	375	0	0	1	-360	360;
	199	178	0.01039	0.08983	0.11422	375	375	375	0	0	1	-360	360;
	201	177	0.01455	0.0813	0.13279	267	267	267	0	0	1	-360	360;
	202	178	0.01455	0.0813	0.13279	267	267	267	0	0	1	-360	360;
	156	202	0.00519	0.03965	0.05836	317	317	317	0	0	1	-360	360;
	156	166	0.00083	0.00645	0.00951	317	317	317	0	0	1	-360	360;
	189	161	0.01105	0.08107	0.12824	341	341	341	0	0	1	-360	360;
	157	177	0.00597	0.04473	0.06735	317	317	317	0	0	1	-360	360;
	196	198	0.01736	0.10969	0.16268	287	287	287	0	0	1	-360	360;
	173	199	0.00938	0.06093	0.08934	339	339	339	0	0	1	-360	360;
	176	178	0.01246	0.09134	0.14349	400	400	400	0	0	1	-360	360;
	154	158	0.00514	0.03826	0.05933	231	231	231	0	0	1	-360	360;
	169	164	0.01062	0.0789	0.12085	317	317	317	0	0	1	-360	360;
	175	205	0.00769	0.0569	0.08673	231	231	231	0	0	1	-360	360;
	175	204	0.00225	0.01667	0.02541	286	286	286	0	0	1	-360	360;
	196	168	0.01851	0.1088	0.14435	250	250	250	0	0	1	-360	360;
	200	195	0.00236	0.01411	0.02031	229	229	229	0	0	1	-360	360;
	195	161	0.00355	0.02607	0.04096	341	341	341	0	0	1	-360	360;
	196	191	0.013	0.07589	0.11484	267	267	267	0	0	1	-360	360;
	195	174	0.00934	0.0539	0.08683	287	287	287	0	0	1	-360	360;
	168	152	0.00698	0.0374	0.05463	314	314	314	0	0	1	-360	360;
	167	153	0.00436	0.03202	0.0503	400	400	400	0	0	1	-360	360;
	188	168	0.0006	0.00351	0.00555	341	341	341	0	0	1	-360	360;
	189	167	0.0006	0.00351	0.00555	341	341	341	0	0	1	-360	360;
	176	164	0.01058	0.07762	0.12203	231	231	231	0	0	1	-360	360;
	182	169	0.00469	0.03486	0.05338	317	317	317	0	0	1	-360	360;
	170	162	0.00568	0.04012	0.07033	317	317	317	0	0	1	-360	360;
	193	162	0.00105	0.00733	0.01258	231	231	231	0	0	1	-360	360;
	194	182	0.00744	0.05397	0.09307	231	231	231	0	0	1	-360	360;
	202	155	0.00221	0.01618	0.02541	231	231	231	0	0	1	-360	360;
	203	201	0.00525	0.03837	0.06052	231	231	231	0	0	1	-360	360;
	206	198	0.00236	0.01746	0.02676	341	341	341	0	0	1	-360	360;
	180	159	0.00274	0.02778	0.69846	717	717	717	0	0	1	-360	360;
	186	160	0.00171	0.01741	0.45456	717	717	717	0	0	1	-360	360;
	184	187	0.00136	0.01599	0.41965	1240	1240	1240	0	0	1	-360	360;
	197	172	0.00373	0.04344	1.172	831	831	831	0	0	1	-360	360;
	214	222	0.02738	0.14254	0.20047	222	222	222	0	0	1	-360	360;
	228	234	0.02709	0.15992	0.26125	197	197	197	0	0	1	-360	360;
	215	239	0.01909	0.11277	0.16673	197	197	197	0	0	1	-360	360;
	217	221	0.008	0.05936	0.10081	231	231	231	0	0	1	-360	360;
	222	207	0.00186	0.02155	0.05317	461	461	461	0	0	1	-360	360;
	233	235	0.00738	0.05486	0.09318	231	231	231	0	0	1	-360	360;
	216	232	0.00556	0.04198	0.06158	231	231	231	0	0	1	-360	360;
	229	224	0.00205	0.01421	0.02506	341	341	341	0	0	1	-360	360;
	239	208	0.00568	0.04215	0.0716	317	317	317	0	0	1	-360	360;
	231	209	0.00131	0.01547	0.41152	838	838	838	0	0	1	-360	360;
	211	218	0.00224	0.02606	0.70304	831	831	831	0	0	1	-360	360;
	225	212	0.0024	0.02795	0.75408	838	838	838	0	0	1	-360	360;
	236	230	0.0015	0.01768	0.46944	831	831	831	0	0	1	-360	360;
	3120	236	0.001	0.01165	0.31426	831	831	831	0	0	1	-360	360;
	212	237	0.00133	0.01553	0.41898	831	831	831	0	0	1	-360	360;
	527	1	0.00064	0.04304	0	250	250	250	1.00985	0	1	-360	360;
	528	2	0.00157	0.06612	0	160	160	160	1.00877	0	1	-360	360;
	316	314	0.00101	0.04727	0	300	300	300	0.91667	0	1	-360	360;
	316	38	0.00079	0.03678	0	426	426	426	0.91667	0	1	-360	360;
	319	4	0.00165	0.06736	0	160	160	160	1.0225	0	1	-360	360;
	5	3	0.00068	0.08078	0	160	160	160	0.9999	0	1	-360	360;
	320	5	0.00072	-0.01281	0	160	160	160	0.98707	0	1	-360	360;
	321	5	-0.00012	0.1674	0	9999	60	60	0.94159	0	1	-360	360;
	361	6	0.00165	0.06901	0	160	160	160	1.01755	0	1	-360	360;
	362	7	0.00165	0.06901	0	160	160	160	1.03303	0	1	-360	360;
	10	8	0.00079	0.07524	0	160	160	160	0.9999	0	1	-360	360;
	459	10	0.00081	-0.00714	0	160	160	160	0.98367	0	1	-360	360;
	461	10	-0.00024	0.15701	0	9999	55	55	0.94157	0	1	-360	360;
	460	13	0.00066	0.0269	0	250	250	250	1.1012	0	1	-360	360;
	462	13	-0.00044	0.00942	0	9999	55	55	0.98438	0	1	-360	360;
	16	14	0.00059	0.07897	0	160	160	160	0.9999	0	1	-360	360;
	474	16	0.0006	-0.01352	0	160	160	160	1.07516	0	1	-360	360;
	477	16	-0.00467	0.16067	0	9999	18	18	0.94157	0	1	-360	360;
	17	15	0.00062	0.08296	0	160	160	160	0.9999	0	1	-360	360;
	475	17	0.00062	-0.01547	0	160	160	160	1.07516	0	1	-360	360;
	478	17	-0.00056	0.17867	0	9999	18	18	0.94157	0	1	-360	360;
	476	14	0.00165	0.06775	0	160	160	160	1.08569	0	1	-360	360;
	486	20	0.00011	-0.00462	0	330	330	330	1.07757	0	1	-360	360;
	488	20	0.00452	0.07233	0	9999	69	69	0.96037	0	1	-360	360;
	496	21	0.00087	0.05244	-0.02144	330	330	330	1.10419	0	1	-360	360;
	518	22	0.00124	0.06839	0	160	160	160	1.03774	0	1	-360	360;
	517	23	0.00124	0.06839	0	160	160	160	1.0225	0	1	-360	360;
	525	24	0.00165	0.06901	0	160	160	160	1.04795	0	1	-360	360;
	526	25	0.00165	0.06901	0	160	160	160	1.03658	0	1	-360	360;
	533	26	0.00155	0.06612	0	160	160	160	1.07516	0	1	-360	360;
	534	27	0.00157	0.06612	0	160	160	160	1.06463	0	1	-360	360;
	540	28	0.00165	0.06901	0	160	160	160	1.05853	0	1	-360	360;
	541	29	0.00165	0.06901	0	160	160	160	1.06912	0	1	-360	360;
	542	30	0.00157	0.06798	0	160	160	160	1.01194	0	1	-360	360;
	543	31	0.00165	0.06901	0	160	160	160	1.01633	0	1	-360	360;
	554	34	0.00067	0.023	0	250	250	250	1.08449	0	1	-360	360;
	556	34	-0.00044	0.01252	0	9999	55	55	0.98438	0	1	-360	360;
	632	40	0.00165	0.06818	0	160	160	160	1.0797	0	1	-360	360;
	667	41	0.00137	0.06119	-0.01504	250	250	250	1.05505	0	1	-360	360;
	668	42	0.00137	0.06119	-0.01504	250	250	250	1.05813	0	1	-360	360;
	752	43	0.00165	0.06901	0	160	160	160	1.09281	0	1	-360	360;
	811	45	0.00165	0.06901	0	160	160	160	1.06463	0	1	-360	360;
	834	47	0.0014	0.0668	0	160	160	160	1.01196	0	1	-360	360;
	839	48	0.00151	0.06715	0	160	160	160	1.01599	0	1	-360	360;
	863	50	0.00157	0.07808	0	160	160	160	1.00521	0	1	-360	360;
	867	51	0.00149	0.06616	0	160	160	160	1.0483	0	1	-360	360;
	922	55	0.00157	0.06775	0	160	160	160	1.01196	0	1	-360	360;
	925	60	0.00163	0.06946	0	160	160	160	1.01196	0	1	-360	360;
	928	62	0.00135	0.06052	0	250	250	250	1.04896	0	1	-360	360;
	959	63	0.00135	0.06052	0	250	250	250	1.07213	0	1	-360	360;
	980	64	0.00119	0.06558	0	160	160	160	1.04115	0	1	-360	360;
	1000	67	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	1004	66	0.00139	0.05984	0	250	250	250	1.06772	0	1	-360	360;
	1012	69	0.00145	0.06839	0	160	160	160	1.01196	0	1	-360	360;
	1032	74	0.00165	0.06775	0	160	160	160	1.01039	0	1	-360	360;
	1031	75	0.00157	0.06775	0	160	160	160	1.00433	0	1	-360	360;
	1044	76	0.00163	0.06783	0	160	160	160	1.00562	0	1	-360	360;
	1043	77	0.00143	0.06831	0	160	160	160	1.00143	0	1	-360	360;
	1053	78	0.00139	0.0608	0	250	250	250	1.05095	0	1	-360	360;
	1054	79	0.0014	0.06235	0	250	250	250	1.05095	0	1	-360	360;
	1086	80	0.00163	0.06754	0	160	160	160	1.01633	0	1	-360	360;
	1119	82	0.00161	0.06762	0	160	160	160	1.02703	0	1	-360	360;
	1142	83	0.00119	0.06565	-0.003	160	160	160	1.02353	0	1	-360	360;
	1171	86	0.00141	0.07036	-0.00319	160	160	160	1.01921	0	1	-360	360;
	1188	88	0.00287	0.10711	-0.00242	100	100	100	1.00972	0	1	-360	360;
	1189	89	0.0014	0.06927	-0.00532	160	160	160	0.99664	0	1	-360	360;
	1289	96	0.00155	0.06268	-0.00992	250	250	250	1.03418	0	1	-360	360;
	1290	96	0.00155	0.06288	-0.00992	250	250	250	1.03622	0	1	-360	360;
	1382	98	0.0016	0.06694	-0.0031	160	160	160	1.06383	0	1	-360	360;
	1383	98	0.00153	0.0666	-0.00319	160	160	160	1.04762	0	1	-360	360;
	1406	99	0.00149	0.06756	-0.00252	160	160	160	1.02335	0	1	-360	360;
	1405	100	0.00149	0.06544	-0.00252	160	160	160	1.01425	0	1	-360	360;
	1484	103	0.00141	0.06975	-0.00232	160	160	160	1.02312	0	1	-360	360;
	1485	104	0.00157	0.0677	-0.00281	160	160	160	1.04645	0	1	-360	360;
	1530	109	0.00154	0.06742	-0.00658	160	160	160	1.02147	0	1	-360	360;
	1529	110	0.00143	0.06701	-0.0029	160	160	160	1.02256	0	1	-360	360;
	1546	111	0.0014	0.06831	-0.00319	160	160	160	1.03811	0	1	-360	360;
	1554	115	0.00162	0.06729	-0.00232	160	160	160	1.01396	0	1	-360	360;
	1553	116	0.00155	0.06701	-0.00319	160	160	160	1.00733	0	1	-360	360;
	1587	117	0.00143	0.06968	-0.00223	160	160	160	1.10731	0	1	-360	360;
	1586	118	0.00155	0.06763	-0.00319	160	160	160	1.12389	0	1	-360	360;
	1589	119	0.00148	0.06688	-0.0029	160	160	160	1.02231	0	1	-360	360;
	1668	120	0.00155	0.06851	-0.0029	160	160	160	1.00562	0	1	-360	360;
	1656	121	0.00174	0.09356	-0.00339	160	160	160	0.98025	0	1	-360	360;
	1658	122	0.00167	0.09275	-0.003	160	160	160	0.99807	0	1	-360	360;
	1695	123	0.00144	0.06708	-0.00223	160	160	160	1.03027	0	1	-360	360;
	1703	125	0.00148	0.06578	-0.00523	160	160	160	1.07761	0	1	-360	360;
	1739	126	0.00152	0.06749	-0.00348	160	160	160	1.06341	0	1	-360	360;
	1875	128	0.00143	0.06968	-0.0029	160	160	160	1.05977	0	1	-360	360;
	1939	130	0.00156	0.06252	-0.00864	250	250	250	1.10771	0	1	-360	360;
	1941	130	0.00156	0.06292	-0.00864	250	250	250	1.07718	0	1	-360	360;
	1984	132	0.00142	0.06729	-0.00223	160	160	160	1.00563	0	1	-360	360;
	1992	135	0.00153	0.06667	-0.00658	160	160	160	1.07985	0	1	-360	360;
	2096	136	0.00136	0.05992	-0.01504	250	250	250	1.11092	0	1	-360	360;
	2098	138	0.00139	0.0612	-0.00992	250	250	250	1.05786	0	1	-360	360;
	2099	139	0.00156	0.06244	-0.00992	250	250	250	1.07395	0	1	-360	360;
	2126	140	0.00155	0.06701	-0.003	160	160	160	1.10437	0	1	-360	360;
	2125	141	0.00121	0.06831	-0.003	160	160	160	1.09917	0	1	-360	360;
	2146	142	0.00139	0.06852	-0.00232	160	160	160	1.0224	0	1	-360	360;
	2145	143	0.00154	0.06811	-0.0029	160	160	160	1.04321	0	1	-360	360;
	2166	146	0.00119	0.06571	-0.00378	160	160	160	1.0213	0	1	-360	360;
	2167	147	0.00143	0.06551	-0.0029	160	160	160	1.00797	0	1	-360	360;
	2238	152	0.00165	0.0625	0	160	160	160	1.03303	0	1	-360	360;
	2258	155	0.00145	0.06818	0	160	160	160	1.02665	0	1	-360	360;
	2259	154	0.00165	0.06818	0	160	160	160	1.07108	0	1	-360	360;
	2263	156	0.00145	0.06818	0	160	160	160	1.07492	0	1	-360	360;
	2283	157	0.00151	0.06688	0	160	160	160	1.04116	0	1	-360	360;
	2285	159	0.00153	0.06206	0	250	250	250	1.09711	0	1	-360	360;
	2286	160	0.00152	0.06206	0	250	250	250	1.09923	0	1	-360	360;
	2291	161	0.00118	0.06517	0	160	160	160	1.09791	0	1	-360	360;
	2317	162	0.00151	0.06688	0	160	160	160	1.05123	0	1	-360	360;
	2323	164	0.00161	0.06653	0	160	160	160	1.05213	0	1	-360	360;
	2324	164	0.00161	0.06653	0	160	160	160	1.04832	0	1	-360	360;
	2388	166	0.00145	0.06818	0	160	160	160	1.08199	0	1	-360	360;
	2389	166	0.00145	0.06818	0	160	160	160	1.09028	0	1	-360	360;
	2405	167	0.00165	0.06851	0	160	160	160	1.08505	0	1	-360	360;
	2404	168	0.00165	0.06851	0	160	160	160	1.03303	0	1	-360	360;
	2415	170	0.00163	0.06136	0.00416	160	160	160	1.0215	0	1	-360	360;
	2461	173	0.00165	0.0593	0	160	160	160	1.13469	0	1	-360	360;
	2472	175	0.00118	0.06517	0	160	160	160	1.07303	0	1	-360	360;
	2473	176	0.00123	0.06619	0	160	160	160	1.0741	0	1	-360	360;
	2489	177	0.00165	0.09277	0	160	160	160	1.00145	0	1	-360	360;
	2490	178	0.00165	0.06694	0	160	160	160	1.00143	0	1	-360	360;
	2496	182	0.00029	0.06136	0.00416	160	160	160	1.03619	0	1	-360	360;
	2497	182	0.00165	0.0686	0	160	160	160	1.03344	0	1	-360	360;
	2528	185	0.00032	-0.00215	0	330	330	330	1.09976	0	1	-360	360;
	2530	185	-0.00023	0.09951	0	9999	69	69	0.96037	0	1	-360	360;
	2533	187	0.00101	0.06188	0	330	330	330	1.09976	0	1	-360	360;
	2532	186	0.00138	0.05931	0	250	250	250	1.10126	0	1	-360	360;
	2534	188	0.00163	0.07033	0	160	160	160	1.04795	0	1	-360	360;
	2553	191	0.00165	0.0593	0	160	160	160	1.07076	0	1	-360	360;
	2554	192	0.00165	0.0593	0	160	160	160	1.07833	0	1	-360	360;
	2555	193	0.00281	0.10601	0	100	100	100	0.99686	0	1	-360	360;
	2556	194	0.00281	0.10601	0	100	100	100	0.99669	0	1	-360	360;
	2558	196	0.00165	0.0593	0	160	160	160	1.10254	0	1	-360	360;
	2557	197	0.00101	0.06188	-0.01984	330	330	330	1.1306	0	1	-360	360;
	2558	197	0.00153	0.06206	0	250	250	250	1.10126	0	1	-360	360;
	2571	198	0.00165	0.06653	0	160	160	160	1.09977	0	1	-360	360;
	2572	199	0.00165	0.06775	0	160	160	160	1.10386	0	1	-360	360;
	2577	200	0.00162	0.06763	0	160	160	160	1.10676	0	1	-360	360;
	2643	201	0.00165	0.06818	0	160	160	160	1.04021	0	1	-360	360;
	2644	202	0.00165	0.06818	0	160	160	160	1.04934	0	1	-360	360;
	2765	203	0.00165	0.06632	0	160	160	160	1.04795	0	1	-360	360;
	2788	205	0.00165	0.06632	0	160	160	160	1.111	0	1	-360	360;
	2787	206	0.00165	0.06632	0	160	160	160	1.10448	0	1	-360	360;
	2809	207	0.00155	0.06585	0	160	160	160	1.08057	0	1	-360	360;
	2834	210	0.00137	0.05968	0	250	250	250	1.05095	0	1	-360	360;
	2843	213	0.00044	-0.00422	0	250	250	250	1.06772	0	1	-360	360;
	2845	213	0.00496	0.06982	0	9999	55	55	0.98438	0	1	-360	360;
	2844	212	0.00129	0.06437	0	250	250	250	1.10126	0	1	-360	360;
	2848	214	0.00015	0.06524	0	160	160	160	1.07325	0	1	-360	360;
	2849	215	0.00027	0.06715	0	160	160	160	1.08282	0	1	-360	360;
	2867	216	0.00163	0.06671	0	160	160	160	1.06463	0	1	-360	360;
	2869	217	0.00163	0.06671	0	160	160	160	1.05908	0	1	-360	360;
	2868	220	0.00032	-0.00435	0	330	330	330	1.06892	0	1	-360	360;
	2870	220	-0.00022	0.1019	0	9999	69	69	0.96037	0	1	-360	360;
	223	222	0.00076	0.0789	0	160	160	160	0.9999	0	1	-360	360;
	2877	223	0.00077	-0.01223	0	160	160	160	1.04712	0	1	-360	360;
	2879	223	-0.00017	0.16709	0	9999	55	55	0.94157	0	1	-360	360;
	2878	221	0.00159	0.06736	0	160	160	160	1.07383	0	1	-360	360;
	2954	227	-0.00013	-0.00407	0	330	330	330	1.05737	0	1	-360	360;
	2956	227	0.00423	0.07177	0	9999	69	69	0.96037	0	1	-360	360;
	2957	228	0.00161	0.06756	0	160	160	160	1.05244	0	1	-360	360;
	2958	229	0.00161	0.06756	0	160	160	160	1.05718	0	1	-360	360;
	3027	230	0.00059	0.04206	0	330	330	330	1.04877	0	1	-360	360;
	3049	233	0.00119	0.06565	0	160	160	160	1.09622	0	1	-360	360;
	3048	232	0.00151	0.06633	0	160	160	160	1.1017	0	1	-360	360;
	3069	234	0.00161	0.06736	0	160	160	160	1.09825	0	1	-360	360;
	3069	235	0.00165	0.06671	0	160	160	160	1.09825	0	1	-360	360;
	3095	236	0.00137	0.05969	0	250	250	250	1.05449	0	1	-360	360;
	3096	236	0.00137	0.05969	0	250	250	250	1.05312	0	1	-360	360;
	3100	238	0.00155	0.06798	0	160	160	160	1.02947	0	1	-360	360;
	3101	239	0.00161	0.06775	0	160	160	160	1.03303	0	1	-360	360;
	2946	467	0.07545	0.13256	0.01257	58	58	58	0	0	1	-360	360;
	2394	384	0.02372	0.06124	0.00624	51	51	51	0	0	1	-360	360;
	2430	416	0.02471	0.06281	0.00641	62	62	62	0	0	1	-360	360;
	2238	565	0.04207	0.1086	0.01107	62	62	62	0	0	1	-360	360;
	2375	267	0.06182	0.10504	0.01014	58	58	58	0	0	1	-360	360;
	2702	717	0.05926	0.10397	0.01048	39	39	39	0	0	1	-360	360;
	1562	311	0.03306	0.08099	0.01007	77	77	77	0	0	1	-360	360;
	1574	595	0.02149	0.07107	0.00724	90	90	90	0	0	1	-360	360;
	938	511	0.04727	0.08388	0.00786	79	79	79	0	0	1	-360	360;
	878	541	0.07463	0.13025	0.01244	55	55	55	0	0	1	-360	360;
	1049	630	0.05223	0.09008	0.00866	55	55	55	0	0	1	-360	360;
	1109	1580	0.04545	0.07934	0.00852	58	58	58	0	0	1	-360	360;
	939	1885	0.03719	0.06033	0.00656	58	58	58	0	0	1	-360	360;
	1012	1964	0.04132	0.13967	0.01241	51	51	51	0	0	1	-360	360;
	1042	1666	0.02397	0.05372	0.00881	51	51	51	0	0	1	-360	360;
	1353	843	0.01653	0.02008	0.0042	39	39	39	0	0	1	-360	360;
	2758	1443	0.07025	0.12066	0.0129	39	39	39	0	0	1	-360	360;
	3040	2534	0.03719	0.09669	0.01016	102	102	102	0	0	1	-360	360;
	2972	2535	0.08207	0.20008	0.02217	102	102	102	0	0	1	-360	360;
	2977	2534	0.04463	0.11521	0.01205	102	102	102	0	0	1	-360	360;
	2918	2404	0.0681	0.17298	0.01756	87	87	87	0	0	1	-360	360;
	2916	2241	0.05678	0.14413	0.01463	87	87	87	0	0	1	-360	360;
	2940	2535	0.05628	0.18322	0.01876	123	123	123	0	0	1	-360	360;
	1996	1065	0.03884	0.06446	0.00695	58	58	58	0	0	1	-360	360;
	3014	2521	0.02306	0.07438	0.00784	123	123	123	0	0	1	-360	360;
	922	615	0.04678	0.32397	0.03151	81	81	81	0	0	1	-360	360;
	1592	2386	0.0405	0.05041	0.00719	57	57	57	0	0	1	-360	360;
	718	1510	0.05702	0.11322	0.01232	58	58	58	0	0	1	-360	360;
	922	630	0.01636	0.05314	0.00619	71	71	71	0	0	1	-360	360;
	923	328	0.05661	0.1305	0.013	55	55	55	0	0	1	-360	360;
	700	1305	0.00992	0.02975	0.00356	90	90	90	0	0	1	-360	360;
	1035	511	0.01397	0.04504	0.00462	120	120	120	0	0	1	-360	360;
	975	446	0.05992	0.10149	0.01089	55	55	55	0	0	1	-360	360;
	957	615	0.07438	0.13025	0.01236	55	55	55	0	0	1	-360	360;
	2906	332	0.0394	0.12917	0.01307	76	76	76	0	0	1	-360	360;
	2946	309	0.04521	0.0795	0.00754	58	58	58	0	0	1	-360	360;
	997	652	0.01719	0.0557	0.00569	120	120	120	0	0	1	-360	360;
	1109	1978	0.01405	0.04298	0.00513	69	69	69	0	0	1	-360	360;
	2076	974	0.02149	0.0405	0.00799	120	120	120	0	0	1	-360	360;
	2014	974	0.01901	0.03388	0.00697	51	51	51	0	0	1	-360	360;
	1901	981	0.05106	0.09015	0.00845	58	58	58	0	0	1	-360	360;
	1033	446	0.04231	0.07529	0.00706	78	78	78	0	0	1	-360	360;
	3038	502	0.03752	0.12182	0.0124	69	69	69	0	0	1	-360	360;
	2800	450	0.07884	0.10231	0.01021	49	49	49	0	0	1	-360	360;
	923	639	0.05653	0.18587	0.01908	71	71	71	0	0	1	-360	360;
	977	606	0.02826	0.09669	0.00936	76	76	76	0	0	1	-360	360;
	880	1309	0.01901	0.05868	0.00682	90	90	90	0	0	1	-360	360;
	2945	2717	0.03074	0.09917	0.01021	69	69	69	0	0	1	-360	360;
	2942	465	0.02314	0.07529	0.00762	19	19	19	0	0	1	-360	360;
	262	260	0.03744	0.18876	0.01765	125	125	125	0	0	1	-360	360;
	579	476	0.01223	0.02868	0.00295	129	129	129	0	0	1	-360	360;
	421	266	0.01959	0.06355	0.00659	81	81	81	0	0	1	-360	360;
	797	710	0.00686	0.02207	0.00232	81	81	81	0	0	1	-360	360;
	578	797	0.00554	0.01802	0.00184	81	81	81	0	0	1	-360	360;
	797	803	0.00273	0.0095	0.001	81	81	81	0	0	1	-360	360;
	463	459	0.02355	0.06107	0.00629	71	71	71	0	0	1	-360	360;
	464	460	0.02339	0.0619	0.00629	71	71	71	0	0	1	-360	360;
	521	459	0.01545	0.04488	0.00434	71	71	71	0	0	1	-360	360;
	649	460	0.01967	0.05959	0.00587	71	71	71	0	0	1	-360	360;
	341	540	0.03182	0.05851	0.00559	55	55	55	0	0	1	-360	360;
	342	541	0.03256	0.06124	0.00549	55	55	55	0	0	1	-360	360;
	625	460	0.00251	0.00811	0.00086	137	137	137	0	0	1	-360	360;
	654	540	0.04058	0.07612	0.00678	55	55	55	0	0	1	-360	360;
	710	625	0.01398	0.04524	0.0048	137	137	137	0	0	1	-360	360;
	576	466	0.04306	0.07157	0.00754	55	55	55	0	0	1	-360	360;
	498	302	0.02736	0.05992	0.00581	55	55	55	0	0	1	-360	360;
	573	294	0.02455	0.07967	0.00818	90	90	90	0	0	1	-360	360;
	654	376	0.02165	0.0386	0.00351	55	55	55	0	0	1	-360	360;
	628	610	0.11182	0.19074	0.01909	55	55	55	0	0	1	-360	360;
	632	331	0.03083	0.10008	0.01034	81	81	81	0	0	1	-360	360;
	377	361	0.01967	0.06455	0.00652	90	90	90	0	0	1	-360	360;
	400	279	0.00653	0.02157	0.00211	90	90	90	0	0	1	-360	360;
	441	526	0.02364	0.07736	0.00789	90	90	90	0	0	1	-360	360;
	442	441	0.00248	0.00802	0.00082	90	90	90	0	0	1	-360	360;
	449	339	0.04314	0.08281	0.0075	58	58	58	0	0	1	-360	360;
	507	362	0.02281	0.07446	0.00759	90	90	90	0	0	1	-360	360;
	818	581	0.02934	0.09512	0.00992	90	90	90	0	0	1	-360	360;
	522	416	0.01372	0.04455	0.00461	90	90	90	0	0	1	-360	360;
	453	298	0.02975	0.07686	0.00795	102	102	102	0	0	1	-360	360;
	517	436	0.03149	0.10347	0.01045	123	123	123	0	0	1	-360	360;
	518	503	0.04736	0.08314	0.00789	78	78	78	0	0	1	-360	360;
	503	379	0.0243	0.07975	0.00805	123	123	123	0	0	1	-360	360;
	524	474	0.00645	0.02025	0.00223	55	55	55	0	0	1	-360	360;
	563	504	0.03702	0.12132	0.0121	81	81	81	0	0	1	-360	360;
	738	632	0.02256	0.07322	0.0075	90	90	90	0	0	1	-360	360;
	830	439	0.05926	0.10455	0.00969	58	58	58	0	0	1	-360	360;
	632	270	0.02744	0.08264	0.00995	81	81	81	0	0	1	-360	360;
	631	651	0.04893	0.15504	0.01573	90	90	90	0	0	1	-360	360;
	618	575	0.0238	0.0781	0.00789	81	81	81	0	0	1	-360	360;
	382	538	0.00711	0.02281	0.00242	81	81	81	0	0	1	-360	360;
	670	619	0.01381	0.04492	0.00795	93	93	93	0	0	1	-360	360;
	740	387	0.01736	0.04533	0.00922	76	76	76	0	0	1	-360	360;
	356	424	0.00919	0.02977	0.00316	70	70	70	0	0	1	-360	360;
	425	788	0.00631	0.02038	0.00216	70	70	70	0	0	1	-360	360;
	801	709	0.00455	0.01471	0.00154	81	81	81	0	0	1	-360	360;
	245	474	0.00628	0.02036	0.00216	137	137	137	0	0	1	-360	360;
	244	485	0.00643	0.02076	0.0022	137	137	137	0	0	1	-360	360;
	761	474	0.00356	0.01154	0.00122	137	137	137	0	0	1	-360	360;
	774	692	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	773	693	0.00582	0.01883	0.002	137	137	137	0	0	1	-360	360;
	693	675	0.00555	0.01796	0.00293	93	93	93	0	0	1	-360	360;
	676	475	0.00607	0.01973	0.00291	137	137	137	0	0	1	-360	360;
	753	476	0.00382	0.02652	0.00281	137	137	137	0	0	1	-360	360;
	735	475	0.01348	0.03592	0.0151	76	76	76	0	0	1	-360	360;
	725	474	0.01121	0.03006	0.01231	76	76	76	0	0	1	-360	360;
	748	734	0.0047	0.01191	0.00126	76	76	76	0	0	1	-360	360;
	741	677	0.01017	0.02827	0.02773	76	76	76	0	0	1	-360	360;
	669	474	0.00161	0.00521	0.00055	93	93	93	0	0	1	-360	360;
	672	476	0.00212	0.00684	0.00073	93	93	93	0	0	1	-360	360;
	741	723	0.01826	0.04974	0.00528	76	76	76	0	0	1	-360	360;
	745	760	0.00916	0.02956	0.00314	93	93	93	0	0	1	-360	360;
	742	741	0.00421	0.01103	0.00117	64	64	64	0	0	1	-360	360;
	743	740	0.00421	0.01103	0.00117	64	64	64	0	0	1	-360	360;
	773	750	0.00596	0.01931	0.00205	137	137	137	0	0	1	-360	360;
	773	689	0.00118	0.0038	0.0004	137	137	137	0	0	1	-360	360;
	744	692	0.00241	0.00778	0.00083	93	93	93	0	0	1	-360	360;
	710	460	0.01404	0.04546	0.00483	137	137	137	0	0	1	-360	360;
	800	781	0.0045	0.0145	0.00154	76	76	76	0	0	1	-360	360;
	728	781	0.01103	0.02812	0.00298	76	76	76	0	0	1	-360	360;
	781	360	0.00037	0.0012	0.00013	70	70	70	0	0	1	-360	360;
	459	780	0.00855	0.02759	0.00293	93	93	93	0	0	1	-360	360;
	784	780	0.0017	0.00427	0.00045	76	76	76	0	0	1	-360	360;
	740	784	0.00843	0.02047	0.00217	76	76	76	0	0	1	-360	360;
	780	359	0.00045	0.00115	0.00012	93	93	93	0	0	1	-360	360;
	784	455	0.00026	0.00066	7e-05	76	76	76	0	0	1	-360	360;
	704	734	0.00616	0.02064	0.00971	93	93	93	0	0	1	-360	360;
	691	763	0.00083	0.00356	0.02543	137	137	137	0	0	1	-360	360;
	747	678	0.00034	0.00216	0.01054	105	105	105	0	0	1	-360	360;
	476	487	0.01254	0.04055	0.00431	137	137	137	0	0	1	-360	360;
	711	485	0.00439	0.01417	0.0015	137	137	137	0	0	1	-360	360;
	774	787	0.01264	0.04099	0.00435	137	137	137	0	0	1	-360	360;
	787	697	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	787	471	0.00329	0.00826	0.00088	64	64	64	0	0	1	-360	360;
	754	355	0.00363	0.01174	0.00125	137	137	137	0	0	1	-360	360;
	693	568	0.00101	0.00587	0.03106	93	93	93	0	0	1	-360	360;
	474	819	0.00493	0.01634	0.00609	70	70	70	0	0	1	-360	360;
	475	708	0.00401	0.01293	0.00137	70	70	70	0	0	1	-360	360;
	720	752	0.00031	0.00199	0.00973	96	96	96	0	0	1	-360	360;
	734	726	0.00279	0.00805	0.00815	76	76	76	0	0	1	-360	360;
	756	671	0.00316	0.01018	0.00108	93	93	93	0	0	1	-360	360;
	697	822	0.00056	0.00182	0.00019	137	137	137	0	0	1	-360	360;
	749	740	0.00404	0.01024	0.00109	76	76	76	0	0	1	-360	360;
	763	688	0.00769	0.0249	0.00264	137	137	137	0	0	1	-360	360;
	759	705	0.00154	0.00541	0.00499	93	93	93	0	0	1	-360	360;
	758	740	0.00575	0.01855	0.00197	93	93	93	0	0	1	-360	360;
	736	735	0.00167	0.00597	0.00617	93	93	93	0	0	1	-360	360;
	741	737	0.0118	0.03881	0.01131	93	93	93	0	0	1	-360	360;
	712	821	0.00358	0.01155	0.00122	137	137	137	0	0	1	-360	360;
	788	698	0.00047	0.0015	0.00016	137	137	137	0	0	1	-360	360;
	788	472	0.00391	0.00826	0.00088	64	64	64	0	0	1	-360	360;
	713	820	0.00181	0.00621	0.00438	70	70	70	0	0	1	-360	360;
	714	707	0.00169	0.00619	0.0081	70	70	70	0	0	1	-360	360;
	773	755	0.00318	0.01028	0.00109	137	137	137	0	0	1	-360	360;
	772	265	0.00995	0.03021	0.00321	64	64	64	0	0	1	-360	360;
	741	694	0.01377	0.03899	0.00414	76	76	76	0	0	1	-360	360;
	763	785	0.01243	0.03156	0.00335	76	76	76	0	0	1	-360	360;
	785	456	0.00026	0.00066	7e-05	64	64	64	0	0	1	-360	360;
	695	690	0.0028	0.00903	0.00096	93	93	93	0	0	1	-360	360;
	751	710	0.00701	0.0227	0.00241	137	137	137	0	0	1	-360	360;
	762	709	0.00393	0.01271	0.00135	137	137	137	0	0	1	-360	360;
	757	541	0.01963	0.06331	0.00672	93	93	93	0	0	1	-360	360;
	724	541	0.01202	0.03521	0.00986	76	76	76	0	0	1	-360	360;
	709	681	0.00882	0.02843	0.00302	70	70	70	0	0	1	-360	360;
	710	537	0.02083	0.06719	0.00713	70	70	70	0	0	1	-360	360;
	753	746	0.00064	0.0041	0.02001	105	105	105	0	0	1	-360	360;
	459	800	0.00412	0.01331	0.00141	93	93	93	0	0	1	-360	360;
	732	719	0.00041	0.00259	0.01264	96	96	96	0	0	1	-360	360;
	567	733	0.0006	0.00374	0.01827	96	96	96	0	0	1	-360	360;
	762	727	0.0042	0.01131	0.0012	76	76	76	0	0	1	-360	360;
	698	487	0.00396	0.01276	0.00135	137	137	137	0	0	1	-360	360;
	692	721	0.00028	0.00179	0.01597	137	137	137	0	0	1	-360	360;
	752	722	0.00041	0.00264	0.0236	183	183	183	0	0	1	-360	360;
	680	711	0.00049	0.00313	0.02806	137	137	137	0	0	1	-360	360;
	640	445	0.03322	0.10785	0.01114	81	81	81	0	0	1	-360	360;
	793	479	0.01169	0.03841	0.00388	81	81	81	0	0	1	-360	360;
	390	793	0.00954	0.03133	0.00316	81	81	81	0	0	1	-360	360;
	629	793	0.00017	0.00033	3e-05	81	81	81	0	0	1	-360	360;
	549	463	0.0686	0.12	0.01149	55	55	55	0	0	1	-360	360;
	828	634	0.04174	0.07628	0.00695	55	55	55	0	0	1	-360	360;
	715	577	0.01372	0.03719	0.00363	71	71	71	0	0	1	-360	360;
	550	329	0.01777	0.03124	0.00297	55	55	55	0	0	1	-360	360;
	633	610	0.0324	0.09587	0.00967	55	55	55	0	0	1	-360	360;
	512	301	0.01504	0.03075	0.00298	55	55	55	0	0	1	-360	360;
	560	512	0.01182	0.01967	0.00207	55	55	55	0	0	1	-360	360;
	330	284	0.00917	0.02983	0.00307	81	81	81	0	0	1	-360	360;
	569	284	0.00785	0.02545	0.00262	81	81	81	0	0	1	-360	360;
	613	611	0.00636	0.02091	0.00212	81	81	81	0	0	1	-360	360;
	716	591	0.0224	0.03926	0.00372	55	55	55	0	0	1	-360	360;
	770	592	0.07868	0.13934	0.01292	55	55	55	0	0	1	-360	360;
	730	716	0.00595	0.01157	0.0011	55	55	55	0	0	1	-360	360;
	662	246	0.04719	0.08273	0.00785	55	55	55	0	0	1	-360	360;
	579	571	0.00496	0.01421	0.00145	71	71	71	0	0	1	-360	360;
	574	518	0.05926	0.19198	0.01974	81	81	81	0	0	1	-360	360;
	703	301	0.00289	0.00926	0.00096	81	81	81	0	0	1	-360	360;
	419	423	0.00504	0.00901	0.00084	55	55	55	0	0	1	-360	360;
	517	778	0.00397	0.01298	0.00132	81	81	81	0	0	1	-360	360;
	804	778	0.01702	0.05512	0.00542	81	81	81	0	0	1	-360	360;
	778	514	8e-05	0.00017	2e-05	81	81	81	0	0	1	-360	360;
	769	764	0.01107	0.01934	0.00184	55	55	55	0	0	1	-360	360;
	649	386	0.00942	0.03041	0.00315	81	81	81	0	0	1	-360	360;
	566	466	0.06091	0.10124	0.01098	55	55	55	0	0	1	-360	360;
	777	517	0.00678	0.01446	0.00132	55	55	55	0	0	1	-360	360;
	566	777	0.00653	0.01207	0.00129	55	55	55	0	0	1	-360	360;
	777	513	0.00017	0.00025	2e-05	55	55	55	0	0	1	-360	360;
	518	516	0.03967	0.1286	0.01323	81	81	81	0	0	1	-360	360;
	515	453	0.02314	0.05587	0.00629	71	71	71	0	0	1	-360	360;
	770	454	0.05322	0.13512	0.01374	71	71	71	0	0	1	-360	360;
	686	454	0.03942	0.12769	0.01323	81	81	81	0	0	1	-360	360;
	422	505	0.02017	0.06405	0.00675	81	81	81	0	0	1	-360	360;
	524	269	0.03529	0.10818	0.011	55	55	55	0	0	1	-360	360;
	347	572	0.00331	0.01091	0.0011	81	81	81	0	0	1	-360	360;
	347	570	0.00347	0.01132	0.00117	81	81	81	0	0	1	-360	360;
	771	247	0.03909	0.06843	0.00649	55	55	55	0	0	1	-360	360;
	772	682	0.00574	0.01668	0.00177	64	64	64	0	0	1	-360	360;
	731	661	0.03289	0.05744	0.00521	55	55	55	0	0	1	-360	360;
	617	302	0.01165	0.04298	0.0039	55	55	55	0	0	1	-360	360;
	385	368	0.00901	0.02917	0.00302	81	81	81	0	0	1	-360	360;
	786	464	0.01522	0.08255	0.00509	81	81	81	0	0	1	-360	360;
	480	786	0.00791	0.02572	0.00265	81	81	81	0	0	1	-360	360;
	458	786	0.00339	0.00603	0.00054	81	81	81	0	0	1	-360	360;
	792	390	0.00542	0.01753	0.00181	81	81	81	0	0	1	-360	360;
	611	792	0.00631	0.0204	0.00211	81	81	81	0	0	1	-360	360;
	608	792	0.00256	0.00463	0.00041	81	81	81	0	0	1	-360	360;
	703	422	0.00694	0.02256	0.00234	55	55	55	0	0	1	-360	360;
	683	301	0.00355	0.0114	0.00118	81	81	81	0	0	1	-360	360;
	614	612	0.00636	0.02074	0.00214	81	81	81	0	0	1	-360	360;
	423	420	0.00694	0.02281	0.0023	81	81	81	0	0	1	-360	360;
	804	531	0.01975	0.06479	0.00655	81	81	81	0	0	1	-360	360;
	765	531	0.03116	0.08463	0.00843	55	55	55	0	0	1	-360	360;
	828	687	0.00537	0.01752	0.00177	81	81	81	0	0	1	-360	360;
	313	517	0.01678	0.05661	0.00575	81	81	81	0	0	1	-360	360;
	491	313	0.02686	0.0881	0.0089	81	81	81	0	0	1	-360	360;
	463	648	0.02727	0.07157	0.00743	81	81	81	0	0	1	-360	360;
	683	383	0.01372	0.04471	0.0046	81	81	81	0	0	1	-360	360;
	559	504	0.00545	0.01752	0.00183	81	81	81	0	0	1	-360	360;
	387	540	0.00607	0.01757	0.00407	76	76	76	0	0	1	-360	360;
	619	540	0.01061	0.03423	0.00363	93	93	93	0	0	1	-360	360;
	367	520	0.0057	0.01851	0.00193	81	81	81	0	0	1	-360	360;
	322	614	0.00012	0.00052	0.00318	81	81	81	0	0	1	-360	360;
	433	415	0.00223	0.00727	0.00073	90	90	90	0	0	1	-360	360;
	414	361	0.00306	0.00959	0.001	77	77	77	0	0	1	-360	360;
	426	406	0.00579	0.01661	0.00179	77	77	77	0	0	1	-360	360;
	590	361	0.01802	0.04636	0.0047	77	77	77	0	0	1	-360	360;
	701	362	0.00463	0.01488	0.00145	90	90	90	0	0	1	-360	360;
	444	361	0.00711	0.02273	0.00242	90	90	90	0	0	1	-360	360;
	404	776	0.00107	0.00281	0.00033	77	77	77	0	0	1	-360	360;
	412	776	0.00992	0.02636	0.00299	77	77	77	0	0	1	-360	360;
	776	310	0.00066	0.00174	0.00016	77	77	77	0	0	1	-360	360;
	655	412	0.00463	0.01388	0.00167	90	90	90	0	0	1	-360	360;
	408	413	0.00372	0.0119	0.00125	90	90	90	0	0	1	-360	360;
	799	411	0.00058	0.00198	0.00021	90	90	90	0	0	1	-360	360;
	407	799	0.00306	0.00992	0.00104	90	90	90	0	0	1	-360	360;
	799	827	0.0005	0.00165	0.00017	90	90	90	0	0	1	-360	360;
	811	411	0.00529	0.01645	0.00189	90	90	90	0	0	1	-360	360;
	798	440	0.00736	0.02388	0.00248	90	90	90	0	0	1	-360	360;
	396	798	0.00215	0.00645	0.00078	90	90	90	0	0	1	-360	360;
	811	798	0.00562	0.01818	0.0019	90	90	90	0	0	1	-360	360;
	790	409	0.00488	0.0124	0.00121	77	77	77	0	0	1	-360	360;
	790	526	0.00595	0.01793	0.00216	90	90	90	0	0	1	-360	360;
	601	790	0.00033	0.00099	0.0001	90	90	90	0	0	1	-360	360;
	812	656	0.00405	0.01298	0.00134	90	90	90	0	0	1	-360	360;
	811	603	0.00752	0.02264	0.0027	90	90	90	0	0	1	-360	360;
	526	293	0.01388	0.03628	0.00396	77	77	77	0	0	1	-360	360;
	415	292	0.01661	0.04702	0.00505	77	77	77	0	0	1	-360	360;
	434	410	0.00504	0.01612	0.0017	90	90	90	0	0	1	-360	360;
	451	362	0.01058	0.02802	0.00316	77	77	77	0	0	1	-360	360;
	783	410	0.00264	0.0086	0.0009	90	90	90	0	0	1	-360	360;
	440	783	8e-05	0.00033	4e-05	90	90	90	0	0	1	-360	360;
	783	435	0.00024	0.00769	0.00078	90	90	90	0	0	1	-360	360;
	452	405	0.00339	0.01124	0.00111	77	77	77	0	0	1	-360	360;
	413	395	0.00223	0.00678	0.00082	90	90	90	0	0	1	-360	360;
	642	338	0.01066	0.03231	0.00383	90	90	90	0	0	1	-360	360;
	602	641	0.01579	0.04785	0.00568	90	90	90	0	0	1	-360	360;
	414	406	0.0057	0.01372	0.00155	77	77	77	0	0	1	-360	360;
	282	811	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	374	361	0.01876	0.05198	0.00571	77	77	77	0	0	1	-360	360;
	525	375	0.01711	0.04669	0.00509	77	77	77	0	0	1	-360	360;
	525	470	0.00339	0.01017	0.00123	90	90	90	0	0	1	-360	360;
	283	812	0.00132	0.0043	0.00045	11	11	11	0	0	1	-360	360;
	279	362	0.01446	0.04802	0.00469	90	90	90	0	0	1	-360	360;
	443	428	0.00769	0.02471	0.00261	90	90	90	0	0	1	-360	360;
	414	429	0.00504	0.0162	0.0017	90	90	90	0	0	1	-360	360;
	580	469	0.00479	0.01446	0.00175	90	90	90	0	0	1	-360	360;
	638	526	0.00785	0.02537	0.00267	90	90	90	0	0	1	-360	360;
	638	432	0.00909	0.03058	0.00315	77	77	77	0	0	1	-360	360;
	525	427	0.01281	0.04116	0.00434	90	90	90	0	0	1	-360	360;
	403	525	0.00612	0.01975	0.00208	90	90	90	0	0	1	-360	360;
	389	525	0.01198	0.0386	0.00406	90	90	90	0	0	1	-360	360;
	388	402	0.00562	0.0181	0.00191	90	90	90	0	0	1	-360	360;
	812	523	0.0238	0.07215	0.00855	90	90	90	0	0	1	-360	360;
	702	415	0.00388	0.01256	0.00132	90	90	90	0	0	1	-360	360;
	811	589	0.00496	0.01496	0.00177	90	90	90	0	0	1	-360	360;
	397	812	0.00504	0.01521	0.00181	90	90	90	0	0	1	-360	360;
	664	729	0.01628	0.05397	0.00529	90	90	90	0	0	1	-360	360;
	789	337	0.02521	0.08223	0.00841	90	90	90	0	0	1	-360	360;
	599	789	0.00149	0.00471	0.00049	90	90	90	0	0	1	-360	360;
	789	582	0.01702	0.03058	0.00276	58	58	58	0	0	1	-360	360;
	557	543	0.00843	0.0214	0.00218	77	77	77	0	0	1	-360	360;
	658	632	0.0195	0.03545	0.00353	118	118	118	0	0	1	-360	360;
	831	263	0.01361	0.02471	0.00246	58	58	58	0	0	1	-360	360;
	832	481	0.02264	0.03769	0.00397	58	58	58	0	0	1	-360	360;
	810	442	0.01413	0.04653	0.0047	90	90	90	0	0	1	-360	360;
	371	290	0.0044	0.03039	0.00342	208	208	208	0	0	1	-360	360;
	814	635	0.01653	0.05388	0.0055	90	90	90	0	0	1	-360	360;
	810	609	0.01785	0.03273	0.00346	122	122	122	0	0	1	-360	360;
	609	565	0.03033	0.07331	0.00825	122	122	122	0	0	1	-360	360;
	532	565	0.00719	0.01256	0.0012	58	58	58	0	0	1	-360	360;
	809	393	0.01711	0.04364	0.00444	77	77	77	0	0	1	-360	360;
	604	394	0.03124	0.07942	0.00808	77	77	77	0	0	1	-360	360;
	667	620	0.01	0.02628	0.00267	77	77	77	0	0	1	-360	360;
	620	605	0.02802	0.06182	0.00747	77	77	77	0	0	1	-360	360;
	506	378	0.00413	0.01347	0.00139	90	90	90	0	0	1	-360	360;
	510	664	0.02595	0.08512	0.0086	90	90	90	0	0	1	-360	360;
	621	506	0.04041	0.13264	0.01339	90	90	90	0	0	1	-360	360;
	684	622	0.00256	0.00843	0.00087	90	90	90	0	0	1	-360	360;
	364	636	0.01413	0.03727	0.004	58	58	58	0	0	1	-360	360;
	600	663	0.00711	0.01248	0.00119	58	58	58	0	0	1	-360	360;
	665	600	0.00579	0.01174	0.00114	58	58	58	0	0	1	-360	360;
	631	438	0.05455	0.09471	0.00914	58	58	58	0	0	1	-360	360;
	586	507	0.06058	0.10603	0.01006	58	58	58	0	0	1	-360	360;
	599	593	0.00273	0.00785	0.00079	90	90	90	0	0	1	-360	360;
	663	272	0.01198	0.03893	0.00402	90	90	90	0	0	1	-360	360;
	795	543	0.01074	0.03479	0.00359	90	90	90	0	0	1	-360	360;
	795	271	0.00983	0.03198	0.0033	90	90	90	0	0	1	-360	360;
	644	795	0.00785	0.0257	0.00248	90	90	90	0	0	1	-360	360;
	699	668	0.01298	0.04215	0.00436	90	90	90	0	0	1	-360	360;
	304	667	0.00471	0.01529	0.00159	58	58	58	0	0	1	-360	360;
	305	668	0.00744	0.01554	0.00151	58	58	58	0	0	1	-360	360;
	306	667	0.00843	0.01744	0.00169	58	58	58	0	0	1	-360	360;
	307	668	0.00826	0.01719	0.00166	58	58	58	0	0	1	-360	360;
	667	312	0.00314	0.00942	0.00096	77	77	77	0	0	1	-360	360;
	597	528	0.00355	0.02421	0.00271	208	208	208	0	0	1	-360	360;
	527	285	0.01372	0.04446	0.00461	90	90	90	0	0	1	-360	360;
	598	344	0.00164	0.01112	0.00134	208	208	208	0	0	1	-360	360;
	528	248	0.01967	0.0638	0.0066	90	90	90	0	0	1	-360	360;
	288	510	0.00355	0.01157	0.00121	90	90	90	0	0	1	-360	360;
	539	490	0.02868	0.09314	0.00962	90	90	90	0	0	1	-360	360;
	286	249	0.00686	0.02215	0.00229	90	90	90	0	0	1	-360	360;
	557	248	0.02231	0.07248	0.0075	90	90	90	0	0	1	-360	360;
	823	585	0.01471	0.04769	0.00493	90	90	90	0	0	1	-360	360;
	824	607	0.0195	0.06331	0.00654	90	90	90	0	0	1	-360	360;
	817	249	0.02058	0.06694	0.00691	90	90	90	0	0	1	-360	360;
	482	357	0.00851	0.02793	0.00285	90	90	90	0	0	1	-360	360;
	545	542	0.00488	0.01587	0.00164	90	90	90	0	0	1	-360	360;
	631	281	0.00843	0.02769	0.00279	90	90	90	0	0	1	-360	360;
	546	527	0.03529	0.13702	0.01374	90	90	90	0	0	1	-360	360;
	401	665	0.0243	0.07893	0.00815	90	90	90	0	0	1	-360	360;
	528	344	0.00182	0.01273	0.00142	208	208	208	0	0	1	-360	360;
	527	345	0.00174	0.01207	0.00134	208	208	208	0	0	1	-360	360;
	289	314	0.00788	0.05315	0.00589	196	196	196	0	0	1	-360	360;
	597	315	0.00107	0.00719	0.00094	196	196	196	0	0	1	-360	360;
	370	345	0.00256	0.02273	0.00199	208	208	208	0	0	1	-360	360;
	528	336	0.0195	0.06314	0.00654	90	90	90	0	0	1	-360	360;
	280	685	0.0357	0.11719	0.01184	90	90	90	0	0	1	-360	360;
	268	363	0.0443	0.09347	0.00876	58	58	58	0	0	1	-360	360;
	717	668	0.01893	0.06248	0.01932	90	90	90	0	0	1	-360	360;
	448	439	0.01099	0.02322	0.00218	58	58	58	0	0	1	-360	360;
	809	815	0.01215	0.03934	0.00405	90	90	90	0	0	1	-360	360;
	287	489	0.02909	0.09438	0.00976	90	90	90	0	0	1	-360	360;
	264	657	0.03183	0.05769	0.00576	58	58	58	0	0	1	-360	360;
	653	539	0.01983	0.06438	0.00665	90	90	90	0	0	1	-360	360;
	808	718	0.02421	0.07934	0.00803	90	90	90	0	0	1	-360	360;
	807	363	0.02223	0.07281	0.00735	122	122	122	0	0	1	-360	360;
	542	729	0.01289	0.04289	0.0042	90	90	90	0	0	1	-360	360;
	376	358	0.03273	0.0719	0.00681	58	58	58	0	0	1	-360	360;
	536	551	0.00835	0.0262	0.00292	58	58	58	0	0	1	-360	360;
	534	529	0.0076	0.02545	0.00249	90	90	90	0	0	1	-360	360;
	535	492	0.01182	0.03	0.00305	77	77	77	0	0	1	-360	360;
	555	493	0.0162	0.05405	0.00527	90	90	90	0	0	1	-360	360;
	552	349	0.01992	0.06438	0.00667	90	90	90	0	0	1	-360	360;
	782	391	0.01066	0.01868	0.00186	90	90	90	0	0	1	-360	360;
	782	348	0.01587	0.05388	0.00533	90	90	90	0	0	1	-360	360;
	782	626	0.01074	0.03496	0.00361	90	90	90	0	0	1	-360	360;
	417	392	0.02702	0.08744	0.00905	90	90	90	0	0	1	-360	360;
	343	295	0.01909	0.06273	0.00634	90	90	90	0	0	1	-360	360;
	509	343	0.01975	0.06496	0.00656	90	90	90	0	0	1	-360	360;
	637	554	0.02504	0.08223	0.00831	90	90	90	0	0	1	-360	360;
	274	637	0.0076	0.02298	0.00272	90	90	90	0	0	1	-360	360;
	535	326	0.02314	0.07413	0.00785	90	90	90	0	0	1	-360	360;
	587	500	0.03884	0.1276	0.01288	90	90	90	0	0	1	-360	360;
	794	530	0.01835	0.06025	0.00608	90	90	90	0	0	1	-360	360;
	794	564	0.03033	0.09967	0.01006	90	90	90	0	0	1	-360	360;
	643	794	0.00182	0.00603	0.00059	90	90	90	0	0	1	-360	360;
	627	392	0.00975	0.0295	0.00355	90	90	90	0	0	1	-360	360;
	829	391	0.03678	0.0638	0.00623	58	58	58	0	0	1	-360	360;
	660	308	0.0214	0.07157	0.00699	90	90	90	0	0	1	-360	360;
	561	533	0.00198	0.0062	0.00069	90	90	90	0	0	1	-360	360;
	583	533	0.00562	0.01711	0.0018	58	58	58	0	0	1	-360	360;
	350	535	0.00306	0.01	0.00103	90	90	90	0	0	1	-360	360;
	534	495	0.00959	0.03099	0.0032	90	90	90	0	0	1	-360	360;
	554	494	0.01066	0.03463	0.00358	90	90	90	0	0	1	-360	360;
	548	484	0.0043	0.01298	0.00157	90	90	90	0	0	1	-360	360;
	499	294	0.08909	0.17595	0.01535	58	58	58	0	0	1	-360	360;
	825	308	0.03124	0.10421	0.01018	90	90	90	0	0	1	-360	360;
	584	551	0.00479	0.01603	0.00156	90	90	90	0	0	1	-360	360;
	501	775	0.00917	0.03	0.00303	90	90	90	0	0	1	-360	360;
	775	295	0.00678	0.02215	0.00224	90	90	90	0	0	1	-360	360;
	291	775	1e-05	8e-05	0	90	90	90	0	0	1	-360	360;
	392	384	0.01661	0.04298	0.00429	77	77	77	0	0	1	-360	360;
	555	483	0.01132	0.03777	0.00369	90	90	90	0	0	1	-360	360;
	554	535	0.01289	0.04116	0.00443	90	90	90	0	0	1	-360	360;
	588	554	0.04397	0.14529	0.01447	90	90	90	0	0	1	-360	360;
	555	533	0.02455	0.0743	0.00772	77	77	77	0	0	1	-360	360;
	659	450	0.02165	0.0724	0.00706	90	90	90	0	0	1	-360	360;
	739	351	0.04405	0.13372	0.01585	90	90	90	0	0	1	-360	360;
	468	509	0.01826	0.03157	0.00307	58	58	58	0	0	1	-360	360;
	651	327	0.0205	0.06694	0.00684	90	90	90	0	0	1	-360	360;
	826	275	0.03339	0.10124	0.01199	90	90	90	0	0	1	-360	360;
	562	547	0.00273	0.00818	0.00099	90	90	90	0	0	1	-360	360;
	259	251	0.00694	0.02256	0.00231	123	123	123	0	0	1	-360	360;
	277	497	0.05992	0.11628	0.01298	78	78	78	0	0	1	-360	360;
	278	241	0.10041	0.17736	0.01665	78	78	78	0	0	1	-360	360;
	323	260	0.00554	0.01802	0.00167	102	102	102	0	0	1	-360	360;
	352	277	0.05198	0.09	0.00889	69	69	69	0	0	1	-360	360;
	365	261	0.02893	0.08719	0.0105	123	123	123	0	0	1	-360	360;
	706	365	0.03033	0.09124	0.01099	123	123	123	0	0	1	-360	360;
	779	334	0.00635	0.01952	0.00235	123	123	123	0	0	1	-360	360;
	779	320	0.03736	0.06314	0.00687	91	91	91	0	0	1	-360	360;
	779	335	0.00026	0.0004	5e-05	123	123	123	0	0	1	-360	360;
	806	437	0.02694	0.0819	0.0097	123	123	123	0	0	1	-360	360;
	503	430	0.02	0.0338	0.00368	78	78	78	0	0	1	-360	360;
	276	380	0.02702	0.08215	0.00973	123	123	123	0	0	1	-360	360;
	508	318	0.04992	0.08967	0.00898	123	123	123	0	0	1	-360	360;
	650	319	0.00785	0.02388	0.00284	123	123	123	0	0	1	-360	360;
	646	242	0.01102	0.03212	0.00397	123	123	123	0	0	1	-360	360;
	796	260	0.01549	0.03483	0.00343	78	78	78	0	0	1	-360	360;
	299	796	0.02848	0.05104	0.00475	78	78	78	0	0	1	-360	360;
	673	796	0.0002	0.00067	7e-05	123	123	123	0	0	1	-360	360;
	553	300	0.0081	0.01413	0.00135	78	78	78	0	0	1	-360	360;
	303	243	0.07934	0.13074	0.01414	78	78	78	0	0	1	-360	360;
	366	436	0.00397	0.01215	0.00138	123	123	123	0	0	1	-360	360;
	320	317	0.02207	0.04273	0.00416	78	78	78	0	0	1	-360	360;
	623	553	0.03653	0.06372	0.00608	78	78	78	0	0	1	-360	360;
	261	250	0.00264	0.00851	0.00088	123	123	123	0	0	1	-360	360;
	805	767	0.0395	0.06909	0.00656	78	78	78	0	0	1	-360	360;
	768	398	0.03537	0.10331	0.00917	102	102	102	0	0	1	-360	360;
	647	596	0.01975	0.03736	0.00401	78	78	78	0	0	1	-360	360;
	766	319	0.03165	0.09537	0.01148	123	123	123	0	0	1	-360	360;
	544	502	0.04066	0.07066	0.00682	69	69	69	0	0	1	-360	360;
	650	242	0.0414	0.1257	0.01489	123	123	123	0	0	1	-360	360;
	519	473	0.0157	0.04736	0.0057	123	123	123	0	0	1	-360	360;
	381	261	0.02802	0.08446	0.01016	123	123	123	0	0	1	-360	360;
	257	256	0.00347	0.01033	0.00125	123	123	123	0	0	1	-360	360;
	340	325	0.02678	0.0805	0.0097	123	123	123	0	0	1	-360	360;
	628	241	0.0386	0.08364	0.00735	78	78	78	0	0	1	-360	360;
	261	254	0.01157	0.03587	0.00404	123	123	123	0	0	1	-360	360;
	354	325	0.01909	0.06198	0.00644	123	123	123	0	0	1	-360	360;
	508	354	0.06769	0.11901	0.01104	78	78	78	0	0	1	-360	360;
	616	353	0.06107	0.10165	0.01102	78	78	78	0	0	1	-360	360;
	437	431	0.00612	0.0124	0.00117	78	78	78	0	0	1	-360	360;
	696	340	0.05099	0.16893	0.0166	123	123	123	0	0	1	-360	360;
	544	380	0.03124	0.09496	0.01125	123	123	123	0	0	1	-360	360;
	767	297	0.02917	0.07438	0.00774	91	91	91	0	0	1	-360	360;
	324	257	0.00711	0.02256	0.00224	102	102	102	0	0	1	-360	360;
	624	303	0.0576	0.10058	0.0096	78	78	78	0	0	1	-360	360;
	473	381	0.02165	0.04008	0.00386	91	91	91	0	0	1	-360	360;
	333	766	0.01868	0.06198	0.00608	123	123	123	0	0	1	-360	360;
	334	519	0.02678	0.08058	0.0097	123	123	123	0	0	1	-360	360;
	353	596	0.0043	0.01388	0.00144	123	123	123	0	0	1	-360	360;
	457	251	0.03942	0.12033	0.01413	123	123	123	0	0	1	-360	360;
	674	250	0.00818	0.02545	0.00289	123	123	123	0	0	1	-360	360;
	418	352	0.04339	0.07157	0.00774	69	69	69	0	0	1	-360	360;
	418	457	0.01826	0.05537	0.00656	123	123	123	0	0	1	-360	360;
	696	333	0.03446	0.11364	0.01127	123	123	123	0	0	1	-360	360;
	296	768	0.02959	0.09727	0.00971	123	123	123	0	0	1	-360	360;
	496	399	0.02868	0.08818	0.00783	102	102	102	0	0	1	-360	360;
	496	260	0.02545	0.08099	0.00735	102	102	102	0	0	1	-360	360;
	255	496	0.01091	0.04223	0.00465	123	123	123	0	0	1	-360	360;
	252	497	0.01818	0.06595	0.00707	123	123	123	0	0	1	-360	360;
	497	253	0.01926	0.05876	0.00555	123	123	123	0	0	1	-360	360;
	320	276	0.02793	0.08496	0.01006	123	123	123	0	0	1	-360	360;
	706	366	0.02364	0.07149	0.00851	123	123	123	0	0	1	-360	360;
	252	258	0.00223	0.00752	0.00076	123	123	123	0	0	1	-360	360;
	647	645	0.02957	0.08621	0.01064	123	123	123	0	0	1	-360	360;
	791	314	0.00098	0.00423	0.02594	95	95	95	0	0	1	-360	360;
	791	372	0.01639	0.0344	0.02258	40	40	40	0	0	1	-360	360;
	791	346	0.00017	0.00074	0.00757	95	95	95	0	0	1	-360	360;
	373	528	0.01545	0.03008	0.00257	40	40	40	0	0	1	-360	360;
	273	315	0.00165	0.00744	0.10672	95	95	95	0	0	1	-360	360;
	813	372	0.00298	0.0105	0.06292	95	95	95	0	0	1	-360	360;
	369	527	1e-05	0.00017	0.00075	95	95	95	0	0	1	-360	360;
	852	1127	0.03628	0.09421	0.00974	77	77	77	0	0	1	-360	360;
	1069	876	0.03041	0.09893	0.01014	90	90	90	0	0	1	-360	360;
	1037	836	0.02678	0.08653	0.00885	90	90	90	0	0	1	-360	360;
	1123	853	0.02256	0.07289	0.00746	76	76	76	0	0	1	-360	360;
	991	844	0.08678	0.14975	0.01423	58	58	58	0	0	1	-360	360;
	1059	999	0.07207	0.1381	0.01321	58	58	58	0	0	1	-360	360;
	1008	1000	0.05	0.10909	0.0107	58	58	58	0	0	1	-360	360;
	884	881	0.01124	0.02777	0.00276	79	79	79	0	0	1	-360	360;
	1000	998	0.01636	0.05306	0.00542	90	90	90	0	0	1	-360	360;
	993	867	0.04116	0.13289	0.01359	90	90	90	0	0	1	-360	360;
	1007	999	0.02306	0.07157	0.00818	90	90	90	0	0	1	-360	360;
	1007	1000	0.02306	0.07157	0.00818	90	90	90	0	0	1	-360	360;
	1023	942	0.02017	0.06529	0.0067	90	90	90	0	0	1	-360	360;
	1071	851	0.04893	0.12777	0.01321	77	77	77	0	0	1	-360	360;
	874	840	0.03198	0.10347	0.01058	69	69	69	0	0	1	-360	360;
	961	1104	0.03917	0.12669	0.01296	90	90	90	0	0	1	-360	360;
	1068	874	0.03851	0.12463	0.01275	69	69	69	0	0	1	-360	360;
	1122	897	0.0614	0.1986	0.02032	90	90	90	0	0	1	-360	360;
	1018	1017	0.00372	0.00884	0.00067	77	77	77	0	0	1	-360	360;
	1018	871	0.04843	0.08438	0.00809	58	58	58	0	0	1	-360	360;
	1064	833	0.01207	0.03893	0.00402	90	90	90	0	0	1	-360	360;
	1049	871	0.0376	0.06554	0.00624	58	58	58	0	0	1	-360	360;
	1018	920	0.01075	0.0282	0.00291	58	58	58	0	0	1	-360	360;
	988	920	0.0127	0.03297	0.00341	58	58	58	0	0	1	-360	360;
	1020	988	0.03485	0.07019	0.00683	58	58	58	0	0	1	-360	360;
	838	1020	0.01421	0.04603	0.00471	90	90	90	0	0	1	-360	360;
	968	834	0.00562	0.00992	0.00092	58	58	58	0	0	1	-360	360;
	968	963	0.00446	0.00793	0.00075	58	58	58	0	0	1	-360	360;
	967	963	0.00256	0.00826	0.00085	90	90	90	0	0	1	-360	360;
	1110	967	0.01306	0.02165	0.00208	58	58	58	0	0	1	-360	360;
	1110	833	0.01174	0.02025	0.00195	90	90	90	0	0	1	-360	360;
	857	833	0.02562	0.08281	0.00847	90	90	90	0	0	1	-360	360;
	857	854	0.02934	0.09479	0.0097	90	90	90	0	0	1	-360	360;
	1062	959	0.01372	0.05686	0.00567	90	90	90	0	0	1	-360	360;
	1064	1062	0.00298	0.00959	0.00099	90	90	90	0	0	1	-360	360;
	1064	836	0.01884	0.06099	0.00624	90	90	90	0	0	1	-360	360;
	1081	836	0.02512	0.08107	0.0083	90	90	90	0	0	1	-360	360;
	1081	841	0.00413	0.01322	0.00136	90	90	90	0	0	1	-360	360;
	960	945	0.02314	0.06628	0.00678	90	90	90	0	0	1	-360	360;
	945	841	0.00777	0.02512	0.00257	90	90	90	0	0	1	-360	360;
	993	841	0.00355	0.01157	0.0012	90	90	90	0	0	1	-360	360;
	954	959	0.01083	0.01917	0.0018	90	90	90	0	0	1	-360	360;
	969	954	0.00455	0.00802	0.00075	90	90	90	0	0	1	-360	360;
	953	952	0.00124	0.00397	0.00044	90	90	90	0	0	1	-360	360;
	965	952	0.00314	0.01025	0.00105	90	90	90	0	0	1	-360	360;
	960	948	0.03322	0.10752	0.011	120	120	120	0	0	1	-360	360;
	964	946	0.01364	0.04413	0.00452	120	120	120	0	0	1	-360	360;
	959	955	0.01339	0.02686	0.00257	58	58	58	0	0	1	-360	360;
	962	955	0.00463	0.01579	0.00161	120	120	120	0	0	1	-360	360;
	964	962	0.01264	0.04091	0.00418	120	120	120	0	0	1	-360	360;
	960	944	0.01967	0.06364	0.00651	90	90	90	0	0	1	-360	360;
	944	910	0.02826	0.0914	0.00934	90	90	90	0	0	1	-360	360;
	1033	910	0.02182	0.07066	0.00723	90	90	90	0	0	1	-360	360;
	975	850	0.05835	0.09876	0.0106	58	58	58	0	0	1	-360	360;
	850	848	0.0057	0.0186	0.00189	90	90	90	0	0	1	-360	360;
	957	849	0.03322	0.10736	0.01099	120	120	120	0	0	1	-360	360;
	1009	959	0.06372	0.20612	0.02108	90	90	90	0	0	1	-360	360;
	969	834	0.01372	0.04438	0.00454	90	90	90	0	0	1	-360	360;
	966	959	0.0038	0.0286	0.00273	183	183	183	0	0	1	-360	360;
	965	960	0.00231	0.02413	0.00373	148	148	148	0	0	1	-360	360;
	966	834	0.00413	0.03066	0.00293	137	137	137	0	0	1	-360	360;
	947	833	0.00397	0.01298	0.00133	120	120	120	0	0	1	-360	360;
	1105	848	0.03231	0.10438	0.01068	120	120	120	0	0	1	-360	360;
	1105	1104	0.04041	0.13058	0.01336	120	120	120	0	0	1	-360	360;
	947	834	0.00397	0.01281	0.00131	120	120	120	0	0	1	-360	360;
	948	946	0.01306	0.04207	0.00431	120	120	120	0	0	1	-360	360;
	995	853	0.03033	0.0981	0.01004	90	90	90	0	0	1	-360	360;
	1104	1009	0.03793	0.12298	0.01258	90	90	90	0	0	1	-360	360;
	960	955	0.00959	0.03116	0.00318	131	131	131	0	0	1	-360	360;
	957	894	0.02636	0.08521	0.00871	120	120	120	0	0	1	-360	360;
	903	894	0.01917	0.06231	0.00637	120	120	120	0	0	1	-360	360;
	1105	903	0.03066	0.09909	0.01014	120	120	120	0	0	1	-360	360;
	894	849	0.03107	0.10041	0.01029	120	120	120	0	0	1	-360	360;
	1018	906	0.01917	0.06198	0.00634	90	90	90	0	0	1	-360	360;
	838	834	0.02917	0.08074	0.00832	77	77	77	0	0	1	-360	360;
	1019	1020	0.00521	0.01694	0.00173	90	90	90	0	0	1	-360	360;
	995	1019	0.01107	0.03579	0.00366	90	90	90	0	0	1	-360	360;
	882	959	0.02033	0.06562	0.00671	90	90	90	0	0	1	-360	360;
	852	1017	0.00496	0.01339	0.00138	77	77	77	0	0	1	-360	360;
	953	969	0.00107	0.00802	0.00018	90	90	90	0	0	1	-360	360;
	912	853	0.00149	0.00446	0	137	137	137	0	0	1	-360	360;
	1037	867	0.03116	0.05504	0.00515	58	58	58	0	0	1	-360	360;
	987	898	0.00512	0.0124	0.00123	58	58	58	0	0	1	-360	360;
	1038	868	0.03215	0.05504	0.00515	58	58	58	0	0	1	-360	360;
	1038	937	0.01901	0.05116	0.00528	77	77	77	0	0	1	-360	360;
	980	937	0.04579	0.12752	0.01314	77	77	77	0	0	1	-360	360;
	1092	979	0.02463	0.04488	0.00423	58	58	58	0	0	1	-360	360;
	1092	844	0.05818	0.10041	0.00954	58	58	58	0	0	1	-360	360;
	1124	979	0.01017	0.03298	0.00336	90	90	90	0	0	1	-360	360;
	1125	1118	0.00347	0.00901	0.00094	77	77	77	0	0	1	-360	360;
	1125	1124	0.00678	0.0219	0.00222	77	77	77	0	0	1	-360	360;
	1118	980	0.01496	0.04661	0.00475	58	58	58	0	0	1	-360	360;
	1119	1096	0.06347	0.1138	0.0107	58	58	58	0	0	1	-360	360;
	987	943	0.04455	0.14413	0.01475	69	69	69	0	0	1	-360	360;
	1122	980	0.06909	0.12273	0.01151	58	58	58	0	0	1	-360	360;
	867	1112	0.01738	0.03069	0.00288	58	58	58	0	0	1	-360	360;
	868	860	0.01669	0.02975	0.00279	58	58	58	0	0	1	-360	360;
	1028	987	0.04463	0.07884	0.00738	69	69	69	0	0	1	-360	360;
	1028	851	0.03843	0.10074	0.01041	77	77	77	0	0	1	-360	360;
	1023	1027	0.03769	0.1219	0.01247	90	90	90	0	0	1	-360	360;
	972	868	0.0557	0.0995	0.00934	58	58	58	0	0	1	-360	360;
	1107	972	0.04099	0.07364	0.00692	58	58	58	0	0	1	-360	360;
	868	862	0.00793	0.01893	0.00187	58	58	58	0	0	1	-360	360;
	867	865	0.00851	0.02785	0.00285	69	69	69	0	0	1	-360	360;
	870	865	0.00942	0.0305	0.00312	90	90	90	0	0	1	-360	360;
	870	862	0.00785	0.01835	0.0018	58	58	58	0	0	1	-360	360;
	1100	1095	0.02777	0.08975	0.00918	10	10	10	0	0	1	-360	360;
	898	904	0.01083	0.03789	0.00385	68	68	68	0	0	1	-360	360;
	904	1069	0.02378	0.07688	0.00787	90	90	90	0	0	1	-360	360;
	845	844	0.00835	0.02702	0.00277	90	90	90	0	0	1	-360	360;
	1093	845	0.01843	0.0595	0.00608	90	90	90	0	0	1	-360	360;
	1107	961	0.02066	0.06686	0.00684	101	101	101	0	0	1	-360	360;
	887	1118	0.04876	0.15769	0.01613	76	76	76	0	0	1	-360	360;
	886	887	0.0105	0.03306	0.00338	90	90	90	0	0	1	-360	360;
	1021	886	0.02661	0.08603	0.0088	90	90	90	0	0	1	-360	360;
	1099	1021	0.01752	0.05678	0.00581	90	90	90	0	0	1	-360	360;
	1119	1099	0.03752	0.1214	0.01242	90	90	90	0	0	1	-360	360;
	1115	1119	0.04169	0.07362	0.0069	26	26	26	0	0	1	-360	360;
	905	1115	0.027	0.04768	0.00446	10	10	10	0	0	1	-360	360;
	1026	1027	0.0238	0.0538	0.0055	58	58	58	0	0	1	-360	360;
	1022	1026	0.01802	0.03182	0.00298	58	58	58	0	0	1	-360	360;
	1029	1022	0.00165	0.00537	0.00055	58	58	58	0	0	1	-360	360;
	1028	1029	0.01083	0.01917	0.0018	58	58	58	0	0	1	-360	360;
	976	1027	0.01678	0.02959	0.00277	34	34	34	0	0	1	-360	360;
	976	1028	0.01455	0.0257	0.00241	34	34	34	0	0	1	-360	360;
	1095	943	0.08306	0.14868	0.01396	58	58	58	0	0	1	-360	360;
	1096	1095	0.01413	0.02694	0.00257	58	58	58	0	0	1	-360	360;
	1069	1093	0.02638	0.08531	0.00873	122	122	122	0	0	1	-360	360;
	860	1112	0.00021	0.00038	4e-05	58	58	58	0	0	1	-360	360;
	859	1112	0.01843	0.03331	0.00326	58	58	58	0	0	1	-360	360;
	1113	859	0.00026	0.00045	4e-05	58	58	58	0	0	1	-360	360;
	1113	860	0.0001	0.00017	2e-05	58	58	58	0	0	1	-360	360;
	1113	861	0.00148	0.00262	0.00024	58	58	58	0	0	1	-360	360;
	926	1115	3e-05	0.0001	1e-05	16	16	16	0	0	1	-360	360;
	893	839	0.03124	0.10107	0.01034	90	90	90	0	0	1	-360	360;
	1070	951	0.03488	0.11281	0.01154	90	90	90	0	0	1	-360	360;
	951	949	0.00207	0.00661	0.00068	90	90	90	0	0	1	-360	360;
	1060	949	0.01992	0.03711	0.00351	118	118	118	0	0	1	-360	360;
	1087	1048	0.01719	0.0557	0.0057	90	90	90	0	0	1	-360	360;
	1086	991	0.01207	0.02074	0.00198	58	58	58	0	0	1	-360	360;
	1059	1117	0.02938	0.06012	0.00579	58	58	58	0	0	1	-360	360;
	1086	1117	0.02938	0.06012	0.00579	58	58	58	0	0	1	-360	360;
	1091	1117	0.00133	0.00431	0.00044	58	58	58	0	0	1	-360	360;
	1087	883	0.04521	0.07926	0.0064	58	58	58	0	0	1	-360	360;
	883	877	0.01306	0.02455	0.00198	58	58	58	0	0	1	-360	360;
	1008	877	0.04455	0.08926	0.00679	58	58	58	0	0	1	-360	360;
	876	1048	0.02207	0.07124	0.00729	90	90	90	0	0	1	-360	360;
	971	970	0.00876	0.01455	0.00152	58	58	58	0	0	1	-360	360;
	1090	1086	0.01248	0.03438	0.00347	58	58	58	0	0	1	-360	360;
	996	863	0.03215	0.08398	0.00837	58	58	58	0	0	1	-360	360;
	971	863	0.01083	0.01909	0.00166	58	58	58	0	0	1	-360	360;
	971	864	0.01124	0.01975	0.00173	58	58	58	0	0	1	-360	360;
	1053	1050	0.02264	0.07314	0.00748	90	90	90	0	0	1	-360	360;
	1087	840	0.1362	0.23512	0.02235	58	58	58	0	0	1	-360	360;
	1052	840	0.00612	0.01992	0.00204	90	90	90	0	0	1	-360	360;
	1057	840	0.00463	0.01479	0.0016	90	90	90	0	0	1	-360	360;
	1057	1051	0.00744	0.02405	0.00247	90	90	90	0	0	1	-360	360;
	1051	1041	0.00322	0.0105	0.00109	90	90	90	0	0	1	-360	360;
	1058	1053	0.02108	0.06817	0.00697	90	90	90	0	0	1	-360	360;
	1054	908	0.00967	0.03149	0.00322	90	90	90	0	0	1	-360	360;
	989	908	0.04545	0.08091	0.00757	58	58	58	0	0	1	-360	360;
	989	864	0.02628	0.04694	0.0044	58	58	58	0	0	1	-360	360;
	1025	971	0.01091	0.01926	0.0018	58	58	58	0	0	1	-360	360;
	1011	884	0.03521	0.07645	0.00743	90	90	90	0	0	1	-360	360;
	1077	1012	0.0224	0.0724	0.00741	90	90	90	0	0	1	-360	360;
	1012	981	0.02132	0.06595	0.00671	90	90	90	0	0	1	-360	360;
	981	864	0.07694	0.13256	0.01263	58	58	58	0	0	1	-360	360;
	1066	840	0.03182	0.07959	0.00806	76	76	76	0	0	1	-360	360;
	1066	1042	0.00917	0.02289	0.00232	76	76	76	0	0	1	-360	360;
	1088	839	0.02355	0.07562	0.00782	90	90	90	0	0	1	-360	360;
	1088	932	0.02223	0.0714	0.00738	90	90	90	0	0	1	-360	360;
	929	837	0.02207	0.05917	0.00611	76	76	76	0	0	1	-360	360;
	1067	837	0.02537	0.06736	0.00695	76	76	76	0	0	1	-360	360;
	950	1067	0.01405	0.03645	0.00377	123	123	123	0	0	1	-360	360;
	931	885	0.02074	0.06702	0.00686	90	90	90	0	0	1	-360	360;
	879	885	0.00967	0.0262	0.00263	58	58	58	0	0	1	-360	360;
	990	879	0.0062	0.02	0.00204	58	58	58	0	0	1	-360	360;
	1094	863	0.01579	0.05107	0.00523	90	90	90	0	0	1	-360	360;
	1056	1036	0.00174	0.00562	0.00058	90	90	90	0	0	1	-360	360;
	1101	1072	0.02058	0.03628	0.00339	131	131	131	0	0	1	-360	360;
	1120	1101	0.02802	0.0905	0.00924	90	90	90	0	0	1	-360	360;
	1120	1067	0.00868	0.01537	0.00143	58	58	58	0	0	1	-360	360;
	1054	839	0.03306	0.10686	0.01094	90	90	90	0	0	1	-360	360;
	1087	897	0.03298	0.10669	0.01091	90	90	90	0	0	1	-360	360;
	996	1090	0.02066	0.06678	0.00683	58	58	58	0	0	1	-360	360;
	1094	892	0.01479	0.04769	0.00488	90	90	90	0	0	1	-360	360;
	1097	892	0.00744	0.01314	0.00123	58	58	58	0	0	1	-360	360;
	1097	883	0.00826	0.01463	0.00137	58	58	58	0	0	1	-360	360;
	1083	1067	0.00256	0.00818	0.00083	90	90	90	0	0	1	-360	360;
	970	864	0.00529	0.01686	0.00173	90	90	90	0	0	1	-360	360;
	1054	942	0.03893	0.12595	0.01288	90	90	90	0	0	1	-360	360;
	1002	1025	0.02157	0.04744	0.00462	58	58	58	0	0	1	-360	360;
	1002	1011	0.02967	0.06636	0.00649	58	58	58	0	0	1	-360	360;
	942	893	0.00983	0.03182	0.00325	90	90	90	0	0	1	-360	360;
	1054	1036	0.02438	0.07802	0.00807	90	90	90	0	0	1	-360	360;
	1041	1036	0.01777	0.05736	0.00587	90	90	90	0	0	1	-360	360;
	1077	884	0.00818	0.02645	0.00271	90	90	90	0	0	1	-360	360;
	929	858	0.0124	0.05413	0.00675	90	90	90	0	0	1	-360	360;
	1083	1068	0.00636	0.02058	0.0021	90	90	90	0	0	1	-360	360;
	858	837	0.01793	0.05802	0.00593	90	90	90	0	0	1	-360	360;
	927	931	0.00149	0.00264	0.00025	58	58	58	0	0	1	-360	360;
	930	927	0.00058	0.0019	0.00019	131	131	131	0	0	1	-360	360;
	1123	1087	0.02868	0.09281	0.00949	58	58	58	0	0	1	-360	360;
	835	1008	0.0157	0.05074	0.00519	90	90	90	0	0	1	-360	360;
	919	1002	0.02132	0.06893	0.00705	90	90	90	0	0	1	-360	360;
	1076	1052	0.00818	0.02653	0.00271	90	90	90	0	0	1	-360	360;
	934	930	0.01149	0.02967	0.00301	58	58	58	0	0	1	-360	360;
	880	990	0.0062	0.02	0.00204	90	90	90	0	0	1	-360	360;
	998	919	0.0181	0.05851	0.00599	90	90	90	0	0	1	-360	360;
	928	934	0.0057	0.01603	0.00165	76	76	76	0	0	1	-360	360;
	1071	950	0.01917	0.04983	0.00516	123	123	123	0	0	1	-360	360;
	1070	1053	0.02306	0.07463	0.00764	90	90	90	0	0	1	-360	360;
	1060	876	0.00016	0.0005	5e-05	121	121	121	0	0	1	-360	360;
	843	990	0.03025	0.05931	0.00567	58	58	58	0	0	1	-360	360;
	928	895	0.01359	0.04394	0.0045	121	121	121	0	0	1	-360	360;
	1086	888	0.00107	0.00626	0.00059	76	76	76	0	0	1	-360	360;
	890	1114	0.00223	0.00678	0	120	120	120	0	0	1	-360	360;
	889	1114	0.00207	0.00612	0	120	120	120	0	0	1	-360	360;
	1087	889	0.00174	0.00564	0.00058	76	76	76	0	0	1	-360	360;
	984	1011	0.04561	0.13862	0.01402	58	58	58	0	0	1	-360	360;
	981	985	0.01031	0.02002	0.00191	58	58	58	0	0	1	-360	360;
	984	985	0.00349	0.01126	0.00115	90	90	90	0	0	1	-360	360;
	901	931	0.00876	0.02636	0	137	137	137	0	0	1	-360	360;
	1076	1050	0.00372	0.0119	0.00121	90	90	90	0	0	1	-360	360;
	933	930	0.00033	0.00116	0	137	137	137	0	0	1	-360	360;
	1040	990	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	958	942	0.00041	0.00126	0	137	137	137	0	0	1	-360	360;
	891	888	0.00099	0.00298	0	137	137	137	0	0	1	-360	360;
	1056	1058	0.0064	0.02069	0.00212	90	90	90	0	0	1	-360	360;
	1127	1043	0.0519	0.1314	0.01312	103	103	103	0	0	1	-360	360;
	1046	1044	0.01521	0.02562	0.00245	79	79	79	0	0	1	-360	360;
	1046	1045	0.00851	0.01438	0.00155	79	79	79	0	0	1	-360	360;
	1045	1016	0.02702	0.0876	0.009	120	120	120	0	0	1	-360	360;
	1015	941	0.01851	0.06	0.00614	120	120	120	0	0	1	-360	360;
	941	923	0.01372	0.04446	0.00454	120	120	120	0	0	1	-360	360;
	1043	1034	0.02289	0.0519	0.00506	79	79	79	0	0	1	-360	360;
	1047	1034	0.02521	0.05744	0.00561	79	79	79	0	0	1	-360	360;
	1047	1039	0.00579	0.00992	0.00105	120	120	120	0	0	1	-360	360;
	902	872	0.01777	0.05736	0.00587	120	120	120	0	0	1	-360	360;
	923	872	0.02058	0.06612	0.00686	120	120	120	0	0	1	-360	360;
	1043	866	0.00901	0.03107	0.00298	120	120	120	0	0	1	-360	360;
	1024	866	0.02397	0.08322	0.00799	120	120	120	0	0	1	-360	360;
	1035	1024	0.02322	0.07521	0.0077	120	120	120	0	0	1	-360	360;
	1111	1063	0.00884	0.01488	0.0015	79	79	79	0	0	1	-360	360;
	1078	1043	0.05331	0.13339	0.01064	103	103	103	0	0	1	-360	360;
	1044	896	0.04066	0.11116	0.01147	103	103	103	0	0	1	-360	360;
	1085	896	0.02777	0.07769	0.00801	103	103	103	0	0	1	-360	360;
	1085	1079	0.00289	0.00777	0.0008	103	103	103	0	0	1	-360	360;
	846	1079	0.04	0.06182	0.00676	79	79	79	0	0	1	-360	360;
	1074	847	0.03826	0.06562	0.01263	79	79	79	0	0	1	-360	360;
	1074	935	0.02893	0.04975	0.00953	79	79	79	0	0	1	-360	360;
	936	935	0.00413	0.00711	0.00137	79	79	79	0	0	1	-360	360;
	1079	999	0.06909	0.1238	0.01008	79	79	79	0	0	1	-360	360;
	1078	921	0.03992	0.06793	0.00543	79	79	79	0	0	1	-360	360;
	1006	921	0.01281	0.02182	0.00175	79	79	79	0	0	1	-360	360;
	1006	1000	0.01322	0.0343	0.00329	79	79	79	0	0	1	-360	360;
	999	956	0.03132	0.1014	0.01038	120	120	120	0	0	1	-360	360;
	1004	1003	0.00033	0.00058	0.0242	274	274	274	0	0	1	-360	360;
	872	842	0.01628	0.05273	0.00541	120	120	120	0	0	1	-360	360;
	1102	922	0.03471	0.11256	0.01158	120	120	120	0	0	1	-360	360;
	1102	978	0.01512	0.05132	0.00251	120	120	120	0	0	1	-360	360;
	978	878	0.0295	0.05182	0.00488	120	120	120	0	0	1	-360	360;
	1089	846	0.01025	0.0181	0.0017	79	79	79	0	0	1	-360	360;
	1108	1089	0.03124	0.05512	0.00516	79	79	79	0	0	1	-360	360;
	1108	925	0.02446	0.04322	0.00405	79	79	79	0	0	1	-360	360;
	983	925	0.05736	0.10083	0.00949	79	79	79	0	0	1	-360	360;
	997	982	0.01364	0.07041	0.00728	120	120	120	0	0	1	-360	360;
	911	925	0.00306	0.00983	0.00101	120	120	120	0	0	1	-360	360;
	915	914	0.00446	0.01455	0.00148	120	120	120	0	0	1	-360	360;
	1031	914	0.01405	0.04537	0.00465	120	120	120	0	0	1	-360	360;
	916	925	0.0076	0.02455	0.00252	120	120	120	0	0	1	-360	360;
	940	916	0.00446	0.01388	0.00143	120	120	120	0	0	1	-360	360;
	924	940	0.0057	0.01851	0.00189	120	120	120	0	0	1	-360	360;
	1031	982	0.02198	0.06843	0.00702	120	120	120	0	0	1	-360	360;
	1106	1032	0.0162	0.02843	0.00269	79	79	79	0	0	1	-360	360;
	1106	900	0.03917	0.06603	0.00396	79	79	79	0	0	1	-360	360;
	899	900	0.00959	0.02017	0.00196	79	79	79	0	0	1	-360	360;
	1032	986	0.00967	0.03157	0.00322	120	120	120	0	0	1	-360	360;
	986	869	0.04777	0.09058	0.00862	79	79	79	0	0	1	-360	360;
	1061	869	0.02273	0.04661	0.0045	79	79	79	0	0	1	-360	360;
	1061	855	0.02463	0.05959	0.00496	79	79	79	0	0	1	-360	360;
	856	855	0.0057	0.01851	0.00189	79	79	79	0	0	1	-360	360;
	1127	956	0.04719	0.08521	0.00803	79	79	79	0	0	1	-360	360;
	1034	1030	0.00777	0.01686	0.00165	79	79	79	0	0	1	-360	360;
	1055	1044	0.01686	0.02983	0.00281	79	79	79	0	0	1	-360	360;
	1055	1030	0.00355	0.00628	0.00542	79	79	79	0	0	1	-360	360;
	1126	846	0.00587	0.01033	0.00097	79	79	79	0	0	1	-360	360;
	1126	1073	0.0038	0.0124	0.00127	120	120	120	0	0	1	-360	360;
	1073	1010	0.00405	0.01298	0.00133	120	120	120	0	0	1	-360	360;
	1035	873	0.00355	0.01157	0.00119	120	120	120	0	0	1	-360	360;
	1084	856	0.01777	0.0576	0.00589	79	79	79	0	0	1	-360	360;
	881	1084	0.01777	0.0576	0.00589	79	79	79	0	0	1	-360	360;
	1014	855	0.02174	0.03835	0.00359	79	79	79	0	0	1	-360	360;
	1014	1116	0.01719	0.05562	0.00568	120	120	120	0	0	1	-360	360;
	1116	939	0.01719	0.05562	0.00568	120	120	120	0	0	1	-360	360;
	977	842	0.02074	0.06727	0.00688	120	120	120	0	0	1	-360	360;
	938	936	0.00157	0.00306	0.00029	79	79	79	0	0	1	-360	360;
	1063	1044	0.03826	0.06752	0.00633	79	79	79	0	0	1	-360	360;
	1078	994	0.02488	0.07223	0.00824	120	120	120	0	0	1	-360	360;
	1014	918	0.01521	0.04901	0.00502	120	120	120	0	0	1	-360	360;
	1111	1075	0.00041	0.0119	0.00122	120	120	120	0	0	1	-360	360;
	1010	1075	0.00281	0.00901	0.00092	120	120	120	0	0	1	-360	360;
	1032	907	0.02289	0.07413	0.00758	120	120	120	0	0	1	-360	360;
	1015	1016	0.01934	0.06264	0.00641	120	120	120	0	0	1	-360	360;
	915	911	0.00455	0.01471	0.0015	120	120	120	0	0	1	-360	360;
	899	1065	0.03488	0.06488	0.00614	79	79	79	0	0	1	-360	360;
	1039	902	0.02099	0.06785	0.00694	120	120	120	0	0	1	-360	360;
	907	924	0.01083	0.03512	0.00359	120	120	120	0	0	1	-360	360;
	875	1116	0.01917	0.05959	0.0061	120	120	120	0	0	1	-360	360;
	1085	1013	0.004	0.01038	0.00107	103	103	103	0	0	1	-360	360;
	917	925	0.0023	0.00744	0.00076	120	120	120	0	0	1	-360	360;
	913	917	0.00144	0.00464	0.00047	120	120	120	0	0	1	-360	360;
	925	913	0.00184	0.00597	0.00061	120	120	120	0	0	1	-360	360;
	1001	999	0.01074	0.03473	0.00355	120	120	120	0	0	1	-360	360;
	1005	1001	0.00223	0.00722	0.00074	120	120	120	0	0	1	-360	360;
	999	1005	0.00328	0.0106	0.00108	120	120	120	0	0	1	-360	360;
	1103	1043	0.0124	0.03603	0	137	137	137	0	0	1	-360	360;
	1121	1078	0.01818	0.05463	0	137	137	137	0	0	1	-360	360;
	1082	1078	0.00331	0.00992	0	137	137	137	0	0	1	-360	360;
	1080	1078	0.00058	0.00165	0	137	137	137	0	0	1	-360	360;
	973	982	0.00661	0.0181	0	137	137	137	0	0	1	-360	360;
	973	982	0.00661	0.01835	0	137	137	137	0	0	1	-360	360;
	992	1031	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	992	1031	0.00207	0.00628	0	137	137	137	0	0	1	-360	360;
	1098	1031	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	1098	1031	0.00496	0.01545	0	137	137	137	0	0	1	-360	360;
	909	922	0.00025	0.00066	0	137	137	137	0	0	1	-360	360;
	2166	1574	0.02645	0.08314	0.00914	62	62	62	0	0	1	-360	360;
	1573	1574	0.00298	0.00926	0.00104	62	62	62	0	0	1	-360	360;
	1272	1800	0.03612	0.04438	0.00878	39	39	39	0	0	1	-360	360;
	1271	1272	0	8e-05	1e-05	29	29	29	0	0	1	-360	360;
	1305	1274	0.0162	0.04917	0.00584	62	62	62	0	0	1	-360	360;
	1304	1305	0.00017	0.00025	4e-05	39	39	39	0	0	1	-360	360;
	1309	1665	0.01653	0.0476	0.0062	62	62	62	0	0	1	-360	360;
	1308	1309	0.0005	0.0014	0.00018	114	114	114	0	0	1	-360	360;
	1439	1188	0.03868	0.10116	0.0108	50	50	50	0	0	1	-360	360;
	1910	1653	0.00537	0.01736	0.00181	75	75	75	0	0	1	-360	360;
	1189	1910	0.03909	0.09719	0.01033	50	50	50	0	0	1	-360	360;
	1909	1910	8e-05	0.00017	2e-05	63	63	63	0	0	1	-360	360;
	1630	1546	0.01595	0.04132	0.00403	50	50	50	0	0	1	-360	360;
	2025	1630	0.03174	0.08347	0.00816	50	50	50	0	0	1	-360	360;
	1628	1630	0.0005	0.00107	0.00014	29	29	29	0	0	1	-360	360;
	1631	1545	0.01595	0.0414	0.00404	50	50	50	0	0	1	-360	360;
	2026	1631	0.03174	0.08347	0.00816	50	50	50	0	0	1	-360	360;
	1629	1631	0.0005	0.00116	0.00014	29	29	29	0	0	1	-360	360;
	2192	1940	0.04826	0.12198	0.0129	50	50	50	0	0	1	-360	360;
	1939	1602	0.04017	0.10537	0.01188	50	50	50	0	0	1	-360	360;
	1302	1172	0.01165	0.03653	0.00401	62	62	62	0	0	1	-360	360;
	1301	1171	0.01165	0.03653	0.00401	62	62	62	0	0	1	-360	360;
	1514	1942	0.00273	0.00876	0.0009	105	105	105	0	0	1	-360	360;
	1656	1514	0.0076	0.02355	0.00263	105	105	105	0	0	1	-360	360;
	1513	1514	0.00033	0.00041	9e-05	39	39	39	0	0	1	-360	360;
	1186	1721	0.01818	0.04521	0.0048	51	51	51	0	0	1	-360	360;
	2167	1186	0.02603	0.06471	0.00687	51	51	51	0	0	1	-360	360;
	1565	1722	0.01736	0.04893	0.00504	51	51	51	0	0	1	-360	360;
	1866	1503	0.00686	0.02215	0.00232	75	75	75	0	0	1	-360	360;
	1344	1866	0.0043	0.01347	0.00147	105	105	105	0	0	1	-360	360;
	1656	1344	0.00579	0.01785	0.00204	105	105	105	0	0	1	-360	360;
	1865	1866	0.00603	0.01744	0.0023	105	105	105	0	0	1	-360	360;
	1344	1343	0.00231	0.00273	0.00058	39	39	39	0	0	1	-360	360;
	2019	1263	0.00504	0.01562	0.00173	75	75	75	0	0	1	-360	360;
	1658	2019	0.01025	0.03198	0.00354	62	62	62	0	0	1	-360	360;
	2019	2017	0.00521	0.00884	0.00089	47	47	47	0	0	1	-360	360;
	2020	1264	0.00504	0.01562	0.00173	75	75	75	0	0	1	-360	360;
	1658	2020	0.01025	0.03198	0.00354	62	62	62	0	0	1	-360	360;
	2020	2018	0.00521	0.00884	0.00089	47	47	47	0	0	1	-360	360;
	2192	1669	0.04017	0.06455	0.0076	39	39	39	0	0	1	-360	360;
	1984	1608	0.02256	0.05818	0.00621	51	51	51	0	0	1	-360	360;
	1983	2159	0.01876	0.04876	0.00519	51	51	51	0	0	1	-360	360;
	1622	1477	0.01463	0.04661	0.00496	62	62	62	0	0	1	-360	360;
	1900	1622	0.00628	0.02	0.00213	75	75	75	0	0	1	-360	360;
	1622	1620	0.00438	0.0086	0.00086	47	47	47	0	0	1	-360	360;
	1623	1219	0.00628	0.01983	0.00216	75	75	75	0	0	1	-360	360;
	2074	1623	0.00504	0.01537	0.00179	75	75	75	0	0	1	-360	360;
	1623	1621	0.00438	0.0086	0.00086	47	47	47	0	0	1	-360	360;
	1658	1128	0.01248	0.04595	0.00524	75	75	75	0	0	1	-360	360;
	1657	1129	0.01248	0.04595	0.00524	75	75	75	0	0	1	-360	360;
	1730	1295	0.00223	0.00826	0.00099	70	70	70	0	0	1	-360	360;
	1280	1296	0.00413	0.01587	0.00183	70	70	70	0	0	1	-360	360;
	1658	1280	0.00488	0.01678	0.00193	62	62	62	0	0	1	-360	360;
	1280	1279	0.00124	0.00421	0.00059	70	70	70	0	0	1	-360	360;
	1706	1530	0.00554	0.01702	0.00195	75	75	75	0	0	1	-360	360;
	1772	1642	0.04174	0.05868	0.01088	39	39	39	0	0	1	-360	360;
	1802	2087	0.00397	0.01124	0.00151	62	62	62	0	0	1	-360	360;
	1977	2171	0.01587	0.04496	0.00605	62	62	62	0	0	1	-360	360;
	1298	1977	0.02157	0.06124	0.00825	62	62	62	0	0	1	-360	360;
	1976	1977	0.0024	0.00686	0.00091	62	62	62	0	0	1	-360	360;
	1747	2079	0.0024	0.00744	0.00084	75	75	75	0	0	1	-360	360;
	1694	1594	0.0105	0.02983	0.00402	62	62	62	0	0	1	-360	360;
	1520	1757	0.02496	0.03802	0.00491	39	39	39	0	0	1	-360	360;
	1358	1278	0.01083	0.02364	0.00345	63	63	63	0	0	1	-360	360;
	2054	1810	0.00835	0.02339	0.0032	63	63	63	0	0	1	-360	360;
	1411	1739	0.02826	0.0924	0.00933	99	99	99	0	0	1	-360	360;
	1805	1739	0.03488	0.0881	0.01298	51	51	51	0	0	1	-360	360;
	1898	1614	0.00818	0.01364	0.00324	63	63	63	0	0	1	-360	360;
	2059	1252	0.02099	0.05934	0.00803	62	62	62	0	0	1	-360	360;
	2058	1637	0.03826	0.04818	0.00455	33	33	33	0	0	1	-360	360;
	1641	1546	0.02926	0.0514	0.00489	39	39	39	0	0	1	-360	360;
	2193	1292	0.01959	0.04818	0.00609	39	39	39	0	0	1	-360	360;
	1792	1568	0.02182	0.06149	0.00827	39	39	39	0	0	1	-360	360;
	1874	1568	0.03628	0.06727	0.00769	39	39	39	0	0	1	-360	360;
	2111	1302	0.01992	0.06157	0.00695	62	62	62	0	0	1	-360	360;
	1508	1301	0.00777	0.02397	0.00275	62	62	62	0	0	1	-360	360;
	1136	2112	0.0476	0.05091	0.00542	27	27	27	0	0	1	-360	360;
	1301	1998	0.05256	0.13264	0.01406	51	51	51	0	0	1	-360	360;
	2190	1230	0.03264	0.08	0.00928	51	51	51	0	0	1	-360	360;
	1166	1512	0.02372	0.03132	0.00624	39	39	39	0	0	1	-360	360;
	1472	2022	0.00835	0.02669	0.0028	62	62	62	0	0	1	-360	360;
	1303	1472	0.01992	0.06488	0.00659	62	62	62	0	0	1	-360	360;
	1471	1472	0.00099	0.00298	0.00039	62	62	62	0	0	1	-360	360;
	1998	1521	0.01355	0.03835	0.00516	62	62	62	0	0	1	-360	360;
	1505	1258	0.00537	0.01686	0.00187	62	62	62	0	0	1	-360	360;
	1796	1955	0.02025	0.06612	0.00668	62	62	62	0	0	1	-360	360;
	2046	2113	0.03727	0.12074	0.01246	62	62	62	0	0	1	-360	360;
	2047	1250	0.01876	0.05926	0.00642	62	62	62	0	0	1	-360	360;
	1860	1695	0.01587	0.05182	0.00527	62	62	62	0	0	1	-360	360;
	1506	1171	0.00678	0.02132	0.00234	62	62	62	0	0	1	-360	360;
	1498	1172	0.01529	0.04917	0.00517	62	62	62	0	0	1	-360	360;
	2172	1171	0.00686	0.02207	0.00229	62	62	62	0	0	1	-360	360;
	2173	1172	0.00686	0.02215	0.0023	62	62	62	0	0	1	-360	360;
	2057	2097	0.05306	0.2314	0.02446	62	62	62	0	0	1	-360	360;
	1368	2096	0.04909	0.21488	0.02272	62	62	62	0	0	1	-360	360;
	1850	1736	0.03438	0.11107	0.01156	99	99	99	0	0	1	-360	360;
	1417	1393	0.0005	0.00091	8e-05	39	39	39	0	0	1	-360	360;
	1421	1417	0.00413	0.00669	0.00073	39	39	39	0	0	1	-360	360;
	2166	1421	0.00413	0.00711	0.0007	39	39	39	0	0	1	-360	360;
	1415	1417	0.00116	0.00207	0.0002	39	39	39	0	0	1	-360	360;
	1419	1421	8e-05	0.00025	3e-05	62	62	62	0	0	1	-360	360;
	1273	1143	0.01736	0.04694	0.00667	51	51	51	0	0	1	-360	360;
	1561	1564	0.00661	0.01504	0.00192	51	51	51	0	0	1	-360	360;
	1670	1427	0.02661	0.03248	0.00676	39	39	39	0	0	1	-360	360;
	2166	1501	0.03165	0.05521	0.01258	51	51	51	0	0	1	-360	360;
	2167	1426	0.04545	0.05331	0.01145	39	39	39	0	0	1	-360	360;
	1541	1142	0.00298	0.00909	0.00104	62	62	62	0	0	1	-360	360;
	1818	1561	0.01347	0.04388	0.00447	62	62	62	0	0	1	-360	360;
	1191	1531	0.00818	0.02537	0.00287	62	62	62	0	0	1	-360	360;
	1580	1502	0.02041	0.03645	0.00807	51	51	51	0	0	1	-360	360;
	1920	1422	8e-05	0.00083	1e-05	39	39	39	0	0	1	-360	360;
	2167	1920	0.00653	0.01116	0.0011	39	39	39	0	0	1	-360	360;
	1920	1919	0.00017	0.00025	3e-05	39	39	39	0	0	1	-360	360;
	1420	1423	0.00256	0.00438	0.00044	39	39	39	0	0	1	-360	360;
	2166	1420	0.00405	0.00694	0.00069	39	39	39	0	0	1	-360	360;
	1418	1420	0.00074	0.00223	0.00029	62	62	62	0	0	1	-360	360;
	1416	1143	0.01091	0.02066	0.00319	39	39	39	0	0	1	-360	360;
	1392	1416	0.00041	0.00074	7e-05	39	39	39	0	0	1	-360	360;
	1414	1416	0.00124	0.00207	0.00021	39	39	39	0	0	1	-360	360;
	2228	1142	0.00455	0.00802	0.00081	39	39	39	0	0	1	-360	360;
	2229	1143	0.00455	0.00802	0.00081	39	39	39	0	0	1	-360	360;
	1986	1142	0.00413	0.01058	0.0018	62	62	62	0	0	1	-360	360;
	1531	2048	0.00678	0.01149	0.00116	29	29	29	0	0	1	-360	360;
	1532	2049	0.00678	0.01149	0.00116	57	57	57	0	0	1	-360	360;
	1883	1725	0.03702	0.0595	0.00702	39	39	39	0	0	1	-360	360;
	1859	1726	0.01488	0.02661	0.00302	39	39	39	0	0	1	-360	360;
	2227	1595	0.01909	0.05413	0.00729	62	62	62	0	0	1	-360	360;
	2166	1425	0.00702	0.01529	0.0018	39	39	39	0	0	1	-360	360;
	1424	1142	0.01083	0.03074	0.00411	62	62	62	0	0	1	-360	360;
	1933	1143	0.0086	0.02438	0.00328	62	62	62	0	0	1	-360	360;
	1997	1579	0.02835	0.05174	0.01048	51	51	51	0	0	1	-360	360;
	2226	1997	0.0086	0.02438	0.00328	62	62	62	0	0	1	-360	360;
	1996	1979	0.0157	0.04471	0.00602	62	62	62	0	0	1	-360	360;
	2028	1793	0.01479	0.02455	0.00298	39	39	39	0	0	1	-360	360;
	2183	1562	0.00388	0.00653	0.00153	51	51	51	0	0	1	-360	360;
	1669	1612	0.0119	0.03397	0.00451	62	62	62	0	0	1	-360	360;
	1613	1185	0.00884	0.02504	0.00337	62	62	62	0	0	1	-360	360;
	2027	1291	0.02678	0.05975	0.00764	39	39	39	0	0	1	-360	360;
	1873	1817	0.03198	0.10364	0.01064	62	62	62	0	0	1	-360	360;
	1562	1509	0.03612	0.1176	0.01195	62	62	62	0	0	1	-360	360;
	2166	1946	0.02388	0.07802	0.00788	62	62	62	0	0	1	-360	360;
	2182	1542	0.02289	0.03901	0.00908	51	51	51	0	0	1	-360	360;
	1241	1532	0	8e-05	1e-05	51	51	51	0	0	1	-360	360;
	2166	1241	0.01083	0.03132	0.00333	51	51	51	0	0	1	-360	360;
	1240	1241	0.0095	0.03116	0.00315	62	62	62	0	0	1	-360	360;
	2166	1190	0.0043	0.01322	0.00152	62	62	62	0	0	1	-360	360;
	1566	2167	0.04058	0.10669	0.01117	51	51	51	0	0	1	-360	360;
	2167	1884	0.01752	0.03033	0.00327	39	39	39	0	0	1	-360	360;
	1949	1934	0.00314	0.00884	0.00119	62	62	62	0	0	1	-360	360;
	1947	1949	0	8e-05	1e-05	62	62	62	0	0	1	-360	360;
	1948	1949	0	8e-05	1e-05	62	62	62	0	0	1	-360	360;
	1532	1985	0.00554	0.01339	0.00257	62	62	62	0	0	1	-360	360;
	1756	1859	0.00215	0.00603	0.00063	39	39	39	0	0	1	-360	360;
	1563	1531	0.0181	0.0419	0.00515	51	51	51	0	0	1	-360	360;
	1247	1142	0.00545	0.01785	0.0018	62	62	62	0	0	1	-360	360;
	1248	1143	0.00545	0.01785	0.0018	62	62	62	0	0	1	-360	360;
	1547	1224	0.01901	0.06017	0.00654	62	62	62	0	0	1	-360	360;
	2208	1223	0.00504	0.01438	0.00192	62	62	62	0	0	1	-360	360;
	1548	1139	0.01421	0.02306	0.00276	39	39	39	0	0	1	-360	360;
	1225	2003	0.02157	0.06926	0.00705	51	51	51	0	0	1	-360	360;
	1586	1518	0.01545	0.05058	0.00511	62	62	62	0	0	1	-360	360;
	2127	1586	0.01223	0.02818	0.00432	51	51	51	0	0	1	-360	360;
	1335	1226	0.00231	0.00653	0.00069	51	51	51	0	0	1	-360	360;
	1972	1312	0.02529	0.04041	0.00662	78	78	78	0	0	1	-360	360;
	2175	1735	0.00149	0.00488	0.0005	114	114	114	0	0	1	-360	360;
	2120	2175	0.01322	0.02975	0.00356	78	78	78	0	0	1	-360	360;
	2003	2119	0.00818	0.02364	0.0031	114	114	114	0	0	1	-360	360;
	2235	2033	0.00901	0.01421	0.0017	39	39	39	0	0	1	-360	360;
	1717	1615	0.00331	0.00744	0.00096	51	51	51	0	0	1	-360	360;
	1733	1134	0.00471	0.01331	0.00179	62	62	62	0	0	1	-360	360;
	1336	1719	0.00298	0.00612	0.00103	51	51	51	0	0	1	-360	360;
	2023	1587	0.01587	0.04314	0.00429	51	51	51	0	0	1	-360	360;
	2055	2002	0.02612	0.03058	0.00657	39	39	39	0	0	1	-360	360;
	2128	1135	0.00413	0.01165	0.00158	62	62	62	0	0	1	-360	360;
	1313	1587	0.00851	0.0257	0.00309	62	62	62	0	0	1	-360	360;
	1804	2003	0.00281	0.00893	0.00097	62	62	62	0	0	1	-360	360;
	1517	1875	0.01033	0.03165	0.00366	62	62	62	0	0	1	-360	360;
	2191	1302	0.02058	0.05215	0.006	51	51	51	0	0	1	-360	360;
	1537	1303	0.00463	0.00777	0.00186	51	51	51	0	0	1	-360	360;
	2122	1876	0.01917	0.0624	0.00638	62	62	62	0	0	1	-360	360;
	1141	2122	0.01802	0.02116	0.00455	39	39	39	0	0	1	-360	360;
	2121	2122	0.00669	0.00785	0.00168	29	29	29	0	0	1	-360	360;
	2188	1522	0.01702	0.04901	0.00645	62	62	62	0	0	1	-360	360;
	2061	2188	0.04091	0.05083	0.01042	39	39	39	0	0	1	-360	360;
	1916	1586	0.00661	0.02	0.0024	62	62	62	0	0	1	-360	360;
	2235	1586	0.02512	0.07182	0.00953	62	62	62	0	0	1	-360	360;
	2149	2120	0.01438	0.04694	0.00475	62	62	62	0	0	1	-360	360;
	1917	2236	0.02876	0.08876	0.01014	62	62	62	0	0	1	-360	360;
	1586	1315	0.00264	0.00744	0.00101	62	62	62	0	0	1	-360	360;
	1973	2236	0.01959	0.02942	0.00541	78	78	78	0	0	1	-360	360;
	1548	2024	0.00372	0.00992	0.00096	51	51	51	0	0	1	-360	360;
	2189	1875	0.02421	0.07669	0.00831	62	62	62	0	0	1	-360	360;
	1301	1875	0.00769	0.02504	0.00253	62	62	62	0	0	1	-360	360;
	1302	1876	0.00769	0.02504	0.00253	62	62	62	0	0	1	-360	360;
	1547	1875	0.01926	0.06298	0.00636	62	62	62	0	0	1	-360	360;
	1735	1410	0.00512	0.01669	0.00168	114	114	114	0	0	1	-360	360;
	1314	1734	0.00405	0.01083	0.00137	51	51	51	0	0	1	-360	360;
	2195	2139	0.00926	0.0262	0.00351	62	62	62	0	0	1	-360	360;
	2194	2034	0.01107	0.0362	0.00368	62	62	62	0	0	1	-360	360;
	1718	1915	0.00512	0.01529	0.00187	62	62	62	0	0	1	-360	360;
	2138	1918	0.01562	0.05107	0.00516	62	62	62	0	0	1	-360	360;
	1538	2209	0.01736	0.02322	0.00464	39	39	39	0	0	1	-360	360;
	1720	1587	0.00289	0.00934	0.00099	114	114	114	0	0	1	-360	360;
	2002	1586	0.02207	0.07215	0.00729	62	62	62	0	0	1	-360	360;
	2060	1166	0.01636	0.02025	0.00421	39	39	39	0	0	1	-360	360;
	1303	1690	0.00884	0.02802	0.00301	62	62	62	0	0	1	-360	360;
	1691	1257	0.00479	0.01471	0.00168	62	62	62	0	0	1	-360	360;
	1587	1277	0.01793	0.04463	0.00544	51	51	51	0	0	1	-360	360;
	1235	1294	0.01347	0.04264	0.00462	75	75	75	0	0	1	-360	360;
	1233	1235	0.00463	0.01331	0.00176	75	75	75	0	0	1	-360	360;
	1255	1235	8e-05	0.00017	3e-05	75	75	75	0	0	1	-360	360;
	1950	1640	0.04025	0.07132	0.00662	47	47	47	0	0	1	-360	360;
	1845	1950	0.02702	0.05752	0.00544	47	47	47	0	0	1	-360	360;
	1904	1845	0.00066	0.00107	0.00018	47	47	47	0	0	1	-360	360;
	1843	1845	0.00017	0.00041	5e-05	75	75	75	0	0	1	-360	360;
	1791	1357	0.00215	0.00612	0.00083	75	75	75	0	0	1	-360	360;
	2064	1668	0.01306	0.04157	0.00445	75	75	75	0	0	1	-360	360;
	2174	1209	0.01	0.02306	0.00305	63	63	63	0	0	1	-360	360;
	2197	2174	0.00587	0.01835	0.00202	75	75	75	0	0	1	-360	360;
	2221	2174	8e-05	0.00033	4e-05	75	75	75	0	0	1	-360	360;
	1153	2221	0.00033	0.00099	0.00013	75	75	75	0	0	1	-360	360;
	2219	2221	0.00446	0.01273	0.00172	75	75	75	0	0	1	-360	360;
	1144	1407	0.01397	0.04405	0.00478	75	75	75	0	0	1	-360	360;
	1897	1588	0.02281	0.06	0.00958	75	75	75	0	0	1	-360	360;
	1739	1851	0.00669	0.0162	0.00254	63	63	63	0	0	1	-360	360;
	1242	1950	0.02256	0.04314	0.004	49	49	49	0	0	1	-360	360;
	1492	1209	0.0057	0.01636	0.00222	75	75	75	0	0	1	-360	360;
	2158	1740	0.01364	0.03446	0.00363	63	63	63	0	0	1	-360	360;
	1849	2216	0.00562	0.0157	0.00174	57	57	57	0	0	1	-360	360;
	1497	1740	0.01769	0.04438	0.00468	63	63	63	0	0	1	-360	360;
	1895	1497	0.00488	0.01306	0.0016	63	63	63	0	0	1	-360	360;
	1497	1495	0.00091	0.00215	0.00023	63	63	63	0	0	1	-360	360;
	1739	1483	0.01669	0.04364	0.00566	63	63	63	0	0	1	-360	360;
	1390	1467	0.00289	0.00802	0.0008	67	67	67	0	0	1	-360	360;
	1482	1390	0.00595	0.00992	0.00237	63	63	63	0	0	1	-360	360;
	1390	1388	0.0024	0.00455	0.00075	47	47	47	0	0	1	-360	360;
	1715	1940	0.00893	0.02926	0.00295	75	75	75	0	0	1	-360	360;
	1758	1715	0.00496	0.01612	0.00164	75	75	75	0	0	1	-360	360;
	1713	1715	0.00231	0.00388	0.00039	47	47	47	0	0	1	-360	360;
	1374	1939	0.00083	0.00256	0.00026	75	75	75	0	0	1	-360	360;
	1155	1374	0.00793	0.02595	0.00262	75	75	75	0	0	1	-360	360;
	1372	1374	0.00025	0.00058	8e-05	75	75	75	0	0	1	-360	360;
	1724	1940	0.00802	0.02471	0.0025	63	63	63	0	0	1	-360	360;
	1723	1939	0.0081	0.0257	0.00258	63	63	63	0	0	1	-360	360;
	1941	2069	0.01446	0.04132	0.0055	75	75	75	0	0	1	-360	360;
	1980	2026	0.01008	0.03182	0.00345	75	75	75	0	0	1	-360	360;
	1487	1529	0.00372	0.01207	0.00122	75	75	75	0	0	1	-360	360;
	1685	1786	0.00223	0.0062	0.00084	75	75	75	0	0	1	-360	360;
	2117	2100	0.00959	0.03107	0.00317	75	75	75	0	0	1	-360	360;
	1743	1929	0.00099	0.00298	0.00036	99	99	99	0	0	1	-360	360;
	1951	1743	0.00579	0.01868	0.0019	99	99	99	0	0	1	-360	360;
	1741	1743	0.00083	0.00231	0.0003	75	75	75	0	0	1	-360	360;
	2144	1950	0.0119	0.03686	0.00418	99	99	99	0	0	1	-360	360;
	1438	1238	0.00421	0.01355	0.0014	75	75	75	0	0	1	-360	360;
	2044	1584	0.00521	0.01496	0.00198	75	75	75	0	0	1	-360	360;
	2180	1784	0.00479	0.01471	0.00176	75	75	75	0	0	1	-360	360;
	1283	2180	0.00174	0.00579	0.00574	75	75	75	0	0	1	-360	360;
	2178	2180	8e-05	0.00017	2e-05	75	75	75	0	0	1	-360	360;
	1283	1922	0.00124	0.00421	0.00042	75	75	75	0	0	1	-360	360;
	1742	1929	0.00149	0.0043	0.00058	75	75	75	0	0	1	-360	360;
	1231	1674	0.00678	0.02215	0.00225	75	75	75	0	0	1	-360	360;
	1375	1727	0.0081	0.02066	0.00231	63	63	63	0	0	1	-360	360;
	1940	1375	0.0005	0.00157	0.00016	63	63	63	0	0	1	-360	360;
	1375	1373	0.00091	0.00264	0.00036	57	57	57	0	0	1	-360	360;
	1430	1263	0.00174	0.00496	0.00065	57	57	57	0	0	1	-360	360;
	2145	1624	0.01298	0.04074	0.0045	75	75	75	0	0	1	-360	360;
	1871	2045	0.0038	0.01231	0.00124	75	75	75	0	0	1	-360	360;
	1716	1871	0.00669	0.02198	0.00222	75	75	75	0	0	1	-360	360;
	1156	1716	0.00446	0.01463	0.00148	75	75	75	0	0	1	-360	360;
	1871	1869	0.00116	0.00256	0.00025	47	47	47	0	0	1	-360	360;
	1714	1716	0.00231	0.00388	0.00039	47	47	47	0	0	1	-360	360;
	2044	1440	0.00446	0.01455	0.00149	75	75	75	0	0	1	-360	360;
	1529	2135	0.00331	0.01066	0.0011	75	75	75	0	0	1	-360	360;
	1529	1322	0.0014	0.00455	0.00046	75	75	75	0	0	1	-360	360;
	1787	1293	0.0024	0.00678	0.00091	75	75	75	0	0	1	-360	360;
	2145	1780	0.0038	0.01083	0.00145	75	75	75	0	0	1	-360	360;
	1930	2146	0.01835	0.05744	0.00634	99	99	99	0	0	1	-360	360;
	1391	1268	0.00099	0.00273	0.00037	75	75	75	0	0	1	-360	360;
	1822	1391	0.00149	0.0043	0.00057	75	75	75	0	0	1	-360	360;
	1391	1389	0.00132	0.00364	0.00049	75	75	75	0	0	1	-360	360;
	2218	1493	0.00223	0.00736	0.00075	75	75	75	0	0	1	-360	360;
	2214	2218	8e-05	0.00017	2e-05	75	75	75	0	0	1	-360	360;
	1491	1493	0.00314	0.00909	0.00119	75	75	75	0	0	1	-360	360;
	2217	2218	0	0.00083	1e-05	75	75	75	0	0	1	-360	360;
	1551	1406	0.00107	0.00339	0.00038	75	75	75	0	0	1	-360	360;
	2142	1551	0.00455	0.01355	0.00164	75	75	75	0	0	1	-360	360;
	1551	1549	0.00116	0.0014	0.0003	47	47	47	0	0	1	-360	360;
	1212	1406	0.00107	0.00339	0.00038	75	75	75	0	0	1	-360	360;
	2187	1212	0.00388	0.01207	0.00134	75	75	75	0	0	1	-360	360;
	1210	1212	0.00066	0.00182	0.00024	75	75	75	0	0	1	-360	360;
	1572	1406	0.00934	0.0257	0.00253	63	63	63	0	0	1	-360	360;
	2025	1572	0.0057	0.01479	0.0015	63	63	63	0	0	1	-360	360;
	1572	1569	0.00554	0.00959	0.00095	47	47	47	0	0	1	-360	360;
	1619	1406	0.01504	0.04033	0.00401	63	63	63	0	0	1	-360	360;
	2026	1619	8e-05	0.00025	2e-05	75	75	75	0	0	1	-360	360;
	1618	1619	0.00017	0.00041	6e-05	75	75	75	0	0	1	-360	360;
	1667	1589	0.0005	0.00149	0.00017	105	105	105	0	0	1	-360	360;
	1667	1589	0.0005	0.00149	0.00017	105	105	105	0	0	1	-360	360;
	1435	1407	0.01256	0.03975	0.0044	75	75	75	0	0	1	-360	360;
	1437	1435	0.00025	0.00083	9e-05	75	75	75	0	0	1	-360	360;
	1668	1437	0.00058	0.00174	0.00019	75	75	75	0	0	1	-360	360;
	1432	1435	0.00041	0.00132	0.00013	75	75	75	0	0	1	-360	360;
	1962	1405	0.00876	0.02744	0.00304	75	75	75	0	0	1	-360	360;
	1434	1962	0.00364	0.01149	0.00127	75	75	75	0	0	1	-360	360;
	1667	1434	0.00099	0.00339	0.00038	75	75	75	0	0	1	-360	360;
	1961	1962	0.00207	0.00603	0.00079	75	75	75	0	0	1	-360	360;
	1431	1434	0.00041	0.00124	0.00017	75	75	75	0	0	1	-360	360;
	1321	2177	0.00149	0.00496	0.0005	75	75	75	0	0	1	-360	360;
	1728	1321	0.00496	0.01306	0.00151	63	63	63	0	0	1	-360	360;
	1320	1321	0.00066	0.00198	0.00026	75	75	75	0	0	1	-360	360;
	2146	1821	0.0043	0.01364	0.00146	99	99	99	0	0	1	-360	360;
	1446	1831	0.01198	0.03702	0.00418	75	75	75	0	0	1	-360	360;
	1688	1263	0.00455	0.01405	0.0016	75	75	75	0	0	1	-360	360;
	2117	2101	0.00421	0.00917	0.00216	75	75	75	0	0	1	-360	360;
	1921	1219	0.00579	0.01529	0.0016	63	63	63	0	0	1	-360	360;
	1645	1219	0.00132	0.00231	0.00023	47	47	47	0	0	1	-360	360;
	1646	1220	0.00132	0.00231	0.00023	47	47	47	0	0	1	-360	360;
	2147	1965	0.00289	0.00719	0.00076	63	63	63	0	0	1	-360	360;
	2148	1966	0.00289	0.00719	0.00076	63	63	63	0	0	1	-360	360;
	1932	1405	0.00372	0.00917	0.00098	63	63	63	0	0	1	-360	360;
	2148	1932	0.00463	0.01463	0.00159	75	75	75	0	0	1	-360	360;
	1931	1932	0.00264	0.00579	0.00136	75	75	75	0	0	1	-360	360;
	2147	1405	0.00835	0.02388	0.00256	63	63	63	0	0	1	-360	360;
	1552	1405	0.00157	0.00488	0.00055	75	75	75	0	0	1	-360	360;
	1779	1552	0.00744	0.02289	0.00262	75	75	75	0	0	1	-360	360;
	2156	1779	0.00099	0.00331	0.00035	75	75	75	0	0	1	-360	360;
	1552	1550	0.00074	0.00132	0.00031	63	63	63	0	0	1	-360	360;
	1777	1779	0.00025	0.0005	5e-05	47	47	47	0	0	1	-360	360;
	1683	1405	0.00752	0.02339	0.0026	75	75	75	0	0	1	-360	360;
	2090	1721	0.01008	0.02496	0.00265	63	63	63	0	0	1	-360	360;
	2130	2090	0.0119	0.03008	0.0032	63	63	63	0	0	1	-360	360;
	2088	2090	0.00438	0.00545	0.00081	49	49	49	0	0	1	-360	360;
	2091	1722	0.01008	0.02496	0.00265	63	63	63	0	0	1	-360	360;
	1908	2091	0.00826	0.02132	0.00242	63	63	63	0	0	1	-360	360;
	2089	2091	0.00413	0.00479	0.00072	49	49	49	0	0	1	-360	360;
	2147	2011	0.0024	0.00694	0.0009	75	75	75	0	0	1	-360	360;
	1529	1295	0.00314	0.01355	0.00135	80	80	80	0	0	1	-360	360;
	1721	1441	0.00306	0.00355	0.00076	47	47	47	0	0	1	-360	360;
	1597	1682	0.00314	0.00959	0.00112	75	75	75	0	0	1	-360	360;
	1722	1442	0.00314	0.00364	0.00078	47	47	47	0	0	1	-360	360;
	1317	1938	0.00107	0.00298	0.0004	75	75	75	0	0	1	-360	360;
	2025	1317	0.00182	0.00529	0.00071	75	75	75	0	0	1	-360	360;
	1317	1316	0.00058	0.00157	0.00021	75	75	75	0	0	1	-360	360;
	1686	1935	0.00314	0.02124	0.00243	114	114	114	0	0	1	-360	360;
	1264	1578	0.00496	0.01628	0.00164	75	75	75	0	0	1	-360	360;
	2147	1674	0.00405	0.01264	0.0014	75	75	75	0	0	1	-360	360;
	1175	1723	0.00198	0.00612	0.00068	75	75	75	0	0	1	-360	360;
	2177	1175	0.00496	0.01545	0.00171	75	75	75	0	0	1	-360	360;
	1175	1173	0.00107	0.0019	0.00019	47	47	47	0	0	1	-360	360;
	1536	1724	0.00231	0.00752	0.00079	75	75	75	0	0	1	-360	360;
	1928	1536	0.0057	0.01818	0.00196	75	75	75	0	0	1	-360	360;
	1535	1536	8e-05	0.00017	2e-05	63	63	63	0	0	1	-360	360;
	1530	2107	0.0019	0.00455	0.00091	75	75	75	0	0	1	-360	360;
	2108	1529	0.0014	0.00471	0.00048	75	75	75	0	0	1	-360	360;
	1220	2108	0.0081	0.02298	0.00239	63	63	63	0	0	1	-360	360;
	2106	2108	0.0005	0.0014	0.00017	75	75	75	0	0	1	-360	360;
	1396	1407	0.00752	0.02347	0.00235	63	63	63	0	0	1	-360	360;
	1570	1396	0.00033	0.00116	0.00012	75	75	75	0	0	1	-360	360;
	1394	1396	0.0024	0.00727	0.00087	75	75	75	0	0	1	-360	360;
	2118	2206	0.0081	0.02496	0.00284	75	75	75	0	0	1	-360	360;
	1857	1137	0.00364	0.01149	0.00123	75	75	75	0	0	1	-360	360;
	1182	1857	0.00157	0.00463	0.00057	75	75	75	0	0	1	-360	360;
	1857	1855	0.00231	0.00694	0.00072	63	63	63	0	0	1	-360	360;
	2084	1307	0.0019	0.0057	0.00061	63	63	63	0	0	1	-360	360;
	1176	2085	0.0057	0.01744	0.00187	63	63	63	0	0	1	-360	360;
	2177	1176	0.00496	0.01545	0.00171	75	75	75	0	0	1	-360	360;
	1176	1174	0.00107	0.0019	0.00019	47	47	47	0	0	1	-360	360;
	1530	2078	0.00521	0.01603	0.00183	75	75	75	0	0	1	-360	360;
	1753	1588	0.01339	0.04223	0.00461	75	75	75	0	0	1	-360	360;
	2104	1753	0.00785	0.02529	0.00263	75	75	75	0	0	1	-360	360;
	1753	1751	0.00388	0.01281	0.00126	99	99	99	0	0	1	-360	360;
	1752	1338	0.00876	0.0281	0.00298	75	75	75	0	0	1	-360	360;
	1663	1752	0.01116	0.03504	0.00382	75	75	75	0	0	1	-360	360;
	1588	1663	0.00231	0.00719	0.00079	75	75	75	0	0	1	-360	360;
	1752	1750	0.0038	0.0124	0.00126	99	99	99	0	0	1	-360	360;
	1663	1661	0.00322	0.00554	0.00054	47	47	47	0	0	1	-360	360;
	2084	1723	0.00545	0.01702	0.00187	75	75	75	0	0	1	-360	360;
	2205	2148	0.00488	0.01207	0.00144	63	63	63	0	0	1	-360	360;
	1445	2204	0.00273	0.00785	0.00081	63	63	63	0	0	1	-360	360;
	1678	1893	0.00289	0.00868	0.00103	75	75	75	0	0	1	-360	360;
	2118	1678	0.00595	0.01942	0.00199	75	75	75	0	0	1	-360	360;
	1678	1676	0.00529	0.00909	0.0009	47	47	47	0	0	1	-360	360;
	1328	1530	0.0014	0.00455	0.00046	75	75	75	0	0	1	-360	360;
	1349	1328	0.00512	0.01554	0.00186	75	75	75	0	0	1	-360	360;
	1327	1328	0.00033	0.00107	0.00011	75	75	75	0	0	1	-360	360;
	2040	1959	0.00678	0.02025	0.00244	67	67	67	0	0	1	-360	360;
	2207	1960	0.00802	0.02554	0.00272	75	75	75	0	0	1	-360	360;
	2058	1903	0.00727	0.00975	0.00189	47	47	47	0	0	1	-360	360;
	2146	1208	0.01785	0.05826	0.00589	99	99	99	0	0	1	-360	360;
	2147	1329	0.00314	0.00785	0.00086	63	63	63	0	0	1	-360	360;
	1778	1330	0.00579	0.01595	0.00189	63	63	63	0	0	1	-360	360;
	1596	1778	0.00207	0.0062	0.00077	75	75	75	0	0	1	-360	360;
	1776	1778	0.00025	0.0005	5e-05	47	47	47	0	0	1	-360	360;
	2100	1820	0.00744	0.02289	0.00262	75	75	75	0	0	1	-360	360;
	1819	1589	0.01207	0.03926	0.00399	75	75	75	0	0	1	-360	360;
	1958	1589	0.0005	0.0038	0.00038	115	115	115	0	0	1	-360	360;
	2012	1958	0.0081	0.05248	0.00524	75	75	75	0	0	1	-360	360;
	2148	2012	0.00769	0.02413	0.00266	75	75	75	0	0	1	-360	360;
	1956	1958	0.00058	0.00174	0.00023	75	75	75	0	0	1	-360	360;
	2010	2012	0.00223	0.00719	0.00075	75	75	75	0	0	1	-360	360;
	1894	1172	0.00281	0.00851	0.00098	75	75	75	0	0	1	-360	360;
	1677	1171	0.00347	0.0114	0.00115	75	75	75	0	0	1	-360	360;
	1337	1677	0.00529	0.01719	0.00176	75	75	75	0	0	1	-360	360;
	1677	1675	0.00529	0.00909	0.0009	47	47	47	0	0	1	-360	360;
	1627	1889	0.01926	0.06198	0.00647	75	75	75	0	0	1	-360	360;
	2144	1627	0.01041	0.03388	0.00346	75	75	75	0	0	1	-360	360;
	1626	1627	0.00165	0.00537	0.00054	75	75	75	0	0	1	-360	360;
	2015	1929	0.00471	0.0138	0.00176	75	75	75	0	0	1	-360	360;
	1436	1668	0.00074	0.00231	0.00023	75	75	75	0	0	1	-360	360;
	2212	1436	0.01107	0.03612	0.00365	75	75	75	0	0	1	-360	360;
	1433	1436	0.00091	0.00306	0.0003	75	75	75	0	0	1	-360	360;
	1668	1798	0.00752	0.02446	0.00247	75	75	75	0	0	1	-360	360;
	1844	2059	0.0124	0.02793	0.00267	47	47	47	0	0	1	-360	360;
	2099	1519	0.01694	0.05562	0.0056	62	62	62	0	0	1	-360	360;
	1270	1237	0.01512	0.04223	0.00403	50	50	50	0	0	1	-360	360;
	1697	1236	0.01529	0.03198	0.00589	50	50	50	0	0	1	-360	360;
	1738	1476	0.00934	0.02917	0.00321	62	62	62	0	0	1	-360	360;
	1747	1738	0.00215	0.00636	0.0008	62	62	62	0	0	1	-360	360;
	1738	1737	0	8e-05	1e-05	62	62	62	0	0	1	-360	360;
	1711	1476	0.00504	0.01661	0.00167	62	62	62	0	0	1	-360	360;
	2038	1656	0.00579	0.01446	0.00162	50	50	50	0	0	1	-360	360;
	1520	1656	0.03413	0.08545	0.00909	50	50	50	0	0	1	-360	360;
	1520	2223	0.0062	0.01562	0.00277	62	62	62	0	0	1	-360	360;
	1695	2222	0.00124	0.00355	0.00045	62	62	62	0	0	1	-360	360;
	1991	2037	0.00769	0.01934	0.00211	50	50	50	0	0	1	-360	360;
	1989	1991	0.01248	0.03545	0.00474	62	62	62	0	0	1	-360	360;
	1519	1148	0.00488	0.01231	0.00189	50	50	50	0	0	1	-360	360;
	1287	1617	0.0062	0.01934	0.00214	62	62	62	0	0	1	-360	360;
	1519	1339	0.00405	0.01331	0.00135	62	62	62	0	0	1	-360	360;
	1340	1990	0.01025	0.02926	0.0039	62	62	62	0	0	1	-360	360;
	1516	1476	0.00959	0.03107	0.00321	62	62	62	0	0	1	-360	360;
	1764	1476	0.0014	0.0043	0.00047	62	62	62	0	0	1	-360	360;
	1266	1507	0.00777	0.02372	0.00273	62	62	62	0	0	1	-360	360;
	2075	1600	0.00818	0.02496	0.00292	62	62	62	0	0	1	-360	360;
	2210	2202	0.00149	0.00446	0.00057	62	62	62	0	0	1	-360	360;
	1788	1694	0.00628	0.01959	0.00217	62	62	62	0	0	1	-360	360;
	1789	1695	0.0062	0.01942	0.00215	62	62	62	0	0	1	-360	360;
	1694	2203	0.00083	0.00248	0.00027	62	62	62	0	0	1	-360	360;
	1149	2211	0.00074	0.00223	0.0003	62	62	62	0	0	1	-360	360;
	2224	1695	0.00198	0.00529	0.00071	50	50	50	0	0	1	-360	360;
	1974	1969	0.00347	0.00975	0.00132	62	62	62	0	0	1	-360	360;
	2103	1236	0.00512	0.01463	0.00197	62	62	62	0	0	1	-360	360;
	1975	2103	0.00132	0.0038	0.00051	62	62	62	0	0	1	-360	360;
	2102	2103	0.00025	0.00033	4e-05	62	62	62	0	0	1	-360	360;
	2005	1477	0.00479	0.01471	0.00169	62	62	62	0	0	1	-360	360;
	1499	1474	0.00884	0.02769	0.00305	62	62	62	0	0	1	-360	360;
	2021	1477	0.00504	0.01554	0.00179	62	62	62	0	0	1	-360	360;
	2008	1475	0.00355	0.00884	0.00094	50	50	50	0	0	1	-360	360;
	2111	2008	0.01603	0.04124	0.00435	50	50	50	0	0	1	-360	360;
	2008	2006	0.01264	0.01488	0.00319	39	39	39	0	0	1	-360	360;
	2009	1474	0.0043	0.01066	0.00113	50	50	50	0	0	1	-360	360;
	1982	2009	0.01727	0.04893	0.00506	50	50	50	0	0	1	-360	360;
	2009	2007	0.01281	0.01496	0.00322	39	39	39	0	0	1	-360	360;
	2112	1982	0.00893	0.02777	0.0031	62	62	62	0	0	1	-360	360;
	1323	1982	0.00901	0.02769	0.00317	62	62	62	0	0	1	-360	360;
	1983	1236	0.01083	0.02711	0.00287	50	50	50	0	0	1	-360	360;
	1984	1237	0.01083	0.02711	0.00287	50	50	50	0	0	1	-360	360;
	2163	1983	0.0043	0.0124	0.00164	62	62	62	0	0	1	-360	360;
	2164	1982	0.0043	0.0124	0.00164	62	62	62	0	0	1	-360	360;
	1814	1795	0.00504	0.01256	0.00135	50	50	50	0	0	1	-360	360;
	1984	1814	0.01099	0.02835	0.00304	50	50	50	0	0	1	-360	360;
	1813	1814	0.0043	0.01231	0.00162	62	62	62	0	0	1	-360	360;
	1983	1794	0.01603	0.04107	0.0044	50	50	50	0	0	1	-360	360;
	1982	2153	0.0062	0.02025	0.00208	62	62	62	0	0	1	-360	360;
	1519	1206	0.00455	0.01289	0.00174	62	62	62	0	0	1	-360	360;
	2081	1164	0.0043	0.01347	0.00148	62	62	62	0	0	1	-360	360;
	2035	1164	0.00347	0.01116	0.00119	62	62	62	0	0	1	-360	360;
	2032	1362	0.00471	0.01339	0.0018	62	62	62	0	0	1	-360	360;
	1657	2032	0.00355	0.01091	0.00126	62	62	62	0	0	1	-360	360;
	2032	2030	0.00157	0.00496	0.00056	62	62	62	0	0	1	-360	360;
	1836	1165	0.00264	0.00818	0.00091	62	62	62	0	0	1	-360	360;
	1657	1836	0.00587	0.01942	0.00212	62	62	62	0	0	1	-360	360;
	1836	1835	0.00207	0.00347	0.00083	50	50	50	0	0	1	-360	360;
	1671	1657	0.0024	0.00719	0.00085	62	62	62	0	0	1	-360	360;
	1288	1747	0.0024	0.00777	0.00081	62	62	62	0	0	1	-360	360;
	1361	1854	0.00372	0.00843	0.00145	50	50	50	0	0	1	-360	360;
	1827	1746	0.00628	0.02025	0.00211	62	62	62	0	0	1	-360	360;
	1560	1515	8e-05	0.00025	2e-05	62	62	62	0	0	1	-360	360;
	1775	1560	0.0076	0.01983	0.00206	50	50	50	0	0	1	-360	360;
	1746	1775	0.00314	0.00843	0.00085	50	50	50	0	0	1	-360	360;
	1559	1560	0.00455	0.00818	0.00096	39	39	39	0	0	1	-360	360;
	1774	1775	0.0005	0.0014	0.00013	50	50	50	0	0	1	-360	360;
	1534	1515	0.00256	0.00636	0.001	50	50	50	0	0	1	-360	360;
	1731	1485	0.00165	0.00463	0.00063	62	62	62	0	0	1	-360	360;
	1481	1516	0.00322	0.00926	0.00122	62	62	62	0	0	1	-360	360;
	1261	1481	0.00306	0.00893	0.00111	62	62	62	0	0	1	-360	360;
	1480	1481	0	8e-05	1e-05	62	62	62	0	0	1	-360	360;
	1485	1853	0.0014	0.00405	0.00053	62	62	62	0	0	1	-360	360;
	2140	1672	0.01074	0.03273	0.00383	62	62	62	0	0	1	-360	360;
	1515	1765	0.00826	0.02686	0.00276	62	62	62	0	0	1	-360	360;
	1705	2099	0.01471	0.03025	0.00563	50	50	50	0	0	1	-360	360;
	1520	1705	0.00992	0.01661	0.00395	50	50	50	0	0	1	-360	360;
	1705	1704	0.00223	0.00562	0.0006	50	50	50	0	0	1	-360	360;
	1162	1477	0.00603	0.02083	0.00212	62	62	62	0	0	1	-360	360;
	1163	1244	0.00306	0.01074	0.00115	62	62	62	0	0	1	-360	360;
	1473	1243	0.00653	0.02099	0.00221	62	62	62	0	0	1	-360	360;
	1601	1473	0.0024	0.00694	0.00092	62	62	62	0	0	1	-360	360;
	1469	1473	0.00868	0.02669	0.00307	62	62	62	0	0	1	-360	360;
	1470	1473	0.00835	0.0257	0.00294	62	62	62	0	0	1	-360	360;
	1490	1794	0.00471	0.01149	0.00179	50	50	50	0	0	1	-360	360;
	2162	1490	0.02405	0.04025	0.00957	50	50	50	0	0	1	-360	360;
	1489	1490	0.00347	0.01025	0.00125	62	62	62	0	0	1	-360	360;
	1795	1970	0.00149	0.00438	0.00052	62	62	62	0	0	1	-360	360;
	1794	1585	0.00091	0.00298	0.00033	62	62	62	0	0	1	-360	360;
	1812	1794	0.01033	0.0124	0.00255	39	39	39	0	0	1	-360	360;
	1795	1556	0.00843	0.02421	0.00321	62	62	62	0	0	1	-360	360;
	2036	1828	0.00149	0.00446	0.00055	62	62	62	0	0	1	-360	360;
	1803	1746	0.00198	0.0057	0.00077	62	62	62	0	0	1	-360	360;
	2031	1262	0.00438	0.01405	0.00149	62	62	62	0	0	1	-360	360;
	1402	2031	0.00066	0.00182	0.00024	62	62	62	0	0	1	-360	360;
	1657	1402	0.00463	0.01413	0.00163	62	62	62	0	0	1	-360	360;
	2029	2031	0.00017	0.00041	6e-05	62	62	62	0	0	1	-360	360;
	1401	1402	0	8e-05	1e-05	62	62	62	0	0	1	-360	360;
	1616	1165	0.00463	0.01438	0.0016	62	62	62	0	0	1	-360	360;
	1311	1165	0.00083	0.00264	0.00026	62	62	62	0	0	1	-360	360;
	1707	1311	0.00256	0.00835	0.00084	62	62	62	0	0	1	-360	360;
	1310	1311	0.00099	0.00289	0.00038	62	62	62	0	0	1	-360	360;
	2112	1265	0.00529	0.01636	0.00188	62	62	62	0	0	1	-360	360;
	1200	1236	0.00083	0.00132	0.00016	39	39	39	0	0	1	-360	360;
	1201	1237	0.00083	0.00124	0.00015	39	39	39	0	0	1	-360	360;
	1202	1237	0.00083	0.00124	0.00015	39	39	39	0	0	1	-360	360;
	1203	1236	0.00074	0.00116	0.00013	39	39	39	0	0	1	-360	360;
	1657	2080	0.00496	0.01537	0.00175	62	62	62	0	0	1	-360	360;
	1516	1269	0.00719	0.01777	0.00216	50	50	50	0	0	1	-360	360;
	1746	1712	0.00802	0.02521	0.00274	62	62	62	0	0	1	-360	360;
	2225	1207	0.00603	0.01711	0.00231	62	62	62	0	0	1	-360	360;
	1729	1658	0.00769	0.02711	0.00317	62	62	62	0	0	1	-360	360;
	2004	1475	0.0014	0.00446	0.00049	62	62	62	0	0	1	-360	360;
	1732	1533	0.00488	0.00868	0.00192	50	50	50	0	0	1	-360	360;
	2150	2099	0.00372	0.01231	0.00124	62	62	62	0	0	1	-360	360;
	2111	1324	0.00273	0.00826	0.00096	62	62	62	0	0	1	-360	360;
	2161	2077	0.00116	0.00273	0.00046	50	50	50	0	0	1	-360	360;
	1428	2098	0.00215	0.01479	0.00169	98	98	98	0	0	1	-360	360;
	1696	2098	0.00769	0.02347	0.00277	62	62	62	0	0	1	-360	360;
	1218	2099	0.00207	0.01413	0.00162	98	98	98	0	0	1	-360	360;
	1429	1218	8e-05	0.00066	7e-05	98	98	98	0	0	1	-360	360;
	1216	1218	0.0005	0.00149	0.0096	98	98	98	0	0	1	-360	360;
	2141	2098	0.01116	0.03273	0.00319	50	50	50	0	0	1	-360	360;
	1749	2154	0.00587	0.0162	0.0017	50	50	50	0	0	1	-360	360;
	2112	1749	0.00017	0.00033	3e-05	50	50	50	0	0	1	-360	360;
	1749	1748	0.00198	0.00455	0.00078	50	50	50	0	0	1	-360	360;
	1371	1369	0	8e-05	0	39	39	39	0	0	1	-360	360;
	1879	1371	0.01612	0.02347	0.00336	39	39	39	0	0	1	-360	360;
	1383	1879	0.04752	0.09182	0.00916	39	39	39	0	0	1	-360	360;
	1968	1403	0.03041	0.05322	0.00508	39	39	39	0	0	1	-360	360;
	2201	1968	0.09893	0.17769	0.01704	39	39	39	0	0	1	-360	360;
	1967	1968	0.00198	0.00314	0.00037	19	19	19	0	0	1	-360	360;
	1650	2200	0.01355	0.02826	0.00271	39	39	39	0	0	1	-360	360;
	2053	1187	0.02289	0.05793	0.00612	50	50	50	0	0	1	-360	360;
	2042	1187	0.02479	0.06264	0.00663	50	50	50	0	0	1	-360	360;
	2201	1359	0.02273	0.07314	0.00765	62	62	62	0	0	1	-360	360;
	1647	1187	0.01479	0.04587	0.00508	50	50	50	0	0	1	-360	360;
	1880	1443	0.04901	0.08405	0.00831	39	39	39	0	0	1	-360	360;
	1382	1880	0.04752	0.09182	0.00916	39	39	39	0	0	1	-360	360;
	1878	1880	0.0062	0.01066	0.00104	39	39	39	0	0	1	-360	360;
	1651	1188	0.01636	0.04132	0.0045	50	50	50	0	0	1	-360	360;
	1254	1651	0.03727	0.06678	0.00651	39	39	39	0	0	1	-360	360;
	1649	1651	0.00058	0.00099	0.0001	29	29	29	0	0	1	-360	360;
	1168	1346	0.01802	0.05174	0.00682	57	57	57	0	0	1	-360	360;
	1403	1168	0.0124	0.03595	0.00461	57	57	57	0	0	1	-360	360;
	1168	1167	0.01653	0.02579	0.0031	19	19	19	0	0	1	-360	360;
	1403	1801	0.01264	0.02372	0.00377	39	39	39	0	0	1	-360	360;
	1546	1188	0.00719	0.02248	0.00246	62	62	62	0	0	1	-360	360;
	1545	1189	0.00719	0.02256	0.00247	62	62	62	0	0	1	-360	360;
	1383	1377	0.00661	0.02124	0.00222	105	105	105	0	0	1	-360	360;
	1409	1382	0.01636	0.0524	0.00553	105	105	105	0	0	1	-360	360;
	1808	1382	0.02066	0.04909	0.0103	39	39	39	0	0	1	-360	360;
	1341	1383	0.00132	0.00231	0.00024	39	39	39	0	0	1	-360	360;
	1342	1382	0.00074	0.00223	0.00025	57	57	57	0	0	1	-360	360;
	1840	1383	0.02843	0.06868	0.00659	39	39	39	0	0	1	-360	360;
	2200	1840	0.0376	0.06537	0.00643	39	39	39	0	0	1	-360	360;
	1840	1838	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	2201	1598	0.03818	0.0662	0.00648	39	39	39	0	0	1	-360	360;
	1839	1382	0.02843	0.06868	0.00659	39	39	39	0	0	1	-360	360;
	1599	1839	0.00521	0.0086	0.00095	39	39	39	0	0	1	-360	360;
	1839	1837	0.00331	0.00562	0.00057	19	19	19	0	0	1	-360	360;
	1593	1568	0.0405	0.06314	0.00758	39	39	39	0	0	1	-360	360;
	2192	1603	0.02579	0.06736	0.0079	50	50	50	0	0	1	-360	360;
	2193	1808	0.02446	0.0624	0.00662	50	50	50	0	0	1	-360	360;
	2193	1809	0.02446	0.0624	0.00662	50	50	50	0	0	1	-360	360;
	1215	1639	0.02479	0.06579	0.00654	50	50	50	0	0	1	-360	360;
	2192	2000	0.00165	0.00347	0.00038	39	39	39	0	0	1	-360	360;
	2193	2001	0.00107	0.00347	0.00037	62	62	62	0	0	1	-360	360;
	2133	1567	0.03074	0.04793	0.00575	39	39	39	0	0	1	-360	360;
	1648	2200	0.00248	0.00752	0.00079	50	50	50	0	0	1	-360	360;
	1382	1360	0.01124	0.03645	0.00373	62	62	62	0	0	1	-360	360;
	1638	1567	0.00777	0.02116	0.00242	50	50	50	0	0	1	-360	360;
	2134	1761	0.05	0.0781	0.00933	39	39	39	0	0	1	-360	360;
	1809	1635	0.02603	0.0662	0.00724	50	50	50	0	0	1	-360	360;
	1862	1760	0.0424	0.06628	0.00792	39	39	39	0	0	1	-360	360;
	1178	1289	0.00438	0.01446	0.00146	55	55	55	0	0	1	-360	360;
	1398	1187	0.03256	0.10355	0.01105	62	62	62	0	0	1	-360	360;
	1888	1354	0.05025	0.07843	0.00941	39	39	39	0	0	1	-360	360;
	2043	1808	0.02537	0.06355	0.00677	50	50	50	0	0	1	-360	360;
	2115	1370	0.01331	0.03785	0.0051	57	57	57	0	0	1	-360	360;
	1289	1383	0.01	0.06967	0.00747	209	209	209	0	0	1	-360	360;
	1290	2062	0.00587	0.04058	0.00443	191	191	191	0	0	1	-360	360;
	1365	1376	0.00628	0.01959	0.0022	105	105	105	0	0	1	-360	360;
	1290	1366	0.00942	0.04198	0.00452	114	114	114	0	0	1	-360	360;
	1634	2052	0.00521	0.0138	0.00166	50	50	50	0	0	1	-360	360;
	2067	1376	0.00306	0.00702	0.00073	39	39	39	0	0	1	-360	360;
	2066	1377	0.00306	0.00694	0.00072	39	39	39	0	0	1	-360	360;
	1861	1177	0.03306	0.05388	0.00644	39	39	39	0	0	1	-360	360;
	1887	1194	0.01777	0.05802	0.00587	57	57	57	0	0	1	-360	360;
	1808	1214	0.02248	0.05165	0.00652	50	50	50	0	0	1	-360	360;
	1345	1369	0.01455	0.04165	0.00549	57	57	57	0	0	1	-360	360;
	1826	1403	0.02992	0.09198	0.01059	62	62	62	0	0	1	-360	360;
	1383	2095	0.01116	0.03364	0.00399	62	62	62	0	0	1	-360	360;
	1824	1988	0.03463	0.10727	0.01217	114	114	114	0	0	1	-360	360;
	1926	1289	0.02107	0.06851	0.00701	114	114	114	0	0	1	-360	360;
	1444	1926	0.03041	0.0914	0.01103	114	114	114	0	0	1	-360	360;
	1925	1926	0.01512	0.0495	0.005	114	114	114	0	0	1	-360	360;
	1987	1290	0.01471	0.04612	0.00511	114	114	114	0	0	1	-360	360;
	1701	1443	0.01074	0.01752	0.00207	78	78	78	0	0	1	-360	360;
	1823	1701	0.00446	0.01281	0.00169	78	78	78	0	0	1	-360	360;
	1700	1701	0.00074	0.00116	0.00014	78	78	78	0	0	1	-360	360;
	2063	1382	0.00463	0.03207	0.00353	196	196	196	0	0	1	-360	360;
	2185	1408	0.00339	0.00975	0.00127	105	105	105	0	0	1	-360	360;
	1289	2184	0.00331	0.02273	0.00246	114	114	114	0	0	1	-360	360;
	1808	1289	0.03438	0.11231	0.01135	114	114	114	0	0	1	-360	360;
	1809	1290	0.03438	0.1124	0.01135	114	114	114	0	0	1	-360	360;
	1636	1355	0.05347	0.06785	0.00635	33	33	33	0	0	1	-360	360;
	1259	1189	0.00752	0.02207	0.00251	50	50	50	0	0	1	-360	360;
	2094	1399	0.01702	0.0519	0.00604	62	62	62	0	0	1	-360	360;
	1404	1253	0.08231	0.14521	0.01396	39	39	39	0	0	1	-360	360;
	1444	1369	0.04719	0.07769	0.00864	39	39	39	0	0	1	-360	360;
	1251	1260	0.05843	0.0805	0.00897	33	33	33	0	0	1	-360	360;
	1195	1403	0.01364	0.04455	0.00453	57	57	57	0	0	1	-360	360;
	1888	1404	0.03124	0.10182	0.01034	57	57	57	0	0	1	-360	360;
	1708	1808	0.00099	0.0019	0.01669	229	229	229	0	0	1	-360	360;
	1709	1809	0.00099	0.0019	0.01646	229	229	229	0	0	1	-360	360;
	1710	1808	0.00124	0.00231	0.0206	229	229	229	0	0	1	-360	360;
	1993	1246	0.02372	0.05926	0.0063	51	51	51	0	0	1	-360	360;
	1465	1703	0.00413	0.01033	0.0011	51	51	51	0	0	1	-360	360;
	1591	1465	0.03595	0.09132	0.0097	51	51	51	0	0	1	-360	360;
	1463	1465	0.00025	0.00041	0.00011	51	51	51	0	0	1	-360	360;
	1992	1204	0.01802	0.04124	0.00623	51	51	51	0	0	1	-360	360;
	1992	1150	0.01818	0.05636	0.00636	62	62	62	0	0	1	-360	360;
	1993	1882	0.02512	0.07851	0.00866	62	62	62	0	0	1	-360	360;
	1992	1576	0.01157	0.02512	0.00389	51	51	51	0	0	1	-360	360;
	2013	1703	0.02438	0.04083	0.00971	51	51	51	0	0	1	-360	360;
	1466	1703	0.00413	0.01033	0.0011	51	51	51	0	0	1	-360	360;
	2126	1466	0.0057	0.01562	0.00163	51	51	51	0	0	1	-360	360;
	1466	1464	0.00033	0.00058	0.00013	51	51	51	0	0	1	-360	360;
	2125	1924	0.01917	0.05124	0.0054	51	51	51	0	0	1	-360	360;
	2125	1459	0.00083	0.00273	0.00028	62	62	62	0	0	1	-360	360;
	2126	1460	0.00083	0.00306	0.00031	62	62	62	0	0	1	-360	360;
	2126	1452	0.00182	0.00512	0.00069	62	62	62	0	0	1	-360	360;
	2125	1453	0.0019	0.00529	0.00071	62	62	62	0	0	1	-360	360;
	2132	1882	0.00463	0.01512	0.00153	62	62	62	0	0	1	-360	360;
	1679	1881	0.00826	0.02702	0.00273	62	62	62	0	0	1	-360	360;
	2125	1450	0.00537	0.01207	0.00267	62	62	62	0	0	1	-360	360;
	1702	1447	0.00347	0.00661	0.00059	39	39	39	0	0	1	-360	360;
	1702	1448	0.00364	0.00653	0.00058	39	39	39	0	0	1	-360	360;
	1703	1449	0.00364	0.00653	0.00058	39	39	39	0	0	1	-360	360;
	1703	1454	0.00107	0.00207	0.00044	62	62	62	0	0	1	-360	360;
	1702	1455	0.00116	0.0019	0.00045	62	62	62	0	0	1	-360	360;
	2126	1462	0.00182	0.00479	0.00076	62	62	62	0	0	1	-360	360;
	1702	1451	0.00248	0.00595	0.00117	62	62	62	0	0	1	-360	360;
	1702	1157	0.01793	0.04512	0.00471	51	51	51	0	0	1	-360	360;
	1282	1158	0.00628	0.01942	0.00195	51	51	51	0	0	1	-360	360;
	1864	1363	0.01322	0.03694	0.0038	51	51	51	0	0	1	-360	360;
	2131	1681	0.00372	0.01223	0.00124	62	62	62	0	0	1	-360	360;
	1847	1681	0.00207	0.00653	0.00074	62	62	62	0	0	1	-360	360;
	1246	1848	0.01198	0.03455	0.00367	51	51	51	0	0	1	-360	360;
	1993	2070	0.01231	0.03545	0.00466	62	62	62	0	0	1	-360	360;
	1999	1229	0.00388	0.00901	0.00133	51	51	51	0	0	1	-360	360;
	1999	1992	0.00066	0.00413	0.00062	98	98	98	0	0	1	-360	360;
	1998	1993	0.00091	0.0062	0.00076	98	98	98	0	0	1	-360	360;
	1525	2082	0.04322	0.04876	0.00543	27	27	27	0	0	1	-360	360;
	1994	1525	0.00926	0.03017	0.00306	27	27	27	0	0	1	-360	360;
	1523	1525	0.00769	0.0086	0.00095	27	27	27	0	0	1	-360	360;
	1526	2083	0.03231	0.0362	0.00756	27	27	27	0	0	1	-360	360;
	1995	1526	0.00909	0.02959	0.00301	27	27	27	0	0	1	-360	360;
	1524	1526	0.00521	0.00612	0.00118	27	27	27	0	0	1	-360	360;
	1999	1913	0.08777	0.15231	0.01599	39	39	39	0	0	1	-360	360;
	1993	1744	0.02	0.04405	0.01004	62	62	62	0	0	1	-360	360;
	1745	1698	0.03934	0.08496	0.02002	62	62	62	0	0	1	-360	360;
	1479	1511	0.04322	0.10372	0.01111	39	39	39	0	0	1	-360	360;
	2082	1659	0.0157	0.02017	0.00426	39	39	39	0	0	1	-360	360;
	1954	1169	0.03678	0.08405	0.01056	51	51	51	0	0	1	-360	360;
	1368	1846	0.00934	0.01628	0.00189	39	39	39	0	0	1	-360	360;
	1368	1607	0.03264	0.09331	0.0124	62	62	62	0	0	1	-360	360;
	1914	1660	0.02653	0.03231	0.00677	39	39	39	0	0	1	-360	360;
	1679	1281	0.00388	0.01264	0.00128	62	62	62	0	0	1	-360	360;
	1387	2047	0.03579	0.06314	0.0077	39	39	39	0	0	1	-360	360;
	2046	1351	0.00397	0.00579	0.00109	57	57	57	0	0	1	-360	360;
	2046	2168	0.00711	0.01107	0.00132	39	39	39	0	0	1	-360	360;
	2047	2169	0.00702	0.01099	0.00131	39	39	39	0	0	1	-360	360;
	1181	1768	0.01909	0.05421	0.0073	62	62	62	0	0	1	-360	360;
	2083	1181	0.00653	0.0186	0.0025	62	62	62	0	0	1	-360	360;
	1179	1181	0.01	0.02843	0.00383	57	57	57	0	0	1	-360	360;
	1367	1699	0.03868	0.11587	0.01404	62	62	62	0	0	1	-360	360;
	1367	1193	0.00264	0.00769	0.00101	62	62	62	0	0	1	-360	360;
	2151	1245	0.01405	0.02124	0.0037	55	39	39	0	0	1	-360	360;
	1881	1151	0.01273	0.03917	0.0045	62	62	62	0	0	1	-360	360;
	1285	1679	0.00215	0.01504	0.00164	98	98	98	0	0	1	-360	360;
	1590	1992	0.00769	0.02074	0.0022	51	51	51	0	0	1	-360	360;
	2125	1680	0.00264	0.01909	0.0019	98	98	98	0	0	1	-360	360;
	2126	1679	0.00264	0.01909	0.0019	98	98	98	0	0	1	-360	360;
	2199	1882	0.01512	0.0376	0.00401	51	51	51	0	0	1	-360	360;
	1205	1841	0.00893	0.02355	0.00319	51	51	51	0	0	1	-360	360;
	1367	1386	0.04124	0.07066	0.00857	39	39	39	0	0	1	-360	360;
	1702	1461	0.00521	0.01157	0.00259	62	62	62	0	0	1	-360	360;
	1364	1881	0.01521	0.04074	0.00426	51	51	51	0	0	1	-360	360;
	1923	1681	0.00471	0.01554	0.00157	62	62	62	0	0	1	-360	360;
	1762	1367	0.01091	0.0357	0.00362	62	62	62	0	0	1	-360	360;
	1833	1763	0.0319	0.10785	0.011	62	62	62	0	0	1	-360	360;
	1633	1681	0.00165	0.01132	0.00121	98	98	98	0	0	1	-360	360;
	1755	1606	0.00653	0.02116	0.00217	62	62	62	0	0	1	-360	360;
	1834	1607	0.02198	0.07174	0.00727	62	62	62	0	0	1	-360	360;
	2083	1998	0.04512	0.23744	0.02383	62	62	62	0	0	1	-360	360;
	2083	1992	0.0457	0.2405	0.0243	62	62	62	0	0	1	-360	360;
	1703	1456	0.00083	0.00248	0.00033	51	51	51	0	0	1	-360	360;
	1945	1286	0.0043	0.00719	0.01602	51	51	51	0	0	1	-360	360;
	1770	1773	0.00264	0.00868	0.00088	62	62	62	0	0	1	-360	360;
	2082	1478	0.0581	0.13339	0.01261	39	39	39	0	0	1	-360	360;
	1680	1863	0.00388	0.01273	0.00129	62	62	62	0	0	1	-360	360;
	1692	1881	0.0005	0.00314	0.03081	97	97	97	0	0	1	-360	360;
	1693	1882	0.0005	0.00322	0.03119	97	97	97	0	0	1	-360	360;
	1170	1192	0.00397	0.01174	0.00144	62	62	62	0	0	1	-360	360;
	1886	1703	0.01802	0.0514	0.00687	62	62	62	0	0	1	-360	360;
	2152	1771	0.01884	0.03719	0.00532	39	39	39	0	0	1	-360	360;
	1842	1245	0.00678	0.01521	0.00235	51	51	51	0	0	1	-360	360;
	1604	1769	0.00678	0.02083	0.00898	62	62	62	0	0	1	-360	360;
	2160	2198	0.02008	0.05017	0.0053	51	51	51	0	0	1	-360	360;
	1286	1632	0.00058	0.00388	0.00044	98	98	98	0	0	1	-360	360;
	1609	1702	0.04446	0.10959	0.01193	51	51	51	0	0	1	-360	360;
	1754	2056	0.03273	0.10661	0.01082	62	62	62	0	0	1	-360	360;
	1368	1605	0.04942	0.16132	0.01634	62	62	62	0	0	1	-360	360;
	1297	2071	0.01174	0.03339	0.00449	62	62	62	0	0	1	-360	360;
	1575	1944	0.00264	0.00793	0.00093	62	62	62	0	0	1	-360	360;
	2046	1352	0.00281	0.00793	0.00103	39	39	39	0	0	1	-360	360;
	1539	1632	0.00074	0.00248	0.01621	81	81	81	0	0	1	-360	360;
	1540	1633	0.00074	0.00248	0.01632	81	81	81	0	0	1	-360	360;
	1457	2125	0.00091	0.00298	0.0003	62	62	62	0	0	1	-360	360;
	1458	2126	0.00091	0.00298	0.0003	62	62	62	0	0	1	-360	360;
	2096	2072	0.00942	0.02802	0.00346	62	62	62	0	0	1	-360	360;
	2073	1130	0.00157	0.00182	0.00039	39	39	39	0	0	1	-360	360;
	2072	1131	0.00149	0.00174	0.00037	39	39	39	0	0	1	-360	360;
	2073	1132	0.0005	0.00058	0.00012	39	39	39	0	0	1	-360	360;
	2073	1133	0.00107	0.00124	0.00027	39	39	39	0	0	1	-360	360;
	2097	2073	0.01116	0.02983	0.0036	51	51	51	0	0	1	-360	360;
	1221	2170	0.02314	0.02711	0.00583	39	39	39	0	0	1	-360	360;
	1554	1654	0.02215	0.03876	0.00878	51	51	51	0	0	1	-360	360;
	1161	1222	0.02083	0.02479	0.00517	39	39	39	0	0	1	-360	360;
	1299	1161	0.01851	0.05818	0.00631	39	39	39	0	0	1	-360	360;
	1159	1161	0.0005	0.00074	9e-05	39	39	39	0	0	1	-360	360;
	2072	1554	0.00694	0.01901	0.00195	51	51	51	0	0	1	-360	360;
	2092	1554	0.00686	0.0095	0.00185	39	39	39	0	0	1	-360	360;
	1412	2170	0.0005	0.00149	0.0002	57	57	57	0	0	1	-360	360;
	2096	1911	0.0057	0.01777	0.00198	62	62	62	0	0	1	-360	360;
	2096	1160	0.02124	0.06909	0.00708	39	39	39	0	0	1	-360	360;
	2050	1665	0.00256	0.00554	0.00084	57	57	57	0	0	1	-360	360;
	2051	1666	0.00198	0.00471	0.00069	57	57	57	0	0	1	-360	360;
	1413	2171	0.00058	0.00174	0.00023	57	57	57	0	0	1	-360	360;
	2171	1643	0.00512	0.01455	0.00197	62	62	62	0	0	1	-360	360;
	1783	1867	0.00364	0.01033	0.0014	62	62	62	0	0	1	-360	360;
	2097	1868	0.00595	0.01917	0.00201	62	62	62	0	0	1	-360	360;
	1544	1665	0.01	0.01562	0.00187	67	67	67	0	0	1	-360	360;
	1901	1543	0.02339	0.03066	0.00535	67	67	67	0	0	1	-360	360;
	1912	1379	0.00661	0.02058	0.00231	62	62	62	0	0	1	-360	360;
	1553	1891	0.00364	0.01041	0.0014	62	62	62	0	0	1	-360	360;
	1553	1767	0.00802	0.02273	0.00304	62	62	62	0	0	1	-360	360;
	1806	1766	0.01264	0.03446	0.00355	51	51	51	0	0	1	-360	360;
	1892	1378	0.00587	0.01669	0.00225	62	62	62	0	0	1	-360	360;
	1554	1971	0.02736	0.08909	0.00906	38	38	38	0	0	1	-360	360;
	1385	1807	0.00174	0.00479	0.0005	51	51	51	0	0	1	-360	360;
	1963	1385	0.02157	0.05752	0.0053	51	51	51	0	0	1	-360	360;
	1385	1384	0.00314	0.00364	0.00079	39	39	39	0	0	1	-360	360;
	2114	2096	0.0119	0.03752	0.00408	62	62	62	0	0	1	-360	360;
	2073	1553	0.00678	0.02074	0.00193	51	51	51	0	0	1	-360	360;
	1655	1665	0.02529	0.04355	0.01005	51	51	51	0	0	1	-360	360;
	2093	1782	0.00314	0.00893	0.0012	62	62	62	0	0	1	-360	360;
	1249	2097	0.0343	0.11	0.01158	62	62	62	0	0	1	-360	360;
	2097	1300	0.01455	0.04521	0.0051	62	62	62	0	0	1	-360	360;
	2096	1797	0.01959	0.06397	0.00647	62	62	62	0	0	1	-360	360;
	2146	1468	0.00355	0.01132	0.00123	99	99	99	0	0	1	-360	360;
	1577	1673	0.00198	0.00645	0.00065	75	75	75	0	0	1	-360	360;
	1664	1589	0.00091	0.00653	0.00065	115	115	115	0	0	1	-360	360;
	1936	1664	0.0043	0.03033	0.00319	115	115	115	0	0	1	-360	360;
	1662	1664	0.00314	0.00545	0.00053	47	47	47	0	0	1	-360	360;
	1907	1723	0.00959	0.02587	0.00288	63	63	63	0	0	1	-360	360;
	1198	1171	0.01041	0.02975	0.00393	75	75	75	0	0	1	-360	360;
	1937	2109	0.00264	0.00744	0.001	75	75	75	0	0	1	-360	360;
	1199	1172	0.01008	0.02884	0.00381	75	75	75	0	0	1	-360	360;
	1941	2176	0.01231	0.03215	0.00338	63	63	63	0	0	1	-360	360;
	1872	1759	0.0019	0.00612	0.00062	75	75	75	0	0	1	-360	360;
	2045	1872	0.00355	0.01165	0.00118	75	75	75	0	0	1	-360	360;
	1872	1870	0.00132	0.00322	0.00031	47	47	47	0	0	1	-360	360;
	1219	1333	0.00347	0.01124	0.00113	75	75	75	0	0	1	-360	360;
	1220	1334	0.00339	0.01116	0.00113	75	75	75	0	0	1	-360	360;
	2146	1684	0.00942	0.03008	0.00319	75	75	75	0	0	1	-360	360;
	1953	1781	0.00711	0.02074	0.00265	75	75	75	0	0	1	-360	360;
	1930	1953	0.00099	0.00289	0.00037	75	75	75	0	0	1	-360	360;
	1952	1953	0.00124	0.00347	0.00046	75	75	75	0	0	1	-360	360;
	1721	1276	0.00083	0.00231	0.00031	75	75	75	0	0	1	-360	360;
	1356	1358	0.00182	0.00512	0.00069	29	29	29	0	0	1	-360	360;
	1858	1504	0.00322	0.01025	0.00109	75	75	75	0	0	1	-360	360;
	1927	1858	0.00372	0.0114	0.00133	75	75	75	0	0	1	-360	360;
	1856	1858	0.0024	0.00719	0.00074	63	63	63	0	0	1	-360	360;
	2068	1275	0.01281	0.03661	0.00485	75	75	75	0	0	1	-360	360;
	2231	1588	0.01198	0.03917	0.00396	75	75	75	0	0	1	-360	360;
	1406	1347	0.00496	0.0162	0.00164	75	75	75	0	0	1	-360	360;
	1406	1348	0.00339	0.00959	0.00129	75	75	75	0	0	1	-360	360;
	2016	1267	0.00975	0.03083	0.00335	75	75	75	0	0	1	-360	360;
	1611	2085	0.00017	0.00058	6e-05	75	75	75	0	0	1	-360	360;
	1724	1611	0.00529	0.01645	0.00181	75	75	75	0	0	1	-360	360;
	1610	1611	0.00421	0.00711	0.00072	47	47	47	0	0	1	-360	360;
	1154	1849	0.01099	0.02496	0.00416	63	63	63	0	0	1	-360	360;
	1154	2065	0.00579	0.01802	0.00198	75	75	75	0	0	1	-360	360;
	1152	1154	0.00025	0.00074	0.0001	75	75	75	0	0	1	-360	360;
	1213	1406	0.00041	0.00132	0.00013	75	75	75	0	0	1	-360	360;
	1228	1213	0.00273	0.00785	0.00077	63	63	63	0	0	1	-360	360;
	1397	1228	0.00438	0.01438	0.00145	75	75	75	0	0	1	-360	360;
	1571	1397	0.00033	0.00099	0.00013	75	75	75	0	0	1	-360	360;
	1211	1213	0.00124	0.00364	0.00048	75	75	75	0	0	1	-360	360;
	1228	1227	0.00339	0.01107	0.00112	75	75	75	0	0	1	-360	360;
	1395	1397	0.00223	0.00678	0.00081	75	75	75	0	0	1	-360	360;
	2176	2143	0.0076	0.02306	0.00272	75	75	75	0	0	1	-360	360;
	1331	1557	0.00496	0.01413	0.0019	75	75	75	0	0	1	-360	360;
	2025	1890	0.00231	0.00744	0.00077	75	75	75	0	0	1	-360	360;
	1496	1951	0.00818	0.02017	0.00219	63	63	63	0	0	1	-360	360;
	2157	1496	0.00471	0.01182	0.00132	57	57	57	0	0	1	-360	360;
	1494	1496	0.00091	0.00215	0.00023	63	63	63	0	0	1	-360	360;
	1943	1138	0.00653	0.02058	0.00222	75	75	75	0	0	1	-360	360;
	2110	1583	0.01231	0.04033	0.00408	75	75	75	0	0	1	-360	360;
	1239	1941	0.02587	0.06818	0.00737	63	63	63	0	0	1	-360	360;
	1832	1264	0.00496	0.01496	0.00179	75	75	75	0	0	1	-360	360;
	1852	2215	0.0014	0.00322	0.00053	63	63	63	0	0	1	-360	360;
	2155	1528	0.00413	0.01289	0.00144	75	75	75	0	0	1	-360	360;
	2144	1981	0.0176	0.05686	0.00587	75	75	75	0	0	1	-360	360;
	1899	1220	0.00636	0.0205	0.00213	75	75	75	0	0	1	-360	360;
	1208	1849	0.0086	0.02802	0.00284	99	99	99	0	0	1	-360	360;
	2145	1850	0.0262	0.08496	0.00871	99	99	99	0	0	1	-360	360;
	1941	1652	0.01975	0.05372	0.00566	63	63	63	0	0	1	-360	360;
	2124	1652	0.0019	0.00595	0.00067	75	75	75	0	0	1	-360	360;
	1440	2124	0.00264	0.0086	0.0009	75	75	75	0	0	1	-360	360;
	2123	2124	8e-05	0.00017	2e-05	47	47	47	0	0	1	-360	360;
	1558	2146	0.01174	0.03537	0.00421	75	75	75	0	0	1	-360	360;
	1183	1306	0.00562	0.01736	0.00193	63	63	63	0	0	1	-360	360;
	2181	1284	0.00182	0.00587	0.00587	114	114	114	0	0	1	-360	360;
	1906	2181	0.0038	0.01215	0.00125	75	75	75	0	0	1	-360	360;
	1220	1906	0.00264	0.00818	0.00094	75	75	75	0	0	1	-360	360;
	2179	2181	8e-05	0.00017	2e-05	75	75	75	0	0	1	-360	360;
	1906	1905	0.00124	0.00364	0.00047	57	57	57	0	0	1	-360	360;
	1673	1785	0.0024	0.00727	0.00087	75	75	75	0	0	1	-360	360;
	2137	1232	0.00413	0.01355	0.00138	75	75	75	0	0	1	-360	360;
	1263	2137	0.00711	0.02322	0.00234	75	75	75	0	0	1	-360	360;
	2136	2137	0.00074	0.00231	0.00026	75	75	75	0	0	1	-360	360;
	2165	1296	0.00091	0.00273	0.00033	75	75	75	0	0	1	-360	360;
	1529	1296	0.00314	0.01355	0.00135	80	80	80	0	0	1	-360	360;
	1196	1529	0.00041	0.00124	0.00013	75	75	75	0	0	1	-360	360;
	1197	1530	0.00041	0.00132	0.00014	75	75	75	0	0	1	-360	360;
	1500	1295	0.00066	0.0024	0.00031	80	80	80	0	0	1	-360	360;
	1667	2196	0.01289	0.04099	0.00439	75	75	75	0	0	1	-360	360;
	1739	1830	0.01942	0.06355	0.00642	69	69	69	0	0	1	-360	360;
	1829	1849	0.02091	0.06826	0.00692	69	69	69	0	0	1	-360	360;
	2129	1724	0.00174	0.00504	0.00052	63	63	63	0	0	1	-360	360;
	1407	1256	0.0076	0.02281	0.00274	75	75	75	0	0	1	-360	360;
	1957	1588	0.00174	0.00504	0.00067	75	75	75	0	0	1	-360	360;
	1332	2220	0.00413	0.01182	0.00159	75	75	75	0	0	1	-360	360;
	1625	1145	0.01248	0.03967	0.00426	75	75	75	0	0	1	-360	360;
	1488	1350	0.00347	0.01008	0.00131	75	75	75	0	0	1	-360	360;
	2039	1488	0.00364	0.01174	0.00124	75	75	75	0	0	1	-360	360;
	1486	1488	0	0.00083	1e-05	75	75	75	0	0	1	-360	360;
	1820	2230	0.00471	0.01554	0.00157	75	75	75	0	0	1	-360	360;
	2086	1530	0.00446	0.01281	0.00175	75	75	75	0	0	1	-360	360;
	1668	1790	0.02769	0.07157	0.00735	63	63	63	0	0	1	-360	360;
	1144	1815	0.00083	0.00248	0.00032	75	75	75	0	0	1	-360	360;
	1145	1816	0.00083	0.00248	0.00033	75	75	75	0	0	1	-360	360;
	2176	2186	0.00554	0.01711	0.00194	75	75	75	0	0	1	-360	360;
	1896	1951	0.00612	0.01636	0.00185	63	63	63	0	0	1	-360	360;
	1811	1849	0.00314	0.00884	0.00119	75	75	75	0	0	1	-360	360;
	1146	1895	0.00074	0.00223	0.00027	75	75	75	0	0	1	-360	360;
	1147	1896	0.00066	0.00207	0.00025	75	75	75	0	0	1	-360	360;
	1380	1980	0.00033	0.00099	0.00013	75	75	75	0	0	1	-360	360;
	1381	1981	0.00033	0.00091	0.00012	75	75	75	0	0	1	-360	360;
	1581	1144	0.00033	0.00091	0.00012	75	75	75	0	0	1	-360	360;
	1582	1145	0.00041	0.00124	0.00016	75	75	75	0	0	1	-360	360;
	2041	2068	0.0043	0.01256	0.00157	75	75	75	0	0	1	-360	360;
	1325	1331	0.00017	0.0005	7e-05	75	75	75	0	0	1	-360	360;
	1326	1332	0.00017	0.00058	7e-05	75	75	75	0	0	1	-360	360;
	1318	1296	0.00066	0.00215	0.00022	75	75	75	0	0	1	-360	360;
	1319	1295	0.00066	0.00207	0.00021	75	75	75	0	0	1	-360	360;
	1529	1284	0.00355	0.01149	0.00116	75	75	75	0	0	1	-360	360;
	2105	2101	0.00413	0.01355	0.00136	75	75	75	0	0	1	-360	360;
	1799	1234	0.00479	0.01537	0.00163	75	75	75	0	0	1	-360	360;
	1644	2147	0.00149	0.00479	0.00048	75	75	75	0	0	1	-360	360;
	2234	1689	0.00091	0.00256	0.00033	75	75	75	0	0	1	-360	360;
	1527	2234	0.00463	0.01446	0.00163	75	75	75	0	0	1	-360	360;
	2232	2234	0	8e-05	0	75	75	75	0	0	1	-360	360;
	1219	1687	0.00488	0.01719	0.00191	75	75	75	0	0	1	-360	360;
	2300	2415	0.00064	0.00483	0.00047	123	123	123	0	0	1	-360	360;
	2628	2486	0.03347	0.05893	0.00578	78	78	78	0	0	1	-360	360;
	2777	2486	0.02959	0.05471	0.00503	78	78	78	0	0	1	-360	360;
	2777	2487	0.03306	0.0586	0.00557	78	78	78	0	0	1	-360	360;
	2592	2499	0.04802	0.10264	0.01344	55	55	55	0	0	1	-360	360;
	2499	2251	0.0138	0.02421	0.0023	55	55	55	0	0	1	-360	360;
	2304	2297	0.05636	0.10521	0.01021	78	78	78	0	0	1	-360	360;
	2705	2348	0.05893	0.12397	0.01197	78	78	78	0	0	1	-360	360;
	2299	2288	0.02174	0.05	0.00501	76	76	76	0	0	1	-360	360;
	2452	2288	0.03471	0.06744	0.00663	76	76	76	0	0	1	-360	360;
	2298	2246	0.01971	0.06676	0.00661	120	120	120	0	0	1	-360	360;
	2639	2253	0.02486	0.04348	0.00415	62	62	62	0	0	1	-360	360;
	2603	2290	0.02228	0.07545	0.00747	62	62	62	0	0	1	-360	360;
	2640	2295	0.02521	0.08264	0.00847	62	62	62	0	0	1	-360	360;
	2631	2670	0.02066	0.06686	0.00692	82	82	82	0	0	1	-360	360;
	2441	2493	0.05967	0.10455	0.00995	59	59	59	0	0	1	-360	360;
	2270	2788	0.02711	0.04612	0.00445	55	39	39	0	0	1	-360	360;
	2623	2788	0.03366	0.11402	0.01129	62	62	62	0	0	1	-360	360;
	2768	2512	0.02413	0.07851	0.0082	62	62	62	0	0	1	-360	360;
	2304	2302	0.01835	0.06256	0.00605	123	123	123	0	0	1	-360	360;
	2438	2543	0.02497	0.08457	0.00837	105	105	105	0	0	1	-360	360;
	2707	2626	0.02236	0.07573	0.0075	105	105	105	0	0	1	-360	360;
	2726	2535	0.01654	0.05601	0.00554	105	105	105	0	0	1	-360	360;
	2687	2726	0.02679	0.09072	0.00898	105	105	105	0	0	1	-360	360;
	2687	2319	0.01445	0.04894	0.00484	105	105	105	0	0	1	-360	360;
	2380	2726	0.02042	0.03616	0.00345	105	105	105	0	0	1	-360	360;
	2651	2523	0.03204	0.10852	0.01074	105	105	105	0	0	1	-360	360;
	2653	2563	0.01612	0.05281	0.00541	62	62	62	0	0	1	-360	360;
	2356	2607	0.0166	0.05623	0.00557	10	10	10	0	0	1	-360	360;
	2536	2447	0.10413	0.16851	0.01897	78	78	78	0	0	1	-360	360;
	2467	2724	0.0158	0.02764	0.00264	76	76	76	0	0	1	-360	360;
	2724	2389	0.1	0.16529	0.01822	76	76	76	0	0	1	-360	360;
	2465	2724	0.0157	0.04628	0.00501	76	76	76	0	0	1	-360	360;
	2522	2273	0.0338	0.05537	0.00595	67	67	67	0	0	1	-360	360;
	2522	2360	0.0157	0.04628	0.00501	69	69	69	0	0	1	-360	360;
	2448	2388	0.02893	0.04711	0.0053	78	78	78	0	0	1	-360	360;
	2720	2713	0.00055	0.00182	0.02683	118	118	118	0	0	1	-360	360;
	2647	2274	0.01198	0.04056	0.00401	123	123	123	0	0	1	-360	360;
	2589	2703	0.00266	0.00902	0.00089	123	123	123	0	0	1	-360	360;
	2590	2704	0.00266	0.00902	0.00089	123	123	123	0	0	1	-360	360;
	2749	2389	0.00354	0.00618	0.00059	78	78	78	0	0	1	-360	360;
	2714	2749	0.01327	0.02321	0.00221	78	78	78	0	0	1	-360	360;
	2749	2701	0.00241	0.00421	0.0004	78	78	78	0	0	1	-360	360;
	2751	2388	0.02584	0.0452	0.00431	78	78	78	0	0	1	-360	360;
	2751	2273	0.00416	0.00727	0.00069	78	78	78	0	0	1	-360	360;
	2751	2703	0.01653	0.029	0.00277	78	78	78	0	0	1	-360	360;
	2755	2704	0.01653	0.02897	0.00276	78	78	78	0	0	1	-360	360;
	2713	2755	0.02164	0.03784	0.00361	78	78	78	0	0	1	-360	360;
	2755	2274	0.00416	0.00727	0.00069	78	78	78	0	0	1	-360	360;
	2748	2533	0.00877	0.02969	0.00294	123	123	123	0	0	1	-360	360;
	2647	2748	0.00445	0.01505	0.00149	123	123	123	0	0	1	-360	360;
	2712	2748	0.00497	0.01683	0.00167	123	123	123	0	0	1	-360	360;
	2585	2274	0.0157	0.04793	0.00515	123	123	123	0	0	1	-360	360;
	2585	2532	0.00744	0.02397	0.00257	123	123	123	0	0	1	-360	360;
	2721	2679	0.0157	0.02727	0.00264	123	123	123	0	0	1	-360	360;
	2753	2532	0.0084	0.02843	0.00281	123	123	123	0	0	1	-360	360;
	2756	2693	0.00106	0.0036	0.00036	123	123	123	0	0	1	-360	360;
	2721	2756	0.00393	0.01332	0.00132	123	123	123	0	0	1	-360	360;
	2753	2756	0.00122	0.00414	0.00041	123	123	123	0	0	1	-360	360;
	2711	2753	0.00498	0.01687	0.00167	123	123	123	0	0	1	-360	360;
	2742	2533	0.00961	0.03256	0.00322	123	123	123	0	0	1	-360	360;
	2742	2680	0.00941	0.03188	0.00316	123	123	123	0	0	1	-360	360;
	2694	2742	0.00106	0.0036	0.00036	123	123	123	0	0	1	-360	360;
	2519	2532	0.02314	0.05868	0.00574	102	102	102	0	0	1	-360	360;
	2657	2533	0.01372	0.04446	0.00439	123	123	123	0	0	1	-360	360;
	2523	2533	0.02231	0.07182	0.00702	123	123	123	0	0	1	-360	360;
	2750	2533	0.02489	0.08432	0.00835	120	120	120	0	0	1	-360	360;
	2691	2750	0.01362	0.04612	0.00457	120	120	120	0	0	1	-360	360;
	2601	2532	0.0295	0.0999	0.00989	123	123	123	0	0	1	-360	360;
	2360	2495	0.00752	0.01256	0.0013	57	57	57	0	0	1	-360	360;
	2657	2493	0.06215	0.10504	0.01058	78	78	78	0	0	1	-360	360;
	2780	2519	0.03967	0.06942	0.00666	78	78	78	0	0	1	-360	360;
	2719	2679	0.00496	0.0157	0.0008	78	78	78	0	0	1	-360	360;
	2735	2274	0.01438	0.02405	0.00249	78	78	78	0	0	1	-360	360;
	2523	2735	0.03876	0.06463	0.00668	78	78	78	0	0	1	-360	360;
	2735	2494	0.01165	0.02124	0.00221	78	78	78	0	0	1	-360	360;
	2723	2389	0.01165	0.02038	0.00195	78	78	78	0	0	1	-360	360;
	2723	2680	0.009	0.01574	0.0015	78	78	78	0	0	1	-360	360;
	2354	2723	0.00149	0.0026	0.00025	78	78	78	0	0	1	-360	360;
	2743	2388	0.00326	0.0057	0.00054	78	78	78	0	0	1	-360	360;
	2743	2545	0.00334	0.00583	0.00056	78	78	78	0	0	1	-360	360;
	2700	2743	0.00856	0.01497	0.00143	78	78	78	0	0	1	-360	360;
	2718	2389	0.01157	0.01893	0.00201	78	78	78	0	0	1	-360	360;
	2725	2388	0.01121	0.01967	0.00187	78	78	78	0	0	1	-360	360;
	2719	2725	0.00021	0.00036	3e-05	78	78	78	0	0	1	-360	360;
	2353	2725	0.00161	0.00281	0.00027	78	78	78	0	0	1	-360	360;
	2699	2679	0.01523	0.0484	0.00476	123	123	123	0	0	1	-360	360;
	2696	2680	0.01157	0.03636	0.00399	102	102	102	0	0	1	-360	360;
	2695	2698	0.00707	0.02395	0.00237	123	123	123	0	0	1	-360	360;
	2696	2630	0.02562	0.08264	0.00854	123	123	123	0	0	1	-360	360;
	2630	2584	0.02149	0.06942	0.00711	120	120	120	0	0	1	-360	360;
	2544	2679	0.00992	0.01736	0.00172	78	78	78	0	0	1	-360	360;
	2718	2695	0.01983	0.0338	0.00329	78	78	78	0	0	1	-360	360;
	2389	2273	0.02561	0.04415	0.00429	78	78	78	0	0	1	-360	360;
	2757	2388	0.01774	0.0304	0.00298	78	78	78	0	0	1	-360	360;
	2247	2389	0.005	0.00879	0.00084	114	114	114	0	0	1	-360	360;
	2789	2621	0.0281	0.04876	0.00477	78	78	78	0	0	1	-360	360;
	2247	2789	0.023	0.04027	0.00384	78	78	78	0	0	1	-360	360;
	2670	2523	0.02546	0.08496	0.00635	123	123	123	0	0	1	-360	360;
	2337	2461	0.03771	0.12774	0.01265	123	123	123	0	0	1	-360	360;
	2543	2337	0.02896	0.10088	0.00999	123	123	123	0	0	1	-360	360;
	2566	2558	0.08066	0.14207	0.01348	120	120	120	0	0	1	-360	360;
	2697	2304	0.04116	0.10446	0.01043	102	102	102	0	0	1	-360	360;
	2781	2697	0.05808	0.10375	0.00991	78	78	78	0	0	1	-360	360;
	2707	2507	0.02504	0.04289	0.00428	120	120	120	0	0	1	-360	360;
	2656	2625	0.01661	0.0538	0.00557	91	91	91	0	0	1	-360	360;
	2293	2659	0.0157	0.05157	0.00528	123	123	123	0	0	1	-360	360;
	2659	2553	0.02479	0.08132	0.00834	120	120	120	0	0	1	-360	360;
	2734	2461	0.03891	0.06806	0.00649	78	78	78	0	0	1	-360	360;
	2734	2706	0.00102	0.00347	0.00034	78	78	78	0	0	1	-360	360;
	2734	2322	0.03237	0.05888	0.00583	78	78	78	0	0	1	-360	360;
	2502	2311	0.00292	0.00988	0.00098	102	102	102	0	0	1	-360	360;
	2310	2292	0.00603	0.01785	0.00183	102	102	102	0	0	1	-360	360;
	2674	2321	0.04207	0.14132	0.01394	120	120	120	0	0	1	-360	360;
	2674	2276	0.02992	0.10136	0.01003	120	120	120	0	0	1	-360	360;
	2276	2554	0.01165	0.03957	0.00392	91	91	91	0	0	1	-360	360;
	2257	2547	0.00372	0.01248	0.00116	102	102	102	0	0	1	-360	360;
	2282	2291	0.00537	0.01512	0.00153	102	102	102	0	0	1	-360	360;
	2677	2581	0.00413	0.01405	0.00138	123	123	123	0	0	1	-360	360;
	2282	2311	0.00074	0.00231	0.00024	123	123	123	0	0	1	-360	360;
	2770	2586	0.00711	0.01942	0.00201	102	102	102	0	0	1	-360	360;
	2240	2310	0.00499	0.01691	0.00147	123	123	123	0	0	1	-360	360;
	2738	2553	0.01917	0.06388	0.00598	123	123	123	0	0	1	-360	360;
	2738	2579	0.0038	0.01264	0.00119	123	123	123	0	0	1	-360	360;
	2738	2551	0.00116	0.0038	0.00038	123	123	123	0	0	1	-360	360;
	2779	2368	0.01455	0.05314	0.00523	120	120	120	0	0	1	-360	360;
	2492	2717	0.02008	0.06818	0.00674	10	10	10	0	0	1	-360	360;
	2521	2368	0.01711	0.05769	0.00567	123	123	123	0	0	1	-360	360;
	2624	2461	0.03196	0.05589	0.00533	78	78	78	0	0	1	-360	360;
	2624	2379	0.01848	0.03232	0.00308	69	69	69	0	0	1	-360	360;
	2379	2355	0.02901	0.05165	0.00489	78	78	78	0	0	1	-360	360;
	2498	2355	0.01661	0.0295	0.00288	78	78	78	0	0	1	-360	360;
	2579	2548	0.00793	0.02678	0.00264	123	123	123	0	0	1	-360	360;
	2551	2548	0.00864	0.0173	0.00166	78	78	78	0	0	1	-360	360;
	2518	2250	0.0376	0.0676	0.00651	78	78	78	0	0	1	-360	360;
	2552	2384	0.01413	0.04628	0.00475	123	123	123	0	0	1	-360	360;
	2524	2329	0.01	0.03479	0.00317	120	120	120	0	0	1	-360	360;
	2770	2240	0.0061	0.02065	0.00204	123	123	123	0	0	1	-360	360;
	2470	2260	0.02213	0.07514	0.00742	91	91	91	0	0	1	-360	360;
	2593	2260	0.04678	0.05793	0.00462	91	91	91	0	0	1	-360	360;
	2629	2627	0.05388	0.0943	0.00898	69	69	69	0	0	1	-360	360;
	2512	2329	0.0414	0.08355	0.00786	78	78	78	0	0	1	-360	360;
	2575	2546	0.00968	0.03279	0.00325	123	123	123	0	0	1	-360	360;
	2463	2461	0.00033	0.00041	0	78	78	78	0	0	1	-360	360;
	2249	2292	0.01165	0.03463	0.00356	78	78	78	0	0	1	-360	360;
	2569	2292	0.02204	0.07467	0.00739	91	91	91	0	0	1	-360	360;
	2312	2569	0.01214	0.04112	0.00407	123	123	123	0	0	1	-360	360;
	2641	2507	0.04033	0.06893	0.00692	91	91	91	0	0	1	-360	360;
	2697	2566	0.03364	0.08545	0.00874	91	91	91	0	0	1	-360	360;
	2740	2553	0.01669	0.03529	0.00341	69	69	69	0	0	1	-360	360;
	2740	2690	0.0576	0.12215	0.01179	69	69	69	0	0	1	-360	360;
	2697	2625	0.03529	0.06033	0.00605	78	78	78	0	0	1	-360	360;
	2344	2461	0.06808	0.1244	0.01294	78	78	78	0	0	1	-360	360;
	2627	2344	0.0043	0.01028	0.00143	78	78	78	0	0	1	-360	360;
	2384	2557	0.01612	0.05405	0.00532	120	120	120	0	0	1	-360	360;
	2707	2483	0.03967	0.06934	0.00663	78	78	78	0	0	1	-360	360;
	2613	2557	0.02397	0.04223	0.00414	78	78	78	0	0	1	-360	360;
	2613	2379	0.04645	0.08174	0.00801	69	69	69	0	0	1	-360	360;
	2269	2558	0.02276	0.0771	0.00763	120	120	120	0	0	1	-360	360;
	2641	2504	0.01124	0.03818	0.00378	120	120	120	0	0	1	-360	360;
	2628	2566	0.02347	0.05785	0.00593	102	102	102	0	0	1	-360	360;
	2551	2554	0.00983	0.03322	0.00328	123	123	123	0	0	1	-360	360;
	2312	2321	0.01393	0.04721	0.00467	120	120	120	0	0	1	-360	360;
	2319	2320	0.00688	0.02328	0.0023	120	120	120	0	0	1	-360	360;
	2629	2483	0.0343	0.06	0.00574	78	78	78	0	0	1	-360	360;
	2470	2461	0.00389	0.01322	0.0013	69	69	69	0	0	1	-360	360;
	2779	2554	0.0605	0.11818	0.01159	78	78	78	0	0	1	-360	360;
	2612	2384	0.00615	0.02083	0.00206	120	120	120	0	0	1	-360	360;
	2656	2612	0.00759	0.02569	0.00254	91	91	91	0	0	1	-360	360;
	2570	2310	0.00519	0.01413	0.00143	102	102	102	0	0	1	-360	360;
	2690	2491	0.06744	0.11802	0.01126	10	10	10	0	0	1	-360	360;
	2269	2524	0.01452	0.04917	0.00487	120	120	120	0	0	1	-360	360;
	2570	2503	0.00182	0.00455	0.00046	91	91	91	0	0	1	-360	360;
	2546	2311	0.00259	0.00876	0.00087	123	123	123	0	0	1	-360	360;
	2552	2576	0.0019	0.00603	0.00061	123	123	123	0	0	1	-360	360;
	2547	2440	0.00174	0.00479	0.00048	102	102	102	0	0	1	-360	360;
	2552	2291	0.00686	0.02198	0.00228	123	123	123	0	0	1	-360	360;
	2599	2518	0.01702	0.05512	0.00571	123	123	123	0	0	1	-360	360;
	2586	2577	0.01028	0.02164	0.0021	78	78	78	0	0	1	-360	360;
	2641	2310	0.01126	0.03814	0.00378	91	91	91	0	0	1	-360	360;
	2741	2575	0.00303	0.01029	0.00102	102	102	102	0	0	1	-360	360;
	2257	2741	0.00617	0.01736	0.00174	102	102	102	0	0	1	-360	360;
	2314	2558	0.00731	0.01279	0.00122	78	78	78	0	0	1	-360	360;
	2580	2558	0.00959	0.02474	0.00251	102	102	102	0	0	1	-360	360;
	2581	2557	0.00959	0.02474	0.00251	102	102	102	0	0	1	-360	360;
	2474	2557	0.01344	0.02383	0.00227	78	78	78	0	0	1	-360	360;
	2474	2578	0.00698	0.01279	0.00098	78	78	78	0	0	1	-360	360;
	2364	2558	0.00574	0.01944	0.00192	123	123	123	0	0	1	-360	360;
	2576	2505	0.00339	0.01099	0.00114	123	123	123	0	0	1	-360	360;
	2505	2311	0.00281	0.00909	0.00094	123	123	123	0	0	1	-360	360;
	2504	2578	0.01475	0.04998	0.00495	78	78	78	0	0	1	-360	360;
	2677	2576	0.00405	0.01339	0.00138	123	123	123	0	0	1	-360	360;
	2781	2293	0.01031	0.01797	0.00171	78	78	78	0	0	1	-360	360;
	2362	2580	0.00202	0.00325	0.02903	80	80	80	0	0	1	-360	360;
	2674	2599	0.0395	0.07231	0.00728	78	78	78	0	0	1	-360	360;
	2570	2289	0.00165	0.00537	0.00055	123	123	123	0	0	1	-360	360;
	2677	2289	0.00182	0.00595	0.00063	123	123	123	0	0	1	-360	360;
	2440	2364	0.00405	0.01331	0.00138	123	123	123	0	0	1	-360	360;
	2315	2578	0.02035	0.03558	0.0034	78	78	78	0	0	1	-360	360;
	2498	2577	0.02272	0.03973	0.00379	78	78	78	0	0	1	-360	360;
	2778	2237	0.00129	0.00374	0.00038	76	76	76	0	0	1	-360	360;
	2275	2778	0.02833	0.07349	0.00745	62	62	62	0	0	1	-360	360;
	2275	2375	0.02967	0.07661	0.00777	62	62	62	0	0	1	-360	360;
	2651	2385	0.02826	0.0957	0.00947	91	91	91	0	0	1	-360	360;
	2531	2328	0.01729	0.05855	0.0058	105	105	105	0	0	1	-360	360;
	2728	2376	0.00702	0.01752	0.00078	62	62	62	0	0	1	-360	360;
	2728	2528	0.02388	0.06711	0.00621	62	62	62	0	0	1	-360	360;
	2728	2454	0.00355	0.00959	0.0008	62	62	62	0	0	1	-360	360;
	2328	2529	0.02737	0.09213	0.00912	105	105	105	0	0	1	-360	360;
	2531	2385	0.01792	0.06144	0.00601	105	105	105	0	0	1	-360	360;
	2441	2529	0.03793	0.09752	0.00999	87	87	87	0	0	1	-360	360;
	2514	2403	0.01322	0.03289	0.00347	76	76	76	0	0	1	-360	360;
	2658	2238	0.00504	0.01413	0.00145	62	62	62	0	0	1	-360	360;
	2475	2776	0.03744	0.09653	0.00989	62	62	62	0	0	1	-360	360;
	2475	2367	0.02017	0.04959	0.00508	62	62	62	0	0	1	-360	360;
	2397	2366	0.01529	0.04967	0.00518	105	105	105	0	0	1	-360	360;
	2280	2404	0.03331	0.07982	0.00783	97	62	62	0	0	1	-360	360;
	2727	2534	0.03814	0.06671	0.00636	48	48	48	0	0	1	-360	360;
	2381	2727	0.00069	0.00235	0.00023	48	48	48	0	0	1	-360	360;
	2401	2727	8e-05	0.00014	1e-05	48	48	48	0	0	1	-360	360;
	2365	2535	0.01364	0.0238	0.00227	69	69	69	0	0	1	-360	360;
	2378	2535	0.00868	0.01512	0.00145	69	69	69	0	0	1	-360	360;
	2535	2404	0.00537	0.01545	0.00181	103	103	103	0	0	1	-360	360;
	2406	2366	0.02843	0.05207	0.00498	59	59	59	0	0	1	-360	360;
	2588	2406	0.02843	0.05207	0.00498	59	59	59	0	0	1	-360	360;
	2525	2529	0.00388	0.00669	0.00063	59	59	59	0	0	1	-360	360;
	2527	2528	0.0076	0.01802	0.00179	59	59	59	0	0	1	-360	360;
	2626	2280	0.01169	0.03957	0.00392	105	105	105	0	0	1	-360	360;
	2676	2534	0.00397	0.02917	0.00283	196	196	196	0	0	1	-360	360;
	2675	2351	0.00099	0.00793	0.00077	171	171	171	0	0	1	-360	360;
	2458	2241	0.03397	0.0862	0.00875	87	87	87	0	0	1	-360	360;
	2351	2405	0.0005	0.00397	0.00056	160	160	160	0	0	1	-360	360;
	2239	2237	0.01627	0.02831	0.0027	69	69	69	0	0	1	-360	360;
	2412	2394	0.00909	0.02645	0.00269	69	69	69	0	0	1	-360	360;
	2402	2237	0.03198	0.08107	0.00828	69	69	69	0	0	1	-360	360;
	2449	2402	0.00692	0.01922	0.00194	69	69	69	0	0	1	-360	360;
	2373	2375	0.00504	0.01421	0.0015	76	76	76	0	0	1	-360	360;
	2243	2449	0.01395	0.03998	0.00401	69	69	69	0	0	1	-360	360;
	2412	2243	0.01657	0.0489	0.0049	69	69	69	0	0	1	-360	360;
	2367	2366	0.0038	0.01215	0.00123	62	62	62	0	0	1	-360	360;
	2520	2529	0.01793	0.05818	0.00603	76	76	76	0	0	1	-360	360;
	2588	2528	0.06438	0.1138	0.01096	48	48	48	0	0	1	-360	360;
	2441	2439	0.0024	0.00413	0.00039	105	105	105	0	0	1	-360	360;
	2369	2238	0.01471	0.03736	0.00382	51	51	51	0	0	1	-360	360;
	2430	2369	0.02504	0.06364	0.00724	51	51	51	0	0	1	-360	360;
	2527	2526	0.01661	0.02917	0.00278	39	39	39	0	0	1	-360	360;
	2631	2520	0.01438	0.04653	0.00481	82	82	82	0	0	1	-360	360;
	2681	2514	0.03669	0.0943	0.00985	51	51	51	0	0	1	-360	360;
	2702	2386	0.02983	0.05463	0.00552	59	59	59	0	0	1	-360	360;
	2453	2296	0.00302	0.01	0.00102	82	82	82	0	0	1	-360	360;
	2377	2296	0.00161	0.00529	0.00054	82	82	82	0	0	1	-360	360;
	2377	2373	0.01645	0.04298	0.00443	76	76	76	0	0	1	-360	360;
	2540	2403	0.01033	0.03405	0.00348	76	76	76	0	0	1	-360	360;
	2681	2658	0.02289	0.06215	0.00636	51	51	51	0	0	1	-360	360;
	2439	2398	0.01752	0.05438	0.00564	105	105	105	0	0	1	-360	360;
	2596	2540	0.01463	0.04793	0.00491	82	82	82	0	0	1	-360	360;
	2650	2596	0.02207	0.07149	0.00747	82	82	82	0	0	1	-360	360;
	2650	2377	0.0176	0.05694	0.00575	82	82	82	0	0	1	-360	360;
	2619	2403	0.01603	0.04074	0.00411	87	87	87	0	0	1	-360	360;
	2506	2404	0.00975	0.03207	0.00329	62	62	62	0	0	1	-360	360;
	2776	2506	0.03488	0.09488	0.00972	62	62	62	0	0	1	-360	360;
	2441	2438	0.00653	0.02207	0.00216	91	91	91	0	0	1	-360	360;
	2619	2458	0.01348	0.0345	0.0035	87	87	87	0	0	1	-360	360;
	2452	2297	0.04669	0.09545	0.00939	76	76	76	0	0	1	-360	360;
	2433	2298	0.03397	0.05942	0.00567	78	78	78	0	0	1	-360	360;
	2617	2323	0.02736	0.09182	0.00907	78	78	78	0	0	1	-360	360;
	2638	2324	0.02719	0.08793	0.0091	123	123	123	0	0	1	-360	360;
	2433	2341	0.02967	0.04926	0.00486	78	78	78	0	0	1	-360	360;
	2638	2302	0.02521	0.08182	0.00917	123	123	123	0	0	1	-360	360;
	2736	2359	0.05945	0.10398	0.00992	76	76	76	0	0	1	-360	360;
	2251	2736	0.01877	0.03282	0.00313	76	76	76	0	0	1	-360	360;
	2500	2736	0.02111	0.0715	0.00708	76	76	76	0	0	1	-360	360;
	2733	2323	0.02473	0.054	0.00523	78	78	78	0	0	1	-360	360;
	2640	2733	0.05383	0.11001	0.01061	78	78	78	0	0	1	-360	360;
	2477	2733	0.00257	0.00449	0.00043	78	78	78	0	0	1	-360	360;
	2359	2323	0.0014	0.00463	0.00046	76	76	76	0	0	1	-360	360;
	2604	2603	0.02661	0.08661	0.00899	123	123	123	0	0	1	-360	360;
	2617	2487	0.02198	0.0738	0.00736	78	78	78	0	0	1	-360	360;
	2732	2324	0.03224	0.06998	0.00678	78	78	78	0	0	1	-360	360;
	2732	2710	0.06617	0.11573	0.01104	78	78	78	0	0	1	-360	360;
	2752	2433	0.0165	0.05588	0.00553	78	78	78	0	0	1	-360	360;
	2476	2732	0.00198	0.00345	0.00033	78	78	78	0	0	1	-360	360;
	2710	2752	0.01442	0.02521	0.00241	78	78	78	0	0	1	-360	360;
	2604	2341	0.03149	0.05215	0.00515	76	76	76	0	0	1	-360	360;
	2336	2323	0.0104	0.03704	0.00282	78	78	78	0	0	1	-360	360;
	2334	2336	0.00375	0.00656	0.00063	78	78	78	0	0	1	-360	360;
	2340	2324	0.00415	0.00726	0.00069	78	78	78	0	0	1	-360	360;
	2327	2340	0.00652	0.0114	0.00109	78	78	78	0	0	1	-360	360;
	2294	2496	0.01983	0.05504	0.00595	76	76	76	0	0	1	-360	360;
	2746	2652	0.01093	0.03048	0.00307	102	102	102	0	0	1	-360	360;
	2294	2746	0.00375	0.01025	0.00103	102	102	102	0	0	1	-360	360;
	2769	2746	0.00383	0.00669	0.00064	120	120	120	0	0	1	-360	360;
	2790	2574	0.01173	0.03052	0.00303	78	78	78	0	0	1	-360	360;
	2790	2497	0.04023	0.10277	0.01021	78	78	78	0	0	1	-360	360;
	2649	2497	0.0286	0.05322	0.00515	76	76	76	0	0	1	-360	360;
	2268	2300	9e-05	0.00069	7e-05	123	123	123	0	0	1	-360	360;
	2331	2268	0.00555	0.01818	0.00186	123	123	123	0	0	1	-360	360;
	2573	2317	0.0256	0.0784	0.00806	78	78	78	0	0	1	-360	360;
	2339	2574	0.00661	0.01826	0.00194	102	102	102	0	0	1	-360	360;
	2654	2317	0.0096	0.02474	0.00251	69	69	69	0	0	1	-360	360;
	2615	2317	0.00628	0.01058	0.00108	78	78	78	0	0	1	-360	360;
	2771	2318	0.01777	0.03157	0.00301	78	78	78	0	0	1	-360	360;
	2481	2497	0.02706	0.09164	0.00907	39	39	39	0	0	1	-360	360;
	2515	2481	0.02078	0.03802	0.00364	39	39	39	0	0	1	-360	360;
	2515	2313	0.04152	0.07429	0.0071	39	39	39	0	0	1	-360	360;
	2313	2597	0.05017	0.08774	0.00837	39	39	39	0	0	1	-360	360;
	2649	2299	0.04463	0.09421	0.00963	76	76	76	0	0	1	-360	360;
	2709	2597	0.02479	0.08041	0.00832	76	76	76	0	0	1	-360	360;
	2485	2597	0.03769	0.06554	0.00624	78	78	78	0	0	1	-360	360;
	2485	2325	0.06537	0.11488	0.01096	78	78	78	0	0	1	-360	360;
	2331	2294	0.02058	0.0676	0.00569	123	123	123	0	0	1	-360	360;
	2761	2565	0.01314	0.02554	0.00246	78	78	78	0	0	1	-360	360;
	2509	2655	0.01947	0.06595	0.00653	34	34	34	0	0	1	-360	360;
	2678	2277	0.02182	0.07107	0.00737	120	120	120	0	0	1	-360	360;
	2669	2574	0.00486	0.01645	0.00163	120	120	120	0	0	1	-360	360;
	2248	2573	0.00228	0.00772	0.00076	120	120	120	0	0	1	-360	360;
	2501	2598	0.02306	0.05736	0.00587	76	76	76	0	0	1	-360	360;
	2455	2318	0.00389	0.01319	0.00131	114	114	114	0	0	1	-360	360;
	2248	2455	0.01011	0.03425	0.00339	123	123	123	0	0	1	-360	360;
	2510	2317	0.0078	0.02641	0.00262	114	114	114	0	0	1	-360	360;
	2669	2510	0.00317	0.01073	0.00106	114	114	114	0	0	1	-360	360;
	2652	2573	0.00595	0.02016	0.002	76	76	76	0	0	1	-360	360;
	2564	2339	0.01289	0.03372	0.00333	102	102	102	0	0	1	-360	360;
	2399	2598	0.03397	0.0581	0.00559	72	72	72	0	0	1	-360	360;
	2399	2316	0.06926	0.12157	0.01174	78	78	78	0	0	1	-360	360;
	2761	2325	0.03983	0.06967	0.00666	78	78	78	0	0	1	-360	360;
	2633	2496	0.00813	0.02214	0.00223	55	55	55	0	0	1	-360	360;
	2632	2497	0.00813	0.02214	0.00223	55	55	55	0	0	1	-360	360;
	2592	2442	0.04961	0.1096	0.01071	55	55	55	0	0	1	-360	360;
	2709	2645	0.00752	0.01835	0.00196	78	78	78	0	0	1	-360	360;
	2648	2646	0.00752	0.01835	0.00196	78	78	78	0	0	1	-360	360;
	2655	2316	0.01818	0.05884	0.00612	120	120	120	0	0	1	-360	360;
	2565	2294	0.00926	0.0186	0.00181	76	76	76	0	0	1	-360	360;
	2754	2496	0.00697	0.0236	0.00234	55	55	55	0	0	1	-360	360;
	2442	2754	0.00574	0.01944	0.00192	55	55	55	0	0	1	-360	360;
	2648	2501	0.01107	0.02744	0.00281	102	102	102	0	0	1	-360	360;
	2678	2300	0.01289	0.04198	0.00436	120	120	120	0	0	1	-360	360;
	2614	2484	0.00802	0.02174	0.0022	78	78	78	0	0	1	-360	360;
	2484	2318	0.00843	0.02298	0.00232	78	78	78	0	0	1	-360	360;
	2471	2496	0.02264	0.07355	0.00762	120	120	120	0	0	1	-360	360;
	2277	2246	0.0318	0.07979	0.00779	120	120	120	0	0	1	-360	360;
	2279	2497	0.05033	0.13388	0.01203	61	61	61	0	0	1	-360	360;
	2682	2279	0.02851	0.09843	0.00896	120	120	120	0	0	1	-360	360;
	2598	2496	0.0343	0.24545	0.02408	120	120	120	0	0	1	-360	360;
	2771	2564	0.00818	0.02149	0.00212	102	102	102	0	0	1	-360	360;
	2459	2765	0.04876	0.06942	0.01254	120	120	120	0	0	1	-360	360;
	2591	2766	0.01979	0.03629	0.00348	78	78	78	0	0	1	-360	360;
	2722	2766	0.02364	0.05992	0.00618	102	102	102	0	0	1	-360	360;
	2747	2309	0.00044	0.00112	0.00011	102	102	102	0	0	1	-360	360;
	2722	2747	0.00246	0.00659	0.00067	102	102	102	0	0	1	-360	360;
	2255	2722	0.00405	0.01306	0.00136	120	120	120	0	0	1	-360	360;
	2763	2766	0.02231	0.07557	0.00748	123	123	123	0	0	1	-360	360;
	2621	2765	0.02835	0.09504	0.00937	123	123	123	0	0	1	-360	360;
	2516	2765	0.03025	0.10165	0.01002	120	120	120	0	0	1	-360	360;
	2783	2644	0.0157	0.02727	0.00286	69	69	69	0	0	1	-360	360;
	2673	2549	0.01201	0.02671	0.00259	120	120	120	0	0	1	-360	360;
	2672	2643	0.01127	0.02548	0.00247	78	78	78	0	0	1	-360	360;
	2622	2643	0.0081	0.02742	0.00272	114	114	114	0	0	1	-360	360;
	2636	2643	0.02975	0.04207	0.00404	69	69	69	0	0	1	-360	360;
	2587	2644	0.04959	0.08678	0.009	69	69	69	0	0	1	-360	360;
	2587	2537	0.04207	0.07025	0.00733	69	69	69	0	0	1	-360	360;
	2255	2644	0.03898	0.10313	0.01043	102	102	102	0	0	1	-360	360;
	2610	2643	0.01467	0.0404	0.00628	78	78	78	0	0	1	-360	360;
	2636	2370	0.05124	0.08182	0.00949	78	78	78	0	0	1	-360	360;
	2244	2258	0.00661	0.01983	0.0023	120	120	120	0	0	1	-360	360;
	2541	2643	0.01405	0.02727	0.00278	78	78	78	0	0	1	-360	360;
	2541	2259	0.02479	0.04298	0.00423	78	78	78	0	0	1	-360	360;
	2480	2258	0.03223	0.05537	0.00307	78	78	78	0	0	1	-360	360;
	2244	2644	0.01762	0.04135	0.00402	78	78	78	0	0	1	-360	360;
	2549	2259	0.01135	0.03509	0.00346	120	120	120	0	0	1	-360	360;
	2684	2259	0.00992	0.02066	0.00218	91	91	91	0	0	1	-360	360;
	2374	2259	0.01753	0.05936	0.00588	123	123	123	0	0	1	-360	360;
	2602	2684	0.00992	0.02314	0.00261	91	91	91	0	0	1	-360	360;
	2602	2517	0.0338	0.08099	0.00927	91	91	91	0	0	1	-360	360;
	2618	2332	0.0281	0.08926	0.00924	114	114	114	0	0	1	-360	360;
	2482	2332	0.01405	0.04463	0.0046	120	120	120	0	0	1	-360	360;
	2618	2517	0.01818	0.04132	0.00465	114	114	114	0	0	1	-360	360;
	2482	2258	0.01157	0.0281	0.00286	102	102	102	0	0	1	-360	360;
	2618	2382	0.02479	0.03471	0.00419	78	78	78	0	0	1	-360	360;
	2272	2383	0.03793	0.06612	0.00641	78	78	78	0	0	1	-360	360;
	2305	2383	0.03853	0.06806	0.0065	78	78	78	0	0	1	-360	360;
	2444	2305	0.02515	0.0455	0.00437	120	120	120	0	0	1	-360	360;
	2459	2271	0.01405	0.04463	0.00484	120	120	120	0	0	1	-360	360;
	2671	2747	0.00775	0.02625	0.0026	102	102	102	0	0	1	-360	360;
	2357	2622	0.00826	0.01653	0.00194	120	120	120	0	0	1	-360	360;
	2308	2610	0.03764	0.09704	0.00984	78	78	78	0	0	1	-360	360;
	2356	2784	0.01676	0.05678	0.00562	123	123	123	0	0	1	-360	360;
	2451	2766	0.01335	0.0452	0.00447	120	120	120	0	0	1	-360	360;
	2775	2489	0.01317	0.0446	0.00442	123	123	123	0	0	1	-360	360;
	2715	2253	0.02744	0.10017	0.00953	114	114	114	0	0	1	-360	360;
	2716	2287	0.0062	0.02008	0.00293	114	114	114	0	0	1	-360	360;
	2254	2489	0.05489	0.14743	0.01489	102	102	102	0	0	1	-360	360;
	2252	2490	0.04902	0.12753	0.01292	102	102	102	0	0	1	-360	360;
	2667	2489	0.00514	0.03512	0.0079	196	196	196	0	0	1	-360	360;
	2668	2490	0.00514	0.03512	0.0079	196	196	196	0	0	1	-360	360;
	2456	2489	0.03223	0.07769	0.0044	123	123	123	0	0	1	-360	360;
	2266	2490	0.02727	0.0686	0.00666	102	102	102	0	0	1	-360	360;
	2663	2661	0.00331	0.00992	0.00099	123	123	123	0	0	1	-360	360;
	2660	2668	0.00413	0.00909	0.00094	123	123	123	0	0	1	-360	360;
	2663	2667	0.00413	0.00992	0.00099	123	123	123	0	0	1	-360	360;
	2664	2667	0.00413	0.01074	0.00099	123	123	123	0	0	1	-360	360;
	2664	2662	0.00413	0.01157	0.00104	123	123	123	0	0	1	-360	360;
	2418	2254	0.01074	0.03471	0.00356	114	114	114	0	0	1	-360	360;
	2689	2252	0.00945	0.02846	0.0028	78	78	78	0	0	1	-360	360;
	2254	2253	0.0065	0.02202	0.00218	120	120	120	0	0	1	-360	360;
	2568	2287	0.01319	0.04467	0.00442	123	123	123	0	0	1	-360	360;
	2775	2568	0.0126	0.04265	0.00422	123	123	123	0	0	1	-360	360;
	2479	2456	0.02562	0.07851	0.00842	123	123	123	0	0	1	-360	360;
	2595	2479	0.0124	0.04132	0.00419	120	120	120	0	0	1	-360	360;
	2267	2283	0.03669	0.09165	0.0094	102	102	102	0	0	1	-360	360;
	2685	2372	0.00661	0.0157	0.00165	102	102	102	0	0	1	-360	360;
	2371	2283	0.00592	0.01857	0.00199	78	78	78	0	0	1	-360	360;
	2685	2283	0.00157	0.00512	0.00053	120	120	120	0	0	1	-360	360;
	2686	2283	0.00153	0.00493	0.0005	120	120	120	0	0	1	-360	360;
	2371	2363	0.00579	0.01322	0.00138	78	78	78	0	0	1	-360	360;
	2407	2283	0.02719	0.04917	0.00478	78	78	78	0	0	1	-360	360;
	2538	2283	0.0129	0.02274	0.0022	78	78	78	0	0	1	-360	360;
	2539	2283	0.01204	0.02472	0.00244	78	78	78	0	0	1	-360	360;
	2488	2363	0.02893	0.05124	0.00469	78	78	78	0	0	1	-360	360;
	2488	2480	0.0157	0.02727	0.00252	78	78	78	0	0	1	-360	360;
	2407	2374	0.01893	0.0595	0.00656	120	120	120	0	0	1	-360	360;
	2480	2374	0.01405	0.02314	0.00232	78	78	78	0	0	1	-360	360;
	2457	2374	0.009	0.03048	0.00302	69	69	69	0	0	1	-360	360;
	2663	2666	0.00909	0.0314	0.00327	123	123	123	0	0	1	-360	360;
	2664	2665	0.0124	0.0405	0.00416	123	123	123	0	0	1	-360	360;
	2616	2538	0.00636	0.02155	0.00213	91	91	91	0	0	1	-360	360;
	2395	2572	0.01028	0.01795	0.00171	78	78	78	0	0	1	-360	360;
	2391	2571	0.01334	0.0339	0.00343	102	102	102	0	0	1	-360	360;
	2737	2571	0.01249	0.03219	0.00326	102	102	102	0	0	1	-360	360;
	2392	2737	0.0006	0.00103	0.0001	102	102	102	0	0	1	-360	360;
	2730	2737	0.00435	0.0076	0.00073	102	102	102	0	0	1	-360	360;
	2446	2730	0.0004	0.00069	7e-05	102	102	102	0	0	1	-360	360;
	2739	2730	0.00221	0.00746	0.00074	102	102	102	0	0	1	-360	360;
	2634	2739	0.0085	0.01485	0.00142	102	102	102	0	0	1	-360	360;
	2583	2739	0.0082	0.02777	0.00275	102	102	102	0	0	1	-360	360;
	2408	2571	0.00257	0.00449	0.00043	102	102	102	0	0	1	-360	360;
	2390	2396	0.00455	0.01263	0.00127	102	102	102	0	0	1	-360	360;
	2409	2572	0.00257	0.00449	0.00043	102	102	102	0	0	1	-360	360;
	2421	2426	0.01176	0.02107	0.00202	78	78	78	0	0	1	-360	360;
	2410	2571	0.00257	0.00449	0.00043	102	102	102	0	0	1	-360	360;
	2421	2424	0.01803	0.06109	0.00605	78	78	78	0	0	1	-360	360;
	2562	2572	0.00154	0.00521	0.00052	123	123	123	0	0	1	-360	360;
	2420	2572	0.00248	0.00661	0.00068	123	123	123	0	0	1	-360	360;
	2419	2571	0.00248	0.00661	0.00068	123	123	123	0	0	1	-360	360;
	2562	2434	0.00697	0.0236	0.00234	123	123	123	0	0	1	-360	360;
	2427	2572	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2426	2571	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2559	2572	0.00012	0.0004	4e-05	123	123	123	0	0	1	-360	360;
	2560	2571	0.0001	0.00031	3e-05	123	123	123	0	0	1	-360	360;
	2422	2572	0.00579	0.01818	0.00186	120	120	120	0	0	1	-360	360;
	2731	2286	0.0207	0.07012	0.00694	123	123	123	0	0	1	-360	360;
	2466	2731	0.00349	0.0118	0.00117	123	123	123	0	0	1	-360	360;
	2464	2731	0.00615	0.02083	0.00206	123	123	123	0	0	1	-360	360;
	2691	2608	0.02479	0.07686	0.00835	120	120	120	0	0	1	-360	360;
	2342	2609	0.02893	0.08843	0.00973	120	120	120	0	0	1	-360	360;
	2416	2393	0.00676	0.02291	0.00227	120	120	120	0	0	1	-360	360;
	2416	2425	0.00369	0.0125	0.00124	123	123	123	0	0	1	-360	360;
	2419	2425	0.00522	0.0177	0.00175	123	123	123	0	0	1	-360	360;
	2729	2572	0.00061	0.00208	0.00021	120	120	120	0	0	1	-360	360;
	2411	2729	0.00102	0.00347	0.00034	120	120	120	0	0	1	-360	360;
	2414	2729	0.00431	0.01388	0.00116	120	120	120	0	0	1	-360	360;
	2437	2571	0.00942	0.03193	0.00316	120	120	120	0	0	1	-360	360;
	2436	2413	0.00645	0.02187	0.00216	120	120	120	0	0	1	-360	360;
	2281	2417	0.02439	0.06359	0.01204	123	123	123	0	0	1	-360	360;
	2786	2537	0.01902	0.04153	0.00864	120	120	120	0	0	1	-360	360;
	2595	2417	0.00579	0.01893	0.00191	76	76	76	0	0	1	-360	360;
	2468	2537	0.01718	0.03006	0.00287	76	76	76	0	0	1	-360	360;
	2469	2537	0.0157	0.02562	0.00227	120	120	120	0	0	1	-360	360;
	2469	2466	0.00826	0.0124	0.00128	120	120	120	0	0	1	-360	360;
	2785	2536	0.02209	0.05774	0.00565	76	76	76	0	0	1	-360	360;
	2349	2536	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2350	2537	0.00435	0.0076	0.00072	69	69	69	0	0	1	-360	360;
	2370	2536	0.04628	0.07686	0.00755	76	76	76	0	0	1	-360	360;
	2345	2788	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2346	2787	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2264	2788	0.00661	0.00909	0.00116	120	120	120	0	0	1	-360	360;
	2782	2264	0.00744	0.02397	0.00244	120	120	120	0	0	1	-360	360;
	2432	2429	0.00359	0.01215	0.0012	123	123	123	0	0	1	-360	360;
	2347	2787	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2348	2788	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2744	2787	0.00615	0.02083	0.0023	120	120	120	0	0	1	-360	360;
	2435	2744	0.00769	0.02603	0.00258	120	120	120	0	0	1	-360	360;
	2431	2744	0.00031	0.00104	0.0001	120	120	120	0	0	1	-360	360;
	2429	2788	0.00909	0.02727	0.0029	120	120	120	0	0	1	-360	360;
	2436	2428	0.00992	0.03058	0.00329	120	120	120	0	0	1	-360	360;
	2563	2787	0.02479	0.08008	0.0083	114	114	114	0	0	1	-360	360;
	2261	2787	0.01499	0.03154	0.0031	78	78	78	0	0	1	-360	360;
	2343	2787	0.04298	0.10248	0.0105	78	78	78	0	0	1	-360	360;
	2782	2424	0.00287	0.00972	0.00096	114	114	114	0	0	1	-360	360;
	2536	2285	0.03719	0.11901	0.0122	114	114	114	0	0	1	-360	360;
	2281	2286	0.06463	0.10992	0.01059	123	123	123	0	0	1	-360	360;
	2278	2285	0.03322	0.05661	0.00545	120	120	120	0	0	1	-360	360;
	2445	2286	0.01783	0.06021	0.00596	90	90	90	0	0	1	-360	360;
	2582	2285	0.00759	0.02569	0.00254	120	120	120	0	0	1	-360	360;
	2745	2423	0.01209	0.04096	0.00406	120	120	120	0	0	1	-360	360;
	2745	2286	0.00687	0.02326	0.0023	120	120	120	0	0	1	-360	360;
	2635	2745	0.00553	0.00967	0.00092	120	120	120	0	0	1	-360	360;
	2393	2285	0.0157	0.04959	0.00511	120	120	120	0	0	1	-360	360;
	2609	2286	0.00413	0.0314	0.003	137	137	137	0	0	1	-360	360;
	2600	2285	0.06583	0.22298	0.02208	123	123	123	0	0	1	-360	360;
	2584	2286	0.02066	0.06612	0.00678	120	120	120	0	0	1	-360	360;
	2396	2414	0.01642	0.05563	0.00551	123	123	123	0	0	1	-360	360;
	2330	2278	0.01214	0.04112	0.00407	123	123	123	0	0	1	-360	360;
	2387	2760	0.03124	0.10231	0.01048	62	62	62	0	0	1	-360	360;
	2290	2306	0.04421	0.11367	0.01112	62	62	62	0	0	1	-360	360;
	2400	2306	0.01033	0.01802	0.00172	39	39	39	0	0	1	-360	360;
	2773	2478	0.01256	0.0219	0.00212	39	39	39	0	0	1	-360	360;
	2774	2772	0.01008	0.01736	0.00172	39	39	39	0	0	1	-360	360;
	2561	2473	0.02	0.03744	0.00365	39	39	39	0	0	1	-360	360;
	2772	2561	0.00793	0.01537	0.0015	39	39	39	0	0	1	-360	360;
	2774	2773	0.01083	0.01893	0.00181	39	39	39	0	0	1	-360	360;
	2478	2472	0.02818	0.05818	0.0059	39	39	39	0	0	1	-360	360;
	2338	2306	0.05702	0.11331	0.01091	39	39	39	0	0	1	-360	360;
	2605	2472	0.03934	0.12917	0.0132	97	62	62	0	0	1	-360	360;
	2606	2605	0.00595	0.01917	0.00198	97	62	62	0	0	1	-360	360;
	2400	2472	0.0362	0.06339	0.00612	39	39	39	0	0	1	-360	360;
	2606	2767	0.02743	0.08885	0.00915	62	62	62	0	0	1	-360	360;
	2708	2620	0.04033	0.13661	0.01353	62	62	62	0	0	1	-360	360;
	2762	2358	0.01157	0.03942	0.0039	62	62	62	0	0	1	-360	360;
	2338	2242	0.03507	0.11878	0.01176	62	62	62	0	0	1	-360	360;
	2242	2473	0.04107	0.13909	0.01377	62	62	62	0	0	1	-360	360;
	2511	2270	0.0295	0.05017	0.00484	55	39	39	0	0	1	-360	360;
	2760	2358	0.01132	0.03744	0.0037	62	62	62	0	0	1	-360	360;
	2642	2768	0.00107	0.00121	0.01087	120	120	120	0	0	1	-360	360;
	2759	2473	0.01421	0.04661	0.00477	62	62	62	0	0	1	-360	360;
	2759	2620	0.01777	0.05818	0.00595	62	62	62	0	0	1	-360	360;
	2513	2387	0.02269	0.06221	0.00629	39	39	39	0	0	1	-360	360;
	2265	2473	0.02099	0.06934	0.00699	62	62	62	0	0	1	-360	360;
	2295	2265	0.01711	0.05562	0.0048	62	62	62	0	0	1	-360	360;
	2760	2653	0.02496	0.08446	0.00847	62	62	62	0	0	1	-360	360;
	2708	2623	0.03174	0.1075	0.01064	62	62	62	0	0	1	-360	360;
	2508	2472	0.02595	0.08512	0.00874	10	10	10	0	0	1	-360	360;
	2513	2511	0.00943	0.01889	0.00185	39	39	39	0	0	1	-360	360;
	2762	2242	0.01769	0.05744	0.00596	62	62	62	0	0	1	-360	360;
	2262	2762	0.05234	0.09155	0.00873	20	20	20	0	0	1	-360	360;
	3031	3098	0.03562	0.10942	0.01146	69	69	69	0	0	1	-360	360;
	2929	3071	0.03678	0.09397	0.00951	102	102	102	0	0	1	-360	360;
	3043	2994	0.00207	0.00727	0.0007	123	123	123	0	0	1	-360	360;
	2994	2820	0.01851	0.0595	0.00627	123	123	123	0	0	1	-360	360;
	2920	2801	0.021	0.0679	0.00696	101	101	101	0	0	1	-360	360;
	3021	3025	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2797	3100	0.06645	0.17719	0.01791	70	70	70	0	0	1	-360	360;
	3016	3101	0.03957	0.12859	0.01319	123	123	123	0	0	1	-360	360;
	2979	2943	0.03364	0.10897	0.0112	114	114	114	0	0	1	-360	360;
	2910	2867	0.04	0.12959	0.01329	102	102	102	0	0	1	-360	360;
	2873	2975	0.00992	0.03322	0.00419	107	107	107	0	0	1	-360	360;
	2911	2868	0.04025	0.13025	0.01336	102	102	102	0	0	1	-360	360;
	2977	2901	0.03545	0.08736	0.00882	101	101	101	0	0	1	-360	360;
	3102	3101	0.01264	0.03802	0.00273	69	69	69	0	0	1	-360	360;
	2872	3102	0.03306	0.08264	0.00968	69	69	69	0	0	1	-360	360;
	2947	2873	0.04669	0.08182	0.00774	90	90	90	0	0	1	-360	360;
	2823	2813	0.03413	0.05992	0.00566	48	48	48	0	0	1	-360	360;
	2837	2948	0.03587	0.05868	0.00646	78	78	78	0	0	1	-360	360;
	2836	2843	0.1	0.1595	0.01597	57	57	57	0	0	1	-360	360;
	3067	2962	0.0395	0.1281	0.01314	62	62	62	0	0	1	-360	360;
	2948	2812	0.03124	0.05603	0.00563	78	78	78	0	0	1	-360	360;
	3079	2833	0.0214	0.06887	0.00708	69	69	69	0	0	1	-360	360;
	3062	3079	0.01686	0.05427	0.00558	69	69	69	0	0	1	-360	360;
	2976	3079	0.00026	0.00066	7e-05	69	69	69	0	0	1	-360	360;
	2822	2821	0.01223	0.0386	0.0042	69	69	69	0	0	1	-360	360;
	2965	2829	0.02883	0.09322	0.00956	69	69	69	0	0	1	-360	360;
	3016	2826	0.01824	0.05899	0.00605	69	69	69	0	0	1	-360	360;
	2873	3042	0.02455	0.07992	0.00823	123	123	123	0	0	1	-360	360;
	2813	3059	0.06843	0.09157	0.0084	69	69	69	0	0	1	-360	360;
	3059	3097	0.08653	0.11405	0.01019	69	69	69	0	0	1	-360	360;
	2930	2904	0.00785	0.01983	0.00203	102	102	102	0	0	1	-360	360;
	2973	2996	0.01033	0.02653	0.00269	69	69	69	0	0	1	-360	360;
	2950	2973	0.02231	0.05702	0.00576	102	102	102	0	0	1	-360	360;
	2949	3013	0.03099	0.07901	0.00801	102	102	102	0	0	1	-360	360;
	2794	2908	0.00264	0.00752	0.00075	102	102	102	0	0	1	-360	360;
	2898	2877	0.03025	0.06281	0.00061	102	102	102	0	0	1	-360	360;
	2875	2802	0.00331	0.01083	0.00109	114	114	114	0	0	1	-360	360;
	2887	2878	0.04124	0.07231	0.00687	69	69	69	0	0	1	-360	360;
	2876	2810	0.0186	0.0562	0.00581	102	102	102	0	0	1	-360	360;
	2945	2967	0.02479	0.08	0.00823	123	123	123	0	0	1	-360	360;
	2794	3013	0.01314	0.04182	0.00448	102	102	102	0	0	1	-360	360;
	3012	2972	0.00942	0.03066	0.00315	76	76	76	0	0	1	-360	360;
	3011	2940	0.02901	0.09438	0.00966	123	123	123	0	0	1	-360	360;
	2808	2878	0.00421	0.01058	0.00106	102	102	102	0	0	1	-360	360;
	3084	2877	0.00736	0.0238	0.00244	123	123	123	0	0	1	-360	360;
	3083	2794	0.00157	0.00496	0.00051	123	123	123	0	0	1	-360	360;
	3083	2795	0.00157	0.00496	0.00051	123	123	123	0	0	1	-360	360;
	2802	2808	0.00306	0.00992	0.00102	123	123	123	0	0	1	-360	360;
	2944	2931	0.00826	0.02628	0.00286	120	120	120	0	0	1	-360	360;
	2855	2944	0.0181	0.05702	0.0062	120	120	120	0	0	1	-360	360;
	2908	2878	0.00405	0.01058	0.00109	102	102	102	0	0	1	-360	360;
	2799	2795	0.00231	0.00752	0.00077	123	123	123	0	0	1	-360	360;
	3007	2799	0.00397	0.01298	0.00131	123	123	123	0	0	1	-360	360;
	2896	2887	0.00361	0.01166	0.0012	114	114	114	0	0	1	-360	360;
	3019	2896	0.06898	0.12121	0.01145	78	78	78	0	0	1	-360	360;
	2819	3019	0.06661	0.11306	0.01118	69	69	69	0	0	1	-360	360;
	2995	2898	0.01322	0.03306	0.00327	69	69	69	0	0	1	-360	360;
	3097	2995	0.05686	0.09339	0.00944	76	76	76	0	0	1	-360	360;
	3043	2877	0.0376	0.12165	0.01249	123	123	123	0	0	1	-360	360;
	3057	2940	0.03058	0.05372	0.00508	78	78	78	0	0	1	-360	360;
	2973	2880	0.00851	0.02074	0.00232	102	102	102	0	0	1	-360	360;
	2880	3040	0.0405	0.09669	0.01016	102	102	102	0	0	1	-360	360;
	3074	2916	0.04008	0.10174	0.01033	99	99	99	0	0	1	-360	360;
	2807	3007	0.00198	0.00628	0.00065	123	123	123	0	0	1	-360	360;
	2793	2807	0.00653	0.02116	0.0022	123	123	123	0	0	1	-360	360;
	2996	2930	0.00926	0.0238	0.00242	69	69	69	0	0	1	-360	360;
	3094	2972	0.06223	0.10413	0.01072	69	69	69	0	0	1	-360	360;
	2885	3094	0.04702	0.07851	0.00808	69	69	69	0	0	1	-360	360;
	2813	2819	0.00545	0.0076	0.00077	69	69	69	0	0	1	-360	360;
	2972	2931	0.0162	0.0338	0.00351	78	78	78	0	0	1	-360	360;
	3011	2989	0.02781	0.08994	0.01845	123	123	123	0	0	1	-360	360;
	2793	2810	0.01397	0.04463	0.00462	123	123	123	0	0	1	-360	360;
	2967	2809	0.00868	0.0281	0.00295	76	76	76	0	0	1	-360	360;
	3006	3019	0.01607	0.05279	0.01083	69	69	69	0	0	1	-360	360;
	2991	3006	0.034	0.10995	0.02256	69	69	69	0	0	1	-360	360;
	2840	2877	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	2841	2878	0.00562	0.01893	0.00189	16	16	16	0	0	1	-360	360;
	3085	2794	0.00215	0.00719	0.00072	16	16	16	0	0	1	-360	360;
	3003	2878	0.00091	0.00306	0.00031	10	10	10	0	0	1	-360	360;
	2901	2904	0.00661	0.01372	0.00133	102	102	102	0	0	1	-360	360;
	3046	2810	0.0205	0.06876	0.00688	123	123	123	0	0	1	-360	360;
	2806	2813	0.0374	0.12066	0.01272	123	123	123	0	0	1	-360	360;
	3046	2991	0.01928	0.06236	0.0064	123	123	123	0	0	1	-360	360;
	2821	2806	0.02269	0.07306	0.00777	123	123	123	0	0	1	-360	360;
	2832	3074	0.0057	0.01017	0.00094	122	122	122	0	0	1	-360	360;
	3072	2832	0.00967	0.01702	0.0016	122	122	122	0	0	1	-360	360;
	2883	3073	0.05769	0.14545	0.015	76	76	76	0	0	1	-360	360;
	3099	3074	0.00282	0.00717	0.00079	90	90	90	0	0	1	-360	360;
	2923	3099	0.03198	0.07876	0.00786	90	90	90	0	0	1	-360	360;
	3070	3073	0.01843	0.06	0.00615	137	137	137	0	0	1	-360	360;
	3052	3054	0.00554	0.01793	0.00184	137	137	137	0	0	1	-360	360;
	2947	2800	0.03636	0.12066	0.01181	114	114	114	0	0	1	-360	360;
	3054	3048	0.00306	0.00992	0.00102	114	114	114	0	0	1	-360	360;
	2858	2923	0.0676	0.11901	0.0112	69	69	69	0	0	1	-360	360;
	3064	2858	0.03868	0.0681	0.00639	69	69	69	0	0	1	-360	360;
	2992	2923	0.05042	0.10487	0.0102	69	69	69	0	0	1	-360	360;
	3009	2992	0.01976	0.0514	0.00515	69	69	69	0	0	1	-360	360;
	2927	2869	0.02781	0.07968	0.00807	123	123	123	0	0	1	-360	360;
	3064	2927	0.01467	0.03239	0.00328	123	123	123	0	0	1	-360	360;
	2805	2874	0.02231	0.07231	0.01493	75	75	75	0	0	1	-360	360;
	2800	2805	0.01322	0.01777	0.00191	62	62	62	0	0	1	-360	360;
	3044	2869	0.00883	0.02792	0.00305	137	137	137	0	0	1	-360	360;
	2854	3044	0.00688	0.02158	0.0024	137	137	137	0	0	1	-360	360;
	2988	3056	0.01554	0.05455	0.00557	137	137	137	0	0	1	-360	360;
	3051	3004	0.00438	0.01136	0.00098	120	120	120	0	0	1	-360	360;
	2831	3051	0.00515	0.01374	0.00122	120	120	120	0	0	1	-360	360;
	3004	3053	0.00281	0.00702	0.00059	114	114	114	0	0	1	-360	360;
	2818	3069	0.02769	0.0895	0.00917	95	95	95	0	0	1	-360	360;
	3056	2817	0.02132	0.06942	0.00707	137	137	137	0	0	1	-360	360;
	3069	3075	0.01504	0.04132	0.00426	122	122	122	0	0	1	-360	360;
	3055	3052	0.01777	0.05736	0.00588	137	137	137	0	0	1	-360	360;
	3010	2867	0.00736	0.0238	0.00251	114	114	114	0	0	1	-360	360;
	3031	2939	0.00421	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	2800	3009	0.02331	0.07893	0.00745	69	69	69	0	0	1	-360	360;
	3031	2866	0.00273	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	2866	2854	0.00149	0.00496	0.00048	137	137	137	0	0	1	-360	360;
	2820	2869	0.02868	0.09256	0.00951	123	123	123	0	0	1	-360	360;
	2831	2883	0.01364	0.03554	0.0037	120	120	120	0	0	1	-360	360;
	3052	3048	0.00421	0.01355	0.0014	131	131	131	0	0	1	-360	360;
	2987	3055	0.00529	0.01074	0.00111	90	90	90	0	0	1	-360	360;
	3075	3072	0.00934	0.01653	0.00174	122	122	122	0	0	1	-360	360;
	2915	2868	0.02124	0.0686	0.00704	123	123	123	0	0	1	-360	360;
	2874	2867	0.0314	0.09884	0.01074	123	123	123	0	0	1	-360	360;
	2917	3048	0.00851	0.02686	0.0029	95	95	95	0	0	1	-360	360;
	2912	2917	0.0181	0.05702	0.0062	95	95	95	0	0	1	-360	360;
	2928	2816	0.00895	0.02924	0.00298	123	123	123	0	0	1	-360	360;
	3048	2928	0.00895	0.02924	0.00298	123	123	123	0	0	1	-360	360;
	2918	3073	0.03678	0.09347	0.00949	120	120	120	0	0	1	-360	360;
	2975	2915	0.03364	0.10744	0.01016	107	107	107	0	0	1	-360	360;
	3010	2939	0.00826	0.01653	0.00194	114	114	114	0	0	1	-360	360;
	3069	3090	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	3069	3090	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2862	3048	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2863	3049	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	3058	3052	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	3061	2987	0.0254	0.08216	0.00843	123	123	123	0	0	1	-360	360;
	3061	2816	0.01636	0.05289	0.00558	140	140	140	0	0	1	-360	360;
	2912	3064	0.02041	0.06843	0.00685	123	123	123	0	0	1	-360	360;
	3058	3052	0.00992	0.03488	0.00407	76	76	76	0	0	1	-360	360;
	3071	3031	0.02017	0.05223	0.00545	120	120	120	0	0	1	-360	360;
	3031	2868	0.0095	0.02455	0.00256	114	114	114	0	0	1	-360	360;
	3036	3020	0.00891	0.01566	0.00148	39	39	39	0	0	1	-360	360;
	3028	3030	0.0328	0.07474	0.00784	39	39	39	0	0	1	-360	360;
	3027	3025	0.04351	0.09356	0.00962	39	39	39	0	0	1	-360	360;
	3081	3029	0.00745	0.01889	0.00192	104	104	104	0	0	1	-360	360;
	3086	3081	0.00011	0.00026	3e-05	104	104	104	0	0	1	-360	360;
	3100	3086	0.06516	0.16537	0.01679	104	104	104	0	0	1	-360	360;
	3082	3030	0.00705	0.01789	0.00182	104	104	104	0	0	1	-360	360;
	2951	3100	0.04207	0.11074	0.01053	39	39	39	0	0	1	-360	360;
	3087	3082	0.00045	0.00112	0.00011	104	104	104	0	0	1	-360	360;
	2951	3082	0.02377	0.06031	0.00612	104	104	104	0	0	1	-360	360;
	3026	3029	0.01653	0.03306	0.00242	39	39	39	0	0	1	-360	360;
	2920	2827	0.0405	0.07107	0.00673	39	39	39	0	0	1	-360	360;
	2827	3026	0.04628	0.07107	0.0076	39	39	39	0	0	1	-360	360;
	3029	3036	0.00496	0.00826	0.00085	39	39	39	0	0	1	-360	360;
	2921	2920	0.00413	0.01372	0.00138	62	62	62	0	0	1	-360	360;
	3062	3027	0.02394	0.04718	0.00469	39	39	39	0	0	1	-360	360;
	3020	3028	0.00862	0.02752	0.00296	101	101	101	0	0	1	-360	360;
	2933	3100	0.04438	0.07826	0.00739	39	39	39	0	0	1	-360	360;
	2966	2933	0.05661	0.09983	0.00943	39	39	39	0	0	1	-360	360;
	2811	2966	0.01975	0.06215	0.00675	39	39	39	0	0	1	-360	360;
	2842	2811	0.03669	0.06471	0.00611	39	39	39	0	0	1	-360	360;
	2828	3030	0.03587	0.07132	0.00624	39	39	39	0	0	1	-360	360;
	3067	2921	0.03438	0.06099	0.00569	62	62	62	0	0	1	-360	360;
	2842	2828	0.03587	0.07132	0.00624	39	39	39	0	0	1	-360	360;
	2826	2871	0.0204	0.06595	0.00677	101	101	101	0	0	1	-360	360;
	2823	2871	0.01455	0.04747	0.00483	101	101	101	0	0	1	-360	360;
	2847	2974	0.00661	0.0157	0.00169	103	103	103	0	0	1	-360	360;
	2852	2814	0.00983	0.01736	0.0016	137	137	137	0	0	1	-360	360;
	2814	2848	0.03025	0.09752	0.01002	86	86	86	0	0	1	-360	360;
	2848	3068	0.01977	0.06457	0.00658	123	123	123	0	0	1	-360	360;
	2891	2849	0.0065	0.02121	0.00216	123	123	123	0	0	1	-360	360;
	2924	2843	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2924	2941	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2925	2941	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2851	3068	0.01083	0.03471	0.00358	137	137	137	0	0	1	-360	360;
	2861	2851	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	3039	2861	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2852	3039	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2814	3095	0.03669	0.11818	0.01217	123	123	123	0	0	1	-360	360;
	3066	3095	0.01721	0.05623	0.00573	140	140	140	0	0	1	-360	360;
	3047	2844	0.03248	0.1081	0.01445	137	137	137	0	0	1	-360	360;
	3034	2843	0.05455	0.18017	0.0242	99	99	99	0	0	1	-360	360;
	2846	2849	0.01917	0.02595	0.00467	69	69	69	0	0	1	-360	360;
	2974	2849	0.01405	0.03636	0.00399	103	103	103	0	0	1	-360	360;
	3078	2848	0.00218	0.00712	0.00073	123	123	123	0	0	1	-360	360;
	3000	3078	0.0235	0.07683	0.00783	123	123	123	0	0	1	-360	360;
	2890	3078	0.00133	0.00434	0.00044	123	123	123	0	0	1	-360	360;
	3080	2849	0.015	0.04714	0.00466	114	114	114	0	0	1	-360	360;
	3032	3080	0.00525	0.0165	0.00163	114	114	114	0	0	1	-360	360;
	3076	3080	0.00026	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	3001	3065	0.04174	0.07322	0.00692	90	90	90	0	0	1	-360	360;
	2857	3096	0.01705	0.05552	0.00567	137	137	137	0	0	1	-360	360;
	2856	2857	0.00142	0.00465	0.00047	123	123	123	0	0	1	-360	360;
	3065	2856	0.00408	0.01332	0.00136	123	123	123	0	0	1	-360	360;
	2851	3050	0.00099	0.00347	0.00036	137	137	137	0	0	1	-360	360;
	2982	3032	0.00364	0.01074	0.00106	114	114	114	0	0	1	-360	360;
	2846	2986	0.00463	0.01488	0.00152	137	137	137	0	0	1	-360	360;
	2860	3000	0.00372	0.00934	0.00094	120	120	120	0	0	1	-360	360;
	2852	2860	0.00496	0.01273	0.00128	95	95	95	0	0	1	-360	360;
	2824	2925	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2848	2824	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2849	3033	0.01496	0.0438	0.00445	114	114	114	0	0	1	-360	360;
	2850	2844	0.0076	0.01983	0.00206	120	120	120	0	0	1	-360	360;
	2937	2849	0.03479	0.1119	0.01176	76	76	76	0	0	1	-360	360;
	3047	2937	0.00702	0.0224	0.00237	123	123	123	0	0	1	-360	360;
	2980	3041	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	3047	2980	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2922	2929	0.01992	0.05245	0.00519	120	120	120	0	0	1	-360	360;
	3041	2922	0.01187	0.03176	0.00315	120	120	120	0	0	1	-360	360;
	2985	2846	0.00504	0.01686	0.00174	137	137	137	0	0	1	-360	360;
	2791	2846	0.00331	0.01091	0.00111	137	137	137	0	0	1	-360	360;
	3033	2993	0.00777	0.02479	0.00257	137	137	137	0	0	1	-360	360;
	2952	2815	0.00711	0.02314	0.00234	124	124	124	0	0	1	-360	360;
	2986	2953	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	3005	3001	0.00645	0.02066	0.00213	137	137	137	0	0	1	-360	360;
	2997	2843	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2998	2844	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2844	2847	0.02074	0.06727	0.00682	137	137	137	0	0	1	-360	360;
	2997	2865	0.00545	0.01736	0.00177	137	137	137	0	0	1	-360	360;
	2844	2791	0.00612	0.0157	0.00157	120	120	120	0	0	1	-360	360;
	2960	2847	0.00132	0.00421	0.00044	137	137	137	0	0	1	-360	360;
	2843	2960	0.00793	0.02231	0.00215	123	123	123	0	0	1	-360	360;
	2865	2985	0.00909	0.02893	0.0029	137	137	137	0	0	1	-360	360;
	2993	3037	0.00736	0.02372	0.00242	137	137	137	0	0	1	-360	360;
	2815	3005	0.00331	0.01074	0.00109	137	137	137	0	0	1	-360	360;
	3050	2893	0.00207	0.00694	0.0007	137	137	137	0	0	1	-360	360;
	3066	3001	0.01132	0.03636	0.00375	137	137	137	0	0	1	-360	360;
	2893	2952	0.00289	0.00926	0.00094	137	137	137	0	0	1	-360	360;
	2953	2982	0.00248	0.00744	0.00073	120	120	120	0	0	1	-360	360;
	2894	2850	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	3037	2894	0.00492	0.02302	0.00236	120	120	120	0	0	1	-360	360;
	2962	3096	0.00165	0.00496	0.00053	137	137	137	0	0	1	-360	360;
	2822	3034	0.0395	0.12455	0.01176	38	38	38	0	0	1	-360	360;
	2888	2849	0.0395	0.06959	0.00657	72	72	72	0	0	1	-360	360;
	2886	2888	0.05306	0.09355	0.00884	72	72	72	0	0	1	-360	360;
	3024	2886	0.03293	0.1065	0.01093	137	137	137	0	0	1	-360	360;
	3023	2886	0.05807	0.10306	0.00937	76	76	76	0	0	1	-360	360;
	3034	3024	0.02444	0.07902	0.00811	137	137	137	0	0	1	-360	360;
	2801	3095	0.02139	0.06954	0.00729	120	120	120	0	0	1	-360	360;
	3008	2848	0.00124	0.00413	0.00039	128	128	128	0	0	1	-360	360;
	2846	3089	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2847	3088	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2981	2844	0.01281	0.02149	0.00212	78	78	78	0	0	1	-360	360;
	2812	2981	0.0262	0.04397	0.00434	78	78	78	0	0	1	-360	360;
	2942	2796	0.03905	0.12628	0.01297	95	95	95	0	0	1	-360	360;
	3077	2958	0.01165	0.03769	0.00387	137	137	137	0	0	1	-360	360;
	2796	3077	0.0214	0.06917	0.0071	137	137	137	0	0	1	-360	360;
	2804	3077	0.00281	0.00917	0.00094	123	123	123	0	0	1	-360	360;
	3038	2957	0.15802	0.18273	0.01643	46	46	46	0	0	1	-360	360;
	2934	2958	0.00498	0.01612	0.00165	123	123	123	0	0	1	-360	360;
	2853	2954	0.01039	0.05083	0.00494	133	133	133	0	0	1	-360	360;
	2926	2954	0.03603	0.12893	0.01251	69	69	69	0	0	1	-360	360;
	2829	2957	0.02234	0.07496	0.00748	69	69	69	0	0	1	-360	360;
	2792	2926	0.0414	0.06942	0.00711	69	69	69	0	0	1	-360	360;
	2864	2926	0.03314	0.06116	0.00639	69	69	69	0	0	1	-360	360;
	2903	2792	0.03769	0.12149	0.01249	69	69	69	0	0	1	-360	360;
	2906	2903	0.01942	0.06281	0.00649	69	69	69	0	0	1	-360	360;
	2959	2954	0.03587	0.1157	0.0122	140	140	140	0	0	1	-360	360;
	2881	2955	0.03025	0.09752	0.01028	140	140	140	0	0	1	-360	360;
	2919	2873	0.00983	0.01727	0.00163	69	69	69	0	0	1	-360	360;
	2964	2919	0.05322	0.09347	0.00882	69	69	69	0	0	1	-360	360;
	2968	2961	0.00661	0.01372	0.00133	69	69	69	0	0	1	-360	360;
	2961	2969	0.00537	0.01736	0.00179	69	69	69	0	0	1	-360	360;
	2942	2906	0.02339	0.07587	0.00784	57	57	57	0	0	1	-360	360;
	2969	2957	0.01157	0.03769	0.00387	69	69	69	0	0	1	-360	360;
	2954	2943	0.03041	0.0986	0.01013	114	114	114	0	0	1	-360	360;
	2946	2959	0.02818	0.09116	0.00934	69	69	69	0	0	1	-360	360;
	2964	2853	0.02446	0.04347	0.00404	69	69	69	0	0	1	-360	360;
	2963	2958	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2935	2968	0.00507	0.01627	0.00168	123	123	123	0	0	1	-360	360;
	2938	2943	0.02579	0.04512	0.0043	69	69	69	0	0	1	-360	360;
	3002	2905	0.01568	0.0507	0.0052	84	84	84	0	0	1	-360	360;
	2954	2957	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2955	2958	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2935	2881	0.01012	0.03265	0.00336	123	123	123	0	0	1	-360	360;
	2970	2934	0.00118	0.00382	0.00039	57	57	57	0	0	1	-360	360;
	2971	2935	0.0011	0.00355	0.00037	57	57	57	0	0	1	-360	360;
	2798	2835	0.02355	0.06215	0.00639	82	82	82	0	0	1	-360	360;
	2882	2798	0.0276	0.0495	0.00448	69	69	69	0	0	1	-360	360;
	2859	2882	0.03967	0.07157	0.00641	69	69	69	0	0	1	-360	360;
	2895	2859	0.02983	0.05793	0.00547	69	69	69	0	0	1	-360	360;
	2900	2834	0.00926	0.03008	0.00307	123	123	123	0	0	1	-360	360;
	3022	3016	0.05314	0.09339	0.0089	69	69	69	0	0	1	-360	360;
	2897	2900	0.00132	0.00421	0.00044	119	119	119	0	0	1	-360	360;
	2899	2835	0.00909	0.02975	0.00302	119	119	119	0	0	1	-360	360;
	2833	2834	0.05504	0.1643	0.01682	69	69	69	0	0	1	-360	360;
	3092	2830	0.03653	0.06413	0.00605	69	69	69	0	0	1	-360	360;
	2914	2899	0.01595	0.05124	0.0053	123	123	123	0	0	1	-360	360;
	2914	2897	0.00744	0.02397	0.00246	123	123	123	0	0	1	-360	360;
	2984	2872	0.03669	0.11669	0.01251	69	69	69	0	0	1	-360	360;
	3092	3022	0.08314	0.14628	0.01392	69	69	69	0	0	1	-360	360;
	3063	2834	0.02688	0.08734	0.00915	123	123	123	0	0	1	-360	360;
	2914	3021	0.03347	0.06529	0.00593	123	123	123	0	0	1	-360	360;
	2892	2895	0.00521	0.01413	0.0014	78	78	78	0	0	1	-360	360;
	2895	3063	0.01843	0.0619	0.0062	123	123	123	0	0	1	-360	360;
	2825	3092	0.00182	0.00388	0.00027	69	69	69	0	0	1	-360	360;
	3015	3016	0.00347	0.01264	0.00119	137	137	137	0	0	1	-360	360;
	2797	3018	0.0376	0.09174	0.00968	69	69	69	0	0	1	-360	360;
	2984	3017	0.01967	0.08612	0.00924	57	57	57	0	0	1	-360	360;
	2902	3014	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	2902	3015	0.00164	0.00212	0.00912	76	76	76	0	0	1	-360	360;
	3060	2834	0.01463	0.05661	0.00653	140	140	140	0	0	1	-360	360;
	2839	3093	0.00331	0.01058	0.00109	137	137	137	0	0	1	-360	360;
	2999	2839	0.02975	0.09587	0.01007	137	137	137	0	0	1	-360	360;
	2932	2999	0.00512	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2907	2948	0.03347	0.06529	0.00593	21	21	21	0	0	1	-360	360;
	2803	2983	0.01653	0.0314	0.0029	48	48	48	0	0	1	-360	360;
	2990	2803	0.03347	0.06529	0.00593	69	69	69	0	0	1	-360	360;
	2983	2837	0.01653	0.0314	0.00315	48	48	48	0	0	1	-360	360;
	2965	2990	0.02288	0.074	0.00759	69	69	69	0	0	1	-360	360;
	3093	2836	0.00165	0.00529	0.00053	137	137	137	0	0	1	-360	360;
	2838	2837	0.00909	0.0281	0.00288	133	133	133	0	0	1	-360	360;
	2913	2909	0.00405	0.01331	0.00138	95	95	95	0	0	1	-360	360;
	2936	2913	0.02074	0.06628	0.00699	126	126	126	0	0	1	-360	360;
	3042	2936	0.02835	0.09223	0.00951	137	137	137	0	0	1	-360	360;
	3045	2909	0.03017	0.09764	0.01004	123	123	123	0	0	1	-360	360;
	2932	3045	0.01103	0.03572	0.00367	123	123	123	0	0	1	-360	360;
	2978	2838	0.02041	0.06612	0.00678	95	95	95	0	0	1	-360	360;
	2889	3042	0.01338	0.04326	0.00444	140	140	140	0	0	1	-360	360;
	3108	2258	0.05787	0.10132	0.00967	78	78	78	0	0	1	-360	360;
	3109	2259	0.05787	0.10132	0.00967	78	78	78	0	0	1	-360	360;
	3103	1105	0.02562	0.08471	0.00848	131	131	131	0	0	1	-360	360;
	3103	1105	0.02562	0.08471	0.00848	131	131	131	0	0	1	-360	360;
	3110	1736	0.01041	0.03405	0.00418	114	114	114	0	0	1	-360	360;
	3111	2175	0.00934	0.03066	0.00383	131	131	131	0	0	1	-360	360;
	3105	1829	0.00256	0.00843	0.00085	114	114	114	0	0	1	-360	360;
	3107	3105	0.00306	0.01	0.00105	114	114	114	0	0	1	-360	360;
	3104	3105	0.00025	0.00091	8e-05	114	114	114	0	0	1	-360	360;
	3106	1830	0.0057	0.0186	0.00188	114	114	114	0	0	1	-360	360;
	3112	197	0.00019	0.00196	0.06877	831	831	831	0	0	1	-360	360;
	3119	73	0.00477	0.23469	0	80	80	80	0.96759	0	1	-360	360;
	3119	72	0.00478	0.23168	0	80	80	80	0.96759	0	1	-360	360;
	3119	72	0.00502	0.22855	0	80	80	80	0.96759	0	1	-360	360;
	4	3	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	7	6	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	9	8	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	12	11	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	15	14	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	19	18	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	23	22	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	25	24	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	27	26	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	29	28	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	31	30	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	33	32	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	38	37	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	40	39	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	42	41	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	46	45	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	50	49	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	53	52	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	57	55	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	56	55	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	59	58	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	62	61	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	65	64	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	67	66	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	69	68	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	71	70	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	73	72	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	75	74	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	77	76	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	79	78	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	87	86	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	89	88	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	91	90	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	95	94	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	97	96	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	100	99	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	102	101	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	104	103	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	106	105	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	108	107	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	110	109	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	112	111	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	114	113	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	116	115	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	118	117	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	120	119	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	122	121	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	124	123	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	127	126	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	129	128	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	131	130	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	133	132	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	135	134	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	137	136	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	139	138	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	141	140	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	143	142	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	145	144	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	147	146	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	153	152	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	155	154	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	158	157	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	160	159	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	163	162	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	165	164	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	168	167	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	169	170	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	172	171	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	174	173	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	176	175	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	178	177	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	179	178	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	181	180	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	183	182	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	187	186	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	189	188	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	192	191	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	194	193	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	196	195	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	199	198	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	202	201	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	206	205	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	210	209	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	212	211	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	215	214	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	217	216	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	222	221	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	226	225	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	229	228	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	231	230	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	233	232	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	235	234	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	237	236	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	239	238	2e-05	0.00021	0	876	876	876	0	0	1	-360	360;
	243	242	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	245	244	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	247	246	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	251	250	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	254	253	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	256	255	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	259	258	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	261	260	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	264	263	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	266	265	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	270	269	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	272	271	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	275	274	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	278	277	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	281	280	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	286	285	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	288	287	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	290	289	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	293	292	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	295	294	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	298	297	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	300	299	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	302	301	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	309	308	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	312	311	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	315	314	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	318	317	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	324	323	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	327	326	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	329	328	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	331	330	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	333	332	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	337	336	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	339	338	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	349	348	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	351	350	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	354	353	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	356	355	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	358	357	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	364	363	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	371	370	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	375	374	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	378	377	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	380	379	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	383	382	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	386	385	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	389	388	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	394	393	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	396	395	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	399	398	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	403	402	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	405	404	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	408	407	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	410	409	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	417	416	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	421	420	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	423	422	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	425	424	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	427	426	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	429	428	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	431	430	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	433	432	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	437	436	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	439	438	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	444	443	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	446	445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	448	447	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	452	451	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	454	453	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	468	467	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	470	469	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	476	475	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	480	479	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	482	481	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	484	483	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	486	485	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	487	486	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	490	489	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	497	496	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	499	498	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	501	500	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	505	504	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	511	510	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	516	515	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	521	520	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	523	522	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	530	529	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	538	537	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	546	545	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	548	547	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	552	551	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	558	557	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	560	559	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	562	561	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	564	563	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	568	567	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	570	569	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	572	571	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	574	573	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	576	575	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	578	577	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	581	580	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	584	583	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	586	585	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	588	587	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	590	589	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	594	593	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	598	597	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	603	602	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	605	604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	607	606	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	611	610	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	613	612	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	615	614	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	618	617	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	624	623	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	632	631	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	634	633	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	636	635	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	640	639	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	642	641	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	646	645	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	653	652	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	656	655	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	658	657	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	660	659	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	662	661	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	666	665	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	670	669	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	672	671	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	676	675	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	678	677	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	680	679	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	682	681	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	685	684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	687	686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	689	688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	691	690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	695	694	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	700	699	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	702	701	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	705	704	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	712	711	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	714	713	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	716	715	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	718	717	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	720	719	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	722	721	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	724	723	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	726	725	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	728	727	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	731	730	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	737	736	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	739	738	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	745	744	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	747	746	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	749	748	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	751	750	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	755	754	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	757	756	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	759	758	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	761	760	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	765	764	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	768	767	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	770	769	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	774	772	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	802	801	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	806	805	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	808	807	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	810	809	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	812	811	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	815	814	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	817	816	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	820	819	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	822	821	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	824	823	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	826	825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	830	829	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	832	831	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	834	833	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	840	839	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	847	846	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	849	848	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	854	853	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	864	863	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	868	867	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	923	922	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	929	928	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	932	931	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	948	947	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	960	959	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	966	965	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	980	979	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	983	982	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1000	999	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1012	1011	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1028	1027	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1032	1031	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1038	1037	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1044	1043	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1054	1053	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1072	1071	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1079	1078	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1119	1118	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1135	1134	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1138	1137	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1140	1139	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1141	1140	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1143	1142	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1145	1144	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1149	1148	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1151	1150	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1156	1155	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1158	1157	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1163	1162	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1165	1164	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1170	1169	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1178	1177	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1180	1179	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1183	1182	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1185	1184	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1191	1190	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1193	1192	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1195	1194	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1205	1204	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1207	1206	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1215	1214	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1217	1216	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1222	1221	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1224	1223	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1226	1225	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1230	1229	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1232	1231	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1234	1233	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1239	1238	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1244	1243	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1246	1245	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1250	1249	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1252	1251	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1254	1253	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1258	1257	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1260	1259	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1262	1261	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1264	1263	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1266	1265	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1268	1267	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1270	1269	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1274	1273	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1276	1275	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1278	1277	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1282	1281	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1288	1287	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1292	1291	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1294	1293	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1296	1295	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1298	1297	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1300	1299	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1307	1306	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1313	1312	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1314	1313	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1324	1323	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1330	1329	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1332	1331	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1336	1335	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1338	1337	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1340	1339	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1346	1345	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1350	1349	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1353	1352	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1355	1354	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1358	1357	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1360	1359	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1362	1361	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1364	1363	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1366	1365	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1368	1367	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1370	1369	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1377	1376	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1379	1378	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1387	1386	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1393	1392	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1399	1398	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1401	1400	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1409	1408	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1411	1410	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1425	1424	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1427	1426	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1439	1438	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1440	1439	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1444	1443	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1446	1445	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1451	1450	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1462	1461	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1468	1467	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1470	1469	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1479	1478	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1483	1482	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1492	1491	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1499	1498	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1502	1501	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1504	1503	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1506	1505	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1508	1507	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1510	1509	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1512	1511	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1518	1517	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1522	1521	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1528	1527	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1532	1531	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1534	1533	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1538	1537	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1542	1541	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1544	1543	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1546	1545	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1548	1547	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1556	1555	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1558	1557	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1562	1561	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1564	1563	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1566	1565	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1568	1567	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1576	1575	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1578	1577	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1580	1579	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1584	1583	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1591	1590	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1593	1592	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1595	1594	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1597	1596	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1599	1598	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1601	1600	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1603	1602	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1605	1604	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1607	1606	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1609	1608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1613	1612	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1615	1614	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1617	1616	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1625	1624	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1633	1632	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1635	1634	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1637	1636	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1639	1638	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1641	1640	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1643	1642	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1648	1647	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1655	1654	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1660	1659	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1666	1665	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1670	1669	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1672	1671	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1674	1673	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1680	1679	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1683	1682	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1685	1684	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1687	1686	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1689	1688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1691	1690	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1695	1694	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1697	1696	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1699	1698	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1703	1702	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1707	1706	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1712	1711	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1718	1717	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1720	1719	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1726	1725	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1728	1727	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1730	1729	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1732	1731	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1734	1733	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1736	1735	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1745	1744	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1747	1746	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1755	1754	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1757	1756	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1759	1758	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1761	1760	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1763	1762	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1765	1764	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1767	1766	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1769	1768	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1771	1770	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1773	1772	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1781	1780	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1783	1782	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1785	1784	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1787	1786	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1791	1790	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1793	1792	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1797	1796	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1799	1798	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1801	1800	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1803	1802	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1805	1804	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1807	1806	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1811	1810	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1818	1817	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1822	1821	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1824	1823	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1826	1825	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1828	1827	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1830	1829	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1832	1831	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1834	1833	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1842	1841	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1848	1847	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1852	1851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1854	1853	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1860	1859	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1862	1861	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1864	1863	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1868	1867	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1874	1873	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1876	1875	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1878	1877	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1884	1883	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1886	1885	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1890	1889	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1892	1891	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1894	1893	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1896	1895	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1898	1897	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1900	1899	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1902	1901	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1904	1903	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1908	1907	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1912	1911	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1914	1913	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1916	1915	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1918	1917	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1922	1921	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1924	1923	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1928	1927	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1930	1929	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1934	1933	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1936	1935	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1938	1937	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1940	1939	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1943	1942	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1945	1944	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1947	1946	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1955	1954	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1960	1959	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1964	1963	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1970	1969	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1973	1972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1975	1974	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1979	1978	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1981	1980	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1986	1985	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1988	1987	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1990	1989	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	1997	1996	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2003	2002	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2005	2004	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2014	2013	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2016	2015	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2022	2021	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2024	2023	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2028	2027	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2034	2033	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2036	2035	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2038	2037	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2043	2042	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2045	2044	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2047	2046	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2053	2052	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2055	2054	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2057	2056	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2059	2058	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2061	2060	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2063	2062	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2065	2064	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2069	2068	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2071	2070	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2075	2074	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2077	2076	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2079	2078	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2081	2080	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2083	2082	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2085	2084	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2087	2086	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2093	2092	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2095	2094	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2097	2096	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2101	2100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2105	2104	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2110	2109	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2112	2111	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2114	2113	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2116	2115	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2118	2117	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2120	2119	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2128	2127	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2130	2129	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2132	2131	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2134	2133	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2139	2138	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2141	2140	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2143	2142	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2152	2151	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2154	2153	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2156	2155	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2158	2157	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2160	2159	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2162	2161	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2169	2168	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2171	2170	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2183	2182	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2185	2184	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2187	2186	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2189	2188	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2191	2190	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2195	2194	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2197	2196	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2199	2198	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2201	2200	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2203	2202	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2205	2204	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2207	2206	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2209	2208	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2211	2210	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2213	2212	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2215	2214	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2223	2222	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2225	2224	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2227	2226	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2231	2230	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2233	2232	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2238	2237	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2245	2244	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2250	2249	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2253	2252	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2256	2255	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2272	2271	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2284	2283	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2292	2291	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2301	2300	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2303	2302	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2307	2306	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2318	2317	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2321	2320	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2327	2326	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2333	2332	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2335	2334	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2343	2342	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2352	2351	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2357	2356	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2361	2360	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2376	2375	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2383	2382	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2398	2397	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2414	2413	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2418	2417	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2423	2422	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2429	2428	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2435	2434	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2444	2443	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2451	2450	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2460	2459	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2462	2461	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2517	2516	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2529	2528	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2535	2534	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2537	2536	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2542	2541	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2545	2544	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2550	2549	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2556	2555	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2567	2566	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2574	2573	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2578	2577	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2583	2582	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2594	2593	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2598	2597	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2601	2600	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2609	2608	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2611	2610	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2637	2636	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2666	2665	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2668	2667	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2673	2672	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2676	2675	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2684	2683	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2689	2688	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2692	2691	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2696	2695	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2706	2705	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2716	2715	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2764	2763	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2766	2765	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2768	2767	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2784	2783	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2795	2794	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2798	2797	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2810	2809	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2815	2814	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2835	2834	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2837	2836	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2852	2851	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2868	2867	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2869	2868	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2878	2877	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2885	2884	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2906	2905	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2911	2909	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2909	2910	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2931	2930	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2955	2954	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2958	2957	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2973	2972	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2979	2978	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3107	3106	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3028	3027	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3030	3029	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3049	3048	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3070	3069	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3074	3073	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3091	3090	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3096	3095	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3101	3100	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3015	3014	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3012	3011	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2876	2875	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3084	3083	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3054	3053	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3098	3097	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	3035	3034	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2925	2924	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2818	2817	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2988	2987	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	2935	2934	8e-05	0.00083	0	438	438	438	0	0	1	-360	360;
	219	218	1e-05	6e-05	0	1593	1593	1593	0	0	1	-360	360;
	2472	175	0.00118	0.06517	0	160	160	160	1.07303	0	1	-360	360;
	2461	174	0.00165	0.0593	0	160	160	160	1.13469	0	1	-360	360;
	1993	134	0.00153	0.06667	-0.00658	160	160	160	1.07985	0	1	-360	360;
	1172	87	0.00141	0.07036	-0.00319	160	160	160	1.01921	0	1	-360	360;
	923	56	0.00157	0.06775	0	160	160	160	1.01196	0	1	-360	360;
	143	2144	0.00139	0.06852	-0.00232	160	160	160	1.0224	0	1	-360	360;
	184	197	0.00228	0.02296	0.8129	1386	1386	1386	0	0	1	-360	360;
	3120	211	0.00033	0.00388	0.10475	831	831	831	0	0	1	-360	360;
	41	184	0.00126	0.01446	0.4016	838	838	838	0	0	1	-360	360;
	37	41	0.00097	0.01052	0.28395	970	970	970	0	0	1	-360	360;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	1;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	134.04	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	137.4	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	107.03	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	158.61	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	143.52	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	148.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	157	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	126.62	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	132.33	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	130.49	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	136.59	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	139.96	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	128.21	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	129.99	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	163.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	135.6	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	125.48	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	139.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
