
param con := 0;

var p {arcs};
var q {arcs};

var V {i in nodes};
var t {i in nodes};

var pn {i in gen};
var qn {i in gen};

var wtqn {i in nodes};
var wtqn_v {i in w_gen} >= 0;

var VTr {l in lines} integer >= 0, <= Trstep[l];
var VTri {lines};

var bszd {i in nodes} integer >= 0, <= bsstep[i];
var bszc {i in nodes} >= 0, <= 1;

#minimize Cost: sum{i in gen} MVABase*pn[i] + sum{i in w_gen} wtqn_v[i]^2;
minimize Cost: sum{i in gen} MVABase*pn[i] + 100000*sum{i in w_gen} wtqn_v[i]^2;
#minimize Cost: 1000000*sum{i in gen} MVABase*pn[i] + sum{i in w_gen} wtqn_v[i]^2;


#subject to PVal{i in gen : i not in gen_slack}: pn[i] == Ps[i];
#subject to UPBoundsP{i in gen_slack}: pn[i] <= Pmax[i];
#subject to LOWBoundsP{i in gen_slack}: pn[i] >= Pmin[i];


#subject to UPBoundsWQ{i in w_gen}: wtqn[i] <= w_gen_r_ub;
#subject to LOWBoundsWQ{i in w_gen}: wtqn[i] >= w_gen_r_lb;
subject to BoundsWQ{i in nodes : i not in w_gen}: wtqn[i] = 0;
#subject to BoundsWQ{i in nodes}: wtqn[i] = 0;

subject to UPBoundsWQ{i in w_gen}: wtqn_v[i] >=  wtqn[i] - w_gen_r_ub;
subject to LBBoundsWQ{i in w_gen}: wtqn_v[i] >= -wtqn[i] + w_gen_r_lb;

subject to UPBoundsQ{i in gen}: qn[i] <= Qmax[i];
subject to LOWBoundsQ{i in gen}: qn[i] >= Qmin[i];

subject to  BoundsQS: sum{(refBus,gid) in busgen} qn[gid] == 0;


subject to UPBoundsV{i in nodes}: V[i] <= Vmax[i];
subject to LOWBoundsV{i in nodes}: V[i] >= Vmin[i];

subject to refBusDefv: V[refBus] = 1.02;
subject to refBusDef: t[refBus] = 0;

subject to ThetaLBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] >= thLBound;
subject to ThetaUBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] <= thUBound;

subject to D_Shunt{i in nodes : bsstep[i] >= 30}: bszd[i] = 0;
subject to C_Shunt{i in nodes : bsstep[i] <  30}: bszc[i] = 0;

subject to BusflowBalP {i in nodes: i <> refBus}: sum{(con,l,i,j) in arcs_c} p[l,i,j] + gs[i]*V[i]^2 + (bszc[i]*cgsinc[i]+cgsmin[i])*V[i]^2 = Sp[scen,i] + sum{(i,gid) in busgen} pn[gid];

subject to BusflowBalP_ref: sum{(con,l,refBus,j) in arcs_c} p[l,refBus,j] + gs[refBus]*V[refBus]^2 + (bszc[refBus]*cgsinc[refBus]+cgsmin[refBus])*V[refBus]^2 + sum{i in nodes: i <> refBus} Sp[scen,i] = Sp[scen,refBus]  + sum{(refBus,gid) in busgen} pn[gid];
### + S_ref_q_pcc[scen] #should this go here?

subject to BusflowBalQ {i in nodes: i <> refBus}: sum{(con,l,i,j) in arcs_c} q[l,i,j] - (bszd[i]*bsinc[i]+bsmin[i])*V[i]^2 - (bszc[i]*cbsinc[i]+cbsmin[i])*V[i]^2 + ql[i] = wtqn[i] + sum{(i,gid) in busgen} qn[gid];

subject to BusflowBalQ_ref: sum{(con,l,refBus,j) in arcs_c} q[l,refBus,j] - (bszd[refBus]*bsinc[refBus]+bsmin[refBus])*V[refBus]^2 - (bszc[refBus]*cbsinc[refBus]+cbsmin[refBus])*V[refBus]^2 + ql[refBus] + S_ref_q[scen] = wtqn[refBus] + sum{(refBus,gid) in busgen} qn[gid];



subject to TapRatioInverseLB {l in lines}: VTri[l] <= 1/Trmin[l];
subject to TapRatioInverseUB {l in lines}: VTri[l] >= 1/(trinc[l]*Trstep[l]+Trmin[l]);

subject to TapRatioInverse {l in lines}: VTri[l]*(trinc[l]*VTr[l]+Trmin[l]) = 1;

subject to PFlow {(con,l,i,j) in arcsf_c}: p[l,i,j] = 
        g[l]*(V[i]*VTri[l])^2 
     + -g[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
     + -b[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to PFlow2 {(con,l,i,j) in arcst_c}: p[l,i,j] = 
        g[l]*V[i]^2 
     + -g[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
     + -b[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to QFlow {(con,l,i,j) in arcsf_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*(V[i]*VTri[l])^2 
    +  b[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
    + -g[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to QFlow2 {(con,l,i,j) in arcst_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*V[i]^2 
    +  b[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
    + -g[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to Capacity {(l,i,j) in arcs}: p[l,i,j]^2 + q[l,i,j]^2 <= S[l]^2;


for {i in nodes}{
    let V[i]:=1.0;
    let t[i]:=0;
    #let bsz[i]:=bsstep[i];
}
for {l in lines}{
    let VTr[l] := Trstep[l]/2;
}



#option solver ipopt;
#option solver couenne;
#option ipopt_options 'halt_on_ampl_error yes tol=1e-4';
#option cplex_options 'timing=1 clocktype=1 prestats=1 bardisplay=2 mipdisplay=1 threads=5 parallelmode=1';

option solver bonmin;
#option bonmin_options 'bonmin.solution_limit=1';

option presolve 1;

solve;

#fix VTr;
#fix bsz;
#option solver ipopt;
#solve;

param obj;
let obj := sum{i in gen} MVABase*pn[i];

param vio;
let vio := sum{i in w_gen} MVABase*wtqn_v[i];

display obj, vio;

#print solve_message;


#display S_ref_q_pcc[scen];
#for{i in nodes}{
#    display i, Sp[scen,i];
#}
#display ql;

#display S;
#display p;

#display sqrt((sum{i in gen_slack} MVABase*pn[i])^2  + (sum{i in gen_slack} MVABase*qn[i])^2);
for {(l,i,j) in arcsf}{
    printf "FLOW, %d, %d, %d, %f, %f, %f \n", l, i, j,  sqrt(p[l,i,j]^2 + q[l,i,j]^2), S[l], sqrt(p[l,i,j]^2 + q[l,i,j]^2) - S[l];
    printf "FLOW, %d, %d, %d, %f, %f, %f \n", l, j, i,  sqrt(p[l,j,i]^2 + q[l,j,i]^2), S[l], sqrt(p[l,j,i]^2 + q[l,j,i]^2) - S[l];
}

display pn;
display qn;
display S_ref_q[scen];
display S_ref_q_pcc[scen];
display pcc_eps;
display wtqn;
display wtqn_v;
display bszd;
display bszc;
display V;
display t;
display VTr;
display sum{i in gen} MVABase*pn[i];
display sum{i in nodes} MVABase*Sp[scen,i];
display Cost;
display _solve_user_time;

display solve_message;
display solve_result;
display solve_result_num;

printf "-, system, scenario, solve result, time(seconds), obj \n";
printf "DATA, %d, %d, %d, %f, %f, %f \n", card(nodes), scen, solve_result_num, _solve_elapsed_time, obj, vio;

for {i in nodes}{
    #printf "SCEN, %d, %.6f\t%.14f \n", i, -Sp[scen,i]*MVABase, -wtqn[i]*MVABase;
}


for {(i,gid) in busgen}{
    #display i, gid, V[i];
}


for {i in nodes}{
    #display i, bszc[i]*cgsinc[i]+cgsmin[i]+gs[i], bszc[i]*cbsinc[i]+cbsmin[i]+bszd[i]*bsinc[i]+bsmin[i];
}

for {i in shunt_bus_c}{
    display i, bszc[i]*cgsinc[i]+cgsmin[i], bszc[i]*cbsinc[i]+cbsmin[i];
}

for {i in shunt_bus}{
    display i, bszd[i]*bsinc[i]+bsmin[i];
}

for {(l,i,j) in arcsf}{
    if l in trans_line then {
        display l, i, j,  trinc[l], VTr[l], Trmin[l], trinc[l]*VTr[l]+Trmin[l];
    }
}


#Outputs competition variables;
#printf "VARS";
printf "VARS, %f", sum{i in gen} MVABase*pn[i];

#for{i in gen}{
#    for{(j,i) in busgen : refBus <> j}{
#        printf ", %f",  pn[i]*MVABase;
#    }
#}

for{i in w_gen}{
    printf ", %.14f",  -MVABase*wtqn[i];
}
for{l in lines}{
    if Trstep[l] <> 0 then {
        printf ", %f",  VTr[l]-Trstep[l]/2;
    }
}
for{i in shunt_bus_c}{
    printf ", %f",  bszc[i];
}
for{i in shunt_bus}{
    printf ", %f",  bszd[i];
}
printf "\n";
