var p {arcs};
var q {arcs};

var V {i in nodes};
var t {i in nodes};

var pn {i in gen};
var qn {i in gen};

var VTr {l in lines} integer >= 0, <= Trstep[l];
var VTri {lines};

var bsz {i in nodes} integer >= 0, <= bsstep[i];

minimize Cost: sum{i in gen} (c2[i]*(MVABase*pn[i])^2 + c1[i]*MVABase*pn[i] + c0[i]);

subject to UPBoundsP{i in gen}: pn[i] <= Pmax[i];
subject to LOWBoundsP{i in gen}: pn[i] >= Pmin[i];
#subject to UPBoundsP{i in gen_slack}: pn[i] <= Pmax[i];

#subject to UPBoundsPG{i in gen : i not in gen_slack}: pn_vio[i] >=  pn_vio[i] - Pmax[i];
#subject to LBBoundsPG{i in gen : i not in gen_slack}: pn_vio[i] >= -pn_vio[i] + Pmin[i];


subject to UPBoundsQ{i in gen}: qn[i] <= Qmax[i] - 0.0001;
subject to LOWBoundsQ{i in gen}: qn[i] >= Qmin[i] + 0.0001;

subject to UPBoundsV{i in nodes}: V[i] <= Vmax[i] + 0.00005; #- 0.0001;
subject to LOWBoundsV{i in nodes}: V[i] >= Vmin[i] + 0.0001;

subject to refBusDef: t[refBus] = 0;

subject to ThetaLBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] >= thLBound;
subject to ThetaUBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] <= thUBound;

subject to BusflowBalP {i in nodes}: sum{(con,l,i,j) in arcs_c} p[l,i,j] +                      gs[i]*V[i]^2 + pl[i] = sum{(i,gid) in busgen} pn[gid];
subject to BusflowBalQ {i in nodes}: sum{(con,l,i,j) in arcs_c} q[l,i,j] - (bsz[i]*bsinc[i]+bsmin[i])*V[i]^2 + ql[i] = sum{(i,gid) in busgen} qn[gid];

subject to TapRatioInverseLB {l in lines}: VTri[l] <= 1/Trmin[l];
subject to TapRatioInverseUB {l in lines}: VTri[l] >= 1/(trinc[l]*Trstep[l]+Trmin[l]);

subject to TapRatioInverse {l in lines}: VTri[l]*(trinc[l]*VTr[l]+Trmin[l]) = 1;
#subject to TapRatioInverse {l in lines}: VTri[l]*Tr[l] = 1;


subject to PFlow {(con,l,i,j) in arcsf_c}: p[l,i,j] = 
        g[l]*(V[i]*VTri[l])^2 
     + -g[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
     + -b[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to PFlow2 {(con,l,i,j) in arcst_c}: p[l,i,j] = 
        g[l]*V[i]^2 
     + -g[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
     + -b[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to QFlow {(con,l,i,j) in arcsf_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*(V[i]*VTri[l])^2 
    +  b[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
    + -g[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to QFlow2 {(con,l,i,j) in arcst_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*V[i]^2 
    +  b[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
    + -g[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to Capacity {(l,i,j) in arcs}: p[l,i,j]^2 + q[l,i,j]^2 <= S[l]^2;


for {i in nodes}{
    let V[i]:=1.0;
    let t[i]:=0;
    let bsz[i]:=bsstep[i];
}
for {l in lines}{
    let VTr[l] := Trstep[l]/2;
}


option solver ipopt;
#option solver couenne;
#option ipopt_options 'halt_on_ampl_error yes tol=1e-4';
#option cplex_options 'timing=1 clocktype=1 prestats=1 bardisplay=2 mipdisplay=1 threads=5 parallelmode=1';

option solver bonmin;
option bonmin_options 'bonmin.allowable_fraction_gap=0.0005';

option presolve 1;

solve;

#print solve_message;

#display degree;
#display sqrt(p[187,125,126]^2 + q[187,125,126]^2);
#display sqrt(p[187,126,125]^2 + q[187,126,125]^2);

param obj;
let obj := sum{i in gen} (c2[i]*(MVABase*pn[i])^2 + c1[i]*MVABase*pn[i] + c0[i]);

display pn;
display qn;
display bsz;
display V;
display t;
display VTr;
display sum{i in nodes} MVABase*pl[i];
display Cost;
display _solve_user_time;

display solve_message;
display solve_result;
display solve_result_num;

printf "-, system, contingency, solve result, time(seconds), obj \n";
printf "DATA, %d, %d, %d, %f, %f \n", card(nodes), con, solve_result_num, _solve_elapsed_time, Cost;


#Outputs competition variables;
#printf "VARS";
printf "VARS, %f", obj;

for{i in gen}{
    for{(j,i) in busgen : refBus <> j}{
        printf ", %.14f",  pn[i]*MVABase;
    }
}
for{i in gen}{
    for{(j,i) in busgen}{
        printf ", %.14f",  V[j];
    }
}
for{l in lines}{
    if Trstep[l] <> 0 then {
        printf ", %f",  VTr[l]-Trstep[l]/2;
    }
}
for{i in nodes}{
    if bsstep[i] <> 0 then {
        printf ", %f",  bsz[i];
    }
}
printf "\n";
