set nodes;
set gen;
set lines;
set contingencies;

set gen_bus;
set gen_slack;
set trans_line;
set shunt_bus;

set busgen within (nodes cross gen);

set arcsf within (lines cross nodes cross nodes);
set arcst within (lines cross nodes cross nodes);
set arcs = arcsf union arcst;

set nodes_c within (contingencies cross nodes);
set gen_c within (contingencies cross gen);
set lines_c within (contingencies cross lines);
set busgen_c within (contingencies cross nodes cross gen);
set arcsf_c within (contingencies cross lines cross nodes cross nodes);
set arcst_c within (contingencies cross lines cross nodes cross nodes);
set arcs_c = arcsf_c union arcst_c;

set shunt_bus_c;
param cgsmin {nodes};
param cgsmax {nodes};
param cbsmin {nodes};
param cbsmax {nodes};

param cgsinc {i in nodes} := (cgsmax[i]-cgsmin[i]);
param cbsinc {i in nodes} := (cbsmax[i]-cbsmin[i]);

param w_gen_r_ub;
param w_gen_r_lb;
set w_gen;
set scenarios;
#set scenario_nodes within (scenarios cross nodes);
param Sp{scenarios cross nodes};
param pcc_eps;
param S_ref_q{scenarios};
param S_ref_q_pcc{scenarios};


param DEBUG:=0;
param AC:=0;
param pi:= 3.14;
param MVABase;
param thLBound;
param thUBound;
param refBus;


param pl {nodes};
param ql {nodes};
param Vmin {nodes};
param Vmax {nodes};
param gs {nodes};
param bs {nodes};
param bsmin {nodes};
param bsmax {nodes};
param bsstep {nodes};

param bsinc {i in nodes} := (bsmax[i]-bsmin[i])/max(1,bsstep[i]);

param Pmin{gen};
param Pmax{gen};
param Qmin{gen};
param Qmax{gen};
param Vs{gen};
param Ps{gen};
param c0 {gen};
param c1 {gen};
param c2 {gen};

param fb {lines};
param tb {lines};
param x {lines};
param r {lines};
param lc {lines};
param S {lines};
param Tr {lines};
param As {lines};
param stat {lines};
param Trmin {lines};
param Trmax {lines};
param Trstep {lines};

param trinc {l in lines} := (Trmax[l]-Trmin[l])/max(1,Trstep[l]);

param g {l in lines} := r[l]/(x[l]^2 + r[l]^2);
param b {l in lines} := -x[l]/(x[l]^2 + r[l]^2);
param cc {l in lines} := Tr[l]*cos(abs(As[l]));
param dd {l in lines} := Tr[l]*sin(abs(As[l]));

option presolve 0;
