%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% TBD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function nicta_test(fhd,ii,jj,kk,args)
    % Paste and adapt the following 
    % parts to your implementation.
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	global proc
    global ps
    % Reinitialization of local
    % function evaluation counter.
    proc.i_eval=0;
    % Function evaluation at which
    % the last update of the global
    % best solution occurred.
    % Refers to the internal evaluation
    % using static penalty constraint 
    % handling method.
	proc.last_improvement=1;
    % Signalizing your 
    % to stop running.
    proc.finish=0;   
    % Size of the swarm.
    n_par=proc.pop_size;
    % For dynamic weight adaption.
    me=proc.n_eval;
    % Dimensionality of test case.
    D=ps.D;
    % Individuals' lower bounds.
    VRmin=ps.x_min;
    % Individuals' upper bounds.
    VRmax=ps.x_max;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %debuging mode with ampl not available.
    debug = 0;
    
    %pos - is a vector of variable values used for solution evaluation (power flow study)
    cc=[2 2];
    iwt=0.9-(1:me).*(0.5./me);
    if length(VRmin)==1
        VRmin=repmat(VRmin,1,D);
        VRmax=repmat(VRmax,1,D);
    end
    VRmin=repmat(VRmin,n_par,1);
    VRmax=repmat(VRmax,n_par,1);
    Vmin=VRmin;
    Vmax=VRmax;
    pos=VRmin+(VRmax-VRmin).*rand(n_par,D);
    
    command = 'ampl ./model/PARAM.mod';
    
    %pause()
    
    switch args{1}
        case 41
            command = strcat(command,' DATA41.mod');
        case 57
            command = strcat(command,' DATA57E.mod');
        case 118
            command = strcat(command,' DATA118.mod');
        case 300
            command = strcat(command,' DATA300.mod');
        otherwise
            disp('Unknown System ID');
            disp(args{1});
            quit();
    end
    
    switch args{1}
        case 41
            %command = strcat(command,' DATA41.mod');
            switch ii
                case 1
                    [status_scen,cmdout_scen] = system(strcat('echo ''param scen := ',int2str(jj),';'' > SCEN_tmp.mod'));
                    command = strcat(command,' ./SCEN_tmp.mod');
    
                    command = strcat(command,' ./model/ACModel_ll_wf_soft_wtq.mod');
                otherwise
                    disp('Unknown Problem Type');
                    disp(args{1});
                    disp(ii);
                    quit();
            end
        otherwise
            command = strcat(command,' ./model/CONT000.mod');
            switch ii
                case 1
                    % use this model, which will inject a small violation into the voltages
                    command = strcat(command,' ./model/ACModel_ll_sc.mod');
                    
                    %command = strcat(command,' ./model/ACModel_ll_sc_soft.mod');
                    %command = strcat(command,' ./model/ACModel_ll.mod');
                case 2
                    %command = strcat(command,' ./model/ACModel_opf_sc.mod');
                    command = strcat(command,' ./model/ACModel_opf_sc_active_bounds.mod');
                otherwise
                    disp('Unknown Problem Type');
                    disp(args{1});
                    disp(ii);
                    quit();
           end
    end
    
    
    %disp(VRmin);
    %disp(VRmax);
    %disp(pos);
    %disp(debug);
    if ~debug
        disp(command);
        [status,cmdout] = system(command);
        [a_obj,data,iterations] = parse_output(cmdout);
        
        disp('Processed Data:');
        disp(a_obj);
        disp(data);
        disp(iterations);
    
        if length(pos) ~= length(data)
            disp('processed data lengh is incorrect!!!');
            disp(length(pos));
            disp(length(data));
            quit();
        end;
        pos = data;
    else
        a_obj = 0;
        disp('Built this Command:');
        disp(command);
        disp('Using dummy data...');
    end;
    
    
    disp(pos);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %[fit,obj,g_sum,pos]=feval(fhd,ii,jj,kk,args,pos);
    [fit,obj,g_sum,pos,fit_best]=feval(fhd,ii,jj,kk,args,pos);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    disp([obj, fit, fit_best]);
    disp( sprintf( 'DATA, %d, %d, %d, %.14f, %.14f, %.14f, %.14f', args{1}, jj, iterations, obj, a_obj, obj-a_obj, fit_best) ); 
    
    vel=Vmin+2.*Vmax.*rand(n_par,D);
    pbest=pos;
    pbestval=fit;
    [gbestval,gbestid]=min(pbestval);
    gbest=pbest(gbestid,:);
    gbestrep=repmat(gbest,n_par,1);

    proc.finish = 1;
    return;
end

function [obj,result,iterations] = parse_output(ampl_out)
    lines = regexp(ampl_out,'\n', 'split');
    
    iteration_lines = {};
    var_lines = [];
    
    for i=1:length(lines);
        iteration_lines_tmp = regexp(lines{i},'NLP....I.*', 'match');
        if length(iteration_lines_tmp) == 1
            iteration_lines{end+1} = iteration_lines_tmp{1};
        end;
        
        var_lines_tmp = regexp(lines{i},'VARS.*', 'match');
        if length(var_lines_tmp) == 1
            var_lines = var_lines_tmp;
        end;
    end;
    
    %iteration_lines = regexp(ampl_out,'Cbc0001I .*\n?', 'match');
    %var_lines = regexp(ampl_out,'VARS.*\n', 'match');
    
    if length(var_lines) ~= 1 || length(iteration_lines) < 1
        disp(ampl_out);
        disp(length(iteration_lines));
        disp(iteration_lines);
        disp(length(var_lines));
        disp(var_lines);
        disp('ampl parsing failed!');
        quit();
    end;
    
    
    disp('Raw Iteration Data:');
    disp(length(iteration_lines));
    iterations = 1;
    for i=1:length(iteration_lines)
        iter_line_items = regexpi(iteration_lines{i},'\s+','split');
        %disp(iter_line_items);
        if length(iter_line_items) == 6
            %disp(iter_line_items{5});
            iterations = iterations + str2num(deblank(iter_line_items{5}));
        end;
    end;
    
    dataline = deblank(var_lines{1});
    disp('Raw Vars Data:');
    disp(dataline);
    items = regexpi(dataline,',','split');
    obj = str2num(deblank(items{2}));
    items = items(3:end);
    result = zeros(1, length(items));
    %format long;
    for i=1:length(items);
        result(i) = str2num(deblank(items{i}));
        %disp(items{i});
        %disp(result(i));
    end;
    return;
end
