#converts a MATPOWER .m file to a AMPL .dat file

import math

def readMatrix(index, lines):
   matrixLines = []
   #print "start: ", lines[index].strip()
   while True : 
      matrixLine = lines[index].strip()
      if matrixLine == '];' :
         break
      else :  
         matrixLineParts = matrixLine.split(';')[0].split('\t')
         matrixLineParts = [x.strip() for x in matrixLineParts]
         matrixLines.append(matrixLineParts)
         index += 1
   return matrixLines


mpFileName = 'case3_l.m'

import sys

if len(sys.argv) > 1:
   mpFileName = sys.argv[1].strip()

mpFile = open(mpFileName, 'r')

firstLine = mpFile.readline();
firstLineParts = firstLine.split(' ');
name = firstLineParts[-1].strip();

print "Translating: ", mpFileName

scenarios = 0
shuntData_c = []
wpp_dispatch = []
wpp_q_ref = []
wpp_q_ref_pcc = []
dispatch_ids = []

lines = mpFile.readlines()
index = 0;

while index < len(lines) :
   line = lines[index].strip()
   index += 1
   
   if (len(line) <= 0 or line[0] == '%') :
      continue
      
   #print index, line;
      
   if line[0:11] == 'mpc.version':
      lineParts = line.strip(' ;\t').split(' ');
      version = lineParts[-1];
      assert(version == '\'2\'')

   if line[0:13] == 'mpc.scenarios':
      lineParts = line.strip(' ;\t').split(' ');
      scenarios = int(lineParts[-1])

   if line[0:11] == 'mpc.baseMVA':
      lineParts = line.strip(' ;\t').split(' ');
      baseMVA = float(lineParts[-1])

   if line[0:19] == 'mpc.wpp_reactive_ub':
      lineParts = line.strip(' ;\t').split(' ');
      w_gen_r_ub = float(lineParts[-1])

   if line[0:11] == 'mpc.pcc_eps':
      lineParts = line.strip(' ;\t').split(' ');
      pcc_eps = float(lineParts[-1])

   if line[0:19] == 'mpc.wpp_reactive_lb':
      lineParts = line.strip(' ;\t').split(' ');
      w_gen_r_lb = float(lineParts[-1])

   if line[0:7] == 'mpc.bus' :
      busData = readMatrix(index, lines)
      index += len(busData)

   if line[0:7] == 'mpc.gen' and line[0:11] != 'mpc.gencost' :
      genData = readMatrix(index, lines)
      index += len(genData)

   if line[0:11] == 'mpc.gencost':
      genCostData = readMatrix(index, lines)
      index += len(genCostData)

   if line[0:10] == 'mpc.branch' :
      branchData = readMatrix(index, lines)
      index += len(branchData)

   if line[0:9] == 'mpc.shunt' and line[0:11] != 'mpc.shunt_c' :
      shuntData = readMatrix(index, lines)
      index += len(shuntData)

   if line[0:11] == 'mpc.shunt_c' :
      shuntData_c = readMatrix(index, lines)
      index += len(shuntData_c)

   if line[0:7] == 'mpc.tap' :
      tapData = readMatrix(index, lines)
      index += len(tapData)

   if line[0:16] == 'mpc.dispatch_ids' :
      lineParts = line.split('[')[1].split(']')[0].split(',');
      dispatch_ids = []
      for x in lineParts:
         try:
            dispatch_ids.append(int(x))
         except:
            print 'Warning: skipping dipatch id - "',x,'"'
            
      index += len(tapData)
            
   if line[0:16] == 'mpc.WPP_dispatch' :
      wpp_dispatch = readMatrix(index, lines)
      index += len(tapData)

   if line[0:13] == 'mpc.WPP_q_ref' and line[0:17] != 'mpc.WPP_q_ref_PCC':
      wpp_q_ref = readMatrix(index, lines)
      index += len(tapData)
      
   if line[0:17] == 'mpc.WPP_q_ref_PCC' :
      wpp_q_ref_pcc = readMatrix(index, lines)
      index += len(tapData)
      
   if line[0:17] == 'mpc.contingencies' :
      lineParts = line.split('[')[1].split(']')[0].split(',');
      #print lineParts;
      contingencyData = []
      for x in lineParts:
         try:
            contingencyData.append(int(x))
         except:
            print 'Warning: skipping contingency - "',x,'"' 

activeGens = set([])
for i,g in enumerate(genData):
    if int(g[7]) == 1:
        activeGens.add(i)
    else:
        print 'Warning: ommiting gen',i,'for status 0'
        
#print activeGens     
 
#print scenarios
#print dispatch_ids;
#print wpp_dispatch;
#print wpp_q_ref;
#print wpp_q_ref_pcc;

assert(scenarios == len(wpp_dispatch));
assert(scenarios == len(wpp_q_ref));
assert(scenarios == len(wpp_q_ref_pcc));
for dispatch in wpp_dispatch:
   assert(len(dispatch) == len(dispatch_ids));



contingencyData.insert(0,0) #add default scenario

genData = [g for i,g in enumerate(genData) if i in activeGens]
genCostData = [g for i,g in enumerate(genCostData) if i in activeGens]

bus_with_gen = set();
busGen = {}
for b in busData:
    busGen[int(b[0])] = set()

for i,g in enumerate(genData):
    busGen[int(g[0])].add(i)
    bus_with_gen.add(int(g[0]))

busShunt = {}
for i,s in enumerate(shuntData):
    busShunt[int(s[0])] = s;

busShuntC = {}
for i,s in enumerate(shuntData_c):
   busShuntC[int(s[0])] = s;

lineTap = {}
for i,t in enumerate(tapData):
    lineTap[(int(t[0]),int(t[1]))] = t;

trans_line = set();
for i,b in enumerate(branchData) :
      if (int(b[0]),int(b[1])) in lineTap:
          trans_line.add(i+1)

#print genData
#print genCostData
#print busGen
#print busShunt
#print bus_with_gen
#print trans_line
#print busShunt.keys()

datFileName = mpFileName.split('.')[0]+'.dat'
print 'output:', datFileName
datFile = open(datFileName, 'w')

thetaBound = 0.523598776;
refBus = -1
for busLine in busData :
   if int(busLine[1]) == 3 :
      refBus = int(busLine[0]);

gen_on_ref = set();
for i,g in enumerate(genData):
    #print i, int(g[0]), refBus
    if int(g[0]) == refBus:
        gen_on_ref.add(i);
#print gen_on_ref

datFile.write('######### Automatically generated DAT file #########'+'\n')
datFile.write('param MVABase := '+str(baseMVA)+";"+'\n')
datFile.write('param refBus := '+str(refBus)+";"+'\n')
datFile.write('param thUBound :=  '+str(thetaBound)+";"+'\n')
datFile.write('param thLBound := '+str(-thetaBound)+";"+'\n')

datFile.write('set nodes :='+'\n')
for bus in busData :
   datFile.write(bus[0]+'\n')
datFile.write(';'+'\n')  

datFile.write('set gen :='+'\n')
for i,g in enumerate(genData) :
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')

datFile.write('set lines := '+'\n')
for i,b in enumerate(branchData) :
      datFile.write(str(i+1)+'\n')
datFile.write(';'+'\n')

datFile.write('set contingencies := '+'\n')
for i,b in enumerate(contingencyData) :
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')


datFile.write('set gen_bus :='+'\n')
for i in bus_with_gen :
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')

datFile.write('set gen_slack :='+'\n')
for i in gen_on_ref:
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')

datFile.write('set trans_line :='+'\n')
for i in trans_line:
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')

datFile.write('set shunt_bus :='+'\n')
for i in busShunt.keys():
      datFile.write(str(i)+'\n')
datFile.write(';'+'\n')


datFile.write('set busgen :='+'\n')
for i,g in enumerate(genData) :
      datFile.write('( '+g[0]+' , '+str(i)+' )'+'\n')
datFile.write(';'+'\n')


datFile.write('set arcsf := '+'\n')
for i,b in enumerate(branchData) :
      #datFile.write(str(i)+'\n')
      datFile.write('( '+str(i+1)+' , '+b[0]+' , '+b[1]+' )'+'\n')
datFile.write(';'+'\n')

datFile.write('set arcst := '+'\n')
for i,b in enumerate(branchData) :
      #datFile.write(str(i)+'\n')
      datFile.write('( '+str(i+1)+' , '+b[1]+' , '+b[0]+' )'+'\n')
datFile.write(';'+'\n')


#set nodes_c within (contingencies cross nodes);
datFile.write('set nodes_c :='+'\n')
for bus in busData :
   for j,c in enumerate(contingencyData):
      datFile.write('( '+str(j)+' , '+str(bus[0])+' )'+'\n')
datFile.write(';'+'\n')  

#set gen_c within (contingencies cross gen);
datFile.write('set gen_c :='+'\n')
for i,g in enumerate(genData) :
   for j,c in enumerate(contingencyData):
      datFile.write('( '+str(j)+' , '+str(i)+' )'+'\n')
datFile.write(';'+'\n')

#set lines_c within (contingencies cross lines);
datFile.write('set lines_c := '+'\n')
for i,b in enumerate(branchData) :
   for j,c in enumerate(contingencyData):
      #if i==0 or i != c:
      if i+1 != c:
         datFile.write('( '+str(j)+' , '+str(i+1)+' )'+'\n')
datFile.write(';'+'\n')

#set busgen_c within (contingencies cross nodes cross gen);
datFile.write('set busgen_c :='+'\n')
for i,g in enumerate(genData) :
   for j,c in enumerate(contingencyData):
      datFile.write('( '+str(j)+' , '+g[0]+' , '+str(i)+' )'+'\n')
datFile.write(';'+'\n')

#set arcsf_c within (contingencies cross lines cross nodes cross nodes);
datFile.write('set arcsf_c := '+'\n')
for i,b in enumerate(branchData) :
   for j,c in enumerate(contingencyData):
      #if i==0 or i != c:
      if i+1 != c:
         datFile.write('( '+str(j)+' , '+str(i+1)+' , '+b[0]+' , '+b[1]+' )'+'\n')
datFile.write(';'+'\n')

#set arcst_c within (contingencies cross lines cross nodes cross nodes);
datFile.write('set arcst_c := '+'\n')
for i,b in enumerate(branchData) :
   for j,c in enumerate(contingencyData):
      #if i==0 or i != c:
      if i+1 != c:
         datFile.write('( '+str(j)+' , '+str(i+1)+' , '+b[1]+' , '+b[0]+' )'+'\n')
datFile.write(';'+'\n')



datFile.write('param: pl ql Vmin Vmax gs bs bsmin bsmax bsstep :='+'\n')
for bus in busData :
   gs = float(bus[4])/baseMVA
   bs = float(bus[5])/baseMVA
   bsmin = bs
   bsmax = bs
   bsstep = 0;
   
   if int(bus[0]) in busShunt:
       bs = 0.0;
       shuntData = busShunt[int(bus[0])]
       bsmin = float(shuntData[1])/baseMVA
       bsmax = float(shuntData[2])/baseMVA
       bsstep = int(shuntData[3])
   
   if int(bus[0]) in busShuntC:
      gs = 0.0;
      bs = 0.0;
      bsmin = 0.0;
      bsmax = 0.0;
      
   
   datFile.write(bus[0]+'\t'+str(float(bus[2])/baseMVA)+'\t'+str(float(bus[3])/baseMVA)+'\t'+bus[12]+'\t'+bus[11]+'\t'+str(gs)+'\t'+str(bs)+'\t'+str(bsmin)+'\t'+str(bsmax)+'\t'+str(bsstep)+'\n')
datFile.write(';'+'\n')

datFile.write('param: c0 c1 c2 Pmin Pmax Qmin Qmax Vs Ps :='+'\n')
for i,g in enumerate(genData)  :
   #print ga
   costData = genCostData[i]
   assert(g[7].strip() == '1') #generator should be active 
   assert(costData[0].strip() == '2' and costData[3].strip() == '3')  #make sure costs are in the only supported format
   datFile.write(str(i)+'\t'+costData[6]+'\t'+costData[5]+'\t'+costData[4]+'\t'+str(float(g[9])/baseMVA)+'\t'+str(float(g[8])/baseMVA)+'\t'+str(float(g[4])/baseMVA)+'\t'+str(float(g[3])/baseMVA)+'\t'+g[5]+'\t'+str(float(g[1])/baseMVA)+'\n')
datFile.write(';'+'\n')


datFile.write('param: fb tb r x lc S Tr As stat Trmin Trmax Trstep :='+'\n')
for i,branch in enumerate(branchData): 
   line = (int(branch[0]),int(branch[1]))
   Tr = 1.0
   As = 0.0
   Trmin = 1.0
   Trmax = 1.0
   Trstep = 0
   if float(branch[8]) != 0.0 or float(branch[9]) != 0.0:
       Tr = float(branch[8])
       As = float(branch[9])
       if float(branch[11]) == 0.0 and float(branch[12]) == 0.0:
           Trmin = Tr
           Trmax = Tr
           Trstep = 0
       else:
           Trmin = float(branch[12])
           Trmax = float(branch[11])
           assert(line in lineTap) #missing line tap step data in data file
           Trstep = int(lineTap[line][2])
   
   datFile.write(str(i+1)+'\t'+branch[0]+'\t'+branch[1]+'\t'+branch[2]+'\t'+branch[3]+'\t'+branch[4]+'\t'+str(float(branch[5])/baseMVA)+'\t'+str(Tr)+'\t'+str(As)+'\t'+branch[10]+'\t'+str(Trmin)+'\t'+str(Trmax)+'\t'+str(Trstep)+'\n')
datFile.write(';'+'\n')


if scenarios > 0:

   #print scenarios
   #print dispatch_ids;
   #print wpp_dispatch;
   #print wpp_q_ref;
   #print wpp_q_ref_pcc;
   
   bus_index_lookup = {}
   for i,bus in enumerate(busData):
      bus_index_lookup[int(bus[0])] = i
   
   datFile.write('set shunt_bus_c :='+'\n')
   for i in busShuntC.keys():
         datFile.write(str(i)+'\n')
   datFile.write(';'+'\n')
   
   
   datFile.write('param: cgsmin cgsmax cbsmin cbsmax :='+'\n')
   for bus in busData:
      if int(bus[0]) in busShuntC: 
         data = busShuntC[int(bus[0])];
         datFile.write(data[0]+'\t'+str(float(data[1])/baseMVA)+'\t'+str(float(data[2])/baseMVA)+'\t'+str(float(data[3])/baseMVA)+'\t'+str(float(data[4])/baseMVA)+'\n')
      else:
         datFile.write(bus[0]+'\t'+'0'+'\t'+'0'+'\t'+'0'+'\t'+'0'+'\n')
   datFile.write(';'+'\n')
   
   datFile.write('param w_gen_r_ub := '+str(w_gen_r_ub/baseMVA)+';\n')
   datFile.write('param w_gen_r_lb := '+str(w_gen_r_lb/baseMVA)+';\n')
   
   datFile.write('set w_gen :='+'\n')
   for i in dispatch_ids:
      datFile.write(str(i)+'\n')
   datFile.write(';'+'\n')
   
   #set scenarios;
   datFile.write('set scenarios :='+'\n')
   for s in range(1,scenarios+1) :
      datFile.write(str(s)+'\n')
   datFile.write(';'+'\n')


   datFile.write('param pcc_eps := '+str(pcc_eps)+';\n')
   
   #param S_ref_q{scenarios};
   datFile.write('param: S_ref_q S_ref_q_pcc :='+'\n')
   for s in range(1,scenarios+1):
      datFile.write(str(s)+'\t'+str(float(wpp_q_ref[s-1][0])/baseMVA)+'\t'+str(float(wpp_q_ref_pcc[s-1][0]))+'\n')
   datFile.write(';'+'\n')  

   #set scenario_nodes within (scenarios cross nodes);
   #index = 1
   #datFile.write('set scenario_nodes :='+'\n')
   #for s in range(1,scenarios+1) :
   #   for bus in busData: 
   #      #datFile.write('( '+str(index)+' , '+str(s)+' , '+bus[0]+' )'+'\n')
   #      datFile.write('( '+str(index)+' , '+bus[0]+' )'+'\n')
   #      index += 1;
   #datFile.write(';'+'\n')  


   #param Sp{scenario_nodes};
   #index = 0
   datFile.write('param: Sp :='+'\n')
   for s in range(1,scenarios+1):
      baseVector = [str(float(bus[2])/baseMVA) for bus in busData]
      for i,p in enumerate(wpp_dispatch[s-1]):
         #print i, dispatch_ids[i], 
         baseVector[bus_index_lookup[dispatch_ids[i]]] = str(float(p)/baseMVA);
      #print baseVector;
      for bus in busData:
         datFile.write(str(s)+'\t'+bus[0]+'\t'+baseVector[bus_index_lookup[int(bus[0])]]+'\n')
         #index += 1;
   datFile.write(';'+'\n')




print "Done..."
