var p {arcs};
var q {arcs};

var V {i in nodes};
var t {i in nodes};

var pn {i in gen};
var qn {i in gen};

var VTr {l in lines} integer >= 0, <= Trstep[l];
var VTri {lines};

var bsz {i in nodes} integer >= 0, <= bsstep[i];

minimize Cost: sum{i in gen} pn[i];

subject to PVal{i in gen : i not in gen_slack}: pn[i] == Ps[i];
#subject to UPBoundsP{i in gen_slack}: pn[i] <= Pmax[i];
#subject to LOWBoundsP{i in gen_slack}: pn[i] >= Pmin[i];

#small bound adjustments to account for numerical errors
subject to UPBoundsQ{i in gen}: qn[i] <= Qmax[i] - 0.0001;
subject to LOWBoundsQ{i in gen}: qn[i] >= Qmin[i] + 0.0001;

subject to UPBoundsV{i in nodes}:  V[i] <= Vmax[i] + 0.00001;
subject to LOWBoundsV{i in nodes}: V[i] >= Vmin[i] + 0.0001;

subject to refBusDef: t[refBus] = 0;

subject to ThetaLBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] >= thLBound;
subject to ThetaUBound_AC{(l,i,j) in arcsf}: t[i]-t[j]+As[l] <= thUBound;

subject to BusflowBalP {i in nodes}: sum{(con,l,i,j) in arcs_c} p[l,i,j] +                      gs[i]*V[i]^2 + pl[i] = sum{(i,gid) in busgen} pn[gid];
subject to BusflowBalQ {i in nodes}: sum{(con,l,i,j) in arcs_c} q[l,i,j] - (bsz[i]*bsinc[i]+bsmin[i])*V[i]^2 + ql[i] = sum{(i,gid) in busgen} qn[gid];

subject to TapRatioInverseLB {l in lines}: VTri[l] <= 1/Trmin[l];
subject to TapRatioInverseUB {l in lines}: VTri[l] >= 1/(trinc[l]*Trstep[l]+Trmin[l]);

subject to TapRatioInverse {l in lines}: VTri[l]*(trinc[l]*VTr[l]+Trmin[l]) = 1;

subject to PFlow {(con,l,i,j) in arcsf_c}: p[l,i,j] = 
        g[l]*(V[i]*VTri[l])^2 
     + -g[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
     + -b[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to PFlow2 {(con,l,i,j) in arcst_c}: p[l,i,j] = 
        g[l]*V[i]^2 
     + -g[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
     + -b[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to QFlow {(con,l,i,j) in arcsf_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*(V[i]*VTri[l])^2 
    +  b[l]*V[i]*VTri[l]*V[j]*cos(t[i]-t[j]+As[l])
    + -g[l]*V[i]*VTri[l]*V[j]*sin(t[i]-t[j]+As[l]);

subject to QFlow2 {(con,l,i,j) in arcst_c}: q[l,i,j]  = 
    -(lc[l]/2+b[l])*V[i]^2 
    +  b[l]*V[i]*V[j]*VTri[l]*cos(t[i]-t[j]-As[l])
    + -g[l]*V[i]*V[j]*VTri[l]*sin(t[i]-t[j]-As[l]);

subject to Capacity {(l,i,j) in arcs}: p[l,i,j]^2 + q[l,i,j]^2 <= S[l]^2;

for {i in nodes}{
    let V[i]:=1.0;
    let t[i]:=0;
    let bsz[i]:=bsstep[i];
}
for {l in lines}{
    let VTr[l] := Trstep[l]/2;
}


#option solver ipopt;
#option ipopt_options 'tol=1e-10';
#option solver couenne;
#option ipopt_options 'halt_on_ampl_error yes tol=1e-4';
#option cplex_options 'timing=1 clocktype=1 prestats=1 bardisplay=2 mipdisplay=1 threads=5 parallelmode=1';

option solver bonmin;
option bonmin_options 'bonmin.allowable_fraction_gap = 0.0005';
#option bonmin_options 'ipopt.tol=1e-10';

option presolve 1;

solve;

#fix VTr;
#fix bsz;
#option solver ipopt;
#solve;

#print solve_message;

#display degree;
#display sqrt(p[187,125,126]^2 + q[187,125,126]^2);
#display sqrt(p[187,126,125]^2 + q[187,126,125]^2);

#display pl;
#display ql;

param obj;
let obj := sum{i in gen} MVABase*pn[i] - sum{i in nodes} MVABase*pl[i];

display pn;
display qn;
display bsz;
display V;
display t;
display VTr;
display sum{i in nodes} MVABase*pl[i], obj;
display Cost, obj;
display _solve_user_time;

display solve_message;
display solve_result;
display solve_result_num;

printf "-, system, contingency, solve result, time(seconds), obj \n";
printf "DATA, %d, %d, %d, %f, %f, %f \n", card(nodes), con, solve_result_num, _solve_elapsed_time, obj, 0;

for {(i,gid) in busgen}{
    #display i, gid, V[i];
}

for {i in shunt_bus}{
    #display i, bsz[i]*bsinc[i]+bsmin[i];
}

for {(l,i,j) in arcsf}{
    if l in trans_line then {
        #display l, i, j,  trinc[l], VTr[l], Trmin[l], trinc[l]*VTr[l]+Trmin[l];
    }
}

for {i in nodes}{
    #printf "%d - %f %f \n", i, sum{(con,l,i,j) in arcsf_c} g[l]*VTri[l]^2, -bsz[i]*bsinc[i]+bsmin[i] + sum{(con,l,i,j) in arcsf_c} -(lc[l]/2+b[l])*VTri[l]^2;
}


for {(l,i,j) in arcs}{
    if Capacity[l,i,j].slack < 1 then {
        #display p[l,i,j]^2 + q[l,i,j]^2, S[l]^2, Capacity[l,i,j].slack;
    }
    #printf "%d %d %d - %f %f - %f %f - %f %f \n", l, i, j, MVABase*p[l,i,j], MVABase*q[l,i,j], MVABase*p[l,j,i], MVABase*q[l,j,i], MVABase*(p[l,i,j]+p[l,j,i]), MVABase*(q[l,i,j]+q[l,j,i]);
    #printf "%d (%d,%d) - %f %f - %f %f - %f %f \n", l, i, j, -g[l]*VTri[l], -b[l]*VTri[l], -g[l], -b[l], VTri[l], trinc[l]*VTr[l]+Trmin[l];
}

for {i in gen}{
    if UPBoundsQ[i].slack < 0.1 || LOWBoundsQ[i].slack < 0.1 then {
        #display i, UPBoundsQ[i].slack, LOWBoundsQ[i].slack;
    }
}

#Outputs competition variables;
#printf "VARS";
printf "VARS, %f", obj;

#for{i in gen}{
#    for{(j,i) in busgen : refBus <> j}{
#        printf ", %f",  pn[i]*MVABase;
#    }
#}

for{i in gen}{
    for{(j,i) in busgen}{
        printf ", %.14f",  V[j];
    }
}
for{l in lines}{
    if Trstep[l] <> 0 then {
        printf ", %f",  VTr[l]-Trstep[l]/2;
    }
}
for{i in nodes}{
    if bsstep[i] <> 0 then {
        printf ", %f",  bsz[i];
    }
}
printf "\n";
