function y = calcCubicStep(x, y0,y1,x0,x1)
%%
% Cubic step function as defined by MSC Adams
% http://web.mscsoftware.com/support/library/conf/adams/na/1995/UC950030.PDF
%
%
%%
y = 0;

if(x >= x1)
   y = y1; 
elseif(x <= x0)
   y = y0;
else
   dy = y1-y0;
   dx = x1-x0;   
   y = y0 + (dy/dx)*(x-x0) - (dy/(2*pi))*sin( (2*pi/dx)*(x-x0));    
end





