function path = calcPathProperties(t,pos,vel, flag_plot)


%%
%Compute the tangent unit vector, and its derivative
%%
vMVel = sum(vel.^2,2).^0.5;
vMVel(find(vMVel <= eps^0.5)) = eps^0.5;

uvT = vel./[vMVel vMVel vMVel] ;
uvdT = zeros(size(uvT));

for i=1:1:3
   uvdT(:,i) = dspline(t,uvT(:,i),t); 
end

%%
%Compute the curvature
%%
vS = cumtrapz(t,vel);
vk = uvdT./[vMVel vMVel vMVel];
k = sum(vk.^2,2).^0.5;

path.uvT = uvT;
path.uvdT = uvdT;
path.k = k;


if(flag_plot == 1)
   fig_test = figure;
    subplot(2,2,1)
        plot(t,pos(:,1),'r');
        hold on;
        plot(t,pos(:,2),'g');
        hold on;
        plot(t,pos(:,3),'b');
        hold on;
        xlabel('Time (s)');
        ylabel('Distance (m)');
        title('XYZ (r,g,b)');
    subplot(2,2,3)
        plot(t,vel(:,1),'r');
        hold on;
        plot(t,vel(:,2),'g');
        hold on;
        plot(t,vel(:,3),'b');
        hold on;
        xlabel('Time (s)');
        ylabel('Velocity (m/s)');
        title('XYZ (r,g,b)');
        
    subplot(2,2,2)
        plot(t,uvT(:,1),'r');
        hold on;
        plot(t,uvT(:,2),'g');
        hold on;
        plot(t,uvT(:,3),'b');
        hold on;
        xlabel('Time (s)');
        ylabel('Magnitude');
        title('Tangent XYZ (rgb)');
        
    subplot(2,2,4)
        plot(t,uvdT(:,1),'r');
        hold on;
        plot(t,uvdT(:,2),'g');
        hold on;
        plot(t,uvdT(:,3),'b');
        hold on;
        xlabel('Time (s)');
        ylabel('Magnitude');
        title('Tangent Der. XYZ (rgb)');
        
fig_test2 = figure;
    subplot(2,2,1)
        plot(t,vS);
        xlabel('Time (s)');
        ylabel('Distance (m)');
        title('Path');
    subplot(2,2,3)
        plot(t,vMVel);
        xlabel('Time (s)');
        ylabel('Velocity (m/s)');
        title('Path Velocity');
    subplot(2,2,2);
        plot(t,1./k,'r');
        xlabel('Time (s)');
        ylabel('1/K');
        title('Radius of Curvature');
        axis([0 10 0 2]);
    subplot(2,2,4)
        plot(pos(:,1), pos(:,3),'b')
        hold on;
        
        th = [pi:-0.01:pi/2];
        plot(cos(th)+1,sin(th),'r');
        
        xlabel('X');
        ylabel('Z');
        title('COM (b), Cicle (r)');
        axis square;
 
end