function success = formatFigure(fig ,figProp)
%%
% This function will create and format a figure according to the 
% settings stored in the structure figProp. This function is designed
% to be part of an innerloop that processes an array of figProp structures  
% to generate high-quality publication-ready plots.
%
% @param fig
%        A handle to an array of figure
%
% @param figProp
%        A structure containing the following fields:
%
%
%%
success = 0;
figure(fig);
%subplot(figProp.subplot(1),figProp.subplot(2),figProp.subplot(3));
subplot('Position', figProp.Position);

axis(figProp.plotRange);
if(figProp.AxisSquare==1)
    axis square;
end
if(figProp.AxisEqual==1)
   axis equal; 
end


%set(gcf,'Units', figProp.Units);
%set(gcf,'PaperPosition', figProp.PaperPosition);

set(gca,'FontName', figProp.fontName);
set(gca,'FontSize', figProp.fontSize);
set(gca, 'XTick',figProp.plotXTick,...
         'YTick',figProp.plotYTick);
set(gca,'Units','centimeters');
     
%%
%Set up the xlabels and ticks
%%
    xticloc = get(gca,'xtick');
    ax = axis;
    xlblDY = ax(3) - 0.01*(ax(4)-ax(3)); 
    ylblDX = ax(1) - 0.01*(ax(2)-ax(1));
    set(gca,'xticklabel',[]);
    
    for i=1:1:length(xticloc)
       txt = num2str(figProp.plotXTick(i));
       if(isempty(figProp.plotXTickLabel)~=1)
          txt =  figProp.plotXTickLabel{i};
       end        
       text(xticloc(i),xlblDY, txt,...
            'HorizontalAlignment','center',...
            'VerticalAlignment','top',...
            'FontSize',figProp.fontSize,...
            'FontName', figProp.fontName,...
         'FontWeight', figProp.fontWeight,...
         'Interpreter','latex');  
    end

    
hx = xlabel(figProp.xLabel{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize,...
    'FontWeight','bold',...
    'Interpreter','latex');
set(hx,'Position',(get(hx,'Position') - [0 0.02 0]));

%%
%Set up the ylabels and ticks
%%
    yticloc = get(gca,'ytick');  
    set(gca,'yticklabel',[]);
    
    for i=1:1:length(yticloc)
       txt = num2str(figProp.plotYTick(i));
       if(isempty(figProp.plotYTickLabel)~=1)
          txt =  figProp.plotYTickLabel{i};
       end
        
       text(ylblDX, yticloc(i), txt,...
            'HorizontalAlignment','right',...
            'VerticalAlignment','middle',...
            'FontSize',figProp.fontSize,...
            'FontName', figProp.fontName,...
         'FontWeight', figProp.fontWeight,...
         'Interpreter','latex'); 
    end
    
    
hy = ylabel(figProp.yLabel{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize,...
    'FontWeight','bold',...
    'Interpreter','latex');

set(hy,'Position',(get(hy,'Position') + [0.01 0 0])); 
     
%%
%Set up title
%%

ht = title(figProp.title{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize+2,...
    'FontWeight','normal',...
    'Interpreter','latex');
set(ht,'Position',(get(ht,'Position') - [0 0.02 0]));


success = 1;