function success = plotData(fig, xData, yData, dataProps, figProp)
success = 0;
figure(fig);
subplot('Position', figProp.Position);
for i = 1:1:size(yData,2)
   if( isempty(dataProps.special) == 1)
       plot(xData.*dataProps.xScaling,...
            yData(:,i).*dataProps.yScaling,...
            dataProps.line{i},...
            'Color', dataProps.lineColor(i,:),...
            'LineWidth', dataProps.lineWidth(i));
   else  
       
       x0 = dataProps.special.dataOff(1).*dataProps.xScaling;
       y0 = dataProps.special.dataOff(2).*dataProps.yScaling;
       
       %%
       %Plot the foot pads
       %%
       rH    = dataProps.special.param(4);
       rM    = dataProps.special.param(5);
       mtAng = dataProps.special.param(6);
       rMH   = [dataProps.special.param(1)...
                dataProps.special.param(2)...
                dataProps.special.param(3)];
       
            
            
       th = [0:0.01:2*pi];
       xCirc = cos(th);
       yCirc = sin(th);
       v1 = ones(size(th));
       fill((xCirc.*rH).*dataProps.xScaling-x0, ...
            (yCirc.*rH).*dataProps.xScaling-y0, ...
            dataProps.special.color(i,:),'EdgeColor','none');
       hold on;
       fill((xCirc.*rM+[rMH(1).*v1]).*dataProps.xScaling-x0, ...
            (yCirc.*rM+[rMH(2).*v1]).*dataProps.xScaling-y0, ...
            dataProps.special.color(i,:), 'EdgeColor', 'none');
       
        hold on;
       %%
       %Plot the MT joint axis
       %%
       mtj = dataProps.special.color(i,:).*0.5;
       for k=1:1:3
          if(mtj(k) < 0)
            mtj(k) = 0;
          end
       end
       
       pt1 = [rM 0]';
       pt2 = [-rM 0]';
       RMmt = [cos(mtAng) -sin(mtAng); sin(mtAng) cos(mtAng)];
       pt1r = RMmt*pt1 + [rMH(1) rMH(2)]';
       pt2r = RMmt*pt2 + [rMH(1) rMH(2)]';
       plot( [pt1r(1) pt2r(1)].*dataProps.xScaling-x0,...
             [pt1r(2) pt2r(2)].*dataProps.yScaling-y0, '-',...
              'Color',mtj,...
              'LineWidth', 1);
       hold on;
       
       %%
       %Plot the COP with line thickness varying with error
       %%
       
       
       
       
       xD = [xData(:).*dataProps.xScaling-x0];
       yD = [yData(:).*dataProps.yScaling-y0];
       wD = [dataProps.special.data(:,2).*dataProps.special.scale(1)];
                    
       plotVariableWidthLine(xD,yD,wD,fig);
       
       
       
       yD = [0:0.001:0.05].*dataProps.yScaling;       
       wD = [0:0.001:0.05].*dataProps.special.scale(1);
       xD = (ones(size(yD)).*(-0.05)).*dataProps.xScaling;
       
       plotVariableWidthLine(xD,yD,wD,fig);
       
       idxStar = dataProps.special.indexStar;
       
       plot(xData(idxStar).*dataProps.xScaling-x0, ...
            yData(idxStar).*dataProps.yScaling-y0, 'o',...
            'Color',[0,0,0],...
            'MarkerFaceColor',[1 1 1]);
        hold on;
       
%         plot(xData(1).*dataProps.xScaling, ...
%             yData(1).*dataProps.yScaling, 'o',...
%             'Color',[0,0,0],...
%             'MarkerFaceColor',[0 0 0]);
%         hold on;
        
   end
    hold on;
end

success = 1;

