
load([folder,'/',dataInput{1}]);
%%
%Walking01
%%

%%
% Subplot properties
%%
%Error plots
idx = 1;%idx_err;
fP(idx).figIdx = 1;
fP(idx).dataIdx = [7 8];
fP(idx).subplot = [1,3,1];
fP(idx).plotRange = [0 max(output.err.time) 0 5.25];
fP(idx).plotXTick = [0:0.3:0.6];
fP(idx).plotYTick = [0,1,5];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'Time (s)'};%{'Time (s)'};
fP(idx).yLabel = {'Distance (cm)'};
fP(idx).title  = {'$\mathbf{\epsilon(t)}$'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [1 1 2 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 0;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%GRF plots
idx = 2;%idx_grf;
fP(idx).figIdx = 1;
fP(idx).dataIdx = [1 2 3];
fP(idx).subplot = [1,3,2];
fP(idx).plotRange = [0 max(output.err.time) -0.400 1.500];
fP(idx).plotXTick = [0:0.3:0.6];
fP(idx).plotYTick = [-0.5:0.5:1];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'Time (s)'};
fP(idx).yLabel = {'Norm. Force (BW)'};
fP(idx).title  = {'\textbf{GRF}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [6.0 1 2 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 0;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%COP plots
idx = 3;%idx_cop;
fP(idx).figIdx = 1;
fP(idx).dataIdx = [4 5 6];
fP(idx).subplot = [1,3,3];
fP(idx).plotRange = [-5.5 5.5 -1 24];
fP(idx).plotXTick = [-2 0 2];
fP(idx).plotYTick = [0 10 20];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'X (cm)'};
fP(idx).yLabel = {'Y (cm)'};
fP(idx).title  = {'\textbf{COP}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [8.75 1 1.5 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 1;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%Error
idx = 4;
fP(idx).figIdx = 1;
fP(idx).dataIdx = [19];
fP(idx).subplot = [1,3,3];
fP(idx).plotRange = [-6 6 -1 24];
fP(idx).plotXTick = [-2 0 2];
fP(idx).plotYTick = [0 10 20];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'X (cm)'};
fP(idx).yLabel = {'Y (cm)'};
fP(idx).title  = {'$\mathbf{\epsilon(t)}$ \textbf{on COP (foot)}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [3.75 1 1.5 4]; 
%fP(idx).PaperPosition = [1.0 1 1.5 4];
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 1;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;
%%
%Data series properties
%%



tStar = [0.36,0.5];
idxMdlStar =zeros(size(tStar));
idxExpStar =zeros(size(tStar));
idxErrStar =zeros(size(tStar));

for k=1:1:length(tStar)
   idxMdlStar(k) = min(find(output.mdl.time > tStar(k)));
   idxExpStar(k) = min(find(output.exp.time > tStar(k)));
   idxErrStar(k) = min(find(output.err.time > tStar(k)));
end
           

%EXP grf
idx = 1;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thickLine,thickLine,thickLine];
    dP(idx).lineColor = [0.8 0.8 0.8;...
                       0.8 0.8 0.8;...
                       0.8 0.8 0.8];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    dP(idx).xdata = output.exp.time;
    dP(idx).ydata = output.exp.grf;
    dP(idx).special = [];

%MDL grf               
idx = 2;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0;...
                       0 0 0;...
                       0 0 0;];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    dP(idx).xdata = output.mdl.time;
    dP(idx).ydata = output.mdl.grf;
    dP(idx).special = [];
    
idx = 3;
    dP(idx).line = {'o','o','o'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0;...
                         0 0 0;
                         0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    %idx0 = min(find(output.mdl.time >= max(output.mdl.time)*0.5) );
    dP(idx).xdata = output.mdl.time(idxMdlStar);
    dP(idx).ydata = output.mdl.grf(idxMdlStar,:);
    dP(idx).special = [];
    
%EXP cop
idx = 4;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thickLine,thickLine,thickLine];
    dP(idx).lineColor = [0.8 0.8 0.8];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];
    
    x0 = output.mdl.cop(1,1);
    y0 = output.mdl.cop(1,2);
    
    dP(idx).xdata = output.exp.cop(:,1)-x0;
    dP(idx).ydata = output.exp.cop(:,2)-y0;
    dP(idx).special = [];
    
%MDL cop       
idx = 5;
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];
    dP(idx).xdata = output.mdl.cop(:,1)-x0;
    dP(idx).ydata = output.mdl.cop(:,2)-y0;
    dP(idx).special = [];
    
idx = 6;
    dP(idx).line = {'o'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];

    %idx0 = min(find(output.mdl.time >= max(output.mdl.time)*0.5) );
    dP(idx).xdata = output.mdl.cop(idxMdlStar,1)-x0;
    dP(idx).ydata = output.mdl.cop(idxMdlStar,2)-y0;
    dP(idx).special = [];

%Err ankle 
idx = 7;
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [100];
    dP(idx).xdata = output.err.time;

    errDist = ( output.err.xDist(:,1).^2 ...
              + output.err.xDist(:,2).^2 ...
              + output.err.xDist(:,3).^2).^0.5;
    
    dP(idx).ydata = errDist;
    dP(idx).special = [];
              
idx = 8;
    dP(idx).line = {'o'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [100];
    
    
    dP(idx).xdata = output.err.time(idxErrStar);
    dP(idx).ydata = dP(idx-1).ydata(idxErrStar);
    dP(idx).special = [];
    
idx = 17;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thinLine, thinLine, thinLine];
    dP(idx).lineColor = [0.25 0.25 0.25; 0.5 0.5 0.5; 0.75 0.75 0.75];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [5/(pi/4)];
    
    ang = [ output.exp.kin(:,13)];
    
    dP(idx).xdata = output.exp.time;
    dP(idx).ydata = ang;    
    dP(idx).special = [];
    
idx = 19;
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];
    
    x0 = 0;%output.mdl.flat.cop(1,1);
    y0 = output.mdl.flat.cop(1,2);
    
    dP(idx).xdata = interp1(output.mdl.time,output.mdl.flat.cop(:,1),...
                            output.err.time);
    dP(idx).ydata = interp1(output.mdl.time,output.mdl.flat.cop(:,2),...
                            output.err.time);    
    dP(idx).special.param =  output.mdl.flat.param;    
    dP(idx).special.data  =  [output.err.time errDist];  
    dP(idx).special.dataOff= [x0 y0];
    dP(idx).special.scale = [15, 15];
    dP(idx).special.color = [0.9 0.9 0.9];
    dP(idx).special.indexStar = idxExpStar;
    
load([folder,'/',dataInput{2}]);
%%
%Rotations10
%%
%%
% Subplot settings
%%

%Error plots
idx = 5;
fP(idx).figIdx = 2;
fP(idx).dataIdx = [15 16];
fP(idx).subplot = [1,3,1];
fP(idx).plotRange = [0 max(output.err.time) 0 5.25];
fP(idx).plotXTick = [0 5 10];
fP(idx).plotYTick = [0,1,5];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'Time (s)'};%{'Time (s)'};
fP(idx).yLabel = {'Distance (cm)'};
fP(idx).title  = {'$\mathbf{\epsilon(t)}$'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [1 1 2 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 0;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%GRF plots
idx = 6;
fP(idx).figIdx = 2;
fP(idx).dataIdx = [9 10 11];
fP(idx).subplot = [1,3,2];
fP(idx).plotRange = [0 max(output.err.time) -0.400 1.500];
fP(idx).plotXTick = [0 5 10];
fP(idx).plotYTick = [-0.5:0.5:1];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'Time (s)'};
fP(idx).yLabel = {'Norm. Force (BW)'};
fP(idx).title  = {'\textbf{GRF}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [6.0 1 2 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 0;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%COP plots
idx = 7;
fP(idx).figIdx = 2;
fP(idx).dataIdx = [12 13 14];
fP(idx).subplot = [1,3,3];
fP(idx).plotRange = [-6 6 -2.5 23];
fP(idx).plotXTick = [-2 0 2];
fP(idx).plotYTick = [0 10 20];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'X (cm)'};
fP(idx).yLabel = {'Y (cm)'};
fP(idx).title  = {'\textbf{COP}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [8.75 1 1.5 4]; 
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 1;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%COP Error plots
idx = 8;
fP(idx).figIdx = 2;
fP(idx).dataIdx = [20];
fP(idx).subplot = [1,3,2];
fP(idx).plotRange = [-6 6 -2.5 23];
fP(idx).plotXTick = [-2 0 2];
fP(idx).plotYTick = [0 10 20];
fP(idx).fontName = fontName;
fP(idx).fontSize = fontSize;
fP(idx).fontWeight = fontWeight;
fP(idx).xLabel = {'X (cm)'};
fP(idx).yLabel = {'Y (cm)'};
fP(idx).title  = {'$\mathbf{\epsilon(t)}$ \textbf{on COP (foot)}'};
fP(idx).Units = 'centimeters';
fP(idx).PaperPosition = [3.75 1 1.5 4]; 
%fP(idx).PaperPosition = [1.0 1 1.5 4];
fP(idx).Position = fP(idx).PaperPosition./11;
fP(idx).AxisEqual = 1;
fP(idx).AxisSquare = 0;
fP(idx).flag_formatted = 0;

%%
% Data series 
%%

tStar = [1.39, 3.25, 5.4, 8.74, 10.8];
idxMdlStar =zeros(size(tStar));
idxExpStar =zeros(size(tStar));
idxErrStar =zeros(size(tStar));

for k=1:1:length(tStar)
   idxMdlStar(k) = min(find(output.mdl.time > tStar(k)));
   idxExpStar(k) = min(find(output.exp.time > tStar(k)));
   idxErrStar(k) = min(find(output.err.time > tStar(k)));
end
           

%EXP grf
idx = 9;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thickLine,thickLine,thickLine];
    dP(idx).lineColor = [0.8 0.8 0.8;...
                       0.8 0.8 0.8;...
                       0.8 0.8 0.8];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    dP(idx).xdata = output.exp.time;
    dP(idx).ydata = output.exp.grf;
    dP(idx).special = [];

%MDL grf               
idx = 10;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0;...
                       0 0 0;...
                       0 0 0;];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    dP(idx).xdata = output.mdl.time;
    dP(idx).ydata = output.mdl.grf;
    dP(idx).special = [];
    
idx = 11;
    dP(idx).line = {'o','o','o'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0;...
                         0 0 0;
                         0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [1/bw];
    %idx0 = min(find(output.mdl.time >= max(output.mdl.time)*0.5) );
    dP(idx).xdata = output.mdl.time(idxMdlStar);
    dP(idx).ydata = output.mdl.grf(idxMdlStar,:);
    dP(idx).special = [];
    
%EXP cop
idx = 12;
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thickLine,thickLine,thickLine];
    dP(idx).lineColor = [0.8 0.8 0.8];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];
    
    x0 = mean(output.mdl.cop(:,1));
    y0 = min(output.mdl.cop(:,2));
    
    dP(idx).xdata = output.exp.cop(:,1)-x0;
    dP(idx).ydata = output.exp.cop(:,2)-y0;
    dP(idx).special = [];
    
%MDL cop       
idx = 13;
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];
    dP(idx).xdata = output.mdl.cop(:,1)-x0;
    dP(idx).ydata = output.mdl.cop(:,2)-y0;
    dP(idx).special = [];
    
idx = 14;
    dP(idx).line = {'o'};
    dP(idx).lineWidth = [thinLine,thinLine,thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];

    %idx0 = min(find(output.mdl.time >= max(output.mdl.time)*0.5) );
    dP(idx).xdata = output.mdl.cop(idxMdlStar,1)-x0;
    dP(idx).ydata = output.mdl.cop(idxMdlStar,2)-y0;
    dP(idx).special = [];

%Err ankle 
idx = 15;
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [100];
    dP(idx).xdata = output.err.time;
    
    errDist = ( output.err.xDist(:,1).^2 ...
              + output.err.xDist(:,2).^2 ...
              + output.err.xDist(:,3).^2).^0.5;
    
    dP(idx).ydata = errDist;
    dP(idx).special = [];
    
idx = 16;
    dP(idx).line = {'o'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [100];
    
    idx0 = min(find(output.err.time >= max(output.err.time)*0.5) );
    
    dP(idx).xdata = output.err.time(idxErrStar);
    dP(idx).ydata = dP(idx-1).ydata(idxErrStar);    
    dP(idx).special = [];
    
idx = 18; %17 is up top in Walking01
    dP(idx).line = {'-','-','-'};
    dP(idx).lineWidth = [thinLine, thinLine, thinLine];
    dP(idx).lineColor = [0.25 0.25 0.25; 0.5 0.5 0.5; 0.75 0.75 0.75];
    dP(idx).xScaling = [1];
    dP(idx).yScaling = [5/(pi/4)];
    
    ang = [output.exp.kin(:,13)];
    
    dP(idx).xdata = output.exp.time;
    dP(idx).ydata = abs(ang); 
    dP(idx).special = [];
    

idx = 20; %17 is up top in Walking01
    dP(idx).line = {'-'};
    dP(idx).lineWidth = [thinLine];
    dP(idx).lineColor = [0 0 0];
    dP(idx).xScaling = [100];
    dP(idx).yScaling = [100];   
    
    x0 = 0;%mean(output.mdl.flat.cop(:,1));
    y0 = min(output.mdl.flat.cop(:,2));
        
    dP(idx).xdata = interp1(output.mdl.time, output.mdl.flat.cop(:,1),output.err.time);
    dP(idx).ydata = interp1(output.mdl.time, output.mdl.flat.cop(:,2),output.err.time);
    dP(idx).special.param =  output.mdl.flat.param;    
    dP(idx).special.dataOff= [x0 y0];
    dP(idx).special.data  =  [output.err.time errDist];    
    dP(idx).special.scale = [15, 15];
    dP(idx).special.color = [0.9 0.9 0.9];
    dP(idx).special.indexStar = idxExpStar;
    