function success = formatFigure(fig ,figProp)
success = 0;
figure(fig);
%subplot(figProp.subplot(1),figProp.subplot(2),figProp.subplot(3));
subplot('Position', figProp.Position);

axis(figProp.plotRange);
if(figProp.AxisSquare==1)
    axis square;
end
if(figProp.AxisEqual==1)
   axis equal; 
end


%set(gcf,'Units', figProp.Units);
%set(gcf,'PaperPosition', figProp.PaperPosition);

%set(gca,'FontName', figProp.fontName);
%set(gca,'FontSize', figProp.fontSize);


hx = xlabel(figProp.xLabel{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize,...
    'FontWeight',figProp.fontWeight,...
    'Interpreter','latex');
hy = ylabel(figProp.yLabel{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize,...
    'FontWeight',figProp.fontWeight,...
    'Interpreter','latex');
ht = title(figProp.title{:},...
    'FontName',figProp.fontName,...
    'FontSize',figProp.fontSize,...
    'FontWeight',figProp.fontWeight,...
    'Interpreter','latex');

set(gca, 'XTick',figProp.plotXTick,...
         'YTick',figProp.plotYTick,...
         'FontName',figProp.fontName,...
         'FontSize',figProp.fontSize,...
         'FontWeight', figProp.fontWeight);


     
set(ht,'Position',(get(ht,'Position') - [0 0.02 0]));
set(hx,'Position',(get(hx,'Position') + [0 0.02 0]));
set(hy,'Position',(get(hy,'Position') + [0.02 0 0]));
     



success = 1;