clc;
close all;
clear all;

folder=  'limaIAK';

fP = [];%figure properties
dP = [];%data properties

%%
%Global figure formatting options
%%
bw = 70*9.81; %used for scaling

fontName = 'Arial';
fontSize = 8;
fontWeight = 'bold';

thickLine = 3;
thinLine = 1;

%%
%Make the empty figures
%%
fig(1) = figure;
fig(2) = figure;
dataInput  = {'opt_Walking01.mat', 'opt_Rotations10.mat'};
figOutput = {'fig_Walking01.pdf', 'fig_Rotations10.pdf'};

configurePlots;



for i=1:1:length(fP)           
   fP0 = fP(i);    
   figIdx = fP0.figIdx;
       
   for j=1:1:length(fP0.dataIdx)
      dIdx = fP0.dataIdx(j);
      plotData( fig(figIdx),...
              dP(dIdx).xdata,...
              dP(dIdx).ydata,...
              dP(dIdx), fP0);
   end
   
end

for i=1:1:length(fP)
    figIdx = fP(i).figIdx;
   if(fP(i).flag_formatted == 0)
    formatFigure(fig(figIdx),fP(i));    
    fP(i).flag_formatted = 1;
   end
end


for i=1:1:length(fig)
    figure(fig(i));
%     totalHeight = 0;
%     totalWidth = 0;
%     for j=1:1:length(fP)
%         if(fP(j).figIdx == i )
%             totalHeight = fP(j).PaperPosition(4);
%             totalWidth = totalWidth + fP(j).PaperPosition(3);
%         end
%         
%     end
%     
%     set(gcf,'PaperUnits','centimeters','PaperPosition',...
%            [0 0 totalHeight totalWidth]);
    %set(gca, 'Units','centimeters');
    
    set(gcf,'PaperUnits','centimeters');
    dims = get(gcf,'PaperPosition');
    sf = 12/dims(3);
    set(gcf,'PaperPosition', dims.*sf);
    
    
    
    
    saveas(fig(i),[folder,'/',figOutput{i}]);
end
