function success = plotVariableWidthLine(x,y,w, fig_h)
figure(fig_h);
success = 0;

xP = x(1);
yP = y(1);

w0 = w(1);
if(w0 < 0.1)
  w0 = 0.1; 
end

wP = (w0*0.5).*([-yP xP]./(xP^2+yP^2)^0.5);

cmap = colormap(gray(128));

for j=2:1:length(x)

   xC = x(j);
   yC = y(j);
   
   xD = xC-xP;
   yD = yC-yP;
   
   w0 = w(j);
   if(w0 < 0.1)
      w0 = 0.1; 
   end
   
   wC = (w0.*0.5).*([-yD xD]./(xD^2+yD^2)^0.5);

   err01 = w(j);
   clrIdx = 128-round(err01*128);
   clrIdx = round(clrIdx.*0.5);
   if(clrIdx > 128)
       clrIdx = 128;
   end
   if(clrIdx < 1)
        clrIdx = 1;
   end
   clr = cmap(clrIdx,:);
   %clr = [0 0 0];

   box = [(xP+wP(1)) (yP+wP(2));...
          (xC+wC(1)) (yC+wC(2));...
          (xC-wC(1)) (yC-wC(2));...
          (xP-wP(1)) (yP-wP(2))];


   fill(box(:,1), box(:,2),clr,'EdgeColor','none');
   hold on;

   xP = xC;
   yP = yC;
   wP = wC;
end

success = 1;