/*
 * Decompiled with CFR 0.152.
 */
package searchtool;

import java.io.File;
import java.util.Stack;
import java.util.Vector;

public class FileFinder {
    static String extension = ".xml";
    static Vector files;

    public FileFinder(String start) {
        files = new Vector();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(start);
        if (startdir.isDirectory()) {
            dirs.push(new File(start));
        }
        if (startdir.isFile()) {
            files.addElement(new File(start));
        }
        while (dirs.size() > 0) {
            File dirFiles = (File)dirs.pop();
            String[] s = dirFiles.list();
            if (s == null) continue;
            int i = 0;
            while (i < s.length) {
                File file = new File(dirFiles.getAbsolutePath() + File.separator + s[i]);
                if (file.isDirectory()) {
                    dirs.push(file);
                } else if (FileFinder.match(s[i], extension)) {
                    files.addElement(file);
                }
                ++i;
            }
        }
    }

    public Vector getVector() {
        return files;
    }

    private static boolean match(String s1, String suffix) {
        return s1.length() >= suffix.length() && s1.substring(s1.length() - suffix.length(), s1.length()).equalsIgnoreCase(suffix);
    }

    public void print() {
        int noFiles = files.size();
        if (noFiles == 0) {
            System.out.println("Keine XML-Dateien gefunden.");
            return;
        }
        System.out.print(noFiles + " Dateien gefunden:\n");
        int i = 0;
        while (i < noFiles) {
            System.out.println(((File)files.elementAt(i)).getAbsolutePath());
            ++i;
        }
    }
}

