/*
 * Decompiled with CFR 0.152.
 */
package searchtool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import searchtool.BrowserControl;
import searchtool.FileFinder;
import searchtool.SearchGUI;

public class SearchTheCorpus {
    static SearchGUI GUI = new SearchGUI();
    static int currentFile;
    static int currentNumberOfResults;
    static boolean error;
    static FileFinder ff;
    static String fileName;
    static String filePath;
    static boolean isCancelled;
    static String logfile;
    static int messageContext;
    static boolean mustHaveAddress;
    static boolean mustHaveAsteriskExpression;
    static boolean mustHaveEmoticon;
    static boolean mustHaveGeneralAddress;
    static boolean mustHaveGeneralNickname;
    static boolean mustHaveNickname;
    static boolean mustHaveSpecificAddress;
    static boolean mustHaveSpecificNickname;
    static int numberOfResults;
    static int numberOfSearchStrings;
    static String outputFileName;
    static String outputPath;
    static boolean searchDone;
    static String searchStringInput;
    static String searchStringModified;
    static boolean showAction;
    static boolean showActionScript;
    static boolean showBot;
    static boolean showNickname;
    static String showOnlyNicknameUser;
    static boolean showSystem;
    static boolean showUtterance;
    static boolean showUtteranceScript;
    static String specificAddressee;
    static String specificNickname;
    static int totalNumberOfFiles;

    static {
        filePath = "Chat Korpus/";
        outputPath = "Output/";
        outputFileName = "Output";
        fileName = "";
        numberOfSearchStrings = 0;
        messageContext = 0;
        searchDone = false;
        isCancelled = false;
        error = false;
        searchStringInput = "";
        searchStringModified = "";
        ff = new FileFinder(filePath);
        logfile = null;
        currentFile = 0;
        totalNumberOfFiles = 0;
        numberOfResults = 0;
        currentNumberOfResults = 0;
        mustHaveNickname = false;
        mustHaveGeneralNickname = false;
        mustHaveSpecificNickname = false;
        specificNickname = "";
        mustHaveEmoticon = false;
        mustHaveAsteriskExpression = false;
        mustHaveAddress = false;
        mustHaveGeneralAddress = false;
        mustHaveSpecificAddress = false;
        specificAddressee = "";
        showSystem = false;
        showAction = false;
        showActionScript = false;
        showUtterance = false;
        showUtteranceScript = false;
        showBot = false;
        showNickname = false;
        showOnlyNicknameUser = "";
    }

    public static String checkAsteriskExpression(String text) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<asteriskExpression>");
        int end = sb.indexOf("</asteriskExpression>", start);
        while (start != -1 && end != -1) {
            sb = sb.insert(start + 20, "<b><font color=\"#FF0000\">");
            sb = sb.insert(end + 25, "</font></b>");
            start = sb.indexOf("<asteriskExpression>", end + 45);
            end = sb.indexOf("</asteriskExpression>", start);
        }
        return sb.toString();
    }

    public static String checkEmoticon(String text) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<emoticon>");
        int end = sb.indexOf("</emoticon>", start);
        while (start != -1 && end != -1) {
            sb = sb.insert(start + 10, "<b><font color=\"#FF0000\">");
            sb = sb.insert(end + 25, "</font></b>");
            start = sb.indexOf("<emoticon>", end + 36);
            end = sb.indexOf("</emoticon>", start);
        }
        return sb.toString();
    }

    public static String checkGeneralAddress(String text) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<address");
        int end = sb.indexOf("</address>", start);
        while (start != -1 && end != -1) {
            int startAddressee = sb.indexOf("\">", start) + 2;
            sb = sb.insert(startAddressee, "<b><font color=\"#FF0000\">");
            sb = sb.insert(end + 25, "</font></b>");
            start = sb.indexOf("<address", end + 35);
            end = sb.indexOf("</address>", start);
        }
        return sb.toString();
    }

    public static String checkGeneralNickname(String text) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<nickname");
        int end = sb.indexOf("</nickname>", start);
        while (start != -1 && end != -1) {
            int startNickname = sb.indexOf(">", start) + 1;
            sb = sb.insert(startNickname, "<b><font color=\"#FF0000\">");
            sb = sb.insert(end + 25, "</font></b>");
            start = sb.indexOf("<nickname", end + 36);
            end = sb.indexOf("</nickname>", start);
        }
        return sb.toString();
    }

    static boolean checkImage(String text) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<img src=");
        int end = sb.indexOf("/>", start);
        if (start != -1 && end != -1) {
            return sb.indexOf("type=\"emoticon\"") != -1;
        }
        return false;
    }

    public static String checkSpecificAddress(String text, String specificAddressee) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<address");
        int end = sb.indexOf("</address>", start);
        while (start != -1 && end != -1) {
            int endAddresseeBf;
            int startAddresseeBf = sb.indexOf("addressee=\"", start) + 11;
            String addresseeBf = sb.substring(startAddresseeBf, endAddresseeBf = sb.indexOf("\">", startAddresseeBf));
            if (addresseeBf.equalsIgnoreCase(specificAddressee)) {
                sb = sb.insert(startAddresseeBf + addresseeBf.length() + 2, "<b><font color=\"#FF0000\">");
                sb = sb.insert(end + 25, "</font></b>");
            }
            start = sb.indexOf("<address", end + 35);
            end = sb.indexOf("</address>", start);
        }
        return sb.toString();
    }

    public static String checkSpecificNickname(String text, String specificNickname) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf("<nickname");
        int end = sb.indexOf("</nickname>", start) + 11;
        while (start != -1 && end != -1) {
            StringBuffer nn = new StringBuffer(sb.substring(start, end));
            if (nn.indexOf("nickname baseform=") != -1) {
                int startNicknameBf = nn.indexOf("baseform=\"") + 10;
                int endNicknameBf = nn.indexOf("\">", startNicknameBf);
                int endNicknameTag = nn.indexOf("</nickname", startNicknameBf);
                String nicknameBf = nn.substring(startNicknameBf, endNicknameBf);
                if (nicknameBf.equalsIgnoreCase(specificNickname)) {
                    nn = nn.insert(startNicknameBf + nicknameBf.length() + 2, "<b><font color=\"#FF0000\">");
                    nn = nn.insert(endNicknameTag + 25, "</font></b>");
                    sb = sb.replace(start, end, nn.toString());
                }
            } else {
                int startNickname = 10;
                int endNickname = nn.indexOf("</nickname>");
                String nickname = nn.substring(startNickname, endNickname);
                if (nickname.equalsIgnoreCase(specificNickname)) {
                    nn = nn.insert(startNickname, "<b><font color=\"#FF0000\">");
                    nn = nn.insert(endNickname + 25, "</font></b>");
                    sb = sb.replace(start, end, nn.toString());
                    start = sb.indexOf("<nickname", end + 35);
                    end = sb.indexOf("</nickname>", start) + 11;
                }
            }
            start = sb.indexOf("<nickname", end);
            end = sb.indexOf("</nickname>", start) + 11;
        }
        return sb.toString();
    }

    static String convertFloat(float f) {
        String floatToString = Float.toString(f);
        floatToString = floatToString.replaceAll("\\.", ",");
        return floatToString;
    }

    public static void createChatterProfile() {
        try {
            String path = new File(filePath).getPath();
            FileFinder ff = new FileFinder(filePath);
        }
        catch (NullPointerException e1) {
            JOptionPane.showMessageDialog(null, "Ihre Suchanfrage kann erst bearbeitet werden, nachdem Sie einen Input-Ordner (Korpusteil) ausgew\u00e4hlt haben, \u00fcber den die Suche ausgef\u00fchrt werden soll. W\u00e4hlen Sie einen zu durchsuchenden Ordner und starten Sie Ihre Suche erneut.", "Eingabefehler!", 0);
        }
        Vector files = ff.getVector();
        ff.print();
        BufferedWriter bw = null;
        String output = outputPath + "\\" + outputFileName + ".html";
        try {
            bw = new BufferedWriter(new FileWriter(output));
            bw.write("<html>");
            bw.newLine();
            bw.write("<head/>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.newLine();
            bw.write("<font size=+1><b>Durchsuchter Korpusteil:</b></font> " + filePath + "<p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Nickname</b></td>");
            bw.newLine();
            bw.write("<td><b>est. Gender</b></td>");
            bw.newLine();
            bw.write("<td><b>NOM</b></td>");
            bw.newLine();
            bw.write("<td><b>NOT</b></td>");
            bw.newLine();
            bw.write("<td><b>NOC</b></td>");
            bw.newLine();
            bw.write("<td><b>&Oslash;-L&auml;nge Message</b></td>");
            bw.newLine();
            bw.write("<td><b>% Messages</b></td>");
            bw.newLine();
            bw.write("<td><b>% Tokens</b></td>");
            bw.newLine();
            bw.write("<td><b>% Characters</b></td>");
            bw.newLine();
            bw.write("<td><b>L&auml;nge/&Oslash;-Chatter</b></td>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        totalNumberOfFiles = files.size();
        Vector<String> chatterList = new Vector<String>(10000);
        HashMap<String, String> chatterGenders = new HashMap<String, String>();
        HashMap<String, Integer> chatterNOMs = new HashMap<String, Integer>();
        HashMap<String, Integer> chatterNOTs = new HashMap<String, Integer>();
        HashMap<String, Integer> chatterNOCs = new HashMap<String, Integer>();
        int TNOMtotal = 0;
        int TNOTtotal = 0;
        int TNOCtotal = 0;
        int NOMserverTotal = 0;
        int NOTserverTotal = 0;
        boolean NOCserverTotal = false;
        int NOM = 0;
        int NOMold = 0;
        int NOMnew = 0;
        int NOT = 0;
        int NOTold = 0;
        int NOTnew = 0;
        String currentLine = null;
        String currentNickname = null;
        String currentGender = null;
        int index = -1;
        int TNOMstart = -1;
        int TNOTstart = -1;
        int TNOM = 0;
        int TNOT = 0;
        int NOMserverStart = -1;
        int NOTserverStart = -1;
        int NOTserverEnd = -1;
        int NOMserver = 0;
        int NOTserver = 0;
        int i = 0;
        while (i < files.size()) {
            String substring;
            if (isCancelled) break;
            currentFile = i + 1;
            String logfile = "";
            String fileLocation = files.elementAt(i).toString();
            fileName = fileLocation.substring(fileLocation.lastIndexOf("\\") + 1, fileLocation.length());
            System.out.println("Durchsuche Datei: " + fileName);
            SearchGUI.currentFileName = fileName;
            try {
                logfile = SearchTheCorpus.readFile(fileLocation);
            }
            catch (FileNotFoundException e3) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            catch (IOException e4) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            TNOMstart = logfile.indexOf("TNOM");
            if (TNOMstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            TNOM = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOM=\"", "\""));
            TNOMtotal += TNOM;
            TNOTstart = logfile.indexOf("TNOT");
            if (TNOTstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            TNOT = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOT=\"", "\""));
            TNOTtotal += TNOT;
            NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM");
            NOMserver = NOMserverStart == -1 ? 0 : Integer.parseInt(SearchTheCorpus.parse(logfile, "estimatedGender=\"system\" NOM=\"", "\""));
            NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOMserverStart + 28);
            while (NOMserverStart != -1) {
                int NOMserverNew = Integer.parseInt(SearchTheCorpus.parse(logfile.substring(NOMserverStart), "estimatedGender=\"system\" NOM=\"", "\""));
                NOMserver += NOMserverNew;
                NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOMserverStart + 28);
            }
            NOMserverTotal += NOMserver;
            NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM");
            if (NOTserverStart == -1) {
                NOTserver = 0;
            } else {
                NOTserverEnd = logfile.indexOf("/>", NOTserverStart);
                substring = logfile.substring(NOTserverStart, NOTserverEnd);
                NOTserver = Integer.parseInt(SearchTheCorpus.parse(substring, "NOT=\"", "\""));
            }
            NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOTserverStart + 28);
            while (NOTserverStart != -1) {
                NOTserverEnd = logfile.indexOf("/>", NOTserverStart);
                substring = logfile.substring(NOTserverStart, NOTserverEnd);
                int NOTserverNew = Integer.parseInt(SearchTheCorpus.parse(substring, "NOT=\"", "\""));
                NOTserver += NOTserverNew;
                NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOTserverStart + 28);
            }
            NOTserverTotal += NOTserver;
            String[] chatterArray = logfile.split("creator name=\"");
            int b = 1;
            while (b < chatterArray.length) {
                currentLine = chatterArray[b];
                currentNickname = SearchTheCorpus.parse(currentLine, "", "\" estimatedGender");
                currentGender = SearchTheCorpus.parse(currentLine, "estimatedGender=\"", "\" NOM");
                NOM = Integer.parseInt(SearchTheCorpus.parse(currentLine, "NOM=\"", "\" NOT"));
                NOT = Integer.parseInt(SearchTheCorpus.parse(currentLine, "NOT=\"", "\""));
                if (!currentGender.endsWith("system")) {
                    if (chatterList.contains(currentNickname)) {
                        index = chatterList.indexOf(currentNickname);
                        NOMold = (Integer)chatterNOMs.get(currentNickname);
                        NOMnew = NOMold + NOM;
                        NOMold = (Integer)chatterNOMs.get(currentNickname);
                        NOMnew = NOMold + NOM;
                        chatterNOMs.put(currentNickname, new Integer(NOMnew));
                        NOTold = (Integer)chatterNOTs.get(currentNickname);
                        NOTnew = NOTold + NOT;
                        chatterNOTs.put(currentNickname, new Integer(NOTnew));
                        String genderOld = chatterGenders.get(currentNickname).toString();
                        if (genderOld == "unknown" && currentGender != "unknown") {
                            chatterGenders.put(currentNickname, currentGender);
                        }
                    } else {
                        chatterList.add(currentNickname);
                        chatterGenders.put(currentNickname, currentGender);
                        chatterNOMs.put(currentNickname, new Integer(NOM));
                        chatterNOTs.put(currentNickname, new Integer(NOT));
                    }
                }
                ++b;
            }
            int NOC = 0;
            int NOCold = 0;
            int NOCnew = 0;
            String currentMessage = null;
            String currentText = null;
            String tag = null;
            int j = 0;
            while (j < TNOM) {
                currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + (j + 1) + "\"", "</message>");
                currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                currentText = currentText.replaceAll("\t", "");
                currentText = currentText.replaceAll("\r", "");
                currentText = currentText.replaceAll("\n", "");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</nickname>");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</address>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<asteriskExpression>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</asteriskExpression>");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<img", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<img", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "<roomname>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</roomname>");
                NOC = currentText.length();
                TNOCtotal += NOC;
                if (chatterNOCs.containsKey(currentNickname)) {
                    NOCold = (Integer)chatterNOCs.get(currentNickname);
                    NOCnew = NOCold + NOC;
                    chatterNOCs.put(currentNickname, new Integer(NOCnew));
                } else {
                    chatterNOCs.put(currentNickname, new Integer(NOC));
                }
                ++j;
            }
            ++i;
        }
        try {
            float TNOMfloat = TNOMtotal;
            float TNOTfloat = TNOTtotal;
            float TNOCfloat = TNOCtotal;
            float NOMserverFloat = NOMserverTotal;
            float NOTserverFloat = NOTserverTotal;
            float NOCserverFloat = (float)NOCserverTotal;
            int c = 0;
            while (c < chatterList.size()) {
                String currentName = chatterList.get(c).toString();
                bw.write("<tr><td>" + currentName + "</td>");
                bw.newLine();
                bw.write("<td>" + chatterGenders.get(currentName) + "</td>");
                bw.newLine();
                bw.write("<td>" + chatterNOMs.get(currentName) + "</td>");
                bw.newLine();
                bw.write("<td>" + chatterNOTs.get(currentName) + "</td>");
                bw.newLine();
                bw.write("<td>" + chatterNOCs.get(currentName) + "</td>");
                bw.newLine();
                float NOTfloat = ((Integer)chatterNOTs.get(currentName)).floatValue();
                float NOMfloat = ((Integer)chatterNOMs.get(currentName)).floatValue();
                bw.write("<td>" + SearchTheCorpus.convertFloat(NOTfloat / NOMfloat) + "</td>");
                bw.newLine();
                bw.write("<td>" + SearchTheCorpus.convertFloat(NOMfloat / (TNOMfloat - NOMserverFloat) * 100.0f) + "</td>");
                bw.newLine();
                bw.write("<td>" + SearchTheCorpus.convertFloat(NOTfloat / (TNOTfloat - NOTserverFloat) * 100.0f) + "</td>");
                bw.newLine();
                float NOCfloat = ((Integer)chatterNOCs.get(currentName)).floatValue();
                if (chatterNOCs.containsKey("system")) {
                    NOCserverFloat = ((Integer)chatterNOCs.get("system")).floatValue();
                }
                bw.write("<td>" + SearchTheCorpus.convertFloat(NOCfloat / (TNOCfloat - NOCserverFloat) * 100.0f) + "</td>");
                bw.newLine();
                bw.write("<td>" + SearchTheCorpus.convertFloat(NOTfloat / NOMfloat / ((TNOTfloat - NOTserverFloat) / (TNOMfloat - NOMserverFloat)) * 100.0f) + "</td>");
                bw.newLine();
                ++c;
            }
            bw.write("<tr><td><b>Durchschnitt:</b></td>");
            bw.newLine();
            bw.write("<td><br></td>");
            bw.newLine();
            bw.write("<td><b>" + SearchTheCorpus.convertFloat((TNOMfloat - NOMserverFloat) / (float)chatterList.size()) + "</b></td>");
            bw.newLine();
            bw.write("<td><b>" + SearchTheCorpus.convertFloat((TNOTfloat - NOTserverFloat) / (float)chatterList.size()) + "</b></td>");
            bw.newLine();
            bw.write("<td><b>" + SearchTheCorpus.convertFloat((TNOCfloat - NOCserverFloat) / (float)chatterList.size()) + "</b></td>");
            bw.newLine();
            bw.write("<td><b>" + SearchTheCorpus.convertFloat((TNOTfloat - NOTserverFloat) / (TNOMfloat - NOMserverFloat)) + "</b></td>");
            bw.newLine();
            bw.write("<td><br></td>");
            bw.newLine();
            bw.write("<td><br></td>");
            bw.newLine();
            bw.write("<td><br></td>");
            bw.newLine();
            bw.write("<td><br></td>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        try {
            ff.getVector().clear();
            bw.write("</table><p>");
            bw.newLine();
            bw.newLine();
            bw.write("<b>Legende:</b><br><font size=-1>");
            bw.write("<b>est. Gender:</b> das Geschlecht, das sich (falls m\u00f6glich) auf Grundlage des Nicknames f\u00fcr den Chatter vermuten l\u00e4sst. M\u00f6gliche Geschlechter sind &quot;male&quot;, &quot;female&quot; und &quot;unknown&quot;.<br>");
            bw.newLine();
            bw.write("<b>NOM:</b> die <i>Number of Messages</i>, d. h. die Anzahl der Messages, die dieser Chatter produziert hat.<br>");
            bw.newLine();
            bw.write("<b>NOT:</b> die <i>Number of Tokens</i>, d. h. die Anzahl der laufenden Wortformen, die dieser Chatter produziert hat.<br>");
            bw.newLine();
            bw.write("<b>NOC:</b> die <i>Number of Characters</i>, d. h. die Anzahl der Anschl\u00e4ge, die dieser Chatter produziert hat.<br>");
            bw.newLine();
            bw.write("<b>&Oslash;-L\u00e4nge Message:</b> Die Anzahl der Tokens dieses Chatters geteilt durch seine Messages.<br>");
            bw.newLine();
            bw.write("<b>% Messages:</b> Gibt an, wie viel Prozent aller Messages im gew\u00e4hlten Ordner von diesem Chatter stammen.<br>");
            bw.newLine();
            bw.write("<b>% Tokens:</b> Gibt an, wie viel Prozent aller Tokens im gew\u00e4hlten Ordner von diesem Chatter stammen.<br>");
            bw.newLine();
            bw.write("<b>% Characters:</b> Gibt an, wie viel Prozent aller Zeichen im gew\u00e4hlten Ordner von diesem Chatter stammen.<br>");
            bw.newLine();
            bw.write("<b>L&auml;nge/&Oslash;-Chatter:</b> Diese Zahl zeigt die Durchschnittsl\u00e4nge der Messages eines Chatters im Verh\u00e4ltnis zur allgemeinen Durchschnittsl\u00e4nge der Messages in Prozent. Je n\u00e4her dieser Wert an 100 liegt, desto &quot;durchschnittlicher&quot; lang waren die Messages eines Chatters.<br>");
            bw.newLine();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
        }
        searchDone = true;
        int j = JOptionPane.showConfirmDialog(null, "Alle Logfiles wurden durchsucht! M\u00f6chten Sie die Ergebnisdatei \u00f6ffnen?", "Fertig!", 1);
        if (j == 0) {
            BrowserControl.displayURL(output);
        }
    }

    public static void createLogfileProfile() {
        try {
            String path = new File(filePath).getPath();
            FileFinder ff = new FileFinder(filePath);
        }
        catch (NullPointerException e1) {
            JOptionPane.showMessageDialog(null, "Ihre Suchanfrage kann erst bearbeitet werden, nachdem Sie einen Input-Ordner (Korpusteil) ausgew\u00e4hlt haben, \u00fcber den die Suche ausgef\u00fchrt werden soll. W\u00e4hlen Sie einen zu durchsuchenden Ordner und starten Sie Ihre Suche erneut.", "Eingabefehler!", 0);
        }
        Vector files = ff.getVector();
        ff.print();
        BufferedWriter bw = null;
        String output = outputPath + "\\" + outputFileName + ".html";
        try {
            bw = new BufferedWriter(new FileWriter(output));
            bw.write("<html>");
            bw.newLine();
            bw.write("<head/>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.newLine();
            bw.write("<font size=+1><b>Durchsuchter Korpusteil:</b></font> " + filePath + "<p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Dateiname</b></td>");
            bw.newLine();
            bw.write("<td><b>TNOM</b></td>");
            bw.newLine();
            bw.write("<td><b>NOM Human</b></td>");
            bw.newLine();
            bw.write("<td><b>TNOT</b></td>");
            bw.newLine();
            bw.write("<td><b>NOT Human</b></td>");
            bw.newLine();
            bw.write("<td><b>TNOC</b></td>");
            bw.newLine();
            bw.write("<td><b>NOC Human</b></td>");
            bw.newLine();
            bw.write("<td><b>&Oslash;-L&auml;nge Message</b></td>");
            bw.newLine();
            bw.write("<td><b># Em.</b></td>");
            bw.newLine();
            bw.write("<td><b>Messages/Em.</b></td>");
            bw.newLine();
            bw.write("<td><b># AstEx.</b></td>");
            bw.newLine();
            bw.write("<td><b>Messages/AstEx.</b></td></tr>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        totalNumberOfFiles = files.size();
        int NOMserverTotal = 0;
        int NOTserverTotal = 0;
        int TNOMstart = -1;
        int TNOTstart = -1;
        int TNOM = 0;
        int TNOT = 0;
        int NOMserverStart = -1;
        int NOTserverStart = -1;
        int NOTserverEnd = -1;
        int NOMserver = 0;
        int NOTserver = 0;
        int i = 0;
        while (i < files.size()) {
            String substring;
            if (isCancelled) break;
            currentFile = i + 1;
            String logfile = "";
            String fileLocation = files.elementAt(i).toString();
            fileName = fileLocation.substring(fileLocation.lastIndexOf("\\") + 1, fileLocation.length());
            System.out.println("Durchsuche Datei: " + fileName);
            SearchGUI.currentFileName = fileName;
            try {
                logfile = SearchTheCorpus.readFile(fileLocation);
            }
            catch (FileNotFoundException e3) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            catch (IOException e4) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            TNOMstart = logfile.indexOf("TNOM");
            if (TNOMstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            TNOM = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOM=\"", "\""));
            TNOTstart = logfile.indexOf("TNOT");
            if (TNOTstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            TNOT = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOT=\"", "\""));
            NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM");
            NOMserver = NOMserverStart == -1 ? 0 : Integer.parseInt(SearchTheCorpus.parse(logfile, "estimatedGender=\"system\" NOM=\"", "\""));
            NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOMserverStart + 28);
            while (NOMserverStart != -1) {
                int NOMserverNew = Integer.parseInt(SearchTheCorpus.parse(logfile.substring(NOMserverStart), "estimatedGender=\"system\" NOM=\"", "\""));
                NOMserver += NOMserverNew;
                NOMserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOMserverStart + 28);
            }
            NOMserverTotal += NOMserver;
            NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM");
            if (NOTserverStart == -1) {
                NOTserver = 0;
            } else {
                NOTserverEnd = logfile.indexOf("/>", NOTserverStart);
                substring = logfile.substring(NOTserverStart, NOTserverEnd);
                NOTserver = Integer.parseInt(SearchTheCorpus.parse(substring, "NOT=\"", "\""));
            }
            NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOTserverStart + 28);
            while (NOTserverStart != -1) {
                NOTserverEnd = logfile.indexOf("/>", NOTserverStart);
                substring = logfile.substring(NOTserverStart, NOTserverEnd);
                int NOTserverNew = Integer.parseInt(SearchTheCorpus.parse(substring, "NOT=\"", "\""));
                NOTserver += NOTserverNew;
                NOTserverStart = logfile.indexOf("estimatedGender=\"system\" NOM", NOTserverStart + 28);
            }
            NOTserverTotal += NOTserver;
            int TNOC = 0;
            int NOCserver = 0;
            int j = 0;
            while (j < TNOM) {
                String currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + (j + 1) + "\"", "</message>");
                String currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                String currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                currentText = currentText.replaceAll("\t", "");
                currentText = currentText.replaceAll("\r", "");
                currentText = currentText.replaceAll("\n", "");
                String tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</nickname>");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</address>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<asteriskExpression>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</asteriskExpression>");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<img", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<img", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "<roomname>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</roomname>");
                int NOC = currentText.length();
                TNOC += NOC;
                if (currentNickname.endsWith("system")) {
                    NOCserver += NOC;
                }
                ++j;
            }
            System.out.println("TNOC: " + TNOC);
            System.out.println("NOCserver: " + NOCserver);
            String[] emoticons = logfile.split("<emoticon>");
            String[] imageEmoticons = logfile.split("type=\"emoticon\"");
            int emCount = emoticons.length + imageEmoticons.length - 2;
            String[] asteriskExpressions = logfile.split("<asteriskExpression>");
            int astExCount = asteriskExpressions.length - 1;
            try {
                bw.write("<tr><td>" + fileName + "</td>");
                bw.newLine();
                bw.write("<td>" + TNOM + "</td>");
                bw.newLine();
                bw.write("<td>" + (TNOM - NOMserver) + "</td>");
                bw.newLine();
                bw.write("<td>" + TNOT + "</td>");
                bw.newLine();
                bw.write("<td>" + (TNOT - NOTserver) + "</td>");
                bw.newLine();
                bw.write("<td>" + TNOC + "</td>");
                bw.newLine();
                bw.write("<td>" + (TNOC - NOCserver) + "</td>");
                bw.newLine();
                bw.write("<td>" + SearchTheCorpus.convertFloat((float)(TNOT - NOTserver) / (float)(TNOM - NOMserver)) + "</td>");
                bw.newLine();
                bw.write("<td>" + emCount + "</td>");
                bw.newLine();
                float quotientEm = (float)TNOM / (float)emCount;
                if (emCount == 0) {
                    bw.write("<td>0.</td>");
                } else {
                    bw.write("<td>" + SearchTheCorpus.convertFloat(quotientEm) + "</td>");
                }
                bw.newLine();
                bw.write("<td>" + astExCount + "</td>");
                bw.newLine();
                float quotientAstEx = (float)TNOM / (float)astExCount;
                if (astExCount == 0) {
                    bw.write("<td>0</td></tr>");
                } else {
                    bw.write("<td>" + SearchTheCorpus.convertFloat(quotientAstEx) + "</td></tr>");
                }
                bw.newLine();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
                System.exit(0);
            }
            ++i;
        }
        try {
            ff.getVector().clear();
            bw.write("</table><p>");
            bw.newLine();
            bw.newLine();
            bw.write("<b>Legende:</b><br><font size=-1>");
            bw.write("<b>TNOM:</b> Die Total Number of Messages, d. h. die Gesamtzahl aller Messages in diesem Logfile.<br>");
            bw.newLine();
            bw.write("<b>NOM Human:</b> Anzahl der von Menschen erzeugten Messages (d. h. ohne Systemmeldungen).<br>");
            bw.newLine();
            bw.write("<b>TNOT:</b> Die Total Number of Tokens, d. h. die Gesamtzahl aller Tokens in diesem Logfile.<br>");
            bw.newLine();
            bw.write("<b>NOT Human:</b> Anzahl der von Menschen erzeugten Tokens (d. h. ohne Systemmeldungen).<br>");
            bw.newLine();
            bw.write("<b>TNOC:</b> Die Total Number of Characters, d. h. die Gesamtzahl aller Zeichen in diesem Logfile.<br>");
            bw.newLine();
            bw.write("<b>NOC Human:</b> Anzahl der von Menschen erzeugten Zeichen (d. h. ohne Systemmeldungen).<br>");
            bw.newLine();
            bw.write("<b>&Oslash;-L\u00e4nge Message:</b> Die Anzahl aller Tokens geteilt durch die Anzahl aller Messages. Hierbei werden die servergenerierten Messages und Tokens herausgerechnet.<br>");
            bw.newLine();
            bw.write("<b># Em.:</b> Die Anzahl aller in diesem Logfile vorkommenden Emoticons.<br>");
            bw.newLine();
            bw.write("<b>Messages/Em.:</b> Gibt an, alle wie viel Messages durchschnittlich ein Emoticon vorkommt.<br>");
            bw.newLine();
            bw.write("<b># AstEx.:</b> Die Anzahl aller in diesem Logfile vorkommenden AsteriskExpressions.<br>");
            bw.newLine();
            bw.write("<b>Messages/AstEx.:</b> Gibt an, alle wie viel Messages durchschnittlich eine AsteriskExpression vorkommt.<br>");
            bw.newLine();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
        }
        searchDone = true;
        int j = JOptionPane.showConfirmDialog(null, "Alle Logfiles wurden durchsucht! M\u00f6chten Sie die Ergebnisdatei \u00f6ffnen?", "Fertig!", 1);
        if (j == 0) {
            BrowserControl.displayURL(output);
        }
    }

    static String deleteAll(String text, String del) {
        StringBuffer sb = new StringBuffer(text);
        int start = sb.indexOf(del);
        int end = start + del.length();
        while (start != -1 && end != -1) {
            sb = sb.replace(start, end, "");
            start = sb.indexOf(del);
            end = start + del.length();
        }
        int startSpace = sb.indexOf("  ");
        int endSpace = startSpace + 2;
        while (startSpace != -1 && endSpace != -1) {
            sb = sb.replace(startSpace, endSpace, " ");
            startSpace = sb.indexOf("  ");
            endSpace = startSpace + 2;
        }
        return sb.toString();
    }

    public static void doExtendedSearch() {
        int j;
        try {
            String path = new File(filePath).getPath();
            FileFinder ff = new FileFinder(filePath);
        }
        catch (NullPointerException e1) {
            JOptionPane.showMessageDialog(null, "Ihre Suchanfrage kann erst bearbeitet werden, nachdem Sie einen Input-Ordner (Korpusteil) ausgew\u00e4hlt haben, \u00fcber den die Suche ausgef\u00fchrt werden soll. W\u00e4hlen Sie einen zu durchsuchenden Ordner und starten Sie Ihre Suche erneut.", "Eingabefehler!", 0);
        }
        try {
            Pattern pGesamt = Pattern.compile(searchStringInput);
            String[] patterns = searchStringInput.split("AND");
            int a = 0;
            while (a < patterns.length) {
                String sEinzeln = patterns[a];
                Pattern pEinzeln = Pattern.compile(sEinzeln);
                ++a;
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt mindestens einen Fehler.\nFalls Sie nach einem der Zeichen & | * + $ \" ( ) [ ] { } ^ \\ suchen m\u00f6chten, denken Sie daran, vor diese das Zeichen \\ zu setzen.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("&") || searchStringInput.equals("|") || searchStringInput.equals("&&") || searchStringInput.equals("||") || searchStringInput.equals("&&&") || searchStringInput.equals("|||")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nDie Operatoren & und | ben\u00f6tigen mindestens zwei Argumente.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("\"") || searchStringInput.equals("\"\"")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nDas Zeichen \" stellt eine Wortgrenze dar und kann nicht alleine stehen.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("/") || searchStringInput.equals("\\/")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nUm nach dem Zeichen / zu suchen, setzen Sie bitte davor und danach je ein Anf\u00fchrungszeichen: \"/\"", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        Vector files = ff.getVector();
        ff.print();
        BufferedWriter bw = null;
        String output = outputPath + "\\" + outputFileName + ".html";
        try {
            bw = new BufferedWriter(new FileWriter(output));
            bw.write("<html>");
            bw.newLine();
            bw.write("<head/>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.newLine();
            bw.write("<font size=+2><b>Suchkriterien:</b></font><p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Zu durchsuchender Korpusteil:</b></td>");
            bw.newLine();
            bw.write("<td>" + filePath + "</td></tr>");
            bw.newLine();
            bw.write("<tr><td><b>Suchstring:</b></td>");
            bw.newLine();
            if (searchStringInput.equals("")) {
                bw.write("<td><br></td></tr>");
            } else {
                bw.write("<td>" + searchStringInput + "</td></tr>");
            }
            bw.newLine();
            bw.write("<tr><td><b>Spezielle Elemente:</b></td>");
            bw.newLine();
            bw.write("<td>");
            boolean isEmpty = true;
            if (mustHaveNickname && mustHaveGeneralNickname) {
                bw.write("Nickname allgemein<br>");
                isEmpty = false;
            }
            if (mustHaveNickname && mustHaveSpecificNickname) {
                bw.write("Nickname speziell: " + specificNickname + "<br>");
                isEmpty = false;
            }
            if (mustHaveEmoticon) {
                bw.write("Emoticon<br>");
                isEmpty = false;
            }
            if (mustHaveAsteriskExpression) {
                bw.write("AsteriskExpression<br>");
                isEmpty = false;
            }
            if (mustHaveAddress && mustHaveGeneralAddress) {
                bw.write("Adressierung allgemein<br>");
                isEmpty = false;
            }
            if (mustHaveAddress && mustHaveSpecificAddress) {
                bw.write("Adressierung speziell an: " + specificAddressee + "<br>");
                isEmpty = false;
            }
            if (isEmpty) {
                bw.write("<br></td></tr>");
            } else {
                bw.write("</td></tr>");
            }
            bw.newLine();
            bw.write("<tr><td><b>Zeige nur Messages vom Typ:</b></td>");
            bw.newLine();
            bw.write("<td>");
            isEmpty = true;
            if (showSystem) {
                bw.write("System<br>");
                isEmpty = false;
            }
            if (showAction) {
                bw.write("Action<br>");
                isEmpty = false;
            }
            if (showActionScript) {
                bw.write("Action_Script<br>");
                isEmpty = false;
            }
            if (showUtterance) {
                bw.write("Utterance<br>");
                isEmpty = false;
            }
            if (showUtteranceScript) {
                bw.write("Utterance_Script<br>");
                isEmpty = false;
            }
            if (showBot) {
                bw.write("Bot<br>");
                isEmpty = false;
            }
            if (isEmpty) {
                bw.write("<br></td></tr>");
            } else {
                bw.write("</td></tr>");
            }
            bw.newLine();
            if (showNickname) {
                bw.write("<tr><td><b>Zeige nur Messages vom Benutzer:</b></td>");
                bw.newLine();
                bw.write("<td>" + showOnlyNicknameUser + "</td></tr>");
            }
            bw.newLine();
            bw.write("<tr><td><b>Message Kontext:</b></td>");
            bw.newLine();
            bw.write("<td>" + messageContext + "</td></tr>");
            bw.write("</table><p><hr><p>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        totalNumberOfFiles = files.size();
        int i = 0;
        while (i < files.size()) {
            if (isCancelled) break;
            currentFile = i + 1;
            String logfile = "";
            String fileLocation = files.elementAt(i).toString();
            String fileFolder = fileLocation.substring(0, fileLocation.lastIndexOf("\\") + 1);
            fileName = fileLocation.substring(fileLocation.lastIndexOf("\\") + 1, fileLocation.length());
            int plauderIndex = fileFolder.indexOf("Plauder");
            int profIndex = fileFolder.indexOf("Professionelle");
            String relativeFileFolder = null;
            relativeFileFolder = plauderIndex != -1 ? fileFolder.substring(plauderIndex) : (profIndex != -1 ? fileFolder.substring(profIndex) : fileFolder);
            relativeFileFolder = relativeFileFolder.replaceAll("\\\\", " / ");
            System.out.println("Durchsuche Datei: " + fileName);
            SearchGUI.currentFileName = fileName;
            try {
                logfile = SearchTheCorpus.readFile(fileLocation);
            }
            catch (FileNotFoundException e3) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            catch (IOException e4) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            int TNOMstart = logfile.indexOf("TNOM");
            if (TNOMstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            int TNOM = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOM=\"", "\""));
            Vector<String> timestamps = new Vector<String>(TNOM);
            Vector<String> nicknames = new Vector<String>(TNOM);
            Vector<String> modes = new Vector<String>(TNOM);
            Vector<String> texts = new Vector<String>(TNOM);
            Vector<String> types = new Vector<String>(TNOM);
            timestamps.add(0, "");
            nicknames.add(0, "");
            modes.add(0, "");
            texts.add(0, "");
            types.add(0, "");
            int startIndex = -1;
            int endIndex = -1;
            int id = 1;
            while (id <= TNOM) {
                block89: {
                    String tag;
                    String currentTextCopy;
                    String currentType;
                    String currentMode;
                    String currentText;
                    String currentNickname;
                    String currentTimestamp;
                    String currentMessage;
                    block95: {
                        String copy;
                        block94: {
                            block93: {
                                block92: {
                                    block91: {
                                        block90: {
                                            currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + id + "\"", "</message>");
                                            currentMessage = currentMessage.replaceAll("\t", " ");
                                            currentMessage = currentMessage.replaceAll("\n", " ");
                                            currentMessage = currentMessage.replaceAll("\r", " ");
                                            currentTimestamp = SearchTheCorpus.parse(currentMessage, "<timestamp>", "</timestamp>");
                                            currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                                            currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                                            currentMode = SearchTheCorpus.parse(currentMessage, "<mode>", "</mode>");
                                            currentType = SearchTheCorpus.parse(currentMessage, "type=\"", "\" ");
                                            while (currentMessage.indexOf("  ") != -1) {
                                                currentMessage = currentMessage.replaceAll("  ", " ");
                                            }
                                            while (currentMessage.startsWith(" ")) {
                                                currentMessage = currentMessage.substring(1);
                                            }
                                            while (currentText.startsWith(" ")) {
                                                currentText = currentText.substring(1);
                                            }
                                            while (currentTimestamp.startsWith(" ")) {
                                                currentTimestamp = currentTimestamp.substring(1);
                                            }
                                            while (currentMode.startsWith(" ")) {
                                                currentMode = currentMode.substring(1);
                                            }
                                            while (currentNickname.startsWith(" ")) {
                                                currentNickname = currentNickname.substring(1);
                                            }
                                            while (currentType.startsWith(" ")) {
                                                currentType = currentType.substring(1);
                                            }
                                            StringBuffer sb = new StringBuffer(currentText);
                                            int imagePosition = currentText.indexOf("<img src=", 0);
                                            while (imagePosition != -1) {
                                                sb = sb.insert(imagePosition + 10, "Grafiken/");
                                                currentText = sb.toString();
                                                imagePosition = currentText.indexOf("<img src=", imagePosition + 20);
                                            }
                                            currentTextCopy = currentText;
                                            tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<nickname", ">");
                                            while (tag != "") {
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                                tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<nickname", ">");
                                            }
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</nickname>");
                                            tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<address", ">");
                                            while (tag != "") {
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                                tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<address", ">");
                                            }
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</address>");
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "<emoticon>");
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</emoticon>");
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "<asteriskExpression>");
                                            currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</asteriskExpression>");
                                            timestamps.add(id, currentTimestamp);
                                            nicknames.add(id, currentNickname);
                                            modes.add(id, currentMode);
                                            texts.add(id, currentTextCopy);
                                            types.add(id, currentType);
                                            if (!(showSystem && currentType.equals("system") || showAction && currentType.equals("action") || showUtterance && currentType.equals("utterance") || showActionScript && currentType.equals("action_script") || showUtteranceScript && currentType.equals("utterance_script")) && (!showBot || !currentType.equals("bot")) || (!showNickname || !currentNickname.equalsIgnoreCase(showOnlyNicknameUser)) && showNickname) break block89;
                                            if (!mustHaveNickname || !mustHaveGeneralNickname) break block90;
                                            copy = currentText;
                                            if ((currentText = SearchTheCorpus.checkGeneralNickname(currentText)).equalsIgnoreCase(copy)) break block89;
                                        }
                                        if (!mustHaveNickname || !mustHaveSpecificNickname || specificNickname == "") break block91;
                                        copy = currentText;
                                        if ((currentText = SearchTheCorpus.checkSpecificNickname(currentText, specificNickname)).equalsIgnoreCase(copy)) break block89;
                                    }
                                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                                    while (tag != "") {
                                        currentText = SearchTheCorpus.deleteAll(currentText, tag);
                                        tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                                    }
                                    currentText = SearchTheCorpus.deleteAll(currentText, "</nickname>");
                                    if (!mustHaveAddress || !mustHaveGeneralAddress) break block92;
                                    copy = currentText;
                                    if ((currentText = SearchTheCorpus.checkGeneralAddress(currentText)).equalsIgnoreCase(copy)) break block89;
                                }
                                if (!mustHaveAddress || !mustHaveSpecificAddress || specificAddressee == "") break block93;
                                copy = currentText;
                                if ((currentText = SearchTheCorpus.checkSpecificAddress(currentText, specificAddressee)).equalsIgnoreCase(copy)) break block89;
                            }
                            tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                            while (tag != "") {
                                currentText = SearchTheCorpus.deleteAll(currentText, tag);
                                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                            }
                            currentText = SearchTheCorpus.deleteAll(currentText, "</address>");
                            if (!mustHaveEmoticon) break block94;
                            copy = currentText;
                            if ((currentText = SearchTheCorpus.checkEmoticon(currentText)).equalsIgnoreCase(copy) && !SearchTheCorpus.checkImage(currentText)) break block89;
                        }
                        currentText = SearchTheCorpus.deleteAll(currentText, "<emoticon>");
                        currentText = SearchTheCorpus.deleteAll(currentText, "</emoticon>");
                        if (!mustHaveAsteriskExpression) break block95;
                        copy = currentText;
                        if ((currentText = SearchTheCorpus.checkAsteriskExpression(currentText)).equalsIgnoreCase(copy)) break block89;
                    }
                    currentText = SearchTheCorpus.deleteAll(currentText, "<asteriskExpression>");
                    currentText = SearchTheCorpus.deleteAll(currentText, "</asteriskExpression>");
                    searchStringModified = searchStringInput;
                    searchStringModified = searchStringModified.replaceAll("\\\\\\$", "mask_DOLLAR");
                    searchStringModified = searchStringModified.replaceAll("\\\\\\*", "mask_STERN");
                    searchStringModified = searchStringModified.replaceAll("\\\\\\\"", "mask_ANFZ");
                    searchStringModified = searchStringModified.replaceAll("\\*", "");
                    searchStringModified = searchStringModified.replaceAll("\"", "\\\\b");
                    searchStringModified = searchStringModified.replaceAll("\\.", "\\\\.");
                    searchStringModified = searchStringModified.replaceAll("\\$", "\\.");
                    searchStringModified = searchStringModified.replaceAll("mask_DOLLAR", "\\\\\\$");
                    searchStringModified = searchStringModified.replaceAll("mask_STERN", "\\\\\\*");
                    if (!(searchStringModified = searchStringModified.replaceAll("mask_ANFZ", "\\\\\\\"")).equals("")) {
                        String[] ss = searchStringModified.split("AND");
                        boolean foundAllStrings = false;
                        int searchCounter = 0;
                        boolean foundSingleMatch = false;
                        Pattern pSingle = Pattern.compile("");
                        int a = 0;
                        while (a < ss.length) {
                            String currentSearchString = ss[a];
                            pSingle = Pattern.compile(currentSearchString);
                            Matcher mSingle = pSingle.matcher(currentText);
                            foundSingleMatch = mSingle.find();
                            if (!foundSingleMatch) break;
                            ++searchCounter;
                            ++a;
                        }
                        if (searchCounter == ss.length) {
                            foundAllStrings = true;
                        }
                        if (foundAllStrings) {
                            String searchStringCopy = searchStringModified;
                            searchStringCopy = searchStringCopy.replaceAll("AND", "|");
                            Pattern p = Pattern.compile(searchStringCopy);
                            Matcher m = p.matcher(currentText);
                            boolean foundMatch = false;
                            if (m.find() && m.start() != m.end()) {
                                foundMatch = true;
                                while (foundMatch) {
                                    startIndex = m.start();
                                    endIndex = m.end();
                                    StringBuffer currentTextSB = new StringBuffer(currentText);
                                    currentTextSB = currentTextSB.insert(startIndex, "<b><font color=\"#FF0000\">");
                                    currentText = (currentTextSB = currentTextSB.insert(endIndex + 25, "</font></b>")).toString();
                                    m = p.matcher(currentText);
                                    if (m.find(endIndex + 25)) continue;
                                    foundMatch = false;
                                }
                            }
                        }
                    } else {
                        int j2;
                        try {
                            bw.write("<font size=+1>Beleg: <b>Message</b> Nr. " + id + " aus <b>Dokument</b> " + fileName + " im <b>Teilkorpus</b> " + relativeFileFolder + "</font><br>");
                            bw.newLine();
                            bw.write("<table border=\"0\">");
                            bw.newLine();
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, "Die Message Nr. " + id + " der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
                        }
                        if (id - messageContext >= 1) {
                            j2 = id - messageContext;
                            while (j2 < id) {
                                SearchTheCorpus.printMessage(timestamps, nicknames, modes, texts, types, j2, bw);
                                ++j2;
                            }
                        } else {
                            j2 = 1;
                            while (j2 < id) {
                                SearchTheCorpus.printMessage(timestamps, nicknames, modes, texts, types, j2, bw);
                                ++j2;
                            }
                        }
                        SearchTheCorpus.printCurrentMessage(timestamps, nicknames, modes, types, currentText, id, bw);
                        ++numberOfResults;
                        if (id + messageContext <= TNOM) {
                            j2 = id + 1;
                            while (j2 <= id + messageContext) {
                                currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + j2 + "\"", "</message>");
                                currentMessage = currentMessage.replaceAll("\t", " ");
                                currentMessage = currentMessage.replaceAll("\n", " ");
                                currentMessage = currentMessage.replaceAll("\r", " ");
                                currentTimestamp = SearchTheCorpus.parse(currentMessage, "<timestamp>", "</timestamp>");
                                currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                                currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                                currentMode = SearchTheCorpus.parse(currentMessage, "<mode>", "</mode>");
                                currentType = SearchTheCorpus.parse(currentMessage, "type=\"", "\" ");
                                while (currentMessage.indexOf("  ") != -1) {
                                    currentMessage = currentMessage.replaceAll("  ", " ");
                                }
                                while (currentMessage.startsWith(" ")) {
                                    currentMessage = currentMessage.substring(1);
                                }
                                while (currentText.startsWith(" ")) {
                                    currentText = currentText.substring(1);
                                }
                                while (currentTimestamp.startsWith(" ")) {
                                    currentTimestamp = currentTimestamp.substring(1);
                                }
                                while (currentMode.startsWith(" ")) {
                                    currentMode = currentMode.substring(1);
                                }
                                while (currentNickname.startsWith(" ")) {
                                    currentNickname = currentNickname.substring(1);
                                }
                                while (currentType.startsWith(" ")) {
                                    currentType = currentType.substring(1);
                                }
                                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<", ">");
                                currentTextCopy = currentText;
                                while (tag != "") {
                                    currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                    tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<", ">");
                                }
                                timestamps.add(j2, currentTimestamp);
                                nicknames.add(j2, currentNickname);
                                modes.add(j2, currentMode);
                                texts.add(j2, currentTextCopy);
                                types.add(j2, currentType);
                                SearchTheCorpus.printMessage(timestamps, nicknames, modes, texts, types, j2, bw);
                                ++j2;
                            }
                        } else {
                            j2 = id + 1;
                            while (j2 <= TNOM) {
                                currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + j2 + "\"", "</message>");
                                currentMessage = currentMessage.replaceAll("\t", " ");
                                currentMessage = currentMessage.replaceAll("\n", " ");
                                currentMessage = currentMessage.replaceAll("\r", " ");
                                currentTimestamp = SearchTheCorpus.parse(currentMessage, "<timestamp>", "</timestamp>");
                                currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                                currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                                currentMode = SearchTheCorpus.parse(currentMessage, "<mode>", "</mode>");
                                currentType = SearchTheCorpus.parse(currentMessage, "type=\"", "\" ");
                                while (currentMessage.indexOf("  ") != -1) {
                                    currentMessage = currentMessage.replaceAll("  ", " ");
                                }
                                while (currentMessage.startsWith(" ")) {
                                    currentMessage = currentMessage.substring(1);
                                }
                                while (currentText.startsWith(" ")) {
                                    currentText = currentText.substring(1);
                                }
                                while (currentTimestamp.startsWith(" ")) {
                                    currentTimestamp = currentTimestamp.substring(1);
                                }
                                while (currentMode.startsWith(" ")) {
                                    currentMode = currentMode.substring(1);
                                }
                                while (currentNickname.startsWith(" ")) {
                                    currentNickname = currentNickname.substring(1);
                                }
                                while (currentType.startsWith(" ")) {
                                    currentType = currentType.substring(1);
                                }
                                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<", ">");
                                currentTextCopy = currentText;
                                while (tag != "") {
                                    currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                    tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<", ">");
                                }
                                timestamps.add(j2, currentTimestamp);
                                nicknames.add(j2, currentNickname);
                                modes.add(j2, currentMode);
                                texts.add(j2, currentTextCopy);
                                types.add(j2, currentType);
                                SearchTheCorpus.printMessage(timestamps, nicknames, modes, texts, types, j2, bw);
                                ++j2;
                            }
                        }
                        try {
                            bw.write("</table><p>");
                            bw.newLine();
                            bw.write("<hr>");
                            bw.newLine();
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, "Die Message Nr. " + id + " der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
                        }
                    }
                }
                ++id;
            }
            ++i;
        }
        try {
            bw.write("<font size=+2><b>Gesamtzahl der Treffer: " + numberOfResults + "</b></font>");
            bw.newLine();
            ff.getVector().clear();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
        }
        searchDone = true;
        if (numberOfResults == 0 && !error) {
            JOptionPane.showMessageDialog(null, "Die ausgew\u00e4hlten Korpusdokumente wurden durchsucht. Leider wurden keine Treffer gefunden.\nVariieren Sie gegebenenfalls Ihre Suchanfrage und starten Sie Ihre Suche erneut.", "Leider keine Treffer!", 2);
        } else if (numberOfResults != 0 && !error && (j = JOptionPane.showConfirmDialog(null, "Alle Logfiles wurden durchsucht! M\u00f6chten Sie die Ergebnisdatei \u00f6ffnen?", "Fertig!", 1)) == 0) {
            BrowserControl.displayURL(output);
        }
    }

    public static void doSimpleSearch() {
        int j;
        try {
            String path = new File(filePath).getPath();
            FileFinder ff = new FileFinder(filePath);
        }
        catch (NullPointerException e1) {
            JOptionPane.showMessageDialog(null, "Ihre Suchanfrage kann erst bearbeitet werden, nachdem Sie einen Input-Ordner (Korpusteil) ausgew\u00e4hlt haben, \u00fcber den die Suche ausgef\u00fchrt werden soll. W\u00e4hlen Sie einen zu durchsuchenden Ordner und starten Sie Ihre Suche erneut.", "Eingabefehler!", 0);
        }
        try {
            Pattern pGesamt = Pattern.compile(searchStringInput);
            String[] patterns = searchStringInput.split("AND");
            int a = 0;
            while (a < patterns.length) {
                String sEinzeln = patterns[a];
                Pattern pEinzeln = Pattern.compile(sEinzeln);
                ++a;
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt mindestens einen Fehler.\nFalls Sie nach einem der Zeichen & | * + $ \" ( ) [ ] { } ^ \\ suchen m\u00f6chten, denken Sie daran, vor diese das Zeichen \\ zu setzen.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("&") || searchStringInput.equals("|") || searchStringInput.equals("&&") || searchStringInput.equals("||") || searchStringInput.equals("&&&") || searchStringInput.equals("|||")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nDie Operatoren & und | ben\u00f6tigen mindestens zwei Argumente.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("\"") || searchStringInput.equals("\"\"")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nDas Zeichen \" stellt eine Wortgrenze dar und kann nicht alleine stehen.", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        if (searchStringInput.equals("/") || searchStringInput.equals("\\/")) {
            JOptionPane.showMessageDialog(null, "Die Syntax Ihrer Anfrage enth\u00e4lt einen Fehler.\nUm nach dem Zeichen / zu suchen, setzen Sie bitte davor und danach je ein Anf\u00fchrungszeichen: \"/\"", "Fehler!", 0);
            isCancelled = true;
            error = true;
        }
        Vector files = ff.getVector();
        BufferedWriter bw = null;
        String output = outputPath + "\\" + outputFileName + ".html";
        try {
            bw = new BufferedWriter(new FileWriter(output));
            bw.write("<html>");
            bw.newLine();
            bw.write("<head/>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.newLine();
            bw.write("<font size=+2><b>Suchkriterien:</b></font><p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Zu durchsuchender Korpusteil:</b></td>");
            bw.newLine();
            bw.write("<td>" + filePath + "</td></tr>");
            bw.newLine();
            bw.write("<tr><td><b>Suchstring:</b></td>");
            bw.newLine();
            if (searchStringInput.equals("")) {
                bw.write("<td><br></td></tr>");
            } else {
                bw.write("<td>" + searchStringInput + "</td></tr>");
            }
            bw.newLine();
            bw.write("<tr><td><b>Spezielle Elemente:</b></td>");
            bw.newLine();
            bw.write("<td>");
            boolean isEmpty = true;
            if (mustHaveNickname && mustHaveGeneralNickname) {
                bw.write("Nickname allgemein<br>");
                isEmpty = false;
            }
            if (mustHaveNickname && mustHaveSpecificNickname) {
                bw.write("Nickname speziell: " + specificNickname + "<br>");
                isEmpty = false;
            }
            if (mustHaveEmoticon) {
                bw.write("Emoticon<br>");
                isEmpty = false;
            }
            if (mustHaveAsteriskExpression) {
                bw.write("AsteriskExpression<br>");
                isEmpty = false;
            }
            if (mustHaveAddress && mustHaveGeneralAddress) {
                bw.write("Adressierung allgemein<br>");
                isEmpty = false;
            }
            if (mustHaveAddress && mustHaveSpecificAddress) {
                bw.write("Adressierung speziell an: " + specificAddressee + "<br>");
                isEmpty = false;
            }
            if (isEmpty) {
                bw.write("<br></td></tr>");
            } else {
                bw.write("</td></tr>");
            }
            bw.newLine();
            bw.write("<tr><td><b>Zeige nur Messages vom Typ:</b></td>");
            bw.newLine();
            bw.write("<td>");
            isEmpty = true;
            if (showSystem) {
                bw.write("System<br>");
                isEmpty = false;
            }
            if (showAction) {
                bw.write("Action<br>");
                isEmpty = false;
            }
            if (showActionScript) {
                bw.write("Action_Script<br>");
                isEmpty = false;
            }
            if (showUtterance) {
                bw.write("Utterance<br>");
                isEmpty = false;
            }
            if (showUtteranceScript) {
                bw.write("Utterance_Script<br>");
                isEmpty = false;
            }
            if (showBot) {
                bw.write("Bot<br>");
                isEmpty = false;
            }
            if (isEmpty) {
                bw.write("<br></td></tr>");
            } else {
                bw.write("</td></tr>");
            }
            if (showNickname) {
                bw.write("<tr><td><b>Zeige nur Messages vom Benutzer:</b></td>");
                bw.newLine();
                bw.write("<td>" + showOnlyNicknameUser + "</td></tr>");
            }
            bw.newLine();
            bw.write("</table><hr><p>");
            bw.newLine();
            bw.write("<font size=+2><b>Die Treffer verteilen sich wie folgt auf die durchsuchten Logfiles:</b></font><p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Dateiname:</b></td>");
            bw.newLine();
            bw.write("<td><b>Treffer:</b></td></tr>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        totalNumberOfFiles = files.size();
        Vector<String> creatorNames = new Vector<String>();
        Vector<Integer> creatorCounts = new Vector<Integer>();
        Vector<String> fileNames = new Vector<String>();
        Vector<Integer> fileCounts = new Vector<Integer>();
        int i = 0;
        while (i < files.size()) {
            block72: {
                String fileName;
                String logfile;
                block71: {
                    if (isCancelled) break;
                    currentNumberOfResults = 0;
                    currentFile = i + 1;
                    logfile = "";
                    String fileLocation = files.elementAt(i).toString();
                    fileName = fileLocation.substring(fileLocation.lastIndexOf("\\") + 1, fileLocation.length());
                    System.out.println("Durchsuche Datei: " + fileName);
                    SearchGUI.currentFileName = fileName;
                    try {
                        logfile = SearchTheCorpus.readFile(fileLocation);
                    }
                    catch (FileNotFoundException e3) {
                        JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                        System.exit(0);
                    }
                    catch (IOException e4) {
                        JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                        System.exit(0);
                    }
                    int TNOMstart = logfile.indexOf("TNOM");
                    if (TNOMstart != -1) break block71;
                    JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                    ++i;
                    break block72;
                }
                int TNOM = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOM=\"", "\""));
                Vector<String> timestamps = new Vector<String>(TNOM);
                Vector<String> nicknames = new Vector<String>(TNOM);
                Vector<String> modes = new Vector<String>(TNOM);
                Vector<String> texts = new Vector<String>(TNOM);
                Vector<String> types = new Vector<String>(TNOM);
                timestamps.add(0, "");
                nicknames.add(0, "");
                modes.add(0, "");
                texts.add(0, "");
                types.add(0, "");
                int startIndex = -1;
                int endIndex = -1;
                int id = 1;
                while (id <= TNOM) {
                    block73: {
                        String currentText;
                        String currentNickname;
                        block79: {
                            String copy;
                            block78: {
                                String tag;
                                block77: {
                                    block76: {
                                        block75: {
                                            block74: {
                                                String currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + id + "\"", "</message>");
                                                currentMessage = currentMessage.replaceAll("\t", " ");
                                                currentMessage = currentMessage.replaceAll("\n", " ");
                                                currentMessage = currentMessage.replaceAll("\r", " ");
                                                String currentTimestamp = SearchTheCorpus.parse(currentMessage, "<timestamp>", "</timestamp>");
                                                currentNickname = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                                                currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                                                String currentMode = SearchTheCorpus.parse(currentMessage, "<mode>", "</mode>");
                                                String currentType = SearchTheCorpus.parse(currentMessage, "type=\"", "\" ");
                                                while (currentMessage.indexOf("  ") != -1) {
                                                    currentMessage = currentMessage.replaceAll("  ", " ");
                                                }
                                                while (currentMessage.startsWith(" ")) {
                                                    currentMessage = currentMessage.substring(1);
                                                }
                                                while (currentText.startsWith(" ")) {
                                                    currentText = currentText.substring(1);
                                                }
                                                while (currentTimestamp.startsWith(" ")) {
                                                    currentTimestamp = currentTimestamp.substring(1);
                                                }
                                                while (currentMode.startsWith(" ")) {
                                                    currentMode = currentMode.substring(1);
                                                }
                                                while (currentNickname.startsWith(" ")) {
                                                    currentNickname = currentNickname.substring(1);
                                                }
                                                while (currentType.startsWith(" ")) {
                                                    currentType = currentType.substring(1);
                                                }
                                                String currentTextCopy = currentText;
                                                tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<nickname", ">");
                                                while (tag != "") {
                                                    currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                                    tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<nickname", ">");
                                                }
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</nickname>");
                                                tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<address", ">");
                                                while (tag != "") {
                                                    currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, tag);
                                                    tag = SearchTheCorpus.parseWithBoundaries(currentTextCopy, "<address", ">");
                                                }
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</address>");
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "<emoticon>");
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</emoticon>");
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "<asteriskExpression>");
                                                currentTextCopy = SearchTheCorpus.deleteAll(currentTextCopy, "</asteriskExpression>");
                                                timestamps.add(id, currentTimestamp);
                                                nicknames.add(id, currentNickname);
                                                modes.add(id, currentMode);
                                                texts.add(id, currentTextCopy);
                                                types.add(id, currentType);
                                                if (!(showSystem && currentType.equals("system") || showAction && currentType.equals("action") || showUtterance && currentType.equals("utterance") || showActionScript && currentType.equals("action_script") || showUtteranceScript && currentType.equals("utterance_script")) && (!showBot || !currentType.equals("bot")) || (!showNickname || !currentNickname.equalsIgnoreCase(showOnlyNicknameUser)) && showNickname) break block73;
                                                if (!mustHaveNickname || !mustHaveGeneralNickname) break block74;
                                                copy = currentText;
                                                if ((currentText = SearchTheCorpus.checkGeneralNickname(currentText)).equalsIgnoreCase(copy)) break block73;
                                            }
                                            if (!mustHaveNickname || !mustHaveSpecificNickname || specificNickname == "") break block75;
                                            copy = currentText;
                                            if ((currentText = SearchTheCorpus.checkSpecificNickname(currentText, specificNickname)).equalsIgnoreCase(copy)) break block73;
                                        }
                                        tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                                        while (tag != "") {
                                            currentText = SearchTheCorpus.deleteAll(currentText, tag);
                                            tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                                        }
                                        currentText = SearchTheCorpus.deleteAll(currentText, "</nickname>");
                                        if (!mustHaveAddress || !mustHaveGeneralAddress) break block76;
                                        copy = currentText;
                                        if ((currentText = SearchTheCorpus.checkGeneralAddress(currentText)).equalsIgnoreCase(copy)) break block73;
                                    }
                                    if (!mustHaveAddress || !mustHaveSpecificAddress || specificAddressee == "") break block77;
                                    copy = currentText;
                                    if ((currentText = SearchTheCorpus.checkSpecificAddress(currentText, specificAddressee)).equalsIgnoreCase(copy)) break block73;
                                }
                                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                                while (tag != "") {
                                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                                }
                                currentText = SearchTheCorpus.deleteAll(currentText, "</address>");
                                if (!mustHaveEmoticon) break block78;
                                copy = currentText;
                                if ((currentText = SearchTheCorpus.checkEmoticon(currentText)).equalsIgnoreCase(copy) && !SearchTheCorpus.checkImage(currentText)) break block73;
                            }
                            currentText = SearchTheCorpus.deleteAll(currentText, "<emoticon>");
                            currentText = SearchTheCorpus.deleteAll(currentText, "</emoticon>");
                            if (!mustHaveAsteriskExpression) break block79;
                            copy = currentText;
                            if ((currentText = SearchTheCorpus.checkAsteriskExpression(currentText)).equalsIgnoreCase(copy)) break block73;
                        }
                        currentText = SearchTheCorpus.deleteAll(currentText, "<asteriskExpression>");
                        currentText = SearchTheCorpus.deleteAll(currentText, "</asteriskExpression>");
                        searchStringModified = searchStringInput;
                        searchStringModified = searchStringModified.replaceAll("\\\\\\$", "mask_DOLLAR");
                        searchStringModified = searchStringModified.replaceAll("\\\\\\*", "mask_STERN");
                        searchStringModified = searchStringModified.replaceAll("\\\\\\\"", "mask_ANFZ");
                        searchStringModified = searchStringModified.replaceAll("\\*", "");
                        searchStringModified = searchStringModified.replaceAll("\"", "\\\\b");
                        searchStringModified = searchStringModified.replaceAll("\\.", "\\\\.");
                        searchStringModified = searchStringModified.replaceAll("\\$", "\\.");
                        searchStringModified = searchStringModified.replaceAll("mask_DOLLAR", "\\\\\\$");
                        searchStringModified = searchStringModified.replaceAll("mask_STERN", "\\\\\\*");
                        searchStringModified = searchStringModified.replaceAll("mask_ANFZ", "\\\\\\\"");
                        Pattern p = Pattern.compile(searchStringModified);
                        if (!searchStringModified.equals("")) {
                            String[] ss = searchStringModified.split("AND");
                            boolean foundAllStrings = false;
                            int searchCounter = 0;
                            boolean foundSingleMatch = false;
                            Pattern pSingle = Pattern.compile("");
                            int a = 0;
                            while (a < ss.length) {
                                String currentSearchString = ss[a];
                                pSingle = Pattern.compile(currentSearchString);
                                Matcher mSingle = pSingle.matcher(currentText);
                                foundSingleMatch = mSingle.find();
                                if (!foundSingleMatch) break;
                                ++searchCounter;
                                ++a;
                            }
                            if (searchCounter == ss.length) {
                                foundAllStrings = true;
                            }
                            if (foundAllStrings) {
                                String searchStringCopy = searchStringModified;
                                searchStringCopy = searchStringCopy.replaceAll("AND", "|");
                                p = Pattern.compile(searchStringCopy);
                                Matcher m = p.matcher(currentText);
                                boolean foundMatch = false;
                                if (m.find() && m.start() != m.end()) {
                                    foundMatch = true;
                                    while (foundMatch) {
                                        startIndex = m.start();
                                        endIndex = m.end();
                                        System.out.println("start: " + startIndex);
                                        System.out.println("end: " + endIndex);
                                        m = p.matcher(currentText);
                                        if (m.find(endIndex)) continue;
                                        foundMatch = false;
                                    }
                                }
                            }
                        } else {
                            int index = creatorNames.indexOf(currentNickname);
                            if (!creatorNames.contains(currentNickname)) {
                                creatorNames.add(currentNickname);
                                index = creatorNames.indexOf(currentNickname);
                                creatorCounts.add(index, new Integer(0));
                            }
                            int counter = (Integer)creatorCounts.elementAt(index);
                            creatorCounts.set(index, new Integer(++counter));
                            ++numberOfResults;
                            ++currentNumberOfResults;
                        }
                    }
                    ++id;
                }
                fileNames.add(fileName);
                fileCounts.add(new Integer(currentNumberOfResults));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < fileNames.size() - 1) {
            int j2 = 0;
            while (j2 < fileNames.size() - i2 - 1) {
                int firstCount = (Integer)fileCounts.get(j2);
                int secondCount = (Integer)fileCounts.get(j2 + 1);
                String firstName = fileNames.get(j2).toString();
                String secondName = fileNames.get(j2 + 1).toString();
                if (firstCount < secondCount) {
                    fileCounts.set(j2, new Integer(secondCount));
                    fileCounts.set(j2 + 1, new Integer(firstCount));
                    fileNames.set(j2, secondName);
                    fileNames.set(j2 + 1, firstName);
                }
                ++j2;
            }
            ++i2;
        }
        try {
            int v = 0;
            while (v < fileNames.size()) {
                bw.write("<tr><td>" + fileNames.get(v) + "</td>");
                bw.newLine();
                bw.write("<td>" + fileCounts.get(v) + "</td></tr>");
                bw.newLine();
                ++v;
            }
            bw.write("<tr><td><b>Summe</b></td>");
            bw.newLine();
            bw.write("<td><b>" + numberOfResults + "</b></td></tr>");
            bw.newLine();
            bw.write("</table><hr>");
            bw.newLine();
            bw.write("<font size=+2><b>Die gefundenen Messages wurden von folgenden Chattern produziert:</b></font><p>");
            bw.newLine();
            bw.write("<table border=1>");
            bw.newLine();
            bw.write("<tr><td><b>Name:</b></td>");
            bw.newLine();
            bw.write("<td><b>Anzahl:</b></td></tr>");
            bw.newLine();
            int i3 = 0;
            while (i3 < creatorNames.size() - 1) {
                int j3 = 0;
                while (j3 < creatorNames.size() - i3 - 1) {
                    int firstCount = (Integer)creatorCounts.get(j3);
                    int secondCount = (Integer)creatorCounts.get(j3 + 1);
                    String firstName = creatorNames.get(j3).toString();
                    String secondName = creatorNames.get(j3 + 1).toString();
                    if (firstCount < secondCount) {
                        creatorCounts.set(j3, new Integer(secondCount));
                        creatorCounts.set(j3 + 1, new Integer(firstCount));
                        creatorNames.set(j3, secondName);
                        creatorNames.set(j3 + 1, firstName);
                    }
                    ++j3;
                }
                ++i3;
            }
            int summe = 0;
            int v2 = 0;
            while (v2 < creatorNames.size()) {
                bw.write("<tr><td>" + creatorNames.get(v2) + "</td>");
                bw.newLine();
                bw.write("<td>" + creatorCounts.get(v2) + "</td></tr>");
                bw.newLine();
                summe += ((Integer)creatorCounts.get(v2)).intValue();
                ++v2;
            }
            bw.write("<tr><td><b>Summe</b></td>");
            bw.newLine();
            bw.write("<td><b>" + summe + "</b></td></tr>");
            bw.newLine();
            bw.write("</table>");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Die aktuelle Zeile der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
        }
        try {
            ff.getVector().clear();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
        }
        searchDone = true;
        if (numberOfResults == 0 && !error) {
            JOptionPane.showMessageDialog(null, "Die ausgew\u00e4hlten Korpusdokumente wurden durchsucht. Leider wurden keine Treffer gefunden.\nVariieren Sie gegebenenfalls Ihre Suchanfrage und starten Sie Ihre Suche erneut.", "Leider keine Treffer!", 2);
        } else if (numberOfResults != 0 && !error && (j = JOptionPane.showConfirmDialog(null, "Alle Logfiles wurden durchsucht! M\u00f6chten Sie die Ergebnisdatei \u00f6ffnen?", "Fertig!", 1)) == 0) {
            BrowserControl.displayURL(output);
        }
    }

    public static String parse(String file, String s1, String s2) {
        int start = file.indexOf(s1) + s1.length();
        int end = file.indexOf(s2, start);
        if (file.indexOf(s1) == -1 || end == -1) {
            return "";
        }
        return file.substring(start, end);
    }

    public static String parseWithBoundaries(String file, String s1, String s2) {
        int start = file.indexOf(s1);
        int end = file.indexOf(s2, start) + s2.length();
        if (start == -1 || end == -1) {
            return "";
        }
        return file.substring(start, end);
    }

    static void printCurrentMessage(Vector ts, Vector nn, Vector m, Vector typ, String text, int id, BufferedWriter bw) {
        try {
            bw.write("<tr>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            bw.write(id + "<br>");
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (ts.elementAt(id) != "") {
                bw.write("<I>");
                bw.write(ts.elementAt(id).toString());
                bw.write("</I> ");
            } else {
                bw.write("<br>");
            }
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (typ.elementAt(id).toString().equals("utterance") || typ.elementAt(id).toString().equals("system")) {
                if (nn.elementAt(id) != "") {
                    bw.write("<B>");
                    bw.write(nn.elementAt(id).toString());
                    bw.write("</B>");
                }
            } else {
                bw.write("<br>");
            }
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (m.elementAt(id) != "") {
                bw.write(m.elementAt(id).toString());
            } else {
                bw.write("<br>");
            }
            bw.write("</td valign=TOP>");
            bw.newLine();
            bw.write("<td>");
            bw.newLine();
            bw.write("<font color=\"#0000FF\">");
            bw.write(text);
            bw.write("</font><br>");
            bw.newLine();
            bw.write("</td>");
            bw.newLine();
            bw.write("</tr>");
            bw.newLine();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Die Message Nr. " + id + " der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
        }
    }

    static void printMessage(Vector ts, Vector nn, Vector m, Vector tex, Vector typ, int id, BufferedWriter bw) {
        try {
            bw.write("<tr>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            bw.write(id + "<br>");
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (ts.elementAt(id) != "") {
                bw.write("<I>");
                bw.write(ts.elementAt(id).toString());
                bw.write("</I>");
            } else {
                bw.write("<br>");
            }
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (typ.elementAt(id).toString().equals("utterance") || typ.elementAt(id).toString().equals("system")) {
                if (nn.elementAt(id) != "") {
                    bw.write("<B>");
                    bw.write(nn.elementAt(id).toString());
                    bw.write("</B>");
                }
            } else {
                bw.write("<br>");
            }
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            if (m.elementAt(id) != "") {
                bw.write(m.elementAt(id).toString());
            } else {
                bw.write("<br>");
            }
            bw.write("</td>");
            bw.newLine();
            bw.write("<td valign=TOP>");
            bw.newLine();
            bw.write(tex.elementAt(id).toString());
            bw.write("<br>");
            bw.newLine();
            bw.write("</td>");
            bw.newLine();
            bw.write("</tr>");
            bw.newLine();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Die Message Nr. " + id + " der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String readFile(String filePath) throws FileNotFoundException, IOException {
        StringBuffer contentOfFile = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            while ((line = br.readLine()) != null) {
                void var2_4;
                contentOfFile.append((String)var2_4 + "\r");
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return contentOfFile.toString();
    }

    public static void setFilePath(String path) {
        filePath = path;
    }

    public static void setMessageContext(int i) {
        messageContext = i;
    }

    public static void setNumberOfSearchStrings(int i) {
        numberOfSearchStrings = i;
    }

    public static void setOutputFileName(String name) {
        outputFileName = name;
    }

    public static void setOutputPath(String path) {
        outputPath = path;
    }

    public static void setSearchString(String ss) {
        searchStringInput = ss;
    }

    public static void textOutput() {
        try {
            String path = new File(filePath).getPath();
            FileFinder ff = new FileFinder(filePath);
        }
        catch (NullPointerException e1) {
            JOptionPane.showMessageDialog(null, "Ihre Suchanfrage kann erst bearbeitet werden, nachdem Sie einen Input-Ordner (Korpusteil) ausgew\u00e4hlt haben, \u00fcber den die Suche ausgef\u00fchrt werden soll. W\u00e4hlen Sie einen zu durchsuchenden Ordner und starten Sie Ihre Suche erneut.", "Eingabefehler!", 0);
        }
        Vector files = ff.getVector();
        ff.print();
        BufferedWriter bw = null;
        String output = outputPath + "\\" + outputFileName + ".html";
        try {
            bw = new BufferedWriter(new FileWriter(output));
            bw.write("<html>");
            bw.newLine();
            bw.write("<head/>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.newLine();
            bw.write("<b>Zu durchsuchender Korpusteil: </b>" + filePath + "<p>");
            bw.newLine();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            JOptionPane.showMessageDialog(null, "Die Ausgabedatei konnte nicht erstellt werden!", "Fehler!", 0);
            System.exit(0);
        }
        totalNumberOfFiles = files.size();
        int i = 0;
        while (i < files.size()) {
            if (isCancelled) break;
            currentFile = i + 1;
            String logfile = "";
            String fileLocation = files.elementAt(i).toString();
            fileName = fileLocation.substring(fileLocation.lastIndexOf("\\") + 1, fileLocation.length());
            String fileFolder = fileLocation.substring(0, fileLocation.lastIndexOf("\\") + 1);
            fileFolder = "file:///" + fileFolder;
            System.out.println("Durchsuche Datei: " + fileName);
            SearchGUI.currentFileName = fileName;
            try {
                logfile = SearchTheCorpus.readFile(fileLocation);
                bw.write("<font size=+1><b>Dateiname:</b> " + fileName + "</font><br>");
                bw.write("<table>");
            }
            catch (FileNotFoundException e3) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            catch (IOException e4) {
                JOptionPane.showMessageDialog(null, "Das Logfile " + fileName + " kann nicht ge\u00f6ffnet werden!", "Fehler!", 0);
                System.exit(0);
            }
            int TNOMstart = logfile.indexOf("TNOM");
            if (TNOMstart == -1) {
                JOptionPane.showMessageDialog(null, "Die Datei " + fileName + " wurde nicht korrekt annotiert und kann daher nicht durchsucht werden!", "Fehler!", 0);
                ++i;
                break;
            }
            int TNOM = Integer.parseInt(SearchTheCorpus.parse(logfile, "TNOM=\"", "\""));
            int id = 1;
            while (id <= TNOM) {
                String currentMessage = SearchTheCorpus.parseWithBoundaries(logfile, "<message id=\"" + id + "\"", "</message>");
                currentMessage = currentMessage.replaceAll("\t", " ");
                currentMessage = currentMessage.replaceAll("\n", " ");
                currentMessage = currentMessage.replaceAll("\r", " ");
                String currentTimestamp = SearchTheCorpus.parse(currentMessage, "<timestamp>", "</timestamp>");
                String currentCreator = SearchTheCorpus.parse(currentMessage, "creator=\"", "\"");
                String currentText = SearchTheCorpus.parse(currentMessage, "<messageBody>", "</messageBody>");
                String currentMode = SearchTheCorpus.parse(currentMessage, "<mode>", "</mode>");
                String currentType = SearchTheCorpus.parse(currentMessage, "type=\"", "\" ");
                String currentColor = SearchTheCorpus.parse(currentMessage, "color=\"", "\">");
                String messageHead = SearchTheCorpus.parse(currentMessage, "<messageHead>", "</messageHead>");
                String currentNickname = SearchTheCorpus.parse(messageHead, "<nickname>", "</nickname>");
                if (currentColor == "") {
                    currentColor = "black";
                }
                while (currentMessage.indexOf("  ") != -1) {
                    currentMessage = currentMessage.replaceAll("  ", " ");
                }
                while (currentMessage.startsWith(" ")) {
                    currentMessage = currentMessage.substring(1);
                }
                while (currentText.startsWith(" ")) {
                    currentText = currentText.substring(1);
                }
                while (currentTimestamp.startsWith(" ")) {
                    currentTimestamp = currentTimestamp.substring(1);
                }
                while (currentMode.startsWith(" ")) {
                    currentMode = currentMode.substring(1);
                }
                while (currentCreator.startsWith(" ")) {
                    currentCreator = currentCreator.substring(1);
                }
                while (currentNickname.startsWith(" ")) {
                    currentNickname = currentNickname.substring(1);
                }
                while (currentType.startsWith(" ")) {
                    currentType = currentType.substring(1);
                }
                String tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<nickname", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</nickname>");
                tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                while (tag != "") {
                    currentText = SearchTheCorpus.deleteAll(currentText, tag);
                    tag = SearchTheCorpus.parseWithBoundaries(currentText, "<address", ">");
                }
                currentText = SearchTheCorpus.deleteAll(currentText, "</address>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</emoticon>");
                currentText = SearchTheCorpus.deleteAll(currentText, "<asteriskExpression>");
                currentText = SearchTheCorpus.deleteAll(currentText, "</asteriskExpression>");
                StringBuffer sb = new StringBuffer(currentText);
                int imagePosition = currentText.indexOf("<img src=", 0);
                while (imagePosition != -1) {
                    sb = sb.insert(imagePosition + 10, "Grafiken/");
                    currentText = sb.toString();
                    imagePosition = currentText.indexOf("<img src=", imagePosition + 20);
                }
                try {
                    bw.write("<tr>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    bw.write(id + "<br>");
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    if (currentTimestamp != "") {
                        bw.write("<I>");
                        bw.write(currentTimestamp);
                        bw.write("</I>");
                    } else {
                        bw.write("<br>");
                    }
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    bw.write("<font color=\"" + currentColor + "\">");
                    if (currentType.equals("utterance") || currentType.equals("system")) {
                        if (currentCreator != "") {
                            bw.write("<B>");
                            bw.write(currentCreator);
                            bw.write("</B>");
                        }
                    } else {
                        bw.write("<br>");
                    }
                    bw.write("</font>");
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    if (currentNickname != "" && !currentNickname.equals(currentCreator)) {
                        bw.write(currentNickname);
                    } else {
                        bw.write("<br>");
                    }
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    if (currentMode != "") {
                        bw.write("<font color=\"666666\">");
                        bw.write(currentMode);
                        bw.write("</font>");
                    } else {
                        bw.write("<br>");
                    }
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("<td valign=TOP>");
                    bw.newLine();
                    bw.write("<font color=\"" + currentColor + "\">");
                    bw.write(currentText);
                    bw.write("</font>");
                    bw.write("<br>");
                    bw.newLine();
                    bw.write("</td>");
                    bw.newLine();
                    bw.write("</tr>");
                    bw.newLine();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Die Message Nr. " + id + " der Datei " + fileName + " konnte nicht korrekt geschrieben werden!", "Fehler!", 0);
                }
                ++id;
            }
            ++numberOfResults;
            try {
                bw.write("</table><hr>");
                bw.newLine();
                bw.write("<p>");
                bw.newLine();
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
            }
            ++i;
        }
        try {
            ff.getVector().clear();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.flush();
            bw.close();
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, "Die Ergebnisdatei konnte nicht erstellt werden!", "Fehler!", 0);
        }
        searchDone = true;
        if (numberOfResults == 0) {
            JOptionPane.showMessageDialog(null, "Die ausgew\u00e4hlten Korpusdokumente wurden durchsucht. Leider wurden keine Treffer gefunden.\nVariieren Sie gegebenenfalls Ihre Suchanfrage und starten Sie Ihre Suche erneut.", "Leider keine Treffer!", 2);
        } else {
            int j = JOptionPane.showConfirmDialog(null, "Alle Logfiles wurden durchsucht! M\u00f6chten Sie die Ergebnisdatei \u00f6ffnen?", "Fertig!", 1);
            if (j == 0) {
                BrowserControl.displayURL(output);
            }
        }
    }
}

